#if   !defined(__ACCESSRIGHTS_HPP)
#define  __ACCESSRIGHTS_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if !defined IN_COMMON_HPP
   #error AccessRights.hpp is included by Common.hpp only.
#endif

      
namespace corelinux
{
   /**
   Access enumeration for various system level
   classes.
   */

   enum  AccessRights
   {
      /// Owner has read access
      OWNER_READ   = 0400, 
      /// Owner has write access
      OWNER_MODIFY = 0200, 
      /// Owner has read/write access   
      OWNER_ALL    = 0600, 
      /// Group has read access
      GROUP_READ   = 040,
      /// Group has write access
      GROUP_MODIFY = 020,
      /// Group has read/write access
      GROUP_ALL    = 060,
      /// Public has read access
      PUBLIC_READ  = 04,
      /// Public has write access
      PUBLIC_MODIFY= 02,
      /// Public has read/write access
      PUBLIC_ALL   = 06
   };

   /**
   Creation dispositions for various system
   utilities
   */

   enum CreateDisposition
   {
      /// Will create or open

      CREATE_OR_REUSE = 0,

      /// Will throw exception if target exists

      FAIL_IF_EXISTS = -1,

      /// Will throw exception if target does NOT exist

      FAIL_IF_NOTEXISTS = -2
   };

   /**
   Addressings constraints
   */

   enum AddressingConstraint
   {
      /// read write access (no constraints)

      READ_WRITE = 0,

      /// read only access

      READ_ONLY,

      /// Execute access

      EXECUTE
   };

}

#endif

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

