#if   !defined(__SET_HPP)
#define  __SET_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  
// STL includes

#include <set>

namespace corelinux
{
   /**
   STL set template. This macro generates all
   the type references and pointers for the collection and
   respective iterators for a set.
   @param name The name you want to give the collection
   @param key The object that represents the set key
   @param comp The comparator functor
   */
   #define CORELINUX_SET(key,comp,name)                                       \
      typedef set<key, comp > name;                                           \
      typedef name *       name ## Ptr;                                       \
      typedef const name * name ## Cptr;                                      \
      typedef name &       name ## Ref;                                       \
      typedef const name & name ## Cref;                                      \
      typedef name::iterator name ## Iterator;                                \
      typedef name::iterator& name ## IteratorRef;                            \
      typedef name::iterator* name ## IteratorPtr;                            \
      typedef name::const_iterator name ## ConstIterator;                     \
      typedef name::const_iterator& name ## ConstIteratorRef;                 \
      typedef name::const_iterator* name ## ConstIteratorPtr;                 \
      typedef name::reverse_iterator name ## Riterator;                       \
      typedef name::reverse_iterator& name ## RiteratorRef;                   \
      typedef name::reverse_iterator* name ## RiteratorPtr
   
   /**
   STL multiset template. This macro generates all
   the type references and pointers for the collection and
   respective iterators for a multiset.
   @param name The name you want to give the collection
   @param key The object that represents the mutliset key
   @param comp The comparator functor
   */
   #define CORELINUX_MULTISET(key,comp,name)                                  \
      typedef multiset<key, comp > name;                                      \
      typedef name *       name ## Ptr;                                       \
      typedef const name * name ## Cptr;                                      \
      typedef name &       name ## Ref;                                       \
      typedef const name & name ## Cref;                                      \
      typedef name::iterator name ## Iterator;                                \
      typedef name::iterator& name ## IteratorRef;                            \
      typedef name::iterator* name ## IteratorPtr;                            \
      typedef name::const_iterator name ## ConstIterator;                     \
      typedef name::const_iterator& name ## ConstIteratorRef;                 \
      typedef name::const_iterator* name ## ConstIteratorPtr;                 \
      typedef name::reverse_iterator name ## Riterator;                       \
      typedef name::reverse_iterator& name ## RiteratorRef;                   \
      typedef name::reverse_iterator* name ## RiteratorPtr

}


#endif
/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/


