/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__REQUESTHELPHANDLER_HPP)
#include <RequestHelpHandler.hpp>
#endif

#include <iostream>

using namespace corelinux;
using namespace std;

// Default constructor

RequestHelpHandler::RequestHelpHandler( void ) 
   :
   HelpHandler(REQUEST_HELP)
{
   ;  // do nothing
}

// Copy constructor

RequestHelpHandler::RequestHelpHandler( RequestHelpHandlerCref aHandler )
   :
   HelpHandler(aHandler)
{
   ;  // do nothing
}

// Destructor cleans slate

RequestHelpHandler::~RequestHelpHandler( void )
{
   ;  // do nothing
}

// Assignment operator

RequestHelpHandlerRef   RequestHelpHandler::operator=( RequestHelpHandlerCref aHandler )
{
   HelpHandler::operator=( aHandler );
   return  (*this);
}

// Calls topic comparison

bool  RequestHelpHandler::operator==( RequestHelpHandlerCref aHandler ) const
{
   return HelpHandler::operator==( aHandler );
}

// The work I do for the request

void RequestHelpHandler::handle( RequestPtr aRequest )
{
   cout << endl;
   cout << "You have reached the Request Help Handler!" << endl;
   cout << "It is my responsibility to provide help for" << endl;
   cout << "request types" << endl;
   cout << endl;

   HelpRequestPtr(aRequest)->setHandled();
}
/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/



