/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif 

#if   !defined(__FOO_HPP)
#include <Foo.hpp>
#endif

using namespace corelinux;

//
// The minimum and maximum screen coordinates
//

Int   Foo::theMinimumVertical(0);

Int   Foo::theMaximumVertical(5);

Int   Foo::theMinimumHorizontal(0);

Int   Foo::theMaximumHorizontal(5);


//
// Default constructor
//

Foo::Foo( void )
{
   ;  // do nothing
}

//
// Copy constructor
//

Foo::Foo( FooCref )
{
   ;  // do nothing
}

//
// Destructor
//

Foo::~Foo( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

FooRef  Foo::operator =( FooCref )
{
   return (*this);
}

//
// Equality operator
//

bool  Foo::operator ==( FooCref aRef )
{
   return (this == &aRef);
}

//
// Static, gets min Y
//

IntCref  Foo::getMinimumVerticalPosition( void )
{
   return Foo::theMinimumVertical;
}

//
// Static, gets max Y
//

IntCref  Foo::getMaximumVerticalPosition( void )
{
   return Foo::theMaximumVertical;
}

//
// Static, gets min X
//

IntCref  Foo::getMinimumHorizontalPosition( void )
{
   return Foo::theMinimumHorizontal;
}

//
// Static, gets max X
//

IntCref  Foo::getMaximumHorizontalPosition( void )
{
   return Foo::theMaximumHorizontal;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/01/19 14:30:07 $
   $Locker:  $
*/

