#if   !defined(__BANNERCOMPONENT_HPP)
#define  __BANNERCOMPONENT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#include <string>
#include <iostream>

using namespace std;

/**
A BannerComponent is a base component that displays
its Banner. You can must set the banner during construction
but always reset it later.
*/

DECLARE_CLASS(BannerComponent)

class BannerComponent
{
public:

                     /**
                     Default constructor requires a banner
                     @param string const reference
                     */

                     BannerComponent( const string & );

                     /**
                     Copy constructor copies theBanner
                     @param BannerComponent const reference
                     */

                     BannerComponent( BannerComponentCref );

                     /// Virtual destructor

   virtual           ~BannerComponent( void );

                  /**
                  Assignmnet operator copies theBanner
                  @param BannerComponent const reference
                  @return BannerComponent reference (*this)
                  */

            BannerComponentRef   operator=( BannerComponentCref );

                  /**
                  Equality operator 
                  @param BannerComponent const reference
                  @return bool - true if theBanner is same
                  */

            bool  operator==( BannerComponentCref ) const;

   //
   // Accessors
   //
   
                     /**
                     Retrieves the banner
                     */

   virtual  string   getBanner( void ) const;

                     /**
                     drawBanner displays theBanner
                     @param ostream - stream output
                     @param bool true if endl is appended
                     */

   virtual  void     drawBanner
                        ( 
                           ostream &aStream , 
                           bool doEndl=false 
                        ) const;

   //
   // Mutators
   //

                     /// Sets a new banner

            void     setBanner( const string & );

protected:

                     /**
                     Default constructor not allowed.
                     @exception Exception 
                     */

                     BannerComponent( void ) 
                        throw(CORELINUX(Exception));

private:

            string   theBanner;

};

#endif // if !defined(__BANNERCOMPONENT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:21 $
   $Locker:  $
*/

