/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__DICTIONARY_HPP)
#include <Dictionary.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

using namespace corelinux;

//
// Default Constructor
//

Dictionary::Dictionary( void )
{
   ;  // do nothing
}

//
// Copy constructor
//

Dictionary::Dictionary( DictionaryCref aRef )
   :
   theNameMap( aRef.theNameMap )
{
   ;  // do nothing
}

//
// Destructor
//

Dictionary::~Dictionary( void )
{
   theNameMap.clear();
}

//
// Assignment operator
//

DictionaryRef Dictionary::operator=( DictionaryCref aRef )
{
   theNameMap =  aRef.theNameMap;
   return (*this);
}

//
// Equality operator
//

bool Dictionary::operator==( DictionaryCref aRef ) const
{
   return (this == &aRef );
}

//
// Retrieve the identifier associated to the name
//

DwordIdentifier Dictionary::getIdentifierForName( const string &aName ) const
{
   DwordIdentifier aId(0);
   NameMapConstIterator   begin( theNameMap.begin() );
   NameMapConstIterator   end( theNameMap.end() );

   while( begin != end )
   {
      if( (*begin).second == aName )
      {
         aId = (*begin).first;
         begin = end;
      }
      else
      {
         ++begin;
      }
   }

   return aId;
}

//
// Retrieve the name associated to the identifier
//

string Dictionary::getNameForIdentifier( DwordIdentifierCref aId ) const
{

   NameMapConstIterator fItr( theNameMap.find(aId) );
   string               aName("");

   if( fItr != theNameMap.end() )
   {
      aName = (*fItr).second;
   }
   else
   {
      ;  // do nothing 
   }

   return aName;
}

//
// Get the entire map
//

NameMapCref Dictionary::getMap( void ) const
{
   return theNameMap;
}
//
// Add an element to the dictionary map
//

void     Dictionary::addName( const string &aName, DwordIdentifierCref aId )
{
   if( this->getNameForIdentifier( aId ) == "" &&
       this->getIdentifierForName( aName ) == DwordIdentifier(0) )
   {
      theNameMap[aId] = aName;
   }
   else
   {
      ;  // do nothing
   }
}

//
// Change the name of an existing element
//

void     Dictionary::changeName
   ( 
      const string &aOldName, 
      const string &aNewName 
   )
{
   DwordIdentifier  aOldId( this->getIdentifierForName( aOldName ) );

   if( aOldId != DwordIdentifier(0) &&
       this->getIdentifierForName( aNewName ) == DwordIdentifier(0) )
   {
      theNameMap[aOldId] = aNewName;
   }
   else
   {
      ;  // do nothing
   }
}

//
// Change the name given an Id and a new name
//

void     Dictionary::changeName( DwordIdentifierCref aId, const string &aNewName )
{
   if( this->getNameForIdentifier( aId ) != "" &&
       this->getIdentifierForName( aNewName ) == DwordIdentifier(0) )
   {
      theNameMap[aId] = aNewName;
   }
   else
   {
      ;  // do nothing
   }

}

//
// Remove a element given it's name
//

void     Dictionary::removeName( const string &aName )
{
   DwordIdentifier  aId( this->getIdentifierForName( aName ) );

   if( aId != DwordIdentifier(0) )
   {
      theNameMap.erase( theNameMap.find(aId) );
   }
   else
   {
      ;  // do nothing
   }

}

//
// Remove a element given it's identifier
//

void     Dictionary::removeName( DwordIdentifierCref aId )
{
   NameMapIterator   fItr( theNameMap.find(aId) );

   if( fItr != theNameMap.end() )
   {
      theNameMap.erase( fItr );
   }
   else
   {
      ;  // do nothing
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/03/01 03:28:18 $
   $Locker:  $
*/

