#if   !defined(__EVENT_HPP)
#define  __EVENT_HPP

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   /**
   Event provides a type basis for event ontologies
   */

   template < class IdentifierType = Identifier >
      class Event
      {
      public:
         //
         // Constructors and destructor
         //
   
                           /// Default constructor protected
                     
                           Event( void )
                              :
                              theIdentifier( NULLPTR )
                           {
                              ;  // do nothing
                           }
   
                           /// Initializing constructor

                           Event( const IdentifierType & aId )
                              :
                              theIdentifier( new IdentifierType(aId) )
                           {
                              ;  // do nothing
                           }
                           /// Copy constructor
   
                           Event( const Event & aEvent )
                              :
                              theIdentifier( NULLPTR )
                           {
                              if( aEvent.theIdentifier != NULLPTR )
                              {
                                 theIdentifier = new IdentifierType
                                    (
                                       *(aEvent.theIdentifier)
                                    );
                              }
                           }
   
                           /// Virtual destructor
   
         virtual           ~Event( void )
         {
            if( theIdentifier != NULLPTR )
            {
               delete theIdentifier;
               theIdentifier = NULLPTR;
            }
            else
            {
               ;  // do nothing
            }
         }
   
         //
         // Operator overloads
         //
   
                  /// Assignment operator
   
                  Event & operator=( const Event & aEvent )
                  {
                     if( *this == aEvent )
                     {
                        ;  // do nothing
                     }
                     else
                     {
                        if( theIdentifier != NULLPTR )
                        {
                           delete theIdentifier;
                           theIdentifier = NULLPTR;
                        }
                        else
                        {
                           ;  // do nothing
                        }

                        if( aEvent.theIdentifier != NULLPTR )
                        {
                           theIdentifier = new IdentifierType
                              (
                                 *(aEvent.theIdentifier)
                              );
                        }
                        else
                        {
                           ;  // do nothing
                        }
                     }
                     return (*this);
                  }
   
                  /// Equality operator
   
                  bool  operator==( const Event & aEvent ) const
                  {
                     bool isSame( false );

                     if( theIdentifier != NULLPTR &&
                         aEvent.theIdentifier != NULLPTR )
                     {
                        isSame = (*theIdentifier == *(aEvent.theIdentifier) );
                     }
                     else
                     {
                        isSame = ( this == &aEvent );
                     }

                     return isSame;
                  }

                  /// Coercion operator for identity

                        operator const IdentifierType &( void ) const
                           throw ( NullPointerException ) 
                        {
                           if( theIdentifier == NULLPTR )
                           {
                              throw NullPointerException(LOCATION);
                           }
                           else
                           {
                              ;  // do nothing
                           }
                           return ( *theIdentifier );
                        }

                  /// Coercion operator for identity

                        operator IdentifierType *( void ) const
                           throw (NullPointerException) 
                        {
                           if( theIdentifier == NULLPTR )
                           {
                              throw NullPointerException(LOCATION);
                           }
                           else
                           {
                              ;  // do nothing
                           }

                           return theIdentifier;
                        }
   
      protected:
   
   
      private:

               IdentifierType    *theIdentifier;
   
      };

}

#endif // if !defined(__EVENT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:41:47 $
   $Locker:  $
*/


