/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__EDITCOLLEAGUE_HPP)
#include <EditColleague.hpp>
#endif

#if   !defined(__LISTEVENTS_HPP)
#include <ListEvents.hpp>
#endif

#if   !defined(__LISTMEMENTOS_HPP)
#include <ListMementos.hpp>
#endif

#include <iostream>

// Buffer space for cin.getline

static   char     gBuffer[1024];

using namespace corelinux;
using namespace std;

// Constructor

EditColleague::EditColleague( ListMediatorPtr aPtr )
   :
   Colleague( MediatorPtr(aPtr) )
{
   ;  // do nothing
}

// Copy constructor 

EditColleague::EditColleague( EditColleagueCref aColleague )
   :
   Colleague( aColleague )
{
   ;  // do nothing
}

// Destructor

EditColleague::~EditColleague( void )
{
   ;  // do nothing
}

// Assignment

EditColleagueRef  EditColleague::operator=( EditColleagueCref aColleague )
{
   return ( *this );
}

// Equality

bool EditColleague::operator==( EditColleagueCref aColleague ) const
{
   return ( this == &aColleague );
}

// Get the events I generate

void  EditColleague::getEventsGenerated( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &EditedEntry );
}

// Get the events I am interested in

void  EditColleague::getInterestedEvents( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &SelectionMade );
}

// Called when a event comes my way

void  EditColleague::action( Event<Identifier> *aEvent ) 
{
   //
   // We deal with the selection and get the edit
   //

   SelectionMementoRef   aChange = 
      dynamic_cast<SelectionMementoRef>
         (
            dynamic_cast<ListEventPtr>(aEvent)->getMemento()
         );

   string   & originalText( aChange.getSelected() );

   cout << "Enter the change for [" << originalText << "] : ";

   cin.getline( gBuffer, sizeof(gBuffer) );
   
   string   changedText(gBuffer);


   //
   // Then let colleagues know the new Edit 
   //

   ListEvent  aEv( EditedEntry, new EditSelectionMemento( originalText, changedText ) );
   Colleague::invokeMediator( (Event<Identifier>*)&aEv );

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:46:00 $
   $Locker:  $
*/



