/***************************************************************************
                          clistenmanager.h  -  description
                             -------------------
    begin                : Sun Feb 29 2004
    copyright            : (C) 2004-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLISTENMANAGER_H
#define CLISTENMANAGER_H

/**
  *@author Mathias Küster
  *
  * This is for incoming peer connections, which go to
  * CDownloadManager.
  *
  * ConnectionWait was a counter but was not used anywhere
  * and got removed.
  */

#include <dclib/dcos.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/cstring.h>
#include <dclib/core/ccallback.h>

class CListen;

class CListenManagerBase {
public:
	/** */
	unsigned int GetListenPort();
	/** */
	CString GetSocketErrorMsg() { return m_sSocketError; };
	
protected:
	/** */
	CListenManagerBase();
	/** */
	virtual ~CListenManagerBase();
	/** called by CManager, no parameters */
	int ManagerCallback();
	/** called by a CListen with a socket descriptor int */
	int ListenCallback( int fd );
	/** A pure virtual function */
	virtual _CCallback1<int> * CreateListenCallback() = 0;
	
	/** */
	_CCallback0 * m_pCallback;
	/** */
	bool m_bCrypto;

private:
	/** */
	void StartListen();
	
	/** current used port */
	unsigned int m_nListenPort;
	/** socket error message */
	CString m_sSocketError;

	/** */
	CMutex m_Mutex;
	/** */
	CListen * m_pListen;
};

class CListenManager : public CSingleton<CListenManager>, public CListenManagerBase {
public:
	/** */
	CListenManager();
	/** */
	virtual ~CListenManager();

protected:	
	/** */
	virtual _CCallback1<int> * CreateListenCallback();
};

class CCryptoListenManager: public CSingleton<CCryptoListenManager>, public CListenManagerBase {
public:
	/** */
	CCryptoListenManager();
	/** */
	virtual ~CCryptoListenManager();

protected:
	/** */
	virtual _CCallback1<int> * CreateListenCallback();
};

#endif
