/***************************************************************************
                          types.h  -  description
                             -------------------
    begin                : Thu May 08 2003
    copyright            : (C) 2003-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TYPES_H
#define _TYPES_H

/** */
enum eUnit {
	euAUTO=0,
	euBYTE,
	euKBYTE,
	euMBYTE,
	euGBYTE
};

/** transfer medium */
enum eltMedium {
	eltNONE=0,
	eltBUFFER,
	eltTTHL,
	eltFILE,
	eltLIST,
	eltCLIENTVERSION
};

/** direction */
enum eDirection {
	edNONE=0,
	edUPLOAD,
	edDOWNLOAD
};

/** chunk state */
enum eChunkState {
	ecsFREE=0,
	ecsFINISHED,
	ecsLOCKED
};

/** crypt state */
enum eSecureState {
	esecsNONE=0,
	esecsHANDSHAKE,
	esecsENCRYPTED
};

/** socket state */
enum eConnectionState {
	estNONE=0,
	estCONNECT,
	estCONNECTING,
	estCONNECTED,
	estSSLCONNECTED,
	estDISCONNECTING,
	estDISCONNECTED,
	estSOCKETERROR,
	estCONNECTIONTIMEOUT,
	estTRANSFERHANDSHAKE,
	estTRANSFERDOWNLOAD,
	estTRANSFERUPLOAD
};

enum eTransferFileState {
	etfsNONE=0,
	etfsTRANSFER,
	etfsERROR,
	etfsPAUSE
};

enum eTransferWaitState {
	etwsWAIT=0,
	etwsIDLE,
	etwsRUN,
	etwsHUBOFFLINE,
	etwsUSEROFFLINE,
	etwsUSERBUSY,
	etwsSENDERROR
};

enum eClientMode {
	ecmNONE=0,
	ecmACTIVE,
	ecmPASSIVE
};

enum eUserAwayMode {
	euamNONE=0,
	euamNORMAL,
	euamAWAY,
	euamONLINE,
	euamOFFLINE
};

enum eFileTypes {
	eftUNKNOWN=0,
	eftALL,
	eftMP3,
	eftARCHIVE,
	eftDOCUMENT,
	eftAPPLICATION,
	eftPICTURE,
	eftVIDEO,
	eftFOLDER,
	eftHASH
};

/*
 * There is no exact size search type in the NMDC protocol according to DC++
 * which explains why auto search by exact size didn't work properly.
 *
 * Although valknut used to have an exact size option, the protocol did
 * not, a search with no size restriction was done, but only results
 * which by very unlikely chance had the right size would be shown.
 */
enum eSearchSizeType {
	esstATLEAST=0,
	esstATMOST
};

enum eUserSpeed {
	eusUNKNOWN=0,
	eus288KBPS,
	eus336KBPS,
	eus56KBPS,
	eusMODEM,
	eusISDN,
	eusDSL,
	eusSATELLITE,
	eusCABLE,
	eusLANT1,
	eusLANT3,
	eusWIRELESS,
	eusMICROWAVE,
	eus0005,
	eus001,
	eus002,
	eus005,
	eus01,
	eus02,
	eus05,
	eus1,
	eus2,
	eus5,
	eus10,
	eus20,
	eus50,
	eus100,
	eus1000
};

enum eUserClientVersion {
	eucvNONE=0,
	eucvDCPP,
	eucvDCHPP,
	eucvPTOKAX,
	eucvDCGUI,
	eucvZPOC,
	eucvOPENDCD,
	eucvDCTC,
	eucvNMDC,
	eucvQUICKDC,
	eucvOPERADC,
	eucvSDDC,	/* <SdDC++ V:0.121GoddessOfTheDark,M:A,H:2/2/13,S:0/1> */
	eucvSTRGDCPP,	/* <StrgDC++ V:1.00 RC3,M:P,H:1/0/0,S:1> */
	eucvRMDC,	/* <RMDC++ V:0.306E[6],M:A,H:3/0/0,S:3> */
	eucvDCPRO,	/* <DC:PRO V:0.2.3.23,M:A,H:2/0/0,S:4> */
	eucvIDC,	/* <iDC1.072> */
	eucvPERLDC,	/* Leaf's are the best! <PerlDC V:0.2,M:P,H:1,S:1> */
	eucvMICRODC,
	eucvSHAKESPEER,
	eucvUNKNOWN
};

enum eUserCommandType {
	euctSeparator,
	euctRaw,
	euctRawOnce,
	euctRemove,
	euctClear = 255
};

enum eUserCommandContext {
	euccHub = 0x01,
	euccChat = 0x02,
	euccSearch = 0x04,
	euccFilelist = 0x08,
	euccMask = euccHub | euccChat | euccSearch | euccFilelist
};

enum eCloseType {
        ectNONE=0,
	ectBOTH,
	ectDLD,
	ectUPLD
};

enum eShareBufferType {
	esbtNONE=0,
	esbtHE3,
	esbtBZ,
	esbtXMLBZ,
	esbtXML
};

enum eMyInfoStatusFlags {
	emsfNormal = 0x01,
	emsfAway = 0x02,
	emsfServer = 0x04,
	emsfFireball = 0x08,
	emsfTLS = 0x10
};

enum eADCType {
	eAdcFile=0,
	eAdcTTHL,
	eAdcList
};

#endif
