/***************************************************************************
       csharetreefolder.cpp  -  Object for storing a tree of folders
                             -------------------
    begin                : Fri Jul 25 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csharetreefolder.h"

#include "csearchindex.h"
#include "core/cxml.h"

/** */
CShareTreeFolder::CShareTreeFolder( const CString & name, const CShareTreeFolder * parent ) :
m_sName(name),
m_pParent(parent),
m_pFolderList(0),
m_pFileList(0)
{
	// all done in initialisation section
	// which is necessary due to the excessive const use
}

/** */
CShareTreeFolder::~CShareTreeFolder()
{
	if ( m_pFolderList )
	{
		for ( std::list<CShareTreeFolder*>::const_iterator it = m_pFolderList->begin(); it != m_pFolderList->end(); ++it )
		{
			delete (*it);
		}
		m_pFolderList->clear();
		delete m_pFolderList;
		m_pFolderList = 0;
	}
	
	delete m_pFileList;
	m_pFileList = 0;
}

/** */
const CString & CShareTreeFolder::GetName() const
{
	return m_sName;
}

/** */
const CShareTreeFolder * CShareTreeFolder::GetParent() const
{
	return m_pParent;
}

/** */
std::list<CShareTreeFolder*> * CShareTreeFolder::GetChildren() const
{
	if ( m_pFolderList )
	{
		std::list<CShareTreeFolder*> * newlist = new std::list<CShareTreeFolder*>();
		(*newlist) = (*m_pFolderList);
		return newlist;
	}
	else
	{
		return 0;
	}
}

/** */
CShareTreeFolder * CShareTreeFolder::AddFolder( const CString & name )
{
	CShareTreeFolder * newfolder = new CShareTreeFolder( name, this );
	
	if ( m_pFolderList == 0 )
	{
		m_pFolderList = new std::list<CShareTreeFolder*>();
	}
	
	m_pFolderList->push_back(newfolder);
	
	return newfolder;
}

/** */
std::list<unsigned long int> * CShareTreeFolder::GetFiles() const
{
	if ( m_pFileList )
	{
		std::list<unsigned long int> * newlist = new std::list<unsigned long int>();
		(*newlist) = (*m_pFileList);
		return newlist;
	}
	else
	{
		return 0;
	}
}

/** */
void CShareTreeFolder::AddFile( const unsigned long int fbi )
{
	if ( m_pFileList == 0 )
	{
		m_pFileList = new std::list<unsigned long int>();
	}
	
	m_pFileList->push_back(fbi);
}

/** */
CString CShareTreeFolder::GetXML( int depth, CSearchIndex * si ) const
{
	CString result;
	CXml cxml;
	
	if ( m_pFolderList )
	{
		for ( std::list<CShareTreeFolder*>::const_iterator it = m_pFolderList->begin(); it != m_pFolderList->end(); ++it )
		{
			result += "<Directory Name=\"";
			result += cxml.ToUTF8( (*it)->GetName() );
			
			if ( depth == 0 )
			{
				result += "\" Incomplete=\"1\"/>\n";
			}
			else
			{
				result += "\">\n";
				result += (*it)->GetXML( depth - 1, si );
				result += "</Directory>\n";
			}
		}
	}
	
	if ( m_pFileList )
	{
		struct filebaseobject fbo;
		for ( std::list<unsigned long int>::const_iterator it = m_pFileList->begin(); it != m_pFileList->end(); ++it )
		{
			if ( si->GetFileBaseObject((*it),&fbo) )
			{
				result += "<File Name=\"";
				result += cxml.ToUTF8( si->GetFileName( (*it) ) );
				result += "\" Size=\"";
				result += CString::number( fbo.m_nSize );
				
				if ( fbo.m_nHashIndex != (unsigned long int)-1 )
				{
					result += "\" TTH=\"";
					result += si->GetHash(fbo.m_nHashIndex);
				}
				
				result += "\"/>\n";
			}
		}
	}
	
	return result;
}
