/***************************************************************************
        case-fold.cpp  -  Test the case folder works (in UTF-8 locale)
                             -------------------
    begin                : Thu Sep 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/ccasefolder.h>

#include <stdio.h>

int main( int, char*[] )
{
	/* without CConfig CCaseFolder uses UTF-8 */
	CCaseFolder folder;
	
	/* a few vowels from what gucharmap calls the Latin-1 Supplement */
	CString input1 = "aBCDEF ÁÉÌÓÙ áéìóù UVWXYz";
	CString input2 = "Abcdef áéìóù áéìóù uvwxyZ";
	CString output1;
	CString output2;
	
	if ( folder.Fold( input1, output1 ) )
	{
		if ( folder.Fold( input2, output2 ) )
		{
			if ( output1 == output2 )
			{
				return 0;
			}
			else
			{
				printf("case-fold: input1='%s' output1='%s'\n", input1.Data(), output1.Data());
				printf("case-fold: input2='%s' output2='%s'\n", input2.Data(), output2.Data());
				return 3;
			}
		}
		else
		{
			printf("case-fold: folding 2 failed, iconv problem?\n");
			return 2;
		}
	}
	else
	{
		printf("case-fold: folding 1 failed, iconv problem?\n");
		return 1;
	}
}
