/* commandqueue.c generated by valac 0.16.1, the Vala compiler
 * generated from commandqueue.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <fsobasics.h>
#include <gobject/gvaluecollector.h>


#define FSO_FRAMEWORK_TYPE_COMMAND_QUEUE (fso_framework_command_queue_get_type ())
#define FSO_FRAMEWORK_COMMAND_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_COMMAND_QUEUE, FsoFrameworkCommandQueue))
#define FSO_FRAMEWORK_IS_COMMAND_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_COMMAND_QUEUE))
#define FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_COMMAND_QUEUE, FsoFrameworkCommandQueueIface))

typedef struct _FsoFrameworkCommandQueue FsoFrameworkCommandQueue;
typedef struct _FsoFrameworkCommandQueueIface FsoFrameworkCommandQueueIface;

#define FSO_FRAMEWORK_TYPE_TRANSPORT (fso_framework_transport_get_type ())
#define FSO_FRAMEWORK_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransport))
#define FSO_FRAMEWORK_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))
#define FSO_FRAMEWORK_IS_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_IS_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))

typedef struct _FsoFrameworkTransport FsoFrameworkTransport;
typedef struct _FsoFrameworkTransportClass FsoFrameworkTransportClass;

#define FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER (fso_framework_abstract_command_handler_get_type ())
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER, FsoFrameworkAbstractCommandHandler))
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER, FsoFrameworkAbstractCommandHandlerClass))
#define FSO_FRAMEWORK_IS_ABSTRACT_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER))
#define FSO_FRAMEWORK_IS_ABSTRACT_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER))
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER, FsoFrameworkAbstractCommandHandlerClass))

typedef struct _FsoFrameworkAbstractCommandHandler FsoFrameworkAbstractCommandHandler;
typedef struct _FsoFrameworkAbstractCommandHandlerClass FsoFrameworkAbstractCommandHandlerClass;
typedef struct _FsoFrameworkAbstractCommandHandlerPrivate FsoFrameworkAbstractCommandHandlerPrivate;
typedef struct _FsoFrameworkParamSpecAbstractCommandHandler FsoFrameworkParamSpecAbstractCommandHandler;

#define FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE (fso_framework_abstract_command_queue_get_type ())
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, FsoFrameworkAbstractCommandQueue))
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, FsoFrameworkAbstractCommandQueueClass))
#define FSO_FRAMEWORK_IS_ABSTRACT_COMMAND_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE))
#define FSO_FRAMEWORK_IS_ABSTRACT_COMMAND_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE))
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, FsoFrameworkAbstractCommandQueueClass))

typedef struct _FsoFrameworkAbstractCommandQueue FsoFrameworkAbstractCommandQueue;
typedef struct _FsoFrameworkAbstractCommandQueueClass FsoFrameworkAbstractCommandQueueClass;
typedef struct _FsoFrameworkAbstractCommandQueuePrivate FsoFrameworkAbstractCommandQueuePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fso_framework_abstract_command_handler_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_abstract_command_handler_unref (var), NULL)))
typedef struct _FsoFrameworkTransportPrivate FsoFrameworkTransportPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FsoFrameworkAbstractCommandQueueOpenData FsoFrameworkAbstractCommandQueueOpenData;
typedef struct _FsoFrameworkAbstractCommandQueueFreezeData FsoFrameworkAbstractCommandQueueFreezeData;
typedef struct _FsoFrameworkAbstractCommandQueueThawData FsoFrameworkAbstractCommandQueueThawData;
typedef struct _FsoFrameworkAbstractCommandQueueCloseData FsoFrameworkAbstractCommandQueueCloseData;

typedef void (*FsoFrameworkCommandQueueUnsolicitedHandler) (const gchar* prefix, const gchar* response, const gchar* pdu, void* user_data);
struct _FsoFrameworkCommandQueueIface {
	GTypeInterface parent_iface;
	void (*open) (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*open_finish) (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
	void (*close) (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*close_finish) (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
	void (*registerUnsolicitedHandler) (FsoFrameworkCommandQueue* self, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target);
	void (*freeze) (FsoFrameworkCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*freeze_finish) (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
	void (*thaw) (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*thaw_finish) (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
	FsoFrameworkTransport* (*get_transport) (FsoFrameworkCommandQueue* self);
	void (*set_transport) (FsoFrameworkCommandQueue* self, FsoFrameworkTransport* value);
};

struct _FsoFrameworkAbstractCommandHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoFrameworkAbstractCommandHandlerPrivate * priv;
	guint timeout;
	guint retry;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _FsoFrameworkAbstractCommandHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (FsoFrameworkAbstractCommandHandler *self);
	void (*writeToTransport) (FsoFrameworkAbstractCommandHandler* self, FsoFrameworkTransport* t);
	gchar* (*to_string) (FsoFrameworkAbstractCommandHandler* self);
};

struct _FsoFrameworkParamSpecAbstractCommandHandler {
	GParamSpec parent_instance;
};

struct _FsoFrameworkAbstractCommandQueue {
	GObject parent_instance;
	FsoFrameworkAbstractCommandQueuePrivate * priv;
	FsoFrameworkCommandQueueUnsolicitedHandler urchandler;
	gpointer urchandler_target;
	GDestroyNotify urchandler_target_destroy_notify;
	FsoFrameworkAbstractCommandHandler* current;
};

struct _FsoFrameworkAbstractCommandQueueClass {
	GObjectClass parent_class;
	void (*onReadFromTransport) (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkTransport* t);
	void (*onResponseTimeout) (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* ach);
	void (*open) (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*open_finish) (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
	void (*freeze) (FsoFrameworkAbstractCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*freeze_finish) (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
	void (*thaw) (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*thaw_finish) (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
	void (*close) (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*close_finish) (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
};

struct _FsoFrameworkAbstractCommandQueuePrivate {
	FsoFrameworkTransport* _transport;
	GeeLinkedList* q;
	guint timeoutWatch;
};

typedef void (*FsoFrameworkTransportFunc) (FsoFrameworkTransport* transport, void* user_data);
struct _FsoFrameworkTransport {
	GObject parent_instance;
	FsoFrameworkTransportPrivate * priv;
	FsoFrameworkLogger* logger;
};

struct _FsoFrameworkTransportClass {
	GObjectClass parent_class;
	gboolean (*isOpen) (FsoFrameworkTransport* self);
	void (*openAsync) (FsoFrameworkTransport* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*openAsync_finish) (FsoFrameworkTransport* self, GAsyncResult* _res_);
	gboolean (*open) (FsoFrameworkTransport* self);
	void (*close) (FsoFrameworkTransport* self);
	gchar* (*getName) (FsoFrameworkTransport* self);
	void (*setDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
	void (*getDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify);
	void (*setPriorities) (FsoFrameworkTransport* self, gint rp, gint wp);
	void (*setBuffered) (FsoFrameworkTransport* self, gboolean on);
	gint (*writeAndRead) (FsoFrameworkTransport* self, void* wdata, gint wlength, void* rdata, gint rlength, gint maxWait);
	gint (*read) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*write) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*freeze) (FsoFrameworkTransport* self);
	void (*thaw) (FsoFrameworkTransport* self);
	void (*drain) (FsoFrameworkTransport* self);
	void (*flush) (FsoFrameworkTransport* self);
	gboolean (*suspend) (FsoFrameworkTransport* self);
	void (*resume) (FsoFrameworkTransport* self);
};

struct _FsoFrameworkAbstractCommandQueueOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkAbstractCommandQueue* self;
	gboolean result;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	gboolean _tmp2_;
	FsoFrameworkTransport* _tmp3_;
	FsoFrameworkTransport* _tmp4_;
	gboolean _tmp5_;
	gboolean opened;
};

struct _FsoFrameworkAbstractCommandQueueFreezeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkAbstractCommandQueue* self;
	gboolean drain;
};

struct _FsoFrameworkAbstractCommandQueueThawData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkAbstractCommandQueue* self;
};

struct _FsoFrameworkAbstractCommandQueueCloseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkAbstractCommandQueue* self;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
};


static gpointer fso_framework_abstract_command_handler_parent_class = NULL;
static gpointer fso_framework_abstract_command_queue_parent_class = NULL;
static FsoFrameworkCommandQueueIface* fso_framework_abstract_command_queue_fso_framework_command_queue_parent_iface = NULL;

GType fso_framework_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_command_queue_get_type (void) G_GNUC_CONST;
void fso_framework_command_queue_open (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean fso_framework_command_queue_open_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
void fso_framework_command_queue_close (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_command_queue_close_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
void fso_framework_command_queue_registerUnsolicitedHandler (FsoFrameworkCommandQueue* self, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target);
void fso_framework_command_queue_freeze (FsoFrameworkCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_command_queue_freeze_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
void fso_framework_command_queue_thaw (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_command_queue_thaw_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_);
FsoFrameworkTransport* fso_framework_command_queue_get_transport (FsoFrameworkCommandQueue* self);
void fso_framework_command_queue_set_transport (FsoFrameworkCommandQueue* self, FsoFrameworkTransport* value);
gpointer fso_framework_abstract_command_handler_ref (gpointer instance);
void fso_framework_abstract_command_handler_unref (gpointer instance);
GParamSpec* fso_framework_param_spec_abstract_command_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_framework_value_set_abstract_command_handler (GValue* value, gpointer v_object);
void fso_framework_value_take_abstract_command_handler (GValue* value, gpointer v_object);
gpointer fso_framework_value_get_abstract_command_handler (const GValue* value);
GType fso_framework_abstract_command_handler_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_DUMMY_PROPERTY
};
void fso_framework_abstract_command_handler_writeToTransport (FsoFrameworkAbstractCommandHandler* self, FsoFrameworkTransport* t);
static void fso_framework_abstract_command_handler_real_writeToTransport (FsoFrameworkAbstractCommandHandler* self, FsoFrameworkTransport* t);
gchar* fso_framework_abstract_command_handler_to_string (FsoFrameworkAbstractCommandHandler* self);
static gchar* fso_framework_abstract_command_handler_real_to_string (FsoFrameworkAbstractCommandHandler* self);
FsoFrameworkAbstractCommandHandler* fso_framework_abstract_command_handler_construct (GType object_type);
static void fso_framework_abstract_command_handler_finalize (FsoFrameworkAbstractCommandHandler* obj);
GType fso_framework_abstract_command_queue_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, FsoFrameworkAbstractCommandQueuePrivate))
enum  {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_DUMMY_PROPERTY,
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_TRANSPORT
};
void fso_framework_abstract_command_queue_onReadFromTransport (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkTransport* t);
static void fso_framework_abstract_command_queue_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkTransport* t);
gboolean fso_framework_abstract_command_queue_checkRestartingQ (FsoFrameworkAbstractCommandQueue* self);
void fso_framework_abstract_command_queue_writeNextCommand (FsoFrameworkAbstractCommandQueue* self);
gboolean fso_framework_abstract_command_queue_onTimeout (FsoFrameworkAbstractCommandQueue* self);
static gboolean _fso_framework_abstract_command_queue_onTimeout_gsource_func (gpointer self);
void fso_framework_abstract_command_queue_resetTimeout (FsoFrameworkAbstractCommandQueue* self);
void fso_framework_abstract_command_queue_onHupFromTransport (FsoFrameworkAbstractCommandQueue* self);
void fso_framework_abstract_command_queue_onResponseTimeout (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* ach);
static void fso_framework_abstract_command_queue_real_onResponseTimeout (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* ach);
void fso_framework_abstract_command_queue_enqueueCommand (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* command);
static gboolean _fso_framework_abstract_command_queue_checkRestartingQ_gsource_func (gpointer self);
void fso_framework_abstract_command_queue_reset (FsoFrameworkAbstractCommandQueue* self);
gboolean fso_framework_abstract_command_queue_is_busy (FsoFrameworkAbstractCommandQueue* self);
FsoFrameworkAbstractCommandQueue* fso_framework_abstract_command_queue_construct (GType object_type, FsoFrameworkTransport* transport);
void fso_framework_transport_setDelegates (FsoFrameworkTransport* self, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
static void _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
static void _fso_framework_abstract_command_queue_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
static void fso_framework_abstract_command_queue_real_registerUnsolicitedHandler (FsoFrameworkCommandQueue* base, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target);
static void fso_framework_abstract_command_queue_real_open_data_free (gpointer _data);
static void fso_framework_abstract_command_queue_real_open (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_open (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean fso_framework_abstract_command_queue_open_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
static gboolean fso_framework_abstract_command_queue_real_open_co (FsoFrameworkAbstractCommandQueueOpenData* _data_);
gboolean fso_framework_transport_isOpen (FsoFrameworkTransport* self);
void fso_framework_transport_openAsync (FsoFrameworkTransport* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean fso_framework_transport_openAsync_finish (FsoFrameworkTransport* self, GAsyncResult* _res_);
static void fso_framework_abstract_command_queue_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void fso_framework_abstract_command_queue_real_freeze_data_free (gpointer _data);
static void fso_framework_abstract_command_queue_real_freeze (FsoFrameworkAbstractCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_freeze (FsoFrameworkAbstractCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_freeze_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
static gboolean fso_framework_abstract_command_queue_real_freeze_co (FsoFrameworkAbstractCommandQueueFreezeData* _data_);
static void fso_framework_abstract_command_queue_real_thaw_data_free (gpointer _data);
static void fso_framework_abstract_command_queue_real_thaw (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_thaw (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_thaw_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
static gboolean fso_framework_abstract_command_queue_real_thaw_co (FsoFrameworkAbstractCommandQueueThawData* _data_);
static void fso_framework_abstract_command_queue_real_close_data_free (gpointer _data);
static void fso_framework_abstract_command_queue_real_close (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_close (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_framework_abstract_command_queue_close_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_);
static gboolean fso_framework_abstract_command_queue_real_close_co (FsoFrameworkAbstractCommandQueueCloseData* _data_);
void fso_framework_transport_close (FsoFrameworkTransport* self);
static void fso_framework_abstract_command_queue_finalize (GObject* obj);
static void _vala_fso_framework_abstract_command_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_fso_framework_abstract_command_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void fso_framework_command_queue_open (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->open (self, _callback_, _user_data_);
}


gboolean fso_framework_command_queue_open_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_) {
	return FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->open_finish (self, _res_);
}


void fso_framework_command_queue_close (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->close (self, _callback_, _user_data_);
}


void fso_framework_command_queue_close_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->close_finish (self, _res_);
}


/**
     * Register @a UnsolicitedHandler delegate that will be called for incoming URCs
     **/
void fso_framework_command_queue_registerUnsolicitedHandler (FsoFrameworkCommandQueue* self, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->registerUnsolicitedHandler (self, urchandler, urchandler_target);
}


void fso_framework_command_queue_freeze (FsoFrameworkCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->freeze (self, drain, _callback_, _user_data_);
}


void fso_framework_command_queue_freeze_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->freeze_finish (self, _res_);
}


void fso_framework_command_queue_thaw (FsoFrameworkCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->thaw (self, _callback_, _user_data_);
}


void fso_framework_command_queue_thaw_finish (FsoFrameworkCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->thaw_finish (self, _res_);
}


FsoFrameworkTransport* fso_framework_command_queue_get_transport (FsoFrameworkCommandQueue* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->get_transport (self);
}


void fso_framework_command_queue_set_transport (FsoFrameworkCommandQueue* self, FsoFrameworkTransport* value) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_COMMAND_QUEUE_GET_INTERFACE (self)->set_transport (self, value);
}


static void fso_framework_command_queue_base_init (FsoFrameworkCommandQueueIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * The underlying transport
		     **/
		g_object_interface_install_property (iface, g_param_spec_object ("transport", "transport", "transport", FSO_FRAMEWORK_TYPE_TRANSPORT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * @interface FsoFramework.CommandQueue
 **/
GType fso_framework_command_queue_get_type (void) {
	static volatile gsize fso_framework_command_queue_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_command_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkCommandQueueIface), (GBaseInitFunc) fso_framework_command_queue_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_framework_command_queue_type_id;
		fso_framework_command_queue_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoFrameworkCommandQueue", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_framework_command_queue_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&fso_framework_command_queue_type_id__volatile, fso_framework_command_queue_type_id);
	}
	return fso_framework_command_queue_type_id__volatile;
}


static void fso_framework_abstract_command_handler_real_writeToTransport (FsoFrameworkAbstractCommandHandler* self, FsoFrameworkTransport* t) {
	g_critical ("Type `%s' does not implement abstract method `fso_framework_abstract_command_handler_writeToTransport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void fso_framework_abstract_command_handler_writeToTransport (FsoFrameworkAbstractCommandHandler* self, FsoFrameworkTransport* t) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_GET_CLASS (self)->writeToTransport (self, t);
}


static gchar* fso_framework_abstract_command_handler_real_to_string (FsoFrameworkAbstractCommandHandler* self) {
	g_critical ("Type `%s' does not implement abstract method `fso_framework_abstract_command_handler_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* fso_framework_abstract_command_handler_to_string (FsoFrameworkAbstractCommandHandler* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_GET_CLASS (self)->to_string (self);
}


FsoFrameworkAbstractCommandHandler* fso_framework_abstract_command_handler_construct (GType object_type) {
	FsoFrameworkAbstractCommandHandler* self = NULL;
	self = (FsoFrameworkAbstractCommandHandler*) g_type_create_instance (object_type);
	return self;
}


static void fso_framework_value_abstract_command_handler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_framework_value_abstract_command_handler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_framework_abstract_command_handler_unref (value->data[0].v_pointer);
	}
}


static void fso_framework_value_abstract_command_handler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_framework_abstract_command_handler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_framework_value_abstract_command_handler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_framework_value_abstract_command_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoFrameworkAbstractCommandHandler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_framework_abstract_command_handler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_framework_value_abstract_command_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoFrameworkAbstractCommandHandler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_framework_abstract_command_handler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_framework_param_spec_abstract_command_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoFrameworkParamSpecAbstractCommandHandler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_framework_value_get_abstract_command_handler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER), NULL);
	return value->data[0].v_pointer;
}


void fso_framework_value_set_abstract_command_handler (GValue* value, gpointer v_object) {
	FsoFrameworkAbstractCommandHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_framework_abstract_command_handler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_abstract_command_handler_unref (old);
	}
}


void fso_framework_value_take_abstract_command_handler (GValue* value, gpointer v_object) {
	FsoFrameworkAbstractCommandHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_abstract_command_handler_unref (old);
	}
}


static void fso_framework_abstract_command_handler_class_init (FsoFrameworkAbstractCommandHandlerClass * klass) {
	fso_framework_abstract_command_handler_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_CLASS (klass)->finalize = fso_framework_abstract_command_handler_finalize;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_CLASS (klass)->writeToTransport = fso_framework_abstract_command_handler_real_writeToTransport;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_CLASS (klass)->to_string = fso_framework_abstract_command_handler_real_to_string;
}


static void fso_framework_abstract_command_handler_instance_init (FsoFrameworkAbstractCommandHandler * self) {
	self->callback = NULL;
	self->ref_count = 1;
}


static void fso_framework_abstract_command_handler_finalize (FsoFrameworkAbstractCommandHandler* obj) {
	FsoFrameworkAbstractCommandHandler * self;
	self = FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER (obj);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
}


/**
 * @class FsoFramework.AbstractCommandHandler
 **/
GType fso_framework_abstract_command_handler_get_type (void) {
	static volatile gsize fso_framework_abstract_command_handler_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_abstract_command_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_framework_value_abstract_command_handler_init, fso_framework_value_abstract_command_handler_free_value, fso_framework_value_abstract_command_handler_copy_value, fso_framework_value_abstract_command_handler_peek_pointer, "p", fso_framework_value_abstract_command_handler_collect_value, "p", fso_framework_value_abstract_command_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkAbstractCommandHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_abstract_command_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkAbstractCommandHandler), 0, (GInstanceInitFunc) fso_framework_abstract_command_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_framework_abstract_command_handler_type_id;
		fso_framework_abstract_command_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoFrameworkAbstractCommandHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&fso_framework_abstract_command_handler_type_id__volatile, fso_framework_abstract_command_handler_type_id);
	}
	return fso_framework_abstract_command_handler_type_id__volatile;
}


gpointer fso_framework_abstract_command_handler_ref (gpointer instance) {
	FsoFrameworkAbstractCommandHandler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_framework_abstract_command_handler_unref (gpointer instance) {
	FsoFrameworkAbstractCommandHandler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_FRAMEWORK_ABSTRACT_COMMAND_HANDLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void fso_framework_abstract_command_queue_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkTransport* t) {
	g_critical ("Type `%s' does not implement abstract method `fso_framework_abstract_command_queue_onReadFromTransport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void fso_framework_abstract_command_queue_onReadFromTransport (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkTransport* t) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->onReadFromTransport (self, t);
}


gboolean fso_framework_abstract_command_queue_checkRestartingQ (FsoFrameworkAbstractCommandQueue* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	FsoFrameworkAbstractCommandHandler* _tmp1_;
	gboolean _tmp5_;
	GeeLinkedList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->current;
	if (_tmp1_ == NULL) {
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->q;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		fso_framework_abstract_command_queue_writeNextCommand (self);
	}
	_tmp6_ = self->priv->q;
	_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	result = _tmp8_ > 0;
	return result;
}


static gboolean _fso_framework_abstract_command_queue_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = fso_framework_abstract_command_queue_onTimeout (self);
	return result;
}


void fso_framework_abstract_command_queue_writeNextCommand (FsoFrameworkAbstractCommandQueue* self) {
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeLinkedList* _tmp11_;
	gpointer _tmp12_ = NULL;
	FsoFrameworkAbstractCommandHandler* _tmp13_;
	FsoFrameworkTransport* _tmp14_;
	FsoFrameworkTransport* _tmp15_;
	FsoFrameworkAbstractCommandHandler* _tmp16_;
	GSourceFunc _tmp17_;
	void* _tmp17__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->logger;
	_tmp3_ = self->priv->q;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("Attemping to write next command to transport; we have ", _tmp7_, " commands pending!", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = fso_framework_logger_debug (_tmp2_, _tmp9_);
	g_assert (_tmp10_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp11_ = self->priv->q;
	_tmp12_ = gee_deque_poll_head ((GeeDeque*) _tmp11_);
	_fso_framework_abstract_command_handler_unref0 (self->current);
	self->current = (FsoFrameworkAbstractCommandHandler*) _tmp12_;
	_tmp13_ = self->current;
	_tmp14_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp15_ = _tmp14_;
	fso_framework_abstract_command_handler_writeToTransport (_tmp13_, _tmp15_);
	_tmp16_ = self->current;
	_tmp17_ = _tmp16_->callback;
	_tmp17__target = _tmp16_->callback_target;
	if (_tmp17_ != NULL) {
		FsoFrameworkTransport* _tmp18_;
		FsoFrameworkTransport* _tmp19_;
		FsoFrameworkLogger* _tmp20_;
		FsoFrameworkAbstractCommandHandler* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		FsoFrameworkAbstractCommandHandler* _tmp24_;
		guint _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		FsoFrameworkAbstractCommandHandler* _tmp31_;
		guint _tmp32_;
		_tmp18_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->logger;
		_tmp21_ = self->current;
		_tmp22_ = fso_framework_abstract_command_handler_to_string (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->current;
		_tmp25_ = _tmp24_->timeout;
		_tmp26_ = g_strdup_printf ("%u", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("Wrote '", _tmp23_, "'. Waiting (", _tmp27_, "s) for answer...", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = fso_framework_logger_debug (_tmp20_, _tmp29_);
		g_assert (_tmp30_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp23_);
		_tmp31_ = self->current;
		_tmp32_ = _tmp31_->timeout;
		if (_tmp32_ > ((guint) 0)) {
			FsoFrameworkAbstractCommandHandler* _tmp33_;
			guint _tmp34_;
			guint _tmp35_ = 0U;
			_tmp33_ = self->current;
			_tmp34_ = _tmp33_->timeout;
			_tmp35_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp34_, _fso_framework_abstract_command_queue_onTimeout_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->timeoutWatch = _tmp35_;
		}
	} else {
		_fso_framework_abstract_command_handler_unref0 (self->current);
		self->current = NULL;
	}
}


void fso_framework_abstract_command_queue_resetTimeout (FsoFrameworkAbstractCommandQueue* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeoutWatch;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timeoutWatch;
		g_source_remove (_tmp1_);
	}
}


void fso_framework_abstract_command_queue_onHupFromTransport (FsoFrameworkAbstractCommandQueue* self) {
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->logger;
	fso_framework_logger_warning (_tmp2_, "HUP from transport; signalling to upper layer");
	g_signal_emit_by_name (self, "hangup");
}


gboolean fso_framework_abstract_command_queue_onTimeout (FsoFrameworkAbstractCommandQueue* self) {
	gboolean result = FALSE;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	FsoFrameworkAbstractCommandHandler* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	FsoFrameworkAbstractCommandHandler* _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->logger;
	_tmp3_ = self->current;
	_tmp4_ = fso_framework_abstract_command_handler_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Timeout while waiting for an answer to '", _tmp5_, "'", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = fso_framework_logger_warning (_tmp2_, _tmp7_);
	g_assert (_tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp9_ = self->current;
	_tmp10_ = _tmp9_->retry;
	if (_tmp10_ > ((guint) 0)) {
		FsoFrameworkAbstractCommandHandler* _tmp11_;
		guint _tmp12_;
		FsoFrameworkTransport* _tmp13_;
		FsoFrameworkTransport* _tmp14_;
		FsoFrameworkLogger* _tmp15_;
		FsoFrameworkAbstractCommandHandler* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		FsoFrameworkAbstractCommandHandler* _tmp19_;
		guint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		FsoFrameworkAbstractCommandHandler* _tmp26_;
		FsoFrameworkTransport* _tmp27_;
		FsoFrameworkTransport* _tmp28_;
		_tmp11_ = self->current;
		_tmp12_ = _tmp11_->retry;
		_tmp11_->retry = _tmp12_ - 1;
		_tmp13_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->logger;
		_tmp16_ = self->current;
		_tmp17_ = fso_framework_abstract_command_handler_to_string (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->current;
		_tmp20_ = _tmp19_->retry;
		_tmp21_ = g_strdup_printf ("%u", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("Retrying '", _tmp18_, "', retry counter = ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = fso_framework_logger_debug (_tmp15_, _tmp24_);
		g_assert (_tmp25_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp18_);
		_tmp26_ = self->current;
		_tmp27_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
		_tmp28_ = _tmp27_;
		fso_framework_abstract_command_handler_writeToTransport (_tmp26_, _tmp28_);
		result = TRUE;
		return result;
	} else {
		FsoFrameworkAbstractCommandHandler* _tmp29_;
		_tmp29_ = self->current;
		fso_framework_abstract_command_queue_onResponseTimeout (self, _tmp29_);
	}
	result = FALSE;
	return result;
}


static void fso_framework_abstract_command_queue_real_onResponseTimeout (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* ach) {
	g_return_if_fail (ach != NULL);
}


void fso_framework_abstract_command_queue_onResponseTimeout (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* ach) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->onResponseTimeout (self, ach);
}


static gboolean _fso_framework_abstract_command_queue_checkRestartingQ_gsource_func (gpointer self) {
	gboolean result;
	result = fso_framework_abstract_command_queue_checkRestartingQ (self);
	return result;
}


void fso_framework_abstract_command_queue_enqueueCommand (FsoFrameworkAbstractCommandQueue* self, FsoFrameworkAbstractCommandHandler* command) {
	GeeLinkedList* _tmp0_;
	FsoFrameworkAbstractCommandHandler* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = self->priv->q;
	_tmp1_ = command;
	gee_deque_offer_tail ((GeeDeque*) _tmp0_, _tmp1_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _fso_framework_abstract_command_queue_checkRestartingQ_gsource_func, g_object_ref (self), g_object_unref);
}


void fso_framework_abstract_command_queue_reset (FsoFrameworkAbstractCommandQueue* self) {
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	GeeLinkedList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->logger;
	fso_framework_logger_info (_tmp2_, "Reset commandqueue ...");
	_fso_framework_abstract_command_handler_unref0 (self->current);
	self->current = NULL;
	_tmp3_ = self->priv->q;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
}


gboolean fso_framework_abstract_command_queue_is_busy (FsoFrameworkAbstractCommandQueue* self) {
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->q;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}


static void _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_framework_abstract_command_queue_onReadFromTransport (self, transport);
}


static void _fso_framework_abstract_command_queue_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_framework_abstract_command_queue_onHupFromTransport (self);
}


FsoFrameworkAbstractCommandQueue* fso_framework_abstract_command_queue_construct (GType object_type, FsoFrameworkTransport* transport) {
	FsoFrameworkAbstractCommandQueue * self = NULL;
	GeeLinkedList* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
	g_return_val_if_fail (transport != NULL, NULL);
	self = (FsoFrameworkAbstractCommandQueue*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_HANDLER, (GBoxedCopyFunc) fso_framework_abstract_command_handler_ref, fso_framework_abstract_command_handler_unref, NULL);
	_g_object_unref0 (self->priv->q);
	self->priv->q = _tmp0_;
	_tmp1_ = transport;
	fso_framework_command_queue_set_transport ((FsoFrameworkCommandQueue*) self, _tmp1_);
	_tmp2_ = transport;
	fso_framework_transport_setDelegates (_tmp2_, _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func, self, _fso_framework_abstract_command_queue_onHupFromTransport_fso_framework_transport_func, self);
	return self;
}


static void fso_framework_abstract_command_queue_real_registerUnsolicitedHandler (FsoFrameworkCommandQueue* base, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target) {
	FsoFrameworkAbstractCommandQueue * self;
	FsoFrameworkCommandQueueUnsolicitedHandler _tmp0_;
	void* _tmp0__target;
	FsoFrameworkCommandQueueUnsolicitedHandler _tmp1_;
	void* _tmp1__target;
	self = (FsoFrameworkAbstractCommandQueue*) base;
	_tmp0_ = self->urchandler;
	_tmp0__target = self->urchandler_target;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = urchandler;
	_tmp1__target = urchandler_target;
	(self->urchandler_target_destroy_notify == NULL) ? NULL : (self->urchandler_target_destroy_notify (self->urchandler_target), NULL);
	self->urchandler = NULL;
	self->urchandler_target = NULL;
	self->urchandler_target_destroy_notify = NULL;
	self->urchandler = _tmp1_;
	self->urchandler_target = _tmp1__target;
	self->urchandler_target_destroy_notify = NULL;
}


static void fso_framework_abstract_command_queue_real_open_data_free (gpointer _data) {
	FsoFrameworkAbstractCommandQueueOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoFrameworkAbstractCommandQueueOpenData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void fso_framework_abstract_command_queue_real_open (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkAbstractCommandQueueOpenData* _data_;
	FsoFrameworkAbstractCommandQueue* _tmp0_;
	_data_ = g_slice_new0 (FsoFrameworkAbstractCommandQueueOpenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_framework_abstract_command_queue_real_open);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_abstract_command_queue_real_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_framework_abstract_command_queue_real_open_co (_data_);
}


static gboolean fso_framework_abstract_command_queue_real_open_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	gboolean result;
	FsoFrameworkAbstractCommandQueueOpenData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void fso_framework_abstract_command_queue_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FsoFrameworkAbstractCommandQueueOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	fso_framework_abstract_command_queue_real_open_co (_data_);
}


static gboolean fso_framework_abstract_command_queue_real_open_co (FsoFrameworkAbstractCommandQueueOpenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_transport_isOpen (_data_->_tmp1_);
	g_assert (!_data_->_tmp2_);
	_data_->_tmp3_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	fso_framework_transport_openAsync (_data_->_tmp4_, fso_framework_abstract_command_queue_open_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = fso_framework_transport_openAsync_finish (_data_->_tmp4_, _data_->_res_);
	_data_->opened = _data_->_tmp5_;
	_data_->result = _data_->opened;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void fso_framework_abstract_command_queue_open (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->open (self, _callback_, _user_data_);
}


gboolean fso_framework_abstract_command_queue_open_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	return FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->open_finish (self, _res_);
}


static void fso_framework_abstract_command_queue_real_freeze_data_free (gpointer _data) {
	FsoFrameworkAbstractCommandQueueFreezeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoFrameworkAbstractCommandQueueFreezeData, _data_);
}


static void fso_framework_abstract_command_queue_real_freeze (FsoFrameworkAbstractCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkAbstractCommandQueueFreezeData* _data_;
	FsoFrameworkAbstractCommandQueue* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (FsoFrameworkAbstractCommandQueueFreezeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_framework_abstract_command_queue_real_freeze);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_abstract_command_queue_real_freeze_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = drain;
	_data_->drain = _tmp1_;
	fso_framework_abstract_command_queue_real_freeze_co (_data_);
}


static void fso_framework_abstract_command_queue_real_freeze_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FsoFrameworkAbstractCommandQueueFreezeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_framework_abstract_command_queue_real_freeze_co (FsoFrameworkAbstractCommandQueueFreezeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_assert_not_reached ();
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void fso_framework_abstract_command_queue_freeze (FsoFrameworkAbstractCommandQueue* self, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->freeze (self, drain, _callback_, _user_data_);
}


void fso_framework_abstract_command_queue_freeze_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->freeze_finish (self, _res_);
}


static void fso_framework_abstract_command_queue_real_thaw_data_free (gpointer _data) {
	FsoFrameworkAbstractCommandQueueThawData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoFrameworkAbstractCommandQueueThawData, _data_);
}


static void fso_framework_abstract_command_queue_real_thaw (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkAbstractCommandQueueThawData* _data_;
	FsoFrameworkAbstractCommandQueue* _tmp0_;
	_data_ = g_slice_new0 (FsoFrameworkAbstractCommandQueueThawData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_framework_abstract_command_queue_real_thaw);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_abstract_command_queue_real_thaw_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_framework_abstract_command_queue_real_thaw_co (_data_);
}


static void fso_framework_abstract_command_queue_real_thaw_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FsoFrameworkAbstractCommandQueueThawData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_framework_abstract_command_queue_real_thaw_co (FsoFrameworkAbstractCommandQueueThawData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_assert_not_reached ();
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void fso_framework_abstract_command_queue_thaw (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->thaw (self, _callback_, _user_data_);
}


void fso_framework_abstract_command_queue_thaw_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->thaw_finish (self, _res_);
}


static void fso_framework_abstract_command_queue_real_close_data_free (gpointer _data) {
	FsoFrameworkAbstractCommandQueueCloseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoFrameworkAbstractCommandQueueCloseData, _data_);
}


static void fso_framework_abstract_command_queue_real_close (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkAbstractCommandQueueCloseData* _data_;
	FsoFrameworkAbstractCommandQueue* _tmp0_;
	_data_ = g_slice_new0 (FsoFrameworkAbstractCommandQueueCloseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_framework_abstract_command_queue_real_close);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_abstract_command_queue_real_close_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_framework_abstract_command_queue_real_close_co (_data_);
}


static void fso_framework_abstract_command_queue_real_close_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FsoFrameworkAbstractCommandQueueCloseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_framework_abstract_command_queue_real_close_co (FsoFrameworkAbstractCommandQueueCloseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	fso_framework_transport_close (_data_->_tmp1_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void fso_framework_abstract_command_queue_close (FsoFrameworkAbstractCommandQueue* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->close (self, _callback_, _user_data_);
}


void fso_framework_abstract_command_queue_close_finish (FsoFrameworkAbstractCommandQueue* self, GAsyncResult* _res_) {
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_CLASS (self)->close_finish (self, _res_);
}


static FsoFrameworkTransport* fso_framework_abstract_command_queue_real_get_transport (FsoFrameworkCommandQueue* base) {
	FsoFrameworkTransport* result;
	FsoFrameworkAbstractCommandQueue* self;
	FsoFrameworkTransport* _tmp0_;
	self = (FsoFrameworkAbstractCommandQueue*) base;
	_tmp0_ = self->priv->_transport;
	result = _tmp0_;
	return result;
}


static void fso_framework_abstract_command_queue_real_set_transport (FsoFrameworkCommandQueue* base, FsoFrameworkTransport* value) {
	FsoFrameworkAbstractCommandQueue* self;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	self = (FsoFrameworkAbstractCommandQueue*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_transport);
	self->priv->_transport = _tmp1_;
	g_object_notify ((GObject *) self, "transport");
}


static void fso_framework_abstract_command_queue_class_init (FsoFrameworkAbstractCommandQueueClass * klass) {
	fso_framework_abstract_command_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkAbstractCommandQueuePrivate));
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->onReadFromTransport = fso_framework_abstract_command_queue_real_onReadFromTransport;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->onResponseTimeout = fso_framework_abstract_command_queue_real_onResponseTimeout;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open = fso_framework_abstract_command_queue_real_open;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open_finish = fso_framework_abstract_command_queue_real_open_finish;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->freeze = fso_framework_abstract_command_queue_real_freeze;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->freeze_finish = fso_framework_abstract_command_queue_real_freeze_finish;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->thaw = fso_framework_abstract_command_queue_real_thaw;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->thaw_finish = fso_framework_abstract_command_queue_real_thaw_finish;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close = fso_framework_abstract_command_queue_real_close;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close_finish = fso_framework_abstract_command_queue_real_close_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_fso_framework_abstract_command_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fso_framework_abstract_command_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_abstract_command_queue_finalize;
	/**
	     * @property transport - The underlying transport
	     **/
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_TRANSPORT, g_param_spec_object ("transport", "transport", "transport", FSO_FRAMEWORK_TYPE_TRANSPORT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Sent, when an error has occured
	     **/
	g_signal_new ("hangup", FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void fso_framework_abstract_command_queue_fso_framework_command_queue_interface_init (FsoFrameworkCommandQueueIface * iface) {
	fso_framework_abstract_command_queue_fso_framework_command_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->registerUnsolicitedHandler = (void (*)(FsoFrameworkCommandQueue*, FsoFrameworkCommandQueueUnsolicitedHandler, void*)) fso_framework_abstract_command_queue_real_registerUnsolicitedHandler;
	iface->open = (gboolean (*)(FsoFrameworkCommandQueue*)) fso_framework_abstract_command_queue_open;
	iface->open_finish = fso_framework_abstract_command_queue_open_finish;
	iface->freeze = (void (*)(FsoFrameworkCommandQueue*, gboolean)) fso_framework_abstract_command_queue_freeze;
	iface->freeze_finish = fso_framework_abstract_command_queue_freeze_finish;
	iface->thaw = (void (*)(FsoFrameworkCommandQueue*)) fso_framework_abstract_command_queue_thaw;
	iface->thaw_finish = fso_framework_abstract_command_queue_thaw_finish;
	iface->close = (void (*)(FsoFrameworkCommandQueue*)) fso_framework_abstract_command_queue_close;
	iface->close_finish = fso_framework_abstract_command_queue_close_finish;
	iface->get_transport = fso_framework_abstract_command_queue_real_get_transport;
	iface->set_transport = fso_framework_abstract_command_queue_real_set_transport;
}


static void fso_framework_abstract_command_queue_instance_init (FsoFrameworkAbstractCommandQueue * self) {
	self->priv = FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_GET_PRIVATE (self);
}


static void fso_framework_abstract_command_queue_finalize (GObject* obj) {
	FsoFrameworkAbstractCommandQueue * self;
	self = FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE (obj);
	_g_object_unref0 (self->priv->_transport);
	_g_object_unref0 (self->priv->q);
	(self->urchandler_target_destroy_notify == NULL) ? NULL : (self->urchandler_target_destroy_notify (self->urchandler_target), NULL);
	self->urchandler = NULL;
	self->urchandler_target = NULL;
	self->urchandler_target_destroy_notify = NULL;
	_fso_framework_abstract_command_handler_unref0 (self->current);
	G_OBJECT_CLASS (fso_framework_abstract_command_queue_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.AbstractCommandQueue
 **/
GType fso_framework_abstract_command_queue_get_type (void) {
	static volatile gsize fso_framework_abstract_command_queue_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_abstract_command_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkAbstractCommandQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_abstract_command_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkAbstractCommandQueue), 0, (GInstanceInitFunc) fso_framework_abstract_command_queue_instance_init, NULL };
		static const GInterfaceInfo fso_framework_command_queue_info = { (GInterfaceInitFunc) fso_framework_abstract_command_queue_fso_framework_command_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_framework_abstract_command_queue_type_id;
		fso_framework_abstract_command_queue_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkAbstractCommandQueue", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (fso_framework_abstract_command_queue_type_id, FSO_FRAMEWORK_TYPE_COMMAND_QUEUE, &fso_framework_command_queue_info);
		g_once_init_leave (&fso_framework_abstract_command_queue_type_id__volatile, fso_framework_abstract_command_queue_type_id);
	}
	return fso_framework_abstract_command_queue_type_id__volatile;
}


static void _vala_fso_framework_abstract_command_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FsoFrameworkAbstractCommandQueue * self;
	self = FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE (object);
	switch (property_id) {
		case FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_TRANSPORT:
		g_value_set_object (value, fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_fso_framework_abstract_command_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FsoFrameworkAbstractCommandQueue * self;
	self = FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE (object);
	switch (property_id) {
		case FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_TRANSPORT:
		fso_framework_command_queue_set_transport ((FsoFrameworkCommandQueue*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



