with Support;           use Support;
with GNATCOLL.Traces;   use GNATCOLL.Traces;

procedure Predec is
   Me  : constant Trace_Handle := Create ("PREDEC");
   Me2 : constant Trace_Handle := Create ("P");

begin
   Add_Global_Decorator (new Custom_Decorator, "MY_DECORATOR");

   Parse_Config_File;

   Trace (Me, "Some message");
   Trace (Me2, "Another message");
   Trace (Me, "A long" & ASCII.LF & "message" & ASCII.LF
      & "on multiple lines");

   --  With indentation

   Increase_Indent (Me, "increasing the indentation");
   Trace (Me, "Some message");
   Trace (Me2, "Another message");

   --  Disable traces

   Set_Active (Create ("MY_DECORATOR"), False);
   Trace (Me, "After disabling decorator");

   Decrease_Indent (Me, "decreasing the indentation");

   Finalize;
end Predec;
