/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.NewBenchmarkSpec;
import com.google.caliper.model.NewHost;
import com.google.caliper.model.NewVmSpec;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NewScenario {
    private final NewHost host;
    private final NewVmSpec vmSpec;
    private final NewBenchmarkSpec benchmarkSpec;

    private NewScenario(Builder builder) {
        this.host = builder.host;
        this.vmSpec = builder.vmSpec;
        this.benchmarkSpec = builder.benchmarkSpec;
    }

    public NewHost host() {
        return this.host;
    }

    public NewVmSpec vmSpec() {
        return this.vmSpec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewScenario) {
            NewScenario that = (NewScenario)obj;
            return this.host.equals(that.host) && this.vmSpec.equals(that.vmSpec) && this.benchmarkSpec.equals(that.benchmarkSpec);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.vmSpec, this.benchmarkSpec});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("environment", (Object)this.host).add("vmSpec", (Object)this.vmSpec).add("benchmarkSpec", (Object)this.benchmarkSpec).toString();
    }

    public static final class Builder {
        private NewHost host;
        private NewVmSpec vmSpec;
        private NewBenchmarkSpec benchmarkSpec;

        public Builder environment(NewHost.Builder hostBuilder) {
            return this.host(hostBuilder.build());
        }

        public Builder host(NewHost host) {
            this.host = (NewHost)Preconditions.checkNotNull((Object)host);
            return this;
        }

        public Builder vmSpec(NewVmSpec.Builder vmSpecBuilder) {
            return this.vmSpec(vmSpecBuilder.build());
        }

        public Builder vmSpec(NewVmSpec vmSpec) {
            this.vmSpec = (NewVmSpec)Preconditions.checkNotNull((Object)vmSpec);
            return this;
        }

        public Builder benchmarkSpec(NewBenchmarkSpec.Builder benchmarkSpecBuilder) {
            return this.benchmarkSpec(benchmarkSpecBuilder.build());
        }

        public Builder benchmarkSpec(NewBenchmarkSpec benchmarkSpec) {
            this.benchmarkSpec = (NewBenchmarkSpec)Preconditions.checkNotNull((Object)benchmarkSpec);
            return this;
        }

        public NewScenario build() {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0);
            Preconditions.checkState((this.vmSpec != null ? 1 : 0) != 0);
            Preconditions.checkState((this.benchmarkSpec != null ? 1 : 0) != 0);
            return new NewScenario(this);
        }
    }
}

