#########################################################################################
# Package        HiPi::Graphics::BitmapFont::Sans19
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::Sans19;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 19;
my $line_spacing = 1;
my $name = 'Sans 19';
my $space_width = 5;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x04, 0x40, ##       0   0  
            0x04, 0xC0, ##       0  00  
            0x0C, 0xC0, ##      00  00  
            0x0C, 0x80, ##      00  0   
            0x7F, 0xF0, ##   00000000000
            0x09, 0x80, ##      0  00   
            0x19, 0x80, ##     00  00   
            0x19, 0x00, ##     00  0    
            0xFF, 0xE0, ##  00000000000 
            0x13, 0x00, ##     0  00    
            0x33, 0x00, ##    00  00    
            0x32, 0x00, ##    00  0     
            0x22, 0x00, ##    0   0     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x10, ##     0    
            0x10, ##     0    
            0x10, ##     0    
            0x7E, ##   000000 
            0xD2, ##  00 0  0 
            0xD0, ##  00 0    
            0xD0, ##  00 0    
            0xF0, ##  0000    
            0x7E, ##   000000 
            0x17, ##     0 000
            0x13, ##     0  00
            0x13, ##     0  00
            0x97, ##  0  0 000
            0xFC, ##  000000  
            0x10, ##     0    
            0x10, ##     0    
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x78, 0x20, ##   0000     0    
            0xCC, 0x20, ##  00  00    0    
            0xCC, 0x40, ##  00  00   0     
            0xCC, 0xC0, ##  00  00  00     
            0xCC, 0x80, ##  00  00  0      
            0xCD, 0x00, ##  00  00 0       
            0x79, 0x38, ##   0000  0  000  
            0x02, 0xEC, ##        0 000 00 
            0x04, 0xC6, ##       0  00   00
            0x04, 0xC6, ##       0  00   00
            0x08, 0xC6, ##      0   00   00
            0x08, 0xEE, ##      0   000 000
            0x10, 0x38, ##     0      000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000    
            0x71, 0x00, ##   000   0    
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x30, 0x00, ##    00        
            0x38, 0x00, ##    000       
            0x6C, 0x60, ##   00 00   00 
            0xC6, 0x60, ##  00   00  00 
            0xC6, 0x40, ##  00   00  0  
            0xC3, 0xC0, ##  00    0000  
            0xC1, 0x80, ##  00     00   
            0x61, 0xC0, ##   00    000  
            0x3E, 0x60, ##    00000  00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x30, ##    00
            0x20, ##    0 
            0x60, ##   00 
            0x60, ##   00 
            0x40, ##   0  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0x40, ##   0  
            0x60, ##   00 
            0x60, ##   00 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0   
            0x40, ##   0  
            0x60, ##   00 
            0x60, ##   00 
            0x20, ##    0 
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x20, ##    0 
            0x60, ##   00 
            0x60, ##   00 
            0x40, ##   0  
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0   
            0x10, ##     0   
            0xD6, ##  00 0 00
            0x38, ##    000  
            0x38, ##    000  
            0xD6, ##  00 0 00
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0xFF, 0xE0, ##  00000000000
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0C, ##      00
            0x08, ##      0 
            0x08, ##      0 
            0x18, ##     00 
            0x10, ##     0  
            0x10, ##     0  
            0x30, ##    00  
            0x30, ##    00  
            0x20, ##    0   
            0x60, ##   00   
            0x60, ##   00   
            0x40, ##   0    
            0x40, ##   0    
            0xC0, ##  00    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x63, 0x00, ##   00   00 
            0x63, 0x00, ##   00   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x00, ##   00   00 
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x78, ##   0000  
            0xF8, ##  00000  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0x86, ##  0    00 
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x07, ##       000
            0x06, ##       00 
            0x0C, ##      00  
            0x18, ##     00   
            0x30, ##    00    
            0x60, ##   00     
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0x86, ##  0    00 
            0x03, ##        00
            0x03, ##        00
            0x07, ##       000
            0x3E, ##    00000 
            0x06, ##       00 
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x86, ##  0    00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x00, ##      000  
            0x0E, 0x00, ##      000  
            0x1E, 0x00, ##     0000  
            0x16, 0x00, ##     0 00  
            0x26, 0x00, ##    0  00  
            0x66, 0x00, ##   00  00  
            0x46, 0x00, ##   0   00  
            0xC6, 0x00, ##  00   00  
            0x86, 0x00, ##  0    00  
            0xFF, 0x80, ##  000000000
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFC, ##  000000  
            0x86, ##  0    00 
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x06, ##       00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000 
            0x30, 0x00, ##    00     
            0x60, 0x00, ##   00      
            0xC0, 0x00, ##  00       
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xE1, 0x80, ##  000    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x61, 0x80, ##   00    00
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0x03, ##        00
            0x06, ##       00 
            0x06, ##       00 
            0x06, ##       00 
            0x0C, ##      00  
            0x0C, ##      00  
            0x08, ##      0   
            0x18, ##     00   
            0x18, ##     00   
            0x10, ##     0    
            0x30, ##    00    
            0x30, ##    00    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3C, 0x00, ##    0000   
            0xE7, 0x00, ##  000  000 
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xE6, 0x00, ##  000  00  
            0x7C, 0x00, ##   00000   
            0x63, 0x00, ##   00   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3C, 0x00, ##    0000   
            0x63, 0x00, ##   00   00 
            0xC1, 0x00, ##  00     0 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x46, 0x00, ##   0   00  
            0x7C, 0x00, ##   00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xE0, ##          000
            0x03, 0xC0, ##        0000 
            0x1E, 0x00, ##     0000    
            0xF0, 0x00, ##  0000       
            0xC0, 0x00, ##  00         
            0x78, 0x00, ##   0000      
            0x0F, 0x00, ##      0000   
            0x03, 0xC0, ##        0000 
            0x00, 0x60, ##           00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0x78, 0x00, ##   0000      
            0x1E, 0x00, ##     0000    
            0x03, 0xC0, ##        0000 
            0x00, 0xE0, ##          000
            0x03, 0xC0, ##        0000 
            0x1E, 0x00, ##     0000    
            0xF0, 0x00, ##  0000       
            0xC0, 0x00, ##  00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x78, ##   0000  
            0x8E, ##  0   000
            0x06, ##       00
            0x06, ##       00
            0x0E, ##      000
            0x1C, ##     000 
            0x38, ##    000  
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##         
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000     
            0x18, 0x30, ##     00     00   
            0x30, 0x08, ##    00        0  
            0x60, 0x04, ##   00          0 
            0x47, 0xE6, ##   0   000000  00
            0x86, 0xE2, ##  0    00 000   0
            0x8C, 0x62, ##  0   00   00   0
            0x8C, 0x62, ##  0   00   00   0
            0x8C, 0x62, ##  0   00   00   0
            0x8C, 0x64, ##  0   00   00  0 
            0x86, 0xEC, ##  0    00 000 00 
            0x47, 0x70, ##   0   000 000   
            0x40, 0x00, ##   0             
            0x20, 0x10, ##    0        0   
            0x18, 0x30, ##     00     00   
            0x07, 0xC0, ##       00000     
            0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00    
            0x0E, 0x00, ##      000    
            0x0B, 0x00, ##      0 00   
            0x09, 0x00, ##      0  0   
            0x19, 0x00, ##     00  0   
            0x11, 0x80, ##     0   00  
            0x30, 0x80, ##    00    0  
            0x30, 0x80, ##    00    0  
            0x3F, 0xC0, ##    00000000 
            0x60, 0x40, ##   00      0 
            0x60, 0x60, ##   00      00
            0x40, 0x60, ##   0       00
            0xC0, 0x20, ##  00        0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000   
            0xC6, 0x00, ##  00   00  
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC6, 0x00, ##  00   00  
            0xFC, 0x00, ##  000000   
            0xC3, 0x00, ##  00    00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x00, ##  00    00 
            0xFE, 0x00, ##  0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000 
            0x30, 0xC0, ##    00    00
            0x60, 0x00, ##   00       
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x30, 0xC0, ##    00    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000    
            0xC1, 0x80, ##  00     00  
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xC0, ##  00      00 
            0xC1, 0x80, ##  00     00  
            0xFE, 0x00, ##  0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xFE, ##  0000000
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000 
            0x30, 0x60, ##    00     00
            0x60, 0x20, ##   00       0
            0x40, 0x00, ##   0         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC3, 0xE0, ##  00    00000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0x60, ##   0       00
            0x60, 0x60, ##   00      00
            0x30, 0x60, ##    00     00
            0x1F, 0xC0, ##     0000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x60, ##   00 
            0xC0, ##  00  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00 
            0xC3, 0x00, ##  00    00  
            0xC6, 0x00, ##  00   00   
            0xCC, 0x00, ##  00  00    
            0xD8, 0x00, ##  00 00     
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xD8, 0x00, ##  00 00     
            0xCC, 0x00, ##  00  00    
            0xC6, 0x00, ##  00   00   
            0xC3, 0x00, ##  00    00  
            0xC1, 0x80, ##  00     00 
            0xC1, 0xC0, ##  00     000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x70, ##  000      000
            0xE0, 0x70, ##  000      000
            0xF0, 0xF0, ##  0000    0000
            0xD0, 0xB0, ##  00 0    0 00
            0xD0, 0xB0, ##  00 0    0 00
            0xD9, 0xB0, ##  00 00  00 00
            0xC9, 0x30, ##  00  0  0  00
            0xCF, 0x30, ##  00  0000  00
            0xCF, 0x30, ##  00  0000  00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0xC0, ##  000     00
            0xE0, 0xC0, ##  000     00
            0xF0, 0xC0, ##  0000    00
            0xD0, 0xC0, ##  00 0    00
            0xD8, 0xC0, ##  00 00   00
            0xC8, 0xC0, ##  00  0   00
            0xCC, 0xC0, ##  00  00  00
            0xC4, 0xC0, ##  00   0  00
            0xC6, 0xC0, ##  00   00 00
            0xC2, 0xC0, ##  00    0 00
            0xC3, 0xC0, ##  00    0000
            0xC1, 0xC0, ##  00     000
            0xC1, 0xC0, ##  00     000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000   
            0x30, 0xC0, ##    00    00  
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x40, 0x60, ##   0       00 
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x1F, 0x80, ##     000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0xC6, ##  00   00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC6, ##  00   00 
            0xFC, ##  000000  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000   
            0x30, 0xC0, ##    00    00  
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x40, 0x60, ##   0       00 
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x1F, 0x80, ##     000000   
            0x01, 0x80, ##         00   
            0x00, 0xC0, ##          00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000    
            0xC6, 0x00, ##  00   00   
            0xC3, 0x00, ##  00    00  
            0xC3, 0x00, ##  00    00  
            0xC3, 0x00, ##  00    00  
            0xC7, 0x00, ##  00   000  
            0xFE, 0x00, ##  0000000   
            0xC6, 0x00, ##  00   00   
            0xC2, 0x00, ##  00    0   
            0xC3, 0x00, ##  00    00  
            0xC1, 0x00, ##  00     0  
            0xC1, 0x80, ##  00     00 
            0xC0, 0x80, ##  00      0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000 
            0x61, 0x00, ##   00    0 
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xE0, 0x00, ##  000      
            0xFC, 0x00, ##  000000   
            0x7F, 0x00, ##   0000000 
            0x07, 0x80, ##       0000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0xC3, 0x00, ##  00    00 
            0xFE, 0x00, ##  0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x3F, 0x00, ##    000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x20, ##  00        0
            0x40, 0x60, ##   0       00
            0x60, 0x60, ##   00      00
            0x60, 0xC0, ##   00     00 
            0x20, 0xC0, ##    0     00 
            0x30, 0x80, ##    00    0  
            0x31, 0x80, ##    00   00  
            0x19, 0x80, ##     00  00  
            0x19, 0x00, ##     00  0   
            0x0B, 0x00, ##      0 00   
            0x0F, 0x00, ##      0000   
            0x0E, 0x00, ##      000    
            0x06, 0x00, ##       00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x83, 0x06, ##  0     00     00
            0xC3, 0x86, ##  00    000    00
            0xC2, 0x86, ##  00    0 0    00
            0xC2, 0x84, ##  00    0 0    0 
            0x46, 0x8C, ##   0   00 0   00 
            0x66, 0xCC, ##   00  00 00  00 
            0x64, 0x4C, ##   00  0   0  00 
            0x64, 0x48, ##   00  0   0  0  
            0x2C, 0x48, ##    0 00   0  0  
            0x3C, 0x78, ##    0000   0000  
            0x38, 0x78, ##    000    0000  
            0x38, 0x38, ##    000     000  
            0x18, 0x30, ##     00     00   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x23, 0x00, ##    0   00  
            0x33, 0x00, ##    00  00  
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x36, 0x00, ##    00 00   
            0x33, 0x00, ##    00  00  
            0x61, 0x80, ##   00    00 
            0xC1, 0x80, ##  00     00 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0x40, 0x80, ##   0      0 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x13, 0x00, ##     0  00  
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0x00, 0xC0, ##          00
            0x01, 0x80, ##         00 
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x06, 0x00, ##       00   
            0x0C, 0x00, ##      00    
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x30, 0x00, ##    00      
            0x60, 0x00, ##   00       
            0xC0, 0x00, ##  00        
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF0, ##  0000
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00    
            0xC0, ##  00    
            0x40, ##   0    
            0x40, ##   0    
            0x60, ##   00   
            0x20, ##    0   
            0x20, ##    0   
            0x30, ##    00  
            0x10, ##     0  
            0x10, ##     0  
            0x18, ##     00 
            0x18, ##     00 
            0x08, ##      0 
            0x08, ##      0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF0, ##  0000
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x33, 0x00, ##    00  00  
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0xC0, ##  00  
            0x60, ##   00 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x7F, ##   0000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xE3, 0x00, ##  000   00 
            0xDE, 0x00, ##  00 0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3F, ##    000000
            0x61, ##   00    0
            0xE0, ##  000     
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x61, ##   00    0
            0x3F, ##    000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3D, 0x80, ##    0000 00
            0x63, 0x80, ##   00   000
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x63, 0x00, ##   00   00 
            0x41, 0x80, ##   0     00
            0xC1, 0x80, ##  00     00
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xE0, 0x00, ##  000      
            0x61, 0x80, ##   00    00
            0x1F, 0x00, ##     00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x3C, ##    0000
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0xFC, ##  000000
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3D, 0x80, ##    0000 00
            0x63, 0x80, ##   00   000
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x43, 0x00, ##   0    00 
            0x7E, 0x00, ##   000000  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xDE, ##  00 0000 
            0xE6, ##  000  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x30, ##    00
            0x30, ##    00
            0x00, ##      
            0x00, ##      
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0xE0, ##  000 
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC3, 0x00, ##  00    00 
            0xC6, 0x00, ##  00   00  
            0xCC, 0x00, ##  00  00   
            0xD8, 0x00, ##  00 00    
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xD8, 0x00, ##  00 00    
            0xCC, 0x00, ##  00  00   
            0xC6, 0x00, ##  00   00  
            0xC3, 0x00, ##  00    00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDE, 0x78, ##  00 0000  0000 
            0xE6, 0x98, ##  000  00 0  00 
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0xC3, 0x0C, ##  00    00    00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDE, ##  00 0000 
            0xE6, ##  000  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x63, 0x00, ##   00   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x00, ##   00   00 
            0x3E, 0x00, ##    00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xE3, 0x00, ##  000   00 
            0xDE, 0x00, ##  00 0000  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3D, 0x80, ##    0000 00
            0x63, 0x80, ##   00   000
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDC, ##  00 000
            0xE0, ##  000   
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0xC0, ##  00    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000 
            0xC0, ##  00     
            0xC0, ##  00     
            0xE0, ##  000    
            0xF8, ##  00000  
            0x3E, ##    00000
            0x06, ##       00
            0x06, ##       00
            0x86, ##  0    00
            0xFC, ##  000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0xFC, ##  000000
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x60, ##   00   
            0x3C, ##    0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x67, ##   00  000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x81, 0x00, ##  0      0 
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0x42, 0x00, ##   0    0  
            0x66, 0x00, ##   00  00  
            0x66, 0x00, ##   00  00  
            0x24, 0x00, ##    0  0   
            0x3C, 0x00, ##    0000   
            0x3C, 0x00, ##    0000   
            0x18, 0x00, ##     00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x86, 0x10, ##  0    00    0
            0xC6, 0x30, ##  00   00   00
            0xCE, 0x30, ##  00  000   00
            0x4F, 0x20, ##   0  0000  0 
            0x49, 0x20, ##   0  0  0  0 
            0x69, 0x60, ##   00 0  0 00 
            0x79, 0x60, ##   0000  0 00 
            0x39, 0xC0, ##    000  000  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x13, 0x00, ##     0  00  
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x33, 0x00, ##    00  00  
            0x21, 0x00, ##    0    0  
            0x61, 0x80, ##   00    00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00
            0x41, 0x80, ##   0     00
            0x61, 0x00, ##   00    0 
            0x63, 0x00, ##   00   00 
            0x23, 0x00, ##    0   00 
            0x32, 0x00, ##    00  0  
            0x16, 0x00, ##     0 00  
            0x14, 0x00, ##     0 0   
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x70, 0x00, ##   000     
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0x06, ##       00
            0x0C, ##      00 
            0x08, ##      0  
            0x18, ##     00  
            0x30, ##    00   
            0x20, ##    0    
            0x60, ##   00    
            0xC0, ##  00     
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 6, 
        'xoffset'  => 3, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x1C, ##     000
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xC0, ##  00    
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x1C, ##     000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 6, 
        'xoffset'  => 3, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000   
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x0C, ##      00
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xE0, ##  000   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x78, 0x60, ##   0000    00
            0x87, 0xC0, ##  0    00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '74' => 1, '84' => -1, '86' => -1, '88' => -1, '89' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '121' => -1, },  # A
    '66' => { '89' => -1, },  # B
    '67' => { },  # C
    '68' => { '89' => -1, },  # D
    '69' => { },  # E
    '70' => { '46' => -2, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '105' => -1, '114' => -1, '117' => -1, '121' => -1, },  # F
    '71' => { '89' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { '45' => -1, '67' => -1, '79' => -1, '84' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # K
    '76' => { '84' => -2, '85' => -1, '86' => -1, '87' => -1, '89' => -2, '121' => -1, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '88' => -1, '89' => -1, },  # O
    '80' => { '46' => -2, '65' => -1, '97' => -1, },  # P
    '81' => { },  # Q
    '82' => { '67' => -1, '84' => -1, '86' => -1, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # R
    '83' => { },  # S
    '84' => { '45' => -1, '46' => -1, '58' => -1, '65' => -1, '67' => -1, '97' => -2, '99' => -2, '101' => -2, '111' => -2, '114' => -2, '115' => -2, '117' => -2, '119' => -2, '121' => -2, },  # T
    '85' => { },  # U
    '86' => { '45' => -1, '46' => -1, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, },  # V
    '87' => { '46' => -1, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '114' => -1, },  # W
    '88' => { '45' => -1, '67' => -1, '79' => -1, '101' => -1, },  # X
    '89' => { '45' => -1, '46' => -2, '58' => -2, '65' => -1, '67' => -1, '79' => -1, '97' => -2, '101' => -2, '111' => -2, '117' => -1, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '45' => -1, '46' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -1, '46' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '46' => -1, '58' => -1, },  # v
    '119' => { '46' => -1, '58' => -1, },  # w
    '120' => { },  # x
    '121' => { '46' => -2, '58' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
