package org.htmlcleaner.conditional;

import org.htmlcleaner.TagNode;

/**
 * Remove empty autogenerated nodes. These nodes are created when an unclosed tag is immediately closed.
 * @author patmoore
 *
 */
public class TagNodeAutoGeneratedCondition implements ITagNodeCondition {

    public static final TagNodeAutoGeneratedCondition INSTANCE = new TagNodeAutoGeneratedCondition();
    /**
     * @see org.htmlcleaner.conditional.ITagNodeCondition#satisfy(org.htmlcleaner.TagNode)
     */
    public boolean satisfy(TagNode tagNode) {
        // auto-generated node that is not needed.
        return tagNode.isAutoGenerated() && tagNode.isEmpty();
    }

    @Override
    public String toString() {
        return "auto generated tagNode";
    }
}
