#------------------------------------------------------------------------------
# File:         ja.pm
#
# Description:  ExifTool Japanese language translations
#
# Notes:        This file generated automatically by Image::ExifTool::TagInfoXML
#------------------------------------------------------------------------------

package Image::ExifTool::Lang::ja;

use strict;
use vars qw($VERSION);

$VERSION = '1.19';

%Image::ExifTool::Lang::ja::Translate = (
   'AEAperture' => 'AE絞り',
   'AEBAutoCancel' => {
      Description => 'ブラケティング自動解除',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AEBBracketValue' => 'AEBブラケット値',
   'AEBSequence' => 'ブラケティング順序',
   'AEBSequenceAutoCancel' => {
      Description => 'ブラケティング順序/自動解除',
      PrintConv => {
        '-,0,+/Disabled' => '－→0 →＋/しない',
        '-,0,+/Enabled' => '－→0 →＋/する',
        '0,-,+/Disabled' => '0 →－→＋/しない',
        '0,-,+/Enabled' => '0 →－→＋/する',
      },
    },
   'AEBShotCount' => 'ブラケティング時の撮影枚数',
   'AEBXv' => 'AEブラケット 露出補正',
   'AEExposureTime' => 'AE露出時間',
   'AEExtra' => 'AE特別？',
   'AEInfo' => '自動露出情報',
   'AELock' => {
      Description => 'AEロック',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AELockButton' => {
      Description => 'AE-L/AF-L',
      PrintConv => {
        'AE-L/AF Area' => 'AE-L/AFエリア',
        'AE-L/AF-L/AF Area' => 'AE-L/AF-L/AFエリア',
        'AF-L/AF Area' => 'AF-L/AFエリア',
        'AF-ON/AF Area' => 'AFオン/AFエリア',
        'FV Lock' => 'FVロック',
        'Focus Area Selection' => 'フォーカスエリア選択',
      },
    },
   'AEMaxAperture' => 'AE最大絞り',
   'AEMaxAperture2' => 'AE最大絞り(2)',
   'AEMeteringMode' => {
      Description => 'AE測光モード',
      PrintConv => {
        'Multi-segment' => 'パターン',
      },
    },
   'AEMeteringSegments' => '自動露出測光値',
   'AEMinAperture' => 'AE最小絞り',
   'AEMinExposureTime' => 'AE最小露出時間',
   'AEProgramMode' => {
      Description => 'AEプログラムモード',
      PrintConv => {
        'Av, B or X' => 'Av, BかX',
        'Candlelight' => 'キャンドルライト',
        'DOF Program' => '深度優先プログラム',
        'DOF Program (P-Shift)' => '深度優先プログラム（Pシフト）',
        'Hi-speed Program' => '高速優先プログラム',
        'Hi-speed Program (P-Shift)' => '高速優先プログラム（Pシフト）',
        'Kids' => 'キッズ',
        'Landscape' => '風景',
        'M, P or TAv' => 'M, PかTAv',
        'MTF Program' => 'MTF優先プログラム',
        'MTF Program (P-Shift)' => 'MTF優先プログラム（Pシフト）',
        'Macro' => 'マクロ',
        'Museum' => 'ミュージアム',
        'Night Scene' => '夜景',
        'Night Scene Portrait' => '人物、夜景',
        'No Flash' => 'フラッシュ無し',
        'Pet' => 'ペット',
        'Portrait' => 'ポートレート',
        'Sport' => 'スポーツ',
        'Standard' => 'スタンダード',
        'Sunset' => '夕日',
        'Surf & Snow' => 'サーフ＆スノー',
        'Sv or Green Mode' => 'Svかグリーンモード',
        'Text' => 'テキスト',
      },
    },
   'AESetting' => {
      Description => '自動露出設定',
      PrintConv => {
        'Exposure Compensation' => '露出補正',
      },
    },
   'AEXv' => 'AE 露出補正',
   'AE_ISO' => 'AE ISO感度',
   'AF-CPrioritySelection' => {
      Description => 'AF-Cプライオリティー選択',
      PrintConv => {
        'Focus' => 'フォーカス',
        'Release' => 'レリーズ',
        'Release + Focus' => 'レリーズ+フォーカス',
      },
    },
   'AF-OnForMB-D10' => {
      Description => 'MB-D10用AFオン',
      PrintConv => {
        'AE Lock (hold)' => 'AEロック（ホールド）',
        'AE Lock (reset on release)' => 'AEロック（レリーズ時リセット）',
        'AE Lock Only' => 'AEロックのみ',
        'AE/AF Lock' => 'AE/AFロック',
        'AF Lock Only' => 'AFロックのみ',
        'AF-On' => 'AFオン',
        'Same as FUNC Button' => 'ファンクションボタンと同一',
      },
    },
   'AF-SPrioritySelection' => {
      Description => 'AF-Sプライオリティー選択',
      PrintConv => {
        'Focus' => 'フォーカス',
        'Release' => 'レリーズ',
      },
    },
   'AFActivation' => {
      Description => 'AFアクティベーション',
      PrintConv => {
        'AF-On Only' => 'AFオンのみ',
        'Shutter/AF-On' => 'シャッター/AFオン',
      },
    },
   'AFAdjustment' => 'AF微調整',
   'AFArea' => 'AFエリア',
   'AFAreaHeight' => 'AFエリア高さ',
   'AFAreaHeights' => 'AFエリア高さ',
   'AFAreaIllumination' => {
      Description => 'AFエリアイルミネーション',
      PrintConv => {
        'Auto' => 'オート',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AFAreaMode' => {
      Description => 'AFエリアモード',
      PrintConv => {
        '1-area' => '１点',
        '1-area (high speed)' => '高速１点',
        '3-area (center)?' => '３点中央？',
        '3-area (left)?' => '３点左？',
        '3-area (right)?' => '３点右？',
        '5-area' => '５点',
        'Auto-area' => '自動エリアAF',
        'Dynamic Area' => 'ダイナミックエリア',
        'Dynamic Area (closest subject)' => 'ダイナミック（重点主題）',
        'Dynamic Area (wide)' => 'ダイナミック（ワイド）',
        'Face Detect AF' => '顔優先',
        'Group Dynamic' => 'グループダイナミック',
        'Normal?' => 'ノーマル？',
        'Single Area' => 'シングルポイント',
        'Single Area (wide)' => 'シングルポイント（ワイド）',
        'Spot Focusing' => 'スポットフォーカス',
        'Spot Mode On' => 'スポットモードオン',
      },
    },
   'AFAreaModeSetting' => {
      Description => 'AFエリアモード',
      PrintConv => {
        'Closest Subject' => 'オートエリア',
        'Dynamic Area' => 'ダイナミックエリア',
        'Single Area' => 'シングルポイント',
      },
    },
   'AFAreaWidth' => 'AFエリア幅',
   'AFAreaWidths' => 'AFエリア幅',
   'AFAreas' => 'AFエリア',
   'AFAssist' => {
      Description => 'AFアシスト',
      PrintConv => {
        'Does not emit/Fires' => 'しない/する',
        'Emits/Does not fire' => 'する/しない',
        'Emits/Fires' => 'する/する',
        'Off' => 'オフ',
        'On' => 'オン',
        'Only ext. flash emits/Fires' => '外部ストロボのみする/する',
      },
    },
   'AFAssistBeam' => {
      Description => 'AF補助光の投光',
      PrintConv => {
        'Does not emit' => 'しない',
        'Emits' => 'する',
        'Only ext. flash emits' => '外部ストロボのみする',
      },
    },
   'AFDefocus' => 'AFぼけ量',
   'AFDuringLiveView' => {
      Description => 'ライブビュー撮影中のAF',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
        'Live mode' => 'ライブモード',
        'Quick mode' => 'クイックモード',
      },
    },
   'AFFineTune' => 'AFファインチューン',
   'AFFineTuneAdj' => 'AFファインチューン',
   'AFImageHeight' => 'AF画像高さ',
   'AFImageWidth' => 'AF画像幅',
   'AFInfo' => 'AFモード',
   'AFInfo2' => 'AF情報',
   'AFInfo2Version' => 'AF情報バージョン',
   'AFIntegrationTime' => 'AF集積時間',
   'AFMicroadjustment' => {
      Description => 'AFマイクロアジャストメント',
      PrintConv => {
        'Adjust all by same amount' => '全レンズ一律調整',
        'Adjust by lens' => 'レンズごとに調整',
        'Disable' => 'しない',
      },
    },
   'AFMode' => 'AFモード',
   'AFOnAELockButtonSwitch' => {
      Description => 'AF-ON/AEロックボタン入替',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'AFPoint' => {
      Description => 'AF選択ポイント',
      PrintConv => {
        'Auto AF point selection' => 'オートAFポイント選択',
        'Bottom' => '下',
        'Center' => '中央',
        'Face Detect' => '顔認識',
        'Left' => '左',
        'Manual AF point selection' => 'マニュアルAFポイント選択',
        'Mid-left' => '中央左',
        'Mid-right' => '中央右',
        'None' => '無し',
        'None (MF)' => '無し（MF）',
        'Right' => '右',
        'Top' => '上',
      },
    },
   'AFPointActivationArea' => {
      Description => 'AFフレームの領域拡大',
      PrintConv => {
        'Standard' => 'スタンダード',
      },
    },
   'AFPointAreaExpansion' => {
      Description => '任意選択時のAFフレーム領域拡大',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
        'Left/right AF points' => 'する(左右1領域アシスト有効)',
        'Surrounding AF points' => 'する(周囲1領域アシスト有効)',
      },
    },
   'AFPointAutoSelection' => {
      Description => 'AFフレーム自動選択の選択可否',
      PrintConv => {
        'Control-direct:disable/Main:disable' => 'サブ電子ダイヤル直接:不可/メイン電子ダイヤル→不可',
        'Control-direct:disable/Main:enable' => 'サブ電子ダイヤル直接:不可/メイン電子ダイヤル→可',
        'Control-direct:enable/Main:enable' => 'サブ電子ダイヤル直接:可/メイン電子ダイヤル→可',
      },
    },
   'AFPointBrightness' => {
      Description => 'AFフレーム点灯輝度',
      PrintConv => {
        'Brighter' => '明るい',
        'Normal' => '標準',
      },
    },
   'AFPointDisplayDuringFocus' => {
      Description => '測距時のAFフレーム表示',
      PrintConv => {
        'Off' => 'しない',
        'On' => 'する',
        'On (when focus achieved)' => 'する(合焦時)',
      },
    },
   'AFPointIllumination' => {
      Description => 'AFポイントイルミネーション',
      PrintConv => {
        'Auto' => 'オート',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AFPointMode' => {
      Description => 'AF測距点モード',
      PrintConv => {
        'Auto' => 'オート',
      },
    },
   'AFPointRegistration' => {
      Description => 'AFフレームの登録',
      PrintConv => {
        'Automatic' => 'オート',
        'Bottom' => '下',
        'Center' => '中央',
        'Extreme Left' => '左端',
        'Extreme Right' => '右端',
        'Left' => '左',
        'Right' => '右',
        'Top' => '上',
      },
    },
   'AFPointSelected' => {
      Description => 'AF測距点',
      PrintConv => {
        'Auto' => 'オート',
        'Automatic Tracking AF' => '自動追尾',
        'Bottom' => '下',
        'Center' => '中央',
        'Face Detect AF' => '顔認識',
        'Fixed Center' => '中央固定',
        'Left' => '左',
        'Lower-left' => '左下',
        'Lower-right' => '右下',
        'Mid-left' => '中央左',
        'Mid-right' => '中央右',
        'Right' => '右',
        'Top' => '上',
        'Upper-left' => '左上',
        'Upper-right' => '右上',
      },
    },
   'AFPointSelected2' => {
      Description => 'AF測距点選択2',
      PrintConv => {
        'Auto' => 'オート',
      },
    },
   'AFPointSelection' => {
      Description => 'AFポイント選択',
      PrintConv => {
        '11 Points' => '11点',
        '51 Points' => '51点（3Dトラッキング）',
      },
    },
   'AFPointSelectionMethod' => {
      Description => 'AFフレーム選択方法',
      PrintConv => {
        'Multi-controller direct' => 'マルチコントローラーダイレクト',
        'Normal' => '標準',
        'Quick Control Dial direct' => 'サブ電子ダイヤルダイレクト',
      },
    },
   'AFPointSpotMetering' => 'AFフレーム数／スポット測光',
   'AFPoints' => 'AFポイント',
   'AFPointsInFocus' => {
      Description => 'AF測距点',
      PrintConv => {
        'All' => '全て',
        'Bottom' => '下',
        'Bottom, Center' => '下+中央',
        'Bottom-center' => '中央下',
        'Bottom-left' => '左下',
        'Bottom-right' => '右下',
        'Center' => '中央',
        'Center (horizontal)' => '中央（水平）',
        'Center (vertical)' => '中央（水平）',
        'Center+Right' => '中央+右',
        'Fixed Center or Multiple' => '中央固定または複数',
        'Left' => '左',
        'Left+Center' => '左+中央',
        'Left+Right' => '左+右',
        'Lower-left, Bottom' => '左下+下',
        'Lower-left, Mid-left' => '左下+中央左',
        'Lower-right, Bottom' => '右下+下',
        'Lower-right, Mid-right' => '右下+中央右',
        'Mid-left' => '中央左',
        'Mid-left, Center' => '中央左+中央',
        'Mid-right' => '中央右',
        'Mid-right, Center' => '中央右+中央',
        'None' => '無し',
        'None (MF)' => '無し（MF）',
        'Right' => '右',
        'Top' => '上',
        'Top, Center' => '上+中央',
        'Top-center' => '中央上',
        'Top-left' => '左上',
        'Top-right' => '右上',
        'Upper-left, Mid-left' => '左上+中央左',
        'Upper-left, Top' => '左上+上',
        'Upper-right, Mid-right' => '右上+中央右',
        'Upper-right, Top' => '右上+上',
      },
    },
   'AFPointsInFocus1D' => 'AF測距点(1D)',
   'AFPointsInFocus5D' => 'AF測距点',
   'AFPointsSelected' => 'AFポイント選択',
   'AFPointsUnknown2' => {
      Description => 'AF測距点 未確認2？',
      PrintConv => {
        'Auto' => 'オート',
      },
    },
   'AFPointsUsed' => {
      Description => 'AF測距点',
      PrintConv => {
        'Bottom' => '下',
        'Center' => '中央',
        'Mid-left' => '中央左',
        'Mid-right' => '中央右',
        'Top' => '上',
      },
    },
   'AFPredictor' => 'AF予測',
   'AFResponse' => 'AFレスポンス',
   'AFResult' => 'AF結果',
   'AFSearch' => {
      Description => 'AFサーチ',
      PrintConv => {
        'Not Ready' => '準備ができていない',
        'Ready' => '準備完了',
      },
    },
   'AIServoContinuousShooting' => 'AI SERVO 連続撮影・撮影速度優先',
   'AIServoImagePriority' => {
      Description => 'AIサーボ1コマ目/2コマ目以降動作',
      PrintConv => {
        '1: AF, 2: Drive speed' => 'ピント優先/撮影速度優先',
        '1: AF, 2: Tracking' => 'ピント優先/被写体追従優先',
        '1: Release, 2: Drive speed' => 'レリーズ優先/撮影速度最優先',
      },
    },
   'AIServoTrackingMethod' => {
      Description => 'AIサーボ時の測距点選択特性',
      PrintConv => {
        'Continuous AF track priority' => '測距連続性優先',
        'Main focus point priority' => '測距中心優先',
      },
    },
   'AIServoTrackingSensitivity' => {
      Description => 'AIサーボ時の被写体追従敏感度',
      PrintConv => {
        'Fast' => '速い',
        'Slow' => '遅い',
        'Standard' => 'スタンダード',
      },
    },
   'APEVersion' => 'APEバージョン',
   'ARMIdentifier' => 'ARM識別子',
   'ARMVersion' => 'ARMバージョン',
   'AToB0' => 'AからB0',
   'AToB1' => 'AからB1',
   'AToB2' => 'AからB2',
   'AccessoryType' => 'アクセサリータイプ',
   'ActionAdvised' => '動作推奨',
   'ActiveArea' => 'アクティブ領域',
   'ActiveD-Lighting' => {
      Description => 'アクティブDライティング',
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Normal' => '標準',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ActiveD-LightingMode' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Normal' => '標準',
        'Off' => 'オフ',
      },
    },
   'AddAspectRatioInfo' => {
      Description => 'アスペクト比情報の付加',
      PrintConv => {
        'Off' => 'オフ',
      },
    },
   'AddOriginalDecisionData' => {
      Description => 'オリジナル画像判定用データの付加',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AdjustmentMode' => '調整モード',
   'AdultContentWarning' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'AdvancedRaw' => {
      Description => 'アドバンスRAW',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AdvancedSceneMode' => {
      PrintConv => {
        'Auto' => 'インテリジェントオート',
      },
    },
   'Album' => 'アルバム',
   'AlphaByteCount' => 'アルファバイト数',
   'AlphaDataDiscard' => {
      Description => 'アルファデータ破棄',
      PrintConv => {
        'Flexbits Discarded' => 'フレックスビット破棄',
        'Full Resolution' => '完全な解像度',
        'HighPass Frequency Data Discarded' => 'ハイパス周波数データ破棄',
        'Highpass and LowPass Frequency Data Discarded' => 'ハイパスとローパス周波数データ破棄',
      },
    },
   'AlphaOffset' => 'アルファオフセット',
   'AnalogBalance' => 'アナログバランス',
   'Annotations' => 'フォトショップ注釈',
   'Anti-Blur' => {
      PrintConv => {
        'Off' => 'オフ',
        'On (Continuous)' => 'オン（連写）',
        'On (Shooting)' => 'オン（撮影）',
        'n/a' => '該当無し',
      },
    },
   'AntiAliasStrength' => 'カメラのアンチエイリアスフィルタの相対的な強度',
   'Aperture' => '絞り',
   'ApertureRange' => {
      Description => '絞り数値の制御範囲の設定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ApertureRingUse' => {
      Description => '絞りリングの使用',
      PrintConv => {
        'Permitted' => '許可',
        'Prohibited' => '禁止',
      },
    },
   'ApertureValue' => '絞り',
   'ApplicationRecordVersion' => 'アプリケーションレコードバージョン',
   'ApplyShootingMeteringMode' => {
      Description => '撮影・測光モードの呼出',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'Artist' => '画像作成者',
   'AsShotICCProfile' => '撮影時ICCプロファイル',
   'AsShotNeutral' => 'ニュートラルショット',
   'AsShotPreProfileMatrix' => '撮影時プロファイルマトリックス',
   'AsShotProfileName' => '撮影時プロフィール名',
   'AsShotWhiteXY' => 'ホワイトX-Yショット',
   'AssignFuncButton' => {
      Description => 'FUNC.ボタンの機能',
      PrintConv => {
        'Exposure comp./AEB setting' => '露出補正／AEB設定',
        'Image jump with main dial' => 'メイン電子ダイヤル での画像送り',
        'Image quality' => '記録画質選択',
        'LCD brightness' => '液晶の明るさ',
        'Live view function settings' => 'ライブビュー機能設定',
      },
    },
   'AssistButtonFunction' => {
      Description => 'アシストボタンの機能',
      PrintConv => {
        'Av+/- (AF point by QCD)' => 'Av±（サブ電子：AFフレーム選択）',
        'FE lock' => 'FEロック',
        'Normal' => '標準',
        'Select HP (while pressing)' => 'HPに移動（押している間）',
        'Select Home Position' => 'HPに移動',
      },
    },
   'Audio' => {
      Description => '音声',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'AudioDuration' => 'オーディオ時間',
   'AudioOutcue' => 'オーディオ終了合図',
   'AudioSamplingRate' => 'オーディオサンプリングレート',
   'AudioSamplingResolution' => 'オーディオサンプリング解像度',
   'AudioType' => 'オーディオタイプ',
   'Author' => '作者',
   'AuthorsPosition' => '役職名',
   'AutoAperture' => {
      Description => '自動絞り',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoBracket' => 'オートブラケット',
   'AutoBracketModeM' => {
      Description => 'オートブラケット(モードM)',
      PrintConv => {
        'Flash Only' => 'フラッシュのみ',
        'Flash/Aperture' => 'フラッシュ/絞り',
        'Flash/Speed' => 'フラッシュ/シャッター速度',
        'Flash/Speed/Aperture' => 'フラッシュ/シャッター速度/絞り',
      },
    },
   'AutoBracketOrder' => 'ブラケット順',
   'AutoBracketSet' => {
      Description => 'オートブラケット設定',
      PrintConv => {
        'AE & Flash' => '自動露出＆フラッシュ',
        'AE Only' => '自動露出のみ',
        'Flash Only' => 'フラッシュのみ',
        'WB Bracketing' => 'ホワイトバランスブラケット',
      },
    },
   'AutoBracketing' => {
      Description => 'オートブラケット',
      PrintConv => {
        'No flash & flash' => 'フラッシュ無し＆フラッシュ有り',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoExposureBracketing' => {
      Description => 'フラッシュバイアス',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
        'On (shot 1)' => 'オン（ショット1）',
        'On (shot 2)' => 'オン（ショット2）',
        'On (shot 3)' => 'オン（ショット3）',
      },
    },
   'AutoFP' => {
      Description => 'オートFP',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoFocus' => {
      Description => 'オートフォーカス',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoISO' => {
      Description => 'ISOオート',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoISOMax' => 'ISOオート 最大感度',
   'AutoISOMinShutterSpeed' => 'ISOオート 最小シャッター速度',
   'AutoLightingOptimizer' => {
      Description => 'オートライティングオプティマイザ',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
        'Low' => 'ソフト',
        'Off' => 'オフ',
        'Standard' => 'スタンダード',
        'Strong' => '強',
        'n/a' => '該当無し',
      },
    },
   'AutoLightingOptimizerOn' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'AutoRedEye' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'AutoRotate' => {
      Description => '自動回転',
      PrintConv => {
        'None' => '無し',
        'Rotate 180' => '180度回転',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
        'n/a' => 'ソフトウェアで回転',
      },
    },
   'AuxiliaryLens' => '補助レンズ',
   'AvApertureSetting' => 'Av絞り設定',
   'AvSettingWithoutLens' => {
      Description => 'レンズ未装着時の絞り数値設定',
      PrintConv => {
        'Disable' => '不可',
        'Enable' => '可',
      },
    },
   'BToA0' => 'BからA0',
   'BToA1' => 'BからA1',
   'BToA2' => 'BからA2',
   'BWFilter' => '白黒フィルター',
   'BWMode' => {
      Description => '白黒モード',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'BabyAge' => '赤ちゃん/ペットの年齢',
   'BackgroundColorIndicator' => '背景色指標',
   'BackgroundColorValue' => '背景色値',
   'BackgroundTiling' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'BadFaxLines' => '粗悪なFAX線',
   'BannerImageType' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'BaseExposureCompensation' => '基本露出補正',
   'BaseISO' => 'ベース感度',
   'BaselineExposure' => 'ベースライン露出',
   'BaselineNoise' => 'ベースラインノイズ',
   'BaselineSharpness' => 'ベースラインシャープネス',
   'BatteryInfo' => '電源',
   'BatteryLevel' => 'バッテリーレベル',
   'BatteryOrder' => {
      Description => 'バッテリー順',
      PrintConv => {
        'Camera Battery First' => 'カメラのバッテリーを最初に使う',
        'MB-D10 First' => 'MB-D10のバッテリーを最初に使う',
      },
    },
   'BayerGreenSplit' => 'ベイヤーグリーン分割',
   'Beep' => {
      Description => 'ビープ',
      PrintConv => {
        'High' => '高い',
        'Low' => '低い',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'BestQualityScale' => '高品質スケール',
   'BestShotMode' => {
      Description => 'ベストショットモード',
      PrintConv => {
        'Off' => 'オフ',
      },
    },
   'BitDepth' => 'ビット深度',
   'BitsPerComponent' => 'コンポーネントあたりビット',
   'BitsPerExtendedRunLength' => '拡張ランレングスあたりのビット',
   'BitsPerRunLength' => 'ランレングスあたりのビット',
   'BitsPerSample' => 'コンポーネントのビット数',
   'BlackLevel' => '黒レベル',
   'BlackLevel2' => '黒レベル2',
   'BlackLevelDeltaH' => '黒レベルデルタH',
   'BlackLevelDeltaV' => '黒レベルデルタV',
   'BlackLevelRepeatDim' => '黒レベル反復値',
   'BlackPoint' => '黒点',
   'BlueBalance' => 'ブルーバランス',
   'BlueMatrixColumn' => '青色マトリックス列',
   'BlueTRC' => '青色調増殖曲線',
   'BlurWarning' => {
      Description => '手振れ警告',
      PrintConv => {
        'Blur Warning' => '手振れ警告',
        'None' => '無し',
      },
    },
   'BodyBatteryADLoad' => '電源A/D本体起動時',
   'BodyBatteryADNoLoad' => '電源A/D本体オフ時',
   'BodyBatteryState' => '電源状態本体',
   'BodyFirmwareVersion' => '本体ファームウェアバージョン',
   'BracketMode' => {
      Description => 'ブラケットモード',
      PrintConv => {
        'Off' => 'オフ',
      },
    },
   'BracketSequence' => 'ブラケットシーケンス',
   'BracketShotNumber' => {
      Description => 'ブラケットショット数',
      PrintConv => {
        'n/a' => '該当無し',
      },
    },
   'BracketStep' => {
      Description => 'ブラケットステップ',
      PrintConv => {
        '1 EV' => '1ステップ',
        '1/3 EV' => '1/3ステップ',
        '2/3 EV' => '2/3ステップ',
      },
    },
   'BracketValue' => 'ブラケット値',
   'Brightness' => 'ブライトネス',
   'BrightnessData' => 'ブライトネスデータ',
   'BrightnessValue' => 'ブライトネス',
   'BulbDuration' => 'バルブ時間',
   'BurstMode' => {
      Description => 'ブラストモード',
      PrintConv => {
        'Infinite' => '無限',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ButtonFunctionControlOff' => {
      Description => 'サブ電子ダイヤル〈OFF〉時のボタン操作',
      PrintConv => {
        'Disable main, Control, Multi-control' => 'メイン電子ダイヤル、サブ電子ダイヤル、マルチコントローラーは無効',
        'Normal (enable)' => '通常(有効)',
      },
    },
   'By-line' => '製作者',
   'By-lineTitle' => '製作者の職種',
   'CCDScanMode' => {
      Description => 'CCDスキャンモード',
      PrintConv => {
        'Interlaced' => 'インタレース',
        'Progressive' => 'プログレッシブ',
      },
    },
   'CFALayout' => 'CFAレイアウト',
   'CFAPattern' => 'CFAパターン',
   'CFAPattern2' => 'CFAパターン2',
   'CFAPlaneColor' => 'CFAプレーン色',
   'CFARepeatPatternDim' => 'CFA反復パターン特性',
   'CLModeShootingSpeed' => 'CLモード撮影速度',
   'CMContrast' => 'CMコントラスト',
   'CMExposureCompensation' => 'CM露出補正',
   'CMHue' => 'CM色相',
   'CMMFlags' => 'CMMフラグ',
   'CMSaturation' => 'CM彩度',
   'CMSharpness' => 'CMシャープネス',
   'CMWhiteBalance' => 'CMホワイトバランス',
   'CMWhiteBalanceComp' => 'CMホワイトバランス補正',
   'CMWhiteBalanceGrayPoint' => 'CMホワイトバランスグレーポイント',
   'CMYKEquivalent' => 'CMYK等価物',
   'CPUFirmwareVersion' => 'CPUファームウエアバージョン',
   'CPUType' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'CalibrationDateTime' => 'キャリブレーション日時',
   'CalibrationIlluminant1' => {
      Description => '光源キャリブレーション1',
      PrintConv => {
        'Cloudy' => '曇り',
        'Cool White Fluorescent' => '白色蛍光灯',
        'Day White Fluorescent' => '昼白色蛍光灯',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Fine Weather' => '良い天気',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'ISO Studio Tungsten' => 'ISOスタジオタングステン',
        'Other' => 'その他の光源',
        'Shade' => '日陰',
        'Standard Light A' => '標準ライトA',
        'Standard Light B' => '標準ライトB',
        'Standard Light C' => '標準ライトC',
        'Tungsten (Incandescent)' => 'タングステン(白熱灯)',
        'Unknown' => '不明',
        'Warm White Fluorescent' => '暖白光色蛍光灯',
        'White Fluorescent' => '温白色蛍光灯',
      },
    },
   'CalibrationIlluminant2' => {
      Description => '光源キャリブレーション2',
      PrintConv => {
        'Cloudy' => '曇り',
        'Cool White Fluorescent' => '白色蛍光灯',
        'Day White Fluorescent' => '昼白色蛍光灯',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Fine Weather' => '良い天気',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'ISO Studio Tungsten' => 'ISOスタジオタングステン',
        'Other' => 'その他の光源',
        'Shade' => '日陰',
        'Standard Light A' => '標準ライトA',
        'Standard Light B' => '標準ライトB',
        'Standard Light C' => '標準ライトC',
        'Tungsten (Incandescent)' => 'タングステン(白熱灯)',
        'Unknown' => '不明',
        'Warm White Fluorescent' => '暖白光色蛍光灯',
        'White Fluorescent' => '温白色蛍光灯',
      },
    },
   'CameraCalibration1' => 'カメラキャリブレーション1',
   'CameraCalibration2' => 'カメラキャリブレーション2',
   'CameraCalibrationSig' => 'カメラキャリブレーションサイン',
   'CameraID' => 'カメラID',
   'CameraISO' => 'カメラISO',
   'CameraInfo' => 'ペンタックスモデル',
   'CameraOrientation' => {
      Description => '画像の向き',
      PrintConv => {
        'Horizontal (normal)' => '水平（標準）',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
      },
    },
   'CameraParameters' => 'カメラパラメーター',
   'CameraSerialNumber' => 'カメラシリアル番号',
   'CameraSettings' => 'カメラ設定',
   'CameraSettingsVersion' => 'カメラ設定バージョン',
   'CameraTemperature' => 'カメラ温度',
   'CameraType' => {
      Description => 'カメラタイプ',
      PrintConv => {
        'Compact' => 'コンパクト',
        'DV Camera' => 'DVカメラ',
        'EOS High-end' => 'EOSハイエンド',
        'EOS Mid-range' => 'EOSミドルレンジ',
      },
    },
   'CameraType2' => 'カメラタイプ2',
   'CanonAFInfo' => 'AF情報',
   'CanonAFInfo2' => 'AF情報2',
   'CanonExposureMode' => {
      Description => '露出モード',
      PrintConv => {
        'Aperture-priority AE' => '絞り優先',
        'Bulb' => 'バルブ',
        'Depth-of-field AE' => '被写界深度AE',
        'Easy' => '簡単',
        'Manual' => 'マニュアル',
        'Program AE' => 'プログラムAE',
        'Shutter speed priority AE' => 'シャッター優先',
      },
    },
   'CanonFileInfo' => 'ファイル情報',
   'CanonFileLength' => 'ファイル長',
   'CanonFirmwareVersion' => 'ファームウェアバージョン',
   'CanonFlashMode' => {
      Description => 'フラッシュモード',
      PrintConv => {
        'Auto' => 'オート',
        'External flash' => '外付フラッシュ',
        'Off' => 'オフ',
        'On' => 'オン',
        'Red-eye reduction' => '赤目軽減',
        'Red-eye reduction (Auto)' => '赤目軽減（オート）',
        'Red-eye reduction (On)' => '赤目軽減（オン）',
        'Slow-sync' => 'スローシンクロ',
      },
    },
   'CanonFocalLength' => 'フォーカスタイプ',
   'CanonImageHeight' => '画像高さ',
   'CanonImageSize' => {
      Description => 'イメージサイズ',
      PrintConv => {
        'Large' => 'ラージ',
        'Medium' => 'ミドル',
        'Medium 1' => 'ミドル1',
        'Medium 2' => 'ミドル2',
        'Medium 3' => 'ミドル3',
        'Medium Movie' => 'ミディアム動画',
        'Postcard' => 'ハガキ',
        'Small' => 'スモール',
        'Small 1' => 'スモール1',
        'Small 2' => 'スモール2',
        'Small 3' => 'スモール3',
        'Small Movie' => 'スモール動画',
        'Widescreen' => 'ワイド画面',
      },
    },
   'CanonImageType' => 'イメージタイプ',
   'CanonImageWidth' => '画像幅',
   'CanonModelID' => 'モデルID',
   'Caption-Abstract' => '表題/説明',
   'CaptionWriter' => 'キャプション作成者',
   'CasioImageSize' => 'カシオイメージサイズ',
   'Categories' => 'カテゴリー',
   'Category' => 'カテゴリー',
   'CellLength' => 'セル長',
   'CellWidth' => 'セル幅',
   'CenterAFArea' => {
      Description => '中央AFエリア',
      PrintConv => {
        'Normal Zone' => 'ノーマルゾーン',
        'Wide Zone' => 'ワイドゾーン',
      },
    },
   'CenterWeightedAreaSize' => {
      Description => '中央重点エリア',
      PrintConv => {
        'Average' => '平均',
      },
    },
   'CharTarget' => '目的文字',
   'CharacterSet' => 'キャラクターセット',
   'ChromaBlurRadius' => '彩度ぼけ半径',
   'ChromaticAdaptation' => '色彩順応化',
   'Chromaticity' => '色度',
   'ChrominanceNR_TIFF_JPEG' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Off' => 'オフ',
      },
    },
   'ChrominanceNoiseReduction' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Off' => 'オフ',
      },
    },
   'City' => '都市',
   'ClassifyState' => '分類状態',
   'CleanFaxData' => '純粋なFAXデータ',
   'ClipPath' => 'クリップパス',
   'CodedCharacterSet' => 'キャラクタセットコード',
   'ColorAberrationControl' => {
      Description => '色収差コントロール',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ColorAdjustment' => '色調整',
   'ColorAdjustmentMode' => {
      Description => '色調整モード',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ColorBalance' => 'カラーバランス',
   'ColorBalanceAdj' => {
      Description => 'カラーバランス調整',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ColorBalanceBlue' => 'カラーバランス青',
   'ColorBalanceGreen' => 'カラーバランス緑',
   'ColorBalanceRed' => 'カラーバランス赤',
   'ColorBoostData' => 'カラーブーストデータ',
   'ColorBoostLevel' => 'カラーブーストレベル1',
   'ColorBoostType' => {
      Description => 'カラーブーストタイプ',
      PrintConv => {
        'Nature' => '自然',
        'People' => '人々',
      },
    },
   'ColorBooster' => {
      Description => 'カラーブースター',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ColorCalibrationMatrix' => 'カラーキャリブレーションマトリックステーブル',
   'ColorCharacterization' => 'カラー特徴描写',
   'ColorControl' => 'カラーコントロール',
   'ColorEffect' => {
      Description => 'カラーエフェクト',
      PrintConv => {
        'Black & White' => '白黒',
        'Cool' => '冷色',
        'Off' => 'オフ',
        'Sepia' => 'セピア',
        'Warm' => '暖色',
      },
    },
   'ColorFilter' => {
      Description => 'カラーフィルター',
      PrintConv => {
        'Black & White' => '白黒',
        'Blue' => '青',
        'Green' => '緑',
        'Off' => 'オフ',
        'Pink' => 'ピンク',
        'Purple' => '紫',
        'Red' => '赤',
        'Sepia' => 'セピア',
        'Yellow' => '黄色',
      },
    },
   'ColorGain' => 'カラーゲイン',
   'ColorHue' => '色相',
   'ColorInfo' => '色情報',
   'ColorMap' => 'カラーマップ',
   'ColorMatrix' => 'カラーマトリックス',
   'ColorMatrix1' => 'カラーマトリックス1',
   'ColorMatrix2' => 'カラーマトリックス2',
   'ColorMatrixNumber' => 'カラーマトリックス番号',
   'ColorMode' => {
      Description => 'カラーモード',
      PrintConv => {
        'Autumn Leaves' => '紅葉',
        'B & W' => '白黒',
        'B&W' => '白黒',
        'Black & White' => '白黒',
        'Chrome' => 'クローム',
        'Clear' => 'クリアー',
        'Deep' => 'ディープ',
        'Evening' => '夕焼け',
        'Landscape' => '風景',
        'Light' => 'ライト',
        'Natural' => 'ナチュラル',
        'Natural color' => 'ナチュラルカラー',
        'Natural sRGB' => 'ナチュラル sRGB',
        'Natural+ sRGB' => 'ナチュラル+ sRGB',
        'Neutral' => 'ニュートラル',
        'Night Portrait' => '人物夜景',
        'Night Scene' => '夜景',
        'Night View' => 'ナイトビュー',
        'Night View/Portrait' => '夜景/夜景ポートレート',
        'Normal' => 'ノーマル',
        'Off' => 'オフ',
        'Portrait' => 'ポートレート',
        'Sepia' => 'セピア',
        'Solarization' => 'ソラリゼーション',
        'Standard' => 'スタンダード',
        'Sunset' => '夕日',
        'Vivid' => 'ビビッド',
        'Vivid color' => 'ビビッドカラー',
      },
    },
   'ColorMoireReduction' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ColorMoireReductionMode' => {
      Description => '色モアレリダクション',
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Off' => 'オフ',
      },
    },
   'ColorPalette' => 'カラーパレット',
   'ColorProfile' => {
      Description => 'カラープロフィール',
      PrintConv => {
        'Embedded' => '埋め込み',
        'Not Embedded' => '埋め込み無し',
      },
    },
   'ColorRepresentation' => '色表現',
   'ColorReproduction' => '色再現',
   'ColorResponseUnit' => '色応答単位',
   'ColorSequence' => 'カラーシーケンス',
   'ColorSpace' => {
      Description => '色空間',
      PrintConv => {
        'ICC Profile' => 'ICCプロフィール',
        'Monochrome' => 'モノトーン',
        'Uncalibrated' => '未調整',
      },
    },
   'ColorSpaceData' => 'カラースペースデータ',
   'ColorTable' => 'カラーテーブル',
   'ColorTemperature' => '色温度',
   'ColorTone' => {
      Description => 'カラートーン',
      PrintConv => {
        'Normal' => '標準',
      },
    },
   'ColorToneFaithful' => 'カラートーン忠実設定',
   'ColorToneLandscape' => 'カラートーン風景',
   'ColorToneNeutral' => 'カラートーンニュートラル',
   'ColorTonePortrait' => 'カラートーンポートレート',
   'ColorToneStandard' => 'カラートーンスタンダード',
   'ColorToneUserDef1' => 'カラートーンユーザ設定1',
   'ColorToneUserDef2' => 'カラートーンユーザ設定2',
   'ColorToneUserDef3' => 'カラートーンユーザ設定3',
   'ColorantOrder' => '着色順',
   'ColorantTable' => '着色テーブル',
   'ColorimetricReference' => '比色分析参照',
   'CommandDials' => {
      Description => 'コマンダーダイヤル',
      PrintConv => {
        'Reversed (Main Aperture, Sub Shutter)' => 'リバース',
        'Standard (Main Shutter, Sub Aperture)' => 'デフォルト',
      },
    },
   'CommandDialsApertureSetting' => {
      Description => 'コマンドダイヤルカスタマイズ 絞り設定',
      PrintConv => {
        'Aperture Ring' => '絞りリング',
        'Sub-command Dial' => 'サブコントロールダイヤル',
      },
    },
   'CommandDialsChangeMainSub' => {
      Description => 'コマンドダイヤルカスタマイズ メイン/サブ変更',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'CommandDialsMenuAndPlayback' => {
      Description => 'コマンドダイヤルカスタマイズ メニューと再生',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'CommandDialsReverseRotation' => {
      Description => 'コマンドダイヤルカスタマイズ 回転保持',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'CommanderChannel' => 'コマンダーモード チャンネル',
   'CommanderGroupAManualOutput' => 'コマンダーモード グループA M 補正',
   'CommanderGroupAMode' => {
      Description => 'コマンダーモード グループA モード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
      },
    },
   'CommanderGroupA_TTL-AAComp' => 'コマンダーモード 内蔵フラッシュ TTL/AA 補正',
   'CommanderGroupBManualOutput' => 'コマンダーモード グループB M 補正',
   'CommanderGroupBMode' => {
      Description => 'コマンダーモード グループB モード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
      },
    },
   'CommanderGroupB_TTL-AAComp' => 'コマンダーモード グループB TTL/AA 補正',
   'CommanderInternalFlash' => {
      Description => 'コマンダーモード 内蔵フラッシュ モード',
      PrintConv => {
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
      },
    },
   'CommanderInternalManualOutput' => 'コマンダーモード 内蔵フラッシュ M 補正',
   'CommanderInternalTTLComp' => 'コマンダーモード 内蔵フラッシュ TTL 補正',
   'Comment' => 'コメント',
   'Compilation' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ComponentsConfiguration' => '各構成要素の意味',
   'CompressedBitsPerPixel' => '画像圧縮モード',
   'CompressedImageSize' => '圧縮画像サイズ',
   'Compression' => {
      Description => '圧縮計画',
      PrintConv => {
        'JPEG' => 'JPEG圧縮率',
        'JPEG (old-style)' => 'JPEG(古い形式)',
        'None' => '無し',
        'Uncompressed' => '非圧縮',
      },
    },
   'CompressionRatio' => '圧縮率',
   'CompressionType' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'ConditionalFEC' => 'フラッシュ露出補正',
   'ConnectionSpaceIlluminant' => '接続スペース光源',
   'ConsecutiveBadFaxLines' => '連続的に粗悪なFAX線',
   'Contact' => '連絡',
   'ContentLocationCode' => '内容位置コード',
   'ContentLocationName' => '内容位置名',
   'ContinuousDrive' => {
      Description => 'ドライブモード',
      PrintConv => {
        'Continuous' => '連続撮影',
        'Continuous, High' => '連写（High）',
        'Continuous, Low' => '連写（Low）',
        'Continuous, Speed Priority' => '高速連写',
        'Movie' => '動画',
        'Single' => '１コマ撮影',
      },
    },
   'ContinuousShootingSpeed' => {
      Description => '連続撮影速度',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ContinuousShotLimit' => {
      Description => '連続撮影時の撮影枚数制限',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'Contrast' => {
      Description => 'コントラスト',
      PrintConv => {
        'Film Simulation' => 'フィルムシミュレーション',
        'High' => 'ハード',
        'Low' => 'ソフト',
        'Med High' => '少し高い',
        'Med Low' => '少し低い',
        'Medium High' => '少し高い',
        'Medium Low' => '少し低い',
        'Normal' => 'スタンダード',
        'Very High' => 'かなり高い',
        'Very Low' => 'かなり低い',
      },
    },
   'ContrastCurve' => 'コントラストカーブ',
   'ContrastFaithful' => 'コントラスト忠実設定',
   'ContrastLandscape' => 'コントラスト風景',
   'ContrastMonochrome' => 'コントラストモノクロ',
   'ContrastNeutral' => 'コントラストニュートラル',
   'ContrastPortrait' => 'コントラストポートレート',
   'ContrastSetting' => 'コントラスト設定',
   'ContrastStandard' => 'コントラストスタンダード',
   'ContrastUserDef1' => 'コントラストユーザ設定1',
   'ContrastUserDef2' => 'コントラストユーザ設定2',
   'ContrastUserDef3' => 'コントラストユーザ設定3',
   'ControlMode' => {
      Description => 'コントロールモード',
      PrintConv => {
        'Camera Local Control' => 'カメラローカルコントロール',
        'Computer Remote Control' => 'コンピュータリモートコントロール',
        'n/a' => '該当無し',
      },
    },
   'ConversionLens' => {
      Description => 'コンバージョンレンズ',
      PrintConv => {
        'Macro' => 'マクロ',
        'Off' => 'オフ',
        'Telephoto' => 'テレフォト',
        'Wide' => 'ワイド',
      },
    },
   'Converter' => 'コンバーター',
   'Copyright' => '版権所有者',
   'CopyrightNotice' => '著作権表示',
   'CopyrightStatus' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'CoringFilter' => 'コアリングフィルタ',
   'CoringValues' => 'コアリング値',
   'Country' => '国名',
   'Country-PrimaryLocationCode' => 'ISO国コード',
   'Country-PrimaryLocationName' => '国',
   'CreateDate' => 'デジタルデータ作成日時',
   'CreationDate' => '作成日時',
   'CreativeStyle' => {
      Description => 'クリエイティブスタイル',
      PrintConv => {
        'Autumn' => '秋',
        'Autumn Leaves' => '紅葉',
        'B&W' => '白黒',
        'Clear' => 'クリアー',
        'Deep' => 'ディープ',
        'Landscape' => '風景',
        'Light' => 'ライト',
        'Neutral' => 'ニュートラル',
        'Night View/Portrait' => '夜景/夜景ポートレート',
        'Portrait' => 'ポートレート',
        'Sepia' => 'セピア',
        'Standard' => 'スタンダード',
        'Sunset' => '夕日',
        'Vivid' => 'ビビッド',
      },
    },
   'Creator' => '製作者',
   'CreatorAddress' => 'クリエーター　-　住所',
   'CreatorCity' => 'クリエーター　-　街',
   'CreatorCountry' => 'クリエーター　-　国',
   'CreatorPostalCode' => 'クリエーター　-　郵便番号',
   'CreatorRegion' => 'クリエーター　-　国/州',
   'CreatorWorkEmail' => 'クリエーター　-　電子メール',
   'CreatorWorkTelephone' => 'クリエーター　-　電話番号',
   'CreatorWorkURL' => 'クリエーター　-　WEBサイト',
   'Credit' => 'プロバイダー',
   'CropActive' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'CropData' => 'クロップデータ',
   'CropHeight' => '最終高さ',
   'CropHiSpeed' => 'ハイスピードクロップ',
   'CropLeft' => '開始オフセットX',
   'CropTop' => '開始オフセットY',
   'CropWidth' => '最終幅',
   'CurrentICCProfile' => 'カレントICCプロファイル',
   'CurrentPreProfileMatrix' => 'カレントプロファイルマトリックス',
   'Curves' => {
      Description => 'カーブ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Custom1' => 'カスタム1',
   'Custom2' => 'カスタム2',
   'Custom3' => 'カスタム3',
   'Custom4' => 'カスタム4',
   'CustomRendered' => {
      Description => 'カスタム画像処理',
      PrintConv => {
        'Custom' => 'カスタム処理',
        'Normal' => '標準処理',
      },
    },
   'CustomSaturation' => 'カスタム彩度',
   'D-LightingHQ' => {
      Description => 'DライティングHQ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'D-LightingHQColorBoost' => 'DライティングHQカラーブースト',
   'D-LightingHQHighlight' => 'DライティングHQハイライト',
   'D-LightingHQSelected' => {
      Description => 'DライティングHQ選択',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'D-LightingHQShadow' => 'DライティングHQシャドウ',
   'D-LightingHS' => {
      Description => 'DライティングHS',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'D-LightingHSAdjustment' => 'DライティングHS調整',
   'D-LightingHSColorBoost' => 'DライティングHSカラーブースト',
   'DECPosition' => {
      Description => 'DEC位置',
      PrintConv => {
        'Contrast' => 'コントラスト',
        'Exposure' => '露出',
        'Filter' => 'フィルター',
        'Saturation' => '彩度',
      },
    },
   'DNGBackwardVersion' => 'DNGバックワードバージョン',
   'DNGLensInfo' => 'レンズ情報',
   'DNGVersion' => 'DNGバージョン',
   'DSPFirmwareVersion' => 'DSPファームウエアバージョン',
   'DataCompressionMethod' => 'データ圧縮アルゴリズム プロバイダー/オーナー',
   'DataDump' => 'データダンプ',
   'DataImprint' => {
      Description => 'データインプリント',
      PrintConv => {
        'None' => '無し',
        'Text' => 'テキスト',
      },
    },
   'DataType' => '日付型',
   'Date' => '日付',
   'DateCreated' => '作成日付',
   'DateDisplayFormat' => {
      Description => '日付形式',
      PrintConv => {
        'D/M/Y' => '日/月/年',
        'M/D/Y' => '月/日/年',
        'Y/M/D' => '年/月/日',
      },
    },
   'DateSent' => '発送日付',
   'DateStampMode' => {
      Description => '日付スタンプモード',
      PrintConv => {
        'Date' => '日付',
        'Off' => 'オフ',
      },
    },
   'DateTime' => 'ファイル作成日時',
   'DateTimeOriginal' => 'オリジナルデータ作成日時',
   'DaylightSavings' => {
      Description => '夏時間',
      PrintConv => {
        'No' => 'オフ',
        'Yes' => 'オン',
      },
    },
   'DefaultCropOrigin' => 'デフォルト切取り基点',
   'DefaultCropSize' => 'デフォルト切取りサイズ',
   'DefaultScale' => 'デフォルトスケール',
   'DeletedImageCount' => '削除イメージカウント',
   'Description' => '説明',
   'Destination' => '宛先',
   'DestinationCity' => '目的地',
   'DestinationCityCode' => '目的地コード',
   'DestinationDST' => {
      Description => '目的地DST',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'DevelopmentDynamicRange' => '進化ダイナミックレンジ',
   'DeviceAttributes' => '機器属性',
   'DeviceManufacturer' => '機器メーカー',
   'DeviceMfgDesc' => '機器メーカー説明',
   'DeviceModel' => '機器モデル',
   'DeviceModelDesc' => '機器モデル説明',
   'DeviceSettingDescription' => 'デバイス設定の説明',
   'DialDirectionTvAv' => {
      Description => 'Tv/Av値設定時のダイヤル回転',
      PrintConv => {
        'Normal' => '通常',
        'Reversed' => '設定方向を反転',
      },
    },
   'DigitalCreationDate' => 'デジタル作成日付',
   'DigitalCreationTime' => 'デジタル作成時間',
   'DigitalGEM' => 'デジタルGEM',
   'DigitalICE' => 'デジタルICE',
   'DigitalROC' => 'デジタルROC',
   'DigitalZoom' => {
      Description => 'デジタルズーム',
      PrintConv => {
        'None' => '無し',
        'Off' => 'オフ',
        'Other' => '未確認',
      },
    },
   'DigitalZoomOn' => {
      Description => 'デジタルズームオン',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'DigitalZoomRatio' => 'デジタルズーム比率',
   'Directory' => 'ファイルの場所',
   'DirectoryIndex' => 'ディレクトリ索引',
   'DirectoryNumber' => 'ディレクトリ番号',
   'DisplayAperture' => '絞り表示',
   'DisplaySize' => {
      PrintConv => {
        'Normal' => '標準',
      },
    },
   'DistortionCorrection' => {
      Description => '歪曲修正',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'DistortionCorrection2' => {
      Description => '歪曲補正編集',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'DjVuVersion' => 'DjVuバージョン',
   'DocumentHistory' => '文書履歴',
   'DocumentName' => 'ドキュメント名',
   'DocumentNotes' => '文書ノート',
   'DotRange' => 'ドット範囲',
   'DriveMode' => {
      Description => 'ドライブモード',
      PrintConv => {
        'Bracketing' => 'ブラケット',
        'Burst' => '高速連射',
        'Continuous' => '連続撮影',
        'Continuous High' => '連射 (Hi)',
        'Continuous Shooting' => '連続撮影',
        'HS continuous' => 'HS連写',
        'Interval' => 'インターバル',
        'Multiple Exposure' => '複数の露出',
        'No Timer' => 'タイマー無し',
        'Off' => 'オフ',
        'Remote Control' => 'リモコン',
        'Remote Control (3 s delay)' => 'リモコン (3秒後レリーズ)',
        'Self-timer' => 'セルフタイマー',
        'Self-timer (12 s)' => 'セルフタイマー (12秒)',
        'Self-timer (2 s)' => 'セルフタイマー (2秒)',
        'Self-timer Operation' => 'セルフタイマー',
        'Shutter Button' => 'シャッターボタン',
        'Single' => '１コマ撮影',
        'Single Exposure' => 'シングル露出',
        'Single Frame' => '１コマ撮影',
        'Single Shot' => '１コマ撮影',
        'Single-frame' => '1コマ撮影',
        'Single-frame Shooting' => '１コマ撮影',
        'UHS continuous' => 'UHS連写',
      },
    },
   'DriveMode2' => {
      Description => '多重露光',
      PrintConv => {
        'Single-frame' => '１コマ撮影',
      },
    },
   'DynamicAFArea' => {
      Description => 'ダイナミックAFエリア',
      PrintConv => {
        '21 Points' => '21点',
        '51 Points' => '51点',
        '51 Points (3D-tracking)' => '51点（3Dトラッキング）',
        '9 Points' => '9点',
      },
    },
   'DynamicRange' => {
      Description => 'ダイナミックレンジ',
      PrintConv => {
        'Standard' => 'スタンダード',
        'Wide' => 'ワイド',
      },
    },
   'DynamicRangeExpansion' => {
      Description => 'ダイナミックレンジ拡大',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'DynamicRangeOptimizer' => {
      Description => 'Dレンジオプティマイザー',
      PrintConv => {
        'Advanced Auto' => 'アドバンスオート',
        'Advanced Lv1' => 'アドバンスLv1',
        'Advanced Lv2' => 'アドバンスLv2',
        'Advanced Lv3' => 'アドバンスLv3',
        'Advanced Lv4' => 'アドバンスLv4',
        'Advanced Lv5' => 'アドバンスLv5',
        'Auto' => 'オート',
        'Off' => 'オフ',
        'Standard' => 'スタンダード',
      },
    },
   'DynamicRangeSetting' => 'ダイナミックレンジ設定',
   'E-DialInProgram' => {
      Description => '電子ダイヤルプログラム',
      PrintConv => {
        'P Shift' => 'Pシフト',
        'Tv or Av' => 'TvかAv',
      },
    },
   'ETTLII' => {
      PrintConv => {
        'Average' => '平均',
        'Evaluative' => '評価',
      },
    },
   'EVStepInfo' => 'EVステップ情報',
   'EVStepSize' => {
      Description => 'EVステップ',
      PrintConv => {
        '1/2 EV' => '1/2ステップ',
        '1/3 EV' => '1/3ステップ',
      },
    },
   'EVSteps' => {
      Description => '露出ステップ',
      PrintConv => {
        '1/2 EV Steps' => '1/2 EVステップ',
        '1/3 EV Steps' => '1/3 EVステップ',
      },
    },
   'EasyExposureCompensation' => {
      Description => '簡単な露出補正',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
        'On (auto reset)' => 'オン（自動リセット）',
      },
    },
   'EasyMode' => {
      Description => '簡単モード',
      PrintConv => {
        'Aquarium' => '水族館',
        'Beach' => 'ビーチ',
        'Black & White' => '白黒',
        'Color Accent' => 'カラーアクセント',
        'Color Swap' => 'スイッチカラー',
        'Digital Macro' => 'デジタルマクロ',
        'Fast shutter' => '高速シャッター',
        'Fireworks' => '花火',
        'Flash Off' => 'フラッシュオフ',
        'Foliage' => '葉',
        'Full auto' => 'フルオート',
        'Gray Scale' => 'グレースケール',
        'ISO 3200' => 'ISO3200',
        'Indoor' => '室内',
        'Kids & Pets' => 'キッズ＆ペット',
        'Landscape' => '風景',
        'Long Shutter' => '長秒シャッター',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'My Colors' => 'ワンポイントカラー',
        'Neutral' => 'ニュートラル',
        'Night' => '夜景',
        'Night Scene' => '夜景',
        'Night Snapshot' => 'ナイトスナップ',
        'Pan focus' => 'パンフォーカス',
        'Portrait' => 'ポートレート',
        'Sepia' => 'セピア',
        'Slow shutter' => 'スローシャッター',
        'Snow' => 'スノー',
        'Sports' => 'スポーツ',
        'Still Image' => '静止画像',
        'Sunset' => '夕焼け',
        'Super Macro' => 'スーパーマクロ',
        'Underwater' => '水中',
        'Vivid' => 'ビビッド',
      },
    },
   'EdgeNoiseReduction' => {
      Description => 'エッジノイズリダクション',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'EditStatus' => '編集状態',
   'EditorialUpdate' => {
      Description => '更新編集',
      PrintConv => {
        'Additional language' => '追加言語',
      },
    },
   'EffectiveLV' => '効果レベル',
   'Emphasis' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'EncodingProcess' => 'JPEGの符号化処理',
   'EndPoints' => '末端',
   'EnhanceDarkTones' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Enhancement' => {
      Description => '強度',
      PrintConv => {
        'Blue' => '青',
        'Flesh Tones' => '肌調',
        'Green' => '緑',
        'Off' => 'オフ',
        'Red' => '赤',
      },
    },
   'Enhancer' => '増大値2',
   'EnhancerValues' => '増大値',
   'EnvelopeNumber' => 'エンベロープ数',
   'EnvelopePriority' => {
      Description => 'エンベロープ優先度',
      PrintConv => {
        '0 (reserved)' => '0 (将来拡張用)',
        '1 (most urgent)' => '1 (高い緊急性)',
        '5 (normal urgency)' => '5 (普通の緊急性)',
        '8 (least urgent)' => '8 (低い緊急性)',
        '9 (user-defined priority)' => '9 (ユーザ定義優先度)',
      },
    },
   'EnvelopeRecordVersion' => 'エンベロープレコードバージョン',
   'EpsonImageHeight' => 'エプソン画像高',
   'EpsonImageWidth' => 'エプソン画像幅',
   'EpsonSoftware' => 'エプソンソフトウェア',
   'Equipment' => 'イクイップメントIFDポインター',
   'EquipmentVersion' => 'イクイップメントバージョン',
   'ExcursionTolerance' => '振幅許容範囲',
   'ExifCameraInfo' => 'Exifカメラ情報',
   'ExifImageHeight' => '画像高さ',
   'ExifImageWidth' => '画像幅',
   'ExifOffset' => 'Exif IFDへのポインタ',
   'ExifToolVersion' => 'ExifToolバージョン',
   'ExifVersion' => 'Exifバージョン',
   'ExpandFilm' => '拡張フイルム',
   'ExpandFilterLens' => '拡張レンズフィルター',
   'ExpandFlashLamp' => '拡張フラッシュランプ',
   'ExpandLens' => '拡張レンズ',
   'ExpandScanner' => '拡張スキャナー',
   'ExpandSoftware' => '拡張ソフト',
   'ExpirationDate' => '有効日付',
   'ExpirationTime' => '有効時間',
   'Exposure' => '露出',
   'ExposureBracketStepSize' => '露出ブラケットステップサイズ',
   'ExposureBracketValue' => '露出ブラケット値',
   'ExposureCompStepSize' => {
      Description => '露出補正/ファインチューン',
      PrintConv => {
        '1 EV' => '1ステップ',
        '1/2 EV' => '1/2ステップ',
        '1/3 EV' => '1/3ステップ',
      },
    },
   'ExposureCompensation' => '露出補正値',
   'ExposureControlStepSize' => {
      Description => '露出制御のEVステップ',
      PrintConv => {
        '1 EV' => '1ステップ',
        '1/2 EV' => '1/2ステップ',
        '1/3 EV' => '1/3ステップ',
      },
    },
   'ExposureDelayMode' => {
      Description => '露出遅延モード',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ExposureDifference' => '露出差',
   'ExposureIndex' => '露出指標',
   'ExposureLevelIncrements' => {
      Description => '露出制御のEVステップ',
      PrintConv => {
        '1-stop set, 1/3-stop comp.' => '設定1 露出補正1/3',
        '1/2 Stop' => '1/2ステップ',
        '1/2-stop set, 1/2-stop comp.' => '設定1/2 露出補正1/2',
        '1/3 Stop' => '1/3ステップ',
        '1/3-stop set, 1/3-stop comp.' => '設定1/3 露出補正1/3',
      },
    },
   'ExposureMode' => {
      Description => '露光モード',
      PrintConv => {
        'Aperture Priority' => '絞り優先',
        'Aperture-priority AE' => '絞り優先',
        'Auto' => '自動露出',
        'Auto bracket' => 'オートブラケット',
        'Bulb' => 'バルブ',
        'Landscape' => '風景',
        'Manual' => 'マニュアル露出',
        'Night Scene / Twilight' => '夜景',
        'Portrait' => 'ポートレート',
        'Program' => 'プログラム',
        'Program AE' => 'プログラムAE',
        'Program-shift' => 'プログラムシフト',
        'Shutter Priority' => 'シャッター優先',
        'Shutter speed priority AE' => 'シャッター優先',
        'n/a' => '未設定',
      },
    },
   'ExposureModeInManual' => {
      Description => 'マニュアル露出時の測光モード',
      PrintConv => {
        'Center-weighted average' => '中央重点',
        'Evaluative metering' => '評価測光',
        'Partial metering' => '部分',
        'Specified metering mode' => '設定測光モード',
        'Spot metering' => 'スポット',
      },
    },
   'ExposureProgram' => {
      Description => '露出プログラム',
      PrintConv => {
        'Action (High speed)' => 'スポーツモード(高速シャッター優先)',
        'Aperture Priority' => '絞り優先',
        'Aperture-priority AE' => '絞り優先',
        'Bulb' => 'バルブ',
        'Creative (Slow speed)' => 'クリエイティブプログラム(被写界深度優先)',
        'Landscape' => '風景モード',
        'Manual' => 'マニュアル',
        'Not Defined' => '未定義',
        'Portrait' => 'ポートレートモード',
        'Program' => 'プログラム',
        'Program AE' => 'ノーマルプログラム',
        'Shutter Priority' => 'シャッター優先',
        'Shutter speed priority AE' => 'シャッター優先',
      },
    },
   'ExposureTime' => '露出時間',
   'ExposureTime2' => '露出時間 2',
   'ExposureWarning' => {
      Description => '露出警告',
      PrintConv => {
        'Bad exposure' => '露出失敗',
        'Good' => '適正',
      },
    },
   'ExtendedWBDetect' => {
      Description => '延長WB検出',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Extender' => 'エクステンダー',
   'ExtenderFirmwareVersion' => 'エクステンダーファームウェアバージョン',
   'ExtenderModel' => 'エクステンダーモデル',
   'ExtenderSerialNumber' => 'エクステンダーシリアル番号',
   'ExternalFlash' => {
      Description => '外付フラッシュ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ExternalFlashAE1' => '外付フラッシュAE1？',
   'ExternalFlashAE1_0' => '外付フラッシュAE1(0)？',
   'ExternalFlashAE2' => '外付フラッシュAE2？',
   'ExternalFlashAE2_0' => '外付フラッシュAE2(0)？',
   'ExternalFlashBounce' => {
      Description => '外付フラッシュバウンス',
      PrintConv => {
        'Bounce' => 'バウンス',
        'Bounce or Off' => 'バウンスかオフ',
        'Direct' => 'ダイレクト',
        'No' => 'いいえ',
        'Yes' => 'はい',
        'n/a' => '該当無し',
      },
    },
   'ExternalFlashExposureComp' => {
      Description => '外付ストロボ露出補正',
      PrintConv => {
        'n/a' => '未設定（オフかオートモード）',
        'n/a (Manual Mode)' => '未設定（マニュアルモード）',
      },
    },
   'ExternalFlashFlags' => '外付フラッシュフラグ',
   'ExternalFlashGuideNumber' => '外付フラッシュガイドナンバー？',
   'ExternalFlashMode' => {
      Description => '外付フラッシュモード',
      PrintConv => {
        'Off' => 'オフ',
        'On, Auto' => 'オン、オート',
        'On, Contrast-control Sync' => 'オン、光量比制御シンクロ',
        'On, Flash Problem' => 'オン、フラッシュの問題？',
        'On, High-speed Sync' => 'オン、ハイスピードシンクロ',
        'On, Manual' => 'オン、マニュアル',
        'On, P-TTL Auto' => 'オン、P-TTLオート',
        'On, Wireless' => 'オン、ワイヤレス',
        'On, Wireless, High-speed Sync' => 'オン、ワイヤレス、ハイスピードシンクロ',
        'n/a - Off-Auto-Aperture' => '該当なし-自動絞りオフ',
      },
    },
   'ExternalFlashZoom' => '外付フラッシュズーム',
   'ExtraSamples' => '特別サンプル',
   'FNumber' => 'F値',
   'Face0Position' => '顔0位置',
   'Face1Position' => '顔1位置',
   'Face2Position' => '顔2位置',
   'Face3Position' => '顔3位置',
   'Face4Position' => '顔4位置',
   'Face5Position' => '顔5位置',
   'Face6Position' => '顔6位置',
   'Face7Position' => '顔7位置',
   'Face8Position' => '顔8位置',
   'Face9Position' => '顔9位置',
   'FaceDetect' => {
      Description => '顔認識',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FaceDetectArea' => '顔エリア',
   'FaceDetectFrameSize' => 'フレームサイズ',
   'FaceOrientation' => {
      PrintConv => {
        'Horizontal (normal)' => '水平（標準）',
        'Rotate 180' => '180度回転',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
      },
    },
   'FacesDetected' => '顔認識',
   'FastSeek' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'FaxProfile' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'FaxRecvParams' => 'FAX受信パラメータ',
   'FaxRecvTime' => 'FAX受信時間',
   'FaxSubAddress' => 'FAXサブアドレス',
   'FileFormat' => 'ファイル形式',
   'FileIndex' => 'ファイル索引',
   'FileInfo' => 'ファイル情報',
   'FileInfoVersion' => 'ファイル情報バージョン',
   'FileModifyDate' => '更新日時',
   'FileName' => 'ファイル名',
   'FileNumber' => 'ファイル番号',
   'FileNumberMemory' => {
      Description => 'ファイル番号メモリ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FileNumberSequence' => {
      Description => 'ファイル番号連番',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FileSize' => 'ファイルのサイズ',
   'FileSource' => {
      Description => 'ファイルソース',
      PrintConv => {
        'Digital Camera' => 'デジタルカメラ',
        'Film Scanner' => 'フィルムスキャナー',
        'Reflection Print Scanner' => '反射印刷スキャナー',
      },
    },
   'FileType' => 'ファイルタイプ',
   'FileVersion' => 'ファイル形式バージョン',
   'Filename' => 'ファイル名',
   'FillFlashAutoReduction' => {
      Description => '日中シンクロ・ストロボ露出自動低減制御',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'FillOrder' => {
      Description => 'フルオーダー',
      PrintConv => {
        'Normal' => '標準',
      },
    },
   'FilmMode' => {
      Description => 'フィルムモード',
      PrintConv => {
        'Dynamic (B&W)' => 'ダイナミック（白黒）',
        'Dynamic (color)' => 'ダイナミック（カラー）',
        'Nature (color)' => 'ナチュラル（カラー）',
        'Smooth (B&W)' => '滑らか（白黒）',
        'Smooth (color)' => '滑らか（カラー）',
        'Standard (B&W)' => 'スタンダード（白黒）',
        'Standard (color)' => 'スタンダード（カラー）',
      },
    },
   'FilmType' => 'フィルムタイプ',
   'Filter' => {
      Description => 'フィルター',
      PrintConv => {
        'Off' => 'オフ',
      },
    },
   'FilterEffect' => {
      Description => 'フィルター効果',
      PrintConv => {
        'Green' => '緑',
        'None' => '無し',
        'Off' => 'オフ',
        'Orange' => 'オレンジ',
        'Red' => '赤',
        'Yellow' => '黄色',
        'n/a' => '該当無し',
      },
    },
   'FilterEffectMonochrome' => {
      Description => 'モノクロフィルター効果',
      PrintConv => {
        'Green' => '緑',
        'None' => '無し',
        'Orange' => 'オレンジ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'FinderDisplayDuringExposure' => {
      Description => '露光中のファインダー内表示',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FineTuneOptCenterWeighted' => '最適露出微調整 中央重点測光',
   'FineTuneOptMatrixMetering' => '最適露出微調整 分割測光',
   'FineTuneOptSpotMetering' => '最適露出微調整 スポット測光',
   'Firmware' => 'ファームウェア',
   'FirmwareDate' => 'ファームウェア日付',
   'FirmwareRevision' => 'ファームウェアリビジョン',
   'FirmwareVersion' => 'ファームウェアバージョン',
   'FixtureIdentifier' => 'フィクチャー識別子',
   'Flash' => {
      Description => 'ストロボ',
      PrintConv => {
        'Auto, Did not fire' => 'フラッシュ未発光、オートモード',
        'Auto, Did not fire, Red-eye reduction' => 'オート、フラッシュ未発光、赤目軽減モード',
        'Auto, Fired' => 'フラッシュ発光、オートモード',
        'Auto, Fired, Red-eye reduction' => 'フラッシュ発光、オートモード、赤目軽減モード',
        'Auto, Fired, Red-eye reduction, Return detected' => 'フラッシュ発光、オートモード、ストロボ光検知、赤目軽減モード',
        'Auto, Fired, Red-eye reduction, Return not detected' => 'フラッシュ発光、オートモード、ストロボ光未検知、赤目軽減モード',
        'Auto, Fired, Return detected' => 'フラッシュ発光、オートモード、ストロボ光検知',
        'Auto, Fired, Return not detected' => 'フラッシュ発光、オートモード、ストロボ光未検知',
        'Did not fire' => 'フラッシュ未発光',
        'Fired' => 'フラッシュ発光',
        'Fired, Red-eye reduction' => 'フラッシュ発光、赤目軽減モード',
        'Fired, Red-eye reduction, Return detected' => 'フラッシュ発光、赤目軽減モード、ストロボ光検知',
        'Fired, Red-eye reduction, Return not detected' => 'フラッシュ発光、赤目軽減モード、ストロボ光未検知',
        'Fired, Return detected' => 'ストロボ光検知',
        'Fired, Return not detected' => 'ストロボ光未検知',
        'No Flash' => 'フラッシュ未発光',
        'No flash function' => 'フラッシュ機能無し',
        'Off' => 'オフ',
        'Off, Did not fire' => 'フラッシュ未発光、強制発光モード',
        'Off, Did not fire, Return not detected' => 'オフ、フラッシュ未発光、ストロボ光未検知',
        'Off, No flash function' => 'オフ、フラッシュ機能無し',
        'Off, Red-eye reduction' => 'オフ、赤目軽減モード',
        'On' => 'オン',
        'On, Did not fire' => 'オン、フラッシュ未発光',
        'On, Fired' => 'フラッシュ発光、強制発光モード',
        'On, Red-eye reduction' => 'フラッシュ発光、強制発光モード、赤目軽減モード',
        'On, Red-eye reduction, Return detected' => 'フラッシュ発光、強制発光モード、赤目軽減モード、ストロボ光検知',
        'On, Red-eye reduction, Return not detected' => 'フラッシュ発光、強制発光モード、赤目軽減モード、ストロボ光未検知',
        'On, Return detected' => 'フラッシュ発光、強制発光モード、ストロボ光検知',
        'On, Return not detected' => 'フラッシュ発光、強制発光モード、ストロボ光未検知',
      },
    },
   'FlashActivity' => 'フラッシュ稼働',
   'FlashBias' => 'フラッシュバイアス',
   'FlashBits' => 'フラッシュ詳細',
   'FlashChargeLevel' => 'フラッシュチャージレベル',
   'FlashCommanderMode' => {
      Description => 'コマンダーモード',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FlashCompensation' => 'フラッシュ補正',
   'FlashControlMode' => {
      Description => 'フラッシュコントロールモード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
        'Repeating Flash' => 'リピーティングフラッシュ',
      },
    },
   'FlashDevice' => {
      Description => 'フラッシュデバイス',
      PrintConv => {
        'External' => '外付け',
        'Internal' => '内蔵',
        'Internal + External' => '内蔵+外付け',
        'None' => '無し',
      },
    },
   'FlashDistance' => 'フラッシュ強度',
   'FlashEnergy' => 'フラッシュ強度',
   'FlashExposureBracketValue' => 'フラッシュ露出ブラケット値',
   'FlashExposureComp' => 'フラッシュ露出補正',
   'FlashExposureCompSet' => 'ストロボ露出補正設定',
   'FlashExposureLock' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FlashFired' => {
      Description => 'フラッシュ発光',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'FlashFiring' => {
      Description => 'ストロボの発光',
      PrintConv => {
        'Does not fire' => 'しない',
        'Fires' => 'する',
      },
    },
   'FlashFirmwareVersion' => 'フラッシュファームウェアバージョン',
   'FlashFocalLength' => 'フラッシュ焦点距離',
   'FlashGroupACompensation' => 'グループAフラッシュ補正',
   'FlashGroupAControlMode' => {
      Description => 'グループAフラッシュコントロールモード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
        'Repeating Flash' => 'リピーティングフラッシュ',
      },
    },
   'FlashGroupAOutput' => 'グループAフラッシュ出力',
   'FlashGroupBCompensation' => 'グループBフラッシュ補正',
   'FlashGroupBControlMode' => {
      Description => 'グループBフラッシュコントロールモード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
        'Repeating Flash' => 'リピーティングフラッシュ',
      },
    },
   'FlashGroupBOutput' => 'グループBフラッシュ出力',
   'FlashGroupCCompensation' => 'グループCフラッシュ補正',
   'FlashGroupCControlMode' => {
      Description => 'グループCフラッシュコントロールモード',
      PrintConv => {
        'Auto Aperture' => '自動絞り（AA）',
        'Manual' => 'マニュアル',
        'Off' => 'オフ',
        'Repeating Flash' => 'リピーティングフラッシュ',
      },
    },
   'FlashGroupCOutput' => 'グループCフラッシュ出力',
   'FlashGuideNumber' => 'フラッシュガイドナンバー',
   'FlashInfo' => 'ストロボ情報',
   'FlashInfoVersion' => 'フラッシュ情報バージョン',
   'FlashIntensity' => {
      Description => 'フラッシュ強度',
      PrintConv => {
        'High' => '高い',
        'Low' => '低い',
        'Normal' => '標準',
        'Strong' => '強い',
        'Weak' => '弱い',
      },
    },
   'FlashLevel' => 'フラッシュ補正',
   'FlashMetering' => 'フラッシュ計測',
   'FlashMeteringSegments' => 'フラッシュ測光値',
   'FlashMode' => {
      Description => 'フラッシュモード',
      PrintConv => {
        'Auto' => 'オート',
        'Auto, Did not fire' => 'オート、発光無し',
        'Auto, Did not fire, Red-eye reduction' => 'オート、発光無し、赤目軽減',
        'Auto, Fired' => 'オート、発光',
        'Auto, Fired, Red-eye reduction' => 'オート、発光、赤目軽減',
        'Did Not Fire' => '発光禁止',
        'External, Auto' => '外付、オート',
        'External, Contrast-control Sync' => '外付、光量比制御シンクロ',
        'External, Flash Problem' => '外付、フラッシュの問題?',
        'External, High-speed Sync' => '外付、ハイスピードシンクロ',
        'External, Manual' => '外付、マニュアル',
        'External, P-TTL Auto' => '外付、P-TTL自動調光',
        'External, Wireless' => '外付、ワイヤレス',
        'External, Wireless, High-speed Sync' => '外付、ワイヤレス、ハイスピードシンクロ',
        'Fill flash' => '強制発光',
        'Fired, Commander Mode' => '発光、コマンダーモード',
        'Fired, External' => '発光、外付',
        'Fired, Manual' => '発光、マニュアル',
        'Fired, TTL Mode' => '発光、TTLモード',
        'Internal' => '内蔵',
        'Normal' => '標準',
        'Off' => 'オフ',
        'Off, Did not fire' => 'オフ',
        'Off?' => 'オフ？',
        'On' => 'オン',
        'On, Did not fire' => 'オン、発光無し',
        'On, Fired' => 'オン',
        'On, Red-eye reduction' => 'オン、赤目軽減',
        'On, Slow-sync' => 'オン、スローシンクロ',
        'On, Slow-sync, Red-eye reduction' => 'オン、スローシンクロ、赤目軽減',
        'On, Soft' => 'オン、ソフト',
        'On, Trailing-curtain Sync' => 'オン、後幕シンクロ',
        'On, Wireless (Control)' => 'オン、ワイヤレス (コントロール)',
        'On, Wireless (Master)' => 'オン、ワイヤレス (マスター)',
        'Rear flash sync' => 'リアフラッシュシンクロ',
        'Red-eye Reduction' => '赤目軽減',
        'Red-eye reduction' => '赤目軽減',
        'Unknown' => '不明',
        'Wireless' => 'ワイヤレス',
        'n/a - Off-Auto-Aperture' => '該当なし-自動絞りオフ',
      },
    },
   'FlashModel' => {
      Description => 'フラッシュモデル',
      PrintConv => {
        'None' => '無し',
      },
    },
   'FlashOptions' => {
      Description => 'フラッシュオプション',
      PrintConv => {
        'Auto' => 'オート',
        'Auto, Red-eye reduction' => 'オート、赤目軽減',
        'Normal' => '標準',
        'Red-eye reduction' => '赤目軽減',
        'Slow-sync' => 'スローシンクロ',
        'Slow-sync, Red-eye reduction' => 'スローシンクロ、赤目軽減',
        'Trailing-curtain Sync' => '後幕シンクロ',
        'Wireless (Control)' => 'ワイヤレス（コントロール発光）',
        'Wireless (Master)' => 'ワイヤレス（マスター発光）',
      },
    },
   'FlashOptions2' => {
      Description => 'ストロボオプション(2)',
      PrintConv => {
        'Auto' => 'オート',
        'Auto, Red-eye reduction' => 'オート、赤目軽減',
        'Normal' => '標準',
        'Red-eye reduction' => '赤目軽減',
        'Slow-sync' => 'スローシンクロ',
        'Slow-sync, Red-eye reduction' => 'スローシンクロ、赤目軽減',
        'Trailing-curtain Sync' => '後幕シンクロ',
        'Wireless (Control)' => 'ワイヤレス（コントロール発光）',
        'Wireless (Master)' => 'ワイヤレス（マスター発光）',
      },
    },
   'FlashOutput' => 'フラッシュ出力',
   'FlashRemoteControl' => 'フラッシュリモートコントロール',
   'FlashSerialNumber' => 'フラッシュシリアル番号',
   'FlashSetting' => 'フラッシュ設定',
   'FlashShutterSpeed' => 'フラッシュシャッター速度',
   'FlashStatus' => {
      Description => 'ストロボ状態',
      PrintConv => {
        'External, Did not fire' => '外付、未発光',
        'External, Fired' => '外付、発光',
        'Internal, Did not fire' => '内蔵、未発光',
        'Internal, Fired' => '内蔵、発光',
        'Off' => 'オフ',
      },
    },
   'FlashSyncSpeed' => 'フラッシュ同調速度',
   'FlashSyncSpeedAv' => {
      Description => 'Avモード時のストロボ同調速度',
      PrintConv => {
        '1/200 Fixed' => '1/200秒固定',
        '1/250 Fixed' => '1/250秒固定',
        '1/300 Fixed' => '1/300秒固定',
        'Auto' => 'オート',
      },
    },
   'FlashType' => {
      Description => 'フラッシュタイプ',
      PrintConv => {
        'E-System' => 'E-システム',
        'None' => '無し',
        'Simple E-System' => 'シンプルE-システム',
      },
    },
   'FlashWarning' => {
      Description => 'フラッシュ警告',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FlashpixVersion' => 'サポートフラッシュピックスバージョン',
   'FlickerReduce' => {
      Description => 'フリッカー軽減',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'FlipHorizontal' => {
      Description => '横フリップ',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'FocalLength' => 'レンズ焦点距離',
   'FocalLength35efl' => 'レンズ焦点距離',
   'FocalLengthIn35mmFormat' => '35mmフイルム換算焦点距離',
   'FocalPlaneDiagonal' => '焦点面対角線',
   'FocalPlaneResolutionUnit' => {
      Description => '焦点面解像度単位',
      PrintConv => {
        'None' => '無し',
        'inches' => 'インチ',
      },
    },
   'FocalPlaneXResolution' => '焦点面X解像度',
   'FocalPlaneXSize' => '焦点面Xサイズ',
   'FocalPlaneXUnknown' => '焦点面Xサイズ',
   'FocalPlaneYResolution' => '焦点面Y解像度',
   'FocalPlaneYSize' => '焦点面Yサイズ',
   'FocalPlaneYUnknown' => '焦点面Yサイズ',
   'FocalType' => {
      Description => 'フォーカスタイプ',
      PrintConv => {
        'Fixed' => '固定',
        'Zoom' => 'ズーム',
      },
    },
   'FocalUnits' => '焦点単位/mm',
   'Focus' => {
      Description => 'フォーカス',
      PrintConv => {
        'Manual' => 'マニュアル',
      },
    },
   'FocusArea' => 'フォーカスエリア',
   'FocusAreaSelection' => {
      Description => 'フォーカスポイントラップアラウンド',
      PrintConv => {
        'No Wrap' => 'ノーラップ',
        'Wrap' => 'ラップ',
      },
    },
   'FocusContinuous' => {
      Description => '連続フォーカス',
      PrintConv => {
        'Continuous' => '連続',
        'Manual' => 'マニュアル',
        'Single' => 'シングル',
      },
    },
   'FocusDistance' => '被写体距離',
   'FocusDistanceLower' => '焦点距離低部分',
   'FocusDistanceUpper' => '焦点距離高部分',
   'FocusMode' => {
      Description => 'フォーカスモード',
      PrintConv => {
        'AI Focus AF' => 'AIフォーカスAF',
        'AI Servo AF' => 'AIサーボAF',
        'Auto' => 'オート',
        'Auto, Continuous' => 'オート、コンティニュアス',
        'Auto, Focus button' => 'オート、フォーカスボタン',
        'Continuous' => '連写',
        'Continuous AF' => 'コンティニュアスAF',
        'Custom' => 'カスタム',
        'Infinity' => '無限遠',
        'Macro' => 'マクロ',
        'Macro (1)' => 'マクロ(1)',
        'Macro (2)' => 'マクロ(2)',
        'Manual' => 'マニュアル',
        'Manual Focus (3)' => 'マニュアルフォーカス(3)',
        'Manual Focus (6)' => 'マニュアルフォーカス(6)',
        'Multi AF' => 'マルチAF',
        'Normal' => '標準',
        'One-shot AF' => 'ワンショットAF',
        'Pan Focus' => 'パンフォーカス',
        'Sequential shooting AF' => 'シーケンシャルシューティングAF',
        'Single' => 'シングル',
        'Single AF' => 'シングルAF',
        'Super Macro' => 'スーパーマクロ',
      },
    },
   'FocusMode2' => 'フォーカスモード2',
   'FocusModeSetting' => {
      Description => 'フォーカスモード',
      PrintConv => {
        'Manual' => 'マニュアル',
      },
    },
   'FocusPixel' => '焦点解像度',
   'FocusPointWrap' => {
      Description => 'フォーカスポイントラップアラウンド',
      PrintConv => {
        'No Wrap' => 'ノーラップ',
        'Wrap' => 'ラップ',
      },
    },
   'FocusPosition' => 'フォーカス距離',
   'FocusProcess' => {
      Description => 'フォーカスプロセス',
      PrintConv => {
        'AF Not Used' => 'AF未使用',
        'AF Used' => 'AF使用',
      },
    },
   'FocusRange' => {
      Description => 'フォーカスレンジ',
      PrintConv => {
        'Auto' => 'オート',
        'Close' => '近景',
        'Far Range' => '遠景',
        'Infinity' => '無限遠',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Middle Range' => '中間範囲',
        'Normal' => 'ノーマル',
        'Not Known' => '不明',
        'Pan Focus' => 'パンフォーカス',
        'Super Macro' => 'スーパーマクロ',
        'Very Close' => '近接',
      },
    },
   'FocusSetting' => 'フォーカス設定',
   'FocusStepCount' => 'フォーカスステップ数',
   'FocusStepInfinity' => '無限レンズステップ',
   'FocusStepNear' => 'ニアステップ数',
   'FocusTrackingLockOn' => {
      Description => 'フォーカストラッキングとロックオン',
      PrintConv => {
        'Long' => 'ロング',
        'Normal' => '標準',
        'Off' => 'オフ',
        'Short' => 'ショート',
      },
    },
   'FocusWarning' => {
      Description => 'フォーカス警告',
      PrintConv => {
        'Good' => 'ジャスピン',
        'Out of focus' => 'ピンボケ',
      },
    },
   'FocusingScreen' => 'フォーカシングスクリーン',
   'FolderName' => 'フォルダ名',
   'ForwardMatrix1' => '前行列1',
   'ForwardMatrix2' => '前行列2',
   'FrameHeight' => 'フレーム高',
   'FrameNumber' => 'フレーム番号',
   'FrameRate' => 'フレームレート',
   'FrameSize' => 'フレームサイズ',
   'FrameWidth' => 'フレーム幅',
   'FreeByteCounts' => 'フリーバイト数',
   'FreeMemoryCardImages' => 'フリーメモリーカードイメージ',
   'FreeOffsets' => 'フリーオフセット',
   'FujiFlashMode' => {
      Description => 'フラッシュモード',
      PrintConv => {
        'Auto' => 'オート',
        'External' => '外付フラッシュ',
        'Off' => 'オフ',
        'On' => 'オン',
        'Red-eye reduction' => '赤目軽減',
      },
    },
   'FunctionButton' => {
      Description => 'FUNCボタン',
      PrintConv => {
        'AF-area Mode' => 'AFエリアモード',
        'Center AF Area' => '中央AFエリア',
        'Center-weighted' => '中央重点測光',
        'FV Lock' => 'FVロック',
        'Flash Off' => 'フラッシュオフ',
        'Framing Grid' => 'フレーミンググリッド',
        'ISO Display' => 'ISO表示',
        'Matrix Metering' => '分割測光',
        'Spot Metering' => 'スポット測光',
      },
    },
   'GEMInfo' => 'GEM情報',
   'GEModel' => 'モデル',
   'GIFVersion' => 'GIFバージョン',
   'GPSAltitude' => '高度',
   'GPSAltitudeRef' => {
      Description => '参照高度',
      PrintConv => {
        'Above Sea Level' => '海水面',
        'Below Sea Level' => '参照海水面(負の値)',
      },
    },
   'GPSAreaInformation' => 'GPSエリアの名称',
   'GPSDOP' => '測定精度',
   'GPSDateStamp' => 'GPSデータ',
   'GPSDateTime' => 'GPS時間(原子時計)',
   'GPSDestBearing' => '目的地の方向',
   'GPSDestBearingRef' => {
      Description => '目的地の方向の参照',
      PrintConv => {
        'Magnetic North' => '磁気の方向',
        'True North' => '正常な方向',
      },
    },
   'GPSDestDistance' => '目的地の距離',
   'GPSDestDistanceRef' => {
      Description => '目的地の距離の参照',
      PrintConv => {
        'Kilometers' => 'キロメートル',
        'Miles' => 'マイル',
        'Nautical Miles' => 'ノット',
      },
    },
   'GPSDestLatitude' => '目的地の緯度',
   'GPSDestLatitudeRef' => {
      Description => '目的地の緯度のための参照',
      PrintConv => {
        'North' => '北緯',
        'South' => '南緯',
      },
    },
   'GPSDestLongitude' => '目的地の経度',
   'GPSDestLongitudeRef' => {
      Description => '目的地の経度のための参照',
      PrintConv => {
        'East' => '東経',
        'West' => '西経',
      },
    },
   'GPSDifferential' => {
      Description => 'GPS誤差修正',
      PrintConv => {
        'Differential Corrected' => '誤差修正あり',
        'No Correction' => '誤差修正無し',
      },
    },
   'GPSImgDirection' => 'イメージの方向',
   'GPSImgDirectionRef' => {
      Description => '画像方向参照',
      PrintConv => {
        'Magnetic North' => '磁気の方向',
        'True North' => '本当の方向',
      },
    },
   'GPSInfo' => 'GPS IFDへのポインタ',
   'GPSLatitude' => '緯度',
   'GPSLatitudeRef' => {
      Description => '北緯または南緯',
      PrintConv => {
        'North' => '北緯',
        'South' => '南緯',
      },
    },
   'GPSLongitude' => '経度',
   'GPSLongitudeRef' => {
      Description => '東経または西経',
      PrintConv => {
        'East' => '東経',
        'West' => '西経',
      },
    },
   'GPSMapDatum' => 'データが使った測地測量',
   'GPSMeasureMode' => {
      Description => 'GPS測定モード',
      PrintConv => {
        '2-D' => '２次元測定',
        '2-Dimensional' => '２次元測定',
        '2-Dimensional Measurement' => '２次元測定',
        '3-D' => '３次元測定',
        '3-Dimensional' => '３次元測定',
        '3-Dimensional Measurement' => '３次元測定',
      },
    },
   'GPSProcessingMethod' => 'GPS処理方法の名称',
   'GPSSatellites' => '測定のために使われたGPS衛星',
   'GPSSpeed' => 'GPS受信機のスピード',
   'GPSSpeedRef' => {
      Description => 'スピード単位',
      PrintConv => {
        'km/h' => '時速(km)',
        'knots' => 'ノット',
        'mph' => '時速(マイル)',
      },
    },
   'GPSStatus' => {
      Description => 'GPS受信機ステータス',
      PrintConv => {
        'Measurement Active' => '測定アクティブ',
        'Measurement Void' => '測定無効',
      },
    },
   'GPSTimeStamp' => 'GPS時間(原子時計)',
   'GPSTrack' => '動作方向',
   'GPSTrackRef' => {
      Description => '動作方向の参照',
      PrintConv => {
        'Magnetic North' => '磁気の方向',
        'True North' => '本当の方向',
      },
    },
   'GPSVersionID' => 'GPSタグバージョン',
   'GainBase' => '基本ゲイン',
   'GainControl' => {
      Description => 'ゲインコントロール',
      PrintConv => {
        'High gain down' => '高いゲインダウン',
        'High gain up' => '高いゲインアップ',
        'Low gain down' => '低いゲインダウン',
        'Low gain up' => '低いゲインアップ',
        'None' => '無し',
      },
    },
   'Gamma' => 'ガンマ',
   'GammaCompensatedValue' => 'ガンマ補償値',
   'Gamut' => '全域',
   'Gapless' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'GeoTiffAsciiParams' => 'ジオアスキー設定タグ',
   'GeoTiffDirectory' => 'ジオキーディレクトリタグ',
   'GeoTiffDoubleParams' => 'ジオダブル設定タグ',
   'Gradation' => 'グラデーション',
   'GrayPoint' => 'グレーポイント',
   'GrayResponseCurve' => 'グレー反応曲線',
   'GrayResponseUnit' => {
      Description => 'グレー反応単位',
      PrintConv => {
        '0.0001' => '単位の数は1000を表す',
        '0.001' => '単位の数は100を表す',
        '0.1' => '単位の数は10を表す',
        '1e-05' => '単位の数は10-1000を表す',
        '1e-06' => '単位の数は100-1000を表す',
      },
    },
   'GrayScale' => 'グレースケール',
   'GrayTRC' => '灰色調増殖曲線',
   'GreenMatrixColumn' => '緑色マトリックス列',
   'GreenTRC' => '緑色調増殖曲線',
   'GridDisplay' => {
      Description => 'ビューファインダーグリッド表示',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'GripBatteryADLoad' => '電源A/Dグリップ起動時',
   'GripBatteryADNoLoad' => '電源A/Dグリップオフ時',
   'GripBatteryState' => '電源状態グリップ',
   'HCUsage' => 'HC使用',
   'HDR' => {
      Description => 'オートHDR',
      PrintConv => {
        'Off' => '切',
      },
    },
   'HalftoneHints' => 'ハーフトーンヒント',
   'Headline' => 'ヘッドライン',
   'HeightResolution' => '高さ方向の画像解像度',
   'HighISONoiseReduction' => {
      Description => '高感度ノイズリダクション',
      PrintConv => {
        'Auto' => 'オート',
        'High' => '高い',
        'Low' => 'ソフト',
        'Minimal' => '最小',
        'Normal' => '標準',
        'Off' => 'オフ',
        'On' => 'オン',
        'Standard' => 'スタンダード',
        'Strong' => '強',
        'Weak' => '弱',
        'Weakest' => '微弱',
      },
    },
   'Highlight' => 'ハイライト',
   'HighlightTonePriority' => {
      Description => '高輝度側・階調優先',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'HometownCity' => '現在地',
   'HometownCityCode' => '現在地コード',
   'HometownDST' => {
      Description => '現在地DST',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'HostComputer' => 'ホストコンピューター',
   'Hue' => '色相',
   'HueAdjustment' => '色相調整',
   'HueSetting' => '色相設定',
   'ICCProfile' => 'ICCプロフィール',
   'ICC_Profile' => 'ICC入力色プロフィール',
   'IPTC-NAA' => 'IPTC-NAAメタデータ',
   'IPTCBitsPerSample' => 'サンプルあたりビット数',
   'IPTCData' => 'IPTCデータ',
   'IPTCImageHeight' => 'ライン数',
   'IPTCImageRotation' => 'イメージ回転',
   'IPTCImageWidth' => 'ラインあたりのピクセル数',
   'IPTCPictureNumber' => '写真番号',
   'IPTCPixelHeight' => 'スキャン方向垂直ピクセルサイズ',
   'IPTCPixelWidth' => 'スキャン方向ピクセルサイズ',
   'ISO' => 'ISOスピードレート',
   'ISO2' => 'ISO（2）',
   'ISOAuto' => 'ISOオート',
   'ISODisplay' => 'ISO表示',
   'ISOExpansion' => {
      Description => 'ISO感度拡張',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ISOExpansion2' => {
      Description => 'ISO拡大（2）',
      PrintConv => {
        'Off' => 'オフ',
      },
    },
   'ISOFloor' => '最低感度',
   'ISOInfo' => 'ISO情報',
   'ISOSelection' => 'ISO選択',
   'ISOSetting' => {
      Description => 'ISO設定',
      PrintConv => {
        'Auto' => 'オート',
        'Manual' => 'マニュアル',
      },
    },
   'ISOSpeedExpansion' => {
      Description => 'ISO感度拡張',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ISOSpeedIncrements' => {
      Description => 'ISO感度ステップ値',
      PrintConv => {
        '1 Stop' => '1ステップ',
        '1/3 Stop' => '1/3ステップ',
      },
    },
   'ISOSpeedRange' => {
      Description => 'ISO感度の制御範囲の設定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ISOStepSize' => {
      Description => 'ISO感度ステップ値',
      PrintConv => {
        '1 EV' => '1ステップ',
        '1/2 EV' => '1/2ステップ',
        '1/3 EV' => '1/3ステップ',
      },
    },
   'ISOValue' => 'ISO感度',
   'IT8Header' => 'IT8ヘッダー',
   'Illumination' => {
      Description => 'イルミネーション',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Image::ExifTool::NikonCapture::RedEyeData' => 'Nikon Capture 赤目データ',
   'ImageAdjustment' => 'イメージ調整',
   'ImageAreaOffset' => 'イメージ領域オフセット',
   'ImageAuthentication' => {
      Description => 'イメージ認証',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ImageBoundary' => 'イメージ境界線',
   'ImageByteCount' => '画像バイト数',
   'ImageColorIndicator' => '画像色指標',
   'ImageColorValue' => '画像色値',
   'ImageCount' => 'イメージカウント',
   'ImageDataDiscard' => {
      Description => 'イメージデータ廃棄',
      PrintConv => {
        'Flexbits Discarded' => 'フレックスビット破棄',
        'Full Resolution' => '完全な解像度',
        'HighPass Frequency Data Discarded' => 'ハイパス周波数データ破棄',
        'Highpass and LowPass Frequency Data Discarded' => 'ハイパスとローパス周波数データ破棄',
      },
    },
   'ImageDataSize' => 'イメージデータサイズ',
   'ImageDepth' => 'イメージの深さ',
   'ImageDescription' => 'イメージ説明',
   'ImageDustOff' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ImageEditCount' => '画像処理カウント',
   'ImageEditing' => {
      Description => 'イメージ処理',
      PrintConv => {
        'Cropped' => 'クロップ',
        'Digital Filter' => 'デジタルフィルター',
        'Frame Synthesis?' => 'フレーム合成？',
        'None' => '未処理',
      },
    },
   'ImageHeight' => '画像高さ',
   'ImageHistory' => '画像履歴',
   'ImageID' => 'イメージID',
   'ImageInfo' => '画像情報',
   'ImageLayer' => 'イメージレイヤー',
   'ImageNumber' => 'イメージ番号',
   'ImageNumber2' => 'イメージ番号(2)',
   'ImageOffset' => 'イメージオフセット',
   'ImageOptimization' => 'イメージ最適化',
   'ImageOrientation' => {
      Description => 'イメージ方向',
      PrintConv => {
        'Landscape' => 'ランドスケープ',
        'Portrait' => 'ポートレート',
        'Square' => '正方形',
      },
    },
   'ImageProcessing' => 'イメージ処理',
   'ImageProcessingVersion' => '画像処理バージョン',
   'ImageQuality' => {
      Description => '画像品質',
      PrintConv => {
        'High' => '高い',
        'Motion Picture' => '動画',
        'Normal' => '標準',
      },
    },
   'ImageQuality2' => 'イメージ品質2',
   'ImageResourceBlocks' => 'イメージリソースブロック',
   'ImageReview' => {
      Description => '画像評価',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ImageReviewTime' => '自動オフタイマー 画像評価時間',
   'ImageRotated' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ImageSize' => 'イメージサイズ',
   'ImageSourceData' => 'イメージソースデータ',
   'ImageStabilization' => {
      Description => 'イメージスタビライザー',
      PrintConv => {
        'Best Shot' => 'ベストショット',
        'Off' => 'オフ',
        'On' => 'オン',
        'On, Mode 1' => 'オン、モード１',
        'On, Mode 2' => 'オン、モード２',
      },
    },
   'ImageTone' => {
      Description => '画像仕上',
      PrintConv => {
        'Bright' => '鮮やか',
        'Landscape' => '風景',
        'Monochrome' => 'モノトーン',
        'Natural' => 'ナチュラル',
        'Portrait' => 'ポートレート',
        'Vibrant' => '雅(MIYABI)',
      },
    },
   'ImageType' => 'ページ',
   'ImageUniqueID' => 'ユニークなイメージID',
   'ImageWidth' => '画像幅',
   'Index' => '目次',
   'Indexed' => 'インデックス',
   'InfoButtonWhenShooting' => {
      Description => '撮影時のINFOボタン',
      PrintConv => {
        'Displays camera settings' => 'カメラ設定内容を表示',
        'Displays shooting functions' => '撮影機能の設定状態を表示',
      },
    },
   'InitialZoomSetting' => {
      Description => '初期ズーム設定',
      PrintConv => {
        'High Magnification' => '高い拡大',
        'Low Magnification' => '低い拡大',
        'Medium Magnification' => '中間拡大',
      },
    },
   'InkNames' => 'インク名',
   'InkSet' => 'インクセット',
   'Instructions' => '詳細',
   'IntellectualGenre' => 'インテリジャンル',
   'IntelligentAuto' => 'インテリジェントオート',
   'IntensityStereo' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'IntergraphMatrix' => '相互グラフマトリックスタグ',
   'Interlace' => 'インタレース',
   'InternalFlash' => {
      Description => '内蔵フラッシュコントロール',
      PrintConv => {
        'Commander Mode' => 'コマンダーモード',
        'Fired' => 'フラッシュ発光',
        'Manual' => 'マニュアル',
        'No' => 'フラッシュ未発光',
        'Off' => 'オフ',
        'On' => 'オン',
        'Repeating Flash' => 'リピーティングフラッシュ',
      },
    },
   'InternalFlashAE1' => '内蔵フラッシュAE1？',
   'InternalFlashAE1_0' => '内蔵フラッシュAE1(0)？',
   'InternalFlashAE2' => '内蔵フラッシュAE2？',
   'InternalFlashAE2_0' => '内蔵フラッシュAE2(0)？',
   'InternalFlashMode' => {
      Description => '内蔵ストロボモード',
      PrintConv => {
        'Did not fire, (Unknown 0xf4)' => 'オフ（未確認 0xF4?）',
        'Did not fire, Auto' => 'オフ、オート',
        'Did not fire, Auto, Red-eye reduction' => 'オフ、オート、赤目軽減',
        'Did not fire, Normal' => 'オフ、標準',
        'Did not fire, Red-eye reduction' => 'オフ、赤目軽減',
        'Did not fire, Slow-sync' => 'オフ、スローシンクロ',
        'Did not fire, Slow-sync, Red-eye reduction' => 'オフ、スローシンクロ、赤目軽減',
        'Did not fire, Trailing-curtain Sync' => 'オフ、後幕シンクロ',
        'Did not fire, Wireless (Control)' => 'オフ、ワイヤレス（コントロール発光）',
        'Did not fire, Wireless (Master)' => 'オフ、ワイヤレス（マスター発光）',
        'Fired' => 'オン',
        'Fired, Auto' => 'オン、オート',
        'Fired, Auto, Red-eye reduction' => 'オン、オート、赤目軽減',
        'Fired, Red-eye reduction' => 'オン、赤目軽減',
        'Fired, Slow-sync' => 'オン、スローシンクロ',
        'Fired, Slow-sync, Red-eye reduction' => 'オン、スローシンクロ、赤目軽減',
        'Fired, Trailing-curtain Sync' => 'オン、後幕シンクロ',
        'Fired, Wireless (Control)' => 'オン、ワイヤレス（コントロール発光）',
        'Fired, Wireless (Master)' => 'オン、ワイヤレス（マスター発光）',
        'n/a - Off-Auto-Aperture' => '該当なし-自動絞りオフ',
      },
    },
   'InternalFlashStrength' => '内蔵フラッシュ強度',
   'InternalFlashTable' => '内蔵フラッシュテーブル',
   'InternalSerialNumber' => '内部シリアル番号',
   'InteropIndex' => {
      Description => 'インターオペラビリティID',
      PrintConv => {
        'R03 - DCF option file (Adobe RGB)' => 'R03: DCFオプションファイル(Adobe RGB)',
        'R98 - DCF basic file (sRGB)' => 'R98: DCF基本ファイル(sRGB)',
        'THM - DCF thumbnail file' => 'THM: DCFサムネイルファイル',
      },
    },
   'InteropOffset' => '互換性IFDへのポインタ',
   'InteropVersion' => 'インターオペラビリティバージョン',
   'IntervalLength' => 'インターバル長',
   'IntervalMode' => 'インターバルモード',
   'IntervalNumber' => 'インターバル数',
   'JFIFVersion' => 'JFIFバージョン',
   'JPEGACTables' => 'JPEG AC テーブル',
   'JPEGDCTables' => 'JPEG DC テーブル',
   'JPEGLosslessPredictors' => 'JPEGロスレス予測',
   'JPEGPointTransforms' => 'JPEG位置変換',
   'JPEGProc' => 'JPEG処理',
   'JPEGQTables' => 'JPEG Q テーブル',
   'JPEGQuality' => {
      Description => 'JPEG　品質',
      PrintConv => {
        'Extra Fine' => 'エクストラファイン',
        'Fine' => 'ファイン',
        'Standard' => 'ノーマル',
        'n/a' => '未設定',
      },
    },
   'JPEGRestartInterval' => 'JPEG再開間隔',
   'JPEGTables' => 'JPEGテーブル',
   'JobID' => 'ジョブID',
   'JpgRecordedPixels' => 'JPEG記録サイズ',
   'Keyword' => 'キーワード',
   'Keywords' => 'キーワード',
   'LC1' => 'レンズデータ',
   'LC10' => 'Mv\' nv\' データ',
   'LC11' => 'AVC 1/EXP データ',
   'LC12' => 'Mv1 Avminsifデータ',
   'LC14' => 'UNT_12 UNT_6 データ',
   'LC15' => '統合フラッシュ最適エンドデータ',
   'LC2' => '距離コードデータ',
   'LC3' => 'K値(',
   'LC4' => '近距離収差訂正データ',
   'LC5' => '明色収差訂正データ',
   'LC6' => 'オープン収差データ',
   'LC7' => 'AF最低作動状態データ（LC7）',
   'LCDDisplayAtPowerOn' => {
      Description => '電源スイッチ〈ON〉時の液晶点灯',
      PrintConv => {
        'Display' => '点灯',
        'Retain power off status' => '電源〈OFF〉時の状態を保持',
      },
    },
   'LCDDisplayReturnToShoot' => {
      Description => '液晶モニター表示中の撮影状態復帰',
      PrintConv => {
        'Also with * etc.' => '*ボタンなどでも復帰',
        'With Shutter Button only' => 'シャッターボタンでのみ復帰',
      },
    },
   'LCDIllumination' => {
      Description => 'LCDイルミネーション',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'LCDIlluminationDuringBulb' => {
      Description => 'バルブ撮影中の表示パネル照明',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'LCDPanels' => '上面表示パネル／背面表示パネル',
   'LCHEditor' => {
      Description => 'LCHエディター',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'LanguageIdentifier' => '言語識別子',
   'LastFileNumber' => '最終ファイル番号',
   'LeafData' => 'リーフデータ',
   'Lens' => 'レンズ',
   'Lens35efl' => 'レンズ',
   'LensAFStopButton' => {
      Description => 'レンズ・AFストップボタンの機能',
      PrintConv => {
        'AE lock' => 'AEロック',
        'AE lock while metering' => 'AEロック(タイマー中)',
        'AF Stop' => 'AFストップ',
        'AF point: M->Auto/Auto->ctr' => '測距点 任意→自動/自動→中央',
        'AF start' => 'AFスタート',
        'AF stop' => 'AFストップ',
        'IS start' => '手ブレ補正機能作動',
        'One Shot <-> AI servo' => 'ワンショット/AIサーボ',
        'Switch to registered AF point' => '登録AFフレームへの切り換え',
      },
    },
   'LensApertureRange' => 'レンズ絞り範囲',
   'LensData' => 'K値(LC3)',
   'LensDistortionParams' => 'レンズ歪曲パラメータ',
   'LensDriveNoAF' => {
      Description => 'AF測距不能時のレンズ動作',
      PrintConv => {
        'Focus search off' => '駆動しない',
        'Focus search on' => 'サーチ駆動する',
      },
    },
   'LensFStops' => 'レンズF値',
   'LensFirmwareVersion' => 'レンズファームウェアバージョン',
   'LensID' => 'レンズID',
   'LensInfo' => 'レンズ情報',
   'LensKind' => 'レンズ種類/バージョン(LC0)',
   'LensProperties' => 'レンズ機能？',
   'LensSerialNumber' => 'レンズシリアル番号',
   'LensSpec' => 'レンズ',
   'LensTemperature' => 'レンズ温度',
   'LensType' => 'レンズタイプ',
   'LicenseType' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'LightCondition' => 'ライトコンディション',
   'LightReading' => 'ライトリーディング',
   'LightSource' => {
      Description => '光源',
      PrintConv => {
        'Cloudy' => '曇り',
        'Cool White Fluorescent' => '白色蛍光灯',
        'Custom 1-4' => 'カスタム1-4',
        'Day White Fluorescent' => '昼白色蛍光灯',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Fine Weather' => '良い天気',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'ISO Studio Tungsten' => 'ISOスタジオタングステン',
        'Other' => 'その他の光源',
        'Shade' => '日陰',
        'Standard Light A' => '標準ライトA',
        'Standard Light B' => '標準ライトB',
        'Standard Light C' => '標準ライトC',
        'Tungsten (Incandescent)' => 'タングステン(白熱灯)',
        'Unknown' => '不明',
        'Warm White Fluorescent' => '暖白光色蛍光灯',
        'White Fluorescent' => '温白色蛍光灯',
      },
    },
   'LightSourceSpecial' => {
      Description => '光源スペシャル',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Lightness' => '明度',
   'LinearResponseLimit' => '線型反応限界',
   'LinearizationTable' => '線形化テーブル',
   'Lit' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'LiveViewExposureSimulation' => {
      Description => 'ライブビュー露出シミュレーション',
      PrintConv => {
        'Disable (LCD auto adjust)' => 'しない(適正表示)',
        'Enable (simulates exposure)' => 'する(撮影露出イメージ表示)',
      },
    },
   'LiveViewShooting' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'LocalizedCameraModel' => '限定カメラモデル',
   'Location' => '撮影場所',
   'LockMicrophoneButton' => {
      Description => 'プロテクト/録音ボタン タンの機能',
      PrintConv => {
        'Protect (hold:record memo)' => 'プロテクト(長押しで録音)',
        'Record memo (protect:disable)' => '録音(プロテクト不可)',
      },
    },
   'LongExposureNoiseReduction' => {
      Description => '長秒露光ノイズリダクション',
      PrintConv => {
        'Auto' => 'オート',
        'Off' => 'オフ',
        'On' => 'オン',
        'n/a' => '未設定',
      },
    },
   'LookupTable' => 'ルックアップテーブル',
   'LoopStyle' => {
      PrintConv => {
        'Normal' => '標準',
      },
    },
   'Luminance' => '輝度',
   'LuminanceNoiseReduction' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Off' => 'オフ',
      },
    },
   'MB-D10Batteries' => 'MB-D10電源タイプ',
   'MB-D10BatteryType' => 'MB-D10電源タイプ',
   'MB-D80Batteries' => 'MB-D80バッテリー',
   'MIEVersion' => 'MIEバージョン',
   'MIMEType' => 'MIMEタイプ',
   'MSStereo' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Macro' => {
      Description => 'マクロ',
      PrintConv => {
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Normal' => '標準',
        'Off' => 'オフ',
        'On' => 'オン',
        'Super Macro' => 'スーパーマクロ',
        'n/a' => '未設定',
      },
    },
   'MacroMode' => {
      Description => 'マクロモード',
      PrintConv => {
        'Macro' => 'マクロ',
        'Normal' => 'ノーマル',
        'Off' => 'オフ',
        'On' => 'オン',
        'Super Macro' => 'スーパーマクロ',
        'Tele-Macro' => 'テレマクロ',
      },
    },
   'MagnifiedView' => {
      Description => '拡大ズーム表示',
      PrintConv => {
        'Image playback only' => '再生時のみ',
        'Image review and playback' => '撮影直後と再生時',
      },
    },
   'MainDialExposureComp' => {
      Description => 'Main Dial 露出補正',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Make' => 'メーカー',
   'MakeAndModel' => '作成とモデル',
   'MakerNote' => 'DNGプライベートデータ',
   'MakerNoteOffset' => 'メーカーノートオフセット',
   'MakerNoteSafety' => {
      Description => 'メーカーノートセーフティ',
      PrintConv => {
        'Safe' => '安全',
        'Unsafe' => '危険',
      },
    },
   'MakerNoteType' => 'メーカーノートタイプ',
   'MakerNoteVersion' => 'メーカーノートバージョン',
   'MakerNotes' => 'メーカーノート',
   'ManometerPressure' => '気圧計圧力',
   'ManometerReading' => '気圧計高度',
   'ManualFlash' => 'マニュアルフラッシュ',
   'ManualFlashOutput' => {
      Description => 'マニュアルフラッシュ出力',
      PrintConv => {
        'Low' => 'ソフト',
        'n/a' => '該当無し',
      },
    },
   'ManualFocusDistance' => 'マニュアルフォーカス距離',
   'ManualTv' => {
      Description => 'マニュアル露出時Tv、Av値設定',
      PrintConv => {
        'Tv=Control/Av=Main' => 'Tv値=サブ電子ダイヤル/Av値=メイン電子ダイヤル',
        'Tv=Main/Av=Control' => 'Tv値=メイン電子ダイヤル/Av値=サブ電子ダイヤル',
      },
    },
   'ManufactureDate' => '製造日付？',
   'MaskedAreas' => 'マスク領域',
   'MasterDocumentID' => 'マスタ文書ID',
   'MasterGain' => 'マスターゲイン',
   'Matteing' => 'マッチング',
   'MaxAperture' => '最大絞り',
   'MaxApertureAtCurrentFocal' => '現在焦点距離の最大絞り',
   'MaxApertureAtMaxFocal' => '最大焦点時最大絞り',
   'MaxApertureAtMinFocal' => '最小焦点時最大絞り',
   'MaxApertureValue' => '最大レンズ口径',
   'MaxContinuousRelease' => '最大連写レリーズ',
   'MaxFocalLength' => '最大焦点距離',
   'MaxSampleValue' => '最大サンプル値',
   'MaximumDensityRange' => '最大密度範囲',
   'MeasuredEV' => '計測EV',
   'Measurement' => '測定オブザーバー',
   'MeasurementBacking' => 'バック測定',
   'MeasurementFlare' => 'フレア測定',
   'MeasurementGeometry' => '幾何学測定',
   'MeasurementIlluminant' => '光源測定',
   'MeasurementObserver' => '測定オブザーバー',
   'MediaBlackPoint' => 'メディア黒点',
   'MediaType' => {
      PrintConv => {
        'Movie' => '動画',
        'Normal' => '標準',
      },
    },
   'MediaWhitePoint' => 'メディア白点',
   'Medium' => 'ミドル',
   'MenuButtonDisplayPosition' => {
      Description => 'メニューの表示位置',
      PrintConv => {
        'Previous' => '直前のメニュー',
        'Previous (top if power off)' => '直前のメニュー（電源切で先頭）',
        'Top' => 'メニューの先頭',
      },
    },
   'MenuButtonReturn' => {
      PrintConv => {
        'Previous' => '直前のメニュー',
        'Top' => '上',
      },
    },
   'Metering' => {
      Description => '測光',
      PrintConv => {
        'Center-weighted' => '中央重点',
        'Matrix' => '分割',
        'Spot' => 'スポット',
      },
    },
   'MeteringMode' => {
      Description => '測光モード',
      PrintConv => {
        'Average' => '平均',
        'Center-weighted average' => '中央重点',
        'Default' => 'デフォルト',
        'Evaluative' => '評価',
        'Multi-segment' => 'パターン',
        'Multi-spot' => 'マルチスポット',
        'Other' => 'その他',
        'Partial' => '部分',
        'Pattern+AF' => 'パターン+AF',
        'Spot' => 'スポット',
        'Spot+Highlight control' => 'スポット+ハイライトコントロール',
        'Spot+Shadow control' => 'スポット+シャドウコントロール',
        'Unknown' => '不明',
      },
    },
   'MeteringMode2' => {
      Description => '測光モード2',
      PrintConv => {
        'Multi-segment' => 'パターン',
      },
    },
   'MeteringMode3' => {
      Description => '測光モード3',
      PrintConv => {
        'Multi-segment' => 'パターン',
      },
    },
   'MeteringTime' => '自動オフタイマー メータオフ時間',
   'MinAperture' => '最小絞り',
   'MinFocalLength' => '最小焦点距離',
   'MinSampleValue' => '最小サンプル値',
   'MinoltaCameraSettings2' => 'カメラ設定2',
   'MinoltaCameraSettings5D' => 'カメラ設定(5D)',
   'MinoltaCameraSettings7D' => 'カメラ設定(7D)',
   'MinoltaDate' => '日付',
   'MinoltaImageSize' => {
      Description => 'イメージサイズ',
      PrintConv => {
        'Full' => 'フル',
        'Large' => 'ラージ',
        'Medium' => 'ミドル',
        'Small' => 'スモール',
      },
    },
   'MinoltaMakerNote' => 'ミノルタメーカーノート',
   'MinoltaModelID' => 'モデルID',
   'MinoltaQuality' => {
      Description => 'イメージ品質',
      PrintConv => {
        'Economy' => 'エコノミー',
        'Extra Fine' => 'エクストラファイン',
        'Extra fine' => 'エクストラファイン',
        'Fine' => 'ファイン',
        'Normal' => '標準',
        'Standard' => 'スタンダード',
        'Super Fine' => 'スーパーファイン',
      },
    },
   'MinoltaTime' => '時間',
   'MirrorLockup' => {
      Description => 'ミラーアップ撮影',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
        'Enable: Down with Set' => 'する(SETボタンでダウン)',
      },
    },
   'Model' => '画像入力機器モデル',
   'Model2' => '画像入力機器モデル(2)',
   'ModelTiePoint' => 'モデル拘束ポイントタグ',
   'ModelTransform' => 'モデル変化タグ',
   'ModelingFlash' => {
      Description => 'モデリングフラッシュ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ModifiedPictureStyle' => {
      PrintConv => {
        'CM Set 1' => 'CMセット1',
        'CM Set 2' => 'CMセット2',
        'Faithful' => '忠実設定',
        'High Saturation' => '高彩度',
        'Landscape' => '風景',
        'Low Saturation' => '低彩度',
        'Monochrome' => 'モノトーン',
        'Neutral' => 'ニュートラル',
        'None' => '無し',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
        'User Def. 1' => 'ユーザ設定1',
        'User Def. 2' => 'ユーザ設定2',
        'User Def. 3' => 'ユーザ設定3',
      },
    },
   'ModifiedSaturation' => {
      Description => '彩度修正',
      PrintConv => {
        'CM1 (Red Enhance)' => 'CM1 (赤増)',
        'CM2 (Green Enhance)' => 'CM2 (緑増)',
        'CM3 (Blue Enhance)' => 'CM3 (青増)',
        'CM4 (Skin Tones)' => 'CM4 (肌色増)',
        'Off' => 'オフ',
      },
    },
   'ModifiedSharpnessFreq' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Standard' => 'スタンダード',
        'n/a' => '該当無し',
      },
    },
   'ModifiedToneCurve' => {
      PrintConv => {
        'Custom' => 'カスタム',
        'Manual' => 'マニュアル',
        'Standard' => 'スタンダード',
      },
    },
   'ModifiedWhiteBalance' => {
      PrintConv => {
        'Auto' => 'オート',
        'Black & White' => '白黒',
        'Cloudy' => '曇り',
        'Custom' => 'カスタム',
        'Custom 1' => 'カスタム1',
        'Custom 2' => 'カスタム2',
        'Custom 3' => 'カスタム3',
        'Custom 4' => 'カスタム4',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'Manual Temperature (Kelvin)' => 'マニュアル白熱灯（ケルビン）',
        'PC Set1' => 'PC設定1',
        'PC Set2' => 'PC設定2',
        'PC Set3' => 'PC設定3',
        'PC Set4' => 'PC設定4',
        'PC Set5' => 'PC設定5',
        'Shade' => '日陰',
        'Tungsten' => 'タングステン(白熱灯)',
        'Underwater' => '水中',
      },
    },
   'ModifyDate' => 'ファイル作成日時',
   'MoireFilter' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'MonitorOffTime' => 'モニターオフ遅延時間',
   'MonochromeFilterEffect' => {
      PrintConv => {
        'Green' => '緑',
        'None' => '無し',
        'Orange' => 'オレンジ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'MonochromeLinear' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'MonochromeToningEffect' => {
      PrintConv => {
        'Blue' => '青',
        'Green' => '緑',
        'None' => '無し',
        'Purple' => '紫',
        'Sepia' => 'セピア',
      },
    },
   'MultiExposure' => '多重露出データ',
   'MultiExposureAutoGain' => {
      Description => '多重露出自動ゲイン',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'MultiExposureMode' => {
      Description => '多重露出モード',
      PrintConv => {
        'Image Overlay' => 'イメージオーバーレイ',
        'Multiple Exposure' => '多重露出',
        'Off' => 'オフ',
      },
    },
   'MultiExposureShots' => '多重露出ショット',
   'MultiExposureVersion' => '多重露出データバージョン',
   'MultiFrameNoiseReduction' => {
      Description => 'マルチショットノイズリダクション',
      PrintConv => {
        'Off' => '切',
        'On' => '入',
      },
    },
   'MultiSample' => 'マルチサンプル',
   'MultiSelector' => {
      Description => 'マルチ選択',
      PrintConv => {
        'Do Nothing' => '何もしない',
        'Reset Meter-off Delay' => 'メーターオフ遅延時間リセット',
      },
    },
   'MultiSelectorPlaybackMode' => {
      Description => 'マルチ選択 再生モード',
      PrintConv => {
        'Choose Folder' => 'フォルダー選択',
        'Thumbnail On/Off' => 'サムネイル　オン/オフ',
        'View Histograms' => 'ヒストグラム表示',
        'Zoom On/Off' => 'ズーム　オン/オフ',
      },
    },
   'MultiSelectorShootMode' => {
      Description => 'マルチ選択 撮影モード',
      PrintConv => {
        'Highlight Active Focus Point' => 'ハイライトアクティブフォーカスポイント',
        'Not Used' => '未使用',
        'Select Center Focus Point' => '中央フォーカスポイント選択',
      },
    },
   'MultipleExposureSet' => {
      Description => '多重露出設定',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Mute' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'MyColorMode' => {
      Description => 'マイカラーモード',
      PrintConv => {
        'B&W' => '白黒',
        'Color Accent' => 'カラーアクセント',
        'Color Swap' => 'スイッチカラー',
        'Custom' => 'カスタム',
        'Dark Skin Tone' => 'ダークスキン調',
        'Light Skin Tone' => 'ライトスカイ調',
        'Neutral' => 'ニュートラル',
        'Off' => 'オフ',
        'Positive Film' => 'ポジフィルム',
        'Sepia' => 'セピア',
        'Vivid' => 'ビビッド',
        'Vivid Blue' => 'ビビッド青',
        'Vivid Green' => 'ビビッド緑',
        'Vivid Red' => 'ビビッド赤',
      },
    },
   'MyColors' => 'マイカラーモード',
   'NDFilter' => {
      Description => 'NDフィルター',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'NEFCompression' => {
      Description => 'RAW圧縮',
      PrintConv => {
        'Lossless' => 'ロスレス',
        'Lossy (type 1)' => '圧縮（タイプ１）',
        'Lossy (type 2)' => '圧縮（タイプ２）',
        'Uncompressed' => '非圧縮',
      },
    },
   'NEFLinearizationTable' => '線形化表',
   'NamedColor2' => '色名称2',
   'NativeDisplayInfo' => 'ネイティブディスプレイ情報',
   'NewsPhotoVersion' => '報道写真レコードバージョン',
   'NikonCaptureData' => 'ニコンキャプチャーデータ',
   'NikonCaptureOffsets' => 'ニコンキャプチャーオフセット',
   'NikonCaptureVersion' => 'ニコンキャプチャーバージョン',
   'NoMemoryCard' => {
      Description => 'メモリーカード無し',
      PrintConv => {
        'Enable Release' => 'レリーズ可能',
        'Release Locked' => 'レリーズロック',
      },
    },
   'Noise' => 'ノイズ',
   'NoiseFilter' => {
      Description => 'ピクチャーモードノイズフィルター',
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Off' => 'オフ',
        'Standard' => 'スタンダード',
      },
    },
   'NoiseReduction' => {
      Description => 'ノイズリダクション',
      PrintConv => {
        'Auto' => 'オート',
        'Low' => '低い',
        'Normal' => '標準',
        'Off' => 'オフ',
        'On' => 'オン',
        'Standard' => 'スタンダード',
      },
    },
   'NoiseReduction2' => 'ノイズリダクション2',
   'NoiseReductionApplied' => '適用ノイズリダクション',
   'NoiseReductionData' => 'ノイズリダクションデータ',
   'NoiseReductionIntensity' => 'ノイズリダクション強度',
   'NoiseReductionMethod' => 'ノイズリダクション方法',
   'NoiseReductionSharpness' => 'ノイズリダクションシャープネス',
   'NominalMaxAperture' => '最大絞り',
   'NominalMinAperture' => '最小絞り',
   'NumAFPoints' => 'AFポイント番号',
   'NumIndexEntries' => 'インデックスエントリ数',
   'NumberofInks' => 'インク番号',
   'OPIProxy' => 'OPIプロキシー',
   'ObjectAttributeReference' => 'インテリジャンル',
   'ObjectCycle' => 'オブジェクトサイクル',
   'ObjectDistance' => '被写体との距離',
   'ObjectFileType' => {
      PrintConv => {
        'None' => '無し',
        'Unknown' => '不明',
      },
    },
   'ObjectName' => 'タイトル',
   'ObjectPreviewData' => 'オブジェクトデータプレビューデータ',
   'ObjectPreviewFileFormat' => 'オブジェクトデータプレビューファイル形式',
   'ObjectPreviewFileVersion' => 'オブジェクトデータプレビューファイル形式バージョン',
   'ObjectTypeReference' => 'オブジェクトタイプ参照',
   'OffsetSchema' => 'オフセットの概要',
   'OlympusImageHeight' => 'イメージ高',
   'OlympusImageWidth' => 'イメージ幅',
   'OneTouchWB' => {
      Description => 'ワンタッチホワイトバランス',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
        'On (Preset)' => 'オン（プリセット）',
      },
    },
   'OpticalZoomCode' => '光学ズームコード',
   'OpticalZoomMode' => {
      Description => '光学ズームモード',
      PrintConv => {
        'Extended' => 'EX光学',
        'Standard' => 'スタンダード',
      },
    },
   'OpticalZoomOn' => {
      Description => '光学ズームオン',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Opto-ElectricConvFactor' => '光電交換関数',
   'OrderNumber' => 'オーダー番号',
   'Orientation' => {
      Description => '画像の向き',
      PrintConv => {
        'Horizontal (normal)' => '水平（標準）',
        'Rotate 180' => '180度回転',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
      },
    },
   'OriginalDecisionDataOffset' => 'オリジナル決定データオフセット',
   'OriginalRawFileData' => 'オリジナルRAWファイルデータ',
   'OriginalRawFileDigest' => 'オリジナルRAWファイル要約',
   'OriginalRawFileName' => 'オリジナルRAWファイル名',
   'OriginalTransmissionReference' => '作業識別子',
   'OriginatingProgram' => '開始プログラム',
   'OutputResponse' => '出力反応',
   'OwnerID' => 'オーナーID',
   'OwnerName' => 'オーナー名',
   'PEFVersion' => 'PEFバージョン',
   'Padding' => '引き伸ばし',
   'PageName' => 'ページ名',
   'PageNumber' => 'ページ番号',
   'PanasonicExifVersion' => 'パナソニックExifバージョン',
   'PanasonicRawVersion' => 'パナソニックRAWバージョン',
   'PanasonicTitle' => 'タイトル',
   'PanoramaDirection' => 'F値',
   'PanoramaMode' => 'パノラマモード',
   'PentaxImageSize' => 'ペンタックスイメージサイズ',
   'PentaxModelID' => 'ペンタックスモデル',
   'PentaxVersion' => 'ペンタックスバージョン',
   'People' => '人々',
   'PhaseDetectAF' => {
      Description => 'オートフォーカス',
      PrintConv => {
        'Off' => 'オフ',
        'On (51-point)' => 'オン',
      },
    },
   'PhotoEffect' => {
      Description => '写真効果',
      PrintConv => {
        'B&W' => '白黒',
        'Custom' => 'カスタム',
        'Neutral' => 'ニュートラル',
        'Off' => 'オフ',
        'Sepia' => 'セピア',
        'Vivid' => 'ビビッド',
      },
    },
   'PhotoEffects' => {
      Description => 'フォトエフェクト',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'PhotoEffectsBlue' => 'フォトエフェクト青',
   'PhotoEffectsData' => 'フォトエフェクトデータ',
   'PhotoEffectsGreen' => 'フォトエフェクト緑',
   'PhotoEffectsRed' => 'フォトエフェクト赤',
   'PhotoEffectsType' => {
      Description => 'フォトエフェクトタイプ',
      PrintConv => {
        'B&W' => '白黒',
        'None' => '無し',
        'Sepia' => 'セピア',
        'Tinted' => '淡調',
      },
    },
   'PhotoInfoPlayback' => {
      Description => '写真情報/再生',
      PrintConv => {
        'Info Left-right, Playback Up-down' => '情報<>/再生',
        'Info Up-down, Playback Left-right' => '情報/再生<>',
      },
    },
   'PhotometricInterpretation' => {
      Description => 'ピクセル形式',
      PrintConv => {
        'BlackIsZero' => '黒はゼロ',
        'Color Filter Array' => 'CFA (カラーフィルターマトリックス)',
        'Pixar LogL' => 'CIE Log2(L) (ログ輝度)',
        'Pixar LogLuv' => 'CIE Log2(L)(u\',v\') (ログ輝度と基準色)',
        'RGB Palette' => 'パレット色',
        'Transparency Mask' => '透明度マスク',
        'WhiteIsZero' => '白はゼロ',
      },
    },
   'PhotoshopAnnotations' => 'フォトショップ注釈',
   'PhotoshopFormat' => {
      PrintConv => {
        'Standard' => 'スタンダード',
      },
    },
   'PictInfo' => '写真情報',
   'PictureControl' => {
      Description => 'ピクチャーコントロール',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'PictureControlActive' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'PictureControlAdjust' => {
      Description => 'ピクチャーコントロール調整',
      PrintConv => {
        'Default Settings' => 'デフォルト設定',
        'Full Control' => 'フルコントロール',
        'Quick Adjust' => 'クイック調整',
      },
    },
   'PictureControlBase' => 'ピクチャーコントロールベース',
   'PictureControlName' => 'ピクチャーコントロール名',
   'PictureControlQuickAdjust' => 'ピクチャーコントロールクイック調整',
   'PictureControlVersion' => 'ピクチャーコントロールバージョン',
   'PictureFinish' => {
      Description => 'ピクチャーフィニッシュ',
      PrintConv => {
        'Monochrome' => 'モノトーン',
        'Natural' => 'ナチュラル',
        'Night Portrait' => '人物夜景',
        'Night Scene' => '夜景',
        'Portrait' => 'ポートレート',
      },
    },
   'PictureMode' => {
      Description => 'ピクチャーモード',
      PrintConv => {
        '1/2 EV steps' => '1/2 EVステップ',
        '1/3 EV steps' => '1/3 EVステップ',
        'Anti-blur' => '手振れ補正',
        'Aperture Priority' => '絞り優先',
        'Aperture Priority, Off-Auto-Aperture' => '絞り優先（自動絞りOFF）',
        'Aperture-priority AE' => '絞り優先',
        'Auto' => 'オート',
        'Auto PICT (Landscape)' => 'オートピクチャー（風景）',
        'Auto PICT (Macro)' => 'オートピクチャー（マクロ）',
        'Auto PICT (Portrait)' => 'オートピクチャー（ポートレート）',
        'Auto PICT (Sport)' => 'オートピクチャー（スポーツ）',
        'Auto PICT (Standard)' => 'オートピクチャー（標準）',
        'Autumn' => '秋',
        'Beach' => 'ビーチ',
        'Beach & Snow' => 'ビーチ＆スノー',
        'Blur Reduction' => 'Digital SR',
        'Bulb' => 'バルブ',
        'Bulb, Off-Auto-Aperture' => 'バルブ（自動絞りOFF）',
        'Candlelight' => 'キャンドルライト',
        'DOF Program' => '深度優先プログラム',
        'DOF Program (HyP)' => '深度優先プログラム（ハイパープログラム）',
        'Dark Pet' => 'ペット黒色',
        'Digital Filter' => 'デジタルフィルター',
        'Fireworks' => '花火',
        'Flash X-Sync Speed AE' => 'ストロボ同調速度AE',
        'Flower' => '花',
        'Food' => '料理',
        'Frame Composite' => 'フレーム合成',
        'Green Mode' => 'グリーンモード',
        'Hi-speed Program' => '高速優先プログラム',
        'Hi-speed Program (HyP)' => '高速優先プログラム（ハイパープログラム）',
        'Illustrations' => 'イラスト',
        'Kids' => 'キッズ',
        'Landscape' => '風景',
        'Light Pet' => 'ペット白色',
        'MTF Program' => 'MTF優先プログラム',
        'MTF Program (HyP)' => 'MTF優先プログラム（ハイパープログラム）',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Manual, Off-Auto-Aperture' => 'マニュアル（自動絞りOFF）',
        'Medium Pet' => 'ペット灰色',
        'Monotone' => 'モノトーン',
        'Museum' => '美術館',
        'Muted' => '弱める',
        'Natural' => 'ナチュラル',
        'Natural Light' => 'ナチュラルフォト',
        'Natural Light & Flash' => 'ナチュラルフォト＆フラッシュ',
        'Natural Skin Tone' => '美肌',
        'Night Scene' => '夜景',
        'Night Scene Portrait' => '人物、夜景',
        'No Flash' => 'フラッシュ無し',
        'Panorama' => 'パノラマ',
        'Party' => 'パーティ',
        'Pet' => 'ペット',
        'Portrait' => 'ポートレート',
        'Program' => 'プログラム',
        'Program (HyP)' => 'プログラムAE（ハイパープログラム）',
        'Program AE' => 'プログラムAE',
        'Program Av Shift' => 'プログラムAvシフト',
        'Program Tv Shift' => 'プログラムTvシフト',
        'Self Portrait' => '自分撮り',
        'Sensitivity Priority AE' => '感度優先AE',
        'Sepia' => 'セピア',
        'Shutter & Aperture Priority AE' => 'シャッター＆絞り優先AE',
        'Shutter Speed Priority' => 'シャッター優先',
        'Shutter speed priority AE' => 'シャッター優先',
        'Snow' => 'スノー',
        'Soft' => 'ソフト',
        'Sport' => 'スポーツ',
        'Sports' => 'スポーツ',
        'Standard' => 'スタンダード',
        'Sunset' => '夕日',
        'Surf & Snow' => 'サーフ＆スノー',
        'Synchro Sound Record' => 'ボイスレコーディング',
        'Text' => 'テキスト',
        'Underwater' => '水中',
        'Vivid' => 'ビビッド',
      },
    },
   'PictureMode2' => {
      Description => 'ピクチャーモード 2',
      PrintConv => {
        'Aperture Priority' => '絞り優先',
        'Aperture Priority, Off-Auto-Aperture' => '絞り優先（自動絞りオフ）',
        'Auto PICT' => 'オートピクチャ',
        'Bulb' => 'バルブ',
        'Bulb, Off-Auto-Aperture' => 'バルブ（自動絞りオフ）',
        'Flash X-Sync Speed AE' => 'ストロボ同調速度AE',
        'Green Mode' => 'グリーンモード',
        'Manual' => 'マニュアル',
        'Manual, Off-Auto-Aperture' => 'マニュアル（自動絞りオフ）',
        'Program AE' => 'プログラムAE',
        'Program Av Shift' => 'プログラムAvシフト',
        'Program Tv Shift' => 'プログラムTvシフト',
        'Scene Mode' => 'シーンモード',
        'Sensitivity Priority AE' => '感度優先AE',
        'Shutter & Aperture Priority AE' => 'シャッター＆絞り優先AE',
        'Shutter Speed Priority' => 'シャッター優先',
      },
    },
   'PictureModeBWFilter' => {
      Description => 'ピクチャーモードBWフィルター',
      PrintConv => {
        'Green' => '緑',
        'Neutral' => 'ニュートラル',
        'Orange' => 'オレンジ',
        'Red' => '赤',
        'Yellow' => '黄色',
        'n/a' => '該当無し',
      },
    },
   'PictureModeContrast' => 'ピクチャーモードコントラスト',
   'PictureModeHue' => 'ピクチャーモード色相？',
   'PictureModeSaturation' => 'ピクチャーモード彩度',
   'PictureModeSharpness' => 'ピクチャーモードシャープネス',
   'PictureModeTone' => {
      Description => 'ピクチャーモードトーン',
      PrintConv => {
        'Blue' => '青',
        'Green' => '緑',
        'Neutral' => 'ニュートラル',
        'Purple' => '紫',
        'Sepia' => 'セピア',
        'n/a' => '該当無し',
      },
    },
   'PictureStyle' => {
      Description => 'ピクチャースタイル',
      PrintConv => {
        'CM Set 1' => 'CMセット1',
        'CM Set 2' => 'CMセット2',
        'Faithful' => '忠実設定',
        'High Saturation' => '高彩度',
        'Landscape' => '風景',
        'Low Saturation' => '低彩度',
        'Monochrome' => 'モノトーン',
        'Neutral' => 'ニュートラル',
        'None' => '無し',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
        'User Def. 1' => 'ユーザ設定1',
        'User Def. 2' => 'ユーザ設定2',
        'User Def. 3' => 'ユーザ設定3',
      },
    },
   'PixelFormat' => {
      Description => 'ピクセルフォーマット',
      PrintConv => {
        'Black & White' => '白黒',
      },
    },
   'PixelIntensityRange' => 'ピクセル強度範囲',
   'PixelScale' => 'モデル画素スケールタグ',
   'PixelUnits' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'PlanarConfiguration' => {
      Description => '画像データの並び',
      PrintConv => {
        'Chunky' => '点順次形式 (重ね合わせ)',
        'Planar' => '平面形式',
      },
    },
   'PowerSource' => {
      Description => '電源',
      PrintConv => {
        'Body Battery' => '本体電源',
        'External Power Supply' => '外部電源',
        'Grip Battery' => 'バッテリーグリップ',
      },
    },
   'PreCaptureFrames' => 'プレキャプチャーフレーム',
   'Predictor' => '指標',
   'Preview' => 'プレビューIFDポインター',
   'Preview0' => 'プレビュー0',
   'Preview1' => 'プレビュー1',
   'Preview2' => 'プレビュー2',
   'PreviewApplicationName' => 'プレビューアプリケーション名',
   'PreviewApplicationVersion' => 'プレビューアプリケーションバージョン',
   'PreviewColorSpace' => {
      Description => 'プレビュー色空間',
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'PreviewDateTime' => 'プレビュー日時',
   'PreviewIFD' => 'プレビューIFDポインター',
   'PreviewImage' => 'プレビューイメージ',
   'PreviewImageBorders' => 'プレビュー画像境界',
   'PreviewImageData' => 'プレビュー画像データ',
   'PreviewImageLength' => 'プレビューイメージ容量',
   'PreviewImageSize' => 'プレビューイメージサイズ',
   'PreviewImageStart' => 'プレビューイメージ開始',
   'PreviewImageValid' => {
      Description => '有効プレビュー画像',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'PreviewQuality' => {
      PrintConv => {
        'Economy' => 'エコノミー',
        'Fine' => 'ファイン',
        'Normal' => '標準',
        'Normal Movie' => '標準動画',
        'Superfine' => 'S.ファイン',
      },
    },
   'PreviewSettingsDigest' => 'プレビュー設定要約',
   'PreviewSettingsName' => 'プレビュー設定名',
   'PrimaryAFPoint' => {
      Description => 'プライマリAFポイント',
      PrintConv => {
        'Bottom' => '下',
        'C6 (Center)' => 'C6 (中央)',
        'Center' => '中央',
        'Mid-left' => '中央左',
        'Mid-right' => '中央右',
        'Top' => '上',
      },
    },
   'PrimaryChromaticities' => '原色色度',
   'PrimaryPlatform' => '主要プラットフォーム',
   'PrintIM' => 'プリントイメージマッチング',
   'ProcessingSoftware' => '処理ソフトウェア',
   'ProductID' => '製品ID',
   'ProductionCode' => 'カメラが修理されたか？',
   'ProfileCMMType' => 'CMMタイププロフィール',
   'ProfileCalibrationSig' => 'プロフィールキャリブレーションサイン',
   'ProfileClass' => {
      Description => 'プロフィールクラス',
      PrintConv => {
        'Abstract Profile' => '抜粋プロフィール',
        'ColorSpace Conversion Profile' => '色空間変換プロフィール',
        'DeviceLink Profile' => 'デバイスリンクプロフィール',
        'Display Device Profile' => '表示装置プロフィール',
        'Input Device Profile' => '入力装置プロフィール',
        'NamedColor Profile' => '色名称プロフィール',
        'Nikon Input Device Profile (NON-STANDARD!)' => 'ニコンプロフィール("nkpf")',
        'Output Device Profile' => '出力装置プロフィール',
      },
    },
   'ProfileConnectionSpace' => '接続スペースプロフィール',
   'ProfileCopyright' => 'プロフィール著作権',
   'ProfileCreator' => 'プロフィール製作者',
   'ProfileDateTime' => 'プロフィール日時',
   'ProfileDescription' => 'プロフィール説明',
   'ProfileDescriptionML' => 'プロフィール説明ML',
   'ProfileEmbedPolicy' => {
      Description => 'プロフィール埋め込み方針',
      PrintConv => {
        'Allow Copying' => 'コピー許可',
        'Embed if Used' => '埋め込み使用',
        'Never Embed' => '埋め込み禁止',
        'No Restrictions' => '無制限',
      },
    },
   'ProfileFileSignature' => 'プロフィールファイルシグネーチャ',
   'ProfileHueSatMapData1' => '色相Sat.マップデータプロフィール1',
   'ProfileHueSatMapData2' => '色相Sat.マップデータプロフィール2',
   'ProfileHueSatMapDims' => '色境界',
   'ProfileID' => 'プロフィールID',
   'ProfileLookTableData' => '表示テーブルデータプロフィール',
   'ProfileLookTableDims' => '色境界',
   'ProfileName' => 'プロフィール名',
   'ProfileSequenceDesc' => 'プロフィールシーケンス説明',
   'ProfileToneCurve' => 'トーンカーブプロフィール',
   'ProfileVersion' => 'プロフィールバージョン',
   'ProgramISO' => 'プログラムISO',
   'ProgramLine' => {
      Description => 'プログラムライン',
      PrintConv => {
        'Depth' => '深度優先',
        'Hi Speed' => '高速優先',
        'MTF' => 'MTF優先',
        'Normal' => 'ノーマル',
      },
    },
   'ProgramMode' => {
      PrintConv => {
        'Night Portrait' => '人物夜景',
        'None' => '無し',
        'Portrait' => 'ポートレート',
        'Sports' => 'スポーツ',
        'Sunset' => '夕日',
        'Text' => 'テキスト',
      },
    },
   'ProgramShift' => 'プログラムシフト',
   'ProgramVersion' => 'プログラムバージョン',
   'Province-State' => '行政区/州',
   'Quality' => {
      Description => '品質',
      PrintConv => {
        'Best' => 'S.ファイン',
        'Better' => 'ファイン',
        'Compressed RAW' => 'cRAW',
        'Compressed RAW + JPEG' => 'cRAW+JPEG',
        'Economy' => 'エコノミー',
        'Extra Fine' => 'エクストラファイン',
        'Fine' => 'ファイン',
        'Good' => 'エコノミー',
        'Low' => '低画質',
        'Normal' => 'ノーマル',
        'Premium' => 'プレミアム',
        'RAW + JPEG' => 'RAW+JPEG',
        'Standard' => 'スタンダード',
        'n/a' => '未設定',
      },
    },
   'QualityMode' => {
      Description => '品質モード',
      PrintConv => {
        'Economy' => 'エコノミー',
        'Fine' => 'ファイン',
        'Normal' => 'ノーマル',
      },
    },
   'QuantizationMethod' => '量子化方法',
   'QuickAdjust' => 'クイック調整',
   'QuickControlDialInMeter' => {
      Description => '測光タイマー中のサブ電子ダイヤル',
      PrintConv => {
        'AF point selection' => 'AFフレーム選択',
        'Exposure comp/Aperture' => '露出補正/絞り数値',
        'ISO speed' => 'ISO感度',
      },
    },
   'QuickShot' => {
      Description => 'クイックショット',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'RAFVersion' => 'RAFバージョン',
   'ROCInfo' => 'ROC情報',
   'RasterPadding' => 'ラスタパディング',
   'RasterizedCaption' => 'ラスタ化表題',
   'Rating' => '格付け',
   'RatingPercent' => '格付け(%)',
   'RawAndJpgRecording' => {
      Description => 'RAWとJPEG記録',
      PrintConv => {
        'RAW+Large/Fine' => 'RAW+ラージ／ファイン',
        'RAW+Large/Normal' => 'RAW+ラージ／ノーマル',
        'RAW+Medium/Fine' => 'RAW+ミドル／ファイン',
        'RAW+Medium/Normal' => 'RAW+ミドル／ノーマル',
        'RAW+Small/Fine' => 'RAW+スモール／ファイン',
        'RAW+Small/Normal' => 'RAW+スモール／ノーマル',
      },
    },
   'RawColorAdj' => {
      PrintConv => {
        'Custom' => 'カスタム',
        'Faithful' => '忠実設定',
      },
    },
   'RawDataOffset' => 'RAWデータオフセット',
   'RawDataUniqueID' => 'RAWデータユニークID',
   'RawDevAutoGradation' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'RawDevColorSpace' => '色空間',
   'RawDevContrastValue' => 'コントラスト値',
   'RawDevEditStatus' => {
      Description => '編集状態',
      PrintConv => {
        'Edited (Landscape)' => 'スタジオ（風景）',
        'Edited (Portrait)' => 'スタジオ（ポートレート）',
        'Original' => 'オリジナル',
      },
    },
   'RawDevEngine' => {
      Description => 'エンジン',
      PrintConv => {
        'Advanced High Speed' => 'アドバンス高速',
        'High Function' => '高機能',
        'High Speed' => '高速',
      },
    },
   'RawDevExposureBiasValue' => '露出バイアス値',
   'RawDevGrayPoint' => 'グレーポイント',
   'RawDevMemoryColorEmphasis' => '記憶色強調',
   'RawDevNoiseReduction' => 'ノイズフィルター（増感）',
   'RawDevPMPictureTone' => {
      PrintConv => {
        'Blue' => '青',
        'Green' => '緑',
        'Neutral' => 'ニュートラル',
        'Purple' => '紫',
        'Sepia' => 'セピア',
      },
    },
   'RawDevPM_BWFilter' => {
      PrintConv => {
        'Green' => '緑',
        'Neutral' => 'ニュートラル',
        'Orange' => 'オレンジ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'RawDevPictureMode' => {
      PrintConv => {
        'Natural' => 'ナチュラル',
        'Sepia' => 'セピア',
        'Vivid' => 'ビビッド',
      },
    },
   'RawDevSaturationEmphasis' => '彩度強調',
   'RawDevSettings' => 'ノイズリダクション',
   'RawDevSharpnessValue' => 'コントラスト値',
   'RawDevVersion' => 'RAW展開バージョン',
   'RawDevWBFineAdjustment' => 'ホワイトバランス微調整',
   'RawDevWhiteBalance' => {
      PrintConv => {
        'Color Temperature' => '色温度',
      },
    },
   'RawDevWhiteBalanceValue' => 'ホワイトバランス値',
   'RawImageCenter' => 'RAWイメージセンター',
   'RawImageDigest' => 'RAWイメージ要約',
   'RawImageHeight' => 'イメージ高さ',
   'RawImageSegmentation' => 'RAWイメージ部分番号',
   'RawImageSize' => 'RAWイメージサイズ',
   'RawImageWidth' => 'イメージ幅',
   'RawInfoVersion' => 'RAW情報バージョン',
   'RawJpgQuality' => {
      Description => 'RAW JPEG　品質',
      PrintConv => {
        'Economy' => 'エコノミー',
        'Fine' => 'ファイン',
        'Normal' => '標準',
        'Normal Movie' => '標準動画',
        'Superfine' => 'S.ファイン',
      },
    },
   'RawJpgSize' => {
      Description => 'RAW JPEG サイズ',
      PrintConv => {
        'Large' => 'ラージ',
        'Medium' => 'ミドル',
        'Medium 1' => 'ミドル1',
        'Medium 2' => 'ミドル2',
        'Medium 3' => 'ミドル3',
        'Medium Movie' => 'ミディアム動画',
        'Postcard' => 'ハガキ',
        'Small' => 'スモール',
        'Small Movie' => 'スモール動画',
        'Widescreen' => 'ワイド画面',
      },
    },
   'RecordMode' => {
      Description => '記録モード',
      PrintConv => {
        'Aperture Priority' => '絞り優先',
        'Best Shot' => 'ベストショット',
        'Manual' => 'マニュアル',
        'Movie' => '動画',
        'Movie (19)' => '動画（19）',
        'Program AE' => 'プログラムAE',
        'Shutter Priority' => 'シャッター優先',
        'YouTube Movie' => 'YouTube動画',
      },
    },
   'RecordShutterRelease' => 'レコードシャッターレリーズ',
   'RecordingMode' => {
      Description => '記録モード',
      PrintConv => {
        'Auto' => 'オート',
        'Landscape' => '風景',
        'Manual' => 'マニュアル',
        'Night Scene' => '夜景',
        'Panorama' => 'パノラマ',
        'Portrait' => 'ポートレート',
        'Single Shutter' => 'シングルシャッター',
      },
    },
   'RedBalance' => 'レッドバランス',
   'RedEyeCorrection' => {
      PrintConv => {
        'Automatic' => 'オート',
        'Off' => 'オフ',
      },
    },
   'RedEyeData' => '赤目データ',
   'RedEyeReduction' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'RedMatrixColumn' => '赤色マトリックス列',
   'RedTRC' => '赤色調増殖曲線',
   'ReductionMatrix1' => '縮小マトリックス1',
   'ReductionMatrix2' => '縮小マトリックス2',
   'ReferenceBlackWhite' => '白黒の基準値の一組',
   'ReferenceDate' => '参照日付',
   'ReferenceNumber' => '参照数',
   'ReferenceService' => '参照サービス',
   'RelatedImageFileFormat' => '関連イメージファイル形式',
   'RelatedImageHeight' => '関連イメージ高',
   'RelatedImageWidth' => '関連イメージ幅',
   'RelatedSoundFile' => '関連オーディオファイル',
   'ReleaseButtonToUseDial' => {
      Description => 'レリーズボタンから使用ダイヤル',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ReleaseDate' => 'リリース日付',
   'ReleaseTime' => 'リリース時間',
   'RemoteOnDuration' => 'リモート持続時間',
   'RenderingIntent' => {
      Description => '意思表現',
      PrintConv => {
        'ICC-Absolute Colorimetric' => '絶対比色分析',
        'Media-Relative Colorimetric' => '相対比色分析',
        'Perceptual' => '知覚的',
        'Saturation' => '飽和',
      },
    },
   'RepeatingFlashCount' => 'リピーティングフラッシュ 時間',
   'RepeatingFlashOutput' => 'リピーティングフラッシュ 出力',
   'RepeatingFlashRate' => 'リピーティングフラッシュ 周波数',
   'ResampleParamsQuality' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
      },
    },
   'Resaved' => {
      Description => '予約',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ResolutionMode' => '解像度モード',
   'ResolutionUnit' => {
      Description => 'XとY解像度単位',
      PrintConv => {
        'None' => '無し',
        'cm' => 'ピクセル/cm',
        'inches' => 'インチ',
      },
    },
   'RetouchHistory' => {
      Description => 'レタッチ履歴',
      PrintConv => {
        'None' => '無し',
        'Sepia' => 'セピア',
      },
    },
   'ReverseIndicators' => '指標逆転',
   'Rotation' => {
      Description => '回転',
      PrintConv => {
        'Horizontal' => '水平（標準）',
        'Horizontal (Normal)' => '水平（標準）',
        'Horizontal (normal)' => '水平（標準）',
        'Rotate 180' => '180度回転',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
        'Rotated 180' => '180度回転',
        'Rotated 270 CW' => '270度回転 CW',
        'Rotated 90 CW' => '90度回転 CW',
      },
    },
   'RowInterleaveFactor' => '列を挟む要因',
   'RowsPerStrip' => '1片の列数',
   'SMaxSampleValue' => 'S 最大サンプル値',
   'SMinSampleValue' => 'S 最小サンプル値',
   'SPIFFVersion' => 'SPIFFバージョン',
   'SRAWQuality' => {
      PrintConv => {
        'n/a' => '該当無し',
      },
    },
   'SRActive' => {
      Description => '手ぶれ補正状態',
      PrintConv => {
        'No' => 'オフ',
        'Yes' => 'オン',
      },
    },
   'SRFocalLength' => 'SR焦点距離',
   'SRHalfPressTime' => 'シャッター半押し時間',
   'SRResult' => {
      Description => 'SR効果',
      PrintConv => {
        'Not stabilized' => 'なし',
      },
    },
   'SVGVersion' => 'SVGバージョン',
   'SafetyShift' => {
      Description => 'セイフティシフト',
      PrintConv => {
        'Disable' => 'しない',
        'Enable (ISO speed)' => 'する(ISO感度)',
        'Enable (Tv/Av)' => 'する(Tv/Av値)',
      },
    },
   'SafetyShiftInAvOrTv' => {
      Description => 'セイフティシフトの設定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'SampleFormat' => 'サンプル形式',
   'SampleStructure' => 'サンプリング構造',
   'SamplesPerPixel' => 'コンポーネント数',
   'SanyoQuality' => 'サンヨー品質',
   'SanyoThumbnail' => 'サンヨーサムネイル',
   'Saturation' => {
      Description => '彩度',
      PrintConv => {
        'Film Simulation' => 'フィルムシミュレーション',
        'High' => '高い彩度',
        'Low' => '低い彩度',
        'Med High' => '少し高い',
        'Med Low' => '少し低い',
        'Medium High' => '少し高い',
        'Medium Low' => '少し低い',
        'None' => '未設定',
        'None (B&W)' => '無し（黒＆白）',
        'Normal' => '標準',
        'Very High' => 'かなり高い',
        'Very Low' => 'かなり低い',
      },
    },
   'SaturationFaithful' => '彩度忠実設定',
   'SaturationLandscape' => '彩度風景',
   'SaturationNeutral' => '彩度ニュートラル',
   'SaturationPortrait' => '彩度ポートレート',
   'SaturationSetting' => '彩度設定',
   'SaturationStandard' => '彩度スタンダード',
   'SaturationUserDef1' => '彩度ユーザ設定1',
   'SaturationUserDef2' => '彩度ユーザ設定2',
   'SaturationUserDef3' => '彩度ユーザ設定3',
   'ScanImageEnhancer' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ScanningDirection' => '走査方向',
   'Scene' => '場面',
   'SceneArea' => 'シーンエリア？',
   'SceneAssist' => 'シーン調整',
   'SceneCaptureType' => {
      Description => 'シーンキャプチャタイプ',
      PrintConv => {
        'Landscape' => '風景',
        'Night' => '夜景',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
      },
    },
   'SceneDetect' => 'シーン検出',
   'SceneDetectData' => 'シーン検出データ？',
   'SceneMode' => {
      Description => 'シーンモード',
      PrintConv => {
        '2 in 1' => '2イン1',
        '3D Sweep Panorama' => '3D',
        'Aerial Photo' => '空撮',
        'Anti Motion Blur' => '人物ブレ軽減',
        'Aperture Priority' => '絞り優先',
        'Auction' => 'アクション',
        'Auto' => 'オート',
        'Auto+' => 'Auto アドバンス',
        'Available Light' => '自然光',
        'Baby' => '赤ちゃん',
        'Beach' => 'ビーチ',
        'Beach & Snow' => 'ビーチ＆スノー',
        'Behind Glass' => 'ガラス越し',
        'Candle' => 'キャンドル',
        'Candlelight' => 'キャンドルライト',
        'Children' => '子供',
        'Color Effects' => 'カラーエフェクト',
        'Cont. Priority AE' => '連続撮影優先AE',
        'Cuisine' => '料理',
        'Digital Image Stabilization' => 'デジタル手振れ補正',
        'Documents' => '文書',
        'Face Portrait' => '寝顔',
        'Fireworks' => '花火',
        'Food' => '料理',
        'Handheld Night Shot' => '手持ち夜景',
        'High Key' => 'ハイキー',
        'High Sensitivity' => '高感度',
        'High Speed Continuous Shooting' => '高速連写',
        'Indoor' => '屋内撮影',
        'Intelligent Auto' => 'インテリジェントオート',
        'Intelligent ISO' => 'インテリジェントISO',
        'Landscape' => '風景',
        'Landscape+Portrait' => '風景+人物',
        'Low Key' => 'ローキー',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Movie' => '動画',
        'Movie Preview' => '動画プレビュー',
        'Museum' => '美術館',
        'My Mode' => 'マイモード',
        'Nature Macro' => '自然マクロ',
        'Night Portrait' => '人物夜景',
        'Night Scene' => '夜景',
        'Night Scenery' => '夜景',
        'Night View/Portrait' => 'ナイトビュー/ポートレイト',
        'Night+Portrait' => '夜景+人物',
        'Normal' => 'ノーマル',
        'Off' => 'オフ',
        'Panning' => 'パンニング',
        'Panorama' => 'パノラマ',
        'Panorama Assist' => 'パノラマアシスト',
        'Party' => 'パーティ',
        'Pet' => 'ペット',
        'Portrait' => 'ポートレート',
        'Program' => 'プログラム',
        'Scenery' => '風景',
        'Self Portrait' => '自分撮り',
        'Self Portrait+Self Timer' => '自分撮り+セルフタイマー',
        'Self Protrait+Timer' => '自分撮り+セルフタイマー',
        'Shoot & Select' => 'ショット＆セレクト',
        'Shoot & Select1' => 'ショット＆セレクト1',
        'Shoot & Select2' => 'ショット＆セレクト2',
        'Shooting Guide' => '撮影ガイド',
        'Shutter Priority' => 'シャッター優先',
        'Simple' => 'シンプル',
        'Smile Shot' => 'スマイルショット',
        'Snow' => 'スノー',
        'Soft Skin' => 'ソフトスキン',
        'Sport' => 'スポーツ',
        'Sports' => 'スポーツ',
        'Spot' => 'スポット',
        'Standard' => 'スタンダード',
        'Starry Night' => '星空',
        'Sunset' => '夕日',
        'Super Macro' => 'スーパーマクロ',
        'Sweep Panorama' => 'スイングパノラマ',
        'Text' => 'テキスト',
        'Underwater' => '水中',
        'Underwater Macro' => '水中マクロ',
        'Underwater Snapshot' => '水中スナップ',
        'Underwater Wide1' => '水中ワイド1',
        'Underwater Wide2' => '水中ワイド2',
        'Vivid' => 'ビビッド',
      },
    },
   'SceneModeUsed' => {
      Description => 'シーンモード',
      PrintConv => {
        'Aperture Priority' => '絞り優先',
        'Beach' => 'ビーチ',
        'Candlelight' => 'キャンドルライト',
        'Fireworks' => '花火',
        'Landscape' => '風景',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Night Portrait' => '人物夜景',
        'Portrait' => 'ポートレート',
        'Program' => 'プログラム',
        'Shutter Priority' => 'シャッター優先',
        'Snow' => 'スノー',
        'Sunset' => '夕日',
        'Text' => 'テキスト',
      },
    },
   'SceneSelect' => {
      Description => 'シーン選択',
      PrintConv => {
        'Lamp' => 'ランプ',
        'Night' => '夜景',
        'Off' => 'オフ',
        'Sport' => 'スポーツ',
        'TV' => 'テレビ',
        'User 1' => 'ユーザー1',
        'User 2' => 'ユーザー2',
      },
    },
   'SceneType' => {
      Description => 'シーンタイプ',
      PrintConv => {
        'Directly photographed' => '直接撮影画像',
      },
    },
   'SecurityClassification' => {
      Description => 'セキュリティ区分',
      PrintConv => {
        'Confidential' => '機密文書',
        'Restricted' => '限定',
        'Secret' => '秘密',
        'Top Secret' => '最高機密',
        'Unclassified' => '未分類',
      },
    },
   'SelectableAFPoint' => {
      Description => '任意選択可能なAFフレーム',
      PrintConv => {
        '11 points' => '11点',
        '19 points' => '19点',
        '45 points' => '45点',
        'Inner 9 points' => '9点(内側)',
        'Outer 9 points' => '9点(外側)',
      },
    },
   'SelfTimer' => {
      Description => 'セルフタイマー長',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'SelfTimer2' => 'セルフタイマー(2)',
   'SelfTimerMode' => 'セルフタイマーモード',
   'SelfTimerTime' => 'セルフタイマー遅延時間',
   'SensingMethod' => {
      Description => 'センサー方式',
      PrintConv => {
        'Color sequential area' => 'シーケンシャルカラーセンサー',
        'Color sequential linear' => 'シーケンシャルカラーラインセンサー',
        'Monochrome area' => 'モノクロエリアセンサー',
        'Monochrome linear' => 'モノクロラインセンサー',
        'Not defined' => '未定義',
        'One-chip color area' => '単板式カラーセンサー',
        'Three-chip color area' => '３板式カラーセンサー',
        'Trilinear' => '３ラインセンサー',
        'Two-chip color area' => '２板式カラーセンサー',
      },
    },
   'SensitivityAdjust' => '感度調節',
   'SensitivitySteps' => {
      Description => '感度ステップ',
      PrintConv => {
        '1 EV Steps' => '1EVステップ',
        'As EV Steps' => '露出ステップに従う',
      },
    },
   'SensorCleaning' => {
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'SensorHeight' => 'センサー高さ',
   'SensorImageHeight' => 'センサー高さ',
   'SensorImageWidth' => 'センサー幅',
   'SensorLeftBorder' => 'イメージ左部',
   'SensorPixelSize' => 'センサーピクセルサイズ',
   'SensorTemperature' => 'センサー温度',
   'SensorTopBorder' => 'イメージ上部',
   'SensorWidth' => 'センサー幅',
   'Sequence' => 'シーケンス',
   'SequenceNumber' => 'シーケンス番号',
   'SequenceShotInterval' => 'シーケンスショットインターバル',
   'SequentialShot' => {
      Description => 'シーケンシャルショット',
      PrintConv => {
        'None' => '無し',
        'Standard' => 'スタンダード',
      },
    },
   'SerialNumber' => 'シリアル番号',
   'SerialNumberFormat' => 'シリアル番号形式',
   'ServiceIdentifier' => 'サービス識別子',
   'SetButtonCrossKeysFunc' => {
      Description => 'SETボタン/十字キー機能',
      PrintConv => {
        'Cross keys: AF point select' => '十字キー:AFフレーム選択',
        'Normal' => '標準',
        'Set: Flash Exposure Comp' => 'SET:調光補正',
        'Set: Parameter' => 'SET:現像パラメーター選択',
        'Set: Picture Style' => 'SET:ピクチャースタイル',
        'Set: Playback' => 'SET:画像の再生',
        'Set: Quality' => 'SET:記録画質',
      },
    },
   'SetButtonWhenShooting' => {
      Description => '撮影時のSETボタン',
      PrintConv => {
        'Change parameters' => '現像パラメーター選択',
        'Default (no function)' => '通常(なし)',
        'Disabled' => '無効',
        'Flash exposure compensation' => '調光補正',
        'ISO speed' => 'ISO感度',
        'Image playback' => '画像再生',
        'Image quality' => '記録画質選択',
        'Image size' => '画像サイズ',
        'LCD monitor On/Off' => '液晶モニターの入/切',
        'Menu display' => 'メニュー表示',
        'Normal (disabled)' => '通常(無効)',
        'Picture style' => 'ピクチャースタイル',
        'Quick control screen' => 'クイック設定画面',
        'Record func. + media/folder' => '記録機能とメディア・フォルダ',
        'Record movie (Live View)' => '動画撮影(ライブビュー)',
        'White balance' => 'ホワイトバランス',
      },
    },
   'SetFunctionWhenShooting' => {
      Description => '撮影時のセットボタン機能',
      PrintConv => {
        'Change Parameters' => '現像パラメーター選択',
        'Change quality' => '記録画質選択',
        'Default (no function)' => '通常(なし)',
        'Image replay' => '画像の再生',
        'Menu display' => 'メニュー表示',
      },
    },
   'ShadingCompensation' => {
      Description => '陰影修正',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ShadingCompensation2' => {
      Description => '陰影補正編集',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Shadow' => 'シャドウ',
   'ShadowScale' => 'シャドウスケール',
   'Shadows' => 'シャドウ',
   'ShakeReduction' => {
      Description => '手ぶれ補正(設定)',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ShakeReductionInfo' => 'SR効果',
   'Sharpness' => {
      Description => 'シャープネス',
      PrintConv => {
        'Film Simulation' => 'フィルムシミュレーション',
        'Hard' => 'ハード',
        'Hard2' => 'ハード2',
        'Med Hard' => '少しハード',
        'Med Soft' => '少しソフト',
        'Medium Hard' => 'ミドルハード',
        'Medium Soft' => 'ミドルソフト',
        'Normal' => 'ノーマル',
        'Sharp' => 'シャープ',
        'Soft' => 'ソフト',
        'Soft2' => 'ソフト2',
        'Very Hard' => 'かなりハード',
        'Very Soft' => 'かなりソフト',
        'n/a' => '該当無し',
      },
    },
   'SharpnessFactor' => 'シャープネス要因',
   'SharpnessFaithful' => 'シャープネス忠実設定',
   'SharpnessFrequency' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
        'Standard' => 'スタンダード',
        'n/a' => '該当無し',
      },
    },
   'SharpnessLandscape' => 'シャープネス風景',
   'SharpnessMonochrome' => 'シャープネスモノクロ',
   'SharpnessNeutral' => 'シャープネスニュートラル',
   'SharpnessPortrait' => 'シャープネスポートレート',
   'SharpnessSetting' => 'シャープネス設定',
   'SharpnessStandard' => 'シャープネススタンダード',
   'SharpnessUserDef1' => 'シャープネスユーザ設定1',
   'SharpnessUserDef2' => 'シャープネスユーザ設定2',
   'SharpnessUserDef3' => 'シャープネスユーザ設定3',
   'ShootingInfoDisplay' => {
      Description => '撮影情報表示',
      PrintConv => {
        'Auto' => 'オート',
        'Manual (dark on light)' => '手動-黒地に白',
        'Manual (light on dark)' => '手動-白地に黒',
      },
    },
   'ShootingMode' => {
      Description => '撮影モード',
      PrintConv => {
        'Aerial Photo' => '空撮',
        'Aperture Priority' => '絞り優先',
        'Baby' => '赤ちゃん',
        'Beach' => 'ビーチ',
        'Candlelight' => 'キャンドルライト',
        'Clipboard' => 'メモ',
        'Color Effects' => 'カラーエフェクト',
        'Economy' => 'エコモード',
        'Fireworks' => '花火',
        'Food' => '料理',
        'High Sensitivity' => '高感度',
        'High Speed Continuous Shooting' => '高速連写',
        'Intelligent Auto' => 'インテリジェントオート',
        'Intelligent ISO' => 'インテリジェントISO',
        'Macro' => 'マクロ',
        'Manual' => 'マニュアル',
        'Movie Preview' => '動画プレビュー',
        'Night Portrait' => '人物夜景',
        'Night Scenery' => '夜景',
        'Normal' => '標準',
        'Panning' => 'パンニング',
        'Panorama Assist' => 'パノラマアシスト',
        'Party' => 'パーティ',
        'Pet' => 'ペット',
        'Portrait' => 'ポートレート',
        'Program' => 'プログラム',
        'Scenery' => '風景',
        'Self Portrait' => '自分撮り',
        'Shutter Priority' => 'シャッター優先',
        'Simple' => 'シンプル',
        'Snow' => 'スノー',
        'Soft Skin' => 'ソフトスキン',
        'Sports' => 'スポーツ',
        'Spot' => 'スポット',
        'Starry Night' => '星空',
        'Sunset' => '夕日',
        'Underwater' => '水中',
      },
    },
   'ShootingModeSetting' => {
      Description => '撮影モード',
      PrintConv => {
        'Continuous' => '連続撮影',
        'Delayed Remote' => '遅延リモート',
        'Quick-response Remote' => '即時リモート',
        'Self-timer' => 'セルフタイマー',
        'Single Frame' => '１コマ撮影',
      },
    },
   'ShortDocumentID' => '短文書ID',
   'ShortOwnerName' => '短いオーナー名',
   'ShortReleaseTimeLag' => {
      Description => 'レリーズタイムラグ最速化',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ShotInfoVersion' => 'ショット情報バージョン',
   'Shutter-AELock' => {
      Description => 'シャッターボタン/AEロックボタン',
      PrintConv => {
        'AE lock/AF' => 'AEロック/AF',
        'AE/AF, No AE lock' => 'AE/AF（AEロックなし）',
        'AF/AE lock' => 'AF/AEロック',
        'AF/AF lock' => 'AF/AFロック',
        'AF/AF lock, No AE lock' => 'AF/AFロック（AEロックなし）',
      },
    },
   'ShutterAELButton' => 'シャッターボタン／AEロックボタン',
   'ShutterButtonAFOnButton' => {
      Description => 'シャッター/AF-ONボタン',
      PrintConv => {
        'AE lock/Metering + AF start' => 'AEロック/測光・AF開始',
        'Metering + AF start' => '測光・AF開始',
        'Metering + AF start/AF stop' => '測光・AF開始/AFストップ',
        'Metering + AF start/disable' => '測光・AF開始/無効',
        'Metering start/Meter + AF start' => '測光開始/測光・AF開始',
      },
    },
   'ShutterCount' => 'シャッター回数',
   'ShutterCurtainSync' => {
      Description => 'ストロボのシンクロタイミング',
      PrintConv => {
        '1st-curtain sync' => '先幕シンクロ',
        '2nd-curtain sync' => '後幕シンクロ',
      },
    },
   'ShutterMode' => {
      PrintConv => {
        'Aperture Priority' => '絞り優先',
        'Auto' => 'オート',
      },
    },
   'ShutterReleaseButtonAE-L' => {
      Description => 'シャッターレリーズボタン　AE-L',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ShutterReleaseNoCFCard' => {
      Description => 'CFカード未装填時のレリーズ',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ShutterSpeed' => '露出時間',
   'ShutterSpeedRange' => {
      Description => 'シャッター速度の制御範囲の設定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ShutterSpeedValue' => 'シャッタースピード',
   'SimilarityIndex' => '類似インデックス',
   'Site' => 'サイト',
   'SlaveFlashMeteringSegments' => 'スレーブフラッシュ測光値',
   'SlideShow' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'SlowShutter' => {
      Description => 'スローシャッター',
      PrintConv => {
        'Night Scene' => '夜景',
        'None' => '無し',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'SlowSync' => {
      Description => 'スローシンクロ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Software' => 'ソフトウェア',
   'SoftwareVersion' => 'ソフトウェアバージョン',
   'Source' => 'ソース',
   'SpatialFrequencyResponse' => '空間周波数特性',
   'SpecialEffectsOpticalFilter' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'SpecialInstructions' => '手順',
   'SpecialMode' => 'スペシャルモード',
   'SpectralSensitivity' => 'スペクトル感度',
   'SpotFocusPointX' => 'スポットフォーカスポイントX',
   'SpotFocusPointY' => 'スポットフォーカスポイントY',
   'SpotMeterLinkToAFPoint' => {
      Description => '測距点連動スポット測光',
      PrintConv => {
        'Disable (use center AF point)' => 'しない(中央固定',
        'Enable (use active AF point)' => 'する(測距点連動)',
      },
    },
   'SpotMeteringMode' => {
      Description => 'スポットメーターモード',
      PrintConv => {
        'Center' => '中央',
      },
    },
   'State' => '都道府県名',
   'StoNits' => 'Stoニット',
   'StraightenAngle' => 'ストレートアングル',
   'StreamType' => {
      PrintConv => {
        'Text' => 'テキスト',
      },
    },
   'StripByteCounts' => '圧縮片のバイト数',
   'StripOffsets' => '画像データ位置',
   'Sub-location' => '場所',
   'SubSecCreateDate' => 'デジタルデータ作成日時',
   'SubSecDateTimeOriginal' => 'オリジナルデータ作成日時',
   'SubSecModifyDate' => 'ファイル作成日時',
   'SubSecTime' => 'DateTimeサブ秒',
   'SubSecTimeDigitized' => 'DateTimeDigitizedサブ秒',
   'SubSecTimeOriginal' => 'DateTimeOriginalサブ秒',
   'SubTileBlockSize' => 'サブタイトルブロックサイズ',
   'SubfileType' => '新規サブファイルタイプ',
   'SubimageColor' => {
      PrintConv => {
        'Monochrome' => 'モノトーン',
      },
    },
   'Subject' => 'サブジェクト',
   'SubjectArea' => '対象領域',
   'SubjectDistance' => '対象距離',
   'SubjectDistanceRange' => {
      Description => '被写体距離範囲',
      PrintConv => {
        'Close' => '近景',
        'Distant' => '遠景',
        'Macro' => 'マクロ',
        'Unknown' => '不明',
      },
    },
   'SubjectLocation' => '対象領域',
   'SubjectProgram' => {
      Description => '被写体プログラム',
      PrintConv => {
        'Night portrait' => '人物夜景',
        'None' => '無し',
        'Portrait' => 'ポートレート',
        'Sports action' => 'スポーツアクション',
        'Sunset' => '夕日',
        'Text' => 'テキスト',
      },
    },
   'SubjectReference' => 'サブジェクトコード',
   'Subsystem' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'SuperMacro' => {
      Description => 'スーパーマクロ',
      PrintConv => {
        'Off' => 'オフ',
        'On (1)' => 'オン(1)',
        'On (2)' => 'オン(2)',
      },
    },
   'SuperimposedDisplay' => {
      Description => 'スーパーインポーズの表示',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'SupplementalCategories' => '補足カテゴリー',
   'SupplementalType' => '補足タイプ',
   'SvISOSetting' => 'SVISO感度設定',
   'SwitchToRegisteredAFPoint' => {
      Description => '登録AFフレームへの切り換え',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'T4Options' => 'T4オプション',
   'T6Options' => 'T6オプション',
   'TIFF-EPStandardID' => 'TIFF/EP標準ID',
   'TTL_DA_ADown' => 'TTL D/A Aチャンネル　ダウン',
   'TTL_DA_AUp' => 'TTL D/A Aチャンネル アップ',
   'TTL_DA_BDown' => 'TTL D/A Bチャンネル　ダウン',
   'TTL_DA_BUp' => 'TTL D/A Bチャンネル　アップ',
   'Tagged' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'TargetAperture' => 'ターゲット絞り',
   'TargetExposureTime' => 'ターゲット露出時間',
   'TargetPrinter' => '標的プリンタ',
   'Technology' => {
      Description => 'テクノロジー',
      PrintConv => {
        'Active Matrix Display' => 'アクティブマトリクス型ディスプレイ',
        'Cathode Ray Tube Display' => 'CRTディスプレイ',
        'Digital Camera' => 'デジタルカメラ',
        'Dye Sublimation Printer' => '昇華型プリンター',
        'Electrophotographic Printer' => '静電記録式プリンター',
        'Electrostatic Printer' => '静電気プリンター',
        'Film Scanner' => 'フイルムスキャナー',
        'Film Writer' => 'フィルムライター',
        'Flexography' => 'アニリン印刷',
        'Gravure' => 'グラビア印刷',
        'Ink Jet Printer' => 'インクジェットプリンター',
        'Offset Lithography' => 'オフセット印刷',
        'Passive Matrix Display' => '単純マトリクス型ディスプレイ',
        'Photo CD' => 'フォトCD',
        'Photo Image Setter' => 'フォトイメージセッター',
        'Photographic Paper Printer' => '印画紙プリンター',
        'Projection Television' => 'プロジェクションテレビ',
        'Reflective Scanner' => '反射スキャナ',
        'Silkscreen' => 'シルクスクリーン印刷',
        'Thermal Wax Printer' => '熱転写プリンター',
        'Video Camera' => 'ビデオカメラ',
        'Video Monitor' => 'ビデオモニター',
      },
    },
   'Teleconverter' => {
      PrintConv => {
        'None' => '無し',
      },
    },
   'Text' => 'テキスト',
   'TextInfo' => 'テキスト情報',
   'TextStamp' => {
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Thresholding' => '閾値化',
   'ThumbnailImage' => 'サムネイル画像',
   'ThumbnailImageSize' => 'サムネイルサイズ',
   'ThumbnailImageValidArea' => 'サムネイル画像有効領域',
   'TileByteCounts' => 'タイルのバイト数',
   'TileDepth' => 'タイルの深さ',
   'TileLength' => 'タイルの長さ',
   'TileOffsets' => 'タイルのオフセット',
   'TileWidth' => 'タイルの幅',
   'Time' => '時間',
   'TimeCreated' => '作成時間',
   'TimeScaleParamsQuality' => {
      PrintConv => {
        'High' => '高い',
        'Low' => 'ソフト',
      },
    },
   'TimeSent' => '発送時間',
   'TimeSincePowerOn' => '電源オン経過時間',
   'TimeStamp' => 'タイムスタンプ',
   'TimeStamp1' => 'タイムスタンプ1',
   'TimeZone' => 'タイムゾーン',
   'TimeZoneOffset' => 'タイムゾーンオフセット',
   'TimerFunctionButton' => {
      Description => 'ファンクションボタン',
      PrintConv => {
        'ISO' => 'ISO感度',
        'Image Quality/Size' => '画像品質/サイズ',
        'Self-timer' => 'セルフタイマー',
        'Shooting Mode' => '撮影モード',
        'White Balance' => 'ホワイトバランス',
      },
    },
   'TimerLength' => {
      Description => '各種タイマー保持時間',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'Timezone' => 'タイムゾーン',
   'Title' => 'タイトル',
   'ToneComp' => 'トーン補正',
   'ToneCurve' => {
      Description => 'トーンカーブ',
      PrintConv => {
        'Custom' => 'カスタム',
        'Manual' => 'マニュアル',
        'Standard' => 'スタンダード',
      },
    },
   'ToneCurveActive' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'ToneCurveName' => {
      PrintConv => {
        'Custom' => 'カスタム',
      },
    },
   'ToneCurves' => 'トーンカーブ(s)',
   'ToningEffect' => {
      Description => 'トーン効果',
      PrintConv => {
        'B&W' => '白黒',
        'Blue' => '青',
        'Blue-green' => '青緑',
        'Cyanotype' => '青写真',
        'Green' => '緑',
        'None' => '無し',
        'Purple' => '紫',
        'Purple-blue' => '青紫',
        'Red' => '赤',
        'Red-purple' => '赤紫',
        'Sepia' => 'セピア',
        'Yellow' => '黄色',
        'n/a' => '該当無し',
      },
    },
   'ToningEffectMonochrome' => {
      Description => 'モノクロトーン効果',
      PrintConv => {
        'Blue' => '青',
        'Green' => '緑',
        'None' => '無し',
        'Purple' => '紫',
        'Sepia' => 'セピア',
      },
    },
   'ToningSaturation' => '彩度トーン',
   'TransferFunction' => '転送機能',
   'TransferRange' => '転送範囲',
   'Transformation' => {
      Description => '変形',
      PrintConv => {
        'Horizontal (normal)' => '水平（標準）',
        'Rotate 180' => '180度回転',
        'Rotate 270 CW' => '270度回転 CW',
        'Rotate 90 CW' => '90度回転 CW',
      },
    },
   'TransmissionReference' => '送信元記録',
   'TransparencyIndicator' => '透明度指標',
   'TrapIndicator' => 'トラップインジケーター',
   'Trapped' => {
      PrintConv => {
        'Unknown' => '不明',
      },
    },
   'TravelDay' => 'トラベル日付',
   'TvExposureTimeSetting' => 'Tv露出時間設定',
   'Type' => 'タイプ',
   'USMLensElectronicMF' => {
      Description => 'USMレンズの電子式手動フォーカス',
      PrintConv => {
        'Disable after one-shot AF' => 'ワンショットAF作動後・不可',
        'Disable in AF mode' => 'AF時すべて不可',
        'Enable after one-shot AF' => 'ワンショットAF作動後・可',
      },
    },
   'Uncompressed' => {
      Description => '非圧縮',
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'UniqueCameraModel' => 'ユニークカメラモデル',
   'UniqueDocumentID' => 'ユニーク文書ID',
   'UniqueObjectName' => 'ユニーク・ネーム・オブ・オブジェクト',
   'Unknown' => '不明',
   'Unsharp1Color' => {
      Description => 'アンシャープ1カラー',
      PrintConv => {
        'Blue' => '青',
        'Cyan' => 'シアン',
        'Green' => '緑',
        'Magenta' => 'マゼンダ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'Unsharp1HaloWidth' => 'アンシャープ1円光幅',
   'Unsharp1Intensity' => 'アンシャープ1強度',
   'Unsharp1Threshold' => 'アンシャープ1起点',
   'Unsharp2Color' => {
      Description => 'アンシャープ2カラー',
      PrintConv => {
        'Blue' => '青',
        'Cyan' => 'シアン',
        'Green' => '緑',
        'Magenta' => 'マゼンダ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'Unsharp2HaloWidth' => 'アンシャープ2円光幅',
   'Unsharp2Intensity' => 'アンシャープ2強度',
   'Unsharp2Threshold' => 'アンシャープ2起点',
   'Unsharp3Color' => {
      Description => 'アンシャープ3カラー',
      PrintConv => {
        'Blue' => '青',
        'Cyan' => 'シアン',
        'Green' => '緑',
        'Magenta' => 'マゼンダ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'Unsharp3HaloWidth' => 'アンシャープ3円光幅',
   'Unsharp3Intensity' => 'アンシャープ3強度',
   'Unsharp3Threshold' => 'アンシャープ3起点',
   'Unsharp4Color' => {
      Description => 'アンシャープ4カラー',
      PrintConv => {
        'Blue' => '青',
        'Cyan' => 'シアン',
        'Green' => '緑',
        'Magenta' => 'マゼンダ',
        'Red' => '赤',
        'Yellow' => '黄色',
      },
    },
   'Unsharp4HaloWidth' => 'アンシャープ4円光幅',
   'Unsharp4Intensity' => 'アンシャープ4強度',
   'Unsharp4Threshold' => 'アンシャープ4起点',
   'UnsharpCount' => 'アンシャープカウント',
   'UnsharpData' => 'アンシャープデータ',
   'UnsharpMask' => {
      Description => 'アンシャープマスク',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Urgency' => '緊急性',
   'UsableMeteringModes' => {
      Description => '測光モードの限定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'UsableShootingModes' => {
      Description => '撮影モードの限定',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'UserComment' => 'ユーザーコメント',
   'UserDef1PictureStyle' => {
      Description => 'ユーザ設定1 ピクチャースタイル',
      PrintConv => {
        'Faithful' => '忠実設定',
        'Landscape' => '風景',
        'Monochrome' => 'モノトーン',
        'Neutral' => 'ニュートラル',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
      },
    },
   'UserDef2PictureStyle' => {
      Description => 'ユーザ設定2 ピクチャースタイル',
      PrintConv => {
        'Faithful' => '忠実設定',
        'Landscape' => '風景',
        'Monochrome' => 'モノトーン',
        'Neutral' => 'ニュートラル',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
      },
    },
   'UserDef3PictureStyle' => {
      Description => 'ユーザ設定3 ピクチャースタイル',
      PrintConv => {
        'Faithful' => '忠実設定',
        'Landscape' => '風景',
        'Monochrome' => 'モノトーン',
        'Neutral' => 'ニュートラル',
        'Portrait' => 'ポートレート',
        'Standard' => 'スタンダード',
      },
    },
   'VRDVersion' => 'VRDバージョン',
   'VRInfo' => 'VR（手振れ補正）情報',
   'VRInfoVersion' => 'VR情報バージョン',
   'VR_0x66' => {
      PrintConv => {
        'Off' => 'オフ',
        'On (active)' => 'オン（アクティブ）',
        'On (normal)' => 'オン（ノーマル）',
      },
    },
   'ValidAFPoints' => '有効なAFポイント',
   'ValidBits' => 'ピクセルにつき有効なビット',
   'VariProgram' => 'バリプログラム',
   'Version' => 'バージョン',
   'VibrationReduction' => {
      Description => '手振れ補正（VR）',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
        'On (1)' => 'オン（1）',
        'On (2)' => 'オン（2）',
        'On (3)' => 'オン（3）',
        'n/a' => '該当無し',
      },
    },
   'VideoCardGamma' => 'ビデオカードガンマ',
   'ViewInfoDuringExposure' => {
      Description => '露光中のファインダー内表示',
      PrintConv => {
        'Disable' => 'しない',
        'Enable' => 'する',
      },
    },
   'ViewfinderWarning' => {
      Description => 'ビューファインダー警告表示',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'ViewingCondDesc' => '視聴状態説明',
   'ViewingCondIlluminant' => '視聴状態光源',
   'ViewingCondIlluminantType' => '視聴状態光源タイプ',
   'ViewingCondSurround' => '視聴状態周辺',
   'ViewingConditions' => '視聴状態光源',
   'VignetteControl' => {
      Description => 'ビネットコントロール',
      PrintConv => {
        'High' => '高い',
        'Low' => '低い',
        'Normal' => '標準',
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'VignetteControlIntensity' => 'ビネットコントロール強度',
   'VoiceMemo' => {
      Description => 'ボイスメモ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'WBAdjData' => 'ホワイトバランス調整データ',
   'WBAdjLighting' => {
      Description => 'ホワイトバランス調整、ライティング',
      PrintConv => {
        'Daylight' => '昼光',
        'Flash' => 'ストロボ',
        'High Color Rendering Fluorescent' => 'ハイカラーレンダリング蛍光灯',
        'Incandescent' => '電球',
        'None' => '無し',
        'Standard Fluorescent' => '標準蛍光灯',
      },
    },
   'WBAdjMode' => {
      Description => 'ホワイトバランス調整モード',
      PrintConv => {
        'Calculate Automatically' => '自動計算',
        'Recorded Value' => '記録値',
        'Use Gray Point' => 'グレーポイント使用',
        'Use Temperature' => '温度使用',
      },
    },
   'WBAdjTemperature' => 'ホワイトバランス調整、色温度',
   'WBBlueLevel' => 'ホワイトバランス青レベル',
   'WBBracketMode' => {
      Description => 'ホワイトバランスブラケットモード',
      PrintConv => {
        'Off' => 'オフ',
        'On (shift AB)' => 'オン（シフトAB）',
        'On (shift GM)' => 'オン（シフトGM）',
      },
    },
   'WBBracketValueAB' => 'ホワイトバランスブラケット値AB',
   'WBBracketValueGM' => 'ホワイトバランスブラケット値GM',
   'WBFineTuneActive' => {
      PrintConv => {
        'No' => 'いいえ',
        'Yes' => 'はい',
      },
    },
   'WBGreenLevel' => 'ホワイトバランス緑レベル',
   'WBMediaImageSizeSetting' => {
      Description => 'WB/メディア・画像サイズの設定',
      PrintConv => {
        'LCD monitor' => '液晶モニター',
        'Rear LCD panel' => '背面表示パネル',
      },
    },
   'WBMode' => {
      Description => 'ホワイトバランスモード',
      PrintConv => {
        'Auto' => 'オート',
      },
    },
   'WBRedLevel' => 'ホワイトバランス赤レベル',
   'WBShiftAB' => 'WB AB補正',
   'WBShiftGM' => 'WB GM補正',
   'WB_GBRGLevels' => 'WB GBRG レベル',
   'WB_GRBGLevels' => 'WB GRBG レベル',
   'WB_GRGBLevels' => 'WB GRGB レベル',
   'WB_RBGGLevels' => 'WB RBGG レベル',
   'WB_RBLevels' => 'WB　RBレベル',
   'WB_RBLevels3000K' => 'WB　RGGB3000Kレベル',
   'WB_RBLevels3300K' => 'WB　RGGB3300Kレベル',
   'WB_RBLevels3600K' => 'WB　RGGB3600Kレベル',
   'WB_RBLevels3900K' => 'WB　RGGB3800Kレベル',
   'WB_RBLevels4000K' => 'WB　RGGB4000Kレベル',
   'WB_RBLevels4300K' => 'WB　RGGB4300Kレベル',
   'WB_RBLevels4500K' => 'WB　RGGB4500Kレベル',
   'WB_RBLevels4800K' => 'WB　RGGB4800Kレベル',
   'WB_RBLevels5300K' => 'WB　RGGB5300Kレベル',
   'WB_RBLevels6000K' => 'WB　RGGB6000Kレベル',
   'WB_RBLevels6600K' => 'WB　RGGB6600Kレベル',
   'WB_RBLevels7500K' => 'WB　RGGB7500Kレベル',
   'WB_RBLevelsAuto' => 'WB RB レベル オート',
   'WB_RBLevelsCloudy' => 'WB RB レベル　曇天',
   'WB_RBLevelsCoolWhiteFluor' => 'WB RB レベル　冷白蛍光灯',
   'WB_RBLevelsDayWhiteFluor' => 'WB RB レベル　昼白蛍光灯',
   'WB_RBLevelsDaylightFluor' => 'WB RB レベル　昼光蛍光灯',
   'WB_RBLevelsEveningSunlight' => 'WB RB レベル　夕日',
   'WB_RBLevelsFineWeather' => 'WB RB レベル　晴天',
   'WB_RBLevelsShade' => 'WB RB レベル　日陰',
   'WB_RBLevelsTungsten' => 'WB RB レベル　白熱灯',
   'WB_RBLevelsUsed' => 'WB RB レベル使用',
   'WB_RBLevelsWhiteFluorescent' => 'WB RB レベル　白蛍光灯',
   'WB_RGBGLevels' => 'WB RGBG レベル',
   'WB_RGBLevels' => 'WB RGB レベル',
   'WB_RGBLevelsCloudy' => 'WB RGB レベル　曇天',
   'WB_RGBLevelsDaylight' => 'WB RGB レベル　昼光',
   'WB_RGBLevelsFlash' => 'WB RGB レベル　ストロボ',
   'WB_RGBLevelsFluorescent' => 'WB RGGB レベル　蛍光灯',
   'WB_RGBLevelsShade' => 'WB RGB レベル　日陰',
   'WB_RGBLevelsTungsten' => 'WB RGB レベル　白熱灯',
   'WB_RGGBLevels' => 'WB RGGB レベル',
   'WB_RGGBLevelsCloudy' => 'WB RGGB レベル　曇天',
   'WB_RGGBLevelsDaylight' => 'WB RGGB レベル　昼光',
   'WB_RGGBLevelsFlash' => 'WB RGGB レベル　ストロボ',
   'WB_RGGBLevelsFluorescent' => 'WB RGGB レベル　蛍光灯',
   'WB_RGGBLevelsFluorescentD' => 'WB RGGB レベル　蛍光灯(D)',
   'WB_RGGBLevelsFluorescentN' => 'WB RGGB レベル　蛍光灯(N)',
   'WB_RGGBLevelsFluorescentW' => 'WB RGGB レベル　蛍光灯(W)',
   'WB_RGGBLevelsShade' => 'WB RGGB レベル　日陰',
   'WB_RGGBLevelsTungsten' => 'WB RGGB レベル　白熱灯',
   'WCSProfiles' => 'Windowsカラーシステムプロフィール',
   'WhiteBalance' => {
      Description => 'ホワイトバランス',
      PrintConv => {
        'Auto' => 'オート',
        'Black & White' => '白黒',
        'Cloudy' => '曇り',
        'Color Temperature/Color Filter' => '色温度マニュアル指定',
        'Cool White Fluorescent' => '白色蛍光灯',
        'Custom' => 'カスタム',
        'Custom 1' => 'カスタム1',
        'Custom 2' => 'カスタム2',
        'Custom 3' => 'カスタム3',
        'Custom 4' => 'カスタム4',
        'Custom2' => 'カスタム2',
        'Custom3' => 'カスタム3',
        'Custom4' => 'カスタム4',
        'Custom5' => 'カスタム5',
        'Day White Fluorescent' => '昼白色蛍光灯',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'Incandescent' => '電球',
        'Kelvin' => 'ケルビン',
        'Living Room Warm White Fluorescent' => 'リビング暖白光色蛍光灯',
        'Manual' => 'マニュアル',
        'Manual Temperature (Kelvin)' => 'マニュアル白熱灯（ケルビン）',
        'PC Set1' => 'PC設定1',
        'PC Set2' => 'PC設定2',
        'PC Set3' => 'PC設定3',
        'PC Set4' => 'PC設定4',
        'PC Set5' => 'PC設定5',
        'Shade' => '日陰',
        'Tungsten' => 'タングステン(白熱灯)',
        'Underwater' => '水中',
        'Unknown' => '不明',
        'User-Selected' => 'ユーザ選択',
        'Warm White Fluorescent' => '暖白光色蛍光灯',
        'White Fluorescent' => '温白色蛍光灯',
      },
    },
   'WhiteBalance2' => {
      Description => 'ホワイトバランス2',
      PrintConv => {
        '3000K (Tungsten light)' => '3000K (白熱電球)',
        '3600K (Tungsten light-like)' => '3600K (白熱電球-like)',
        '4000K (Cool white fluorescent)' => '4000K (蛍光灯１)',
        '4500K (Neutral white fluorescent)' => '4500K (蛍光灯２)',
        '5300K (Fine Weather)' => '5300K (晴天)',
        '6000K (Cloudy)' => '6000K (曇り)',
        '6600K (Daylight fluorescent)' => '6600K (蛍光灯３)',
        '7500K (Fine Weather with Shade)' => '7500K (晴天と影)',
        'Auto' => 'オート',
        'Custom WB 1' => 'カスタムホワイトバランス1',
        'Custom WB 2' => 'カスタムホワイトバランス2',
        'Custom WB 2900K' => 'カスタムホワイトバランス2900K',
        'Custom WB 3' => 'カスタムホワイトバランス3',
        'Custom WB 4' => 'カスタムホワイトバランス4',
        'Custom WB 5400K' => 'カスタムホワイトバランス5400K',
        'Custom WB 8000K' => 'カスタムホワイトバランス8000K',
      },
    },
   'WhiteBalanceAdj' => {
      Description => 'ホワイトバランス調整',
      PrintConv => {
        'Auto' => 'オート',
        'Cloudy' => '曇り',
        'Daylight' => '昼光',
        'Flash' => 'ストロボ',
        'Fluorescent' => '蛍光灯',
        'Off' => 'オフ',
        'On' => 'オン',
        'Shade' => '日陰',
        'Tungsten' => 'タングステン(白熱灯)',
      },
    },
   'WhiteBalanceBias' => 'ホワイトバランスバイアス',
   'WhiteBalanceBracket' => 'ホワイトバランスブラケット',
   'WhiteBalanceComp' => 'ホワイトバランス補正',
   'WhiteBalanceFineTune' => 'ホワイトバランスファインチューン',
   'WhiteBalanceMode' => {
      Description => 'ホワイトバランスモード',
      PrintConv => {
        'Auto (Cloudy)' => 'オート（曇天）',
        'Auto (Day White Fluorescent)' => 'オート（昼白色蛍光灯）',
        'Auto (Daylight Fluorescent)' => 'オート（昼光色蛍光灯）',
        'Auto (Daylight)' => 'オート（昼光）',
        'Auto (Flash)' => 'オート（ストロボ）',
        'Auto (Shade)' => 'オート（日陰）',
        'Auto (Tungsten)' => 'オート（白熱灯）',
        'Auto (White Fluorescent)' => 'オート（白色蛍光灯）',
        'Unknown' => '不明',
        'User-Selected' => 'ユーザー選択',
      },
    },
   'WhiteBalanceSet' => {
      Description => 'ホワイトバランス設定',
      PrintConv => {
        'Auto' => 'オート',
        'Cloudy' => '曇り',
        'Day White Fluorescent' => '昼白色蛍光灯',
        'Daylight' => '昼光',
        'Daylight Fluorescent' => '昼光色蛍光灯',
        'Flash' => 'ストロボ',
        'Manual' => 'マニュアル',
        'Set Color Temperature 1' => '色温度設定1',
        'Set Color Temperature 2' => '色温度設定2',
        'Set Color Temperature 3' => '色温度設定3',
        'Shade' => '日陰',
        'Tungsten' => 'タングステン(白熱灯)',
        'White Fluorescent' => '温白色蛍光灯',
      },
    },
   'WhiteBalanceTemperature' => 'ホワイトバランス温度',
   'WhiteBoard' => 'ホワイトボード',
   'WhiteLevel' => '白レベル',
   'WhitePoint' => '白点色度',
   'Wide' => 'ワイド',
   'WideFocusZone' => 'ワイドフォーカスゾーン',
   'WideRange' => {
      Description => 'ワイドレンジ',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'WidthResolution' => '幅方向の画像解像度',
   'WorldTime' => 'タイムゾーン',
   'WorldTimeLocation' => {
      Description => 'ワールドタイム位置',
      PrintConv => {
        'Destination' => '目的地',
        'Home' => '自宅',
        'Hometown' => '現在地',
      },
    },
   'Writer-Editor' => '表題/説明の作家',
   'X3FillLight' => 'X3光を満たす',
   'XClipPathUnits' => 'Xクリップパス単位',
   'XMP' => 'XMPメタデータ',
   'XPAuthor' => '作者',
   'XPComment' => 'コメント',
   'XPKeywords' => 'キーワード',
   'XPSubject' => 'サブジェクト',
   'XPTitle' => 'タイトル',
   'XPosition' => 'X位置',
   'XResolution' => '画像幅の解像度',
   'YCbCrCoefficients' => 'カラースペース変化マトリックス係数',
   'YCbCrPositioning' => {
      Description => 'YとCの位置',
      PrintConv => {
        'Centered' => '中央',
        'Co-sited' => '相互配置',
      },
    },
   'YCbCrSubSampling' => 'YとCのサブサンプリング比率',
   'YClipPathUnits' => 'Yクリップパス単位',
   'YPosition' => 'Y位置',
   'YResolution' => '画像高さの解像度',
   'ZoneMatching' => {
      Description => 'ゾーンマッチング',
      PrintConv => {
        'High Key' => 'ハイキー',
        'ISO Setting Used' => 'オフ(ISO設定使用)',
        'Low Key' => 'ローキー',
      },
    },
   'ZoneMatchingOn' => {
      Description => 'ゾーンマッチング',
      PrintConv => {
        'Off' => 'オフ',
        'On' => 'オン',
      },
    },
   'Zoom' => 'ズーム',
   'ZoomSourceWidth' => 'ズームソース幅',
   'ZoomStepCount' => 'ズームステップ数',
   'ZoomTargetWidth' => 'ズームターゲット幅',
);

1;  # end


__END__

=head1 NAME

Image::ExifTool::Lang::ja.pm - ExifTool Japanese language translations

=head1 DESCRIPTION

This file is used by Image::ExifTool to generate localized tag descriptions
and values.

=head1 AUTHOR

Copyright 2003-2014, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 ACKNOWLEDGEMENTS

Thanks to Jens Duttke and Kazunari Nishina for providing this translation.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::TagInfoXML(3pm)|Image::ExifTool::TagInfoXML>

=cut
