/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.plugins.cache;

import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

/**
 * Timed cache policy factory.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class TimedCachePolicyFactory implements CachePolicyFactory
{
   private int defaultLifetime;
   private boolean threadSafe;
   private int resolution;

   public TimedCachePolicyFactory()
   {
      this(30*60, false, 0);
   }

   public TimedCachePolicyFactory(int defaultLifetime)
   {
      this(defaultLifetime, false, 0);
   }

   public TimedCachePolicyFactory(int defaultLifetime, boolean threadSafe, int resolution)
   {
      this.defaultLifetime = defaultLifetime;
      this.threadSafe = threadSafe;
      if( resolution <= 0 )
         resolution = 60;
      this.resolution = resolution;
   }

   public CachePolicy createCachePolicy()
   {
      return new TimedCachePolicy(defaultLifetime, threadSafe, resolution);
   }
}