/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.spi.signature;

import java.util.Calendar;
import java.util.TimeZone;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import junit.framework.Test;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.signature.javassist.JavassistConstructorParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistMethodParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistSignatureFactory;
import org.jboss.test.metadata.SignatureMetaDataTest;
import org.jboss.test.metadata.shared.support.SignatureTester;

/**
 * JavassistSignatureTestCase.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class JavassistSignatureTestCase extends SignatureMetaDataTest
{
   private ClassPool pool;

   public JavassistSignatureTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
   {
      return suite(JavassistSignatureTestCase.class);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      pool = ClassPool.getDefault();
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      pool = null;
   }

   protected CtClass getCtClass(Class<?> clazz) throws NotFoundException
   {
      return pool.get(clazz.getName());
   }

   public void testConstructor() throws Exception
   {
      CtClass ctClass = getCtClass(SignatureTester.class);
      Signature jpcs = JavassistSignatureFactory.getSignature(ctClass.getDeclaredConstructor(new CtClass[]{getCtClass(Calendar.class)}));
      assertEquals(getClassParameterConstructorSignature(), jpcs);
      assertEquals(getClassInfoParameterConstructorSignature(), jpcs);
   }

   public void testConstructorParams() throws Exception
   {
      CtClass ctClass = getCtClass(SignatureTester.class);
      Signature jpcs = new JavassistConstructorParametersSignature(ctClass.getDeclaredConstructor(new CtClass[]{getCtClass(Calendar.class)}), 0);
      assertEquals(getConstructorParametersSignature(), jpcs);
      assertEquals(getConstructorInfoParametersSignature(), jpcs);
   }

   public void testMethod() throws Exception
   {
      CtClass ctClass = getCtClass(SignatureTester.class);
      CtMethod ctMethod = ctClass.getDeclaredMethod("applyTimeZone", new CtClass[]{getCtClass(Calendar.class), getCtClass(TimeZone.class)});
      Signature sig = JavassistSignatureFactory.getSignature(ctMethod);
      assertEquals(getClassMethodSignature(), sig);
      assertEquals(getStringMethodSignature(), sig);
      assertEquals(getMethodSignature(), sig);
      assertEquals(getMethodInfoSignature(), sig);
   }

   public void testMethodParams() throws Exception
   {
      CtClass ctClass = getCtClass(SignatureTester.class);
      CtMethod ctMethod = ctClass.getDeclaredMethod("applyTimeZone", new CtClass[]{getCtClass(Calendar.class), getCtClass(TimeZone.class)});
      Signature sig = new JavassistMethodParametersSignature(ctMethod, 0);
      assertEquals(getClassMethodParametersSignature(), sig);
      assertEquals(getStringMethodParametersSignature(), sig);
      assertEquals(getMethodParametersSignature(), sig);
      assertEquals(getMethodInfoParametersSignature(), sig);
   }

   public void testField() throws Exception
   {
      CtClass ctClass = getCtClass(SignatureTester.class);
      Signature sig = JavassistSignatureFactory.getSignature(ctClass.getField("calendar"));      
      assertEquals(getStringFieldSignature(), sig);
      assertEquals(getFieldSignature(), sig);
      assertEquals(getFieldInfoSignature(), sig);
   }
}
