/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.XAReturnValue;
import com.microsoft.sqlserver.jdbc.XidImpl;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class SQLServerXAResource
implements XAResource {
    private SQLServerConnection con;
    private int timeoutSeconds;
    static final int XA_START = 0;
    static final int XA_END = 1;
    static final int XA_PREPARE = 2;
    static final int XA_COMMIT = 3;
    static final int XA_ROLLBACK = 4;
    static final int XA_FORGET = 5;
    static final int XA_RECOVER = 6;
    static final int XA_PREPARE_EX = 7;
    static final int XA_ROLLBACK_EX = 8;
    static final int XA_FORGET_EX = 9;
    static final int XA_INIT = 10;
    private SQLServerConnection controlConnection;
    private static boolean xaInitDone;
    private static Integer xaInitLock;
    private String sResourceManagerId;
    private int enlistedTransactionCount;
    private Logger xaLogger;
    private static int baseResourceID;
    private final int resourceID;
    private int tightlyCoupled = 0;
    public static final int SSTRANSTIGHTLYCPLD = 32768;
    private CallableStatement[] xaStatements = new CallableStatement[]{null, null, null, null, null, null, null, null, null, null};
    static final /* synthetic */ boolean $assertionsDisabled;

    String toLogString() {
        String string = " XAResourceID:" + this.resourceID;
        return string;
    }

    SQLServerXAResource(SQLServerConnection sQLServerConnection) {
        this.resourceID = SQLServerXAResource.nextResourceID();
        this.xaLogger = SQLServerXADataSource.xaLogger;
        this.con = sQLServerConnection;
        Properties properties = sQLServerConnection.activeConnectionProperties;
        this.sResourceManagerId = properties == null ? "" : properties.getProperty("serverName") + "." + properties.getProperty("databaseName") + "." + properties.getProperty("portNumber");
    }

    private synchronized CallableStatement getXACallableStatementHandle(int n) throws SQLServerException {
        if (!($assertionsDisabled || n >= 0 && n <= 9)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.xaStatements.length) {
            throw new AssertionError();
        }
        if (null != this.xaStatements[n]) {
            return this.xaStatements[n];
        }
        CallableStatement callableStatement = null;
        switch (n) {
            case 0: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_start(?, ?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 1: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_end(?, ?, ?, ?, ?)}");
                break;
            }
            case 2: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare(?, ?, ?, ?)}");
                break;
            }
            case 3: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_commit(?, ?, ?, ?, ?)}");
                break;
            }
            case 4: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback(?, ?, ?, ?)}");
                break;
            }
            case 5: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget(?, ?, ?, ?)}");
                break;
            }
            case 6: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_recover(?, ?, ?, ?)}");
                break;
            }
            case 7: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare_ex(?, ?, ?, ?,?)}");
                break;
            }
            case 8: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback_ex(?, ?, ?, ?, ?)}");
                break;
            }
            case 9: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget_ex(?, ?, ?, ?, ?)}");
            }
        }
        this.xaStatements[n] = callableStatement;
        return this.xaStatements[n];
    }

    private void closeXAStatements() throws SQLException {
        for (int i = 0; i < this.xaStatements.length; ++i) {
            if (null == this.xaStatements[i]) continue;
            this.xaStatements[i].close();
            this.xaStatements[i] = null;
        }
    }

    final void close() throws SQLException {
        block3: {
            try {
                this.closeXAStatements();
            }
            catch (Exception exception) {
                if (!this.xaLogger.isLoggable(Level.WARNING)) break block3;
                this.xaLogger.warning(this.toLogString() + "Closing exception ignored: " + exception);
            }
        }
        if (null != this.controlConnection) {
            this.controlConnection.close();
        }
    }

    private String flagsDisplay(int n) {
        if (0 == n) {
            return "TMNOFLAGS";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (0 != (0x800000 & n)) {
            stringBuffer.append("TMENDRSCAN");
        }
        if (0 != (0x20000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMFAIL");
        }
        if (0 != (0x200000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMJOIN");
        }
        if (0 != (0x40000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMONEPHASE");
        }
        if (0 != (0x8000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMRESUME");
        }
        if (0 != (0x1000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSTARTRSCAN");
        }
        if (0 != (0x4000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUCCESS");
        }
        if (0 != (0x2000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUSPEND");
        }
        if (0 != (0x8000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("SSTRANSTIGHTLYCPLD");
        }
        return stringBuffer.toString();
    }

    private String cookieDisplay(byte[] byArray) {
        return Util.byteToHexDisplayString(byArray);
    }

    private String typeDisplay(int n) {
        switch (n) {
            case 0: {
                return "XA_START";
            }
            case 1: {
                return "XA_END";
            }
            case 2: {
                return "XA_PREPARE";
            }
            case 3: {
                return "XA_COMMIT";
            }
            case 4: {
                return "XA_ROLLBACK";
            }
            case 5: {
                return "XA_FORGET";
            }
            case 6: {
                return "XA_RECOVER";
            }
        }
        return "UNKNOWN" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XAReturnValue DTC_XA_Interface(int n, Xid xid, int n2) throws SQLException {
        XAReturnValue xAReturnValue;
        int n3;
        SQLException sQLException;
        block50: {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " Calling XA function for type:" + this.typeDisplay(n) + " flags:" + this.flagsDisplay(n2) + " xid:" + XidImpl.xidDisplay(xid));
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (xid != null) {
                byArray = xid.getGlobalTransactionId();
                byArray2 = xid.getBranchQualifier();
            }
            sQLException = null;
            String string = "DTC_XA_";
            int n4 = 1;
            n3 = 0;
            xAReturnValue = new XAReturnValue();
            try {
                Object object;
                Object object2;
                PreparedStatement preparedStatement = null;
                if (this.controlConnection == null) {
                    object2 = this;
                    synchronized (object2) {
                        if (this.controlConnection == null) {
                            try {
                                object = (Properties)this.con.activeConnectionProperties.clone();
                                ((Properties)object).remove("sendStringParametersAsUnicode");
                                ((Properties)object).remove("selectMethod");
                                if (this.xaLogger.isLoggable(Level.FINE)) {
                                    this.xaLogger.fine("Creating an internal control connection for" + this.toLogString() + " xid:" + XidImpl.xidDisplay(xid));
                                }
                                SQLServerConnection sQLServerConnection = new SQLServerConnection();
                                sQLServerConnection.connect((Properties)object, null);
                                if (this.xaLogger.isLoggable(Level.FINE)) {
                                    this.xaLogger.fine("Created an internal control connection" + sQLServerConnection.toLogString() + " for " + this.toLogString() + " xid:" + XidImpl.xidDisplay(xid));
                                }
                                if (!xaInitDone) {
                                    Integer n5 = xaInitLock;
                                    synchronized (n5) {
                                        if (!xaInitDone) {
                                            CallableStatement callableStatement = null;
                                            callableStatement = sQLServerConnection.prepareCall("{call master..xp_sqljdbc_xa_init(?, ?)}");
                                            callableStatement.registerOutParameter(1, 4);
                                            callableStatement.registerOutParameter(2, 1);
                                            try {
                                                callableStatement.execute();
                                            }
                                            catch (SQLException sQLException2) {
                                                try {
                                                    callableStatement.close();
                                                    sQLServerConnection.close();
                                                }
                                                catch (SQLException sQLException3) {
                                                    // empty catch block
                                                }
                                                throw sQLException2;
                                            }
                                            int n6 = callableStatement.getInt(1);
                                            String string2 = callableStatement.getString(2);
                                            callableStatement.close();
                                            if (null != string2 && string2.length() > 1) {
                                                sQLServerConnection.close();
                                                throw new SQLException("xp_sqljdbc_xa_init failure, status:" + n6 + " msg:" + string2);
                                            }
                                            xaInitDone = true;
                                        }
                                    }
                                }
                                this.controlConnection = sQLServerConnection;
                            }
                            catch (SQLException sQLException4) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToCreateXAConnection"));
                                Object[] objectArray = new Object[]{new String(sQLException4.getMessage())};
                                throw new SQLException(messageFormat.format(objectArray));
                            }
                        }
                    }
                }
                switch (n) {
                    case 0: {
                        string = string + "START:";
                        preparedStatement = this.getXACallableStatementHandle(0);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        preparedStatement.setInt(n4++, n2);
                        preparedStatement.registerOutParameter(n4++, -2);
                        preparedStatement.setInt(n4++, this.timeoutSeconds);
                        break;
                    }
                    case 1: {
                        string = "END:";
                        preparedStatement = this.getXACallableStatementHandle(1);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        preparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 2: {
                        string = "PREPARE:";
                        preparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(7) : this.getXACallableStatementHandle(2);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        if ((0x8000 & n2) != 32768) break;
                        preparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 3: {
                        string = "COMMIT:";
                        preparedStatement = this.getXACallableStatementHandle(3);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        preparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 4: {
                        string = "ROLLBACK:";
                        preparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(8) : this.getXACallableStatementHandle(4);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        if ((0x8000 & n2) != 32768) break;
                        preparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 5: {
                        string = "FORGET:";
                        preparedStatement = (0x8000 & n2) == 32768 ? this.getXACallableStatementHandle(9) : this.getXACallableStatementHandle(5);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setBytes(n4++, byArray);
                        preparedStatement.setBytes(n4++, byArray2);
                        if ((0x8000 & n2) != 32768) break;
                        preparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 6: {
                        string = "RECOVER:";
                        preparedStatement = this.getXACallableStatementHandle(6);
                        preparedStatement.registerOutParameter(n4++, 4);
                        preparedStatement.registerOutParameter(n4++, 1);
                        preparedStatement.setInt(n4++, n2);
                        preparedStatement.registerOutParameter(n4++, -2);
                    }
                }
                preparedStatement.execute();
                n3 = preparedStatement.getInt(1);
                object2 = preparedStatement.getString(2);
                if (null != object2 && ((String)object2).length() > 1) {
                    sQLException = new SQLException(string + "Status:" + n3 + " msg:" + (String)object2);
                    break block50;
                }
                if (n == 0) {
                    object = preparedStatement.getBytes(6);
                    if (object == null) {
                        sQLException = new SQLException(string + "No transaction cookie returned");
                    } else {
                        try {
                            if (this.xaLogger.isLoggable(Level.FINE)) {
                                this.xaLogger.fine(this.toLogString() + " Begin enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                            }
                            this.con.JTAEnlistConnection((byte[])object);
                            ++this.enlistedTransactionCount;
                            if (this.xaLogger.isLoggable(Level.FINE)) {
                                this.xaLogger.fine(this.toLogString() + " End enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                            }
                        }
                        catch (SQLException sQLException5) {
                            sQLException = new SQLException("Failed to enlist:" + sQLException5.getMessage());
                        }
                    }
                }
                if (n == 1) {
                    try {
                        if (this.xaLogger.isLoggable(Level.FINE)) {
                            this.xaLogger.fine(this.toLogString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                        }
                        this.con.JTAUnenlistConnection();
                        --this.enlistedTransactionCount;
                        if (this.xaLogger.isLoggable(Level.FINE)) {
                            this.xaLogger.fine(this.toLogString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                        }
                    }
                    catch (SQLException sQLException6) {
                        sQLException = new SQLException("Failed to unenlist:" + sQLException6.getMessage());
                    }
                }
                if (n == 6) {
                    try {
                        xAReturnValue.bData = preparedStatement.getBytes(4);
                    }
                    catch (SQLException sQLException7) {
                        sQLException = new SQLException("Failed to read recovery XIDs:" + sQLException7.getMessage());
                    }
                }
            }
            catch (SQLException sQLException8) {
                sQLException = new SQLException(sQLException8.getMessage());
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toLogString() + " Status:" + n3);
        }
        xAReturnValue.nStatus = n3;
        return xAReturnValue;
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            this.tightlyCoupled = n & 0x8000;
            this.DTC_XA_Interface(0, xid, n);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            this.DTC_XA_Interface(1, xid, n | this.tightlyCoupled);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        try {
            XAReturnValue xAReturnValue = this.DTC_XA_Interface(2, xid, this.tightlyCoupled);
            n = xAReturnValue.nStatus;
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
        return n;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            this.DTC_XA_Interface(3, xid, (bl ? 0x40000000 : 0) | this.tightlyCoupled);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.DTC_XA_Interface(4, xid, this.tightlyCoupled);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.DTC_XA_Interface(5, xid, this.tightlyCoupled);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public Xid[] recover(int n) throws XAException {
        try {
            int n2;
            int n3;
            XAReturnValue xAReturnValue = this.DTC_XA_Interface(6, null, n | this.tightlyCoupled);
            Vector<XidImpl> vector = new Vector<XidImpl>();
            if (null == xAReturnValue.bData) {
                return new XidImpl[0];
            }
            for (int i = 0; i < xAReturnValue.bData.length; i += n3) {
                int n4;
                int n5 = 1;
                n2 = 0;
                for (n4 = 0; n4 < 4; ++n4) {
                    n3 = xAReturnValue.bData[i + n4] & 0xFF;
                    n2 += (n3 *= n5);
                    n5 *= 256;
                }
                i += 4;
                n4 = xAReturnValue.bData[i++] & 0xFF;
                n3 = xAReturnValue.bData[i++] & 0xFF;
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n3];
                System.arraycopy(xAReturnValue.bData, i, byArray, 0, n4);
                System.arraycopy(xAReturnValue.bData, i += n4, byArray2, 0, n3);
                XidImpl xidImpl = new XidImpl(n2, byArray, byArray2);
                vector.add(xidImpl);
            }
            Xid[] xidArray = new XidImpl[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                xidArray[n2] = (XidImpl)vector.elementAt(n2);
                if (!this.xaLogger.isLoggable(Level.FINE)) continue;
                this.xaLogger.fine(this.toLogString() + ((XidImpl)xidArray[n2]).toLogString());
            }
            return xidArray;
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine(this.toLogString() + " exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toLogString() + " xares:" + xAResource);
        }
        if (!(xAResource instanceof SQLServerXAResource)) {
            return false;
        }
        SQLServerXAResource sQLServerXAResource = (SQLServerXAResource)xAResource;
        return sQLServerXAResource.sResourceManagerId.equals(this.sResourceManagerId);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.timeoutSeconds = n;
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toLogString() + " TransactionTimeout:" + n);
        }
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeoutSeconds;
    }

    private static synchronized int nextResourceID() {
        return ++baseResourceID;
    }

    static {
        $assertionsDisabled = !SQLServerXAResource.class.desiredAssertionStatus();
        baseResourceID = 0;
        xaInitLock = new Integer(0);
    }
}

