/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.ConfHandler;
import org.tuckey.web.filters.urlrewrite.OutboundRule;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.RuleBase;
import org.tuckey.web.filters.urlrewrite.Run;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXParseException;

public final class Conf {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$Conf == null ? (class$org$tuckey$web$filters$urlrewrite$Conf = Conf.class$("org.tuckey.web.filters.urlrewrite.Conf")) : class$org$tuckey$web$filters$urlrewrite$Conf);
    private final List errors = new ArrayList();
    private final List rules = new ArrayList(50);
    private List outboundRules = new ArrayList(50);
    private boolean ok = false;
    private Date loadedDate = null;
    private int ruleIdCounter = 0;
    private int outboundRuleIdCounter = 0;
    private String fileName;
    private ServletContext context;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$Conf;

    public Conf() {
        this.loadedDate = new Date();
    }

    public Conf(ServletContext context, InputStream inputStream, String fileName) {
        this.context = context;
        this.fileName = fileName;
        this.loadDom(inputStream);
        this.initialise();
        this.loadedDate = new Date();
    }

    public Conf(InputStream inputStream, String conffile) {
        this(null, inputStream, conffile);
    }

    private synchronized void loadDom(InputStream inputStream) {
        DocumentBuilder parser;
        if (inputStream == null) {
            log.error("inputstream is null");
            return;
        }
        ConfHandler handler = new ConfHandler();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        log.debug("XML builder factory is: " + factory.getClass().getName());
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to setup XML parser for reading conf", e);
            return;
        }
        log.debug("XML Parser: " + parser.getClass().getName());
        parser.setErrorHandler(handler);
        parser.setEntityResolver(handler);
        try {
            log.debug("about to parse conf");
            Document doc = parser.parse(inputStream);
            this.processConfDoc(doc);
        }
        catch (SAXParseException e) {
            this.addError("Parse error on line " + e.getLineNumber() + " " + e.getMessage(), e);
        }
        catch (Exception e) {
            this.addError("Exception loading conf  " + e.getMessage(), e);
        }
    }

    private void processConfDoc(Document doc) {
        Element rootElement = doc.getDocumentElement();
        NodeList rootElementList = rootElement.getChildNodes();
        for (int i = 0; i < rootElementList.getLength(); ++i) {
            Node toNode;
            RuleBase rule;
            Element ruleElement;
            Node node = rootElementList.item(i);
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals("rule")) {
                ruleElement = (Element)node;
                rule = new Rule();
                Conf.processRuleBasics(ruleElement, rule);
                Conf.procesConditions(ruleElement, rule);
                Conf.processRuns(ruleElement, rule);
                toNode = ruleElement.getElementsByTagName("to").item(0);
                rule.setTo(Conf.getNodeValue(toNode));
                ((Rule)rule).setToType(Conf.getAttrValue(toNode, "type"));
                rule.setToLast(Conf.getAttrValue(toNode, "last"));
                if ("true".equalsIgnoreCase(Conf.getAttrValue(toNode, "encode"))) {
                    ((Rule)rule).setEncodeToUrl(true);
                }
                Conf.processSetAttributes(ruleElement, rule);
                this.addRule((Rule)rule);
                continue;
            }
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("outbound-rule")) continue;
            ruleElement = (Element)node;
            rule = new OutboundRule();
            Conf.processRuleBasics(ruleElement, rule);
            if ("true".equalsIgnoreCase(Conf.getAttrValue(ruleElement, "encodefirst"))) {
                ((OutboundRule)rule).setEncodeFirst(true);
            }
            Conf.procesConditions(ruleElement, rule);
            Conf.processRuns(ruleElement, rule);
            toNode = ruleElement.getElementsByTagName("to").item(0);
            rule.setTo(Conf.getNodeValue(toNode));
            rule.setToLast(Conf.getAttrValue(toNode, "last"));
            if ("false".equalsIgnoreCase(Conf.getAttrValue(toNode, "encode"))) {
                ((OutboundRule)rule).setEncodeToUrl(false);
            }
            Conf.processSetAttributes(ruleElement, rule);
            this.addOutboundRule((OutboundRule)rule);
        }
    }

    private static void processRuleBasics(Element ruleElement, RuleBase rule) {
        if ("false".equalsIgnoreCase(Conf.getAttrValue(ruleElement, "enabled"))) {
            rule.setEnabled(false);
        }
        Node nameNode = ruleElement.getElementsByTagName("name").item(0);
        rule.setName(Conf.getNodeValue(nameNode));
        Node noteNode = ruleElement.getElementsByTagName("note").item(0);
        rule.setNote(Conf.getNodeValue(noteNode));
        Node fromNode = ruleElement.getElementsByTagName("from").item(0);
        rule.setFrom(Conf.getNodeValue(fromNode));
        if ("true".equalsIgnoreCase(Conf.getAttrValue(fromNode, "casesensitive"))) {
            rule.setFromCaseSensitive(true);
        }
    }

    private static void processSetAttributes(Element ruleElement, RuleBase rule) {
        NodeList setNodes = ruleElement.getElementsByTagName("set");
        for (int j = 0; j < setNodes.getLength(); ++j) {
            Node setNode = setNodes.item(j);
            if (setNode == null) continue;
            SetAttribute setAttribute = new SetAttribute();
            setAttribute.setValue(Conf.getNodeValue(setNode));
            setAttribute.setType(Conf.getAttrValue(setNode, "type"));
            setAttribute.setName(Conf.getAttrValue(setNode, "name"));
            rule.addSetAttribute(setAttribute);
        }
    }

    private static void processRuns(Element ruleElement, RuleBase rule) {
        NodeList runNodes = ruleElement.getElementsByTagName("run");
        for (int j = 0; j < runNodes.getLength(); ++j) {
            Node runNode = runNodes.item(j);
            if (runNode == null) continue;
            Run run = new Run();
            if (runNode.getNodeType() == 1) {
                Element runElement = (Element)runNode;
                NodeList initParamsNodeList = runElement.getElementsByTagName("init-param");
                for (int k = 0; k < initParamsNodeList.getLength(); ++k) {
                    Node initParamNode = initParamsNodeList.item(k);
                    if (initParamNode == null || initParamNode.getNodeType() != 1) continue;
                    Element initParamElement = (Element)initParamNode;
                    Node paramNameNode = initParamElement.getElementsByTagName("param-name").item(0);
                    Node paramValueNode = initParamElement.getElementsByTagName("param-value").item(0);
                    run.addInitParam(Conf.getNodeValue(paramNameNode), Conf.getNodeValue(paramValueNode));
                }
            }
            run.setClassStr(Conf.getAttrValue(runNode, "class"));
            run.setMethodStr(Conf.getAttrValue(runNode, "method"));
            run.setNewEachTime("true".equalsIgnoreCase(Conf.getAttrValue(runNode, "neweachtime")));
            rule.addRun(run);
        }
    }

    private static void procesConditions(Element ruleElement, RuleBase rule) {
        NodeList conditionNodes = ruleElement.getElementsByTagName("condition");
        for (int j = 0; j < conditionNodes.getLength(); ++j) {
            Node conditionNode = conditionNodes.item(j);
            if (conditionNode == null) continue;
            Condition condition = new Condition();
            condition.setValue(Conf.getNodeValue(conditionNode));
            condition.setType(Conf.getAttrValue(conditionNode, "type"));
            condition.setName(Conf.getAttrValue(conditionNode, "name"));
            condition.setNext(Conf.getAttrValue(conditionNode, "next"));
            condition.setCaseSensitive("true".equalsIgnoreCase(Conf.getAttrValue(conditionNode, "casesensitive")));
            condition.setOperator(Conf.getAttrValue(conditionNode, "operator"));
            rule.addCondition(condition);
        }
    }

    private static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        Node child = nodeList.item(0);
        if (child == null) {
            return null;
        }
        if (child.getNodeType() == 3) {
            String value = ((Text)child).getData();
            return value.trim();
        }
        return null;
    }

    private static String getAttrValue(Node n, String attrName) {
        if (n == null) {
            return null;
        }
        NamedNodeMap attrs = n.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node attr = attrs.getNamedItem(attrName);
        if (attr == null) {
            return null;
        }
        String val = attr.getNodeValue();
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    public void initialise() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("now initialising conf");
        }
        boolean rulesOk = true;
        for (i = 0; i < this.rules.size(); ++i) {
            Rule rule = (Rule)this.rules.get(i);
            if (rule.initialise(this.context)) continue;
            rulesOk = false;
        }
        for (i = 0; i < this.outboundRules.size(); ++i) {
            OutboundRule outboundRule = (OutboundRule)this.outboundRules.get(i);
            if (outboundRule.initialise(this.context)) continue;
            rulesOk = false;
        }
        if (rulesOk) {
            this.ok = true;
        }
    }

    public void destroy() {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = (Rule)this.rules.get(i);
            rule.destroy();
        }
    }

    public void addRule(Rule rule) {
        rule.setId(this.ruleIdCounter++);
        this.rules.add(rule);
    }

    public void addOutboundRule(OutboundRule outboundRule) {
        outboundRule.setId(this.outboundRuleIdCounter++);
        this.outboundRules.add(outboundRule);
    }

    public List getErrors() {
        return this.errors;
    }

    public List getRules() {
        return this.rules;
    }

    public List getOutboundRules() {
        return this.outboundRules;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void addError(String errorMsg, Exception e) {
        this.errors.add(errorMsg);
        log.error(errorMsg, e);
    }

    public Date getLoadedDate() {
        return this.loadedDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

