/*
 * Copyright (C) 2003 - 2016 Sony Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "ldac.h"

/***************************************************************************************************
    Window Tables
***************************************************************************************************/
DECLFUNC const SCALAR *gaa_fwin_ldac[LDAC_NUMLNN];
static const SCALAR sa_fwin_1fs_ldac[LDAC_1FSLSU] = {
    3.7649080427729667e-05, 3.3880770582525241e-04, 9.4094354992539870e-04, 1.8436939086109933e-03,
    3.0465149988219862e-03, 4.5486822861099899e-03, 6.3492909210708052e-03, 8.4472562843918454e-03,
    1.0841314640186185e-02, 1.3530023897219945e-02, 1.6511764477573954e-02, 1.9784740292217093e-02,
    2.3346979822903100e-02, 2.7196337309739343e-02, 3.1330494043712527e-02, 3.5746959763392233e-02,
    4.0443074154971129e-02, 4.5416008454738845e-02, 5.0662767153023092e-02, 5.6180189798573019e-02,
    6.1964952902296720e-02, 6.8013571939206638e-02, 7.4322403447367416e-02, 8.0887647222581002e-02,
    8.7705348607487368e-02, 9.4771400873702616e-02, 1.0208154769555824e-01, 1.0963138571395278e-01,
    1.1741636718877053e-01, 1.2543180273827034e-01, 1.3367286416379359e-01, 1.4213458735809070e-01,
    1.5081187529551357e-01, 1.5969950110227349e-01, 1.6879211120491414e-01, 1.7808422855510431e-01,
    1.8757025592880680e-01, 1.9724447929783726e-01, 2.0710107127178060e-01, 2.1713409460819344e-01,
    2.2733750578897677e-01, 2.3770515866076555e-01, 2.4823080813714124e-01, 2.5890811396043867e-01,
    2.6973064452088003e-01, 2.8069188073073620e-01, 2.9178521995118140e-01, 3.0300397996947592e-01,
    3.1434140302408126e-01, 3.2579065987528272e-01, 3.3734485391886854e-01, 3.4899702534038596e-01,
    3.6074015530747344e-01, 3.7256717019774271e-01, 3.8447094585966446e-01, 3.9644431190389073e-01,
    4.0848005602242954e-01, 4.2057092833306925e-01, 4.3270964574643694e-01, 4.4488889635305845e-01,
    4.5710134382778006e-01, 4.6933963184889571e-01, 4.8159638852932057e-01, 4.9386423085714004e-01,
    5.0613576914285996e-01, 5.1840361147067937e-01, 5.3066036815110429e-01, 5.4289865617222000e-01,
    5.5511110364694149e-01, 5.6729035425356311e-01, 5.7942907166693070e-01, 5.9151994397757046e-01,
    6.0355568809610927e-01, 6.1552905414033554e-01, 6.2743282980225734e-01, 6.3925984469252650e-01,
    6.5100297465961399e-01, 6.6265514608113141e-01, 6.7420934012471734e-01, 6.8565859697591880e-01,
    6.9699602003052408e-01, 7.0821478004881855e-01, 7.1930811926926386e-01, 7.3026935547911997e-01,
    7.4109188603956133e-01, 7.5176919186285873e-01, 7.6229484133923442e-01, 7.7266249421102318e-01,
    7.8286590539180656e-01, 7.9289892872821943e-01, 8.0275552070216272e-01, 8.1242974407119317e-01,
    8.2191577144489569e-01, 8.3120788879508589e-01, 8.4030049889772651e-01, 8.4918812470448646e-01,
    8.5786541264190930e-01, 8.6632713583620635e-01, 8.7456819726172963e-01, 8.8258363281122942e-01,
    8.9036861428604719e-01, 8.9791845230444178e-01, 9.0522859912629738e-01, 9.1229465139251265e-01,
    9.1911235277741898e-01, 9.2567759655263260e-01, 9.3198642806079335e-01, 9.3803504709770325e-01,
    9.4381981020142702e-01, 9.4933723284697691e-01, 9.5458399154526119e-01, 9.5955692584502883e-01,
    9.6425304023660774e-01, 9.6866950595628742e-01, 9.7280366269026064e-01, 9.7665302017709688e-01,
    9.8021525970778289e-01, 9.8348823552242604e-01, 9.8646997610278009e-01, 9.8915868535981377e-01,
    9.9155274371560820e-01, 9.9365070907892916e-01, 9.9545131771389006e-01, 9.9695348500117797e-01,
    9.9815630609138906e-01, 9.9905905645007465e-01, 9.9966119229417472e-01, 9.9996235091957231e-01,
};
static const SCALAR sa_fwin_2fs_ldac[LDAC_2FSLSU] = {
    9.4123586994287859e-06, 8.4709102088288972e-05, 2.3529124945341780e-04, 4.6113612367731146e-04,
    7.6220971335262645e-04, 1.1384666779041968e-03, 1.5898503544171428e-03, 2.1162927661701014e-03,
    2.7177146328722815e-03, 3.3940253826027396e-03, 4.1451231654502426e-03, 4.9708948688514491e-03,
    5.8712161346252531e-03, 6.8459513777006896e-03, 7.8949538065354735e-03, 9.0180654452223750e-03,
    1.0215117157279735e-02, 1.1485928671122823e-02, 1.2830308607212064e-02, 1.4248054506874127e-02,
    1.5738952862791353e-02, 1.7302779151155318e-02, 1.8939297865479203e-02, 2.0648262552064218e-02,
    2.2429415847114661e-02, 2.4282489515495831e-02, 2.6207204491129441e-02, 2.8203270919019821e-02,
    3.0270388198905041e-02, 3.2408245030526237e-02, 3.4616519460508151e-02, 3.6894878930844345e-02,
    3.9242980328979035e-02, 4.1660470039478668e-02, 4.4146983997285061e-02, 4.6702147742542340e-02,
    4.9325576476989007e-02, 5.2016875121907433e-02, 5.4775638377621054e-02, 5.7601450784531098e-02,
    6.0493886785683293e-02, 6.3452510790854968e-02, 6.6476877242153690e-02, 6.9566530681116359e-02,
    7.2721005817299733e-02, 7.5939827598351411e-02, 7.9222511281550820e-02, 8.2568562506809995e-02,
    8.5977477371122130e-02, 8.9448742504447690e-02, 9.2981835147025835e-02, 9.6576223228100361e-02,
    1.0023136544604751e-01, 1.0394671134989383e-01, 1.0772170142221238e-01, 1.1155576716338379e-01,
    1.1544833117721018e-01, 1.1939880725786912e-01, 1.2340660047819377e-01, 1.2747110727926703e-01,
    1.3159171556131508e-01, 1.3576780477588740e-01, 1.3999874601930917e-01, 1.4428390212739181e-01,
    1.4862262777138735e-01, 1.5301426955517303e-01, 1.5745816611364982e-01, 1.6195364821234201e-01,
    1.6650003884818126e-01, 1.7109665335146068e-01, 1.7574279948894378e-01, 1.8043777756811213e-01,
    1.8518088054253648e-01, 1.8997139411835545e-01, 1.9480859686184529e-01, 1.9969176030806554e-01,
    2.0462014907056292e-01, 2.0959302095211774e-01, 2.1460962705651634e-01, 2.1966921190133201e-01,
    2.2477101353169759e-01, 2.2991426363505360e-01, 2.3509818765685267e-01, 2.4032200491720521e-01,
    2.4558492872844651e-01, 2.5088616651360907e-01, 2.5622491992578200e-01, 2.6160038496833893e-01,
    2.6701175211601691e-01, 2.7245820643682811e-01, 2.7793892771478540e-01, 2.8345309057342405e-01,
    2.8899986460010013e-01, 2.9457841447104804e-01, 3.0018790007717661e-01, 3.0582747665058685e-01,
    3.1149629489179087e-01, 3.1719350109761307e-01, 3.2291823728975483e-01, 3.2866964134400284e-01,
    3.3444684712006179e-01, 3.4024898459199215e-01, 3.4607517997923254e-01, 3.5192455587818811e-01,
    3.5779623139436406e-01, 3.6368932227502548e-01, 3.6960294104236224e-01, 3.7553619712713993e-01,
    3.8148819700281639e-01, 3.8745804432010356e-01, 3.9344484004195435e-01, 3.9944768257895402e-01,
    4.0546566792509692e-01, 4.1149788979392560e-01, 4.1754343975501507e-01, 4.2360140737077828e-01,
    4.2967088033357537e-01, 4.3575094460310343e-01, 4.4184068454404762e-01, 4.4793918306397273e-01,
    4.5404552175143365e-01, 4.6015878101428492e-01, 4.6627804021816799e-01, 4.7240237782515504e-01,
    4.7853087153252960e-01, 4.8466259841168169e-01, 4.9079663504709758e-01, 4.9693205767542276e-01,
    5.0306794232457719e-01, 5.0920336495290242e-01, 5.1533740158831831e-01, 5.2146912846747040e-01,
    5.2759762217484496e-01, 5.3372195978183201e-01, 5.3984121898571502e-01, 5.4595447824856635e-01,
    5.5206081693602727e-01, 5.5815931545595243e-01, 5.6424905539689663e-01, 5.7032911966642463e-01,
    5.7639859262922166e-01, 5.8245656024498493e-01, 5.8850211020607435e-01, 5.9453433207490314e-01,
    6.0055231742104598e-01, 6.0655515995804565e-01, 6.1254195567989644e-01, 6.1851180299718356e-01,
    6.2446380287286007e-01, 6.3039705895763776e-01, 6.3631067772497452e-01, 6.4220376860563588e-01,
    6.4807544412181195e-01, 6.5392482002076746e-01, 6.5975101540800785e-01, 6.6555315287993821e-01,
    6.7133035865599722e-01, 6.7708176271024523e-01, 6.8280649890238698e-01, 6.8850370510820913e-01,
    6.9417252334941315e-01, 6.9981209992282345e-01, 7.0542158552895196e-01, 7.1100013539989981e-01,
    7.1654690942657595e-01, 7.2206107228521466e-01, 7.2754179356317195e-01, 7.3298824788398309e-01,
    7.3839961503166107e-01, 7.4377508007421800e-01, 7.4911383348639093e-01, 7.5441507127155349e-01,
    7.5967799508279477e-01, 7.6490181234314736e-01, 7.7008573636494637e-01, 7.7522898646830241e-01,
    7.8033078809866796e-01, 7.8539037294348368e-01, 7.9040697904788226e-01, 7.9537985092943708e-01,
    8.0030823969193443e-01, 8.0519140313815474e-01, 8.1002860588164460e-01, 8.1481911945746355e-01,
    8.1956222243188781e-01, 8.2425720051105622e-01, 8.2890334664853937e-01, 8.3349996115181868e-01,
    8.3804635178765796e-01, 8.4254183388635018e-01, 8.4698573044482695e-01, 8.5137737222861265e-01,
    8.5571609787260816e-01, 8.6000125398069083e-01, 8.6423219522411254e-01, 8.6840828443868490e-01,
    8.7252889272073297e-01, 8.7659339952180626e-01, 8.8060119274213089e-01, 8.8455166882278979e-01,
    8.8844423283661622e-01, 8.9227829857778762e-01, 8.9605328865010614e-01, 8.9976863455395251e-01,
    9.0342377677189967e-01, 9.0701816485297415e-01, 9.1055125749555232e-01, 9.1402252262887784e-01,
    9.1743143749319001e-01, 9.2077748871844922e-01, 9.2406017240164862e-01, 9.2727899418270032e-01,
    9.3043346931888360e-01, 9.3352312275784632e-01, 9.3654748920914499e-01, 9.3950611321431676e-01,
    9.4239854921546895e-01, 9.4522436162237899e-01, 9.4798312487809255e-01, 9.5067442352301101e-01,
    9.5329785225745767e-01, 9.5585301600271488e-01, 9.5833952996052130e-01, 9.6075701967102101e-01,
    9.6310512106915569e-01, 9.6538348053949186e-01, 9.6759175496947381e-01, 9.6972961180109496e-01,
    9.7179672908098014e-01, 9.7379279550887055e-01, 9.7571751048450417e-01, 9.7757058415288534e-01,
    9.7935173744793580e-01, 9.8106070213452079e-01, 9.8269722084884470e-01, 9.8426104713720863e-01,
    9.8575194549312584e-01, 9.8716969139278798e-01, 9.8851407132887714e-01, 9.8978488284272026e-01,
    9.9098193455477768e-01, 9.9210504619346451e-01, 9.9315404862229928e-01, 9.9412878386537473e-01,
    9.9502910513114851e-01, 9.9585487683454976e-01, 9.9660597461739731e-01, 9.9728228536712771e-01,
    9.9788370723382991e-01, 9.9841014964558283e-01, 9.9886153332209582e-01, 9.9923779028664739e-01,
    9.9953886387632274e-01, 9.9976470875054657e-01, 9.9991529089791176e-01, 9.9999058764130055e-01,
};

/***************************************************************************************************
    MDCT/IMDCT Tables
***************************************************************************************************/
DECLFUNC const SCALAR *gaa_wcos_ldac[LDAC_NUMLNN];
static const SCALAR sa_wcos_1fs_ldac[LDAC_1FSLSU] = {
    7.0710678118654757e-01, 9.2387953251128674e-01,-3.8268343236508973e-01, 9.8078528040323043e-01,
    5.5557023301960229e-01,-1.9509032201612819e-01,-8.3146961230254535e-01, 9.9518472667219693e-01,
    8.8192126434835505e-01, 6.3439328416364549e-01, 2.9028467725446233e-01,-9.8017140329560645e-02,
   -4.7139673682599770e-01,-7.7301045336273699e-01,-9.5694033573220882e-01, 9.9879545620517241e-01,
    9.7003125319454397e-01, 9.0398929312344334e-01, 8.0320753148064494e-01, 6.7155895484701833e-01,
    5.1410274419322166e-01, 3.3688985339222005e-01, 1.4673047445536175e-01,-4.9067674327418008e-02,
   -2.4298017990326387e-01,-4.2755509343028186e-01,-5.9569930449243336e-01,-7.4095112535495888e-01,
   -8.5772861000027201e-01,-9.4154406518302070e-01,-9.8917650996478101e-01, 9.9969881869620425e-01,
    9.9247953459870997e-01, 9.7570213003852857e-01, 9.4952818059303667e-01, 9.1420975570353069e-01,
    8.7008699110871146e-01, 8.1758481315158371e-01, 7.5720884650648457e-01, 6.8954054473706694e-01,
    6.1523159058062682e-01, 5.3499761988709726e-01, 4.4961132965460660e-01, 3.5989503653498828e-01,
    2.6671275747489842e-01, 1.7096188876030136e-01, 7.3564563599667454e-02,-2.4541228522912142e-02,
   -1.2241067519921615e-01,-2.1910124015686966e-01,-3.1368174039889141e-01,-4.0524131400498975e-01,
   -4.9289819222978398e-01,-5.7580819141784534e-01,-6.5317284295377653e-01,-7.2424708295146678e-01,
   -7.8834642762660623e-01,-8.4485356524970712e-01,-8.9322430119551521e-01,-9.3299279883473885e-01,
   -9.6377606579543984e-01,-9.8527764238894122e-01,-9.9729045667869021e-01, 9.9998117528260111e-01,
    9.9952941750109314e-01, 9.9847558057329477e-01, 9.9682029929116567e-01, 9.9456457073425542e-01,
    9.9170975366909953e-01, 9.8825756773074946e-01, 9.8421009238692903e-01, 9.7956976568544052e-01,
    9.7433938278557586e-01, 9.6852209427441738e-01, 9.6212140426904158e-01, 9.5514116830577078e-01,
    9.4758559101774109e-01, 9.3945922360218992e-01, 9.3076696107898371e-01, 9.2151403934204201e-01,
    9.1170603200542988e-01, 9.0134884704602203e-01, 8.9044872324475788e-01, 8.7901222642863353e-01,
    8.6704624551569265e-01, 8.5455798836540053e-01, 8.4155497743689844e-01, 8.2804504525775580e-01,
    8.1403632970594841e-01, 7.9953726910790501e-01, 7.8455659715557524e-01, 7.6910333764557970e-01,
    7.5318679904361252e-01, 7.3681656887736990e-01, 7.2000250796138165e-01, 7.0275474445722530e-01,
    6.8508366777270036e-01, 6.6699992230363747e-01, 6.4851440102211255e-01, 6.2963823891492710e-01,
    6.1038280627630948e-01, 5.9075970185887428e-01, 5.7078074588696737e-01, 5.5045797293660481e-01,
    5.2980362468629483e-01, 5.0883014254310699e-01, 4.8755016014843605e-01, 4.6597649576796613e-01,
    4.4412214457042926e-01, 4.2200027079979979e-01, 3.9962419984564679e-01, 3.7700741021641831e-01,
    3.5416352542049051e-01, 3.3110630575987643e-01, 3.0784964004153498e-01, 2.8440753721127182e-01,
    2.6079411791527557e-01, 2.3702360599436734e-01, 2.1311031991609136e-01, 1.8906866414980628e-01,
    1.6491312048997009e-01, 1.4065823933284924e-01, 1.1631863091190488e-01, 9.1908956497132696e-02,
    6.7443919563664106e-02, 4.2938256934940959e-02, 1.8406729905804820e-02, 0.0000000000000000e+00,
};
static const SCALAR sa_wcos_2fs_ldac[LDAC_2FSLSU] = {
    7.0710678118654757e-01, 9.2387953251128674e-01,-3.8268343236508973e-01, 9.8078528040323043e-01,
    5.5557023301960229e-01,-1.9509032201612819e-01,-8.3146961230254535e-01, 9.9518472667219693e-01,
    8.8192126434835505e-01, 6.3439328416364549e-01, 2.9028467725446233e-01,-9.8017140329560645e-02,
   -4.7139673682599770e-01,-7.7301045336273699e-01,-9.5694033573220882e-01, 9.9879545620517241e-01,
    9.7003125319454397e-01, 9.0398929312344334e-01, 8.0320753148064494e-01, 6.7155895484701833e-01,
    5.1410274419322166e-01, 3.3688985339222005e-01, 1.4673047445536175e-01,-4.9067674327418008e-02,
   -2.4298017990326387e-01,-4.2755509343028186e-01,-5.9569930449243336e-01,-7.4095112535495888e-01,
   -8.5772861000027201e-01,-9.4154406518302070e-01,-9.8917650996478101e-01, 9.9969881869620425e-01,
    9.9247953459870997e-01, 9.7570213003852857e-01, 9.4952818059303667e-01, 9.1420975570353069e-01,
    8.7008699110871146e-01, 8.1758481315158371e-01, 7.5720884650648457e-01, 6.8954054473706694e-01,
    6.1523159058062682e-01, 5.3499761988709726e-01, 4.4961132965460660e-01, 3.5989503653498828e-01,
    2.6671275747489842e-01, 1.7096188876030136e-01, 7.3564563599667454e-02,-2.4541228522912142e-02,
   -1.2241067519921615e-01,-2.1910124015686966e-01,-3.1368174039889141e-01,-4.0524131400498975e-01,
   -4.9289819222978398e-01,-5.7580819141784534e-01,-6.5317284295377653e-01,-7.2424708295146678e-01,
   -7.8834642762660623e-01,-8.4485356524970712e-01,-8.9322430119551521e-01,-9.3299279883473885e-01,
   -9.6377606579543984e-01,-9.8527764238894122e-01,-9.9729045667869021e-01, 9.9992470183914450e-01,
    9.9811811290014918e-01, 9.9390697000235606e-01, 9.8730141815785843e-01, 9.7831737071962765e-01,
    9.6697647104485207e-01, 9.5330604035419386e-01, 9.3733901191257496e-01, 9.1911385169005777e-01,
    8.9867446569395382e-01, 8.7607009419540660e-01, 8.5135519310526520e-01, 8.2458930278502529e-01,
    7.9583690460888357e-01, 7.6516726562245896e-01, 7.3265427167241282e-01, 6.9837624940897292e-01,
    6.6241577759017178e-01, 6.2485948814238645e-01, 5.8579785745643886e-01, 5.4532498842204646e-01,
    5.0353838372571758e-01, 4.6053871095824001e-01, 4.1642956009763732e-01, 3.7131719395183760e-01,
    3.2531029216226298e-01, 2.7851968938505306e-01, 2.3105810828067128e-01, 1.8303988795514106e-01,
    1.3458070850712622e-01, 8.5797312344439880e-02, 3.6807222941358991e-02,-1.2271538285719823e-02,
   -6.1320736302208530e-02,-1.1022220729388306e-01,-1.5885814333386128e-01,-2.0711137619221845e-01,
   -2.5486565960451452e-01,-3.0200594931922808e-01,-3.4841868024943440e-01,-3.9399204006104799e-01,
   -4.3861623853852738e-01,-4.8218377207912272e-01,-5.2458968267846873e-01,-5.6573181078361323e-01,
   -6.0551104140432543e-01,-6.4383154288979128e-01,-6.8060099779545302e-01,-7.1573082528381859e-01,
   -7.4913639452345915e-01,-7.8073722857209449e-01,-8.1045719825259466e-01,-8.3822470555483808e-01,
   -8.6397285612158670e-01,-8.8763962040285382e-01,-9.0916798309052238e-01,-9.2850608047321548e-01,
   -9.4560732538052117e-01,-9.6043051941556579e-01,-9.7293995220556007e-01,-9.8310548743121629e-01,
   -9.9090263542778001e-01,-9.9631261218277800e-01,-9.9932238458834954e-01, 9.9999529380957619e-01,
    9.9988234745421256e-01, 9.9961882249517864e-01, 9.9920475861836389e-01, 9.9864021818026527e-01,
    9.9792528619859600e-01, 9.9706007033948296e-01, 9.9604470090125197e-01, 9.9487933079480562e-01,
    9.9356413552059530e-01, 9.9209931314219180e-01, 9.9048508425645709e-01, 9.8872169196032378e-01,
    9.8680940181418553e-01, 9.8474850180190421e-01, 9.8253930228744124e-01, 9.8018213596811743e-01,
    9.7767735782450993e-01, 9.7502534506699412e-01, 9.7222649707893627e-01, 9.6928123535654853e-01,
    9.6619000344541250e-01, 9.6295326687368388e-01, 9.5957151308198452e-01, 9.5604525134999641e-01,
    9.5237501271976588e-01, 9.4856134991573027e-01, 9.4460483726148026e-01, 9.4050607059326830e-01,
    9.3626566717027826e-01, 9.3188426558166815e-01, 9.2736252565040111e-01, 9.2270112833387863e-01,
    9.1790077562139050e-01, 9.1296219042839821e-01, 9.0788611648766626e-01, 9.0267331823725883e-01,
    8.9732458070541832e-01, 8.9184070939234272e-01, 8.8622253014888064e-01, 8.8047088905216075e-01,
    8.7458665227817611e-01, 8.6857070597134090e-01, 8.6242395611104061e-01, 8.5614732837519447e-01,
    8.4974176800085255e-01, 8.4320823964184544e-01, 8.3654772722351201e-01, 8.2976123379452305e-01,
    8.2284978137582643e-01, 8.1581441080673378e-01, 8.0865618158817498e-01, 8.0137617172314024e-01,
    7.9397547755433717e-01, 7.8645521359908577e-01, 7.7881651238147598e-01, 7.7106052426181382e-01,
    7.6318841726338127e-01, 7.5520137689653655e-01, 7.4710060598018013e-01, 7.3888732446061511e-01,
    7.3056276922782759e-01, 7.2212819392921535e-01, 7.1358486878079364e-01, 7.0493408037590499e-01,
    6.9617713149146299e-01, 6.8731534089175916e-01, 6.7835004312986158e-01, 6.6928258834663601e-01,
    6.6011434206742048e-01, 6.5084668499638099e-01, 6.4148101280858316e-01, 6.3201873593980906e-01,
    6.2246127937415008e-01, 6.1281008242940971e-01, 6.0306659854034828e-01, 5.9323229503979980e-01,
    5.8330865293769829e-01, 5.7329716669804232e-01, 5.6319934401383409e-01, 5.5301670558002758e-01,
    5.4275078486451600e-01, 5.3240312787719801e-01, 5.2197529293715439e-01, 5.1146885043797052e-01,
    5.0088538261124094e-01, 4.9022648328829110e-01, 4.7949375766015301e-01, 4.6868882203582796e-01,
    4.5781330359887729e-01, 4.4686884016237433e-01, 4.3585707992225547e-01, 4.2477968120910881e-01,
    4.1363831223843456e-01, 4.0243465085941854e-01, 3.9117038430225398e-01, 3.7984720892405111e-01,
    3.6846682995337232e-01, 3.5703096123343003e-01, 3.4554132496398915e-01, 3.3399965144200949e-01,
    3.2240767880107002e-01, 3.1076715274961147e-01, 2.9907982630804048e-01, 2.8734745954472957e-01,
    2.7557181931095825e-01, 2.6375467897483151e-01, 2.5189781815421691e-01, 2.4000302244874150e-01,
    2.2807208317088579e-01, 2.1610679707621960e-01, 2.0410896609281701e-01, 1.9208039704989238e-01,
    1.8002290140569951e-01, 1.6793829497473123e-01, 1.5582839765426532e-01, 1.4369503315029458e-01,
    1.3154002870288328e-01, 1.1936521481099135e-01, 1.0717242495680887e-01, 9.4963495329639061e-02,
    8.2740264549375803e-02, 7.0504573389614009e-02, 5.8258264500435732e-02, 4.6003182130914644e-02,
    3.3741171851377642e-02, 2.1474080275469605e-02, 9.2037547820599599e-03, 0.0000000000000000e+00,
};

DECLFUNC const SCALAR *gaa_wsin_ldac[LDAC_NUMLNN];
static const SCALAR sa_wsin_1fs_ldac[LDAC_1FSLSU] = {
    7.0710678118654746e-01, 3.8268343236508978e-01, 9.2387953251128674e-01, 1.9509032201612825e-01,
    8.3146961230254524e-01, 9.8078528040323043e-01, 5.5557023301960218e-01, 9.8017140329560604e-02,
    4.7139673682599764e-01, 7.7301045336273699e-01, 9.5694033573220894e-01, 9.9518472667219693e-01,
    8.8192126434835505e-01, 6.3439328416364549e-01, 2.9028467725446239e-01, 4.9067674327418015e-02,
    2.4298017990326387e-01, 4.2755509343028208e-01, 5.9569930449243336e-01, 7.4095112535495911e-01,
    8.5772861000027212e-01, 9.4154406518302081e-01, 9.8917650996478101e-01, 9.9879545620517241e-01,
    9.7003125319454397e-01, 9.0398929312344345e-01, 8.0320753148064494e-01, 6.7155895484701855e-01,
    5.1410274419322177e-01, 3.3688985339222033e-01, 1.4673047445536180e-01, 2.4541228522912288e-02,
    1.2241067519921620e-01, 2.1910124015686980e-01, 3.1368174039889152e-01, 4.0524131400498986e-01,
    4.9289819222978404e-01, 5.7580819141784534e-01, 6.5317284295377676e-01, 7.2424708295146689e-01,
    7.8834642762660623e-01, 8.4485356524970701e-01, 8.9322430119551532e-01, 9.3299279883473885e-01,
    9.6377606579543984e-01, 9.8527764238894122e-01, 9.9729045667869021e-01, 9.9969881869620425e-01,
    9.9247953459870997e-01, 9.7570213003852857e-01, 9.4952818059303667e-01, 9.1420975570353069e-01,
    8.7008699110871146e-01, 8.1758481315158371e-01, 7.5720884650648468e-01, 6.8954054473706705e-01,
    6.1523159058062693e-01, 5.3499761988709715e-01, 4.4961132965460687e-01, 3.5989503653498833e-01,
    2.6671275747489848e-01, 1.7096188876030122e-01, 7.3564563599667732e-02, 6.1358846491544753e-03,
    3.0674803176636626e-02, 5.5195244349689934e-02, 7.9682437971430126e-02, 1.0412163387205459e-01,
    1.2849811079379317e-01, 1.5279718525844344e-01, 1.7700422041214875e-01, 2.0110463484209190e-01,
    2.2508391135979283e-01, 2.4892760574572015e-01, 2.7262135544994898e-01, 2.9615088824362379e-01,
    3.1950203081601569e-01, 3.4266071731199438e-01, 3.6561299780477385e-01, 3.8834504669882625e-01,
    4.1084317105790391e-01, 4.3309381885315196e-01, 4.5508358712634384e-01, 4.7679923006332209e-01,
    4.9822766697278187e-01, 5.1935599016558964e-01, 5.4017147272989285e-01, 5.6066157619733603e-01,
    5.8081395809576453e-01, 6.0061647938386897e-01, 6.2005721176328910e-01, 6.3912444486377573e-01,
    6.5780669329707864e-01, 6.7609270357531592e-01, 6.9397146088965400e-01, 7.1143219574521643e-01,
    7.2846439044822520e-01, 7.4505778544146595e-01, 7.6120238548426178e-01, 7.7688846567323244e-01,
    7.9210657730021239e-01, 8.0684755354379922e-01, 8.2110251499110465e-01, 8.3486287498638001e-01,
    8.4812034480329712e-01, 8.6086693863776731e-01, 8.7309497841829009e-01, 8.8479709843093779e-01,
    8.9596624975618511e-01, 9.0659570451491533e-01, 9.1667905992104270e-01, 9.2621024213831127e-01,
    9.3518350993894750e-01, 9.4359345816196039e-01, 9.5143502096900834e-01, 9.5870347489587160e-01,
    9.6539444169768940e-01, 9.7150389098625178e-01, 9.7702814265775439e-01, 9.8196386910955524e-01,
    9.8630809724459867e-01, 9.9005821026229712e-01, 9.9321194923479450e-01, 9.9576741446765982e-01,
    9.9772306664419164e-01, 9.9907772775264536e-01, 9.9983058179582340e-01, 0.0000000000000000e+00,
};
static const SCALAR sa_wsin_2fs_ldac[LDAC_2FSLSU] = {
    7.0710678118654746e-01, 3.8268343236508978e-01, 9.2387953251128674e-01, 1.9509032201612825e-01,
    8.3146961230254524e-01, 9.8078528040323043e-01, 5.5557023301960218e-01, 9.8017140329560604e-02,
    4.7139673682599764e-01, 7.7301045336273699e-01, 9.5694033573220894e-01, 9.9518472667219693e-01,
    8.8192126434835505e-01, 6.3439328416364549e-01, 2.9028467725446239e-01, 4.9067674327418015e-02,
    2.4298017990326387e-01, 4.2755509343028208e-01, 5.9569930449243336e-01, 7.4095112535495911e-01,
    8.5772861000027212e-01, 9.4154406518302081e-01, 9.8917650996478101e-01, 9.9879545620517241e-01,
    9.7003125319454397e-01, 9.0398929312344345e-01, 8.0320753148064494e-01, 6.7155895484701855e-01,
    5.1410274419322177e-01, 3.3688985339222033e-01, 1.4673047445536180e-01, 2.4541228522912288e-02,
    1.2241067519921620e-01, 2.1910124015686980e-01, 3.1368174039889152e-01, 4.0524131400498986e-01,
    4.9289819222978404e-01, 5.7580819141784534e-01, 6.5317284295377676e-01, 7.2424708295146689e-01,
    7.8834642762660623e-01, 8.4485356524970701e-01, 8.9322430119551532e-01, 9.3299279883473885e-01,
    9.6377606579543984e-01, 9.8527764238894122e-01, 9.9729045667869021e-01, 9.9969881869620425e-01,
    9.9247953459870997e-01, 9.7570213003852857e-01, 9.4952818059303667e-01, 9.1420975570353069e-01,
    8.7008699110871146e-01, 8.1758481315158371e-01, 7.5720884650648468e-01, 6.8954054473706705e-01,
    6.1523159058062693e-01, 5.3499761988709715e-01, 4.4961132965460687e-01, 3.5989503653498833e-01,
    2.6671275747489848e-01, 1.7096188876030122e-01, 7.3564563599667732e-02, 1.2271538285719925e-02,
    6.1320736302208578e-02, 1.1022220729388306e-01, 1.5885814333386145e-01, 2.0711137619221856e-01,
    2.5486565960451457e-01, 3.0200594931922808e-01, 3.4841868024943456e-01, 3.9399204006104810e-01,
    4.3861623853852766e-01, 4.8218377207912272e-01, 5.2458968267846895e-01, 5.6573181078361312e-01,
    6.0551104140432555e-01, 6.4383154288979139e-01, 6.8060099779545302e-01, 7.1573082528381859e-01,
    7.4913639452345926e-01, 7.8073722857209438e-01, 8.1045719825259477e-01, 8.3822470555483797e-01,
    8.6397285612158670e-01, 8.8763962040285393e-01, 9.0916798309052227e-01, 9.2850608047321548e-01,
    9.4560732538052128e-01, 9.6043051941556579e-01, 9.7293995220556007e-01, 9.8310548743121629e-01,
    9.9090263542778001e-01, 9.9631261218277800e-01, 9.9932238458834954e-01, 9.9992470183914450e-01,
    9.9811811290014918e-01, 9.9390697000235606e-01, 9.8730141815785843e-01, 9.7831737071962765e-01,
    9.6697647104485207e-01, 9.5330604035419386e-01, 9.3733901191257496e-01, 9.1911385169005777e-01,
    8.9867446569395393e-01, 8.7607009419540660e-01, 8.5135519310526520e-01, 8.2458930278502518e-01,
    7.9583690460888357e-01, 7.6516726562245907e-01, 7.3265427167241282e-01, 6.9837624940897292e-01,
    6.6241577759017201e-01, 6.2485948814238634e-01, 5.8579785745643898e-01, 5.4532498842204635e-01,
    5.0353838372571769e-01, 4.6053871095824023e-01, 4.1642956009763715e-01, 3.7131719395183771e-01,
    3.2531029216226326e-01, 2.7851968938505317e-01, 2.3105810828067133e-01, 1.8303988795514090e-01,
    1.3458070850712628e-01, 8.5797312344440158e-02, 3.6807222941358832e-02, 3.0679567629659761e-03,
    1.5339206284988100e-02, 2.7608145778965740e-02, 3.9872927587739811e-02, 5.2131704680283324e-02,
    6.4382630929857465e-02, 7.6623861392031492e-02, 8.8853552582524600e-02, 1.0106986275482782e-01,
    1.1327095217756435e-01, 1.2545498341154623e-01, 1.3762012158648604e-01, 1.4976453467732151e-01,
    1.6188639378011183e-01, 1.7398387338746382e-01, 1.8605515166344663e-01, 1.9809841071795356e-01,
    2.1011183688046961e-01, 2.2209362097320351e-01, 2.3404195858354343e-01, 2.4595505033579459e-01,
    2.5783110216215899e-01, 2.6966832557291509e-01, 2.8146493792575794e-01, 2.9321916269425863e-01,
    3.0492922973540237e-01, 3.1659337555616585e-01, 3.2820984357909250e-01, 3.3977688440682685e-01,
    3.5129275608556709e-01, 3.6275572436739723e-01, 3.7416406297145793e-01, 3.8551605384391885e-01,
    3.9680998741671031e-01, 4.0804416286497869e-01, 4.1921688836322391e-01, 4.3032648134008261e-01,
    4.4137126873171667e-01, 4.5234958723377089e-01, 4.6325978355186015e-01, 4.7410021465054997e-01,
    4.8486924800079106e-01, 4.9556526182577254e-01, 5.0618664534515523e-01, 5.1673179901764987e-01,
    5.2719913478190128e-01, 5.3758707629564539e-01, 5.4789405917310019e-01, 5.5811853122055610e-01,
    5.6825895267013149e-01, 5.7831379641165559e-01, 5.8828154822264522e-01, 5.9816070699634227e-01,
    6.0794978496777363e-01, 6.1764730793780387e-01, 6.2725181549514408e-01, 6.3676186123628420e-01,
    6.4617601298331628e-01, 6.5549285299961535e-01, 6.6471097820334479e-01, 6.7382900037875604e-01,
    6.8284554638524808e-01, 6.9175925836415775e-01, 7.0056879394324834e-01, 7.0927282643886558e-01,
    7.1787004505573171e-01, 7.2635915508434601e-01, 7.3473887809596339e-01, 7.4300795213512172e-01,
    7.5116513190968637e-01, 7.5920918897838796e-01, 7.6713891193582040e-01, 7.7495310659487382e-01,
    7.8265059616657573e-01, 7.9023022143731003e-01, 7.9769084094339104e-01, 8.0503133114296366e-01,
    8.1225058658520388e-01, 8.1934752007679690e-01, 8.2632106284566342e-01, 8.3317016470191319e-01,
    8.3989379419599941e-01, 8.4649093877405202e-01, 8.5296060493036363e-01, 8.5930181835700836e-01,
    8.6551362409056898e-01, 8.7159508665595109e-01, 8.7754529020726124e-01, 8.8336333866573158e-01,
    8.8904835585466457e-01, 8.9459948563138258e-01, 9.0001589201616028e-01, 9.0529675931811882e-01,
    9.1044129225806714e-01, 9.1544871608826783e-01, 9.2031827670911048e-01, 9.2504924078267758e-01,
    9.2964089584318133e-01, 9.3409255040425887e-01, 9.3840353406310806e-01, 9.4257319760144687e-01,
    9.4660091308328353e-01, 9.5048607394948170e-01, 9.5422809510910567e-01, 9.5782641302753291e-01,
    9.6128048581132064e-01, 9.6458979328981265e-01, 9.6775383709347551e-01, 9.7077214072895035e-01,
    9.7364424965081187e-01, 9.7636973133002114e-01, 9.7894817531906220e-01, 9.8137919331375456e-01,
    9.8366241921173025e-01, 9.8579750916756737e-01, 9.8778414164457218e-01, 9.8962201746320078e-01,
    9.9131085984611544e-01, 9.9285041445986510e-01, 9.9424044945318790e-01, 9.9548075549192694e-01,
    9.9657114579055484e-01, 9.9751145614030345e-01, 9.9830154493389289e-01, 9.9894129318685687e-01,
    9.9943060455546173e-01, 9.9976940535121528e-01, 9.9995764455196390e-01, 0.0000000000000000e+00,
};

DECLFUNC const int *gaa_perm_ldac[LDAC_NUMLNN];
static const int sa_perm_1fs_ldac[LDAC_1FSLSU] = {
      0,  64,  96,  32,  48, 112,  80,  16,  24,  88, 120,  56,  40, 104,  72,   8,
     12,  76, 108,  44,  60, 124,  92,  28,  20,  84, 116,  52,  36, 100,  68,   4,
      6,  70, 102,  38,  54, 118,  86,  22,  30,  94, 126,  62,  46, 110,  78,  14,
     10,  74, 106,  42,  58, 122,  90,  26,  18,  82, 114,  50,  34,  98,  66,   2,
      3,  67,  99,  35,  51, 115,  83,  19,  27,  91, 123,  59,  43, 107,  75,  11,
     15,  79, 111,  47,  63, 127,  95,  31,  23,  87, 119,  55,  39, 103,  71,   7,
      5,  69, 101,  37,  53, 117,  85,  21,  29,  93, 125,  61,  45, 109,  77,  13,
      9,  73, 105,  41,  57, 121,  89,  25,  17,  81, 113,  49,  33,  97,  65,   1,
};
static const int sa_perm_2fs_ldac[LDAC_2FSLSU] = {
      0, 128, 192,  64,  96, 224, 160,  32,  48, 176, 240, 112,  80, 208, 144,  16,
     24, 152, 216,  88, 120, 248, 184,  56,  40, 168, 232, 104,  72, 200, 136,   8,
     12, 140, 204,  76, 108, 236, 172,  44,  60, 188, 252, 124,  92, 220, 156,  28,
     20, 148, 212,  84, 116, 244, 180,  52,  36, 164, 228, 100,  68, 196, 132,   4,
      6, 134, 198,  70, 102, 230, 166,  38,  54, 182, 246, 118,  86, 214, 150,  22,
     30, 158, 222,  94, 126, 254, 190,  62,  46, 174, 238, 110,  78, 206, 142,  14,
     10, 138, 202,  74, 106, 234, 170,  42,  58, 186, 250, 122,  90, 218, 154,  26,
     18, 146, 210,  82, 114, 242, 178,  50,  34, 162, 226,  98,  66, 194, 130,   2,
      3, 131, 195,  67,  99, 227, 163,  35,  51, 179, 243, 115,  83, 211, 147,  19,
     27, 155, 219,  91, 123, 251, 187,  59,  43, 171, 235, 107,  75, 203, 139,  11,
     15, 143, 207,  79, 111, 239, 175,  47,  63, 191, 255, 127,  95, 223, 159,  31,
     23, 151, 215,  87, 119, 247, 183,  55,  39, 167, 231, 103,  71, 199, 135,   7,
      5, 133, 197,  69, 101, 229, 165,  37,  53, 181, 245, 117,  85, 213, 149,  21,
     29, 157, 221,  93, 125, 253, 189,  61,  45, 173, 237, 109,  77, 205, 141,  13,
      9, 137, 201,  73, 105, 233, 169,  41,  57, 185, 249, 121,  89, 217, 153,  25,
     17, 145, 209,  81, 113, 241, 177,  49,  33, 161, 225,  97,  65, 193, 129,   1,
};


/***************************************************************************************************
    Normalization Tables
***************************************************************************************************/

/* Inverse of Scale Factor for Spectrum Normalization */
DECLFUNC const SCALAR ga_isf_ldac[LDAC_NIDSF] = {
    3.2768000000000000e+04, 1.6384000000000000e+04, 8.1920000000000000e+03, 4.0960000000000000e+03,
    2.0480000000000000e+03, 1.0240000000000000e+03, 5.1200000000000000e+02, 2.5600000000000000e+02,
    1.2800000000000000e+02, 6.4000000000000000e+01, 3.2000000000000000e+01, 1.6000000000000000e+01,
    8.0000000000000000e+00, 4.0000000000000000e+00, 2.0000000000000000e+00, 1.0000000000000000e+00,
    5.0000000000000000e-01, 2.5000000000000000e-01, 1.2500000000000000e-01, 6.2500000000000000e-02,
    3.1250000000000000e-02, 1.5625000000000000e-02, 7.8125000000000000e-03, 3.9062500000000000e-03,
    1.9531250000000000e-03, 9.7656250000000000e-04, 4.8828125000000000e-04, 2.4414062500000000e-04,
    1.2207031250000000e-04, 6.1035156250000000e-05, 3.0517578125000000e-05, 1.5258789062500000e-05,
};

/***************************************************************************************************
    Quantization Tables
***************************************************************************************************/
/* Quantize Factor for Spectrum/Residual Quantization */
DECLFUNC const SCALAR ga_qf_ldac[LDAC_NIDWL] = {
    5.0000000000000000e-01, 1.5000000000000000e+00, 3.5000000000000000e+00, 7.5000000000000000e+00,
    1.5500000000000000e+01, 3.1500000000000000e+01, 6.3500000000000000e+01, 1.2750000000000000e+02,
    2.5550000000000000e+02, 5.1150000000000000e+02, 1.0235000000000000e+03, 2.0475000000000000e+03,
    4.0955000000000000e+03, 8.1915000000000000e+03, 1.6383500000000000e+04, 3.2767500000000000e+04,
};

/* Inverse of Quantize Factor for Spectrum/Residual Quantization */
DECLFUNC const SCALAR ga_iqf_ldac[LDAC_NIDWL] = {
    2.0000000000000000e+00, 6.6666666666666663e-01, 2.8571428571428570e-01, 1.3333333333333333e-01,
    6.4516129032258063e-02, 3.1746031746031744e-02, 1.5748031496062992e-02, 7.8431372549019607e-03,
    3.9138943248532287e-03, 1.9550342130987292e-03, 9.7703957010258913e-04, 4.8840048840048840e-04,
    2.4417043096081065e-04, 1.2207776353537203e-04, 6.1037018951994385e-05, 3.0518043793392844e-05,
};

/* Inverse of Scale Factor for Residual Normalization */
DECLFUNC const SCALAR ga_irsf_ldac[LDAC_NIDWL] = {
    1.0000000000000000e+00, 3.0000000000000000e+00, 7.0000000000000000e+00, 1.5000000000000000e+01,
    3.1000000000000000e+01, 6.3000000000000000e+01, 1.2700000000000000e+02, 2.5500000000000000e+02,
    5.1100000000000000e+02, 1.0230000000000000e+03, 2.0470000000000000e+03, 4.0950000000000000e+03,
    8.1910000000000000e+03, 1.6383000000000000e+04, 3.2767000000000000e+04, 6.5535000000000000e+04,
};



/***************************************************************************************************
    Set MDCT Tables
***************************************************************************************************/
DECLFUNC void set_mdct_table_ldac(
int nlnn)
{
    int index = nlnn - LDAC_1FSLNN;

    if (nlnn == LDAC_1FSLNN) {
        gaa_fwin_ldac[index] = sa_fwin_1fs_ldac;
        gaa_wcos_ldac[index] = sa_wcos_1fs_ldac;
        gaa_wsin_ldac[index] = sa_wsin_1fs_ldac;
        gaa_perm_ldac[index] = sa_perm_1fs_ldac;
    }
    else if (nlnn == LDAC_2FSLNN) {
        gaa_fwin_ldac[index] = sa_fwin_2fs_ldac;
        gaa_wcos_ldac[index] = sa_wcos_2fs_ldac;
        gaa_wsin_ldac[index] = sa_wsin_2fs_ldac;
        gaa_perm_ldac[index] = sa_perm_2fs_ldac;
    }

    return;
}


