/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.table.TableContainsHeaderAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableDisplayFilterButtonsAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableHasPersistentDataAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableIsSelectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableOnUpdateKeepSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableOnUpdateKeepStylesAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableOrientationAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableRefreshDelayAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableTargetRangeAddressAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element table:database-range}.
 *
 */
public class TableDatabaseRangeElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "database-range");

	/**
	 * Create the instance of <code>TableDatabaseRangeElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableDatabaseRangeElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:database-range}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableContainsHeaderAttribute</code> , See {@odf.attribute table:contains-header}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableContainsHeaderAttribute() {
		TableContainsHeaderAttribute attr = (TableContainsHeaderAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "contains-header");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableContainsHeaderAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableContainsHeaderAttribute</code> , See {@odf.attribute table:contains-header}
	 *
	 * @param tableContainsHeaderValue   The type is <code>Boolean</code>
	 */
	public void setTableContainsHeaderAttribute(Boolean tableContainsHeaderValue) {
		TableContainsHeaderAttribute attr = new TableContainsHeaderAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableContainsHeaderValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableDisplayFilterButtonsAttribute</code> , See {@odf.attribute table:display-filter-buttons}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableDisplayFilterButtonsAttribute() {
		TableDisplayFilterButtonsAttribute attr = (TableDisplayFilterButtonsAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "display-filter-buttons");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableDisplayFilterButtonsAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableDisplayFilterButtonsAttribute</code> , See {@odf.attribute table:display-filter-buttons}
	 *
	 * @param tableDisplayFilterButtonsValue   The type is <code>Boolean</code>
	 */
	public void setTableDisplayFilterButtonsAttribute(Boolean tableDisplayFilterButtonsValue) {
		TableDisplayFilterButtonsAttribute attr = new TableDisplayFilterButtonsAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableDisplayFilterButtonsValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableHasPersistentDataAttribute</code> , See {@odf.attribute table:has-persistent-data}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableHasPersistentDataAttribute() {
		TableHasPersistentDataAttribute attr = (TableHasPersistentDataAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "has-persistent-data");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableHasPersistentDataAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableHasPersistentDataAttribute</code> , See {@odf.attribute table:has-persistent-data}
	 *
	 * @param tableHasPersistentDataValue   The type is <code>Boolean</code>
	 */
	public void setTableHasPersistentDataAttribute(Boolean tableHasPersistentDataValue) {
		TableHasPersistentDataAttribute attr = new TableHasPersistentDataAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableHasPersistentDataValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableIsSelectionAttribute</code> , See {@odf.attribute table:is-selection}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableIsSelectionAttribute() {
		TableIsSelectionAttribute attr = (TableIsSelectionAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "is-selection");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableIsSelectionAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableIsSelectionAttribute</code> , See {@odf.attribute table:is-selection}
	 *
	 * @param tableIsSelectionValue   The type is <code>Boolean</code>
	 */
	public void setTableIsSelectionAttribute(Boolean tableIsSelectionValue) {
		TableIsSelectionAttribute attr = new TableIsSelectionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableIsSelectionValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNameAttribute</code> , See {@odf.attribute table:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableNameAttribute() {
		TableNameAttribute attr = (TableNameAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNameAttribute</code> , See {@odf.attribute table:name}
	 *
	 * @param tableNameValue   The type is <code>String</code>
	 */
	public void setTableNameAttribute(String tableNameValue) {
		TableNameAttribute attr = new TableNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableOnUpdateKeepSizeAttribute</code> , See {@odf.attribute table:on-update-keep-size}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableOnUpdateKeepSizeAttribute() {
		TableOnUpdateKeepSizeAttribute attr = (TableOnUpdateKeepSizeAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "on-update-keep-size");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableOnUpdateKeepSizeAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableOnUpdateKeepSizeAttribute</code> , See {@odf.attribute table:on-update-keep-size}
	 *
	 * @param tableOnUpdateKeepSizeValue   The type is <code>Boolean</code>
	 */
	public void setTableOnUpdateKeepSizeAttribute(Boolean tableOnUpdateKeepSizeValue) {
		TableOnUpdateKeepSizeAttribute attr = new TableOnUpdateKeepSizeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableOnUpdateKeepSizeValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableOnUpdateKeepStylesAttribute</code> , See {@odf.attribute table:on-update-keep-styles}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableOnUpdateKeepStylesAttribute() {
		TableOnUpdateKeepStylesAttribute attr = (TableOnUpdateKeepStylesAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "on-update-keep-styles");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableOnUpdateKeepStylesAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableOnUpdateKeepStylesAttribute</code> , See {@odf.attribute table:on-update-keep-styles}
	 *
	 * @param tableOnUpdateKeepStylesValue   The type is <code>Boolean</code>
	 */
	public void setTableOnUpdateKeepStylesAttribute(Boolean tableOnUpdateKeepStylesValue) {
		TableOnUpdateKeepStylesAttribute attr = new TableOnUpdateKeepStylesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableOnUpdateKeepStylesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableOrientationAttribute</code> , See {@odf.attribute table:orientation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableOrientationAttribute() {
		TableOrientationAttribute attr = (TableOrientationAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "orientation");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return TableOrientationAttribute.DEFAULT_VALUE;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableOrientationAttribute</code> , See {@odf.attribute table:orientation}
	 *
	 * @param tableOrientationValue   The type is <code>String</code>
	 */
	public void setTableOrientationAttribute(String tableOrientationValue) {
		TableOrientationAttribute attr = new TableOrientationAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableOrientationValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableRefreshDelayAttribute</code> , See {@odf.attribute table:refresh-delay}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableRefreshDelayAttribute() {
		TableRefreshDelayAttribute attr = (TableRefreshDelayAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "refresh-delay");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableRefreshDelayAttribute</code> , See {@odf.attribute table:refresh-delay}
	 *
	 * @param tableRefreshDelayValue   The type is <code>String</code>
	 */
	public void setTableRefreshDelayAttribute(String tableRefreshDelayValue) {
		TableRefreshDelayAttribute attr = new TableRefreshDelayAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableRefreshDelayValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableTargetRangeAddressAttribute</code> , See {@odf.attribute table:target-range-address}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableTargetRangeAddressAttribute() {
		TableTargetRangeAddressAttribute attr = (TableTargetRangeAddressAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "target-range-address");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableTargetRangeAddressAttribute</code> , See {@odf.attribute table:target-range-address}
	 *
	 * @param tableTargetRangeAddressValue   The type is <code>String</code>
	 */
	public void setTableTargetRangeAddressAttribute(String tableTargetRangeAddressValue) {
		TableTargetRangeAddressAttribute attr = new TableTargetRangeAddressAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableTargetRangeAddressValue);
	}

	/**
	 * Create child element {@odf.element table:database-source-query}.
	 *
	 * @param tableDatabaseNameValue  the <code>String</code> value of <code>TableDatabaseNameAttribute</code>, see {@odf.attribute  table:database-name} at specification
	 * @param tableQueryNameValue  the <code>String</code> value of <code>TableQueryNameAttribute</code>, see {@odf.attribute  table:query-name} at specification
	 * @return the element {@odf.element table:database-source-query}
	 */
	 public TableDatabaseSourceQueryElement newTableDatabaseSourceQueryElement(String tableDatabaseNameValue, String tableQueryNameValue) {
		TableDatabaseSourceQueryElement tableDatabaseSourceQuery = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDatabaseSourceQueryElement.class);
		tableDatabaseSourceQuery.setTableDatabaseNameAttribute(tableDatabaseNameValue);
		tableDatabaseSourceQuery.setTableQueryNameAttribute(tableQueryNameValue);
		this.appendChild(tableDatabaseSourceQuery);
		return tableDatabaseSourceQuery;
	}

	/**
	 * Create child element {@odf.element table:database-source-sql}.
	 *
	 * @param tableDatabaseNameValue  the <code>String</code> value of <code>TableDatabaseNameAttribute</code>, see {@odf.attribute  table:database-name} at specification
	 * @param tableSqlStatementValue  the <code>String</code> value of <code>TableSqlStatementAttribute</code>, see {@odf.attribute  table:sql-statement} at specification
	 * @return the element {@odf.element table:database-source-sql}
	 */
	 public TableDatabaseSourceSqlElement newTableDatabaseSourceSqlElement(String tableDatabaseNameValue, String tableSqlStatementValue) {
		TableDatabaseSourceSqlElement tableDatabaseSourceSql = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDatabaseSourceSqlElement.class);
		tableDatabaseSourceSql.setTableDatabaseNameAttribute(tableDatabaseNameValue);
		tableDatabaseSourceSql.setTableSqlStatementAttribute(tableSqlStatementValue);
		this.appendChild(tableDatabaseSourceSql);
		return tableDatabaseSourceSql;
	}

	/**
	 * Create child element {@odf.element table:database-source-table}.
	 *
	 * @param tableDatabaseNameValue  the <code>String</code> value of <code>TableDatabaseNameAttribute</code>, see {@odf.attribute  table:database-name} at specification
	 * @param tableDatabaseTableNameValue  the <code>String</code> value of <code>TableDatabaseTableNameAttribute</code>, see {@odf.attribute  table:database-table-name} at specification
	 * @return the element {@odf.element table:database-source-table}
	 */
	 public TableDatabaseSourceTableElement newTableDatabaseSourceTableElement(String tableDatabaseNameValue, String tableDatabaseTableNameValue) {
		TableDatabaseSourceTableElement tableDatabaseSourceTable = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDatabaseSourceTableElement.class);
		tableDatabaseSourceTable.setTableDatabaseNameAttribute(tableDatabaseNameValue);
		tableDatabaseSourceTable.setTableDatabaseTableNameAttribute(tableDatabaseTableNameValue);
		this.appendChild(tableDatabaseSourceTable);
		return tableDatabaseSourceTable;
	}

	/**
	 * Create child element {@odf.element table:filter}.
	 *
	 * @return the element {@odf.element table:filter}
	 */
	public TableFilterElement newTableFilterElement() {
		TableFilterElement tableFilter = ((OdfFileDom) this.ownerDocument).newOdfElement(TableFilterElement.class);
		this.appendChild(tableFilter);
		return tableFilter;
	}

	/**
	 * Create child element {@odf.element table:sort}.
	 *
	 * @return the element {@odf.element table:sort}
	 */
	public TableSortElement newTableSortElement() {
		TableSortElement tableSort = ((OdfFileDom) this.ownerDocument).newOdfElement(TableSortElement.class);
		this.appendChild(tableSort);
		return tableSort;
	}

	/**
	 * Create child element {@odf.element table:subtotal-rules}.
	 *
	 * @return the element {@odf.element table:subtotal-rules}
	 */
	public TableSubtotalRulesElement newTableSubtotalRulesElement() {
		TableSubtotalRulesElement tableSubtotalRules = ((OdfFileDom) this.ownerDocument).newOdfElement(TableSubtotalRulesElement.class);
		this.appendChild(tableSubtotalRules);
		return tableSubtotalRules;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
