#include "osl/stat/twoDimensionalStatistics.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class TwoDimensionalStatisticsTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(TwoDimensionalStatisticsTest);
  CPPUNIT_TEST(testCorrelation);
  CPPUNIT_TEST(testFitting);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testCorrelation();
  void testFitting();
};

using namespace osl;
using namespace osl::stat;

CPPUNIT_TEST_SUITE_REGISTRATION(TwoDimensionalStatisticsTest);

void TwoDimensionalStatisticsTest::testCorrelation()
{
    TwoDimensionalStatistics t;
    t.add(0,0);
    t.add(1,1);
    CPPUNIT_ASSERT_EQUAL(1.0, t.correlation());
    t.add(1,2);
    CPPUNIT_ASSERT(t.correlation() < 1.0);
    CPPUNIT_ASSERT(0.0 < t.correlation());
}

void TwoDimensionalStatisticsTest::testFitting()
{
    {
	TwoDimensionalStatistics t;
	t.add(0,0);
	t.add(1,1);
	double a, b, res;
	t.fitting(a, b, res);
	CPPUNIT_ASSERT_EQUAL(1.0, a);
	CPPUNIT_ASSERT_EQUAL(0.0, b);
	CPPUNIT_ASSERT_EQUAL(0.0, res);
    }
    {
	TwoDimensionalStatistics t;
	t.add(0,0);
	t.add(1,-1);
	double a, b, res;
	t.fitting(a, b, res);
	CPPUNIT_ASSERT_EQUAL(-1.0, a);
	CPPUNIT_ASSERT_EQUAL(0.0, b);
	CPPUNIT_ASSERT_EQUAL(0.0, res);
    }

    {
	TwoDimensionalStatistics t;
	t.add(0,1);
	t.add(1,2);
	double a, b, res;
	t.fitting(a, b, res);
	CPPUNIT_ASSERT_EQUAL(1.0, a);
	CPPUNIT_ASSERT_EQUAL(1.0, b);
	CPPUNIT_ASSERT_EQUAL(0.0, res);
    }
    {
	TwoDimensionalStatistics t;
	t.add(0,1);
	t.add(1,0);
	double a, b, res;
	t.fitting(a, b, res);
	CPPUNIT_ASSERT_EQUAL(-1.0, a);
	CPPUNIT_ASSERT_EQUAL(1.0, b);
	CPPUNIT_ASSERT_EQUAL(0.0, res);
    }

    {
	TwoDimensionalStatistics t;
	t.add(0,0);
	t.add(1,1);
	t.add(1,-1);
	double a, b, res;
	t.fitting(a, b, res);
	CPPUNIT_ASSERT_EQUAL(0.0, a);
	CPPUNIT_ASSERT_EQUAL(0.0, b);
	CPPUNIT_ASSERT(res > 0.0);
    }
}
