#!/bin/sh

# Copyright (C) 2002  Andres Salomon <dilinger@voxel.net>
#
# Create a chroot environment for allowing users to rsync.
# This script is placed in the public domain.  Do with it what
# you will.

PATH="/usr/local/sbin:/usr/sbin:/sbin:/usr/local/bin:/bin:/usr/bin"
DIRECTORIES="bin dev lib usr/bin usr/lib"
FILES="bin/false lib/libc.so.6 lib/ld-linux.so.2
		bin/bash lib/libncurses.so.5 lib/libdl.so.2
		usr/bin/rsync lib/libpopt.so.0 lib/libresolv.so.2"

if test -z "$1"; then
	echo "Usage: $0 <directory>" 1>&2
	exit 1
fi

id=`id -u`
if test "$id" -gt 0; then
	echo "Error: this script requires root (for mknod)!" 1>&2
	exit 1
fi

dir=$1
curdir=`pwd`

# Create directory structure
mkdir -p $dir
cd $dir
for d in $DIRECTORIES; do
	mkdir -p $d
done

# Add files
for f in $FILES; do
	cp /$f $f
done

# And devices..
if test -d dev; then
	cp /dev/MAKEDEV dev
	cd dev && ./MAKEDEV std && rm -f MAKEDEV
fi


cd $curdir

exit 0
