/*
 * pam_sshauth: PAM module for authentication via a remote ssh server.
 * Copyright (C) 2010 Scott Balneaves <sbalneav@ltsp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define HOST              "PAM_SSHAUTH_HOST"
#define PORT              "PAM_SSHAUTH_PORT"
#define SSHAUTHDIR        "PAM_SSHAUTH_DIR"
#define PAMXDISPLAY       "PAM_XDISPLAY"
#define NOCLEANUP         0
#define CLEANUP           1
#define UID_MIN           500

#define SSH_AUTH_METHOD_PASSWORD    1
#define SSH_AUTH_METHOD_INTERACTIVE 2
#define SSH_AUTH_METHOD_PUBLICKEY   4

#define SSH_AUTH_SUCCESS 0
#define SSH_AUTH_ERROR   1

#define SYSTEM_KNOWNHOSTS "/etc/ssh/ssh_known_hosts"
#define AUTHTRIES         3     /* Three chances to get password right */

/*
 * Globals.
 */

extern int psadebug;            /* Debug flag */
extern int nostrict;            /* nostrict flag */
extern int authtries;           /* Number of times we'll try to authenticate */
extern int try_first_pass;      /* Try to obtain auth token from pam stack */
extern int askpass;             /* Support shm_askpass */

/*
 * Prototypes
 */

void cleanup (pam_handle_t * pamh, void * data, int error_status);
void pam_debug (pam_handle_t * pamh, const char *format, ...);
int send_pam_msg (pam_handle_t * pamh, int style, const char *format, ...);
void pam_process_args (pam_handle_t * pamh, int argc, const char **argv, char **host, char **port);
int sshauth_pam_env (pam_handle_t * pamh, char *envname, char *envvalue, int cleanup);
int do_sshauth (pam_handle_t * pamh, const char *username);
int create_sshauthdir (pam_handle_t * pamh, const char *username);
int askpass_create (pam_handle_t * pamh);
int askpass_remove (pam_handle_t * pamh);
