/*
 *	Copyright 2020 Cray Inc. All Rights Reserved.
 */

/*
 *	Fujitsu A64FX processor
 *
 *	A64FX® PMU Events
 *	Fujitsu Limited
 *	1.2, 28 April 2020
 */

static const arm_entry_t arm_a64fx_pe[ ] = {
	{
		.name = "SW_INCR",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0000,
		.desc = "This event counts on writes to the PMSWINC register.",
	},
	{
		.name = "L1I_CACHE_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0001,
		.desc = "This event counts operations that cause a refill of at least the L1I cache.",
	},
	{
		.name = "L1I_TLB_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0002,
		.desc = "This event counts operations that cause a TLB refill of at least the L1I TLB.",
	},
	{
		.name = "L1D_CACHE_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0003,
		.desc = "This event counts operations that cause a refill of at least the L1D cache.",
	},
	{
		.name = "L1D_CACHE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0004,
		.desc = "This event counts operations that cause a cache access to at least the L1D cache.",
	},
	{
		.name = "L1D_TLB_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0005,
		.desc = "This event counts operations that cause a TLB refill of at least the L1D TLB.",
	},
	{
		.name = "INST_RETIRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0008,
		.desc = "This event counts every architecturally executed instruction.",
	},
	{
		.name = "EXC_TAKEN",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0009,
		.desc = "This event counts each exception taken.",
	},
	{
		.name = "EXC_RETURN",
		.modmsk = ARMV8_ATTRS,
		.code = 0x000a,
		.desc = "This event counts each executed exception return instruction.",
	},
	{
		.name = "CID_WRITE_RETIRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x000b,
		.desc = "This event counts every write to CONTEXTIDR.",
	},
	{
		.name = "BR_MIS_PRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0010,
		.desc = "This event counts each correction to the predicted program flow that occurs because of a misprediction from, or no prediction from, the branch prediction resources and that relates to instructions that the branch prediction resources are capable of predicting.",
	},
	{
		.name = "CPU_CYCLES",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0011,
		.desc = "This event counts every cycle.",
	},
	{
		.name = "BR_PRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0012,
		.desc = "This event counts every branch or other change in the program flow that the branch prediction resources are capable of predicting.",
	},
	{
		.name = "L1I_CACHE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0014,
		.desc = "This event counts operations that cause a cache access to at least the L1I cache.",
	},
	{
		.name = "L1D_CACHE_WB",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0015,
		.desc = "This event counts every write-back of data from the L1D cache.",
	},
	{
		.name = "L2D_CACHE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0016,
		.desc = "This event counts operations that cause a cache access to at least the L2 cache.",
	},
	{
		.name = "L2D_CACHE_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0017,
		.desc = "This event counts operations that cause a refill of at least the L2 cache.",
	},
	{
		.name = "L2D_CACHE_WB",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0018,
		.desc = "This event counts every write-back of data from the L2 cache.",
	},
	{
		.name = "INST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x001b,
		.desc = "This event counts every architecturally executed instruction.",
	},
	{
		.name = "STALL_FRONTEND",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0023,
		.desc = "This event counts every cycle counted by the CPU_CYCLES event on that no operations are issued because there are no operations available to issue for this PE from the frontend.",
	},
	{
		.name = "STALL_BACKEND",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0024,
		.desc = "This event counts every cycle counted by the CPU_CYCLES event on that no operations are issued because the backend is unable to accept any operations.",
	},
	{
		.name = "L2D_TLB_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x002d,
		.desc = "This event counts operations that cause a TLB refill of at least the L2D TLB.",
	},
	{
		.name = "L2I_TLB_REFILL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x002e,
		.desc = "This event counts operations that cause a TLB refill of at least the L2I TLB.",
	},
	{
		.name = "L2D_TLB",
		.modmsk = ARMV8_ATTRS,
		.code = 0x002f,
		.desc = "This event counts operations that cause a TLB access to at least the L2D TLB.",
	},
	{
		.name = "L2I_TLB",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0030,
		.desc = "This event counts operations that cause a TLB access to at least the L2I TLB.",
	},
	{
		.name = "L1D_CACHE_REFILL_PRF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0049,
		.desc = "This event counts L1D_CACHE_REFILL caused by software or hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_PRF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0059,
		.desc = "This event counts L2D_CACHE_REFILL caused by software or hardware prefetch.",
	},
	{
		.name = "LDREX_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x006c,
		.desc = "This event counts architecturally executed load-exclusive instructions.",
	},
	{
		.name = "STREX_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x006f,
		.desc = "This event counts architecturally executed store-exclusive instructions.",
	},
	{
		.name = "LD_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0070,
		.desc = "This event counts architecturally executed memory-reading instructions, as defined by the LD_RETIRED event.",
	},
	{
		.name = "ST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0071,
		.desc = "This event counts architecturally executed memory-writing instructions, as defined by the ST_RETIRED event. This event counts DCZVA as a store operation.",
	},
	{
		.name = "LDST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0072,
		.desc = "This event counts architecturally executed memory-reading instructions and memory-writing instructions, as defined by the LD_RETIRED and ST_RETIRED events.",
	},
	{
		.name = "DP_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0073,
		.desc = "This event counts architecturally executed integer data-processing instructions.",
	},
	{
		.name = "ASE_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0074,
		.desc = "This event counts architecturally executed Advanced SIMD data-processing instructions.",
	},
	{
		.name = "VFP_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0075,
		.desc = "This event counts architecturally executed floating-point data-processing instructions.",
	},
	{
		.name = "PC_WRITE_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0076,
		.desc = "This event counts only software changes of the PC that defined by the instruction architecturally executed, condition code check pass and software change of the PC event.",
	},
	{
		.name = "CRYPTO_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0077,
		.desc = "This event counts architecturally executed cryptographic instructions, except PMULL and VMULL.",
	},
	{
		.name = "BR_IMMED_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0078,
		.desc = "This event counts architecturally executed immediate branch instructions.",
	},
	{
		.name = "BR_RETURN_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0079,
		.desc = "This event counts architecturally executed procedure return operations that defined by the BR_RETURN_RETIRED event.",
	},
	{
		.name = "BR_INDIRECT_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x007a,
		.desc = "This event counts architecturally executed indirect branch instructions that includes software change of the PC other than exception-generating instructions and immediate branch instructions.",
	},
	{
		.name = "ISB_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x007c,
		.desc = "This event counts architecturally executed Instruction Synchronization Barrier instructions.",
	},
	{
		.name = "DSB_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x007d,
		.desc = "This event counts architecturally executed Data Synchronization Barrier instructions.",
	},
	{
		.name = "DMB_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x007e,
		.desc = "This event counts architecturally executed Data Memory Barrier instructions, excluding the implied barrier operations of load/store operations with release consistency semantics.",
	},
	{
		.name = "EXC_UNDEF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0081,
		.desc = "This event counts only other synchronous exceptions that are taken locally.",
	},
	{
		.name = "EXC_SVC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0082,
		.desc = "This event counts only Supervisor Call exceptions that are taken locally.",
	},
	{
		.name = "EXC_PABORT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0083,
		.desc = "This event counts only Instruction Abort exceptions that are taken locally.",
	},
	{
		.name = "EXC_DABORT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0084,
		.desc = "This event counts only Data Abort or SError interrupt exceptions that are taken locally.",
	},
	{
		.name = "EXC_IRQ",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0086,
		.desc = "This event counts only IRQ exceptions that are taken locally, including Virtual IRQ exceptions.",
	},
	{
		.name = "EXC_FIQ",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0087,
		.desc = "This event counts only FIQ exceptions that are taken locally, including Virtual FIQ exceptions.",
	},
	{
		.name = "EXC_SMC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0088,
		.desc = "This event counts only Secure Monitor Call exceptions. The counter does not increment on SMC instructions trapped as a Hyp Trap exception.",
	},
	{
		.name = "EXC_HVC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x008a,
		.desc = "This event counts for both Hypervisor Call exceptions taken locally in the hypervisor and those taken as an exception from Non-secure EL1.",
	},
	{
		.name = "DCZVA_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x009f,
		.desc = "This event counts architecturally executed zero blocking operations due to the 'DC ZVA' instruction.",
	},
	{
		.name = "FP_MV_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0105,
		.desc = "This event counts architecturally executed floating-point move operations.",
	},
	{
		.name = "PRD_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0108,
		.desc = "This event counts architecturally executed operations that using predicate register.",
	},
	{
		.name = "IEL_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0109,
		.desc = "This event counts architecturally executed inter-element manipulation operations.",
	},
	{
		.name = "IREG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x010a,
		.desc = "This event counts architecturally executed inter-register manipulation operations.",
	},
	{
		.name = "FP_LD_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0112,
		.desc = "This event counts architecturally executed NOSIMD load operations that using SIMD and FP registers.",
	},
	{
		.name = "FP_ST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0113,
		.desc = "This event counts architecturally executed NOSIMD store operations that using SIMD and FP registers.",
	},
	{
		.name = "BC_LD_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x011a,
		.desc = "This event counts architecturally executed SIMD broadcast floating-point load operations.",
	},
	{
		.name = "EFFECTIVE_INST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0121,
		.desc = "This event counts architecturally executed instructions, excluding the MOVPRFX instruction.",
	},
	{
		.name = "PRE_INDEX_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0123,
		.desc = "This event counts architecturally executed operations that uses 'pre-index' as its addressing mode.",
	},
	{
		.name = "POST_INDEX_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0124,
		.desc = "This event counts architecturally executed operations that uses 'post-index' as its addressing mode.",
	},
	{
		.name = "UOP_SPLIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0139,
		.desc = "This event counts the occurrence count of the micro-operation split.",
	},
	{
		.name = "LD_COMP_WAIT_L2_MISS",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0180,
		.desc = "This event counts every cycle that no operation was committed because the oldest and uncommitted load/store operation waits for memory access.",
	},
	{
		.name = "LD_COMP_WAIT_L2_MISS_EX",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0181,
		.desc = "This event counts every cycle that no instructions are committed because the oldest and uncommitted integer load instruction waits for memory access.",
	},
	{
		.name = "LD_COMP_WAIT_L1_MISS",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0182,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted load/store operation waits for L2 cache access.",
	},
	{
		.name = "LD_COMP_WAIT_L1_MISS_EX",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0183,
		.desc = "This event counts every cycle that no instructions are committed because the oldest and uncommitted integer load instruction waits for L2 cache access.",
	},
	{
		.name = "LD_COMP_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0184,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted load/store operation waits for L1D, L2 and memory access.",
	},
	{
		.name = "LD_COMP_WAIT_EX",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0185,
		.desc = "This event counts every cycle that no instructions are committed because the oldest and uncommitted integer load instruction waits for L1D, L2 and memory access.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0186,
		.desc = "This event counts every cycle that no instructions are committed due to the lack of an available prefetch port.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY_EX",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0187,
		.desc = "This event counts the LD_COMP_WAIT_PFP_BUSY caused by an integer load operation.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY_SWPF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0188,
		.desc = "This event counts the LD_COMP_WAIT_PFP_BUSY caused by a software prefetch instruction.",
	},
	{
		.name = "EU_COMP_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0189,
		.desc = "This event counts every cycle that no instructions are committed, and the oldest and uncommitted instruction is an integer or floating-point instruction.",
	},
	{
		.name = "FL_COMP_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x018a,
		.desc = "This event counts every cycle that no instructions are committed, and the oldest and uncommitted instruction is a floating-point instruction.",
	},
	{
		.name = "BR_COMP_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x018b,
		.desc = "This event counts every cycle that no instructions are committed, and the oldest and uncommitted instruction is a branch instruction.",
	},
	{
		.name = "ROB_EMPTY",
		.modmsk = ARMV8_ATTRS,
		.code = 0x018c,
		.desc = "This event counts every cycle that no instructions are committed because the CSE is empty.",
	},
	{
		.name = "ROB_EMPTY_STQ_BUSY",
		.modmsk = ARMV8_ATTRS,
		.code = 0x018d,
		.desc = "This event counts every cycle that no instructions are committed because the CSE is empty and the all store ports are full.",
	},
	{
		.name = "WFE_WFI_CYCLE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x018e,
		.desc = "This event counts every cycle that the WFE/WFI instruction brings the instruction unit to a halt.",
	},
	{
		.name = "0INST_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0190,
		.desc = "This event counts every cycle that no instructions are committed, but counts at the time when commits MOVPRFX only.",
	},
	{
		.name = "1INST_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0191,
		.desc = "This event counts every cycle that one instruction is committed.",
	},
	{
		.name = "2INST_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0192,
		.desc = "This event counts every cycle that two instructions are committed.",
	},
	{
		.name = "3INST_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0193,
		.desc = "This event counts every cycle that three instructions are committed.",
	},
	{
		.name = "4INST_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0194,
		.desc = "This event counts every cycle that four instructions are committed.",
	},
	{
		.name = "UOP_ONLY_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0198,
		.desc = "This event counts every cycle that only any micro-operations are committed.",
	},
	{
		.name = "SINGLE_MOVPRFX_COMMIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0199,
		.desc = "This event counts every cycle that only the MOVPRFX instruction is committed.",
	},
	{
		.name = "EAGA_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a0,
		.desc = "This event counts valid cycles of EAGA pipeline.",
	},
	{
		.name = "EAGB_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a1,
		.desc = "This event counts valid cycles of EAGB pipeline.",
	},
	{
		.name = "EXA_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a2,
		.desc = "This event counts valid cycles of EXA pipeline.",
	},
	{
		.name = "EXB_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a3,
		.desc = "This event counts valid cycles of EXB pipeline.",
	},
	{
		.name = "FLA_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a4,
		.desc = "This event counts valid cycles of FLA pipeline.",
	},
	{
		.name = "FLB_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a5,
		.desc = "This event counts valid cycles of FLB pipeline.",
	},
	{
		.name = "PRX_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01a6,
		.desc = "This event counts valid cycles of PRX pipeline.",
	},
	{
		.name = "FLA_VAL_PRD_CNT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01b4,
		.desc = "This event counts the number of 1 in the predicate bits of request in FLA pipeline, and corrects itself to be 16 when all bits are 1.",
	},
	{
		.name = "FLB_VAL_PRD_CNT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01b5,
		.desc = "This event counts the number of 1 in the predicate bits of request in FLB pipeline, and corrects itself to be 16 when all bits are 1.",
	},
	{
		.name = "EA_CORE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x01e0,
		.desc = "This event counts energy consumption per cycle of core.",
	},
	{
		.name = "L1D_CACHE_REFILL_DM",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0200,
		.desc = "This event counts L1D_CACHE_REFILL caused by demand access.",
	},
	{
		.name = "L1D_CACHE_REFILL_HWPRF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0202,
		.desc = "This event counts L1D_CACHE_REFILL caused by hardware prefetch.",
	},
	{
		.name = "L1_MISS_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0208,
		.desc = "This event counts outstanding L1D cache miss requests per cycle.",
	},
	{
		.name = "L1I_MISS_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0209,
		.desc = "This event counts outstanding L1I cache miss requests per cycle.",
	},
	{
		.name = "L1HWPF_STREAM_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0230,
		.desc = "This event counts streaming prefetch requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L1HWPF_INJ_ALLOC_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0231,
		.desc = "This event counts allocation type prefetch injection requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L1HWPF_INJ_NOALLOC_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0232,
		.desc = "This event counts non-allocation type prefetch injection requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_STREAM_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0233,
		.desc = "This event counts streaming prefetch requests to L2 cache generated by hardware prefecher.",
	},
	{
		.name = "L2HWPF_INJ_ALLOC_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0234,
		.desc = "This event counts allocation type prefetch injection requests to L2 cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_INJ_NOALLOC_PF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0235,
		.desc = "This event counts non-allocation type prefetch injection requests to L2 cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_OTHER",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0236,
		.desc = "This event counts prefetch requests to L2 cache generated by the other causes.",
	},
	{
		.name = "L1_PIPE0_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0240,
		.desc = "This event counts valid cycles of L1D cache pipeline#0.",
	},
	{
		.name = "L1_PIPE1_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0241,
		.desc = "This event counts valid cycles of L1D cache pipeline#1.",
	},
	{
		.name = "L1_PIPE0_VAL_IU_TAG_ADRS_SCE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0250,
		.desc = "This event counts requests in L1D cache pipeline#0 that its sce bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE0_VAL_IU_TAG_ADRS_PFE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0251,
		.desc = "This event counts requests in L1D cache pipeline#0 that its pfe bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE1_VAL_IU_TAG_ADRS_SCE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0252,
		.desc = "This event counts requests in L1D cache pipeline#1 that its sce bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE1_VAL_IU_TAG_ADRS_PFE",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0253,
		.desc = "This event counts requests in L1D cache pipeline#1 that its pfe bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE0_COMP",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0260,
		.desc = "This event counts completed requests in L1D cache pipeline#0.",
	},
	{
		.name = "L1_PIPE1_COMP",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0261,
		.desc = "This event counts completed requests in L1D cache pipeline#1.",
	},
	{
		.name = "L1I_PIPE_COMP",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0268,
		.desc = "This event counts completed requests in L1I cache pipeline.",
	},
	{
		.name = "L1I_PIPE_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0269,
		.desc = "This event counts valid cycles of L1I cache pipeline.",
	},
	{
		.name = "L1_PIPE_ABORT_STLD_INTLK",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0274,
		.desc = "This event counts aborted requests in L1D pipelines that due to store-load interlock.",
	},
	{
		.name = "L1_PIPE0_VAL_IU_NOT_SEC0",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02a0,
		.desc = "This event counts requests in L1D cache pipeline#0 that its sector cache ID is not 0.",
	},
	{
		.name = "L1_PIPE1_VAL_IU_NOT_SEC0",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02a1,
		.desc = "This event counts requests in L1D cache pipeline#1 that its sector cache ID is not 0.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_2FLOW",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b0,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 2flows because 2 elements could not be combined.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_1FLOW",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b1,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 1flow because 2 elements could be combined.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_0FLOW",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b2,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 0flow because both predicate values are 0.",
	},
	{
		.name = "L1_PIPE_COMP_SCATTER_1FLOW",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b3,
		.desc = "This event counts the number of flows of the scatter instructions.",
	},
	{
		.name = "L1_PIPE0_COMP_PRD_CNT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b8,
		.desc = "This event counts the number of 1 in the predicate bits of request in L1D cache pipeline#0, and corrects itself to be 16 when all bits are 1.",
	},
	{
		.name = "L1_PIPE1_COMP_PRD_CNT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x02b9,
		.desc = "This event counts the number of 1 in the predicate bits of request in L1D cache pipeline#1, and corrects itself to be 16 when all bits are 1.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0300,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_HWPRF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0302,
		.desc = "This event counts L2D_CACHE_REFILL caused by hardware prefetch.",
	},
	{
		.name = "L2_MISS_WAIT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0308,
		.desc = "This event counts outstanding L2 cache miss requests per cycle. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "L2_MISS_COUNT",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0309,
		.desc = "This event counts the number of times of L2 cache miss. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_CMG0",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0310,
		.desc = "This event counts read requests from CMG0 to measured CMG, if measured CMG is not CMG0. Otherwise, this event counts read requests from CMG0 local memory to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_CMG1",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0311,
		.desc = "This event counts read requests from CMG1 to measured CMG, if measured CMG is not CMG1. Otherwise, this event counts read requests from CMG1 local memory to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_CMG2",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0312,
		.desc = "This event counts read requests from CMG2 to measured CMG, if measured CMG is not CMG2. Otherwise, this event counts read requests from CMG2 local memory to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_CMG3",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0313,
		.desc = "This event counts read requests from CMG3 to measured CMG, if measured CMG is not CMG3. Otherwise, this event counts read requests from CMG3 local memory to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_TOFU",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0314,
		.desc = "This event counts read requests from tofu controller to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_PCI",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0315,
		.desc = "This event counts read requests from PCI controller to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_READ_TOTAL_MEM",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0316,
		.desc = "This event counts read requests from measured CMG local memory to measured CMG. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_CMG0",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0318,
		.desc = "This event counts write requests from measured CMG to CMG0, if measured CMG is not CMG0. Otherwise, this event counts write requests from measured CMG to CMG0 local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_CMG1",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0319,
		.desc = "This event counts write requests from measured CMG to CMG1, if measured CMG is not CMG1. Otherwise, this event counts write requests from measured CMG to CMG1 local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_CMG2",
		.modmsk = ARMV8_ATTRS,
		.code = 0x031a,
		.desc = "This event counts write requests from measured CMG to CMG2, if measured CMG is not CMG2. Otherwise, this event counts write requests from measured CMG to CMG2 local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_CMG3",
		.modmsk = ARMV8_ATTRS,
		.code = 0x031b,
		.desc = "This event counts write requests from measured CMG to CMG3, if measured CMG is not CMG3. Otherwise, this event counts write requests from measured CMG to CMG3 local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_TOFU",
		.modmsk = ARMV8_ATTRS,
		.code = 0x031c,
		.desc = "This event counts write requests from measured CMG to tofu controller. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_PCI",
		.modmsk = ARMV8_ATTRS,
		.code = 0x031d,
		.desc = "This event counts write requests from measured CMG to PCI controller. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "BUS_WRITE_TOTAL_MEM",
		.modmsk = ARMV8_ATTRS,
		.code = 0x031e,
		.desc = "This event counts write requests from measured CMG to measured CMG local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "L2D_SWAP_DM",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0325,
		.desc = "This event counts operations where demand access hits an L2 cache refill buffer allocated by software or hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_MIBMCH_PRF",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0326,
		.desc = "This event counts operations where software or hardware prefetch hits an L2 cache refill buffer allocated by demand access.",
	},
	{
		.name = "L2_PIPE_VAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0330,
		.desc = "This event counts valid cycles of L2 cache pipeline. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "L2_PIPE_COMP_ALL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0350,
		.desc = "This event counts completed requests in L2 cache pipeline. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "L2_PIPE_COMP_PF_L2MIB_MCH",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0370,
		.desc = "This event counts operations where software or hardware prefetch hits an L2 cache refill buffer allocated by demand access. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "L2D_CACHE_SWAP_LOCAL",
		.modmsk = ARMV8_ATTRS,
		.code = 0x0396,
		.desc = "This event counts operations where demand access hits an L2 cache refill buffer allocated by software or hardware prefetch. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "EA_L2",
		.modmsk = ARMV8_ATTRS,
		.code = 0x03e0,
		.desc = "This event counts energy consumption per cycle of L2 cache. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "EA_MEMORY",
		.modmsk = ARMV8_ATTRS,
		.code = 0x03e8,
		.desc = "This event counts energy consumption per cycle of CMG local memory. It counts all events caused in measured CMG regardless of measured PE.",
	},
	{
		.name = "SIMD_INST_RETIRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8000,
		.desc = "This event counts architecturally executed SIMD instructions, excluding the Advanced SIMD scalar instructions and the instructions listed in Non-SIMD SVE instructions section of SVE Reference Manual.",
	},
	{
		.name = "SVE_INST_RETIRED",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8002,
		.desc = "This event counts architecturally executed Advanced SIMD instructions, including the instructions listed in Non-SIMD SVE instructions section of SVE Reference Manual.",
	},
	{
		.name = "UOP_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8008,
		.desc = "This event counts all architecturally executed micro-operations.",
	},
	{
		.name = "SVE_MATH_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x800e,
		.desc = "This event counts architecturally executed math function operations due to the SVE FTSMUL, FTMAD, FTSSEL, and FEXPA instructions.",
	},
	{
		.name = "FP_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8010,
		.desc = "This event counts architecturally executed operations due to scalar, Advanced SIMD, and SVE instructions listed in Floating-point instructions section of SVE Reference Manual.",
	},
	{
		.name = "FP_FMA_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8028,
		.desc = "This event counts architecturally executed floating-point fused multiply-add and multiply-subtract operations.",
	},
	{
		.name = "FP_RECPE_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8034,
		.desc = "This event counts architecturally executed floating-point reciprocal estimate operations due to the Advanced SIMD scalar, Advanced SIMD vector, and SVE FRECPE and FRSQRTE instructions.",
	},
	{
		.name = "FP_CVT_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8038,
		.desc = "This event counts architecturally executed floating-point convert operations due to the scalar, Advanced SIMD, and SVE floating-point conversion instructions listed in Floating-point conversions section of SVE Reference Manual.",
	},
	{
		.name = "ASE_SVE_INT_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8043,
		.desc = "This event counts architecturally executed integer arithmetic operations due to Advanced SIMD and SVE data-processing instructions listed in Integer instructions section of SVE Reference Manual.",
	},
	{
		.name = "SVE_PRED_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8074,
		.desc = "This event counts architecturally executed SIMD data-processing and load/store operations due to SVE instructions with a Governing predicate operand that determines the Active elements.",
	},
	{
		.name = "SVE_MOVPRFX_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x807c,
		.desc = "This event counts architecturally executed operations due to MOVPRFX instructions, whether or not they are fused with the prefixed instruction.",
	},
	{
		.name = "SVE_MOVPRFX_U_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x807f,
		.desc = "This event counts architecturally executed operations due to MOVPRFX instructions that are not fused with the prefixed instruction.",
	},
	{
		.name = "ASE_SVE_LD_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8085,
		.desc = "This event counts architecturally executed operations that read from memory due to SVE and Advanced SIMD load instructions.",
	},
	{
		.name = "ASE_SVE_ST_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8086,
		.desc = "This event counts architecturally executed operations that write to memory due to SVE and Advanced SIMD store instructions.",
	},
	{
		.name = "PRF_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8087,
		.desc = "This event counts architecturally executed prefetch operations due to scalar PRFM and SVE PRF instructions.",
	},
	{
		.name = "BASE_LD_REG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8089,
		.desc = "This event counts architecturally executed operations that read from memory due to an instruction that loads a general-purpose register.",
	},
	{
		.name = "BASE_ST_REG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x808a,
		.desc = "This event counts architecturally executed operations that write to memory due to an instruction that stores a general-purpose register, excluding the 'DC ZVA' instruction.",
	},
	{
		.name = "SVE_LDR_REG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8091,
		.desc = "This event counts architecturally executed operations that read from memory due to an SVE LDR instruction.",
	},
	{
		.name = "SVE_STR_REG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8092,
		.desc = "This event counts architecturally executed operations that write to memory due to an SVE STR instruction.",
	},
	{
		.name = "SVE_LDR_PREG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8095,
		.desc = "This event counts architecturally executed operations that read from memory due to an SVE LDR (predicate) instruction.",
	},
	{
		.name = "SVE_STR_PREG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x8096,
		.desc = "This event counts architecturally executed operations that write to memory due to an SVE STR (predicate) instruction.",
	},
	{
		.name = "SVE_PRF_CONTIG_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x809f,
		.desc = "This event counts architecturally executed operations that prefetch memory due to an SVE predicated single contiguous element prefetch instruction.",
	},
	{
		.name = "ASE_SVE_LD_MULTI_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80a5,
		.desc = "This event counts architecturally executed operations that read from memory due to SVE and Advanced SIMD multiple vector contiguous structure load instructions.",
	},
	{
		.name = "ASE_SVE_ST_MULTI_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80a6,
		.desc = "This event counts architecturally executed operations that write to memory due to SVE and Advanced SIMD multiple vector contiguous structure store instructions.",
	},
	{
		.name = "SVE_LD_GATHER_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80ad,
		.desc = "This event counts architecturally executed operations that read from memory due to SVE noncontiguous gather-load instructions.",
	},
	{
		.name = "SVE_ST_SCATTER_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80ae,
		.desc = "This event counts architecturally executed operations that write to memory due to SVE noncontiguous scatter-store instructions.",
	},
	{
		.name = "SVE_PRF_GATHER_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80af,
		.desc = "This event counts architecturally executed operations that prefetch memory due to SVE noncontiguous gather-prefetch instructions.",
	},
	{
		.name = "SVE_LDFF_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80bc,
		.desc = "This event counts architecturally executed memory read operations due to SVE First-fault and Non-fault load instructions.",
	},
	{
		.name = "FP_SCALE_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c0,
		.desc = "This event counts architecturally executed SVE arithmetic operations. This event counter is incremented by (128 / CSIZE) and by twice that amount for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_FIXED_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c1,
		.desc = "This event counts architecturally executed v8SIMD and FP arithmetic operations. The event counter is incremented by the specified number of elements for Advanced SIMD operations or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_HP_SCALE_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c2,
		.desc = "This event counts architecturally executed SVE half-precision arithmetic operations. This event counter is incremented by 8, or by 16 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_HP_FIXED_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c3,
		.desc = "This event counts architecturally executed v8SIMD and FP half-precision arithmetic operations. This event counter is incremented by the number of 16-bit elements for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_SP_SCALE_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c4,
		.desc = "This event counts architecturally executed SVE single-precision arithmetic operations. This event counter is incremented by 4, or by 8 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_SP_FIXED_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c5,
		.desc = "This event counts architecturally executed v8SIMD and FP single-precision arithmetic operations. This event counter is incremented by the number of 32-bit elements for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_DP_SCALE_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c6,
		.desc = "This event counts architecturally executed SVE double-precision arithmetic operations. This event counter is incremented by 2, or by 4 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_DP_FIXED_OPS_SPEC",
		.modmsk = ARMV8_ATTRS,
		.code = 0x80c7,
		.desc = "This event counts architecturally executed v8SIMD and FP double-precision arithmetic operations. This event counter is incremented by 2 for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
};
