#include "sw-banishable-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_banishable_iface_object_info;

struct _SwBanishableIfaceClass {
    GTypeInterface parent_class;
    sw_banishable_iface_hide_item_impl hide_item;
};

enum {
    SIGNAL_BANISHABLE_IFACE_ItemHidden,
    N_BANISHABLE_IFACE_SIGNALS
};
static guint banishable_iface_signals[N_BANISHABLE_IFACE_SIGNALS] = {0};

static void sw_banishable_iface_base_init (gpointer klass);

GType
sw_banishable_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwBanishableIfaceClass),
        sw_banishable_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwBanishableIface", &info, 0);
    }

  return type;
}

/**
 * sw_banishable_iface_hide_item_impl:
 * @self: The object implementing this interface
 * @in_uid: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * HideItem on interface com.meego.libsocialweb.Banishable.
 */
static void
sw_banishable_iface_hide_item (SwBanishableIface *self,
    const gchar *in_uid,
    DBusGMethodInvocation *context)
{
  sw_banishable_iface_hide_item_impl impl = (SW_BANISHABLE_IFACE_GET_CLASS (self)->hide_item);

  if (impl != NULL)
    {
      (impl) (self,
        in_uid,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_banishable_iface_implement_hide_item:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the HideItem D-Bus method
 *
 * Register an implementation for the HideItem method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_banishable_iface_implement_hide_item (SwBanishableIfaceClass *klass, sw_banishable_iface_hide_item_impl impl)
{
  klass->hide_item = impl;
}

/**
 * sw_banishable_iface_emit_item_hidden:
 * @instance: The object implementing this interface
 * @arg_uid: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ItemHidden signal on interface com.meego.libsocialweb.Banishable.
 */
void
sw_banishable_iface_emit_item_hidden (gpointer instance,
    const gchar *arg_uid)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_BANISHABLE_IFACE));
  g_signal_emit (instance,
      banishable_iface_signals[SIGNAL_BANISHABLE_IFACE_ItemHidden],
      0,
      arg_uid);
}

static inline void
sw_banishable_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_banishable_iface_get_type (),
      &_sw_banishable_iface_object_info);

  /**
   * SwBanishableIface::item-hidden:
   * @arg_uid: const gchar * (FIXME, generate documentation)
   *
   * The ItemHidden D-Bus signal is emitted whenever this GObject signal is.
   */
  banishable_iface_signals[SIGNAL_BANISHABLE_IFACE_ItemHidden] =
  g_signal_new ("item-hidden",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__STRING,
      G_TYPE_NONE,
      1,
      G_TYPE_STRING);

}
static void
sw_banishable_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_banishable_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_banishable_iface_methods[] = {
  { (GCallback) sw_banishable_iface_hide_item, sw_marshal_VOID__STRING_POINTER, 0 },
};

static const DBusGObjectInfo _sw_banishable_iface_object_info = {
  0,
  _sw_banishable_iface_methods,
  1,
"com.meego.libsocialweb.Banishable\0HideItem\0A\0uid\0I\0s\0\0\0",
"com.meego.libsocialweb.Banishable\0ItemHidden\0\0",
"\0\0",
};


