/* PR rtl-optimization/48840 */
/* Testcase by Hans-Peter Nilsson <hp@gcc.gnu.org> */

/* { dg-do compile } */
/* { dg-require-effective-target lp64 } */
/* { dg-options "-O2 -mcpu=ultrasparc -mvis" } */

typedef unsigned char uint8_t;

typedef unsigned char rc_vec_t __attribute__((__vector_size__(8)));
typedef short rc_svec_type_ __attribute__((__vector_size__(8)));

typedef unsigned char rc_vec4_type_ __attribute__((__vector_size__(4)));
typedef short rc_svec2_type_ __attribute__((__vector_size__(4)));

void
rc_filter_sobel_3x3_horz_u8(uint8_t *__restrict dst, int dst_dim,
                            const uint8_t *__restrict src, int src_dim,
                            int width, int height)
{
    do { int tot = (((width) + (8) - 1) / (8)); int len = tot / 3; int rem = tot % 3; int y; unsigned int rc_gsr_scale_ __attribute__ ((__unused__)) = 7; unsigned int rc_gsr_align_ __attribute__ ((__unused__)) = 4; unsigned int rc_gsr_set_ __attribute__ ((__unused__)) = 0; register unsigned int rc_gsr_fakedep_ __attribute__ ((__unused__)) = 0; unsigned int rc_gsr_ldinit_ __attribute__ ((__unused__)) = 0; for (y = 0; y < (height); y++) { rc_vec_t v11, v12, v13; rc_vec_t v21, v22, v23; rc_vec_t v31, v32, v33; rc_vec_t s1, s2, s3; int j = y*(dst_dim); int i2 = y*(src_dim) + 8; int i1 = i2 - (src_dim); int i3 = i2 + (src_dim); int x; ((s1) = *(const rc_vec_t*)(&(src)[i1 - 2*8])); ((s2) = *(const rc_vec_t*)(&(src)[i2 - 2*8])); ((s3) = *(const rc_vec_t*)(&(src)[i3 - 2*8])); do { do { rc_vec_t s1_ = (s1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v21) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); } while (0); ((s1) = *(const rc_vec_t*)(&(src)[i1 - 8])); ((s2) = *(const rc_vec_t*)(&(src)[i2 - 8])); ((s3) = *(const rc_vec_t*)(&(src)[i3 - 8])); do { do { rc_vec_t s1_ = (s1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v12) = dstv_; } while (0); do { rc_vec_t s1_ = (v12); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v22) = dstv_; } while (0); do { rc_vec_t s1_ = (v12); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v12) = dstv_; } while (0); } while (0); ((v13) = ((rc_vec_t) {0})); ((v23) = ((rc_vec_t) {0})); ((v33) = ((rc_vec_t) {0})); (void)v21, (void)v22; (void)v31, (void)v32; for (x = 0; x < len; x++) { do { rc_vec_t p1, p2, p3, sum; ((p1) = *(const rc_vec_t*)(&(src)[i1])); ((p2) = *(const rc_vec_t*)(&(src)[i2])); ((p3) = *(const rc_vec_t*)(&(src)[i3])); do { do { rc_vec_t s1_ = (p1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v13) = dstv_; } while (0); do { rc_vec_t s1_ = (v13); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v23) = dstv_; } while (0); do { rc_vec_t s1_ = (v13); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v13) = dstv_; } while (0); } while (0); do { rc_vec_t u12, u23; do { rc_vec_t shv_; do { rc_vec_t v_ = (v12); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(8 - 1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (8 - 1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (8 - 1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v11, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u12) = dstv_; } while (0); } while (0); do { rc_vec_t shv_; do { rc_vec_t v_ = (v23); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v22, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u23) = dstv_; } while (0); } while (0); do { rc_vec_t s1_ = (u23); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (u12); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = ((hi1_) - (hi2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); los_ = ((lo1_) - (lo2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (sum) = dstv_; } while (0); } while (0); (*(rc_vec_t*)(&(dst)[j]) = (sum)); (i1) += 8; (i2) += 8; (i3) += 8; (j) += 8; } while (0); do { rc_vec_t p1, p2, p3, sum; ((p1) = *(const rc_vec_t*)(&(src)[i1])); ((p2) = *(const rc_vec_t*)(&(src)[i2])); ((p3) = *(const rc_vec_t*)(&(src)[i3])); do { do { rc_vec_t s1_ = (p1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v21) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); } while (0); do { rc_vec_t u12, u23; do { rc_vec_t shv_; do { rc_vec_t v_ = (v13); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(8 - 1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (8 - 1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (8 - 1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v12, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u12) = dstv_; } while (0); } while (0); do { rc_vec_t shv_; do { rc_vec_t v_ = (v21); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v23, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u23) = dstv_; } while (0); } while (0); do { rc_vec_t s1_ = (u23); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (u12); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = ((hi1_) - (hi2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); los_ = ((lo1_) - (lo2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (sum) = dstv_; } while (0); } while (0); (*(rc_vec_t*)(&(dst)[j]) = (sum)); (i1) += 8; (i2) += 8; (i3) += 8; (j) += 8; } while (0); do { rc_vec_t p1, p2, p3, sum; ((p1) = *(const rc_vec_t*)(&(src)[i1])); ((p2) = *(const rc_vec_t*)(&(src)[i2])); ((p3) = *(const rc_vec_t*)(&(src)[i3])); do { do { rc_vec_t s1_ = (p1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v12) = dstv_; } while (0); do { rc_vec_t s1_ = (v12); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v22) = dstv_; } while (0); do { rc_vec_t s1_ = (v12); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v12) = dstv_; } while (0); } while (0); do { rc_vec_t u12, u23; do { rc_vec_t shv_; do { rc_vec_t v_ = (v11); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(8 - 1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (8 - 1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (8 - 1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v13, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u12) = dstv_; } while (0); } while (0); do { rc_vec_t shv_; do { rc_vec_t v_ = (v22); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v21, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u23) = dstv_; } while (0); } while (0); do { rc_vec_t s1_ = (u23); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (u12); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = ((hi1_) - (hi2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); los_ = ((lo1_) - (lo2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (sum) = dstv_; } while (0); } while (0); (*(rc_vec_t*)(&(dst)[j]) = (sum)); (i1) += 8; (i2) += 8; (i3) += 8; (j) += 8; } while (0); } if (rem > 0) { do { rc_vec_t p1, p2, p3, sum; ((p1) = *(const rc_vec_t*)(&(src)[i1])); ((p2) = *(const rc_vec_t*)(&(src)[i2])); ((p3) = *(const rc_vec_t*)(&(src)[i3])); do { do { rc_vec_t s1_ = (p1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v13) = dstv_; } while (0); do { rc_vec_t s1_ = (v13); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v23) = dstv_; } while (0); do { rc_vec_t s1_ = (v13); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v13) = dstv_; } while (0); } while (0); do { rc_vec_t u12, u23; do { rc_vec_t shv_; do { rc_vec_t v_ = (v12); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(8 - 1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (8 - 1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (8 - 1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v11, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u12) = dstv_; } while (0); } while (0); do { rc_vec_t shv_; do { rc_vec_t v_ = (v23); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v22, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u23) = dstv_; } while (0); } while (0); do { rc_vec_t s1_ = (u23); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (u12); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = ((hi1_) - (hi2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); los_ = ((lo1_) - (lo2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (sum) = dstv_; } while (0); } while (0); (*(rc_vec_t*)(&(dst)[j]) = (sum)); (i1) += 8; (i2) += 8; (i3) += 8; (j) += 8; } while (0); } if (rem > 1) { do { rc_vec_t p1, p2, p3, sum; ((p1) = *(const rc_vec_t*)(&(src)[i1])); ((p2) = *(const rc_vec_t*)(&(src)[i2])); ((p3) = *(const rc_vec_t*)(&(src)[i3])); do { do { rc_vec_t s1_ = (p1); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p3); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_) + (rc_svec_type_){(16), (16), (16), (16)}; los_ = (lo1_) + (lo2_) + (rc_svec_type_){(16), (16), (16), (16)}; hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v21) = dstv_; } while (0); do { rc_vec_t s1_ = (v11); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (p2); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = (hi1_) + (hi2_); los_ = (lo1_) + (lo2_); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (v11) = dstv_; } while (0); } while (0); do { rc_vec_t u12, u23; do { rc_vec_t shv_; do { rc_vec_t v_ = (v13); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(8 - 1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (8 - 1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (8 - 1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v12, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u12) = dstv_; } while (0); } while (0); do { rc_vec_t shv_; do { rc_vec_t v_ = (v21); do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(1) || !__builtin_constant_p(rc_gsr_scale_) || !rc_gsr_set_ || (unsigned) (1) != rc_gsr_align_ || (unsigned) (rc_gsr_scale_) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (1); rc_gsr_scale_ = (rc_gsr_scale_); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (v_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (v_) : "0" (v_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); (shv_) = v_; } while (0); do { rc_vec_t dstv_ = __builtin_vis_faligndatav8qi(v23, shv_); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (u23) = dstv_; } while (0); } while (0); do { rc_vec_t s1_ = (u23); rc_vec_t dstv_; rc_vec4_type_ hi_, lo_; rc_vec4_type_ s1hi_, s1lo_; rc_vec4_type_ s2hi_, s2lo_; rc_svec_type_ hi1_, hi2_, lo1_, lo2_, his_, los_; do { if (rc_gsr_ldinit_) { extern void rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(void); rc_mixing_GSR_setting_with_RC_VEC_LDINIT_(); } if (!__builtin_constant_p(rc_gsr_align_) || !__builtin_constant_p(2) || !rc_gsr_set_ || (unsigned) (rc_gsr_align_) != rc_gsr_align_ || (unsigned) (2) != rc_gsr_scale_) { rc_gsr_set_ = 1; rc_gsr_align_ = (rc_gsr_align_); rc_gsr_scale_ = (2); unsigned int val_ = (rc_gsr_scale_ << 3) | rc_gsr_align_; if (__builtin_constant_p (val_)) { __asm__("wr %%g0,%[gsrval],%%gsr\n" ";# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "i" (val_), "1" (rc_gsr_fakedep_)); } else { __asm__("wr %[gsrval],0,%%gsr" "\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_), [fakegsr] "=rm" (rc_gsr_fakedep_) : "0" (s1_), [gsrval] "r" (val_), "1" (rc_gsr_fakedep_)); } } else { __asm__("\n;# dep %[depvec] on fake GSR %[fakegsr]" : [depvec] "=brm" (s1_) : "0" (s1_), [fakegsr] "g" (rc_gsr_fakedep_)); } } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (s1_); (s1hi_) = hl_.hilo_.hi_; (s1lo_) = hl_.hilo_.lo_; } while (0); do { typedef union { rc_vec_t v_; struct { rc_vec4_type_ hi_, lo_; } hilo_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) (u12); (s2hi_) = hl_.hilo_.hi_; (s2lo_) = hl_.hilo_.lo_; } while (0); hi1_ = __builtin_vis_fexpand(s1hi_); lo1_ = __builtin_vis_fexpand(s1lo_); hi2_ = __builtin_vis_fexpand(s2hi_); lo2_ = __builtin_vis_fexpand(s2lo_); his_ = ((hi1_) - (hi2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); los_ = ((lo1_) - (lo2_) + (rc_svec_type_){(256*16), (256*16), (256*16), (256*16)}); hi_ = __builtin_vis_fpack16(his_); lo_ = __builtin_vis_fpack16(los_); do { typedef union { struct { rc_vec4_type_ hi_, lo_; } hilo_; rc_vec_t v_; } RC_hl_type_; RC_hl_type_ hl_ = (RC_hl_type_) {{(hi_), (lo_)}}; (dstv_) = hl_.v_; } while (0); __asm__("\n;# dep fake GSR %[fakegsr] on %[xdep]" : [fakegsr] "=brm" (rc_gsr_fakedep_) : [xdep] "brm" (dstv_), "0" (rc_gsr_fakedep_)); (sum) = dstv_; } while (0); } while (0); (*(rc_vec_t*)(&(dst)[j]) = (sum)); (i1) += 8; (i2) += 8; (i3) += 8; (j) += 8; } while (0); } } ; } while (0);

}
