/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
/**
 * @defgroup Xml XML/WBXML API
 * @ingroup PrivateAPI
 * @brief The public part
 * 
 */
/**
 * @defgroup XmlPublic Internal XML/WBXML API
 * @ingroup Xml
 * @brief The public part
 * 
 */
/**
 * @defgroup XmlParser XML Parser
 * @ingroup XmlPublic
 * @brief Interfaces to parse SyncML XML messages
 * 
 */
/*@{*/

#ifndef _SML_XML_PARSE_H_
#define _SML_XML_PARSE_H_

typedef struct SmlXmlParser SmlXmlParser;

SmlXmlParser *smlXmlParserNew(SmlParserFunctions *functions, SmlError **error);

SmlBool smlXmlParserStart(SmlXmlParser *parser, const char *data, unsigned int size, SmlError **error);
SmlBool smlXmlParserEnd(SmlXmlParser *parser, SmlBool *final, SmlBool *end, SmlError **error);
void smlXmlParserFree(SmlXmlParser *parser);
SmlBool smlXmlParserGetHeader(SmlXmlParser *parser, SmlHeader **header, SmlCred **cred, SmlError **error);
SmlBool smlXmlParserGetStatus(SmlXmlParser *parser, SmlStatus **status, SmlError **error);
SmlParserResult smlXmlParserGetCommand(SmlXmlParser *parser, SmlCommand **cmd, SmlError **error);

SmlDevInf *smlXmlDevInfParse(const char *data, unsigned int size, SmlError **error);

#endif //_SML_XML_PARSE_H_
/*@}*/
