/* *************************************************************************
 * Copyright (c) 2005 VMware, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * *************************************************************************/

/*
 * contentBox.hh --
 *
 *      Declarations for the view::ContentBox class.
 */

#ifndef LIBVIEW_CONTENTBOX_HH
#   define LIBVIEW_CONTENTBOX_HH


#include <gtkmm/box.h>
#include <sigc++/connection.h>
#include <list>


namespace view {


class ContentBox
   : public Gtk::HBox
{
public:
   enum Mode {
      TRACK,
      SHOW,
      HIDE,
   };

   ContentBox(void);
   void SetMode(Mode value);

protected:
   /* Re-implemented Gtk::Container methods. */
   void on_add(Gtk::Widget *widget);
   void on_remove(Gtk::Widget *widget);

private:
   void Disconnect(void);
   void UpdateVisibility(void);
   void UpdateVisibilityWhenTracking(void);
   bool WidgetHasContent(Gtk::Widget *widget);
   bool ContainerHasContent(Gtk::Container *container);

   Mode mMode;
   Gtk::Widget *mChild;
   bool mTracking;
   std::list<sigc::connection> mCnxs;
   sigc::slot<void> mVisibilityChangedSlot;
   sigc::slot<void, Gtk::Widget *> mChildrenChangedSlot;
};


} /* namespace view */


#endif /* LIBVIEW_CONTENTBOX_HH */
