%define     req_libvirt_version 1.2.8

%if 0%{?suse_version}
%define     php_confdir %{_sysconfdir}/php5/conf.d
%define     php_extdir  %{_libdir}/php5/extensions
%else
%define     php_confdir %{_sysconfdir}/php.d
%define     php_extdir  %{_libdir}/php/modules
%endif

Name:       libvirt-php
Version:    0.5.5
Release:    1%{?dist}%{?extra_release}
Summary:    PHP language binding for Libvirt

%if 0%{?suse_version}
Group:      Development/Libraries/PHP
%else
Group:      Development/Libraries
%endif
License:    PHP
URL:        http://libvirt.org/php
Source0:    http://libvirt.org/sources/php/libvirt-php-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires:  php-devel
BuildRequires:  libvirt-devel >= %{req_libvirt_version}
BuildRequires:  libxml2-devel
BuildRequires:  libxslt
BuildRequires:  php-pecl-imagick
%if 0%{?suse_version}
BuildRequires:  xhtml-dtd
%else
BuildRequires:  xhtml1-dtds
%endif
%if 0%{?suse_version}
Requires:   php5
%else
Requires:   php
%endif

%description
PHP language bindings for Libvirt API.
For more details see: http://www.libvirt.org/php/

%package -n libvirt-php-doc
Summary:    Document of libvirt-php
Group:      Development/Libraries/PHP
BuildArch:  noarch
Requires:   libvirt-php = %{version}

%description -n libvirt-php-doc
PHP language bindings for Libvirt API.
For more details see: http://www.libvirt.org/php/ http://www.php.net/

This package contain the document for libvirt-php.

%prep
%setup -q -n libvirt-php-%{version}

%build
%configure --with-html-dir=%{_datadir}/doc \
           --with-html-subdir=%{name}-%{version}/html \
           --with-php-extensiondir=%{php_extdir} \
           --with-php-confdir=%{php_confdir}
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
rm -f ${RPM_BUILD_ROOT}%{php_extdir}/*.la

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{php_extdir}/libvirt-php.so
%config(noreplace) %{php_confdir}/libvirt-php.ini

%files -n libvirt-php-doc
%defattr(-,root,root)
%doc
%dir %{_datadir}/doc/%{name}-%{version}
%{_datadir}/doc/%{name}-%{version}/html

%changelog
* Sat Feb 8 2020 Michal Privoznik <mprivozn@redhat.com> - 0.5.5
- Implemented virDomainReset() API
- Implemented virDomainInterfaceAddresses() API
- Bug fixes

* Wed Aug 2 2017 Michal Privoznik <mprivozn@redhat.com> - 0.5.4
- Added API bindings for getting/setting network autostart
- Implement NWFilter API bindings
- Bug fixes

* Thu May 11 2017 Michal Privoznik <mprivozn@redhat.com> - 0.5.3
- Several improvements for the build system
- Implemented new libvirt APIs
- Slight rework of our examples
- Bug fixes

* Wed Apr 20 2016 Michal Privoznik <mprivozn@redhat.com> - 0.5.2
- Several bugfixes & improvements

* Fri Oct 2 2015 Michal Privoznik <mprivozn@redhat.com> - 0.5.1
- Several bugfixes & improvements

* Thu Jan 23 2014 Michal Novotny <minovotn@redhat.com> - 0.5.0
- Several bugfixes & improvements

* Mon Aug 22 2011 Michal Novotny <minovotn@redhat.com> - 0.4.4
- Several bugfixes for VNC and updated SPEC file

* Thu Aug 11 2011 Michal Novotny <minovotn@redhat.com> - 0.4.3
- Rebase to 0.4.3 from master branch

* Tue Apr 19 2011 Michal Novotny <minovotn@redhat.com> - 0.4.1-5
- Minor memory leak fixes
- Several bug fixes

* Mon Apr 11 2011 Michal Novotny <minovotn@redhat.com> - 0.4.1-4
- Add new storagepool API functions
- Add optional xPath argument for *_get_xml_desc() functions
- Add new network API functions
- Add new API functions to add/remove disks

* Wed Mar 23 2011 Michal Novotny <minovotn@redhat.com> - 0.4.1-3
- Add connection information function
- Add coredump support
- Add snapshots support
- Improve error reporting for destructors

* Thu Mar 10 2011 Michal Novotny <minovotn@redhat.com> - 0.4.1-2
- Changes done to comply with Fedora package policy

* Tue Feb 8 2011 Michal Novotny <minovotn@redhat.com> - 0.4.1
- Initial commit (from github)
