/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.event.DockingActionSplitComponentEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitDockableContainerEvent;
import java.awt.Shape;
import javax.swing.*;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import java.awt.Rectangle;
import java.awt.BorderLayout;
import java.awt.geom.Rectangle2D;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import java.awt.Point;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

/** This class is responsible for the containment of a Dockable component.
 * <p>
 * Users of the VLDocking Framework should not call this class which is
 * a utility component of DockingDesktop.
 *
 * <p>
 * Please rely on DockingDesktop capabilities.
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 * @update 2005/11/08 Lilian Chamontin : added support for global width/height drop
 */
public class DockingPanel extends JPanel implements DockDropReceiver{

    /**  @todo  see if we still need the DockDropReceiver */

    /** Javabeans constructor  */
    public DockingPanel(){
      super(new BorderLayout());
    }

    /** act the same as a splitContainer : allow drop on the borders*/
    public void processDockableDrag(DockDragEvent event) {
      scanContainer(event, false);
    }

    public void processDockableDrop(DockDropEvent event) {
      scanContainer(event, true);
    }

    private void acceptDrop(DockEvent event, DockingConstants.Split position){ 
      Container dragContainer = event.getDragSource().getDockableContainer();
      ( (DockDropEvent) event).acceptDrop();        
      if (dragContainer instanceof TabbedDockableContainer){
         event.getDesktop().splitComponent(this, dragContainer,  position);
      } else {
        event.getDesktop().splitComponent(this, event.getDragSource().getDockable(),  position);
      }
    }
    
    private void acceptDrag(DockEvent event, DockingConstants.Split position, Shape shape){ 
      Container dragContainer = event.getDragSource().getDockableContainer();
      Dockable dockable = event.getDragSource().getDockable();
      int initialState = dockable.getDockKey().getDockableState();
      int nextState = DockableState.STATE_DOCKED;
      
      if (dragContainer instanceof TabbedDockableContainer){
         event.setDockingAction(new DockingActionSplitDockableContainerEvent(
             event.getDesktop(), initialState, nextState, 
             this, dragContainer, position, 0.5f));
      } else {
         event.setDockingAction(new DockingActionSplitComponentEvent(
             event.getDesktop(), dockable, initialState, nextState, 
             this, position, 0.5f));
      }
      ( (DockDragEvent) event).acceptDrag(shape);        
    }

    private void scanContainer(DockEvent event, boolean drop) {
      Point p = event.getMouseEvent().getPoint();
      Rectangle compBounds = getBounds();
      int distTop = p.y;
      int distLeft = p.x;
      int min = Math.min(distTop, distLeft);
      int distRight = compBounds.width - p.x;
      int distBottom = compBounds.height - p.y;
      int min2 = Math.min(distBottom, distRight);
      min = Math.min(min, min2);

      Dimension size = getSize();
      Dockable dragged = event.getDragSource().getDockable();
      // the drag size is the one of the parent dockable container
      Dimension draggedSize = dragged.getComponent().getParent().getSize();
      int bestHeight = (int)Math.min(draggedSize.height , size.height * 0.5);
      int bestWidth = (int)Math.min(draggedSize.width , size.width * 0.5);
      
      
      if (min == distTop) {
        // dock on top
        if (drop) {
          acceptDrop(event, DockingConstants.SPLIT_TOP);
        } else {
          Rectangle2D r2d = new Rectangle2D.Float(0,
              0,
              compBounds.width,
              bestHeight);
          acceptDrag(event, DockingConstants.SPLIT_TOP, r2d);
        }
      } else if (min == distLeft) {
        if (drop) {
          acceptDrop(event, DockingConstants.SPLIT_LEFT);
        } else {
          Rectangle2D r2d = new Rectangle2D.Float(0,
              0,
              bestWidth,
              compBounds.height);
          acceptDrag(event, DockingConstants.SPLIT_LEFT, r2d);
        }
      } else if (min == distBottom) {
        if (drop) {
          acceptDrop(event, DockingConstants.SPLIT_BOTTOM);
        } else {
          Rectangle2D r2d = new Rectangle2D.Float(0,
              compBounds.height - bestHeight,
              compBounds.width,
              bestHeight);
          acceptDrag(event, DockingConstants.SPLIT_BOTTOM, r2d);
        }
        } else { // right
          if (drop) {
            acceptDrop(event, DockingConstants.SPLIT_RIGHT);
          } else {
            Rectangle2D r2d = new Rectangle2D.Float(
                compBounds.width - bestWidth,
                0,
                bestWidth,
                compBounds.height);
          acceptDrag(event, DockingConstants.SPLIT_RIGHT, r2d);
          }
        }
      }

    public void resetToPreferredSize() {
      Component mainComp = getComponent(0);
      if (mainComp instanceof SplitContainer){
        ((SplitContainer)mainComp).resetToPreferredSizes();
      }
    }
    
    public String toString(){
      return "DockingPanel["+hashCode()+"]"; // 2007/01/24
    }


  }
