/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking.event;

import java.awt.event.*;
import com.vlsolutions.swing.docking.*;

/** Abstract superclass of drag and drop docking events.
 * <P> This class holds a reference to the source of the event and its mouse event.
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 *  */
public abstract class DockEvent {
  /** The drag source */
  protected DockableDragSource source;

  /** The docking desktop which is the destination of the drag and drop gesture */
  protected DockingDesktop desktop;

  /** The MouseEvent, in target's coordinates */
  protected MouseEvent event;
  
  /** The action corresponding to the drag and drop gesture 
   * (actions can be seen as allowed docking gestures)
   */
  protected DockingActionEvent action;

  /** Constructor for dock events.
   *
   * @param targetDesktop the desktop which will receive the drop 
   * @param source the source of drag operation
   * @param event the mouse event which is the cause of this DockEvent.
   */
  public DockEvent(DockingDesktop targetDesktop, DockableDragSource source, MouseEvent event) {
    this.desktop = targetDesktop;
    this.source = source;
    this.event = event;
  }

  /** Returns the MouseEvent which is the cause of this DockEvent.
   * <p>
   * <b> note that mouse coordinates are converted into the target's coordinates.</b>
   * @return a mouse event
   */
  public MouseEvent getMouseEvent(){
    return event;
  }

  /** Returns a reference to the drag source of this event.
   *
   * @return the drag source (the component actually dragged)
   */
  public DockableDragSource getDragSource(){
    return source;
  }

  /** Returns a reference of the desktop in which the docking event takes place.
   *<p> 
   * As of version 2.1, this method returns the "target" desktop (the one in which the drop will occur)
   *<p>
   * To get a reference of the "source" desktop, use the DockableState information provided by 
   * the DockingContext.
   *
   */
  public DockingDesktop getDesktop(){
    return desktop;
  }

  
  /** Returns the DockingActionEvent corresponding to the drag and drop gesture */
  public DockingActionEvent getDockingAction(){
    return action;
  }
  
  /** Set the docking action corresponding to this drag and drop gesture.
   *
   */
  public void setDockingAction(DockingActionEvent actionEvent){
    this.action = actionEvent;
  }


}
