/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.typesafe;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class TypeSafeVerifier
extends InputVerifier {
    private static final boolean DEFAULT_TRIMSPACES = false;
    private static final int DEFAULT_MINCHARS = 0;
    private static final Date DEFAULT_DATE = Calendar.getInstance().getTime();
    private static final String DEFAULT_DATEPATTERN = "dd/MM/yyyy";
    private Class m_classType = null;
    private boolean m_defaultsOnError = false;
    private boolean m_trimSpaces = false;
    private int m_minChars = 0;
    private String m_datePattern = "dd/MM/yyyy";
    private Date m_defaultDateValue = DEFAULT_DATE;
    private byte m_minByteValue = (byte)-128;
    private byte m_maxByteValue = (byte)127;
    private byte m_defaultByteValue = 0;
    private short m_minShortValue = Short.MIN_VALUE;
    private short m_maxShortValue = Short.MAX_VALUE;
    private short m_defaultShortValue = 0;
    private int m_minIntegerValue = Integer.MIN_VALUE;
    private int m_maxIntegerValue = Integer.MAX_VALUE;
    private int m_defaultIntegerValue = 0;
    private long m_minLongValue = Long.MIN_VALUE;
    private long m_maxLongValue = Long.MAX_VALUE;
    private long m_defaultLongValue = 0L;
    private float m_minFloatValue = Float.MIN_VALUE;
    private float m_maxFloatValue = Float.MAX_VALUE;
    private float m_defaultFloatValue = 0.0f;
    private double m_minDoubleValue = Double.MIN_VALUE;
    private double m_maxDoubleValue = Double.MAX_VALUE;
    private double m_defaultDoubleValue = 0.0;

    public TypeSafeVerifier(Class clsType) {
        this.m_classType = clsType;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextComponent tx = null;
        String text = "";
        if (input instanceof JTextComponent) {
            tx = (JTextComponent)input;
            text = tx.getText();
            if (this.m_trimSpaces) {
                tx.setText(text.trim());
                text = tx.getText();
            }
        } else {
            System.err.println("TypeSafeVerifier: unsupported JComponent(" + input + ")");
            return true;
        }
        if (this.m_classType.equals(String.class)) {
            return this.check_string(text);
        }
        if (this.m_classType.equals(Date.class)) {
            return this.check_date(text, tx);
        }
        if (this.m_classType.equals(Byte.class)) {
            return this.check_byte(text, tx);
        }
        if (this.m_classType.equals(Short.class)) {
            return this.check_short(text, tx);
        }
        if (this.m_classType.equals(Integer.class)) {
            return this.check_int(text, tx);
        }
        if (this.m_classType.equals(Long.class)) {
            return this.check_long(text, tx);
        }
        if (this.m_classType.equals(Float.class)) {
            return this.check_float(text, tx);
        }
        if (this.m_classType.equals(Double.class)) {
            return this.check_double(text, tx);
        }
        System.err.println("TypeSafeVerifier: unsupported classType(" + this.m_classType + ")");
        return true;
    }

    public Class getVerifierClassType() {
        return this.m_classType;
    }

    public boolean getDefaultsOnError() {
        return this.m_defaultsOnError;
    }

    public void setDefaultsOnError(boolean f) {
        this.m_defaultsOnError = f;
    }

    public boolean getTrimSpaces() {
        return this.m_trimSpaces;
    }

    public void setTrimSpaces(boolean f) {
        this.m_trimSpaces = f;
    }

    public int getMinChars() {
        return this.m_minChars;
    }

    public void setMinChars(int v) {
        if (v >= 0 && v <= 4096) {
            this.m_minChars = v;
        } else {
            System.err.println("TypeSafeVerifier: invalid minChars(" + v + "), reverting to default(" + 0 + ")");
            this.m_minChars = 0;
        }
    }

    public String getDatePattern() {
        return this.m_datePattern;
    }

    public void setDatePattern(String v) {
        this.m_datePattern = v;
    }

    public Date getDefaultDateValue() {
        return this.m_defaultDateValue;
    }

    public void setDefaultDateValue(Date v) {
        this.m_defaultDateValue = v;
    }

    public byte getMinByteValue() {
        return this.m_minByteValue;
    }

    public void setMinByteValue(byte v) {
        this.m_minByteValue = v;
    }

    public byte getMaxByteValue() {
        return this.m_maxByteValue;
    }

    public void setMaxByteValue(byte v) {
        this.m_maxByteValue = v;
    }

    public byte getDefaultByteValue() {
        return this.m_defaultByteValue;
    }

    public void setDefaultByteValue(byte v) {
        this.m_defaultByteValue = v;
    }

    public short getMinShortValue() {
        return this.m_minShortValue;
    }

    public void setMinShortValue(short v) {
        this.m_minShortValue = v;
    }

    public short getMaxShortValue() {
        return this.m_maxShortValue;
    }

    public void setMaxShortValue(short v) {
        this.m_maxShortValue = v;
    }

    public short getDefaultShortValue() {
        return this.m_defaultShortValue;
    }

    public void setDefaultShortValue(short v) {
        this.m_defaultShortValue = v;
    }

    public int getMinIntegerValue() {
        return this.m_minIntegerValue;
    }

    public void setMinIntegerValue(int v) {
        this.m_minIntegerValue = v;
    }

    public int getMaxIntegerValue() {
        return this.m_maxIntegerValue;
    }

    public void setMaxIntegerValue(int v) {
        this.m_maxIntegerValue = v;
    }

    public int getDefaultIntegerValue() {
        return this.m_defaultIntegerValue;
    }

    public void setDefaultIntegerValue(int v) {
        this.m_defaultIntegerValue = v;
    }

    public long getMinLongValue() {
        return this.m_minLongValue;
    }

    public void setMinLongValue(long v) {
        this.m_minLongValue = v;
    }

    public long getMaxLongValue() {
        return this.m_maxLongValue;
    }

    public void setMaxLongValue(long v) {
        this.m_maxLongValue = v;
    }

    public long getDefaultLongValue() {
        return this.m_defaultLongValue;
    }

    public void setDefaultLongValue(long v) {
        this.m_defaultLongValue = v;
    }

    public float getMinFloatValue() {
        return this.m_minFloatValue;
    }

    public void setMinFloatValue(float v) {
        this.m_minFloatValue = v;
    }

    public float getMaxFloatValue() {
        return this.m_maxFloatValue;
    }

    public void setMaxFloatValue(float v) {
        this.m_maxFloatValue = v;
    }

    public float getDefaultFloatValue() {
        return this.m_defaultFloatValue;
    }

    public void setDefaultFloatValue(float v) {
        this.m_defaultFloatValue = v;
    }

    public double getMinDoubleValue() {
        return this.m_minDoubleValue;
    }

    public void setMinDoubleValue(double v) {
        this.m_minDoubleValue = v;
    }

    public double getMaxDoubleValue() {
        return this.m_maxDoubleValue;
    }

    public void setMaxDoubleValue(double v) {
        this.m_maxDoubleValue = v;
    }

    public double getDefaultDoubleValue() {
        return this.m_defaultDoubleValue;
    }

    public void setDefaultDoubleValue(double v) {
        this.m_defaultDoubleValue = v;
    }

    private boolean check_string(String text) {
        return text.length() >= this.m_minChars;
    }

    private boolean check_date(String text, JTextComponent tx) {
        SimpleDateFormat frm = null;
        try {
            frm = new SimpleDateFormat(this.m_datePattern);
            Date dt = frm.parse(text);
            return true;
        }
        catch (Exception e) {
            String s = "";
            try {
                s = frm != null ? frm.format(this.m_defaultDateValue) : "";
            }
            catch (Exception ex) {
                System.err.println("TypeSafeVerifier: invalid datePattern(" + this.m_datePattern + ")");
                s = "";
            }
            return this.print_default(tx, s != null ? s : "");
        }
    }

    private boolean check_byte(String text, JTextComponent tx) {
        try {
            Byte num = new Byte(Byte.parseByte(text));
            byte val = num;
            if (val >= this.m_minByteValue && val <= this.m_maxByteValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultByteValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultByteValue));
        }
    }

    private boolean check_short(String text, JTextComponent tx) {
        try {
            Short num = new Short(Short.parseShort(text));
            short val = num;
            if (val >= this.m_minShortValue && val <= this.m_maxShortValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultShortValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultShortValue));
        }
    }

    private boolean check_int(String text, JTextComponent tx) {
        try {
            Integer num = new Integer(Integer.parseInt(text));
            int val = num;
            if (val >= this.m_minIntegerValue && val <= this.m_maxIntegerValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultIntegerValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultIntegerValue));
        }
    }

    private boolean check_long(String text, JTextComponent tx) {
        try {
            Long num = new Long(Long.parseLong(text));
            long val = num;
            if (val >= this.m_minLongValue && val <= this.m_maxLongValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultLongValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultLongValue));
        }
    }

    private boolean check_float(String text, JTextComponent tx) {
        try {
            Float num = new Float(Float.parseFloat(text));
            float val = num.floatValue();
            if (val >= this.m_minFloatValue && val <= this.m_maxFloatValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultFloatValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultFloatValue));
        }
    }

    private boolean check_double(String text, JTextComponent tx) {
        try {
            Double num = new Double(Double.parseDouble(text));
            double val = num;
            if (val >= this.m_minDoubleValue && val <= this.m_maxDoubleValue) {
                return true;
            }
            return this.print_default(tx, String.valueOf(this.m_defaultDoubleValue));
        }
        catch (Exception e) {
            return this.print_default(tx, String.valueOf(this.m_defaultDoubleValue));
        }
    }

    private boolean print_default(JTextComponent tx, String val) {
        if (!this.m_defaultsOnError) {
            return false;
        }
        tx.setText(val);
        return true;
    }
}

