/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfInterpretor.cc
    \brief Implementation of the Template class NetcdfInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/



#include "NetcdfInterpretor.h"
#include "Netcdf.h"
#include <limits>

using namespace magics;

NetcdfInterpretor::NetcdfInterpretor() 
{
}

void NetcdfInterpretor::setDimensions(const stringarray& value, map<string, string>& first, map<string, string>& last)
{
    first.clear();
    last.clear();
 
    Tokenizer tokenizer("/ ");
    vector<string> tokens;
    for (stringarray::const_iterator val = value.begin(); val != value.end(); ++val) {
        tokens.clear();
        tokenizer(*val, tokens);
        
        switch (tokens.size()) 
        {
            case 2 : // param/from/from
                first[tokens[0]] = tokens[1];
                last[tokens[0]] =  tokens[1];
                break;
            case 3 : // param/from/to
                first[tokens[0]] =  tokens[1];
                last[tokens[0]] = tokens[2];
                break;
            case 1  : // param = all    
    			break;
            default : 
                throw MagicsException( "Syntax not Valid!:" + *val);
        }
          
    }
    MagLog::debug() << "NetcdfInterpretor::setDimensions---> OK!" << "\n";
}
NetcdfInterpretor::~NetcdfInterpretor() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void NetcdfInterpretor::print(ostream& out)  const
{
	out << "NetcdfInterpretor[";
    NetcdfInterpretorAttributes::print(out);
	out << "]";
}
/*
 * return the missing value
 */
double NetcdfInterpretor::missing(Netcdf& netcdf) const
{
	double missing = netcdf.getAttribute(missing_attribute_, std::numeric_limits<double>::max());
	return missing;
}

void NetcdfInterpretor::getAttributes(Netcdf& nc,const string& varName,string& keys,string& values)
{
	try
	{	
		NetVariable var=nc.getVariable(varName);
		bool first=true;
		for(map<string, NetAttribute>::iterator it=var.attributes_.begin(); it != var.attributes_.end(); it++)
		{
			const char* val;
			string str;
			it->second.get(val);
			if(val) str=string(val);
		
			if(!first)
			{	
			  	keys+="/";
				values+="/";
			}
			first=false;
		
				keys+=it->first;
				values+=val;		
			}
	}
	catch ( ... ) {}
}


