
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsgramDecoderAttributes.h
    \\brief Definition of EpsgramDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "EpsgramDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



EpsgramDecoderWrapper::EpsgramDecoderWrapper(): epsgramdecoder_(new EpsgramDecoder())


{


	

}
EpsgramDecoderWrapper::EpsgramDecoderWrapper(EpsgramDecoder* epsgramdecoder): epsgramdecoder_(epsgramdecoder)
{

	
}

EpsgramDecoderWrapper::~EpsgramDecoderWrapper()
{

}

void EpsgramDecoderWrapper::set(const MagRequest& request)
{

	

	stringarray  title_value;
	for (int i = 0; i < request.countValues("EPS_TITLE"); i++)
		title_value.push_back((string)request("EPS_TITLE", i));
	if ( !title_value.empty() )
		epsgramdecoder_->title_ = title_value;
	if  (request.countValues("EPS_TYPE") ) {
		string type_value = request("EPS_TYPE");
		epsgramdecoder_->type_ = type_value;
		}
	if  (request.countValues("EPS_DATABASE") ) {
		string database_value = request("EPS_DATABASE");
		epsgramdecoder_->database_ = database_value;
		}
	if  (request.countValues("EPS_TITLE_TEXT") ) {
		string title_text_value = request("EPS_TITLE_TEXT");
		epsgramdecoder_->title_text_ = title_text_value;
		}
	if  (request.countValues("EPS_PARAMETER") ) {
		string param_value = request("EPS_PARAMETER");
		epsgramdecoder_->param_ = param_value;
		}
	if  (request.countValues("EPS_PARAMETER_TITLE") ) {
		string param_title_value = request("EPS_PARAMETER_TITLE");
		epsgramdecoder_->param_title_ = param_title_value;
		}
	if  (request.countValues("EPS_LATITUDE") ) {
		double latitude_value = request("EPS_LATITUDE");
		epsgramdecoder_->latitude_ = latitude_value;
		}
	if  (request.countValues("EPS_LONGITUDE") ) {
		double longitude_value = request("EPS_LONGITUDE");
		epsgramdecoder_->longitude_ = longitude_value;
		}
	if  (request.countValues("EPS_PARAMETER_HOUR_SHIFT") ) {
		double param_hour_shift_value = request("EPS_PARAMETER_HOUR_SHIFT");
		epsgramdecoder_->param_hour_shift_ = param_hour_shift_value;
		}
	if  (request.countValues("EPS_PARAMETER_SCALING_FACTOR") ) {
		double param_scaling_factor_value = request("EPS_PARAMETER_SCALING_FACTOR");
		epsgramdecoder_->param_scaling_factor_ = param_scaling_factor_value;
		}
	if  (request.countValues("EPS_PARAMETER_OFFSET_FACTOR") ) {
		double param_offset_factor_value = request("EPS_PARAMETER_OFFSET_FACTOR");
		epsgramdecoder_->param_offset_factor_ = param_offset_factor_value;
		}
	if  (request.countValues("EPS_DATE") ) {
		string date_value = request("EPS_DATE");
		epsgramdecoder_->date_ = date_value;
		}
	if  (request.countValues("EPS_TIME") ) {
		string time_value = request("EPS_TIME");
		epsgramdecoder_->time_ = time_value;
		}
	if  (request.countValues("EPS_LONG_TITLE") ) {
		string long_title_value = request("EPS_LONG_TITLE");
		
		epsgramdecoder_->long_title_ = MagTranslator<string, bool>()(long_title_value);
		
		}
	if  (request.countValues("EPS_LONG_TITLE_STATION") ) {
		string long_title_station_value = request("EPS_LONG_TITLE_STATION");
		
		epsgramdecoder_->long_title_station_ = MagTranslator<string, bool>()(long_title_station_value);
		
		}
	if  (request.countValues("EPS_LONG_TITLE_HEIGHT") ) {
		string long_title_height_value = request("EPS_LONG_TITLE_HEIGHT");
		
		epsgramdecoder_->long_title_height_ = MagTranslator<string, bool>()(long_title_height_value);
		
		}
	if  (request.countValues("EPS_LONG_TITLE_POINT") ) {
		string long_title_point_value = request("EPS_LONG_TITLE_POINT");
		
		epsgramdecoder_->long_title_point_ = MagTranslator<string, bool>()(long_title_point_value);
		
		}
	if  (request.countValues("EPS_STATION_NAME") ) {
		string station_value = request("EPS_STATION_NAME");
		epsgramdecoder_->station_ = station_value;
		}
	if  (request.countValues("EPS_STATION_HEIGHT") ) {
		double height_value = request("EPS_STATION_HEIGHT");
		epsgramdecoder_->height_ = height_value;
		}
	if  (request.countValues("EPS_TEMPERATURE_CORRECTION") ) {
		string correction_value = request("EPS_TEMPERATURE_CORRECTION");
		
		epsgramdecoder_->correction_ = MagTranslator<string, bool>()(correction_value);
		
		}
	if  (request.countValues("EPS_Y_AXIS_PERCENTILE") ) {
		double percentile_value = request("EPS_Y_AXIS_PERCENTILE");
		epsgramdecoder_->percentile_ = percentile_value;
		}
	if  (request.countValues("EPS_Y_AXIS_THRESHOLD") ) {
		double threshold_value = request("EPS_Y_AXIS_THRESHOLD");
		epsgramdecoder_->threshold_ = threshold_value;
		}
	
	
}

void EpsgramDecoderWrapper::print(ostream& out)  const
{
	out << "EpsgramDecoderWrapper[]";
}


