/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include "mn-sylpheed-mailbox-backend.h"

#include "mn-sylpheed-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 41 "src/mn-sylpheed-mailbox-backend.gob"

#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"
#include "mn-sylpheed-message.h"

/* taken from defs.h in the Sylpheed sources */
#define SYLPHEED_MARK_VERSION		2

/* taken from defs.h in the Claws Mail sources */
#define CLAWS_MAIL_CACHE_FILE		".sylpheed_claws_cache"

#line 47 "mn-sylpheed-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_SYLPHEED_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMailboxBackend Self;
typedef MNSylpheedMailboxBackendClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-sylpheed-mailbox-backend.gob"
static void mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o);
#line 64 "mn-sylpheed-mailbox-backend.c"
#line 66 "src/mn-sylpheed-mailbox-backend.gob"
static void mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class);
#line 67 "mn-sylpheed-mailbox-backend.c"
#line 71 "src/mn-sylpheed-mailbox-backend.gob"
static void ___2_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type);
#line 70 "mn-sylpheed-mailbox-backend.c"
#line 98 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean ___3_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox);
#line 73 "mn-sylpheed-mailbox-backend.c"
#line 113 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_is_claws_mail_mailbox (MNSylpheedMailboxBackend * self);
#line 76 "mn-sylpheed-mailbox-backend.c"
#line 127 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_has_sylpheed_locking (void);
#line 79 "mn-sylpheed-mailbox-backend.c"
#line 150 "src/mn-sylpheed-mailbox-backend.gob"
static void mn_sylpheed_mailbox_backend_update_check_latency (MNSylpheedMailboxBackend * self);
#line 82 "mn-sylpheed-mailbox-backend.c"
#line 186 "src/mn-sylpheed-mailbox-backend.gob"
static void ___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend, int check_id);
#line 85 "mn-sylpheed-mailbox-backend.c"
#line 332 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err);
#line 88 "mn-sylpheed-mailbox-backend.c"
#line 378 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err);
#line 91 "mn-sylpheed-mailbox-backend.c"
#line 400 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err);
#line 94 "mn-sylpheed-mailbox-backend.c"
#line 426 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean mn_sylpheed_mailbox_backend_byte_stream_read (ByteStream * stream, gpointer buf, int size, GError ** err);
#line 97 "mn-sylpheed-mailbox-backend.c"
#line 492 "src/mn-sylpheed-mailbox-backend.gob"
static void mn_sylpheed_mailbox_backend_write_marks_foreach_cb (gpointer key, gpointer value, gpointer data);
#line 100 "mn-sylpheed-mailbox-backend.c"

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_is_claws_mail_mailbox mn_sylpheed_mailbox_backend_is_claws_mail_mailbox
#define self_has_sylpheed_locking mn_sylpheed_mailbox_backend_has_sylpheed_locking
#define self_update_check_latency mn_sylpheed_mailbox_backend_update_check_latency
#define self_read_local_mark_file mn_sylpheed_mailbox_backend_read_local_mark_file
#define self_read_remote_mark_file mn_sylpheed_mailbox_backend_read_remote_mark_file
#define self_read_mark_file mn_sylpheed_mailbox_backend_read_mark_file
#define self_byte_stream_read mn_sylpheed_mailbox_backend_byte_stream_read
#define self_read_marks mn_sylpheed_mailbox_backend_read_marks
#define self_write_marks_foreach_cb mn_sylpheed_mailbox_backend_write_marks_foreach_cb
#define self_write_marks mn_sylpheed_mailbox_backend_write_marks
GType
mn_sylpheed_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNSylpheedMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMailboxBackend *)g_object_new(mn_sylpheed_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMailboxBackend *)g_object_new_valist (mn_sylpheed_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::init"
}
#undef __GOB_FUNCTION__
#line 66 "src/mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class G_GNUC_UNUSED)
{
#line 168 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::class_init"
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 71 "src/mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___2_mn_sylpheed_mailbox_backend_monitor_cb;
#line 98 "src/mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___3_mn_sylpheed_mailbox_backend_is;
#line 186 "src/mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___7_mn_sylpheed_mailbox_backend_check;
#line 180 "mn-sylpheed-mailbox-backend.c"
 {
#line 67 "src/mn-sylpheed-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Sylpheed";
  
#line 186 "mn-sylpheed-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 71 "src/mn-sylpheed-mailbox-backend.gob"
static void 
___2_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 196 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_cb"
{
#line 75 "src/mn-sylpheed-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;

	filename = mn_vfs_uri_extract_short_name(info_uri);
	if (filename)
	  {
	    /*
	     * The status of the mailbox can only have changed if the
	     * subject of the event is the mark file or a message file
	     * (having a numbered filename).
	     */
	    if (! strcmp(filename, SYLPHEED_MARK_FILE) || mn_str_isnumeric(filename))
	      mn_vfs_mailbox_backend_queue_check(backend);

	    g_free(filename);
	  }
      }
  }}
#line 226 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 98 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
___3_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox)
#line 233 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___class,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___class,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is"
{
#line 102 "src/mn-sylpheed-mailbox-backend.gob"
	
    gboolean is;
    GnomeVFSURI *uri;

    uri = gnome_vfs_uri_append_file_name(mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    is = mn_vfs_test(uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(uri);

    return is;
  }}
#line 252 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 113 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_is_claws_mail_mailbox (MNSylpheedMailboxBackend * self)
{
#line 260 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is_claws_mail_mailbox"
#line 113 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 113 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self), (gboolean )0);
#line 266 "mn-sylpheed-mailbox-backend.c"
{
#line 115 "src/mn-sylpheed-mailbox-backend.gob"
	
    gboolean is;
    GnomeVFSURI *uri;

    uri = gnome_vfs_uri_append_file_name(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri, CLAWS_MAIL_CACHE_FILE);
    is = mn_vfs_test(uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(uri);

    return is;
  }}
#line 279 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 127 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_has_sylpheed_locking (void)
{
#line 286 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::has_sylpheed_locking"
{
#line 129 "src/mn-sylpheed-mailbox-backend.gob"
	
    static gboolean checked = FALSE;
    static gboolean has = FALSE;

    if (! checked)
      {
	char *output;

	if (g_spawn_command_line_sync("sylpheed --version", &output, NULL, NULL, NULL))
	  {
	    if (strstr(output, "+locking"))
	      has = TRUE;
	    g_free(output);
	  }

	checked = TRUE;
      }

    return has;
  }}
#line 310 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 150 "src/mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_update_check_latency (MNSylpheedMailboxBackend * self)
{
#line 317 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::update_check_latency"
#line 150 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (self != NULL);
#line 150 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self));
#line 323 "mn-sylpheed-mailbox-backend.c"
{
#line 152 "src/mn-sylpheed-mailbox-backend.gob"
	
    MNVFSMailboxBackend *backend = MN_VFS_MAILBOX_BACKEND(self);

    mn_vfs_mailbox_lock(backend->mailbox);

    /*
     * If it is a Claws Mail mailbox, the check_latency can be set to
     * 0, since Claws Mail does not write the mark file in place but
     * uses an atomic rename() to move the new mark file over the
     * previous one.
     */
    if (self_is_claws_mail_mailbox(self))
      backend->check_latency = 0;
    else
      {
	/*
	 * If Sylpheed was compiled with the locking patch and the
	 * mailbox is local, check_latency can be set to 0, since we
	 * lock the mark file while reading it.
	 */
	if (self_has_sylpheed_locking() && gnome_vfs_uri_is_local(backend->mailbox->vfs_uri))
	  backend->check_latency = 0;
	else
	  /*
	   * Otherwise, set check_latency to 3 seconds to avoid race
	   * conditions that can occur when Sylpheed writes the mark
	   * file while we read it.
	   */
	  backend->check_latency = 3000;
      }

    mn_vfs_mailbox_unlock(backend->mailbox);
  }}
#line 359 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 186 "src/mn-sylpheed-mailbox-backend.gob"
static void 
___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, int check_id)
#line 365 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::check"
{
#line 188 "src/mn-sylpheed-mailbox-backend.gob"
	
    GError *err = NULL;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    GHashTable *marks;
    GSList *messages = NULL;
    int num_errors = 0;

    self_update_check_latency(SELF(backend));

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_DIRECTORY);

    marks = self_read_marks(backend->mailbox->vfs_uri, &err);
    if (! marks)
      {
	if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to read %s: %s"), SYLPHEED_MARK_FILE, err->message);

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }

	g_error_free(err);
	return;
      }

    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      goto finish;

    result = gnome_vfs_directory_open_from_uri(&handle, backend->mailbox->vfs_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder: %s"), gnome_vfs_result_to_string(result));

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }

	goto end;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (mn_str_isnumeric(file_info->name))
	{
	  guint32 num = atoi(file_info->name);
	  guint32 sflags;
	  gboolean has_mark;
	  gpointer value;

	  has_mark = g_hash_table_lookup_extended(marks, GUINT_TO_POINTER(num), NULL, &value);
	  if (has_mark)
	    sflags = GPOINTER_TO_UINT(value);

	  if (! has_mark || (sflags & (SYLPHEED_MSG_NEW | SYLPHEED_MSG_UNREAD)) != 0)
	    {
	      MNMessageFlags flags = 0;
	      MNVFSMessage *message;

	      if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
		break;

	      if (! has_mark || (sflags & SYLPHEED_MSG_NEW) != 0)
		flags |= MN_MESSAGE_NEW;

	      /*
	       * We set handle_status to FALSE, since Sylpheed has its
	       * own way (mark file) of differencing seen/unseen
	       * messages.
	       */
	      message = mn_vfs_message_new(MN_TYPE_SYLPHEED_MESSAGE,
					   backend,
					   NULL,
					   backend->mailbox->vfs_uri,
					   file_info->name,
					   flags,
					   FALSE,
					   &err);
	      if (message)
		messages = g_slist_prepend(messages, message);
	      else if (err)
		{
		  GnomeVFSURI *message_uri;
		  char *message_text_uri;

		  message_uri = gnome_vfs_uri_append_file_name(backend->mailbox->vfs_uri, file_info->name);
		  message_text_uri = gnome_vfs_uri_to_string(message_uri, GNOME_VFS_URI_HIDE_PASSWORD);
		  gnome_vfs_uri_unref(message_uri);

		  mn_mailbox_warning(MN_MAILBOX(backend->mailbox), "cannot read message \"%s\": %s",
				     message_text_uri, err->message);
		  g_free(message_text_uri);
		  g_clear_error(&err);

		  num_errors++;
		}
	    }
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

  finish:
    GDK_THREADS_ENTER();

    if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      {
		mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);

		if (num_errors != 0)
		  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox),
				       ngettext("cannot read %i message",
						"cannot read %i messages",
						num_errors),
				       num_errors);
	      }
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder: %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder: %s"), gnome_vfs_result_to_string(result));
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    g_hash_table_destroy(marks);
  }}
#line 516 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 332 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err)
{
#line 524 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_local_mark_file"
#line 332 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (filename != NULL, (gboolean )0);
#line 332 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 332 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 532 "mn-sylpheed-mailbox-backend.c"
{
#line 337 "src/mn-sylpheed-mailbox-backend.gob"
	
    int fd;
    struct flock lock;
    GIOChannel *channel;
    GError *tmp_err = NULL;
    gboolean status = FALSE;

    fd = open(filename, O_RDONLY);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    memset(&lock, 0, sizeof(lock));
    lock.l_start = 0;		/* from l_whence */
    lock.l_len = 0;		/* to end of file */
    lock.l_type = F_RDLCK;	/* read lock */
    lock.l_whence = SEEK_SET;	/* from start of file */

    /* ignore lock failures */
    fcntl(fd, F_SETLKW, &lock);

    channel = g_io_channel_unix_new(fd);
    if (g_io_channel_set_encoding(channel, NULL, &tmp_err) == G_IO_STATUS_NORMAL)
      {
	if (g_io_channel_read_to_end(channel, contents, size, err) == G_IO_STATUS_NORMAL)
	  status = TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, _("unable to set encoding: %s"), tmp_err->message);
	g_error_free(tmp_err);
      }

    g_io_channel_shutdown(channel, FALSE, NULL);
    g_io_channel_unref(channel);

    return status;
  }}
#line 575 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 378 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err)
{
#line 582 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_remote_mark_file"
#line 378 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 378 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 378 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 590 "mn-sylpheed-mailbox-backend.c"
{
#line 383 "src/mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSResult result;
    int _size;

    result = mn_vfs_read_entire_file_uri(uri, &_size, contents);
    if (result == GNOME_VFS_OK)
      {
	*size = _size;
	return TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "%s", gnome_vfs_result_to_string(result));
	return FALSE;
      }
  }}
#line 609 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 400 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err)
{
#line 616 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_mark_file"
#line 400 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 400 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 400 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 624 "mn-sylpheed-mailbox-backend.c"
{
#line 405 "src/mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    char *filename;
    gboolean status;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);

    filename = mn_vfs_get_local_path(markfile_uri);
    if (filename)
      {
	status = self_read_local_mark_file(filename, size, contents, err);
	g_free(filename);
      }
    else
      status = self_read_remote_mark_file(markfile_uri, size, contents, err);

    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 647 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 426 "src/mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_byte_stream_read (ByteStream * stream, gpointer buf, int size, GError ** err)
{
#line 654 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::byte_stream_read"
#line 426 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (stream != NULL, (gboolean )0);
#line 426 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (buf != NULL, (gboolean )0);
#line 660 "mn-sylpheed-mailbox-backend.c"
{
#line 431 "src/mn-sylpheed-mailbox-backend.gob"
	
    if (stream->bytes_left >= size)
      {
	memcpy(buf, stream->position, size);

	stream->position += size;
	stream->bytes_left -= size;

	return TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, _("unexpected end of file"));
	return FALSE;
      }
  }}
#line 679 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 448 "src/mn-sylpheed-mailbox-backend.gob"
GHashTable * 
mn_sylpheed_mailbox_backend_read_marks (GnomeVFSURI * mailbox_uri, GError ** err)
{
#line 686 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_marks"
#line 448 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (GHashTable * )0);
#line 690 "mn-sylpheed-mailbox-backend.c"
{
#line 450 "src/mn-sylpheed-mailbox-backend.gob"
	
    GHashTable *marks = NULL;
    gsize bytes_left;
    char *buf;

    if (self_read_mark_file(mailbox_uri, &bytes_left, &buf, err))
      {
	ByteStream stream = { buf, bytes_left };
	guint32 version;

	if (self_byte_stream_read(&stream, &version, sizeof(version), err))
	  {
	    if (version == SYLPHEED_MARK_VERSION)
	      {
		guint32 num;

		marks = g_hash_table_new(g_direct_hash, g_direct_equal);

		while (self_byte_stream_read(&stream, &num, sizeof(num), NULL))
		  {
		    guint32 flags;

		    if (! self_byte_stream_read(&stream, &flags, sizeof(flags), err))
		      {
			g_hash_table_destroy(marks);
			marks = NULL;
			break;
		      }

		    g_hash_table_insert(marks, GUINT_TO_POINTER(num), GUINT_TO_POINTER(flags));
		  }
	      }
	    else
	      g_set_error(err, 0, 0, _("incompatible file version \"%i\""), version);
	  }

	g_free(buf);
      }

    return marks;
  }}
#line 734 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 492 "src/mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_write_marks_foreach_cb (gpointer key, gpointer value, gpointer data)
{
#line 741 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::write_marks_foreach_cb"
{
#line 494 "src/mn-sylpheed-mailbox-backend.gob"
	
    GByteArray *array = data;
    guint32 num;
    guint32 flags;

    num = GPOINTER_TO_UINT(key);
    flags = GPOINTER_TO_UINT(value);

    g_byte_array_append(array, (const guint8 *) &num, sizeof(num));
    g_byte_array_append(array, (const guint8 *) &flags, sizeof(flags));
  }}
#line 756 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 507 "src/mn-sylpheed-mailbox-backend.gob"
gboolean 
mn_sylpheed_mailbox_backend_write_marks (GnomeVFSURI * mailbox_uri, GHashTable * marks, GError ** err)
{
#line 763 "mn-sylpheed-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::write_marks"
#line 507 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 507 "src/mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (marks != NULL, (gboolean )0);
#line 769 "mn-sylpheed-mailbox-backend.c"
{
#line 511 "src/mn-sylpheed-mailbox-backend.gob"
	
    GByteArray *data;
    guint32 version;
    GnomeVFSURI *markfile_uri;
    gboolean status;

    /*
     * We do not need to lock the mark file: races with Sylpheed are
     * avoided since mn_vfs_write_entire_file_uri_safe() writes the
     * file atomically (with a move).
     *
     * However, only one thread at once can write a given mark file,
     * since mn_vfs_write_entire_file_uri_safe() is not thread-safe
     * (it uses fixed temporary file names, foo.tmp and foo.old).
     */

    data = g_byte_array_new();

    version = SYLPHEED_MARK_VERSION;
    g_byte_array_append(data, (const guint8 *) &version, sizeof(version));

    g_hash_table_foreach(marks, self_write_marks_foreach_cb, data);

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);
    /* Sylpheed uses S_IRUSR | S_IWUSR for data files */
    status = mn_vfs_write_entire_file_uri_safe(markfile_uri, data->len, data->data, S_IRUSR | S_IWUSR, err);
    gnome_vfs_uri_unref(markfile_uri);

    g_byte_array_free(data, TRUE);

    return status;
  }}
#line 804 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
