// license:BSD-3-Clause
// copyright-holders:Ryan Holtz
/*
 * nld_DM9334.h
 *
 *  DM9334: 8-Bit Addressable Latch
 *
 *          +--------------+
 *       A0 |1     ++    16| VCC
 *       A1 |2           15| /C
 *       A2 |3           14| /E
 *       Q0 |4   DM9334  13| D
 *       Q1 |5           12| Q7
 *       Q2 |6           11| Q6
 *       Q3 |7           10| Q5
 *      GND |8            9| Q4
 *          +--------------+
 *
 *          +---+---++---++---+---+---++---+---+---+---+---+---+---+---+
 *          | C | E || D || A0| A1| A2|| Q0| Q1| Q2| Q3| Q4| Q5| Q6| Q7|
 *          +===+===++===++===+===+===++===+===+===+===+===+===+===+===+
 *          | 1 | 0 || X || X | X | X || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          +---+---++---++---+---+---++---+---+---+---+---+---+---+---+
 *          | 1 | 1 || 0 || 0 | 0 | 0 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 0 | 0 | 0 || 1 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 0 || 0 | 0 | 1 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 0 | 0 | 1 || 0 | 1 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 0 || 0 | 1 | 0 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 0 | 1 | 0 || 0 | 0 | 1 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 0 || 0 | 1 | 1 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 0 | 1 | 1 || 0 | 0 | 0 | 1 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 0 || 1 | 0 | 0 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 1 | 0 | 0 || 0 | 0 | 0 | 0 | 1 | 0 | 0 | 0 |
 *          | 1 | 1 || 0 || 1 | 0 | 1 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 1 | 0 | 1 || 0 | 0 | 0 | 0 | 0 | 1 | 0 | 0 |
 *          | 1 | 1 || 0 || 1 | 1 | 0 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 1 | 1 | 0 || 0 | 0 | 0 | 0 | 0 | 0 | 1 | 0 |
 *          | 1 | 1 || 0 || 1 | 1 | 1 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
 *          | 1 | 1 || 1 || 1 | 1 | 1 || 0 | 0 | 0 | 0 | 0 | 0 | 0 | 1 |
 *          +---+---++---++---+---+---++---+---+---+---+---+---+---+---+
 *          | 0 | 0 || X || X | X | X || P | P | P | P | P | P | P | P |
 *          +---+---++---++---+---+---++---+---+---+---+---+---+---+---+
 *          | 0 | 1 || 0 || 0 | 0 | 0 || 0 | P | P | P | P | P | P | P |
 *          | 0 | 1 || 1 || 0 | 0 | 0 || 1 | P | P | P | P | P | P | P |
 *          | 0 | 1 || 0 || 0 | 0 | 1 || P | 0 | P | P | P | P | P | P |
 *          | 0 | 1 || 1 || 0 | 0 | 1 || P | 1 | P | P | P | P | P | P |
 *          | 0 | 1 || 0 || 0 | 1 | 0 || P | P | 0 | P | P | P | P | P |
 *          | 0 | 1 || 1 || 0 | 1 | 0 || P | P | 1 | P | P | P | P | P |
 *          | 0 | 1 || 0 || 0 | 1 | 1 || P | P | P | 0 | P | P | P | P |
 *          | 0 | 1 || 1 || 0 | 1 | 1 || P | P | P | 1 | P | P | P | P |
 *          | 0 | 1 || 0 || 1 | 0 | 0 || P | P | P | P | 0 | P | P | P |
 *          | 0 | 1 || 1 || 1 | 0 | 0 || P | P | P | P | 1 | P | P | P |
 *          | 0 | 1 || 0 || 1 | 0 | 1 || P | P | P | P | P | 0 | P | P |
 *          | 0 | 1 || 1 || 1 | 0 | 1 || P | P | P | P | P | 1 | P | P |
 *          | 0 | 1 || 0 || 1 | 1 | 0 || P | P | P | P | P | P | 0 | P |
 *          | 0 | 1 || 1 || 1 | 1 | 0 || P | P | P | P | P | P | 1 | P |
 *          | 0 | 1 || 0 || 1 | 1 | 1 || P | P | P | P | P | P | P | 0 |
 *          | 0 | 1 || 1 || 1 | 1 | 1 || P | P | P | P | P | P | P | 1 |
 *          +---+---++---++---+---+---++---+---+---+---+---+---+---+---+
 *
 *  Naming convention attempts to follow Texas Instruments / National Semiconductor datasheet Literature Number SNOS382A
 *
 */

#ifndef NLD_DM9334_H_
#define NLD_DM9334_H_

#include "../nl_setup.h"

#define TTL_9334(name, cCQ, cEQ, cD, cA0, cA1, cA2) \
		NET_REGISTER_DEV(TTL_9334, name)    \
		NET_CONNECT(name, CQ,  cCQ) \
		NET_CONNECT(name, EQ,  cEQ) \
		NET_CONNECT(name, D,  cD)   \
		NET_CONNECT(name, A0, cA0)  \
		NET_CONNECT(name, A1, cA1)  \
		NET_CONNECT(name, A2, cA2)

#define TTL_9334_DIP(name)                                                     \
		NET_REGISTER_DEV(TTL_9334_DIP, name)

#endif /* NLD_DM9334_H_ */
