# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class OutlineFilter(PolyDataAlgorithm):
    r"""
    OutlineFilter - create wireframe outline for an arbitrary data set
    or composite dataset
    
    Superclass: PolyDataAlgorithm
    
    OutlineFilter is a filter that generates a wireframe outline of
    any dataset or composite dataset. An outline consists of the twelve
    edges of the dataset bounding box. An option exists for generating
    faces instead of a wireframe outline.
    
    @warning
    When an input composite dataset is provided, options exist for
    producing different styles of outline(s). Also, if the composite
    dataset has non-geometric members (like tables) the result is
    unpredictable.
    
    @warning
    Specialized versions of the outline filter are also available. For
    example see StructuredGridOutlineFilter,
    RectilinearGridOutlineFilter, and ImageDataOutlineFilter.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOutlineFilter, obj, update, **traits)
    
    generate_faces = tvtk_base.false_bool_trait(desc=\
        r"""
        Generate solid faces for the box. This is off by default.
        """
    )

    def _generate_faces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateFaces,
                        self.generate_faces_)

    composite_style = tvtk_base.RevPrefixMap({'root_and_leafs': 2, 'leafs': 1, 'root': 0, 'specified_index': 3}, default_value='root_and_leafs', desc=\
        r"""
        Specify a style for creating bounding boxes around input
        composite datasets. (If the filter input is a DataSet type
        these options have no effect.) There are four choices: 1) place a
        bounding box around the root of the CompositeDataSet (i.e.,
        all of the data); 2) place separate bounding boxes around each
        DataSet leaf of the composite dataset; 3) place a bounding box
        around the root and all dataset leaves; and 4) place a bounding
        box around each (flat) index of the composite dataset. The
        default behavior is both root and leafs.
        """
    )

    def _composite_style_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeStyle,
                        self.composite_style_)

    output_points_precision = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points.
        Algorithm::SINGLE_PRECISION - Output single-precision floating
        point. Algorithm::DOUBLE_PRECISION - Output double-precision
        floating point.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_index(self, *args):
        """
        add_index(self, index:int) -> None
        C++: void add_index(unsigned int index)
        If the composite style is set to specified_index, then one or more
        flat indices can be specified, and bounding boxes will be drawn
        around those pieces of the composite dataset. (Recall that the
        flat index is a non-negative integer, with root index=0,
        increasing in perorder (depth-first) traversal order.
        """
        ret = self._wrap_call(self._vtk_obj.AddIndex, *args)
        return ret

    def remove_all_indices(self):
        """
        remove_all_indices(self) -> None
        C++: void remove_all_indices()"""
        ret = self._vtk_obj.RemoveAllIndices()
        return ret
        

    def remove_index(self, *args):
        """
        remove_index(self, index:int) -> None
        C++: void remove_index(unsigned int index)"""
        ret = self._wrap_call(self._vtk_obj.RemoveIndex, *args)
        return ret

    _updateable_traits_ = \
    (('generate_faces', 'GetGenerateFaces'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('composite_style', 'GetCompositeStyle'),
    ('output_points_precision', 'GetOutputPointsPrecision'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_faces',
    'global_warning_display', 'release_data_flag', 'composite_style',
    'object_name', 'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OutlineFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OutlineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_faces'], ['composite_style'], ['object_name',
            'output_points_precision']),
            title='Edit OutlineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OutlineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

