# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class MultiProcessController(Object):
    r"""
    MultiProcessController - Multiprocessing communication superclass
    
    Superclass: Object
    
    MultiProcessController is used to control multiple processes in a
    distributed computing environment. It has methods for executing
    single/multiple method(s) on multiple processors, triggering
    registered callbacks (Remote Methods) (add_rmi(), trigger_rmi()) and
    communication. Please note that the communication is done using the
    communicator which is accessible to the user. Therefore it is
    possible to get the communicator with get_communicator() and use it to
    send and receive data. This is the encouraged communication method.
    The internal (RMI) communications are done using a second internal
    communicator (called RMICommunicator).
    
    There are two modes for RMI communication: (1) Send/Receive mode and
    (2) Broadcast (collective) mode. The Send/Receive mode arranges
    processes in a binary tree using post-order traversal and propagates
    the RMI trigger starting from the root (rank 0) to the children. It
    is commonly employed to communicate between client/server over TCP.
    Although, the Send/Receive mode can be employed transparently over
    TCP or MPI, it is not optimal for triggering the RMIs on the
    satellite ranks. The Broadcast mode provides a more desirable
    alternative, namely, it uses MPI_Broadcast for communication, which
    is the nominal way of achieving this in an MPI context. The
    underlying communication mode used for triggering RMIs is controlled
    by the "broadcast_trigger_rmi" variable. Note, that mixing between the
    two modes for RMI communication is not correct behavior. All
    processes within the MultiProcessController must use the same mode
    for triggering RMI.
    
    @sa
    MPIController Communicator MPICommunicator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMultiProcessController, obj, update, **traits)
    
    broadcast_trigger_rmi = tvtk_base.false_bool_trait(desc=\
        r"""
        Setting this flag to 1 will cause the trigger_rmi_on_all_children to
        use a collective broadcast operation to communicate the RMI tag
        to the satellites.
        """
    )

    def _broadcast_trigger_rmi_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBroadcastTriggerRMI,
                        self.broadcast_trigger_rmi_)

    break_flag = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Setting this flag to 1 will cause the process_rm_is loop to return.
        This also causes UpStreamPorts to return from their
        wait_for_update loops.
        """
    )

    def _break_flag_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBreakFlag,
                        self.break_flag)

    def _get_global_controller(self):
        return wrap_vtk(self._vtk_obj.GetGlobalController())
    def _set_global_controller(self, arg):
        old_val = self._get_global_controller()
        self._wrap_call(self._vtk_obj.SetGlobalController,
                        deref_vtk(arg))
        self.trait_property_changed('global_controller', old_val, arg)
    global_controller = traits.Property(_get_global_controller, _set_global_controller, desc=\
        r"""
        This convenience method returns the controller associated with
        the local process.  It returns nullptr until the processes are
        spawned. It is better if you hang on to the controller passed as
        an argument to the single_method or multiple_method functions.
        """
    )

    number_of_processes = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of processes you will be using.  This defaults to
        the maximum number available.  If you set this to a value higher
        than the default, you will get an error.
        """
    )

    def _number_of_processes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfProcesses,
                        self.number_of_processes)

    def _get_break_rmi_tag(self):
        return self._vtk_obj.GetBreakRMITag()
    break_rmi_tag = traits.Property(_get_break_rmi_tag, desc=\
        r"""
        Accessor to some default tags.
        """
    )

    def _get_communicator(self):
        return wrap_vtk(self._vtk_obj.GetCommunicator())
    communicator = traits.Property(_get_communicator, desc=\
        r"""
        Returns the communicator associated with this controller. A
        default communicator is created in constructor.
        """
    )

    def _get_count(self):
        return self._vtk_obj.GetCount()
    count = traits.Property(_get_count, desc=\
        r"""
        Returns the number of words received by the most recent
        Receive(). Note that this is not the number of bytes received,
        but the number of items of the data-type received by the most
        recent Receive() eg. if Receive(int*,..) was used, then this
        returns the number of ints received; if Receive(double*,..) was
        used, then this returns the number of doubles received etc. The
        return value is valid only after a successful Receive().
        """
    )

    def _get_local_process_id(self):
        return self._vtk_obj.GetLocalProcessId()
    local_process_id = traits.Property(_get_local_process_id, desc=\
        r"""
        Tells you which process [0, num_process) you are in.
        """
    )

    def _get_rmi_arg_tag(self):
        return self._vtk_obj.GetRMIArgTag()
    rmi_arg_tag = traits.Property(_get_rmi_arg_tag, desc=\
        r"""
        
        """
    )

    def _get_rmi_tag(self):
        return self._vtk_obj.GetRMITag()
    rmi_tag = traits.Property(_get_rmi_tag, desc=\
        r"""
        
        """
    )

    def all_gather(self, *args):
        """
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const int *sendBuffer, int *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const long *sendBuffer, long *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:str, recvBuffer:str, length:int) -> int
        C++: int all_gather(const char *sendBuffer, char *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int) -> int
        C++: int all_gather(const double *sendBuffer, double *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const long long *sendBuffer,
            long long *recvBuffer, IdType length)
        all_gather(self, sendBuffer:DataArray, recvBuffer:DataArray)
            -> int
        C++: int all_gather(DataArray *sendBuffer,
            DataArray *recvBuffer)
        all_gather(self, sendBuffer:DataObject,
            recvBuffer:[DataObject, ...]) -> int
        C++: int all_gather(DataObject *sendBuffer,
            std::vector<SmartPointer<vtkDataObject> > &recvBuffer)
        Same as gather except that the result ends up on all processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int'), ('string', 'string', 'int'), (('float', Ellipsis), 'tuple', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int'), ('vtkDataArray', 'vtkDataArray'), ('vtkDataObject', ['vtkDataObject', Ellipsis])])
        ret = self._wrap_call(self._vtk_obj.AllGather, *my_args)
        return ret

    def all_gather_v(self, *args):
        """
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const int *sendBuffer, int *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const long *sendBuffer, long *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:str, recvBuffer:str, sendLength:int,
            recvLengths:[int, ...], offsets:[int, ...]) -> int
        C++: int all_gather_v(const char *sendBuffer, char *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
             sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const double *sendBuffer, double *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const long long *sendBuffer,
            long long *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets)
        all_gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray,
             recvLengths:[int, ...], offsets:[int, ...]) -> int
        C++: int all_gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray)
             -> int
        C++: int all_gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer)
        Same as GatherV except that the result is placed in all
        processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), ('string', 'string', 'int', ['int', Ellipsis], ['int', Ellipsis]), (('float', Ellipsis), 'tuple', 'int', ['int', Ellipsis], ['int', Ellipsis]), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), ('vtkDataArray', 'vtkDataArray', ['int', Ellipsis], ['int', Ellipsis]), ('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.AllGatherV, *my_args)
        return ret

    def all_reduce(self, *args):
        """
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const int *sendBuffer, int *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const long *sendBuffer, long *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:str, recvBuffer:str, length:int,
            operation:int) -> int
        C++: int all_reduce(const char *sendBuffer, char *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const double *sendBuffer, double *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int operation)
        all_reduce(self, sendBuffer:DataArray, recvBuffer:DataArray,
            operation:int) -> int
        C++: int all_reduce(DataArray *sendBuffer,
            DataArray *recvBuffer, int operation)
        all_reduce(self, sendBuffer:BoundingBox,
            recvBuffer:BoundingBox) -> int
        C++: int all_reduce(const BoundingBox &sendBuffer,
            BoundingBox &recvBuffer)
        all_reduce(self, sendBuffer:DataArraySelection,
            recvBuffer:DataArraySelection) -> int
        C++: int all_reduce(DataArraySelection *sendBuffer,
            DataArraySelection *recvBuffer)
        Same as Reduce except that the result is placed in all of the
        processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int'), ('vtkBoundingBox', 'vtkBoundingBox'), ('vtkDataArraySelection', 'vtkDataArraySelection')])
        ret = self._wrap_call(self._vtk_obj.AllReduce, *my_args)
        return ret

    def barrier(self):
        """
        barrier(self) -> None
        C++: void barrier()
        This method can be used to synchronize processes.
        """
        ret = self._vtk_obj.Barrier()
        return ret
        

    def broadcast(self, *args):
        """
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(int *data, IdType length, int srcProcessId)
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(long *data, IdType length, int srcProcessId)
        broadcast(self, data:str, length:int, srcProcessId:int) -> int
        C++: int broadcast(char *data, IdType length, int srcProcessId)
        broadcast(self, data:[float, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(double *data, IdType length,
            int srcProcessId)
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(long long *data, IdType length,
            int srcProcessId)
        broadcast(self, data:DataObject, srcProcessId:int) -> int
        C++: int broadcast(DataObject *data, int srcProcessId)
        broadcast(self, data:DataArray, srcProcessId:int) -> int
        C++: int broadcast(DataArray *data, int srcProcessId)
        broadcast(self, stream:MultiProcessStream, srcProcessId:int)
            -> int
        C++: int broadcast(MultiProcessStream &stream,
            int srcProcessId)
        Broadcast sends the array in the process with id srcprocess_id to
        all of the other processes.  All processes must call these method
        with the same arguments in order for it to complete.
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'int', 'int'), (['int', Ellipsis], 'int', 'int'), ('string', 'int', 'int'), ('tuple', 'int', 'int'), (['int', Ellipsis], 'int', 'int'), ('vtkDataObject', 'int'), ('vtkDataArray', 'int'), ('vtkMultiProcessStream', 'int')])
        ret = self._wrap_call(self._vtk_obj.Broadcast, *my_args)
        return ret

    def broadcast_process_rm_is(self, *args):
        """
        broadcast_process_rm_is(self, reportErrors:int, dont_loop:int=0)
            -> int
        C++: int broadcast_process_rm_is(int reportErrors, int dont_loop=0)"""
        ret = self._wrap_call(self._vtk_obj.BroadcastProcessRMIs, *args)
        return ret

    def broadcast_trigger_rmi_on_all_children(self, *args):
        """
        broadcast_trigger_rmi_on_all_children(self, arg:Pointer, argLength:int,
             tag:int) -> None
        C++: void broadcast_trigger_rmi_on_all_children(void *arg,
            int argLength, int tag)"""
        ret = self._wrap_call(self._vtk_obj.BroadcastTriggerRMIOnAllChildren, *args)
        return ret

    def create_output_window(self):
        """
        create_output_window(self) -> None
        C++: virtual void create_output_window()
        This method can be used to tell the controller to create a
        special output window in which all messages are preceded by the
        process id.
        """
        ret = self._vtk_obj.CreateOutputWindow()
        return ret
        

    def create_sub_controller(self, *args):
        """
        create_sub_controller(self, group:ProcessGroup)
            -> MultiProcessController
        C++: virtual MultiProcessController *create_sub_controller(
            ProcessGroup *group)
        Creates a new controller with the processes specified by the
        given group. The new controller will already be initialized for
        you.  You are responsible for deleting the controller once you
        are done.  It is invalid to pass this method a group with a
        different communicator than is used by this controller.  This
        operation is collective across all processes defined in the
        group.  It is undefined what will happen if the group is not the
        same on all processes.  This method must be called by all
        processes in the controller regardless of whether they are in the
        group.  nullptr is returned on all process not in the group.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CreateSubController, *my_args)
        return wrap_vtk(ret)

    def finalize(self, *args):
        """
        finalize(self) -> None
        C++: virtual void finalize()
        finalize(self, finalizedExternally:int) -> None
        C++: virtual void finalize(int finalizedExternally)
        This method is for cleaning up. If a subclass needs to clean up
        process communication (i.e. MPI) it would over ride this method.
        """
        ret = self._wrap_call(self._vtk_obj.Finalize, *args)
        return ret

    def gather(self, *args):
        """
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const int *sendBuffer, int *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const long *sendBuffer, long *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:str, recvBuffer:str, length:int,
            destProcessId:int) -> int
        C++: int gather(const char *sendBuffer, char *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const double *sendBuffer, double *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int destProcessId)
        gather(self, sendBuffer:DataArray, recvBuffer:DataArray,
            destProcessId:int) -> int
        C++: int gather(DataArray *sendBuffer,
            DataArray *recvBuffer, int destProcessId)
        gather(self, sendBuffer:DataObject, recvBuffer:[DataObject,
            ...], destProcessId:int) -> int
        C++: int gather(DataObject *sendBuffer,
            std::vector<SmartPointer<vtkDataObject> > &recvBuffer,
            int destProcessId)
        Gather collects arrays in the process with id destprocess_id. 
        Each process (including the destination) sends the contents of
        its send buffer to the destination process.  The destination
        process receives the messages and stores them in rank order.  The
        length argument (which must be the same on all processes) is the
        length of the sendBuffers.  The recvBuffer (on the destination
        process) must be of length length*numProcesses.  Gather is the
        inverse operation of Scatter.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int'), ('vtkDataObject', ['vtkDataObject', Ellipsis], 'int')])
        ret = self._wrap_call(self._vtk_obj.Gather, *my_args)
        return ret

    def gather_v(self, *args):
        """
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const int *sendBuffer, int *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const long *sendBuffer, long *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:str, recvBuffer:str, sendLength:int,
            recvLengths:[int, ...], offsets:[int, ...], destProcessId:int)
             -> int
        C++: int gather_v(const char *sendBuffer, char *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const double *sendBuffer, double *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const long long *sendBuffer,
            long long *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray,
            recvLengths:[int, ...], offsets:[int, ...], destProcessId:int)
             -> int
        C++: int gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        GatherV is the vector variant of Gather.  It extends the
        functionality of Gather by allowing a varying count of data from
        each process. GatherV collects arrays in the  ...
         [Truncated]
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), ('string', 'string', 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('float', Ellipsis), 'tuple', 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), ('vtkDataArray', 'vtkDataArray', ['int', Ellipsis], ['int', Ellipsis], 'int')])
        ret = self._wrap_call(self._vtk_obj.GatherV, *my_args)
        return ret

    def multiple_method_execute(self):
        """
        multiple_method_execute(self) -> None
        C++: virtual void multiple_method_execute()
        Execute the multiple_methods (as define by calling
        set_multiple_method for each of the required
        this->number_of_processes methods) using this->number_of_processes
        processes.
        """
        ret = self._vtk_obj.MultipleMethodExecute()
        return ret
        

    def partition_controller(self, *args):
        """
        partition_controller(self, localColor:int, localKey:int)
            -> MultiProcessController
        C++: virtual MultiProcessController *partition_controller(
            int localColor, int localKey)
        Partitions this controller based on a coloring.  That is, each
        process passes in a color.  All processes with the same color are
        grouped into the same partition.  The processes are ordered by
        their self-assigned key. Lower keys have lower process ids.  Ties
        are broken by the current process ids.  (For example, if all the
        keys are 0, then the resulting processes will be ordered in the
        same way.)  This method returns a new controller to each process
        that represents the local partition.  This is basically the same
        operation as MPI_Comm_split.
        """
        ret = self._wrap_call(self._vtk_obj.PartitionController, *args)
        return wrap_vtk(ret)

    def process_rm_is(self, *args):
        """
        process_rm_is(self, reportErrors:int, dont_loop:int=0) -> int
        C++: int process_rm_is(int reportErrors, int dont_loop=0)
        process_rm_is(self) -> int
        C++: int process_rm_is()
        Calling this method gives control to the controller to start
        processing RMIs. Possible return values are: RMI_NO_ERROR,
        RMI_TAG_ERROR : rmi tag could not be received, RMI_ARG_ERROR :
        rmi arg could not be received. If reportErrors is false, no
        ErrorMacro is called. process_rm_is() calls process_rm_is(int)
        with reportErrors = 0. If dont_loop is 1, this call just process
        one RMI message and exits.
        """
        ret = self._wrap_call(self._vtk_obj.ProcessRMIs, *args)
        return ret

    def receive(self, *args):
        """
        receive(self, data:[int, ...], maxlength:int, remoteProcessId:int,
             tag:int) -> int
        C++: int receive(int *data, IdType maxlength,
            int remoteProcessId, int tag)
        receive(self, data:[int, ...], maxlength:int, remoteProcessId:int,
             tag:int) -> int
        C++: int receive(long *data, IdType maxlength,
            int remoteProcessId, int tag)
        receive(self, data:str, maxlength:int, remoteProcessId:int,
            tag:int) -> int
        C++: int receive(char *data, IdType maxlength,
            int remoteProcessId, int tag)
        receive(self, data:[float, ...], maxlength:int,
            remoteProcessId:int, tag:int) -> int
        C++: int receive(double *data, IdType maxlength,
            int remoteProcessId, int tag)
        receive(self, data:[int, ...], maxLength:int, remoteProcessId:int,
             tag:int) -> int
        C++: int receive(long long *data, IdType maxLength,
            int remoteProcessId, int tag)
        receive(self, data:DataObject, remoteId:int, tag:int) -> int
        C++: int receive(DataObject *data, int remoteId, int tag)
        receive(self, data:DataArray, remoteId:int, tag:int) -> int
        C++: int receive(DataArray *data, int remoteId, int tag)
        receive(self, stream:MultiProcessStream, remoteId:int, tag:int)
             -> int
        C++: int receive(MultiProcessStream &stream, int remoteId,
            int tag)
        This method receives data from a corresponding send. It blocks
        until the receive is finished.  It calls methods in "data" to
        communicate the sending data. In the overrloads that take in a \\c
        maxlength argument, this length is the maximum length of the
        message to receive. If the maxlength is less than the length of
        the message sent by the sender, an error will be flagged. Once a
        message is received, use the get_count() method to determine the
        actual size of the data received.
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'int', 'int', 'int'), (['int', Ellipsis], 'int', 'int', 'int'), ('string', 'int', 'int', 'int'), ('tuple', 'int', 'int', 'int'), (['int', Ellipsis], 'int', 'int', 'int'), ('vtkDataObject', 'int', 'int'), ('vtkDataArray', 'int', 'int'), ('vtkMultiProcessStream', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.Receive, *my_args)
        return ret

    def receive_data_object(self, *args):
        """
        receive_data_object(self, remoteId:int, tag:int) -> DataObject
        C++: DataObject *receive_data_object(int remoteId, int tag)"""
        ret = self._wrap_call(self._vtk_obj.ReceiveDataObject, *args)
        return wrap_vtk(ret)

    def reduce(self, *args):
        """
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const int *sendBuffer, int *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const long *sendBuffer, long *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:str, recvBuffer:str, length:int,
            operation:int, destProcessId:int) -> int
        C++: int reduce(const char *sendBuffer, char *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const double *sendBuffer, double *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int operation,
            int destProcessId)
        reduce(self, sendBuffer:DataArray, recvBuffer:DataArray,
            operation:int, destProcessId:int) -> int
        C++: int reduce(DataArray *sendBuffer,
            DataArray *recvBuffer, int operation, int destProcessId)
        reduce(self, sendBuffer:BoundingBox, recvBuffer:BoundingBox,
             destProcessId:int) -> int
        C++: int reduce(const BoundingBox &sendBuffer,
            BoundingBox &recvBuffer, int destProcessId)
        reduce(self, sendBuffer:DataArraySelection,
            recvBuffer:DataArraySelection, destProcessId:int) -> int
        C++: int reduce(DataArraySelection *sendBuffer,
            DataArraySelection *recvBuffer, int destProcessId)
        Reduce an array to the given destination process.  This version
        of Reduce takes an identifier defined in the
        Communicator::StandardOperations enum to define the operation.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), ('string', 'string', 'int', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int', 'int'), ('vtkBoundingBox', 'vtkBoundingBox', 'int'), ('vtkDataArraySelection', 'vtkDataArraySelection', 'int')])
        ret = self._wrap_call(self._vtk_obj.Reduce, *my_args)
        return ret

    def remove_all_rmi_callbacks(self, *args):
        """
        remove_all_rmi_callbacks(self, tag:int) -> None
        C++: virtual void remove_all_rmi_callbacks(int tag)
        These methods are a part of the newer API to add multiple rmi
        callbacks. When the RMI is triggered, all the callbacks are
        called Removes all callbacks for the tag.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllRMICallbacks, *args)
        return ret

    def remove_first_rmi(self, *args):
        """
        remove_first_rmi(self, tag:int) -> int
        C++: virtual int remove_first_rmi(int tag)
        Remove the first RMI matching the tag.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveFirstRMI, *args)
        return ret

    def remove_rmi(self, *args):
        """
        remove_rmi(self, id:int) -> int
        C++: virtual int remove_rmi(unsigned long id)
        Remove the RMI matching the id. The id is the same id returned by
        add_rmi().
        """
        ret = self._wrap_call(self._vtk_obj.RemoveRMI, *args)
        return ret

    def remove_rmi_callback(self, *args):
        """
        remove_rmi_callback(self, id:int) -> bool
        C++: virtual bool remove_rmi_callback(unsigned long id)
        Remove a callback. Returns true is the remove was successful.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveRMICallback, *args)
        return ret

    def scatter(self, *args):
        """
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const int *sendBuffer, int *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const long *sendBuffer, long *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:str, recvBuffer:str, length:int,
            srcProcessId:int) -> int
        C++: int scatter(const char *sendBuffer, char *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const double *sendBuffer, double *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int srcProcessId)
        scatter(self, sendBuffer:DataArray, recvBuffer:DataArray,
            srcProcessId:int) -> int
        C++: int scatter(DataArray *sendBuffer,
            DataArray *recvBuffer, int srcProcessId)
        Scatter takes an array in the process with id srcprocess_id and
        distributes it.  Each process (including the source) receives a
        portion of the send buffer.  Process 0 receives the first length
        values, process 1 receives the second length values, and so on. 
        Scatter is the inverse operation of Gather.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.Scatter, *my_args)
        return ret

    def scatter_v(self, *args):
        """
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const int *sendBuffer, int *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const long *sendBuffer, long *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:str, recvBuffer:str, sendLengths:[int,
            ...], offsets:[int, ...], recvLength:int, srcProcessId:int)
            -> int
        C++: int scatter_v(const char *sendBuffer, char *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const double *sendBuffer, double *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const long long *sendBuffer,
            long long *recvBuffer, IdType *sendLengths,
            IdType *offsets, IdType recvLength, int srcProcessId)
        ScatterV is the vector variant of Scatter.  It extends the
        functionality of Scatter by allowing a varying count of data to
        each process. ScatterV takes an array in the process with id
        srcprocess_id and distributes it.  Each process (including the
        source) receives a portion of the send buffer defined by the
        sendLengths and offsets arrays.
        """
        ret = self._wrap_call(self._vtk_obj.ScatterV, *args)
        return ret

    def send(self, *args):
        """
        send(self, data:(int, ...), length:int, remoteProcessId:int,
            tag:int) -> int
        C++: int send(const int *data, IdType length,
            int remoteProcessId, int tag)
        send(self, data:(int, ...), length:int, remoteProcessId:int,
            tag:int) -> int
        C++: int send(const long *data, IdType length,
            int remoteProcessId, int tag)
        send(self, data:str, length:int, remoteProcessId:int, tag:int)
            -> int
        C++: int send(const char *data, IdType length,
            int remoteProcessId, int tag)
        send(self, data:(float, ...), length:int, remoteProcessId:int,
            tag:int) -> int
        C++: int send(const double *data, IdType length,
            int remoteProcessId, int tag)
        send(self, data:(int, ...), length:int, remoteProcessId:int,
            tag:int) -> int
        C++: int send(const long long *data, IdType length,
            int remoteProcessId, int tag)
        send(self, data:DataObject, remoteId:int, tag:int) -> int
        C++: int send(DataObject *data, int remoteId, int tag)
        send(self, data:DataArray, remoteId:int, tag:int) -> int
        C++: int send(DataArray *data, int remoteId, int tag)
        send(self, stream:MultiProcessStream, remoteId:int, tag:int)
            -> int
        C++: int send(const MultiProcessStream &stream, int remoteId,
            int tag)
        This method sends data to another process.  Tag eliminates
        ambiguity when multiple sends or receives exist in the same
        process. It is recommended to use custom tag number over 100.
        MultiProcessController has reserved tags between 1 and 4.
        Communicator has reserved tags between 10 and 16.
        """
        my_args = deref_array(args, [(('int', Ellipsis), 'int', 'int', 'int'), (('int', Ellipsis), 'int', 'int', 'int'), ('string', 'int', 'int', 'int'), ('tuple', 'int', 'int', 'int'), (('int', Ellipsis), 'int', 'int', 'int'), ('vtkDataObject', 'int', 'int'), ('vtkDataArray', 'int', 'int'), ('vtkMultiProcessStream', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.Send, *my_args)
        return ret

    def set_single_process_object(self, *args):
        """
        set_single_process_object(self, p:Process) -> None
        C++: void set_single_process_object(Process *p)
        Object-oriented flavor of set_single_method(). Instead of passing
        some function pointer and user data, a Process object is
        passed where the method to execute is Execute() and the data the
        object itself.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSingleProcessObject, *my_args)
        return ret

    def single_method_execute(self):
        """
        single_method_execute(self) -> None
        C++: virtual void single_method_execute()
        Execute the single_method (as define by set_single_method) using
        this->number_of_processes processes.  This will only return when
        all the processes finish executing their methods.
        """
        ret = self._vtk_obj.SingleMethodExecute()
        return ret
        

    def trigger_break_rm_is(self):
        """
        trigger_break_rm_is(self) -> None
        C++: void trigger_break_rm_is()
        A convenience method.  Called on process 0 to break "process_rm_is"
        loop on all other processes.
        """
        ret = self._vtk_obj.TriggerBreakRMIs()
        return ret
        

    def trigger_rmi(self, *args):
        """
        trigger_rmi(self, remoteProcessId:int, arg:Pointer, argLength:int,
            tag:int) -> None
        C++: void trigger_rmi(int remoteProcessId, void *arg,
            int argLength, int tag)
        trigger_rmi(self, remoteProcessId:int, arg:str, tag:int) -> None
        C++: void trigger_rmi(int remoteProcessId, const char *arg,
            int tag)
        trigger_rmi(self, remoteProcessId:int, tag:int) -> None
        C++: void trigger_rmi(int remoteProcessId, int tag)
        A method to trigger a method invocation in another process.
        """
        ret = self._wrap_call(self._vtk_obj.TriggerRMI, *args)
        return ret

    def trigger_rmi_on_all_children(self, *args):
        """
        trigger_rmi_on_all_children(self, arg:Pointer, argLength:int, tag:int)
             -> None
        C++: void trigger_rmi_on_all_children(void *arg, int argLength,
            int tag)
        trigger_rmi_on_all_children(self, arg:str, tag:int) -> None
        C++: void trigger_rmi_on_all_children(const char *arg, int tag)
        trigger_rmi_on_all_children(self, tag:int) -> None
        C++: void trigger_rmi_on_all_children(int tag)
        This is a convenicence method to trigger an RMI call on all the
        "children" of the current node. The children of the current node
        can be determined by drawing a binary tree starting at node 0 and
        then assigned nodes ids incrementally in a breadth-first fashion
        from left to right. This is designed to be used when trigger an
        RMI call on all satellites from the root node.
        """
        ret = self._wrap_call(self._vtk_obj.TriggerRMIOnAllChildren, *args)
        return ret

    _updateable_traits_ = \
    (('broadcast_trigger_rmi', 'GetBroadcastTriggerRMI'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('break_flag', 'GetBreakFlag'), ('number_of_processes',
    'GetNumberOfProcesses'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['broadcast_trigger_rmi', 'debug', 'global_warning_display',
    'break_flag', 'number_of_processes', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MultiProcessController, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MultiProcessController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['broadcast_trigger_rmi'], [], ['break_flag',
            'number_of_processes', 'object_name']),
            title='Edit MultiProcessController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MultiProcessController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

