# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class WebGLExporter(Object):
    r"""
    WebGLExporter - WebGLExporter export the data of the scene to
    be used in the web_gl.
    
    Superclass: Object
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWebGLExporter, obj, update, **traits)
    
    def _get_id(self):
        return self._vtk_obj.GetId()
    id = traits.Property(_get_id, desc=\
        r"""
        
        """
    )

    def _get_number_of_objects(self):
        return self._vtk_obj.GetNumberOfObjects()
    number_of_objects = traits.Property(_get_number_of_objects, desc=\
        r"""
        
        """
    )

    def get_web_gl_object(self, *args):
        """
        get_web_gl_object(self, index:int) -> WebGLObject
        C++: WebGLObject *get_web_gl_object(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetWebGLObject, *args)
        return wrap_vtk(ret)

    def compute_md5(self, *args):
        """
        compute_md5(content:(int, ...), size:int, hash:str) -> None
        C++: static void compute_md5(const unsigned char *content,
            int size, std::string &hash)"""
        ret = self._wrap_call(self._vtk_obj.ComputeMD5, *args)
        return ret

    def generate_metadata(self):
        """
        generate_metadata(self) -> str
        C++: const char *generate_metadata()"""
        ret = self._vtk_obj.GenerateMetadata()
        return ret
        

    def set_center_of_rotation(self, *args):
        """
        set_center_of_rotation(self, a1:float, a2:float, a3:float) -> None
        C++: void set_center_of_rotation(float a1, float a2, float a3)"""
        ret = self._wrap_call(self._vtk_obj.SetCenterOfRotation, *args)
        return ret

    def set_max_allowed_size(self, *args):
        """
        set_max_allowed_size(self, mesh:int, lines:int) -> None
        C++: void set_max_allowed_size(int mesh, int lines)
        set_max_allowed_size(self, size:int) -> None
        C++: void set_max_allowed_size(int size)"""
        ret = self._wrap_call(self._vtk_obj.SetMaxAllowedSize, *args)
        return ret

    def export_static_scene(self, *args):
        """
        export_static_scene(self, renderers:RendererCollection,
            width:int, height:int, path:str) -> None
        C++: void export_static_scene(RendererCollection *renderers,
            int width, int height, std::string path)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.exportStaticScene, *my_args)
        return ret

    def has_changed(self):
        """
        has_changed(self) -> bool
        C++: bool has_changed()"""
        ret = self._vtk_obj.hasChanged()
        return ret
        

    def parse_scene(self, *args):
        """
        parse_scene(self, renderers:RendererCollection, viewId:str,
            parseType:int) -> None
        C++: void parse_scene(RendererCollection *renderers,
            const char *viewId, int parseType)
        Get all the needed information from the Renderer
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.parseScene, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WebGLExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WebGLExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit WebGLExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WebGLExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

