<?php
/**
 * Internationalization file for the install/upgrade process. None of the
 * messages used here are loaded during normal operations, only during
 * install and upgrade. So you should not put normal messages here.
 *
 * @file
 * @ingroup Deployment
 */

$messages = array();

/** English */
$messages['en'] = array(
	'config-desc'                     => 'The installer for MediaWiki',
	'config-title'                    => 'MediaWiki $1 installation',
	'config-information'              => 'Information',
	'config-localsettings-upgrade'    => "A <code>LocalSettings.php</code> file has been detected.
To upgrade this installation, please enter the value of <code>\$wgUpgradeKey</code> in the box below.
You will find it in LocalSettings.php.",
	'config-localsettings-cli-upgrade'    => 'A LocalSettings.php file has been detected.
To upgrade this installation, please run update.php instead',
	'config-localsettings-key'        => 'Upgrade key:',
	'config-localsettings-badkey'     => 'The key you provided is incorrect.',
	'config-upgrade-key-missing'      => 'An existing installation of MediaWiki has been detected.
To upgrade this installation, please put the following line at the bottom of your LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'The existing LocalSettings.php appears to be incomplete.
The $1 variable is not set.
Please change LocalSettings.php so that this variable is set, and click "Continue".',
	'config-localsettings-connection-error' => 'An error was encountered when connecting to the database using the settings specified in LocalSettings.php or AdminSettings.php. Please fix these settings and try again.

$1',
	'config-session-error'            => 'Error starting session: $1',
	'config-session-expired'          => 'Your session data seems to have expired.
Sessions are configured for a lifetime of $1.
You can increase this by setting <code>session.gc_maxlifetime</code> in php.ini.
Restart the installation process.',
	'config-no-session'               => 'Your session data was lost!
Check your php.ini and make sure <code>session.save_path</code> is set to an appropriate directory.',
	'config-your-language'            => 'Your language:',
	'config-your-language-help'       => 'Select a language to use during the installation process.',
	'config-wiki-language'            => 'Wiki language:',
	'config-wiki-language-help'       => 'Select the language that the wiki will predominantly be written in.',
	'config-back'                     => '← Back',
	'config-continue'                 => 'Continue →',
	'config-page-language'            => 'Language',
	'config-page-welcome'             => 'Welcome to MediaWiki!',
	'config-page-dbconnect'           => 'Connect to database',
	'config-page-upgrade'             => 'Upgrade existing installation',
	'config-page-dbsettings'          => 'Database settings',
	'config-page-name'                => 'Name',
	'config-page-options'             => 'Options',
	'config-page-install'             => 'Install',
	'config-page-complete'            => 'Complete!',
	'config-page-restart'             => 'Restart installation',
	'config-page-readme'              => 'Read me',
	'config-page-releasenotes'        => 'Release notes',
	'config-page-copying'             => 'Copying',
	'config-page-upgradedoc'          => 'Upgrading',
	'config-page-existingwiki'        => 'Existing wiki',
	'config-help-restart'             => 'Do you want to clear all saved data that you have entered and restart the installation process?',
	'config-restart'                  => 'Yes, restart it',
	'config-welcome'                  => "=== Environmental checks ===
Basic checks are performed to see if this environment is suitable for MediaWiki installation.
You should provide the results of these checks if you need help during installation.",
	'config-copyright'                => "=== Copyright and Terms ===

$1

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but '''without any warranty'''; without even the implied warranty of '''merchantability''' or '''fitness for a particular purpose'''.
See the GNU General Public License for more details.

You should have received <doclink href=Copying>a copy of the GNU General Public License</doclink> along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. or [http://www.gnu.org/copyleft/gpl.html read it online].",
	'config-sidebar'                  => "* [//www.mediawiki.org MediaWiki home]
* [//www.mediawiki.org/wiki/Help:Contents User's Guide]
* [//www.mediawiki.org/wiki/Manual:Contents Administrator's Guide]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>Read me</doclink>
* <doclink href=ReleaseNotes>Release notes</doclink>
* <doclink href=Copying>Copying</doclink>
* <doclink href=UpgradeDoc>Upgrading</doclink>",
	'config-env-good'                 => 'The environment has been checked.
You can install MediaWiki.',
	'config-env-bad'                  => 'The environment has been checked.
You cannot install MediaWiki.',
	'config-env-php'                  => 'PHP $1 is installed.',
	'config-env-php-toolow'           => 'PHP $1 is installed.
However, MediaWiki requires PHP $2 or higher.',
	'config-unicode-using-utf8'       => 'Using Brion Vibber\'s utf8_normalize.so for Unicode normalization.',
	'config-unicode-using-intl'       => 'Using the [http://pecl.php.net/intl intl PECL extension] for Unicode normalization.',
	'config-unicode-pure-php-warning' => "'''Warning''': The [http://pecl.php.net/intl intl PECL extension] is not available to handle Unicode normalization, falling back to slow pure-PHP implementation.
If you run a high-traffic site, you should read a little on [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode normalization].",
	'config-unicode-update-warning'   => "'''Warning''': The installed version of the Unicode normalization wrapper uses an older version of [http://site.icu-project.org/ the ICU project's] library.
You should [//www.mediawiki.org/wiki/Unicode_normalization_considerations upgrade] if you are at all concerned about using Unicode.",
	'config-no-db'                    => 'Could not find a suitable database driver! You need to install a database driver for PHP.
The following database types are supported: $1.

If you are on shared hosting, ask your hosting provider to install a suitable database driver.
If you compiled PHP yourself, reconfigure it with a database client enabled, for example using <code>./configure --with-mysql</code>.
If you installed PHP from a Debian or Ubuntu package, then you also need install the php5-mysql module.',
	'config-outdated-sqlite'          => "'''Warning''': you have SQLite $1, which is lower than minimum required version $2. SQLite will be unavailable.",
	'config-no-fts3'                  => "'''Warning''': SQLite is compiled without the [//sqlite.org/fts3.html FTS3 module], search features will be unavailable on this backend.",
	'config-register-globals'         => "'''Warning: PHP's <code>[http://php.net/register_globals register_globals]</code> option is enabled.'''
'''Disable it if you can.'''
MediaWiki will work, but your server is exposed to potential security vulnerabilities.",
	'config-magic-quotes-runtime'     => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] is active!'''
This option corrupts data input unpredictably.
You cannot install or use MediaWiki unless this option is disabled.",
	'config-magic-quotes-sybase'      => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] is active!'''
This option corrupts data input unpredictably.
You cannot install or use MediaWiki unless this option is disabled.",
	'config-mbstring'                 => "'''Fatal: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] is active!'''
This option causes errors and may corrupt data unpredictably.
You cannot install or use MediaWiki unless this option is disabled.",
	'config-ze1'                      => "'''Fatal: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] is active!'''
This option causes horrible bugs with MediaWiki.
You cannot install or use MediaWiki unless this option is disabled.",
	'config-safe-mode'                => "'''Warning:''' PHP's [http://www.php.net/features.safe-mode safe mode] is active.
It may cause problems, particularly if using file uploads and <code>math</code> support.",
	'config-xml-bad'                  => "PHP's XML module is missing.
MediaWiki requires functions in this module and will not work in this configuration.
If you're running Mandrake, install the php-xml package.",
	'config-pcre'                     => 'The PCRE support module appears to be missing.
MediaWiki requires the Perl-compatible regular expression functions to work.',
	'config-pcre-no-utf8'             => "'''Fatal''': PHP's PCRE module seems to be compiled without PCRE_UTF8 support.
MediaWiki requires UTF-8 support to function correctly.",
	'config-memory-raised'            => "PHP's <code>memory_limit</code> is $1, raised to $2.",
	'config-memory-bad'               => "'''Warning:''' PHP's <code>memory_limit</code> is $1.
This is probably too low.
The installation may fail!",
	'config-ctype'                    => "'''Fatal''': PHP must be compiled with support for the [http://www.php.net/manual/en/ctype.installation.php Ctype extension].",
	'config-xcache'                   => '[http://xcache.lighttpd.net/ XCache] is installed',
	'config-apc'                      => '[http://www.php.net/apc APC] is installed',
	'config-wincache'                 => '[http://www.iis.net/download/WinCacheForPhp WinCache] is installed',
	'config-no-cache'                 => "'''Warning:''' Could not find [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] or [http://www.iis.net/download/WinCacheForPhp WinCache].
Object caching is not enabled.",
	'config-mod-security'             => "'''Warning''': Your web server has [http://modsecurity.org/ mod_security] enabled. If misconfigured, it can cause problems for MediaWiki or other software that allows users to post arbitrary content.
Refer to [http://modsecurity.org/documentation/ mod_security documentation] or contact your host's support if you encounter random errors.",
	'config-diff3-bad'                => 'GNU diff3 not found.',
	'config-imagemagick'              => 'Found ImageMagick: <code>$1</code>.
Image thumbnailing will be enabled if you enable uploads.',
	'config-gd'                       => 'Found GD graphics library built-in.
Image thumbnailing will be enabled if you enable uploads.',
	'config-no-scaling'               => 'Could not find GD library or ImageMagick.
Image thumbnailing will be disabled.',
	'config-no-uri'                   => "'''Error:''' Could not determine the current URI.
Installation aborted.",
	'config-no-cli-uri'               => "'''Warning''': No --scriptpath specified, using default: <code>$1</code>.",
	'config-using-server'             => 'Using server name "<nowiki>$1</nowiki>".',
	'config-using-uri'                => 'Using server URL "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe'         => "'''Warning:''' Your default directory for uploads <code>$1</code> is vulnerable to arbitrary scripts execution.
Although MediaWiki checks all uploaded files for security threats, it is highly recommended to [//www.mediawiki.org/wiki/Manual:Security#Upload_security close this security vulnerability] before enabling uploads.",
	'config-no-cli-uploads-check'     => "'''Warning:''' Your default directory for uploads (<code>$1</code>) is not checked for vulnerability
to arbitrary script execution during the CLI install.",
	'config-brokenlibxml'             => 'Your system has a combination of PHP and libxml2 versions which is buggy and can cause hidden data corruption in MediaWiki and other web applications.
Upgrade to PHP 5.2.9 or later and libxml2 2.7.3 or later ([//bugs.php.net/bug.php?id=45996 bug filed with PHP]).
Installation aborted.',
	'config-using531'                 => 'MediaWiki cannot be used with PHP $1 due to a bug involving reference parameters to <code>__call()</code>.
Upgrade to PHP 5.3.2 or higher, or downgrade to PHP 5.3.0 to resolve this.
Installation aborted.',
	'config-suhosin-max-value-length' => "Suhosin is installed and limits the GET parameter length to $1 bytes. MediaWiki's ResourceLoader component will work around this limit, but that will degrade performance. If at all possible, you should set suhosin.get.max_value_length to 1024 or higher in php.ini , and set \$wgResourceLoaderMaxQueryLength to the same value in LocalSettings.php .",
	'config-db-type'                  => 'Database type:',
	'config-db-host'                  => 'Database host:',
	'config-db-host-help'             => 'If your database server is on different server, enter the host name or IP address here.

If you are using shared web hosting, your hosting provider should give you the correct host name in their documentation.

If you are installing on a Windows server and using MySQL, using "localhost" may not work for the server name. If it does not, try "127.0.0.1" for the local IP address.

If you are using PostgreSQL, leave this field blank to connect via a Unix socket.',
	'config-db-host-oracle'           => 'Database TNS:',
	'config-db-host-oracle-help'      => 'Enter a valid [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm Local Connect Name]; a tnsnames.ora file must be visible to this installation.<br />If you are using client libraries 10g or newer you can also use the [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect] naming method.',
	'config-db-wiki-settings'         => 'Identify this wiki',
	'config-db-name'                  => 'Database name:',
	'config-db-name-help'             => 'Choose a name that identifies your wiki.
It should not contain spaces.

If you are using shared web hosting, your hosting provider will either give you a specific database name to use or let you create databases via a control panel.',
	'config-db-name-oracle'           => 'Database schema:',
	'config-db-account-oracle-warn' => "There are three supported scenarios for installing Oracle as database backend:

If you wish to create database account as part of the installation process, please supply an account with SYSDBA role as database account for installation and specify the desired credentials for the web-access account, otherwise you can either create the web-access account manually and supply only that account (if it has required permissions to create the schema objects) or supply two different accounts, one with create privileges and a restricted one for web access.

Script for creating an account with required privileges can be found in \"maintenance/oracle/\" directory of this installation. Keep in mind that using a restricted account will disable all maintenance capabilities with the default account.",
	'config-db-install-account'       => 'User account for installation',
	'config-db-username'              => 'Database username:',
	'config-db-password'              => 'Database password:',
	'config-db-password-empty'        => 'Please enter a password for the new database user: $1.
While it may be possible to create users with no passwords, it is not secure.',
	'config-db-install-username'	  => 'Enter the username that will be used to connect to the database during the installation process.
This is not the username of the MediaWiki account; this is the username for your database.',
	'config-db-install-password'	  => 'Enter the password that will be used to connect to the database during the installation process.
This is not the password for the MediaWiki account; this is the password for your database.',
	'config-db-install-help'          => 'Enter the username and password that will be used to connect to the database during the installation process.',
	'config-db-account-lock'          => 'Use the same username and password during normal operation',
	'config-db-wiki-account'          => 'User account for normal operation',
	'config-db-wiki-help'             => 'Enter the username and password that will be used to connect to the database during normal wiki operation.
If the account does not exist, and the installation account has sufficient privileges, this user account will be created with the minimum privileges required to operate the wiki.',
	'config-db-prefix'                => 'Database table prefix:',
	'config-db-prefix-help'           => 'If you need to share one database between multiple wikis, or between MediaWiki and another web application, you may choose to add a prefix to all the table names to avoid conflicts.
Do not use spaces.

This field is usually left empty.',
	'config-db-charset'               => 'Database character set',
	'config-charset-mysql5-binary'    => 'MySQL 4.1/5.0 binary',
	'config-charset-mysql5'           => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4'           => 'MySQL 4.0 backwards-compatible UTF-8',
	'config-charset-help'             => "'''Warning:''' If you use '''backwards-compatible UTF-8''' on MySQL 4.1+, and subsequently back up the database with <code>mysqldump</code>, it may destroy all non-ASCII characters, irreversibly corrupting your backups!

In '''binary mode''', MediaWiki stores UTF-8 text to the database in binary fields.
This is more efficient than MySQL's UTF-8 mode, and allows you to use the full range of Unicode characters.
In '''UTF-8 mode''', MySQL will know what character set your data is in, and can present and convert it appropriately,
but it will not let you store characters above the [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",
	'config-mysql-old'                => 'MySQL $1 or later is required, you have $2.',
	'config-db-port'                  => 'Database port:',
	'config-db-schema'                => 'Schema for MediaWiki:',
	'config-db-schema-help'           => 'This schema will usually be fine.
Only change it if you know you need to.',
	'config-pg-test-error'            => "Cannot connect to database '''$1''': $2",
	'config-sqlite-dir'               => 'SQLite data directory:',
	'config-sqlite-dir-help'          => "SQLite stores all data in a single file.

The directory you provide must be writable by the webserver during installation.

It should '''not''' be accessible via the web, this is why we're not putting it where your PHP files are.

The installer will write a <code>.htaccess</code> file along with it, but if that fails someone can gain access to your raw database.
That includes raw user data (e-mail addresses, hashed passwords) as well as deleted revisions and other restricted data on the wiki.

Consider putting the database somewhere else altogether, for example in <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts'            => 'Default tablespace:',
	'config-oracle-temp-ts'           => 'Temporary tablespace:',
	'config-type-mysql'               => 'MySQL',
	'config-type-postgres'            => 'PostgreSQL',
	'config-type-sqlite'              => 'SQLite',
	'config-type-oracle'              => 'Oracle',
	'config-type-ibm_db2'             => 'IBM DB2',
	'config-support-info'             => 'MediaWiki supports the following database systems:

$1

If you do not see the database system you are trying to use listed below, then follow the instructions linked above to enable support.',
	'config-support-mysql'            => '* $1 is the primary target for MediaWiki and is best supported ([http://www.php.net/manual/en/mysql.installation.php how to compile PHP with MySQL support])',
	'config-support-postgres'         => '* $1 is a popular open source database system as an alternative to MySQL ([http://www.php.net/manual/en/pgsql.installation.php how to compile PHP with PostgreSQL support]). There may be some minor outstanding bugs, and it is not recommended for use in a production environment.',
	'config-support-sqlite'           => '* $1 is a lightweight database system which is very well supported. ([http://www.php.net/manual/en/pdo.installation.php How to compile PHP with SQLite support], uses PDO)',
	'config-support-oracle'           => '* $1 is a commercial enterprise database. ([http://www.php.net/manual/en/oci8.installation.php How to compile PHP with OCI8 support])',
	'config-support-ibm_db2'          => '* $1 is a commercial enterprise database.',
	'config-header-mysql'             => 'MySQL settings',
	'config-header-postgres'          => 'PostgreSQL settings',
	'config-header-sqlite'            => 'SQLite settings',
	'config-header-oracle'            => 'Oracle settings',
	'config-header-ibm_db2'           => 'IBM DB2 settings',
	'config-invalid-db-type'          => 'Invalid database type',
	'config-missing-db-name'          => 'You must enter a value for "Database name"',
	'config-missing-db-host'          => 'You must enter a value for "Database host"',
	'config-missing-db-server-oracle' => 'You must enter a value for "Database TNS"',
	'config-invalid-db-server-oracle' => 'Invalid database TNS "$1".
Use only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_) and dots (.).',
	'config-invalid-db-name'          => 'Invalid database name "$1".
Use only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_) and hyphens (-).',
	'config-invalid-db-prefix'        => 'Invalid database prefix "$1".
Use only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_) and hyphens (-).',
	'config-connection-error'         => '$1.

Check the host, username and password and try again.',
	'config-invalid-schema'           => 'Invalid schema for MediaWiki "$1".
Use only ASCII letters (a-z, A-Z), numbers (0-9) and underscores (_).',
	'config-db-sys-create-oracle' => 'Installer only supports using a SYSDBA account for creating a new account.',
	'config-db-sys-user-exists-oracle' => 'User account "$1" already exists. SYSDBA can only be used for creating of a new account!',
	'config-postgres-old'             => 'PostgreSQL $1 or later is required, you have $2.',
	'config-sqlite-name-help'         => 'Choose a name that identifies your wiki.
Do not use spaces or hyphens.
This will be used for the SQLite data file name.',
	'config-sqlite-parent-unwritable-group' => 'Cannot create the data directory <code><nowiki>$1</nowiki></code>, because the parent directory <code><nowiki>$2</nowiki></code> is not writable by the webserver.

The installer has determined the user your webserver is running as.
Make the <code><nowiki>$3</nowiki></code> directory writable by it to continue.
On a Unix/Linux system do:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Cannot create the data directory <code><nowiki>$1</nowiki></code>, because the parent directory <code><nowiki>$2</nowiki></code> is not writable by the webserver.

The installer could not determine the user your webserver is running as.
Make the <code><nowiki>$3</nowiki></code> directory globally writable by it (and others!) to continue.
On a Unix/Linux system do:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error'       => 'Error creating the data directory "$1".
Check the location and try again.',
	'config-sqlite-dir-unwritable'    => 'Unable to write to the directory "$1".
Change its permissions so that the webserver can write to it, and try again.',
	'config-sqlite-connection-error'  => '$1.

Check the data directory and database name below and try again.',
	'config-sqlite-readonly'          => 'The file <code>$1</code> is not writeable.',
	'config-sqlite-cant-create-db'    => 'Could not create database file <code>$1</code>.',
	'config-sqlite-fts3-downgrade'    => 'PHP is missing FTS3 support, downgrading tables',
	'config-can-upgrade'              => "There are MediaWiki tables in this database.
To upgrade them to MediaWiki $1, click '''Continue'''.",
	'config-upgrade-done'             => "Upgrade complete.

You can now [$1 start using your wiki].

If you want to regenerate your <code>LocalSettings.php</code> file, click the button below.
This is '''not recommended''' unless you are having problems with your wiki.",
	'config-upgrade-done-no-regenerate' => "Upgrade complete.

You can now [$1 start using your wiki].",
	'config-regenerate'               => 'Regenerate LocalSettings.php →',
	'config-show-table-status'        => 'SHOW TABLE STATUS query failed!',
	'config-unknown-collation'        => "'''Warning:''' Database is using unrecognised collation.",
	'config-db-web-account'           => 'Database account for web access',
	'config-db-web-help'              => 'Select the username and password that the web server will use to connect to the database server, during ordinary operation of the wiki.',
	'config-db-web-account-same'      => 'Use the same account as for installation',
	'config-db-web-create'            => 'Create the account if it does not already exist',
	'config-db-web-no-create-privs'   => 'The account you specified for installation does not have enough privileges to create an account.
The account you specify here must already exist.',
	'config-mysql-engine'             => 'Storage engine:',
	'config-mysql-innodb'             => 'InnoDB',
	'config-mysql-myisam'             => 'MyISAM',
	'config-mysql-myisam-dep'         => "'''Warning''': You have selected MyISAM as storage engine for MySQL, which is not recommended for use with MediaWiki, because:
* it barely supports concurrency due to table locking
* it is more prone to corruption than other engines
* the MediaWiki codebase does not always handle MyISAM as it should

If your MySQL installation supports InnoDB, it is highly recommended that you choose that instead.
If your MySQL installation does not support InnoDB, maybe it's time for an upgrade.",
	'config-mysql-engine-help'        => "'''InnoDB''' is almost always the best option, since it has good concurrency support.

'''MyISAM''' may be faster in single-user or read-only installations.
MyISAM databases tend to get corrupted more often than InnoDB databases.",
	'config-mysql-charset'            => 'Database character set:',
	'config-mysql-binary'             => 'Binary',
	'config-mysql-utf8'               => 'UTF-8',
	'config-mysql-charset-help'       => "In '''binary mode''', MediaWiki stores UTF-8 text to the database in binary fields.
This is more efficient than MySQL's UTF-8 mode, and allows you to use the full range of Unicode characters.

In '''UTF-8 mode''', MySQL will know what character set your data is in, and can present and convert it appropriately, but it will not let you store characters above the [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",

	'config-ibm_db2-low-db-pagesize'  => "Your DB2 database has a default tablespace with an insufficient pagesize. The pagesize has to be '''32K''' or greater.",

	'config-site-name'                => 'Name of wiki:',
	'config-site-name-help'           => "This will appear in the title bar of the browser and in various other places.",
	'config-site-name-blank'          => 'Enter a site name.',
	'config-project-namespace'        => 'Project namespace:',
	'config-ns-generic'               => 'Project',
	'config-ns-site-name'             => 'Same as the wiki name: $1',
	'config-ns-other'                 => 'Other (specify)',
	'config-ns-other-default'         => 'MyWiki',
	'config-project-namespace-help'   => 'Following Wikipedia\'s example, many wikis keep their policy pages separate from their content pages, in a "\'\'\'project namespace\'\'\'".
All page titles in this namespace start with a certain prefix, which you can specify here.
Traditionally, this prefix is derived from the name of the wiki, but it cannot contain punctuation characters such as "#" or ":".',
	'config-ns-invalid'               => 'The specified namespace "<nowiki>$1</nowiki>" is invalid.
Specify a different project namespace.',
	'config-ns-conflict'               => 'The specified namespace "<nowiki>$1</nowiki>" conflicts with a default MediaWiki namespace.
Specify a different project namespace.',
	'config-admin-box'                => 'Administrator account',
	'config-admin-name'               => 'Your name:',
	'config-admin-password'           => 'Password:',
	'config-admin-password-confirm'   => 'Password again:',
	'config-admin-help'               => 'Enter your preferred username here, for example "Joe Bloggs".
This is the name you will use to log in to the wiki.',
	'config-admin-name-blank'         => 'Enter an administrator username.',
	'config-admin-name-invalid'       => 'The specified username "<nowiki>$1</nowiki>" is invalid.
Specify a different username.',
	'config-admin-password-blank'     => 'Enter a password for the administrator account.',
	'config-admin-password-same'      => 'The password must not be the same as the username.',
	'config-admin-password-mismatch'  => 'The two passwords you entered do not match.',
	'config-admin-email'              => 'E-mail address:',
	'config-admin-email-help'         => 'Enter an e-mail address here to allow you to receive e-mail from other users on the wiki, reset your password, and be notified of changes to pages on your watchlist. You can leave this field empty.',
	'config-admin-error-user'         => 'Internal error when creating an admin with the name "<nowiki>$1</nowiki>".',
	'config-admin-error-password'     => 'Internal error when setting a password for the admin "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail'     => 'You have entered an invalid e-mail address.',
	'config-subscribe'                => 'Subscribe to the [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce release announcements mailing list].',
	'config-subscribe-help'           => 'This is a low-volume mailing list used for release announcements, including important security announcements.
You should subscribe to it and update your MediaWiki installation when new versions come out.',
	'config-subscribe-noemail'        => 'You tried to subscribe to the release announcements mailing list without providing an e-mail address.
Please provide an e-mail address if you wish to subscribe to the mailing list.',
	'config-almost-done'              => 'You are almost done!
You can now skip the remaining configuration and install the wiki right now.',
	'config-optional-continue'        => 'Ask me more questions.',
	'config-optional-skip'            => "I'm bored already, just install the wiki.",
	'config-profile'                  => 'User rights profile:',
	'config-profile-wiki'             => 'Traditional wiki',
	'config-profile-no-anon'          => 'Account creation required',
	'config-profile-fishbowl'         => 'Authorized editors only',
	'config-profile-private'          => 'Private wiki',
	'config-profile-help'             => "Wikis work best when you let as many people edit them as possible.
In MediaWiki, it is easy to review the recent changes, and to revert any damage that is done by naive or malicious users.

However, many have found MediaWiki to be useful in a wide variety of roles, and sometimes it is not easy to convince everyone of the benefits of the wiki way.
So you have the choice.

A '''{{int:config-profile-wiki}}''' allows anyone to edit, without even logging in.
A wiki with '''{{int:config-profile-no-anon}}''' provides extra accountability, but may deter casual contributors.

The '''{{int:config-profile-fishbowl}}''' scenario allows approved users to edit, but the public can view the pages, including history.
A '''{{int:config-profile-private}}''' only allows approved users to view pages, with the same group allowed to edit.

More complex user rights configurations are available after installation, see the [//www.mediawiki.org/wiki/Manual:User_rights relevant manual entry].",
	'config-license'                  => 'Copyright and license:',
	'config-license-none'             => 'No license footer',
	'config-license-cc-by-sa'         => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by'            => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa'      => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0'             => 'Creative Commons Zero (Public Domain)',
	'config-license-gfdl'             => 'GNU Free Documentation License 1.3 or later',
	'config-license-pd'               => 'Public Domain',
	'config-license-cc-choose'        => 'Select a custom Creative Commons license',
	'config-license-help'             => "Many public wikis put all contributions under a [http://freedomdefined.org/Definition free license].
This helps to create a sense of community ownership and encourages long-term contribution.
It is not generally necessary for a private or corporate wiki.

If you want to be able to use text from Wikipedia, and you want Wikipedia to be able to accept text copied from your wiki, you should choose '''Creative Commons Attribution Share Alike'''.

Wikipedia previously used the GNU Free Documentation License.
The GFDL is a valid license, but it is difficult to understand.
It is also difficult to reuse content licensed under the GFDL.",
	'config-email-settings'           => 'E-mail settings',
	'config-enable-email'             => 'Enable outbound e-mail',
	'config-enable-email-help'        => "If you want e-mail to work, [http://www.php.net/manual/en/mail.configuration.php PHP's mail settings] need to be configured correctly.
If you do not want any e-mail features, you can disable them here.",
	'config-email-user'               => 'Enable user-to-user e-mail',
	'config-email-user-help'          => 'Allow all users to send each other e-mail if they have enabled it in their preferences.',
	'config-email-usertalk'           => 'Enable user talk page notification',
	'config-email-usertalk-help'      => 'Allow users to receive notifications on user talk page changes, if they have enabled it in their preferences.',
	'config-email-watchlist'          => 'Enable watchlist notification',
	'config-email-watchlist-help'     => 'Allow users to receive notifications about their watched pages if they have enabled it in their preferences.',
	'config-email-auth'               => 'Enable e-mail authentication',
	'config-email-auth-help'          => "If this option is enabled, users have to confirm their e-mail address using a link sent to them whenever they set or change it.
Only authenticated e-mail addresses can receive e-mails from other users or change notification e-mails.
Setting this option is '''recommended''' for public wikis because of potential abuse of the e-mail features.",
	'config-email-sender'             => 'Return e-mail address:',
	'config-email-sender-help'        => 'Enter the e-mail address to use as the return address on outbound e-mail.
This is where bounces will be sent.
Many mail servers require at least the domain name part to be valid.',
	'config-upload-settings'          => 'Images and file uploads',
	'config-upload-enable'            => 'Enable file uploads',
	'config-upload-help'              => "File uploads potentially expose your server to security risks.
For more information, read the [//www.mediawiki.org/wiki/Manual:Security security section] in the manual.

To enable file uploads, change the mode on the <code>images</code> subdirectory under MediaWiki's root directory so that the web server can write to it.
Then enable this option.",
	'config-upload-deleted'           => 'Directory for deleted files:',
	'config-upload-deleted-help'      => 'Choose a directory in which to archive deleted files.
Ideally, this should not be accessible from the web.',
	'config-logo'                     => 'Logo URL:',
	'config-logo-help'                => "MediaWiki's default skin includes space for a 135x160 pixel logo above the sidebar menu.
Upload an image of the appropriate size, and enter the URL here.

If you do not want a logo, leave this box blank.",
	'config-instantcommons'           => 'Enable Instant Commons',
	'config-instantcommons-help'      => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] is a feature that allows wikis to use images, sounds and other media found on the [//commons.wikimedia.org/ Wikimedia Commons] site.
In order to do this, MediaWiki requires access to the Internet.

For more information on this feature, including instructions on how to set it up for wikis other than the Wikimedia Commons, consult [//mediawiki.org/wiki/Manual:$wgForeignFileRepos the manual].',
	'config-cc-error'                 => 'The Creative Commons license chooser gave no result.
Enter the license name manually.',
	'config-cc-again'                 => 'Pick again...',
	'config-cc-not-chosen'            => 'Choose which Creative Commons license you want and click "proceed".',
	'config-advanced-settings'        => 'Advanced configuration',
	'config-cache-options'            => 'Settings for object caching:',
	'config-cache-help'               => 'Object caching is used to improve the speed of MediaWiki by caching frequently used data.
Medium to large sites are highly encouraged to enable this, and small sites will see benefits as well.',
	'config-cache-none'               => 'No caching (no functionality is removed, but speed may be impacted on larger wiki sites)',
	'config-cache-accel'              => 'PHP object caching (APC, XCache or WinCache)',
	'config-cache-memcached'          => 'Use Memcached (requires additional setup and configuration)',
	'config-memcached-servers'        => 'Memcached servers:',
	'config-memcached-help'           => 'List of IP addresses to use for Memcached.
Should specify one per line and specify the port to be used. For example:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers'     => 'You selected Memcached as your cache type but did not specify any servers.',
	'config-memcache-badip'           => 'You have entered an invalid IP address for Memcached: $1.',
	'config-memcache-noport'          => 'You did not specify a port to use for Memcached server: $1.
If you do not know the port, the default is 11211.',
	'config-memcache-badport'         => 'Memcached port numbers should be between $1 and $2.',
	'config-extensions'               => 'Extensions',
	'config-extensions-help'          => 'The extensions listed above were detected in your <code>./extensions</code> directory.

They may require additional configuration, but you can enable them now',
	'config-install-alreadydone'      => "'''Warning:''' You seem to have already installed MediaWiki and are trying to install it again.
Please proceed to the next page.",
	'config-install-begin'            => 'By pressing "{{int:config-continue}}", you will begin the installation of MediaWiki.
If you still want to make changes, press back.',
	'config-install-step-done'        => 'done',
	'config-install-step-failed'      => 'failed',
	'config-install-extensions'       => 'Including extensions',
	'config-install-database'         => 'Setting up database',
	'config-install-schema'           => 'Creating schema',
	'config-install-pg-schema-not-exist' => 'PostgreSQL schema does not exist.',
	'config-install-pg-schema-failed' => 'Tables creation failed.
Make sure that the user "$1" can write to the schema "$2".',
	'config-install-pg-commit'        => 'Committing changes',
	'config-install-pg-plpgsql'       => 'Checking for language PL/pgSQL',
	'config-pg-no-plpgsql'            => 'You need to install the language PL/pgSQL in the database $1',
	'config-pg-no-create-privs'       => 'The account you specified for installation does not have enough privileges to create an account.',
	'config-pg-not-in-role'           => 'The account you specified for the web user already exists.
The account you specified for installation is not a superuser and is not a member of the web user\'s role, so it is unable to create objects owned by the web user.

MediaWiki currently requires that the tables be owned by the web user. Please specify another web account name, or click "back" and specify a suitably privileged install user.',
	'config-install-user'             => 'Creating database user',
	'config-install-user-alreadyexists' => 'User "$1" already exists',
	'config-install-user-create-failed' => 'Creating user "$1" failed: $2',
	'config-install-user-grant-failed'  => 'Granting permission to user "$1" failed: $2',
	'config-install-user-missing'     => 'The specified user "$1" does not exist.',
	'config-install-user-missing-create' => 'The specified user "$1" does not exist.
Please click the "create account" checkbox below if you want to create it.',
	'config-install-tables'           => 'Creating tables',
	'config-install-tables-exist'     => "'''Warning''': MediaWiki tables seem to already exist.
Skipping creation.",
	'config-install-tables-failed'    => "'''Error''': Table creation failed with the following error: $1",
	'config-install-interwiki'        => 'Populating default interwiki table',
	'config-install-interwiki-list'   => 'Could not read file <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Warning''': The interwiki table seems to already have entries.
Skipping default list.",
	'config-install-stats'            => 'Initializing statistics',
	'config-install-keys'             => 'Generating secret keys',
	'config-insecure-keys'            => "'''Warning:''' {{PLURAL:$2|A secure key|Secure keys}} ($1) generated during installation {{PLURAL:$2|is|are}} not completely safe. Consider changing {{PLURAL:$2|it|them}} manually.",
	'config-install-sysop'            => 'Creating administrator user account',
	'config-install-subscribe-fail'   => 'Unable to subscribe to mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL is not installed and allow_url_fopen is not available.',
	'config-install-mainpage'         => 'Creating main page with default content',
	'config-install-extension-tables' => 'Creating tables for enabled extensions',
	'config-install-mainpage-failed'  => 'Could not insert main page: $1',
	'config-install-done'             => "'''Congratulations!'''
You have successfully installed MediaWiki.

The installer has generated a <code>LocalSettings.php</code> file.
It contains all your configuration.

You will need to download it and put it in the base of your wiki installation (the same directory as index.php). The download should have started automatically.

If the download was not offered, or if you cancelled it, you can restart the download by clicking the link below:

$3

'''Note''': If you do not do this now, this generated configuration file will not be available to you later if you exit the installation without downloading it.

When that has been done, you can '''[$2 enter your wiki]'''.",
	'config-download-localsettings' => 'Download LocalSettings.php',
	'config-help' => 'help',
	'mainpagetext'      => "'''MediaWiki has been successfully installed.'''",
	'mainpagedocfooter' => "Consult the [//meta.wikimedia.org/wiki/Help:Contents User's Guide] for information on using the wiki software.

== Getting started ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Message documentation (Message documentation)
 * @author Amire80
 * @author Dani
 * @author EugeneZelenko
 * @author Kghbln
 * @author McDutchie
 * @author Mormegil
 * @author Nemo bis
 * @author Nike
 * @author Platonides
 * @author Purodha
 * @author Raymond
 * @author SPQRobin
 * @author Shirayuki
 * @author Siebrand
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'config-desc' => '{{desc}}',
	'config-title' => 'Parameters:
* $1 is the version of MediaWiki that is being installed.',
	'config-information' => '{{Identical|Information}}',
	'config-localsettings-cli-upgrade' => 'Do not translate the <code>LocalSettings.php</code> and the <code>update.php</code> parts.',
	'config-session-error' => 'Parameters:
* $1 is the error that was encountered with the session.',
	'config-session-expired' => 'Parameters:
* $1 is the configured session lifetime.',
	'config-back' => '{{Identical|Back}}',
	'config-continue' => '{{Identical|Continue}}',
	'config-page-language' => '{{Identical|Language}}',
	'config-page-name' => '{{Identical|Name}}',
	'config-page-options' => '{{Identical|Options}}',
	'config-page-install' => '{{Identical|Install}}',
	'config-page-copying' => 'This is a link to the full GPL text',
	'config-restart' => 'Button text to confirm the installation procedure has to be restarted.',
	'config-sidebar' => 'Maximum width for words is 24 characters. Only visible part of the translation counts to this limit.',
	'config-env-php' => 'Parameters:
* $1 is the version of PHP that has been installed.',
	'config-unicode-pure-php-warning' => 'PECL is the name of a group producing standard pieces of software for PHP, and intl is the name of their library handling some aspects of internationalization.',
	'config-unicode-update-warning' => "ICU is a body producing standard software tools for support of Unicode and other internationalization aspects. This message warns the system administrator installing MediaWiki that the server's software is not up-to-date and MediaWiki will have problems handling some characters.",
	'config-no-db' => 'Do not translate: <code>./configure --with-mysql</code>.
<br />
Do not translate: <code>php5-mysql</code>.

Parameters:
* $1 is comma separated list of database types supported by MediaWiki.',
	'config-no-fts3' => 'A "[[:wikipedia:Front and back ends|backend]]" is a system or component that ordinary users don\'t interact with directly and don\'t need to know about, and that is responsible for a distinct task or service - for example, a storage back-end is a generic system for storing data which other applications can use. Possible alternatives for back-end are "system" or "service", or (depending on context and language) even leave it untranslated.',
	'config-pcre' => 'PCRE is an initialism for "Perl-compatible regular expression". Perl is programming language whose [[:w:regular expression|regular expression]] syntax is popular and used in other languages using a library called PCRE.',
	'config-pcre-no-utf8' => "PCRE is a name of a programmers' library for supporting regular expressions. It can probably be translated without change.",
	'config-memory-raised' => 'Parameters:
* $1 is the configured <code>memory_limit</code>.
* $2 is the value to which <code>memory_limit</code> was raised.',
	'config-memory-bad' => 'Parameters:
* $1 is the configured <code>memory_limit</code>.',
	'config-ctype' => 'Message if support for [http://www.php.net/manual/en/ctype.installation.php Ctype] is missing from PHP',
	'config-xcache' => 'Message indicates if this program is available',
	'config-apc' => 'Message indicates if this program is available',
	'config-wincache' => 'Message indicates if this program is available',
	'config-imagemagick' => '$1 is ImageMagick\'s <code>convert</code> executable file name.

Add dir="ltr" to the <nowiki><code></nowiki> for right-to-left languages.',
	'config-no-cli-uri' => 'Parameters:
* $1 is the default value for scriptpath.',
	'config-no-cli-uploads-check' => 'CLI = [[w:Command-line interface|command-line interface]] (i.e. the installer runs as a command-line script, not using HTML interface via an internet browser)',
	'config-suhosin-max-value-length' => 'Message shown when PHP parameter suhosin.get.max_value_length is between 0 and 1023 (that max value is hard set in MediaWiki software)',
	'config-db-host-oracle' => 'TNS = [[:wikipedia:Transparent Network Substrate|Transparent Network Substrate]] (<== wikipedia link)',
	'config-db-wiki-settings' => 'This is more acurate: "Enter identifying or distinguishing data for this wiki" since a MySQL database can host tables of several wikis.',
	'config-db-account-oracle-warn' => 'A "[[:wikipedia:Front and back ends|backend]]" is a system or component that ordinary users don\'t interact with directly and don\'t need to know about, and that is responsible for a distinct task or service - for example, a storage back-end is a generic system for storing data which other applications can use. Possible alternatives for back-end are "system" or "service", or (depending on context and language) even leave it untranslated.',
	'config-db-account-lock' => "It might be easier to translate ''normal operation'' as \"also after the installation process\"",
	'config-type-mysql' => '{{optional}}',
	'config-type-postgres' => '{{optional}}',
	'config-type-sqlite' => '{{optional}}',
	'config-type-oracle' => '{{optional}}',
	'config-support-info' => 'Parameters:
* $1 - a list of DBMSs that MediaWiki supports, composed with other config-type-* and config-support-* messages.',
	'config-support-mysql' => 'Parameters:
* $1 - a link to the MySQL home page having the anchor text "MySQL".',
	'config-support-postgres' => 'Parameters:
* $1 - a link to the PostgreSQL home page having the anchor text "PostgreSQL".',
	'config-support-sqlite' => 'Parameters:
* $1 - a link to the SQLite home page having the anchor text "SQLite".',
	'config-support-oracle' => 'Parameters:
* $1 - a link to the Oracle home page, the anchor text of which is "Oracle".',
	'config-connection-error' => '$1 is the external error from the database, such as "DB connection error: Access denied for user \'dba\'@\'localhost\' (using password: YES) (localhost)."

If you\'re translating this message to a right-to-left language, consider writing <nowiki><div dir="ltr">$1.</div></nowiki>. (When the bidi features for HTML5 will be implemented in the browsers, it will probably be a good idea to write it as <nowiki><div dir="auto">$1.</div></nowiki>.)',
	'config-invalid-schema' => '*$1 - schema name',
	'config-sqlite-dir-unwritable' => 'webserver refers to a software like Apache or Lighttpd.',
	'config-can-upgrade' => 'Parameters:
* $1 - Version or Revision indicator.',
	'config-show-table-status' => '{{doc-important|"SHOW TABLE STATUS" is a MySQL command. Do not translate this.}}',
	'config-db-web-account-same' => 'checkbox label',
	'config-db-web-create' => 'checkbox label',
	'config-ns-generic' => '{{Identical|Project}}',
	'config-admin-name' => '{{Identical|Your name}}',
	'config-admin-password' => '{{Identical|Password}}',
	'config-admin-email' => '{{Identical|E-mail address}}',
	'config-subscribe' => 'Used as label for the installer checkbox',
	'config-profile-help' => 'Messages referenced:
* {{msg-mw|config-profile-wiki}}
* {{msg-mw|config-profile-no-anon}}
* {{msg-mw|config-profile-fishbowl}}
* {{msg-mw|config-profile-private}}',
	'config-upload-help' => 'The word "mode" here refers to the access rights given to various user groups when attempting to create and store files and/or subdiretories in the said directory on the server. It also refers to the <code>mode</code> command used to maipulate said right mask under Unix, Linux, and similar operating systems. A less operating-system-centric translation is fine.',
	'config-logo-help' => '',
	'config-cc-not-chosen' => 'Do not translate the <code>"proceed".</code> part.
This message refers to a block of HTML being embedded into the installer page. It comes from the Creative Commons Web site. The block is in the English language. It is a scripted license chooser. When an individual license has been selected, it asks you to klick "proceed" so as to return to the MediaWiki installer page.',
	'config-extensions' => '{{Identical|Extension}}',
	'config-install-step-done' => '{{Identical|Done}}',
	'config-install-database' => '*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-schema' => '*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-pg-schema-failed' => 'Parameters:
* $1 = database user name (usernames in the database are unrelated to wiki user names)
* $2 =',
	'config-install-user' => 'Message indicates that the user is being created

See also:
*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-user-grant-failed' => 'Parameters:
* $1 is the database username for which granting rights failed
* $2 is the error message',
	'config-install-tables' => 'Message indicates that the tables are being created

See also:
*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-interwiki' => 'Message indicates that the interwikitables are being populated

See also:
*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-stats' => '*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-keys' => '*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-insecure-keys' => 'Parameters:
* $1 - A list of names of the secret keys that were generated.
* $2 - the number of items in the list $1, to be used with PLURAL.',
	'config-install-sysop' => 'Message indicates that the administrator user account is being created

See also:
*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-subscribe-fail' => '{{doc-important|"mediawiki-announce" is the name of a mailing list and should not be translated.}}',
	'config-install-mainpage' => '*{{msg-mw|Config-install-database}}
*{{msg-mw|Config-install-tables}}
*{{msg-mw|Config-install-schema}}
*{{msg-mw|Config-install-user}}
*{{msg-mw|Config-install-interwiki}}
*{{msg-mw|Config-install-stats}}
*{{msg-mw|Config-install-keys}}
*{{msg-mw|Config-install-sysop}}
*{{msg-mw|Config-install-mainpage}}',
	'config-install-done' => 'Parameters:
* $1 is the URL to LocalSettings download
* $2 is a link to the wiki.
* $3 is a download link with attached download icon. The config-download-localsettings message will be used as the link text.',
	'config-download-localsettings' => 'The link text used in the download link in config-install-done.',
	'config-help' => 'This is used in help boxes.
{{Identical|Help}}',
	'mainpagetext' => 'Along with {{msg|mainpagedocfooter}}, the text you will see on the Main Page when your wiki is installed.',
	'mainpagedocfooter' => 'Along with {{msg|mainpagetext}}, the text you will see on the Main Page when your wiki is installed.
This might be a good place to put information about <nowiki>{{GRAMMAR:}}</nowiki>. See [[{{NAMESPACE}}:{{BASEPAGENAME}}/fi]] for an example. For languages having grammatical distinctions and not having an appropriate <nowiki>{{GRAMMAR:}}</nowiki> software available, a suggestion to check and possibly amend the messages having <nowiki>{{SITENAME}}</nowiki> may be valuable. See [[{{NAMESPACE}}:{{BASEPAGENAME}}/ksh]] for an example.',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'config-desc' => 'Die Installasieprogram vir MediaWiki',
	'config-title' => 'Installasie MediaWiki $1',
	'config-information' => 'Inligting',
	'config-localsettings-key' => 'Opgradeer-sleutel:',
	'config-localsettings-badkey' => 'Die sleutel wat u verskaf het is verkeerd.',
	'config-session-error' => 'Fout met begin van sessie: $1',
	'config-no-session' => "U sessiedata is verlore!
Kontroleer u php.ini en maak seker dat <code>session.save_path</code> na 'n geldige gids wys.",
	'config-your-language' => 'U taal:',
	'config-your-language-help' => "Kies 'n taal om tydens die installasieproses te gebruik.",
	'config-wiki-language' => 'Wiki se taal:',
	'config-wiki-language-help' => 'Kies die taal waarin die wiki hoofsaaklik geskryf sal word.',
	'config-back' => '← Terug',
	'config-continue' => 'Gaan voort →',
	'config-page-language' => 'Taal',
	'config-page-welcome' => 'Welkom by MediaWiki!',
	'config-page-dbconnect' => 'Konnekteer na die databasis',
	'config-page-upgrade' => "Opgradeer 'n bestaande installasie",
	'config-page-dbsettings' => 'Databasis-instellings',
	'config-page-name' => 'Naam',
	'config-page-options' => 'Opsies',
	'config-page-install' => 'Installeer',
	'config-page-complete' => 'Voltooi!',
	'config-page-restart' => 'Herbegin installasie',
	'config-page-readme' => 'Lees my',
	'config-page-releasenotes' => 'Vrystellingsnotas',
	'config-page-copying' => 'Besig met kopiëring',
	'config-page-upgradedoc' => 'Besig met opgradering',
	'config-page-existingwiki' => 'Bestaande wiki',
	'config-restart' => 'Ja, herbegin dit',
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki tuisblad]
* [//www.mediawiki.org/wiki/Help:Contents Gebruikershandleiding] (Engelstalig)
* [//www.mediawiki.org/wiki/Manual:Contents Administrateurshandleiding] (Engelstalig)
* [//www.mediawiki.org/wiki/Manual:FAQ Algemene vrae] (Engelstalig)
----
* <doclink href=Readme>Lees my</doclink>
* <doclink href=ReleaseNotes>Vrystellingsnotas</doclink>
* <doclink href=Copying>Kopiëring</doclink>
* <doclink href=UpgradeDoc>Opgradering</doclink>',
	'config-env-good' => 'Die omgewing is gekontroleer.
U kan MediaWiki installeer.',
	'config-env-bad' => 'Die omgewing is gekontroleer.
U kan nie MediaWiki installeer nie.</span>',
	'config-env-php' => 'PHP $1 is tans geïnstalleer.',
	'config-no-db' => "Kon nie 'n geskikte databasisdrywer vind nie!", # Fuzzy
	'config-memory-raised' => 'PHP se <code>memory_limit</code> is $1, en is verhoog tot $2.',
	'config-memory-bad' => "'''Waarskuwing:''' PHP se <code>memory_limit</code> is $1.
Dit is waarskynlik te laag.
Die installasie mag moontlik faal!",
	'config-xcache' => '[Http://trac.lighttpd.net/xcache/ XCache] is geïnstalleer',
	'config-apc' => '[Http://www.php.net/apc APC] is geïnstalleer',
	'config-wincache' => '[Http://www.iis.net/download/WinCacheForPhp WinCache] is geïnstalleer',
	'config-diff3-bad' => 'GNU diff3 nie gevind nie.',
	'config-db-type' => 'Databasistipe:',
	'config-db-host' => 'Databasisbediener:',
	'config-db-host-oracle' => 'Databasis-TNS:',
	'config-db-wiki-settings' => 'Identifiseer hierdie wiki',
	'config-db-name' => 'Databasisnaam:',
	'config-db-name-oracle' => 'Databasis-skema:',
	'config-db-install-account' => 'Gebruiker vir die installasie',
	'config-db-username' => 'Databasis gebruikersnaam:',
	'config-db-password' => 'Databasis wagwoord:',
	'config-db-prefix' => 'Voorvoegsel vir databasistabelle:',
	'config-db-charset' => 'Karakterstelsel vir databasis',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binêr',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-mysql-old' => 'U moet MySQL $1 of later gebruik.
U gebruik tans $2.',
	'config-db-port' => 'Databasispoort:',
	'config-db-schema' => 'Skema vir MediaWiki',
	'config-sqlite-dir' => 'Gids vir SQLite se data:',
	'config-oracle-def-ts' => 'Standaard tabelruimte:',
	'config-oracle-temp-ts' => 'Tydelike tabelruimte:',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-header-mysql' => 'MySQL-instellings',
	'config-header-postgres' => 'PostgreSQL-instellings',
	'config-header-sqlite' => 'SQLite-instellings',
	'config-header-oracle' => 'Oracle-instellings',
	'config-header-ibm_db2' => 'Instellings vir IBM DB2',
	'config-invalid-db-type' => 'Ongeldige databasistipe',
	'config-missing-db-name' => 'U moet \'n waarde vir "Databasnaam" verskaf',
	'config-sqlite-readonly' => 'Die lêer <code>$1</code> kan nie geskryf word nie.',
	'config-sqlite-cant-create-db' => 'Kon nie databasislêer <code>$1</code> skep nie.',
	'config-upgrade-done-no-regenerate' => 'Opgradering is voltooi.

U kan nou [$1 u wiki gebruik].',
	'config-regenerate' => 'Herskep LocalSettings.php →',
	'config-show-table-status' => 'Die uitvoer van SHOW TABLE STATUS het gefaal!',
	'config-db-web-account' => 'Databasisgebruiker vir toegang tot die web',
	'config-mysql-engine' => 'Stoor-enjin:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Karakterstelsel vir databasis:',
	'config-mysql-binary' => 'Binêr',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Naam van die wiki:',
	'config-site-name-blank' => "Verskaf 'n naam vir u webwerf.",
	'config-project-namespace' => 'Projeknaamruimte:',
	'config-ns-generic' => 'Projek',
	'config-ns-site-name' => 'Dieselfde as die wiki: $1',
	'config-ns-other' => 'Ander (spesifiseer)',
	'config-ns-other-default' => 'MyWiki',
	'config-admin-box' => 'Administrateur se gebruiker',
	'config-admin-name' => 'U naam:',
	'config-admin-password' => 'Wagwoord:',
	'config-admin-password-confirm' => 'Wagwoord weer:',
	'config-admin-password-blank' => "Verskaf 'n wagwoord vir die administrateur in.",
	'config-admin-password-same' => 'Die wagwoord mag nie dieselfde as die gebruikersnaam wees nie.',
	'config-admin-password-mismatch' => 'Die twee wagwoorde wat u ingetik het stem nie ooreen nie.',
	'config-admin-email' => 'E-posadres:',
	'config-optional-continue' => 'Vra my meer vrae.',
	'config-optional-skip' => 'Ek is reeds verveeld, installeer maar net die wiki.',
	'config-profile-wiki' => 'Tradisionele wiki',
	'config-profile-no-anon' => 'Skep van gebruiker is verpligtend',
	'config-profile-fishbowl' => 'Slegs vir gemagtigde redaksie',
	'config-profile-private' => 'Privaat wiki',
	'config-license' => 'Kopiereg en lisensie:',
	'config-license-none' => 'Geen lisensie in die onderskrif',
	'config-license-pd' => 'Publieke Domein',
	'config-license-cc-choose' => "Kies 'n Creative Commons-lisensie",
	'config-email-settings' => 'E-posinstellings',
	'config-email-sender' => 'E-posadres vir antwoorde:',
	'config-upload-settings' => 'Oplaai van beelde en lêer',
	'config-upload-enable' => 'Aktiveer die oplaai van lêers',
	'config-upload-deleted' => 'Gids vir verwyderde lêers:',
	'config-logo' => 'URL vir logo:',
	'config-cc-again' => 'Kies weer...',
	'config-advanced-settings' => 'Gevorderde konfigurasie',
	'config-memcached-servers' => 'Memcached-bedieners:',
	'config-extensions' => 'Uitbreidings',
	'config-install-step-done' => 'gedoen',
	'config-install-step-failed' => 'het misluk',
	'config-install-extensions' => 'Insluitende uitbreidings',
	'config-install-database' => 'Stel die databasis op',
	'config-install-pg-schema-not-exist' => 'Die skema vir PostgreSQL bestaan ​​nie.',
	'config-install-pg-schema-failed' => 'Die skep van tabelle het gefaal.
Maak seker dat die gebruiker "$1" na skema "$2" mag skryf.',
	'config-install-pg-commit' => 'Wysigings word gestoor',
	'config-install-pg-plpgsql' => 'Kontroleer vir taal PL/pgSQL',
	'config-pg-no-plpgsql' => 'U moet die taal PL/pgSQL in die database $1 installeer',
	'config-install-user' => 'Besig om die databasisgebruiker te skep',
	'config-install-user-alreadyexists' => 'Gebruiker "$1" bestaan al reeds',
	'config-install-user-create-failed' => 'Skep van gebruiker "$1" het gefaal: $2',
	'config-install-user-grant-failed' => 'Die toekenning van regte aan gebruiker "$1" het gefaal: $2',
	'config-install-tables' => 'Skep tabelle',
	'config-install-tables-exist' => "'''Waarskuwing''': Dit lyk of MediaWiki se tabelle reeds bestaan.
Die skep van tabelle word oorgeslaan.",
	'config-install-tables-failed' => "'''Fout''': die skep van 'n tabel het gefaal met die volgende fout: $1",
	'config-install-interwiki' => 'Besig om data in die interwiki-tabel in te laai',
	'config-install-interwiki-list' => 'Kon nie die lêer <code>interwiki.list</code> vind nie.',
	'config-install-interwiki-exists' => "'''Waarskuwing''': Die interwiki-tabel bevat reeds inskrywings.
Die standaardlys word oorgeslaan.",
	'config-install-stats' => 'Inisialiseer statistieke',
	'config-install-keys' => 'Genereer geheime sleutel', # Fuzzy
	'config-install-sysop' => "Skep 'n gebruiker vir die administrateur",
	'config-install-subscribe-fail' => 'Kon nie vir MediaWiki-announce inskryf nie: $1',
	'config-install-mainpage' => 'Skep die hoofblad met standaard inhoud',
	'config-install-extension-tables' => 'Skep tabelle vir aangeskakel uitbreidings',
	'config-install-mainpage-failed' => 'Kon nie die hoofblad laai nie: $1',
	'config-install-done' => "'''Veels geluk!'''
U het MediaWiki suksesvol geïnstalleer.

Die installeerder het 'n <code>LocalSettings.php</code> lêer opgestel.
Dit bevat al u instellings.

U sal dit moet [$1 aflaai] en dit in die hoofgids van u wiki-installasie plaas; in dieselfde gids as index.php.
'''Let wel''': As u dit nie nou doen nie, sal die gegenereerde konfigurasielêer nie later meer beskikbaar wees nadat u die installasie afgesluit het nie.

As dit gedoen is, kan u '''[u $2 wiki besoek]'''.", # Fuzzy
	'config-download-localsettings' => 'Laai LocalSettings.php af',
	'config-help' => 'hulp',
	'mainpagetext' => "'''MediaWiki is suksesvol geïnstalleer.'''",
	'mainpagedocfooter' => "Konsulteer '''[//meta.wikimedia.org/wiki/Help:Contents User's Guide]''' vir inligting oor hoe om die wikisagteware te gebruik.

== Hoe om te Begin ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Gheg Albanian (Gegë)
 * @author Bresta
 */
$messages['aln'] = array(
	'mainpagetext' => "'''MediaWiki software u instalue me sukses.'''",
	'mainpagedocfooter' => 'Për mâ shumë informata rreth përdorimit të softwareit wiki, ju lutem shikoni [//meta.wikimedia.org/wiki/Help:Contents dokumentacionin].


== Për fillim ==

* [//www.mediawiki.org/wiki/Help:Configuration_settings Konfigurimi i MediaWikit]
* [//www.mediawiki.org/wiki/Help:FAQ Pyetjet e shpeshta rreth MediaWikit]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Njoftime rreth MediaWikit]',
);

/** Amharic (አማርኛ)
 */
$messages['am'] = array(
	'mainpagetext' => "'''MediaWiki በትክክል ማስገባቱ ተከናወነ።'''",
	'mainpagedocfooter' => "ስለ ዊኪ ሶፍትዌር ጥቅም ለመረዳት፣ [//meta.wikimedia.org/wiki/Help:Contents User's Guide] ያንብቡ።

== ለመጀመር ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'mainpagetext' => "'''O programa MediaWiki s'ha instalato correctament.'''",
	'mainpagedocfooter' => "Consulta a [//meta.wikimedia.org/wiki/Help:Contents Guía d'usuario] ta mirar información sobre cómo usar o software wiki.

== Ta prencipiar ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista de caracteristicas confegurables]
* [//www.mediawiki.org/wiki/Manual:FAQ Preguntas cutianas sobre MediaWiki (FAQ)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de correu sobre ta anuncios de MediaWiki]",
);

/** Old English (Ænglisc)
 * @author Gott wisst
 */
$messages['ang'] = array(
	'mainpagetext' => "'''MediaǷiki hafaþ ȝeƿorden spēdiȝe inseted.'''",
	'mainpagedocfooter' => 'Þeahta þone [//meta.wikimedia.org/wiki/Help:Contents Brūcenda Lǣdend]  on helpe mid þǣre nytte of ƿikisōftƿare.

== Beȝinnunȝ ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Onfæstnunȝa ȝesetednessa ȝetæl]
* [//www.mediawiki.org/wiki/Manual:FAQ Ȝetæl oft ascodra ascunȝa ymb MediaǷiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Ǣrendunȝȝetæl nīƿra MediaǷiki forþsendnessa]',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 * @author روخو
 */
$messages['ar'] = array(
	'config-desc' => 'مثبت لميدياويكي',
	'config-title' => 'ميدياويكي 1$ التثبيت', # Fuzzy
	'config-information' => 'معلومات',
	'config-back' => '→ ارجع',
	'config-continue' => 'استمر ←',
	'config-page-language' => 'اللغة',
	'config-page-name' => 'الاسم',
	'config-db-username' => 'اسم مستخدم قاعدة البيانات:',
	'config-db-password' => 'كلمة سر قاعدة البيانات:',
	'config-db-port' => 'منفذ قاعدة البيانات:',
	'config-type-mysql' => 'ماي إس كيو إل',
	'config-type-postgres' => 'بوستجر إس كيو إل',
	'config-type-sqlite' => 'إس كيو لايت',
	'config-type-oracle' => 'أوراكل',
	'config-admin-email' => 'عنوان البريد الإلكتروني:',
	'mainpagetext' => "'''تم تثبيت ميدياويكي بنجاح.'''",
	'mainpagedocfooter' => 'استشر [//meta.wikimedia.org/wiki/Help:Contents دليل المستخدم] لمعلومات حول استخدام برنامج الويكي.

== البداية ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings قائمة إعدادات الضبط]
* [//www.mediawiki.org/wiki/Manual:FAQ أسئلة متكررة حول ميدياويكي]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce القائمة البريدية الخاصة بإصدار ميدياويكي]',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'config-information' => 'ܝܕ̈ܥܬܐ',
	'config-your-language' => 'ܠܫܢܐ ܕܝܠܟ:',
	'config-wiki-language' => 'ܠܫܢܐ ܕܘܝܩܝ:',
	'config-page-language' => 'ܠܫܢܐ',
	'config-page-name' => 'ܫܡܐ',
	'config-page-options' => 'ܓܒܝܬ̈ܐ',
	'config-page-install' => 'ܢܨܘܒ',
	'config-ns-other-default' => 'ܘܝܩܝ ܕܝܠܝ',
	'config-admin-box' => 'ܚܘܫܒܢܐ ܕܡܕܒܪܢܐ',
	'config-admin-name' => 'ܫܡܐ ܕܝܠܟ:',
	'config-admin-password' => 'ܡܠܬܐ ܕܥܠܠܐ:',
	'config-admin-password-confirm' => 'ܡܠܬܐ ܕܥܠܠܐ ܙܒܢܬܐ ܐܚܪܬܐ:',
	'config-admin-email' => 'ܡܘܢܥܐ ܕܒܝܠܕܪܐ ܐܠܩܛܪܘܢܝܐ:',
	'config-profile-private' => 'ܘܝܩܝ ܦܪܨܘܦܝܐ',
	'config-email-settings' => 'ܛܘܝܒ̈ܐ ܕܒܝܠܕܪܐ ܐܠܩܛܪܘܢܝܐ',
);

/** Moroccan Spoken Arabic (Maġribi)
 * @author Enzoreg
 */
$messages['ary'] = array(
	'mainpagetext' => "'''MediaWiki ṫ'instala be najaḫ.'''",
	'mainpagedocfooter' => 'Ila bġiṫiw meĝlomaṫ ĥrin baċ ṫesṫeĝmlo had l-lojisyél siro ċofo [//meta.wikimedia.org/wiki/Aide:Contenu Gid dyal l-mosṫeĥdim]

== L-bdaya mĝa MediaWiki ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista dyal l-paramétraṫ dyal l-konfigurasyon]
* [//www.mediawiki.org/wiki/Manual:FAQ/fr FAQ fe MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista dyal l-modakaraṫ ĝla versyonaṫ jdad dyal MediaWiki]',
);

/** Egyptian Spoken Arabic (مصرى)
 */
$messages['arz'] = array(
	'mainpagetext' => "''' ميدياويكى اتنزلت بنجاح.'''",
	'mainpagedocfooter' => 'اسال [//meta.wikimedia.org/wiki/Help:Contents دليل اليوزر] للمعلومات حوالين استخدام برنامج الويكى.

== البداية ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings لستة اعدادات الضبط]
* [//www.mediawiki.org/wiki/Manual:FAQ أسئلة بتكرر حوالين الميدياويكى]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce لستة الايميلات بتاعة اعلانات الميدياويكى]',
);

/** Assamese (অসমীয়া)
 * @author Chaipau
 * @author Gitartha.bordoloi
 */
$messages['as'] = array(
	'mainpagetext' => "'''মিডিয়াৱিকি সফলভাবে ইন্সটল কৰা হ'ল ।'''",
	'mainpagedocfooter' => "ৱিকি চ'ফটৱেৰ কেনেকৈ ব্যৱহাৰ কৰিব [//meta.wikimedia.org/wiki/Help:Contents সদস্যৰ সহায়িকা] চাওঁক ।

== আৰম্ভণি কৰিবলৈ ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Asturian (asturianu)
 */
$messages['ast'] = array(
	'mainpagetext' => "'''MediaWiki instalóse correchamente.'''",
	'mainpagedocfooter' => "Visita la [//meta.wikimedia.org/wiki/Help:Contents Guía d'usuariu] pa saber cómo usar esti software wiki.

== Empecipiando ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Llista de les opciones de configuración]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ de MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Llista de corréu de les ediciones de MediaWiki]",
);

/** Kotava (Kotava)
 */
$messages['avk'] = array(
	'mainpagetext' => "'''MediaWiki inkeyen talpeyot.'''",
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 * @author Vago
 * @author Wertuose
 */
$messages['az'] = array(
	'config-back' => '← Geri',
	'config-continue' => 'Davam et →',
	'config-page-language' => 'Dil',
	'config-page-welcome' => 'MediaWiki-yə xoş gəlmişsiniz!',
	'config-page-dbconnect' => 'Verilənlər bazasına birləşdir',
	'config-page-dbsettings' => 'Verilənlər bazasının nizamlanması',
	'config-page-name' => 'Ad',
	'config-page-options' => 'Nizamlamalar:',
	'config-page-install' => 'Nizamlama',
	'config-page-complete' => 'Komplektləşdir!',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-utf8' => 'UTF-8',
	'config-ns-generic' => 'Layihə',
	'config-admin-name' => 'Sizin adınız:',
	'config-admin-password' => 'Parol:',
	'config-admin-email' => 'E-poçt ünvanı',
	'config-help' => 'kömək',
	'mainpagetext' => "'''MediaWiki müvəffəqiyyətlə quraşdırıldı.'''",
	'mainpagedocfooter' => 'Bu vikinin istifadəsi ilə bağlı məlumat almaq üçün [//meta.wikimedia.org/wiki/Help:Contents İstifadəçi məlumat səhifəsinə] baxın.

== Faydalı keçidlər ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Tənzimləmələrin siyahısı]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki haqqında tez-tez soruşulan suallar]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki e-poçt siyahısı]',
);

/** Bashkir (башҡортса)
 * @author Haqmar
 */
$messages['ba'] = array(
	'mainpagetext' => '«MediaWiki» уңышлы рәүештә ҡоролдо.',
	'mainpagedocfooter' => 'Был вики менән эшләү тураһында мәғлүмәтте [//meta.wikimedia.org/wiki/Ярҙам:Белешмә ошонда] табып була.

== Файҙалы сығанаҡтар ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Көйләүҙәр исемлеге (инг.)];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki тураһында йыш бирелгән һорауҙар һәм яуаптар (инг.)];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-ның яңы версиялары тураһында хәбәрҙәр алып тороу].',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'mainpagetext' => "'''MediaWiki is erfoigreich installird worn.'''",
	'mainpagedocfooter' => 'A Hüf zur da Benützung und Konfigurazion voh da Wiki-Software findst auf [//meta.wikimedia.org/wiki/Help:Contents Benützerhåndbuach].

== Starthüfe ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listen voh de Konfigurazionsvariaablen]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailinglisten voh de neichen MediaWiki-Versionen]',
);

/** Southern Balochi (بلوچی مکرانی)
 */
$messages['bcc'] = array(
	'mainpagetext' => "'''مدیا وی کی گون موفقیت نصب بوت.'''",
	'mainpagedocfooter' => "مشورت کنیت گون  [//meta.wikimedia.org/wiki/Help:Contents User's Guide] په گشیترین اطلاعات په استفاده چه برنامه ویکی.

== شروع بیت ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Bikol Central (Bikol Central)
 */
$messages['bcl'] = array(
	'mainpagetext' => "'''Instalado na an MediaWiki.'''",
	'mainpagedocfooter' => "Konsultarón tabì an [//meta.wikimedia.org/wiki/Help:Contents User's Guide] para sa impormasyon sa paggamit nin progama kaining wiki.

== Pagpopoon ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Belarusian (беларуская)
 */
$messages['be'] = array(
	'mainpagetext' => "'''MediaWiki паспяхова ўсталяваная.'''",
	'mainpagedocfooter' => 'Гл. [//meta.wikimedia.org/wiki/Help:Contents Дапаможнік карыстальніка (англ.)] па далейшыя звесткі аб карыстанні вікі-праграмамі.

== З чаго пачаць ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Пералік параметраў канфігурацыі (англ.)]
* [//www.mediawiki.org/wiki/Manual:FAQ ЧАПЫ MediaWiki (англ.)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Ліставанне аб выпусках MediaWiki (англ.)]',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'config-desc' => 'Праграма ўсталяваньня MediaWiki',
	'config-title' => 'Усталяваньне MediaWiki $1',
	'config-information' => 'Інфармацыя',
	'config-localsettings-upgrade' => 'Выяўлены файл <code>LocalSettings.php</code>.
Каб абнавіць гэтае усталяваньне, калі ласка, увядзіце значэньне <code>$wgUpgradeKey</code> у полі ніжэй.
Яго можна знайсьці ў LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Быў знойдзены файл LocalSettings.php.
Каб зьмяніць гэтае ўсталяваньне, калі ласка, запусьціце update.php',
	'config-localsettings-key' => 'Ключ паляпшэньня:',
	'config-localsettings-badkey' => 'Пададзены Вамі ключ зьяўляецца няслушным',
	'config-upgrade-key-missing' => 'Выяўленае існуючае ўсталяваньне MediaWiki.
Каб абнавіць гэтае ўсталяваньне, калі ласка, устаўце наступны радок у канец Вашага LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Выглядае, што існуючы LocalSettings.php зьяўляецца няпоўным.
Не ўстаноўленая пераменная $1.
Калі ласка, зьмяніце LocalSettings.php так, каб была ўстаноўленая гэтая пераменная, і націсьніце «Працягваць».',
	'config-localsettings-connection-error' => 'Адбылася памылка падчас злучэньня з базай зьвестак з выкарыстаньнем наладаў, пазначаных у LocalSettings.php ці AdminSettings.php. Калі ласка, выпраўце гэтыя налады і паспрабуйце зноў.

$1',
	'config-session-error' => 'Памылка стварэньня сэсіі: $1',
	'config-session-expired' => 'Скончыўся тэрмін дзеяньня зьвестак сэсіі.
Сэсія мае абмежаваны тэрмін у $1.
Вы можаце павялічыць яго, зьмяніўшы парамэтар <code>session.gc_maxlifetime</code> у php.ini.
Перазапусьціце праграму ўсталяваньня.',
	'config-no-session' => 'Зьвесткі сэсіі згубленыя!
Праверце php.ini і ўпэўніцеся, што ўстаноўлены слушны шлях у <code>session.save_path</code>.',
	'config-your-language' => 'Вашая мова:',
	'config-your-language-help' => 'Выберыце мову для выкарыстаньня падчас усталяваньня.',
	'config-wiki-language' => 'Мова вікі:',
	'config-wiki-language-help' => 'Выберыце мову, на якой пераважна будзе пісацца зьмест у вікі.',
	'config-back' => '← Назад',
	'config-continue' => 'Далей →',
	'config-page-language' => 'Мова',
	'config-page-welcome' => 'Вітаем у MediaWiki!',
	'config-page-dbconnect' => 'Падключэньне да базы зьвестак',
	'config-page-upgrade' => 'Абнавіць існуючую ўстаноўку',
	'config-page-dbsettings' => 'Налады базы зьвестак',
	'config-page-name' => 'Назва',
	'config-page-options' => 'Налады',
	'config-page-install' => 'Усталяваць',
	'config-page-complete' => 'Зроблена!',
	'config-page-restart' => 'Пачаць усталяваньне зноў',
	'config-page-readme' => 'Дадатковыя зьвесткі',
	'config-page-releasenotes' => 'Заўвагі да выпуску',
	'config-page-copying' => 'Капіяваньне',
	'config-page-upgradedoc' => 'Абнаўленьне',
	'config-page-existingwiki' => 'Існуючая вікі',
	'config-help-restart' => 'Ці жадаеце выдаліць усе ўведзеныя зьвесткі і пачаць працэс усталяваньня зноў?',
	'config-restart' => 'Так, пачаць зноў',
	'config-welcome' => '== Праверка асяродзьдзя ==
Праверка патрэбная для запэўніваньня, што гэтае асяродзьдзе слушнае для ўсталяваньня MediaWiki.
Вам патрэбна будзе падаць усе вынікі праверкі, калі спатрэбіцца дапамога падчас усталяваньня.',
	'config-copyright' => "== Аўтарскае права і ўмовы ==

$1

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but '''without any warranty'''; without even the implied warranty of '''merchantability''' or '''fitness for a particular purpose'''.
See the GNU General Public License for more details.

You should have received <doclink href=Copying>a copy of the GNU General Public License</doclink> along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. or [http://www.gnu.org/copyleft/gpl.html read it online].",
	'config-sidebar' => '* [//www.mediawiki.org Хатняя старонка MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Даведка для ўдзельнікаў]
* [//www.mediawiki.org/wiki/Manual:Contents Даведка для адміністратараў]
* [//www.mediawiki.org/wiki/Manual:FAQ Адказы на частыя пытаньні]
----
* <doclink href=Readme>Прачытайце</doclink>
* <doclink href=ReleaseNotes>Паляпшэньні ў вэрсіі</doclink>
* <doclink href=Copying>Капіяваньне</doclink>
* <doclink href=UpgradeDoc>Абнаўленьне</doclink>',
	'config-env-good' => 'Асяродзьдзе было праверанае.
Вы можаце ўсталёўваць MediaWiki.',
	'config-env-bad' => 'Асяродзьдзе было праверанае.
Усталяваньне MediaWiki немагчымае.',
	'config-env-php' => 'Усталяваны PHP $1.',
	'config-env-php-toolow' => 'Усталяваны PHP $1.
Але MediaWiki патрабуе PHP вэрсіі $2 ці навейшай.',
	'config-unicode-using-utf8' => 'Выкарыстоўваецца бібліятэка Unicode-нармалізацыі Браяна Вібэра',
	'config-unicode-using-intl' => 'Выкарыстоўваецца [http://pecl.php.net/intl intl пашырэньне з PECL] для Unicode-нармалізацыі',
	'config-unicode-pure-php-warning' => "'''Папярэджаньне''': [http://pecl.php.net/intl Пашырэньне intl з PECL] — ня слушнае для Unicode-нармалізацыі, цяпер выкарыстоўваецца марудная PHP-рэалізацыя.
Калі ў Вас сайт з высокай наведваемасьцю, раім пачытаць пра [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode-нармалізацыю].",
	'config-unicode-update-warning' => "'''Папярэджаньне''': усталяваная вэрсія бібліятэкі для Unicode-нармалізацыі выкарыстоўвае састарэлую вэрсію бібліятэкі з [http://site.icu-project.org/ праекту ICU].
Раім [//www.mediawiki.org/wiki/Unicode_normalization_considerations абнавіць], калі ваш сайт будзе працаваць зь Unicode.",
	'config-no-db' => 'Немагчыма знайсьці адпаведны драйвэр базы зьвестак. Вам неабходна ўсталяваць драйвэр базы зьвестак для PHP.
Падтрымліваюцца наступныя тыпы базаў зьвестак: $1.

Калі вы выкарыстоўваеце агульны хостынг, запытайцеся ў свайго хостынг-правайдэра наконт усталяваньня патрабуемага драйвэру базы зьвестак.
Калі Вы кампілявалі PHP самастойна, пераканфігуруйце і сабярыце яго з дазволеным кліентам базаў зьвестак, напрыклад, <code>./configure --with-mysql</code>.
Калі Вы ўсталёўвалі PHP з пакетаў Debian ці Ubuntu, то Вам трэба ўсталяваць дадаткова модуль <code>php5-mysql</code>.',
	'config-outdated-sqlite' => "'''Папярэджаньне''': усталяваны SQLite $1, у той час, калі мінімальная сумяшчальная вэрсія — $2. SQLite ня будзе даступны.",
	'config-no-fts3' => "'''Папярэджаньне''': SQLite створаны без модуля [//sqlite.org/fts3.html FTS3], для гэтага ўнутранага інтэрфэйсу ня будзе даступная магчымасьць пошуку.",
	'config-register-globals' => "'''Папярэджаньне: уключаная опцыя PHP <code>[http://php.net/register_globals register_globals]</code>.'''
'''Адключыце яе, калі можаце.'''
MediaWiki будзе працаваць, але гэта панізіць узровень бясьпекі сэрвэра.",
	'config-magic-quotes-runtime' => "'''Фатальная памылка: уключаная опцыя PHP [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]!'''
Гэтая опцыя псуе ўводны паток зьвестак непрадказальным чынам.
Працяг усталяваньня альбо выкарыстаньне MediaWiki без адключэньня гэтай опцыі немагчымыя.",
	'config-magic-quotes-sybase' => "'''Фатальная памылка: рэжым [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] уключаны!'''
Гэты рэжым шкодзіць уваходныя зьвесткі непрадказальным чынам.
Працяг усталяваньня альбо выкарыстаньне MediaWiki немагчымыя, пакуль рэжым ня будзе выключаны.",
	'config-mbstring' => "'''Фатальная памылка: рэжым [http://www.php.net/manual/en/ref.info.php#mbstring.overload mbstring.func_overload] уключаны!'''
Гэты рэжым выклікае памылкі і можа шкодзіць зьвесткі непрадказальным чынам.
Працяг усталяваньня альбо выкарыстаньне MediaWiki немагчымыя, пакуль рэжым ня будзе выключаны.",
	'config-ze1' => "'''Фатальная памылка: рэжым [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] уключаны!'''
Гэтая рэжым стварае вялікія праблемы ў працы MediaWiki.
Працяг усталяваньня альбо выкарыстаньне MediaWiki немагчымыя, пакуль рэжым ня будзе выключаны.",
	'config-safe-mode' => "'''Папярэджаньне:''' [http://www.php.net/features.safe-mode бясьпечны рэжым] PHP уключаны.
Гэта можа выклікаць праблемы, галоўным чынам падчас загрузак файлаў і ў падтрымцы <code>math</code>.",
	'config-xml-bad' => 'Ня знойдзены модуль XML для PHP.
MediaWiki патрэбныя функцыі з гэтага модулю, таму MediaWiki ня будзе працаваць у гэтай канфігурацыі.
Калі Вы выкарыстоўваеце Mandrake, усталюйце пакет php-xml.',
	'config-pcre' => 'Ня знойдзены модуль падтрымкі PCRE.
MediaWiki для працы патрабуюцца функцыі рэгулярных выразаў у стылі Perl.',
	'config-pcre-no-utf8' => "'''Фатальная памылка''': модуль PCRE для PHP скампіляваны без падтрымкі PCRE_UTF8.
MediaWiki патрабуе падтрымкі UTF-8 для слушнай працы.",
	'config-memory-raised' => 'Абмежаваньне на даступную для PHP памяць <code>memory_limit</code> было падвышанае з $1 да $2.',
	'config-memory-bad' => "'''Папярэджаньне:''' памер PHP <code>memory_limit</code> складае $1.
Верагодна, гэта вельмі мала.
Усталяваньне можа быць няўдалым!",
	'config-ctype' => "'''Фатальная памылка''': PHP мусіць быць скампіляваны з падтрымкай [http://www.php.net/manual/en/ctype.installation.php пашырэньня Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] усталяваны',
	'config-apc' => '[http://www.php.net/apc APC] усталяваны',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] усталяваны',
	'config-no-cache' => "'''Папярэджаньне:''' немагчыма знайсьці [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] ці [http://www.iis.net/download/WinCacheForPhp WinCache].
Аб’ектнае кэшаваньне ня ўключанае.",
	'config-mod-security' => "'''Папярэджаньне''': на Вашым ўэб-сэрверы ўключаны [http://modsecurity.org/ mod_security]. У выпадку няслушнай наладцы, ён можа стаць прычынай праблемаў для MediaWiki ці іншага праграмнага забесьпячэньня, якое дазваляе ўдзельнікам дасылаць на сэрвэр любы зьмест.
Глядзіце [http://modsecurity.org/documentation/ дакумэнтацыю mod_security] ці зьвярніцеся ў падтрымку Вашага хосту, калі ў Вас узьнікаюць выпадковыя праблемы.",
	'config-diff3-bad' => 'GNU diff3 ня знойдзены.',
	'config-imagemagick' => 'Знойдзены ImageMagick: <code>$1</code>.
Пасьля ўключэньня загрузак будзе ўключанае маштабаваньне выяваў.',
	'config-gd' => 'GD падтрымліваецца ўбудавана.
Пасьля ўключэньня загрузак будзе ўключанае маштабаваньне выяваў.',
	'config-no-scaling' => 'Ні GD, ні ImageMagick ня знойдзеныя.
Маштабаваньне выяваў будзе адключанае.',
	'config-no-uri' => "'''Памылка:''' Не магчыма вызначыць цяперашні URI.
Усталяваньне спыненае.",
	'config-no-cli-uri' => "'''Папярэджаньне''': Не пазначаны --scriptpath, па змоўчваньні выкарыстоўваецца: <code>$1</code>.",
	'config-using-server' => 'Выкарыстоўваецца назва сэрвэра «<nowiki>$1</nowiki>».',
	'config-using-uri' => 'Выкарыстоўваецца URL-спасылка сэрвэра «<nowiki>$1$2</nowiki>».',
	'config-uploads-not-safe' => "'''Папярэджаньне:''' дырэкторыя для загрузак па змоўчваньні <code>$1</code> уразьлівая да выкананьня адвольнага коду.
Хоць MediaWiki і правярае ўсе файлы перад захаваньнем, вельмі рэкамэндуецца [//www.mediawiki.org/wiki/Manual:Security#Upload_security закрыць гэтую ўразьлівасьць] перад уключэньнем магчымасьці загрузкі файлаў.",
	'config-no-cli-uploads-check' => "'''Папярэджаньне:''' Вашая дырэкторыя для загрузак па змоўчваньні (<code>$1</code>), не правераная на ўразьлівасьць да выкананьня адвольных скрыптоў падчас усталяваньня CLI.
.",
	'config-brokenlibxml' => 'У Вашай сыстэме ўсталяваныя PHP і libxml2 зь несумяшчальнымі вэрсіямі, што можа прывесьці да пашкоджаньня зьвестак MediaWiki і іншых ўэб-дастасаваньняў.
Абнавіце PHP да вэрсіі 5.2.9 ці болей позьняй, а libxml2 да 2.7.3 ці болей позьняй ([//bugs.php.net/bug.php?id=45996 паведамленьне пра памылку на сайце PHP]).
Усталяваньне перарванае.',
	'config-using531' => 'PHP $1 не сумяшчальнае з MediaWiki з-за памылкі ў перадачы парамэтраў па ўказальніку да <code>__call()</code>.
Абнавіце PHP да вэрсіі 5.3.2 ці болей позьняй, ці адкаціце да вэрсіі 5.3.0 каб гэта выправіць.
Усталяваньне перарванае.',
	'config-suhosin-max-value-length' => 'Suhosin усталяваны і абмяжоўвае даўжыню парамэтра GET у $1 {{PLURAL:$1|байт|байты|байтаў}}. ResourceLoader для MediaWiki будзе абходзіць гэтае абмежаваньне, што, аднак, адаб’ецца на хуткадзеяньні. Калі магчыма, варта ўстанавіць suhosin.get.max_value_length роўным 1024 ці больш у php.ini, а таксама ўстанавіць тое ж значэньне для $wgResourceLoaderMaxQueryLength у LocalSettings.php.',
	'config-db-type' => 'Тып базы зьвестак:',
	'config-db-host' => 'Хост базы зьвестак:',
	'config-db-host-help' => 'Калі сэрвэр Вашай базы зьвестак знаходзіцца на іншым сэрвэры, увядзіце тут імя хоста ці IP-адрас.

Калі Вы карыстаецеся shared-хостынгам, Ваш хостынг-правайдэр мусіць даць Вам слушнае імя хоста базы зьвестак у сваёй дакумэнтацыі.

Калі Вы усталёўваеце сэрвэр Windows з выкарыстаньнем MySQL, выкарыстаньне «localhost» можа не працаваць для назвы сэрвэра. У гэтым выпадку паспрабуйце пазначыць «127.0.0.1»  для лякальнага IP-адраса.

Калі Вы выкарыстоўваеце PostgreSQL, пакіньце поле пустым, каб далучыцца праз Unix-сокет.',
	'config-db-host-oracle' => 'TNS базы зьвестак:',
	'config-db-host-oracle-help' => 'Увядзіце слушнае [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm лякальнае імя злучэньня]; файл tnsnames.ora павінен быць бачным для гэтага ўсталяваньня.<br />Калі Вы выкарыстоўваеце кліенцкія бібліятэкі 10g ці больш новыя, Вы можаце таксама выкарыстоўваць мэтад наданьня назваў [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm лёгкае злучэньне].',
	'config-db-wiki-settings' => 'Ідэнтыфікацыя гэтай вікі',
	'config-db-name' => 'Назва базы зьвестак:',
	'config-db-name-help' => 'Выберыце імя для вызначэньня Вашай вікі.
Яно ня мусіць зьмяшчаць прагалаў.

Калі Вы набываеце shared-хостынг, Ваш хостынг-правайдэр мусіць надаць Вам ці пэўнае імя базы зьвестак для выкарыстаньня, ці магчымасьць ствараць базы зьвестак праз кантрольную панэль.',
	'config-db-name-oracle' => 'Схема базы зьвестак:',
	'config-db-account-oracle-warn' => 'Існуюць тры сцэнары ўсталяваньня Oracle як базы зьвестак для MediaWiki:

Калі Вы жадаеце стварыць рахунак базы зьвестак як частку працэсу ўсталяваньня, калі ласка, падайце рахунак з роляй SYSDBA як рахунак базы зьвестак для ўсталяваньня і пазначце пажаданыя правы рахунку з доступам да Інтэрнэту, у адваротным выпадку Вы можаце таксама стварыць рахунак з доступам да Інтэрнэту ўручную і падаць толькі гэты рахунак (калі патрабуюцца правы для стварэньня схемы аб’ектаў) ці падайце два розных рахункі, адзін з правамі на стварэньне і адзін з абмежаваньнямі для доступу да Інтэрнэту.

Скрыпт для стварэньня рахунку з патрабуемымі правамі можна знайсьці ў дырэкторыі гэтага ўсталяваньня «maintenance/oracle/». Памятайце, што выкарыстаньне рахунку з абмежаваньнямі адключыць усе падтрымліваемыя магчымасьці даступныя па змоўчваньні.',
	'config-db-install-account' => 'Імя карыстальніка для ўсталяваньня',
	'config-db-username' => 'Імя карыстальніка базы зьвестак:',
	'config-db-password' => 'Пароль базы зьвестак:',
	'config-db-password-empty' => 'Калі ласка, увядзіце пароль для новага карыстальніка базы зьвестак: $1.
Магчыма стварыць карыстальніка без паролю, але гэта небясьпечна.',
	'config-db-install-username' => 'Увядзіце імя карыстальніка, якое будзе выкарыстоўвацца для злучэньня з базай зьвестак падчас усталяваньня. Гэта не назва рахунку MediaWiki; гэта імя карыстальніка Вашай базы зьвестак.',
	'config-db-install-password' => 'Увядзіце пароль, які будзе выкарыстоўвацца для злучэньня з базай зьвестак падчас усталяваньня. Гэта не пароль рахунку MediaWiki; гэта пароль Вашай базы зьвестак.',
	'config-db-install-help' => 'Увядзіце імя карыстальніка і пароль, якія будуць выкарыстаныя для далучэньня да базы зьвестак падчас працэсу ўсталяваньня.',
	'config-db-account-lock' => 'Выкарыстоўваць тыя ж імя карыстальніка і пароль пасьля ўсталяваньня',
	'config-db-wiki-account' => 'Імя карыстальніка для працы',
	'config-db-wiki-help' => 'Увядзіце імя карыстальніка і пароль, якія будуць выкарыстаныя для далучэньня да базы зьвестак падчас працы (пасьля ўсталяваньня).
Калі рахунак ня створаны, а рахунак для ўсталяваньня мае значныя правы, гэты рахунак будзе створаны зь мінімальна патрэбнымі для працы вікі правамі.',
	'config-db-prefix' => 'Прэфікс табліцаў базы зьвестак:',
	'config-db-prefix-help' => 'Калі Вы разьдзяляеце адну базу зьвестак паміж некалькімі вікі, ці паміж MediaWiki і іншым вэб-дастасаваньнем, можаце вызначыць прэфікс назваў табліцаў для пазьбяганьня канфліктаў.
Пазьбягайце прагалаў.

Гэтае поле звычайна пакідаецца пустым.',
	'config-db-charset' => 'Кадаваньне базы зьвестак',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binary',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 UTF-8 з адваротнай сумяшчальнасьцю',
	'config-charset-help' => "'''Папярэджаньне:''' калі Вы выкарыстоўваеце '''UTF-8 з адваротнай сумяшчальнасьцю''' на MySQL 4.1+ і зробіце рэзэрвовую копію праз <code>mysqldump</code>, ён можа зьнішчыць усе не-ASCII-сымбалі беспаваротна!

У '''бінарным (binary)''' рэжыме MediaWiki захоўвае тэксты ў UTF-8 у палёх тыпу binary.
Гэты рэжым болей эфэктыўны за рэжым MySQL UTF-8 і дазваляе выкарыстоўваць увесь абсяг сымбаляў Unicode.
У рэжыме '''UTF-8''' MySQL будзе ведаць, у якім кадаваньне Вы зьмяшчаеце зьвесткі, і будзе вяртаць іх у адпаведным кадаваньні,
але MySQL ня можа ўтрымліваць сымбалі па-за [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Стандартным шматмоўным пластом] сымбаляў Unicode.",
	'config-mysql-old' => 'Патрабуецца MySQL $1 ці навейшая, усталяваная вэрсія $2.',
	'config-db-port' => 'Порт базы зьвестак:',
	'config-db-schema' => 'Схема для MediaWiki',
	'config-db-schema-help' => 'Гэтая схема слушная ў большасьці выпадкаў.
Зьмяняйце яе толькі тады, калі Вы ведаеце, што гэта неабходна.',
	'config-pg-test-error' => "Немагчыма далучыцца да базы зьвестак '''$1''': $2",
	'config-sqlite-dir' => 'Дырэкторыя зьвестак SQLite:',
	'config-sqlite-dir-help' => "SQLite захоўвае ўсе зьвесткі ў адзіным файле.

Пададзеная Вамі дырэкторыя павінна быць даступнай да запісу вэб-сэрвэрам падчас усталяваньня.

Яна '''ня''' мусіць быць даступнай праз Сеціва, вось чаму мы не захоўваем яе ў адным месцы з файламі PHP.

Праграма ўсталяваньня дадаткова створыць файл <code>.htaccess</code>, але калі ён не выкарыстоўваецца, хто заўгодна зможа атрымаць зьвесткі з базы зьвестак.
Гэта ўключае як прыватныя зьвесткі ўдзельнікаў (адрасы электроннай пошты, хэшы пароляў), гэтак і выдаленыя вэрсіі старонак і іншыя зьвесткі, доступ да якіх маецца абмежаваны.

Падумайце над тым, каб зьмяшчаць базу зьвестак у іншым месцы, напрыклад у <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Прастора табліцаў па змоўчваньні:',
	'config-oracle-temp-ts' => 'Часовая прастора табліцаў:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki падтрымлівае наступныя сыстэмы базаў зьвестак:

$1

Калі Вы ня бачыце сыстэму базаў зьвестак, якую Вы спрабуеце выкарыстоўваць ў сьпісе ніжэй, перайдзіце па спасылцы інструкцыі, якая знаходзіцца ніжэй, каб уключыць падтрымку.',
	'config-support-mysql' => '* $1 зьяўляецца галоўнай мэтай MediaWiki і падтрымліваецца лепей за ўсё ([http://www.php.net/manual/en/mysql.installation.php як кампіляваць PHP з падтрымкай MySQL])',
	'config-support-postgres' => '* $1 — вядомая сыстэма базы зьвестак з адкрытым кодам, якая зьяўляецца альтэрнатывай MySQL ([http://www.php.net/manual/en/pgsql.installation.php як кампіляваць PHP з падтрымкай PostgreSQL]). Яна можа ўтрымліваць дробныя памылкі, і не рэкамэндуецца выкарыстоўваць яе для працуючых праектаў.',
	'config-support-sqlite' => '* $1 — невялікая сыстэма базы зьвестак, якая мае вельмі добрую падтрымку. ([http://www.php.net/manual/en/pdo.installation.php як кампіляваць PHP з падтрымкай SQLite], выкарыстоўвае PDO)',
	'config-support-oracle' => '* $1 зьяўляецца камэрцыйнай прафэсійнай базай зьвестак. ([http://www.php.net/manual/en/oci8.installation.php Як скампіляваць PHP з падтрымкай OCI8])',
	'config-support-ibm_db2' => '* $1 — база зьвестак камэрцыйнага прадпрыемства.',
	'config-header-mysql' => 'Налады MySQL',
	'config-header-postgres' => 'Налады PostgreSQL',
	'config-header-sqlite' => 'Налады SQLite',
	'config-header-oracle' => 'Налады Oracle',
	'config-header-ibm_db2' => 'Налады IBM DB2',
	'config-invalid-db-type' => 'Няслушны тып базы зьвестак',
	'config-missing-db-name' => 'Вы павінны ўвесьці значэньне парамэтру «Імя базы зьвестак»',
	'config-missing-db-host' => 'Вы павінны ўвесьці значэньне парамэтру «Хост базы зьвестак»',
	'config-missing-db-server-oracle' => 'Вы павінны ўвесьці значэньне парамэтру «TNS базы зьвестак»',
	'config-invalid-db-server-oracle' => 'Няслушнае TNS базы зьвестак «$1».
Назва можа ўтрымліваць толькі ASCII-літары (a-z, A-Z), лічбы (0-9), сымбалі падкрэсьліваньня(_) і кропкі (.).',
	'config-invalid-db-name' => 'Няслушная назва базы зьвестак «$1».
Назва можа ўтрымліваць толькі ASCII-літары (a-z, A-Z), лічбы (0-9), сымбалі падкрэсьліваньня(_) і працяжнікі (-).',
	'config-invalid-db-prefix' => 'Няслушны прэфікс базы зьвестак «$1».
Ён можа зьмяшчаць толькі ASCII-літары (a-z, A-Z), лічбы (0-9), сымбалі падкрэсьліваньня (_) і працяжнікі (-).',
	'config-connection-error' => '$1.

Праверце хост, імя карыстальніка і пароль ніжэй і паспрабуйце зноў.',
	'config-invalid-schema' => 'Няслушная схема для MediaWiki «$1».
Выкарыстоўвайце толькі ASCII-літары (a-z, A-Z), лічбы (0-9) і сымбалі падкрэсьліваньня (_).',
	'config-db-sys-create-oracle' => 'Праграма ўсталяваньня падтрымлівае толькі выкарыстаньне рахунку SYSDBA для стварэньня новага рахунку.',
	'config-db-sys-user-exists-oracle' => 'Рахунак карыстальніка «$1» ужо існуе. SYSDBA можа выкарыстоўвацца толькі для стварэньня новых рахункаў!',
	'config-postgres-old' => 'Патрабуецца PostgreSQL $1 ці навейшая, усталяваная вэрсія $2.',
	'config-sqlite-name-help' => 'Выберыце назву, якая будзе ідэнтыфікаваць Вашую вікі.
Не выкарыстоўвайце прагалы ці злучкі.
Назва будзе выкарыстоўвацца ў назьве файла зьвестак SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Немагчыма стварыць дырэкторыю зьвестак <code><nowiki>$1</nowiki></code>, таму што бацькоўская дырэкторыя <code><nowiki>$2</nowiki></code> абароненая ад запісаў вэб-сэрвэра.

Праграма ўсталяваньня вызначыла карыстальніка, які запусьціў вэб-сэрвэр.
Дазвольце запісы ў дырэкторыю <code><nowiki>$3</nowiki></code> для працягу.
У сыстэме Unix/Linux зрабіце:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Немагчыма стварыць дырэкторыю зьвестак <code><nowiki>$1</nowiki></code>, таму што бацькоўская дырэкторыя <code><nowiki>$2</nowiki></code> абароненая ад запісаў вэб-сэрвэра.

Праграма ўсталяваньня вызначыла карыстальніка, які запусьціў вэб-сэрвэр.
Дазвольце яму (і іншым) запісы ў дырэкторыю <code><nowiki>$3</nowiki></code> для працягу.
У сыстэме Unix/Linux зрабіце:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Памылка падчас стварэньня дырэкторыі «$1».
Праверце шлях і паспрабуйце зноў.',
	'config-sqlite-dir-unwritable' => 'Запіс у дырэкторыю «$1» немагчымы.
Зьмяніце налады доступу, каб вэб-сэрвэр меў правы на запіс, і паспрабуйце зноў.',
	'config-sqlite-connection-error' => '$1.

Праверце дырэкторыю для зьвестак, назву базы зьвестак і паспрабуйце зноў.',
	'config-sqlite-readonly' => 'Файл <code>$1</code> недаступны для запісу.',
	'config-sqlite-cant-create-db' => 'Немагчыма стварыць файл базы зьвестак <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP бракуе падтрымкі FTS3 — табліцы пагаршаюцца',
	'config-can-upgrade' => "У гэтай базе зьвестак ёсьць табліцы MediaWiki.
Каб абнавіць іх да MediaWiki $1, націсьніце '''Працягнуць'''.",
	'config-upgrade-done' => "Абнаўленьне завершанае.

Цяпер Вы можаце [$1 пачаць выкарыстаньне вікі].

Калі Вы жадаеце рэгенэраваць <code>LocalSettings.php</code>, націсьніце кнопку ніжэй.
Гэтае дзеяньне '''не рэкамэндуецца''', калі Вы ня маеце праблемаў у працы вікі.",
	'config-upgrade-done-no-regenerate' => 'Абнаўленьне скончанае.

Цяпер Вы можаце [$1 пачаць працу з вікі].',
	'config-regenerate' => 'Рэгенэраваць LocalSettings.php →',
	'config-show-table-status' => "Запыт 'SHOW TABLE STATUS' не атрымаўся!",
	'config-unknown-collation' => "'''Папярэджаньне:''' база зьвестак выкарыстоўвае нераспазнанае супастаўленьне.",
	'config-db-web-account' => 'Рахунак базы зьвестак для вэб-доступу',
	'config-db-web-help' => 'Выберыце імя карыстальніка і пароль, які выкарыстоўваецца вэб-сэрвэрам для злучэньня з сэрвэрам базы зьвестак, падчас звычайных апэрацыяў вікі.',
	'config-db-web-account-same' => 'Выкарыстоўваць той жа рахунак, што для ўсталяваньня',
	'config-db-web-create' => 'Стварыць рахунак, калі ён яшчэ не існуе',
	'config-db-web-no-create-privs' => 'Рахунак, які Вы пазначылі для ўсталяваньня ня мае правоў для стварэньня рахунку.
Рахунак, які Вы пазначылі тут, мусіць ужо існаваць.',
	'config-mysql-engine' => 'Рухавік сховішча:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Папярэджаньне''': Вы выбралі MyISAM у якасьці рухавіка для захоўваньня зьвестак у MySQL, які не рэкамэндуецца да выкарыстаньня з MediaWiki па прычынах:
* кепская падтрымка паралельнай апрацоўкі з-за таблічных блякаваньняў;
* большая імавернасьць пашкоджаньня зьвестак у параўнаньні зь іншымі рухавікамі;
* код MediaWiki не ва ўсіх выпадках улічвае асаблівасьці MyISAM.

Калі Ваш MySQL-сэрвэр падтрымлівае InnoDB, вельмі рэкамэндуецца выкарыстаньне менавіта гэтага рухавіка.
Калі MySQL-сэрвэр не падтрымлівае InnoDB, пэўна, настаў час абнавіць яго.",
	'config-mysql-engine-help' => "'''InnoDB''' — звычайна найбольш слушны варыянт, таму што добра падтрымлівае паралелізм.

'''MyISAM''' можа быць хутчэйшай у вікі з адным удзельнікам, ці толькі для чытаньня.
Базы зьвестак на MyISAM вядомыя тым, што ў іх зьвесткі шкодзяцца нашмат часьцей за InnoDB.",
	'config-mysql-charset' => 'Кадаваньне базы зьвестак:',
	'config-mysql-binary' => 'Двайковае',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "У '''двайковым рэжыме''', MediaWiki захоўвае тэкст у кадаваньні UTF-8 у базе зьвестак у двайковых палях.
Гэта болей эфэктыўна за рэжым MySQL UTF-8, і дазваляе Вам выкарыстоўваць увесь дыяпазон сымбаляў Unicode.

У '''рэжыме UTF-8''', MySQL ведае, якая табліцы сымбаляў выкарыстоўваецца ў Вашых зьвестках, і можа адпаведна прадстаўляць і канвэртаваць іх, але гэта не дазволіць Вам захоўваць сымбалі па-за межамі [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Базавага шматмоўнага дыяпазону].",
	'config-ibm_db2-low-db-pagesize' => "Вашая база зьвестак DB2 мае таблічную прасторну зь недастатковым памерам старонкі. Памер старонкі мусіць быць ня менш за '''32к'''.",
	'config-site-name' => 'Назва вікі:',
	'config-site-name-help' => 'Назва будзе паказвацца ў загалоўку браўзэра і ў некаторых іншых месцах.',
	'config-site-name-blank' => 'Увядзіце назву сайта.',
	'config-project-namespace' => 'Прастора назваў праекту:',
	'config-ns-generic' => 'Праект',
	'config-ns-site-name' => 'Такая ж, як і назва вікі: $1',
	'config-ns-other' => 'Іншая (вызначце)',
	'config-ns-other-default' => 'MyWiki',
	'config-project-namespace-help' => "Па прыкладу Вікіпэдыі, шматлікія вікі трымаюць уласныя старонкі з правіламі асобна ад старонак са зьместам, у «'''прасторы назваў праекту'''».
Усе назвы старонак у гэтай прасторы назваў пачынаюцца з прыстаўкі, якую Вы можаце пазначыць тут.
Традыцыйна, гэтая прыстаўка вытворная ад назвы вікі, яле яна ня можа ўтрымліваць некаторыя сымбалі, такія як «#» ці «:».",
	'config-ns-invalid' => 'Пададзеная няслушная прастора назваў «<nowiki>$1</nowiki>».
Падайце іншую прастору назваў праекту.',
	'config-ns-conflict' => 'Пазначаная прастора назваў «<nowiki>$1</nowiki>» канфліктуе з прасторай назваў MediaWiki па змоўчваньні.
Пазначце іншую прастору назваў праекту.',
	'config-admin-box' => 'Рахунак адміністратара',
	'config-admin-name' => 'Вашае імя:',
	'config-admin-password' => 'Пароль:',
	'config-admin-password-confirm' => 'Пароль яшчэ раз:',
	'config-admin-help' => 'Увядзіце тут Вашае імя ўдзельніка, напрыклад «Янка Кавалевіч».
Гэтае імя будзе выкарыстоўвацца для ўваходу ў вікі.',
	'config-admin-name-blank' => 'Увядзіце імя адміністратара.',
	'config-admin-name-invalid' => 'Пададзенае няслушнае імя ўдзельніка «<nowiki>$1</nowiki>».
Падайце іншае імя ўдзельніка.',
	'config-admin-password-blank' => 'Увядзіце пароль рахунку адміністратара.',
	'config-admin-password-same' => 'Пароль ня можа быць аднолькавым зь іменем удзельніка.',
	'config-admin-password-mismatch' => 'Уведзеныя Вамі паролі не супадаюць.',
	'config-admin-email' => 'Адрас электроннай пошты:',
	'config-admin-email-help' => 'Увядзіце тут адрас электроннай пошты, каб атрымліваць электронныя лісты ад іншых удзельнікаў вікі, скідваць Ваш пароль і атрымліваць абвешчаньні пра зьмены старонак, якія знаходзяцца ў Вашым сьпісе назіраньня. Вы можаце пакінуць гэтае поле пустым.',
	'config-admin-error-user' => 'Унутраная памылка падчас стварэньня рахунку адміністратара зь іменем «<nowiki>$1</nowiki>».',
	'config-admin-error-password' => 'Унутраная памылка падчас устаноўкі паролю для адміністратара «<nowiki>$1</nowiki>»: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Вы ўвялі няслушны адрас электроннай пошты',
	'config-subscribe' => 'Падпісацца на [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce сьпіс распаўсюджаньня навінаў пра зьяўленьне новых вэрсіяў].',
	'config-subscribe-help' => 'Гэта ня вельмі актыўны сьпіс распаўсюджаньня навінаў пра зьяўленьне новых вэрсіяў, які ўключаючы важныя навіны пра бясьпеку.
Вам неабходна падпісацца на яго і абнавіць Вашае ўсталяваньне MediaWiki, калі зьявяцца новыя вэрсіі.',
	'config-subscribe-noemail' => 'Вы спрабавалі падпісацца на рассылку паведамленьняў пра выхад новых вэрсіяў, не пазначыўшы адрас электроннай пошты.
Калі ласка, падайце слушны адрас, калі Вы жадаеце падпісацца на рассылку.',
	'config-almost-done' => 'Вы амаль што скончылі!
Астатнія налады можна прапусьціць і пачаць усталяваньне вікі.',
	'config-optional-continue' => 'Задаць болей пытаньняў.',
	'config-optional-skip' => 'Хопіць, проста ўсталяваць вікі.',
	'config-profile' => 'Профіль правоў удзельніка:',
	'config-profile-wiki' => 'Традыцыйная вікі',
	'config-profile-no-anon' => 'Патрэбнае стварэньне рахунку',
	'config-profile-fishbowl' => 'Толькі для аўтарызаваных рэдактараў',
	'config-profile-private' => 'Прыватная вікі',
	'config-profile-help' => "Вікі працуюць лепей, калі Вы дазваляеце як мага большай колькасьці людзей рэдагаваць яе.
У MediaWiki вельмі лёгка праглядаць апошнія зьмены і выпраўляць любыя пашкоджаньні зробленыя недасьведчанымі ўдзельнікамі альбо вандаламі.

Тым ня менш, многія лічаць, што MediaWiki можа быць карыснай ў шматлікіх іншых ролях, і часта вельмі нялёгка растлумачыць усім перавагі выкарыстаньня тэхналёгіяў вікі.
Таму Вы маеце выбар.

'''{{int:config-profile-wiki}}''' дазваляе рэдагаваць усім, нават без уваходу ў сыстэму.
Вікі з '''{{int:config-profile-no-anon}}''' дазваляе дадатковую адказнасьць, але можа адштурхнуць некаторых патэнцыйных удзельнікаў.

Сцэнар '''{{int:config-profile-fishbowl}}''' дазваляе рэдагаваць зацьверджаным удзельнікам, але ўсе могуць праглядаць старонкі іх гісторыю.
'''{{int:config-profile-private}}''' дазваляе праглядаць і рэдагаваць старонкі толькі зацьверджаным удзельнікам.

Больш складаныя правы ўдзельнікаў даступныя пасьля ўсталяваньня, глядзіце [//www.mediawiki.org/wiki/Manual:User_rights адпаведную старонку дакумэнтацыі].",
	'config-license' => 'Аўтарскія правы і ліцэнзія:',
	'config-license-none' => 'Без інфармацыі пра ліцэнзію',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0' => 'Creative Commons Zero (грамадзкі набытак)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 ці болей позьняя',
	'config-license-pd' => 'Грамадзкі набытак',
	'config-license-cc-choose' => 'Выберыце іншую ліцэнзію Creative Commons',
	'config-license-help' => "Шматлікія адкрытыя вікі публікуюць увесь унёсак у праект на ўмовах [http://freedomdefined.org/Definition вольнай ліцэнзіі].
Гэта дазваляе ствараць эфэкт супольнай уласнасьці і садзейнічае доўгатэрміноваму ўнёску.
Для прыватных і карпаратыўных вікі гэта не зьяўляецца неабходнасьцю.

Калі Вы жадаеце выкарыстоўваць тэкст зь Вікіпэдыі, і жадаеце, каб Вікіпэдыя магла прымаць тэксты, скапіяваныя з Вашай вікі, Вам неабходна выбраць ліцэнзію '''Creative Commons Attribution Share Alike'''.

Раней Вікіпэдыя выкарыстоўвала ліцэнзію GNU Free Documentation.
Яна ўсё яшчэ дзейнічае, але яна ўтрымлівае некаторыя моманты,
якія ўскладняюць паўторнае выкарыстоўваньне і інтэрпрэтацыю матэрыялаў.",
	'config-email-settings' => 'Налады электроннай пошты',
	'config-enable-email' => 'Дазволіць выходзячыя электронныя лісты',
	'config-enable-email-help' => 'Калі Вы жадаеце, каб працавала электронная пошта, неабходна сканфігураваць PHP [http://www.php.net/manual/en/mail.configuration.php адпаведным чынам].
Калі Вы не жадаеце выкарыстоўваць магчымасьці электроннай пошты, Вы можаце яе адключыць.',
	'config-email-user' => 'Дазволіць электронную пошту для сувязі паміж удзельнікамі',
	'config-email-user-help' => 'Дазволіць усім удзельнікам дасылаць адзін аднаму электронныя лісты, калі ўключаная адпаведная магчымасьць ў іх наладах.',
	'config-email-usertalk' => 'Уключыць абвяшчэньні пра паведамленьні на старонцы абмеркаваньня',
	'config-email-usertalk-help' => 'Дазваляе ўдзельнікам атрымліваць абвяшчэньні пра зьмены на старонцы абмеркаваньня, калі гэтая магчымасьць уключаная ў іх наладах.',
	'config-email-watchlist' => 'Уключыць абвяшчэньні пра зьмены ў сьпісе назіраньня',
	'config-email-watchlist-help' => 'Дазваляе ўдзельнікам атрымліваць абвяшчэньні пра зьмены ў іх сьпісе назіраньня, калі гэтая магчымасьць уключаная ў іх наладах.',
	'config-email-auth' => 'Уключыць аўтэнтыфікацыю праз электронную пошту',
	'config-email-auth-help' => "Калі гэтая магчымасьць уключаная, удзельнікі павінны пацьвердзіць іх адрас электроннай пошты праз спасылку, якая дасылаецца ім праз электронную пошту. Яна дасылаецца і падчас зьмены адрасу электроннай пошты.
Толькі аўтэнтыфікаваныя адрасы электроннай пошты могуць атрымліваць электронныя лісты ад іншых удзельнікаў, ці зьмяняць абвяшчэньні дасылаемыя праз электронную пошту.
Уключэньне гэтай магчымасьці '''рэкамэндуецца'''  для адкрытых вікі, з-за магчымых злоўжываньняў магчымасьцямі электроннай пошты.",
	'config-email-sender' => 'Адрас электроннай пошты для вяртаньня:',
	'config-email-sender-help' => 'Увядзіце адрас электроннай пошты для вяртаньня ў якасьці адрасу дасылаемых электронных лістоў.
Сюды будуць дасылацца неатрыманыя электронныя лісты.
Шматлікія паштовыя сэрвэры патрабуюць, каб хаця б назва дамэну была слушнай.',
	'config-upload-settings' => 'Загрузкі выяваў і файлаў',
	'config-upload-enable' => 'Дазволіць загрузку файлаў',
	'config-upload-help' => 'Дазвол загрузкі файлаў можа патэнцыйна пагражаць бясьпекі сэрвэра.
Дадатковую інфармацыю можна атрымаць ў [//www.mediawiki.org/wiki/Manual:Security разьдзеле бясьпекі].

Каб дазволіць загрузку файлаў, зьмяніце рэжым падкаталёга <code>images</code> у карэннай дырэкторыі MediaWiki так, каб ўэб-сэрвэр меў доступ на запіс.
Потым дазвольце гэтую магчымасьць.',
	'config-upload-deleted' => 'Дырэкторыя для выдаленых файлаў:',
	'config-upload-deleted-help' => 'Выберыце дырэкторыю, у якой будуць захоўвацца выдаленыя файлы.
У ідэальным выпадку, яна не павінна мець доступу з Інтэрнэту.',
	'config-logo' => 'URL-адрас лягатыпу:',
	'config-logo-help' => 'Афармленьне MediaWiki па змоўчваньні уключае прастору для лягатыпу памерам 135×160 піксэляў у верхнім левым куце.
Загрузіце выяву адпаведнага памеру і увядзіце тут URL-адрас.

Калі Вы не жадаеце мець ніякага лягатыпу, пакіньце поле пустым.',
	'config-instantcommons' => 'Дазволіць Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] — магчымасьць, якая дазваляе вікі выкарыстоўваць выявы, гукі і іншыя мэдыя, якія знаходзяцца на сайце [//commons.wikimedia.org/ Wikimedia Commons].
Каб гэта зрабіць, MediaWiki патрабуе доступу да Інтэрнэту.

Каб даведацца болей пра гэтую магчымасьць, уключаючы інструкцыю пра тое, як яе ўстанавіць ў любой вікі, акрамя Wikimedia Commons, глядзіце [//mediawiki.org/wiki/Manual:$wgForeignFileRepos дакумэнтацыю].',
	'config-cc-error' => 'Выбар ліцэнзіі Creative Commons ня даў вынікаў.
Увядзіце назву ліцэнзіі ўручную.',
	'config-cc-again' => 'Выберыце яшчэ раз…',
	'config-cc-not-chosen' => 'Выберыце, якую ліцэнзію Creative Commons Вы жадаеце выкарыстоўваць і націсьніце «працягваць».',
	'config-advanced-settings' => 'Дадатковыя налады',
	'config-cache-options' => 'Налады кэшаваньня аб’ектаў:',
	'config-cache-help' => 'Кэшаваньне аб’ектаў павялічвае хуткасьць працы MediaWiki праз кэшаваньне зьвестак, якія часта выкарыстоўваюцца.
Вельмі рэкамэндуем уключыць гэта для сярэдніх і буйных сайтаў, таксама будзе карысна для дробных сайтаў.',
	'config-cache-none' => 'Без кэшаваньня (ніякія магчымасьці не страчваюцца, але хуткасьць працы буйных сайтаў можа зьнізіцца)',
	'config-cache-accel' => 'Кэшаваньне аб’ектаў PHP (APC, XCache ці WinCache)',
	'config-cache-memcached' => 'Выкарыстоўваць Memcached (патрабуе дадатковай канфігурацыі)',
	'config-memcached-servers' => 'Сэрвэры memcached:',
	'config-memcached-help' => 'Сьпіс IP-адрасоў, якія будуць выкарыстоўвацца Memcached.
Адрасы павінны быць у асобным радку з пазначэньнем порту, які будзе выкарыстоўвацца. Напрыклад:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Вы выбралі Memcached у якасьці тыпу Вашага кэша, але не пазначылі ніякага сэрвэра',
	'config-memcache-badip' => 'Вы ўвялі няслушны IP-адрас для Memcached: $1',
	'config-memcache-noport' => 'Вы не пазначылі порт для выкарыстаньня сэрвэрам Memcached: $1.
Калі Вы ня ведаеце порт, то па змоўчваньні выкарыстоўваецца 11211',
	'config-memcache-badport' => 'Нумар порту Memcached павінен быць паміж $1 і $2',
	'config-extensions' => 'Пашырэньні',
	'config-extensions-help' => 'Пашырэньні пададзеныя вышэй, былі знойдзеныя ў Вашай дырэкторыі <code>./extensions</code>.

Яны могуць патрабаваць дадатковых наладаў, але іх можна ўключыць зараз',
	'config-install-alreadydone' => "'''Папярэджаньне:''' здаецца, што Вы ўжо ўсталёўвалі MediaWiki і спрабуеце зрабіць гэтай зноў.
Калі ласка, перайдзіце на наступную старонку.",
	'config-install-begin' => 'Пасьля націску кнопкі «{{int:config-continue}}» пачнецца ўсталяваньне MediaWiki.
Калі Вы жадаеце што-небудзь зьмяніць, націсьніце кнопку «Вярнуцца».',
	'config-install-step-done' => 'зроблена',
	'config-install-step-failed' => 'не атрымалася',
	'config-install-extensions' => 'Уключаючы пашырэньні',
	'config-install-database' => 'Налада базы зьвестак',
	'config-install-schema' => 'Стварэньне схемы',
	'config-install-pg-schema-not-exist' => 'Схема PostgreSQL не існуе',
	'config-install-pg-schema-failed' => 'Немагчыма стварыць табліцу.
Упэўніцеся, што карыстальнік «$1» можа пісаць у схему «$2».',
	'config-install-pg-commit' => 'Захаваньне зьменаў',
	'config-install-pg-plpgsql' => 'Праверка падтрымкі мовы PL/pgSQL',
	'config-pg-no-plpgsql' => 'Вам неабходна ўсталяваць падтрымку мовы PL/pgSQL у базе зьвестак $1',
	'config-pg-no-create-privs' => 'Рахунак, які Вы пазначылі для ўсталяваньня ня мае дастаткова правоў для стварэньня рахунку.',
	'config-pg-not-in-role' => 'Пазначаны Вамі рахунак для ўэб-карыстальніка ўжо існуе.
Пазначаны Вамі рахунак для ўсталяваньня ня мае правоў і не зьяўляецца сябрам ролі ўэб-карыстальніка, таму немагчыма стварыць аб’екты, якія належаць ўэб-карыстальніку.

Цяпер MediaWiki патрабуе, каб табліцы належалі да ўэб-карыстальніку. Калі ласка, пазначце іншы рахунак, ці націсьніце кнопку «Вярнуцца» і пазначце карыстальніка з неабходнымі для ўсталяваньня правамі.',
	'config-install-user' => 'Стварэньне карыстальніка базы зьвестак',
	'config-install-user-alreadyexists' => 'Удзельнік «$1» ужо існуе',
	'config-install-user-create-failed' => 'Немагчыма стварыць ўдзельніка «$1»: $2',
	'config-install-user-grant-failed' => 'Немагчыма даць правы удзельніку «$1»: $2',
	'config-install-user-missing' => 'Пазначаны карыстальнік «$1» не існуе.',
	'config-install-user-missing-create' => 'Пазначаны карыстальнік «$1» не існуе.
Калі ласка, пазначце «стварыць рахунак», калі Вы жадаеце яго стварыць.',
	'config-install-tables' => 'Стварэньне табліцаў',
	'config-install-tables-exist' => "'''Папярэджаньне''': Выглядае, што табліцы MediaWiki ужо існуюць.
Стварэньне прапушчанае.",
	'config-install-tables-failed' => "'''Памылка''': немагчыма стварыць табліцы з-за наступнай памылкі: $1",
	'config-install-interwiki' => 'Запаўненьне табліцы інтэрвікі па змоўчваньні',
	'config-install-interwiki-list' => 'Немагчыма знайсьці файл <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Папярэджаньне''': выглядае, што табліца інтэрвікі ўжо запоўненая.
Сьпіс па змоўчваньні прапушчаны.",
	'config-install-stats' => 'Ініцыялізацыі статыстыкі',
	'config-install-keys' => 'Стварэньне сакрэтных ключоў',
	'config-insecure-keys' => "'''Папярэджаньне:''' {{PLURAL:$2|Ключ бясьпекі $1 створаны|Ключы бясьпекі $1 створаныя}} падчас усталяваньня, не зьяўляюцца поўнасьцю бясьпечнымі. Рэкамэндуецца зьмяніць {{PLURAL:$2|яго ўручную|іх уручную}}.",
	'config-install-sysop' => 'Стварэньне рахунку адміністратара',
	'config-install-subscribe-fail' => 'Немагчыма падпісацца на «mediawiki-announce»: $1',
	'config-install-subscribe-notpossible' => 'cURL не ўсталяваны, allow_url_fopen недаступны.',
	'config-install-mainpage' => 'Стварэньне галоўнай старонкі са зьместам па змоўчваньні',
	'config-install-extension-tables' => 'Стварэньне табліцаў для ўключаных пашырэньняў',
	'config-install-mainpage-failed' => 'Немагчыма ўставіць галоўную старонку: $1',
	'config-install-done' => "'''Віншуем!'''
Вы пасьпяхова ўсталявалі MediaWiki.

Праграма ўсталяваньня стварыла файл <code>LocalSettings.php</code>.
Ён утрымлівае ўсе Вашыя налады.

Вам неабходна загрузіць яго і захаваць у карэнную дырэкторыю Вашай вікі (у тую ж самую дырэкторыю, дзе знаходзіцца index.php). Загрузка павінна пачацца аўтаматычна.

Калі загрузка не пачалася, ці Вы яе адмянілі, Вы можаце перазапусьціць яе націснуўшы на спасылку ніжэй:

$3

'''Заўвага''': калі Вы гэтага ня зробіце зараз, то створаны файл ня будзе даступны Вам потым, калі Вы выйдзеце з праграмы ўсталяваньня  без яго загрузкі.

Калі Вы гэта зробіце, Вы можаце '''[$2 ўвайсьці ў Вашую вікі]'''.",
	'config-download-localsettings' => 'Загрузіць LocalSettings.php',
	'config-help' => 'дапамога',
	'config-nofile' => 'Файл «$1» ня знойдзены. Ці быў ён выдалены?',
	'mainpagetext' => "'''MediaWiki пасьпяхова ўсталяваная.'''",
	'mainpagedocfooter' => 'Глядзіце [//meta.wikimedia.org/wiki/Help:Contents дапаможнік карыстальніка] для атрыманьня інфармацыі па карыстаньні вікі-праграмамі.

== З чаго пачаць ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Сьпіс парамэтраў канфігурацыі]
* [//www.mediawiki.org/wiki/Manual:FAQ Частыя пытаньні MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Рассылка паведамленьняў пра зьяўленьне новых вэрсіяў MediaWiki]',
);

/** Bulgarian (български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'config-desc' => 'Инсталатор на МедияУики',
	'config-title' => 'Инсталиране на МедияУики $1',
	'config-information' => 'Информация',
	'config-localsettings-upgrade' => 'Беше открит файл <code>LocalSettings.php</code>.
За надграждане на съществуващата инсталация, необходимо е в кутията по-долу да се въведе стойността на <code>$wgUpgradeKey</code>.
Тази информация е налична в LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Беше открит файл LocalSettings.php.
За надграждане на наличната инсталация, необходимо е да се стартира update.php',
	'config-localsettings-key' => 'Ключ за надграждане:',
	'config-localsettings-badkey' => 'Предоставеният ключ е неправилен.',
	'config-upgrade-key-missing' => 'Беше открита съществуваща инсталация на МедияУики.
За надграждане на съществуващата инсталация, необходимо е да се постави следният ред в края на файла LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Съществуващият файл LocalSettings.php изглежда непълен.
Променливата $1 не е зададена.
Необходимо е да се редактира файлът LocalSettings.php и да се зададе променливата, след което да се натисне "Продължаване".',
	'config-localsettings-connection-error' => 'Възникна грешка при свързване с базата от данни чрез данните, посочени в LocalSettings.php или AdminSettings.php. Необходимо е да се коригират тези настройки преди повторен опит за свързване.

$1',
	'config-session-error' => 'Грешка при създаване на сесия: $1',
	'config-session-expired' => 'Срокът на валидност на данните от сесията са изтекли.
Продължителността на сесиите е настроена на $1.
Това може да бъде увеличено чрез настройване на <code>session.gc_maxlifetime</code> в php.ini.
Необходимо е рестартиране на инсталационния процес.',
	'config-no-session' => 'Данните за сесията бяха загубени!
Проверете вашия php.ini и се уверете, че на <code>session.save_path</code> е настроена подходящата директория.',
	'config-your-language' => 'Вашият език:',
	'config-your-language-help' => 'Избиране на език за използване по време на инсталацията.',
	'config-wiki-language' => 'Език на уикито:',
	'config-wiki-language-help' => 'Избиране на език, на който ще е основното съдържание на уикито.',
	'config-back' => '← Връщане',
	'config-continue' => 'Продължаване →',
	'config-page-language' => 'Език',
	'config-page-welcome' => 'Добре дошли в МедияУики!',
	'config-page-dbconnect' => 'Свързване с базата от данни',
	'config-page-upgrade' => 'Надграждане на съществуваща инсталация',
	'config-page-dbsettings' => 'Настройки на базата от данни',
	'config-page-name' => 'Име',
	'config-page-options' => 'Настройки',
	'config-page-install' => 'Инсталиране',
	'config-page-complete' => 'Готово!',
	'config-page-restart' => 'Рестартиране на инсталацията',
	'config-page-readme' => 'Информация за софтуера',
	'config-page-releasenotes' => 'Бележки за версията',
	'config-page-copying' => 'Лицензно споразумение',
	'config-page-upgradedoc' => 'Надграждане',
	'config-page-existingwiki' => 'Съществуващо уики',
	'config-help-restart' => 'Необходимо е потвърждение за изтриване на всички въведени и съхранени данни и започване отначало на процеса по инсталация.',
	'config-restart' => 'Да, започване отначало',
	'config-welcome' => '=== Проверка на средата ===
Извършени бяха основни проверки, за да се провери дали средата е подходяща за инсталиране на МедияУики.
Ако е необходима помощ по време на инсталацията, резултатите от направените проверки трябва също да бъдат предоставени.',
	'config-copyright' => "=== Авторски права и Условия ===

$1

Тази програма е свободен софтуер, който може да се променя и/или разпространява според Общия публичен лиценз на GNU, както е публикуван от Free Software Foundation във версия на Лиценза 2 или по-късна версия.

Тази програма се разпространява с надеждата, че ще е полезна, но '''без каквито и да е гаранции'''; без дори косвена гаранция за '''продаваемост''' или '''прогодност за конкретна употреба'''.
За повече подробности се препоръчва преглеждането на Общия публичен лиценз на GNU.

Към програмата трябва да е приложено <doclink href=Copying>копие на Общия публичен лиценз на GNU</doclink>; ако не, можете да пишете на Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. или да [http://www.gnu.org/copyleft/gpl.html го прочетете онлайн].",
	'config-sidebar' => '* [//www.mediawiki.org Сайт на МедияУики]
* [//www.mediawiki.org/wiki/Help:Contents Наръчник на потребителя]
* [//www.mediawiki.org/wiki/Manual:Contents Наръчник на администратора]
* [//www.mediawiki.org/wiki/Manual:FAQ ЧЗВ]
----
* <doclink href=Readme>Документация</doclink>
* <doclink href=ReleaseNotes>Бележки за версията</doclink>
* <doclink href=Copying>Авторски права</doclink>
* <doclink href=UpgradeDoc>Обновяване</doclink>',
	'config-env-good' => 'Средата беше проверена.
Инсталирането на МедияУики е възможно.',
	'config-env-bad' => 'Средата беше проверена.
Не е възможна инсталация на МедияУики.',
	'config-env-php' => 'Инсталирана е версия на PHP $1.',
	'config-env-php-toolow' => 'Инсталирана е версия на PHP $1.
МедияУики изисква версия PHP $2 или по-нова.',
	'config-unicode-using-utf8' => 'Използване на utf8_normalize.so от Brion Vibber за нормализация на Уникод.',
	'config-unicode-using-intl' => 'Използване на разширението [http://pecl.php.net/intl intl PECL] за нормализация на Уникод.',
	'config-unicode-pure-php-warning' => "'''Предупреждение''': [http://pecl.php.net/intl Разширението intl PECL] не е налично за справяне с нормализацията на Уникод, превключване към по-бавното изпълнение на чист PHP.
Ако сайтът е с голям трафик, препоръчително е запознаването с [//www.mediawiki.org/wiki/Unicode_normalization_considerations нормализацията на Уникод].",
	'config-unicode-update-warning' => "'''Предупреждение''': Инсталираната версия на Обвивката за нормализация на Unicode използва по-старата версия на библиотеката на [http://site.icu-project.org/ проекта ICU].
Необходимо е да [//www.mediawiki.org/wiki/Unicode_normalization_considerations инсталирате по-нова верия], в случай че сте загрижени за използването на Unicode.",
	'config-no-db' => 'Не може да бъде открит подходящ драйвер за база от данни! Необходимо е да се инсталира драйвер за база от данни за PHP.
Поддържат се следните типове базни от данни: $1.

Ако използвате споделен хостинг, помолете доставчика на услугата да инсталира подходящ драйвер за база от данни.
Ако сами сте компилирали PHP, преконфигурирайте го с включен клиент за база от данни, например чрез използване на <code>./configure --with-mysql</code>.
Ако сте инсталирали PHP от пакет за Debian или Убунту, необходимо е, също така, да инсталирате и модула php5-mysql.',
	'config-no-fts3' => "'''Предупреждение''': SQLite е компилирана без [//sqlite.org/fts3.html модула FTS3], затова възможностите за търсене няма да са достъпни.",
	'config-register-globals' => "'''Предупреждение: Настройката на PHP <code>[http://php.net/register_globals register_globals]</code> е включена.'''
'''При възможност е препоръчително тя да бъде изключена.'''
МедияУики ще работи, но сървърът е изложен на евентуални пропуски в сигурността.",
	'config-magic-quotes-runtime' => "'''Фатално: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] е активирана!'''
Това може да повреди непредвидимо въвеждането на данните.
Инсталацията на МедияУики е невъзможна докато тази настройка не бъде изключена.",
	'config-magic-quotes-sybase' => "'''Фатално: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] е активирана!'''
Това може да повреди непредвидимо въвеждането на данните.
Инсталацията на МедияУики е невъзможна докато тази настройка не бъде изключена.",
	'config-mbstring' => "'''Фатално: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] е активирана!'''
Това може да повреди непредвидимо въвеждането на данните.
Инсталацията на МедияУики е невъзможна докато тази настройка не бъде изключена.",
	'config-ze1' => "'''Фатално: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] е активирана!'''
Тази настройка причинява ужасни грешки в МедияУики.
Невъзможно е инсталирането и използването на МедияУики докато тази настройка не бъде изключена.",
	'config-safe-mode' => "'''Предупреждение:''' PHP работи в [http://www.php.net/features.safe-mode безопасен режим].
Това може да създаде проблеми, особено ако качването на файлове е разрешено, както и при поддръжката на <code>math</code>.",
	'config-xml-bad' => 'Липсва XML модулът на PHP.
МедияУики се нуждае от някои функции от този модул и няма да работи при наличната конфигурация.
При Mandrake, необходимо е да се инсталира пакетът php-xml.',
	'config-pcre' => 'Липсва модулът PCRE.
За да работи, МедияУики изисква съвместими с Perl функии за регилярни изрази.',
	'config-pcre-no-utf8' => "'''Фатално''': Модулът PCRE на PHP изглежда е компилиран без поддръжка на PCRE_UTF8.
За да функционира правилно, МедияУики изисква поддръжка на UTF-8.",
	'config-memory-raised' => '<code>memory_limit</code> на PHP е $1, увеличаване до $2.',
	'config-memory-bad' => "'''Предупреждение:''' <code>memory_limit</code> на PHP е $1.
Стойността вероятно е твърде ниска.
Възможно е инсталацията да се провали!",
	'config-ctype' => "'''Фатално''': Необходимо е PHP да бъде компилиран с поддръжка на [http://www.php.net/manual/en/ctype.installation.php разширението Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] е инсталиран',
	'config-apc' => '[http://www.php.net/apc APC] е инсталиран',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] е инсталиран',
	'config-no-cache' => "'''Предупреждение:''' Не бяха открити [http://www.php.net/apc APC] [http://xcache.lighttpd.net/ XCache] или [http://www.iis.net/download/WinCacheForPhp WinCache].
Обектното кеширане не е включено.",
	'config-diff3-bad' => 'GNU diff3 не беше намерен.',
	'config-imagemagick' => 'Открит е ImageMagick: <code>$1</code>.
Преоразмеряването на картинки ще бъде включено ако качването на файлове бъде разрешено.',
	'config-gd' => 'Открита е вградена графичната библиотека GD.
Ако качването на файлове бъде включено, ще бъде включена възможността за преоразмеряване на картинки.',
	'config-no-scaling' => 'Не са открити библиотеките GD или ImageMagick.
Преоразмеряването на картинки ще бъде изключено.',
	'config-no-uri' => "'''Грешка:''' Не може да се определи текущия адрес.
Инсталация беше прекратена.",
	'config-using-server' => 'Използване на сървърното име "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Използване на сървърния адрес (URL) "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''Предупреждение:''' Папката по подразбиране за качване <code>$1</code> е уязвима от изпълнение на зловредни скриптове.
Въпреки че МедияУики извършва проверка за заплахи в сигурността на всички качени файлове, силно препоръчително е да се [//www.mediawiki.org/wiki/Manual:Security#Upload_security затвори тази уязвимост в сигурността] преди разрешаване за качване на файлове.",
	'config-brokenlibxml' => 'Вашата система използа комбинация от версии на PHP и libxml2, които са с много грешки и могат да причинят скрити повреди на данните в МедияУики или други уеб приложения.
Необходимо е обновяване до PHP 5.2.9 или по-нова версия и libxml2 2.7.3 или по-нова версия ([//bugs.php.net/bug.php?id=45996 докладвана грешка при PHP]).
Инсталацията беше прекратена.',
	'config-using531' => 'МедияУики не може да се използва с PHP $1 заради проблем с референтните параметри за <code>__call()</code>.
За разрешаване на този проблем е необходимо да се обнови до PHP 5.3.2 или по-нова версия или да се инсталира по-стара версия, напр. PHP 5.3.0.
Инсталацията беше прекратена.',
	'config-suhosin-max-value-length' => 'Suhosin е инсталиран и ограничава дължината на параметъра GET на $1 байта. Компонентът на МедияУики ResourceLoader ще може да пренебрегне частично това ограничение, но това ще намали производителността. По възможност е препоръчително да се настрои suhosin.get.max_value_length на 1024 или по-голяма стойност в php.ini и в LocalSettings.php да се настрои $wgResourceLoaderMaxQueryLength със същата стойност.',
	'config-db-type' => 'Тип на базата от данни:',
	'config-db-host' => 'Хост на базата от данни:',
	'config-db-host-help' => 'Ако базата от данни е на друг сървър, в кутията се въвежда името на хоста или IP адреса.

Ако се използва споделен уеб хостинг, доставчикът на услугата би трябвало да е предоставил в документацията си коректния хост.

Ако инсталацията протича на Windows-сървър и се използва MySQL, използването на "localhost" може да е неприемливо. В такива случаи се използва "127.0.0.1" за локален IP адрес.

При използване на PostgreSQL, това поле се оставя празно, за свързване чрез Unix socket.',
	'config-db-host-oracle' => 'TNS на базата данни:',
	'config-db-wiki-settings' => 'Идентифициране на това уики',
	'config-db-name' => 'Име на базата от данни:',
	'config-db-name-help' => 'Избира се име, което да идентифицира уикито.
То не трябва да съдържа интервали.

Ако се използва споделен хостинг, доставчикът на услугата би трябвало да е предоставил или име на базата от данни, която да бъде използвана, или да позволява създаването на бази от данни чрез контролния панел.',
	'config-db-name-oracle' => 'Схема на базата от данни:',
	'config-db-install-account' => 'Потребителска сметка за инсталацията',
	'config-db-username' => 'Потребителско име за базата от данни:',
	'config-db-password' => 'Парола за базата от данни:',
	'config-db-password-empty' => 'Въведете парола за новия потребител на базата от данни: $1.
Въпреки че е допустимо да се създават потребители без пароли, това е незащитено действие.',
	'config-db-install-username' => 'Въвежда се потребителско име, което ще се използва за свързване с базата от данни по време на процеса по инсталация.
Това не е потребителско име за сметка в МедияУики; това е потребителско име за базата от данни.',
	'config-db-install-password' => 'Въвежда се парола, която ще бъде използвана за свързване с базата от данни по време на инсталационния процес.
Това не е парола за сметка в МедияУики; това е парола за базата от данни.',
	'config-db-install-help' => 'Въвеждат се потребителско име и парола, които ще бъдат използвани за свързване с базата от данни по време на инсталационния процес.',
	'config-db-account-lock' => 'Използване на същото потребителско име и парола по време на нормална работа',
	'config-db-wiki-account' => 'Потребителска сметка за нормална работа',
	'config-db-wiki-help' => 'Въвежда се потребителско име и парола, които ще се използват при нормалното функциониране на уикито.
Ако сметката не съществува и използваната при инсталацията сметка има необходимите права, тази потребителска сметка ще бъде създадена с минималните необходими права за работа с уикито.',
	'config-db-prefix' => 'Представка за таблиците в базата от данни:',
	'config-db-prefix-help' => 'Ако е необходимо да се сподели базата от данни между няколко уикита или между МедияУики и друго уеб приложение, може да се добави представка пред имената на таблиците, за да се избегнат конфликти.
Не се използват интервали.

Това поле обикновено се оставя празно.',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 бинарно',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 с обратна съвестимост с UTF-8',
	'config-mysql-old' => 'Изисква се MySQL $1 или по-нова версия, наличната версия е $2.',
	'config-db-port' => 'Порт на базата от данни:',
	'config-db-schema' => 'Схема за МедияУики',
	'config-db-schema-help' => 'Схемата по-горе обикновено е коректна.
Промени се извършват ако наистина е необходимо.',
	'config-pg-test-error' => "Невъзможно свързване с базата данни '''$1''': $2",
	'config-sqlite-dir' => 'Директория за данни на SQLite:',
	'config-sqlite-dir-help' => "SQLite съхранява всички данни в един файл.

По време на инсталацията уеб сървърът трябва да има права за писане в посочената директория.

Тя '''не трябва''' да е достъпна през уеб, затова не е там, където са PHP файловете.

Инсталаторът ще съхрани заедно с нея файл <code>.htaccess</code>, но ако този метод пропадне, някой може да придобие даостъп до суровите данни от базата от данни.
Това включва сурови данни за потребителите (адреси за е-поща, хеширани пароли), както и изтрити версии на страници и друга чувствителна и с ограничен достъп информация от и за уикито.

Базата от данни е препоръчително да се разположи на друго място, например в <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'МедияУики поддържа следните системи за бази от данни:

$1

Ако не виждате желаната за използване система в списъка по-долу, следвайте инструкциите за активиране на поддръжка по-горе.',
	'config-support-mysql' => '* $1 е най-добре поддържаната система за база от данни, с най-добра поддръжка от МедияУики ([http://www.php.net/manual/en/mysql.installation.php Как се компилира PHP с поддръжка на MySQL])',
	'config-support-postgres' => '* $1 е популярна система за бази от данни с отворен изходен код, която е алтернатива на MySQL ([http://www.php.net/manual/en/pgsql.installation.php как се компилира PHP с поддръжка на PostgreSQL]). Възможно е все още да има грешки, затова не се препоръчва да се използва в общодостъпна среда.',
	'config-support-sqlite' => '* $1 е лека система за база от данни, която е много добре поддържана. ([http://www.php.net/manual/en/pdo.installation.php Как се компилира PHP с поддръжка на SQLite], използва PDO)',
	'config-support-oracle' => '* $1 е комерсиална корпоративна база от данни. ([http://www.php.net/manual/en/oci8.installation.php Как се компилира PHP с поддръжка на OCI8])',
	'config-support-ibm_db2' => '* $1 е комерсиална фирмена база от данни.',
	'config-header-mysql' => 'Настройки за MySQL',
	'config-header-postgres' => 'Настройки за PostgreSQL',
	'config-header-sqlite' => 'Настройки за SQLite',
	'config-header-oracle' => 'Настройки за Oracle',
	'config-header-ibm_db2' => 'Настройки за IBM DB2',
	'config-invalid-db-type' => 'Невалиден тип база от данни',
	'config-missing-db-name' => 'Необходимо е да се въведе стойност за "Име на базата от данни"',
	'config-missing-db-host' => 'Необходимо е да се въведе стойност за "Хост на базата от данни"',
	'config-missing-db-server-oracle' => 'Необходимо е да се въведе стойност за "Database TNS"',
	'config-invalid-db-server-oracle' => 'Невалиден TNS на базата от данни "$1".
Допустими са само ASCII букви (a-z, A-Z), цифри (0-9), символите за долна черта (_) и точка (.).',
	'config-invalid-db-name' => 'Невалидно име на базата от данни "$1".
Използват се само ASCII букви (a-z, A-Z), цифри (0-9), долни черти (_) и тирета (-).',
	'config-invalid-db-prefix' => 'Невалидна представка за базата от данни "$1".
Позволени са само ASCII букви (a-z, A-Z), цифри (0-9), долни черти (_) и тирета (-).',
	'config-connection-error' => '$1.

Необходимо е да се проверят хостът, потребителското име и паролата, след което да се опита отново.',
	'config-invalid-schema' => 'Невалидна схема за МедияУики "$1".
Допустими са само ASCII букви (a-z, A-Z), цифри (0-9) и долни черти (_).',
	'config-db-sys-create-oracle' => 'Инсталаторът поддържа само сметка SYSDBA за създаване на нова сметка.',
	'config-db-sys-user-exists-oracle' => 'Потребителската сметка "$1" вече съществува. SYSDBA може да се използва само за създаване на нова сметка!',
	'config-postgres-old' => 'Изисква се PostgreSQL $1 или по-нова версия, наличната версия е $2.',
	'config-sqlite-name-help' => 'Избира се име, което да идентифицира уикито.
Не се използват интервали или тирета.
Това име ще се използва за име на файла за данни на SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Дикректорията за данни <code><nowiki>$1</nowiki></code> не може да бъде създадена, тъй като уеб сървърът няма права за писане в родителската директория <code><nowiki>$2</nowiki></code>.

Инсталаторът разпознава потребителското име, с което работи уеб сървърът.
Уверете се, че той притежава права за писане в директорията <code><nowiki>$3</nowiki></code> преди да продължите.
В Unix/Линукс системи можете да използвате:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Дикректорията за данни <code><nowiki>$1</nowiki></code> не може да бъде създадена, тъй като уеб сървърът няма права за писане в родителската директория <code><nowiki>$2</nowiki></code>.

Инсталаторът не може да определи потребителското име, с което работи уеб сървърът.
Уверете се, че в директория <code><nowiki>$3</nowiki></code> може да бъде писано от уебсървъра (или от други потребители!) преди да продължите.
На Unix/Линукс системи можете да използвате:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Грешка при създаване на директорията за данни "$1".
Проверете местоположението ѝ и опитайте отново.',
	'config-sqlite-dir-unwritable' => 'Уебсървърът няма права за писане в директория "$1".
Променете правата му така, че да може да пише в нея, и опитайте отново.',
	'config-sqlite-connection-error' => '$1.

Проверете директорията за данни и името на базата от данни по-долу и опитайте отново.',
	'config-sqlite-readonly' => 'Файлът <code>$1</code> няма права за писане.',
	'config-sqlite-cant-create-db' => 'Файлът за базата от данни <code>$1</code> не може да бъде създаден.',
	'config-sqlite-fts3-downgrade' => 'Липсва поддръжката на FTS3 за PHP, извършен беше downgradе на таблиците',
	'config-can-upgrade' => "В базата от данни има таблици за МедияУики.
За надграждането им за MediaWiki $1, натиска се '''Продължаване'''.",
	'config-upgrade-done' => "Обновяването приключи.

Вече е възможно [$1 да използвате уикито].

Ако е необходимо, възможно е файлът <code>LocalSettings.php</code> да бъде създаден отново чрез натискане на бутона по-долу.
Това '''не е препоръчително действие''', освен ако не срещате затруднения с уикито.",
	'config-upgrade-done-no-regenerate' => 'Обновяването приключи.

Вече е възможно [$1 да използвате уикито].',
	'config-regenerate' => 'Създаване на LocalSettings.php →',
	'config-show-table-status' => 'Заявката SHOW TABLE STATUS не сполучи!',
	'config-unknown-collation' => "'''Предупреждение:''' Базата от данни използва неразпозната колация.",
	'config-db-web-account' => 'Сметка за уеб достъп до базата от данни',
	'config-db-web-help' => 'Избиране на потребителско име и парола, които уеб сървърът ще използва да се свързва с базата от данни при обичайната работа на уикито.',
	'config-db-web-account-same' => 'Използване на същата сметка като при инсталацията.',
	'config-db-web-create' => 'Създаване на сметката ако все още не съществува',
	'config-db-web-no-create-privs' => 'Посочената сметка за инсталацията не разполага с достатъчно права за създаване на нова сметка.
Необходимо е посочената сметка вече да съществува.',
	'config-mysql-engine' => 'Хранилище на данни:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Предупреждение''': Избрана е MyISAM като система за складиране в MySQL, която не се препоръчва за използване с МедияУики, защото:
* почти не поддържа паралелност заради заключване на таблиците
* е по-податлива на повреди в сравнение с други системи
* кодът на МедияУики не винаги поддържа MyISAM коректно

Ако инсталацията на MySQL поддържа InnoDB, силно е препоръчително да се използва тя.
Ако инсталацията на MySQL не поддържа InnoDB, вероятно е време за обновяване.",
	'config-mysql-engine-help' => "'''InnoDB''' почти винаги е най-добрата възможност заради навременната си поддръжка.

'''MyISAM''' може да е по-бърза при инсталации с един потребител или само за четене.
Базите от данни MyISAM се повреждат по-често от InnoDB.",
	'config-mysql-charset' => 'Набор от символи в базата от данни:',
	'config-mysql-binary' => 'Бинарен',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "В '''бинарен режим''' МедияУики съхранява текстовете в UTF-8 в бинарни полета в базата от данни.
Това е по-ефективно от UTF-8 режима на MySQL и позволява използването на пълния набор от символи в Уникод.

В '''UTF-8 режим''' MySQL ще знае в кой набор от символи са данните от уикито и ще може да ги показва и променя по подходящ начин, но няма да позволява складиране на символи извън [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Основния многоезичен набор].",
	'config-site-name' => 'Име на уикито:',
	'config-site-name-help' => 'Това име ще се показва в заглавната лента на браузъра и на различни други места.',
	'config-site-name-blank' => 'Необходимо е да се въведе име на уикито.',
	'config-project-namespace' => 'Именно пространство на проекта:',
	'config-ns-generic' => 'Проект',
	'config-ns-site-name' => 'Същото като името на уикито: $1',
	'config-ns-other' => 'Друго (уточняване)',
	'config-ns-other-default' => 'МоетоУики',
	'config-project-namespace-help' => 'Следвайки примера на Уикипедия, много уикита съхраняват страниците си с правила в "\'\'\'именно пространство на проекта\'\'\'", отделно от основното съдържание.
Всички заглавия на страниците в това именно пространство започват с определена представка, която може да бъде зададена тук.
Обикновено представката произлиза от името на уикито, но не може да съдържа символи като "#" или ":".',
	'config-ns-invalid' => 'Посоченото именно пространство "<nowiki>$1</nowiki>" е невалидно.
Необходимо е да бъде посочено друго.',
	'config-ns-conflict' => 'Посоченото именно пространство "<nowiki>$1</nowiki>" е в конфликт с използваното по подразбиране именно пространство MediaWiki.
Необходимо е да се посочи друго именно пространство.',
	'config-admin-box' => 'Администраторска сметка',
	'config-admin-name' => 'Потребителско име:',
	'config-admin-password' => 'Парола:',
	'config-admin-password-confirm' => 'Парола (повторно):',
	'config-admin-help' => 'Въвежда се предпочитаното потребителско име, например "Иванчо Иванчев".
Това ще е потребителското име, което администраторът ще използва за влизане в уикито.',
	'config-admin-name-blank' => 'Необходимо е да бъде въведено потребителско име на администратора.',
	'config-admin-name-invalid' => 'Посоченото потребителско име "<nowiki>$1</nowiki>" е невалидно.
Необходимо е да се посочи друго.',
	'config-admin-password-blank' => 'Неовходимо е да се въведе парола за администраторската сметка.',
	'config-admin-password-same' => 'Паролата не трябва да е същата като потребителското име.',
	'config-admin-password-mismatch' => 'Двете въведени пароли не съвпадат.',
	'config-admin-email' => 'Адрес за електронна поща:',
	'config-admin-email-help' => 'Въвеждането на адрес за е-поща позволява получаване на е-писма от другите потребители на уикито, възстановяване на изгубена или забравена парола, оповестяване при промени в страниците от списъка за наблюдение. Това поле може да бъде оставено празно.',
	'config-admin-error-user' => 'Възникна вътрешна грешка при създаване на администратор с името "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Възникна вътрешна грешка при задаване на парола за администратора "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Въведен е невалиден адрес за електронна поща',
	'config-subscribe' => 'Абониране за [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce пощенския списък за нови версии].',
	'config-subscribe-help' => 'Това е пощенски списък с малко трафик, който се използва за съобщения при излизане на нови версии, както и за важни проблеми със сигурността.
Абонирането е препоръчително, както и надграждането на инсталацията на МедияУики при излизането на нова версия.',
	'config-subscribe-noemail' => 'Опитахте да се абонирате за пощенския списък за нови версии без да посочите адрес за електронна поща.
Необходимо е да се предостави адрес за електронна поща, в случай че желаете да се абонирате за пощенския списък.',
	'config-almost-done' => 'Инсталацията е почти готова!
Възможно е пропускане на оставащата конфигурация и моментално инсталиране на уикито.',
	'config-optional-continue' => 'Задаване на допълнителни въпроси.',
	'config-optional-skip' => 'Достатъчно, инсталиране на уикито.',
	'config-profile' => 'Профил на потребителските права:',
	'config-profile-wiki' => 'Традиционно уики',
	'config-profile-no-anon' => 'Необходимо е създаване на сметка',
	'config-profile-fishbowl' => 'Само одобрени редактори',
	'config-profile-private' => 'Затворено уики',
	'config-profile-help' => "Уикитата функционират най-добре, когато позволяват на възможно най-много хора да ги редактират.
В МедияУики лесно се преглеждат последните промени и се възстановяват пораженип от недобронамерени потребители.

Въпреки това мнозина смятат МедияУики за полезен софтуер по различни начини и често е трудно да се убедят всички от предимствата на уики модела.
Затова се предоставя възможност за избор.

Уикитата от типа '''{{int:config-profile-wiki}}''' позволяват на всички потребители да редактират, дори и без регистрация.
Уикитата от типа '''{{int:config-profile-no-anon}}''' позволяват достъп до страниците и редактирането им само след създаване на потребителска сметка.

Уики, което е '''{{int:config-profile-fishbowl}}''' позволява на всички да преглеждат страниците, но само предварително одобрени редактори могат да редактират съдържанието.
В '''{{int:config-profile-private}}''' само предварително одобрени потребители могат да четат и редактират съдържанието.

Детайлно обяснение на конфигурациите на потребителските права е достъпно след инсталацията в [//www.mediawiki.org/wiki/Manual:User_rights Наръчника за потребителски права].",
	'config-license' => 'Авторски права и лиценз:',
	'config-license-none' => 'Без лиценз',
	'config-license-cc-by-sa' => 'Криейтив Комънс Признание-Споделяне на споделеното',
	'config-license-cc-by' => 'Криейтив Комънс Признание',
	'config-license-cc-by-nc-sa' => 'Криейтив Комънс Признание-Некомерсиално-Споделяне на споделеното',
	'config-license-cc-0' => 'Криейтив Комънс Нула (обществено достояние)',
	'config-license-gfdl' => 'Лиценз за свободна документация на GNU 1.3 или по-нов',
	'config-license-pd' => 'Обществено достояние',
	'config-license-cc-choose' => 'Избиране на друг лиценз от Криейтив Комънс',
	'config-license-help' => "Много публични уикита поставят всички приноси под [http://freedomdefined.org/Definition/Bg свободен лиценз].
Това помага създаване на усещане за общност и насърчава дългосрочните приноси.
Това не е необходимо за частни или корпоративни уикита.

Ако е необходимо да се използват текстове от Уикипедия, както и Уикипедия да може да използва текстове от уикито, необходимо е да се избере лиценз '''Криейтив Комънс Признание-Споделяне на споделеното'''.

Лицензът за свободна документация на GNU е старият лиценз на съдържанието на Уикипедия.
Той все още е валиден лиценз, но някои негови условия са трудни за разбиране и правят по-сложни повторното използване и интерпретацията.",
	'config-email-settings' => 'Настройки за е-поща',
	'config-enable-email' => 'Разрешаване на изходящи е-писма',
	'config-enable-email-help' => 'За да работят възможностите за използване на е-поща, необходимо е [http://www.php.net/manual/en/mail.configuration.php настройките за поща на PHP] да бъдат конфигурирани правилно.
Ако няма да се използват услугите за е-поща в уикито, те могат да бъдат изключени тук.',
	'config-email-user' => 'Позволяване на потребителите да си изпращат е-писма през уикито',
	'config-email-user-help' => 'Позволяване на потребителите да си изпращат е-писма ако са разрешили това в настройките си.',
	'config-email-usertalk' => 'Оповестяване при промяна на потребителската беседа',
	'config-email-usertalk-help' => 'Позволява на потребителите да получават оповестяване при промяна на беседата им, ако това е разрешено в настройките им.',
	'config-email-watchlist' => 'Оповестяване за списъка за наблюдение',
	'config-email-watchlist-help' => 'Позволява на потребителите да получават оповестяване за техните наблюдавани страници, ако това е разрешено в настройките им.',
	'config-email-auth' => 'Потвърждаване на адреса за електронна поща',
	'config-email-auth-help' => "Ако тази настройка е включена, потребителите трябва да потвърдят адреса си за е-поща чрез препратка, която им се изпраща при настройване или промяна.
Само валидните адреси могат да получават е-писма от други потребители или да променят писмата за оповестяване.
Настройването на това е '''препоръчително''' за публични уикита заради потенциални злоупотреби с възможностите за електронна поща.",
	'config-email-sender' => 'Адрес за обратна връзка:',
	'config-email-sender-help' => 'Въвежда се адрес за електронна поща, който ще се използва за обратен адрес при изходящи е-писма.
Това е адресът, на който ще се получават върнатите и неполучени писма.
Много е-пощенски сървъри изискват поне домейн името да е валидно.',
	'config-upload-settings' => 'Картинки и качване на файлове',
	'config-upload-enable' => 'Позволяне качването на файлове',
	'config-upload-help' => 'Качването на файлове е възможно да доведе до пробели със сигурността на сървъра.
Повече информация по темата има в [//www.mediawiki.org/wiki/Manual:Security раздела за сигурност] в Наръчника.

За позволяване качването на файлове, необходимо е уебсървърът да може да записва в поддиректорията на МедияУики <code>images</code>.
След като това условие е изпълнено, функционалността може да бъде активирана.',
	'config-upload-deleted' => 'Директория за изтритите файлове:',
	'config-upload-deleted-help' => 'Избиране на директория, в която ще се складират изтритите файлове.
В най-добрия случай тя не трябва да е достъпна през уеб.',
	'config-logo' => 'Адрес на логото:',
	'config-logo-help' => 'Обликът по подразбиране на МедияУики вклчва място с размери 135х160 пиксела за лого над страничното меню.
Ако има наличен файл с подходящ размер, неговият адрес може да бъде посочен тук.

Ако не е необходимо лого, полето може да се остави празно.',
	'config-instantcommons' => 'Включване на Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] е функционалност, която позволява на уикитата да използват картинки, звуци и друга медиа от сайта на Уикимедия [//commons.wikimedia.org/ Общомедия].
За да е възможно това, МедияУики изисква достъп до Интернет.

Повече информация за тази функционалност, както и инструкции за настройване за други уикита, различни от Общомедия, е налична в [//mediawiki.org/wiki/Manual:$wgForeignFileRepos наръчника].',
	'config-cc-error' => 'Избирането на лиценз на Криейтив Комънс не даде резултат.
Необходимо е името на лиценза да бъде въведено ръчно.',
	'config-cc-again' => 'Повторно избиране...',
	'config-cc-not-chosen' => 'Изберете кой лиценз на Криейтив Комънс желаете и щракнете "proceed".',
	'config-advanced-settings' => 'Разширена конфигурация',
	'config-cache-options' => 'Настройки за обектното кеширане:',
	'config-cache-help' => 'Обектното кеширане се използва за подобряване на скоростта на МедияУики чрез кеширане на често използваните данни.
Силно препоръчително е на средните и големите сайтове да включат тази настройка, но малките също могат да се възползват от нея.',
	'config-cache-none' => 'Без кеширане (не се премахва от функционалността, но това влияе на скоростта на по-големи уикита)',
	'config-cache-accel' => 'PHP обектно кеширане (APC, XCache или WinCache)',
	'config-cache-memcached' => 'Използване на Memcached (изисква допълнителни настройки и конфигуриране)',
	'config-memcached-servers' => 'Memcached сървъри:',
	'config-memcached-help' => 'Списък с IP адреси за използване за Memcached.
Необходимо е да бъдат разделени по един на ред, както и да е посочен порта. Пример:
127.0.0.1:11211
192.168.1.25:1234',
	'config-memcache-needservers' => 'Избран е Memcached като складиращ тип, но не са посочени сървъри.',
	'config-memcache-badip' => 'Беше въведен невалиден IP адрес за Memcached: $1.',
	'config-memcache-noport' => 'Не е посочен порт за използване за Memcached сървъра: $1.
В случай, че не знаете порта, този по подразбиране е 11211.',
	'config-memcache-badport' => 'Портовете за Memcached трябва да бъдат между $1 и $2.',
	'config-extensions' => 'Разширения',
	'config-extensions-help' => 'Разширенията от списъка по-горе бяха открити в директорията <code>./extensions</code>.

Възможно е те да изискват допълнително конфигуриране, но сега могат да бъдат включени.',
	'config-install-alreadydone' => "'''Предупреждение:''' Изглежда вече сте инсталирали МедияУики и се опитвате да го инсталирате отново.
Продължете към следващата страница.",
	'config-install-begin' => 'Инсталацията на МедияУики ще започне след натискане на бутона "{{int:config-continue}}".
Ако желаете да направите промени, натиснете Връщане.',
	'config-install-step-done' => 'готово',
	'config-install-step-failed' => 'неуспешно',
	'config-install-extensions' => 'Добавяне на разширенията',
	'config-install-database' => 'Създаване на базата от данни',
	'config-install-schema' => 'Създаване на схема',
	'config-install-pg-schema-not-exist' => 'PostgreSQL схемата не съществува',
	'config-install-pg-schema-failed' => 'Създаването на таблиците пропадна.
Необходимо е потребител "$1" да има права за писане в схемата "$2".',
	'config-install-pg-plpgsql' => 'Проверяване за езика PL/pgSQL',
	'config-pg-no-plpgsql' => 'Необходимо е да се инсталира езикът PL/pgSQL в базата от данни $1',
	'config-pg-no-create-privs' => 'Посочената сметка за инсталацията не притежава достатъчно права за създаване на сметка.',
	'config-pg-not-in-role' => 'Посочената сметка за уеб потребител вече съществува.
Посочената сметка за инсталация не с права на суперпотребител и не е член на ролите на уеб потребителя и не може да създава обекти, собственост на уеб потребителя.

Текущо МедияУики изисква таблиците да са собственост на уеб потребителя. Необходимо е да се посочи друго потребителско име за уеб или да се натисне "връщане" и да се избере друг потребител за инсталацията с подходящите права.',
	'config-install-user' => 'Създаване на потребител за базата от данни',
	'config-install-user-alreadyexists' => 'Потребител „$1“ вече съществува',
	'config-install-user-create-failed' => 'Създаването на потребител „$1“ беше неуспешно: $2',
	'config-install-user-grant-failed' => 'Предоставянето на права на потребител "$1" беше неуспешно: $2',
	'config-install-user-missing' => 'Посоченият потребител " $1 "не съществува.',
	'config-install-user-missing-create' => 'Посоченият потребител "$1" не съществува.
Ако желаете да го създадете, поставете отметка на "създаване на сметка".',
	'config-install-tables' => 'Създаване на таблиците',
	'config-install-tables-exist' => "'''Предупреждение''': Таблиците за МедияУики изглежда вече съществуват.
Пропускане на създаването им.",
	'config-install-tables-failed' => "'''Грешка''': Създаването на таблиците пропадна и върна следната грешка: $1",
	'config-install-interwiki' => 'Попълване на таблицата с междууикитата по подразбиране',
	'config-install-interwiki-list' => 'Файлът <code>interwiki.list</code> не можа да бъде открит.',
	'config-install-interwiki-exists' => "'''Предупреждение''': Таблицата с междууикита изглежда вече съдържа данни.
Пропускане на списъка по подразбиране.",
	'config-install-stats' => 'Инициализиране на статистиките',
	'config-install-keys' => 'Генериране на тайни ключове',
	'config-insecure-keys' => "'''Предупреждение:''' {{PLURAL:$2|Сигурният ключ, създаден по време на инсталацията, не е напълно надежден|Сигурните ключове, създадени по време на инсталацията, не са напълно надеждни}} $1 . Обмислете да {{PLURAL:$2|го|ги}} смените ръчно.",
	'config-install-sysop' => 'Създаване на администраторска сметка',
	'config-install-subscribe-fail' => 'Невъзможно беше абонирането за mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'не е инсталиран cURL и allow_url_fopen не е налична.',
	'config-install-mainpage' => 'Създаване на Началната страница със съдържание по подразбиране',
	'config-install-extension-tables' => 'Създаване на таблици за включените разширения',
	'config-install-mainpage-failed' => 'Вмъкването на Началната страница беше невъзможно: $1',
	'config-install-done' => "'''Поздравления!'''
Инсталирането на МедияУики приключи успешно.

Инсталаторът създаде файл <code>LocalSettings.php</code>.
Той съдържа всичката необходима основна конфигурация на уикито.

Необходимо е той да бъде изтеглен и поставен в основната директория на уикито (директорията, в която е и index.php). Изтеглянето би трябвало да започне автоматично.

Ако изтеглянето не започне автоматично или е било прекратено, файлът може да бъде изтеглен чрез щракване на препратката по-долу:

$3

'''Забележка''': Ако това не бъде извършено сега, генерираният конфигурационен файл няма да е достъпен на по-късен етап ако не бъде изтеглен сега или инсталацията приключи без изтеглянето му.

Когато файлът вече е в основната директория, '''[$2 уикито ще е достъпно на този адрес]'''.",
	'config-download-localsettings' => 'Изтегляне на LocalSettings.php',
	'config-help' => 'помощ',
	'mainpagetext' => "'''Уикито беше успешно инсталирано.'''",
	'mainpagedocfooter' => 'Разгледайте [//meta.wikimedia.org/wiki/Help:Contents ръководството] за подробна информация относно използването на софтуера.

== Първи стъпки ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Конфигурационни настройки]
* [//www.mediawiki.org/wiki/Manual:FAQ ЧЗВ за МедияУики]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Пощенски списък относно нови версии на МедияУики]',
);

/** Banjar (Bahasa Banjar)
 * @author Ezagren
 * @author J Subhi
 */
$messages['bjn'] = array(
	'mainpagetext' => "'''MediaWiki sudah tapasang awan sukses'''.",
	'mainpagedocfooter' => 'Carii panjalasan [//meta.wikimedia.org/wiki/Help:Contents Panduan Pamuruk] gasan mamuruk parangkat lunak wiki

== Gasan bamula ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Daptar konpigurasi setélan]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki nang rancak ditakunakan]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki rilis milis]',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'config-desc' => 'মিডিয়াউইকির জন্য ইন্সটলার',
	'config-title' => 'মিডিয়াউইকি $1 ইন্সটলেশন',
	'config-information' => 'তথ্য',
	'config-localsettings-key' => 'হালনাগাদ কি',
	'config-session-error' => 'সেশন শুরুতে ত্রুটি: $1',
	'config-your-language' => 'আপনার ভাষা:',
	'config-your-language-help' => 'ইন্সটল করা সময় ব্যবহারের জন্য ভাষা নির্বাচন করুন।',
	'config-wiki-language' => 'উইকি ভাষা:',
	'config-back' => '← পেছনে',
	'config-continue' => 'অব্যাহত →',
	'config-page-language' => 'ভাষা',
	'config-page-welcome' => 'মিডিয়াউইকিতে স্বাগতম!',
	'config-page-dbconnect' => 'ডেটাবেজে সংযোগ দিন',
	'config-page-upgrade' => 'ইতিমধ্যেই থাকা ইন্সটলেশন হালনাগাদ করুন',
	'config-page-dbsettings' => 'ডেটাবেজ সেটিংস',
	'config-page-name' => 'নাম',
	'config-page-options' => 'অপশন',
	'config-page-install' => 'ইন্সটল',
	'config-page-complete' => 'সম্পূর্ণ!',
	'config-page-restart' => 'পুনরায় ইন্সটল প্রক্রিয়া চালু করুন',
	'config-page-readme' => 'এটি পড়ুন',
	'config-page-releasenotes' => 'রিলিজ নোট',
	'config-page-copying' => 'অনুলেপন',
	'config-page-upgradedoc' => 'হালনাগাদকরণ',
	'config-page-existingwiki' => 'ইতিমধ্যেই থাকা উইকি',
	'config-restart' => 'হ্যাঁ, পুনরায় চালু করুন',
	'config-env-php' => 'পিএইচপি $1 ইন্সটল করা হয়েছে।',
	'config-db-type' => 'ডেটাবেজের ধরন:',
	'config-db-host' => 'ডেটাবেজের হোস্ট:',
	'config-db-install-account' => 'ইন্সটলের জন্য ব্যবহারকারী অ্যাকাউন্ট',
	'config-db-username' => 'ডেটাবেজের ব্যবহারকারী নাম:',
	'config-db-password' => 'ডেটাবেজের শব্দচাবি:',
	'config-db-charset' => 'ডেটাবেজের অক্ষর সেট',
	'config-db-port' => 'ডেটাবেজ পোর্ট:',
	'config-db-schema' => 'মিডিয়াউইকির স্কিমা',
	'config-sqlite-dir' => 'এসকিউলাইট ডেটা ডিরেক্টরি:',
	'config-oracle-def-ts' => 'পূর্বনির্ধারিত টেবিলস্পেস',
	'config-oracle-temp-ts' => 'সাময়কি টেবিলস্পেস:',
	'config-type-ibm_db2' => 'আইবিএম ডিবি২',
	'config-header-mysql' => 'মাইএসকিউএল সেটিংস',
	'config-header-postgres' => 'পোস্টগ্রেএসকিউএল সেটিংস',
	'config-header-sqlite' => 'এসকিউলাইট সেটিংস',
	'config-header-oracle' => 'ওরাকল সেটিংস',
	'config-header-ibm_db2' => 'আইবিএম ডিবি২ সেটিংস',
	'config-invalid-db-type' => 'ডেটাবেজের ধরন অগ্রহযোগ্য',
	'config-missing-db-name' => 'আপনাকে অবশ্যই "ডেটাবেজ নাম"-এর জন্য একটি মান প্রবেশ করাতে হবে',
	'config-missing-db-host' => 'আপনাকে অবশ্যই "ডেটাবেজ হোস্ট"-এর জন্য একটি মান প্রবেশ করাতে হবে',
	'config-missing-db-server-oracle' => 'আপনাকে অবশ্যই "ডেটাবেজ টিএনএস"-এর জন্য একটি মান প্রবেশ করাতে হবে',
	'config-mysql-engine' => 'সংরক্ষণ ইঞ্জিন:',
	'config-mysql-innodb' => 'ইনোডিবি',
	'config-mysql-myisam' => 'মাইআইএসএএম',
	'config-mysql-charset' => 'ডেটাবেজের অক্ষর সেট',
	'config-mysql-binary' => 'বাইনারি',
	'config-mysql-utf8' => 'ইউটিএফ-৮',
	'config-site-name' => 'উইকির নাম:',
	'config-site-name-blank' => 'একটি সাইটের নাম প্রবেশ করান।',
	'config-project-namespace' => 'প্রকল্প নামস্থান:',
	'config-ns-generic' => 'প্রকল্প',
	'config-ns-site-name' => 'উইকি নামের অনুরুপ: $1',
	'config-ns-other' => 'অন্যান্য (নির্দিষ্ট করুন)',
	'config-ns-other-default' => 'মাইউইকি',
	'config-admin-box' => 'প্রশাসক অ্যাকাউন্ট',
	'config-admin-name' => 'আপনার নাম:',
	'config-admin-password' => 'শব্দচাবি:',
	'config-admin-password-confirm' => 'শব্দচাবি আবারও প্রবেশ করান:',
	'config-admin-name-blank' => 'একটি প্রশাসক ব্যবহারকারী নাম প্রবেশ করান',
	'config-admin-password-blank' => 'প্রশাসক অ্যাকাউন্টের জন্য পাসওয়ার্ড প্রবেশ করান।',
	'config-admin-password-same' => 'পাসওয়ার্ড অবশ্যই ব্যবহারকারী নামের অনুরুপ হওয়া চলবে না।',
	'config-admin-password-mismatch' => 'আপনি যে দুটি শব্দচাবি দিয়েছেন তারা পরস্পর মেলেনি।',
	'config-admin-email' => 'ইমেইল ঠিকানা:',
	'config-optional-continue' => 'আরও প্রশ্ন জিজ্ঞেস করুন।',
	'config-optional-skip' => 'আমি ইতিমধ্যেই বিরক্ত হয়ে গেছি, উইকিটি ইন্সটল করো।',
	'config-profile' => 'ব্যবহারকারী অধিকার প্রোফাইল:',
	'config-profile-wiki' => 'গতানুগতিক উইকি',
	'config-profile-no-anon' => 'অ্যাকাউন্ট তৈরি করা বাধ্যতামূলক',
	'config-profile-fishbowl' => 'শুধুমাত্র নির্ধারিত সম্পাদকদের  জন্যই',
	'config-profile-private' => 'ব্যক্তিগত উইকি',
	'config-license' => 'কপিরাইট ও লাইসেন্স:',
	'config-license-none' => 'কোনো লাইসেন্স ফুটার নেই',
	'config-license-cc-by-sa' => 'ক্রিয়েটিভ কমন্স অ্যাট্রিবিউশন শেয়ার অ্যালাইক',
	'config-license-cc-by-nc-sa' => 'ক্রিয়েটিভ কমন্স অ্যাট্রিবিউশন নন-কমার্শিয়াল শেয়ার অ্যালাইক',
	'config-license-cc-0' => 'ক্রিয়েটিভ কমন্স জিরো', # Fuzzy
	'config-license-pd' => 'পাবলিক ডোমেইন',
	'config-license-cc-choose' => 'একটি স্বনির্ধারিত ক্রিয়েটিভ কমন্স লাইসেন্ট নির্বাচন করুন',
	'config-email-settings' => 'ই-মেইল সেটিংস',
	'config-email-user' => 'ব্যবহারকারী-থেকে-ব্যবহারকারী ই-মেইল সুবিধা সক্রিয় করো',
	'config-upload-settings' => 'চিত্র এবং ফাইল আপলোড',
	'config-upload-enable' => 'ফাইল আপলোড সক্রিয় করো',
	'config-upload-deleted' => 'অপসারণকৃত ফাইলের ডিরেক্টরি:',
	'config-logo' => 'লোগো ইউআরএল:',
	'config-memcached-servers' => 'মেমক্যাশেকৃত সার্ভারসমূহ:',
	'config-extensions' => 'এক্সটেনশন',
	'config-install-step-done' => 'সম্পন্ন',
	'config-install-step-failed' => 'ব্যর্থ',
	'config-install-extensions' => 'এক্সটেনশন সহকারে',
	'config-install-database' => 'ডেটাবেজ সেটআপ',
	'config-install-pg-schema-not-exist' => 'পোস্টগ্রেএসকিউএল স্কিমা খুঁজে পাওয়া যায়নি।',
	'config-install-tables' => 'টেবিল তৈরি',
	'config-install-keys' => 'গোপন কি তৈরি',
	'config-help' => 'সাহায্য',
	'mainpagetext' => "'''মিডিয়াউইকি সফলভাবে ইন্সটল করা হয়েছে।'''",
	'mainpagedocfooter' => 'কী ভাবে উইকি সফটওয়্যারটি ব্যবহারকার করবেন, তা জানতে [//meta.wikimedia.org/wiki/Help:Contents ব্যবহারকারী সহায়িকা] দেখুন।

== কোথা থেকে শুরু করবেন ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings কনফিগারেশন সেটিংস তালিকা]
* [//www.mediawiki.org/wiki/Manual:FAQ প্রশ্নোত্তরে মিডিয়াউইকি]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce মিডিয়াউইকি রিলিজের মেইলিং লিস্ট]',
);

/** Bishnupria Manipuri (বিষ্ণুপ্রিয়া মণিপুরী)
 */
$messages['bpy'] = array(
	'mainpagetext' => "'''মিডিয়াউইকি হবাবালা ইয়া ইন্সটল ইল.'''",
	'mainpagedocfooter' => 'উইকি সফটৱ্যার এহান আতানির বারে দরকার ইলে [//meta.wikimedia.org/wiki/Help:Contents আতাকুরার গাইড]হানর পাঙলাক নেগা।

== অকরানিহান ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings কনফিগারেশন সেটিংর তালিকাহান]
* [//www.mediawiki.org/wiki/Manual:FAQ মিডিয়া উইকি আঙলাক]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce মিডিয়া উইকির ফঙপার বারে মেইলর তালিকাহান]',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Y-M D
 */
$messages['br'] = array(
	'config-desc' => 'Poellad staliañ MediaWIki',
	'config-title' => 'Staliadur MediaWiki $1',
	'config-information' => 'Titouroù',
	'config-localsettings-upgrade' => 'Kavet ez eus bet ur restr <code>LocalSettings.php</code>.
Evit hizivaat ar staliadur-se, merkit an talvoud <code>$wgUpgradeKey</code> er voest dindan.
E gavout a rit e LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Dinoet ez eus bet ur restr LocalSettings.php.
Evit lakaat ar staliadur-mañ a-live, implijit update.php e plas',
	'config-localsettings-key' => "Alc'hwez hizivaat :",
	'config-localsettings-badkey' => "Direizh eo an alc'hwez merket ganeoc'h",
	'config-upgrade-key-missing' => 'Kavet ez eus bet ur staliadur kent eus MediaWiki.
Evit hizivaat ar staliadur-se, ouzhpennit al linenn da-heul e traoñ ho restr LocalSettings.php:

$1',
	'config-localsettings-incomplete' => "Diglok e seblant bezañ ar restr LocalSettings.php zo anezhi dija.
An argemmenn $1 n'eo ket termenet.
Kemmit LocalSettings.php evit ma vo termenet an argemmenn-se, ha klikit war « Kenderc'hel ».",
	'config-localsettings-connection-error' => "C'hoarvezet ez eus ur fazi en ur gevreañ ouzh an diaz roadennoù oc'h implijout an arventennoù diferet e LocalSettings.php pe AdminSettings.php. Reizhit an arventennoù-se hag esaeit en-dro.

$1",
	'config-session-error' => "Fazi e-ser loc'hañ an dalc'h : $1",
	'config-session-expired' => "Kloz eo an dalc'h evit doare.
Kefluniet eo an dalc'hoù evit padout $1.
Kreskiñ ar pad-mañ a c'hallit dre e arventenniñ <code>session.gc_maxlifetime</code> e php.ini.
Adgrogit gant ar staliadur.",
	'config-no-session' => "Kolle teo bet roadennoù ho talc'h !
Gwiriit ar restr php.ini ha bezit sur emañ staliet <code>session.save_path</code> en ur c'havlec'h a zere.",
	'config-your-language' => 'Ho yezh :',
	'config-your-language-help' => 'Dibabit ur yezh da implijout e-pad an argerzh staliañ.',
	'config-wiki-language' => 'Yezh ar wiki :',
	'config-wiki-language-help' => 'Diuzañ ar yezh a vo implijet ar muiañ er wiki.',
	'config-back' => '← Distreiñ',
	'config-continue' => "Kenderc'hel →",
	'config-page-language' => 'Yezh',
	'config-page-welcome' => 'Degemer mat e MediaWiki !',
	'config-page-dbconnect' => "Kevreañ d'an diaz roadennoù",
	'config-page-upgrade' => 'Hizivaat ar staliadur a zo dioutañ',
	'config-page-dbsettings' => 'Arventennoù an diaz roadennoù',
	'config-page-name' => 'Anv',
	'config-page-options' => 'Dibarzhioù',
	'config-page-install' => 'Staliañ',
	'config-page-complete' => 'Graet !',
	'config-page-restart' => 'Adlañsañ ar staliadur',
	'config-page-readme' => 'Lennit-me',
	'config-page-releasenotes' => 'Notennoù stumm',
	'config-page-copying' => 'O eilañ',
	'config-page-upgradedoc' => 'O hizivaat',
	'config-page-existingwiki' => 'Wiki zo anezhañ dija',
	'config-help-restart' => "Ha c'hoant hoc'h eus da ziverkañ an holl roadennoù hoc'h eus ebarzhet ha da adlañsañ an argerzh staliañ ?",
	'config-restart' => "Ya, adloc'hañ anezhañ",
	'config-welcome' => "=== Gwiriadennoù a denn d'an endro ===
Rekis eo un nebeud gwiriadennoù diazez da welet hag azas eo an endro evit gallout staliañ MediaWiki.
Dleout a rafec'h merkañ disoc'hoù ar gwiriadennoù-se m'hoc'h eus ezhomm skoazell e-pad ar staliadenn.",
	'config-copyright' => "=== Gwiriañ aozer ha Termenoù implijout ===

$1

Ur meziant frank eo ar programm-mañ; gallout a rit skignañ anezhañ ha/pe kemmañ anezhañ dindan termenoù ar GNU Aotre-implijout Foran Hollek evel m'emañ embannet gant Diazezadur ar Meziantoù Frank; pe diouzh stumm 2 an aotre-implijout, pe (evel mar karit) diouzh ne vern pe stumm nevesoc'h.

Ingalet eo ar programm gant ar spi e vo talvoudus met n'eus '''tamm gwarant ebet'''; hep zoken gwarant empleg ar '''varc'hadusted''' pe an '''azaster ouzh ur pal bennak'''. Gwelet ar GNU Aotre-Implijout Foran Hollek evit muioc'h a ditouroù.

Sañset oc'h bezañ resevet <doclink href=Copying>un eilskrid eus ar GNU Aotre-implijout Foran Hollek</doclink> a-gevret gant ar programm-mañ; ma n'hoc'h eus ket, skrivit da Diazezadur ar Meziantoù Frank/Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, SUA pe [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html lennit anezhañ enlinenn].",
	'config-sidebar' => "* [//www.mediawiki.org MediaWiki degemer]
* [//www.mediawiki.org/wiki/Help:Contents Sturlevr an implijerien]
* [//www.mediawiki.org/wiki/Manual:Contents Sturlevr ar verourien]
* [//www.mediawiki.org/wiki/Manual:FAQ FAG]
----
* <doclink href=Readme>Lennit-me</doclink>
* <doclink href=ReleaseNotes>Notennoù embann</doclink>
* <doclink href=Copying>Oc'h eilañ</doclink>
* <doclink href=UpgradeDoc>O hizivaat</doclink>",
	'config-env-good' => 'Gwiriet eo bet an endro.
Gallout a rit staliañ MediaWiki.',
	'config-env-bad' => "Gwiriet eo bet an endro.
Ne c'hallit ket staliañ MediaWiki.",
	'config-env-php' => 'Staliet eo PHP $1.',
	'config-env-php-toolow' => "Staliet eo PHP $1.
Nemet eo rekis PHP $2 pe nevesoc'h evit MediaWiki.",
	'config-unicode-using-utf8' => "Oc'h implijout utf8_normalize.so gant Brion Vibber evit ar reolata Unicode.",
	'config-unicode-using-intl' => "Oc'h implijout [http://pecl.php.net/intl an astenn PECL intl] evit ar reolata Unicode.",
	'config-unicode-pure-php-warning' => "'''Diwallit''' : N'haller ket kaout an [http://pecl.php.net/intl intl PECL astenn] evit merañ reoladur Unicode, a zistro d'ar stumm gorrek emplementet e-PHP.
Ma lakait da dreiñ ul lec'hienn darempredet-stank e vo mat deoc'h lenn un tammig bihan diwar-benn se war [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode normalization]. (e saozneg)",
	'config-unicode-update-warning' => "'''Diwallit''': ober a ra stumm staliet endalc'her skoueriekaat Unicode gant ur stumm kozh eus [http://site.icu-project.org/ levraoueg meziantoù ar raktres ICU].
Dleout a rafec'h [//www.mediawiki.org/wiki/Unicode_normalization_considerations hizivaat] ma seblant deoc'h bezañ pouezus ober gant Unicode.",
	'config-no-db' => "N'eus ket bet gallet kavout ur sturier diazoù roadennoù a zere ! Ret eo deoc'h staliañ ur sturier diazoù roadennoù evit PHP.
Skoret eo an diazoù roadennoù da-heul : $1.

Ma rit gant un herberc'hiañ kenrannet, goulennit digant ho herberc'hier staliañ ur sturier diaz roadennoù azas.
Ma kempunit PHP c'hwi hoc'h-unan, adkeflugnit-eñ en ur weredekaat un arval diaz roadennoù, da skouer en ur ober gant <code>./configure --mysql</code>.
M'hoc'h eus staliet PHP adalek ur pakad Debian pe Ubuntu, eo ret deoc'h staliañ ar vodulenn php5-mysql ivez.",
	'config-no-fts3' => "'''Diwallit ''': Kempunet eo SQLite hep ar [//sqlite.org/fts3.html vodulenn FTS3]; ne vo ket posupl ober gant an arc'hwelioù klask er staliadur-mañ",
	'config-register-globals' => "'''Diwallit : Gweredekaet eo dibarzh <code>[http://php.net/register_globals register_globals]</code> PHP.'''
'''Diweredekait anezhañ ma c'hallit.'''
Mont a raio MediaWiki en-dro met fazioù surentez a c'hallo c'hoari war ho servijer",
	'config-magic-quotes-runtime' => "'''Fazi groñs : gweredekaet eo [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] !'''
Breinañ a ra an dibarzh-mañ ar roadennoù en ur mod dic'hortoz.
N'hallit ket staliañ pe ober gant MediaWiki e-keit ha m'eo gweredekaet an dibarzh-se.",
	'config-magic-quotes-sybase' => "'''Fazi groñs : gweredekaet eo [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] !'''
Breinañ a ra an dibarzh-mañ ar roadennoù en ur mod dic'hortoz.
N'hallit ket staliañ pe ober gant MediaWiki e-keit ha m'eo gweredekaet an dibarzh-se.",
	'config-mbstring' => "'''Fazi groñs : gweredekaet eo [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] !'''
Degas a ra an dibarzh-mañ fazioù ha gallout a ra breinañ ar roadennoù en ur mod dic'hortoz.
N'hallit ket staliañ pe ober gant MediaWiki e-keit ha m'eo gweredekaet an dibarzh-se.",
	'config-ze1' => "'''Fazi diremed : [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mod] zo gweredekaet !'''
An dibarzh-mañ zo kaoz da zrein euzhus gant MediaWiki.
Ne c'hallit ket staliañ nag implijout MediaWiki keit ha m'eo gweredekaet an dibarzh-mañ.",
	'config-safe-mode' => "'''Diwallit :''' Gweredekaet eo [http://www.php.net/features.safe-mode mod surentez] PHP.
Kudennoù a c'hall sevel abalamour da gement-se, dreist-holl ma pellgargit restroù ha ma skorit <code>math</code>.",
	'config-xml-bad' => "Mankout a ra modulenn XML PHP.
Ezhomm en deus MediaWiki eus arc'hwelioù zo eus ar vodulenn-se ha ne'z aio ket en-dro gant ar c'hefluniadur zo.
M'emaoc'h gant Mandrake, stailhit pakad php-xml.",
	'config-pcre' => "Evit doare e vank ar vodulenn skorañ PCRE.
Evit mont en-dro plaen en deus ezhomm MediaWiki eus an arc'hwelioù jediñ reoliek kenglotus gant Perl.",
	'config-pcre-no-utf8' => "'''Fazi groñs ''': evit doare eo bet kempunet modulenn PCRE PHP hep ar skor PCRE_UTF8.
Ezhomm en deus MediaWiki eus UTF-8 evit mont plaen en-dro.",
	'config-memory-raised' => '<code>memory_limit</code> ar PHP zo $1, kemmet e $2.',
	'config-memory-bad' => "'''Diwallit :''' Da $1 emañ arventenn <code>memory_limit</code> PHP.
Re izel eo moarvat.
Marteze e c'hwito ar staliadenn !",
	'config-xcache' => 'Staliet eo [http://xcache.lighttpd.net/ XCache]',
	'config-apc' => 'Staliet eo [http://www.php.net/apc APC]',
	'config-wincache' => 'Staliet eo [http://www.iis.net/download/WinCacheForPhp WinCache]',
	'config-no-cache' => "'''Diwallit:''' N'eus ket bet gallet kavout [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] pe [http://www.iis.net/download/WinCacheForPhp WinCache].
N'eo ket gweredekaet ar c'hrubuilhañ traezoù.",
	'config-diff3-bad' => "N'eo ket bet kavet GNU diff3.",
	'config-imagemagick' => "ImageMagick kavet : <code>$1</code>.
Gweredekaet e vo ar bihanaat skeudennoù ma vez gweredekaet ganeoc'h ar pellgargañ restroù.",
	'config-gd' => "Kavet eo bet al levraoueg c'hrafek GD enframmet.
Gweredekaet e vo ar bihanaat skeudennoù ma vez gweredekaet an enporzhiañ restroù.",
	'config-no-scaling' => "N'eus ket bet gallet kavout al levraoueg GD pe ImageMagick.
Diweredekaet e vo ar bihanaat skeudennoù.",
	'config-no-uri' => "'''Fazi :''' N'eus ket tu da anavezout URI ar skript red.
Staliadur nullet.",
	'config-uploads-not-safe' => "'''Diwallit :'''Bresk eo ho kavlec'h pellgargañ dre ziouer <code>$1</code> rak gallout a ra erounit ne vern pe skript.
ha pa vefe gwiriet gant MediaWiki an holl restroù pellgarget eo erbedet-groñs da [//www.mediawiki.org/wiki/Manual:Security#Upload_security serriñ ar breskter surentez-mañ] a-rao gweredekaat ar pellgargañ.",
	'config-brokenlibxml' => "Ur meskad stummoù PHP ha libxml2 dreinek a vez implijet gant ho reizhiad. Gallout a ra breinañ ar roadennoù e MediaWiki hag en arloadoù web all.
Hizivait da PHP 5.2.9 pe nevesoc'h ha libxml2 2.7.3 pe nevesoc'h ([//bugs.php.net/bug.php?id=45996 draet renablet gant PHP]).
Staliadur paouezet.",
	'config-using531' => "N'haller ket implijout MediaWiki gant PHP $1 abalamour d'un draen a zegas trubuilh en arventennoù kaset en ur ober dave da <code>__call()</code>.
Hizivait ho reizhiad gant PHP 5.3.2 pe nevesoc'h, pe distroit da PHP 5.3.0 evit renkañ an dra-se.
Staliadur paouezet.",
	'config-db-type' => 'Doare an diaz roadennoù :',
	'config-db-host' => 'Anv implijer an diaz roadennoù :',
	'config-db-host-help' => "M'emañ ho servijer roadennoù war ur servijer disheñvel, merkit amañ an anv ostiz pe ar chomlec'h IP.

Ma rit gant un herberc'hiañ kenrannet, e tlefe ho herberc'hier bezañ pourchaset deoc'h un anv ostiz reizh en teulioù titouriñ.

M'emaoc'h o staliañ ur servijer Windows ha ma rit gant MySQL, marteze ne'z aio ket en-dro \"localhost\" evel anv servijer. Ma ne dro ket, klaskit ober gant \"127.0.0.1\" da chomlec'h IP lechel.", # Fuzzy
	'config-db-host-oracle' => 'TNS an diaz roadennoù :',
	'config-db-wiki-settings' => 'Anavezout ar wiki-mañ',
	'config-db-name' => 'Anv an diaz roadennoù :',
	'config-db-name-help' => "Dibabit un anv evit ho wiki.
Na lakait ket a esaouennoù ennañ.

Ma ri gant un herberc'hiañ kenrannet e vo pourchaset deoc'h un anv diaz roadennoù dibar da vezañ graet gantañ gant ho herberc'hier pe e lezo ac'hanoc'h da grouiñ diazoù roadennoù dre ur banell gontrolliñ.",
	'config-db-name-oracle' => 'Brastres diaz roadennoù :',
	'config-db-install-account' => 'Kont implijer evit ar staliadur',
	'config-db-username' => 'Anv implijer an diaz roadennoù :',
	'config-db-password' => 'Ger-tremen an diaz roadennoù :',
	'config-db-password-empty' => "Lakait ur ger-tremen evit kont nevez an diaz roadennoù : $1.
Ha pa vefe posupl da grouiñ kontoù hep ger-tremen, n'eo ket erbedet evit abegoù surentez.",
	'config-db-install-username' => "Ebarzhit an anv implijer a vo implijet da gevreañ ouzh an diaz roadennoù e-pad an argerzh staliañ.
N'eo ket anv implijer ar gont MediaWiki, an anv implijer evit ho tiaz roadennoù eo.",
	'config-db-install-password' => "Ebarzhit ar ger-tremen a vo implijet da gevreañ ouzh an diaz roadennoù e-pad an argerzh staliañ.
N'eo ket ar ger-tremen evit ar gont MediaWiki, ar ger-tremen evit ho tiaz roadennoù eo.",
	'config-db-install-help' => 'Merkañ anv an implijer hag ar ger-tremen a vo implijet evit kevreañ ouzh an diaz roadennoù e-pad an argerzh staliañ.',
	'config-db-account-lock' => 'Implijout ar memes anv implijer ha ger-tremen e-kerzh oberiadurioù boutin',
	'config-db-wiki-account' => 'Kont implijer evit oberiadurioù boutin',
	'config-db-prefix' => 'Rakrann taolennoù an diaz roadennoù :',
	'config-db-charset' => 'Strobad arouezennoù an diaz roadennoù',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binarel',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 kilkenglotus UTF-8',
	'config-mysql-old' => "Rekis eo MySQL $1 pe ur stumm nevesoc'h; ober a rit gant $2.",
	'config-db-port' => 'Porzh an diaz roadennoù :',
	'config-db-schema' => 'Brastres evit MediaWiki',
	'config-db-schema-help' => "Peurliesañ e vo digudenn ar chema-mañ.
Arabat cheñch anezho ma n'hoc'h eus ket ezhomm d'en ober.",
	'config-pg-test-error' => "N'haller ket kevreañ ouzh an diaz-titouroù '''$1''' : $2",
	'config-sqlite-dir' => "Kavlec'h roadennoù SQLite :",
	'config-oracle-def-ts' => 'Esaouenn stokañ ("tablespace") dre ziouer :',
	'config-oracle-temp-ts' => "Esaouenn stokañ (''tablespace'') da c'hortoz :",
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => "Skoret eo ar reizhiadoù diaz titouroù da-heul gant MediaWiki :

$1

Ma ne welit ket amañ dindan ar reizhiad diaz titouroù a fell deoc'h ober ganti, heuilhit an titouroù a-us (s.o. al liammoù) evit gweredekaat ar skorañ.",
	'config-support-mysql' => '* $1 eo an dibab kentañ evit MediaWiki hag an hini skoret ar gwellañ ([http://www.php.net/manual/en/mysql.installation.php penaos kempunañ PHP gant skor MySQL])',
	'config-support-postgres' => "* Ur reizhiad diaz titouroù brudet ha digor eo $1. Gallout a ra ober evit MySQL ([http://www.php.net/manual/en/pgsql.installation.php Penaos kempunañ PHP gant skor PostgreSQL]). Gallout a ra bezañ un nebeud drein bihan enni ha n'eo ket erbedet he implijout en un endro produiñ.",
	'config-support-sqlite' => "* $1 zo ur reizhiad diaz titouroù skañv skoret eus ar c'hentañ. ([http://www.php.net/manual/en/pdo.installation.php Penaos kempunañ PHP gant skor SQLite], implijout a ra PDO)",
	'config-support-oracle' => '* $1 zo un diaz titouroù kenwerzhel. ([http://www.php.net/manual/en/oci8.installation.php Penaos kempunañ PHP gant skor OCI8])',
	'config-support-ibm_db2' => '* Un diaz titouroù evit embregerezhioù kenwerzhel eo $1.',
	'config-header-mysql' => 'Arventennoù MySQL',
	'config-header-postgres' => 'Arventennoù PostgreSQL',
	'config-header-sqlite' => 'Arventennoù SQLite',
	'config-header-oracle' => 'Arventennoù Oracle',
	'config-header-ibm_db2' => 'Arventennoù IBM DB2',
	'config-invalid-db-type' => 'Direizh eo ar seurt diaz roadennoù',
	'config-missing-db-name' => 'Ret eo deoc\'h merkañ un dalvoudenn evit "Anv an diaz titouroù"',
	'config-missing-db-host' => 'Ret eo deoc\'h merkañ un dalvoudenn evit "Ostiz an diaz titouroù"',
	'config-missing-db-server-oracle' => 'Ret eo deoc\'h merkañ un dalvoudenn evit "Anv TNS an diaz titouroù"',
	'config-invalid-db-server-oracle' => 'Direizh eo anv TNS an diaz titouroù "$1".
Ober hepken gant lizherennoù ASCII (a-z, A-Z), sifroù (0-9), arouezennoù islinennañ (_) ha pikoù (.).',
	'config-invalid-db-name' => 'Direizh eo anv an diaz titouroù "$1".
Ober hepken gant lizherennoù ASCII (a-z, A-Z), sifroù (0-9), arouezennoù islinennañ (_) ha tiredoù (-).',
	'config-invalid-db-prefix' => 'Direizh eo rakger an diaz titouroù "$1".
Ober hepken gant lizherennoù ASCII (a-z, A-Z), sifroù (0-9), arouezennoù islinennañ (_) ha tiredoù (-).',
	'config-connection-error' => '$1.

Gwiriit anv an ostiz, an anv implijer, ar ger-tremen ha klaskit en-dro.',
	'config-invalid-schema' => 'Chema direizh evit MediaWiki "$1".
Grit hepken gant lizherennoù ASCII (a-z, A-Z), sifroù (0-9) hag arouezennoù islinennañ (_).',
	'config-db-sys-create-oracle' => "N'anavez ar stalier nemet ar c'hontoù SYSDBA evit krouiñ kontoù nevez.",
	'config-db-sys-user-exists-oracle' => 'Bez\' ez eus eus ar gont "$1" c\'hoazh. N\'haller ober gant SYSDBA nemet evit krouiñ kontoù nevez !',
	'config-postgres-old' => "Rekis eo PostgreSQL $1 pe ur stumm nevesoc'h; ober a rit gant $2.",
	'config-sqlite-name-help' => "Dibabit un anv dibar d'ho wiki.
Arabat ober gant esaouennoù pe barrennigoù-stagañ.
Implijet e vo evit ar restr roadennoù SQLite.",
	'config-sqlite-mkdir-error' => 'Ur fazi zo bet e-ser krouiñ ar c\'havlec\'h roadennoù "$1".
Gwiriañ al lec\'hiadur ha klask en-dro.',
	'config-sqlite-dir-unwritable' => 'Dibosupl skrivañ er c\'havlec\'h "$1".
Cheñchit ar aotreoù evit ma c\'hallfe ar servijer web skrivañ ennañ ha klaskit en-dro.',
	'config-sqlite-connection-error' => "$1.

Gwiriañ ar c'havlec'h roadennoù hag anv an diaz roadennoù a-is ha klaskit en-dro.",
	'config-sqlite-readonly' => "N'haller ket skrivañ er restr <code>$1</code>.",
	'config-sqlite-cant-create-db' => "N'haller ket krouiñ restr an diaz roadennoù <code>$1</code>.",
	'config-sqlite-fts3-downgrade' => "N'eo ket kenglotus ar PHP gant FTS3, o lakaat an taolennoù da glotañ gant ur stumm koshoc'h",
	'config-can-upgrade' => "Taolennoù MediaWiki zo en diaz titouroù.
Da hizivaat anezho da VediaWiki $1, klikañ war '''Kenderc'hel'''.",
	'config-upgrade-done-no-regenerate' => 'Hizivadenn kaset da benn.

Gallout a rit [$1 kregiñ da implijout ho wiki].',
	'config-regenerate' => 'Adgenel LocalSettings.php →',
	'config-show-table-status' => "C'hwitet ar reked SHOW TABLE STATUS !",
	'config-unknown-collation' => "'''Diwallit :''' Emañ an diaz roadennoù o renkañ an traoù diouzh un urzh lizherennek dianav.",
	'config-db-web-account' => 'Kont an diaz roadennoù evit ar voned Kenrouedad',
	'config-db-web-help' => 'Diuzañ an anv implijer hag ar ger-tremen a vo implijet gant ar servijer web evit kevreañ ouzh ar servijer diaz roadennoù pa vez ar wiki o vont en-dro war ar pemdez.',
	'config-db-web-account-same' => 'Ober gant an hevelep kont hag an hini implijet evit ar staliañ',
	'config-db-web-create' => "Krouiñ ar gont ma n'eus ket anezhi c'hoazh",
	'config-mysql-engine' => 'Lusker stokañ :',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Strobad arouezennoù an diaz roadennoù :',
	'config-mysql-binary' => 'Binarel',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Anv ar wiki :',
	'config-site-name-help' => "Dont a raio war wel e barrenn ditl ar merdeer hag e meur a lec'h all c'hoazh.",
	'config-site-name-blank' => "Lakait anv ul lec'hienn .",
	'config-project-namespace' => 'Esaouenn anv ar raktres :',
	'config-ns-generic' => 'Raktres',
	'config-ns-site-name' => 'Hevelep anv hag hini ar wiki : $1',
	'config-ns-other' => 'All (spisaat)',
	'config-ns-other-default' => 'MaWiki',
	'config-ns-invalid' => 'Direizh eo an esaouenn anv "<nowiki>$1</nowiki>" spisaet.
Merkit un esaouenn anv disheñvel evit ar raktres.',
	'config-ns-conflict' => 'Tabut zo etre an esaouenn anv spisaet "<nowiki>$1</nowiki>" hag un esaouenn anv dre ziouer eus MediaWiki.
Spisait un anv raktres esaouenn anv all.',
	'config-admin-box' => 'Kont merour',
	'config-admin-name' => "Hoc'h anv :",
	'config-admin-password' => 'Ger-tremen :',
	'config-admin-password-confirm' => 'Adskrivañ ar ger-tremen :',
	'config-admin-help' => 'Merkit hoc\'h anv implijer amañ, da skouer "Yann Vlog".
Hemañ eo an anv a implijot evit kevreañ d\'ar wiki-mañ.',
	'config-admin-name-blank' => 'Lakait anv ur merour.',
	'config-admin-name-invalid' => 'Direizh eo an anv implijer spisaet "<nowiki>$1</nowiki>".
Merkit un anv implijer all.',
	'config-admin-password-blank' => 'Reiñ ur ger-tremen evit kont ar merour.',
	'config-admin-password-same' => "Ne c'hall ket ar ger-tremen bezañ heñvel ouzh anv ar gont.",
	'config-admin-password-mismatch' => "Ne glot ket ar gerioù-tremen hoc'h eus merket an eil gant egile.",
	'config-admin-email' => "Chomlec'h postel :",
	'config-admin-email-help' => "Merkit ur chomlec'h postel amañ evit gallout resev posteloù a-berzh implijerien all eus ar wiki, adderaouekaat ho ker-tremen ha bezañ kelaouet eus ar c'hemmoù degaset d'ar pajennoù zo en ho roll evezhiañ. Gallout a rit lezel ar vaezienn-mañ goullo.",
	'config-admin-error-user' => 'Fazi diabarzh en ur grouiñ ur merer gant an anv "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Fazi diabarzh o lakaat ur ger-tremen evit ar merour « <nowiki>$1</nowiki> » : <pre>$2</pre>',
	'config-admin-error-bademail' => "Ebarzhet hoc'h eus ur chomlec'h postel direizh.",
	'config-subscribe' => 'Koumanantit da [https://lists.wikimedia.org/mailman/listinfo/mediawiki-listenn kemennadoù evit ar stummoù nevez].',
	'config-almost-done' => "Kazi echu eo !
Gellout a rit tremen ar c'hefluniadur nevez ha staliañ ar wiki war-eeun.",
	'config-optional-continue' => "Sevel muioc'h a goulennoù ouzhin.",
	'config-optional-skip' => 'Aet on skuizh, staliañ ar wiki hepken.',
	'config-profile' => 'Profil ar gwirioù implijer :',
	'config-profile-wiki' => 'Wiki hengounel',
	'config-profile-no-anon' => 'Krouidigezh ur gont ret',
	'config-profile-fishbowl' => 'Embanner aotreet hepken',
	'config-profile-private' => 'Wiki prevez',
	'config-license' => 'Copyright hag aotre-implijout:',
	'config-license-none' => 'Aotre ebet en traoñ pajenn',
	'config-license-cc-by-sa' => 'Creative Commons Deroadenn Kenrannañ heñvel',
	'config-license-cc-by' => 'Creative Commons Deroadenn',
	'config-license-cc-by-nc-sa' => 'Creative Commons Deroadenn Angenwerzhel Kenrannañ heñvel',
	'config-license-cc-0' => 'Creative Commons Zero (Domani foran)',
	'config-license-pd' => 'Domani foran',
	'config-license-cc-choose' => 'Dibabit un aotre-implijout Creative Commons personelaet',
	'config-email-settings' => 'Arventennoù ar postel',
	'config-enable-email' => 'Gweredekaat ar posteloù a ya kuit',
	'config-enable-email-help' => "Mar fell deoc'h ober gant ar posteler eo ret deoc'h [http://www.php.net/manual/en/mail.configuration.php kefluniañ arventennoù postel PHP] ervat.
Mar ne fell ket deoc'h ober gant ar servij posteloù e c'hall bezañ diweredekaet amañ.",
	'config-email-user' => 'Gweredekaat ar posteloù a implijer da implijer',
	'config-email-user-help' => "Aotren a ra an holl implijerien da gas posteloù an eil d'egile mard eo bet gweredekaet an arc'hwel ganto en ho penndibaboù.",
	'config-email-usertalk' => 'Gweredekaat kemennadur pajennoù kaozeal an implijerien',
	'config-email-usertalk-help' => "Talvezout a ra d'an implijerien da resev kemennadennoù ma vez kemmet o fajennoù kaozeal, ma vez gweredekaet en o fenndibaboù.",
	'config-email-watchlist' => "Gweredekaat ar c'hemenn listenn evezhiañ",
	'config-email-watchlist-help' => "Talvezout a ra d'an implijerien da resev kemennadennoù diwar-benn ar pajennoù evezhiet ganto, ma vez gweredekaet en o fenndibaboù.",
	'config-email-auth' => 'Gweredekaat an dilesadur dre bostel',
	'config-email-sender' => "Chomlec'h postel respont :",
	'config-email-sender-help' => "Merkit ar chomlec'h postel da vezañ implijet da chomlec'h distreiñ ar posteloù a ya er-maez.
Di e vo kaset ar posteloù distaolet.
Niverus eo ar servijerioù postel a c'houlenn da nebeutañ un [http://fr.wikipedia.org/wiki/Nom_de_domaine anv domani] reizh.",
	'config-upload-settings' => 'Pellgargañ skeudennoù ha restroù',
	'config-upload-enable' => 'Gweredekaat ar pellgargañ restroù',
	'config-upload-deleted' => "Kavlec'h evit ar restroù dilamet :",
	'config-upload-deleted-help' => "Dibab ur c'havlec'h da ziellaouiñ ar restroù diverket.
Ar pep gwellañ e vije ma ne vije ket tu d'e dizhout adalek ar Genrouedad.",
	'config-logo' => 'URL al logo :',
	'config-instantcommons' => "Gweredekaat ''InstantCommons''",
	'config-cc-error' => "N'eus deuet disoc'h ebet gant dibaber aotreoù-implijout Creative Commons.
Merkit anv an aotre-implijout gant an dorn.",
	'config-cc-again' => 'Dibabit adarre...',
	'config-cc-not-chosen' => 'Dibabit an aotre-implijout Creative Commons a fell deoc\'h ober gantañ ha klikit war "kenderc\'hel".',
	'config-advanced-settings' => 'Kefluniadur araokaet',
	'config-cache-options' => 'Arventennoù evit krubuilhañ traezoù :',
	'config-cache-accel' => 'Krubuilhañ traezoù PHP (APC, XCache pe WinCache)',
	'config-cache-memcached' => 'Implijout Memcached (en deus ezhomm bezañ staliet ha kefluniet)',
	'config-memcached-servers' => 'Servijerioù Memcached :',
	'config-memcached-help' => "Roll ar chomlec'hioù IP da implijout evit Memcached.
Ret eo spisaat unan dre linenn ha spisaat ar porzh da vezañ implijet. Da skouer :
127.0.0.1:11211
192.168.1.25:1234",
	'config-memcache-needservers' => "Diuzet hoc'h eus Memcached evel seurt krubuilh met n'hoc'h eus spisaet servijer ebet.",
	'config-memcache-badip' => "Ur chomlec'h IP direizh hoc'h eus lakaet evit Memcached : $1.",
	'config-memcache-badport' => 'Niverennoù porzh Memcached a zlefe bezañ etre $1 ha $2.',
	'config-extensions' => 'Astennoù',
	'config-extensions-help' => "N'eo ket bet detektet an astennoù rollet a-us en ho kavlec'h <code>./astennoù</code>.

Marteze e vo ezhomm kefluniañ pelloc'h met gallout a rit o gweredekaat bremañ.",
	'config-install-alreadydone' => "'''Diwallit''': Staliet hoc'h eus MediaWiki dija war a seblant hag emaoc'h o klask e staliañ c'hoazh.
Kit d'ar bajenn war-lerc'h, mar plij.",
	'config-install-begin' => 'Pa vo bet pouezet ganeoc\'h war "{{int:config-continue}}"  e krogo staliadur MediaWiki.
Pouezit war Kent mar fell deoc\'h cheñch tra pe dra.',
	'config-install-step-done' => 'graet',
	'config-install-step-failed' => "c'hwitet",
	'config-install-extensions' => 'En ur gontañ an astennoù',
	'config-install-database' => 'Krouiñ an diaz roadennoù',
	'config-install-schema' => 'O krouiñ ar chema',
	'config-install-pg-schema-not-exist' => "N'eus ket eus chema PostgreSQL.",
	'config-install-pg-schema-failed' => "C'hwitet eo krouidigezh an taolennoù.
Gwiriit hag-eñ e c'hall an implijer « $1 » skrivañ er brastres « $2 ».",
	'config-install-pg-commit' => "O wiriekaat ar c'hemmoù",
	'config-install-pg-plpgsql' => 'O wiriañ ar yezh PL/pgSQL',
	'config-pg-no-plpgsql' => "Ret eo deoc'h staliañ ar yezh PL/pgSQL en diaz roadennoù $1",
	'config-pg-no-create-privs' => "N'eus ket gwirioù a-walc'h gant ar gont hoc'h eus merket evit ar staliadur evit gallout krouiñ ur gont.",
	'config-install-user' => 'O krouiñ an diaz roadennoù implijer',
	'config-install-user-alreadyexists' => 'An implijer "$1" zo anezhañ dija',
	'config-install-user-create-failed' => 'Fazi e-ser krouiñ an implijer "$1" : $2',
	'config-install-user-grant-failed' => 'N\'eus ket bet gallet reiñ an aotre d\'an implijer "$1" : $2',
	'config-install-tables' => 'Krouiñ taolennoù',
	'config-install-tables-failed' => "'''Fazi :''' c'hwitet eo krouidigezh an daolenn gant ar fazi-mañ : $1",
	'config-install-interwiki' => 'O leuniañ dre ziouer an daolenn etrewiki',
	'config-install-interwiki-list' => "Ne c'haller ket kavout ar restr <code>interwiki.list</code>.",
	'config-install-stats' => 'O sevel ar stadegoù',
	'config-install-keys' => "Genel an alc'hwezioù kuzh",
	'config-install-sysop' => 'Krouidigezh kont ar merour',
	'config-install-subscribe-fail' => "N'haller ket koumanantiñ da mediawiki-announce : $1",
	'config-install-mainpage' => "O krouiñ ar bajenn bennañ gant un endalc'had dre ziouer",
	'config-install-extension-tables' => 'O krouiñ taolennoù evit an astennoù gweredekaet',
	'config-install-mainpage-failed' => "Ne c'haller ket ensoc'hañ ar bajenn bennañ: $1",
	'config-download-localsettings' => 'Pellgargañ LocalSettings.php',
	'config-help' => 'skoazell',
	'mainpagetext' => "'''Meziant MediaWiki staliet.'''",
	'mainpagedocfooter' => "Sellit ouzh [//meta.wikimedia.org/wiki/Help:Contents Sturlevr an implijerien] evit gouzout hiroc'h war an doare da implijout ar meziant wiki.

== Kregiñ ganti ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'config-desc' => 'Instalacija za MediaWiki',
	'config-title' => 'MediaWiki $1 instalacija',
	'config-information' => 'Informacija',
	'config-localsettings-upgrade' => 'Otkrivena je datoteka <code>LocalSettings.php</code>.
Da biste unaprijedili vaš softver, molimo vas upišite vrijednost od <code>$wgUpgradeKey</code> u okvir ispod.
Naći ćete ga u LocalSettings.php.',
	'config-localsettings-key' => 'Ključ za nadgradnju:',
	'config-session-error' => 'Greška pri pokretanju sesije: $1',
	'config-no-session' => 'Vaši podaci sesije su izgubljeni!
Provjerite vaš php.ini i provjerite da li je <code>session.save_path</code> postavljen na pravilni direktorijum.',
	'config-your-language' => 'Vaš jezik:',
	'config-your-language-help' => 'Odaberite jezik koji ćete koristiti tokom procesa instalacije.',
	'config-wiki-language' => 'Wiki jezik:',
	'config-wiki-language-help' => 'Odaberite jezik na kojem će wiki biti najvećim dijelim pisana.',
	'config-back' => '← Nazad',
	'config-continue' => 'Nastavi →',
	'config-page-language' => 'Jezik',
	'config-page-welcome' => 'Dobrodošli u MediaWiki!',
	'config-page-dbconnect' => 'Poveži sa bazom podataka',
	'config-page-upgrade' => 'Unaprijedi postojeću instalaciju',
	'config-page-dbsettings' => 'Postavke baze podataka',
	'config-page-name' => 'Naziv',
	'config-page-options' => 'Opcije',
	'config-page-install' => 'Instaliraj',
	'config-page-complete' => 'Završeno!',
	'config-page-restart' => 'Ponovi instalaciju ispočetka',
	'config-page-readme' => 'Pročitaj me',
	'config-page-releasenotes' => 'Bilješke izdanja',
	'config-page-copying' => 'Kopiram',
	'config-page-upgradedoc' => 'Nadograđujem',
	'config-help-restart' => 'Da li želite očistiti sve spremljene podatke koje ste unijeli i da započnete ponovo proces instalacije?',
	'config-restart' => 'Da, pokreni ponovo',
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki Početna strana]
* [//www.mediawiki.org/wiki/Help:Contents Vodič za korisnike]
* [//www.mediawiki.org/wiki/Manual:Contents Vodič za administratore]
* [//www.mediawiki.org/wiki/Manual:FAQ NPP]
----
* <doclink href=Readme>Pročitaj me</doclink>
* <doclink href=ReleaseNotes>Napomene izdanja</doclink>
* <doclink href=Copying>Kopiranje</doclink>
* <doclink href=UpgradeDoc>Poboljšavanje</doclink>',
	'config-env-good' => 'Okruženje je provjereno.
Možete instalirati MediaWiki.',
	'config-env-php' => 'PHP $1 je instaliran.',
	'config-no-db' => 'Nije mogao biti pronađen pogodan driver za bazu podataka! Morate instalirati driver baze podataka za PHP.
Slijedeće vrste baza podataka su podržane: $1.

Ako se na dijeljenom serveru, tražite od vašeg pružaoca usluga da instalira pogodan driver za bazu podataka.
Ako se sami kompajlirali PHP, podesite ga sa omogućenim klijentom baze podataka, koristeći naprimjer <code>./configure --with-mysql</code>.
Ako ste instalirali PHP iz Debian ili Ubuntu paketa, možda morate instalirati i modul php5-mysql.',
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] je instaliran',
	'config-apc' => '[http://www.php.net/apc APC] je instaliran',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] je instaliran',
	'config-diff3-bad' => 'GNU diff3 nije pronađen.',
	'config-db-type' => 'Vrsta baze podataka:',
	'config-db-host' => 'Domaćin baze podataka:',
	'config-db-wiki-settings' => 'Identificiraj ovu wiki',
	'config-db-name' => 'Naziv baze podataka:',
	'config-db-name-oracle' => 'Šema baze podataka:',
	'config-header-mysql' => 'Postavke MySQL',
	'config-header-postgres' => 'Postavke PostgreSQL',
	'config-header-sqlite' => 'Postavke SQLite',
	'config-header-oracle' => 'Postavke Oracle',
	'config-invalid-db-type' => 'Nevaljana vrsta baze podataka',
	'config-upgrade-done' => "Nadogradnja završena.

Sada možete [$1 početi koristiti vašu wiki].

Ako želite regenerisati vašu datoteku <code>LocalSettings.php</code>, kliknite na dugme ispod.
Ovo '''nije preporučeno''' osim ako nemate problema s vašom wiki.",
	'config-admin-name' => 'Vaše ime:',
	'config-admin-password' => 'Šifra:',
	'mainpagetext' => "'''MediaViki softver is uspješno instaliran.'''",
	'mainpagedocfooter' => 'Kontaktirajte [//meta.wikimedia.org/wiki/Help:Contents uputstva za korisnike] za informacije o upotrebi wiki programa.

== Početak ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista postavki]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki najčešće postavljana pitanja]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista E-Mail adresa MediaWiki]',
);

/** Catalan (català)
 * @author පසිඳු කාවින්ද
 */
$messages['ca'] = array(
	'config-page-language' => 'Llengua',
	'config-page-name' => 'Nom',
	'mainpagetext' => "'''El programari del MediaWiki s'ha instaŀlat correctament.'''",
	'mainpagedocfooter' => "Consulteu la [//meta.wikimedia.org/wiki/Help:Contents Guia d'Usuari] per a més informació sobre com utilitzar-lo.

== Per a començar ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Llista de característiques configurables]
* [//www.mediawiki.org/wiki/Manual:FAQ PMF del MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Llista de correu (''listserv'') per a anuncis del MediaWiki]",
);

/** Chechen (нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'config-no-fts3' => "'''Тергам бе''': SQLite гулйина хуттург йоцуш [//sqlite.org/fts3.html FTS3] — лахар болхбеш хир дац оцу бухца.",
	'mainpagetext' => "'''Вики-белха гlирс «MediaWiki» кхочуш дика дlахlоттийна.'''",
	'mainpagedocfooter' => 'Викийца болх бан хаамаш карор бу хlокху чохь [//meta.wikimedia.org/wiki/%D0%9F%D0%BE%D0%BC%D0%BE%D1%89%D1%8C:%D0%A1%D0%BE%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D0%BD%D0%B8%D0%B5 нисвохааман куьйгаллица].

== Цхьаболу пайде гlирсаш ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Гlирс нисбан тарлушболу могlам];
* [//www.mediawiki.org/wiki/Manual:FAQ Сих сиха лушдолу хаттарш а жоьпаш оцу MediaWiki];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Хаам бохьуьйту араяларца башхонца керла MediaWiki].',
);

/** Cebuano (Cebuano)
 */
$messages['ceb'] = array(
	'mainpagetext' => "'''Malamposon ang pag-instalar sa MediaWiki.'''",
	'mainpagedocfooter' => 'Konsultaha ang [//meta.wikimedia.org/wiki/Help:Contents Giya sa mga gumagamit] alang sa impormasyon unsaon paggamit niining wiki nga software.

== Pagsugod ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listahan sa mga setting sa kompigurasyon]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ sa MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce  Mailing list sa mga release sa MediaWiki]',
);

/** Sorani Kurdish (کوردی)
 * @author Asoxor
 */
$messages['ckb'] = array(
	'mainpagetext' => "'''میدیاویکی بە سەرکەوتوویی دامەزرا.'''",
	'mainpagedocfooter' => 'پرس بکە بە [//meta.wikimedia.org/wiki/Help:Contents ڕێنوێنیی بەکارھێنەران] بۆ زانیاری سەبارەت بە بەکارھێنانی نەرمامێری ویکی.

== دەستپێکردن ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings لیستی ڕێکخستنەکان شێوەپێدان]
* [//www.mediawiki.org/wiki/Manual:FAQ پرسیارە دوپاتکراوەکانی میدیاویکی (MediaWiki FAQ)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce لیستی ئیمەیلی وەشانەکانی میدیاویکی]',
);

/** Capiznon (Capiceño)
 * @author Oxyzen
 */
$messages['cps'] = array(
	'mainpagetext' => "'''Madalag-on nga na-install ang MediaWiki.'''",
	'mainpagedocfooter' => 'Kunsultahon ang [//meta.wikimedia.org/wiki/Help:Pagtuytoy sa Manug-usar] para sa impormasyon sa paggamit sang wiki nga "software".

==Pag-umpisa==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista sang mga setting sang konpigurayon]
* [//www.mediawiki.org/wiki/Manual:FAQ Mga perme napangkot sa MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista sang mga ginapadal-an sang sulat sang MediaWiki]',
);

/** Crimean Turkish (Cyrillic script) (къырымтатарджа (Кирилл)‎)
 */
$messages['crh-cyrl'] = array(
	'mainpagetext' => "'''MediaWiki мувафакъиетнен къурулды.'''",
	'mainpagedocfooter' => "Бу викининъ ёл-ёругъыны [//meta.wikimedia.org/wiki/Help:Contents User's Guide къулланыджы къылавузындан] огренип оласынъыз.

== Базы файдалы сайтлар ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Олуджы сазламалар джедвели];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki боюнджа сыкъ берильген суаллернен джеваплар];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-нинъ янъы версияларынынъ чыкъувындан хабер йиберюв].",
);

/** Crimean Turkish (Latin script) (qırımtatarca (Latin)‎)
 */
$messages['crh-latn'] = array(
	'mainpagetext' => "'''MediaWiki muvafaqiyetnen quruldı.'''",
	'mainpagedocfooter' => "Bu vikiniñ yol-yoruğını [//meta.wikimedia.org/wiki/Help:Contents User's Guide qullanıcı qılavuzından] ögrenip olasıñız.

== Bazı faydalı saytlar ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Olucı sazlamalar cedveli];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki boyunca sıq berilgen suallernen cevaplar];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-niñ yañı versiyalarınıñ çıquvından haber yiberüv].",
);

/** Czech (česky)
 * @author Danny B.
 * @author Mormegil
 */
$messages['cs'] = array(
	'config-desc' => 'Instalační program pro MediaWiki',
	'config-title' => 'Instalace MediaWiki $1',
	'config-information' => 'Informace',
	'config-localsettings-upgrade' => 'Byl nalezen soubor <code>LocalSettings.php</code>.
Pokud chcete stávající instalaci aktualizovat, zadejte hodnotu <code>$wgUpgradeKey</code>, kterou naleznete v souboru LocalSettings.php, do následujícího rámečku.',
	'config-localsettings-cli-upgrade' => 'Byl detekován soubor <code>LocalSettings.php</code>
Pro aktualizaci spusťte místo instalace skript <code>update.php</code>.',
	'config-localsettings-key' => 'Klíč pro aktualizaci:',
	'config-localsettings-badkey' => 'Zadaný klíč je nesprávný.',
	'config-upgrade-key-missing' => 'Byla detekována existující instalace MediaWiki.
Pokud ji chcete aktualizovat, přidejte následující řádku na konec souboru LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Existující soubor LocalSettings.php vypadá neúplný.
Není nastavena proměnná $1.
Upravte soubor LocalSettings.php tak, aby tuto proměnnou obsahoval, a klikněte na „Pokračovat“.',
	'config-localsettings-connection-error' => 'Při připojování k databázi s využitím nastavení uvedených v LocalSettings.php nebo AdminSettings.php došlo k chybě. Opravte tato nastavení a zkuste to znovu.

$1',
	'config-session-error' => 'Nepodařilo se inicializovat relaci: $1',
	'config-session-expired' => 'Platnost dat vašeho sezení patrně vypršela.
Sezení má nastavenu životnost $1.
Prodloužit ji můžete nastavením <code>session.gc_maxlifetime</code> v php.ini.
Spusťte instalační proces od začátku.',
	'config-no-session' => 'Data vašeho sezení se ztratila!
Zkontrolujte svůj soubor php.ini a ujistěte se, že <code>session.save_path</code> je nastaveno na odpovídající adresář.',
	'config-your-language' => 'Váš jazyk:',
	'config-your-language-help' => 'Zvolte jazyk, který se má použít v průběhu instalace.',
	'config-wiki-language' => 'Jazyk wiki:',
	'config-wiki-language-help' => 'Zvolte jazyk, ve kterém bude většina obsahu wiki.',
	'config-back' => '← Zpět',
	'config-continue' => 'Pokračovat →',
	'config-page-language' => 'Jazyk',
	'config-page-welcome' => 'Vítejte v MediaWiki!',
	'config-page-dbconnect' => 'Připojení k databázi',
	'config-page-upgrade' => 'Aktualizace existující instalace',
	'config-page-dbsettings' => 'Nastavení databáze',
	'config-page-name' => 'Název',
	'config-page-options' => 'Nastavení',
	'config-page-install' => 'Instalovat',
	'config-page-complete' => 'Hotovo!',
	'config-page-restart' => 'Restartovat instalaci',
	'config-page-readme' => 'Soubor Čti mě',
	'config-page-releasenotes' => 'Poznámky k vydání',
	'config-page-copying' => 'Licence',
	'config-page-upgradedoc' => 'Upgrade',
	'config-page-existingwiki' => 'Existující wiki',
	'config-help-restart' => 'Chcete smazat všechny údaje, které jste zadali, a spustit proces instalace znovu od začátku?',
	'config-restart' => 'Ano, restartovat',
	'config-welcome' => '=== Kontrola prostředí ===
Provedou se základní kontroly, aby se zjistilo, zda je toto prostředí použitelné k instalaci MediaWiki.
Pokud budete potřebovat při instalaci pomoc, měli byste sdělit výsledky těchto testů.',
	'config-copyright' => "=== Licence a podmínky ===
$1

Tento program je svobodný software; můžete jej šířit nebo modifikovat podle podmínek GNU General Public License, vydávané Free Software Foundation; buď verze 2 této licence anebo (podle vašeho uvážení) kterékoli pozdější verze.

Tento program je distribuován v naději, že bude užitečný, avšak '''bez jakékoli záruky'''; neposkytují se ani odvozené záruky '''prodejnosti''' anebo '''vhodnosti pro určitý účel'''.
Podrobnosti se dočtete v textu GNU General Public License.

<doclink href=Copying>Kopii GNU General Public License</doclink> jste měli obdržet spolu s tímto programem; pokud ne, napište na Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA nebo [http://www.gnu.org/copyleft/gpl.html si ji přečtěte online].",
	'config-sidebar' => '* [//www.mediawiki.org Oficiální web MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Uživatelská příručka]
* [//www.mediawiki.org/wiki/Manual:Contents Administrátorská příručka]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>Čti mě</doclink>
* <doclink href=ReleaseNotes>Poznámky k vydání</doclink>
* <doclink href=Copying>Licence</doclink>
* <doclink href=UpgradeDoc>Upgrade</doclink>',
	'config-env-good' => 'Prostředí bylo zkontrolováno.
Můžete nainstalovat MediaWiki.',
	'config-env-bad' => 'Prostředí bylo zkontrolováno.
MediaWiki nelze nainstalovat.',
	'config-env-php' => 'Je nainstalováno PHP $1.',
	'config-env-php-toolow' => 'Je nainstalováno PHP $1.
MediaWiki ale vyžaduje PHP $2 nebo vyšší.',
	'config-unicode-using-utf8' => 'Pro normalizaci Unicode se používá utf8_normalize.so Briona Vibbera.',
	'config-unicode-using-intl' => 'Pro normalizaci Unicode se používá [http://pecl.php.net/intl PECL rozšíření intl].',
	'config-unicode-pure-php-warning' => "'''Upozornění''': Není dostupné [http://pecl.php.net/intl PECL rozšíření intl] pro normalizaci Unicode, bude se využívat pomalá implementace v čistém PHP.
Pokud provozujete wiki s velkým provozem, měli byste si přečíst něco o [//www.mediawiki.org/wiki/Unicode_normalization_considerations normalizaci Unicode].",
	'config-unicode-update-warning' => "'''Upozornění''': Nainstalovaná verze vrstvy pro normalizaci Unicode používá starší verzi knihovny [http://site.icu-project.org/ projektu ICU].
Pokud vám aspoň trochu záleží na používání Unicode, měli byste [//www.mediawiki.org/wiki/Unicode_normalization_considerations ji aktualizovat].",
	'config-no-db' => 'Nepodařilo se nalézt vhodný databázový ovladač! Musíte do PHP nainstalovat databázový ovladač.
Jsou podporovány následující typy databází: $1.

Pokud jste na sdíleném hostingu, požádejte svého poskytovale o instalaci vhodného databázového ovladače.
Pokud jste si PHP přeložili sami, překonfigurujte ho se zapnutým databázovým klientem, například pomocí <code>./configure --with-mysql</code>.
Pokud jste PHP nainstalovali z balíčku Debian či Ubuntu, potřebujete nainstalovat také modul php5-mysql.',
	'config-outdated-sqlite' => "'''Upozornění''': Máte SQLite $1, které je starší než minimálně vyžadovaná verze $2. SQLite nebude dostupné.",
	'config-no-fts3' => "'''Upozornění''': SQLite bylo přeloženo bez [//sqlite.org/fts3.html modulu FTS3], funkce pro vyhledávání zde nebudou dostupné.",
	'config-register-globals' => "'''Upozornění: Je zapnuta PHP volba <code>[http://php.net/register_globals register_globals]</code>.'''
'''Pokud můžete, vypněte ji.'''
MediaWiki bude fungovat, ale váš server je vystaven potenciálním bezpečnostním hrozbám.",
	'config-magic-quotes-runtime' => "'''Kritická chyba: Je zapnuto [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]!'''
Toto nastavení nepředvídatelně poškozuje vstupní data.
MediaWiki nelze nainstalovat ani používat, dokud není toto nastavení vypnuto.",
	'config-magic-quotes-sybase' => "'''Kritická chyba: Je zapnuto [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase]!'''
Toto nastavení nepředvídatelně poškozuje vstupní data.
MediaWiki nelze nainstalovat ani používat, dokud není toto nastavení vypnuto.",
	'config-mbstring' => "'''Kritická chyba: Je zapnuto [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]!'''
Toto nastavení způsobuje chyby a může nepředvídatelně poškozovat vstupní data.
MediaWiki nelze nainstalovat ani používat, dokud není toto nastavení vypnuto.",
	'config-ze1' => "'''Kritická chyba: Je zapnut [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode]!'''
Toto nastavení způsobuje s MediaWiki příšerné chyby.
MediaWiki nelze nainstalovat ani používat, dokud není toto nastavení vypnuto.",
	'config-safe-mode' => "'''Upozornění:''' Je aktivní [http://www.php.net/features.safe-mode bezpečný režim] PHP.
Může způsobovat potíže, zejména při použití načítání souborů a podpory <code>math</code>.",
	'config-xml-bad' => 'Chybí XML modul pro PHP.
MediaWiki potřebuje funkce v tomto modulu a v této konfiguraci nebude fungovat.
Pokud běžíte na Mandrake, nainstalujte balíček php-xml.',
	'config-pcre' => 'Zdá se, že modul s podporou PCRE chybí.
MediaWiki ke své činnosti potřebuje funkce pro Perl-kompatibilní regulární výrazy.',
	'config-pcre-no-utf8' => "'''Kritická chyba''': PHP modul PCRE byl zřejmě přeložen bez podpory PCRE_UTF8.
MediaWiki vyžaduje ke správné funkci podporu UTF-8.",
	'config-memory-raised' => '<code>memory_limit</code> v PHP byl nastaven na $1, zvýšen na $2.',
	'config-memory-bad' => "'''Upozornění:''' <code>memory_limit</code> je v PHP nastaven na $1.
To je pravděpodobně příliš málo.
Instalace může selhat!",
	'config-ctype' => "'''Kritická chyba''': PHP musí být přeloženo s podporou pro [http://www.php.net/manual/en/ctype.installation.php rozšíření Ctype].",
	'config-xcache' => 'Je nainstalována [http://xcache.lighttpd.net/ XCache]',
	'config-apc' => 'Je nainstalováno [http://www.php.net/apc APC]',
	'config-wincache' => 'Je nainstalována [http://www.iis.net/download/WinCacheForPhp WinCache]',
	'config-no-cache' => "'''Upozornění:''' Nebylo nalezeno [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache], ani [http://www.iis.net/download/WinCacheForPhp WinCache].
Kešování objektů bude vypnuto.",
	'config-mod-security' => "'''Upozornění''': váš webový server má zapnuto [http://modsecurity.org/ mod_security]. Při chybné konfiguraci může způsobovat potíže MediaWiki či dalším programům, které umožňují ukládat libovolný obsah.
Pokud narazíte na náhodné chyby, podívejte se do [http://modsecurity.org/documentation/ dokumentace mod_security] nebo kontaktujte technickou podporu vašeho poskytovatele.",
	'config-diff3-bad' => 'Nebyl nalezen GNU diff3.',
	'config-imagemagick' => 'Nalezen ImageMagick: <code>$1</code>.
Pokud povolíte načítání souborů, bude zapnuto vytváření náhledů.',
	'config-gd' => 'Nalezena vestavěná grafická knihovna GD.
Pokud povolíte načítání souborů, bude zapnuto vytváření náhledů.',
	'config-no-scaling' => 'Nebyla nalezena knihovna GD ani ImageMagick.
Vytváření náhledů bude vypnuto.',
	'config-no-uri' => "'''Chyba:''' Nepodařilo se určit aktuální URI.
Instalace přerušena.",
	'config-no-cli-uri' => "'''Upozornění''': Nebylo uvedeno --scriptpath, používá se implicitní hodnota: <code>$1</code>.",
	'config-using-server' => 'Použito jméno serveru „<nowiki>$1</nowiki>“.',
	'config-using-uri' => 'Použito URL serveru „<nowiki>$1$2</nowiki>“.',
	'config-uploads-not-safe' => "'''Upozornění:''' Váš implicitní adresář pro načítání souborů <code>$1</code> umožňuje provádění libovolných skriptů.
Přestože MediaWiki všechny načítané soubory kontroluje proti bezpečnostním hrozbám, je důrazně doporučeno [//www.mediawiki.org/wiki/Manual:Security#Upload_security tuto bezpečnostní díru zacelit] před povolením načítání souborů.",
	'config-no-cli-uploads-check' => "'''Upozornění:''' Váš implicitní adresář pro načítané soubory (<code>$1</code>) se při instalaci z příkazového řádku nekontroluje na bezpečnostní hrozbu provádění libovolných skriptů.",
	'config-brokenlibxml' => 'Váš systém obsahuje kombinaci verzí PHP a libxml2, která je chybná a může v MediaWiki a dalších webových aplikacích způsobovat skryté poškozování dat.
Aktualizujte na PHP 5.2.9 nebo novější a libxml2 2.7.3 nebo novější ([//bugs.php.net/bug.php?id=45996 chyba evidovaná u PHP]).
Instalace přerušena.',
	'config-using531' => 'MediaWiki nelze používat na PHP $1 kvůli chybě při předávání parametrů odkazem do <code>__call()</code>.
Pro vyřešení upgradujte na PHP 5.3.2 nebo vyšší nebo downgradujte na PHP 5.3.0.
Instalace přerušena.',
	'config-suhosin-max-value-length' => 'Je nainstalován Suhosin, který omezuje délku parametrů GET na $1 bajtů. Komponenta ResourceLoader z MediaWiki dokáže s tímto omezením pracovat, ale sníží to výkon. Pokud to je alespoň trochu možné, měli byste v php.ini nastavit suhosin.get.max_value_length na 1024 nebo vyšší a na stejnou hodnotu nastavit v LocalSettings.php proměnnou $wgResourceLoaderMaxQueryLength.',
	'config-db-type' => 'Typ databáze:',
	'config-db-host' => 'Databázový server:',
	'config-db-host-help' => 'Pokud je váš databázový server na jiném počítači, zadejte zde jméno stroje nebo IP adresu.

Pokud používáte sdílený webový hosting, váš poskytovatel by vám měl v dokumentaci sdělit správné jméno stroje.

Pokud instalujete na server běžící na Windows a používáte MySQL, jméno „localhost“ nemusí fungovat. V takovém případě zkuste jako místní IP adresu zadat „127.0.0.1“.

Pokud používáte PostgreSQL, můžete se připojit Unixovými sockety tak, že toto pole necháte prázdné.',
	'config-db-host-oracle' => 'Databázové TNS:',
	'config-db-host-oracle-help' => 'Zadejte platné [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm Local Connect Name]; tato instalace musí vidět soubor tnsnames.ora.<br />Pokud používáte klientské knihovny verze 10g nebo novější, můžete také používat názvy [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identifikace této wiki',
	'config-db-name' => 'Jméno databáze:',
	'config-db-name-help' => 'Zvolte jméno, které označuje vaši wiki.
Nemělo by obsahovat mezery.

Pokud používáte sdílený webový hosting, váš poskytovatel vám buď sdělí konkrétní jméno databáze, nebo vás nechá vytvářet databáze pomocí nějakého ovládacího panelu.',
	'config-db-name-oracle' => 'Databázové schéma:',
	'config-db-account-oracle-warn' => 'Existují tři podporované možnosti pro instalaci s použitím databáze Oracle.

Pokud chcete v rámci instalace založit databázový účet, zadejte jako databázový účet pro instalaci účet s rolí SYSDBA a uveďte požadované údaje pro účet pro webový přístup, jinak můžete vytvořit účet pro webový přístup ručně a zadat pouze tento účet (pokud má dostatečná oprávnění k zakládání objektů schématu) nebo poskytnout dva různé účty, jeden s oprávněními k zakládání, druhý omezený pro webový přístup.

Skript pro založení účtu s potřebnými privilegii můžete v této instalaci nalézt v adresáři „maintenance/oracle/“. Nezapomeňte, že použití omezeného účtu znepřístupní veškeré možnosti údržby přes implicitní účet.',
	'config-db-install-account' => 'Uživatelský účet pro instalaci',
	'config-db-username' => 'Databázové uživatelské jméno:',
	'config-db-password' => 'Databázové heslo:',
	'config-db-password-empty' => 'Zadejte heslo pro nového databázového uživatele: $1.
Přestože může jít zakládat nové uživatele i bez hesel, není to bezpečné.',
	'config-db-install-username' => 'Zadejte uživatelské jméno, které se použije pro připojení k databázi v průběhu instalace.
Toto není jméno uživatelského účtu MediaWiki; toto je uživatelské jméno k vaší databázi.',
	'config-db-install-password' => 'Zadejte heslo, které se použije pro připojení k databázi v průběhu instalace.
Toto není heslo uživatelského účtu MediaWiki; toto je heslo k vaší databázi.',
	'config-db-install-help' => 'Zadejte uživatelské jméno a heslo, které se použijí pro připojení k databázi v průběhu instalace.',
	'config-db-account-lock' => 'Použít stejné uživatelské jméno a heslo pro běžnou činnost',
	'config-db-wiki-account' => 'Uživatelský účet pro běžnou činnost',
	'config-db-wiki-help' => 'Zadejte uživatelské jméno a heslo, které se bude používat pro připojení k databázi za běžného provozu wiki.
Pokud účet neexistuje a instalační účet má dostatečná oprávnění, bude tento uživatelský účet založen s minimálními oprávněními potřebnými k provozu wiki.',
	'config-db-prefix' => 'Prefix databázových tabulek:',
	'config-db-prefix-help' => 'Pokud potřebujete sdílet jednu databázi mezi vícero wiki, případně mezi MediaWiki a další webovou aplikací, můžete přidat k názvu každé tabulky prefix, abyste se vyhnuli konfliktům.
Nepoužívejte mezery.

Toto pole se zpravidla ponechává prázdné.',
	'config-db-charset' => 'Znaková sada databáze',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binární',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 zpětně kompatibilní UTF-8',
	'config-charset-help' => "'''Upozornění:''' Pokud použijete '''zpětně kompatibilní UTF-8''' na MySQL 4.1+ a následně zazálohujete databázi pomocí <code>mysqldump</code>, může to zničit všechny ne-ASCII znaky, což nevratně poškodí vaše zálohy!

V '''binárním režimu''' ukládá MediaWiki text v UTF-8 do databáze v binárních sloupcích.
To je výkonnější než UTF-8 režim MySQL a umožňuje využít plný rozsah znaků Unicode.
V '''režimu UTF-8''' bude MySQL znát znakovou sadu vašich dat a může je příslušně zobrazovat a převádět,
ale neumožní vám uložit znaky mimo [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",
	'config-mysql-old' => 'Je vyžadováno MySQL $1 nebo novější, vy máte $2.',
	'config-db-port' => 'Databázový port:',
	'config-db-schema' => 'Schéma pro MediaWiki:',
	'config-db-schema-help' => 'Toto schéma zpravidla stačí.
Měňte ho, jen pokud víte, že je to potřeba.',
	'config-pg-test-error' => "Nelze se připojit k databázi '''$1''': $2",
	'config-sqlite-dir' => 'Adresář pro data SQLite:',
	'config-sqlite-dir-help' => "SQLite ukládá veškerá data v jediném souboru.

Zadaný adresář musí být v průběhu instalace být přístupný pro zápis.

'''Neměl by''' být dostupný z webu, proto ho nedáváme tam, kde jsou vaše PHP soubory.

Instalátor do adresáře přidá soubor <code>.htaccess</code>, ale pokud to selže, mohl by někdo získat přístup k vaší holé databázi.
To zahrnuje syrová uživatelská data (e-mailové adresy, hašovaná hesla), jako i smazané revize a další data s omezeným přístupem z vaší wiki.

Zvažte umístění databáze někam zcela jinam, například do <code>/var/lib/mediawiki/mojewiki</code>.",
	'config-oracle-def-ts' => 'Implicitní tabulkový prostor:',
	'config-oracle-temp-ts' => 'Dočasný tabulkový prostor:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Věštba',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki podporuje následující databázové systémy:

$1

Pokud v nabídce níže nevidíte databázový systém, který chcete použít, musíte pro zapnutí podpory následovat instrukce odkázané výše.',
	'config-support-mysql' => '* $1 je pro MediaWiki hlavní platformou a je podporováno nejlépe ([http://www.php.net/manual/en/mysql.installation.php jak zkompilovat PHP s podporou MySQL])',
	'config-support-postgres' => '* $1 je populární open-source databázový systém používaný jako alternativa k MySQL ([http://www.php.net/manual/en/pgsql.installation.php jak přeložit PHP s podporou PostgreSQL]). Mohou se vyskytnout ještě nějaké menší chyby, použití v produkčním prostředí se nedoporučuje.',
	'config-support-sqlite' => '* $1 je velmi dobře podporovaný lehký databázový systém. ([http://www.php.net/manual/en/pdo.installation.php Jak přeložit PHP s podporou SQLite], používá PDO)',
	'config-support-oracle' => '* $1 je komerční podniková databáze. ([http://www.php.net/manual/en/oci8.installation.php Jak přeložit PHP s podporou OCI8])',
	'config-support-ibm_db2' => '* $1 je komerční podniková databáze.',
	'config-header-mysql' => 'Nastavení MySQL',
	'config-header-postgres' => 'Nastavení PostgreSQL',
	'config-header-sqlite' => 'Nastavení SQLite',
	'config-header-oracle' => 'Nastavení Oracle',
	'config-header-ibm_db2' => 'Nastavení IBM DB2',
	'config-invalid-db-type' => 'Chybný typ databáze',
	'config-missing-db-name' => 'Musíte zadat hodnotu pro „Jméno databáze“',
	'config-missing-db-host' => 'Musíte zadat hodnotu pro „Databázový server“',
	'config-missing-db-server-oracle' => 'Musíte zadat hodnotu pro „Databázové TNS“',
	'config-invalid-db-server-oracle' => 'Chybné databázové TNS „$1“.
Používejte pouze ASCII písmena (a-z, A-Z), čísla (0-9), podtržítko (_) a tečku (.).',
	'config-invalid-db-name' => 'Chybné jméno databáze „$1“.
Používejte pouze ASCII písmena (a-z, A-Z), čísla (0-9), podtržítko (_) a spojovník (-).',
	'config-invalid-db-prefix' => 'Chybný databázový prefix „$1“.
Používejte pouze ASCII písmena (a-z, A-Z), čísla (0-9), podtržítko (_) a spojovník (-).',
	'config-connection-error' => '$1.

Zkontrolujte server, uživatelské jméno a heslo a zkuste to znovu.',
	'config-invalid-schema' => 'Neplatné schéma pro MediaWiki „$1“.
Používejte pouze ASCII písmena (a-z, A-Z), čísla (0-9) a podtržítko (_).',
	'config-db-sys-create-oracle' => 'Instalátor podporuje zakládání nového účtu pouze prostřednictvím účtu SYSDBA.',
	'config-db-sys-user-exists-oracle' => 'Uživatelský účet „$1“ již existuje. SYSDBA lze použít pouze pro založení nového účtu!',
	'config-postgres-old' => 'Je vyžadován PostgreSQL $1 nebo novější, vy máte $2.',
	'config-sqlite-name-help' => 'Zvolte jméno, které označuje vaši wiki.
Nepoužívejte mezery a spojovníky.
Použije se jako název souboru s daty SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Nelze vytvořit datový adresář <code><nowiki>$1</nowiki></code>, protože do nadřazeného adresáře <code><nowiki>$2</nowiki></code> nemá webový server právo zapisovat.

Instalátor zjistil uživatele, pod kterým váš webový server běží.
Abyste mohli pokračovat, umožněte mu zapisovat do adresáře <code><nowiki>$3</nowiki></code>.
Na systémech Unix/Linux proveďte:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Nelze vytvořit datový adresář <code><nowiki>$1</nowiki></code>, protože do nadřazeného adresáře <code><nowiki>$2</nowiki></code> nemá webový server právo zapisovat.

Instalátoru se nepodařilo zjistit uživatele, pod kterým váš webový server běží.
Abyste mohli pokračovat, umožněte zápis do <code><nowiki>$3</nowiki></code> všem uživatelům.
Na systémech Unix/Linux proveďte:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Chyba při vytváření datového adresáře „$1“.
Zkontrolujte umístění a zkuste to znovu.',
	'config-sqlite-dir-unwritable' => 'Nelze zapisovat do adresáře „$1“.
Změňte na něm oprávnění, aby do něj mohl webový server zapisovat, a zkuste to znovu.',
	'config-sqlite-connection-error' => '$1.

Zkontrolujte datový adresář a jméno databáze níže a zkuste to znovu.',
	'config-sqlite-readonly' => 'Do souboru <code>$1</code> nelze zapisovat.',
	'config-sqlite-cant-create-db' => 'Nepodařilo se vytvořit databázový soubor <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP neobsahuje podporu FTS3, downgradují se tabulky',
	'config-can-upgrade' => "V této databázi jsou tabulky MediaWiki.
Pokud je chcete aktualizovat na MediaWiki $1, klikněte na '''Pokračovat'''.",
	'config-upgrade-done' => "Aktualizace byla dokončena.

Svou wiki teď můžete [$1 začít používat].

Pokud chcete přegenerovat soubor <code>LocalSettings.php</code>, klikněte na tlačítko níže.
To se ale '''nedoporučuje''', pokud s wiki nemáte problémy.",
	'config-upgrade-done-no-regenerate' => 'Aktualizace byla dokončena.

Svou wiki teď můžete [$1 začít používat].',
	'config-regenerate' => 'Přegenerovat LocalSettings.php →',
	'config-show-table-status' => 'Dotaz SHOW TABLE STATUS se nezdařil!',
	'config-unknown-collation' => "'''Upozornění:''' Databáze používá nerozpoznané řazení.",
	'config-db-web-account' => 'Databázový účet pro webový přístup',
	'config-db-web-help' => 'Zvolte uživatelské jméno a heslo, které bude webový server používat pro připojení k databázovému serveru při běžném provozu wiki.',
	'config-db-web-account-same' => 'Použít stejný účet jako pro instalaci',
	'config-db-web-create' => 'Založit účet, pokud zatím neexistuje',
	'config-db-web-no-create-privs' => 'Účet uvedený pro instalaci nemá oprávnění dostatečná pro založení nového účtu.
Účet, který zde uvedete, již musí existovat.',
	'config-mysql-engine' => 'Typ úložiště:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Upozornění''': Jako typ úložiště pro MySQL jste zvolili MyISAM, které není pro použití v MediaWiki doporučeno, neboť:
* stěží podporuje současný přístup kvůli zamykání tabulek,
* je náchylnější na poškození dat než jiná úložiště,
* kód MediaWiki nepodporuje MyISAM vždy tak dobře, jak by měl.

Pokud vaše instalace MySQL podporuje InnoDB, důrazně doporučujeme použít spíše to.
Pokud vaše instalace MySQL InnoDB nepodporuje, možná je čas na aktualizaci.",
	'config-mysql-engine-help' => "'''InnoDB''' je téměř vždy nejlepší volba, neboť má dobrou podporu současného přístupu.

'''MyISAM''' může být rychlejší u instalací pro jednoho uživatele nebo jen pro čtení.
Databáze MyISAM bývají poškozeny častěji než databáze InnoDB.",
	'config-mysql-charset' => 'Znaková sada databáze:',
	'config-mysql-binary' => 'Binární',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "V '''binárním režimu''' ukládá MediaWiki text v UTF-8 do databáze v binárních sloupcích.
To je výkonnější než UTF-8 režim MySQL a umožňuje využít plný rozsah znaků Unicode.

V '''režimu UTF-8''' bude MySQL znát znakovou sadu vašich dat a může je příslušně zobrazovat a převádět, ale neumožní vám uložit znaky mimo [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",
	'config-ibm_db2-low-db-pagesize' => "Vaše DB2 databáze má implicitní tabulkový prostor s nedostatečnou velikostí stránky. Velikost stránky musí být minimálně '''32K'''.",
	'config-site-name' => 'Název wiki:',
	'config-site-name-help' => 'Bude se zobrazovat v titulku prohlížeče a na dalších místech.',
	'config-site-name-blank' => 'Zadejte název serveru.',
	'config-project-namespace' => 'Jmenný prostor projektu:',
	'config-ns-generic' => 'Projekt',
	'config-ns-site-name' => 'Stejný jako název wiki: $1',
	'config-ns-other' => 'Jiný (uveďte)',
	'config-ns-other-default' => 'MojeWiki',
	'config-project-namespace-help' => "Po vzoru Wikipedie udržuje mnoho wiki stránky se svými pravidly odděleně od stránek s vlastním obsahem, v „'''jmenném prostoru projektu'''“.
Názvy všech stránek v tomto jmenném prostoru začínají jistým prefixem, který zde můžete nastavit.
Zvykem je odvozovat tento prefix z názvu wiki, ale nesmí obsahovat jisté interpunkční znaky jako „#“ nebo „:“.",
	'config-ns-invalid' => 'Uvedený jmenný prostor „<nowiki>$1</nowiki>“ je neplatný.
Zadejte jiný jmenný prostor projektu.',
	'config-ns-conflict' => 'Uvedený jmenný prostor „<nowiki>$1</nowiki>“ koliduje se standardním jmenným prostorem MediaWiki.
Zadejte jiný jmenný prostor projektu.',
	'config-admin-box' => 'Správcovský účet',
	'config-admin-name' => 'Vaše jméno:',
	'config-admin-password' => 'Heslo:',
	'config-admin-password-confirm' => 'Heslo ještě jednou:',
	'config-admin-help' => 'Zde zadejte své požadované uživatelské jméno, například „Pepa Novák“.
Tímto jménem se budete do wiki hlásit.',
	'config-admin-name-blank' => 'Zadejte uživatelské jméno správce.',
	'config-admin-name-invalid' => 'Uvedené uživatelské jméno „<nowiki>$1</nowiki>“ není platné.
Zadejte jiné uživatelské jméno.',
	'config-admin-password-blank' => 'Zadejte heslo ke správcovskému účtu.',
	'config-admin-password-same' => 'Heslo nesmí být stejné jako uživatelské jméno.',
	'config-admin-password-mismatch' => 'Uvedená hesla se neshodují.',
	'config-admin-email' => 'E-mailová adresa:',
	'config-admin-email-help' => 'Zde zadejte e-mailovou adresu, která vám umožní přijímat e-maily od ostatních uživatelů wiki, získat nové heslo a přijímat notifikace o změnách sledovaných stránek. Tohle pole můžete nechat prázdné.',
	'config-admin-error-user' => 'Vnitřní chyba při vytváření správce se jménem „<nowiki>$1</nowiki>“.',
	'config-admin-error-password' => 'Vnitřní chyba při nastavování hesla správci se jménem „<nowiki>$1</nowiki>“: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Zadali jste neplatnou e-mailovou adresu.',
	'config-subscribe' => 'Přihlásit se k odběru [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce e-mailové konference pro oznamování nových verzí].',
	'config-subscribe-help' => 'Tohle je e-mailová konference s nízkým provozem, na které se oznamují nové verze, včetně důležitých bezpečnostních oznámení.
Měli byste se do ní přihlásit a při vydání nových verzí aktualizovat svou instalaci MediaWiki.',
	'config-subscribe-noemail' => 'Pokusili jste se přihlásit k odběru e-mailové konference pro oznamování nových verzí, aniž byste poskytli e-mailovou adresu.
Pokud se chcete přihlásit k odběru, zadejte e-mailovou adresu.',
	'config-almost-done' => 'Už jsme skoro hotovi!
Zbývající konfiguraci už můžete přeskočit a nainstalovat wiki hned teď.',
	'config-optional-continue' => 'Ptejte se mě dál.',
	'config-optional-skip' => 'Už mě to nudí, prostě nainstalujte wiki.',
	'config-profile' => 'Profil uživatelských práv:',
	'config-profile-wiki' => 'Tradiční wiki',
	'config-profile-no-anon' => 'Vyžadována registrace uživatelů',
	'config-profile-fishbowl' => 'Editace jen pro vybrané',
	'config-profile-private' => 'Soukromá wiki',
	'config-profile-help' => "Wiki fungují nejlépe, když je necháte editovat co největším možným počtem lidí.
V MediaWiki můžete snadno kontrolovat poslední změny a vracet zpět libovolnou škodu způsobenou hloupými nebo zlými uživateli.

Mnoho lidí však zjistilo, že je MediaWiki užitečné v širokém spektru rolí a někdy není snadné všechny přesvědčit o výhodách wikizvyklostí.
Takže si můžete vybrat.

'''{{int:config-profile-wiki}}''' dovoluje editovat všem, aniž by se museli přihlašovat.
Na wiki, kde je '''{{int:config-profile-no-anon}}''', se lépe řídí zodpovědnost, ale může to odradit náhodné přispěvatele.

Profil '''{{int:config-profile-fishbowl}}''' umožňuje schváleným uživatelům editovat, ale veřejnost si může stránky prohlížet včetně jejich historie.
'''{{int:config-profile-private}}''' dovoluje stránky prohlížet jen schváleným uživatelům, kteří je i mohou editovat.

Po instalaci je možná komplexní konfigurace uživatelských práv; vizte [//www.mediawiki.org/wiki/Manual:User_rights odpovídající stránku příručky].",
	'config-license' => 'Autorská práva a licence:',
	'config-license-none' => 'Bez patičky s licencí',
	'config-license-cc-by-sa' => 'Creative Commons Uveďte autora-Zachovejte licenci',
	'config-license-cc-by' => 'Creative Commons Uveďte autora',
	'config-license-cc-by-nc-sa' => 'Creative Commons Uveďte autora-Nevyužívejte dílo komerčně-Zachovejte licenci',
	'config-license-cc-0' => 'Creative Commons Zero (volné dílo)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 nebo novější',
	'config-license-pd' => 'Volné dílo',
	'config-license-cc-choose' => 'Zvolit vlastní licenci Creative Commons',
	'config-license-help' => "Mnoho veřejných wiki všechny příspěvky zveřejňuje pod některou [http://freedomdefined.org/Definition/Cs svobodnou licencí].
To pomáhá vytvořit duch komunitního vlastnictví a povzbuzuje dlouhodobé přispívání.
To obecně není potřeba u soukromé nebo firemní wiki.

Pokud chcete být schopni používat text z Wikipedie a chcete, aby Wikipedie byla schopna přijímat text okopírovaný z vaší wiki, měli byste zvolit '''Creative Commons Uveďte autora-Zachovejte licenci'''.

Dříve Wikipedie používala GNU Free Documentation License.
GFDL je platná licence, ale složité jí porozumět.
Také je komplikované používat obsah licencovaný pod GFDL.",
	'config-email-settings' => 'Nastavení e-mailu',
	'config-enable-email' => 'Zapnout odchozí e-mail',
	'config-enable-email-help' => 'Pokud chcete, aby e-mail fungoval, je potřeba správně nakonfigurovat [http://www.php.net/manual/en/mail.configuration.php e-mailová nastavení PHP].
Pokud nechcete žádné e-mailové funkce, můžete je zde vypnout.',
	'config-email-user' => 'Umožnit vzájemné e-maily mezi uživateli',
	'config-email-user-help' => 'Umožní všem uživatelům posílat si navzájem e-maily, pokud si to zapnout v uživatelském nastavení.',
	'config-email-usertalk' => 'Umožnit notifikace k uživatelským diskusím',
	'config-email-usertalk-help' => 'Umožní uživatelům přijímat notifikace o změnách uživatelských diskusí, pokud si to zapnou v nastavení.',
	'config-email-watchlist' => 'Umožnit notifikace ke sledovaným stránkám',
	'config-email-watchlist-help' => 'Umožní uživatelům přijímat notifikace o změnách sledovaných stránek, pokud si to zapnou v nastavení.',
	'config-email-auth' => 'Zapnout ověřování e-mailů',
	'config-email-auth-help' => "Pokud je tato volba vybrána, uživatelé musí potvrdit svou e-mailovou adresu pomocí odkazu, který je jim poslán, kdykoli si ji nastaví nebo změní.
Jen potvrzené e-mailové adresy mohou přijímat e-maily od ostatních uživatelů a e-maily s notifikacemi o změnách.
Nastavení této volby je '''doporučeno''' pro veřejné wiki kvůli možnosti zneužití e-mailových funkcí.",
	'config-email-sender' => 'Návratová e-mailová adresa:',
	'config-email-sender-help' => 'Zadejte e-mailovou adresu, která se má použít jako návratová na odchozích e-mailech.
Sem budou zasílány nedoručitelné zprávy.
Mnoho mailových serverů vyžaduje, aby byla přinejmenším část s doménovým jménem platná.',
	'config-upload-settings' => 'Obrázky a načítání souborů',
	'config-upload-enable' => 'Povolit načítání souborů',
	'config-upload-help' => 'Načítání souborů potenciálně vystavuje váš server bezpečnostním rizikům.
Více informací naleznete v [//www.mediawiki.org/wiki/Manual:Security části o bezpečnosti] v příručce.

Pro umožnění načítání souborů změňte práva na podadresáři <code>images</code> pod kořenovým adresářem MediaWiki, aby do něj mohl webový server zapisovat.
Poté zapněte tuto volbu.',
	'config-upload-deleted' => 'Adresář pro smazané soubory:',
	'config-upload-deleted-help' => 'Zvolte adresář, do kterého se mají archivovat smazané soubory.
Tento adresář by ideálně neměl být dostupný z webu.',
	'config-logo' => 'URL loga:',
	'config-logo-help' => 'Základní vzhled MediaWiki zahrnuje místo pro logo o velikosti 135×160 pixelů nad bočním menu.
Načtěte obrázek odpovídající velikosti a zadejte sem jeho URL.

Pokud logo nechcete, ponechte toto pole prázdné.',
	'config-instantcommons' => 'Zapnout Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] je funkce, která umožňuje wiki používat obrázky, zvuky a další mediální soubory ze serveru [//commons.wikimedia.org/wiki/Hlavn%C3%AD_strana Wikimedia Commons].
Aby to bylo možné, potřebuje mít MediaWiki přístup k internetu.

Více informací o této funkci, včetně instrukcí, jak ji nastavit pro jiné wiki než Wikimedia Commons, najdete v [//mediawiki.org/wiki/Manual:$wgForeignFileRepos příručce].',
	'config-cc-error' => 'Volič licence Creative Commons nevrátil žádný výsledek.
Zadejte název licence ručně.',
	'config-cc-again' => 'Zvolit znovu…',
	'config-cc-not-chosen' => 'Zvolte si požadovanou licenci Creative Commons a klikněte na tlačítko.',
	'config-advanced-settings' => 'Pokročilá konfigurace',
	'config-cache-options' => 'Nastavení cachování objektů:',
	'config-cache-help' => 'Cachování objektů se používá pro vylepšení rychlosti MediaWiki tím, že se cachují často používaná data.
Středním až velkým serverům se jeho zapnutí důrazně doporučuje, i menší servery pocítí jeho výhody.',
	'config-cache-none' => 'Bez cachování (o žádnou funkcionalitu nepřijdete, na větších wiki však může dojít ke zhoršení rychlosti)',
	'config-cache-accel' => 'Cachování PHP objektů (APC, XCache nebo WinCache)',
	'config-cache-memcached' => 'Použít Memcached (vyžaduje další nastavení a konfiguraci)',
	'config-memcached-servers' => 'Servery Memcached:',
	'config-memcached-help' => 'Seznam IP adres, které se mají používat pro Memcached.
Uveďte jednu na řádek spolu s portem. Například:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Jako typ cache jste zvolili Memcached, ale neuvedli jste žádné servery.',
	'config-memcache-badip' => 'Zadali jste neplatnou IP adresu pro Memcached: $1.',
	'config-memcache-noport' => 'Nezadali jste port serveru Memcached: $1.
Pokud port neznáte, implicitní je 11211.',
	'config-memcache-badport' => 'Čísla portů pro Memcached by měla být mezi $1 a $2.',
	'config-extensions' => 'Rozšíření',
	'config-extensions-help' => 'Výše uvedená rozšíření byla nalezena ve vašem adresáři <code>./extensions</code>.

Mohou vyžadovat dodatečnou konfiguraci, ale teď je můžete povolit.',
	'config-install-alreadydone' => "'''Upozornění:''' Vypadá to, že jste MediaWiki již nainstalovali a teď se o to pokoušíte znovu.
Pokračujte na další stránku.",
	'config-install-begin' => 'Stisknutím „{{int:config-continue}}“ spustíte instalaci MediaWiki.
Pokud ještě chcete udělat nějaké změny, stiskněte tlačítko zpět.',
	'config-install-step-done' => 'hotovo',
	'config-install-step-failed' => 'selhaly',
	'config-install-extensions' => 'Vkládají se rozšíření',
	'config-install-database' => 'Připravuje se databáze',
	'config-install-schema' => 'Vytváří se schéma',
	'config-install-pg-schema-not-exist' => 'Schéma PostgreSQL neexistuje.',
	'config-install-pg-schema-failed' => 'Založení tabulek se nezdařilo.
Ujistěte se, že uživatel „$1“ může zapisovat do schématu „$2“.',
	'config-install-pg-commit' => 'Potvrzují se změny',
	'config-install-pg-plpgsql' => 'Kontroluje se jazyk PL/pgSQL',
	'config-pg-no-plpgsql' => 'Musíte do databáze $1 nainstalovat jazyk PL/pgSQL',
	'config-pg-no-create-privs' => 'Účet zadaný pro instalaci nemá oprávnění k založení uživatelského účtu.',
	'config-pg-not-in-role' => 'Účet zadaný pro webového uživatele již existuje
Účet zadaný pro instalaci není superuživatelský a není členem role webového uživatele, takže nemůže zakládat objekty vlastněné webovým uživatelem.

MediaWiki v současné době vyžaduje, aby byl vlastníkem tabulek webový uživatel. Uveďte jiný název účtu webového uživatele nebo klikněte na „zpět“ a zadejte instalačního uživatele s odpovídajícími oprávněními.',
	'config-install-user' => 'Vytváří se databázový uživatel',
	'config-install-user-alreadyexists' => 'Uživatel „$1“ už existuje',
	'config-install-user-create-failed' => 'Vytváření uživatele „$1“ selhalo: $2',
	'config-install-user-grant-failed' => 'Uživateli „$1“ se nepodařilo přidělit oprávnění: $2',
	'config-install-user-missing' => 'Zadaný uživatel „$1“ neexistuje.',
	'config-install-user-missing-create' => 'Zadaný uživatel „$1“ neexistuje.
Pokud ho chcete založit, zaškrtněte možnost „založit účet“ níže.',
	'config-install-tables' => 'Vytvářejí se tabulky',
	'config-install-tables-exist' => "'''Upozornění''': Vypadá to, že tabulky MediaWiki již existují.
Přeskakuje se jejich zakládání.",
	'config-install-tables-failed' => "'''Chyba''': Vytvoření tabulek selhalo s následující chybou: $1",
	'config-install-interwiki' => 'Tabulka interwiki se plní implicitními položkami',
	'config-install-interwiki-list' => 'Nelze přečíst soubor <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Upozornění''': Vypadá to, že tabulka interwiki již obsahuje nějaké záznamy.
Přeskakuje se implicitní seznam.",
	'config-install-stats' => 'Inicializují se statistiky',
	'config-install-keys' => 'Vytvářejí se tajné klíče',
	'config-insecure-keys' => "'''Upozornění:''' {{PLURAL:$2|Tajný klíč|Tajné klíče}} ($1) vytvořené v průběhu instalace {{PLURAL:$2|není|nejsou}} zcela {{PLURAL:$2|bezpečný|bezpečné}}. Zvažte {{PLURAL:$2|jeho|jejich}} ruční změnu.",
	'config-install-sysop' => 'Zakládá se uživatelský účet správce',
	'config-install-subscribe-fail' => 'Nelze se přihlásit k odběru mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'Není nainstalován cURL a není dostupné allow_url_fopen.',
	'config-install-mainpage' => 'Vytváří se počáteční obsah hlavní strany',
	'config-install-extension-tables' => 'Vytvářejí se tabulky pro zapnutá rozšíření',
	'config-install-mainpage-failed' => 'Nepodařilo se vložit hlavní stranu: $1',
	'config-install-done' => "'''Gratulujeme!'''
Úspěšně jste nainstalovali MediaWiki.

Instalátor vytvořil soubor <code>LocalSettings.php</code>.
Ten obsahuje veškerou vaši konfiguraci.

Budete si ho muset stáhnout a uložit do základního adresáře vaší instalace wiki (do stejného adresáře jako soubor index.php). Stažení souboru se mělo spustit automaticky.

Pokud se vám stažení nenabídlo nebo jste ho zrušili, můžete ho spustit znovu kliknutím na následující odkaz:

$3

'''Poznámka''': Pokud to neuděláte hned, tento vygenerovaný konfigurační soubor nebude později dostupný, pokud instalaci opustíte, aniž byste si ho stáhli.

Až to dokončíte, můžete '''[$2 vstoupit do své wiki]'''.",
	'config-download-localsettings' => 'Stáhnout LocalSettings.php',
	'config-help' => 'nápověda',
	'config-nofile' => 'Soubor „$1“ nelze nalézt. Byl smazán?',
	'mainpagetext' => "'''MediaWiki byla úspěšně nainstalována.'''",
	'mainpagedocfooter' => '[//meta.wikimedia.org/wiki/Help:Contents Uživatelská příručka] vám napoví, jak MediaWiki používat.

== Začínáme ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Nastavení konfigurace]
* [//www.mediawiki.org/wiki/Manual:FAQ Často kladené otázky o MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce E-mailová konference oznámení MediaWiki]',
);

/** Kashubian (kaszëbsczi)
 */
$messages['csb'] = array(
	'mainpagetext' => "'''MediaWiki òsta zainstalowónô.'''",
);

/** Chuvash (Чӑвашла)
 */
$messages['cv'] = array(
	'mainpagetext' => "'''«MediaWiki» вики-движока лартасси ăнăçлă вĕçленчĕ.'''",
	'mainpagedocfooter' => 'Ку википе ĕçлеме пулăшакан информацине [//meta.wikimedia.org/wiki/%D0%9F%D0%BE%D0%BC%D0%BE%D1%89%D1%8C:%D0%A1%D0%BE%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D0%BD%D0%B8%D0%B5 усăç руководствинче] тупма пултаратăр.

== Пулăшма пултарĕç ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Ĕнерлевсен списокĕ];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki тăрăх час-часах ыйтакан ыйтусемпе хуравсем];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki çĕнĕ верси тухнине пĕлтерекен рассылка].',
);

/** Welsh (Cymraeg)
 * @author Xxglennxx
 */
$messages['cy'] = array(
	'mainpagetext' => "'''Wedi llwyddo gosod meddalwedd MediaWiki yma'''",
	'mainpagedocfooter' => 'Ceir cymorth (yn Saesneg) ar ddefnyddio meddalwedd wici yn y [//meta.wikimedia.org/wiki/Help:Contents Canllaw Defnyddwyr] ar wefan Wikimedia.

==Cychwyn arni==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Rhestr osodiadau wrth gyflunio]
* [//www.mediawiki.org/wiki/Manual:FAQ Cwestiynau poblogaidd ar MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Rhestr postio datganiadau MediaWiki]',
);

/** Danish (dansk)
 * @author Peter Alberti
 */
$messages['da'] = array(
	'mainpagetext' => "'''MediaWiki er nu installeret.'''",
	'mainpagedocfooter' => 'Se [//meta.wikimedia.org/wiki/Help:Contents brugervejledningen] for oplysninger om brugen af wikiprogrammellet.

== At komme i gang ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listen over opsætningsmuligheder]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki ofte stillede spørgsmål]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Postliste angående udgivelser af MediaWiki]',
);

/** German (Deutsch)
 * @author Kghbln
 * @author LWChris
 * @author Metalhead64
 * @author Purodha
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'config-desc' => 'Das MediaWiki-Installationsprogramm',
	'config-title' => 'Installation von MediaWiki $1',
	'config-information' => 'Informationen',
	'config-localsettings-upgrade' => 'Eine Datei <code>LocalSettings.php</code> wurde gefunden.
Um die vorhandene Installation aktualisieren zu können, muss der Wert des Parameters <code>$wgUpgradeKey</code> im folgenden Eingabefeld angegeben werden.
Der Parameterwert befindet sich in der Datei LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Eine Datei <code>LocalSettings.php</code> wurde gefunden.
Um die vorhandene Installation zu aktualisieren, muss die Datei <code>update.php</code> ausgeführt werden.',
	'config-localsettings-key' => 'Aktualisierungsschlüssel:',
	'config-localsettings-badkey' => 'Der angegebene Aktualisierungsschlüssel ist falsch.',
	'config-upgrade-key-missing' => 'Eine MediaWiki-Installation wurde gefunden.
Um die vorhandene Installation aktualisieren zu können, muss die unten angegebene Codezeile in die Datei LocalSettings.php an deren Ende eingefügt werden:

$1',
	'config-localsettings-incomplete' => 'Die vorhandene Datei LocalSettings.php scheint unvollständig zu sein.
Die Variable <code>$1</code> wurde nicht definiert.
Die Datei LocalSettings.php muss entsprechend geändert werden, so dass sie definiert ist. Klicke danach auf „Weiter“.',
	'config-localsettings-connection-error' => 'Beim Verbindungsversuch zur Datenbank ist, unter Verwendung der in den Dateien LocalSettings.php oder AdminSettings.php hinterlegten Einstellungen, ein Fehler aufgetreten. Diese Einstellungen müssen korrigiert werden. Danach kann ein erneuter Versuch unternommen werden.

$1',
	'config-session-error' => 'Fehler beim Starten der Sitzung: $1',
	'config-session-expired' => 'Die Sitzungsdaten scheinen abgelaufen zu sein.
Sitzungen sind für einen Zeitraum von $1 konfiguriert.
Dieser kann durch Anhebung des Parameters <code>session.gc_maxlifetime</code> in der Datei <code>php.ini</code> erhöht werden.
Den Installationsvorgang erneut starten.',
	'config-no-session' => 'Die Sitzungsdaten sind verloren gegangen!
Die Datei <code>php.ini</code> muss geprüft und es muss dabei sichergestellt werden, dass der Parameter <code>session.save_path</code> auf das richtige Verzeichnis verweist.',
	'config-your-language' => 'Sprache während des Installierens:',
	'config-your-language-help' => 'Bitte die Sprache auswählen, die während des Installationsvorgangs verwendet werden soll.',
	'config-wiki-language' => 'Sprache des Wikis:',
	'config-wiki-language-help' => 'Bitte die Sprache auswählen, die überwiegend beim Erstellen der Inhalte verwendet werden soll.',
	'config-back' => '← Zurück',
	'config-continue' => 'Weiter →',
	'config-page-language' => 'Sprache',
	'config-page-welcome' => 'Willkommen bei MediaWiki!',
	'config-page-dbconnect' => 'Mit der Datenbank verbinden',
	'config-page-upgrade' => 'Eine vorhandene Installation aktualisieren',
	'config-page-dbsettings' => 'Einstellungen zur Datenbank',
	'config-page-name' => 'Name',
	'config-page-options' => 'Optionen',
	'config-page-install' => 'Installieren',
	'config-page-complete' => 'Fertig!',
	'config-page-restart' => 'Installationsvorgang erneut starten',
	'config-page-readme' => 'Lies mich',
	'config-page-releasenotes' => 'Versionsinfos (en)',
	'config-page-copying' => 'Kopie der Lizenz',
	'config-page-upgradedoc' => 'Aktualisiere',
	'config-page-existingwiki' => 'Vorhandenes Wiki',
	'config-help-restart' => 'Sollen alle bereits eingegebene Daten gelöscht und der Installationsvorgang erneut gestartet werden?',
	'config-restart' => 'Ja, erneut starten',
	'config-welcome' => '=== Prüfung der Installationsumgebung ===
Die Basisprüfungen werden durchgeführt, um festzustellen, ob die Installationsumgebung für die Installation von MediaWiki geeignet ist.
Die Ergebnisse dieser Prüfung sollten angegeben werden, sofern während des Installationsvorgangs Hilfe benötigt und erfragt wird.',
	'config-copyright' => "=== Lizenz und Nutzungsbedingungen ===

$1

Dieses Programm ist freie Software, d. h. es kann, gemäß den Bedingungen der von der Free Software Foundation veröffentlichten ''GNU General Public License'', weiterverteilt und/oder modifiziert werden. Dabei kann die Version 2, oder nach eigenem Ermessen, jede neuere Version der Lizenz verwendet werden.

Dieses Programm wird in der Hoffnung verteilt, dass es nützlich sein wird, allerdings '''ohne jegliche Garantie''' und sogar ohne die implizierte Garantie einer '''Marktgängigkeit''' oder '''Eignung für einen bestimmten Zweck'''. Hierzu sind weitere Hinweise in der ''GNU General Public License'' enthalten.

Eine <doclink href=Copying>Kopie der ''GNU General Public License''</doclink> sollte zusammen mit diesem Programm verteilt worden sein. Sofern dies nicht der Fall war, kann eine Kopie bei der Free Software Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA, schriftlich angefordert oder auf deren Website [http://www.gnu.org/copyleft/gpl.html online gelesen] werden.",
	'config-sidebar' => '* [//www.mediawiki.org/wiki/MediaWiki/de Website von MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents/de Benutzeranleitung]
* [//www.mediawiki.org/wiki/Manual:Contents/de Administratorenanleitung]
* [//www.mediawiki.org/wiki/Manual:FAQ/de Häufig gestellte Fragen]
----
* <doclink href=Readme>Lies mich</doclink>
* <doclink href=ReleaseNotes>Versionsinformationen</doclink>
* <doclink href=Copying>Lizenzbestimmungen</doclink>
* <doclink href=UpgradeDoc>Aktualisierung</doclink>',
	'config-env-good' => 'Die Installationsumgebung wurde geprüft.
MediaWiki kann installiert werden.',
	'config-env-bad' => 'Die Installationsumgebung wurde geprüft.
MediaWiki kann nicht installiert werden.',
	'config-env-php' => 'PHP $1 ist installiert.',
	'config-env-php-toolow' => 'PHP $1 ist installiert.
Allerdings benötigt MediaWiki PHP $2 oder höher.',
	'config-unicode-using-utf8' => 'Zur Unicode-Normalisierung wird Brion Vibbers <code>utf8_normalize.so</code> eingesetzt.',
	'config-unicode-using-intl' => 'Zur  Unicode-Normalisierung wird die [http://pecl.php.net/intl PECL-Erweiterung intl] eingesetzt.',
	'config-unicode-pure-php-warning' => "'''Warnung:''' Die [http://pecl.php.net/intl PECL-Erweiterung intl] ist für die Unicode-Normalisierung nicht verfügbar, so dass stattdessen die langsame pure-PHP-Implementierung genutzt wird.
Sofern eine Website mit großer Benutzeranzahl betrieben wird, sollten weitere Informationen auf der Webseite [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode-Normalisierung (en)] gelesen werden.",
	'config-unicode-update-warning' => "'''Warnung:''' Die installierte Version des Unicode-Normalisierungswrappers nutzt einer ältere Version der Bibliothek des [http://site.icu-project.org/ ICU-Projekts].
Diese sollte [//www.mediawiki.org/wiki/Unicode_normalization_considerations aktualisiert] werden, sofern auf die Verwendung von Unicode Wert gelegt wird.",
	'config-no-db' => 'Es konnte kein adäquater Datenbanktreiber gefunden werden. Es muss daher ein Datenbanktreiber für PHP installiert werden.
Die folgenden Datenbanksysteme werden unterstützt: $1

Sofern ein gemeinschaftlich genutzter Server für das Hosting verwendet wird, muss der Hoster gefragt werden einen adäquaten Datenbanktreiber zu installieren.
Sofern PHP selbst kompiliert wurde, muss es mit es neu konfiguriert werden, wobei der Datenbankclient zu aktivierten ist. Hierzu kann beispielsweise <code>./configure --with-mysql</code> ausgeführt werden.
Sofern PHP über die Paketverwaltung einer Debian- oder Ubuntu-Installation installiert wurde, muss das „php5-mysql“-Paket nachinstalliert werden.',
	'config-outdated-sqlite' => "'''Warnung:''' SQLite $1 ist installiert. Allerdings benötigt MediaWiki SQLite $2 oder höher. SQLite wird daher nicht verfügbar sein.",
	'config-no-fts3' => "'''Warnung:''' SQLite wurde ohne das [//sqlite.org/fts3.html FTS3-Modul] kompiliert, so dass keine Suchfunktionen für dieses Datenbanksystem zur Verfügung stehen werden.",
	'config-register-globals' => "'''Warnung: Der Parameter <code>[http://php.net/register_globals register_globals]</code> von PHP ist aktiviert.'''
'''Sie sollte deaktiviert werden, sofern dies möglich ist.'''
Die MediaWiki-Installation wird zwar laufen, wobei aber der Server für potentielle Sicherheitsprobleme anfällig ist.",
	'config-magic-quotes-runtime' => "'''Fataler Fehler: Der Parameter <code>[http://www.php.net/manual/de/function.set-magic-quotes-runtime.php set_magic_quotes_runtime]</code> von PHP ist aktiviert!'''
Diese Einstellung führt zu unvorhersehbaren Problemen bei der Dateneingabe.
MediaWiki kann nicht installiert werden, solange dieser Parameter nicht deaktiviert wurde.",
	'config-magic-quotes-sybase' => "'''Fataler Fehler: Der Parameter <code>[http://www.php.net/manual/de/sybase.configuration.php#ini.magic-quotes-sybase magic_quotes_sybase]</code> von PHP ist aktiviert!'''
Diese Einstellung führt zu unvorhersehbaren Problemen bei der Dateneingabe.
MediaWiki kann nicht installiert werden, solange dieser Parameter nicht deaktiviert wurde.",
	'config-mbstring' => "'''Fataler Fehler: Der Parameter <code>[http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]</code> von PHP ist aktiviert!'''
Diese Einstellung verursacht Fehler und führt zu unvorhersehbaren Problemen bei der Dateneingabe.
MediaWiki kann nicht installiert werden, solange dieser Parameter nicht deaktiviert wurde.",
	'config-ze1' => "'''Fataler Fehler: Der Parameter <code>[http://www.php.net/manual/de/ini.core.php zend.ze1_compatibility_mode]</code> von PHP ist aktiviert!'''
Diese Einstellung führt zu großen Fehlern bei MediaWiki.
MediaWiki kann nicht installiert werden, solange dieser Parameter nicht deaktiviert wurde.",
	'config-safe-mode' => "'''Warnung:''' Der Funktion <code>[http://www.php.net/features.safe-mode Safe Mode]</code> von PHP ist aktiviert.
Dies kann zu Problemen führen, insbesondere wenn das Hochladen von Dateien möglich sein, bzw. der Auszeichner <code>math</code> genutzt werden soll.",
	'config-xml-bad' => 'Das XML-Modul von PHP fehlt.
MediaWiki benötigt Funktionen, die dieses Modul bereitstellt und wird in der bestehenden Konfiguration nicht funktionieren.
Sofern Mandriva genutzt wird, muss noch das „php-xml“-Paket installiert werden.',
	'config-pcre' => 'Das PHP-Modul für die PCRE-Unterstützung wurde nicht gefunden.
MediaWiki benötigt allerdings perl-kompatible reguläre Ausdrücke, um lauffähig zu sein.',
	'config-pcre-no-utf8' => "'''Fataler Fehler:''' Das PHP-Modul PCRE scheint ohne PCRE_UTF8-Unterstützung kompiliert worden zu sein.
MediaWiki benötigt die UTF-8-Unterstützung, um fehlerfrei lauffähig zu sein.",
	'config-memory-raised' => 'Der PHP-Parameter <code>memory_limit</code> betrug $1 und wurde auf $2 erhöht.',
	'config-memory-bad' => "'''Warnung:''' Der PHP-Parameter <code>memory_limit</code> beträgt $1.
Dieser Wert ist wahrscheinlich zu niedrig.
Der Installationsvorgang könnte daher scheitern!",
	'config-ctype' => "'''Fataler Fehler:''' PHP muss mit Unterstützung für das [http://www.php.net/manual/de/ctype.installation.php Modul ctype] kompiliert werden.",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] ist installiert',
	'config-apc' => '[http://www.php.net/apc APC] ist installiert',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] ist installiert',
	'config-no-cache' => "'''Warnung:''' [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] oder [http://www.iis.net/download/WinCacheForPhp WinCache] konnten nicht gefunden werden.
Das Objektcaching kann daher nicht aktiviert werden.",
	'config-mod-security' => "'''Warnung:''' Auf dem Webserver wurde [http://modsecurity.org/ ModSecurity] aktiviert. Sofern falsch konfiguriert, kann dies zu Problemen mit MediaWiki sowie anderer Software auf dem Server führen und es Benutzern ermöglichen beliebige Inhalte im Wiki einzustellen.
Für weitere Informationen empfehlen wir die [http://modsecurity.org/documentation/ Dokumentation zu ModSecurity] oder den Kontakt zum Hoster, sofern Fehler auftreten.",
	'config-diff3-bad' => 'GNU diff3 wurde nicht gefunden.',
	'config-imagemagick' => 'ImageMagick wurde gefunden: <code>$1</code>.
Miniaturansichten von Bildern werden möglich sein, sobald das Hochladen von Dateien aktiviert wurde.',
	'config-gd' => 'Die im System integrierte GD-Grafikbibliothek wurde gefunden.
Miniaturansichten von Bildern werden möglich sein, sobald das Hochladen von Dateien aktiviert wurde.',
	'config-no-scaling' => 'Weder die GD-Grafikbibliothek noch ImageMagick wurden gefunden.
Miniaturansichten von Bildern sind daher nicht möglich.',
	'config-no-uri' => "'''Fehler:''' Die aktuelle URL konnte nicht ermittelt werden.
Der Installationsvorgang wurde daher abgebrochen.",
	'config-no-cli-uri' => "'''Warnung''': Es wurde kein Pfad zum Skipt (--scriptpath) angegeben. Daher wird der Standardpfad genutzt: <code>$1</code>.",
	'config-using-server' => 'Der Servername „<nowiki>$1</nowiki>“ wird verwendet.',
	'config-using-uri' => 'Die Server-URL „<nowiki>$1$2</nowiki>“ wird verwendet.',
	'config-uploads-not-safe' => "'''Warnung:''' Das Standardverzeichnis für hochgeladene Dateien <code>$1</code> ist für die willkürliche Ausführung von Skripten anfällig.
Obwohl MediaWiki die hochgeladenen Dateien auf Sicherheitsrisiken überprüft, wird dennoch dringend empfohlen diese [//www.mediawiki.org/wiki/Manual:Security#Upload_security Sicherheitslücke] zu schließen, bevor das Hochladen von Dateien aktiviert wird.",
	'config-no-cli-uploads-check' => "'''Warnung''': Das Standardverzeichnis für hochgeladene Dateien (<code>$1</code>) wird, während der Installation über die Kommandozeile, nicht auf Sicherheitsanfälligkeiten hinsichtlich willkürlicher Skriptausführungen geprüft.",
	'config-brokenlibxml' => 'Das System nutzt eine Kombination aus PHP- und libxml2-Versionen, die fehleranfällig ist und versteckte Datenfehler bei MediaWiki und anderen Webanwendungen verursachen kann.
PHP muss auf Version 5.2.9 oder später sowie libxml2 auf die Version 2.7.3 oder später aktualisiert werden, um das Problem zu lösen. Installationsabbruch ([//bugs.php.net/bug.php?id=45996 siehe hierzu die Fehlermeldung bei PHP]).',
	'config-using531' => 'MediaWiki kann nicht zusammen mit PHP $1 verwendet werden. Grund hierfür ist ein Fehler im Zusammenhang mit den Verweisparametern zu <code>__call()</code>.
PHP muss auf Version 5.3.2 oder höher oder 5.3.0 oder niedriger aktualisiert werden, um das Problem zu beheben.
Die Installation wurde abgebrochen.',
	'config-suhosin-max-value-length' => 'Suhosin ist installiert und beschränkt die Länge des GET-Parameters auf $1 Bytes. Der ResouceLoader von MediaWiki wird zwar unter diesen Bedingungen funktionieren, allerdings nur mit verminderter Leistungsfähigkeit. Sofern möglich sollte der Parameter <code>suhosin.get.max_value_length</code> in der Datei php.ini auf 1024 oder höher festgelegt werden. Gleichzeitig muss der Parameter <code>$wgResourceLoaderMaxQueryLength</code> in der Datei LocalSettings.php auf den selben Wert eingestellt werden.',
	'config-db-type' => 'Datenbanksystem:',
	'config-db-host' => 'Datenbankserver:',
	'config-db-host-help' => 'Sofern sich die Datenbank auf einem anderen Server befindet, ist hier der Servername oder die entsprechende IP-Adresse anzugeben.

Sofern ein gemeinschaftlich genutzter Server verwendet wird, sollte der Hoster den zutreffenden Servernamen in seiner Dokumentation angegeben haben.

Sofern auf einem Windows-Server installiert und MySQL genutzt wird, funktioniert der Servername „localhost“ voraussichtlich nicht. Wenn nicht, sollte  „127.0.0.1“ oder die lokale IP-Adresse angegeben werden.

Sofern PostgresQL genutzt wird, muss dieses Feld leer gelassen werden, um über ein Unix-Socket zu verbinden.',
	'config-db-host-oracle' => 'Datenbank-TNS:',
	'config-db-host-oracle-help' => 'Einen gültigen [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm „Local Connect“-Namen] angeben. Die „tnsnames.ora“-Datei muss von dieser Installation erkannt werden können.<br />Sofern die Client-Bibliotheken für Version 10g oder neuer verwendet werden, kann auch [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm „Easy Connect“] zur Namensgebung genutzt werden.',
	'config-db-wiki-settings' => 'Bitte Daten zur eindeutigen Identifikation dieses Wikis angeben',
	'config-db-name' => 'Datenbankname:',
	'config-db-name-help' => 'Bitte einen Namen angeben, mit dem das Wiki identifiziert werden kann.
Dabei sollten keine Leerzeichen verwendet werden.

Sofern ein gemeinschaftlich genutzter Server verwendet wird, sollte der Hoster den Datenbanknamen angegeben oder aber die Erstellung einer Datenbank über ein entsprechendes Interface gestattet haben.',
	'config-db-name-oracle' => 'Datenbankschema:',
	'config-db-account-oracle-warn' => 'Es gibt drei von MediaWiki unterstützte Möglichkeiten Oracle als Datenbank einzurichten:

Sofern das Datenbankbenutzerkonto während des Installationsvorgangs erstellt werden soll, muss ein Datenbankbenutzerkonto mit der SYSDBA-Berechtigung zusammen mit den entsprechenden Anmeldeinformationen angegeben werden, mit dem dann über das Web auf die Datenbank zugegriffen werden kann. Alternativ kann man auch lediglich ein einzelnes manuell angelegtes Datenbankbenutzerkonto angeben, mit dem über das Web auf die Datenbank zugegriffen werden kann, sofern dieses über die Berechtigung zur Erstellung von Datenbankschemen verfügt. Zudem ist es möglich zwei Datenbankbenutzerkonten anzugeben von denen eines die Berechtigung zur Erstellung von Datenbankschemen hat und das andere, um mit ihm über das Web auf die Datenbank zuzugreifen.

Ein Skript zum Anlegen eines Datenbankbenutzerkontos mit den notwendigen Berechtigungen findet man unter dem Pfad „…/maintenance/oracle/“ dieser MediaWiki-Installation. Es ist dabei zu bedenken, dass die Verwendung eines Datenbankbenutzerkontos mit beschränkten Berechtigungen die Nutzung der Wartungsfunktionen für das Standarddatenbankbenutzerkonto deaktiviert.',
	'config-db-install-account' => 'Benutzerkonto für die Installation',
	'config-db-username' => 'Name des Datenbankbenutzers:',
	'config-db-password' => 'Passwort des Datenbankbenutzers:',
	'config-db-password-empty' => 'Bitte ein Passwort für den neuen Datenbankbenutzer angeben: $1
Obzwar es möglich ist Datenbankbenutzer ohne Passwort anzulegen, so ist dies aber nicht sicher.',
	'config-db-install-username' => 'Den Benutzernamen angeben, der für die Verbindung mit der Datenbank während des Installationsvorgangs genutzt werden soll. Es handelt sich dabei nicht um den Benutzernamen für das MediaWiki-Konto, sondern um den Benutzernamen der vorgesehenen Datenbank.',
	'config-db-install-password' => 'Das Passwort angeben, das für die Verbindung mit der Datenbank während des Installationsvorgangs genutzt werden soll. Es handelt sich dabei nicht um das Passwort für das MediaWiki-Konto, sondern um das Passwort der vorgesehenen Datenbank.',
	'config-db-install-help' => 'Benutzername und Passwort, die während des Installationsvorgangs, für die Verbindung mit der Datenbank, genutzt werden sollen, sind nun anzugeben.',
	'config-db-account-lock' => 'Derselbe Benutzername und das Passwort müssen während des Normalbetriebs des Wikis verwendet werden.',
	'config-db-wiki-account' => 'Benutzerkonto für den normalen Betrieb',
	'config-db-wiki-help' => 'Bitte Benutzernamen und Passwort angeben, die der Webserver während des Normalbetriebes dazu verwenden soll, eine Verbindung zum Datenbankserver herzustellen.
Sofern ein entsprechendes Benutzerkonto nicht vorhanden ist und das Benutzerkonto für den Installationsvorgang über ausreichende Berechtigungen verfügt, wird dieses Benutzerkonto automatisch mit den Mindestberechtigungen zum Normalbetrieb des Wikis angelegt.',
	'config-db-prefix' => 'Datenbanktabellenpräfix:',
	'config-db-prefix-help' => 'Sofern eine Datenbank für mehrere Wikiinstallationen oder eine Wikiinstallation und eine andere Programminstallation genutzt werden soll, muss ein Datenbanktabellenpräfix angegeben werden, um Datenbankprobleme zu vermeiden.
Es können keine Leerzeichen verwendet werden.

Gewöhnlich bleibt dieses Datenfeld leer.',
	'config-db-charset' => 'Datenbankzeichensatz',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binär',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 abwärtskompatibles UTF-8',
	'config-charset-help' => "'''Warnung:''' Sofern '''abwärtskompatibles UTF-8''' bei MySQL 4.1+ verwendet und anschließend die Datenbank mit <code>mysqldump</code> gesichert wird, könnten alle nicht mit ASCII-codierten Zeichen beschädigt werden, was zu irreversiblen Schäden der Datensicherung führt!

Im '''binären Modus''' speichert MediaWiki UTF-8 Texte in der Datenbank in binär kodierte Datenfelder.
Dies ist effizienter als der UTF-8-Modus von MySQL und ermöglicht so die Verwendung jeglicher Unicode-Zeichen.
Im '''UTF-8-Modus''' wird MySQL den Zeichensatz der Daten erkennen und sie richtig anzeigen und konvertieren.
Es können allerdings keine Zeichen außerhalb des [//de.wikipedia.org/wiki/Basic_Multilingual_Plane#Gliederung_in_Ebenen_und_Bl.C3.B6cke ''Basic Multilingual Plane'' (BMP)] gespeichert werden.",
	'config-mysql-old' => 'MySQL $1 oder höher wird benötigt. MySQL $2 ist momentan vorhanden.',
	'config-db-port' => 'Datenbankport:',
	'config-db-schema' => 'Datenschema für MediaWiki',
	'config-db-schema-help' => 'Dieses Datenschema ist in der Regel allgemein verwendbar.
Nur Änderungen daran vornehmen, sofern es gute Gründe dafür gibt.',
	'config-pg-test-error' => "Es kann keine Verbindung zur Datenbank '''$1''' hergestellt werden: $2",
	'config-sqlite-dir' => 'SQLite-Datenverzeichnis:',
	'config-sqlite-dir-help' => "SQLite speichert alle Daten in einer einzigen Datei.

Das für sie vorgesehene Verzeichnis muss während des Installationsvorgangs beschreibbar sein.

Es sollte '''nicht'' über das Web zugänglich sein, was der Grund ist, warum die Datei nicht dort abgelegt wird, wo sich die PHP-Dateien befinden.

Das Installationsprogramm wird mit der Datei zusammen eine zusätzliche <code>.htaccess</code>-Datei erstellen. Sofern dies scheitert, können Dritte auf die Datendatei zugreifen.
Dies umfasst die Nutzerdaten (E-Mail-Adressen, Passwörter, etc.) wie auch gelöschte Seitenversionen und andere vertrauliche Daten, die im Wiki gespeichert sind.

Es ist daher zu erwägen die Datendatei an gänzlich anderer Stelle abzulegen, beispielsweise im Verzeichnis <code>./var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Standardtabellenraum:',
	'config-oracle-temp-ts' => 'Temporärer Tabellenraum:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki unterstützt die folgenden Datenbanksysteme:

$1

Sofern nicht das Datenbanksystem angezeigt wird, das verwendet werden soll, gibt es oben einen Link zur Anleitung mit Informationen, wie dieses aktiviert werden kann.',
	'config-support-mysql' => '* $1 ist das von MediaWiki primär unterstützte Datenbanksystem ([http://www.php.net/manual/en/mysql.installation.php Anleitung zur Kompilierung von PHP mit MySQL-Unterstützung (en)])',
	'config-support-postgres' => '* $1 ist ein beliebtes Open-Source-Datenbanksystem und eine Alternative zu MySQL ([http://www.php.net/manual/de/pgsql.installation.php Anleitung zur Kompilierung von PHP mit PostgreSQL-Unterstützung]). Es gibt allerdings einige kleinere Implementierungsfehler, so dass von der Nutzung in einer Produktivumgebung abgeraten wird.',
	'config-support-sqlite' => '* $1 ist ein verschlanktes Datenbanksystem, das auch gut unterstützt wird ([http://www.php.net/manual/de/pdo.installation.php Anleitung zur Kompilierung von PHP mit SQLite-Unterstützung], verwendet PHP Data Objects (PDO))',
	'config-support-oracle' => '* $1 ist eine kommerzielle Unternehmensdatenbank ([http://www.php.net/manual/en/oci8.installation.php Anleitung zur Kompilierung von PHP mit OCI8-Unterstützung (en)])',
	'config-support-ibm_db2' => '* $1 ist eine kommerzielle Unternehmensdatenbank',
	'config-header-mysql' => 'MySQL-Einstellungen',
	'config-header-postgres' => 'PostgreSQL-Einstellungen',
	'config-header-sqlite' => 'SQLite-Einstellungen',
	'config-header-oracle' => 'Oracle-Einstellungen',
	'config-header-ibm_db2' => 'IBM DB2-Einstellungen',
	'config-invalid-db-type' => 'Unzulässiges Datenbanksystem',
	'config-missing-db-name' => 'Bei „Datenbankname“ muss ein Wert angegeben werden.',
	'config-missing-db-host' => 'Bei „Datenbankhost“ muss ein Wert angegeben werden.',
	'config-missing-db-server-oracle' => 'Für das „Datenbank-TNS“ muss ein Wert eingegeben werden',
	'config-invalid-db-server-oracle' => 'Ungültiges Datenbank-TNS „$1“.
Es dürfen nur ASCII-codierte Buchstaben (a-z, A-Z), Zahlen (0-9) und Unterstriche (_) und Punkte (.) verwendet werden.',
	'config-invalid-db-name' => 'Ungültiger Datenbankname „$1“.
Es dürfen nur ASCII-codierte Buchstaben (a-z, A-Z), Zahlen (0-9), Unter- (_) sowie Bindestriche (-) verwendet werden.',
	'config-invalid-db-prefix' => 'Ungültiger Datenbanktabellenpräfix „$1“.
Es dürfen nur ASCII-codierte Buchstaben (a-z, A-Z), Zahlen (0-9), Unter- (_) sowie Bindestriche (-) verwendet werden.',
	'config-connection-error' => '$1.

Bitte unten angegebenen Servernamen, Benutzernamen sowie das Passwort überprüfen und es danach erneut versuchen.',
	'config-invalid-schema' => 'Ungültiges Datenschema für MediaWiki „$1“.
Es dürfen nur ASCII-codierte Buchstaben (a-z, A-Z), Zahlen (0-9) und Unterstriche (_) verwendet werden.',
	'config-db-sys-create-oracle' => 'Das Installationsprogramm unterstützt nur die Verwendung eines Datenbankbenutzerkontos mit SYSDBA-Berechtigung zum Anlegen eines neuen Datenbankbenutzerkontos.',
	'config-db-sys-user-exists-oracle' => 'Das Datenbankbenutzerkonto „$1“ ist bereits vorhanden. Ein Datenbankbenutzerkontos mit SYSDBA-Berechtigung kann nur zum Anlegen eines neuen Datenbankbenutzerkontos genutzt werden.',
	'config-postgres-old' => 'PostgreSQL $1 oder höher wird benötigt. PostgreSQL $2 ist momentan vorhanden.',
	'config-sqlite-name-help' => 'Bitten einen Namen angeben, mit dem das Wiki identifiziert werden kann.
Dabei bitte keine Leerzeichen oder Bindestriche verwenden.
Dieser Name wird für die SQLite-Datendateinamen genutzt.',
	'config-sqlite-parent-unwritable-group' => 'Das Datenverzeichnis <code><nowiki>$1</nowiki></code> kann nicht erzeugt werden, da das übergeordnete Verzeichnis <code><nowiki>$2</nowiki></code> nicht für den Webserver beschreibbar ist.

Das Installationsprogramm konnte den Benutzer bestimmen, mit dem Webserver ausgeführt wird.
Schreibzugriff auf das <code><nowiki>$3</nowiki></code>-Verzeichnis muss für diesen ermöglicht werden, um den Installationsvorgang fortsetzen zu können.

Auf einem Unix- oder Linux-System:
<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Das Datenverzeichnis <code><nowiki>$1</nowiki></code> kann nicht erzeugt werden, da das übergeordnete Verzeichnis <code><nowiki>$2</nowiki></code> nicht für den Webserver beschreibbar ist.

Das Installationsprogramm konnte den Benutzer bestimmen, mit dem Webserver ausgeführt wird.
Schreibzugriff auf das <code><nowiki>$3</nowiki></code>-Verzeichnis muss global für diesen und andere Benutzer ermöglicht werden, um den Installationsvorgang fortsetzen zu können.

Auf einem Unix- oder Linux-System:
<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Fehler beim Erstellen des Datenverzeichnisses „$1“.

Bitte den Speicherort überprüfen und es danach erneut versuchen.',
	'config-sqlite-dir-unwritable' => 'Das Verzeichnis „$1“  ist nicht beschreibbar.
Bitte die Zugriffsberechtigungen so ändern, dass dieses Verzeichnis für den Webserver beschreibbar ist und es danach erneut versuchen.',
	'config-sqlite-connection-error' => '$1.

Bitte unten angegebenes Datenverzeichnis sowie den Datenbanknamen überprüfen und es danach erneut versuchen.',
	'config-sqlite-readonly' => 'Die Datei <code>$1</code> ist nicht beschreibbar.',
	'config-sqlite-cant-create-db' => 'Die Datenbankdatei <code>$1</code> konnte nicht erzeugt werden.',
	'config-sqlite-fts3-downgrade' => 'PHP verfügt nicht über FTS3-Unterstützung. Die Tabellen wurden zurückgestuft.',
	'config-can-upgrade' => "Es wurden MediaWiki-Tabellen in dieser Datenbank gefunden.
Um sie auf MediaWiki $1 zu aktualisieren, bitte auf '''Weiter''' klicken.",
	'config-upgrade-done' => "Die Aktualisierung ist nun abgeschlossen.

Das Wiki kann nun [$1 genutzt werden].

Sofern die Datei <code>LocalSettings.php</code> neu erzeugt werden soll, bitte auf die Schaltfläche unten klicken.
Dies wird '''nicht empfohlen''', es sei denn, es treten Probleme mit dem Wiki auf.",
	'config-upgrade-done-no-regenerate' => 'Die Aktualisierung ist abgeschlossen.

Das Wiki kann nun [$1 genutzt werden].',
	'config-regenerate' => 'LocalSettings.php neu erstellen →',
	'config-show-table-status' => 'Die Abfrage SHOW TABLE STATUS ist gescheitert!',
	'config-unknown-collation' => "'''Warnung:''' Die Datenbank nutzt eine unbekannte Kollation.",
	'config-db-web-account' => 'Datenbankkonto für den Webzugriff',
	'config-db-web-help' => 'Bitte Benutzernamen und Passwort auswählen, die der Webserver während des Normalbetriebes dazu verwenden soll, eine Verbindung zum Datenbankserver herzustellen.',
	'config-db-web-account-same' => 'Dasselbe Datenbankkonto wie während des Installationsvorgangs verwenden',
	'config-db-web-create' => 'Sofern nicht bereits vorhanden, muss nun das Konto erstellt werden',
	'config-db-web-no-create-privs' => 'Das angegebene und für den Installationsvorgang vorgesehene Datenbankkonto verfügt nicht über ausreichend Berechtigungen, um ein weiteres Datenbankkonto zu erstellen.
Das hier angegebene Datenbankkonto muss daher bereits vorhanden sein.',
	'config-mysql-engine' => 'Speicher-Engine:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Warnung:''' Es wurde MyISAM als Speicher-Engine für MySQL ausgewählt, die aus folgenden Gründen nicht die für den Einsatz mit MediaWiki empfohlene ist:
* sie unterstützt aufgrund von Tabellensperrungen kaum die nebenläufige Ausführung von Aktionen
* sie ist anfälliger für Datenprobleme
* sie wird von MediaWiki nicht immer adäquat unterstützt

Sofern die vorhandene MySQL-Installation die Speicher-Engine InnoDB unterstützt, wird deren Verwendung eindringlich empfohlen.
Sofern sie sie nicht unterstützt, sollte eine entsprechende Aktualisierung nunmehr Erwägung gezogen werden.",
	'config-mysql-engine-help' => "'''InnoDB''' ist fast immer die bessere Wahl, da es gleichzeitige Zugriffe gut unterstützt.

'''MyISAM''' ist in Einzelnutzerumgebungen sowie bei schreibgeschützten Wikis schneller.
Bei MyISAM-Datenbanken treten tendenziell häufiger Fehler auf als bei InnoDB-Datenbanken.",
	'config-mysql-charset' => 'Datenbankzeichensatz:',
	'config-mysql-binary' => 'binär',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "Im '''binären Modus''' speichert MediaWiki UTF-8 Texte in der Datenbank in binär kodierte Datenfelder.
Dies ist effizienter als der UTF-8-Modus von MySQL und ermöglicht so die Verwendung jeglicher Unicode-Zeichen.

Im '''UTF-8-Modus''' wird MySQL den Zeichensatz der Daten erkennen und sie richtig anzeigen und konvertieren,
allerdings können keine Zeichen außerhalb des [//de.wikipedia.org/wiki/Basic_Multilingual_Plane#Gliederung_in_Ebenen_und_Bl.C3.B6cke ''Basic Multilingual Plane'' (BMP)] gespeichert werden.",
	'config-ibm_db2-low-db-pagesize' => "Die DB2-Datenbank verfügt über einen Standardtabellenraum mit einer unzureichenden Seitengröße. Die Seitengröße muss '''32 000'' oder größer sein.",
	'config-site-name' => 'Name des Wikis:',
	'config-site-name-help' => 'Er wird in der Titelleiste des Browsers, wie auch verschiedenen anderen Stellen, genutzt.',
	'config-site-name-blank' => 'Den Namen des Wikis angeben.',
	'config-project-namespace' => 'Name des Projektnamensraums:',
	'config-ns-generic' => 'Projekt',
	'config-ns-site-name' => 'Entspricht dem Namen des Wikis: $1',
	'config-ns-other' => 'Anderer Name (bitte angeben)',
	'config-ns-other-default' => 'MeinWiki',
	'config-project-namespace-help' => "Dem Beispiel von Wikipedia folgend, unterscheiden viele Wikis zwischen den Seiten für Inhalte und denen für Richtlinien. Letztere werden im „'''Projektnamensraum'''“ hinterlegt.
Alle Seiten dieses Namensraumes verfügen über einen Seitenpräfix, der nun an dieser Stelle angegeben werden kann.
Traditionell steht dieser Seitenpräfix mit dem Namen des Wikis in einem engen Zusammenhang. Dabei können bestimmte Sonderzeichen wie „#“ oder „:“ nicht verwendet werden.",
	'config-ns-invalid' => 'Der angegebene Namensraum „<nowiki>$1</nowiki>“ ist ungültig.
Bitte einen abweichenden Projektnamensraum angeben.',
	'config-ns-conflict' => 'Der angegebene Namensraum „<nowiki>$1</nowiki>“ verursacht Problem mit dem Standardnamensraum von MediaWiki.
Bitte einen abweichenden Projektnamensraum angeben.',
	'config-admin-box' => 'Administratorkonto',
	'config-admin-name' => 'Name:',
	'config-admin-password' => 'Passwort:',
	'config-admin-password-confirm' => 'Passwort wiederholen:',
	'config-admin-help' => 'Bitte den bevorzugten Benutzernamen angeben, beispielsweise „Knut Wuchtig“.
Dies ist der Name, der benötigt wird, um sich im Wiki anzumelden.',
	'config-admin-name-blank' => 'Bitte den Benutzernamen für den Administratoren angeben.',
	'config-admin-name-invalid' => 'Der angegebene Benutzername „<nowiki>$1</nowiki>“ ist ungültig.
Bitte einen abweichenden Benutzernamen angeben.',
	'config-admin-password-blank' => 'Bitte das Passwort für das Administratorkonto angeben.',
	'config-admin-password-same' => 'Das Passwort darf nicht mit dem Benutzernamen übereinstimmen.',
	'config-admin-password-mismatch' => 'Die beiden Passwörter stimmen nicht überein.',
	'config-admin-email' => 'E-Mail-Adresse:',
	'config-admin-email-help' => 'Bitte hier eine E-Mail-Adresse angeben, die den E-Mail-Empfang von anderen Benutzern des Wikis, das Zurücksetzen des Passwortes sowie Benachrichtigungen zu Änderungen an beobachteten Seiten ermöglicht. Diese Feld kann leer gelassen werden.',
	'config-admin-error-user' => 'Es ist beim Erstellen des Administrators mit dem Namen „<nowiki>$1</nowiki>“ ein interner Fehler aufgetreten.',
	'config-admin-error-password' => 'Es ist beim Setzen des Passworts für den Administrator „<nowiki>$1</nowiki>“ ein interner Fehler aufgetreten: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Es wurde eine ungültige E-Mail-Adresse angegeben',
	'config-subscribe' => 'Bitte die Mailingliste [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mitteilungen zu Versionsveröffentlichungen] abonnieren.',
	'config-subscribe-help' => 'Es handelt sich hierbei um eine Mailingliste mit wenigen Aussendungen, die für Mitteilungen zu Versionsveröffentlichungen, einschließlich wichtiger Sicherheitsveröffentlichungen, genutzt wird.
Diese Mailingliste sollte abonniert werden. Zudem sollte die MediaWiki-Installation stets aktualisiert werden, sobald eine neue Programmversion veröffentlicht wurde.',
	'config-subscribe-noemail' => 'Beim Abonnieren der Mailingliste mit Mitteilungen zu Versionsveröffentlichungen wurde keine E-Mail-Adresse angegeben.
Bitte eine E-Mail-Adresse angeben, sofern die Mailingliste abonniert werden soll.',
	'config-almost-done' => 'Der Vorgang ist fast abgeschlossen!
Die verbleibenden Konfigurationseinstellungen können übersprungen und das Wiki umgehend installiert werden.',
	'config-optional-continue' => 'Ja, es sollen weitere Konfigurationseinstellungen vorgenommen werden.',
	'config-optional-skip' => 'Nein, das Wiki soll nun installiert werden.',
	'config-profile' => 'Profil der Benutzerberechtigungen:',
	'config-profile-wiki' => 'offenes Wiki',
	'config-profile-no-anon' => 'Erstellung eines Benutzerkontos erforderlich',
	'config-profile-fishbowl' => 'ausschließlich berechtigte Bearbeiter',
	'config-profile-private' => 'geschlossenes Wiki',
	'config-profile-help' => "Wikis sind am nützlichsten, wenn so viele Menschen als möglich Bearbeitungen vornehmen können.
Mit MediaWiki ist es einfach die letzten Änderungen nachzuvollziehen und unbrauchbare Bearbeitungen, beispielsweise von unbedarften oder böswilligen Benutzern, rückgängig zu machen.

Allerdings finden etliche Menschen Wikis auch mit anderen Bearbeitungskonzepten sinnvoll. Manchmal ist es zudem nicht einfach alle Beteiligten von den Vorteilen des „Wiki-Prinzips” zu überzeugen. Darum ist diese Auswahl möglich.

Ein '''{{int:config-profile-wiki}}''' ermöglicht es jedermann, sogar ohne über ein Benutzerkonto zu verfügen, Bearbeitungen vorzunehmen.
Ein Wiki bei dem die '''{{int:config-profile-no-anon}}''' ist, fordert von den Benutzern eine höhere Verantwortung für ihre Bearbeitungen ein, könnte allerdings Personen abschrecken, die nur gelegentlich Bearbeitungen vornehmen wollen. Ein Wiki für '''{{int:config-profile-fishbowl}}''' gestattet es nur bestimmten Benutzern, Bearbeitungen vorzunehmen. Allerdings kann dabei die Allgemeinheit die Seiten immer noch betrachten und Änderungen nachvollziehen. Ein '''{{int:config-profile-private}}''' gestattet es nur ausgewählten Benutzern, Seiten zu betrachten sowie zu bearbeiten.

Komplexere Konzepte zur Zugriffssteuerung können erst nach abgeschlossenem Installationsvorgang eingerichtet werden. Hierzu gibt es weitere Informationen auf der Website mit der [//www.mediawiki.org/wiki/Manual:User_rights entsprechenden Anleitung].",
	'config-license' => 'Lizenz:',
	'config-license-none' => 'Keine Lizenzangabe in der Fußzeile',
	'config-license-cc-by-sa' => 'Creative Commons „Namensnennung, Weitergabe unter gleichen Bedingungen“',
	'config-license-cc-by' => 'Creative Commons „Namensnennung“',
	'config-license-cc-by-nc-sa' => 'Creative Commons „Namensnennung, nicht kommerziell, Weitergabe unter gleichen Bedingungen“',
	'config-license-cc-0' => 'Creative Commons „Zero“ (Gemeinfreiheit)',
	'config-license-gfdl' => 'GNU-Lizenz für freie Dokumentation 1.3 oder höher',
	'config-license-pd' => 'Gemeinfreiheit',
	'config-license-cc-choose' => 'Eine benutzerdefinierte Creative-Commons-Lizenz auswählen',
	'config-license-help' => 'Viele öffentliche Wikis publizieren alle Beiträge unter einer [http://freedomdefined.org/Definition/De freien Lizenz].
Dies trägt dazu bei ein Gefühl von Gemeinschaft zu schaffen und ermutigt zu längerfristiger Mitarbeit.
Dahingegen ist im Allgemeinen eine freie Lizenz auf geschlossenen Wikis nicht notwendig.

Sofern man Texte aus der Wikipedia verwenden möchte und umgekehrt, sollte die Creative Commons-Lizenz „Namensnennung, Weitergabe unter gleichen Bedingungen“ gewählt werden.

Die Wikipedia nutzte vormals die GNU-Lizenz für freie Dokumentation (GFDL).
Die GFDL ist eine gültige Lizenz, die allerdings schwer zu verstehen ist.
Es ist zudem schwierig gemäß dieser Lizenz lizenzierte Inhalten wiederzuverwenden.',
	'config-email-settings' => 'E-Mail-Einstellungen',
	'config-enable-email' => 'Ausgehende E-Mails ermöglichen',
	'config-enable-email-help' => 'Sofern die E-Mail-Funktionen genutzt werden sollen, müssen die entsprechenden [http://www.php.net/manual/en/mail.configuration.php PHP-E-Mail-Einstellungen] richtig konfiguriert werden.
Für den Fall, dass die E-Mail-Funktionen nicht benötigt werden, können sie hier deaktiviert werden.',
	'config-email-user' => 'E-Mail-Versand von Benutzer zu Benutzer aktivieren',
	'config-email-user-help' => 'Allen Benutzern ermöglichen, sich gegenseitig E-Mails zu schicken, sofern sie es in ihren Einstellungen aktiviert haben.',
	'config-email-usertalk' => 'Benachrichtigungen zu Änderungen an Benutzerdiskussionsseiten ermöglichen',
	'config-email-usertalk-help' => 'Ermöglicht es Benutzern, Benachrichtigungen zu Änderungen an ihren Benutzerdiskussionsseiten zu erhalten, sofern sie dies in ihren Einstellungen aktiviert haben.',
	'config-email-watchlist' => 'Benachrichtigungen zu Änderungen an Seiten auf der Beobachtungsliste ermöglichen',
	'config-email-watchlist-help' => 'Ermöglicht es Benutzern, Benachrichtigungen zu Änderungen an Seiten auf ihrer Beobachtungsliste zu erhalten, sofern sie dies in ihren Einstellungen aktiviert haben.',
	'config-email-auth' => 'E-Mail-Authentifizierung ermöglichen',
	'config-email-auth-help' => "Sofern diese Funktion aktiviert ist, müssen Benutzer ihre E-Mail-Adresse bestätigen, indem sie den Bestätigungslink nutzen, der ihnen immer dann zugesandt wird, wenn sie ihre E-Mail-Adresse angeben oder ändern.
Nur bestätigte E-Mail-Adressen können Nachrichten von anderen Benutzer oder Benachrichtigungsmitteilungen erhalten.
Die Aktivierung dieser Funktion wird bei offenen Wikis, mit Hinblick auf möglichen Missbrauch der E-Mailfunktionen, '''empfohlen'''.",
	'config-email-sender' => 'E-Mail-Adresse für Antworten:',
	'config-email-sender-help' => 'Bitte hier die E-Mail-Adresse angeben, die als Absenderadresse bei ausgehenden E-Mails eingesetzt werden soll.
Rücklaufende E-Mails werden an diese E-Mail-Adresse gesandt.
Bei viele E-Mail-Servern muss der Teil der E-Mail-Adresse mit der Domainangabe korrekt sein.',
	'config-upload-settings' => 'Hochladen von Bildern und Dateien',
	'config-upload-enable' => 'Das Hochladen von Dateien ermöglichen',
	'config-upload-help' => 'Das Hochladen von Dateien macht den Server für potentielle Sicherheitsprobleme anfällig.
Weitere Informationen hierzu können im [//www.mediawiki.org/wiki/Manual:Security Abschnitt Sicherheit] der Anleitung nachgelesen werden.

Um das Hochladen von Dateien zu ermöglichen, muss der Zugriff auf das Unterverzeichnis <code>./images</code> so geändert werden, das dieses für den Webserver beschreibbar ist.
Hernach kann diese Option aktiviert werden.',
	'config-upload-deleted' => 'Verzeichnis für gelöschte Dateien:',
	'config-upload-deleted-help' => 'Bitte ein Verzeichnis auswählen, in dem gelöschte Dateien archiviert werden sollen.
Idealerweise sollte es nicht über das Internet zugänglich sein.',
	'config-logo' => 'URL des Logos:',
	'config-logo-help' => 'Die Standardoberfläche von MediaWiki verfügt links oberhalb der Seitenleiste über Platz für eine Logo mit den Maßen 135x160 Pixel.
Bitte ein Logo in entsprechender Größe hochladen und die zugehörige URL an dieser Stelle angeben.

Sofern kein Logo benötigt wird, kann dieses Datenfeld leer bleiben.',
	'config-instantcommons' => '„InstantCommons“ aktivieren',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons InstantCommons] ist eine Funktion, die es Wikis ermöglicht, Bild-, Klang- und andere Mediendateien zu nutzen, die auf der Website [//commons.wikimedia.org/ Wikimedia Commons] verfügbar sind.
Um diese Funktion nutzen zu können, muss das Wiki über eine Verbindung zum Internet verfügen.

Weitere Informationen zu dieser Funktion, einschließlich der Anleitung, wie hierfür andere Wikis als Wikimedia Commons eingerichtet werden können, gibt es im [//mediawiki.org/wiki/Manual:$wgForeignFileRepos Handbuch].',
	'config-cc-error' => 'Der Creativ-Commons-Lizenzassistent konnte keine Lizenz ermitteln.
Die Lizenz ist daher jetzt manuell einzugeben.',
	'config-cc-again' => 'Erneut auswählen …',
	'config-cc-not-chosen' => 'Die gewünschte Creative-Commons-Lizenz auswählen und dann auf „weiter“ klicken.',
	'config-advanced-settings' => 'Erweiterte Konfiguration',
	'config-cache-options' => 'Einstellungen für die Zwischenspeicherung von Objekten:',
	'config-cache-help' => 'Das Objektcaching wird dazu genutzt die Geschwindigkeit von MediaWiki zu verbessern, indem häufig genutzte Daten zwischengespeichert werden.
Es wird sehr empfohlen es für mittelgroße bis große Wikis zu nutzen, aber auch für kleine Wikis ergeben sich erkennbare Geschwindigkeitsverbesserungen.',
	'config-cache-none' => 'Kein Objektcaching (es wird keine Funktion entfernt, allerdings kann dies die Geschwindigkeit größerer Wikis negativ beeinflussen)',
	'config-cache-accel' => 'Objektcaching von PHP (APC, XCache oder WinCache)',
	'config-cache-memcached' => 'Memchached Cacheserver nutzen (erfordert einen zusätzliche Installationsvorgang mitsamt Konfiguration)',
	'config-memcached-servers' => 'Memcached Cacheserver',
	'config-memcached-help' => 'Liste der für Memcached nutzbaren IP-Adressen.
Es sollte eine je Zeile mitsamt des vorgesehenen Ports angegeben werden. Beispiele:
127.0.0.1:11211 oder
192.168.1.25:1234 usw.',
	'config-memcache-needservers' => 'Memcached wurde als Cacheserver ausgewählt. Dabei wurde allerdings kein Server angegeben.',
	'config-memcache-badip' => 'Es wurde für Memcached eine ungültige IP-Adresse angegeben: $1',
	'config-memcache-noport' => 'Es wurde kein Port zur Nutzung durch den Memcached Cacheserver angegeben: $1
Sofern der Port unbekannt ist, ist 11211 die Standardangabe.',
	'config-memcache-badport' => 'Der Ports für den Memcached Cacheserver sollten zwischen $1 und $2 liegen',
	'config-extensions' => 'Erweiterungen',
	'config-extensions-help' => 'Die obig angegebenen Erweiterungen wurden im Verzeichnis <code>./extensions</code> gefunden.

Es könnten zusätzliche Konfigurierungen zu einzelnen Erweiterungen erforderlich sein, dennoch können sie aber bereits jetzt aktiviert werden.',
	'config-install-alreadydone' => "'''Warnung:''' Es wurde eine vorhandene MediaWiki-Installation gefunden.
Es muss daher mit den nächsten Seite weitergemacht werden.",
	'config-install-begin' => 'Durch Drücken von „{{int:config-continue}}“ wird die Installation von MediaWiki gestartet.
Sofern Änderungen vorgenommen werden sollen, kann man auf „← Zurück“ klicken.',
	'config-install-step-done' => 'erledigt',
	'config-install-step-failed' => 'gescheitert',
	'config-install-extensions' => 'Programmerweiterungen',
	'config-install-database' => 'Datenbank wird eingerichtet',
	'config-install-schema' => 'Datenschema wird erstellt',
	'config-install-pg-schema-not-exist' => 'Das PostgesSQL-Datenschema ist nicht vorhanden',
	'config-install-pg-schema-failed' => 'Das Erstellen der Datentabellen ist gescheitert.
Es muss sichergestellt sein, dass der Benutzer „$1“ Schreibzugriff auf das Datenschema „$2“ hat.',
	'config-install-pg-commit' => 'Änderungen anwenden',
	'config-install-pg-plpgsql' => 'Suche nach der Datenbanksprache PL/pgSQL',
	'config-pg-no-plpgsql' => 'Für Datenbank $1 muss die Datenbanksprache PL/pgSQL installiert werden',
	'config-pg-no-create-privs' => 'Das für die Installation angegeben Konto verfügt nicht über ausreichende Berechtigungen, um ein Datenbanknutzerkonto zu erstellen.',
	'config-pg-not-in-role' => 'Das für den Webbenutzer angegebene Benutzerkonto ist bereits vorhanden.
Das für den Installationsvorgang angegebene Benutzerkonto ist kein Superbenutzer und nicht Mitglied der Benutzergruppe der Webbenutzer, so dass keine dem Webbenutzer zugeordneten Datenobjekte erstellt werden können.

Für MediaWiki ist es momentan erforderlich, dass die Tabellen dem Webbenutzer rechtemäßig zugeordnet sind. Bitte einen anderen Namen für den Wikibenutzer angeben oder „← Zurück“ anklicken, um einen ausreichend berechtigten Benutzer für den Installationsvorgang anzugeben.',
	'config-install-user' => 'Datenbankbenutzer wird erstellt',
	'config-install-user-alreadyexists' => 'Datenbankbenutzer „$1“ ist bereits vorhanden',
	'config-install-user-create-failed' => 'Das Anlegen des Datenbankbenutzers „$1“ ist gescheitert: $2',
	'config-install-user-grant-failed' => 'Die Gewährung der Berechtigung für Datenbankbenutzer „$1“ ist gescheitert: $2',
	'config-install-user-missing' => 'Der angegebene Benutzer „$1“ ist nicht vorhanden.',
	'config-install-user-missing-create' => 'Der angegebene Benutzer „$1“ ist nicht vorhanden.
Bitte das Auswahlkästchen „Benutzerkonto erstellen“ anklicken, sofern dieser erstellt werden soll.',
	'config-install-tables' => 'Datentabellen werden erstellt',
	'config-install-tables-exist' => "'''Warnung:''' Es wurden MediaWiki-Datentabellen gefunden.
Die Erstellung wurde übersprungen.",
	'config-install-tables-failed' => "'''Fehler:''' Die Erstellung der Datentabellen ist aufgrund des folgenden Fehlers gescheitert: $1",
	'config-install-interwiki' => 'Interwikitabellen werden eingerichtet',
	'config-install-interwiki-list' => 'Die Datei <code>interwiki.list</code> konnte nicht gelesen werden.',
	'config-install-interwiki-exists' => "'''Warnung:'''  Es wurden Interwikitabellen mit Daten gefunden.
Die Standardliste wird übersprungen.",
	'config-install-stats' => 'Statistiken werden initialisiert',
	'config-install-keys' => 'Geheimschlüssel werden erstellt',
	'config-insecure-keys' => "'''Warnung:''' {{PLURAL:$2|Der Geheimschlüssel|Die Geheimschlüssel}} $1, {{PLURAL:$2|der|die}} während des Installationsvorgangs generiert {{PLURAL:$2|wurde, ist|wurden, sind}} nicht sehr sicher. {{PLURAL:$2|Er sollte|Sie sollten}} manuell geändert werden.",
	'config-install-sysop' => 'Administratorkonto wird erstellt',
	'config-install-subscribe-fail' => 'Abonnieren von „mediawiki-announce“ ist gescheitert: $1',
	'config-install-subscribe-notpossible' => 'cURL ist nicht installiert und allow_url_fopen ist nicht verfügbar.',
	'config-install-mainpage' => 'Erstellung der Hauptseite mit Standardinhalten',
	'config-install-extension-tables' => 'Erstellung der Tabellen für die aktivierten Erweiterungen',
	'config-install-mainpage-failed' => 'Die Hauptseite konnte nicht erstellt werden: $1',
	'config-install-done' => "'''Herzlichen Glückwunsch!'''
MediaWiki wurde erfolgreich installiert.

Das Installationsprogramm hat die Datei <code>LocalSettings.php</code> erzeugt.
Sie enthält alle vorgenommenen Konfigurationseinstellungen.

Diese Datei muss nun heruntergeladen und anschließend in das Stammverzeichnis der MediaWiki-Installation hochgeladen werden. Dies ist dasselbe Verzeichnis, in dem sich auch die Datei <code>index.php</code> befindet. Das Herunterladen sollte inzwischen automatisch gestartet worden sein.

Sofern dies nicht der Fall war, oder das Herunterladen unterbrochen wurde, kann der Vorgang durch einen Klick auf den folgenden Link erneut gestartet werden:

$3

'''Hinweis:''' Die Konfigurationsdatei sollte jetzt unbedingt heruntergeladen werden. Sie wird nach Beenden des Installationsprogramms, nicht mehr zur Verfügung stehen.

Sobald alles erledigt wurde, kann auf das '''[$2 Wiki zugegriffen werden]'''. Wir wünschen viel Spaß und Erfolg mit dem Wiki.",
	'config-download-localsettings' => 'LocalSettings.php herunterladen',
	'config-help' => 'Hilfe',
	'config-nofile' => 'Die Datei „$1“ konnte nicht gefunden werden. Wurde sie gelöscht?',
	'mainpagetext' => "'''MediaWiki wurde erfolgreich installiert.'''",
	'mainpagedocfooter' => 'Hilfe zur Benutzung und Konfiguration der Wiki-Software findest du im [//meta.wikimedia.org/wiki/Help:Contents Benutzerhandbuch].

== Starthilfen ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liste der Konfigurationsvariablen]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailingliste neuer MediaWiki-Versionen]',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author MichaelFrey
 */
$messages['de-formal'] = array(
	'mainpagedocfooter' => 'Hilfe zur Benutzung und Konfiguration der Wiki-Software finden Sie im [//meta.wikimedia.org/wiki/Help:Contents Benutzerhandbuch].

== Starthilfen ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liste der Konfigurationsvariablen]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailingliste neuer MediaWiki-Versionen]',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'config-your-language' => 'Zıwanê şıma:',
	'config-wiki-language' => 'Wiki zıwan:',
	'config-back' => '← Peyser',
	'config-continue' => 'Dewam ke',
	'config-page-language' => 'Zıwan',
	'config-page-welcome' => 'Şıma xeyr ameyê MediaWiki!',
	'config-page-dbconnect' => 'Database rê grêdey',
	'config-page-name' => 'Name',
	'config-page-options' => 'Weçinegi',
	'config-page-install' => 'Barine',
	'config-page-readme' => 'Mı bıwane',
	'config-restart' => 'E, fına dest pekê',
	'config-sidebar' => "* [//www.mediawiki.org MediaWiki keye]
* [//www.mediawiki.org/wiki/Help:Contents User's Şınasiye]
* [//www.mediawiki.org/wiki/Manual:Contents Xizmetkara şınasiye]
* [//www.mediawiki.org/wiki/Manual:FAQ Peşti]
----
* <doclink href=Readme>Mı buwanê</doclink>
* <doclink href=ReleaseNotes>Notê elekeyıni</doclink>
* <doclink href=Copying>Telifiye</doclink>
* <doclink href=UpgradeDoc>Weşkerdış</doclink>",
	'config-env-php' => 'PHP $1 i biyo saz.',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 dılet',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-db-port' => 'Portê database:',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-header-mysql' => 'Sazkardışê MySQL',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-binary' => 'Dılet',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Namey wiki:',
	'config-ns-generic' => 'Proce',
	'config-ns-other' => 'Zewbi (keyfiyo)',
	'config-ns-other-default' => 'MyWiki',
	'config-admin-box' => 'Hesabê Administratori',
	'config-admin-name' => 'Namey şıma:',
	'config-admin-password' => 'Parola:',
	'config-admin-password-confirm' => 'Fına parola:',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-pd' => 'Malê Şari',
	'config-extensions' => 'Olekeni',
	'mainpagetext' => "'''MediaWiki vıst ra ser, vıraziya.'''",
	'mainpagedocfooter' => 'Seba gurenayış u eyarkerdışê Wiki-Softwarey [//meta.wikimedia.org/wiki/Help:Contents İdarê karberi] de mıracaet ke.

== Yardımê Sıftekerdışi ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista eyaranê vıraştışi]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki de ÇZP]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki ra lista serbest-dayışê postey]',
);

/** Lower Sorbian (dolnoserbski)
 */
$messages['dsb'] = array(
	'mainpagetext' => "'''MediaWiki jo se wuspěšnje instalěrowało.'''",
	'mainpagedocfooter' => "Pomoc pśi wužywanju softwary wiki namakajoš pód [//meta.wikimedia.org/wiki/Help:Contents User's Guide].

== Na zachopjenje ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Konfiguracija lisćiny połoženjow]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ (pšašanja a wótegrona)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lisćina e-mailowych nakładow MediaWiki]",
);

/** Central Dusun (Dusun Bundu-liwan)
 * @author FRANELYA
 */
$messages['dtp'] = array(
	'mainpagetext' => "'''Nopongo no do popodokot ot ModiaWiki.'''",
	'mainpagedocfooter' => 'Rujuko hilo [//meta.wikimedia.org/wiki/Help:Contents Ponudukan Momomoguno] kokomoi koilaan do momoguno posusuang-suangon wiki.

== Kopotimpuunan ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lis papatantu nuludan]
* [//www.mediawiki.org/wiki/Manual:FAQ Ponguhatan Koinsoruan om Simbar ModiaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lis pininsuratan pinolabus do ModiaWiki]',
);

/** Greek (Ελληνικά)
 */
$messages['el'] = array(
	'mainpagetext' => "'''To λογισμικό MediaWiki εγκαταστάθηκε με επιτυχία.'''",
	'mainpagedocfooter' => 'Περισσότερες πληροφορίες σχετικά με τη χρήση και με τη ρύθμιση παραμέτρων θα βρείτε στους συνδέσμους: [//meta.wikimedia.org/wiki/MediaWiki_localisation Οδηγίες για τροποποίηση του περιβάλλοντος εργασίας] και [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide Εγχειρίδιο χρήστη].',
);

/** Esperanto (Esperanto)
 * @author Airon90
 * @author Yekrats
 */
$messages['eo'] = array(
	'config-your-language' => 'Via lingvo:',
	'config-your-language-help' => 'Elekti lingvon uzi dum la instalada procezo.',
	'config-wiki-language' => 'Lingvo de la vikio:',
	'config-wiki-language-help' => 'Elekti la ĉefe skribotan lingvon de la vikio.',
	'config-page-welcome' => 'Bonvenon al MediaWiki!',
	'config-page-dbsettings' => 'Agordoj de la datumbazo',
	'config-page-name' => 'Nomo',
	'config-page-options' => 'Agordoj',
	'config-page-install' => 'Instali',
	'config-page-complete' => 'Farita!',
	'mainpagetext' => "'''MediaWiki estis sukcese instalita.'''",
	'mainpagedocfooter' => "Konsultu la [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide User's Guide] por informo pri uzado de vikia programaro.

==Kiel komenci==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listo de konfiguraĵoj] (angla)
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki Oftaj Demandoj] (angla)
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki dissendolisto pri anoncoj] (angla)",
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Danke7
 * @author Locos epraix
 * @author Od1n
 * @author Platonides
 * @author Sanbec
 * @author Translationista
 * @author Vivaelcelta
 */
$messages['es'] = array(
	'config-desc' => 'El instalador para MediaWiki',
	'config-title' => 'MediaWiki $1 instalación',
	'config-information' => 'Información',
	'config-localsettings-upgrade' => 'Se ha encontrado un archivo <code>LocalSettings.php</code>.
Para actualizar esta instalación, por favor ingresa el valor de <code>$wgUpgradeKey</code> en el cuadro de abajo.
Lo encontrarás en LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Se ha detectado un archivo LocalSettings.php.
Para actualizar la instalación, vuelva a ejecutar update.php',
	'config-localsettings-key' => 'Clave de actualización:',
	'config-localsettings-badkey' => 'La clave proporcionada es incorrecta.',
	'config-upgrade-key-missing' => 'Se ha detectado una instalación existente de MediaWiki.
Para actualizar la instalación, por favor, ponga la siguiente línea al final de su archivo LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'El archivo LocalSettings.php existente parece estar incompleto.
La variable $1 no está definida.
Cambie el archivo LocalSettings.php para que esta variable quede establecida y haga clic en "Continuar".',
	'config-localsettings-connection-error' => 'Se detectó un error al conectarse a la base de datos utilizando la configuración especificada en los archivos LocalSettings.php o AdminSettings.php. Corrija estas opciones y vuelva a intentarlo.

$1',
	'config-session-error' => 'Error comenzando sesión: $1',
	'config-session-expired' => 'Tus datos de sesión parecen haber expirado.
Las sesiones están configuradas por una duración de $1.
Puedes incrementar esto configurando <code>session.gc_maxlifetime</code> en php.ini.
Reiniciar el proceso de instalación.',
	'config-no-session' => 'Se han perdido los datos de sesión.
Verifica tu php.ini y comprueba que <code>session.save_path</code> está establecido en un directorio apropiado.',
	'config-your-language' => 'Tu idioma:',
	'config-your-language-help' => 'Seleccionar un idioma a usar durante el proceso de instalación.',
	'config-wiki-language' => 'Idioma del wiki:',
	'config-wiki-language-help' => 'Seleccionar el idioma en el que el wiki será escrito predominantemente.',
	'config-back' => '← Atrás',
	'config-continue' => 'Continuar →',
	'config-page-language' => 'Idioma',
	'config-page-welcome' => 'Bienvenido a MediaWiki!',
	'config-page-dbconnect' => 'Conectar a la base de datos',
	'config-page-upgrade' => 'Actualizar instalación existente',
	'config-page-dbsettings' => 'Configuración de la base de datos',
	'config-page-name' => 'Nombre',
	'config-page-options' => 'Opciones',
	'config-page-install' => 'Instalar',
	'config-page-complete' => 'Completo!',
	'config-page-restart' => 'Reiniciar instalación',
	'config-page-readme' => 'Léeme',
	'config-page-releasenotes' => 'Notas de la versión',
	'config-page-copying' => 'Copiando',
	'config-page-upgradedoc' => 'Actualizando',
	'config-page-existingwiki' => 'Wiki existente',
	'config-help-restart' => '¿Deseas borrar todos los datos que has ingresado hasta ahora y reiniciar el proceso de instalación desde el principio?',
	'config-restart' => 'Sí, reiniciarlo',
	'config-welcome' => '=== Comprobación del entorno ===
Se realiza comprobaciones básicas para ver si el entorno es adecuado para la instalación de MediaWiki.
Deberás suministrar los resultados de tales comprobaciones si necesitas ayuda durante la instalación.',
	'config-copyright' => "=== Derechos de autor y Términos de uso ===

$1

Este programa es software libre; puedes redistribuirlo y/o modificarlo en los términos de la Licencia Pública General de GNU, tal como aparece publicada por la Fundación para el Software Libre, tanto la versión 2 de la Licencia, como cualquier versión posterior (según prefiera).

Este programa es distribuido en la esperanza de que sea útil, pero '''sin cualquier garantía'''; inclusive, sin la garantía implícita de la '''posibilidad de ser comercializado''' o de '''idoneidad para cualquier finalidad específica'''.
Consulte la licencia *GNU General *Public *License para más detalles.

En conjunto con este programa debe haber recibido <doclink href=Copying>una copia de la Licencia Pública General de GNU</doclink>; si no la recibió, pídala por escrito a Fundación para el Software Libre, Inc., 51 Franklin Street, Fifth Floor, Boston, ME La 02110-1301, USA o [http://www.gnu.org/copyleft/gpl.html léala en internet].",
	'config-sidebar' => '* [//www.mediawiki.org Página principal de MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Guía del usuario]
* [//www.mediawiki.org/wiki/Manual:Contents Guía del administrador]
* [//www.mediawiki.org/wiki/Manual:FAQ Preguntas frecuentes]
----
* <doclink href=Readme>Léeme</doclink>
* <doclink href=ReleaseNotes>Notas de la versión</doclink>
* <doclink href=Copying>Copia</doclink>
* <doclink href=UpgradeDoc>Actualización</doclink>',
	'config-env-good' => 'El entorno ha sido comprobado.
Puedes instalar MediaWiki.',
	'config-env-bad' => 'El entorno ha sido comprobado.
No puedes instalar MediaWiki.',
	'config-env-php' => 'PHP $1 está instalado.',
	'config-env-php-toolow' => 'PHP $1 está instalado.
Sin embargo, MediaWiki requiere PHP $2 o superior.',
	'config-unicode-using-utf8' => 'Usando utf8_normalize.so de Brion Vibber para la normalización Unicode.',
	'config-unicode-using-intl' => 'Usando la [http://pecl.php.net/intl extensión intl PECL] para la normalización Unicode.',
	'config-unicode-pure-php-warning' => "'''Advertencia''': La [http://pecl.php.net/intl extensión intl] no está disponible para efectuar la normalización Unicode. Utilizando la implementación más lenta en PHP.
Si tu web tiene mucho tráfico, te recomendamos leer acerca de la [//www.mediawiki.org/wiki/Unicode_normalization_considerations normalización Unicode].",
	'config-unicode-update-warning' => "'''Warning''': La versión instalada del contenedor de normalización Unicode usa una versión anterior de la biblioteca del [http://site.icu-project.org/ proyecto ICU].
Deberás [//www.mediawiki.org/wiki/Unicode_normalization_considerations actualizar] si realmente deseas usar Unicode.",
	'config-no-db' => 'No fue posible encontrar un controlador adecuado para la base de datos! Necesitas instalar un controlador de base de datos para PHP.
Las siguientes bases de datos son soportadas: $1.
Si estás en alojamiento compartido, pregunta a tu proveedor el instalar un controlador de base de datos adecuado.
Si estás compilando PHP por ti mismo, reconfigúralo con un cliente de base de datos disponible, por ejemplo usando <code>./configure --with-mysql</code>.
Si instalaste PHP de un paquete Debian o Ubuntu, entonces también necesitas instalar el módulo php5-mysql.',
	'config-outdated-sqlite' => "''' Advertencia ''': tiene la versión SQLite $1, que es inferior a la mínima versión requerida: $2 . SQLite no estará disponible.",
	'config-no-fts3' => "'''Advertencia''': SQLite está compilado sin el [//sqlite.org/fts3.html módulo FTS3]. Las funcionalidades de búsqueda no estarán disponibles en esta instalación.",
	'config-register-globals' => "'''Advertencia: La opción de <code>[http://php.net/register_globals register_globals]</code> de PHP está habilitada.'''
'''Desactívela si puede.'''
MediaWiki funcionará, pero tu servidor quedará expuesto a vulnerabilidades de seguridad potenciales.",
	'config-magic-quotes-runtime' => "'''Fatal: ¡[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] está activada!'''
Esta opción causa la imprevisible corrupción de la entrada de datos.
No puedes instalar o utilizar MediaWiki a menos que esta opción esté inhabilitada.",
	'config-magic-quotes-sybase' => "'''Fatal: ¡[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] está activada!'''
Esta opción causa la imprevisible corrupción de la entrada de datos.
No puedes instalar o utilizar MediaWiki a menos que esta opción esté inhabilitada.",
	'config-mbstring' => "'''Fatal: La opción [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] está activada!'''
Esta opción causa errores y puede corromper los datos de una forma imprevisible.
No se puede instalar o usar MediaWiki a menos que esta opción sea desactivada.",
	'config-ze1' => "'''Fatal: ¡La opción [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] está activada!'''
Esta opción causa problemas significativos en MediaWiki.
No se puede instalar o usar MediaWiki a menos que esta opción sea desactivada.",
	'config-safe-mode' => "'''Advertencia:''' El [http://www.php.net/features.safe-mode modo seguro] de PHP está activado.
Este modo puede causar problemas, especialmente en la carga de archivosy en compatibilidad con <code>math</code>.",
	'config-xml-bad' => 'Falta el módulo XML de PHP.
MediaWiki necesita funciones en este módulo y no funcionará con esta configuración.
Si está ejecutando Mandrake, instale el paquete php-xml.',
	'config-pcre' => 'Parece faltar el módulo de compatibilidad PCRE.
MediaWiki necesita que las funciones de expresiones regulares compatibles con Perl estén funcionando.',
	'config-pcre-no-utf8' => "'''Error fatal ''': Parece que el módulo PCRE de PHP fue compilado sin el soporte PCRE_UTF8.
MediaWiki requiere compatibilidad con UTF-8 para funcionar correctamente.",
	'config-memory-raised' => 'el parámetro <code>memory_limit</code> de PHP es $1, aumentada a $2.',
	'config-memory-bad' => "'''Advertencia:''' El parámetro <code>memory_limit</code> de PHP es $1.
Probablemente este valor es demasiado bajo.
¡La instalación podrá fallar!",
	'config-ctype' => "'''Fatal''': PHP debe ser compilado con soporte para la [http://www.php.net/manual/en/ctype.installation.php extensión Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] está instalado',
	'config-apc' => '[http://www.php.net/apc APC] está instalado',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] está instalado',
	'config-no-cache' => "'''Advertencia:''' No pudo encontrarse [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] o [http://www.iis.net/download/WinCacheForPhp WinCache].
El caché de objetos no está habilitado.",
	'config-mod-security' => "''' Advertencia ''': Su servidor web tiene [http://modsecurity.org/ mod_security] habilitado. Si la configuración es incorrecta, puede causar problemas a MediaWiki u otro software que permita a los usuarios publicar contenido arbitrarios.
Consulte la [http://modsecurity.org/documentation/ documentación de mod_security] o contacte con el soporte de su servidor (''host'') si encuentra errores aleatorios.",
	'config-diff3-bad' => 'GNU diff3 no se encuentra.',
	'config-imagemagick' => 'ImageMagick encontrado: <code>$1</code>.
La miniaturización de imágenes se habilitará si habilitas las cargas.',
	'config-gd' => 'Se ha encontrado una biblioteca de gráficos GD integrada.
La miniaturización de imágenes se habilitará si habilitas las subidas.',
	'config-no-scaling' => 'No se ha encontrado ninguma biblioteca GD o ImageMagik.
Se inhabilitará la miniaturización de imágenes.',
	'config-no-uri' => "'''Error:''' No se pudo determinar el URI actual.
Instalación abortada.",
	'config-no-cli-uri' => "''' Advertencia ''': No se ha especificado ningún --scriptpath, por defecto, se usará: <code>$1</code> .",
	'config-using-server' => 'Utilizando el nombre de servidor "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Utilizando la dirección URL del servidor "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''Atención:''' Su directorio por defecto para las cargas, <code>$1</code>, es vulnerable a la ejecución de scripts arbitrarios.
Aunque MediaWiki comprueba todos los archivos cargados por si hubiese amenazas de seguridad, es altamente recomendable [//www.mediawiki.org/wiki/Manual:Security#Upload_security cerrar esta vulnerabilidad de seguridad] antes de activar las cargas.",
	'config-no-cli-uploads-check' => "'''Atención:''' Su directorio predeterminado para cargas (<code>$1</code>) no está comprobado para la vulnerabilidad
 de ejecución arbitraria de comandos script durante la instalación de CLI.",
	'config-brokenlibxml' => 'El sistema tiene una combinación de versiones de PHP y de libxml2 que puede ser problemática y puede causar daños en datos ocultos de MediaWiki y otras aplicaciones web
Actualizar a PHP 5.2.9 o posterior y a libxml2 2.7.3 o posterior ([//bugs.php.net/bug.php?id=45996 bug presentado con PHP]).
Instalación anulada.',
	'config-using531' => 'MediaWiki no puede utilizarse con PHP $1 debido a un error con los parámetros de referencia para <code>__call()</code> .
Actualice el sistema a PHP 5.3.2 o superior, o vuelva a la versión PHP 5.3.0 para resolver este problema.
Instalación anulada.',
	'config-suhosin-max-value-length' => 'Suhosin está instalado y limita la longitud del parámetro GET a $1 bytes. El componente ResourceLoader de MediaWiki trabajará en este límite, pero eso degradará el rendimiento. Si es posible, debe establecer el valor de suhosin.get.max_value_length en 1024 o superior en el archivo php.ini y establecer $wgResourceLoaderMaxQueryLength en el mismo valor en LocalSettings.php.',
	'config-db-type' => 'Tipo de base de datos',
	'config-db-host' => 'Servidor de la base de datos:',
	'config-db-host-help' => 'Si su servidor de base de datos está en otro servidor, escriba el nombre del host o su dirección IP aquí.
Si está utilizando alojamiento web compartido, su proveedor de alojamiento debería darle el nombre correcto del servidor de alojamiento (host) en su documentación.
Si va a instalarlo en un servidor Windows y utiliza MySQL, el uso de "localhost" como nombre del servidor puede no funcionar. Si no es así, intente poner "127.0.0.1" como dirección IP local.
Si utiliza PostgreSQL, deje este campo en blanco para conectarse a través de un socket de Unix.',
	'config-db-host-oracle' => 'TNS de la base de datos:',
	'config-db-host-oracle-help' => 'Introduzca un [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm nombre de conexión local] válido; un archivo tnsnames.ora debe ser visible para esta instalación.<br />Si está utilizando bibliotecas de cliente 10g o más recientes también puede utilizar el método de asignación de nombres [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identifique este wiki',
	'config-db-name' => 'Nombre de base de datos:',
	'config-db-name-help' => 'Elija un nombre que identifique su wiki.
No debe contener espacios.

Si está utilizando alojamiento web compartido, su proveedor de alojamiento le dará un nombre específico de base de datos para que lo utilice, o bien le permitirá crear bases de datos a través de un panel de control.',
	'config-db-name-oracle' => 'Esquema de base de datos:',
	'config-db-account-oracle-warn' => 'Hay tres escenarios compatibles para la instalación de Oracle como base de datos back-end:

Si desea crear una cuenta de base de datos como parte del proceso de instalación, por favor suministre una cuenta con función SYSDBA como cuenta de base de datos para la instalación y especifique las credenciales deseadas de la cuenta de acceso al web, de lo contrario puede crear manualmente la cuenta de acceso al web y suministrar sólo esa cuenta (si tiene los permisos necesarios para crear los objetos de esquema) o suministrar dos cuentas diferentes, una con privilegios de creación y otra con acceso restringido a la web

La secuencia de comandos (script) para crear una cuenta con los privilegios necesarios puede encontrarse en el directorio "maintenance/oracle/" de esta instalación. Tenga en cuenta que utilizando una cuenta restringida desactivará todas las capacidades de mantenimiento con la cuenta predeterminada.',
	'config-db-install-account' => 'Cuenta de usuario para instalación',
	'config-db-username' => 'Nombre de usuario de base de datos:',
	'config-db-password' => 'contraseña de base de datos:',
	'config-db-password-empty' => 'Introduzca una contraseña para el nuevo usuario de base de datos:  $1.
Aunque es posible crear usuarios sin contraseña, esto no es seguro.',
	'config-db-install-username' => 'Introduzca el nombre de usuario que se utilizará para conectarse a la base de datos durante el proceso de instalación.
Este no es el nombre de usuario de la cuenta de MediaWiki; Este es el nombre de usuario para la base de datos.',
	'config-db-install-password' => 'Introduzca la contraseña que se utilizará para conectarse a la base de datos durante el proceso de instalación.
Esta no es la contraseña para la cuenta de MediaWiki; esta es la contraseña para la base de datos.',
	'config-db-install-help' => 'Ingresar el nombre de usuario y la contraseña que será usada para conectar a la base de datos durante el proceso de instalación.',
	'config-db-account-lock' => 'Usar el mismo nombre de usuario y contraseña durante operación normal',
	'config-db-wiki-account' => 'Usar cuenta para operación normal',
	'config-db-wiki-help' => 'Introduce el nombre de usuario y la contraseña que serán usados para acceder a la base de datos durante la operación normal del wiki.
Si esta cuenta no existe y la cuenta de instalación tiene suficientes privilegios, se creará esta cuenta de usuario con los privilegios mínimos necesarios para la operación normal del wiki.',
	'config-db-prefix' => 'Prefijo para las tablas de la base de datos:',
	'config-db-prefix-help' => 'Si necesita compartir una base de datos entre múltiples wikis, o entre MediaWiki y otra aplicación web, puede optar por agregar un prefijo a todos los nombres de tabla para evitar conflictos.
No utilice espacios.

Normalmente se deja este campo vacío.',
	'config-db-charset' => 'Conjunto de caracteres de la base de datos',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binario',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 retrocompatible UTF-8',
	'config-charset-help' => "'''Atención:''' Si emplea '''backwards-compatible UTF-8''' en MySQL 4.1+ y posteriormente hace copia de seguridad de la base de datos con <code>mysqldump</code> , puede destruir todos los caracteres no-ASCII, ¡dañando irreversiblemente sus copias de seguridad!

En '''modo binario''', MediaWiki almacena texto UTF-8 en la base de datos en campos binarios.
Esto es más eficiente que el modo UTF-8 de MySQL, y le permite utilizar la gama completa de caracteres Unicode.
En ''' modo UTF-8'' ', MySQL sabrá el juego de caracteres de sus datos y puede presentarlos y convertirlos apropiadamente,
pero no le permitirá almacenar caracteres por encima del [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plano multilingüe básico].",
	'config-mysql-old' => 'Se necesita MySQL $1 o una versión más reciente. Tienes la versión $2.',
	'config-db-port' => 'Puerto de la base de datos:',
	'config-db-schema' => 'Esquema para MediaWiki',
	'config-db-schema-help' => 'Estos esquemas usualmente estarán bien.
Altéralos sólo si tienes la seguridad de que necesitas hacerlo.',
	'config-pg-test-error' => "No se puede conectar a la base de datos '''$1''': $2",
	'config-sqlite-dir' => 'Directorio de datos SQLite:',
	'config-sqlite-dir-help' => "SQLite almacena todos los datos en un único archivo.

El directorio que proporcione debe ser escribible por el servidor Web durante la instalación.

'''No''' debería ser accesible a través de Internet, por eso no vamos a ponerlo en el sitio donde están los archivos PHP.

El instalador escribirá un archivo <code>.htaccess</code> junto con él, pero si falla alguien podría tener acceso a la base de datos en bloque.
Eso incluye los datos de usuario en bloque (direcciones de correo electrónico, las contraseñas con hash) así como revisiones eliminadas y otros datos restringidos del wiki.

Considere la posibilidad de poner la base de datos en algún otro sitio, por ejemplo en <code>/var/lib/mediawiki/yourwiki</code> .",
	'config-oracle-def-ts' => 'Espacio de tablas por defecto:',
	'config-oracle-temp-ts' => 'Espacio de tablas temporal:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki es compatible con los siguientes sistemas de bases de datos:

$1

Si no encuentras en el listado el sistema de base de datos que estás intentando utilizar, sigue las instrucciones vinculadas arriba para habilitar la compatibilidad.',
	'config-support-mysql' => '* $1 es la base de datos mayoritaria para MediaWiki y la que goza de mayor compatibilidad ([http://www.php.net/manual/es/mysql.installation.php cómo compilar PHP con compatibilidad MySQL])',
	'config-support-postgres' => '$1 es un popular sistema de base de datos de código abierto, alternativa a MySQL. ([http://www.php.net/manual/es/pgsql.installation.php cómo compilar PHP con compatibilidad PostgreSQL]). Puede haber algunos defectos menores destacables, y no es recomendable para uso en un entorno de producción.',
	'config-support-sqlite' => '* $1 es una base de datos ligera con gran compatibilidad con MediaWiki. ([http://www.php.net/manual/es/pdo.installation.php Cómo compilar PHP con compatibilidad SQLite], usa PDO)',
	'config-support-oracle' => '* $1 es una base de datos comercial a nivel empresarial ([http://www.php.net/manual/es/oci8.installation.php cómo compilar PHP con compatibilidad con OCI8])',
	'config-support-ibm_db2' => ' $1  es una base de datos de empresa comercial.',
	'config-header-mysql' => 'Configuración de MySQL',
	'config-header-postgres' => 'Configuración de PostgreSQL',
	'config-header-sqlite' => 'Configuración de SQLite',
	'config-header-oracle' => 'Configuración de Oracle',
	'config-header-ibm_db2' => 'Configuración de IBM DB2',
	'config-invalid-db-type' => 'Tipo de base de datos inválida',
	'config-missing-db-name' => 'Debes introducir un valor para "Nombre de la base de datos"',
	'config-missing-db-host' => 'Debe introducir un valor para "Servidor (host) de base de datos"',
	'config-missing-db-server-oracle' => 'Debe introducir un valor para "TNS de la base de datos"',
	'config-invalid-db-server-oracle' => 'El TNS de la base de datos, "$1", es inválido.Use sólo carateres ASCII: letras (a-z, A-Z), números (0-9), guiones bajos (_) y guiones (-).Usa sólo caracteres ASCII: letras (a-z, A-Z), dígitos (0-9), guiones bajos (_) y puntos (.).',
	'config-invalid-db-name' => 'El nombre de la base de datos "$1"  es inválido.
Usa sólo caracteres ASCII: letras (a-z, A-Z), números (0-9), guiones bajos (_)y guiones (-).',
	'config-invalid-db-prefix' => 'El prefijo de la base de datos "$1"  es inválido.
Use sólo carateres ASCII: letras (a-z, A-Z), números (0-9), guiones bajos (_) y guiones (-).',
	'config-connection-error' => '$1.

Verifique el servidor, el nombre de usuario y la contraseña, e intente de nuevo.',
	'config-invalid-schema' => 'El esquema de la base de datos "$1"  es inválido.
Use sólo carateres ASCII: letras (a-z, A-Z), guarismos (0-9) y guiones bajos (_).',
	'config-db-sys-create-oracle' => 'El instalador sólo admite el empleo de cuentas SYSDBA como método para crear una cuenta nueva.',
	'config-db-sys-user-exists-oracle' => 'La cuenta de usuario "$1" ya existe. ¡SYSDBA sólo puede utilizarse para crear una nueva cuenta!',
	'config-postgres-old' => 'Se necesita PostgreSQL $1 o una versión más reciente; tienes la versión $2.',
	'config-sqlite-name-help' => 'Elige el nombre que identificará tu wiki.
No uses espacios o guiones.
Este nombre será usado como nombre del archivo de datos de SQLite.',
	'config-sqlite-parent-unwritable-group' => 'No se puede crear el directorio de datos <code><nowiki>$1</nowiki></code> , porque el directorio padre <code><nowiki>$2</nowiki></code> no es accesible en escritura por el servidor Web.

El instalador ha determinado el usuario cuyo servidor Web se está ejecutando.
Conceda permisos de escritura en el directorio <code><nowiki>$3</nowiki></code> para continuar.
En un sistema Unix/Linux haga:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'No se puede crear el directorio de datos <code><nowiki>$1</nowiki></code> , porque el directorio padre <code><nowiki>$2</nowiki></code> no es accesible en escritura por el servidor Web.

El programa de instalación no pudo determinar el usuario que se ejecuta en el servidor Web
Conceda permisos de escritura en el directorio <code><nowiki>$3</nowiki></code> para continuar.
En un sistema Unix/Linux haga:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Error al crear el directorio de datos "$1".
Comprueba la ubicación e inténtalo de nuevo.',
	'config-sqlite-dir-unwritable' => 'No se puede escribir en el directorio "$1".
Modifica los permisos para que el servidor web pueda escribir en él y vuelve a intentarlo.',
	'config-sqlite-connection-error' => '$1.

Verifique el directório de datos y el nombre de la base de datos mostrada a continuación e inténtalo nuevamente.',
	'config-sqlite-readonly' => 'El archivo <code>$1</code> no se puede escribir.',
	'config-sqlite-cant-create-db' => 'No fue posible crear el archivo de la base de datos <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'El PHP no tiene compatibilidad FTS3. actualizando tablas a una versión anterior',
	'config-can-upgrade' => "Esta base de datos contiene tablas de MediaWiki.
Para actualizarlas a MediaWiki $1, haz clic en '''Continuar'''.",
	'config-upgrade-done' => "Actualización completa.

Usted puede ahora [ $1  empezar a usar su wiki].

Si desea regenerar su archivo <code>LocalSettings.php</code> de archivo, haga clic en el botón de abajo.
Esto '''no se recomienda''' a menos que esté teniendo problemas con su wiki.",
	'config-upgrade-done-no-regenerate' => 'Actualización completa.

Usted puede ahora [$1  empezar a usar su wiki].',
	'config-regenerate' => 'Regenerar LocalSettings.php →',
	'config-show-table-status' => 'SHOW TABLE STATUS ha fallado!',
	'config-unknown-collation' => "'''Advertencia:''' La base de datos está utilizando una intercalación no reconocida.",
	'config-db-web-account' => 'Cuenta de base de datos para acceso Web',
	'config-db-web-help' => 'Elige el usuario y contraseña que el servidor Web usará para conectarse al servidor de la base de datos durante el fincionamiento normal del wiki.',
	'config-db-web-account-same' => 'Utilizar la misma cuenta que en la instalación',
	'config-db-web-create' => 'Crear la cuenta si no existe',
	'config-db-web-no-create-privs' => 'La cuenta que has especificado para la instalación no tiene privilegios suficientes para crear una cuenta.
La cuenta que especifiques aquí debe existir.',
	'config-mysql-engine' => 'Motor de almacenamiento:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Atención''': Ha seleccionado MyISAM como motor de almacenamiento de MySQL, el cual no está recomendado para su uso con MediaWiki, porque:
 * apenas soporta accesos simultáneos debido al bloqueo de tablas
 * es más propenso a la corrupción que otros motores
 * el código MediaWiki no siempre controla MyISAM como debiera

Si su instalación de MySQL soporta InnoDB, es muy recomendable que lo elija en su lugar.
Si la instalación de MySQL no admite InnoDB, quizás es el momento de una actualización.",
	'config-mysql-engine-help' => "'''InnoDB''' es casi siempre la mejor opción, dado que soporta bien los accesos simultáneos.

'''MyISAM''' es más rápido en instalaciones de usuario único o de sólo lectura.
Las bases de datos MyISAM tienden a corromperse más a menudo que las bases de datos InnoDB.",
	'config-mysql-charset' => 'Conjunto de caracteres de la base de datos:',
	'config-mysql-binary' => 'Binario',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "En '''modo binario''', MediaWiki almacena texto UTF-8 para la base de datos en campos binarios.
Esto es más eficiente que el modo UTF-8 de MySQL y le permite utilizar la gama completa de caracteres Unicode.

En '''modo UTF-8''', MySQL sabrá qué conjunto de caracteres emplean sus datos y puede presentarlos y convertirlos adecuadamente, pero no le permitirá almacenar caracteres por encima del [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plano multilingüe básico].",
	'config-ibm_db2-low-db-pagesize' => "Su base de datos DB2 tiene un espacio de tablas por defecto con un tamaño de página insuficiente. El tamaño de página tiene que ser '''32 K''' o superior.",
	'config-site-name' => 'Nombre del wiki:',
	'config-site-name-help' => 'Esto aparecerá en la barra de título del navegador y en varios otros lugares.',
	'config-site-name-blank' => 'Ingresar un nombre de sitio.',
	'config-project-namespace' => 'Espacio de nombre de proyecto:',
	'config-ns-generic' => 'Proyecto',
	'config-ns-site-name' => 'Igual como el nombre del wiki: $1',
	'config-ns-other' => 'Otro (especificar)',
	'config-ns-other-default' => 'MiWiki',
	'config-project-namespace-help' => 'Siguiendo el ejemplo de  Wikipedia, muchos wikis mantienen sus páginas de políticas separadas de sus páginas de contenido, en un "\'\'\'espacio de nombres del proyecto\'\'\'".

Todos los títulos de página en este espacio de nombres comienzan con un determinado prefijo, que usted puede especificar aquí.
Tradicionalmente, este prefijo se deriva del nombre del wiki, pero no puede contener caracteres de puntuación como "#" o ":".',
	'config-ns-invalid' => 'El espacio de nombre especificado "<nowiki>$1</nowiki>" no es válido.
Especifica un espacio de nombre de proyecto diferente.',
	'config-ns-conflict' => 'El espacio de nombres especificado "<nowiki>$1</nowiki>" entra en conflicto con un espacio de nombres predeterminado de MediaWiki.
Especifique un espacio de nombres de proyecto diferente.',
	'config-admin-box' => 'Cuenta de administrador',
	'config-admin-name' => 'Su nombre:',
	'config-admin-password' => 'Contraseña:',
	'config-admin-password-confirm' => 'Repita la contraseña:',
	'config-admin-help' => 'Escribe aquí el nombre de usuario que desees, como por ejemplo "Pedro Bloggs".
Este es el nombre que usarás para entrar al wiki.',
	'config-admin-name-blank' => 'Introduce un nombre de usuario de administrador.',
	'config-admin-name-invalid' => 'El nombre de usuario especificado "<nowiki>$1</nowiki>" no es válido.
Especifique un nombre de usuario diferente.',
	'config-admin-password-blank' => 'Introduzca una contraseña para la cuenta de administrador.',
	'config-admin-password-same' => 'La contraseña no debe ser la misma que el nombre de usuario.',
	'config-admin-password-mismatch' => 'Las dos contraseñas que ingresaste no coinciden.',
	'config-admin-email' => 'Dirección de correo electrónico:',
	'config-admin-email-help' => 'Introduce aquí un correo electrónico que te permita recibir mensajes de otros usuarios del wiki, vuelve a configurar tu contraseña y recibe notificaciones de cambios realizados a tus páginas vigiladas. Puedes dejar este campo vacío.',
	'config-admin-error-user' => 'Error interno al crear un administrador con el nombre "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Error interno al establecer una contraseña para el administrador " <nowiki>$1</nowiki> ": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Ha introducido una dirección de correo electrónico inválida.',
	'config-subscribe' => 'Suscribirse para recibir [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce avisos de nuevas versiones].',
	'config-subscribe-help' => 'Esta es una lista de divulgación de bajo volumen para anuncios de lanzamiento de versiones nuevas, incluyendo anuncios de seguridad importantes.
Te recomendamos suscribirte y actualizar tu instalación MediaWiki cada vez que se lance una nueva versión.',
	'config-subscribe-noemail' => 'Ha intentado suscribirse a la lista de correo de anuncios de nuevos lanzamientos sin proporcionar una dirección de correo electrónico.
Proporcione una dirección de correo electrónico si desea suscribirse a la lista de correo.',
	'config-almost-done' => '¡Ya casi has terminado!
Ahora puedes saltarte el resto de pasos e instalar el wiki con valores predeterminados.',
	'config-optional-continue' => 'Hazme más preguntas.',
	'config-optional-skip' => 'Ya estoy aburrido, sólo instala el wiki.',
	'config-profile' => 'Perfil de derechos de usuario:',
	'config-profile-wiki' => 'Wiki tradicional',
	'config-profile-no-anon' => 'Creación de cuenta requerida',
	'config-profile-fishbowl' => 'Sólo editores autorizados',
	'config-profile-private' => 'Wiki privado',
	'config-profile-help' => "Los wikis funcionan mejor cuando dejas que los edite tanta gente como sea posible.
En MediaWiki, es fácil revisar los cambios recientes y revertir los daños realizados por usuarios malintencionados o novatos.
Sin embargo, muchos han encontrado que MediaWiki es útil para una amplia variedad de funciones, y a veces no es fácil convencer a todos de los beneficios de la forma wiki.
Por lo tanto tienes la elección.

Un '''{{int:config-profile-wiki}}''' permite que cualquiera pueda editar, sin siquiera iniciar sesión.
Un wiki con '''{{int:config-profile-no-anon}}''' ofrece rendición de cuentas adicional, pero puede disuadir a colaboradores.

El escenario '''{{int:config-profile-fishbowl}}''' permite editar a los usuarios autorizados, pero el público puede ver las páginas, incluyendo el historial.
Un '''{{int:config-profile-private}}''' sólo permite ver páginas a los usuarios autorizados, el mismo grupo al que le está permitido editar.

Configuraciones más complejas de derechos de usuario están disponibles después de la instalación, consulte [//www.mediawiki.org/wiki/Manual:User_rights esta entrada en el manual].",
	'config-license' => 'Copyright and licencia:',
	'config-license-none' => 'Pie sin licencia',
	'config-license-cc-by-sa' => 'Creative Commons Reconocimiento Compartir Igual',
	'config-license-cc-by' => 'Creative Commons Reconocimiento',
	'config-license-cc-by-nc-sa' => 'Creative Commons Reconocimiento Compartir Igual no comercial',
	'config-license-cc-0' => 'Creative Commons Zero (dominio público)',
	'config-license-gfdl' => 'Licencia de documentación libre de GNU 1.3 o posterior',
	'config-license-pd' => 'Dominio Público',
	'config-license-cc-choose' => 'Selecciona una licencia personalizada de Creative Commons',
	'config-license-help' => "Muchos wikis públicos ponen todas las contribuciones bajo una [http://freedomdefined.org/Definition licencia libre].
Esto ayuda a crear un sentido de propiedad comunitaria y alienta la contribución a largo plazo.
Esto no es generalmente necesario para un wiki privado o corporativo.

Si desea poder utilizar texto de Wikipedia, y desea que Wikipedia pueda aceptar el texto copiado de tu wiki, debe elegir '''Creative Commons Reconocimiento Compartir Igual'''.

Wikipedia utilizaba anteriormente la licencia de documentación libre de GNU (GFDL).
La GFDL es una licencia válida, pero es difícil de entender.
También es difícil reutilizar el contenido licenciado bajo la GFDL.",
	'config-email-settings' => 'Configuración de correo electrónico',
	'config-enable-email' => 'Activar el envío de correos electrónicos',
	'config-enable-email-help' => 'Si quieres que el correo electrónico funcione, la [http://www.php.net/manual/en/mail.configuration.php configuración PHP de correo electrónico] debe ser la correcta.
Si no quieres la funcionalidad de correo electrónico, puedes desactivarla aquí.',
	'config-email-user' => 'Habilitar correo electrónico de usuario a usuario',
	'config-email-user-help' => 'Permitir que todos los usuarios intercambien correos electrónicos si lo han activado en sus preferencias.',
	'config-email-usertalk' => 'Activar notificaciones de páginas de discusión de usuarios',
	'config-email-usertalk-help' => 'Permitir a los usuarios recibir notificaciones de cambios en la página de discusión de usuario, si lo han activado en sus preferencias.',
	'config-email-watchlist' => 'Activar notificación de alteraciones a la páginas vigiladas',
	'config-email-watchlist-help' => 'Permitir a los usuarios recibir notificaciones de cambios en la páginas que vigilan, si lo han activado en sus preferencias.',
	'config-email-auth' => 'Activar autenticación del correo electrónico',
	'config-email-auth-help' => "Si esta opción está habilitada, los usuarios tienen que confirmar su dirección de correo electrónico mediante un enlace que se les envía a ellos cuando éstos lo establecen o lo cambian.
Solo las direcciones de correo electrónico autenticadas pueden recibir correos electrónicos de otros usuarios o correos electrónicos de notificación de cambios.
Esta opción está '''recomendada''' para wikis públicos debido a posibles abusos de las características del correo electrónico.",
	'config-email-sender' => 'Dirección de correo electrónico de retorno:',
	'config-email-sender-help' => 'Introduce la dirección de correo electrónico que será usada como dirección de retorno en los mensajes electrónicos de salida.
Aquí llegarán los correos electrónicos que no lleguen a su destino.
Muchos servidores de correo electrónico exigen que por lo menos la parte del nombre del dominio sea válida.',
	'config-upload-settings' => 'Cargas de imágenes y archivos',
	'config-upload-enable' => 'Habilitar la subida de archivos',
	'config-upload-help' => 'La carga de archivos expone potencialmente su servidor a riesgos de seguridad.
Para obtener más información, lea la [//www.mediawiki.org/wiki/Manual:Security sección de seguridad] en el manual.

Para habilitar la carga de archivos, cambie el modo en el subdirectorio <code>images</code> bajo el directorio raíz de MediaWiki para que el servidor web pueda escribir en él.
A continuación, habilite esta opción.',
	'config-upload-deleted' => '*Directório para los archivos eliminados:',
	'config-upload-deleted-help' => 'Elige un directorio en el que guardar los archivos eliminados.
Lo ideal es una carpeta no accesible desde la red.',
	'config-logo' => 'URL del logo :',
	'config-logo-help' => 'La apariencia por defecto de MediaWiki incluye espacio para un logotipo de 135x160 píxeles encima del menú de la barra lateral.
Cargue una imagen de tamaño adecuado e introduzca la dirección URL aquí.

Si no desea un logotipo, deje esta casilla en blanco.',
	'config-instantcommons' => 'Habilitar Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] es una característica que permite que los wikis puedan utilizar imágenes, sonidos y otros archivos multimedia que se encuentran en el sitio [//commons.wikimedia.org/ Wikimedia Commons].
Para ello, MediaWiki requiere acceso a Internet.

Para obtener más información sobre esta función, incluidas las instrucciones sobre cómo configurarlo para otras wikis distintas de Wikimedia Commons, consulte [//mediawiki.org/wiki/Manual:$wgForeignFileRepos el manual].',
	'config-cc-error' => 'El selector de licencia de Creative Commons no dio resultado.
Escribe el nombre de la licencia manualmente.',
	'config-cc-again' => 'Elegir otra vez...',
	'config-cc-not-chosen' => 'Elige la licencia Creative Commons que desees y haz clic en "continuar".',
	'config-advanced-settings' => 'Configuración avanzada',
	'config-cache-options' => 'Configuración de la caché de objetos:',
	'config-cache-help' => 'El almacenamiento en caché de objetos se utiliza para mejorar la velocidad de MediaWiki mediante el almacenamiento en caché los datos usados más frecuentemente.
A los sitios medianos y grandes se les recomienda que permitirlo. También es beneficioso para los sitios pequeños.',
	'config-cache-none' => 'Sin almacenamiento en caché (no se pierde ninguna funcionalidad, pero la velocidad puede resentirse en sitios grandes)',
	'config-cache-accel' => 'Almacenamiento en caché de objetos PHP (APC, XCache o WinCache)',
	'config-cache-memcached' => 'Utilizar Memcached (necesita ser instalado y configurado aparte)',
	'config-memcached-servers' => 'Servidores Memcached:',
	'config-memcached-help' => 'Lista de direcciones IP que serán usadas por Memcached.
Deben especificarse una por cada línea y especificar el puerto a utilizar. Por ejemplo:
127.0.0.1:11211
192.168.1.25:1234',
	'config-memcache-needservers' => 'Ha seleccionado Memcached como su tipo de caché pero no especificó ninguno de los servidores.',
	'config-memcache-badip' => 'Ha introducido una dirección IP no válida para Memcached:  $1 .',
	'config-memcache-noport' => 'No ha especificado un puerto a usar en el servidor Memcached:  $1 .
Si no conoce el puerto, el valor predeterminado es 11211.',
	'config-memcache-badport' => 'Los números de puerto de Memcached deben estar entre  $1  y  $2.',
	'config-extensions' => 'Extensiones',
	'config-extensions-help' => 'Se ha detectado en tu directorio <code>./extensions</code>  las extensiones listadas arriba.

Puede que necesiten configuraciones adicionales, pero puedes habilitarlas ahora.',
	'config-install-alreadydone' => "'''Aviso:''' Parece que ya habías instalado MediaWiki y estás intentando instalarlo nuevamente.
Pasa a la próxima página, por favor.",
	'config-install-begin' => 'Pulsando "{{int:config-continue}}", se iniciará la instalación de MediaWiki.
Si todavía desea realizar algún cambio, pulse atrás.',
	'config-install-step-done' => 'hecho',
	'config-install-step-failed' => 'falló',
	'config-install-extensions' => 'Extensiones inclusive',
	'config-install-database' => 'Configurando la base de datos',
	'config-install-schema' => 'Creando el esquema',
	'config-install-pg-schema-not-exist' => 'El esquema PostgreSQL no existe.',
	'config-install-pg-schema-failed' => 'La creación de las tablas ha fallado.
Asegúrate de que el usuario "$1" puede escribir en el esquema "$2".',
	'config-install-pg-commit' => 'Validando los cambios',
	'config-install-pg-plpgsql' => 'Comprobación de lenguaje PL/pgSQL',
	'config-pg-no-plpgsql' => 'Necesita instalar el lenguaje PL/pgSQL en la base de datos $1',
	'config-pg-no-create-privs' => 'La cuenta especificada para la instalación no tiene suficientes privilegios para crear una cuenta.',
	'config-pg-not-in-role' => 'La cuenta especificada para el usuario web ya existe.
La cuenta especificada para la instalación no es de un superusuario y no es miembro del grupo de usuarios con acceso a la web, por lo que es incapaz de crear objetos pertenecientes al usuario web.

MediaWiki requiere actualmente que las tablas sean propiedad del usuario web. Especifique otro nombre de cuenta web, o haga clic en "atrás" y especifique un usuario de instalación con los privilegios convenientes.',
	'config-install-user' => 'Creando el usuario de la base de datos',
	'config-install-user-alreadyexists' => 'El usuario "$1" ya existe',
	'config-install-user-create-failed' => 'La creación del usuario "$1" falló:  $2',
	'config-install-user-grant-failed' => 'La concesión de permisos para el usuario "$1" ha fallado: $2',
	'config-install-user-missing' => 'El usuario especificado "$1" no existe.',
	'config-install-user-missing-create' => 'El usuario especificado "$1" no existe.
Por favor, haga clic en la casilla "Crear cuenta" que aparece a continuación si desea crearlo.',
	'config-install-tables' => 'Creando tablas',
	'config-install-tables-exist' => "'''Advertencia''': Al parecer, las tablas de MediaWiki ya existen. Saltándose su creación.",
	'config-install-tables-failed' => "'''Error''': La creación de las tablas falló con el siguiente error: $1",
	'config-install-interwiki' => 'Llenando la tabla interwiki predeterminada',
	'config-install-interwiki-list' => 'No se pudo encontrar el archivo <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Advertencia''': La tabla de interwikis parece ya contener entradas.
Se omitirá la lista predeterminada.",
	'config-install-stats' => 'Iniciando las estadísticas',
	'config-install-keys' => 'Generación de claves secretas',
	'config-insecure-keys' => "''' Atención:'' '  {{PLURAL:$2|Una clave de seguridad generada|Las claves de seguridad generadas}} ($1) durante la instalación no  {{PLURAL:$2|es totalmente segura|son totalmente seguras}}. Considere {{PLURAL:$2| cambiarla|cambiarlas}} manualmente.",
	'config-install-sysop' => 'Creando cuenta de usuario del administrador',
	'config-install-subscribe-fail' => 'No se ha podido suscribir a mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL no está instalado y allow_url_fopen no está disponible.',
	'config-install-mainpage' => 'Creando página principal con contenido predeterminado',
	'config-install-extension-tables' => 'Creando las tablas para las extensiones habilitadas',
	'config-install-mainpage-failed' => 'No se pudo insertar la página principal: $1',
	'config-install-done' => "''' Felicidades!'''
Ha instalado MediaWiki correctamente.

El instalador ha generado un  archivo<code>LocalSettings.php</code>.
Contiene toda su configuración.

Deberá descargarlo y ponerlo en la base de la instalación de wiki (el mismo directorio que index.php). Debería haber comenzado automáticamente la descarga.

Si no comenzó la descarga, o si se ha cancelado, puede reiniciar la descarga haciendo clic en el enlace siguiente:
$3

'''Nota''': Si no haces esto ahora, este archivo de configuración generado no estará disponible para usted más tarde si sale de la instalación sin descargarlo.

Cuando lo haya hecho, usted puede '''[$2  entrar en su wiki]'''.",
	'config-download-localsettings' => 'Descargar archivo LocalSettings.php',
	'config-help' => 'Ayuda',
	'config-nofile' => 'El archivo "$1" no se pudo encontrar. ¿Se ha eliminado?',
	'mainpagetext' => "'''MediaWiki ha sido instalado con éxito.'''",
	'mainpagedocfooter' => 'Consulta la [//meta.wikimedia.org/wiki/Ayuda:Contenido Guía de usuario] para obtener información sobre el uso del software wiki.

== Empezando ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista de ajustes de configuración]
* [//www.mediawiki.org/wiki/Manual:FAQ/es FAQ de MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de correo de anuncios de distribución de MediaWiki]',
);

/** español (formal) (español (formal))
 * @author Dferg
 */
$messages['es-formal'] = array(
	'mainpagedocfooter' => 'Consulte usted la [//meta.wikimedia.org/wiki/Ayuda:Contenido Guía de usuario] para obtener información sobre el uso del software wiki.

== Empezando ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista de ajustes de configuración]
* [//www.mediawiki.org/wiki/Manual:FAQ/es FAQ de MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de correo de anuncios de distribución de MediaWiki]',
);

/** Estonian (eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'config-back' => '← Tagasi',
	'config-continue' => 'Jätka →',
	'config-page-language' => 'Keel',
	'config-page-welcome' => 'Tere tulemast MediaWikisse!',
	'config-page-name' => 'Nimi',
	'config-page-options' => 'Seaded',
	'config-page-install' => 'Paigaldamine',
	'config-page-complete' => 'Valmis!',
	'config-db-name' => 'Andmebaasi nimi:',
	'config-db-username' => 'Andmebaasi kasutajanimi:',
	'config-db-password' => 'Andmebaasi parool:',
	'config-admin-email' => 'E-posti aadress:',
	'config-optional-continue' => 'Küsi minult veel küsimusi.',
	'config-install-step-done' => 'valmis',
	'config-install-step-failed' => 'ebaõnnestus',
	'mainpagetext' => "'''MediaWiki tarkvara on edukalt paigaldatud.'''",
	'mainpagedocfooter' => 'Juhiste saamiseks kasutamise ning konfigureerimise kohta vaata palun inglisekeelset [//meta.wikimedia.org/wiki/MediaWiki_localisation dokumentatsiooni liidese kohaldamisest]
ning [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide kasutusjuhendit].',
);

/** Basque (euskara)
 * @author An13sa
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'config-desc' => 'MediaWiki instalatzailea',
	'config-title' => 'MediaWiki $1 instalazioa',
	'config-information' => 'Informazioa',
	'config-session-error' => 'Saio hasierako errorea: $1',
	'config-your-language' => 'Zure hizkuntza:',
	'config-your-language-help' => 'Aukeratu instalazio prozesuan erabiliko den hizkuntza',
	'config-wiki-language' => 'Wiki hizkuntza:',
	'config-back' => '← Atzera',
	'config-continue' => 'Jarraitu →',
	'config-page-language' => 'Hizkuntza',
	'config-page-welcome' => 'Ongi etorri MediaWikira!',
	'config-page-dbconnect' => 'Datu-basera konektatu',
	'config-page-dbsettings' => 'Datu-basearen ezarpenak',
	'config-page-name' => 'Izena',
	'config-page-options' => 'Aukerak',
	'config-page-install' => 'Instalatu',
	'config-page-complete' => 'Bukatua!',
	'config-page-restart' => 'Instalazioa berriz hasi',
	'config-page-readme' => 'Irakur nazazu',
	'config-page-copying' => 'Kopiatzea',
	'config-page-upgradedoc' => 'Eguneratu',
	'config-restart' => 'Bai, berriz hasi',
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki nagusia]
* [//www.mediawiki.org/wiki/Help:Contents Erabiltzaileentzako Gida]
* [//www.mediawiki.org/wiki/Manual:Contents Administratzaileentzako Gida]
* [//www.mediawiki.org/wiki/Manual:FAQ MEG]
----
* <doclink href=Readme>Irakur nazazu</doclink>
* <doclink href=ReleaseNotes>Oharren argitalpena</doclink>
* <doclink href=Copying>Kopiaketa</doclink>
* <doclink href=UpgradeDoc>Eguneratzea</doclink>',
	'config-env-php' => 'PHP $1 instalatuta dago.',
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] instalatuta dago',
	'config-apc' => '[http://www.php.net/apc APC] instalatuta dago',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] instalatuta dago',
	'config-diff3-bad' => 'GNU diff3 ez da aurkitu.',
	'config-db-type' => 'Datu-base mota:',
	'config-db-wiki-settings' => 'Wiki hau identifikatu',
	'config-db-name' => 'Datu-base izena:',
	'config-db-username' => 'Datu-base lankide izena:',
	'config-db-password' => 'Datu-base pasahitza:',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 bitarra',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-header-mysql' => 'MySQL hobespenak',
	'config-header-postgres' => 'PostgreSQL hobespenak',
	'config-header-sqlite' => 'SQLite hobespenak',
	'config-header-oracle' => 'Oracle hobespenak',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-binary' => 'Bitarra',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Wikiaren izena:',
	'config-project-namespace' => 'Proiektuaren izen-tartea:',
	'config-ns-generic' => 'Proiektua',
	'config-ns-other' => 'Bestelakoa (zehaztu)',
	'config-ns-other-default' => 'MyWiki',
	'config-admin-box' => 'Administratzaile kontua',
	'config-admin-name' => 'Zure izena:',
	'config-admin-password' => 'Pasahitza:',
	'config-admin-password-confirm' => 'Pasahitza berriz:',
	'config-admin-email' => 'E-posta helbidea:',
	'config-profile-wiki' => 'Wiki tradizionala',
	'config-profile-private' => 'Wiki pribatua',
	'config-license' => 'Copyright eta lizentzia:',
	'config-license-pd' => 'Domeinu Askea',
	'config-email-settings' => 'E-posta hobespenak',
	'config-logo' => 'Logo URL:',
	'config-extensions' => 'Luzapenak',
	'config-install-step-done' => 'egina',
	'config-help' => 'Laguntza',
	'mainpagetext' => "'''MediaWiki arrakastaz instalatu da.'''",
	'mainpagedocfooter' => 'Ikus [//meta.wikimedia.org/wiki/Help:Contents Erabiltzaile Gida] wiki softwarea erabiltzen hasteko informazio gehiagorako.

== Nola hasi ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Konfigurazio balioen zerrenda]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ (Maiz egindako galderak)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWikiren argitalpenen posta zerrenda]',
);

/** Extremaduran (estremeñu)
 */
$messages['ext'] = array(
	'mainpagetext' => "'''MeyaGüiqui s'á istalau satihatoriamenti.'''",
	'mainpagedocfooter' => "Consurta la [//meta.wikimedia.org/wiki/Help:Contents User's Guide] pa sabel mas al tentu el huncionamientu el software güiqui.

== Esminciandu ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Persian (فارسی)
 * @author Mjbmr
 */
$messages['fa'] = array(
	'config-desc' => 'نصب کنندهٔ ویکی‌مدیا',
	'config-title' => 'نصب ویکی‌مدیا $1',
	'config-information' => 'اطلاعات',
	'config-your-language' => 'زبان شما:',
	'config-wiki-language' => 'زبان ویکی:',
	'config-back' => '→ بازگشت',
	'config-continue' => 'ادامه ←',
	'config-page-language' => 'زبان',
	'config-page-welcome' => 'به مدیاویکی خوش آمدید!',
	'config-page-name' => 'نام',
	'config-page-options' => 'گزینه‌ها',
	'config-page-install' => 'نصب',
	'config-page-complete' => 'کامل!',
	'config-page-readme' => 'مرا بخوان',
	'config-page-releasenotes' => 'یادداشت‌های انتشار',
	'config-page-existingwiki' => 'ویکی موجود',
	'config-restart' => 'بله ، آن دوباره راه اندازی کن',
	'config-sidebar' => '* [//www.mediawiki.org صفحهٔ اصلی مدیاویکی]
* [//www.mediawiki.org/wiki/Help:Contents راهنمای کاربر]
* [//www.mediawiki.org/wiki/Manual:Contents راهنمای مدیر]
* [//www.mediawiki.org/wiki/Manual:FAQ پرسش‌های رایج]
----
* <doclink href=Readme>مرا بخوان</doclink>
* <doclink href=ReleaseNotes>یادداشت‌های انتشار</doclink>
* <doclink href=Copying>نسخه برداری</doclink>
* <doclink href=UpgradeDoc>ارتقا</doclink>',
	'config-env-php' => 'پی‌اچ‌پی $1 نصب شده است.',
	'config-env-php-toolow' => 'پی‌اچ‌پی $1 نصب شده است.
در هر صورت، مدیاویکی نیاز به پی‌اچ‌پی نسخهٔ $2 یا بالاتر دارد.',
	'config-db-type' => 'نوع پایگاه اطلاعات:',
	'config-db-host' => 'میزبان پایگاه اطلاعات:',
	'config-db-username' => 'نام کاربری پایگاه اطلاعات:',
	'config-db-password' => 'کلمه عبور پایگاه اطلاعات:',
	'config-header-mysql' => 'تنظیمات مای‌اس‌کیو‌ال',
	'config-connection-error' => '$1.

میزبان، نام کاربری و گذرواژه را بررسی کنید و دوباره امتحان کنید.',
	'config-site-name' => 'نام ویکی:',
	'config-site-name-blank' => 'نام تارنما را وارد کنید.',
	'config-project-namespace' => 'فضای نام پروژه:',
	'config-admin-name' => 'نام شما:',
	'config-admin-password' => 'کلمه عبور:',
	'config-admin-password-confirm' => 'دوباره کلمه عبور:',
	'config-admin-email' => 'پست الکترونیکی شما:',
	'config-profile-private' => 'ویکی خصوصی',
	'config-license' => 'حق تکثیر و مجوز:',
	'config-license-none' => 'بدون پاورقی مجوز',
	'config-license-pd' => 'دامنه عمومی',
	'config-license-cc-choose' => 'انتخاب یک مجوز سفارشی عوام خلاق',
	'config-email-settings' => 'تنظیمات پست الکترونیکی',
	'config-upload-enable' => 'فعال سازی بارگذاری پرونده',
	'config-logo' => 'نشانی نامواره:',
	'config-install-step-done' => 'انجام شد',
	'config-install-step-failed' => 'ناموفق بود',
	'config-help' => 'راهنما',
	'mainpagetext' => "'''نرم‌افزار ویکی با موفقیت نصب شد.'''",
	'mainpagedocfooter' => 'از [//meta.wikimedia.org/wiki/Help:Contents راهنمای کاربران]
برای استفاده از نرم‌افزار ویکی کمک بگیرید.

== آغاز به کار ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings تنظیم پیکربندی]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki پرسش‌های متداول]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce فهرست پست الکترونیکی نسخه‌های مدیاویکی]',
);

/** Finnish (suomi)
 * @author Beluga
 * @author Centerlink
 * @author Crt
 * @author Nike
 * @author Olli
 * @author Str4nd
 */
$messages['fi'] = array(
	'config-desc' => 'MediaWiki-asennin',
	'config-title' => 'MediaWikin version $1 asennus',
	'config-information' => 'Tiedot',
	'config-localsettings-upgrade' => '<code>LocalSettings.php</code>-tiedosto havaittiin.
Kirjoita muuttujan <code>$wgUpgradeKey</code> arvo alla olevaan kenttään päivittääksesi asennuksen.
Löydät sen LocalSettings.php-tiedostosta.',
	'config-localsettings-cli-upgrade' => 'LocalSettings.php-tiedosto havaittiin.
Päivitä asennus suorittamalla update.php.',
	'config-localsettings-key' => 'Päivitysavain',
	'config-localsettings-badkey' => 'Antamasi avain on virheellinen.',
	'config-localsettings-incomplete' => 'Nykyinen LocalSettings.php-tiedosto näyttää olevan puutteellinen.
Muuttujaa $1 ei ole asetettu.
Muuta LocalSettings.php-tiedostoa siten, että muuttuja on asetettu ja napsauta »Jatka».',
	'config-session-error' => 'Istunnon aloittaminen epäonnistui: $1',
	'config-session-expired' => 'Istuntotietosi näyttävät olevan vanhentuneita.
Istuntojen elinajaksi on määritelty $1.
Voit muuttaa tätä asetusta vaihtamalla kohtaa <code>session.gc_maxlifetime</code> php.ini-tiedostossa.
Käynnistä asennusprosessi uudelleen.',
	'config-your-language' => 'Asennuksen kieli',
	'config-your-language-help' => 'Valitse kieli, jota haluat käyttää asennuksen ajan.',
	'config-wiki-language' => 'Wikin kieli',
	'config-wiki-language-help' => 'Valitse kieli, jota wikissä tullaan etupäässä käyttämään.',
	'config-back' => '← Takaisin',
	'config-continue' => 'Jatka →',
	'config-page-language' => 'Kieli',
	'config-page-welcome' => 'Tervetuloa MediaWikiin!',
	'config-page-dbconnect' => 'Tietokantaan yhdistäminen',
	'config-page-upgrade' => 'Olemassa olevan asennuksen päivitys',
	'config-page-dbsettings' => 'Tietokannan asetukset',
	'config-page-name' => 'Nimi',
	'config-page-options' => 'Asetukset',
	'config-page-install' => 'Asenna',
	'config-page-complete' => 'Valmis!',
	'config-page-restart' => 'Aloita asennus alusta',
	'config-page-readme' => 'Lue minut',
	'config-page-releasenotes' => 'Julkaisutiedot',
	'config-page-copying' => 'Kopiointi',
	'config-page-upgradedoc' => 'Päivittäminen',
	'config-page-existingwiki' => 'Aikaisempi asennus',
	'config-help-restart' => 'Haluatko poistaa kaikki annetut tiedot ja aloittaa asennuksen alusta?',
	'config-restart' => 'Kyllä',
	'config-welcome' => '=== Ympäristön tarkistukset ===
Varmistetaan MediaWikin asennettavuus tähän ympäristöön.
Sinun pitäisi antaa näiden tarkistusten tulokset, jos tarvitset apua asennuksen aikana.',
	'config-sidebar' => '* [//www.mediawiki.org MediaWikin kotisivu]
* [//www.mediawiki.org/wiki/Help:Contents Käyttöopas]
* [//www.mediawiki.org/wiki/Manual:Contents Hallintaopas]
* [//www.mediawiki.org/wiki/Manual:FAQ UKK]
----
* <doclink href=Readme>Lue minut</doclink>
* <doclink href=ReleaseNotes>Julkaisutiedot</doclink>
* <doclink href=Copying>Kopiointi</doclink>
* <doclink href=UpgradeDoc>Päivittäminen</doclink>',
	'config-env-good' => 'Asennusympäristö on tarkastettu.
Voit asentaa MediaWikin.',
	'config-env-bad' => 'Asennusympäristö on tarkastettu.
Et voi asentaa MediaWikiä.',
	'config-env-php' => 'PHP $1 on asennettu.',
	'config-env-php-toolow' => 'PHP $1 on asennettu.
MediaWiki vaatii PHP:n version $2 tai uudemman.',
	'config-no-db' => 'Sopivaa tietokanta-ajuria ei löytynyt! Sinun täytyy asentaa tietokanta-ajurit PHP:lle.
Seuraavat tietokantatyypit ovat tuettuja: $1.', # Fuzzy
	'config-safe-mode' => "'''Varoitus:''' PHP:n [http://www.php.net/features.safe-mode safe mode] -tila on aktiivinen.
Se voi aiheuttaa ongelmia erityisesti tiedostojen tallentamisen ja matemaattisten kaavojen kanssa.",
	'config-pcre' => 'PCRE-tukimoduuli puuttuu.
MediaWiki vaatii toimiakseen Perl-yhteensopivat säännölliset lausekkeet.',
	'config-memory-bad' => "'''Varoitus:''' PHP:n <code>memory_limit</code> on $1.
Tämä on luultavasti liian alhainen.
Asennus saattaa epäonnistua!",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] on asennettu',
	'config-apc' => '[http://www.php.net/apc APC] on asennettu.',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] on asennettu',
	'config-diff3-bad' => 'GNU diff3:a ei löytynyt.',
	'config-db-type' => 'Tietokannan tyyppi',
	'config-db-host' => 'Tietokantapalvelin',
	'config-db-name' => 'Tietokannan nimi',
	'config-db-username' => 'Tietokannan käyttäjätunnus',
	'config-db-password' => 'Tietokannan salasana',
	'config-db-install-help' => 'Anna käyttäjätunnus ja salasana, joita käytetään asennuksen aikana.',
	'config-db-account-lock' => 'Käytä samaa tunnusta ja salasanaa myös asennuksen jälkeen',
	'config-db-prefix' => 'Tietokantataulujen etuliite',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0, binääri',
	'config-charset-mysql5' => 'MySQL 4.1/5.0, UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0, taaksepäin yhteensopiva UTF-8',
	'config-mysql-old' => 'MediaWiki tarvitsee MySQL:n version $1 tai uudemman. Nykyinen versio on $2.',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-ibm_db2' => '* $1 on kaupallinen tietokanta yrityskäyttöön.',
	'config-header-mysql' => 'MySQL-asetukset',
	'config-header-postgres' => 'PostgreSQL-asetukset',
	'config-header-sqlite' => 'SQLite-asetukset',
	'config-header-oracle' => 'Oracle-asetukset',
	'config-header-ibm_db2' => 'IBM DB2 -asetukset',
	'config-invalid-db-type' => 'Virheellinen tietokantatyyppi',
	'config-missing-db-name' => 'Kenttä »Tietokannan nimi» on pakollinen',
	'config-invalid-db-name' => '”$1” ei kelpaa tietokannan nimeksi.
Käytä ainoastaan kirjaimia (a-z, A-Z), numeroita (0-9), alaviivoja (_) ja tavuviivoja (-).',
	'config-invalid-db-prefix' => '”$1” ei kelpaa tietokannan etuliitteeksi.
Käytä ainoastaan kirjaimia (a-z, A-Z), numeroita (0-9), alaviivoja (_) ja tavuviivoja (-).',
	'config-postgres-old' => 'MediaWiki tarvitsee PostgreSQL:n version $1 tai uudemman. Nykyinen versio on $2.',
	'config-sqlite-name-help' => 'Valitse nimi, joka yksilöi tämän wikin.
Älä käytä välilyöntejä tai viivoja.
Nimeä käytetään SQLite-tietokannan tiedostonimessä.',
	'config-sqlite-dir-unwritable' => 'Hakemistoon ”$1” kirjoittaminen epäonnistui.
Muuta hakemiston käyttöoikeuksia siten, että palvelinohjelmisto voi kirjoittaa siihen ja yritä uudelleen.',
	'config-sqlite-readonly' => 'Tiedostoon <code>$1</code> ei voi kirjoittaa.',
	'config-sqlite-fts3-downgrade' => 'PHP:stä puuttuu FTS3-tuki. Poistetaan ominaisuus käytöstä tietokantatauluista.',
	'config-upgrade-done' => "Päivitys valmis.

Voit [$1 aloittaa wikin käytön].

Napsauta alla olevaa painiketta, jos haluat luoda uudelleen <code>LocalSettings.php</code>-tiedoston.
Tämä '''ei ole suositeltavaa''', jos wikissäsi ei ole ongelmia.",
	'config-upgrade-done-no-regenerate' => 'Päivitys valmis.

Voit [$1 aloittaa wikin käytön].',
	'config-regenerate' => 'Luo LocalSettings.php uudelleen →',
	'config-show-table-status' => 'Kysely SHOW TABLE STATUS epäonnistui!',
	'config-mysql-engine' => 'Tallennusmoottori',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-binary' => 'Binääri',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Wikin nimi',
	'config-site-name-blank' => 'Kirjoita sivuston nimi.',
	'config-project-namespace' => 'Projektinimiavaruus',
	'config-ns-generic' => 'Projekti',
	'config-ns-site-name' => 'Sama kuin wikin nimi: $1',
	'config-ns-other' => 'Muu (määritä)',
	'config-admin-name' => 'Nimesi',
	'config-admin-password' => 'Salasana',
	'config-admin-password-confirm' => 'Salasana uudelleen',
	'config-admin-name-blank' => 'Anna ylläpitäjän käyttäjänimi.',
	'config-admin-email' => 'Sähköpostiosoite',
	'config-admin-error-bademail' => 'Annoit virheellisen sähköpostiosoitteen.',
	'config-almost-done' => 'Olet jo lähes valmis!
Voit ohittaa jäljellä olevat määritykset ja asentaa wikin juuri nyt.',
	'config-profile-wiki' => 'Perinteinen wiki',
	'config-profile-no-anon' => 'Tunnuksen luonti vaaditaan',
	'config-profile-private' => 'Yksityinen wiki',
	'config-license' => 'Tekijänoikeus ja lisenssi:',
	'config-license-pd' => 'Public domain',
	'config-email-settings' => 'Sähköpostiasetukset',
	'config-logo' => 'Logon URL-osoite',
	'config-cc-again' => 'Valitse uudelleen...',
	'config-extensions' => 'Laajennukset',
	'config-install-step-done' => 'valmis',
	'config-install-step-failed' => 'epäonnistui',
	'config-install-user-alreadyexists' => 'Käyttäjä $1 on jo olemassa',
	'config-install-interwiki-list' => 'Tiedostoa <code>interwiki.list</code> ei voitu lukea.',
	'config-download-localsettings' => 'Lataa LocalSettings.php',
	'config-help' => 'ohje',
	'mainpagetext' => "'''MediaWiki on onnistuneesti asennettu.'''",
	'mainpagedocfooter' => "Lisätietoja käytöstä on sivulla [//meta.wikimedia.org/wiki/Help:Contents User's Guide].

=== Lisäohjeita ===

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Asetusten teko-ohjeita]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWikin FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Sähköpostilista, jolla tiedotetaan MediaWikin uusista versioista]

=== Asetukset ===

Tarkista, että alla olevat taivutusmuodot ovat oikein. Jos eivät, tee tarvittavat muutokset tiedostoon LocalSettings.php seuraavasti:
 \$wgGrammarForms['fi']['genitive']['{{SITENAME}}'] = '...';
 \$wgGrammarForms['fi']['partitive']['{{SITENAME}}'] = '...';
 \$wgGrammarForms['fi']['elative']['{{SITENAME}}'] = '...';
 \$wgGrammarForms['fi']['inessive']['{{SITENAME}}'] = '...';
 \$wgGrammarForms['fi']['illative']['{{SITENAME}}'] = '...';
Taivutusmuodot: {{GRAMMAR:genitive|{{SITENAME}}}} (yön) – {{GRAMMAR:partitive|{{SITENAME}}}} (yötä) – {{GRAMMAR:elative|{{SITENAME}}}} (yöstä) – {{GRAMMAR:inessive|{{SITENAME}}}} (yössä) – {{GRAMMAR:illative|{{SITENAME}}}} (yöhön).",
);

/** Faroese (føroyskt)
 */
$messages['fo'] = array(
	'mainpagetext' => "'''Innlegging av Wiki-ritbúnaði væleydnað.'''",
);

/** French (français)
 * @author Aadri
 * @author Crochet.david
 * @author Gomoko
 * @author Grondin
 * @author Guillom
 * @author Hashar
 * @author IAlex
 * @author Jean-Frédéric
 * @author McDutchie
 * @author Peter17
 * @author Reedy
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 * @author Wyz
 * @author Yumeki
 */
$messages['fr'] = array(
	'config-desc' => 'Le programme d’installation de MediaWiki',
	'config-title' => 'Installation de MediaWiki $1',
	'config-information' => 'Informations',
	'config-localsettings-upgrade' => 'Un fichier <code>LocalSettings.php</code> a été détecté.
Pour mettre à jour cette installation, veuillez saisir la valeur de <code>$wgUpgradeKey</code> dans le champ ci-dessous.
Vous la trouverez dans LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Un fichier LocalSettings.php a été détecté.
Pour mettre à niveau cette installation, veuillez exécuter update.php',
	'config-localsettings-key' => 'Clé de mise à jour :',
	'config-localsettings-badkey' => 'La clé que vous avez fournie est incorrecte',
	'config-upgrade-key-missing' => 'Une installation existante de MediaWiki a été détectée.

Pour mettre à jour cette installation, veuillez ajouter la ligne suivante à la fin de votre fichier LocalSettings.php

$1',
	'config-localsettings-incomplete' => 'Le fichier LocalSettings.php existant semble être incomplet.
La variable $1 n’est pas définie.
Veuillez modifier LocalSettings.php de sorte que cette variable soit définie, puis cliquer sur « Continuer ».',
	'config-localsettings-connection-error' => 'Une erreur est survenue lors de la connexion à la base de données en utilisant la configuration spécifiée dans LocalSettings.php ou AdminSettings.php. Veuillez corriger cette configuration puis réessayer.

$1',
	'config-session-error' => 'Erreur lors du démarrage de la session : $1',
	'config-session-expired' => "↓Les données de votre session semblent avoir expiré.
Les sessions sont configurées pour une durée de $1.
Vous pouvez l'augmenter en configurant <code>session.gc_maxlifetime</code> dans le fichier php.ini.
Redémarrer le processus d'installation.",
	'config-no-session' => 'Les données de votre session ont été perdues !
Vérifiez votre fichier php.ini et assurez-vous que <code>session.save_path</code> contient le chemin d’un répertoire approprié.',
	'config-your-language' => 'Votre langue :',
	'config-your-language-help' => "Sélectionnez la langue à utiliser pendant le processus d'installation.",
	'config-wiki-language' => 'Langue du wiki :',
	'config-wiki-language-help' => 'Sélectionner la langue dans laquelle le wiki sera principalement écrit.',
	'config-back' => '← Retour',
	'config-continue' => 'Continuer →',
	'config-page-language' => 'Langue',
	'config-page-welcome' => 'Bienvenue sur MediaWiki !',
	'config-page-dbconnect' => 'Se connecter à la base de données',
	'config-page-upgrade' => 'Mettre à jour l’installation existante',
	'config-page-dbsettings' => 'Paramètres de la base de données',
	'config-page-name' => 'Nom',
	'config-page-options' => 'Options',
	'config-page-install' => 'Installer',
	'config-page-complete' => 'Terminé !',
	'config-page-restart' => 'Redémarrer l’installation',
	'config-page-readme' => 'Lisez-moi',
	'config-page-releasenotes' => 'Notes de version',
	'config-page-copying' => 'Copie',
	'config-page-upgradedoc' => 'Mise à jour',
	'config-page-existingwiki' => 'Wiki existant',
	'config-help-restart' => "Voulez-vous effacer toutes les données enregistrées que vous avez entrées et relancer le processus d'installation ?",
	'config-restart' => 'Oui, le relancer',
	'config-welcome' => "=== Vérifications liées à l’environnement ===
Des vérifications de base sont effectuées pour voir si cet environnement est adapté à l'installation de MediaWiki.
Vous devriez indiquer les résultats de ces vérifications si vous avez besoin d’aide lors de l’installation.",
	'config-copyright' => "=== Droit d'auteur et conditions ===

$1

Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou le modifier selon les termes de la Licence Publique Générale GNU telle que publiée par la Free Software Foundation (version 2 de la Licence, ou, à votre choix, toute version ultérieure).

Ce programme est distribué dans l’espoir qu’il sera utile, mais '''sans aucune garantie''' : sans même les garanties implicites de '''commerciabilité''' ou d’'''adéquation à un usage particulier'''.
Voir la Licence Publique Générale GNU pour plus de détails.

Vous devriez avoir reçu <doclink href=Copying>une copie de la Licence Publique Générale GNU</doclink> avec ce programme ; dans le cas contraire, écrivez à la Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. ou [http://www.gnu.org/copyleft/gpl.html lisez-le en ligne].",
	'config-sidebar' => '* [//www.mediawiki.org Accueil MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Guide de l’utilisateur]
* [//www.mediawiki.org/wiki/Manual:Contents Guide de l’administrateur]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>Lisez-moi</doclink>
* <doclink href=ReleaseNotes>Notes de publication</doclink>
* <doclink href=Copying>Copie</doclink>
* <doclink href=UpgradeDoc>Mise à jour</doclink>',
	'config-env-good' => 'L’environnement a été vérifié.
Vous pouvez installer MediaWiki.',
	'config-env-bad' => 'L’environnement a été vérifié.
Vous ne pouvez pas installer MediaWiki.',
	'config-env-php' => 'PHP $1 est installé.',
	'config-env-php-toolow' => 'PHP $1 est installé.
Cependant, MediaWiki requiert PHP $2 ou plus haut.',
	'config-unicode-using-utf8' => 'Utilisation de utf8_normalize.so par Brion Vibber pour la normalisation Unicode.',
	'config-unicode-using-intl' => "Utilisation de [http://pecl.php.net/intl l'extension PECL intl] pour la normalisation Unicode.",
	'config-unicode-pure-php-warning' => "'''Attention''': L'[http://pecl.php.net/intl extension PECL intl] n'est pas disponible pour la normalisation d’Unicode, retour à la version lente implémentée en PHP.
Si votre site web sera très fréquenté, vous devriez lire ceci : [//www.mediawiki.org/wiki/Unicode_normalization_considerations ''Unicode normalization''] (en anglais).",
	'config-unicode-update-warning' => "'''Attention''': La version installée du ''wrapper'' de normalisation Unicode utilise une vieille version de la [http://site.icu-project.org/ bibliothèque logicielle ''ICU Project''].
Vous devriez faire une [//www.mediawiki.org/wiki/Unicode_normalization_considerations mise à jour] (texte en anglais) si l'usage d'Unicode vous semble important.",
	'config-no-db' => "Impossible de trouver un pilote de base de données approprié ! Vous devez installer un pilote pour PHP. Ces types de bases de données sont reconnus : $1.

Si vous êtes sur un site partagé, demandez à votre hébergeur d'installer un pilote de base de données approprié. Si vous avez compilé PHP, le configurer avec client de base de données activé, par exemple en insérant la directive <code>./configure --with-mysql</code>.

Si vous avez installé PHP d'une distribution Debian ou Ubuntu, vous devez aussi installer le module <code>php5-mysql</code>.",
	'config-outdated-sqlite' => "'''Attention''': vous avez SQLite $1, qui est inférieur à la version minimale requise $2. SQLite sera indisponible.",
	'config-no-fts3' => "'''Attention :''' SQLite est compilé sans le module [//sqlite.org/fts3.html FTS3] ; les fonctions de recherche ne seront pas disponibles sur ce moteur.",
	'config-register-globals' => "'''Attention : l'option <code>[http://php.net/register_globals register_globals]</code> de PHP est activée.'''
'''Désactivez-la si vous le pouvez.'''
MediaWiki fonctionnera, mais votre serveur sera exposé à de potentielles failles de sécurité.",
	'config-magic-quotes-runtime' => "'''Erreur fatale : [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] est activé !'''
Cette option corrompt les données de manière imprévisible.
Vous ne pouvez pas installer ou utiliser MediaWiki tant que cette option est activée.",
	'config-magic-quotes-sybase' => "'''Erreur fatale : [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybasee] est activé !'''
Cette option corrompt les données de manière imprévisible.
Vous ne pouvez pas installer ou utiliser MediaWiki tant que cette option est activée.",
	'config-mbstring' => "'''Erreur fatale : [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] est activé !'''
Cette option provoque des erreurs et peut corrompre les données de manière imprévisible.
Vous ne pouvez pas installer ou utiliser MediaWiki tant que cette option est activée.",
	'config-ze1' => "'''Erreur fatale : [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mod] est activé !'''
Cette option provoque des bugs horribles avec MediaWiki.
Vous ne pouvez pas installer ou utiliser MediaWiki tant que cette option est activée.",
	'config-safe-mode' => "'''Attention : le « [http://www.php.net/features.safe-mode safe mode] » est activé !'''
Ceci peut causer des problèmes, en particulier si vous utilisez le téléversement de fichiers et le support de <code>math</code>.",
	'config-xml-bad' => 'Le module XML de PHP est manquant.
MediaWiki requiert des fonctions de ce module et ne fonctionnera pas avec cette configuration.
Si vous êtes sous Mandrake, installez le paquet php-xml.',
	'config-pcre' => 'Le module de support PCRE semble manquer.
MediaWiki requiert les fonctions d’expressions rationnelles compatibles avec Perl.',
	'config-pcre-no-utf8' => "'''Erreur fatale''': Le module PCRE de PHP semble être compilé sans le support PCRE_UTF8.
MédiaWiki nécessite la gestion d’UTF-8 pour fonctionner correctement.",
	'config-memory-raised' => 'Le paramètre <code>memory_limit</code> de PHP était à $1, porté à $2.',
	'config-memory-bad' => "'''Attention :''' Le paramètre <code>memory_limit</code> de PHP est à $1.
Cette valeur est probablement trop faible.
Il est possible que l’installation échoue !",
	'config-ctype' => "'''Fatal ''': PHP doit être compilé avec le support pour l'[http://www.php.net/manual/en/ctype.installation.php extension Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] est installé',
	'config-apc' => '[http://www.php.net/apc APC] est installé',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] est installé',
	'config-no-cache' => "'''Attention :''' Impossible de trouver [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] ou [http://www.iis.net/download/WinCacheForPhp WinCache].
La mise en cache d'objets n'est pas activée.",
	'config-mod-security' => "'''Attention''': Votre serveur web a [http://modsecurity.org/ mod_security] activé. S&il est mal configuré, cela peut poser des problèmes à MediaWiki ou à d'autres applications qui permettent aux utilisateurs de publier un contenu quelconque.
Reportez-vous à [http://modsecurity.org/documentation/ la documentation de mod_security] ou contactez le support de votre hébergeur si vous rencontrez des erreurs aléatoires.",
	'config-diff3-bad' => 'GNU diff3 introuvable.',
	'config-imagemagick' => "ImageMagick trouvé : <code>$1</code>.
La miniaturisation d'images sera activée si vous activez le téléversement de fichiers.",
	'config-gd' => "La bibliothèque graphique GD intégrée a été trouvée.
La miniaturisation d'images sera activée si vous activez le téléversement de fichiers.",
	'config-no-scaling' => "Impossible de trouver la bibliothèque GD ou ImageMagick.
La miniaturisation d'images sera désactivé.",
	'config-no-uri' => "'''Erreur :''' Impossible de déterminer l'URI du script actuel.
Installation avortée.",
	'config-no-cli-uri' => "'''Attention''': Aucun --scriptpath n'a été spécifié; <code>$1</code> sera utilisé par défaut",
	'config-using-server' => 'Utilisation du nom de serveur "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Utilisation de l\'URL de serveur "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''Attention:''' Votre répertoire par défaut pour les téléchargements, <code>$1</code>, est vulnérable, car il peut exécuter n'importe quel script.
Bien que MediaWiki vérifie tous les fichiers téléchargés, il est fortement recommandé de [//www.mediawiki.org/wiki/Manual:Security#Upload_security fermer cette vulnérabilité de sécurité] (texte en anglais) avant d'activer les téléchargements.",
	'config-no-cli-uploads-check' => "'''Attention:''' Votre répertoire par défaut pour les imports(<code>$1</code>) n'est pas contrôlé concernant la vulnérabilité d'exécution de scripts arbitraires lors de l'installation CLI.",
	'config-brokenlibxml' => 'Votre système utilise une combinaison de versions de PHP et libxml2 qui est boguée et peut engendrer des corruptions cachées de données dans MediaWiki et d’autres applications web.
Veuillez mettre à jour votre système vers PHP 5.2.9 ou plus récent et libxml2 2.7.3 ou plus récent ([//bugs.php.net/bug.php?id=45996 bogue déposé auprès de PHP]).
Installation interrompue.',
	'config-using531' => 'MediaWiki ne peut pas être utilisé avec PHP $1 à cause d’un bogue affectant les paramètres passés par référence à <code>__call()</code>.
Veuillez mettre à jour votre système vers PHP 5.3.2 ou plus récent ou revenir à PHP 5.3.0 pour résoudre ce problème.
Installation interrompue.',
	'config-suhosin-max-value-length' => 'Suhosin est installé et limite la longueur du paramètre GET à $1 octets. Le <code>ResourceLoader</code> de MediaWiki va répondre en respectant cette limite, mais ses performances seront dégradées. Si possible, vous devriez définir <code>suhosin.get.max_value_length</code> à 1024 ou plus dans le fichier <code>php.ini</code>, et fixer <code>$wgResourceLoaderMaxQueryLength</code> à la même valeur dans <code>LocalSettings.php</code>.',
	'config-db-type' => 'Type de base de données :',
	'config-db-host' => 'Nom d’hôte de la base de données :',
	'config-db-host-help' => 'Si votre serveur de base de données est sur un serveur différent, saisissez ici son nom d’hôte ou son adresse IP.

Si vous utilisez un hébergement mutualisé, votre hébergeur doit vous avoir fourni le nom d’hôte correct dans sa documentation.

Si vous installez sur un serveur Windows et utilisez MySQL, « localhost » peut ne pas fonctionner comme nom de serveur. S’il ne fonctionne pas, essayez « 127.0.0.1 » comme adresse IP locale.

Si vous utilisez PostgreSQL, laissez ce champ vide pour vous connecter via un socket Unix.',
	'config-db-host-oracle' => 'Nom TNS de la base de données :',
	'config-db-host-oracle-help' => 'Entrez un [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm nom de connexion locale] valide ; un fichier tnsnames.ora doit être visible par cette installation.<br /> Si vous utilisez les bibliothèques clientes version 10g ou plus récentes, vous pouvez également utiliser la méthode de nommage [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identifier ce wiki',
	'config-db-name' => 'Nom de la base de données :',
	'config-db-name-help' => "Choisissez un nom qui identifie votre wiki.
Il ne doit pas contenir d'espaces.

Si vous utilisez un hébergement web partagé, votre hébergeur vous fournira un nom spécifique de base de données à utiliser, ou bien vous permet de créer des bases de données via un panneau de contrôle.",
	'config-db-name-oracle' => 'Schéma de base de données :',
	'config-db-account-oracle-warn' => "Il existe trois scénarios pris en charge pour l’installation d'Oracle comme backend de base :

Si vous souhaitez créer un compte de base de données dans le cadre de la procédure d’installation, veuillez fournir un compte avec le rôle de SYSDBA comme compte de base de données pour l’installation et spécifiez les informations d’identification souhaitées pour le compte d'accès au web, sinon vous pouvez créer le compte d’accès web manuellement et fournir uniquement ce compte (si elle a exigé des autorisations nécessaires pour créer les objets de schéma) ou fournir deux comptes différents, l’un avec les privilèges de créer et une restreinte pour l’accès web.

Un script pour créer un compte avec des privilèges requis peut être trouvé dans le répertoire « entretien/oracle/ » de cette installation. N’oubliez pas que le fait de l’utilisation d’un compte limité désactive toutes les fonctionnalités d’entretien avec le compte par défaut.",
	'config-db-install-account' => "Compte d'utilisateur pour l'installation",
	'config-db-username' => 'Nom d’utilisateur de la base de données :',
	'config-db-password' => 'Mot de passe de la base de données :',
	'config-db-password-empty' => "Veuillez entrer un mot de passe pour le nouvel compte de la base de données : $1.
Bien qu'il soit possible de créer un compte sans mot de passe, ce n'est pas recommandé pour des questions de sécurité.",
	'config-db-install-username' => "Entrez le nom d’utilisateur qui sera utilisé pour se connecter à la base de données pendant le processus d'installation. Il ne s’agit pas du nom d’utilisateur du compte MediaWiki, mais du nom d’utilisateur pour votre base de données.",
	'config-db-install-password' => "Entrez le mot de passe qui sera utilisé pour se connecter à la base de données pendant le processus d'installation. Il ne s’agit pas du mot de passe du compte MediaWiki, mais du mot de passe pour votre base de données.",
	'config-db-install-help' => "Entrez le nom d'utilisateur et le mot de passe qui seront utilisés pour se connecter à la base de données pendant le processus d'installation.",
	'config-db-account-lock' => "Utiliser le même nom d'utilisateur et le même mot de passe pendant le fonctionnement habituel",
	'config-db-wiki-account' => "Compte d'utilisateur pour le fonctionnement habituel",
	'config-db-wiki-help' => "Entrez le nom d'utilisateur et le mot de passe qui seront utilisés pour se connecter à la base de données pendant le fonctionnement habituel du wiki.
Si le compte n'existe pas, et le compte d'installation dispose de privilèges suffisants, ce compte d'utilisateur sera créé avec les privilèges minimum requis pour faire fonctionner le wiki.",
	'config-db-prefix' => 'Préfixe des tables de la base de données :',
	'config-db-prefix-help' => "Si vous avez besoin de partager une base de données entre plusieurs wikis, ou entre MediaWiki et une autre application Web, vous pouvez choisir d'ajouter un préfixe à tous les noms de table pour éviter les conflits.
Ne pas utiliser des espaces.

Ce champ est généralement laissé vide.",
	'config-db-charset' => 'Jeu de caractères de la base de données',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binaire',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 rétrocompatible UTF-8',
	'config-charset-help' => "'''Attention:''' Si vous utilisez ''backwards-compatible UTF-8'' sur MySQL 4.1+, et ensuite sauvegardez la base de données avec <code>mysqldump</code>, cela peut détruire tous les caractères non-ASCII, ce qui rend inutilisable vos copies de sauvegarde de façon irréversible !

En ''mode binaire'', MediaWiki stocke le texte UTF-8 dans des champs binaires de la base de données. C'est plus efficace que le ''mode UTF-8'' de MySQL, et vous permet d'utiliser toute la gamme des caractères Unicode.
En ''mode UTF-8'', MySQL connaîtra le jeu de caractères de vos données et pourra présenter et convertir les données de manière appropriée, mais il ne vous laissera pas stocker les caractères au-dessus du [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plan multilingue de base] (en anglais).",
	'config-mysql-old' => 'MySQL $1 ou version ultérieure est requis, vous avez $2.',
	'config-db-port' => 'Port de la base de données :',
	'config-db-schema' => 'Schéma pour MediaWiki',
	'config-db-schema-help' => "Les schémas ci-dessus sont généralement corrects.
Ne les changez que si vous êtes sûr que c'est nécessaire.",
	'config-pg-test-error' => "Impossible de se connecter à la base de données '''$1''' : $2",
	'config-sqlite-dir' => 'Dossier des données SQLite :',
	'config-sqlite-dir-help' => "SQLite stocke toutes les données dans un fichier unique.

Le répertoire que vous inscrivez doit être accessible en écriture par le serveur lors de l'installation.

Il '''ne faut pas''' qu'il soit accessible via le web, c'est pourquoi il n'est pas à l'endroit où vos fichiers PHP sont.

L'installateur écrira un fichier <code>.htaccess</code> en même temps, mais s'il y a échec, quelqu'un peut accéder à votre base de données.
Cela comprend les données des utilisateurs (adresses de courriel, mots de passe hachés) ainsi que des révisions supprimées et d'autres données confidentielles du wiki.

Envisagez de placer la base de données ailleurs, par exemple dans <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => "Espace de stockage (''tablespace'') par défaut :",
	'config-oracle-temp-ts' => "Espace de stockage (''tablespace'') temporaire :",
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => "MediaWiki supporte ces systèmes de bases de données :

$1

Si vous ne voyez pas le système de base de données que vous essayez d'utiliser ci-dessous, alors suivez les instructions ci-dessus (voir liens) pour activer le support.",
	'config-support-mysql' => '* $1 est le premier choix pour MediaWiki et est mieux pris en charge ([http://www.php.net/manual/en/mysql.installation.php how to compile PHP with MySQL support])',
	'config-support-postgres' => "* $1 est un système de base de données populaire et ''open source'' qui peut être une alternative à MySQL ([http://www.php.net/manual/en/pgsql.installation.php how to compile PHP with PostgreSQL support]). Il peut contenir quelques bogues mineurs et n'est pas recommandé dans un environnement de production.",
	'config-support-sqlite' => '* $1 est un système de base de données léger qui est bien supporté. ([http://www.php.net/manual/en/pdo.installation.php How to compile PHP with SQLite support], utilise PDO)',
	'config-support-oracle' => '* $1 est un système commercial de gestion de base de données d’entreprise. ([http://www.php.net/manual/en/oci8.installation.php Comment compiler PHP avec le support OCI8])',
	'config-support-ibm_db2' => "* $1 est une base de données d'entreprise commerciale.",
	'config-header-mysql' => 'Paramètres de MySQL',
	'config-header-postgres' => 'Paramètres de PostgreSQL',
	'config-header-sqlite' => 'Paramètres de SQLite',
	'config-header-oracle' => 'Paramètres d’Oracle',
	'config-header-ibm_db2' => 'paramètres de IBM DB2',
	'config-invalid-db-type' => 'Type de base de données non valide',
	'config-missing-db-name' => 'Vous devez saisir une valeur pour « Nom de la base de données »',
	'config-missing-db-host' => "Vous devez entrer une valeur pour « l'hôte de la base de données »",
	'config-missing-db-server-oracle' => 'Vous devez saisir une valeur pour le « Nom TNS de la base de données »',
	'config-invalid-db-server-oracle' => 'Le nom TNS de la base de données (« $1 ») est invalide.
Il ne peut contenir que des lettres latines de base (a-z, A-Z), des chiffres (0-9), des caractères de soulignement (_) et des points (.).',
	'config-invalid-db-name' => 'Nom de la base de données invalide (« $1 »).
Il ne peut contenir que des lettres latines (a-z, A-Z), des chiffres (0-9), des caractères de soulignement (_) et des tirets (-).',
	'config-invalid-db-prefix' => 'Préfixe de la base de données non valide « $1 ».
Il ne peut contenir que des lettres latines (a-z, A-Z), des chiffres (0-9), des caractères de soulignement (_) et des tirets (-).',
	'config-connection-error' => '$1.

Vérifier le nom d’hôte, le nom d’utilisateur et le mot de passe ci-dessous puis réessayer.',
	'config-invalid-schema' => 'Schéma invalide pour MediaWiki « $1 ».
Utilisez seulement des lettres latines (a-z, A-Z), des chiffres (0-9) et des caractères de soulignement (_).',
	'config-db-sys-create-oracle' => "L'installateur ne reconnaît que les compte SYSDBA lors de la création d'un nouveau compte.",
	'config-db-sys-user-exists-oracle' => 'Le compte « $1 » existe déjà. Un SYSDBA peut seulement servir à créer un nouveau compte.',
	'config-postgres-old' => 'PostgreSQL $1 ou version ultérieure est requis, vous avez $2.',
	'config-sqlite-name-help' => "Choisir un nom qui identifie votre wiki.
Ne pas utiliser des espaces ou des traits d'union.
Il sera utilisé pour le fichier de données SQLite.",
	'config-sqlite-parent-unwritable-group' => "Impossible de créer le répertoire de données <nowiki><code>$1</code></nowiki>, parce que le répertoire parent <nowiki><code>$2</code></nowiki> n'est pas accessible en écriture par le serveur Web.

L'utilisateur du serveur web est connu.
Rendre le répertoire <nowiki><code>$3</code></nowiki> accessible en écriture pour continuer.
Sur un système UNIX/Linux, saisir :

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>",
	'config-sqlite-parent-unwritable-nogroup' => "Impossible de créer le répertoire de données <nowiki><code>$1</code></nowiki>, parce que le répertoire parent <nowiki><code>$2</code></nowiki> n'est pas accessible en écriture par le serveur Web.

L'utilisateur du serveur web est inconnu.
Rendre le répertoire <nowiki><code>$3</code></nowiki> globalement accessible en écriture pour continuer.
Sur un système UNIX/Linux, saisir :

<pre>cd $2
mkdir $3
chmod a+w $3</pre>",
	'config-sqlite-mkdir-error' => "Erreur de création du répertoire de données « $1 ».
Vérifiez l'emplacement et essayez à nouveau.",
	'config-sqlite-dir-unwritable' => "Impossible d'écrire dans le répertoire « $1 ».
Changer les permissions de sorte que le serveur peut y écrire et essayez à nouveau.",
	'config-sqlite-connection-error' => '$1.

Vérifier le répertoire des données et le nom de la base de données ci-dessous et réessayer.',
	'config-sqlite-readonly' => "Le fichier <code>$1</code> n'est pas accessible en écriture.",
	'config-sqlite-cant-create-db' => 'Impossible de créer le fichier de base de données <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP ne vient pas avec FTS3, les tables sont diminuées.',
	'config-can-upgrade' => "Il y a des tables MediaWiki dans cette base de données.
Pour les mettre au niveau de MediaWiki $1, cliquez sur '''Continuer'''.",
	'config-upgrade-done' => "Mise à jour complétée.

Vous pouvez maintenant [$1 commencer à utiliser votre wiki].

Si vous souhaitez régénérer votre fichier <code>LocalSettings.php</code>, cliquez sur le bouton ci-dessous.
Ce '''n'est pas recommandé''' sauf si vous rencontrez des problèmes avec votre wiki.",
	'config-upgrade-done-no-regenerate' => 'Mise à jour terminée.

Vous pouvez maintenant [$1 commencer à utiliser votre wiki].',
	'config-regenerate' => 'Regénérer LocalSettings.php →',
	'config-show-table-status' => 'Échec de la requête SHOW TABLE STATUS !',
	'config-unknown-collation' => "'''Attention:''' La base de données effectue un classement alphabétique (''collation'') inconnu.",
	'config-db-web-account' => "Compte de la base de données pour l'accès Web",
	'config-db-web-help' => "Sélectionnez le nom d'utilisateur et le mot de passe que le serveur web utilisera pour se connecter au serveur de base de données pendant le fonctionnement habituel du wiki.",
	'config-db-web-account-same' => "Utilisez le même compte que pour l'installation",
	'config-db-web-create' => "Créez le compte s'il n'existe pas déjà",
	'config-db-web-no-create-privs' => "Le compte que vous avez spécifié pour l'installation n'a pas de privilèges suffisants pour créer un compte.
Le compte que vous spécifiez ici doit déjà exister.",
	'config-mysql-engine' => 'Moteur de stockage :',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "''' Avertissement ''': vous avez sélectionné MyISAM comme moteur de stockage pour MySQL, ce qui n'est pas recommandé pour une utilisation avec MediaWiki, parce que:
 * il supporte à peine la simultanéité en raison de verrouillage de table
 * il est plus sujet à la corruption que les autres moteurs
 * le codebase MediaWiki ne gère pas toujours MyISAM comme il se doit
Si votre installation MySQL supporte InnoDB, il est fortement recommandé que vous le choisissez plutôt. Si votre installation MySQL ne supporte pas les tables InnoDB, il est peut-être temps de faire une mise à niveau.",
	'config-mysql-engine-help' => "'''InnoDB''' est presque toujours la meilleure option, car il supporte bien l'[http://fr.wikipedia.org/wiki/Ordonnancement_dans_les_syst%C3%A8mes_d%27exploitation ordonnancement].

'''MyISAM''' peut être plus rapide dans les installations monoposte ou en lecture seule. Les bases de données MyISAM ont tendance à se corrompre plus souvent que celles d'InnoDB.",
	'config-mysql-charset' => 'Jeu de caractères de la base de données :',
	'config-mysql-binary' => 'Binaire',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "En ''mode binaire'', MediaWiki stocke le texte au format UTF-8 dans la base de données. C'est plus efficace que le ''UTF-8 mode'' de MySQL, et vous permet d'utiliser toute la gamme des caractères Unicode.

En ''mode binaire'', MediaWiki stocke le texte UTF-8 dans des champs binaires de la base de données. C'est plus efficace que le ''mode UTF-8'' de MySQL, et vous permet d'utiliser toute la gamme des caractères Unicode.
En ''mode UTF-8'', MySQL connaîtra le jeu de caractères de vos données et pourra présenter et convertir les données de manière appropriée, mais il ne vous laissera pas stocker les caractères au-dessus du [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plan multilingue de base] (en anglais).",
	'config-ibm_db2-low-db-pagesize' => "Votre base de données DB2 a un espace de stockage par défaut avec un pagesize insuffisant. Le pagesize doit être au minimum '''32K'''.",
	'config-site-name' => 'Nom du wiki :',
	'config-site-name-help' => 'Il apparaîtra dans la barre de titre du navigateur et en divers autres endroits.',
	'config-site-name-blank' => 'Entrez un nom de site.',
	'config-project-namespace' => 'Espace de noms du projet :',
	'config-ns-generic' => 'Projet',
	'config-ns-site-name' => 'Même nom que le wiki : $1',
	'config-ns-other' => 'Autre (préciser)',
	'config-ns-other-default' => 'MonWiki',
	'config-project-namespace-help' => "Suivant l'exemple de Wikipédia, plusieurs wikis gardent leurs pages de politique séparées de leurs pages de contenu, dans un ''espace de noms'' propre.
Tous les titres de page de cet espace de noms commence par un préfixe défini, que vous pouvez spécifier ici.
Traditionnellement, ce préfixe est dérivé du nom du wiki, mais il ne peut contenir des caractères de ponctuation tels que « # » ou « : ».",
	'config-ns-invalid' => "L'espace de noms spécifié « <nowiki>$1</nowiki> » n'est pas valide.
Spécifiez un espace de noms pour le projet.",
	'config-ns-conflict' => "L'espace de noms spécifié « <nowiki>$1</nowiki> » est en conflit avec un espace de noms par défaut de MediaWiki.
Choisir un autre espace de noms.",
	'config-admin-box' => 'Compte administrateur',
	'config-admin-name' => 'Votre nom :',
	'config-admin-password' => 'Mot de passe :',
	'config-admin-password-confirm' => 'Saisir à nouveau le mot de passe :',
	'config-admin-help' => "Entrez votre nom d'utilisateur préféré ici, par exemple « Jean Blogue ».
C'est le nom que vous utiliserez pour vous connecter au wiki.",
	'config-admin-name-blank' => "Entrez un nom d'administrateur.",
	'config-admin-name-invalid' => "Le nom d'utilisateur spécifié « <nowiki>$1</nowiki> » n'est pas valide.
Indiquez un nom d'utilisateur différent.",
	'config-admin-password-blank' => 'Entrez un mot de passe pour le compte administrateur.',
	'config-admin-password-same' => "Le mot de passe doit être différent du nom d'utilisateur.",
	'config-admin-password-mismatch' => 'Les deux mots de passe que vous avez saisis ne correspondent pas.',
	'config-admin-email' => 'Adresse de courriel :',
	'config-admin-email-help' => "Entrez une adresse de courriel ici pour vous permettre de recevoir des courriels d'autres utilisateurs du wiki, réinitialiser votre mot de passe, et être informé des modifications apportées aux pages de votre liste de suivi. Vous pouvez laisser ce champ vide.",
	'config-admin-error-user' => "Erreur interne lors de la création d'un administrateur avec le nom « <nowiki>$1</nowiki> ».",
	'config-admin-error-password' => "Erreur interne lors de l'inscription d'un mot de passe pour l'administrateur « <nowiki>$1</nowiki> » : <pre>$2</pre>",
	'config-admin-error-bademail' => 'Vous avez entré une adresse de courriel invalide',
	'config-subscribe' => "Abonnez-vous à la [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce liste d'annonce des nouvelles versions] (la page peut afficher le texte en français).",
	'config-subscribe-help' => "Il s'agit d'une liste de diffusion à faible volume utilisée servant à annoncer les nouvelles versions, y compris les versions améliorant la sécurité du logiciel.
Vous devriez y souscrire et mettre à jour votre version de MediaWiki lorsque de nouvelles versions sont publiées.",
	'config-subscribe-noemail' => "Vous avez essayé de vous abonner à la liste de diffusion des communiqués, sans fournir une adresse courriel ! S'il vous plaît, fournir une adresse électronique si vous souhaitez vous abonner à la liste de diffusion.",
	'config-almost-done' => 'Vous avez presque fini !
Vous pouvez passer la configuration restante et installer immédiatement le wiki.',
	'config-optional-continue' => 'Me poser davantage de questions.',
	'config-optional-skip' => 'J’en ai assez, installer simplement le wiki.',
	'config-profile' => 'Profil des droits d’utilisateurs :',
	'config-profile-wiki' => 'Wiki traditionnel',
	'config-profile-no-anon' => 'Création de compte requise',
	'config-profile-fishbowl' => 'Éditeurs autorisés seulement',
	'config-profile-private' => 'Wiki privé',
	'config-profile-help' => "Les wikis fonctionnent mieux lorsque vous laissez le plus de personnes possible le modifier.
Avec MediaWiki, il est facile de vérifier les modifications récentes et de révoquer tout dommage créé par des utilisateurs débutants ou mal intentionnés.

Cependant, de nombreuses autres utilisations ont été trouvées au logiciel et il n’est pas toujours facile de convaincre tout le monde des bénéfices de l’esprit wiki.
Vous avez donc le choix.

'''{{int:config-profile-wiki}}''' autorise toute personne à modifier, y compris sans s’identifier.
'''{{int:config-profile-no-anon}}''' fournit plus de contrôle, par l’identification, mais peut rebuter les contributeurs occasionnels.

'''{{int:config-profile-fishbowl}}''' autorise la modification par les utilisateurs approuvés, mais le public peut toujours lire les pages et leur historique.
'''{{int:config-profile-private}}''' n’autorise que les utilisateurs approuvés à voir et modifier les pages.

Des configurations de droits d’utilisateurs plus complexes sont disponibles après l'installation, voir la [//www.mediawiki.org/wiki/Manual:User_rights page correspondante du manuel].",
	'config-license' => "Droits d'auteur et licence :",
	'config-license-none' => 'Aucune licence en bas de page',
	'config-license-cc-by-sa' => "Creative Commons attribution partage à l'identique",
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons paternité – non commercial – partage à l’identique',
	'config-license-cc-0' => 'Creative Commons Zero (domaine public)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 ou ultérieure',
	'config-license-pd' => 'Domaine public',
	'config-license-cc-choose' => 'Sélectionner une licence Creative Commons personnalisée',
	'config-license-help' => "Beaucoup de wikis publics mettent l'ensemble des contributions sous [http://freedomdefined.org/Definition/Fr licence libre].
Cela contribue à créer un sentiment d'appartenance dans leur communauté et encourage les contributions sur le long terme.
Ce n'est généralement pas nécessaire pour un wiki privé ou d'entreprise.

Si vous souhaitez utiliser des textes de Wikipédia, et souhaitez que Wikipédia réutilise des textes de votre wiki, vous devriez choisir la [http://creativecommons.org/licenses/by-sa/3.0/deed.fr licence ''Creative Commons Attribution Share Alike''] (CC-by-sa).

Wikipédia a déjà été publié selon les termes de la [http://fr.wikipedia.org/wiki/Licence_de_documentation_libre_GNU ''GNU Free Documentation License''] (GFDL).
C'est une licence valide, mais elle est difficile à comprendre. De plus, elle possède des caractéristiques qui rendent difficiles la réutilisation.",
	'config-email-settings' => 'Paramètres de courriel',
	'config-enable-email' => 'Activer les courriels sortants',
	'config-enable-email-help' => 'Si vous souhaitez utiliser le courriel, vous devez [http://www.php.net/manual/en/mail.configuration.php configurer des paramètres PHP] (texte en anglais).
Si vous ne voulez pas du service de courriel, vous pouvez le désactiver ici.',
	'config-email-user' => "Activer les courriers électroniques d'utilisateur à utilisateur",
	'config-email-user-help' => "Permet à tous les utilisateurs d'envoyer des courriels à d'autres utilisateurs si cela est activé dans leurs préférences.",
	'config-email-usertalk' => 'Activer la notification des pages de discussion des utilisateurs',
	'config-email-usertalk-help' => 'Permet aux utilisateurs de recevoir une notification en cas de modification de leurs pages de discussion, si cela est activé dans leurs préférences.',
	'config-email-watchlist' => 'Activer la notification de la liste de suivi',
	'config-email-watchlist-help' => "Permet aux utilisateurs de recevoir des notifications à propos des pages qu'ils ont en suivi (si cette préférence est activée).",
	'config-email-auth' => "Activer l'authentification par courriel",
	'config-email-auth-help' => "Si cette option est activée, les utilisateurs doivent confirmer leur adresse de courriel en utilisant l'hyperlien envoyé à chaque fois qu'ils la définissent ou la modifient.
Seules les adresses authentifiées peuvent recevoir des courriels des autres utilisateurs ou lorsqu'il y a des notifications de modification.
L'activation de cette option est '''recommandée''' pour les wikis publics en raison d'abus potentiels des fonctionnalités de courriels.",
	'config-email-sender' => 'Adresse de courriel de retour :',
	'config-email-sender-help' => "Entrez l'adresse de courriel à utiliser comme adresse de retour des courriels sortant.
Les courriels rejetés y seront envoyés.
De nombreux serveurs de courriels exigent au moins un [http://fr.wikipedia.org/wiki/Nom_de_domaine nom de domaine] valide.",
	'config-upload-settings' => 'Téléchargement des images et des fichiers',
	'config-upload-enable' => 'Activer le téléchargement des fichiers',
	'config-upload-help' => "Le téléchargement des fichiers expose votre serveur à des risques de sécurité.
Pour plus d'informations, lire la section [//www.mediawiki.org/wiki/Manual:Security ''Security''] du manuel d'installation (en anglais).

Pour autoriser le téléchargement des fichiers, modifier le mode du sous-répertoire <code>images</code> qui se situe sous le répertoire racine de MediaWiki.
Ensuite, activez cette option.",
	'config-upload-deleted' => 'Répertoire pour les fichiers supprimés :',
	'config-upload-deleted-help' => 'Choisissez un répertoire qui servira à archiver les fichiers supprimés.
Idéalement, il ne devrait pas être accessible depuis le web.',
	'config-logo' => 'URL du logo :',
	'config-logo-help' => "L'habillage (''skin'') par défaut de MediaWiki comprend l'espace pour un logo de 135x160 pixels dans le coin supérieur gauche.
Téléchargez une image de la taille appropriée, et entrez l'URL ici.

Si vous ne voulez pas d'un logo, laissez cette case vide.",
	'config-instantcommons' => "Activer ''InstantCommons''",
	'config-instantcommons-help' => "[//www.mediawiki.org/wiki/InstantCommons InstantCommons] est un service qui permet d'utiliser les images, les sons et les autres médias disponibles sur le site [//commons.wikimedia.org/ Wikimedia Commons].
Pour se faire, il faut que MediaWiki accède à Internet.

Pour plus d'informations sur ce service, y compris les instructions sur la façon de le configurer pour d'autres wikis que Wikimedia Commons, consultez le [//mediawiki.org/wiki/Manual:\$wgForeignFileRepos manuel] (en anglais).",
	'config-cc-error' => "Le sélection d'une licence ''Creative Commons'' n'a donné aucun résultat.
Entrez le nom de la licence manuellement.",
	'config-cc-again' => 'Choisissez à nouveau...',
	'config-cc-not-chosen' => "Choisissez une licence ''Creative Commons'' et cliquez sur « Continuer ».",
	'config-advanced-settings' => 'Configuration avancée',
	'config-cache-options' => 'Paramètres pour la mise en cache des objets:',
	'config-cache-help' => "La mise en cache des objets améliore la vitesse de MediaWiki en mettant en cache les données fréquemment utilisées.
Les sites de taille moyenne à grande sont fortement encouragés à l'activer. Les petits sites y verront également des avantages.",
	'config-cache-none' => 'Aucune mise en cache (aucune fonctionnalité supprimée, mais la vitesse peut changer sur les wikis importants)',
	'config-cache-accel' => 'Mise en cache des objets PHP (APC, XCache ou WinCache)',
	'config-cache-memcached' => 'Utiliser Memcached (nécessite une installation et une configuration supplémentaires)',
	'config-memcached-servers' => 'serveurs pour Memcached :',
	'config-memcached-help' => 'Liste des adresses IP à utiliser pour Memcached.
Elles doivent être séparés par des virgules et vous devez spécifier le port à utiliser. Par exemple :
  127.0.0.1:11211
  192.168.1.25:1234',
	'config-memcache-needservers' => 'Vous avez sélectionné Memcached comme type de cache, mais ne précisez pas de serveur.',
	'config-memcache-badip' => 'Vous avez entré une adresse IP invalide pour Memcached: $1.',
	'config-memcache-noport' => "Vous n'avez pas entré un port pour le serveur Memcached : $1.
Si vous ne le connaissez pas, la valeur par défaut est 11211.",
	'config-memcache-badport' => 'Les numéros de port de Memcached sont situés entre $1 et $2.',
	'config-extensions' => 'Extensions',
	'config-extensions-help' => 'Les extensions énumérées ci-dessus ont été détectées dans votre répertoire <code>./extensions</code>.

Elles peuvent nécessiter une configuration supplémentaire, mais vous pouvez les activer maintenant',
	'config-install-alreadydone' => "'''Attention''': Vous semblez avoir déjà installé MediaWiki et tentez de l'installer à nouveau.
S'il vous plaît, allez à la page suivante.",
	'config-install-begin' => "En appuyant sur {{int:config-continue}}, vous commencerez l'installation de MediaWiki.
Si vous voulez apporter des modifications, appuyez sur Retour.",
	'config-install-step-done' => 'fait',
	'config-install-step-failed' => 'échec',
	'config-install-extensions' => 'Inclusion des extensions',
	'config-install-database' => 'Création de la base de données',
	'config-install-schema' => 'Création de schéma',
	'config-install-pg-schema-not-exist' => "Le schéma PostgreSQL n'existe pas",
	'config-install-pg-schema-failed' => "Échec lors de la création des tables.
Assurez-vous que l'utilisateur « $1 » peut écrire selon le schéma « $2 ».",
	'config-install-pg-commit' => 'Validation des modifications',
	'config-install-pg-plpgsql' => 'Vérification du langage PL/pgSQL',
	'config-pg-no-plpgsql' => 'Vous devez installer le langage PL/pgSQL dans la base de données $1',
	'config-pg-no-create-privs' => "Le compte que vous avez spécifié pour l'installation n'a pas suffisamment de privilèges pour créer un compte.",
	'config-pg-not-in-role' => "Le compte que vous avez spécifié pour l'utilisateur web existe déjà !
Le compte que vous avez spécifié pour l'installation n'est pas un super-utilisateur et n'est pas membre du rôle de l'internaute, il est donc incapable de créer des objets appartenant à l'utilisateur web.!

MediaWiki exige actuellement que les tableaux soient possédés par un utilisateur web. S'il vous plaît, spécifier un autre nom de compte web, ou cliquez sur \"retour\" et spécifier un utilisateur avec les privilèges suffisants.",
	'config-install-user' => "Création d'un utilisateur de la base de données",
	'config-install-user-alreadyexists' => "L'utilisateur « $1 » existe déjà.",
	'config-install-user-create-failed' => "Échec lors de la création de l'utilisateur « $1 » : $2",
	'config-install-user-grant-failed' => "Échec lors de l'ajout de permissions à l'utilisateur « $1 » : $2",
	'config-install-user-missing' => 'L\'utilisateur "$1" n\'existe pas.',
	'config-install-user-missing-create' => 'L\'utilisateur "$1" n\'existe pas !
S\'il vous plaît, cocher "Compte de créer" dans la case ci-dessous si vous voulez le créer.',
	'config-install-tables' => 'Création des tables',
	'config-install-tables-exist' => "'''Avertissement:''' Les tables MediaWiki semblent déjà exister.
Création omise.",
	'config-install-tables-failed' => "'''Erreur:''' échec lors de la création de la table avec l'erreur suivante: $1",
	'config-install-interwiki' => 'Remplissage par défaut de la table des interwikis',
	'config-install-interwiki-list' => 'Impossible de trouver le fichier <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Attention:''' La table des interwikis semble déjà contenir des entrées.
La liste par défaut ne sera pas inscrite.",
	'config-install-stats' => 'Initialisation des statistiques',
	'config-install-keys' => 'Génération de la clé secrète',
	'config-insecure-keys' => "'''Avertissement''' : {{PLURAL:$2|Une clé de sécurité générée ($1) pendant l'installation n'est pas complètement sécuritaire. Envisagez de la modifier manuellement.|Des clés de sécurité générées ($1) pendant l'installation ne sont pas complètement sécuritaires. Envisagez de les modifier manuellement.}}",
	'config-install-sysop' => 'Création du compte administrateur',
	'config-install-subscribe-fail' => "Impossible de s'abonner à mediawiki-announce : $1",
	'config-install-subscribe-notpossible' => 'cURL n’est pas installé et allow_url_fopen n’est pas disponible.',
	'config-install-mainpage' => 'Création de la page principale avec un contenu par défaut',
	'config-install-extension-tables' => 'Création de tables pour les extensions activées',
	'config-install-mainpage-failed' => 'Impossible d’insérer la page principale: $1',
	'config-install-done' => "'''Félicitations!'''
Vous avez réussi à installer MediaWiki.

Le programme d'installation a généré <code>LocalSettings.php</code>, un fichier qui contient tous les paramètres de configuration.

Si le téléchargement n'a pas été offert, ou que vous l'avez annulé, vous pouvez démarrer à nouveau le téléchargement en cliquant ce lien :

$3

'''Note''': Si vous ne le faites pas maintenant, ce fichier de configuration généré ne sera pas disponible plus tard si vous quittez l'installation sans le télécharger.

Lorsque c'est fait, vous pouvez '''[$2 accéder à votre wiki]'''.",
	'config-download-localsettings' => 'Télécharger LocalSettings.php',
	'config-help' => 'aide',
	'config-nofile' => 'Le fichier « $1 » est introuvable. A-t-il été supprimé ?',
	'mainpagetext' => "'''MediaWiki a été installé avec succès.'''",
	'mainpagedocfooter' => 'Consultez le [//meta.wikimedia.org/wiki/Aide:Contenu Guide de l’utilisateur] pour plus d’informations sur l’utilisation de ce logiciel.

== Démarrer avec MediaWiki ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liste des paramètres de configuration]
* [//www.mediawiki.org/wiki/Manual:FAQ/fr FAQ sur MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Liste de discussion sur les distributions de MediaWiki]',
);

/** Cajun French (français cadien)
 */
$messages['frc'] = array(
	'mainpagetext' => "'''Vous avez bien installé MediaWiki.'''",
	'mainpagedocfooter' => 'Lisez la [//meta.wikimedia.org/wiki/Help:Contents Guide des Useurs] pour apprendre à user le wiki software.

== Pour Commencer ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Réglage]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki: Questions Souvent Posées]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki Liste à Malle]',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'config-desc' => 'La programeria d’enstalacion de MediaWiki',
	'config-title' => 'Enstalacion de MediaWiki $1',
	'config-information' => 'Enformacions',
	'config-localsettings-key' => 'Cllâf de misa a jorn :',
	'config-session-error' => 'Èrror pendent l’emmodâ de la sèance : $1',
	'config-your-language' => 'Voutra lengoua :',
	'config-wiki-language' => 'Lengoua du vouiqui :',
	'config-back' => '← Retôrn',
	'config-continue' => 'Continuar →',
	'config-page-language' => 'Lengoua',
	'config-page-welcome' => 'Benvegnua dessus MediaWiki !',
	'config-page-dbconnect' => 'Sè branchiér a la bâsa de balyês',
	'config-page-upgrade' => 'Betar a jorn l’enstalacion ègzistenta',
	'config-page-dbsettings' => 'Paramètres de la bâsa de balyês',
	'config-page-name' => 'Nom',
	'config-page-options' => 'Chouèx',
	'config-page-install' => 'Enstalar',
	'config-page-complete' => 'Chavonâ !',
	'config-page-restart' => 'Tornar emmodar l’enstalacion',
	'config-page-readme' => 'Liéséd-mè',
	'config-page-releasenotes' => 'Notes de publecacion',
	'config-page-copying' => 'Copia',
	'config-page-upgradedoc' => 'Misa a jorn',
	'config-page-existingwiki' => 'Vouiqui ègzistent',
	'config-env-php' => 'PHP $1 est enstalâ.',
	'config-env-php-toolow' => 'PHP $1 est enstalâ.
Portant, MediaWiki at fôta de PHP $2 ou ben ples hôt.',
	'config-memory-raised' => 'Lo paramètre <code>memory_limit</code> de PHP ére a $1, portâ a $2.',
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] est enstalâ',
	'config-apc' => '[http://www.php.net/apc APC] est enstalâ',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] est enstalâ',
	'config-diff3-bad' => 'GNU diff3 entrovâblo.',
	'config-db-type' => 'Tipo de bâsa de balyês :',
	'config-db-host' => 'Hôto de la bâsa de balyês :',
	'config-db-host-oracle' => 'TNS de la bâsa de balyês :',
	'config-db-wiki-settings' => 'Identifiar cél vouiqui',
	'config-db-name' => 'Nom de la bâsa de balyês :',
	'config-db-name-oracle' => 'Plan de bâsa de balyês :',
	'config-db-install-account' => 'Compto usanciér por l’enstalacion',
	'config-db-username' => 'Nom d’usanciér de la bâsa de balyês :',
	'config-db-password' => 'Contresegno de la bâsa de balyês :',
	'config-db-wiki-account' => 'Compto usanciér por l’opèracion normala',
	'config-db-prefix' => 'Prèfixo de les trâbles de la bâsa de balyês :',
	'config-db-charset' => 'Juè de caractèros de la bâsa de balyês',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binèro',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 rètrocompatiblo UTF-8',
	'config-mysql-old' => 'MySQL $1 ou ben ples novél est nècèssèro, vos avéd $2.',
	'config-db-port' => 'Pôrt de la bâsa de balyês :',
	'config-db-schema' => 'Plan por MediaWiki',
	'config-pg-test-error' => "Empossiblo de sè branchiér a la bâsa de donâs '''$1''' : $2",
	'config-sqlite-dir' => 'Dossiér de les balyês SQLite :',
	'config-oracle-def-ts' => "Èspâço de stocâjo (''tablespace'') per dèfôt :",
	'config-oracle-temp-ts' => "Èspâço de stocâjo (''tablespace'') temporèro :",
	'config-type-ibm_db2' => 'IBM DB2',
	'config-header-mysql' => 'Paramètres de MySQL',
	'config-header-postgres' => 'Paramètres de PostgreSQL',
	'config-header-sqlite' => 'Paramètres de SQLite',
	'config-header-oracle' => 'Paramètres d’Oracle',
	'config-header-ibm_db2' => 'Paramètres d’IBM DB2',
	'config-invalid-db-type' => 'Tipo de bâsa de balyês envalido',
	'config-missing-db-name' => 'Vos dête buchiér una valor por « Nom de la bâsa de balyês »',
	'config-missing-db-host' => 'Vos dête buchiér una valor por « Hôto de la bâsa de balyês »',
	'config-missing-db-server-oracle' => 'Vos dête buchiér una valor por « TNS de la bâsa de balyês »',
	'config-sqlite-readonly' => 'Lo fichiér <code>$1</code> est pas accèssiblo en ècritura.',
	'config-regenerate' => 'Refâre LocalSettings.php →',
	'config-show-table-status' => 'Falyita de la requéta SHOW TABLE STATUS !',
	'config-db-web-account' => 'Compto de la bâsa de balyês por l’accès vouèbe',
	'config-db-web-account-same' => 'Utilisâd lo mémo compto que por l’enstalacion',
	'config-db-web-create' => 'Féte lo compto s’ègziste p’oncor',
	'config-mysql-engine' => 'Motor de stocâjo :',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Juè de caractèros de la bâsa de balyês :',
	'config-mysql-binary' => 'Binèro',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Nom du vouiqui :',
	'config-site-name-blank' => 'Buchiéd un nom de seto.',
	'config-project-namespace' => 'Èspâço de noms du projèt :',
	'config-ns-generic' => 'Projèt',
	'config-ns-site-name' => 'Mémo nom que lo vouiqui : $1',
	'config-ns-other' => 'Ôtro (spècefiar)',
	'config-ns-other-default' => 'MonVouiqui',
	'config-admin-box' => 'Compto administrator',
	'config-admin-name' => 'Voutron nom :',
	'config-admin-password' => 'Contresegno :',
	'config-admin-password-confirm' => 'Tornar buchiér lo contresegno :',
	'config-admin-name-blank' => 'Buchiéd un nom d’administrator.',
	'config-admin-password-blank' => 'Buchiéd un contresegno por lo compto administrator.',
	'config-admin-email' => 'Adrèce èlèctronica :',
	'config-optional-continue' => 'Mè posar més de quèstions.',
	'config-profile' => 'Profil des drêts d’usanciér :',
	'config-profile-wiki' => 'Vouiqui tradicionâl',
	'config-profile-no-anon' => 'Crèacion de compto nècèssèra',
	'config-profile-fishbowl' => 'Solament los èditors ôtorisâs',
	'config-profile-private' => 'Vouiqui privâ',
	'config-license' => 'Drêts d’ôtor et licence :',
	'config-license-none' => 'Gins de licence d’avâl la pâge',
	'config-license-cc-by-sa' => 'Creative Commons patèrnitât - partâjo a l’identico',
	'config-license-cc-by' => 'Creative Commons patèrnitât',
	'config-license-cc-by-nc-sa' => 'Creative Commons patèrnitât pas comèrciâla - partâjo a l’identico',
	'config-license-cc-0' => 'Creative Commons Zero (domêno publico)',
	'config-license-gfdl' => 'Licence de documentacion libra GNU 1.3 ou ben ples novèla',
	'config-license-pd' => 'Domêno publico',
	'config-license-cc-choose' => 'Chouèsir una licence Creative Commons pèrsonalisâ',
	'config-email-settings' => 'Paramètres de mèssageria èlèctronica',
	'config-enable-email' => 'Activar los mèssâjos que sôrtont',
	'config-email-user' => 'Activar los mèssâjos d’usanciér a usanciér',
	'config-email-usertalk' => 'Activar la notificacion de les pâges de discussion ux usanciérs',
	'config-email-watchlist' => 'Activar la notificacion de la lista de survelyence',
	'config-email-auth' => 'Activar l’ôtenticacion per mèssageria èlèctronica',
	'config-email-sender' => 'Adrèce èlèctronica de retôrn :',
	'config-upload-settings' => 'Tèlèchargement de les émâges et des fichiérs',
	'config-upload-enable' => 'Activar lo tèlèchargement des fichiérs',
	'config-upload-deleted' => 'Dossiér por los fichiérs suprimâs :',
	'config-logo' => 'URL du logô :',
	'config-instantcommons' => 'Activar Instant Commons',
	'config-cc-again' => 'Tornâd chouèsir...',
	'config-advanced-settings' => 'Configuracion avanciê',
	'config-cache-options' => 'Paramètres por la misa en cache de les chouses :',
	'config-cache-accel' => 'Misa en cache de les chouses PHP (APC, XCache ou ben WinCache)',
	'config-memcached-servers' => 'Sèrvors por memcached :',
	'config-extensions' => 'Èxtensions',
	'config-install-step-done' => 'fêt',
	'config-install-step-failed' => 'falyita',
	'config-install-extensions' => 'Encllusion de les èxtensions',
	'config-install-database' => 'Crèacion de la bâsa de balyês',
	'config-install-schema' => 'Crèacion de plan',
	'config-install-pg-schema-not-exist' => 'Lo plan PostgreSQL ègziste pas',
	'config-install-pg-commit' => 'Validacion des changements',
	'config-install-pg-plpgsql' => 'Contrôlo du lengâjo PL/pgSQL',
	'config-install-user' => 'Crèacion d’un usanciér de la bâsa de balyês',
	'config-install-user-alreadyexists' => 'L’usanciér « $1 » ègziste ja',
	'config-install-user-create-failed' => 'Falyita pendent la crèacion de l’usanciér « $1 » : $2',
	'config-install-user-grant-failed' => 'Falyita pendent l’aponsa de pèrmissions a l’usanciér « $1 » : $2',
	'config-install-tables' => 'Crèacion de les trâbles',
	'config-install-interwiki' => 'Remplissâjo per dèfôt de la trâbla des entèrvouiquis',
	'config-install-interwiki-list' => 'Empossiblo de trovar lo fichiér <code>interwiki.list</code>.',
	'config-install-stats' => 'Inicialisacion de les statistiques',
	'config-install-keys' => 'G·ènèracion de les cllâfs secrètes',
	'config-install-sysop' => 'Crèacion du compto administrator',
	'config-install-subscribe-fail' => 'Empossiblo de s’abonar a mediawiki-announce : $1',
	'config-install-mainpage' => 'Crèacion de la pâge principâla avouéc un contegnu per dèfôt',
	'config-install-extension-tables' => 'Crèacion de trâbles por les èxtensions activâs',
	'config-install-mainpage-failed' => 'Empossiblo d’entrebetar la pâge principâla : $1',
	'config-download-localsettings' => 'Tèlèchargiér LocalSettings.php',
	'config-help' => 'éde',
	'mainpagetext' => "'''MediaWiki at étâ enstalâ avouéc reusséta.'''",
	'mainpagedocfooter' => 'Vêde lo [//meta.wikimedia.org/wiki/Aide:Contenu guido d’usanciér] por més d’enformacions sur l’usâjo de la programeria vouiqui.

== Emmodar avouéc MediaWiki ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista des paramètres de configuracion]
* [//www.mediawiki.org/wiki/Manual:FAQ/fr FDQ sur MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de discussion sur les distribucions de MediaWiki]',
);

/** Northern Frisian (Nordfriisk)
 * @author Pyt
 */
$messages['frr'] = array(
	'mainpagetext' => "'''MediaWiki wörd ma erfolch instaliird.'''",
	'mainpagedocfooter' => 'Heelp tu jü benjüting än konfigurasjoon foon e Wiki-software fanst dü önj dåt [//meta.wikimedia.org/wiki/Help:Contents Benutzerhandbuch].


== Startheelpe ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liste der Konfigurationsvariablen]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailingliste neuer MediaWiki-Versionen]',
);

/** Friulian (furlan)
 */
$messages['fur'] = array(
	'mainpagetext' => "'''MediaWiki e je stade instalade cun sucès.'''",
);

/** Western Frisian (Frysk)
 */
$messages['fy'] = array(
	'mainpagetext' => "'''MediaWiki-program goed ynstallearre.'''",
	'mainpagedocfooter' => "Rieplachtsje de [//meta.wikimedia.org/wiki/Help:Ynhâldsopjefte hantlieding] foar ynformaasje oer it gebrûk fan 'e wikisoftware.

== Mear help oer Mediawiki ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings List mei ynstellings]
* [//www.mediawiki.org/wiki/Manual:FAQ Faak stelde fragen (FAQ)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailinglist foar oankundigings fan nije ferzjes]",
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'config-page-language' => 'Teanga',
	'config-page-name' => 'Ainm',
	'config-admin-password' => "D'fhocal faire:",
	'config-help' => 'Cuidiú',
	'mainpagetext' => "'''D'éirigh le suiteáil MediaWiki.'''",
	'mainpagedocfooter' => 'Féach ar [//meta.wikimedia.org/wiki/MediaWiki_localisation doiciméid um conas an chomhéadán a athrú]
agus an [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide Lámhleabhar úsáideora] chun cabhair úsáide agus fíoraíochta a fháil.',
);

/** Gagauz (Gagauz)
 */
$messages['gag'] = array(
	'mainpagetext' => "'''MediaWiki başarılan kuruldu.'''",
	'mainpagedocfooter' => "Vikilän iş uurunda bilgi almaa için [//meta.wikimedia.org/wiki/Help:Contents User's Guide] sayfasına bakınız

== Eni başlayanlar için ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Simplified Gan script (赣语（简体）‎)
 */
$messages['gan-hans'] = array(
	'mainpagetext' => "'''安装正MediaWiki喽。'''",
	'mainpagedocfooter' => '参看[//meta.wikimedia.org/wiki/Help:Contents 用户指南]里头会话到啷用wiki软件

== 开始使用 ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings MediaWiki 配置设定列表]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki 平常问题解答]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki 发布email清单]',
);

/** Traditional Gan script (贛語（繁體）‎)
 */
$messages['gan-hant'] = array(
	'mainpagetext' => "'''安裝正MediaWiki嘍。'''",
	'mainpagedocfooter' => '參看[//meta.wikimedia.org/wiki/Help:Contents 用戶指南]裡頭會話到啷用wiki軟件

== 開始使用 ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings MediaWiki 配置設定列表]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki 平常問題解答]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki 發佈email清單]',
);

/** Scottish Gaelic (Gàidhlig)
 * @author Akerbeltz
 */
$messages['gd'] = array(
	'mainpagetext' => "'''Chaidh MediaWiki a stàladh gu soirbheachail.'''",
	'mainpagedocfooter' => "Cuir sùil air [//meta.wikimedia.org/wiki/Help:Contents treòir nan cleachdaichean] airson fiosrachadh mu chleachdadh a' bhathar-bhog wiki.

== Toiseach tòiseachaidh ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liosta suidheachadh nan roghainnean]
* [//www.mediawiki.org/wiki/Manual:FAQ CÀBHA MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Liosta puist nan sgaoilidhean MediaWiki]",
);

/** Galician (galego)
 * @author Elisardojm
 * @author Toliño
 */
$messages['gl'] = array(
	'config-desc' => 'O programa de instalación de MediaWiki',
	'config-title' => 'Instalación de MediaWiki $1',
	'config-information' => 'Información',
	'config-localsettings-upgrade' => 'Detectouse un ficheiro <code>LocalSettings.php</code>.
Para actualizar esta instalación, introduza o valor de <code>$wgUpgradeKey</code> na caixa.
Pode atopalo en LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Detectouse un ficheiro LocalSettings.php.
Para actualizar esta instalación, execute update.php',
	'config-localsettings-key' => 'Clave de actualización:',
	'config-localsettings-badkey' => 'A clave dada é incorrecta',
	'config-upgrade-key-missing' => 'Detectouse unha instalación existente de MediaWiki.
Para actualizar esta instalación, inclúa esta liña ao final do ficheiro LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Semella que o ficheiro LocalSettings.php existente está incompleto.
A variable $1 non está establecida.
Modifique o ficheiro LocalSettings.php de xeito que a variable quede establecida e prema en "Continuar".',
	'config-localsettings-connection-error' => 'Atopouse un erro ao conectar coa base de datos empregando a configuración especificada no ficheiro LocalSettings.php ou no ficheiro AdminSettings.php. Corrixa esta configuración e inténteo de novo.

$1',
	'config-session-error' => 'Erro ao iniciar a sesión: $1',
	'config-session-expired' => 'Semella que os seus datos da sesión caducaron.
As sesións están configuradas para unha duración de $1.
Pode incrementar isto fixando <code>session.gc_maxlifetime</code> en php.ini.
Reinicie o proceso de instalación.',
	'config-no-session' => 'Perdéronse os datos da súa sesión!
Comprobe o seu php.ini e asegúrese de que en <code>session.save_path</code> está definido un directorio correcto.',
	'config-your-language' => 'A súa lingua:',
	'config-your-language-help' => 'Seleccione a lingua que se empregará durante o proceso de instalación.',
	'config-wiki-language' => 'Lingua do wiki:',
	'config-wiki-language-help' => 'Seleccione a lingua que predominará no wiki.',
	'config-back' => '← Volver',
	'config-continue' => 'Continuar →',
	'config-page-language' => 'Lingua',
	'config-page-welcome' => 'Benvido a MediaWiki!',
	'config-page-dbconnect' => 'Conectarse á base de datos',
	'config-page-upgrade' => 'Actualizar a instalación actual',
	'config-page-dbsettings' => 'Configuración da base de datos',
	'config-page-name' => 'Nome',
	'config-page-options' => 'Opcións',
	'config-page-install' => 'Instalar',
	'config-page-complete' => 'Completo!',
	'config-page-restart' => 'Reiniciar a instalación',
	'config-page-readme' => 'Léame',
	'config-page-releasenotes' => 'Notas de lanzamento',
	'config-page-copying' => 'Copiar',
	'config-page-upgradedoc' => 'Actualizar',
	'config-page-existingwiki' => 'Wiki existente',
	'config-help-restart' => 'Quere eliminar todos os datos gardados e reiniciar o proceso de instalación?',
	'config-restart' => 'Si, reiniciala',
	'config-welcome' => '=== Comprobación da contorna ===
Cómpre realizar unhas comprobacións básicas para ver se a contorna é axeitada para a instalación de MediaWiki.
Deberá proporcionar os resultados destas comprobacións se necesita axuda durante a instalación.',
	'config-copyright' => "=== Dereitos de autor e termos de uso ===

$1

Este programa é software libre; pode redistribuílo e/ou modificalo segundo os termos da licenza pública xeral GNU publicada pola Free Software Foundation; versión 2 ou (na súa escolla) calquera outra posterior.

Este programa distribúese coa esperanza de que poida ser útil, pero '''sen garantía ningunha'''; nin sequera a garantía implícita de '''comercialización''' ou '''adecuación a unha finalidade específica'''.
Olle a licenza pública xeral GNU para obter máis detalles.

Debería recibir <doclink href=Copying>unha copia da licenza pública xeral GNU</doclink> xunto ao programa; se non é así, escriba á Free Software Foundation, Inc., rúa Franklin, número 51, quinto andar, Boston, Massachusetts, 02110-1301, Estados Unidos de América ou [http://www.gnu.org/copyleft/gpl.html lea a licenza en liña].",
	'config-sidebar' => '* [//www.mediawiki.org/wiki/MediaWiki/gl Páxina principal de MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Guía de usuario]
* [//www.mediawiki.org/wiki/Manual:Contents Guía de administrador]
* [//www.mediawiki.org/wiki/Manual:FAQ Preguntas máis frecuentes]
----
* <doclink href=Readme>Léame</doclink>
* <doclink href=ReleaseNotes>Notas de lanzamento</doclink>
* <doclink href=Copying>Copia</doclink>
* <doclink href=UpgradeDoc>Actualizacións</doclink>',
	'config-env-good' => 'Rematou a comprobación da contorna.
Pode instalar MediaWiki.',
	'config-env-bad' => 'Rematou a comprobación da contorna.
Non pode instalar MediaWiki.',
	'config-env-php' => 'Está instalado o PHP $1.',
	'config-env-php-toolow' => 'Está instalado o PHP $1.
Porén, MediaWiki necesita o PHP $2 ou superior.',
	'config-unicode-using-utf8' => 'Usando utf8_normalize.so de Brion Vibber para a normalización Unicode.',
	'config-unicode-using-intl' => 'Usando a [http://pecl.php.net/intl extensión intl PECL] para a normalización Unicode.',
	'config-unicode-pure-php-warning' => "'''Atención:''' A [http://pecl.php.net/intl extensión intl PECL] non está dispoñible para manexar a normalización Unicode; volvendo á implementación lenta de PHP puro.
Se o seu sitio posúe un alto tráfico de visitantes, debería ler un chisco sobre a [//www.mediawiki.org/wiki/Unicode_normalization_considerations normalización Unicode].",
	'config-unicode-update-warning' => "'''Atención:''' A versión instalada da envoltura de normalización Unicode emprega unha versión vella da biblioteca [http://site.icu-project.org/ do proxecto ICU].
Debería [//www.mediawiki.org/wiki/Unicode_normalization_considerations actualizar] se o uso de Unicode é importante para vostede.",
	'config-no-db' => 'Non se puido atopar un controlador axeitado para a base de datos! Necesita instalar un controlador de base de datos para PHP.
Os tipos de base de datos admitidos son os seguintes: $1.

Se está nun aloxamento compartido, pregunte ao seu provedor de hospedaxe para instalar un controlador de base de datos axeitado.
Se compilou o PHP vostede mesmo, reconfigúreo activando un cliente de base de datos, por exemplo, usando <code>./configure --with-mysql</code>.
Se instalou o PHP desde un paquete Debian ou Ubuntu, entón tamén necesita instalar o módulo php5-mysql.',
	'config-outdated-sqlite' => "'''Atención:''' Ten o SQLite $1, que é inferior á versión mínima necesaria: $2. O SQLite non estará dispoñible.",
	'config-no-fts3' => "'''Atención:''' O SQLite está compilado sen o [//sqlite.org/fts3.html módulo FTS3]; as características de procura non estarán dispoñibles nesta instalación.",
	'config-register-globals' => "'''Atención: A opción PHP <code>[http://php.net/register_globals register_globals]</code> está activada.'''
'''Desactívea se pode.'''
MediaWiki funcionará, pero o seu servidor está exposto a potenciais vulnerabilidades de seguridade.",
	'config-magic-quotes-runtime' => "'''Erro fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] está activado!'''
Esta opción corrompe os datos de entrada de xeito imprevisible.
Non pode instalar ou empregar MediaWiki a menos que esta opción estea desactivada.",
	'config-magic-quotes-sybase' => "'''Erro fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] está activado!'''
Esta opción corrompe os datos de entrada de xeito imprevisible.
Non pode instalar ou empregar MediaWiki a menos que esta opción estea desactivada.",
	'config-mbstring' => "'''Erro fatal: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] está activado!'''
Esta opción causa erros e pode corromper os datos de xeito imprevisible.
Non pode instalar ou empregar MediaWiki a menos que esta opción estea desactivada.",
	'config-ze1' => "'''Erro fatal: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] está activado!'''
Esta opción causa erros horribles en MediaWiki.
Non pode instalar ou empregar MediaWiki a menos que esta opción estea desactivada.",
	'config-safe-mode' => "'''Atención:''' O [http://www.php.net/features.safe-mode safe mode] do PHP está activado.
Isto pode causar problemas, particularmente se emprega cargas de ficheiros e soporte de <code>math</code>.",
	'config-xml-bad' => 'Falta o módulo XML do PHP.
MediaWiki necesita funcións neste módulo e non funcionará con esta configuración.
Se está executando o Mandrake, instale o paquete php-xml.',
	'config-pcre' => 'Semella que falta o módulo de soporte PCRE.
MediaWiki necesita que funcionen as expresións regulares compatibles co Perl.',
	'config-pcre-no-utf8' => "'''Erro fatal:''' Semella que o módulo PCRE do PHP foi compilado sen o soporte PCRE_UTF8.
MediaWiki necesita soporte UTF-8 para funcionar correctamente.",
	'config-memory-raised' => 'O parámetro <code>memory_limit</code> do PHP é $1. Aumentado a $2.',
	'config-memory-bad' => "'''Atención:''' O parámetro <code>memory_limit</code> do PHP é $1.
Probablemente é un valor baixo de máis.
A instalación pode fallar!",
	'config-ctype' => "'''Fatal:''' O PHP debe compilarse co soporte para a [http://www.php.net/manual/en/ctype.installation.php extensión Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] está instalado',
	'config-apc' => '[http://www.php.net/apc APC] está instalado',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] está instalado',
	'config-no-cache' => "'''Atención:''' Non se puido atopar [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] ou [http://www.iis.net/download/WinCacheForPhp WinCache].
A caché de obxectos está desactivada.",
	'config-mod-security' => "'''Atención:''' O seu servidor web ten o [http://modsecurity.org/ mod_security] activado. Se estivese mal configurado, pode causar problemas a MediaWiki ou calquera outro software que permita aos usuarios publicar contidos arbitrarios.
Olle a [http://modsecurity.org/documentation/ documentación do mod_security] ou póñase en contacto co soporte do seu servidor se atopa erros aleatorios.",
	'config-diff3-bad' => 'GNU diff3 non se atopou.',
	'config-imagemagick' => 'ImageMagick atopado: <code>$1</code>.
As miniaturas de imaxes estarán dispoñibles se activa as cargas.',
	'config-gd' => 'Atopouse a biblioteca gráfica GD integrada.
As miniaturas de imaxes estarán dispoñibles se activa as cargas.',
	'config-no-scaling' => 'Non se puido atopar a biblioteca GD ou ImageMagick.
As miniaturas de imaxes estarán desactivadas.',
	'config-no-uri' => "'''Erro:''' Non se puido determinar o URI actual.
Instalación abortada.",
	'config-no-cli-uri' => "'''Aviso:''' Non se especificou ningún --scriptpath; por defecto, usarase: <code>$1</code>.",
	'config-using-server' => 'Usando o nome do servidor "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Usando o URL do servidor "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''Atención:''' O seu directorio por defecto para as cargas, <code>$1</code>, é vulnerable a execucións arbitrarias de escrituras.
Aínda que MediaWiki comproba todos os ficheiros cargados por se houbese ameazas de seguridade, é amplamente recomendable [//www.mediawiki.org/wiki/Manual:Security#Upload_security pechar esta vulnerabilidade de seguridade] antes de activar as cargas.",
	'config-no-cli-uploads-check' => "'''Atención:''' Durante a instalación CLI, o seu directorio por defecto para as cargas, <code>$1</code>, non se comproba fronte a posibles vulnerabilidades de execucións arbitrarias de escrituras.",
	'config-brokenlibxml' => 'O seu sistema ten unha combinación de versións de PHP e libxml2 que pode ser problemático e causar corrupción de datos en MediaWiki e outras aplicacións web.
Actualice o sistema á versión 5.2.9 ou posterior do PHP e á 2.7.3 ou posterior de libxml2 ([//bugs.php.net/bug.php?id=45996 erro presentado co PHP]).
Instalación abortada.',
	'config-using531' => 'O PHP $1 non é compatible con MediaWiki debido a un erro que afecta aos parámetros de referencia de <code>__call()</code>.
Actualice o sistema á versión 5.3.2 ou posterior do PHP ou volva á versión 5.3.0 do PHP para arranxar o problema.
Instalación abortada.',
	'config-suhosin-max-value-length' => 'Suhosin está instalado e limita a lonxitude do parámetro GET a $1 bytes. O compoñente ResourceLoader (xestor de recursos) de MediaWiki traballa neste límite, pero este prexudica o rendemento. Se é posible, debería establecer suhosin.get.max_value_length no valor 1024 ou superior en php.ini e establecer $wgResourceLoaderMaxQueryLength no mesmo valor en LocalSettings.php.',
	'config-db-type' => 'Tipo de base de datos:',
	'config-db-host' => 'Servidor da base de datos:',
	'config-db-host-help' => 'Se o servidor da súa base de datos está nun servidor diferente, escriba o nome do servidor ou o enderezo IP aquí.

Se está usando un aloxamento web compartido, o seu provedor de hospedaxe debe darlle o nome de servidor correcto na súa documentación.

Se está a realizar a instalación nun servidor de Windows con MySQL, o nome "localhost" pode non valer como servidor. Se non funcionase, inténteo con "127.0.0.1" como enderezo IP local.

Se está usando PostgreSQL, deixe este campo en branco para facer a conexión a través do conectador Unix.',
	'config-db-host-oracle' => 'TNS da base de datos:',
	'config-db-host-oracle-help' => 'Insira un [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm nome de conexión local] válido; cómpre que haxa visible un ficheiro tnsnames.ora para esta instalación.<br />Se está a empregar bibliotecas cliente versión 10g ou máis recentes, tamén pode usar o método de atribución de nomes [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identificar o wiki',
	'config-db-name' => 'Nome da base de datos:',
	'config-db-name-help' => 'Escolla un nome que identifique o seu wiki.
Non debe conter espazos.

Se está usando un aloxamento web compartido, o seu provedor de hospedaxe daralle un nome específico para a base de datos ou deixaralle crear unha a través do panel de control.',
	'config-db-name-oracle' => 'Esquema da base de datos:',
	'config-db-account-oracle-warn' => 'Existen tres escenarios soportados para a instalación de Oracle como fin da base de datos:

Se quere crear unha conta para a base de datos como parte do proceso de instalación, proporcione unha conta co papel SYSDBA e especifique as credenciais desexadas para a conta; senón pode crear a conta manualmente e dar só esa conta (se ten os permisos necesarios para crear os obxectos do esquema) ou fornecer dous contas diferentes, unha con privilexios de creación e outra restrinxida para o acceso á web.

A escritura para crear unha conta cos privilexios necesarios atópase no directorio "maintenance/oracle/" desta instalación. Teña en conta que o emprego de contas restrinxidas desactivará todas as operacións de mantemento da conta predeterminada.',
	'config-db-install-account' => 'Conta de usuario para a instalación',
	'config-db-username' => 'Nome de usuario da base de datos:',
	'config-db-password' => 'Contrasinal da base de datos:',
	'config-db-password-empty' => 'Introduza un contrasinal para o novo usuario da base de datos: $1.
Malia que é posible crear usuarios sen contrasinal, esta práctica non é segura.',
	'config-db-install-username' => 'Escriba o nome de usuario que empregará para conectarse á base de datos durante o proceso de instalación. Este non é o nome de usuario da conta de MediaWiki, trátase do nome de usuario para a súa base de datos.',
	'config-db-install-password' => 'Escriba o contrasinal que empregará para conectarse á base de datos durante o proceso de instalación. Este non é o contrasinal da conta de MediaWiki, trátase do contrasinal para a súa base de datos.',
	'config-db-install-help' => 'Introduza o nome de usuario e contrasinal que se usará para conectar á base de datos durante o proceso de instalación.',
	'config-db-account-lock' => 'Use o mesmo nome de usuario e contrasinal despois do proceso de instalación',
	'config-db-wiki-account' => 'Conta de usuario para despois do proceso de instalación',
	'config-db-wiki-help' => 'Introduza o nome de usuario e mais o contrasinal que se usarán para conectar á base de datos durante o funcionamento habitual do wiki.
Se a conta non existe e a conta de instalación ten privilexios suficientes, esa conta de usuario será creada cos privilexios mínimos necesarios para o funcionamento do wiki.',
	'config-db-prefix' => 'Prefixo das táboas da base de datos:',
	'config-db-prefix-help' => 'Se necesita compartir unha base de datos entre varios wikis ou entre MediaWiki e outra aplicación web, pode optar por engadir un prefixo a todos os nomes da táboa para evitar conflitos.
Non utilice espazos.

O normal é que este campo quede baleiro.',
	'config-db-charset' => 'Conxunto de caracteres da base de datos',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binario',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 retrocompatible UTF-8',
	'config-charset-help' => "'''Atención:''' Se emprega '''backwards-compatible UTF-8''' no MySQL 4.1+ e posteriormente realiza unha copia de seguridade da base de datos con <code>mysqldump</code>, pode destruír todos os caracteres que non sexan ASCII, corrompendo de xeito irreversible as súas copias!

No '''modo binario''', MediaWiki almacena texto UTF-8 na base de datos en campos binarios.
Isto é máis eficaz ca o modo UTF-8 de MySQL e permítelle usar o rango completo de caracteres Unicode.
No '''modo UTF-8''', MySQL saberá o xogo de caracteres dos seus datos e pode presentar e converter os datos de maneira axeitada,
pero non lle deixará gardar caracteres por riba do [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plan multilingüe básico].",
	'config-mysql-old' => 'Necesítase MySQL $1 ou posterior; ten a versión $2.',
	'config-db-port' => 'Porto da base de datos:',
	'config-db-schema' => 'Esquema para MediaWiki',
	'config-db-schema-help' => 'O normal é que este esquema sexa correcto.
Cámbieo soamente se sabe que é necesario.',
	'config-pg-test-error' => "Non se pode conectar coa base de datos '''$1''': $2",
	'config-sqlite-dir' => 'Directorio de datos SQLite:',
	'config-sqlite-dir-help' => "SQLite recolle todos os datos nun ficheiro único.

O servidor web debe ter permisos sobre o directorio para que poida escribir nel durante a instalación.

Ademais, o servidor '''non''' debe ser accesible a través da web, motivo polo que non está no mesmo lugar ca os ficheiros PHP.

Asemade, o programa de instalación escribirá un ficheiro <code>.htaccess</code>, pero se erra alguén pode obter acceso á súa base de datos.
Isto inclúe datos de usuario (enderezos de correo electrónico, contrasinais codificados), así como revisións borradas e outros datos restrinxidos no wiki.

Considere poñer a base de datos nun só lugar, por exemplo en <code>/var/lib/mediawiki/oseuwiki</code>.",
	'config-oracle-def-ts' => 'Espazo de táboas por defecto:',
	'config-oracle-temp-ts' => 'Espazo de táboas temporal:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki soporta os seguintes sistemas de bases de datos:

$1

Se non ve listado a continuación o sistema de base de datos que intenta usar, siga as instrucións ligadas enriba para activar o soporte.',
	'config-support-mysql' => '* $1 é o obxectivo principal para MediaWiki e está mellor soportado ([http://www.php.net/manual/en/mysql.installation.php como compilar o PHP con soporte MySQL])',
	'config-support-postgres' => '* $1 é un sistema de base de datos popular e de código aberto como alternativa a MySQL ([http://www.php.net/manual/en/pgsql.installation.php como compilar o PHP con soporte PostgreSQL]). É posible que haxa algúns pequenos erros e non se recomenda o seu uso nunha contorna de produción.',
	'config-support-sqlite' => '* $1 é un sistema de base de datos lixeiro moi ben soportado. ([http://www.php.net/manual/en/pdo.installation.php Como compilar o PHP con soporte SQLite], emprega PDO)',
	'config-support-oracle' => '* $1 é un sistema comercial de xestión de base de datos de empresa. ([http://www.php.net/manual/en/oci8.installation.php Como compilar PHP con soporte OCI8])',
	'config-support-ibm_db2' => '* $1 é unha base de datos de empresa comercial.',
	'config-header-mysql' => 'Configuración do MySQL',
	'config-header-postgres' => 'Configuración do PostgreSQL',
	'config-header-sqlite' => 'Configuración do SQLite',
	'config-header-oracle' => 'Configuración do Oracle',
	'config-header-ibm_db2' => 'Configuración de IBM DB2',
	'config-invalid-db-type' => 'Tipo de base de datos incorrecto',
	'config-missing-db-name' => 'Debe escribir un valor "Nome da base de datos"',
	'config-missing-db-host' => 'Debe escribir un valor "Servidor da base de datos"',
	'config-missing-db-server-oracle' => 'Debe escribir un valor "TNS da base de datos"',
	'config-invalid-db-server-oracle' => 'O TNS da base de datos, "$1", é incorrecto.
Só pode conter letras ASCII (a-z, A-Z), números (0-9), guións baixos (_) e puntos (.).',
	'config-invalid-db-name' => 'O nome da base de datos, "$1", é incorrecto.
Só pode conter letras ASCII (a-z, A-Z), números (0-9), guións baixos (_) e guións (-).',
	'config-invalid-db-prefix' => 'O prefixo da base de datos, "$1", é incorrecto.
Só pode conter letras ASCII (a-z, A-Z), números (0-9), guións baixos (_) e guións (-).',
	'config-connection-error' => '$1.

Comprobe o servidor, nome de usuario e contrasinal que hai a continuación e inténteo de novo.',
	'config-invalid-schema' => 'O esquema de MediaWiki, "$1", é incorrecto.
Só pode conter letras ASCII (a-z, A-Z), números (0-9) e guións baixos (_).',
	'config-db-sys-create-oracle' => 'O programa de instalación soamente soporta o emprego de contas SYSDBA como método para crear unha nova conta.',
	'config-db-sys-user-exists-oracle' => 'A conta de usuario "$1" xa existe. SYSDBA soamente se pode empregar para a creación dunha nova conta!',
	'config-postgres-old' => 'Necesítase PostgreSQL $1 ou posterior; ten a versión $2.',
	'config-sqlite-name-help' => 'Escolla un nome que identifique o seu wiki.
Non utilice espazos ou guións.
Este nome será utilizado para o ficheiro de datos SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Non se puido crear o directorio de datos <code><nowiki>$1</nowiki></code>, porque o servidor web non pode escribir no directorio pai <code><nowiki>$2</nowiki></code>.

O programa de instalación determinou o usuario que executa o seu servidor web.
Para continuar, faga que se poida escribir no directorio <code><nowiki>$3</nowiki></code>.
Nun sistema Unix/Linux cómpre realizar:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Non se puido crear o directorio de datos <code><nowiki>$1</nowiki></code>, porque o servidor web non pode escribir no directorio pai <code><nowiki>$2</nowiki></code>.

O programa de instalación non puido determinar o usuario que executa o seu servidor web.
Para continuar, faga que se poida escribir globalmente no directorio <code><nowiki>$3</nowiki></code>.
Nun sistema Unix/Linux cómpre realizar:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Erro ao crear o directorio de datos "$1".
Comprobe a localización e inténteo de novo.',
	'config-sqlite-dir-unwritable' => 'Non se puido escribir o directorio "$1".
Cambie os permisos para que o servidor poida escribir nel e inténteo de novo.',
	'config-sqlite-connection-error' => '$1.

Comprobe o directorio de datos e o nome da base de datos que hai a continuación e inténteo de novo.',
	'config-sqlite-readonly' => 'Non se pode escribir no ficheiro <code>$1</code>.',
	'config-sqlite-cant-create-db' => 'Non se puido crear o ficheiro da base de datos <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'Falta o soporte FTS3 para o PHP; diminuíndo as táboas',
	'config-can-upgrade' => "Existen táboas MediaWiki nesta base de datos.
Para actualizalas a MediaWiki \$1, prema sobre \"'''Continuar'''\".",
	'config-upgrade-done' => "Actualización completada.

Agora pode [$1 comezar a utilizar o seu wiki].

Se quere rexenerar o seu ficheiro <code>LocalSettings.php</code>, prema no botón que aparece a continuación.
Isto '''non é recomendable''' a menos que estea a ter problemas co seu wiki.",
	'config-upgrade-done-no-regenerate' => 'Actualización completada.

Xa pode [$1 comezar a usar o seu wiki].',
	'config-regenerate' => 'Rexenerar LocalSettings.php →',
	'config-show-table-status' => 'A pescuda SHOW TABLE STATUS fallou!',
	'config-unknown-collation' => "'''Atención:''' A base de datos está a empregar unha clasificación alfabética irrecoñecible.",
	'config-db-web-account' => 'Conta na base de datos para o acceso á internet',
	'config-db-web-help' => 'Seleccione o nome de usuario e contrasinal que o servidor web empregará para se conectar ao servidor da base de datos durante o funcionamento normal do wiki.',
	'config-db-web-account-same' => 'Empregar a mesma conta que para a instalación',
	'config-db-web-create' => 'Crear a conta se aínda non existe',
	'config-db-web-no-create-privs' => 'A conta que especificou para a instalación non ten os privilexios suficientes para crear unha conta.
A conta que se especifique aquí xa debe existir.',
	'config-mysql-engine' => 'Motor de almacenamento:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Atención:''' Seleccionou MyISAM como o motor de almacenamento para MySQL, unha combinación non recomendada para MediaWiki, porque:
* practicamente non soporta os accesos simultáneos debido ao bloqueo de táboas
* é máis propenso a corromperse ca outros motores
* o código base de MediaWiki non sempre manexa o MyISAM como debera

Se a súa instalación MySQL soporta InnoDB, recoméndase elixilo no canto de MyISAM.
Se a súa instalación MySQL non soporta InnoDB, quizais sexa boa idea realizar unha actualización.",
	'config-mysql-engine-help' => "'''InnoDB''' é case sempre a mellor opción, dado que soporta ben os accesos simultáneos.

'''MyISAM''' é máis rápido en instalacións de usuario único e de só lectura.
As bases de datos MyISAM tenden a se corromper máis a miúdo ca as bases de datos InnoDB.",
	'config-mysql-charset' => 'Conxunto de caracteres da base de datos:',
	'config-mysql-binary' => 'Binario',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "No '''modo binario''', MediaWiki almacena texto UTF-8 na base de datos en campos binarios.
Isto é máis eficaz ca o modo UTF-8 de MySQL e permítelle usar o rango completo de caracteres Unicode.

No '''modo UTF-8''', MySQL saberá o xogo de caracteres dos seus datos e pode presentar e converter os datos de maneira axeitada,
pero non lle deixará gardar caracteres por riba do [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes plan multilingüe básico].",
	'config-ibm_db2-low-db-pagesize' => "A súa base de datos DB2 ten un espazo de táboa cun tamaño de páxina insuficiente. O tamaño de páxina debe ser '''32k''' ou maior.",
	'config-site-name' => 'Nome do wiki:',
	'config-site-name-help' => 'Isto aparecerá na barra de títulos do navegador e noutros lugares.',
	'config-site-name-blank' => 'Escriba o nome do sitio.',
	'config-project-namespace' => 'Espazo de nomes do proxecto:',
	'config-ns-generic' => 'Proxecto',
	'config-ns-site-name' => 'O mesmo nome que o wiki: $1',
	'config-ns-other' => 'Outro (especificar)',
	'config-ns-other-default' => 'OMeuWiki',
	'config-project-namespace-help' => 'Seguindo o exemplo da Wikipedia, moitos wikis manteñen as súas páxinas de políticas separadas das súas páxinas de contido, nun "\'\'\'espazo de nomes do proxecto\'\'\'".
Todos os títulos presentes neste espazo de nomes comezan cun prefixo determinado, que pode especificar aquí.
Tradicionalmente, este prefixo deriva do nome do wiki, pero non pode conter caracteres de puntuación como "#" ou ":".',
	'config-ns-invalid' => 'O espazo de nomes especificado, "<nowiki>$1</nowiki>", é incorrecto.
Especifique un espazo de nomes do proxecto diferente.',
	'config-ns-conflict' => 'O espazo de nomes especificado, "<nowiki>$1</nowiki>", entra en conflito co espazo de nomes MediaWiki por defecto.
Especifique un espazo de nomes do proxecto diferente.',
	'config-admin-box' => 'Conta de administrador',
	'config-admin-name' => 'O seu nome:',
	'config-admin-password' => 'Contrasinal:',
	'config-admin-password-confirm' => 'Repita o contrasinal:',
	'config-admin-help' => 'Escriba o nome de usuario que queira aquí, por exemplo, "Joe Bloggs".
Este é o nome que usará para acceder ao sistema do wiki.',
	'config-admin-name-blank' => 'Escriba un nome de usuario para o administrador.',
	'config-admin-name-invalid' => 'O nome de usuario especificado, "<nowiki>$1</nowiki>", é incorrecto.
Especifique un nome de usuario diferente.',
	'config-admin-password-blank' => 'Escriba un contrasinal para a conta de administrador.',
	'config-admin-password-same' => 'O contrasinal debe diferir do nome de usuario.',
	'config-admin-password-mismatch' => 'Os contrasinais non coinciden.',
	'config-admin-email' => 'Enderezo de correo electrónico:',
	'config-admin-email-help' => 'Escriba aquí un enderezo de correo electrónico para que poida recibir mensaxes doutros usuarios a través do wiki, restablecer o contrasinal e ser notificado das modificacións feitas nas páxinas presentes na súa lista de vixilancia. Pode deixar este campo en branco.',
	'config-admin-error-user' => 'Erro interno ao crear un administrador co nome "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Erro interno ao establecer un contrasinal para o administrador "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Escribiu un enderezo de correo electrónico non válido.',
	'config-subscribe' => 'Subscríbase á [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce lista de correo de anuncios sobre lanzamentos].',
	'config-subscribe-help' => 'Esta é unha lista de correos de baixo volume usada para anuncios sobre lanzamentos de novas versións, incluíndo avisos de seguridade importantes.
Debería subscribirse a ela e actualizar a súa instalación MediaWiki cando saian as novas versións.',
	'config-subscribe-noemail' => 'Intentou subscribirse á lista de correo dos anuncios de novos lanzamentos sen proporcionar o enderezo de correo electrónico.
Dea un enderezo de correo electrónico se quere efectuar a subscrición á lista de correo.',
	'config-almost-done' => 'Xa case rematou!
Neste paso pode saltar o resto da configuración e instalar o wiki agora mesmo.',
	'config-optional-continue' => 'Facédeme máis preguntas.',
	'config-optional-skip' => 'Xa estou canso. Instalade o wiki.',
	'config-profile' => 'Perfil dos dereitos de usuario:',
	'config-profile-wiki' => 'Wiki tradicional',
	'config-profile-no-anon' => 'Necesítase a creación dunha conta',
	'config-profile-fishbowl' => 'Só os editores autorizados',
	'config-profile-private' => 'Wiki privado',
	'config-profile-help' => "Os wikis funcionan mellor canta máis xente os edite.
En MediaWiki, é doado revisar os cambios recentes e reverter calquera dano feito por usuarios novatos ou con malas intencións.
Porén, moita xente atopa MediaWiki útil nunha ampla variedade de papeis, e ás veces non é fácil convencer a todos dos beneficios que leva consigo o estilo wiki.
Vostede decide.

O tipo '''{{int:config-profile-wiki}}''' permite a edición por parte de calquera, mesmo sen rexistro.
A opción '''{{int:config-profile-no-anon}}''' proporciona un control maior, pero pode desalentar os colaboradores casuais.

O escenario '''{{int:config-profile-fishbowl}}''' restrinxe a edición aos usuarios aprobados, pero o público pode ollar as páxinas, incluíndo os historiais.
O tipo '''{{int:config-profile-private}}''' só deixa que os usuarios aprobados vexan e editen as páxinas.

Hai dispoñibles configuracións de dereitos de usuario máis complexas despois da instalación; bótelle un ollo a [//www.mediawiki.org/wiki/Manual:User_rights esta entrada no manual].",
	'config-license' => 'Dereitos de autor e licenza:',
	'config-license-none' => 'Sen licenza ao pé',
	'config-license-cc-by-sa' => 'Creative Commons recoñecemento compartir igual',
	'config-license-cc-by' => 'Creative Commons recoñecemento',
	'config-license-cc-by-nc-sa' => 'Creative Commons recoñecemento non comercial compartir igual',
	'config-license-cc-0' => 'Creative Commons Zero (dominio público)',
	'config-license-gfdl' => 'Licenza de documentación libre de GNU 1.3 ou posterior',
	'config-license-pd' => 'Dominio público',
	'config-license-cc-choose' => 'Seleccione unha licenza Creative Commons personalizada',
	'config-license-help' => "Moitos wikis públicos liberan todas as súas contribucións baixo unha [http://freedomdefined.org/Definition/Gl licenza libre].
Isto axuda a crear un sentido de propiedade comunitaria e anima a seguir contribuíndo durante moito tempo.
Xeralmente, non é necesario nos wikis privados ou de empresas.

Se quere poder empregar textos da Wikipedia, así como que a Wikipedia poida aceptar textos copiados do seu wiki, escolla a licenza '''Creative Commons recoñecemento compartir igual'''.

A licenza de documentación libre de GNU era a licenza anterior da Wikipedia.
Malia aínda ser unha licenza válida, é difícil de entender.
Tamén é difícil reusar contidos baixo esta licenza.",
	'config-email-settings' => 'Configuración do correo electrónico',
	'config-enable-email' => 'Activar os correos electrónicos de saída',
	'config-enable-email-help' => 'Se quere que o correo electrónico funcione, cómpre configurar os [http://www.php.net/manual/en/mail.configuration.php parámetros PHP] correctamente.
Se non quere ningunha característica no correo, pode desactivalas aquí.',
	'config-email-user' => 'Activar o intercambio de correos electrónicos entre usuarios',
	'config-email-user-help' => 'Permitir que todos os usuarios intercambien correos electrónicos, se o teñen activado nas súas preferencias.',
	'config-email-usertalk' => 'Activar a notificación da páxina de conversa de usuario',
	'config-email-usertalk-help' => 'Permitir que os usuarios reciban notificacións cando a súa páxina de conversa de usuario sufra modificacións, se o teñen activado nas súas preferencias.',
	'config-email-watchlist' => 'Activar a notificación da lista de vixilancia',
	'config-email-watchlist-help' => 'Permitir que os usuarios reciban notificacións sobre modificacións nas páxinas que vixían, se o teñen activado nas súas preferencias.',
	'config-email-auth' => 'Activar a autenticación do correo electrónico',
	'config-email-auth-help' => "Se esta opción está activada, os usuarios teñen que confirmar o seu correo electrónico mediante unha ligazón enviada ao enderezo cando o definan ou o cambien.
Só os enderezos autenticados poden recibir correos doutros usuarios ou de notificación.
É '''recomendable''' establecer esta opción nos wikis públicos para evitar abusos potenciais das características do correo.",
	'config-email-sender' => 'Enderezo de correo electrónico de retorno:',
	'config-email-sender-help' => 'Introduza o enderezo de correo electrónico a usar como enderezo de retorno dos correos de saída.
Aquí é onde irán parar os correos rexeitados.
Moitos servidores de correo electrónico esixen que polo menos a parte do nome de dominio sexa válido.',
	'config-upload-settings' => 'Imaxes e carga de ficheiros',
	'config-upload-enable' => 'Activar a carga de ficheiros',
	'config-upload-help' => 'A subida de ficheiros expón potencialmente o servidor a riscos de seguridade.
Para obter máis información, lea a [//www.mediawiki.org/wiki/Manual:Security sección de seguridade] no manual.

Para activar a carga de ficheiros, cambie o modo no subdirectorio <code>images</code> que está baixo o directorio raíz de MediaWiki, de xeito que o servidor web poida escribir nel.
A continuación, active esta opción.',
	'config-upload-deleted' => 'Directorio para os ficheiros borrados:',
	'config-upload-deleted-help' => 'Escolla un directorio no que arquivar os ficheiros borrados.
O ideal é que non sexa accesible desde a web.',
	'config-logo' => 'URL do logo:',
	'config-logo-help' => 'A aparencia de MediaWiki por defecto inclúe espazo para un logo de 135x160 píxeles por riba do menú lateral.
Cargue unha imaxe do tamaño axeitado e introduza o enderezo URL aquí.

Se non quere un logo, deixe esta caixa en branco.',
	'config-instantcommons' => 'Activar Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons InstantCommons] é unha característica que permite aos wikis usar imaxes, sons e outros ficheiros multimedia atopados no sitio da [//commons.wikimedia.org/wiki/Portada_galega Wikimedia Commons].
Para facer isto, MediaWiki necesita acceso á internet.

Para obter máis información sobre esta característica, incluíndo as instrucións sobre como configuralo para outros wikis que non sexan a Wikimedia Commons, consulte [//mediawiki.org/wiki/Manual:$wgForeignFileRepos o manual].',
	'config-cc-error' => 'A escolla da licenza Creative Commons non deu resultados.
Escriba o nome da licenza manualmente.',
	'config-cc-again' => 'Escolla outra vez...',
	'config-cc-not-chosen' => 'Escolla a licenza Creative Commons que desexe e prema en "continuar".',
	'config-advanced-settings' => 'Configuración avanzada',
	'config-cache-options' => 'Configuración da caché de obxectos:',
	'config-cache-help' => 'A caché de obxectos emprégase para mellorar a velocidade de MediaWiki mediante a memorización de datos usados con frecuencia.
É amplamente recomendable a súa activación nos sitios de tamaño medio e grande; os sitios pequenos obterán tamén beneficios.',
	'config-cache-none' => 'Sen caché (non se elimina ningunha funcionalidade, pero pode afectar á velocidade en wikis grandes)',
	'config-cache-accel' => 'Caché de obxectos do PHP (APC, XCache ou WinCache)',
	'config-cache-memcached' => 'Empregar o Memcached (necesita unha instalación e configuración adicional)',
	'config-memcached-servers' => 'Servidores da memoria caché:',
	'config-memcached-help' => 'Lista de enderezos IP para Memcached.
Debe especificarse un por liña, así como o porto a usar. Por exemplo:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Seleccionou Memcached como o seu tipo de caché, pero non especificou ningún servidor.',
	'config-memcache-badip' => 'Escribiu un enderezo IP inválido para Memcached: $1.',
	'config-memcache-noport' => 'Non especificou o porto a usar no servidor Memcached: $1.
Se non sabe o porto, o predeterminado é 11211.',
	'config-memcache-badport' => 'Os números de porto Memcached deben estar entre $1 e $2.',
	'config-extensions' => 'Extensións',
	'config-extensions-help' => 'As extensións anteriores detectáronse no seu directorio <code>./extensions</code>.

Quizais necesite algunha configuración adicional, pero pode activalas agora',
	'config-install-alreadydone' => "'''Atención:''' Semella que xa instalou MediaWiki e que o está a instalar de novo.
Vaia ata a seguinte páxina.",
	'config-install-begin' => 'Ao premer en "{{int:config-continue}}", comezará a instalación de MediaWiki.
Se aínda quere facer algún cambio, volva atrás.',
	'config-install-step-done' => 'feito',
	'config-install-step-failed' => 'erro',
	'config-install-extensions' => 'Incluíndo as extensións',
	'config-install-database' => 'Configurando a base de datos',
	'config-install-schema' => 'Creando o esquema',
	'config-install-pg-schema-not-exist' => 'O esquema PostgreSQL non existe.',
	'config-install-pg-schema-failed' => 'Fallou a creación de táboas.
Asegúrese de que o usuario "$1" pode escribir no esquema "$2".',
	'config-install-pg-commit' => 'Validando os cambios',
	'config-install-pg-plpgsql' => 'Comprobación da lingua PL/pgSQL',
	'config-pg-no-plpgsql' => 'Cómpre instalar a lingua PL/pgSQL na base de datos $1',
	'config-pg-no-create-privs' => 'A conta especificada para a instalación non ten os privilexios necesarios para crear unha conta.',
	'config-pg-not-in-role' => 'A conta especificada para o usuario web xa existe.
A conta que especificou para a instalación non é un superusuario e non pertence ao grupo de usuarios con acceso á web, polo que non pode crear obxectos pertencentes ao usuario da rede.

Actualmente, MediaWiki necesita que as táboas sexan propiedade do usuario da rede. Especifique outro nome de conta web ou prema no botón "Atrás" e dea un usuario de instalación cos privilexios axeitados.',
	'config-install-user' => 'Creando o usuario da base de datos',
	'config-install-user-alreadyexists' => 'O usuario "$1" xa existe',
	'config-install-user-create-failed' => 'A creación do usuario "$1" fallou: $2',
	'config-install-user-grant-failed' => 'Fallou a concesión de permisos ao usuario "$1": $2',
	'config-install-user-missing' => 'O usuario especificado, "$1", non existe.',
	'config-install-user-missing-create' => 'O usuario especificado, "$1", non existe.
Prema na caixa de verificación "crear unha conta" que hai a continuación se quere crear unha.',
	'config-install-tables' => 'Creando as táboas',
	'config-install-tables-exist' => "'''Atención:''' Semella que as táboas de MediaWiki xa existen.
Saltando a creación.",
	'config-install-tables-failed' => "'''Erro:''' Fallou a creación da táboa. Descrición do erro: $1",
	'config-install-interwiki' => 'Enchendo a táboa de interwiki por defecto',
	'config-install-interwiki-list' => 'Non se puido atopar o ficheiro <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Atención:''' Semella que a táboa de interwiki xa contén entradas.
Saltando a lista por defecto.",
	'config-install-stats' => 'Iniciando as estatísticas',
	'config-install-keys' => 'Xerando as claves secretas',
	'config-insecure-keys' => "'''Atención:''' {{PLURAL:$2|A clave de seguridade|As claves de seguridade}} ($1) {{PLURAL:$2|xerada|xeradas}} durante a instalación non {{PLURAL:$2|é|son}} completamente {{PLURAL:$2|segura|seguras}}. Considere a posibilidade de {{PLURAL:$2|cambiala|cambialas}} manualmente.",
	'config-install-sysop' => 'Creando a conta de usuario de administrador',
	'config-install-subscribe-fail' => 'Non se puido subscribir á lista mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL non está instalado e allow_url_fopen non está dispoñible.',
	'config-install-mainpage' => 'Creando a páxina principal co contido por defecto',
	'config-install-extension-tables' => 'Creando as táboas para as extensións activadas',
	'config-install-mainpage-failed' => 'Non se puido inserir a páxina principal: $1',
	'config-install-done' => "'''Parabéns!'''
Instalou correctamente MediaWiki.

O programa de instalación xerou un ficheiro <code>LocalSettings.php</code>.
Este ficheiro contén toda a súa configuración.

Terá que descargalo e poñelo na base da instalación do seu wiki (no mesmo directorio ca index.php). A descarga debería comezar automaticamente.

Se non comezou a descarga ou se a cancelou, pode facer que comece de novo premendo na ligazón que aparece a continuación:

$3

'''Nota:''' Se non fai iso agora, este ficheiro de configuración xerado non estará dispoñible máis adiante se sae da instalación sen descargalo.

Cando faga todo isto, xa poderá '''[$2 entrar no seu wiki]'''.",
	'config-download-localsettings' => 'Descargar o LocalSettings.php',
	'config-help' => 'axuda',
	'config-nofile' => 'Non se puido atopar o ficheiro "$1". Se cadra, foi borrado?',
	'mainpagetext' => "'''MediaWiki instalouse correctamente.'''",
	'mainpagedocfooter' => 'Consulte a [//meta.wikimedia.org/wiki/Help:Contents guía de usuario] para obter máis información sobre como usar o software wiki.

== Primeiros pasos ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista das opcións de configuración]
* [//www.mediawiki.org/wiki/Manual:FAQ Preguntas máis frecuentes sobre MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de correo dos lanzamentos de MediaWiki]',
);

/** Goan Konkani (Latin script) (Konknni)
 * @author The Discoverer
 */
$messages['gom-latn'] = array(
	'config-page-language' => 'Bhas',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'config-page-language' => 'Γλῶττα',
	'mainpagetext' => "'''Ἡ ἐγκατάστασις τῆς MediaWiki ἦν ἐπιτυχής'''",
	'mainpagedocfooter' => 'Βουλευθήσεσθε τὰς [//meta.wikimedia.org/wiki/Help:Contents βουλὰς τοῖς Χρωμένοις] ἵνα πληροφορηθῇτε περὶ τοῦ βίκιλογισμικοῦ.

== Ἄρξασθε ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Διαλογή παραμέτρων διαμορφώσεως]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki: τὰ πολλάκις αἰτηθέντα]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Διαλογή διαλέξεων ἐπὶ τῶν διανομῶν τῆς MediaWiki]',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'config-desc' => 'S MediaWiki-Inschtallationsprogramm',
	'config-title' => 'MediaWiki $1 inschtalliere',
	'config-information' => 'Information',
	'config-localsettings-upgrade' => "'''Warnig:''' E Datei <code>LocalSettings.php</code> isch gfunde wore.
Fir d Aktualisierig vu dr däre Inschtallation, gib bitte dr Wärt vum Parameter <code>\$wgUpgradeKey</code> im Fäld unten yy.
Du findsch dr Wärt in dr Datei LocalSettings.php.",
	'config-localsettings-key' => 'Aktualisierigsschlissel:',
	'config-localsettings-badkey' => 'Dr Aktualisierigsschlissel, wu du aagee hesch, isch falsch.',
	'config-session-error' => 'Fähler bim Starte vu dr Sitzig: $1',
	'config-session-expired' => 'D Sitzigsdate sin schyns abgloffe.
Sitzige sin fir e Zytruum vu $1 konfiguriert.
Dää cha dur Aalupfe vum Parameter <code>session.gc_maxlifetime</code> in dr Datei <code>php.ini</code> greßer gmacht wäre.
Dr Inschtallationsvorgang nomol starte.',
	'config-no-session' => 'Dyyni Sitzigsdate sin verlore gange!
D Datei <code>php.ini</code> mueß prieft wäre un s mueß derby sichergstellt wäre, ass dr Parameter <code>session.save_path</code> uf s richtig Verzeichnis verwyyst.',
	'config-your-language' => 'Dyy Sproch:',
	'config-your-language-help' => 'Bitte d Sproch uuswehle, wu bim Inschtallationsvorgang soll brucht wäre.',
	'config-wiki-language' => 'Wikisproch:',
	'config-wiki-language-help' => 'Bitte d Sproch uuswehle, wu s Wiki in dr Hauptsach din gschribe wird.',
	'config-back' => '← Zruck',
	'config-continue' => 'Wyter →',
	'config-page-language' => 'Sproch',
	'config-page-welcome' => 'Willchuu bi MediaWiki!',
	'config-page-dbconnect' => 'Mit dr Datebank verbinde',
	'config-page-upgrade' => 'E Inschtallition, wu s scho het, aktualisiere',
	'config-page-dbsettings' => 'Datebankyystellige',
	'config-page-name' => 'Name',
	'config-page-options' => 'Optione',
	'config-page-install' => 'Inschtalliere',
	'config-page-complete' => 'Fertig!',
	'config-page-restart' => 'Inschtallation nomol aafange',
	'config-page-readme' => 'Liis mi',
	'config-page-releasenotes' => 'Hiiwys fir d Vereffentlichung',
	'config-page-copying' => 'Am Kopiere',
	'config-page-upgradedoc' => 'Am Aktualisiere',
	'config-help-restart' => 'Witt alli Date, wu Du yygee hesch, lesche un d Inschtallation nomol aafange?',
	'config-restart' => 'Jo, nomol aafange',
	'config-welcome' => '=== Priefig vu dr Inschtallationsumgäbig ===
Basispriefige wäre durgfiert zum Feschtstelle, eb d Inschtallationsumgäbig fir d Inschtallation vu MediaWiki geignet isch.
Du sottsch d Ergebnis vu däre Priefig aagee, wänn Du bi dr Inschtallation Hilf bruchsch.',
	'config-copyright' => "=== Copyright un Nutzigsbedingige ===

$1

Des Programm isch e freji Software, d. h. s cha, no dr Bedingige vu dr GNU General Public-Lizänz, wu vu dr Free Software Foundation vereffentligt woren isch, wyterverteilt un/oder modifiziert wäre. Doderbyy cha d Version 2, oder no eigenem Ermässe, jedi nejeri Version vu dr Lizänz brucht wäre.

Des Programm wird in dr Hoffnig verteilt, ass es nitzli isch, aber '''ohni jedi Garanti''' un sogar ohni di impliziert Garanti vun ere '''Märtgängigkeit''' oder '''Eignig fir e bstimmte Zwäck'''. Doderzue git meh Hiiwys in dr GNU General Public-Lizänz.

E <doclink href=Copying>Kopi vu dr GNU General Public-Lizänz</doclink> sott zämme mit däm Programm verteilt wore syy. Wänn des nit eso isch, cha ne Kopi bi dr Free Software Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA, schriftli aagforderet oder [http://www.gnu.org/copyleft/gpl.html online gläse] wäre.",
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki Websyte vu MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Nutzeraaleitig zue MediaWiki]
* [//www.mediawiki.org/wiki/Manual:Contents Adminischtratoreaaleitig zue MediaWiki]
* [//www.mediawiki.org/wiki/Manual:FAQ Vilmol gstellti Froge zue MediaWiki]', # Fuzzy
	'config-env-good' => 'D Inschtallationsumgäbig isch prieft wore.
Du chasch MediaWiki inschtalliere.',
	'config-env-bad' => 'D Inschtallationsumgäbigisch prieft wore.
Du chasch MediaWiki nit inschtalliere.',
	'config-env-php' => 'PHP $1 isch inschtalliert.',
	'config-unicode-using-utf8' => 'Fir d Unicode-Normalisierig wird em Brion Vibber syy utf8_normalize.so yygsetzt.',
	'config-unicode-using-intl' => 'For d Unicode-Normalisierig wird d [http://pecl.php.net/intl PECL-Erwyterig intl] yygsetzt.',
	'config-unicode-pure-php-warning' => "'''Warnig:''' D [http://pecl.php.net/intl PECL-Erwyterig intl] isch fir d Unicode-Normalisierig nit verfiegbar. Wäge däm wird di langsam pure-PHP-Implementierig brucht.
Wänn Du ne Websyte mit ere große Bsuechrzahl bedrybsch, sottsch e weng ebis läse iber [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode-Normalisierig (en)].",
	'config-unicode-update-warning' => "'''Warnig:''' Di inschtalliert Version vum Unicode-Normalisierigswrapper verwändet e elteri Version vu dr Bibliothek vum [http://site.icu-project.org/ ICU-Projäkt].
Du sottsch si [//www.mediawiki.org/wiki/Unicode_normalization_considerations aktualisiere], wänn Dor d Verwändig vu Unicode wichtig isch.",
	'config-no-db' => 'S isch kei adäquate Datebanktryyber gfunde wore!', # Fuzzy
	'config-no-fts3' => "'''Warnig:''' SQLite isch ohni s [//sqlite.org/fts3.html FTS3-Modul] kumpiliert wore, s stehn kei Suechfunktione z Verfiegig.",
	'config-register-globals' => "'''Warnig: Dr Parameter <code>[http://php.net/register_globals register_globals]</code> vu PHP isch aktiviert.'''
'''Är sott deaktiviert wäre, wänn des megli isch.'''
D MediaWiki-Inschtallation lauft einwäg, aber dr Server isch aafällig fi megligi Sicherheitsprobläm.",
	'config-magic-quotes-runtime' => "'''Fatal: Dr Parameter <code>[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]</code> vu PHP isch aktiviert!'''
Die Yystellig fiert zue nit vorhärsähbare Probläm bi dr Datenyygab.
MediaWiki cha nit inschtalliert wäre, solang dää Parameter nit deaktiviert woren isch.",
	'config-magic-quotes-sybase' => "'''Fatal: Dr Parameter <code>[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase]</code> vu PHP isch aktiviert!'''
Die Yystellig fiert zue nit vorhärsähbare Probläm bi dr Datenyygab.
MediaWiki cha nit inschtalliert wäre, solang dää Parameter nit deaktiviert woren isch.",
	'config-mbstring' => "'''Fatal: Dr Parameter <code>[http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]</code> vu PHP isch aktiviert!'''
Die Yystellig verursacht Fähler un fiert zue nit vorhärsähbare Probläm bi dr Datenyygab.
MediaWiki cha nit inschtalliert wäre, solang dää Parameter nit deaktiviert woren isch.",
	'config-ze1' => "'''Fatal: Dr Parameter <code>[http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode]</code> vu PHP isch aktiviert!'''
Die Yystellig fiert zue große Fähler bi MediaWiki.
MediaWiki cha nit inschtalliert wäre, solang dää Parameter nit deaktiviert woren isch.",
	'config-safe-mode' => "'''Warnig:''' D Funktion <code>[http://www.php.net/features.safe-mode Safe Mode]</code> vu PHP isch aktiviert.
Des cha zue Probläm fiere, vor allem wänn s Uffelade vu Dateie soll megli syy bzw. dr Uuszeichner <code>math</code> soll brucht wäre.",
	'config-xml-bad' => 'S XML-Modul vu PHP fählt.
MediaWiki brucht Funktione, wu au des Modul z Verfiegig stellt, un funktioniert in däre Konfiguration nit.
Wänn Mandriva brucht wird, mueß no s „php-xml“-Paket inschtalliert wäre.',
	'config-pcre' => 'S PHP-Modul fir d PCRE-Unterstitzig isch nit gfunde wore.
MediaWiki brucht aber perl-kompatibli reguläri Uusdruck zum lauffähig syy.',
	'config-pcre-no-utf8' => "'''Fatale Fähler: S PHP-Modul PCRE isch schyns ohni PCRE_UTF8-Unterstitzig kompiliert wore.'''
MediaWiki brucht d UTF-8-Unterstitzi zum fählerfrej lauffähig syy.",
	'config-memory-raised' => 'Dr PHP-Parameter <code>memory_limit</code> lyt bi $1 un isch uf $2 uffegsetzt wore.',
	'config-memory-bad' => "'''Warnig:''' Dr PHP-Parameter <code>memory_limit</code> lyt bi $1.
Dää Wärt isch wahrschyns z nider.
Dr Inschtallationsvorgang chennt wäge däm fählschlaa!",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] isch inschtalliert',
	'config-apc' => '[http://www.php.net/apc APC] isch inschtalliert',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] isch inschtalliert',
	'config-no-cache' => "'''Warnig:''' [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] oder [http://www.iis.net/download/WinCacheForPhp WinCache] hän nit chenne gfunde wäre.
S Objäktcaching isch wäge däm nit aktiviert.",
	'config-diff3-bad' => 'GNU diff3 isch nit gfunde wore.',
	'config-imagemagick' => 'ImageMagick isch gfunde wore: <code>$1</code>.
Miniaturaasichte vu Bilder sin megli, sobald s Uffelade vu Dateie aktiviert isch.',
	'config-help' => 'Hilf',
	'mainpagetext' => "'''MediaWiki isch erfolgrich inschtalliert worre.'''",
	'mainpagedocfooter' => 'Lueg uf d [//meta.wikimedia.org/wiki/MediaWiki_localisation Dokumentation fir d Aapassig vu dr Benutzeroberflächi] un s [//meta.wikimedia.org/wiki/Help:Contents Benutzerhandbuech] fir d Hilf iber d Benutzig un s Yystelle.',
);

/** Gujarati (ગુજરાતી)
 * @author Dineshjk
 */
$messages['gu'] = array(
	'mainpagetext' => "'''મિડીયાવિકિ સફળતાપૂર્વક ઇન્સટોલ થયું છે.'''",
	'mainpagedocfooter' => 'વિકિ સોફ્ટવેર વાપરવાની માહીતિ માટે [//meta.wikimedia.org/wiki/Help:Contents સભ્ય માર્ગદર્શિકા] જુઓ.

== શરૂઆતના તબક્કે ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings કોનફીગ્યુરેશન સેટીંગ્સની યાદી]
* [//www.mediawiki.org/wiki/Manual:FAQ વારંવાર પુછાતા પ્રશ્નો]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce મિડીયાવિકિ રીલીઝ મેઇલીંગ લીસ્ટ]',
);

/** Manx (Gaelg)
 */
$messages['gv'] = array(
	'mainpagetext' => "'''Ta MediaWiki currit stiagh nish.'''",
);

/** Hakka (Hak-kâ-fa)
 */
$messages['hak'] = array(
	'mainpagetext' => "'''Yí-kîn sṳ̀n-kûng ôn-chông MediaWiki.'''",
	'mainpagedocfooter' => 'chhiáng fóng-mun [//meta.wikimedia.org/wiki/Help:Contents Yung-fu sú-chhak] yî-khi̍p sṳ́-yung chhṳ́ wiki ngiôn-khien ke sin-sit！

== Ngi̍p-mùn  ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings MediaWiki Phi-chṳ sat-thin chhîn-tân]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki Phìn-sòng mun-thì kié-tap]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki fat-phu email chhîn-tân]',
);

/** Hawaiian (Hawai`i)
 */
$messages['haw'] = array(
	'mainpagetext' => "'''Ua pono ka ho‘ouka ‘ana o MediaWiki.'''",
);

/** Hebrew (עברית)
 * @author Amire80
 * @author YaronSh
 * @author ערן
 */
$messages['he'] = array(
	'config-desc' => 'תכנית ההתקנה של מדיה־ויקי',
	'config-title' => 'התקנת מדיה־ויקי $1',
	'config-information' => 'פרטים',
	'config-localsettings-upgrade' => 'זוהה קובץ <code>LocalSettings.php</code>.
כדי לשדרג את ההתקנה הזאת, נא להקליד את הערך של <code>$wgUpgradeKey</code> בתיבה להלן.
אפשר למצוא אותו בקובץ LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'זוהה קובץ LocalSettings.php.
כדי לשדרג את ההתקנה הזאת, הריצו את update.php ולא את הקובץ הזה.',
	'config-localsettings-key' => 'מפתח השדרוג:',
	'config-localsettings-badkey' => 'המפתח שהקלדתם שגוי',
	'config-upgrade-key-missing' => 'זוהתה התקנה קיימת של מדיה־ויקי.
כדי לשדרג את ההתקנה הזאת, אנא כתבו את השורה הבא בתחתית קובץ LocalSettings.php שלכם:

$1',
	'config-localsettings-incomplete' => 'נראה שקובץ LocalSettings.php הקיים אינו שלם.
המשתנה $1 אינו מוגדר.
נו לשנות את קובץ LocalSettings.php שלכם כך שהמשתנה הזה יהיה מוגדר וללחוץ "המשך".',
	'config-localsettings-connection-error' => 'אירעה שגיאה בעת חיבור למסד נתונים עם הגדרות ב־LocalSettings.php או ב־AdminSettings.php. נא לתקן את ההגדרות האלו ולנסות שוב.

$1',
	'config-session-error' => 'שגיאה באתחול שיחה: $1',
	'config-session-expired' => 'נראה שנתוני השיחה שלכם פגו.
השיחות מוגדרות להיות תקפות לזמן של $1.
אפשר להגדיל את זה ב־<code>session.gc_maxlifetime</code> בקובץ php.ini.
יש להתחיל מחדש את תהליך ההתקנה.',
	'config-no-session' => 'נתוני השיחה שלכם אבדו!
יש לבדוק את קובץ php.ini שלכם ולוודא שתיקייה נכונה מוגדרת ב־<code>session.save_path</code>.',
	'config-your-language' => 'השפה שלכם:',
	'config-your-language-help' => 'נא לבחור את השפה שתשמש במהלך ההתקנה.',
	'config-wiki-language' => 'שפת הוויקי:',
	'config-wiki-language-help' => 'נא לבחור את השפה העיקרית שבה ייכתב ויקי זה.',
	'config-back' => '→ חזרה',
	'config-continue' => 'המשך ←',
	'config-page-language' => 'שפה',
	'config-page-welcome' => 'ברוכים הבאים למדיה־ויקי!',
	'config-page-dbconnect' => 'התחברות למסד הנתונים',
	'config-page-upgrade' => 'שדרוג התקנה קיימת',
	'config-page-dbsettings' => 'הגדרות מסד הנתונים',
	'config-page-name' => 'שם',
	'config-page-options' => 'אפשרויות',
	'config-page-install' => 'התקנה',
	'config-page-complete' => 'הושלמה!',
	'config-page-restart' => 'הפעלת ההתקנה מחדש',
	'config-page-readme' => 'קרא־אותי',
	'config-page-releasenotes' => 'הערות גרסה',
	'config-page-copying' => 'העתקה',
	'config-page-upgradedoc' => 'שדרוג',
	'config-page-existingwiki' => 'ויקי קיים',
	'config-help-restart' => 'האם ברצונך לנקות את כל הנתונים שהזנת ולהתחיל מחדש את תהליך ההתקנה?',
	'config-restart' => 'כן, להפעיל מחדש',
	'config-welcome' => '=== בדיקות סביבה ===
בדיקות בסיסיות מתבצעות כדי לבדוק שהסביבה מתאימה להתקנת מדיה־ויקי.
יש לתת את תוצאות הבדיקות האלו אם תזדקקו לעזרה בזמן ההתקנה.',
	'config-copyright' => "=== זכויות יוצרים ותנאים ===

$1

תכנית זו היא תכנה חופשית; באפשרותך להפיצה מחדש ו/או לשנות אותה על פי תנאי הרישיון הציבורי הכללי של GNU כפי שפורסם על ידי קרן התכנה החופשית; בין אם גרסה 2 של הרישיון, ובין אם (לפי בחירתך) כל גרסה מאוחרת שלו.

תכנית זו מופצת בתקווה שתהיה מועילה, אבל '''בלא אחריות כלשהי'''; ואפילו ללא האחריות המשתמעת בדבר '''מסחריותה''' או '''התאמתה למטרה '''מסוימת'''. לפרטים נוספים, ניתן לעיין ברישיון הציבורי הכללי של GNU.

לתכנית זו אמור היה להיות מצורף <doclink href=Copying>עותק של הרישיון הציבורי הכללי של GNU</doclink>; אם לא, עליך לכתוב ל־Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, , MA 02111-1307, USA. או [http://www.gnu.org/copyleft/gpl.html לקרוא אותו דרך האינטרנט].",
	'config-sidebar' => '* [//www.mediawiki.org אתר הבית של מדיה־ויקי]
* [//www.mediawiki.org/wiki/Help:Contents המדריך למשתמשים]
* [//www.mediawiki.org/wiki/Manual:Contents המדריך למנהלים]
* [//www.mediawiki.org/wiki/Manual:FAQ שו״ת]
----
* <doclink href=Readme>קרא אותי</doclink>
* <doclink href=ReleaseNotes>הערות גרסה</doclink>
* <doclink href=Copying>העתקה</doclink>
* <doclink href=UpgradeDoc>שדרוג</doclink>',
	'config-env-good' => 'הסביבה שלכם נבדקה.
אפשר להתקין מדיה־ויקי.',
	'config-env-bad' => 'הסביבה שלכם נבדקה.
אי־אפשר להתקין מדיה־ויקי.',
	'config-env-php' => 'מותקנת <span dir="ltr">PHP $1</span>.',
	'config-env-php-toolow' => 'מותקנת <span dir="ltr">PHP $1</span>.
למדיה־ויקי נדרשת <span dir="ltr">PHP $2</span> או גרסה גבוהה יותר.',
	'config-unicode-using-utf8' => 'משתמש ב־normalize.so של בריון ויבר לנרמול יוניקוד.',
	'config-unicode-using-intl' => 'משתמש בהרחבת [http://pecl.php.net/intl הרחבת intl PECL] לנרמול יוניקוד',
	'config-unicode-pure-php-warning' => "'''אזהרה''': [http://pecl.php.net/intl הרחבת intl PECL] אינה זמינה לטיפול בנרמול יוניקוד. משתמש ביישום PHP טהור ואטי יותר.
אם זהו אתר בעל תעבורה גבוהה, כדאי לקרוא את המסמך הבא: [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode normalization].",
	'config-unicode-update-warning' => "'''אזהרה''': הגרסה המותקנת של מעטפת נרמול יוניקוד משתמשת בגרסה ישנה של הספרייה של [http://site.icu-project.org/ פרויקט ICU].
כדאי [//www.mediawiki.org/wiki/Unicode_normalization_considerations לעדכן] אם חשוב לכם הטיפול ביוניקוד.",
	'config-no-db' => 'לא נמצא דרייבר מסד נתונים מתאים. יש להתקין דרייבר מסד נתונים ל־PHP.
נתמכים הסוגים הבאים של מסדי נתונים: $1.

אם אתם משתמשים באירוח משותף, בקשו מספק האירוח שלכם להתקין דרייבר מסד נתונים מתאים.
אם קִמפלתם את PHP בעצמכם, הגדירו אותו מחדש והפעילו את לקוח מסד נתונים, למשל באמצעות <code dir="ltr">./configure --with-mysql</code>.
אם התקנתם את PHP כחבילה של דביאן או של אובונטו, יש להתקין את המודול php5-mysql.',
	'config-outdated-sqlite' => "'''אזהרה''': במערכת מתוקן SQLite $1. גרסה זו לא נתמכת ולשימוש ב SQLite נדרשת גרסה $2 ומעלה. מסיבה זו האפשרות SQLite לא מאופשרת.",
	'config-no-fts3' => "'''אזהרה''': SQLite מקומפל ללא [//sqlite.org/fts3.html מודול FTS]. יכולות חיפוש לא יהיו זמינות בהתקנה הזאת.",
	'config-register-globals' => "'''אזהרה: האפשרות <code>[http://php.net/register_globals register_globals]</code> של PHP מופעלת.'''
'''כבו אותה אם אתם יכולים.'''
מדיה־ויקי תעבוד, אבל השרת שלכם חשוף לפגיעות אבטחה.",
	'config-magic-quotes-runtime' => "'''שגיאה סופנית: האפשרות [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] פעילה!'''
האפשרות הזאת מעוותת את נתוני הקלט באופן בלתי־צפוי.
לא ניתן להתקין את מדיה־ויקי אלא אם האפשרות הזאת תכובה.",
	'config-magic-quotes-sybase' => "'''שגיאה סופנית''': האפשרות [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] פעילה!'''
האפשרות הזאת מעוותת את נתוני הקלט באופן בלתי־צפוי.
לא ניתן להתקין את מדיה־ויקי או להשתמש בה אלא אם האפשרות הזאת תכובה.",
	'config-mbstring' => "'''שגיאה סופנית''': האפשרות [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] פעילה!'''
האפשרות הזאת גורמת לשגיאות ומעוותת את נתוני הקלט באופן בלתי־צפוי.
לא ניתן להתקין את מדיה־ויקי או להשתמש בה אלא אם האפשרות הזאת תכובה.",
	'config-ze1' => "'''שגיאה סופנית''': האפשרות [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] פעילה!'''
האפשרות הזאת גורמת לתקלות מזעזעות במדיה־ויקי.
לא ניתן להתקין את מדיה־ויקי או להשתמש בה אלא אם האפשרות הזאת תכובה.",
	'config-safe-mode' => "'''אזהרה:''' האפשרות [http://www.php.net/features.safe-mode safe mode] של PHP פעילה.
היא יכולה לגרום לבעיות, במיוחד אם אתם משתמשים בהעלאת קבצים או ב־<code>math</code>.",
	'config-xml-bad' => 'מודול XML של PHP חסר.
מדיה־ויקי דורשת פונקציות של המודול ולא תעבוד עם הגדרות כאלו.
אם מערכת ההפעלה שלהם היא Mandrake, התקינו את החבילה php-xml.',
	'config-pcre' => 'נראה שחסרה תמיכה במודול PCRE.
כדי שמדיה־ויקי תעבוד, נדרשת תמיכה בביטויים רגולריים תואמי Perl.',
	'config-pcre-no-utf8' => "'''שגיאה סופנית''': נראה שמודול PCRE של PHP מקומפל ללא תמיכה ב־PCRE_UTF8.
מדיה־ויקי דורשת תמיכה ב־UTF-8 לפעילות נכונה.",
	'config-memory-raised' => 'ערך האפשרות <code>memory_limit</code> של PHP הוא $1, הועלה ל־$2.',
	'config-memory-bad' => "'''אזהרה:''' ערך האפשרות <code>memory_limit</code> של PHP הוא $1.
זה כנראה נמוך מדי.
ההתקנה עשויה להיכשל!",
	'config-ctype' => "'''שגיאה סופנית''': נדרשת גרסת PHP שתומכת בהרחבה [http://www.php.net/manual/en/ctype.installation.php Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] מותקן',
	'config-apc' => '[http://www.php.net/apc APC] מותקן',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] מותקן',
	'config-no-cache' => "'''אזהרה:''' אחת מהתוכנות הבאות לא נמצאה: [http://www.php.net/apc APC]&rlm;, [http://xcache.lighttpd.net/ XCache] או [http://www.iis.net/download/WinCacheForPhp WinCache].
מטמון עצמים לא מופעל.",
	'config-mod-security' => "'''אזהרה''': בשרת הווב שלכם מופעל [http://modsecurity.org/ mod_security]. אם הוא לא מוגדר טוב, זה יכול לגרום לבעיות במדיה־ויקי ובתכנה אחרת שמאפשרת למשתמשים לשלוח תוכן שרירותי.
קראו את [http://modsecurity.org/documentation/ התיעוד של mod_security] או צרו קשר עם אנשי התמיכה של שירותי האירוח שלכם אם אתם נתקלים בשגיאות אקראיות.",
	'config-diff3-bad' => 'GNU diff3 לא נמצא.',
	'config-imagemagick' => 'נמצא ImageMagick&rlm;: <code dir="ltr">$1</code>.
מזעור תמונות יופעל, אם תפעילו את האפשרות להעלות קבצים.',
	'config-gd' => 'נמצאה ספריית הגרפיקה GD המובנית.
מזעור תמונות יופעל, אם תפעילו את האפשרות להעלות קבצים.',
	'config-no-scaling' => 'ספריית GD או ImageMagick לא נמצאו.
מזעור תמונות לא יופעל.',
	'config-no-uri' => "'''שגיאה:''' אי־אפשר לזהות את הכתובת הנוכחית.
ההתקנה בוטלה.",
	'config-no-cli-uri' => 'אזהרה: לא הוגדר <span dir="ltr">--scriptpath</span>, משתמש בבררת המחדל: <code dir="ltr">$1</code>.',
	'config-using-server' => 'שם השרת בשימוש: "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'נעשה שימוש בכתובת השרת "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''אזהרה:''' תיקיית ההעלאות ההתחלתית <code>$1</code> חשופה להרצת סקריפטים שרירותיים.
מדיה־ויקי בודקת את כל הקבצים המוּעלים לאיומי אבטחה, מומלץ מאוד למנוע את [//www.mediawiki.org/wiki/Manual:Security#Upload_security פרצת האבטחה] הזאת לפני שאתם מפעילים את ההעלאות.",
	'config-no-cli-uploads-check' => "'''אזהרה:''' תיקיית בררת המחדל להעלאות (<code>$1</code>) לא נבדקת לפגיעוּת להרצת תסריטים אקראיים בזמן התקנה דרך CLI.",
	'config-brokenlibxml' => 'במערכת שלכם יש שילוב של גרסאות של PHP ושל libxml2 שחשוף לבאגים ויכול לגרום לעיוות נתונים נסתר במדיה־ויקי וביישומי רשת אחרים.
שדרגו ל־PHP 5.2.9 או לגרסה חדשה יותר ול־libxml2 2.7.3 או גרסה חדשה יותר ([//bugs.php.net/bug.php?id=45996 באג מתויק ב־PHP]).
ההתקנה בוטלה.',
	'config-using531' => 'אי־אפשר להשתמש במדיה־ויקי עם <span dir="ltr">PHP $1</span> בגלל באג בפרמטרים של הפניות (reference parameters) ל־<code dir="ltr">__call()</code>.
שדרגו ל־PHP 5.3.2 או לגרסה גבוהה יותר כדי לתקן את זה ([//bugs.php.net/bug.php?id=50394 bug filed with PHP]) או שַנמכו ל־PHP 5.3.0 כדי לפתור את הבעיה הזאת.
ההתקנה בוטלה.',
	'config-suhosin-max-value-length' => 'מותקן פה Suhosin והוא מגביל את אורך פרמטר GET ל־$1 בתים. רכיב ResourceLoader של מדיה־ויקי יעקוף את המגלבה הזאת, אבל זה יפגע בביצועים. אם זה בכלל אפשרי, כדי לתקן את הערך של suhosin.get.max_value_length ל־1024 בקובץ php.ini ולהגדיר את ‎$wgResourceLoaderMaxQueryLength לאותו הערך בקובץ LocalSettings.php.',
	'config-db-type' => 'סוג מסד הנתונים:',
	'config-db-host' => 'שרת מסד הנתונים:',
	'config-db-host-help' => 'אם שרת מסד הנתונים שלכם נמצא על שרת אחר, הקלידו את שם המחשב או את כתובת ה־IP כאן.

אם אתם משתמשים באירוח משותף, ספק האירוח שלכם אמור לתת לכם את שם השרת הנכון במסמכים.

אם אתם מתקינים בשרת Windows ומשתמשים ב־MySQL, השימוש ב־localhost עשוי לא לעבוד. אם הוא לא עובד, נסו את "127.0.0.1" בתור כתובת ה־IP המקומית.

אם אתם משתמשים ב־PostgreSQL, תשאירו את השדה הזה ריק כדי להתחבר דרך שקע יוניקס.',
	'config-db-host-oracle' => 'TNS של מסד הנתונים:',
	'config-db-host-oracle-help' => 'הקלידו [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm שם חיבור מקומי (Local Connect Name)] תקין; הקובץ tnsnames.ora צריך להיות זמין להתקנה הזאת.<br />
אם אתם משתמשים ב־client libraries 10g או בגרסה חדשה יותר, אתם יכולים גם להשתמש בשיטת מתן השמות [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'זיהוי ויקי זה',
	'config-db-name' => 'שם מסד הנתונים:',
	'config-db-name-help' => 'בחרו שם שמזהה את הוויקי שלכם.
לא צריכים להיות בו רווחים.

אם אתם משתמשים באירוח משותף, ספק האירוח שלכם ייתן לכם שם מסד נתונים מסוים שתוכלו להשתמש בו או יאפשר לכם ליצור מסד נתונים דרך לוח בקרה.',
	'config-db-name-oracle' => 'סכמה של מסד נתונים:',
	'config-db-account-oracle-warn' => 'קיימים שלושה תרחישים נתמכים עבור התקנת אורקל בתור מסד הנתונים:

אם אתם רוצים ליצור חשבון מסד נתונים כחלק מתהליך ההתקנה, נא לספק חשבון בעל תפקיד SYSDBA בתור חשבון מסד הנתונים עבור ההתקנה ולציין את האישורים המבוקשים עבור חשבון הגישה לאינטרנט, אחרת ניתן ליצור באופן ידני את חשבון הגישה לאינטרנט, ולספק חשבון זה בלבד (אם יש לו ההרשאות הדרושות ליצירת עצמי סכמה) או לספק שני חשבונות שונים, אחד עם הרשאות יצירה ואחד מוגבלת עבור גישה לאינטרנט.

סקריפט ליצירת חשבון עם ההרשאות הנדרשות ניתן למצוא בתיקייה "<span dir="ltr">maintenance/oracle/</span>" של ההתקנה זו. זכרו כי שימוש בחשבון מוגבל יגרום להשבתת כל יכולות תחזוקה עם חשבון בררת המחדל.',
	'config-db-install-account' => 'חשבון משתמש להתקנה',
	'config-db-username' => 'שם המשתמש במסד הנתונים:',
	'config-db-password' => 'הססמה במסד הנתונים:',
	'config-db-password-empty' => 'נא להזין ססמה למשתמש מסד הנתונים החדש: $1.
אף־על־פי שאפשר ליצור חשבונות ללא ססמה, זה לא מאובטח.',
	'config-db-install-username' => 'הכניסו שם משתמש שישמש אתכם לחיבור למסד נתונים במהלך ההתקנה.
זהו לא שם משתמש לחשבון במדיה־ויקי; זהו שם משתמש בשרת מסד נתונים.',
	'config-db-install-password' => 'הקלידו ססמה שתשמש אתכם לצורך חיבור למסד נתונים במהלך ההתקנה.
זוהי לא ססמה של חשבון במדיה־ויקי; זוהי ססמה לשרת מסד נתונים.',
	'config-db-install-help' => 'הקלידו את שם המשתמש ואת הססמה להתחברות למסד הנתונים במהלך ההתקנה.',
	'config-db-account-lock' => 'להשתמש באותו שם המשתמש ובאותה ססמה בזמן הפעלה רגילה',
	'config-db-wiki-account' => 'חשבון משתמש להפעלה רגילה',
	'config-db-wiki-help' => 'הקלידו את שם המשתמש והססמה לחיבור למסד הנתונים במהלך פעילות רגילה של הוויקי.
אם החשבון אינו קיים ולחשבון שבו מתבצעת ההתקנה יש הרשאות מספיקות, החשבון הזה ייווצר עם ההרשאות המזעריות הנחוצות להפעלת הוויקי.',
	'config-db-prefix' => 'תחילית לטבלאות של מסד נתונים (database table prefix):',
	'config-db-prefix-help' => 'אם אתם צריכים לשתף מסד נתונים אחד בין אתרי ויקי שונים או בין מדיה־ויקי ויישום וב אחר, תוכלו לבחור להוסיף תחילית וכל שמות הטבלאות כדי להימנע מהתנגשויות.
אל תשתמשו ברווחים.

השדה הזה בדרך כלל אמור להיות ריק.',
	'config-db-charset' => 'קבוצת התווים (character set) של מסד הנתונים',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binary',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 backwards-compatible UTF-8',
	'config-charset-help' => "'''אזהרה:''' אם אתם משתמשים ב־'''backwards-compatible UTF-8''' ב־<span dir=\"ltr\">MySQL 4.1+</span>, ומגבים את מסד הנתונים באמצעות <code>mysqldump</code>, זה יכול להרוס את כל תווי ה־ASCII ויהרוס באופן בלתי־הפיך את הגיבויים שלכם!

ב'''מצב בינרי''' (binary mode) מדיה־ויקי שומרת טקסט UTF-8 במסד הנתונים בשדות בינריים.
זה יעיל יותר ממצב UTF-8 של MySQL ומאפשר לכם להשתמש בכל הטווח של תווי יוניקוד.
ב'''מצב UTF-8'''&rlm; (UTF-8 mode)&rlm; MySQL יֵדַע מה קבוצת התווים (character set) של הטקסט שלכם ויציג וימיר אותו בהתאם, אבל לא יאפשר לכם לשמור תווים שאינם נמצאים בטווח הרב־לשוני הבסיסי ([//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane]).",
	'config-mysql-old' => 'נדרשת גרסה <span dir="ltr">$1</span> של MySQL או גרסה חדשה יותר. הגרסה הנוכחית שלכם היא $2.',
	'config-db-port' => 'פִּתְחַת מסד הנתונים (database port):',
	'config-db-schema' => 'סכמה למדיה־ויקי',
	'config-db-schema-help' => 'הסְכֵמָה הבאה בדרך כלל מתאימה.
שנו אותה רק אם אתם יודעים שאתם חייבים.',
	'config-pg-test-error' => "ההתחברות למסד הנתונים '''$1''' לא מצליחה: $2",
	'config-sqlite-dir' => 'תיקיית נתונים (data directory) של SQLite:',
	'config-sqlite-dir-help' => 'SQLite שומר את כל הנתונים בקובץ אחד.

לשרת הווב צריכה להיות הרשאה לכתוב לתיקייה שאתם מגדירים.

היא לא צריכה נגישה לכולם דרך האינטרנט – בגלל זה איננו שמים אותה באותו מקום עם קובצי ה־PHP.

תוכנת ההתקנה תכתוב קובץ <code dir="ltr">.htaccess</code> יחד אִתו, אבל אם זה ייכשל, מישהו יוכל להשיג גישה למסד הנתונים שלכם. שם נמצא מידע מפורש של משתמשים (כתובות דוא״ל, ססמאות מגובבות) וגם גרסאות מחוקות של דפים ומידע מוגבל אחר.

כדאי לשקול לשים את מסד הנתונים במקום אחר לגמרי, למשל ב־<code dir="ltr">/var/lib/mediawiki/yourwik</code>.',
	'config-oracle-def-ts' => 'מרחב טבלאות לפי בררת מחדל (default tablespace):',
	'config-oracle-temp-ts' => 'מרחב טבלאות זמני (temporary tablespace):',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'מדיה־ויקי תומכת במערכות מסדי הנתונים הבאות:

$1

אם אינכם רואים את מסד הנתונים שלכם ברשימה, עקבו אחר ההוראות המקושרות לעיל כדי להפעיל את התמיכה.',
	'config-support-mysql' => '* $1 הוא היעד העיקרי עבור מדיה־ויקי ולו התמיכה הטובה ביותר (ר׳ [http://www.php.net/manual/en/mysql.installation.php how to compile PHP with MySQL support])',
	'config-support-postgres' => '$1 הוא מסד נתונים נפוץ בקוד פתוח והוא נפוץ בתור חלופה ל־MySQL (ר׳ [http://www.php.net/manual/en/pgsql.installation.php how to compile PHP with PostgreSQL support]). ייתכן שיש בתצורה הזאת באגים מסוימים והיא לא מומלצת לסביבות מבצעיות.',
	'config-support-sqlite' => '* $1 הוא מסד נתונים קליל עם תמיכה טובה מאוד. (ר׳ [http://www.php.net/manual/en/pdo.installation.php How to compile PHP with SQLite support], משתמש ב־PDO)',
	'config-support-oracle' => '* $1 הוא מסד נתונים עסקי מסחרי. (ר׳ [http://www.php.net/manual/en/oci8.installation.php How to compile PHP with OCI8 support])',
	'config-support-ibm_db2' => '* $1 הוא מסד נתונים מסחרי ארגוני.',
	'config-header-mysql' => 'הגדרות MySQL',
	'config-header-postgres' => 'הגדרות PostgreSQL',
	'config-header-sqlite' => 'הגדרות SQLite',
	'config-header-oracle' => 'הגדרות Oracle',
	'config-header-ibm_db2' => 'תצורת IBM DB2',
	'config-invalid-db-type' => 'סוג מסד הנתונים שגוי',
	'config-missing-db-name' => 'עליך להזין ערך עבור "שם מסד הנתונים"',
	'config-missing-db-host' => 'יש להכניס ערך לשדה "שרת מסד הנתונים"',
	'config-missing-db-server-oracle' => 'יש להכניס ערך לשדה "TNS של מסד הנתונים"',
	'config-invalid-db-server-oracle' => '"$1" הוא TNS בלתי תקין.
יש להשתמש רק באותיות ASCII&rlm; (a עד z&rlm;, A עד Z), סְפָרוֹת (0 עד 9), קווים תחתיים (_) ונקודות (.).',
	'config-invalid-db-name' => '"$1" הוא שם מסד נתונים בלתי תקין.
יש להשתמש רק באותיות ASCII&rlm; (a עד z&rlm;, A עד Z), סְפָרוֹת (0 עד 9), קווים תחתיים (_) ומינוסים (-).',
	'config-invalid-db-prefix' => '"$1" היא תחילית מסד נתונים בלתי תקינה.
יש להשתמש רק באותיות ASCII&rlm; (a עד z&rlm;, A עד Z), סְפָרוֹת (0 עד 9), קווים תחתיים (_) ומינוסים (-).',
	'config-connection-error' => '<div dir="ltr">$1.</div>

בדקו את שם השרת, את שם המשתמש ואת הססמה בטופס להלן ונסו שוב.',
	'config-invalid-schema' => '"$1" היא סכמה לא תקינה עבור מדיה־ויקי.
יש להשתמש רק באותיות ASCII&rlm; (a עד z&rlm;, A עד Z), סְפָרוֹת (0 עד 9) וקווים תחתיים (_).',
	'config-db-sys-create-oracle' => 'תוכנית ההתקנה תומכת רק בשימוש בחשבון SYSDBA ליצירת חשבון חדש.',
	'config-db-sys-user-exists-oracle' => 'חשבון המשתמש "$1" כבר קיים. SYSDBA יכול לשמש רק ליצירת חשבון חדש!',
	'config-postgres-old' => 'נדרש PostgreSQL $1 או גרסה חדשה יותר, הגרסה הנוכחית שלכם היא $2.',
	'config-sqlite-name-help' => 'בחרו בשם שמזהה את הוויקי שלכם.
אל תשתמשו ברווחים או במינוסים.
זה יהיה שם קובץ הנתונים ל־SQLite.',
	'config-sqlite-parent-unwritable-group' => 'לא ניתן ליצור את תיקיית הנתונים <code><nowiki>$1</nowiki></code>, כי לשָׁרַת הווב אין הרשאות לכתוב לתיקיית האם <code><nowiki>$2</nowiki></code> .

תוכנת ההתקנה זיהתה את החשבון שתחתיו רץ שרת הווב שלכם.
אפשרו לשָׁרַת הווב לכתוב לתיקייה <code><nowiki>$3</nowiki></code>.
במערכת Unix/Linux כִתבו:

<div dir="ltr"><pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre></div>',
	'config-sqlite-parent-unwritable-nogroup' => 'לא ניתן ליצור את תיקיית הנתונים <code><nowiki>$1</nowiki></code>, כי לשָׁרַת הווב אין הרשאות לכתוב לתיקיית האם <code><nowiki>$2</nowiki></code> .

תוכנת ההתקנה לא זיהתה את החשבון שתחתיו רץ שרת הווב שלכם.
אפשרו לכל החשבונות לכתוב לתיקייה <code><nowiki>$3</nowiki></code> כדי להמשיך.
במערכת Unix/Linux כִתבו:

<div dir="ltr"><pre>cd $2
mkdir $3
chmod a+w $3</pre></div>',
	'config-sqlite-mkdir-error' => 'אירעה שגיאה בעת יצירת תיקיית הנתונים "$1".
נא לבדוק את המיקום ולנסות שוב.',
	'config-sqlite-dir-unwritable' => 'אי־אפשר לכתוב לתיקייה "$1".
שנו את ההרשאות שלה כך ששרת הווב יוכל לכתוב אליה ונסו שוב.',
	'config-sqlite-connection-error' => '$1.

בִדקו את תיקיית הנתונים את שם מסת הנתונים להלן ונסו שוב.',
	'config-sqlite-readonly' => 'לא ניתן לכתוב אל הקובץ <code>$1</code>.',
	'config-sqlite-cant-create-db' => 'לא ניתן ליצור את קובץ מסד הנתונים <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'ב־PHP חסרה תמיכה ב־FTS3, יבתצע שנמוך טבלאות',
	'config-can-upgrade' => "יש טבלאות מדיה־ויקי במסד הנתונים.
כדי לשדרג אותן למדיה־ויקי $1, לחצו '''המשך'''.",
	'config-upgrade-done' => "השדרוג הושלם.

עכשיו אפשר [$1 להשתמש בוויקי שלכם].

אם תרצו ליצור מחדש את קובץ ה־<code>LocalSettings.php</code> שלכם, לחצו על הכפתור להלן.
זה '''לא מומלץ''', אלא אם כן יש לכם בעיות עם הוויקי שלכם.",
	'config-upgrade-done-no-regenerate' => 'השדרוג הושלם.

עכשיו אפשר [$1 להתחיל להשתמש בוויקי שלכם].',
	'config-regenerate' => 'לחולל מחדש את LocalSettings.php ←',
	'config-show-table-status' => 'שאילתת SHOW TABLE STATUS נכשלה!',
	'config-unknown-collation' => "'''אזהרה:''' מסד הנתונים משתמש בשיטת מיון שאינה מוּכּרת.",
	'config-db-web-account' => 'חשבון במסד הנתונים לגישה מהרשת',
	'config-db-web-help' => 'לבחור את שם המשתמש ואת הססמה ששרת הווב ישתמש בו להתחברות לשרת מסד הנתונים בזמן פעילות רגילה של הוויקי.',
	'config-db-web-account-same' => 'להשתמש באותו חשבון כמו עבור ההתקנה',
	'config-db-web-create' => 'ליצור חשבון אם הוא אינו קיים כבר.',
	'config-db-web-no-create-privs' => 'לחשבון שהקלדתם להתקנה אין מספיק הרשאות ליצירת חשבות.
החשבון שאתם מקלידים כאן צריך להיות קיים.',
	'config-mysql-engine' => 'מנגנון האחסון:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''אזהרה''': בחרתם ב־MyISAM בתור מנוע אחסון של MySQL, וזה לא מומלץ מהסיבות הבאות:
* המנוע הזה בקושי תומך בעיבוד מקבילי בגלל נעילת טבלאות
* הוא פחות עמיד בפני אובדן מידע ממנועים אחרים
* הקוד של מדיה־ויקי לא תמיד מטפל ב־MyISAM כפי שצריך

אם התקנת MySQL שלכם תומכת ב־InnoDB, מומלץ מאוד שתבחרו באפשרות הזאת.
אם התקנת MySQL שלכם אינה תומכת ב־InnoDB, אולי זה הזמן לשקול לשדרג אותה.",
	'config-mysql-engine-help' => "'''InnoDB''' הוא כמעט תמיד האפשרות הטובה ביותר, כי במנוע הזה יש תמיכה טובה ביותר בעיבוד מקבילי.

'''MyISAM''' עשוי להיות בהתקנות שמיועדות למשתמש אחד ולהתקנות לקריאה בלבד.
מסדי נתונים עם MyISAM נוטים להיהרס לעתים קרובות יותר מאשר מסדי נתונים עם InnoDB.",
	'config-mysql-charset' => 'ערכת הקידוד של מסד הנתונים:',
	'config-mysql-binary' => 'בינרי',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "ב'''מצב בינרי''' (binary mode) מדיה־ויקי שומרת טקסט UTF-8 במסד הנתונים בשדות בינריים.
זה יעיל יותר ממצב UTF-8 של MySQL ומאפשר לכם להשתמש בכל הטווח של תווי יוניקוד.

ב'''מצב UTF-8'''&rlm; (UTF-8 mode)&rlm; MySQL יֵדַע מה קבוצת התווים (character set) של הטקסט שלכם ויציג וימיר אותו בהתאם, אבל לא יאפשר לכם לשמור תווים שאינם נמצאים בטווח הרב־לשוני הבסיסי ([//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane]).",
	'config-ibm_db2-low-db-pagesize' => "במסד הנתונים DB2 שלכם יש מרחב טבלאות לפי מחדלי עם גודל דף בלתי־מספיק. גודל הדף צריך להיות '''32K''' או יותר.",
	'config-site-name' => 'שם הוויקי:',
	'config-site-name-help' => 'זה יופיע בשורת הכותרת של הדפדפן ובמקומות רבים אחרים.',
	'config-site-name-blank' => 'נא להזין שם לאתר.',
	'config-project-namespace' => 'מרחב שמות לדפי מיזם:',
	'config-ns-generic' => 'מיזם',
	'config-ns-site-name' => 'זהה לשם הוויקי: $1',
	'config-ns-other' => 'אחר (לציין)',
	'config-ns-other-default' => 'הוויקי שלי',
	'config-project-namespace-help' => "בהתאם לדוגמה של ויקיפדיה, אתרי ויקי רבים שומרים על דפי המדיניות שלהם בנפרד מדפי התוכן שלהם ב\"'''מרחב השמות של המיזם'''\" (\"'''project namespace'''\").
כל שמות הדפים במרחב השמות הזה מתחילים בתחילית מסוימת שאתם יכולים להגדיר כאן.
באופן מסורתי התחילית הזאת מבוססת על שם הוויקי, והיא אינה יכולה להכיל תווי פיסוק כגון \"#\" או \":\".",
	'config-ns-invalid' => 'מרחב השמות "<nowiki>$1</nowiki>" אינו תקין.
הקלידו שם אחר למרחב השמות של המיזם.',
	'config-ns-conflict' => 'מרחב השמות שהגדרתם "<nowiki>$1</nowiki>" מתנגש עם מרחב שמות מובנה של מדיה־ויקי.
הגדירו מרחב שמות מיזם שונה.',
	'config-admin-box' => 'חשבון מפעיל',
	'config-admin-name' => 'שמכם:',
	'config-admin-password' => 'ססמה:',
	'config-admin-password-confirm' => 'הססמה שוב:',
	'config-admin-help' => 'הקלידו כאן את שם המשתמש, למשל "שקד לוי" או "Joe Bloggs".
זה השם שישמש אתכם כדי להיכנס לוויקי.',
	'config-admin-name-blank' => 'נא להזין את שם המשתמש של המפעיל.',
	'config-admin-name-invalid' => 'שם המשתמש שהוקלד "<nowiki>$1</nowiki>" אינו תקין.
הקלידו שם משתמש אחר.',
	'config-admin-password-blank' => 'הקלידו ססמה לחשבון המפעיל.',
	'config-admin-password-same' => 'הססמה לא יכולה להיות זהה לשם המשתמש.',
	'config-admin-password-mismatch' => 'שתי הססמאות שהוזנו אינן מתאימות.',
	'config-admin-email' => 'כתובת הדוא״ל:',
	'config-admin-email-help' => 'הקלידו כתובת דוא״ל שתאפשר לכם לקבל מכתבים ממשתמשים אחרים בוויקי, לאתחל את הססמה, ולקבל הודעות על שינויים בדפים ברשימת המעקב שלכם. אפשר להשאיר את השדה הזה ריק.',
	'config-admin-error-user' => 'שגיאה פנימית ביצירת מפעיל בשם "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'שגיאה פנימית בהגדרת ססמה עבור המפעיל "<nowiki>$1</nowiki>"&rlm;: <pre>$2</pre>',
	'config-admin-error-bademail' => 'הכנסתם כתובת דוא״ל לא תקינה.',
	'config-subscribe' => 'להירשם ל[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce רשימת התפוצה עם הודעות על גרסאות חדשות].',
	'config-subscribe-help' => 'זוהי רשימת תפוצה עם הודעות מעטות שמשמשת להודעות על הוצאת גרסאות, כולל עדכוני אבטחה חשובים.
מומלץ להירשם אליה ולעדכן את מדיה־ויקי כאשר יוצאות גרסאות חדשות.',
	'config-subscribe-noemail' => 'ניסיתם להירשם לרשימת תפוצה של הודעות בלי לתת כתובת דוא"ל.
נא לתת כתובת דוא"ל אם אתם רוצים להירשם לרשימת התפוצה.',
	'config-almost-done' => 'כמעט סיימתם!
אפשר לדלג על שאר ההגדרות ולהתקין את הוויקי כבר עכשיו.',
	'config-optional-continue' => 'הצגת שאלות נוספות.',
	'config-optional-skip' => 'משעמם לי, תתקינו לי כבר את הוויקי הזה.',
	'config-profile' => 'תסריט הרשאות משתמשים:',
	'config-profile-wiki' => 'ויקי מסורתי',
	'config-profile-no-anon' => 'נדרשת יצירת חשבון',
	'config-profile-fishbowl' => 'עורכים מורשים בלבד',
	'config-profile-private' => 'ויקי פרטי',
	'config-profile-help' => "אתרי ויקי עובדים הכי טוב כאשר אתם מאפשרים לכמה שיותר אנשים לערוך אותם.
במדיה־ויקי קל לסקור את השינויים האחרונים ולשחזר כל נזק שעושים משתמשים תמימים או משחיתים.

עם זאת, אנשים שונים מצאו למדיה־ויקי שימושים מגוּונים ולעתים לא קל לשכנע את כולם ביתרונות של \"דרך הוויקי\" המסורתית. ולכן יש לכם בררה.

באתר '''{{int:config-profile-wiki}}''' – לכולם יש הרשאה לערוך, אפילו בלי להיכנס לחשבון.
באתר וויקי מסוג '''{{int:config-profile-no-anon}}''' יש ביטחון גדול יותר, אבל הגדרה כזאת יכולה להרתיע תורמים מזדמנים.

בתסריט '''{{int:config-profile-fishbowl}}''' רק משתמשים שקיבלו אישור יכולים לערוך, אבל כל הגולשים יכולים לקרוא את הדפים ואת גרסאותיהם הקודמות.
ב'''{{int:config-profile-private}}''' רק משתמשים שקיבלו אישור יכולים לקרוא ולערוך דפים.

הגדרות מורכבות של הרשאות אפשריות אחרי ההתקנה, ר׳ את [//www.mediawiki.org/wiki/Manual:User_rights הפרק על הנושא הזה בספר ההדרכה].",
	'config-license' => 'זכויות יוצרים ורישיון:',
	'config-license-none' => 'ללא כותרת תחתית עם רישיון',
	'config-license-cc-by-sa' => 'קריאייטיב קומונז–ייחוס–שיתוף זהה',
	'config-license-cc-by' => 'קריאייטיב קומונז–ייחוס',
	'config-license-cc-by-nc-sa' => 'קריאייטיב קומונז ייחוס–ללא שימוש מסחרי–שיתוף זהה',
	'config-license-cc-0' => 'קריאייטיב קומונז אפס (נחלת הכלל)',
	'config-license-gfdl' => 'רישיון חופשי למסמכים של גנו גרסה 1.3 או חדשה יותר',
	'config-license-pd' => 'נחלת הכלל',
	'config-license-cc-choose' => 'בחרו רישיון קריאייטיב קומונז מותאם אישית',
	'config-license-help' => "אתרי ויקי ציבוריים רבים מפרסמים את כל התרומות תחת [http://freedomdefined.org/Definition רישיון חופשי].
זה עוזר ליצור תחושה של בעלות קהילתית ומעודד תרומה לאורך זמן.
זה בדרך כלל לא נחוץ לאתר ויקי פרטי או בחברה מסחרית.

אם אתם רוצים אפשרות להשתמש בטקסט מוויקיפדיה ואתם רוצים שוויקיפדיה תוכל לקבל עותקים של טקסטים מהוויקי שלכם, כדאי לכם לבחור ב'''רישיון קריאייטיב קומונז ייחוס–שיתוף זהה''' (CC-BY-SA).

ויקיפדיה השתמשה בעבר ברישיון החופשי למסמכים של גנו (GNU FDL או GFDL).
הוא עדיין רישיון תקין, אבל קשה להבנה.
כמו־כן, קשה לעשות שימוש חוזר ביצירות שפורסמו לפי GFDL.",
	'config-email-settings' => 'הגדרות דוא״ל',
	'config-enable-email' => 'להפעיל דוא״ל יוצא',
	'config-enable-email-help' => 'אם אתם רוצים שדוא״ל יעבוד, [http://www.php.net/manual/en/mail.configuration.php אפשרויות הדוא״ל של PHP] צריכות להיות מוגדרות נכון.
אם אינכם רוצים להפעיל שום אפשרויות דוא״ל, כבו אותן כאן ועכשיו.',
	'config-email-user' => 'להפעיל שליחת דוא״ל ממשתמש למשתמש',
	'config-email-user-help' => 'לאפשר לכל המשתמשים לשלוח אחד לשני דוא״ל אם הם הפעילו את זה בהעדפות שלהם.',
	'config-email-usertalk' => 'להפעיל הודעות על דף שיחת משתמש',
	'config-email-usertalk-help' => 'לאפשר למשתמשים לקבל הודעות על שינויים בדפי המשתמש שלהם, אם הם הפעילו את זה בהעדפות שלהם.',
	'config-email-watchlist' => 'הפעלת התרעה על רשימת המעקב',
	'config-email-watchlist-help' => 'לאפשר למשתמשים לקבל הודעות על הדפים ברשימת המעקב שלהם אם הם הפעילו את זה בהעדפות שלהם.',
	'config-email-auth' => 'הפעלת התרעה בדוא״ל',
	'config-email-auth-help' => "אם האפשרות הזאת מופעלת, משתמשים יצטרכו לאשר את כתובת הדוא״ל שלהם באמצעות קישור שיישלח אליהם בכל פעם שהם יגדירו או ישנו אותה.
רק כתובות דוא״ל מאושרות יכולות לקבלת דוא״ל ממשתמשים אחרים או מכתבים עם הודעות על שינויים.
'''מומלץ''' להגדיר את האפשרות הזאת לאתרי ויקי ציבוריים כי אפשר לעשות שימוש לרעה בתכונות הדוא״ל.",
	'config-email-sender' => 'כתובת דוא״ל לתשובות:',
	'config-email-sender-help' => 'הכניסו את כתובת הדוא״ל שתשמש ככתובת לתשובה לכל הדואר היוצא.
לשם יישלחו תגובות שגיאה (bounce).
שרתי דוא״ל רבים דורשים שלפחות החלק של המתחם יהיה תקין.',
	'config-upload-settings' => 'העלאת קבצים ותמונות',
	'config-upload-enable' => 'להפעיל העלאת קבצים',
	'config-upload-help' => 'העלאות קבצים חושפות את השרת שלכם לסיכוני אבטחה.
למידע נוסף, קִראו את [//www.mediawiki.org/wiki/Manual:Security חלק האבטחה] בספר ההדרכה.

כדי להפעיל העלאת קבצים שנו את ההרשאות של התיקייה <code>images</code> תחת תיקיית השורש של מדיה־ויקי כך ששרת הווב יוכל לכתוב אליה.
זה מפעיל את האפשרות הזאת.',
	'config-upload-deleted' => 'תיקיית לקבצים שנמחקו:',
	'config-upload-deleted-help' => 'בחרו את התיקייה לארכוב קבצים מחוקים.
כדאי שזה לא יהיה נגיש לכל העולם דרך הרשת.',
	'config-logo' => 'כתובת הסמל:',
	'config-logo-help' => 'המראה ההתחלתי של מדיה־ויקי מכיל מקום לסמל של 135 על 160 פיקסלים בפינה העליונה מעל תפריט הצד.
יש להעלות תמונה בגודל מתאים ולהכניס את הכתובת כאן.

אם אינכם רוצים סמל, השאירו את התיבה הזאת ריקה.',
	'config-instantcommons' => 'להפעיל את Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] היא תכונה שמאפשרת לאתרי ויקי להשתמש בתמונות, בצלילים ובמדיה אחרת שנמצאת באתר [//commons.wikimedia.org/ ויקישיתוף] (Wikimedia Commons).
כדי לעשות את זה, מדיה־ויקי צריך לגשת לאינטרנט.

למידע נוסף על התכונה הזאת, כולל הוראות איך להפעיל את זה לאתרי ויקי שאינם ויקישיתוף, ר׳ [//mediawiki.org/wiki/Manual:$wgForeignFileRepos את ספר ההדרכה].',
	'config-cc-error' => 'בורר רישיונות קריאייטיב קומונז לא החזיר שום תוצאה.
הקלידו את שם הרישיון ידנית.',
	'config-cc-again' => 'נא לבחור שוב...',
	'config-cc-not-chosen' => 'בחרו באיזה רישיון קריאייטיב קומונז להשתמש ולחצו "המשך".',
	'config-advanced-settings' => 'הגדרות מתקדמות',
	'config-cache-options' => 'הגדרות למטמון עצמים (object caching):',
	'config-cache-help' => 'מטמון עצמים משמש לשיפור המהירות של מדיה־ויקי על־ידי שמירה של נתונים שהשימוש בהם נפוץ במטמון.
לאתרים בינוניים וגדולים כדאי מאוד להפעיל את זה, וגם אתרים קטנים ייהנו מזה.',
	'config-cache-none' => 'ללא מטמון (שום יכולת אינה מוּסרת, אבל הביצועים באתרים גדולים ייפגעו)',
	'config-cache-accel' => 'מטמון עצמים (object caching) של PHP&rlm; (APC&rlm;, XCache או WinCache)',
	'config-cache-memcached' => 'להשתמש ב־Memcached (דורש התקנות והגדרות נוספות)',
	'config-memcached-servers' => 'שרתי Memcached:',
	'config-memcached-help' => 'רשימת כתובות IP ש־Memcached ישתמש בהן.
יש לרשום כתובת אחת בכל שורה ולציין את הפִּתְחָה (port), למשל:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'בחרת ב־Memcached בתתור סוג המטמון שלכם, אבל לא הגדרתם שום שרת.',
	'config-memcache-badip' => 'הקלדתם כתובת IP בלתי תקינה ל־Memcached&lrm;: $1.',
	'config-memcache-noport' => 'לא הגדרתם פתחה לשימוש שרת Memcached&rlm;: $1.
אם אינכם יודעים את מספר הפתחה, בררת המחדל היא 11211.',
	'config-memcache-badport' => 'מספרי פתחה של Memcached צריכים להיות בין $1 ל־$2',
	'config-extensions' => 'הרחבות',
	'config-extensions-help' => 'ההרחבות ברשימה לעיל התגלו בתיקיית <span dir="ltr"><code>./extensions</code></span> שלכם.

ייתכן שזה ידרוש הגדרות נוספות, אבל תוכלו להפעיל אותן עכשיו.',
	'config-install-alreadydone' => "'''אזהרה:''' נראה שכבר התקנתם את מדיה־ויקי ואתם מנסים להתקין אותה שוב.
אנה התקדמו לדף הבא.",
	'config-install-begin' => 'כשתלחצו על "{{int:config-continue}}", תתחילו את ההתקנה של מדיה־ויקי.
אם אתם עדיין רוצים לשנות משהו, לחצו על "הקודם".',
	'config-install-step-done' => 'בוצע',
	'config-install-step-failed' => 'נכשל',
	'config-install-extensions' => 'כולל הרחבות',
	'config-install-database' => 'הקמת מסד נתונים',
	'config-install-schema' => 'יצירת סכמה',
	'config-install-pg-schema-not-exist' => 'סכמה של PostgreSQL אינה קיימת',
	'config-install-pg-schema-failed' => 'יצירת טבלאות נכשלה.
ודאו כי המשתמש "$1" יכול לכתוב לסכמה "$2".',
	'config-install-pg-commit' => 'שמירת שינויים',
	'config-install-pg-plpgsql' => 'בדיקת שפת PL/pgSQL',
	'config-pg-no-plpgsql' => 'צריך להתקין את שפת PL/pgSQL במסד הנתונים $1',
	'config-pg-no-create-privs' => 'לחשבון שהגדרתם להתקנה אין מספיק הרשאות ליצירת חשבון.',
	'config-pg-not-in-role' => 'החשבון שציינתם עבור משתמש שרת הווב כבר קיים.
החשבון שסיפקתם להתקנה אינו חשבון בעל הרשאות (superuser) ואינו חבר בתפקיד (role) של משתמש שרת הווב, אז אין אפשרות ליצור עצמים בבעלות משתמש שרת הווב.

כעת נדרש במדיה־ויקי שהטבלאות יהיו בבעלות של משתמש שרת הווב. נא לציין שם חשבון שרת וב אחר או ללחוץ על כפתור "אחורה" ולציין משתמש התקנה בעל הרשאות מתאימות.',
	'config-install-user' => 'יצירת חשבון במסד נתונים',
	'config-install-user-alreadyexists' => 'המשתמש "$1" כבר קיים',
	'config-install-user-create-failed' => 'יצירת משתמש "$1" נכשלה: $2',
	'config-install-user-grant-failed' => 'מתן הרשאות למשתמש "$1" נכשל: $2',
	'config-install-user-missing' => 'המשתמש "$1" שצוין אינו קיים.',
	'config-install-user-missing-create' => 'המשתמש "$1" שצוין אינו קיים.
נא ללחוץ על תיבת בסימון "יצירת חשבון" להלן אם אתם רוצים ליצור אותו.',
	'config-install-tables' => 'יצירת טבלאות',
	'config-install-tables-exist' => "'''אזהרה:''' נראה שטבלאות מדיה־ויקי כבר קיימות.
מדלג על יצירתן.",
	'config-install-tables-failed' => "'''שגיאה:''' יצירת הטבלה נכשלה עם השגיאה הבאה: $1",
	'config-install-interwiki' => 'אכלוס טבלת בינוויקי התחלתית',
	'config-install-interwiki-list' => 'קריאת הקובץ <code>interwiki.list</code> לא הצליחה.',
	'config-install-interwiki-exists' => "'''אזהרה:''': נראה שבטבלת הבינוויקי כבר יש רשומות.
מדלג על הרשומה ההתחלתית.",
	'config-install-stats' => 'אתחול סטטיסטיקות',
	'config-install-keys' => 'יצירת מפתחות סודיים',
	'config-insecure-keys' => "'''אזהרה''': {{PLURAL:$2|מפתח|מפתחות}} אבטחה ($1) {{PLURAL:$2|שנוצר|שנוצרו}} במהלך ההתקנה {{PLURAL:$2|אינו בטוח|אינם בטוחים}} מספיק. מומלץ לשקול לשנות {{PLURAL:$2|אותו|אותם}} ידנית.",
	'config-install-sysop' => 'יצירת חשבון מפעיל',
	'config-install-subscribe-fail' => 'הרישום ל־mediawiki-announce לא הצליח: $1',
	'config-install-subscribe-notpossible' => 'cURL אינה מותקנת ו־allow_url_fopen אינה זמינה.',
	'config-install-mainpage' => 'יצירת דף ראשי עם תוכן התחלתי.',
	'config-install-extension-tables' => 'יצירת טבלאות להרחבות מופעלות',
	'config-install-mainpage-failed' => 'לא הצליחה הכנסת דף ראשי: $1.',
	'config-install-done' => "'''מזל טוב!'''
התקנתם בהצלחה את מדיה־ויקי.

תוכנת ההתקנה יצרה את הקובץ <code>LocalSettings.php</code>.
הוא מכיל את כל ההגדרות שלכם.

תצטרכו להוריד אותו ולשים אותו בבסיס ההתקנה של הוויקי שלכם (אותה התיקייה שבה נמצא הקובץ index.php). ההורדה הייתה אמורה להתחיל באופן אוטומטי.

אם ההורדה לא התחילה, או אם ביטלתם אותה, אפשר להתחיל אותה מחדש בלחיצה על הקישור הבא:

$3

'''שימו לב''': אם לא תעשו זאת עכשיו, קובץ ההגדרות המחוּלל לא יהיה זמין לכם שוב.

אחרי שתעשו את זה, תוכלו '''[$2 להיכנס לוויקי שלכם]'''.",
	'config-download-localsettings' => 'הורדת LocalSettings.php',
	'config-help' => 'עזרה',
	'config-nofile' => 'הקובץ "$1" לא נמצא. האם הוא נמחק?',
	'mainpagetext' => "'''תוכנת מדיה־ויקי הותקנה בהצלחה.'''",
	'mainpagedocfooter' => 'היעזרו ב[//meta.wikimedia.org/wiki/Help:Contents מדריך למשתמש] למידע על שימוש בתוכנת הוויקי.

== קישורים שימושיים ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings רשימת ההגדרות]
* [//www.mediawiki.org/wiki/Manual:FAQ שאלות ותשובות על מדיה־ויקי]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce רשימת התפוצה על השקת גרסאות]',
);

/** Hindi (हिन्दी)
 */
$messages['hi'] = array(
	'mainpagetext' => "'''मीडियाविकिका इन्स्टॉलेशन पूरा हो गया हैं ।'''",
	'mainpagedocfooter' => 'विकि सॉफ्टवेयरके इस्तेमाल के लिये [//meta.wikimedia.org/wiki/Help:Contents उपयोगकर्ता गाईड] देखें ।

== शुरुवात करें ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings कॉन्फिगरेशन सेटींगकी सूची]
* [//www.mediawiki.org/wiki/Manual:FAQ मीडियाविकिके बारे में प्राय: पूछे जाने वाले सवाल]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce मीडियाविकि मेलिंग लिस्ट]',
);

/** Fiji Hindi (Latin script) (Fiji Hindi)
 * @author Thakurji
 */
$messages['hif-latn'] = array(
	'mainpagetext' => "'''MediaWiki ke safalta se install kar dewa gais hai.'''",
	'mainpagedocfooter' => "Wiki software ke use kare ke aur jaankari ke khatir [//meta.wikimedia.org/wiki/Help:Contents User's Guide] ke dekho.

== Getting started ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Hiligaynon (Ilonggo)
 * @author Anjoeli9806
 */
$messages['hil'] = array(
	'mainpagetext' => "'''Ang MediaWiki madinalag-on nga na-instala.'''",
	'mainpagedocfooter' => " Magkonsulta sa [//meta.wikimedia.org/wiki/Help:Contents User's Guide] para sa mga impormasyon sa paggamit sang wiki nga software.

== Pag-umpisa ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista sang mga konpigorasyon sang pagkay-o]
* [//www.mediawiki.org/wiki/Manual:FAQ Mga Masami Pamangkoton sa MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista sang mga ginapadal-an sang sulat kon may paguha-on nga MediaWiki]",
);

/** Croatian (hrvatski)
 */
$messages['hr'] = array(
	'mainpagetext' => "'''Softver MediaWiki je uspješno instaliran.'''",
	'mainpagedocfooter' => 'Pogledajte [//meta.wikimedia.org/wiki/MediaWiki_localisation dokumentaciju o prilagodbi sučelja]
i [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide Vodič za suradnike] za pomoć pri uporabi i podešavanju.',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'config-desc' => 'Instalaciski program za MediaWiki',
	'config-title' => 'Instalacija MediaWiki $1',
	'config-information' => 'Informacije',
	'config-localsettings-upgrade' => 'Dataja <code>LocalSettings.php</code> je so wotkryła.
Zo by tutu instalaciju aktualizował, zapodaj prošu hódnotu za parameter <code>$wgUpgradeKey</code> do slědowaceho pola.
Namakaš tón parameter w dataji LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Dataja LocalSettings.php bu wotkryta.
Zo by tutu instalaciju aktualizował, wuwjedźće update.php',
	'config-localsettings-key' => 'Aktualizaciski kluč:',
	'config-localsettings-badkey' => 'Kluč, kotryž sy podał, je wopak',
	'config-upgrade-key-missing' => 'Eksistowaca instalacija MediaWiki je so wotkryła.
Zo by tutu instalaciju aktualizował, staj prošu slědowacu linku deleka w dataji LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Zda so, zo eksistwoaca dataja LocalSettings.php je njedospołna.
Wariabla $1 njeje nastajena.
Prošu změń dataju LocalSettings.php, zo by so tuta wariabla nastajiła a klikń na "Dale".',
	'config-localsettings-connection-error' => 'Při zwjazowanju z datowej banku z pomocu nastajenjow podatych w LocalSettings.php abo AdminSettings.php je zmylk wustupił. Prošu skoriguj tute nastajenja a spytaj hišće raz.

$1',
	'config-session-error' => 'Zmylk při startowanju posedźenja: $1',
	'config-session-expired' => 'Zda so, zo twoje posedźenske daty su spadnjene.
Posedźenja su za čas žiwjenja $1 skonfigurowane.
Móžeš jón přez nastajenje <code>session.gc_maxlifetime</code> w php.ini powyšić.
Startuj instalaciski proces znowa.',
	'config-no-session' => 'Twoje posedźenske daty su so zhubili!
Skontroluj swój php.ini a zawěsć, zo <code>session.save_path</code> je na prawy zapis nastajeny.',
	'config-your-language' => 'Twoja rěč:',
	'config-your-language-help' => 'Wubjer rěč, kotraž ma so za instalaciski proces wužiwać.',
	'config-wiki-language' => 'Wikirěč:',
	'config-wiki-language-help' => 'Wubjer rěč, w kotrejž wiki ma so zwjetša pisać.',
	'config-back' => '← Wróćo',
	'config-continue' => 'Dale →',
	'config-page-language' => 'Rěč',
	'config-page-welcome' => 'Witaj do MediaWiki!',
	'config-page-dbconnect' => 'Z datowej banku zwjazać',
	'config-page-upgrade' => 'Eksistowacu instalaciju aktualizować',
	'config-page-dbsettings' => 'Nastajenja datoweje banki',
	'config-page-name' => 'Mjeno',
	'config-page-options' => 'Opcije',
	'config-page-install' => 'Instalować',
	'config-page-complete' => 'Dokónčeny!',
	'config-page-restart' => 'Instalaciju znowa startować',
	'config-page-readme' => 'Čitaj mje',
	'config-page-releasenotes' => 'Wersijowe informacije',
	'config-page-copying' => 'Kopěrowanje',
	'config-page-upgradedoc' => 'Aktualizowanje',
	'config-page-existingwiki' => 'Eksistowacy wiki',
	'config-help-restart' => 'Chceš wšě składowane daty hašeć, kotrež sy zapodał a instalaciski proces znowa startować?',
	'config-restart' => 'Haj, znowa startować',
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki Startowa strona MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Nawod za wužiwarjow]
* [//www.mediawiki.org/wiki/Manual:Contents Nawod za administratorow]
* [//www.mediawiki.org/wiki/Manual:FAQ Huste prašenja]
----
* <doclink href=Readme>Čitaj mje</doclink>
* <doclink href=ReleaseNotes>Wersijowe informacije</doclink>
* <doclink href=Copying>Licencne postajenja</doclink>
* <doclink href=UpgradeDoc>Aktualizacija</doclink>',
	'config-env-good' => 'Wokolina je so skontrolowała.
Móžeš MediaWiki instalować.',
	'config-env-bad' => 'Wokolina je so skontrolowała.
Njemóžeš MediaWiki instalować.',
	'config-env-php' => 'PHP $1 je instalowany.',
	'config-env-php-toolow' => 'PHP $1 je instalowany.
Ale MediaWiki wužaduje sej PHP $2 abo wyši.',
	'config-unicode-using-utf8' => 'Za normalizaciju Unicode so utf8_normalize.so Briona Vibbera wužiwa.',
	'config-unicode-using-intl' => 'Za normalizaciju Unicode so [http://pecl.php.net/intl PECL-rozšěrjenje intl] wužiwa.',
	'config-no-db' => 'Njeda so přihódny ćěrjak datoweje banki namakać! Dyrbiš ćěrjak datoweje banki za PHP instalować.
Slědowace typy datoweje banki so podpěruja: $1.

Jeli wužiwaš zhromadnje wužiwany serwer, proš swojeho poskićowarja, zo by přihódny ćěrjak datoweje banki instalował.
Jeli sy PHP sam kompilował, konfiguruj jón znowa z aktiwizowanym programom datoweje banki, na přikład z pomocu <code>./configure --with-mysql</code>.
Jeli sy PHP z Debianoweho abo Ubuntuoweho paketa instalował, dyrbiš tež modul php5-mysql instalować.',
	'config-outdated-sqlite' => "'''Warnowanje''': maš SQLite $1, kotryž je starši hač minimalna trěbna wersija $2. SQLite njebudźe k dispoziciji stać.",
	'config-no-fts3' => "'''Warnowanje''': SQLite je so bjez [//sqlite.org/fts3.html FTS3-modula] kompilował, pytanske funkcije njebudu k dispoziciji stać.",
	'config-register-globals' => "'''Warnowanje: Funkcija <code>[http://php.net/register_globals register_globals]</code> PHP je zmóžnjena.'''
'''Znjemóžń ju, jeli móžeš.'''
MediaWiki budźe fungować, ale twój serwer je potencielnym wěstotnym njedostatkam wustajeny.",
	'config-ze1' => "'''Chutny zmylk: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] je aktiwny!'''
Tuta opcija zawinuje grawěrowace zmylki při MediaWiki.
Njemóžeš MediaWiki instalować abo wužiwać, chibazo tuta opcija je znjemóžnjena.",
	'config-safe-mode' => "'''Warnowanje:''' [http://www.php.net/features.safe-mode wěsty modus] PHP je aktiwny.
To móže problemy zawinować, předewšěm, jeli so datajowe nahraća a podpěra <code>math</code> wužiwaja.",
	'config-xml-bad' => 'XML-modul za PHP faluje.
MediaWiki trjeba funkcije w tutym modulu a njebudźe w tutej konfiguraciji fungować.
Jeli wužiwaš Mandrake, instaluj paket php-xml.',
	'config-pcre' => 'Zda so, zo modul za PCRE-podpěru faluje.
MediaWiki trjeba z Perl kompatibelne funkcije za regularne wurazy, zo by fungował.',
	'config-pcre-no-utf8' => "'''Ćežki zmylk''': Zda so, zo PCRE-modul za PHP ma so bjez PCRE_UTF8-podpěry kompilować.
MediaWiki trjeba UTF-8-podpěru, zo by korektnje fungował.",
	'config-memory-raised' => 'PHP-parameter <code>memory_limit</code> je $1, je so na hódnotu $2 zwyšił.',
	'config-memory-bad' => "'''Warnowanje:''' PHP-parameter <code>memory_limit</code> ma hódnotu $1,
To je najskerje přeniske.
Instalacija móhła so njeporadźić!",
	'config-ctype' => "'''Ćežki zmylk''': PHP dyrbi so z podpěru za [http://www.php.net/manual/en/ctype.installation.php rozšěrjenje Ctype] kompilować.",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] je instalowany',
	'config-apc' => '[http://www.php.net/apc APC] je instalowany',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] je instalowany',
	'config-diff3-bad' => 'GNU diff3 njenamakany.',
	'config-no-uri' => "'''Zmylk:''' Aktualny URI njeda so postajić.
Instalacija bu přetorhnjena.",
	'config-no-cli-uri' => "'''Warnowanje''': Žana skriptowa šćežka (--scriptpath) podata, standard so wužiwa: <code>$1</code>.",
	'config-using-server' => 'Serwerowe mjeno "<nowiki>$1</nowiki>" so wužiwa.',
	'config-using-uri' => 'Serwerowy URL "<nowiki>$1$2</nowiki>" so wužiwa.',
	'config-db-type' => 'Typ datoweje banki:',
	'config-db-host' => 'Serwer datoweje banki:',
	'config-db-host-oracle' => 'Datowa banka TNS:',
	'config-db-wiki-settings' => 'Tutón wiki identifikować',
	'config-db-name' => 'Mjeno datoweje banki:',
	'config-db-name-oracle' => 'Šema datoweje banki:',
	'config-db-install-account' => 'Wužiwarske konto za instalaciju',
	'config-db-username' => 'Wužiwarske mjeno datoweje banki:',
	'config-db-password' => 'Hesło datoweje banki:',
	'config-db-password-empty' => 'Prošu zapodaj hesło za noweho wužiwarja datoweje banki: $1.
Byrnjež było móžno wužiwarjow bjez hesłow wutworić, njeje to wěste.',
	'config-db-install-username' => 'Zapodaj wužiwarske mjeno, kotrež budźe so za zwisk z datowej banku za instalaciski proces wužiwać.
To njeje wužiwarske mjeno konta MediaWiki; to je wužiwarske mjeno za twoju datowu banku.',
	'config-db-install-password' => 'Zapodaj hesło, kotrež budźe so za zwisk z datowej banku za instalaciski proces wužiwać.
To njeje hesło konta MediaWiki; to je hesło za twoju datowu banku.',
	'config-db-install-help' => 'Zapodaj wužiwarske mjeno a hesło, kotrejž měłoj so za zwisk z datowej banku za instalaciski proces wužiwać.',
	'config-db-account-lock' => 'Samsne wužiwarske mjeno a hesło za normalnu operaciju wužiwać',
	'config-db-wiki-account' => 'Wužiwarske konto za normalnu operaciju',
	'config-db-prefix' => 'Tabelowy prefiks datoweje banki:',
	'config-db-charset' => 'Znamješkowa sadźba datoweje banki',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binarny',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 wróćokompatibelny UTF-8',
	'config-mysql-old' => 'MySQL $1 abo nowši trěbny, maš $2.',
	'config-db-port' => 'Port datoweje banki:',
	'config-db-schema' => 'Šema za MediaWiki',
	'config-db-schema-help' => 'Tuta šema da so zwjetša derje wužiwać.
Změń ju jenož, jeli su přeswědčiwe přičiny za to.',
	'config-pg-test-error' => "Zwisk z datowej banku '''$1''' móžno njeje: $2",
	'config-sqlite-dir' => 'Zapis SQLite-datow:',
	'config-oracle-def-ts' => 'Standardny tabelowy rum:',
	'config-oracle-temp-ts' => 'Nachwilny tabelowy rum:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-mysql' => '* $1 je primarny cil za MediaWiki a podpěruje so najlěpje ([http://www.php.net/manual/en/mysql.installation.php Nawod ke kompilowanju  PHP z  MySQL-podpěru])',
	'config-support-postgres' => '* $1 je popularny system datoweje banki zjawneho žórła jako alternatiwa k MySQL ([http://www.php.net/manual/en/pgsql.installation.php nawod za kompilowanje PHP z podpěru PostgreSQL]). Móhło hišće někotre zmylki eksistować, a njeporuča so jón w produktiwnej wokolinje wužiwać.',
	'config-support-oracle' => '* $1 je komercielna předewzaćelska datowa banka. ([http://www.php.net/manual/en/oci8.installation.php Nawod za kompilowanje PHP z OCI8-podpěru])',
	'config-support-ibm_db2' => '* $1 je komercielna předewzaćelska datowa banka.',
	'config-header-mysql' => 'Nastajenja MySQL',
	'config-header-postgres' => 'Nastajenja PostgreSQL',
	'config-header-sqlite' => 'Nastajenja SQLite',
	'config-header-oracle' => 'Nastajenja Oracle',
	'config-header-ibm_db2' => 'Nastajenja IBM DB2',
	'config-invalid-db-type' => 'Njepłaćiwy typ datoweje banki',
	'config-missing-db-name' => 'Dyrbiš hódnotu za "Mjeno datoweje banki" zapodać',
	'config-missing-db-host' => 'Dyrbiš hódnotu za "Database host" zapodać',
	'config-missing-db-server-oracle' => 'Dyrbiš hódnotu za "Database TNS" zapodać',
	'config-invalid-db-server-oracle' => 'Njepłaćiwa datowa banka TNS "$1".
Wužij jenož pismiki ASCII (a-z, A-Z), ličby (0-9), podsmužki (_) a dypki (.).',
	'config-invalid-db-name' => 'Njepłaćiwe mjeno "$1" datoweje banki.
Wužij jenož pismiki ASCII (a-z, A-Z), ličby (0-9),a podsmužki (_) a wjazawki (-).',
	'config-invalid-db-prefix' => 'Njepłaćiwy prefiks "$1" datoweje banki.
Wužij jenož pismiki ASCII (a-z, A-Z), ličby (0-9), podsmužki (_) a wjazawki (-).',
	'config-connection-error' => '$1.

Skontroluj serwer, wužiwarske a hesło a spytaj hišće raz.',
	'config-invalid-schema' => 'Njepłaćiwe šema za MediaWiki "$1".
Wužij jenož pismiki ASCII (a-z, A-Z), ličby (0-9) a podsmužki (_).',
	'config-db-sys-create-oracle' => 'Instalaciski program podpěruje jenož wužiwanje SYSDBA-konta za zakoženje noweho konta.',
	'config-db-sys-user-exists-oracle' => 'Wužiwarske konto "$1" hižo eksistuje. SYSDBA hodźi so jenož za załoženje noweho konta wužiwać!',
	'config-postgres-old' => 'PostgreSQL $1 abo nowši trěbny, maš $2.',
	'config-sqlite-name-help' => 'Wubjer mjeno, kotrež twój wiki identifikuje.
Njewužij mjezery abo wjazawki.
To budźe so za mjeno dataje SQLite-datow wužiwać.',
	'config-sqlite-mkdir-error' => 'Zmylk při wutworjenju datoweho zapisa "$1".
Skontroluj městno a spytaj hišće raz.',
	'config-sqlite-dir-unwritable' => 'Njeje móžno do zapisa "$1" pisać.
Změń jeho prawa, tak zo webserwer móže do njeho pisać a spytaj hišće raz.',
	'config-sqlite-connection-error' => '$1.

Skontroluj datowy zapis a mjeno datoweje banki kaj spytaj hišće raz.',
	'config-sqlite-readonly' => 'Do dataje <code>$1</code> njeda so pisać.',
	'config-sqlite-cant-create-db' => 'Dataja <code>$1</code> datoweje banki njeda so wutworić.',
	'config-sqlite-fts3-downgrade' => 'PHP wo podpěrje FTS3 k dispoziciji njesteji, table so znižuja',
	'config-can-upgrade' => "Su tabele MediaWiki w tutej datowej bance.
Zo by je na MediaWiki $1 aktualizował, klikń na '''Dale'''.",
	'config-upgrade-done-no-regenerate' => 'Aktualizacija dokónčena.

Móžeš nětko [$1 swój wiki wužiwać].',
	'config-regenerate' => 'LocalSettings.php znowa wutworić →',
	'config-show-table-status' => 'Naprašowanje SHOW TABLE STATUS je so njeporadźiło!',
	'config-unknown-collation' => "'''Warnowanje:''' Datowa banka njeznatu kolaciju wužiwa.",
	'config-db-web-account' => 'Konto datoweje banki za webpřistup',
	'config-db-web-help' => 'wubjer wužiwarske mjeno a hesło, kotrejž webserwer budźe wužiwać, zo by z serwerom datoweje banki za wšědnu operaciju zwjazać',
	'config-db-web-account-same' => 'Samsne konto kaž za instalaciju wužiwać',
	'config-db-web-create' => 'Załož konto, jeli hišće njeeksistuje.',
	'config-db-web-no-create-privs' => 'Konto, kotrež sy za instalaciju podał, nima dosć woprawnjenjow, zo by konto wutworiło.
Konto, kotrež tu podawaće, dyrbi hižo eksistować.',
	'config-mysql-engine' => 'Składowanska mašina:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Znamješkowa sadźba datoweje banki:',
	'config-mysql-binary' => 'Binarny',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Mjeno wikija:',
	'config-site-name-help' => 'To zjewi so w titulowej lejstwje wobhladaka kaž tež na wšelakich druhich městnach.',
	'config-site-name-blank' => 'Zapodaj sydłowe mjeno.',
	'config-project-namespace' => 'Mjenowy rum projekta:',
	'config-ns-generic' => 'Projekt',
	'config-ns-site-name' => 'Samsne kaž wikimjeno: $1',
	'config-ns-other' => 'Druhe (podać)',
	'config-ns-other-default' => 'MyWiki',
	'config-ns-invalid' => 'Podaty mjenowy rum "<nowiki>$1</nowiki>" je njepłaćiwy.
Podaj druhi projektowy mjenowy rum.',
	'config-ns-conflict' => 'Podaty mjenowy rum "<nowiki>$1</nowiki>" je w konflikće ze standardnym mjenjowym rumom MediaWiki.
Podaj druhi projektowy mjenowy rum.',
	'config-admin-box' => 'Administratorowe konto',
	'config-admin-name' => 'Twoje mjeno:',
	'config-admin-password' => 'Hesło:',
	'config-admin-password-confirm' => 'Hesło wospjetować:',
	'config-admin-help' => 'Zapodaj swoje preferowane wužiwarske mjeno, na přikład "Jurij Serb".
To je mjeno, kotrež budźeš wužiwać, zo by so do wikija přizjewił.',
	'config-admin-name-blank' => 'Zapodaj administratorowe wužiwarske mjeno.',
	'config-admin-name-invalid' => 'Podate wužiwarske mjeno "<nowiki>$1</nowiki>" je njepłaćiwe.
Podaj druhe wužiwarske mjeno.',
	'config-admin-password-blank' => 'Zapodaj hesło za administratorowe konto.',
	'config-admin-password-same' => 'Hesło dyrbi so wot wužiwarskeho mjena rozeznać.',
	'config-admin-password-mismatch' => 'Wobě hesle, kotrejž sy zapodał, njejstej jenakej.',
	'config-admin-email' => 'E-mejlowa adresa:',
	'config-admin-email-help' => 'Zapodaj tu e-mejlowu adresu, zo by přijimanje e-mejlow wot druhich wužiwarjow w tutym wikiju zmóžnił, swoje hesło wróćo stajił a zdźělenki wo změnach na swojich wobkedźbowanych stronach  dostał. Móžeš polo prózdne wostajić.',
	'config-admin-error-user' => 'Interny zmylk při wutworjenju administratora z mjenom "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Interny zmylk při nastajenju hesła za administratora "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Sy njepłaćiwu e-mejlowu adresu zapodał.',
	'config-subscribe' => '[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Rozesyłansku lisćinu wo připowědźenjach nowych wersijow ].abonować',
	'config-almost-done' => 'Sy skoro hotowy!
Móžeš nětko zbytnu konfiguraciju přeskočić a wiki hnydom instalować.',
	'config-optional-continue' => 'Dalše prašenja?',
	'config-optional-skip' => 'Instaluj nětko wiki.',
	'config-profile' => 'Profil wužiwarskich prawow:',
	'config-profile-wiki' => 'Tradicionelny wiki',
	'config-profile-no-anon' => 'Załoženje konto je trěbne',
	'config-profile-fishbowl' => 'Jenož awtorizowani wobdźěłarjo',
	'config-profile-private' => 'Priwatny wiki',
	'config-license' => 'Awtorske prawo a licenca:',
	'config-license-none' => 'Žane licencne podaća w nohowej lince',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0' => 'Creative Commons Zero (zjawnosći přistupny)',
	'config-license-gfdl' => 'GNU-licenca za swobodnu dokumentaciju 1.3 abo nowša',
	'config-license-pd' => 'Powšitkownosći přistupny',
	'config-license-cc-choose' => 'Swójsku licencu Creative Commons wubrać',
	'config-email-settings' => 'E-mejlowe nastajenja',
	'config-enable-email' => 'Wuchadźace e-mejlki zmóžnić',
	'config-enable-email-help' => 'Jeli chceš e-mejl wužiwać, dyrbja so [http://www.php.net/manual/en/mail.configuration.php e-mejlowe nastajenja PHP] prawje konfigurować.
Jeli nochceš e-mejlowe funkcije wužiwać, móžeš je tu znjemóžnić.',
	'config-email-user' => 'E-mejl mjez wužiwarjemi zmóžnić',
	'config-email-user-help' => 'Wšěm wužiwarjam dowolić, jednomu druhemu e-mejlki pósłać, jeli su tutu funkciju w swojich nastajenjach zmóžnili.',
	'config-email-usertalk' => 'Zdźělenja za wužiwarske diskusijne strony zmóžnić',
	'config-email-usertalk-help' => 'Wužiwarjam dowolić zdźělenki wo změnach na wužiwarskich diskusijnych stronach dóstać, jeli woni su to w swojich nastajenjach zmóžnili.',
	'config-email-watchlist' => 'Zdźělenja za wobkedźbowanki zmóžnić',
	'config-email-watchlist-help' => 'Wužiwarjam dowolić zdźělenki wo jich wobked´bowanych stronach dóstać, jeli woni su to w swojich nastajenjach zmóžnili.',
	'config-email-auth' => 'E-mejlowu awtentifikaciju zmóžnić',
	'config-email-sender' => 'E-mejlowa adresa za wotmołwy:',
	'config-upload-settings' => 'Wobrazy a nahraća datajow',
	'config-upload-enable' => 'Nahraće datajow zmóžnić',
	'config-upload-deleted' => 'Zapis za zhašane dataje:',
	'config-upload-deleted-help' => 'Wubjer zapis, w kotrymž zhašene dataje maja so archiwować.
Idealnje tón njeměł z weba přistupny być.',
	'config-logo' => 'URL loga:',
	'config-instantcommons' => 'Instant commons zmóžnić',
	'config-cc-error' => 'Pytanje za licencu Creative Commons njeje žadyn wuslědk přinjesło.
Zapodaj licencne mjeno manuelnje.',
	'config-cc-again' => 'Zaso wubrać...',
	'config-cc-not-chosen' => 'Wubjer licencu Creative Commons a klikń na "dale".',
	'config-advanced-settings' => 'Rozšěrjena konfiguraćija',
	'config-cache-options' => 'Nastajenja za objektowe pufrowanje:',
	'config-cache-none' => 'Žane pufrowanje (žana funkcionalnosć so njewotstronja, ale spěšnosć móže so na wjetšich wikijowych sydłach wobwliwować)',
	'config-cache-accel' => 'Objektowe pufrowanje PHP (APC, XCache abo WinCache)',
	'config-cache-memcached' => 'Memcached wužiwać (wužaduje sej přidatnu instalaciju a konfiguraciju)',
	'config-memcached-servers' => 'Serwery memcached:',
	'config-memcached-help' => 'Lisćina IP-adresow, kotrež maja so za Memcached wužiwać.
Kóžda linka měła jenož jednu IP-adresu a port, kotryž ma so wužiwać, wobsahować. Na přikład:
127.0.0.1:11211
192.168.1.25:1234',
	'config-memcache-needservers' => 'Sy Memcached jako swój pufrowakowy typ wubrał, ale njejsy žane serwery podał',
	'config-memcache-badip' => 'Sy njepłaćiwu IP-adresu za Memcached zapodał: $1',
	'config-memcache-noport' => 'Njejsy žadyn port za wužiwanje serwera Memcached podał: $1.
Jeli port njewěš, standard je 11211.',
	'config-memcache-badport' => 'Portowe čisła za Memcached měli mjez $1 a $2 być',
	'config-extensions' => 'Rozšěrjenja',
	'config-extensions-help' => 'Rozšěrjenja podate horjeka buchu w twojim zapisu <code>./extensions</code> namakane.

To móže sej přidatnu konfiguraciju wužadać, ale móžeš je nětko zmóžnić.',
	'config-install-alreadydone' => "'''Warnowanje:''' Zda so, zo sy hižo MediaWiki instalował a pospytuješ jón znowa instalować.
Prošu pokročuj z přichodnej stronu.",
	'config-install-begin' => 'Přez kliknjenje na "{{int:config-continue}}" budźe so instalacija MediaWiki startować.
Jeli hišće chceš něšto změnić, klikń na "Wróćo".',
	'config-install-step-done' => 'dokónčene',
	'config-install-step-failed' => 'njeporadźiło',
	'config-install-extensions' => 'Inkluziwnje rozšěrjenja',
	'config-install-database' => 'Datowa banka so připrawja',
	'config-install-schema' => 'Datowa šema so twori',
	'config-install-pg-schema-not-exist' => 'Šema PostgreSQL njeeksistuje',
	'config-install-pg-schema-failed' => 'Wutworjenje tabelow je so njeporadźiło.
Zawěsć, zo wužiwar "$1" móže do šemy "$2" pisać.',
	'config-install-pg-commit' => 'Změny so wotesyłaja',
	'config-install-pg-plpgsql' => 'Pruwowanje za rěču PL/pgSQL',
	'config-pg-no-plpgsql' => 'Dyrbiš rěč PL/pgSQL w datowej bance $1 instalować',
	'config-pg-no-create-privs' => 'Konto, kotrež sy za instalaciju podał, nima dosahace prawa za wutworjenje konta.',
	'config-install-user' => 'Tworjenje wužiwarja datoweje banki',
	'config-install-user-alreadyexists' => 'Wužiwar "$1" hižo eksistuje',
	'config-install-user-create-failed' => 'Wutworjenje wužiwarja "$1" je so njeporadźiło: $2',
	'config-install-user-grant-failed' => 'Prawo njeda so wužiwarjej "$1" dać: $2',
	'config-install-user-missing' => 'Podaty wužiwar "$1" njeeksistuje.',
	'config-install-user-missing-create' => 'Podaty wužiwar "$1" njeeksistuje.
Prošu klikń na slědowacy kontrolny kašćik "konto załožić", jeli chceš jo wutworić.',
	'config-install-tables' => 'Tworjenje tabelow',
	'config-install-tables-exist' => "'''Warnowanje''': Zda so, zo tabele MediaWiki hižo eksistuja.
Wutworjenje so přeskakuje.",
	'config-install-tables-failed' => "'''Zmylk''': Wutworjenje tabele je so slědowaceho zmylka dla njeporadźiło: $1",
	'config-install-interwiki' => 'Standardna tabela interwikijow so pjelni',
	'config-install-interwiki-list' => '<code>interwiki.list</code> njeda so namakać.',
	'config-install-interwiki-exists' => "'''Warnowanje''': Zda so, zo tabela interwikjow hižo zapiski wobsahuje.
Standardna lisćina sp přeskakuje.",
	'config-install-stats' => 'Statistika so inicializuje',
	'config-install-keys' => 'Tajne kluče so tworja',
	'config-install-sysop' => 'Tworjenje administratoroweho wužiwarskeho konta',
	'config-install-subscribe-fail' => 'Abonowanje "mediawiki-announce" njemóžno: $1',
	'config-install-subscribe-notpossible' => 'cURL njeje instalowany a allow_url_fopen k dispoziciji njesteji.',
	'config-install-mainpage' => 'Hłowna strona so ze standardnym wobsahom wutworja',
	'config-install-extension-tables' => 'Tabele za zmóžnjene rozšěrjenja so tworja',
	'config-install-mainpage-failed' => 'Powěsć njeda so zasunyć: $1',
	'config-download-localsettings' => 'LocalSettings.php sćahnyć',
	'config-help' => 'pomoc',
	'config-nofile' => 'Dataja "$1" njeje so namakała. Je so zhašała?',
	'mainpagetext' => "'''MediaWiki bu wuspěšnje instalowany.'''",
	'mainpagedocfooter' => 'Prošu hlej [//meta.wikimedia.org/wiki/Help:Contents dokumentaciju] za informacije wo wužiwanju softwary.

== Za nowačkow ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Wo nastajenjach]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]',
);

/** Haitian (Kreyòl ayisyen)
 * @author Boukman
 */
$messages['ht'] = array(
	'mainpagetext' => "'''MedyaWiki byen enstale l.'''",
	'mainpagedocfooter' => 'Konsilte [//meta.wikimedia.org/wiki/Help:Konteni Gid Itilizatè] pou enfòmasyon sou kijan pou w itilize logisyèl wiki a.

== Kijan pou kòmanse ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lis paramèt yo pou konfigirasyon]
* [//www.mediawiki.org/wiki/Manyèl:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lis diskisyon ki parèt sou MediaWiki]',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'config-desc' => 'A MediaWiki telepítője',
	'config-title' => 'A MediaWiki $1 telepítése',
	'config-information' => 'Információ',
	'config-localsettings-upgrade' => 'Már létezik a <code>LocalSettings.php</code> fájl.
A telepített szoftver frissítéséhez írd be az alábbi mezőbe a <code>$wgUpgradeKey</code> beállítás értékét, melyet a LocalSettings.php nevű fájlban találhatsz meg.',
	'config-localsettings-cli-upgrade' => 'A LocalSettings.php fájl megtalálható.
A telepített rendszer frissítéséhez futtasd az update.php-t.',
	'config-localsettings-key' => 'Frissítési kulcs:',
	'config-localsettings-badkey' => 'A megadott kulcs érvénytelen.',
	'config-upgrade-key-missing' => 'A telepítő a MediaWiki meglévő példányát észlelte.
A telepített rendszer frissítéséhez helyezd el az alábbi sort a LocalSettings.php végére:

$1',
	'config-localsettings-incomplete' => 'A meglévő LocalSettings.php hiányosnak tűnik.
A(z) $1 változó értéke nincs beállítva.
Módosítsd a LocalSettings.php fájlt úgy, hogy ez a változó be legyen állítva, majd kattints a „Folytatás” gombra.',
	'config-localsettings-connection-error' => 'Nem sikerült csatlakozni az adatbázishoz a LocalSettings.php-ben vagy az AdminSettings.php-ben megadott adatokkal. Ellenőrizd a beállításokat, majd próbáld újra.

$1',
	'config-session-error' => 'Nem sikerült elindítani a munkamenetet: $1',
	'config-session-expired' => 'Úgy tűnik, hogy a munkamenetadatok lejártak.
A munkamenetek élettartama a következőre van beállítva: $1.
Az érték növelhető a php.ini <code>session.gc_maxlifetime</code> beállításának módosításával.
Indítsd újra a telepítési folyamatot.',
	'config-no-session' => 'Elvesztek a munkamenetadatok!
Ellenőrizd, hogy a php.ini-ben a <code>session.save_path</code> a megfelelő könyvtárra mutat-e.',
	'config-your-language' => 'Nyelv:',
	'config-your-language-help' => 'A telepítési folyamat során használandó nyelv.',
	'config-wiki-language' => 'A wiki nyelve:',
	'config-wiki-language-help' => 'Az a nyelv, amin a wiki tartalmának legnagyobb része íródik.',
	'config-back' => '← Vissza',
	'config-continue' => 'Folytatás →',
	'config-page-language' => 'Nyelv',
	'config-page-welcome' => 'Üdvözöl a MediaWiki!',
	'config-page-dbconnect' => 'Kapcsolódás az adatbázishoz',
	'config-page-upgrade' => 'Telepített változat frissítése',
	'config-page-dbsettings' => 'Adatbázis-beállítások',
	'config-page-name' => 'Név',
	'config-page-options' => 'Beállítások',
	'config-page-install' => 'Telepítés',
	'config-page-complete' => 'Kész!',
	'config-page-restart' => 'Telepítés újraindítása',
	'config-page-readme' => 'Tudnivalók',
	'config-page-releasenotes' => 'Kiadási megjegyzések',
	'config-page-copying' => 'Másolás',
	'config-page-upgradedoc' => 'Frissítés',
	'config-page-existingwiki' => 'Létező wiki',
	'config-help-restart' => 'Szeretnéd törölni az eddig megadott összes adatot és újraindítani a telepítési folyamatot?',
	'config-restart' => 'Igen, újraindítás',
	'config-welcome' => '=== A környezet ellenőrzése ===
Néhány alapvető ellenőrzés lett végrehajtva, ami meghatározza, hogy ez a környezet alkalmas-e a MediaWiki telepítésére.
Ha telepítéssel kapcsolatos segítségre van szükséged, add meg ezen ellenőrzések eredményét.',
	'config-copyright' => "=== Licenc és feltételek ===

$1

Ez a program szabad szoftver; terjeszthető illetve módosítható a Free Software Foundation által kiadott GNU General Public License dokumentumában leírtak; akár a licenc 2-es, akár (tetszőleges) későbbi változata szerint.

Ez a program abban a reményben kerül közreadásra, hogy hasznos lesz, de minden egyéb '''garancia nélkül''', az '''eladhatóságra''' vagy '''valamely célra való alkalmazhatóságra''' való származtatott garanciát is beleértve. További részleteket a GNU General Public License tartalmaz.

A felhasználónak a programmal együtt meg kell kapnia a <doclink href=Copying>GNU General Public License egy példányát</doclink>; ha mégsem kapta meg, akkor írjon a Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. címre, vagy [http://www.gnu.org/copyleft/gpl.html tekintse meg online].",
	'config-sidebar' => '* [//www.mediawiki.org A MediaWiki honlapja]
* [//www.mediawiki.org/wiki/Help:Contents Felhasználói kézikönyv]
* [//www.mediawiki.org/wiki/Manual:Contents Útmutató adminisztrátoroknak]
* [//www.mediawiki.org/wiki/Manual:FAQ GyIK]
----
* <doclink href=Readme>Ismertető</doclink>
* <doclink href=ReleaseNotes>Kiadási megjegyzések</doclink>
* <doclink href=Copying>Másolás</doclink>
* <doclink href=UpgradeDoc>Frissítés</doclink>',
	'config-env-good' => 'A környezet ellenőrzése befejeződött.
A MediaWiki telepíthető.',
	'config-env-bad' => 'A környezet ellenőrzése befejeződött.
A MediaWiki nem telepíthető.',
	'config-env-php' => 'A PHP verziója: $1',
	'config-env-php-toolow' => 'PHP $1 van telepítve,
azonban a MediaWikinek PHP $2, vagy újabb szükséges.',
	'config-unicode-using-utf8' => 'A rendszer Unicode normalizálására Brion Vibber utf8_normalize.so könyvtárát használja.',
	'config-unicode-using-intl' => 'A rendszer Unicode normalizálására az [http://pecl.php.net/intl intl PECL kiterjesztést] használja.',
	'config-unicode-pure-php-warning' => "'''Figyelmeztetés''': Az Unicode normalizáláshoz szükséges [http://pecl.php.net/intl intl PECL kiterjesztés] nem érhető el, helyette a lassú, PHP alapú implementáció lesz használva.
Ha nagy látogatottságú oldalt üzemeltetsz, itt találhatsz további információkat [//www.mediawiki.org/wiki/Unicode_normalization_considerations a témáról].",
	'config-unicode-update-warning' => "'''Figyelmeztetés''': Az Unicode normalizáláshoz szükséges burkolókönyvtár [http://site.icu-project.org/ ICU projekt] függvénykönyvtárának régebbi változatát használja.
Ha ügyelni kívánsz a Unicode használatára, fontold meg a [//www.mediawiki.org/wiki/Unicode_normalization_considerations frissítését].",
	'config-no-db' => 'Nem sikerült egyetlen használható adatbázis-illesztőprogramot sem találni.  Telepítened kell egyet a PHP-hez.
A következő adatbázistípusok támogatottak: $1.

Ha megosztott tárhelyszolgáltatást használsz, kérd meg a szolgáltatódat, hogy telepítsen egy megfelelő illesztőprogramot.
Ha a PHP-t magad fordítottad, konfiguráld újra úgy, hogy engedélyezve legyen egy adatbáziskliens, pl. a <code>./configure --with-mysql</code> parancs használatával.
Ha a PHP-t Debian vagy Ubuntu csomaggal telepítetted, akkor szükséged lesz a php5-mysql modulra is.',
	'config-no-fts3' => "'''Figyelmeztetés''': Az SQLite [//sqlite.org/fts3.html FTS3 modul] nélkül lett fordítva, a keresési funkciók nem fognak működni ezen a rendszeren.",
	'config-register-globals' => "'''Figyelmeztetés: A PHP <code>[http://php.net/register_globals register_globals]</code> beállítása engedélyezve van.'''
'''Tiltsd le, ha van rá lehetőséged.'''
A MediaWiki működőképes a beállítás használata mellett, de a szerver biztonsági kockázatnak lesz kitéve.",
	'config-magic-quotes-runtime' => "'''Kritikus hiba: a [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] aktív!'''
Ez a beállítás kiszámíthatatlan károkat okoz a bevitt adatokban.
A MediaWiki csak akkor telepíthető, ha ki van kapcsolva.",
	'config-magic-quotes-sybase' => "'''Kritikus hiba: a [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_sybase] aktív!'''
Ez a beállítás kiszámíthatatlan károkat okoz a bevitt adatokban.
A MediaWiki csak akkor telepíthető, ha ki van kapcsolva.",
	'config-mbstring' => "'''Kritikus hiba: az [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime mbstring.func_overload] aktív!'''
Ez a beállítás hibákat okoz és kiszámíthatatlanul károsíthatja bevitt adatokat.
A MediaWiki csak akkor telepíthető, ha ki van kapcsolva.",
	'config-ze1' => "'''Kritikus hiba: a [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_sybase] aktív!'''
Ez a beállítás borzalmas hibákat okoz a MediaWiki futása során.
A MediaWiki csak akkor telepíthető, ha ki van kapcsolva.",
	'config-safe-mode' => "'''Figyelmeztetés:''' A PHP [http://www.php.net/features.safe-mode safe mode]-ja be van kapcsolva.
Problémákat okozhat, különösen a fájlfeltöltéseknél és a <code>math</code>-támogatás használatánál.",
	'config-xml-bad' => 'A PHP XML-modulja hiányzik.
Egyes MediaWiki-funkciók, melyek ezt a modult igénylik, nem fognak működni ilyen beállítások mellett.
Ha Madrake-et futtatsz, telepítsd a php-xml csomagot.',
	'config-pcre' => 'Úgy tűnik, hogy a PCRE támogató modul hiányzik.
A MediaWikinek Perl-kompatibilis reguláriskifejezés-függvényekre van szüksége a működéshez.',
	'config-pcre-no-utf8' => "'''Kritikus hiba''': Úgy tűnik, hogy a PHP PRCE modulja PRCE_UTF8 támogatás nélkül lett fordítva.
A MediaWikinek UTF-8-támogatásra van szüksége a helyes működéshez.",
	'config-memory-raised' => 'A PHP <code>memory_limit</code> beállításának értéke: $1. Meg lett növelve a következő értékre: $2.',
	'config-memory-bad' => "'''Figyelmeztetés:''' A PHP <code>memory_limit</code> beállításának értéke $1.
Ez az érték valószínűleg túl kevés, a telepítés sikertelen lehet.",
	'config-xcache' => 'Az [http://xcache.lighttpd.net/ XCache] telepítve van',
	'config-apc' => 'Az [http://www.php.net/apc APC] telepítve van',
	'config-wincache' => 'A [http://www.iis.net/download/WinCacheForPhp WinCache] telepítve van',
	'config-no-cache' => "'''Figyelmeztetés:''' Nem található [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] és [http://www.iis.net/download/WinCacheForPhp WinCache] sem.
Objektum-gyorsítótárazás nem lesz engedélyezve.",
	'config-diff3-bad' => 'GNU diff3 nem található.',
	'config-imagemagick' => 'Az ImageMagick megtalálható a rendszeren: <code>$1</code>.
A bélyegképek készítése engedélyezve lesz a feltöltések engedélyezése esetén.',
	'config-gd' => 'A GD grafikai könyvtár elérhető.
Bélyegképek készítése működni fog, miután engedélyezted a fájlfeltöltést.',
	'config-no-scaling' => 'Nem található a GD könyvtár és az ImageMagick.
A bélyegképek készítése le lesz tiltva.',
	'config-no-uri' => "'''Hiba:''' Nem sikerült megállapítani a jelenlegi URI-t.
Telepítés megszakítva.",
	'config-using-server' => 'A következő szervernév használata: „<nowiki>$1</nowiki>”.',
	'config-using-uri' => 'A következő szerver URL-cím használata: „<nowiki>$1$2</nowiki>”.',
	'config-uploads-not-safe' => "'''Figyelmeztetés:''' a feltöltésekhez használt alapértelmezett könyvtárban (<code>$1</code>) tetszőleges külső szkript futtatható.
Habár a MediaWiki ellenőrzi a feltöltött fájlokat az efféle biztonsági veszélyek megtalálása érdekében, a feltöltés engedélyezése előtt erősen ajánlott a [//www.mediawiki.org/wiki/Manual:Security#Upload_security a sérülékenység megszüntetése].",
	'config-brokenlibxml' => 'A rendszereden a PHP és libxml2 verziók olyan kombinációja található meg, ami hibásan működik, és észrevehetetlen adatkárosodást okoz a MediaWikiben és más webalkalmazásokban.
Frissíts a PHP 5.2.9-es vagy újabb, valamint a libxml2 2.7.3 vgy újabb verziójára ([//bugs.php.net/bug.php?id=45996 A hiba bejelentése a PHP-nél]).
Telepítés megszakítva.',
	'config-using531' => 'A MediaWiki nem használható a PHP $1-es verziójával, mert hiba van a <code>__call()</code> függvénynek átadott referenciaparaméterekkel.
A probléma kiküszöböléséhez frissíts a PHP 5.3.2-es verziójára, vagy használd a korábbi, 5.3.0-ásat.
Telepítés megszakítva.',
	'config-suhosin-max-value-length' => 'A Suhosin telepítve van, és a GET paraméter hosszát $1 bájtra korlátozza. A MediaWiki erőforrásbetöltő összetevője megkerüli a problémát, de így csökkenni fog a teljesítmény. Ha lehetséges, állítsd be a suhosin.get.max_value_length értékét legalább 1024-re a php.iniben, és állítsd be a $wgResourceLoaderMaxQueryLength változót ugyanerre az értékre a LocalSettings.php-ben.',
	'config-db-type' => 'Adatbázis típusa:',
	'config-db-host' => 'Adatbázis hosztneve:',
	'config-db-host-help' => 'Ha az adatbázisszerver másik szerveren található, add meg a hosztnevét vagy az IP-címét.

Ha megosztott webtárhelyet használsz, a szolgáltató dokumentációjában megtalálható a helyes hosztnév.

Ha Windows-alapú szerverre telepítesz, és MySQL-t használsz, a „localhost” nem biztos, hogy működni fog. Ha így van, próbáld meg a „127.0.0.1” helyi IP-cím használatát.', # Fuzzy
	'config-db-host-oracle' => 'Adatbázis TNS:',
	'config-db-wiki-settings' => 'A wiki azonosítása',
	'config-db-name' => 'Adatbázisnév:',
	'config-db-name-help' => 'Válassz egy nevet a wiki azonosítására.
Ne tartalmazzon szóközt.

Ha megosztott webtárhelyet használsz, a szolgáltatód vagy egy konkrét adatbázisnevet ad neked használatra, vagy te magad hozhatsz létre adatbázisokat a vezérlőpulton keresztül.',
	'config-db-name-oracle' => 'Adatbázisséma:',
	'config-db-account-oracle-warn' => 'Oracle adatbázisba való telepítésnek három támogatott módja van:

Ha a telepítési folyamat során adatbázisfiókot szeretnél létrehozni, akkor egy olyan fiókot kell használnod, mely rendelkezik SYSDBA jogosultsággal, majd meg kell adnod a létrehozandó, webes hozzáféréshez használt fiók adatait. Emellett a fiók kézzel is létrehozható, ekkor ennek az adatait kell megadni (a fióknak rendelkeznie kell megfelelő jogosul adatbázis-objektumok létrehozásához), vagy megadhatsz két fiókot: egyet a létrehozáshoz szükséges jogosultságokkal, és egy korlátozottat a webes hozzáféréshez.

A megfelelő jogosultságokkal rendelkező fiók létrehozásához használható szkript a szoftver „maintenance/oracle/” könyvtárában található. Ne feledd, hogy korlátozott fiók használatakor az alapértelmezett fiókkal nem végezhetőek el a karbantartási műveletek.',
	'config-db-install-account' => 'A telepítéshez használt felhasználói fiók adatai',
	'config-db-username' => 'Felhasználónév:',
	'config-db-password' => 'Jelszó:',
	'config-db-password-empty' => 'Írd be az új adatbázis-felhasználó jelszavát: $1
Van lehetőség jelszó nélküli felhasználók létrehozására, azonban ez nem ajánlott.',
	'config-db-install-username' => 'Írd be az adatbázisrendszerhez való csatlakozáshoz használt felhasználónevet.
Ez nem a MediaWiki fiók felhasználóneve; ez az adatbázisrendszeren használt felhasználóneved.',
	'config-db-install-password' => 'Írd be az adatbázisrendszerhez való csatlakozáshoz használt jelszót.
Ez nem a MediaWiki-fiók jelszava; ez az adatbázisrendszeren használt jelszavad.',
	'config-db-install-help' => 'Add meg a felhasználónevet és jelszót, amivel a telepítő csatlakozhat az adatbázishoz.',
	'config-db-account-lock' => 'Általános működés során is ezen információk használata',
	'config-db-wiki-account' => 'Általános működéshez használt felhasználói adatok',
	'config-db-wiki-help' => 'Add meg azt a felhasználónevet és jelszót, amivel a wiki fog csatlakozni az adatbázishoz működés közben.
Ha a fiók nem létezik és a telepítést végző fiók rendelkezik megfelelő jogosultsággal, egy új fiók készül a megadott a névvel, azon minimális jogosultságkörrel, ami a wiki működéséhez szükséges.',
	'config-db-prefix' => 'Adatbázistáblák nevének előtagja:',
	'config-db-prefix-help' => 'Ha egyetlen adatbázison osztozik több wiki, vagy a MediaWiki és más webalkalmazás, választhatsz egy előtagot a táblaneveknek, hogy megelőzd a konfliktusokat.
Ne használj szóközöket.

A mezőt általában üresen kell hagyni.',
	'config-db-charset' => 'Az adatbázis karakterkészlete',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0, bináris',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0, visszafelé kompatibilis UTF-8',
	'config-charset-help' => "'''Figyelmezetés:''' Ha a '''visszafelé kompatibilis UTF-8''' beállítást használod MySQL 4.1 vagy újabb verziók esetén, és utána a <code>mysqldump</code> programmal készítesz róla biztonsági másolatot, az tönkreteheti az összes nem ASCII-karaktert, visszafordíthatatlanul károsítva a másolatokban tárolt adatokat!

'''Bináris''' módban a MediaWiki az UTF-8-ban kódolt szöveget bináris mezőkben tárolja az adatbázisban.
Ez sokkal hatékonyabb a MySQL UTF-8-módjától, és lehetővé teszi, hogy a teljes Unicode-karakterkészletet használd.
'''UTF-8-módban''' MySQL tudja, hogy milyen karakterkészlettel van kódolva az adat, és megfelelően tárolja és konvertálja, de
nem használhatod a [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane] feletti karaktereket.",
	'config-mysql-old' => 'A MySQL $1 vagy újabb verziója szükséges, a rendszeren $2 van.',
	'config-db-port' => 'Adatbázisport:',
	'config-db-schema' => 'MediaWiki-séma',
	'config-db-schema-help' => 'A fenti sémák általában megfelelőek.
Csak akkor módosíts rajtuk, ha tudod, hogy szükséges.',
	'config-pg-test-error' => "Nem sikerült csatlakozni a(z) '''$1''' adatbázishoz: $2",
	'config-sqlite-dir' => 'SQLite-adatkönyvtár:',
	'config-sqlite-dir-help' => "Az SQLite minden adatot egyetlen fájlban tárol.

A megadott könyvtárban írási jogosultsággal kell rendelkeznie a webszervernek.

'''Nem''' szabad elérhetőnek lennie weben keresztül, ezért nem rakjuk oda, ahol a PHP-fájljaid vannak.

A telepítő készít egy <code>.htaccess</code> fájlt az adatbázis mellé, azonban ha valamilyen okból nem sikerül, akkor akárki hozzáférhet a teljes adatbázisodhoz. Ez a felhasználók adatai (e-mail címek, jelszók hashei) mellett a törölt változatokat és más, korlátozott hozzáférésű információkat is tartalmaz.

Fontold meg az adatbázis más helyre történő elhelyezését, például a <code>/var/lib/mediawiki/tewikid</code> könyvtárba.",
	'config-oracle-def-ts' => 'Alapértelmezett táblatér:',
	'config-oracle-temp-ts' => 'Ideiglenes táblatér:',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'A MediaWiki a következő adatbázisrendszereket támogatja:

$1

Ha az alábbi listán nem találod azt a rendszert, melyet használni szeretnél, a fenti linken található instrukciókat követve engedélyezheted a támogatását.',
	'config-support-mysql' => '* A $1 a MediaWiki elsődleges célpontja, így a legjobban támogatott ([http://www.php.net/manual/en/mysql.installation.php Hogyan fordítható a PHP MySQL-támogatással])',
	'config-support-postgres' => '* A $1 népszerű, nyílt forráskódú adatbázisrendszer, a MySQL alternatívája ([http://www.php.net/manual/en/pgsql.installation.php Hogyan fordítható a PHP PostgreSQL-támogatással]). Több apró, javítatlan hiba is előfordulhat, így nem ajánlott éles környezetben használni.',
	'config-support-sqlite' => '* Az $1 egy könnyű, nagyon jól támogatott adatbázisrendszer. ([http://www.php.net/manual/en/pdo.installation.php Hogyan fordítható a PHP SQLite-támogatással], PDO-t használ)',
	'config-support-oracle' => '* Az $1 kereskedelmi, vállalati adatbázisrendszer. ([http://www.php.net/manual/en/oci8.installation.php Hogyan fordítható a PHP OCI8-támogatással])',
	'config-support-ibm_db2' => '* Az $1 kereskedelmi vállalati adatbázisrendszer.',
	'config-header-mysql' => 'MySQL-beállítások',
	'config-header-postgres' => 'PostgreSQL-beállítások',
	'config-header-sqlite' => 'SQLite-beállítások',
	'config-header-oracle' => 'Oracle-beállítások',
	'config-header-ibm_db2' => 'IBM DB2-beállítások',
	'config-invalid-db-type' => 'Érvénytelen adatbázistípus',
	'config-missing-db-name' => 'Meg kell adnod az „Adatbázisnév” értékét',
	'config-missing-db-host' => 'Meg kell adnod az „Adatbázis hosztneve” értékét',
	'config-missing-db-server-oracle' => 'Meg kell adnod az „Adatbázis TNS” értékét',
	'config-invalid-db-server-oracle' => 'Érvénytelen adatbázis TNS: „$1”
Csak ASCII betűk (a-z, A-Z), számok (0-9), alulvonás (_) és pont (.) használható.',
	'config-invalid-db-name' => 'Érvénytelen adatbázisnév: „$1”.
Csak ASCII-karakterek (a-z, A-Z), számok (0-9), alulvonás (_) és kötőjel (-) használható.',
	'config-invalid-db-prefix' => 'Érvénytelen adatbázisnév-előtag: „$1”.
Csak ASCII-karakterek (a-z, A-Z), számok (0-9), alulvonás (_) és kötőjel (-) használható.',
	'config-connection-error' => '$1.

Ellenőrizd a hosztot, felhasználónevet és jelszót, majd próbáld újra.',
	'config-invalid-schema' => 'Érvénytelen MediaWiki-séma: „$1”.
Csak ASCII-karakterek (a-z, A-Z), számok (0-9) és alulvonás (_) használható.',
	'config-db-sys-create-oracle' => 'A telepítő csak a SYSDBA fiókkal tud új felhasználói fiókot létrehozni.',
	'config-db-sys-user-exists-oracle' => 'Már létezik „$1” nevű felhasználói fiók. A SYSDBA csak új fiók létrehozására használható!',
	'config-postgres-old' => 'A PostgreSQL $1 vagy újabb verziója szükséges, a rendszeren $2 van.',
	'config-sqlite-name-help' => 'Válassz egy nevet a wiki azonosítására.
Ne tartalmazzon szóközt vagy kötőjelet.
Ez lesz az SQLite-adatfájl neve.',
	'config-sqlite-parent-unwritable-group' => 'Nem hozható létre a(z) <code><nowiki>$1</nowiki></code> adatkönyvtár, mert a szülőkönyvtárba (<code><nowiki>$2</nowiki></code>) nem írhat a webszerver.

A telepítő megállapította, hogy mely felhasználó futtatja a webszervert.
A folytatáshoz tedd írhatóvá a(z) <code><nowiki>$3</nowiki></code> könyvtárat.
Unix/Linux rendszeren tedd a következőt:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Nem lehet létrehozni az adatok tárolásához szükséges <code><nowiki>$1</nowiki></code> könyvtárat, mert a webszerver nem írhat a szülőkönyvtárba (<code><nowiki>$2</nowiki></code>).

A telepítő nem tudta megállapíteni, hogy melyik felhasználói fiókon fut a webszerver.
A folytatáshoz tedd írhatóvá ezen fiók (és más fiókok!) számára a következő könyvtárat: <code><nowiki>$3</nowiki></code>.
Unix/Linux rendszereken tedd a következőt:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Nem sikerült létrehozni a következő adatkönyvtárat: „$1”.
Ellenőrizd a helyet, majd próbáld újra.',
	'config-sqlite-dir-unwritable' => 'Nem sikerült írni a következő könyvtárba: „$1”.
Módosítsd a jogosultságokat úgy, hogy a webszerver tudjon oda írni, majd próbáld újra.',
	'config-sqlite-connection-error' => '$1.

Ellenőrizd az adatkönyvtárat és az adatbázisnevet, majd próbáld újra.',
	'config-sqlite-readonly' => 'A következő fájl nem írható: <code>$1</code>.',
	'config-sqlite-cant-create-db' => 'Nem sikerült létrehozni a következő adatbázisfájlt: <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'A PHP nem rendelkezik FTS3-támogatással, táblák visszaminősítése',
	'config-can-upgrade' => "Ebben az adatábizban MediaWiki-táblák találhatóak.
A MediaWiki $1 verzióra történő frissítéséhez kattints a '''Folytatás''' gombra.",
	'config-upgrade-done' => "A frissítés befejeződött.

Most már '''[$1 beléphetsz a wikibe]'''.

Ha újra szeretnéd generálni a <code>LocalSettings.php</code> fájlt, kattints az alábbi gombra.
Ez '''nem ajánlott''', csak akkor, ha problémák vannak a wikivel.",
	'config-upgrade-done-no-regenerate' => "A frissítés befejeződött.

Most már '''[$1 beléphetsz a wikibe]'''.",
	'config-regenerate' => 'LocalSettings.php elkészítése újra →',
	'config-show-table-status' => 'A SHOW TABLE STATUS lekérdezés nem sikerült!',
	'config-unknown-collation' => "'''Figyelmeztetés:''' az adatbázis ismeretlen egybevetést használ.",
	'config-db-web-account' => 'A webes hozzáférésnél használt adatbázisfiók',
	'config-db-web-help' => 'Add meg azt a felhasználónevet és jelszót, amit a webszerver a wiki általános működése során használ a csatlakozáshoz.',
	'config-db-web-account-same' => 'A telepítéshez használt fiók használata',
	'config-db-web-create' => 'Fiók létrehozása, ha még nem létezik.',
	'config-db-web-no-create-privs' => 'A telepítéshez megadott fiók nem rendelkezik megfelelő jogosultságokkal új felhasználó létrehozásához.
Az itt megadott fióknak léteznie kell.',
	'config-mysql-engine' => 'Tárolómotor:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Figyelmeztetés''': A MyISAM tárolómotort választottad, ami nem ajánlott a MediaWiki használatánál, mert:
* nagyon rosszul kezeli a párhuzamos lekéréseket a táblák zárolása miatt
* sokkal nagyobb az esélye az adatkorrupció kialakulásának
* a MediaWiki kódbázisa nem mindig úgy kezeli a MyISAM-ot, ahogyan kellene

Ha a feltelepített MySQL támogatja az InnoDB-t, erősen ajánlott, hogy inkább azt válaszd.
Ha nem, akkor lehet, hogy itt az ideje a frissítésnek.",
	'config-mysql-engine-help' => "A legtöbb esetben az '''InnoDB''' a legjobb választás, mivel megfelelően támogatja a párhuzamosságot.

A '''MyISAM''' gyorsabb megoldás lehet egyfelhasználós vagy csak olvasható környezetekben, azonban a MyISAM-adatbázisok sokkal gyakrabban sérülnek meg, mint az InnoDB-adatbázisok.",
	'config-mysql-charset' => 'Adatbázis karakterkészlete:',
	'config-mysql-binary' => 'Bináris',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "'''Bináris módban''' a MediaWiki az UTF-8-as szövegeket bináris mezőkben tárolja az adatbázisban.
Ez sokkal hatékonyabb a MySQL UTF-8-as módjánál, és lehetővé teszi a teljes Unicode-karakterkészlet használatát.

'''UTF-8-as módban''' a MySQL tudni fogja,hogy az adatok milyen karakterkészlettel rendelkeznek, és megfelelően átalakítja őket, azonban nem tárolhatóak olyan karakterek, melyek a [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane] felett vannak.",
	'config-ibm_db2-low-db-pagesize' => "A DB2 adatbázisodnak alapértelmezett táblatere van elégtelen lapmérettel. A lapméretnek legalább '''32K'''-nak kell lennie.",
	'config-site-name' => 'A wiki neve:',
	'config-site-name-help' => 'A böngésző címsorában és még számos más helyen jelenik meg.',
	'config-site-name-blank' => 'Add meg az oldal nevét.',
	'config-project-namespace' => 'Projektnévtér:',
	'config-ns-generic' => 'Projekt',
	'config-ns-site-name' => 'Ugyanaz, mint a wiki neve: $1',
	'config-ns-other' => 'Más (meg kell adni)',
	'config-ns-other-default' => 'SajátWiki',
	'config-project-namespace-help' => "A Wikipédia példáját követve számos wiki elkülöníti egy '''projekt névtérbe''' az irányelveit a tartalommal rendelkező lapoktól
Az ebben a névtérben található lapok nevei egy előtaggal kezdődnek, amit itt adhatsz meg.
Általában az előtag a wiki nevéből származik, de nem tartalmazhat írásjeleket, például „#”-t vagy „:”-t.",
	'config-ns-invalid' => 'A megadott névtér („<nowiki>$1</nowiki>”) érvénytelen.
Válassz másik projektnévteret!',
	'config-ns-conflict' => 'A megadott névtér („<nowiki>$1</nowiki>”) ütközik az egyik alapértelmezett MediaWiki-névtérrel.
Válassz másik projektnévteret!',
	'config-admin-box' => 'Adminisztrátori fiók',
	'config-admin-name' => 'Név:',
	'config-admin-password' => 'Jelszó:',
	'config-admin-password-confirm' => 'Jelszó újra:',
	'config-admin-help' => 'Írd be a kívánt felhasználónevet, például „Kovács János”.
Ezzel a névvel fogsz majd bejelentkezni a wikibe.',
	'config-admin-name-blank' => 'Add meg az adminisztrátor felhasználónevét!',
	'config-admin-name-invalid' => 'A megadott felhasználónév (<nowiki>$1</nowiki>) érvénytelen.
Adj meg egy másik felhasználónevet.',
	'config-admin-password-blank' => 'Add meg az adminisztrátori fiók jelszavát!',
	'config-admin-password-same' => 'A jelszó nem lehet ugyanaz, mint a felhasználónév.',
	'config-admin-password-mismatch' => 'A megadott jelszavak nem egyeznek.',
	'config-admin-email' => 'E-mail cím:',
	'config-admin-email-help' => 'Add meg az e-mail címedet, hogy más felhasználók küldhessenek e-maileket a wikin keresztül, új jelszót tudj kérni, és értesülhess a figyelőlistádon lévő lapokon történt változásokról. Üresen is hagyhatod ezt a mezőt.',
	'config-admin-error-user' => 'Belső hiba történt a(z) „<nowiki>$1</nowiki>” nevű adminisztrátor létrehozásakor.',
	'config-admin-error-password' => 'Belső hiba történt a(z) „<nowiki>$1</nowiki>” nevű adminisztrátor jelszavának beállításakor: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Érvénytelen e-mail címet adtál meg.',
	'config-subscribe' => 'Feliratkozás a [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce kiadási bejelentések levelezőlistájára].',
	'config-subscribe-help' => 'Ez egy alacsony forgalmú levelezőlista, ahol a kiadásokkal kapcsolatos bejelentések jelennek meg, a fontos biztonsági javításokkal együtt.
Ajánlott feliratkozni rá, és frissíteni a MediaWikit, ha új verzió jön ki.',
	'config-subscribe-noemail' => 'Anélkül próbáltál feliratkozni a kiadási bejelentések levelezőlistájára, hogy megadtál volna egy e-mail címet.
Adj meg egyet, ha fel szeretnél iratkozni a levelezőlistára.',
	'config-almost-done' => 'Már majdnem kész!
A további konfigurációt kihagyhatod, és most azonnal elindíthatod a wiki telepítését.',
	'config-optional-continue' => 'További információk megadása.',
	'config-optional-skip' => 'Épp elég volt, települjön a wiki!',
	'config-profile' => 'Felhasználói jogosultságok profilja:',
	'config-profile-wiki' => 'Hagyományos wiki',
	'config-profile-no-anon' => 'Felhasználói fiók létrehozása szükséges',
	'config-profile-fishbowl' => 'Csak engedélyezett szerkesztők',
	'config-profile-private' => 'Privát wiki',
	'config-profile-help' => "A wikik akkor működnek a legjobban, ha minél több felhasználó számára engedélyezett a szerkesztés.
A MediaWikiben könnyű ellenőrizni a legutóbbi változtatásokat,és visszaállítani a naiv vagy káros felhasználók által okozott károkat.

A MediaWiki azonban számos helyzetben hasznos lehet, és néha nem könnyű mindenkit meggyőzni a wiki előnyeiről.
Választhatsz!

'''{{int:config-profile-wiki}}kben''' bárki szerkeszthet, akár bejelentkezés nélkül is. A '''{{int:config-profile-no-anon}}''' beállítás további biztonságot nyújt, azonban elijesztheti az alkalmi szerkesztőket.

Lehetőség van arra is, hogy '''{{lc:{{int:config-profile-fishbowl}}}}''' módosíthassák a lapokat, de a nyilvánosság ekkor megtekintheti a lapokat és azok laptörténetét is. '''{{int:config-profile-private}}''' esetén csak az engedélyezett szerkesztők tekinthetik meg a lapokat, és ugyanez a csoport szerkeszthet.

Telepítés után jóval összetettebb jogosultságrendszer állítható össze, további információ a [//www.mediawiki.org/wiki/Manual:User_rights kézikönyv kapcsolódó bejegyzésében].",
	'config-license' => 'Szerzői jog és licenc:',
	'config-license-none' => 'Nincs licencjelzés',
	'config-license-cc-by-sa' => 'Creative Commons Nevezd meg! - Így add tovább!',
	'config-license-cc-by' => 'Creative Commons Nevezd meg!',
	'config-license-cc-by-nc-sa' => 'Creative Commons Nevezd meg! - Ne add el! - Így add tovább!',
	'config-license-cc-0' => 'Creative Commons Zero (közkincs)',
	'config-license-gfdl' => 'GNU Szabad Dokumentációs Licenc 1.3 vagy újabb',
	'config-license-pd' => 'Közkincs',
	'config-license-cc-choose' => 'Creative Commons-licenc választása',
	'config-license-help' => "A legtöbb wiki valamilyen [http://freedomdefined.org/Definition szabad licenc] alatt teszi közzé a szerkesztéseit.
Ez erősíti a közösségi tulajdon érzését, és elősegíti a hosszú távú közreműködők megjelenését.
Általában nem szükséges magán- vagy vállalati wiki esetén.

Ha a Wikipédiáról szeretnél szövegeket másolni, és a Wikipédián felhasználhassák a wikidben található szöveget, akkor a '''Creative Commons Nevezd meg! - Így add tovább!''' lehetőséget válaszd.

A Wikipédia korábban a GNU Szabad Dokumentációs Licencet használta.
Ez a licenc még ma is használható, azonban nem könnyű megérteni,
továbbá a GFDL alatt közzétett tartalom újrafelhasználása nehézkes.",
	'config-email-settings' => 'E-mail beállítások',
	'config-enable-email' => 'Kimenő e-mailek engedélyezése',
	'config-enable-email-help' => 'E-mailek küldéséhez [http://www.php.net/manual/en/mail.configuration.php a PHP mail beállításait] megfelelően meg kell adni.
Ha nem akarsz semmilyen e-mailes funkciót használni, itt tilthatod le őket.',
	'config-email-user' => 'A felhasználók küldhetnek egymásnak e-maileket',
	'config-email-user-help' => 'Bármelyik felhasználó küldhet másiknak e-mail üzenetet, amennyiben engedélyezték a lehetőséget a beállításaiknál.',
	'config-email-usertalk' => 'Vitalapi értesítések engedélyezése',
	'config-email-usertalk-help' => 'A felhasználók értesítéseket kapnak a vitalapjuk változásairól, amennyiben engedélyezték ezt a lehetőséget a beállításaiknál.',
	'config-email-watchlist' => 'Figyelőlistai értesítések engedélyezése',
	'config-email-watchlist-help' => 'A felhasználók értesítéseket kapnak a figyelt lapjaik változásairól, amennyiben engedélyezték ezt a lehetőséget a beállításaiknál.',
	'config-email-auth' => 'E-mailes hitelesítés engedélyezése',
	'config-email-auth-help' => "Ha a beállítás engedélyezve van, a felhasználóknak meg kell erősíteniük az e-mail címüket egy kiküldött link segítségével, amikor megadják vagy módosítják azt.
Csak a megerősített e-mail címmel rendelkezők kaphatnak e-maileket más felhasználóktól vagy értesítéseket.
A beállítás engedélyezése '''ajánlott''' publikus wikiknél, mivel így megakadályozható az e-mailes funkciókkal való visszaélés.",
	'config-email-sender' => 'Válaszcím:',
	'config-email-sender-help' => 'Add meg a kimenő e-mail-üzenetek válaszcímét.
Ide lesznek küldve a visszapattant üzenetek is.
Számos levelezőszerver számára a cím domainrészének érvényesnek kell lennie.',
	'config-upload-settings' => 'Képek és fájlok feltöltése',
	'config-upload-enable' => 'Fájlfeltöltés engedélyezése',
	'config-upload-help' => 'A fájlfeltöltés lehetséges biztonsági kockázatoknak teszi ki a szerveredet.
További információért olvasd el a [//www.mediawiki.org/wiki/Manual:Security biztonságról szóló szakaszt] a kézikönyvben.

A fájlfeltöltés engedélyezéséhez változtasd meg a MediaWiki gyökérkönyvtárában található <code>images</code> alkönyvtár jogosultságát úgy, hogy a szerver írhasson oda, majd engedélyezd itt a beállítást.',
	'config-upload-deleted' => 'Törölt fájlok könyvtára:',
	'config-upload-deleted-help' => 'Válaszd ki azt a könyvtárat, ahol a törölt fájlok lesznek archiválva.
Normális esetben ennek nem szabad elérhetőnek lennie az internetről.',
	'config-logo' => 'A logó URL-címe:',
	'config-logo-help' => 'A MediaWiki alapértelmezett felülete helyet ad egy 135×160 pixeles logónak a bal felső sarokban.
Tölts fel egy megfelelő méretű képet, majd írd be ide az URL-címét!

Ha nem szeretnél logót használni, egyszerűen hagyd üresen a mezőt.',
	'config-instantcommons' => 'Instant Commons engedélyezése',
	'config-instantcommons-help' => 'Az [//www.mediawiki.org/wiki/InstantCommons Instant Commons] lehetővé teszi, hogy a wikin használhassák a [//commons.wikimedia.org/ Wikimedia Commons] oldalon található képeket, hangokat és más médiafájlokat.
A használatához a MediaWikinek internethozzáférésre van szüksége.

A funkcióról és hogy hogyan állítható be más wikik esetén [//mediawiki.org/wiki/Manual:$wgForeignFileRepos a kézikönyvben] találhatsz további információkat.',
	'config-cc-error' => 'A Creative Commons-licencválasztó nem tért vissza eredménnyel.
Add meg kézzel a licencet.',
	'config-cc-again' => 'Válassz újra…',
	'config-cc-not-chosen' => 'Válaszd ki a kívánt Creative Commons licencet, majd kattints a „Folytatás gombra”!',
	'config-advanced-settings' => 'Haladó beállítások',
	'config-cache-options' => 'Objektum-gyorsítótárazás beállításai:',
	'config-cache-help' => 'Az objektumgyorsítótárazás célja, hogy felgyorsítsa a MediaWiki működését a gyakran használt adatok gyorsítótárazásával.
Közepes vagy nagyobb oldalak esetén erősen ajánlott a használata, de kisebb oldalak esetén is hasznos lehet.',
	'config-cache-none' => 'Nincs gyorsítótárazás (minden funkció működik, de nagyobb wiki esetében lassabb működést eredményezhet)',
	'config-cache-accel' => 'PHP-objektumok gyorsítótárazása (APC, XCache or WinCache)',
	'config-cache-memcached' => 'Memcached használata (további telepítés és konfigurálás szükséges)',
	'config-memcached-servers' => 'Memcached-szerverek:',
	'config-memcached-help' => 'Azon IP-címek listája, melyeket a Memcached használhat.
Vesszővel kell elválasztani őket, és meg kell adni a portot is. Például:
 127.0.0.1:11211
 192.168.1.25:11211',
	'config-memcache-needservers' => 'Memcachedet választottad gyorsítótárnak, de nem adtál meg egyetlen szervert sem.',
	'config-memcache-badip' => 'Érvénytelen IP-címet adtál meg a Memcachednek: $1.',
	'config-memcache-noport' => 'Nem adtál meg portot a Memcached-szervernek: $1.
Ha nem ismered a portszámot, használd az alapértelmezettet: 11211.',
	'config-memcache-badport' => 'A Memcached a(z) $1 és $2 közötti portokat szokta használni.',
	'config-extensions' => 'Kiterjesztések',
	'config-extensions-help' => 'A fent felsorolt kiterjesztések találhatóak meg az <code>./extensions</code> könyvtárban.

Lehetséges, hogy további beállításra lesz szükség hozzájuk, de már most engedélyezheted őket.',
	'config-install-alreadydone' => "'''Figyelmeztetés:''' Úgy tűnik, hogy a MediaWiki telepítve van, és te ismét megpróbálod telepíteni.
Folytasd a következő oldalon.",
	'config-install-begin' => 'A „{{int:config-continue}}” gomb megnyomása elindítja a MediaWiki telepítését.
Ha szeretnél módosítani a beállításokon, kattints a vissza gombra.',
	'config-install-step-done' => 'kész',
	'config-install-step-failed' => 'sikertelen',
	'config-install-extensions' => 'Kiterjesztések beillesztése',
	'config-install-database' => 'Adatbázis felállítása',
	'config-install-schema' => 'Adatbázis-szerkezet létrehozása',
	'config-install-pg-schema-not-exist' => 'A PostgreSQL-adatbázis nem létezik.',
	'config-install-pg-schema-failed' => 'A táblák létrehozása nem sikerült.
Ellenőrizd, hogy „$1” felhasználó írhat-e a következő adatbázisba: „$2”.',
	'config-install-pg-commit' => 'Változtatások közzététele',
	'config-install-pg-plpgsql' => 'PL/pgSQL nyelv meglétének ellenőrzése',
	'config-pg-no-plpgsql' => 'Telepítened kell a PL/pgSQL nyelvet a következő adatbázishoz: $1',
	'config-pg-no-create-privs' => 'A telepítéshez megadott felhasználói fiók nem rendelkezik új fiók létrehozásához szükséges jogosultságokkal.',
	'config-install-user' => 'Adatbázis-felhasználó létrehozása',
	'config-install-user-alreadyexists' => 'Már létezik „$1” nevű felhasználó',
	'config-install-user-create-failed' => 'Nem sikerült a(z) „$1” nevű felhasználó létrehozása: $2',
	'config-install-user-grant-failed' => 'Nem sikerült jogosultságokkal felruházni a(z) „$1” nevű felhasználót: $2',
	'config-install-user-missing' => 'A megadott felhasználó („$1”) nem létezik.',
	'config-install-user-missing-create' => 'A megadott felhasználó („$1”) nem létezik.
Pipáld ki a „Fiók létrehozása” dobozt, ha létre szeretnéd hozni.',
	'config-install-tables' => 'Táblák létrehozása',
	'config-install-tables-exist' => "'''Figyelmeztetés''': úgy tűnik, hogy a MediaWiki táblái már léteznek.
Létrehozás kihagyása.",
	'config-install-tables-failed' => "'''Hiba''': a tábla létrehozása nem sikerült a következő miatt: $1",
	'config-install-interwiki' => 'Alapértelmezett nyelvközihivatkozás-tábla feltöltése',
	'config-install-interwiki-list' => 'Az <code>interwiki.list</code> fájl nem található.',
	'config-install-interwiki-exists' => "'''Figyelmeztetés''': Úgy tűnik, hogy az interwiki táblában már vannak bejegyzések.
Alapértelmezett lista kihagyása.",
	'config-install-stats' => 'Statisztika inicializálása',
	'config-install-keys' => 'Titkos kulcsok generálása',
	'config-insecure-keys' => "'''Figyelmeztetés:''' A telepítés során generált $1 {{PLURAL:$2|biztonsági kulcs|biztonsági kulcsok}} nem teljesen $1 {{PLURAL:$2|biztonságos|biztonságosak}}. Érdemes {{PLURAL:$2||őket}} manuálisan megváltoztatni.",
	'config-install-sysop' => 'Az adminisztrátor felhasználói fiókjának létrehozása',
	'config-install-subscribe-fail' => 'Nem sikerült feliratkozni a mediawiki-announce levelezőlistára: $1',
	'config-install-subscribe-notpossible' => 'A cURL nincs telepítve és az allow_url_fopen nem érhető el.',
	'config-install-mainpage' => 'Kezdőlap létrehozása az alapértelmezett tartalommal',
	'config-install-extension-tables' => 'Táblák létrehozása az engedélyezett kiterjesztésekhez',
	'config-install-mainpage-failed' => 'Nemsikerült létrehozni a kezdőlapot: $1',
	'config-install-done' => "'''Gratulálunk!'''
A MediaWiki telepítése sikeresen befejeződött.

A telepítő elkészítette a <code>LocalSettings.php</code> fájlt, amely tartalmazza az összes beállítást.

Ezt le kell tölteni, majd elhelyezni a wiki telepítési könyvtárába (az a könyvtár, ahol az index.php is található).

A letöltés automatikusan elindul. Ha mégsem indulna el, vagy megszakítottad, az alábbi linkre kattintva újra letöltheted:

$3

'''Megjegyzés''': Ha ezt most nem teszed meg, és kilépsz a telepítésből, az elkészített konfigurációs fájlt nem tudod elérni a későbbiekben.

Ha végeztél a fájl elhelyezésével, '''[$2 beléphetsz a wikibe]'''.",
	'config-download-localsettings' => 'LocalSettings.php letöltése',
	'config-help' => 'segítség',
	'mainpagetext' => "'''A MediaWiki telepítése sikeresen befejeződött.'''",
	'mainpagedocfooter' => "Ha segítségre van szükséged a wikiszoftver használatához, akkor keresd fel a [//meta.wikimedia.org/wiki/Help:Contents User's Guide] oldalt.

== Alapok (angol nyelven) ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Beállítások listája]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki GyIK]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-kiadások levelezőlistája]",
);

/** Magyar (magázó) (Magyar (magázó))
 * @author Dani
 * @author Glanthor Reviol
 */
$messages['hu-formal'] = array(
	'config-localsettings-upgrade' => "'''Figyelmeztetés''': már létezik a <code>LocalSettings.php</code> fájl.
A szoftver frissíthető.
Adja meg a <code>\$wgUpgradeKey</code>-ben található kulcsot a beviteli mezőben", # Fuzzy
	'config-session-expired' => 'Úgy tűnik, hogy a munkamenetadatok lejártak.
A munkamenetek élettartama a következőre van beállítva: $1.
Az érték növelhető a php.ini <code>session.gc_maxlifetime</code> beállításának módosításával.
Indítsa újra a telepítési folyamatot.',
	'config-no-session' => 'Elvesztek a munkamenetadatok!
Ellenőrizze, hogy a php.ini-ben a <code>session.save_path</code> beállítás a megfelelő könyvtárra mutat-e.',
	'config-your-language-help' => 'Válassza ki a telepítési folyamat során használandó nyelvet.',
	'config-wiki-language-help' => 'Az a nyelv, amin a wiki tartalmának legnagyobb része íródik.',
	'config-page-welcome' => 'Üdvözli a MediaWiki!',
	'config-help-restart' => 'Szeretné törölni az eddig megadott összes adatot és újraindítani a telepítési folyamatot?',
	'config-welcome' => '=== Környezet ellenőrzése ===
Alapvető ellenőrzés, ami megmondja, hogy a környezet alkalmas-e a MediaWiki számára.
Ha probléma merülne fel a telepítés során, meg kell adnia mások számára az alább megjelenő információkat.',
	'config-unicode-pure-php-warning' => "'''Figyelmeztetés''': Az [http://pecl.php.net/intl intl PECL kiterjesztés] nem érhető el Unicode normalizáláshoz.
Ha nagy látogatottságú oldalt üzemeltet, itt találhat információkat [//www.mediawiki.org/wiki/Unicode_normalization_considerations a témáról].", # Fuzzy
	'config-register-globals' => "'''Figyelmeztetés: A PHP <code>[http://php.net/register_globals register_globals]</code> beállítása engedélyezve van.'''
'''Tiltsa le, ha van rá lehetősége.'''
A MediaWiki működőképes a beállítás használata mellett, de a szerver biztonsági kockázatnak lesz kitéve.",
	'config-imagemagick' => 'Az ImageMagick megtalálható a rendszeren: <code>$1</code>.
A bélyegképek készítése engedélyezve lesz, ha engedélyezi a feltöltéseket.',
	'config-db-name-help' => 'Válassza ki a wikije azonosítására használt nevet.
Nem tartalmazhat szóközt vagy kötőjelet.

Ha megosztott webtárhelyet használ, a szolgáltatója vagy egy konkrét adatbázisnevet ad önnek használatra, vagy létrehozhat egyet a vezérlőpulton keresztül.', # Fuzzy
	'config-db-install-help' => 'Adja meg a felhasználónevet és jelszót, amivel a telepítő csatlakozhat az adatbázishoz.',
	'config-db-wiki-help' => 'Adja meg azt a felhasználónevet és jelszót, amivel a wiki fog csatlakozni az adatbázishoz működés közben.
Ha a fiók nem létezik és a telepítést végző fiók rendelkezik megfelelő jogosultsággal, egy új fiók készül a megadott a névvel, azon minimális jogosultságkörrel, ami a wiki működéséhez szükséges.',
	'config-charset-help' => "'''Figyelmezetés:''' Ha a '''visszafelé kompatibilis UTF-8''' beállítást használja MySQL 4.1 vagy újabb verziók esetén, és utána a <code>mysqldump</code> programmal készít róla biztonsági másolatot, az tönkreteheti az összes nem ASCII-karaktert, visszafordíthatatlanul károsítva a másolatokban tárolt adatokat!

'''Bináris''' módban a MediaWiki az UTF-8-ban kódolt szöveget bináris mezőkben tárolja az adatbázisban.
Ez sokkal hatékonyabb a MySQL UTF-8-módjától, és lehetővé teszi, hogy a teljes Unicode-karakterkészletet használja.
'''UTF-8-módban''' MySQL tudja, hogy milyen karakterkészlettel van kódolva az adat, megfelelően van megjelenítve és konvertálva, de
nem használhatja a [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane] feletti karaktereket.",
	'config-db-schema-help' => 'A fenti sémák általában megfelelőek.
Csak akkor módosítson rajta, ha szükség van rá.', # Fuzzy
	'config-sqlite-parent-unwritable-nogroup' => 'Nem lehet létrehozni az adatok tárolásához szükséges <code><nowiki>$1</nowiki></code> könyvtárat, mert a webszerver nem írhat a szülőkönyvtárba (<code><nowiki>$2</nowiki></code>).

A telepítő nem tudta megállapíteni, hogy melyik felhasználói fiókon fut a webszerver.
A folytatáshoz tegye írhatóvá ezen fiók (és más fiókok!) számára a következő könyvtárat: <code><nowiki>$3</nowiki></code>.
Unix/Linux rendszereken tedd a következőt:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-ns-other' => 'Más (adja meg)',
	'config-admin-name-blank' => 'Adja meg az adminisztrátor felhasználónevét!',
	'config-admin-name-invalid' => 'A megadott felhasználónév (<nowiki>$1</nowiki>) érvénytelen.
Adjon meg egy másik felhasználónevet.',
	'config-admin-password-blank' => 'Adja meg az adminisztrátori fiók jelszavát!',
	'config-instantcommons-help' => 'Az [//www.mediawiki.org/wiki/InstantCommons Instant Commons] lehetővé teszi, hogy a wikin használhassák a [//commons.wikimedia.org/ Wikimedia Commons] oldalon található képeket, hangokat és más médiafájlokat.
A használatához a MediaWikinek internethozzáférésre van szüksége.

A funkcióról és hogy hogyan állítható be más wikik esetén [//mediawiki.org/wiki/Manual:$wgForeignFileRepos a kézikönyvben] találhat további információkat.',
	'config-install-done' => "'''Gratulálunk!'''
Sikeresen telepítette a MediaWikit.

A telepítő készített egy <code>LocalSettings.php</code> fájlt.
Ez tartalmazza az összes beállítást.

[$1 Le kell töltenie], és el kell helyeznie a MediaWiki telepítési könyvtárába (az a könyvtár, ahol az index.php van).
'''Megjegyzés''': Ha ezt most nem teszi meg, és kilép, a generált fájl nem lesz elérhető a későbbiekben.

Ha ezzel készen van, '''[$2 beléphet a wikibe]'''.", # Fuzzy
	'mainpagedocfooter' => "Ha segítségre van szüksége a wikiszoftver használatához, akkor keresse fel a [//meta.wikimedia.org/wiki/Help:Contents User's Guide] oldalt.

== Alapok (angol nyelven) ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Beállítások listája]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki GyIK]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-kiadások levelezőlistája]",
);

/** Armenian (Հայերեն)
 */
$messages['hy'] = array(
	'mainpagetext' => "'''«MediaWiki» ծրագիրը հաջողությամբ տեղադրվեց։'''",
	'mainpagedocfooter' => "Այցելեք [//meta.wikimedia.org/wiki/Help:Contents User's Guide]՝ վիքի ծրագրային ապահովման օգտագործման մասին տեղեկությունների համար։

== Որոշ օգտակար ռեսուրսներ ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'config-desc' => 'Le installator de MediaWiki',
	'config-title' => 'Installation de MediaWiki $1',
	'config-information' => 'Information',
	'config-localsettings-upgrade' => 'Un file <code>LocalSettings.php</code> ha essite detegite.
Pro actualisar iste installation, per favor entra le valor de <code>$wgUpgradeKey</code> in le quadro hic infra.
Iste se trova in LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Un file LocalSettings.php file ha essite detegite.
Pro actualisar iste installation, per favor executa upgrade.php.',
	'config-localsettings-key' => 'Clave de actualisation:',
	'config-localsettings-badkey' => 'Le clave que tu forniva es incorrecte',
	'config-upgrade-key-missing' => 'Un installation existente de MediaWiki ha essite detegite.
Pro actualisar iste installation, es necessari adjunger le sequente linea al fin del file LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Le file LocalSettings.php existente pare esser incomplete.
Le variabile $1 non es definite.
Per favor cambia LocalSettings.php de sorta que iste variabile es definite, e clicca "Continuar".',
	'config-localsettings-connection-error' => 'Un error esseva incontrate durante le connexion al base de datos usante le configurationes specificate in LocalSettings.php o AdminSettings.php. Per favor repara iste configurationes e tenta lo de novo.

$1',
	'config-session-error' => 'Error al comenciamento del session: $1',
	'config-session-expired' => 'Le datos de tu session pare haber expirate.
Le sessiones es configurate pro un duration de $1.
Tu pote augmentar isto per definir <code>session.gc_maxlifetime</code> in php.ini.
Reinitia le processo de installation.',
	'config-no-session' => 'Le datos de tu session es perdite!
Verifica tu php.ini e assecura te que un directorio appropriate es definite in <code>session.save_path</code>.',
	'config-your-language' => 'Tu lingua:',
	'config-your-language-help' => 'Selige un lingua a usar durante le processo de installation.',
	'config-wiki-language' => 'Lingua del wiki:',
	'config-wiki-language-help' => 'Selige le lingua in que le wiki essera predominantemente scribite.',
	'config-back' => '← Retro',
	'config-continue' => 'Continuar →',
	'config-page-language' => 'Lingua',
	'config-page-welcome' => 'Benvenite a MediaWiki!',
	'config-page-dbconnect' => 'Connecter al base de datos',
	'config-page-upgrade' => 'Actualisar le installation existente',
	'config-page-dbsettings' => 'Configuration del base de datos',
	'config-page-name' => 'Nomine',
	'config-page-options' => 'Optiones',
	'config-page-install' => 'Installar',
	'config-page-complete' => 'Complete!',
	'config-page-restart' => 'Reinitiar installation',
	'config-page-readme' => 'Lege me',
	'config-page-releasenotes' => 'Notas del version',
	'config-page-copying' => 'Copiar',
	'config-page-upgradedoc' => 'Actualisar',
	'config-page-existingwiki' => 'Wiki existente',
	'config-help-restart' => 'Vole tu rader tote le datos salveguardate que tu ha entrate e reinitiar le processo de installation?',
	'config-restart' => 'Si, reinitia lo',
	'config-welcome' => '=== Verificationes del ambiente ===
Verificationes de base es exequite pro determinar si iste ambiente es apte pro le installation de MediaWiki.
Tu deberea indicar le resultatos de iste verificationes si tu ha besonio de adjuta durante le installation.',
	'config-copyright' => "=== Copyright and Terms ===

$1

Iste programma es software libere; vos pote redistribuer lo e/o modificar lo sub le conditiones del Licentia Public General de GNU publicate per le Free Software Foundation; version 2 del Licentia, o (a vostre option) qualcunque version posterior.

Iste programma es distribuite in le sperantia que illo sia utile, ma '''sin garantia''', sin mesmo le implicite garantia de '''commercialisation''' o '''aptitude pro un proposito particular'''.
Vide le Licentia Public General de GNU pro plus detalios.

Vos deberea haber recipite <doclink href=Copying>un exemplar del Licentia Public General de GNU</doclink> con iste programma; si non, scribe al Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA, o [http://www.gnu.org/copyleft/gpl.html lege lo in linea].",
	'config-sidebar' => '* [//www.mediawiki.org Pagina principal de MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents Guida pro usatores]
* [//www.mediawiki.org/wiki/Manual:Contents Guida pro administratores]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>Lege me</doclink>
* <doclink href=ReleaseNotes>Notas de iste version</doclink>
* <doclink href=Copying>Conditiones de copia</doclink>
* <doclink href=UpgradeDoc>Actualisation</doclink>',
	'config-env-good' => 'Le ambiente ha essite verificate.
Tu pote installar MediaWiki.',
	'config-env-bad' => 'Le ambiente ha essite verificate.
Tu non pote installar MediaWiki.',
	'config-env-php' => 'PHP $1 es installate.',
	'config-env-php-toolow' => 'PHP $1 es installate.
Nonobstante, MediaWiki require PHP $2 o plus recente.',
	'config-unicode-using-utf8' => 'utf8_normalize.so per Brion Vibber es usate pro le normalisation Unicode.',
	'config-unicode-using-intl' => 'Le [http://pecl.php.net/intl extension PECL intl] es usate pro le normalisation Unicode.',
	'config-unicode-pure-php-warning' => "'''Aviso''': Le [http://pecl.php.net/intl extension PECL intl] non es disponibile pro exequer le normalisation Unicode; le systema recurre al implementation lente in PHP pur.
Si tu sito ha un alte volumine de traffico, tu deberea informar te un poco super le [//www.mediawiki.org/wiki/Unicode_normalization_considerations normalisation Unicode].",
	'config-unicode-update-warning' => "'''Aviso''': Le version installate del bibliotheca inveloppante pro normalisation Unicode usa un version ancian del bibliotheca del [http://site.icu-project.org/ projecto ICU].
Tu deberea [//www.mediawiki.org/wiki/Unicode_normalization_considerations actualisar lo] si le uso de Unicode importa a te.",
	'config-no-db' => 'Non poteva trovar un driver appropriate pro le base de datos! Es necessari installar un driver de base de datos pro PHP.
Le sequente typos de base de datos es supportate: $1.

Si tu sito usa un servitor dividite (shared hosting), demanda a tu providitor de installar un driver de base de datos appropriate.
Si tu compilava PHP tu mesme, reconfigura lo con un cliente de base de datos activate, per exemplo usante <code>./configure --with-mysql</code>.
Si tu installava PHP ex un pacchetto Debian o Ubuntu, tu debe installar equalmente le modulo php5-mysql.',
	'config-outdated-sqlite' => "'''Attention''': tu ha SQLite $1, que es inferior al version minimal requirite, $2. SQLite essera indisponibile.",
	'config-no-fts3' => "'''Attention''': SQLite es compilate sin [//sqlite.org/fts3.html modulo FTS3]; functionalitate de recerca non essera disponibile in iste back-end.",
	'config-register-globals' => "'''Attention: le option <code>[http://php.net/register_globals register_globals]</code> de PHP es activate.'''
'''Disactiva lo si tu pote.'''
MediaWiki functionara, ma tu servitor es exponite a potential vulnerabilitates de securitate.",
	'config-magic-quotes-runtime' => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] es active!'''
Iste option corrumpe le entrata de datos imprevisibilemente.
Tu non pote installar o usar MediaWiki si iste option non es disactivate.",
	'config-magic-quotes-sybase' => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] es active!'''
Iste option corrumpe le entrata de datos imprevisibilemente.
Tu non pote installar o usar MediaWiki si iste option non es disactivate.",
	'config-mbstring' => "'''Fatal: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] es active!'''
Iste option causa errores e pote corrumper datos imprevisibilemente.
Tu non pote installar o usar MediaWiki si iste option non es disactivate.",
	'config-ze1' => "'''Fatal: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] es active!'''
Iste option causa horribile defectos con MediaWiki.
Tu non pote installar o usar MediaWiki si iste option non es disactivate.",
	'config-safe-mode' => "'''Aviso:''' Le [http://www.php.net/features.safe-mode modo secur] de PHP es active.
Isto pote causar problemas, particularmente si es usate le incargamento de files e le supporto de <code>math</code>.",
	'config-xml-bad' => 'Le modulo XML de PHP es mancante.
MediaWiki require functiones de iste modulo e non functionara in iste configuration.
Si tu usa Mandrake, installa le pacchetto php-xml.',
	'config-pcre' => 'Le modulo de supporto PCRE pare esser mancante.
MediaWiki require le functiones de expression regular compatibile con Perl pro poter functionar.',
	'config-pcre-no-utf8' => "'''Fatal''': Le modulo PCRE de PHP pare haber essite compilate sin supporto de PCRE_UTF8.
MediaWiki require supporto de UTF-8 pro functionar correctemente.",
	'config-memory-raised' => 'Le <code>memory_limit</code> de PHP es $1, elevate a $2.',
	'config-memory-bad' => "'''Aviso:''' Le <code>memory_limit</code> de PHP es $1.
Isto es probabilemente troppo basse.
Le installation pote faller!",
	'config-ctype' => "'''Fatal''': PHP debe esser compilate con supporto pro le [http://www.php.net/manual/en/ctype.installation.php extension Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] es installate',
	'config-apc' => '[http://www.php.net/apc APC] es installate',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] es installate',
	'config-no-cache' => "'''Aviso:''' Non poteva trovar [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] o [http://www.iis.net/download/WinCacheForPhp WinCache].
Le cache de objectos non es activate.",
	'config-mod-security' => "'''Attention''': [http://modsecurity.org/ mod_security] es active in tu servitor web. Si mal configurate, isto pote causar problemas pro MediaWiki o altere software que permitte al usatores de publicar contento arbitrari.
Consulta le [http://modsecurity.org/documentation/ documentation de mod_security] o contacta le servicio de adjuta de tu host si tu incontra estranie errores.",
	'config-diff3-bad' => 'GNU diff3 non trovate.',
	'config-imagemagick' => 'ImageMagick trovate: <code>$1</code>.
Le miniaturas de imagines essera activate si tu activa le incargamento de files.',
	'config-gd' => 'Le bibliotheca graphic GD se trova integrate in le systema.
Le miniaturas de imagines essera activate si tu activa le incargamento de files.',
	'config-no-scaling' => 'Non poteva trovar le bibliotheca GD ni ImageMagick.
Le miniaturas de imagines essera disactivate.',
	'config-no-uri' => "'''Error:''' Non poteva determinar le URI actual.
Installation abortate.",
	'config-no-cli-uri' => "'''Attention''': Cammino al script (--scriptpath) non specificate. Le predefinition es usate: <code>$1</code>.",
	'config-using-server' => 'Es usate le nomine de servitor "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Le URL de servitor "<nowiki>$1$2</nowiki>" es usate.',
	'config-uploads-not-safe' => "'''Aviso:''' Le directorio predefinite pro files incargate <code>$1</code> es vulnerabile al execution arbitrari de scripts.
Ben que MediaWiki verifica tote le files incargate contra le menacias de securitate, il es altemente recommendate [//www.mediawiki.org/wiki/Manual:Security#Upload_security remediar iste vulnerabilitate de securitate] ante de activar le incargamento de files.",
	'config-no-cli-uploads-check' => "'''Attention:''' Le directorio predefinite pro files incargate (<code>$1</code>) non es verificate contra le vulnerabilitate
al execution arbitrari de scripts durante le installation de CLI.",
	'config-brokenlibxml' => 'Vostre systema ha un combination de versiones de PHP e libxml2 que es defectuose e pote causar corruption celate de datos in MediaWiki e altere applicationes web.
Actualisa a PHP 5.2.9 o plus recente e libxml2 2.7.3 o plus recente ([//bugs.php.net/bug.php?id=45996 problema reportate presso PHP]).
Installation abortate.',
	'config-using531' => 'MediaWiki non pote esser usate con PHP $1 a causa de un defecto concernente parametros de referentia a <code>__call()</code>.
Actualisa a PHP 5.3.2 o plus recente, o retrograda a PHP 5.3.0 pro remediar isto.
Installation abortate.',
	'config-suhosin-max-value-length' => 'Suhosin es installate e limita le longitude del parametro GET a $1 bytes. Le componente ResourceLoader de MediaWiki pote contornar iste limite, ma isto degradara le rendimento. Si possibile, tu deberea mitter suhosin.get.max_value_length a 1024 o plus in php.ini , e mitter $wgResourceLoaderMaxQueryLength al mesme valor in LocalSettings.php .',
	'config-db-type' => 'Typo de base de datos:',
	'config-db-host' => 'Servitor de base de datos:',
	'config-db-host-help' => 'Si tu servitor de base de datos es in un altere servitor, entra hic le nomine o adresse IP del servitor.

Si tu usa un servitor web usate in commun, tu providitor deberea dar te le correcte nomine de servitor in su documentation.

Si tu face le installation in un servitor Windows e usa MySQL, le nomine "localhost" possibilemente non functiona como nomine de servitor. In tal caso, essaya "127.0.0.1", i.e. le adresse IP local.

Si tu usa PostgreSQL, lassa iste campo vacue pro connecter via un "socket" de Unix.',
	'config-db-host-oracle' => 'TNS del base de datos:',
	'config-db-host-oracle-help' => 'Entra un [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm nomine Local Connect] valide; un file tnsnames.ora debe esser visibile a iste installation.<br />Si tu usa bibliothecas de cliente 10g o plus recente, tu pote anque usar le methodo de nomination [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identificar iste wiki',
	'config-db-name' => 'Nomine del base de datos:',
	'config-db-name-help' => 'Selige un nomine que identifica tu wiki.
Illo non pote continer spatios.

Si tu usa un servitor web usate in commun, tu providitor te fornira le nomine specific de un base de datos a usar, o te permitte crear un base de datos via un pannello de controlo.',
	'config-db-name-oracle' => 'Schema del base de datos:',
	'config-db-account-oracle-warn' => 'Il ha tres scenarios supportate pro le installation de Oracle como le base de datos de iste systema:

Si tu vole crear un conto del base de datos como parte del processo de installation, per favor specifica un conto con le rolo SYSDBA como le conto del base de datos pro installation, e specifica le nomine e contrasigno desirate pro le conto de accesso per web. Alteremente tu pote crear le conto de accesso per web manualmente e specificar solmente iste conto (si illo ha le permissiones requisite pro crear le objectos de schema) o specifica duo contos differente, un con privilegios de creation e un conto restringite pro accesso per web.

Un script pro crear un conto con le privilegios requisite se trova in le directorio "maintenance/oracle/" de iste installation. Non oblida que le uso de un conto restringite disactiva tote le capacitates de mantenentia in le conto predefinite.',
	'config-db-install-account' => 'Conto de usator pro installation',
	'config-db-username' => 'Nomine de usator del base de datos:',
	'config-db-password' => 'Contrasigno del base de datos:',
	'config-db-password-empty' => 'Per favor entra un contrasigno pro le nove usator del base de datos: $1.
Ben que il es possibile crear usatores sin contrasigno, isto non es secur.',
	'config-db-install-username' => 'Entra le nomine de usator que essera usate pro connecter al base de datos durante le processo de installation. Isto non es le nomine de usator del conto MediaWiki; isto es le nomine de usator pro tu base de datos.',
	'config-db-install-password' => 'Entra le contrasigno que essera usate pro connecter al base de datos durante le processo de installation. Isto non es le contrasigno del conto MediaWiki; isto es le contrasigno pro tu base de datos.',
	'config-db-install-help' => 'Entra le nomine de usator e contrasigno que essera usate pro connecter al base de datos durante le processo de installation.',
	'config-db-account-lock' => 'Usar le mesme nomine de usator e contrasigno durante le operation normal',
	'config-db-wiki-account' => 'Conto de usator pro operation normal',
	'config-db-wiki-help' => 'Entra le nomine de usator e contrasigno que essera usate pro connecter al base de datos durante le operation normal del wiki.
Si le conto non existe, e si le conto de installation possede sufficiente privilegios, iste conto de usator essera create con le minime privilegios necessari pro operar le wiki.',
	'config-db-prefix' => 'Prefixo de tabella del base de datos:',
	'config-db-prefix-help' => 'Si il es necessari usar un base de datos in commun inter multiple wikis, o inter MediaWiki e un altere application web, tu pote optar pro adder un prefixo a tote le nomines de tabella pro evitar conflictos.
Non usa spatios.

Iste campo usualmente resta vacue.',
	'config-db-charset' => 'Codification de characteres in le base de datos',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binari',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 retrocompatibile UTF-8',
	'config-charset-help' => "'''Aviso:''' Si tu usa '''UTF-8 retrocompatibile''' sur MySQL 4.1+, e postea face un copia de reserva del base de datos con <code>mysqldump</code>, tote le characteres non ASCII pote esser destruite, resultante in corruption irreversibile de tu copias de reserva!

In '''modo binari''', MediaWiki immagazina texto in UTF-8 in le base de datos in campos binari.
Isto es plus efficiente que le modo UTF-8 de MySQL, e permitte usar le rango complete de characteres de Unicode.
In '''modo UTF-8''', MySQL sapera in qual codification de characteres tu datos es, e pote presentar e converter lo appropriatemente,
ma non te permittera immagazinar characteres supra le [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Plano Multilingue Basic].",
	'config-mysql-old' => 'MySQL $1 o plus recente es requirite, tu ha $2.',
	'config-db-port' => 'Porto de base de datos:',
	'config-db-schema' => 'Schema pro MediaWiki',
	'config-db-schema-help' => 'Iste schema es generalmente correcte.
Solmente cambia lo si tu es secur que es necessari.',
	'config-pg-test-error' => "Impossibile connecter al base de datos '''$1''': $2",
	'config-sqlite-dir' => 'Directorio pro le datos de SQLite:',
	'config-sqlite-dir-help' => "SQLite immagazina tote le datos in un sol file.

Le directorio que tu forni debe permitter le accesso de scriptura al servitor web durante le installation.

Illo '''non''' debe esser accessibile via web. Pro isto, nos non lo pone ubi tu files PHP es.

Le installator scribera un file <code>.htaccess</code> insimul a illo, ma si isto falli, alcuno pote ganiar accesso directe a tu base de datos.
Isto include le crude datos de usator (adresses de e-mail, contrasignos codificate) assi como versiones delite e altere datos restringite super le wiki.

Considera poner le base de datos in un loco completemente differente, per exemplo in <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Spatio de tabellas predefinite:',
	'config-oracle-temp-ts' => 'Spatio de tabellas temporari:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki supporta le sequente systemas de base de datos:

$1

Si tu non vide hic infra le systema de base de datos que tu tenta usar, alora seque le instructiones ligate hic supra pro activar le supporto.',
	'config-support-mysql' => '* $1 es le systema primari pro MediaWiki e le melio supportate ([http://www.php.net/manual/en/mysql.installation.php como compilar PHP con supporto de MySQL])',
	'config-support-postgres' => '* $1 es un systema de base de datos popular e open source, alternativa a MySQL ([http://www.php.net/manual/en/pgsql.installation.php como compilar PHP con supporto de PostgreSQL]). Es possibile que resta alcun minor defectos non resolvite, dunque illo non es recommendate pro uso in un ambiente de production.',
	'config-support-sqlite' => '* $1 es un systema de base de datos legier que es multo ben supportate. ([http://www.php.net/manual/en/pdo.installation.php Como compilar PHP con supporto de SQLite], usa PDO)',
	'config-support-oracle' => '* $1 es un banca de datos commercial pro interprisas. ([http://www.php.net/manual/en/oci8.installation.php Como compilar PHP con supporto de OCI8])',
	'config-support-ibm_db2' => '* $1 es un systema commercial de base de datos pro interprisas.',
	'config-header-mysql' => 'Configuration de MySQL',
	'config-header-postgres' => 'Configuration de PostgreSQL',
	'config-header-sqlite' => 'Configuration de SQLite',
	'config-header-oracle' => 'Configuration de Oracle',
	'config-header-ibm_db2' => 'Configurationes pro IBM DB2',
	'config-invalid-db-type' => 'Typo de base de datos invalide',
	'config-missing-db-name' => 'Tu debe entrar un valor pro "Nomine de base de datos"',
	'config-missing-db-host' => 'Tu debe entrar un valor pro "Host del base de datos"',
	'config-missing-db-server-oracle' => 'You must enter a value for "TNS del base de datos"',
	'config-invalid-db-server-oracle' => 'TNS de base de datos "$1" invalide.
Usa solmente litteras ASCII (a-z, A-Z), numeros (0-9), characteres de sublineamento (_) e punctos (.).',
	'config-invalid-db-name' => 'Nomine de base de datos "$1" invalide.
Usa solmente litteras ASCII (a-z, A-Z), numeros (0-9), characteres de sublineamento (_) e tractos de union (-).',
	'config-invalid-db-prefix' => 'Prefixo de base de datos "$1" invalide.
Usa solmente litteras ASCII (a-z, A-Z), numeros (0-9), characteres de sublineamento (_) e tractos de union (-).',
	'config-connection-error' => '$1.

Verifica le servitor, nomine de usator e contrasigno hic infra e reproba.',
	'config-invalid-schema' => 'Schema invalide pro MediaWiki "$1".
Usa solmente litteras ASCII (a-z, A-Z), numeros (0-9) e characteres de sublineamento (_).',
	'config-db-sys-create-oracle' => 'Le installator supporta solmente le uso de un conto SYSDBA pro le creation de un nove conto.',
	'config-db-sys-user-exists-oracle' => 'Le conto de usator "$1" ja existe. SYSDBA pote solmente esser usate pro le creation de un nove conto!',
	'config-postgres-old' => 'PostgreSQL $1 o plus recente es requirite, tu ha $2.',
	'config-sqlite-name-help' => 'Selige un nomine que identifica tu wiki.
Non usar spatios o tractos de union.
Isto essera usate pro le nomine del file de datos de SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Impossibile crear le directorio de datos <code><nowiki>$1</nowiki></code>, proque le directorio superjacente <code><nowiki>$2</nowiki></code> non concede le accesso de scriptura al servitor web.

Le installator ha determinate le usator sub que le servitor web es executate.
Concede le accesso de scriptura in le directorio <code><nowiki>$3</nowiki></code> a iste usator pro continuar.
In un systema Unix/Linux:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Impossibile crear le directorio de datos <code><nowiki>$1</nowiki></code>, proque le directorio superjacente <code><nowiki>$2</nowiki></code> non concede le accesso de scriptura al servitor web.

Le installator non poteva determinar le usator sub que le servitor web es executate.
Concede le accesso de scriptura in le directorio <code><nowiki>$3</nowiki></code> a iste usator (e alteres!) pro continuar.
In un systema Unix/Linux:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Error al creation del directorio de datos "$1".
Verifica le loco e reproba.',
	'config-sqlite-dir-unwritable' => 'Impossibile scriber in le directorio "$1".
Cambia su permissiones de sorta que le servitor web pote scriber in illo, e reproba.',
	'config-sqlite-connection-error' => '$1.

Verifica le directorio de datos e le nomine de base de datos hic infra e reproba.',
	'config-sqlite-readonly' => 'Le file <code>$1</code> non es accessibile pro scriptura.',
	'config-sqlite-cant-create-db' => 'Non poteva crear le file de base de datos <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP non ha supporto pro FTS3. Le tabellas es retrogradate.',
	'config-can-upgrade' => "Il ha tabellas MediaWiki in iste base de datos.
Pro actualisar los a MediaWiki $1, clicca super '''Continuar'''.",
	'config-upgrade-done' => "Actualisation complete.

Tu pote ora [$1 comenciar a usar tu wiki].

Si tu vole regenerar tu file <code>LocalSettings.php</code>, clicca super le button hic infra.
Isto '''non es recommendate''' si tu non ha problemas con tu wiki.",
	'config-upgrade-done-no-regenerate' => 'Actualisation complete.

Tu pote ora [$1 comenciar a usar tu wiki].',
	'config-regenerate' => 'Regenerar LocalSettings.php →',
	'config-show-table-status' => 'Le consulta SHOW TABLE STATUS falleva!',
	'config-unknown-collation' => "'''Aviso:''' Le base de datos usa un collation non recognoscite.",
	'config-db-web-account' => 'Conto de base de datos pro accesso via web',
	'config-db-web-help' => 'Selige le nomine de usator e contrasigno que le servitor web usara pro connecter al servitor de base de datos, durante le operation ordinari del wiki.',
	'config-db-web-account-same' => 'Usar le mesme conto que pro le installation',
	'config-db-web-create' => 'Crear le conto si illo non jam existe',
	'config-db-web-no-create-privs' => 'Le conto que tu specificava pro installation non ha sufficiente privilegios pro crear un conto.
Le conto que tu specifica hic debe jam exister.',
	'config-mysql-engine' => 'Motor de immagazinage:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "* '''Attention:''' Tu ha seligite MyISAM como motor de immagazinage pro MySQL, lo que non es recommendate pro uso con MediaWiki, perque:
* illo a pena supporta le processamento simultanee a causa del blocada le tabulas
* illo es plus susceptibile al corruption que altere motores
* le base de codice de MediaWiki non sempre manea MyISAM como illo deberea

Si tu installation de MySQL supporta InnoDB, es multo recommendate que tu selige iste in su loco.
Si tu installation de MySQL non supporta InnoDB, forsan isto es un bon occasion pro actualisar lo.",
	'config-mysql-engine-help' => "'''InnoDB''' es quasi sempre le melior option, post que illo ha bon supporto pro simultaneitate.

'''MyISAM''' pote esser plus rapide in installationes a usator singule o a lectura solmente.
Le bases de datos MyISAM tende a esser corrumpite plus frequentemente que le base de datos InnoDB.",
	'config-mysql-charset' => 'Codification de characteres in le base de datos:',
	'config-mysql-binary' => 'Binari',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "In '''modo binari''', MediaWiki immagazina le texto UTF-8 in le base de datos in campos binari.
Isto es plus efficiente que le modo UTF-8 de MySQL, e permitte usar le rango complete de characteres Unicode.

In '''modo UTF-8''', MySQL cognoscera le codification de characteres usate pro tu dats, e pote presentar e converter lo appropriatemente, ma illo non permittera immagazinar characteres supra le [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Plano Multilingue Basic].",
	'config-ibm_db2-low-db-pagesize' => 'Tu base de datos DB2 ha un "tablespace" (spatio de tabella) predefinite con un "pagesize" (dimension de pagina) insufficiente. Le "pagesize" debe esser \'\'\'32K\'\'\' o plus.',
	'config-site-name' => 'Nomine del wiki:',
	'config-site-name-help' => 'Isto apparera in le barra de titulo del navigator e in varie altere locos.',
	'config-site-name-blank' => 'Entra un nomine de sito.',
	'config-project-namespace' => 'Spatio de nomines del projecto:',
	'config-ns-generic' => 'Projecto',
	'config-ns-site-name' => 'Mesme nomine que le wiki: $1',
	'config-ns-other' => 'Altere (specifica)',
	'config-ns-other-default' => 'MiWiki',
	'config-project-namespace-help' => 'Sequente le exemplo de Wikipedia, multe wikis tene lor paginas de politica separate de lor paginas de contento, in un "\'\'\'spatio de nomines de projecto\'\'\'".
Tote le titulos de pagina in iste spatio de nomines comencia con un certe prefixo, le qual tu pote specificar hic.
Traditionalmente, iste prefixo deriva del nomine del wiki, ma illo non pote continer characteres de punctuation como "#" o ":".',
	'config-ns-invalid' => 'Le spatio de nomines specificate "<nowiki>$1</nowiki>" es invalide.
Specifica un altere spatio de nomines de projecto.',
	'config-ns-conflict' => 'Le spatio de nomines specificate "<nowiki>$1</nowiki>" conflige con un spatio de nomines predefinite de MediaWiki.
Specifica un altere spatio de nomines pro le projecto.',
	'config-admin-box' => 'Conto de administrator',
	'config-admin-name' => 'Tu nomine:',
	'config-admin-password' => 'Contrasigno:',
	'config-admin-password-confirm' => 'Repete contrasigno:',
	'config-admin-help' => 'Entra hic tu nomine de usator preferite, per exemplo "Julio Cesare".
Isto es le nomine que tu usara pro aperir session in le wiki.',
	'config-admin-name-blank' => 'Entra un nomine de usator pro administrator.',
	'config-admin-name-invalid' => 'Le nomine de usator specificate "<nowiki>$1</nowiki>" es invalide.
Specifica un altere nomine de usator.',
	'config-admin-password-blank' => 'Entra un contrasigno pro le conto de administrator.',
	'config-admin-password-same' => 'Le contrasigno non pote esser le mesme que le nomine de usator.',
	'config-admin-password-mismatch' => 'Le duo contrasignos que tu scribeva non es identic.',
	'config-admin-email' => 'Adresse de e-mail:',
	'config-admin-email-help' => 'Entra un adresse de e-mail hic pro permitter le reception de e-mail ab altere usatores del wiki, pro poter reinitialisar tu contrasigno, e pro reciper notification de cambios a paginas in tu observatorio. Iste campo pote esser lassate vacue.',
	'config-admin-error-user' => 'Error interne durante le creation de un administrator con le nomine "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Error interne durante le definition de un contrasigno pro le administrator "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Tu ha entrate un adresse de e-mail invalide',
	'config-subscribe' => 'Subscribe al [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce lista de diffusion pro annuncios de nove versiones].',
	'config-subscribe-help' => 'Isto es un lista de e-mail a basse volumine pro annuncios de nove versiones, includente importante annuncios de securitate.
Tu deberea subscriber a illo e actualisar tu installation de MediaWiki quando nove versiones es editate.',
	'config-subscribe-noemail' => 'Tu tentava abonar te al lista de diffusion pro annunciamento de nove versiones sin fornir un adresse de e-mail.
Per favor specifica un adresse de e-mail si tu vole abonar te al lista de diffusion.',
	'config-almost-done' => 'Tu ha quasi finite!
Tu pote ora saltar le configuration remanente e installar le wiki immediatemente.',
	'config-optional-continue' => 'Pone me plus questiones.',
	'config-optional-skip' => 'Isto me es jam tediose. Simplemente installa le wiki.',
	'config-profile' => 'Profilo de derectos de usator:',
	'config-profile-wiki' => 'Wiki traditional',
	'config-profile-no-anon' => 'Creation de conto obligatori',
	'config-profile-fishbowl' => 'Modificatores autorisate solmente',
	'config-profile-private' => 'Wiki private',
	'config-profile-help' => "Le wikis functiona melio si tu permitte a tante personas como possibile de modificar los.
In MediaWiki, il es facile revider le modificationes recente, e reverter omne damno facite per usatores naive o malitiose.

Nonobstante, multes ha trovate MediaWiki utile in un grande varietate de rolos, e alcun vices il non es facile convincer omnes del beneficios del principio wiki.
Dunque, a te le option.

Un '''{{int:config-profile-wiki}}''' permitte a omnes de modificar, sin mesmo aperir un session.
Un wiki con '''{{int:config-profile-no-anon}}''' attribue additional responsabilitate, ma pote dissuader contributores occasional.

Le scenario '''{{int:config-profile-fishbowl}}''' permitte al usatores approbate de modificar, ma le publico pote vider le paginas, includente lor historia.
Un '''{{int:config-profile-private}}''' permitte solmente al usatores approbate de vider le paginas e de modificar los.

Configurationes de derectos de usator plus complexe es disponibile post installation, vide le [//www.mediawiki.org/wiki/Manual:User_rights pertinente section del manual].",
	'config-license' => 'Copyright e licentia:',
	'config-license-none' => 'Nulle licentia in pede de paginas',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0' => 'Creative Commons Zero (dominio public)',
	'config-license-gfdl' => 'Licentia GNU pro Documentation Libere 1.3 o plus recente',
	'config-license-pd' => 'Dominio public',
	'config-license-cc-choose' => 'Seliger un licentia Creative Commons personalisate',
	'config-license-help' => "Multe wikis public pone tote le contributiones sub un [http://freedomdefined.org/Definition/Ia?uselang=ia licentia libere].
Isto adjuta a crear un senso de proprietate communitari e incoragia le contribution in longe termino.
Isto non es generalmente necessari pro un wiki private o de interprisa.

Si tu vole poter usar texto de Wikipedia, e si tu vole que Wikipedia pote acceptar texto copiate de tu wiki, tu debe seliger '''Creative Commons Attribution Share Alike'''.

Wikipedia usava anteriormente le Licentia GNU pro Documentation Libere (GFDL).
Iste es un licentia valide, ma es difficile a comprender.
Il es anque difficile reusar le contento licentiate sub GFDL.",
	'config-email-settings' => 'Configuration de e-mail',
	'config-enable-email' => 'Activar le e-mail sortiente',
	'config-enable-email-help' => 'Si tu vole que e-mail functiona, [http://www.php.net/manual/en/mail.configuration.php le optiones de e-mail de PHP] debe esser configurate correctemente.
Si tu non vole functiones de e-mail, tu pote disactivar los hic.',
	'config-email-user' => 'Activar le e-mail de usator a usator',
	'config-email-user-help' => 'Permitter a tote le usatores de inviar e-mail inter se, si illes lo ha activate in lor preferentias.',
	'config-email-usertalk' => 'Activar notification de cambios in paginas de discussion de usatores',
	'config-email-usertalk-help' => 'Permitter al usatores de reciper notification de modificationes in lor paginas de discussion personal, si illes lo ha activate in lor preferentias.',
	'config-email-watchlist' => 'Activar notification de observatorio',
	'config-email-watchlist-help' => 'Permitter al usatores de reciper notification super lor paginas sub observation, si illes lo ha activate in lor preferentias.',
	'config-email-auth' => 'Activar authentication de e-mail',
	'config-email-auth-help' => "Si iste option es activate, le usatores debe confirmar lor adresse de e-mail usante un ligamine inviate a illes, quandocunque illes lo defini o cambia.
Solmente le adresses de e-mail authenticate pote reciper e-mail de altere usatores o alterar le e-mails de notification.
Es '''recommendate''' activar iste option pro wikis public a causa de abuso potential del functionalitate de e-mail.",
	'config-email-sender' => 'Adresse de e-mail de retorno:',
	'config-email-sender-help' => 'Entra le adresse de e-mail a usar como adresse de retorno in e-mail sortiente.
Hic es recipite le notificationes de non-livration.
Multe servitores de e-mail require que al minus le parte de nomine de dominio sia valide.',
	'config-upload-settings' => 'Incargamento de imagines e files',
	'config-upload-enable' => 'Activar le incargamento de files',
	'config-upload-help' => 'Le incargamento de files potentialmente expone tu servitor a riscos de securitate.
Pro plus information, lege le [//www.mediawiki.org/wiki/Manual:Security section de securitate] in le manual.

Pro activar le incargamento de files, cambia le modo in le subdirectorio <code>images</code> sub le directorio-radice de MediaWiki de sorta que le servitor web pote scriber in illo.
Postea activa iste option.',
	'config-upload-deleted' => 'Directorio pro files delite:',
	'config-upload-deleted-help' => 'Selige un directorio in le qual archivar le files delite.
Idealmente, isto non debe esser accessibile ab le web.',
	'config-logo' => 'URL del logotypo:',
	'config-logo-help' => 'Le apparentia predefinite de MediaWiki include spatio pro un logotypo de 135×160 pixels supra le menu del barra lateral.
Incarga un imagine con le dimensiones appropriate, e entra le URL hic.

Si tu non vole un logotypo, lassa iste quadro vacue.',
	'config-instantcommons' => 'Activar "Instant Commons"',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] es un function que permitte a wikis de usar imagines, sonos e altere multimedia trovate in le sito [//commons.wikimedia.org/ Wikimedia Commons].
Pro poter facer isto, MediaWiki require accesso a Internet.

Pro plus information super iste function, includente instructiones super como configurar lo pro wikis altere que Wikimedia Commons, consulta [//mediawiki.org/wiki/Manual:$wgForeignFileRepos le manual].',
	'config-cc-error' => 'Le selector de licentia Creative Commons non dava un resultato.
Entra le nomine del licentia manualmente.',
	'config-cc-again' => 'Selige de novo…',
	'config-cc-not-chosen' => 'Selige le licentia Creative Commons que tu prefere e clicca "proceder".',
	'config-advanced-settings' => 'Configuration avantiate',
	'config-cache-options' => 'Configuration del cache de objectos:',
	'config-cache-help' => 'Le cache de objectos es usate pro meliorar le rapiditate de MediaWiki per immagazinar le datos frequentemente usate.
Le sitos medie o grande es multo incoragiate de activar isto, ma anque le sitos parve percipera le beneficios.',
	'config-cache-none' => 'Nulle cache (nulle functionalitate es removite, ma le rapiditate pote diminuer in grande sitos wiki)',
	'config-cache-accel' => 'Cache de objectos de PHP (APC, XCache o WinCache)',
	'config-cache-memcached' => 'Usar Memcached (require additional installation e configuration)',
	'config-memcached-servers' => 'Servitores Memcached:',
	'config-memcached-help' => 'Lista de adresses IP a usar pro Memcached.
Debe specificar un per linea e specificar le porto a usar. Per exemplo:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Tu seligeva Memcached como typo de cache ma non specificava alcun servitores',
	'config-memcache-badip' => 'Tu ha entrate un adresse IP invalide pro Memcached: $1',
	'config-memcache-noport' => 'Tu non specificava un porto a usar pro le servitor Memcached: $1.
Si tu non cognosce le porto, le standard es 11211',
	'config-memcache-badport' => 'Le numeros de porto de Memcached debe esser inter $1 e $2',
	'config-extensions' => 'Extensiones',
	'config-extensions-help' => 'Le extensiones listate hic supra esseva detegite in tu directorio <code>./extensions</code>.

Istes pote requirer additional configuration, ma tu pote activar los ora.',
	'config-install-alreadydone' => "'''Aviso:''' Il pare que tu ha jam installate MediaWiki e tenta installar lo de novo.
Per favor continua al proxime pagina.",
	'config-install-begin' => 'Un clic sur "{{int:config-continue}}" comencia le installation de MediaWiki.
Pro facer alterationes, clicca sur "Retro".',
	'config-install-step-done' => 'finite',
	'config-install-step-failed' => 'fallite',
	'config-install-extensions' => 'Include le extensiones',
	'config-install-database' => 'Configura le base de datos',
	'config-install-schema' => 'Creation de schema',
	'config-install-pg-schema-not-exist' => 'Iste schema de PostgreSQL non existe',
	'config-install-pg-schema-failed' => 'Le creation del tabellas falleva.
Assecura te que le usator "$1" pote scriber in le schema "$2".',
	'config-install-pg-commit' => 'Committer cambiamentos',
	'config-install-pg-plpgsql' => 'Verifica le presentia del linguage PL/pgSQL',
	'config-pg-no-plpgsql' => 'Es necessari installar le linguage PL/pgSQL in le base de datos $1',
	'config-pg-no-create-privs' => 'Le conto que tu specificava pro installation non ha sufficiente privilegios pro crear un conto.',
	'config-pg-not-in-role' => 'Le conto que tu specificava pro le usator web ja existe.
Le conto que tu specificava pro installation non es superusator e non es membro del rolo de usator web, dunque es incapace de crear objectos possedite per le usator web.

MediaWiki require actualmente que le tabellas sia possedite per le usator web. Per favor specifica un altere nomine de conto web, o clicca super "retornar" e specifica un usator de installation con sufficiente privilegios.',
	'config-install-user' => 'Crea usator pro base de datos',
	'config-install-user-alreadyexists' => 'Le usator "$1" ja existe',
	'config-install-user-create-failed' => 'Le creation del usator "$1" ha fallite: $2',
	'config-install-user-grant-failed' => 'Le concession de permission al usator "$1" falleva: $2',
	'config-install-user-missing' => 'Le usator specificate, "$1", non existe.',
	'config-install-user-missing-create' => 'Le usator specificate, "$1", non existe.
Per favor marca le quadrato "crear conto" hic infra si tu vole crear lo.',
	'config-install-tables' => 'Crea tabellas',
	'config-install-tables-exist' => "'''Aviso''': Il pare que le tabellas de MediaWiki jam existe.
Le creation es saltate.",
	'config-install-tables-failed' => "'''Error''': Le creation del tabellas falleva con le sequente error: $1",
	'config-install-interwiki' => 'Plena le tabella interwiki predefinite',
	'config-install-interwiki-list' => 'Non poteva trovar le file <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Aviso''': Le tabella interwiki pare jam haber entratas.
Le lista predefinite es saltate.",
	'config-install-stats' => 'Initialisation del statisticas',
	'config-install-keys' => 'Generation de claves secrete',
	'config-insecure-keys' => "'''Attention:''' {{PLURAL:$2|Un clave|Alcun claves}} secur ($1) generate durante le installation non es completemente secur. Considera cambiar {{PLURAL:$2|lo|los}} manualmente.",
	'config-install-sysop' => 'Crea conto de usator pro administrator',
	'config-install-subscribe-fail' => 'Impossibile subscriber a mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL non es installate e allow_url_fopen non es disponibile.',
	'config-install-mainpage' => 'Crea pagina principal con contento predefinite',
	'config-install-extension-tables' => 'Creation de tabellas pro le extensiones activate',
	'config-install-mainpage-failed' => 'Non poteva inserer le pagina principal: $1',
	'config-install-done' => "'''Felicitationes!'''
Tu ha installate MediaWiki con successo.

Le installator ha generate un file <code>LocalSettings.php</code>.
Iste contine tote le configuration.

Es necessari discargar lo e poner lo in le base del installation wiki (le mesme directorio que index.php).
Le discargamento debe haber comenciate automaticamente.

Si le discargamento non ha comenciate, o si illo esseva cancellate, es possibile recomenciar le discargamento con un clic sur le ligamine sequente:

$3

'''Nota''': Si tu non discarga iste file de configuration ora, illo non essera disponibile plus tarde.

Post facer isto, tu pote '''[$2 entrar in tu wiki]'''.",
	'config-download-localsettings' => 'Discargar LocalSettings.php',
	'config-help' => 'adjuta',
	'config-nofile' => 'Le file "$1" non poteva esser trovate. Ha illo essite delite?',
	'mainpagetext' => "'''MediaWiki ha essite installate con successo.'''",
	'mainpagedocfooter' => 'Consulta le [//meta.wikimedia.org/wiki/Help:Contents Guida del usator] pro informationes super le uso del software wiki.

== Pro initiar ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista de configurationes]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ a proposito de MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de diffusion pro annuncios de nove versiones de MediaWiki]',
);

/** Indonesian (Bahasa Indonesia)
 * @author Farras
 * @author IvanLanin
 * @author Kenrick95
 * @author Reedy
 */
$messages['id'] = array(
	'config-desc' => 'Penginstal untuk MediaWiki',
	'config-title' => 'Instalasi MediaWiki $1',
	'config-information' => 'Informasi',
	'config-localsettings-upgrade' => 'Berkas <code>LocalSettings.php</code> sudah ada.
Untuk memutakhirkan instalasi ini, masukkan nilai <code>$wgUpgradeKey</code> dalam kotak yang tersedia di bawah ini.
Anda dapat menemukan nilai tersebut dalam LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Berkas LocalSettings.php terdeteksi.
Untuk meningkatkan versi, harap jalankan update.php.',
	'config-localsettings-key' => 'Kunci pemutakhiran:',
	'config-localsettings-badkey' => 'Kunci yang Anda berikan tidak benar',
	'config-upgrade-key-missing' => 'Suatu instalasi MediaWiki telah terdeteksi.
Untuk memutakhirkan instalasi ini, silakan masukkan baris berikut di bagian bawah LocalSettings.php Anda:

$1',
	'config-localsettings-incomplete' => 'LocalSettings.php yang ada tampaknya tidak lengkap.
Variabel $1 tidak diatur.
Silakan ubah LocalSettings.php untuk mengatur variabel ini dan klik "Lanjutkan".',
	'config-localsettings-connection-error' => 'Timbul galat saat menghubungkan ke basis data dengan menggunakan setelan yang ditentukan di LocalSettings.php atau AdminSettings.php. Harap perbaiki setelan ini dan coba lagi.

$1',
	'config-session-error' => 'Kesalahan sesi mulai: $1',
	'config-session-expired' => 'Data sesi tampaknya telah kedaluwarsa.
Sesi dikonfigurasi untuk berlaku selama $1.
Anda dapat menaikkannya dengan menetapkan <code>session.gc_maxlifetime</code> dalam php.ini.
Ulangi proses instalasi.',
	'config-no-session' => 'Data sesi Anda hilang!
Cek php.ini Anda dan pastikan bahwa <code>session.save_path</code> diatur ke direktori yang sesuai.',
	'config-your-language' => 'Bahasa Anda:',
	'config-your-language-help' => 'Pilih bahasa yang akan digunakan selama proses instalasi.',
	'config-wiki-language' => 'Bahasa wiki:',
	'config-wiki-language-help' => 'Pilih bahasa yang akan digunakan tulisan-tulisan wiki.',
	'config-back' => '← Kembali',
	'config-continue' => 'Lanjut →',
	'config-page-language' => 'Bahasa',
	'config-page-welcome' => 'Selamat datang di MediaWiki',
	'config-page-dbconnect' => 'Hubungkan ke basis data',
	'config-page-upgrade' => 'Perbarui instalasi yang ada',
	'config-page-dbsettings' => 'Pengaturan basis data',
	'config-page-name' => 'Nama',
	'config-page-options' => 'Pilihan',
	'config-page-install' => 'Instal',
	'config-page-complete' => 'Selesai!',
	'config-page-restart' => 'Ulangi instalasi',
	'config-page-readme' => 'Baca saya',
	'config-page-releasenotes' => 'Catatan pelepasan',
	'config-page-copying' => 'Menyalin',
	'config-page-upgradedoc' => 'Memerbarui',
	'config-page-existingwiki' => 'Wiki yang ada',
	'config-help-restart' => 'Apakah Anda ingin menghapus semua data tersimpan yang telah Anda masukkan dan mengulang proses instalasi?',
	'config-restart' => 'Ya, nyalakan ulang',
	'config-welcome' => '=== Pengecekan lingkungan ===
Pengecekan dasar dilakukan untuk melihat apakah lingkungan ini memadai untuk instalasi MediaWiki.
Anda harus memberikan hasil pemeriksaan ini jika Anda memerlukan bantuan selama instalasi.',
	'config-copyright' => "=== Hak cipta dan persyaratan ===

\$1

Program ini adalah perangkat lunak bebas; Anda dapat mendistribusikan dan/atau memodifikasi di bawah persyaratan GNU General Public License seperti yang diterbitkan oleh Free Software Foundation; baik versi 2 lisensi, atau (sesuai pilihan Anda) versi yang lebih baru.

Program ini didistribusikan dengan harapan bahwa itu akan berguna, tetapi '''tanpa jaminan apa pun'''; bahkan tanpa jaminan tersirat untuk '''dapat diperjualbelikan ''' atau '''sesuai untuk tujuan tertentu'''.
Lihat GNU General Public License untuk lebih jelasnya.

Anda seharusnya telah menerima <doclink href=\"Copying\">salinan dari GNU General Public License</doclink> bersama dengan program ini; jika tidak, kirimkan surat untuk Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. atau [http://www.gnu.org/copyleft/gpl.html baca versi daring].",
	'config-sidebar' => '* [//www.mediawiki.org/wiki/MediaWiki/id Situs MediaWiki]
* [//www.mediawiki.org/wiki/Help:Contents/id Pedoman Pengguna]
* [//www.mediawiki.org/wiki/Manual:Contents/id Pedoman Administrator]
* [//www.mediawiki.org/wiki/Manual:FAQ/id FAQ]
----
* <doclink href=Readme>Read me</doclink>
* <doclink href=ReleaseNotes>Release notes</doclink>
* <doclink href=Copying>Copying</doclink>
* <doclink href=UpgradeDoc>Upgrading</doclink>',
	'config-env-good' => 'Kondisi telah diperiksa.
Anda dapat menginstal MediaWiki.',
	'config-env-bad' => 'Kondisi telah diperiksa.
Anda tidak dapat menginstal MediaWiki.',
	'config-env-php' => 'PHP $1 diinstal.',
	'config-env-php-toolow' => 'PHP $1 telah terinstal.
Namun, MediaWiki memerlukan PHP $2 atau lebih tinggi.',
	'config-unicode-using-utf8' => 'Menggunakan utf8_normalize.so Brion Vibber untuk normalisasi Unicode.',
	'config-unicode-using-intl' => 'Menggunakan [http://pecl.php.net/intl ekstensi PECL intl] untuk normalisasi Unicode.',
	'config-unicode-pure-php-warning' => "'''Peringatan''': [http://pecl.php.net/intl Ekstensi intl PECL] untuk menangani normalisasi Unicode tidak tersedia, kembali menggunakan implementasi murni PHP yang lambat.
Jika Anda menjalankan situs berlalu lintas tinggi, Anda harus sedikit membaca [//www.mediawiki.org/wiki/Unicode_normalization_considerations normalisasi Unicode].",
	'config-unicode-update-warning' => "'''Peringatan''': Versi terinstal dari pembungkus normalisasi Unicode menggunakan versi lama pustaka [http://site.icu-project.org/ proyek ICU].
Anda harus [//www.mediawiki.org/wiki/Unicode_normalization_considerations memutakhirkannya] jika Anda ingin menggunakan Unicode.",
	'config-no-db' => 'Pengandar basis data yang sesuai tidak ditemukan! Anda perlu menginstal pengandar basis data untuk PHP.
Jenis basis data yang didukung: $1.

Jika Anda menggunakan inang bersama, mintalah penyedia inang Anda untuk menginstal pengandar basis data yang sesuai.
Jika Anda mengompilasi sendiri PHP, ubahlah konfigurasinya dengan mengaktifkan klien basis data, misalnya menggunakan <code>./configure --with-mysql</code>.
Jika Anda menginstal PHP dari paket Debian atau Ubuntu, maka Anda juga perlu menginstal modul php5-mysql.',
	'config-no-fts3' => "'''Peringatan''': SQLite dikompilasi tanpa [//sqlite.org/fts3.html modul FTS3], fitur pencarian tidak akan tersedia pada konfigurasi ini.",
	'config-register-globals' => "'''Peringatan: Opsi <code>[http://php.net/register_globals register_globals]</code> PHP diaktifkan.'''
'''Nonaktifkan kalau bisa.'''
MediaWiki akan bekerja, tetapi server Anda memiliki potensi kerentanan keamanan.",
	'config-magic-quotes-runtime' => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] aktif!'''
Pilihan ini dapat merusak masukan data secara tidak terduga.
Anda tidak dapat menginstal atau menggunakan MediaWiki kecuali pilihan ini dinonaktifkan.",
	'config-magic-quotes-sybase' => "'''Fatal: [http://www.php.net/manual/en/ref.info.php#ini.magic_quotes_sybase magic_quotes_sybase] aktif!'''
Pilihan ini dapat merusak masukan data secara tidak terduga.
Anda tidak dapat menginstal atau menggunakan MediaWiki kecuali pilihan ini dinonaktifkan.",
	'config-mbstring' => "'''Fatal: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] aktif!'' '
Pilihan ini dapat menyebabkan kesalahan dan kerusakan data yang tidak terduga.
Anda tidak dapat menginstal atau menggunakan MediaWiki kecuali pilihan ini dinonaktifkan.",
	'config-ze1' => "'''Fatal: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] aktif!'''
Pilihan ini dapat menyebabkan bug yang mengerikan pada MediaWiki.
Anda tidak dapat menginstal atau menggunakan MediaWiki kecuali pilihan ini dinonaktifkan.",
	'config-safe-mode' => "''' Peringatan:''' [http://www.php.net/features.safe-mode Mode aman] PHP aktif.
Hal ini akan menyebabkan masalah, terutama jika menggunakan pengunggahan berkas dan dukungan <code>math</code>.",
	'config-xml-bad' => 'Modul XML PHP hilang.
MediaWiki membutuhkan fungsi dalam modul ini dan tidak akan bekerja dalam konfigurasi ini.
Jika Anda menggunakan Mandrake, instal paket php-xml.',
	'config-pcre' => 'Modul pendukung PCRE tampaknya hilang.
MediaWiki memerlukan fungsi persamaan reguler kompatibel Perl untuk bekerja.',
	'config-pcre-no-utf8' => "'''Fatal''': Modul PCRE PHP tampaknya dikompilasi tanpa dukungan PCRE_UTF8.
MediaWiki memerlukan dukungan UTF-8 untuk berfungsi dengan benar.",
	'config-memory-raised' => '<code>memory_limit</code> PHP adalah $1, dinaikkan ke $2.',
	'config-memory-bad' => "'''Peringatan:''' <code>memory_limit</code> PHP adalah $1.
Ini terlalu rendah.
Instalasi terancam gagal!",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] telah diinstal',
	'config-apc' => '[http://www.php.net/apc APC] telah diinstal',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] telah diinstal',
	'config-no-cache' => "'''Peringatan:''' Tidak dapat menemukan [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache], atau [http://www.iis.net/download/WinCacheForPhp WinCache]. Pinggahan obyek tidak dinonaktifkan.",
	'config-diff3-bad' => 'GNU diff3 tidak ditemukan.',
	'config-imagemagick' => 'ImageMagick ditemukan: <code>$1</code> .
Pembuatan gambar mini akan diaktifkan jika Anda mengaktifkan pengunggahan.',
	'config-gd' => 'Pustaka grafis GD terpasang ditemukan.
Pembuatan gambar mini akan diaktifkan jika Anda mengaktifkan pengunggahan.',
	'config-no-scaling' => 'Pustaka GD atau ImageMagick tidak ditemukan.
Pembuatan gambar mini dinonaktifkan.',
	'config-no-uri' => "'''Kesalahan:''' URI saat ini tidak dapat ditentukan.
Instalasi dibatalkan.",
	'config-uploads-not-safe' => "'''Peringatan:''' Direktori bawaan pengunggahan <code>$1</code> Anda rentan terhadap eksekusi skrip yang sewenang-wenang.
Meskipun MediaWiki memeriksa semua berkas unggahan untuk ancaman keamanan, sangat dianjurkan untuk [//www.mediawiki.org/wiki/Manual:Security#Upload_security menutup kerentanan keamanan ini] sebelum mengaktifkan pengunggahan.",
	'config-brokenlibxml' => 'Sistem Anda memiliki kombinasi versi PHP dan libxml2 yang memiliki bug dan dapat menyebabkan kerusakan data tersembunyi pada MediaWiki dan aplikasi web lain.
Mutakhirkan ke PHP 5.2.9 atau yang lebih baru dan libxml2 2.7.3 atau yang lebih baru ([//bugs.php.net/bug.php?id=45996 arsip bug di PHP]).
Instalasi dibatalkan.',
	'config-using531' => 'MediaWiki tidak dapat dijalankan dengan PHP $1 karena bug yang melibatkan parameter referensi untuk <code>__call()</code> .
Tingkatkan ke PHP 5.3.2 atau lebih baru, atau turunkan ke PHP versi 5.3.0 untuk menyelesaikan hal ini.
Instalasi dibatalkan.',
	'config-suhosin-max-value-length' => 'Suhosin terpasang dan membatasi panjang parameter GET sebesar $1 bita. Komponen ResourceLoader MediaWiki akan mengatasi batasan ini, tapi penanganannya akan menurunkan kinerja. Jika memungkinkan, Anda sebaiknya menetapkan nilai suhosin.get.max_value_length menjadi 1024 atau lebih tinggi dalam php.ini dan menyetel $wgResourceLoaderMaxQueryLength dengan nilai yang sama dalam LocalSettings.php.',
	'config-db-type' => 'Jenis basis data:',
	'config-db-host' => 'Inang basis data:',
	'config-db-host-help' => 'Jika server basis data Anda berada di server yang berbeda, masukkan nama inang atau alamat IP di sini.

Jika Anda menggunakan inang web bersama, penyedia inang Anda harus memberikan nama inang yang benar di dokumentasi mereka.

Jika Anda menginstal pada server Windows dan menggunakan MySQL, "localhost" mungkin tidak dapat digunakan sebagai nama server. Jika demikian, coba "127.0.0.1" untuk alamat IP lokal.', # Fuzzy
	'config-db-host-oracle' => 'TNS basis data:',
	'config-db-host-oracle-help' => 'Masukkan [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm Local Connect Name] yang sah; berkas tnsnames.ora harus dapat diakses oleh instalasi ini.<br />Jika Anda menggunakan pustaka klien 10g atau lebih baru, Anda juga dapat menggunakan metode penamaan [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identifikasi wiki ini',
	'config-db-name' => 'Nama basis data:',
	'config-db-name-help' => 'Pilih nama yang mengidentifikasikan wiki Anda.
Nama tersebut tidak boleh mengandung spasi.

Jika Anda menggunakan inang web bersama, penyedia inang Anda dapat memberikan Anda nama basis data khusus untuk digunakan atau mengizinkan Anda membuat basis data melalui panel kontrol.',
	'config-db-name-oracle' => 'Skema basis data:',
	'config-db-account-oracle-warn' => 'Ada tiga skenario yang didukung untuk instalasi Oracle sebagai basis data pendukung:

Jika Anda ingin membuat akun basis data sebagai bagian dari proses instalasi, silakan masukkan akun dengan peran SYSDBA sebagai akun basis data untuk instalasi dan tentukan kredensial yang diinginkan untuk akun akses web. Jika tidak, Anda dapat membuat akun akses web secara manual dan hanya memberikan akun tersebut (jika memiliki izin yang diperlukan untuk membuat objek skema) atau memasukkan dua akun yang berbeda, satu dengan hak membuat objek dan satu dibatasi untuk akses web.

Skrip untuk membuat akun dengan privilese yang diperlukan dapat ditemukan pada direktori "maintenance/oracle/" instalasi ini. Harap diingat bahwa penggunaan akun terbatas akan menonaktifkan semua kemampuan pemeliharaan dengan akun bawaan.',
	'config-db-install-account' => 'Akun pengguna untuk instalasi',
	'config-db-username' => 'Nama pengguna basis data:',
	'config-db-password' => 'Kata sandi basis data:',
	'config-db-password-empty' => 'Silakan masukkan sandi untuk pengguna basis data baru: $1.
Meskipun dimungkinkan untuk membuat pengguna tanpa sandi, hal itu tidak aman.',
	'config-db-install-username' => 'Masukkan nama pengguna yang akan digunakan untuk terhubung ke basis data selama proses instalasi.
Ini bukan nama pengguna akun MediaWiki, melainkan nama pengguna untuk basis data Anda.',
	'config-db-install-password' => 'Masukkan sandi yang akan digunakan untuk terhubung ke basis data selama proses instalasi.
Ini bukan sandi untuk akun MediaWiki, melainkan sandi untuk basis data Anda.',
	'config-db-install-help' => 'Masukkan nama pengguna dan sandi yang akan digunakan untuk terhubung ke basis data pada saat proses instalasi.',
	'config-db-account-lock' => 'Gunakan nama pengguna dan kata sandi yang sama selama operasi normal',
	'config-db-wiki-account' => 'Akun pengguna untuk operasi normal',
	'config-db-wiki-help' => 'Masukkan nama pengguna dan sandi yang akan digunakan untuk terhubung ke basis data wiki selama operasi normal.
Jika akun tidak ada, akun instalasi memiliki hak yang memadai, akun pengguna ini akan dibuat dengan hak akses minimum yang diperlukan untuk mengoperasikan wiki.',
	'config-db-prefix' => 'Prefiks tabel basis data:',
	'config-db-prefix-help' => 'Jika Anda perlu berbagi satu basis data di antara beberapa wiki, atau antara MediaWiki dan aplikasi web lain, Anda dapat memilih untuk menambahkan prefiks terhadap semua nama tabel demi menghindari konflik.
Jangan gunakan spasi.

Prefiks ini biasanya dibiarkan kosong.',
	'config-db-charset' => 'Set karakter basis data',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 biner',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'UTF-8 yang kompatibel balik dengan MySQL 4.0',
	'config-charset-help' => "'''Peringatan:''' Jika Anda menggunakan '''UTF-8 kompatibel balik''' pada MySQL 4.1+, dan kemudian mencadangkan basis data dengan <code>mysqldump</code>, proses itu mungkin menghancurkan semua karakter non-ASCII dan merusak cadangan Anda tanpa dapat dikembalikan!

Dalam '''modus biner''', MediaWiki menyimpan teks UTF-8 ke basis data dalam bidang biner.
Ini lebih efisien dibandingkan modus UTF-8 MySQL dan memungkinkan Anda untuk menggunakan berbagai karakter Unicode.
Dalam '''modus UTF-8''', MySQL akan tahu apa set karakter data anda dan dapat menyajikan dan mengubahnya denga tepat, namun tidak akan mengizinkan Anda menyimpan karakter di atas [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",
	'config-mysql-old' => 'MySQL $1 atau versi terbaru diperlukan, Anda menggunakan $2.',
	'config-db-port' => 'Porta basis data:',
	'config-db-schema' => 'Skema untuk MediaWiki',
	'config-db-schema-help' => 'Skema ini biasanya berjalan baik.
Ubah hanya jika Anda tahu Anda perlu mengubahnya.',
	'config-sqlite-dir' => 'Direktori data SQLite:',
	'config-sqlite-dir-help' => "SQLite menyimpan semua data dalam satu berkas.

Direktori yang Anda berikan harus dapat ditulisi oleh server web selama instalasi.

Direktori itu '''tidak''' boleh dapat diakses melalui web, inilah sebabnya kami tidak menempatkannya bersama dengan berkas PHP lain.

Penginstal akan membuat berkas <code>.htaccess</code> bersamaan dengan itu, tetapi jika gagal, orang dapat memperoleh akses ke basis data mentah Anda.
Itu termasuk data mentah pengguna (alamat surel, hash sandi) serta revisi yang dihapus dan data lainnya yang dibatasi pada wiki.

Pertimbangkan untuk menempatkan basis data di tempat lain, misalnya di <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Tablespace bawaan:',
	'config-oracle-temp-ts' => 'Tablespace sementara:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki mendukung sistem basis data berikut:

$1

Jika Anda tidak melihat sistem basis data yang Anda gunakan tercantum di bawah ini, ikuti petunjuk terkait di atas untuk mengaktifkan dukungan.',
	'config-support-mysql' => '* $1 adalah target utama MediaWiki dan memiliki dukungan terbaik ([http://www.php.net/manual/en/mysql.installation.php cara mengompilasi PHP dengan dukungan MySQL])',
	'config-support-postgres' => '* $1 adalah sistem basis data sumber terbuka populer sebagai alternatif untuk MySQL ([http://www.php.net/manual/en/pgsql.installation.php cara mengompilasi PHP dengan dukungan PostgreSQL]). Mungkin ada beberapa bug terbuka dan alternatif ini tidak direkomendasikan untuk dipakai dalam lingkungan produksi.',
	'config-support-sqlite' => '* $1 adalah sistem basis data yang ringan yang sangat baik dukungannya. ([http://www.php.net/manual/en/pdo.installation.php cara mengompilasi PHP dengan dukungan SQLite], menggunakan PDO)',
	'config-support-oracle' => '* $1 adalah basis data komersial untuka perusahaan. ([http://www.php.net/manual/en/oci8.installation.php cara mengompilasi PHP dengan dukungan OCI8])',
	'config-support-ibm_db2' => '* $1 adalah basis data-perusahaan komersial.',
	'config-header-mysql' => 'Pengaturan MySQL',
	'config-header-postgres' => 'Pengaturan PostgreSQL',
	'config-header-sqlite' => 'Pengaturan SQLite',
	'config-header-oracle' => 'Pengaturan Oracle',
	'config-header-ibm_db2' => 'Pengaturan IBM DB2',
	'config-invalid-db-type' => 'Jenis basis data tidak sah',
	'config-missing-db-name' => 'Anda harus memasukkan nilai untuk "Nama basis data"',
	'config-missing-db-host' => 'Anda harus memasukkan nilai untuk "Inang basis data"',
	'config-missing-db-server-oracle' => 'Anda harus memasukkan nilai untuk "TNS basis data"',
	'config-invalid-db-server-oracle' => 'TNS basis data "$1" tidak sah.
Gunakan hanya huruf ASCII (a-z, A-Z), angka (0-9), garis bawah (_), dan titik (.).',
	'config-invalid-db-name' => 'Nama basis data "$1" tidak sah.
Gunakan hanya huruf ASCII (a-z, A-Z), angka (0-9), garis bawah (_), dan tanda hubung (-).',
	'config-invalid-db-prefix' => 'Prefiks basis data "$1" tidak sah.
Gunakan hanya huruf ASCII (a-z, A-Z), angka (0-9), garis bawah (_), dan tanda hubung (-).',
	'config-connection-error' => '$1.

Periksa nama inang, pengguna, dan sandi di bawah ini dan coba lagi.',
	'config-invalid-schema' => 'Skema MediaWiki "$1" tidak sah.
Gunakan hanya huruf ASCII (a-z, A-Z), angka (0-9), dan garis bawah (_).',
	'config-db-sys-create-oracle' => 'Penginstal hanya mendukung penggunaan akun SYSDBA untuk membuat akun baru.',
	'config-db-sys-user-exists-oracle' => 'Akun pengguna "$1"sudah ada. SYSDBA hanya dapat digunakan untuk membuat akun baru!',
	'config-postgres-old' => 'PostgreSQL $1 atau versi terbaru diperlukan, Anda menggunakan $2.',
	'config-sqlite-name-help' => 'Pilih nama yang mengidentifikasi wiki Anda.
Jangan gunakan spasi atau tanda hubung.
Nama ini akan digunakan untuk nama berkas data SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Tidak dapat membuat direktori data <code><nowiki>$1</nowiki></code>, karena direktori induk <code><nowiki>$2</nowiki></code> tidak bisa ditulisi oleh server web.

Penginstal telah menentukan pengguna yang menjalankan server web Anda.
Buat direktori <code><nowiki>$3</nowiki></code> menjadi dapat ditulisi olehnya.
Pada sistem Unix/Linux lakukan hal berikut:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Tidak dapat membuat direktori data <code><nowiki>$1</nowiki></code>, karena direktori induk <code><nowiki>$2</nowiki></code> tidak bisa ditulisi oleh server web.

Penginstal tidak dapat menentukan pengguna yang menjalankan server web Anda.
Buat direktori <code><nowiki>$3</nowiki></code> menjadi dapat ditulisi oleh semua orang.
Pada sistem Unix/Linux lakukan hal berikut:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Kesalahan saat membuat direktori data "$1".
Periksa lokasi dan coba lagi.',
	'config-sqlite-dir-unwritable' => 'Tidak dapat menulisi direktori "$1".
Ubah hak akses direktori sehingga server web dapat menulis ke sana, dan coba lagi.',
	'config-sqlite-connection-error' => '$1.

Periksa direktori data dan nama basis data di bawah dan coba lagi.',
	'config-sqlite-readonly' => 'Berkas <code>$1</code> tidak dapat ditulisi.',
	'config-sqlite-cant-create-db' => 'Tidak dapat membuat berkas basis data <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP tidak memiliki dukungan FTS3, tabel dituruntarafkan.',
	'config-can-upgrade' => "Ada tabel MediaWiki di basis dataini.
Untuk memperbaruinya ke MediaWiki $1, klik '''Lanjut'''.",
	'config-upgrade-done' => "Pemutakhiran selesai.

Anda sekarang dapat [$1 mulai menggunakan wiki Anda].

Jika Anda ingin membuat ulang berkas <code>LocalSettings.php</code>, klik tombol di bawah ini.
Tindakan ini '''tidak dianjurkan''' kecuali jika Anda mengalami masalah dengan wiki Anda.",
	'config-upgrade-done-no-regenerate' => 'Pemutakhiran selesai.

Anda sekarang dapat [$1 mulai menggunakan wiki Anda].',
	'config-regenerate' => 'Regenerasi LocalSettings.php →',
	'config-show-table-status' => 'Kueri SHOW TABLE STATUS gagal!',
	'config-unknown-collation' => "'''Peringatan:''' basis data menggunakan kolasi yang tidak dikenal.",
	'config-db-web-account' => 'Akun basis data untuk akses web',
	'config-db-web-help' => 'Masukkan nama pengguna dan sandi yang akan digunakan server web untuk terhubung ke server basis data saat operasi normal wiki.',
	'config-db-web-account-same' => 'Gunakan akun yang sama seperti untuk instalasi',
	'config-db-web-create' => 'Buat akun jika belum ada',
	'config-db-web-no-create-privs' => 'Akun Anda berikan untuk instalasi tidak memiliki hak yang cukup untuk membuat akun.
Akun yang Anda berikan harus sudah ada.',
	'config-mysql-engine' => 'Mesin penyimpanan:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-engine-help' => "'''InnoDB''' hampir selalu merupakan pilihan terbaik karena memiliki dukungan konkurensi yang baik.

'''MyISAM''' mungkin lebih cepat dalam instalasi pengguna-tunggal atau hanya-baca.
Basis data MyISAM cenderung lebih sering rusak daripada basis data InnoDB.",
	'config-mysql-charset' => 'Set karakter basis data:',
	'config-mysql-binary' => 'Biner',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "Dalam '''modus biner''', MediaWiki menyimpan teks UTF-8 untuk basis data dalam bidang biner.
Ini lebih efisien daripada modus UTF-8 MySQL dan memungkinkan Anda untuk menggunakan ragam penuh karakter Unicode.

Dalam '''modus UTF-8''', MySQL akan tahu apa set karakter data dan dapat menampilkan dan mengubahnya sesuai keperluan, tetapi tidak akan mengizinkan Anda menyimpan karakter di atas [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Basic Multilingual Plane].",
	'config-ibm_db2-low-db-pagesize' => "Basis data DB2 Anda tidak memiliki pagesize yang cukup untuk tablespace bawaan. Pagesize harus sama atau lebih dari '''32K'''.",
	'config-site-name' => 'Nama wiki:',
	'config-site-name-help' => 'Ini akan muncul di bilah judul peramban dan di berbagai tempat lainnya.',
	'config-site-name-blank' => 'Masukkan nama situs.',
	'config-project-namespace' => 'Ruang nama proyek:',
	'config-ns-generic' => 'Proyek',
	'config-ns-site-name' => 'Sama seperti nama wiki: $1',
	'config-ns-other' => 'Lainnya (sebutkan)',
	'config-ns-other-default' => 'MyWiki',
	'config-project-namespace-help' => 'Mengikuti contoh Wikipedia, banyak wiki menyimpan halaman kebijakan mereka terpisah dari halaman konten mereka, dalam "\'\'\'ruang nama proyek\'\'\'".
Semua judul halaman dalam ruang nama ini diawali dengan prefiks tertentu yang dapat Anda tetapkan di sini.
Biasanya, prefiks ini berasal dari nama wiki, tetapi tidak dapat berisi karakter tanda baca seperti "#" atau ":".',
	'config-ns-invalid' => 'Ruang nama "<nowiki>$1</nowiki>" yang ditentukan tidak sah.
Berikan ruang nama proyek lain.',
	'config-ns-conflict' => 'Ruang nama "<nowiki>$1</nowiki>" yang diberikan berkonflik dengan ruang nama bawaan MediaWiki.
Tentukan ruang nama proyek yang berbeda.',
	'config-admin-box' => 'Akun pengurus',
	'config-admin-name' => 'Nama Anda:',
	'config-admin-password' => 'Kata sandi:',
	'config-admin-password-confirm' => 'Kata sandi lagi:',
	'config-admin-help' => 'Masukkan nama pengguna pilihan Anda di sini, misalnya "Udin Wiki".
Ini adalah nama yang akan Anda gunakan untuk masuk ke wiki.',
	'config-admin-name-blank' => 'Masukkan nama pengguna pengurus.',
	'config-admin-name-invalid' => 'Nama pengguna "<nowiki>$1</nowiki>" yang diberikan tidak sah.
Berikan nama pengguna lain.',
	'config-admin-password-blank' => 'Masukkan kata sandi untuk akun pengurus.',
	'config-admin-password-same' => 'Kata sandi harus tidak sama seperti nama pengguna.',
	'config-admin-password-mismatch' => 'Dua kata sandi yang Anda masukkan tidak cocok.',
	'config-admin-email' => 'Alamat surel:',
	'config-admin-email-help' => 'Masukkan alamat surel untuk memungkinkan Anda menerima surel dari pengguna lain, menyetel ulang sandi, dan mendapat pemberitahuan tentang perubahan atas daftar pantauan Anda. Anda dapat mengosongkan bidang ini.',
	'config-admin-error-user' => 'Kesalahan internal saat membuat admin dengan nama "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Kesalahan internal saat membuat sandi untuk admin "<nowiki>$1</nowiki>":<pre>$2</pre>',
	'config-admin-error-bademail' => 'Anda memasukkan alamat surel yang tidak sah',
	'config-subscribe' => 'Berlangganan ke [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce milis pengumuman rilis].',
	'config-subscribe-help' => 'Ini adalah milis bervolume rendah yang digunakan untuk pengumuman rilis, termasuk pengumuman keamanan penting.
Anda sebaiknya berlangganan dan memperbarui instalasi MediaWiki saat versi baru keluar.',
	'config-almost-done' => 'Anda hampir selesai!
Anda sekarang dapat melewati sisa konfigurasi dan menginstal wiki sekarang.',
	'config-optional-continue' => 'Berikan saya pertanyaan lagi.',
	'config-optional-skip' => 'Saya sudah bosan, instal saja wikinya.',
	'config-profile' => 'Profil hak pengguna:',
	'config-profile-wiki' => 'Wiki tradisional',
	'config-profile-no-anon' => 'Pembuatan akun diperlukan',
	'config-profile-fishbowl' => 'Khusus penyunting terdaftar',
	'config-profile-private' => 'Wiki pribadi',
	'config-profile-help' => "Wiki paling baik bekerja jika Anda membiarkan sebanyak mungkin orang untuk menyunting. Dengan MediaWiki, sangat mudah meninjau perubahan terbaru dan mengembalikan kerusakan yang dilakukan oleh pengguna naif atau berbahaya.

Namun, berbagai kegunaan lain dari MediaWiki telah ditemukan, dan kadang tidak mudah untuk meyakinkan semua orang manfaat dari cara wiki. Jadi, Anda yang menentukan.

'''{{int:config-profile-wiki}}''' memungkinkan setiap orang untuk menyunting, bahkan tanpa masuk.
'''{{int:config-profile-no-anon}}''' menyediakan akuntabilitas tambahan, tetapi dapat mencegah kontributor biasa.

'''{{int:config-profile-fishbowl}}''' memungkinkan pengguna yang disetujui untuk menyunting, tetapi publik dapat melihat halaman, termasuk riwayatnya.
'''{{int:config-profile-private}}''' hanya memungkinkan pengguna yang disetujui untuk melihat dan menyunting halaman.

Konfigurasi hak pengguna yang lebih kompleks tersedia setelah instalasi. Lihat [//www.mediawiki.org/wiki/Manual:User_rights/id entri manual terkait].",
	'config-license' => 'Hak cipta dan lisensi:',
	'config-license-none' => 'Tidak ada lisensi',
	'config-license-cc-by-sa' => 'Creative Commons Atribusi Berbagi Serupa',
	'config-license-cc-by' => 'Creative Commons Atribusi',
	'config-license-cc-by-nc-sa' => 'Creative Commons Atribusi Nonkomersial Berbagi Serupa',
	'config-license-cc-0' => 'Creative Commons Zero (Domain Publik)',
	'config-license-gfdl' => 'Lisensi Dokumentasi Bebas GNU 1.3 atau versi terbaru',
	'config-license-pd' => 'Domain Umum',
	'config-license-cc-choose' => 'Pilih lisensi Creative Commons kustom',
	'config-license-help' => "Banyak wiki publik melisensikan semua kontribusi di bawah [http://freedomdefined.org/Definition lisensi bebas].
Hal ini membantu menciptakan rasa kepemilikan komunitas dan mendorong kontribusi jangka panjang.
Hal ini umumnya tidak diperlukan untuk wiki pribadi atau perusahaan.

Jika Anda ingin dapat menggunakan teks dari Wikipedia dan Anda ingin agar Wikipedia dapat menerima teks yang disalin dari wiki Anda, Anda harus memilih'''Creative Commons Attribution Share Alike'''.

Wikipedia sebelumnya menggunakan GNU Free Documentation License.
Lisensi ini masih sah, namun sulit dipahami.
Selain itu, sulit untuk menggunakan ulang konten yang dilisensikan di bawah GFDL.",
	'config-email-settings' => 'Pengaturan surel',
	'config-enable-email' => 'Aktifkan surel keluar',
	'config-enable-email-help' => 'Jika Anda ingin mengaktifkan surel, [http://www.php.net/manual/en/mail.configuration.php setelah surel PHP] perlu dikonfigurasi dengan benar.
Jika Anda tidak perlu fitur surel, Anda dapat menonaktifkannya di sini.',
	'config-email-user' => 'Aktifkan surel antarpengguna',
	'config-email-user-help' => 'Memungkinkan semua pengguna untuk saling berkirim surel jika mereka mengaktifkan pilihan tersebut dalam preferensi mereka.',
	'config-email-usertalk' => 'Aktifkan pemberitahuan perubahan halaman pembicaraan pengguna',
	'config-email-usertalk-help' => 'Memungkinkan pengguna untuk menerima pemberitahuan tentang perubahan halaman pembicaraan pengguna, jika pilihan tersebut telah diaktifkan dalam preferensi mereka.',
	'config-email-watchlist' => 'Aktifkan pemberitahuan daftar pantau',
	'config-email-watchlist-help' => 'Memungkinkan pengguna untuk menerima pemberitahuan tentang perubahan halaman yang ada dalam daftar pantauan mereka, jika pilihan tersebut telah diaktifkan dalam preferensi mereka.',
	'config-email-auth' => 'Aktifkan otentikasi surel',
	'config-email-auth-help' => "Jika opsi ini diaktifkan, pengguna harus mengonfirmasi alamat surel dengan menggunakan pranala yang dikirim kepadanya setiap kali mereka mengatur atau mengubahnya.
Hanya alamat surel yang dikonfirmasi yang dapat menerima surel dari pengguna lain atau surel pemberitahuan perubahan.
Penetapan opsi ini '''direkomendasikan''' untuk wiki publik karena adanya potensi penyalahgunaan fitur surel.",
	'config-email-sender' => 'Alamat surel balasan:',
	'config-email-sender-help' => 'Masukkan alamat surel untuk digunakan sebagai alamat pengirim pada surel keluar.
Alamat ini akan menerima pentalan.
Banyak server surel mensyaratkan paling tidak bagian nama domain yang sah.',
	'config-upload-settings' => 'Pengunggahan gambar dan berkas',
	'config-upload-enable' => 'Aktifkan pengunggahan berkas',
	'config-upload-help' => 'Pengunggahan berkas berpotensi memaparkan server Anda dengan risiko keamanan.
Untuk informasi lebih lanjut, baca [//www.mediawiki.org/wiki/Manual:Security/id manual keamanan].

Untuk mengaktifkan pengunggahan berkas, ubah modus subdirektori <code>images</code> di bawah direktori akar MediaWiki agar server web dapat menulis ke sana.
Kemudian aktifkan opsi ini.',
	'config-upload-deleted' => 'Direktori untuk berkas terhapus:',
	'config-upload-deleted-help' => 'Pilih direktori tempat mengarsipkan berkas yang dihapus.
Idealnya, direktori ini tidak boleh dapat diakses dari web.',
	'config-logo' => 'URL logo:',
	'config-logo-help' => 'Kulit bawaan MediaWiki memberikan ruang untuk logo berukuran 135x160 piksel di atas menu bilah samping.
Unggah gambar dengan ukuran yang sesuai, lalu masukkan URL di sini.

Jika Anda tidak ingin menyertakan logo, biarkan kotak ini kosong.',
	'config-instantcommons' => 'Aktifkan Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] adalah fitur yang memungkinkan wiki untuk menggunakan gambar, suara, dan media lain dari [//commons.wikimedia.org/ Wikimedia Commons].
Untuk melakukannya, MediaWiki memerlukan akses ke Internet.

Untuk informasi lebih lanjut tentang fitur ini, termasuk petunjuk tentang cara untuk mengatur untuk wiki selain Wikimedia Commons, baca [//mediawiki.org/wiki/Manual:$wgForeignFileRepos manual].',
	'config-cc-error' => 'Pemilih lisensi Creative Commons tidak memberikan hasil.
Masukkan nama lisensi secara manual.',
	'config-cc-again' => 'Pilih lagi...',
	'config-cc-not-chosen' => 'Pilih lisensi Creative Commons yang Anda inginkan dan klik "lanjutkan".',
	'config-advanced-settings' => 'Konfigurasi lebih lanjut',
	'config-cache-options' => 'Pengaturan untuk penyinggahan objek:',
	'config-cache-help' => 'Penyinggahan objek digunakan untuk meningkatkan kecepatan MediaWiki dengan menyinggahkan data yang sering digunakan.
Situs berukuran sedang hingga besar sangat dianjurkan untuk mengaktifkan fitur ini, dan situs kecil juga akan merasakan manfaatnya.',
	'config-cache-none' => 'Tidak ada penyinggahan (tidak ada fungsi yang dibuang, tetapi kecepatan dapat terpengaruh pada situs wiki yang besar)',
	'config-cache-accel' => 'Penyinggahan objek PHP (APC, XCache atau WinCache)',
	'config-cache-memcached' => 'Gunakan Memcached (memerlukan setup dan konfigurasi tambahan)',
	'config-memcached-servers' => 'Server Memcached:',
	'config-memcached-help' => 'Daftar alamat IP yang digunakan untuk Memcached.
Harus dispesifikasikan per baris berikut porta yang akan digunakan. Contoh:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Anda memilih Memcached sebagai jenis singgahan, tetapi tidak menentukan server apa pun.',
	'config-memcache-badip' => 'Anda memasukkan alamat IP yang tidak sah untuk Memcached: $1 .',
	'config-memcache-noport' => 'Anda tidak menentukan suatu porta untuk digunakan oleh server Memcached: $1.
Jika Anda tidak tahu porta tersebut, porta bawaan adalah 11211.',
	'config-memcache-badport' => 'Nomor porta Memcached harus antara $1 dan $2.',
	'config-extensions' => 'Ekstensi',
	'config-extensions-help' => 'Ekstensi yang tercantum di atas terdeteksi di direktori <code>./extensions</code>.

Ekstensi tersebut mungkin memerlukan konfigurasi tambahan, tetapi Anda dapat mengaktifkannya sekarang.',
	'config-install-alreadydone' => "'''Peringatan:''' Anda tampaknya telah menginstal MediaWiki dan mencoba untuk menginstalnya lagi.
Lanjutkan ke halaman berikutnya.",
	'config-install-begin' => 'Dengan menekan "{{int:config-continue}}", Anda akan memulai instalasi MediaWiki.
Jika Anda masih ingin membuat perubahan, tekan "{{int:config-back}}".',
	'config-install-step-done' => 'selesai',
	'config-install-step-failed' => 'gagal',
	'config-install-extensions' => 'Termasuk ekstensi',
	'config-install-database' => 'Menyiapkan basis data',
	'config-install-pg-schema-not-exist' => 'Skema PostgreSQL tidak tersedia.',
	'config-install-pg-schema-failed' => 'Pembuatan tabel gagal.
Pastikan bahwa pengguna "$1" dapat menulis ke skema "$2".',
	'config-install-pg-commit' => 'Melakukan perubahan',
	'config-install-pg-plpgsql' => 'Memeriksa bahasa PL / pgSQL',
	'config-pg-no-plpgsql' => 'Anda perlu menginstal bahasa PL/pgSQL pada basis data $1',
	'config-pg-no-create-privs' => 'Akun yang Anda tetapkan untuk instalasi tidak memiliki hak yang cukup untuk membuat akun.',
	'config-install-user' => 'Membuat pengguna basis data',
	'config-install-user-alreadyexists' => 'Pengguna "$1" sudah ada',
	'config-install-user-create-failed' => 'Pembuatan pengguna "$1" gagal: $2',
	'config-install-user-grant-failed' => 'Memberikan izin untuk pengguna "$1" gagal: $2',
	'config-install-tables' => 'Membuat tabel',
	'config-install-tables-exist' => "'''Peringatan''': Tabel MediaWiki sepertinya sudah ada.
Melompati pembuatan.",
	'config-install-tables-failed' => "'''Kesalahan''': Pembuatan tabel gagal dengan kesalahan berikut: $1",
	'config-install-interwiki' => 'Mengisi tabel bawaan antarwiki',
	'config-install-interwiki-list' => 'Tidak dapat menemukan berkas <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Peringatan''': Tabel antarwiki tampaknya sudah memiliki entri.
Mengabaikan daftar bawaan.",
	'config-install-stats' => 'Inisialisasi statistik',
	'config-install-keys' => 'Membuat kunci rahasia',
	'config-insecure-keys' => "'''Peringatan:''' {{PLURAL:$2|Suatu|Beberapa}} kunci aman ($1) yang dibuat selama instalasi {{PLURAL:$2|tidak|tidak}} benar-benar aman. Pertimbangkan untuk mengubah {{PLURAL:$2|kunci|kunci-kunci}} tersebut secara manual.",
	'config-install-sysop' => 'Membuat akun pengguna pengurus',
	'config-install-subscribe-fail' => 'Tidak dapat berlangganan mediawiki-announce', # Fuzzy
	'config-install-mainpage' => 'Membuat halaman utama dengan konten bawaan',
	'config-install-extension-tables' => 'Pembuatan tabel untuk ekstensi yang diaktifkan',
	'config-install-mainpage-failed' => 'Tidak dapat membuat halaman utama: $1',
	'config-install-done' => "'''Selamat!'''
Anda telah berhasil menginstal MediaWiki.

Penginstal telah membuat berkas <code>LocalSettings.php</code>.
Berkas itu berisi semua konfigurasi Anda.

Anda perlu mengunduh berkas itu dan meletakkannya di direktori instalasi wiki (direktori yang sama dengan index.php). Pengunduhan akan dimulai secara otomatis.

Jika pengunduhan tidak terjadi, atau jika Anda membatalkannya, Anda dapat mengulangi pengunduhan dengan mengeklik tautan berikut:

$3

'''Catatan''': Jika Anda tidak melakukannya sekarang, berkas konfigurasi yang dihasilkan ini tidak akan tersedia lagi setelah Anda keluar dari proses instalasi tanpa mengunduhnya.

Setelah melakukannya, Anda dapat '''[$2 memasuki wiki Anda]'''.",
	'config-download-localsettings' => 'Unduh LocalSettings.php',
	'config-help' => 'bantuan',
	'mainpagetext' => "'''MediaWiki telah terpasang dengan sukses'''.",
	'mainpagedocfooter' => 'Silakan baca [//www.mediawiki.org/wiki/Help:Contents/id Panduan Pengguna] untuk cara penggunaan perangkat lunak wiki ini.

== Memulai penggunaan ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings/id Daftar pengaturan konfigurasi]
* [//www.mediawiki.org/wiki/Manual:FAQ/id Daftar pertanyaan yang sering diajukan mengenai MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Milis rilis MediaWiki]',
);

/** Interlingue (Interlingue)
 */
$messages['ie'] = array(
	'mainpagetext' => "'''Software del wiki installat con successe.'''",
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'config-admin-password' => 'Okwúngáfè:',
	'config-admin-password-confirm' => 'Okwúngáfè mgbe ozor:',
	'mainpagetext' => "'''MediaWiki a banyélé nke oma.'''",
	'mainpagedocfooter' => "Gbàkpó [//meta.wikimedia.org/wiki/Help:Contents Ǹdù Ọ'bànifé] màkà ụmá màkà Í jí ngwa nsónùsòrò bu wiki.

== I bídó ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Ndétu ndósé ihe]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce wéfù ndétu nke ozi MediaWiki]",
);

/** Iloko (Ilokano)
 */
$messages['ilo'] = array(
	'mainpagetext' => "'''Sibaballigi a nainstolar ti MediaWiki.'''",
);

/** Ido (Ido)
 * @author Wyvernoid
 */
$messages['io'] = array(
	'mainpagetext' => "'''MediaWiki instalesis sucese.'''",
	'mainpagedocfooter' => "Videz la [//meta.wikimedia.org/wiki/Help:Contents Guidilo por Uzanti] por informo pri uzar la wiki programo.

== Komencar ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listo di ''Configuration setting'']
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki OQQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki nova versioni posto-listo]",
);

/** Icelandic (íslenska)
 */
$messages['is'] = array(
	'mainpagetext' => "'''Uppsetning á MediaWiki heppnaðist.'''",
	'mainpagedocfooter' => 'Ráðfærðu þig við [//meta.wikimedia.org/wiki/Help:Contents Notandahandbókina] fyrir frekari upplýsingar um notkun wiki-hugbúnaðarins.

== Fyrir byrjendur ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Listi yfir uppsetningarstillingar]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki Algengar spurningar MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Póstlisti MediaWiki-útgáfa]',
);

/** Italian (italiano)
 * @author Beta16
 * @author Darth Kule
 * @author F. Cosoleto
 * @author Karika
 */
$messages['it'] = array(
	'config-desc' => 'Il programma di installazione per MediaWiki',
	'config-title' => 'Installazione MediaWiki $1',
	'config-information' => 'Informazioni',
	'config-localsettings-upgrade' => 'È stato rilevato un file <code>LocalSettings.php</code>.
Per aggiornare questa installazione, si prega di inserire il valore di <code>$wgUpgradeKey</code> nella casella qui sotto.
Lo potete trovare in LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'È stato rilevato un file LocalSettings.php.
Per aggiornare questa installazione, eseguire update.php',
	'config-localsettings-key' => 'Chiave di aggiornamento:',
	'config-localsettings-badkey' => 'La chiave che hai fornito non è corretta.',
	'config-upgrade-key-missing' => "È stata rilevata un'installazione esistente di MediaWiki.
Per aggiornare questa installazione, si prega di inserire la seguente riga nella parte inferiore del tuo LocalSettings.php:

$1",
	'config-localsettings-incomplete' => 'Il file LocalSettings.php esistente sembra essere incompleto.
La variabile $1 non è impostata.
Cambia LocalSettings.php in modo che questa variabile sia impostata e fai clic su "Continua".',
	'config-localsettings-connection-error' => 'Si è verificato un errore durante la connessione al database utilizzando le impostazioni specificate in LocalSettings.php o AdminSettings.php. Si prega di correggere queste impostazioni e riprovare.

$1',
	'config-session-error' => "Errore nell'avvio della sessione: $1",
	'config-session-expired' => 'I dati della sessione sembrano essere scaduti.
Le sessioni sono configurate per una durata di $1.
Puoi aumentarla impostando <code>session.gc_maxlifetime</code> nel file php.ini.
Riavvia il processo di installazione.',
	'config-no-session' => 'I dati della sessione sono andati persi!
Controlla il tuo file php.ini ed assicurati che <code>session.save_path</code> è impostato su una directory appropriata.',
	'config-your-language' => 'La tua lingua:',
	'config-your-language-help' => 'Seleziona una lingua da utilizzare durante il processo di installazione.',
	'config-wiki-language' => 'La lingua del wiki:',
	'config-wiki-language-help' => 'Seleziona la lingua che verrà prevalentemente usata nel wiki.',
	'config-back' => '← Indietro',
	'config-continue' => 'Continua →',
	'config-page-language' => 'Lingua',
	'config-page-welcome' => 'Benvenuti in MediaWiki!',
	'config-page-dbconnect' => 'Connessione al database',
	'config-page-upgrade' => "Aggiornamento dell'installazione esistente",
	'config-page-dbsettings' => 'Impostazioni del database',
	'config-page-name' => 'Nome',
	'config-page-options' => 'Opzioni',
	'config-page-install' => 'Installa',
	'config-page-complete' => 'Completa!',
	'config-page-restart' => 'Riavvio installazione',
	'config-page-readme' => 'Leggimi',
	'config-page-releasenotes' => 'Note di versione',
	'config-page-upgradedoc' => 'Aggiornamento',
	'config-page-existingwiki' => 'Wiki esistenti',
	'config-help-restart' => 'Vuoi cancellare tutti i dati salvati che hai inserito e riavviare il processo di installazione?',
	'config-restart' => 'Sì, riavvia',
	'config-welcome' => "=== Controllo dell'ambiente ===
Vengono eseguiti controlli di base per vedere se questo ambiente è adatto per l'installazione di MediaWiki.
Se hai bisogno di aiuto durante l'installazione, è necessario fornire i risultati di questi controlli.",
	'config-env-good' => "L'ambiente è stato controllato.
È possibile installare MediaWiki.",
	'config-env-bad' => "L'ambiente è stato controllato.
Non è possibile installare MediaWiki.",
	'config-env-php' => 'PHP $1 è installato.',
	'config-env-php-toolow' => 'PHP $1 è installato.
Tuttavia, MediaWiki richiede PHP $2 o superiore.',
	'config-outdated-sqlite' => "'''Attenzione''': è presente SQLite $1 mentre è richiesta la versione $2, SQLite non sarà disponibile.",
	'config-no-fts3' => "'''Attenzione''': SQLite è compilato senza il [//sqlite.org/fts3.html modulo FTS3], le funzionalità di ricerca non saranno disponibili su questo backend.",
	'config-xml-bad' => 'Il modulo XML di PHP è mancante.
MediaWIki necessita di funzioni presenti in questo modulo e non funzionerà con la configurazione corrente.
Se si sta eseguendo Mandrake, installare il paccketto php-xml.',
	'config-pcre' => 'Il modulo per il supporto PCRE sembra essere mancante.
MediaWiki necessita di questo modulo per funzinare, che fornisce funzioni per le espressioni regolari Perl-compatibili.',
	'config-pcre-no-utf8' => "'''Errore''': Il modulo PCRE di PHP sembra essere stato compilato senza il supporto PCRE_UTF8, ma MediaWiki lo richiede per funzionare correttamente.",
	'config-memory-raised' => 'Il valore <code>memory_limit</code> di PHP è $1, aumentato a $2.',
	'config-memory-bad' => "''Attenzione:''' Il valore di <code>memory_limit</code> di PHP è $1.
Probabilmente è troppo basso.
L'installazione potrebbe non riuscire!",
	'config-ctype' => "'''Errore''': PHP deve essere compilato con il supporto per l'[http://www.php.net/manual/it/ctype.installation.php estensione Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] è installato',
	'config-apc' => '[http://www.php.net/apc APC] è installato',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] è installato',
	'config-no-cache' => "'''Attenzione:''' [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] o [http://www.iis.net/download/WinCacheForPhp WinCache] non sono stati trovati.
La caching degli oggetti non è attivata.",
	'config-diff3-bad' => 'GNU diff3 non trovato.',
	'config-imagemagick' => 'Trovato ImageMagick: <code>$1</code>.
Le miniature delle immagini saranno presenti se gli upload vengono abilitati.',
	'config-gd' => 'Trovata la GD Graphics Library built-in.
Le miniature delle immagini saranno presenti se gli upload vengono abilitati.',
	'config-no-scaling' => 'Impossibile trovare GD library o ImageMagick.
Le miniature delle immagini saranno disabilitate.',
	'config-no-uri' => "'''Errore:''' Impossibile determinare l'URI attuale.
Installazione interrotta.",
	'config-no-cli-uri' => "'''Attenzione''': --scriptpath non specificato, si utilizza il valore predefinito: <code>$1</code>.",
	'config-using-server' => 'Nome server in uso "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'URL del server in uso "<nowiki>$1$2</nowiki>".',
	'config-db-type' => 'Tipo di database:',
	'config-db-name' => 'Nome del database:',
	'config-db-password-empty' => 'Inserire una password per il nuovo utente del database: $1.
Anche se può essere possibile creare utenti senza password, questo non è sicuro.',
	'config-db-install-help' => "Inserire il nome utente e la password che verranno usate per la connessione al database durante il processo d'installazione.",
	'config-db-charset' => 'Set di caratteri del database',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 con compatibilità UTF-8',
	'config-mysql-old' => 'MySQL $1 o una versione successiva è necessaria, rilevata la $2.',
	'config-db-port' => 'Porta del database:',
	'config-db-schema' => 'Schema per MediaWiki:',
	'config-db-schema-help' => 'Questo schema in genere andrà bene.
Da cambiare solamente se si è sicuri di averne bisogno.',
	'config-pg-test-error' => "Impossibile connettersi al database '''$1''': $2",
	'config-sqlite-dir' => 'Directory data di SQLite:',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-header-mysql' => 'Impostazioni MySQL',
	'config-header-postgres' => 'Impostazioni PostgreSQL',
	'config-header-sqlite' => 'Impostazioni SQLite',
	'config-header-oracle' => 'Impostazioni Oracle',
	'config-header-ibm_db2' => 'Impostazioni IBM DB2',
	'config-invalid-db-type' => 'Tipo di database non valido',
	'config-db-web-create' => "Crea l'account se non esiste già",
	'config-mysql-engine' => 'Storage engine:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Set di caratteri del database:',
	'config-mysql-utf8' => 'UTF-8',
	'config-ibm_db2-low-db-pagesize' => "Il database DB2 in uso ha una tablespace predefinita con un insufficiente pagesize, che dovrebbe essere '''32K''' o maggiore.",
	'config-ns-generic' => 'Progetto',
	'config-ns-site-name' => 'Stesso nome wiki: $1',
	'config-admin-box' => 'Account amministratore',
	'config-admin-name' => 'Tuo nome:',
	'config-admin-password' => 'Password:',
	'config-admin-password-confirm' => 'Ripeti la password:',
	'config-admin-help' => 'Inserisci il tuo nome utente scelto qui, ad esempio "Mario Rossi".
Questo è il nome che userai per accedere al wiki.',
	'config-admin-name-blank' => "Inserisci un nome utente per l'amministratore.",
	'config-admin-name-invalid' => 'Il nome utente specificato "<nowiki>$1</nowiki>" non è valido.
Specificare un nome utente diverso.',
	'config-admin-password-blank' => "Inserisci una password per l'account di amministratore.",
	'config-admin-password-same' => 'La password non deve essere uguale al nome utente.',
	'config-admin-password-mismatch' => 'Le password inserite non coincidono tra loro.',
	'config-admin-email' => 'Indirizzo e-mail:',
	'config-admin-error-bademail' => 'È stato inserito un indirizzo email non valido.',
	'config-subscribe-help' => 'Si tratta di una mailing list a basso traffico dedicata agli annunci di nuove versioni, compresi importanti segnalazioni riguardanti la sicurezza.
È consigliato iscriversi e aggiornare la proprio installazione di MediaWiki quando una nuova versione viene resa pubblica.',
	'config-subscribe-noemail' => "Hai provato ad iscriverti alla mailing list dedicata agli annunci delle nuove versioni senza fornire un indirizzo email.
Inserire un indirizzo email se si desidera effettuare l'iscrizione alla mailing list.",
	'config-almost-done' => 'Hai quasi finito!
Adesso puoi saltare la rimanente parte della configurazione e semplicemente installare la wiki.',
	'config-license' => 'Copyright e licenza:',
	'config-license-cc-by-sa' => 'Creative Commons Attribuzione-Condividi allo stesso modo',
	'config-license-cc-by' => 'Creative Commons Attribuzione',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribuzione-Non commerciale-Condividi allo stesso modo',
	'config-license-cc-0' => 'Creative Commons Zero (pubblico dominio)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 o versioni successive',
	'config-license-pd' => 'Pubblico dominio',
	'config-email-settings' => 'Impostazioni email',
	'config-email-auth' => 'Abilita autenticazione via email',
	'config-upload-deleted' => 'Directory per i file cancellati:',
	'config-logo' => 'URL del logo:',
	'config-cc-again' => 'Seleziona di nuovo...',
	'config-cc-not-chosen' => 'Scegliere quale licenza Creative Commons si desidera e cliccare su "procedi".',
	'config-advanced-settings' => 'Configurazione avanzata',
	'config-memcache-badip' => 'È stato inserito un indirizzo IP non valido per Memcached: $1.',
	'config-extensions' => 'Estensioni',
	'config-install-user-alreadyexists' => 'L\'utente "$1" è già presente',
	'config-install-user-create-failed' => 'Creazione dell\'utente "$1" non riuscita: $2',
	'config-install-user-missing' => 'L\'utente indicato "$1" non esiste.',
	'config-install-tables-failed' => "'''Errore''': La creazione della tabella non è riuscita: $1",
	'config-install-interwiki-list' => 'Impossibile leggere il file <code>interwiki.list</code>.',
	'config-install-stats' => 'Inizializzazione delle statistiche',
	'config-install-keys' => 'Generazione delle chiavi segrete',
	'config-install-sysop' => "Creazione dell'account utente per l'amministratore",
	'config-install-subscribe-fail' => 'Impossibile sottoscrivere mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL non è installato e allow_url_fopen non è disponibile.',
	'config-install-mainpage' => 'Creazione della pagina principale con contenuto predefinito',
	'config-install-mainpage-failed' => 'Impossibile inserire la pagina principale: $1',
	'config-download-localsettings' => 'Scarica LocalSettings.php',
	'config-help' => 'aiuto',
	'config-nofile' => 'Il file "$1" non può essere trovato. È stato eliminato?',
	'mainpagetext' => "'''Installazione di MediaWiki completata correttamente.'''",
	'mainpagedocfooter' => "Consultare la [//meta.wikimedia.org/wiki/Aiuto:Sommario Guida utente] per maggiori informazioni sull'uso di questo software wiki.

== Per iniziare ==
I seguenti collegamenti sono in lingua inglese:

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Impostazioni di configurazione]
* [//www.mediawiki.org/wiki/Manual:FAQ Domande frequenti su MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailing list annunci MediaWiki]",
);

/** Japanese (日本語)
 * @author Aphaia
 * @author Iwai.masaharu
 * @author Mizusumashi
 * @author Ninomy
 * @author Ohgi
 * @author Shirayuki
 * @author Whym
 * @author Yanajin66
 * @author 青子守歌
 */
$messages['ja'] = array(
	'config-desc' => 'MediaWiki のインストーラー',
	'config-title' => 'MediaWiki $1 のインストール',
	'config-information' => '情報',
	'config-localsettings-upgrade' => 'ファイル <code>LocalSettings.php</code> を検出しました。
インストールされているものをアップグレードするには、<code>$wgUpgradeKey</code> の値を以下の欄に入力してください。
この値は LocalSettings.php 内にあります。',
	'config-localsettings-cli-upgrade' => 'ファイル LocalSettings.php を検出しました。
インストールされているものをアップグレードするには、update.php を実行してください',
	'config-localsettings-key' => 'アップグレード キー:',
	'config-localsettings-badkey' => '与えられたキーが間違っています',
	'config-upgrade-key-missing' => 'MediaWiki が既にインストールされていることを検出しました。
インストールされているものをアップグレードするために、以下の行を LocalSettings.php の末尾に挿入してください:

$1',
	'config-localsettings-incomplete' => '既存の LocalSettings.php の内容は不完全のようです。
変数 $1 が設定されていません。
LocalSettings.php 内でこの変数を設定して、「{{int:Config-continue}}」をクリックしてください。',
	'config-session-error' => 'セッションの開始エラー: $1',
	'config-session-expired' => 'セッションの有効期限が切れたようです。
セッションの有効期間は$1に設定されています。
php.iniの<code>session.gc_maxlifetime</code>を設定することで、この問題を改善できます。
インストール作業を再起動させてください。',
	'config-no-session' => 'セッションのデータが消失しました！
php.iniを確認し、<code>session.save_path</code>が適切なディレクトリに設定されていることを確認してください。',
	'config-your-language' => 'あなたの言語:',
	'config-your-language-help' => 'インストール作業に使用する言語を選択してください。',
	'config-wiki-language' => 'ウィキの言語:',
	'config-wiki-language-help' => 'ウィキで主に書き込まれる言語を選択してください。',
	'config-back' => '← 戻る',
	'config-continue' => '続行 →',
	'config-page-language' => '言語',
	'config-page-welcome' => 'MediaWiki へようこそ!',
	'config-page-dbconnect' => 'データベースに接続',
	'config-page-upgrade' => '既存のインストールを更新',
	'config-page-dbsettings' => 'データベースの設定',
	'config-page-name' => '名前',
	'config-page-options' => 'オプション',
	'config-page-install' => 'インストール',
	'config-page-complete' => '完了!',
	'config-page-restart' => 'インストールを再起動',
	'config-page-readme' => 'お読みください',
	'config-page-releasenotes' => 'リリースノート',
	'config-page-copying' => 'コピー',
	'config-page-upgradedoc' => 'アップグレード',
	'config-page-existingwiki' => '既存のウィキ',
	'config-help-restart' => '入力した保存データをすべて消去して、インストール作業を再起動しますか？',
	'config-restart' => 'はい、再起動します',
	'config-welcome' => '=== 環境の確認 ===
基本的な確認では、現在の環境がMediaWikiのインストールに適しているかを確認します。
インストール中に助けが必要になった場合は、この確認結果を提供してください。',
	'config-copyright' => '=== 著作権および規約 ===
$1

この作品はフリーソフトウェアです。あなたは、フリーソフトウェア財団の発行するGNU一般公衆利用許諾書 (GNU General Public License)（バージョン2、またはそれ以降のライセンス）の規約に基づき、このライブラリを再配布および改変できます。

この作品は、有用であることを期待して配布されていますが、商用あるいは特定の目的に適するかどうかも含めて、暗黙的にも、一切保証されません。
詳しくは、GNU一般公衆利用許諾書をご覧ください。

あなたはこのプログラムと共に、<doclink href=Copying>GNU一般公衆利用許諾契約書の複製</doclink>を一部受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団(宛先は the Free Software Foundation, Inc., 59Temple Place, Suite 330, Boston, MA 02111-1307 USA)まで請求してください。',
	'config-sidebar' => '* [//www.mediawiki.org MediaWikiのホーム]
* [//www.mediawiki.org/wiki/Help:Contents 利用者向け案内]
* [//www.mediawiki.org/wiki/Manual:Contents 管理者向け案内]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>お読みください</doclink>
* <doclink href=ReleaseNotes>リリースノート</doclink>
* <doclink href=Copying>コピー</doclink>
* <doclink href=UpgradeDoc>アップグレード</doclink>',
	'config-env-good' => '環境の確認が終わりました。
MediaWikiをインストールできます。',
	'config-env-bad' => '環境の確認が終わりました。
MediaWikiのインストールはできません。',
	'config-env-php' => 'PHP $1がインストールされています。',
	'config-env-php-toolow' => 'PHP $1 がインストールされています。
しかし、MediaWikiには PHP $2 以上が必要です。',
	'config-unicode-using-utf8' => 'Unicode正規化に、Brion Vibberのutf8_normalize.soを使用。',
	'config-unicode-using-intl' => 'Unicode正規化に[http://pecl.php.net/intl intl PECL 拡張機能]を使用。',
	'config-unicode-pure-php-warning' => "'''警告'''：Unicode正規化の処理に [http://pecl.php.net/intl intl PECL 拡張機能]が使用可能ではなく、処理の遅いピュア PHP の実装を代わりに用いています。
高トラフィックのサイトを運営する場合は、[//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode正規化に関するページ]をお読みください。",
	'config-unicode-update-warning' => "'''警告'''：インストールされているバージョンのUnicode正規化ラッパーは、[http://site.icu-project.org/ ICUプロジェクト]のライブラリの古いバージョンを使用しています。
Unicodeを少しでも利用する可能性があるなら、[//www.mediawiki.org/wiki/Unicode_normalization_considerations アップグレード]する必要があります。",
	'config-no-db' => '適切なデータベース ドライバーが見つかりませんでした! PHP にデータベース ドライバーをインストールする必要があります。
以下の種類のデータベースに対応しています: $1

共有サーバーを使用している場合は、適切なデータベース ドライバーのインストールを、サーバーの管理者に依頼してください。
PHP を自分でコンパイルした場合は、例えば <code>./configure --with-mysql</code> を実行して、データベース クライアントを使用できるように再設定してください。
Debian または Ubuntu のパッケージから PHP をインストールした場合は、php5-mysql モジュールもインストールする必要があります。',
	'config-no-fts3' => "'''警告'''：SQLiteは[//sqlite.org/fts3.html FTS3]モジュールなしでコンパイルされており、検索機能はこのバックエンドで利用不可能になります。",
	'config-register-globals' => "'''警告：PHPの<code>[http://php.net/register_globals register_globals]</code>オプションが有効になっています。'''
'''可能なら無効化してください。'''
MediaWikiは動作しますが、サーバーは、潜在的なセキュリティ脆弱性を露呈します。",
	'config-magic-quotes-runtime' => "'''致命的エラー：[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]が動作しています！'''
このオプションは、予期せずデータ入力を破壊します。
このオプションが無効化されないかぎり、MediaWikiをインストールし利用することはできません。",
	'config-magic-quotes-sybase' => "'''致命的エラー：[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase]が動作しています！'''
このオプションは、予期せずデータ入力を破壊します。
このオプションが無効化されないかぎり、MediaWikiをインストールし利用することはできません。",
	'config-mbstring' => "'''致命的エラー：[http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]が動作しています！'''
このオプションは、エラーを引き起こし、予期せずデータ入力を破壊する可能性があります。
このオプションが無効化されないかぎり、MediaWikiをインストールし利用することはできません。",
	'config-ze1' => "'''致命的エラー：[http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode]が動作しています！'''
このオプションは、MediaWikiにおいて深刻なバグを引き起こします。
このオプションが無効化されないかぎり、MediaWikiをインストールし利用することはできません。",
	'config-safe-mode' => "'''警告：'''PHPの[http://www.php.net/features.safe-mode セーフモード]が有効です。
特にファイルのアップロード<code>math</code>のサポートにおいて、問題が発生する可能性があります。",
	'config-xml-bad' => 'PHPのXMLモジュールが不足しています。
MediaWikiは、このモジュールの関数を必要としているため、この構成では動作しません。
Mandrakeを実行している場合、php-xmlパッケージをインストールしてください。',
	'config-pcre' => 'PCREをサポートしているモジュールが不足しているようです。
MediaWikiは、Perl互換の正規表現関数の動作が必要です。',
	'config-pcre-no-utf8' => "'''致命的エラー''': PHP の PCRE が PCRE_UTF8 対応なしでコンパイルされているようです。
MediaWiki を正しく動作させるには、UTF-8 対応が必要です。",
	'config-memory-raised' => 'PHPの<code>memory_limit</code>は$1で、$2に引き上げられました。',
	'config-memory-bad' => "'''警告：'''PHPの<code>memory_limit</code>は$1です。
これは、非常に遅い可能性があります。
インストールが失敗するかもしれません！",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] がインストール済み',
	'config-apc' => '[http://www.php.net/apc APC] がインストール済み',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] がインストール済み',
	'config-no-cache' => "'''警告：'''[http://www.php.net/apc APC]、[http://xcache.lighttpd.net/ XCache]、[http://www.iis.net/download/WinCacheForPhp WinCache] のいずれも見つかりませんでした。
オブジェクトのキャッシュは有効化されません。",
	'config-diff3-bad' => 'GNU diff3 が見つかりません。',
	'config-imagemagick' => 'ImageMagickが見つかりました：<code>$1</code>。
アップロードが有効なら、画像のサムネイルが利用できます。',
	'config-gd' => 'GD画像ライブラリが内蔵されていることが確認されました。
アップロードが有効なら、画像のサムネイルが利用できます。',
	'config-no-scaling' => 'GDライブラリもImageMagickも見つかりませんでした。
画像のサムネイル生成は無効になります。',
	'config-no-uri' => "'''エラー：'''現在のURIを決定できませんでした。
インストールは中止されました。",
	'config-using-server' => 'サーバー名「<nowiki>$1</nowiki>」を使用しています。',
	'config-using-uri' => 'サーバー URL「<nowiki>$1$2</nowiki>」を使用しています。',
	'config-uploads-not-safe' => "'''警告：'''アップロードの既定ディレクトリ <code>$1</code> に、任意のスクリプト実行に関する脆弱性があります。
MediaWiki はアップロードされたファイルのセキュリティ上の脅威を確認しますが、アップロードを有効化する前に、[//www.mediawiki.org/wiki/Manual:Security#Upload_security このセキュリティ上の脆弱性を解決する]ことを強く推奨します。",
	'config-brokenlibxml' => 'このシステムで使われているPHPとlibxml2のバージョンのこの組み合わせにはバグがあります。具体的には、MediaWikiやその他のウェブアプリケーションでhiddenデータが破損する可能性があります。
PHPを5.2.9かそれ以降のバージョンに、libxml2を2.7.3かそれ以降のバージョンにアップグレードしてください([//bugs.php.net/bug.php?id=45996 PHPでのバグ情報])。
インストールを終了します。',
	'config-using531' => 'PHP$1は<code>__call()</code>の引数参照に関するバグのため、MediaWikiと互換性がありません。
PHP5.3.2以降に更新するか、この([//bugs.php.net/bug.php?id=50394 PHPに提出されたバグ])を修正するためにPHP5.3.0へ戻してください。
インストールは中止されました。',
	'config-suhosin-max-value-length' => 'Suhosin がインストールされており、GETパラメータの長さを $1 バイトに制限しています。MediaWiki の ResourceLoader コンポーネントはこの制限を回避しますが、パフォーマンスは低下します。可能な限り、php.ini で suhosin.get.max_value_length を 1024 以上に設定し、同じ値を LocalSettings.php 中で $wgResourceLoaderMaxQueryLength に設定してください。',
	'config-db-type' => 'データベースの種類:',
	'config-db-host' => 'データベースのホスト:',
	'config-db-host-help' => '異なるサーバー上にデータベースサーバーがある場合、ホスト名またはIPアドレスをここに入力してください。

もし、共有されたウェブホスティングを使用している場合、ホスティングプロバイダーは正確なホスト名を解説しているはずです。

WindowsでMySQLを使用している場合に、「localhost」は、サーバー名としてはうまく働かないでしょう。もしそのような場合は、ローカルIPアドレスとして「127.0.0.1」を試してみてください。

PostgreSQLを使用している場合、UNIXソケットで接続するにはこの欄を空欄のままにしてください。',
	'config-db-host-oracle' => 'データベース TNS:',
	'config-db-host-oracle-help' => '有効な[http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm ローカル接続名]を入力してください。tnsnames.oraファイルは、このインストールに対して表示されてなければなりません、<br />もしクライアントライブラリ10gもしくはそれ以上を使用している場合、メソッドの名前を[http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm 簡易接続]で利用できます。',
	'config-db-wiki-settings' => 'このウィキの識別情報',
	'config-db-name' => 'データベース名:',
	'config-db-name-help' => 'このウィキを識別する名前を入力してください。
空白を含めることはできません。

共有ウェブホストを利用している場合、ホスティングプロバイダーが特定の使用可能なデータベース名を提供するか、あるいは管理パネルからデータベースを作成できるようにしているでしょう。',
	'config-db-name-oracle' => 'データベースのスキーマ:',
	'config-db-install-account' => 'インストールで使用する利用者アカウント',
	'config-db-username' => 'データベースのユーザー名:',
	'config-db-password' => 'データベースのパスワード:',
	'config-db-password-empty' => '新しいデータベースの利用者名 $1 のパスワードを入力してください。
パスワードを設定しないでユーザを作ることもできるかもしれませんが、安全ではありません。',
	'config-db-install-username' => 'インストール中にデータベースに接続するために使うユーザ名を入力してください。これは MediaWiki アカウントのユーザ名 (利用者名) のことではありません。あなたのデータベースでのユーザ名です。',
	'config-db-install-password' => 'インストール中にデータベースに接続するために使うパスワードを入力してください。これは MediaWiki アカウントパスワードのことではありません。あなたのデータベースでのパスワードです。',
	'config-db-install-help' => 'インストール作業中にデータベースに接続するための利用者名とパスワードを入力してください。',
	'config-db-account-lock' => 'インストール作業終了後も同じ利用者名とパスワードを使用する',
	'config-db-wiki-account' => 'インストール作業終了後の利用者アカウント',
	'config-db-wiki-help' => '通常のウィキ操作中にデータベースへの接続する時に利用する利用者名とパスワードを入力してください。
アカウントが存在せず、インストールのアカウントに十分な権限がある場合は、この利用者アカウントは、ウィキを操作する上で最小限の権限を持った状態で作成されます。',
	'config-db-prefix' => 'データベース テーブルの接頭辞:',
	'config-db-prefix-help' => 'データベースを複数のウィキ間、あるいはMediaWikiと他のウェブアプリケーションで共有する必要がある場合、衝突を避けるために、すべてのテーブル名に接頭辞を付ける必要があります。
空白は使用できません。

このフィールドは、通常は空のままです。',
	'config-db-charset' => 'データベースの文字セット',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 バイナリ',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 後方互換 UTF-8',
	'config-charset-help' => "'''警告:''' MySQL 4.1+ で'''後方互換 UTF-8''' を使用している状態で、<code>mysqldump</code> でデータベースをバックアップすると、すべての非 ASCII 文字が破壊されてしまい、バックアップが不可逆的に破損してしまいます!

'''バイナリ モード'''では、MediaWiki は、UTF-8 テキストをデータベースのバイナリ フィールドに格納します。
これは、MySQL の UTF-8 モードより効率的で、Unicode 文字の全範囲を利用できるようになります。
'''UTF-8 モード'''では、MySQL は、データ内で使用している文字集合を知っているため、適切に表現や変換ができますが、
[//ja.wikipedia.org/wiki/%E5%9F%BA%E6%9C%AC%E5%A4%9A%E8%A8%80%E8%AA%9E%E9%9D%A2 基本多言語面]の外にある文字を格納できません。",
	'config-mysql-old' => 'MySQL $1 以降が必要です。ご使用中の MySQL は $2 です。',
	'config-db-port' => 'データベースのポート:',
	'config-db-schema' => 'MediaWiki のスキーマ:',
	'config-db-schema-help' => '通常はこのスキーマで問題ありません。
必要な場合のみ変更してください。',
	'config-sqlite-dir' => 'SQLite データ ディレクトリ:',
	'config-sqlite-dir-help' => "SQLite は単一のファイル内にすべてのデータを格納しています。

指定したディレクトリは、インストール時にウェブ サーバーが書き込めるようにしておく必要があります。

このディレクトリはウェブからアクセス'''不可能'''である必要があります。PHP ファイルがある場所には配置できないのはこのためです。

インストーラーは <code>.htaccess</code> ファイルにも書き込みます。しかし、これが失敗した場合は、誰かが生のデータベースにアクセスできてしまいます。
データベースは、生のデータ (メールアドレス、パスワードのハッシュ値) の他、削除された版、その他ウィキ上の制限されているデータを含んでいます。

例えば <code>/var/lib/mediawiki/yourwiki</code> のように、別の場所にデータベースを配置することを検討してください。",
	'config-oracle-def-ts' => '既定のテーブル領域:',
	'config-oracle-temp-ts' => '一時的なテーブル領域:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki は以下のデータベース システムに対応しています:

$1

使用しようとしているデータベース システムが下記の一覧にない場合は、上記リンク先の手順に従ってインストールしてください。',
	'config-support-mysql' => '* $1はMediaWikiの主要な対象で、もっともサポートされています（[http://www.php.net/manual/en/mysql.installation.php MySQLのサポート下でPHPをコンパイルする方法]）',
	'config-support-postgres' => '* $1は、MySQLの代替として、人気のあるオープンソースデータベースシステムです（[http://www.php.net/manual/en/pgsql.installation.php PostgreSQLのサポート下でPHPをコンパイルする方法]）',
	'config-support-sqlite' => '* $1は、良くサポートされている、軽量データベースシステムです。（[http://www.php.net/manual/en/pdo.installation.php SQLiteのサポート下でPHPをコンパイルする方法]、PDOを使用）',
	'config-support-oracle' => '* $1は商業企業のデータベースです。（[http://www.php.net/manual/en/oci8.installation.php OCI8サポートなPHPをコンパイルする方法]）',
	'config-support-ibm_db2' => '* $1 は商業企業のデータベースです。',
	'config-header-mysql' => 'MySQL の設定',
	'config-header-postgres' => 'PostgreSQL の設定',
	'config-header-sqlite' => 'SQLite の設定',
	'config-header-oracle' => 'Oracle の設定',
	'config-header-ibm_db2' => 'IBM DB2 の設定',
	'config-invalid-db-type' => '無効なデータベースの種類',
	'config-missing-db-name' => '「データベース名」を入力してください',
	'config-missing-db-host' => '「データベースのホスト」を入力してください',
	'config-missing-db-server-oracle' => '「データベース TNS」の値を入力してください',
	'config-invalid-db-server-oracle' => '「$1」は無効なデータベース TNS です。
アスキー英字(a-z、A-Z)、数字(0-9)、アンダーバー(_)、ドット(.)のみを使用してください。',
	'config-invalid-db-name' => '「$1」は無効なデータベース名です。
アスキー英字(a-z、A-Z)、数字(0-9)、アンダーバー(_)、ハイフン(-)のみを使用してください。',
	'config-invalid-db-prefix' => '「$1」は無効なデータベース接頭語です。
アスキー英字(a-z, A-Z)、数字(0-9)、下線(_)、ハイフン(-)のみを使用してください。',
	'config-connection-error' => '$1。

以下のホスト名、ユーザ名、パスワードをチェックして、再度試してみてください。',
	'config-invalid-schema' => '「$1」は MediaWiki のスキーマとして無効です。
ASCII の英数字 (a-z、A-Z、0-9)、下線 (_) のみを使用してください。',
	'config-postgres-old' => 'PostgreSQL $1 以降が必要です。ご使用中の PostgreSQL は $2 です。',
	'config-sqlite-name-help' => 'あなたのウェキと同一性のある名前を選んでください。
空白およびハイフンは使用しないでください。
SQLiteのデータファイル名として使用されます。',
	'config-sqlite-parent-unwritable-group' => 'データ ディレクトリ <code><nowiki>$1</nowiki></code> を作成できません。ウェブ サーバーは親ディレクトリ <code><nowiki>$2</nowiki></code> に書き込めませんでした。

インストーラーは、ウェブ サーバーの実行ユーザーを特定しました。
続行するには、ディレクトリ <code><nowiki>$3</nowiki></code> に書き込めるようにしてください。
Unix または Linux であれば、以下を実行してください:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'データ ディレクトリ <code><nowiki>$1</nowiki></code> を作成できません。ウェブ サーバーは、親ディレクトリ <code><nowiki>$2</nowiki></code> に書き込めませんでした。

インストーラーは、ウェブ サーバーの実行ユーザーを特定できませんでした。
続行するには、ディレクトリ <code><nowiki>$3</nowiki></code> に、ウェブ サーバー (と、あらゆる人々!) がグローバルに書き込めるようにしてください。
Unix または Linux では、以下を実行してください:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'データ ディレクトリ「$1」を作成する際にエラーが発生しました。
場所を確認してから、再度試してください。',
	'config-sqlite-dir-unwritable' => 'ディレクトリ「$1」に書き込めません。
ウェブ サーバーが書き込めるようにパーミッションを変更してから、再度試してください。',
	'config-sqlite-connection-error' => '$1。

データ ディレクトリおよびデータベース名を確認してから、再度試してください。',
	'config-sqlite-readonly' => 'ファイル <code>$1</code> に書き込めません。',
	'config-sqlite-cant-create-db' => 'データベース ファイル <code>$1</code> を作成できませんでした。',
	'config-sqlite-fts3-downgrade' => 'PHP が FTS3 に対応していないため、テーブルをダウングレードしています',
	'config-can-upgrade' => 'このデータベースには　MediaWiki テーブルがあります。
これらのテーブルを MediaWiki $1 にアップグレードするには、「続行」をクリックしてください。',
	'config-upgrade-done' => "更新は完了しました。

[$1 ウィキを使い始める]ことができます。

もし、<code>LocalSettings.php</code>ファイルを再生成したいのならば、下のボタンを押してください。
ウィキに問題がないのであれば、これは'''推奨されません'''。",
	'config-upgrade-done-no-regenerate' => 'アップグレードが完了しました。

[$1 ウィキの使用を開始]することができます。',
	'config-regenerate' => 'LocalSettings.phpを再生成→',
	'config-show-table-status' => 'SHOW TABLE STATUSクエリーが失敗しました！',
	'config-unknown-collation' => "'''警告:''' データベースは認識されない照合を使用しています。",
	'config-db-web-account' => 'ウェブアクセスのためのデータベースアカウント',
	'config-db-web-help' => 'ウィキの通常の操作の際に、ウェブ サーバーがデータベース サーバーに接続できるように、ユーザー名とパスワードを指定してください。',
	'config-db-web-account-same' => 'インストール作業と同じアカウントを使用する',
	'config-db-web-create' => 'アカウントが存在しない場合は作成する',
	'config-db-web-no-create-privs' => 'あなたがインストールのために定義したアカウントは、アカウント作成のための特権としては不充分です。
あなたがここで指定したアカウントは既に存在している必要があります。',
	'config-mysql-engine' => 'ストレージ エンジン:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-engine-help' => "'''InnoDB'''は、並行処理のサポートに優れているので、ほとんどの場合において最良の選択肢です。

'''MyISAM'''は、利用者が1人の場合、あるいは読み込み専用でインストールする場合に、より処理が早くなるでしょう。
ただし、MyISAMのデータベースは、InnoDBより高頻度で破損する傾向があります。",
	'config-mysql-charset' => 'データベースの文字セット：',
	'config-mysql-binary' => 'バイナリ',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "'''バイナリ モード'''では、MediaWiki は、UTF-8 テキストをデータベースのバイナリ フィールドに格納します。
これは、MySQL の UTF-8 モードより効率的で、Unicode 文字の全範囲を利用できるようになります。

'''UTF-8 モード'''では、MySQL は、データ内で使用している文字集合を知っているため、適切に表現や変換ができますが、
[//ja.wikipedia.org/wiki/%E5%9F%BA%E6%9C%AC%E5%A4%9A%E8%A8%80%E8%AA%9E%E9%9D%A2 基本多言語面]の外にある文字を格納できません。",
	'config-site-name' => 'ウィキ名:',
	'config-site-name-help' => 'この事象はブラウザーのタイトルバーと他のさまざまな場所に現れる。',
	'config-site-name-blank' => 'サイト名を入力してください。',
	'config-project-namespace' => 'プロジェクト名前空間:',
	'config-ns-generic' => 'プロジェクト',
	'config-ns-site-name' => 'ウィキ名と同じ: $1',
	'config-ns-other' => 'その他 (指定してください)',
	'config-ns-other-default' => 'マイウィキ',
	'config-project-namespace-help' => "ウィキペディアの例に従い、多くのウィキは、コンテンツのページとは分離したポリシーページを「'''プロジェクトの名前空間'''」に持っています。
この名前空間のページのタイトルはすべて、ある接頭辞で始まります。それをここで指定することができます。
この接頭辞はウィキの名前に由来するのが伝統的ですが、「#」や「:」のような区切り文字を含めることはできません。",
	'config-ns-invalid' => '"<nowiki>$1</nowiki>"のように指定された名前空間は無効です。
違うプロジェクト名前空間を指定してください。',
	'config-admin-box' => '管理アカウント',
	'config-admin-name' => '名前:',
	'config-admin-password' => 'パスワード:',
	'config-admin-password-confirm' => 'パスワードの再入力:',
	'config-admin-help' => '希望するユーザー名をここに入力してください (例: "Joe Bloggs")。
この名前でこのウィキにログインすることになります。',
	'config-admin-name-blank' => '管理者のユーザ名を入力してください。',
	'config-admin-name-invalid' => '指定されたユーザ名 "<nowiki>$1</nowiki>" は無効です。
別のユーザ名を指定してください。',
	'config-admin-password-blank' => '管理者アカウントのパスワードを入力してください。',
	'config-admin-password-same' => 'ユーザ名と同じパスワードは使えません。',
	'config-admin-password-mismatch' => '入力された2つのパスワードが一致しません。',
	'config-admin-email' => 'メールアドレス:',
	'config-admin-email-help' => 'メールアドレスを入力してください。他の利用者からのメールの受け取り、パスワードのリセット、ウォッチリストに登録したページの更新通知に使用します。空欄のままにすることもできます。',
	'config-admin-error-user' => '"<nowiki>$1</nowiki>"という名前の管理者を作成する際に内部エラーが発生しました。',
	'config-admin-error-password' => '管理者"<nowiki>$1</nowiki>"のパスワードを設定する際に内部エラーが発生しました: <pre>$2</pre>',
	'config-subscribe' => '[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce リリース告知のメーリングリスト]を購読する。',
	'config-subscribe-help' => 'これは、リリースの告知（重要なセキュリティに関する案内を含む）に使われる、低容量のメーリングリストです。
このメーリングリストを購読して、新しいバージョンが出た場合にMediaWikiを更新してください。',
	'config-almost-done' => 'これでほぼ終わりました！
残りの設定を飛ばして、今すぐにウィキをインストールできます。',
	'config-optional-continue' => '私にもっと質問してください。',
	'config-optional-skip' => 'もう飽きてしまったので、とにかくウィキをインストールしてください。',
	'config-profile' => '利用者権限のプロファイル:',
	'config-profile-wiki' => '伝統的なウィキ',
	'config-profile-no-anon' => 'アカウントの作成が必要',
	'config-profile-fishbowl' => '承認された編集者のみ',
	'config-profile-private' => '非公開ウィキ',
	'config-profile-help' => "ウィキは、たくさんの人が可能な限りそのウィキを編集できるとき、最も優れた働きをします。
MediaWikiでは、最近の更新を確認し、神経質な、もしくは悪意を持った利用者からの損害を差し戻すことが、簡単にできます。

しかし一方で、MediaWikiは、さらにさまざまな形態での利用も優れていると言われています。また、時には、すべての人にウィキ手法の利点を説得させるのは容易ではないかもしれません。
そこで、選択肢があります。

'''{{int:config-profile-wiki}}'''は、ログインしなくても、誰でも編集できるものです。
'''{{int:config-profile-no-anon}}'''なウィキは、各編集に対してより強い説明責任を付与しますが、気軽な投稿を阻害するかもしれません。

'''{{int:config-profile-fishbowl}}'''のウィキは、承認された利用者が編集でき、一方、一般の人はページ（とその履歴）を閲覧できます。
'''{{int:config-profile-private}}'''は、承認された利用者のみがページを閲覧でき、そのグループが編集できます。

より複雑な利用者権限の設定は、インストール後に設定できます。詳細は[//www.mediawiki.org/wiki/Manual:User_rights 関連するマニュアル]をご覧ください。",
	'config-license' => '著作権とライセンス:',
	'config-license-none' => 'ライセンスのフッターを付けない',
	'config-license-cc-by-sa' => 'クリエイティブ・コモンズ 表示-継承',
	'config-license-cc-by' => 'クリエイティブ・コモンズ 表示',
	'config-license-cc-by-nc-sa' => 'クリエイティブ・コモンズ 表示-非営利-継承',
	'config-license-gfdl' => 'GNU フリー文書利用許諾契約書 1.3 以降',
	'config-license-pd' => 'パブリック・ドメイン',
	'config-license-cc-choose' => 'その他のクリエイティブ・コモンズ・ライセンスを選択する',
	'config-license-help' => "多くの公開ウィキでは、すべての寄稿物が[http://freedomdefined.org/Definition フリーライセンス]の元に置かれています。
こうすることにより、コミュニティによる共有の感覚が生まれ、長期的な寄稿が促されます。
私的ウィキや企業のウィキでは、通常、フリーライセンスにする必要はありません。

ウィキペディアにあるテキストをあなたのウィキで利用し、逆にあなたのウィキにあるテキストをウィキペディアに複製することを許可したい場合には、'''クリエイティブ・コモンズ 表示-継承'''を選択するべきです。

ウィキペディアは以前、GNUフリー文書利用許諾契約書(GFDL)を使用していました。
GFDL は有効なライセンスですが、内容を理解するのは困難です。
また、GFDL の元に置かれているコンテンツの再利用も困難です。",
	'config-email-settings' => 'メールの設定',
	'config-enable-email' => 'メール送信を有効にする',
	'config-enable-email-help' => 'メールを使用したい場合は、[http://www.php.net/manual/en/mail.configuration.php PHP のメール設定]が正しく設定されている必要があります。
メールの機能を使用しない場合は、ここで無効にすることができます。',
	'config-email-user' => '利用者間のメールを有効にする',
	'config-email-user-help' => '設定において有効になっている場合、すべてのユーザがお互いにメールのやりとりを行うことを許可する。',
	'config-email-usertalk' => 'ユーザのトークページにおける通知を有効にする',
	'config-email-usertalk-help' => '設定で有効にしているならば、ユーザのトークページの変更の通知を受けることをユーザに許可する。',
	'config-email-watchlist' => 'ウォッチリストの通知を有効にする',
	'config-email-watchlist-help' => '利用者が設定で有効にしている場合、閲覧されたページに関する通知を受け取ることを許可する。',
	'config-email-auth' => 'メールの認証を有効にする',
	'config-email-auth-help' => "この選択肢を有効にすると、利用者がメールアドレスを設定あるいは変更したときに送信されるリンクにより、そのアドレスを確認しなければならなくなります。
認証済みのアドレスだけが、他の利用者からのメールや、変更通知のメールを受け取ることができます。
公開ウィキでは、メール機能による潜在的な不正利用の防止のため、この選択肢を設定することが'''推奨'''されます。",
	'config-email-sender' => '返信先メールアドレス:',
	'config-email-sender-help' => '送信メールで返信先として使用するメールアドレスを入力してください。
このアドレスは、宛先不明の場合の通知の宛先になります。
多くのメールサーバーでは、少なくともドメイン名部分は有効である必要があります。',
	'config-upload-settings' => '画像およびファイルのアップロード',
	'config-upload-enable' => 'ファイルのアップロードを有効にする',
	'config-upload-help' => 'ファイルのアップロードは、あなたのサーバーをセキュリティ上の潜在的な危険に晒します。
この詳細は、マニュアルの [//www.mediawiki.org/wiki/Manual:Security security section] をお読みください。

ファイルのアップロードを有効にするには、MediaWiki のルート ディレクトリ内の <code>images</code> サブ ディレクトリのモードを変更します。これにより、ウェブ サーバーがそこに書き込めるようになります。
そして、このオプションを有効にしてください。',
	'config-upload-deleted' => '削除されたファイルのためのディレクトリ:',
	'config-upload-deleted-help' => '削除されるファイルを保存するためのディレクトリを選択してください。
これがウェブからアクセスできないことが理想です。',
	'config-logo' => 'ロゴ のURL:',
	'config-logo-help' => 'MediaWikiの既定の外装では、サイドバー上部に135x160ピクセルのロゴ用の余白があります。
適切なサイズの画像をアップロードして、そのURLをここに入力してください。

ロゴが不要の場合は、このボックスを空白のままにしてください。',
	'config-instantcommons' => 'Instant Commons 機能を有効にする',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons InstantCommons]は、[//commons.wikimedia.org/ ウィキメディア・コモンズ]のサイトで見つかった画像や音声、その他のメディアをウィキ上で利用することができるようになる機能です。
これを有効化するには、MediaWikiはインターネットに接続できなければなりません。

ウィキメディア・コモンズ以外のウィキを同じように設定する方法など、この機能に関する詳細な情報は、[//mediawiki.org/wiki/Manual:$wgForeignFileRepos マニュアル]をご覧ください。',
	'config-cc-error' => 'クリエイティブ・コモンズ・ライセンスの選択器から結果が得られませんでした。
ライセンスの名前を手動で入力してください。',
	'config-cc-again' => 'もう一度選択してください...',
	'config-cc-not-chosen' => '希望するクリエイティブ・コモンズのライセンスを選択して、「続行」をクリックしてください。',
	'config-advanced-settings' => '高度な設定',
	'config-cache-options' => 'オブジェクトのキャッシュの設定:',
	'config-cache-help' => 'オブジェクトのキャッシュを使用すると、頻繁に使用するデータをキャッシュするため MediaWiki の動作速度を改善できます。
中〜大規模サイトではこれを有効にすることを強くお勧めします。小規模サイトでも同様に効果があります。',
	'config-cache-none' => 'キャッシングしない(機能は取り払われます、しかもより大きなウィキサイト上でスピードの問題が発生します)',
	'config-cache-accel' => 'PHP オブジェクト キャッシュ (APC、XCache、WinCache のいずれか)',
	'config-cache-memcached' => 'Memcachedを使用（追加の設定が必要です）',
	'config-memcached-servers' => 'メモリをキャッシュされたサーバ:',
	'config-memcached-help' => 'Memcachedを使用するIPアドレスの一覧。
カンマ区切りで、利用する特定のポートの指定が必要です。例:
127.0.0.1:11211
192.168.1.25:1234',
	'config-extensions' => '拡張機能',
	'config-extensions-help' => '<code>./extensions</code>ディレクトリ内で、上記リストの拡張機能が発見されました。

これらは更に多くの設定を要求するかもしれませんが、今これらを有効にすることができます。',
	'config-install-alreadydone' => "'''警告:''' 既にMediaWikiがインストール済みで、再びインストールし直そうとしています。
次のページへ進んでください。",
	'config-install-begin' => '「{{int:config-continue}}」を押すと、MediaWiki のインストールを開始できます。
変更したい設定がある場合は、「{{int:Config-back}}」を押してください。',
	'config-install-step-done' => '実行',
	'config-install-step-failed' => '失敗した',
	'config-install-extensions' => '拡張機能を含む',
	'config-install-database' => 'データベースの構築',
	'config-install-schema' => 'スキーマの作成',
	'config-install-pg-schema-not-exist' => 'PostgreSQL スキーマがありません。',
	'config-install-pg-schema-failed' => 'テーブルの作成に失敗しました。
利用者「$1」がスキーマ「$2」に書き込めるようにしてください。',
	'config-install-pg-commit' => '変更を送信',
	'config-install-user' => 'データベースユーザーの作成',
	'config-install-user-alreadyexists' => 'ユーザー「$1」は既に存在します',
	'config-install-user-create-failed' => 'ユーザー「$1」の作成に失敗しました: $2',
	'config-install-user-grant-failed' => 'ユーザー「$1」に許可を与えることに失敗しました: $2',
	'config-install-user-missing' => '指定したユーザー「$1」は存在しません。',
	'config-install-user-missing-create' => '指定したユーザー「$1」は存在しません。
アカウントを作成する場合は、下の「アカウント作成」をクリックしてください。',
	'config-install-tables' => 'テーブルの作成',
	'config-install-tables-exist' => "'''警告'''：MediaWikiテーブルは既に存在するようです。
作成を飛ばします。",
	'config-install-tables-failed' => "'''エラー''': テーブルの作成が、以下のエラーにより失敗しました: $1",
	'config-install-interwiki' => '既定のウィキ間テーブルの導入',
	'config-install-interwiki-list' => 'ファイル <code>interwiki.list</code> から読み取れませんでした。',
	'config-install-interwiki-exists' => "'''警告'''：ウィキ間テーブルは既に登録されているようです。
既定のテーブルを無視します。",
	'config-install-stats' => '統計情報の初期化',
	'config-install-keys' => '秘密鍵の生成',
	'config-install-sysop' => '管理者のアカウントの作成',
	'config-install-mainpage' => 'メインページを既定の内容で作成',
	'config-install-mainpage-failed' => 'メインページを挿入できませんでした: $1',
	'config-install-done' => "'''おめでとうございます！'''
MediaWikiのインストールに成功しました。

<code>LocalSettings.php</code>ファイルが生成されました。
すべての設定がそのファイルに含まれています。

それをダウンロードし、ウィキをインストールした基準ディレクトリ（index.phpと同じディレクトリ）に設置する必要があります。ダウンロードは自動的に開始しているはずです。

ダウンロードが開始していない場合、またダウンロードをキャンセルした場合は、下記のリンクからダウンロードを再開することができます：

$3

'''注意''': もし、これを今しなければ、つまり、このファイルをダウンロードせずインストールを終了した場合、この生成された設定ファイルは利用されません。

それを完了すれば、'''[$2 ウィキに入る]'''ことができます。",
	'config-download-localsettings' => 'LocalSettings.php をダウンロード',
	'config-help' => 'ヘルプ',
	'mainpagetext' => "'''MediaWiki のインストールに成功しました。'''",
	'mainpagedocfooter' => 'ウィキソフトウェアの使い方に関する情報は[//meta.wikimedia.org/wiki/Help:Contents 利用者案内]を参照してください。

== はじめましょう ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings/ja 設定の一覧]
* [//www.mediawiki.org/wiki/Manual:FAQ/ja MediaWiki よくある質問と回答]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWikiリリース情報メーリングリスト]',
);

/** Jamaican Creole English (Patois)
 * @author Yocahuna
 */
$messages['jam'] = array(
	'mainpagetext' => "'''MediaWiki don instaal soksesful.'''",
	'mainpagedocfooter' => "Kansolt di [//meta.wikimedia.org/wiki/Help:Contents User's Guide] fi infamieshan ou fi yuuz di wiki saafwier.

== Taatop ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Jutish (jysk)
 * @author Huslåke
 */
$messages['jut'] = array(
	'mainpagetext' => "'''MediaWiki er nu installeret.'''",
	'mainpagedocfooter' => "Se vores engelskspråĝede [//meta.wikimedia.org/wiki/MediaWiki_localisation dokumentåsje tilpasnenge'm åf æ brugergrænseflade] og [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide æ brugervejlednenge] før åplysnenger åpsætnenge'm og anvendelse.",
);

/** Javanese (Basa Jawa)
 */
$messages['jv'] = array(
	'mainpagetext' => "'''Prangkat empuk wiki wis suksès dipasang.'''",
	'mainpagedocfooter' => "Mangga maca [//meta.wikimedia.org/wiki/Help:Contents User's Guide] kanggo katrangan luwih langkung prakara panggunan prangkat empuk wiki
== Miwiti panggunan  ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Daftar pangaturan préférènsi]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Milis rilis MediaWiki]",
);

/** Georgian (ქართული)
 * @author David1010
 */
$messages['ka'] = array(
	'config-information' => 'ინფორმაცია',
	'config-your-language' => 'თქვენი ენა:',
	'config-wiki-language' => 'ვიკის ენა:',
	'config-back' => '← უკან',
	'config-continue' => 'გაგრძელება →',
	'config-page-language' => 'ენა',
	'config-page-welcome' => 'კეთილი იყოს თქვენი მობრძანება მედიავიკიში!',
	'config-page-dbconnect' => 'მონაცემთა ბაზასთან დაკავშირება',
	'config-page-dbsettings' => 'მონაცემთა ბაზის კონფიგურაცია',
	'config-page-name' => 'სახელი',
	'config-page-options' => 'პარამეტრები',
	'config-page-install' => 'ინსტალაცია',
	'config-page-complete' => 'დასრულებულია!',
	'config-page-restart' => 'ინსტალაციის თავიდან დაწყება',
	'config-page-readme' => 'წამიკითხე',
	'config-page-copying' => 'ლიცენზია',
	'config-page-upgradedoc' => 'განახლება',
	'config-restart' => 'დიახ, თავიდან დაიწყეთ',
	'config-sidebar' => '* [//www.mediawiki.org მედიავიკის ვებ-გვერდი]
* [//www.mediawiki.org/wiki/Help:Contents/ka მომხმარებლების დახმარება]
* [//www.mediawiki.org/wiki/Manual:Contents/ka ადმინისტრატორების დახმარება]
* [//www.mediawiki.org/wiki/Manual:FAQ/ka FAQ]
----
* <doclink href=Readme>წამიკითხე</doclink>
* <doclink href=ReleaseNotes>ინფორმაცია გამოშვებაზე</doclink>
* <doclink href=Copying>ლიცენზია</doclink>
* <doclink href=UpgradeDoc>განახლება</doclink>',
	'config-db-type' => 'მონაცემთა ბაზის ტიპი:',
	'config-db-host-oracle' => 'მონაცემთა ბაზის TNS:',
	'config-db-name' => 'მონაცემთა ბაზის სახელი:',
	'config-db-name-oracle' => 'მონაცემთა ბაზის სქემა:',
	'config-db-username' => 'მონაცემთა ბაზის მომხმარებლის სახელი:',
	'config-db-password' => 'მონაცემთა ბაზის პაროლი:',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 ორობითი',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-db-port' => 'მონაცემთა ბაზის პორტი:',
	'config-db-schema' => 'მედიავიკის სქემა:',
	'config-header-mysql' => 'MySQL-ის პარამეტრები',
	'config-header-postgres' => 'PostgreSQL-ის პარამეტრები',
	'config-header-sqlite' => 'SQLite-ის პარამეტრები',
	'config-header-oracle' => 'Oracle-ის პარამეტრები',
	'config-header-ibm_db2' => 'IBM DB2-ის პარამეტრები',
	'config-invalid-db-type' => 'არასწორი მონაცემთა ბაზის ტიპი',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-binary' => 'ორობითი',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'ვიკის სახელი:',
	'config-site-name-blank' => 'შეიყვანეთ ვებ-გვერდის სახელი.',
	'config-project-namespace' => 'პროექტის სახელთა სივრცე:',
	'config-ns-generic' => 'პროექტი',
	'config-ns-other' => 'სხვა (მიუთითეთ)',
	'config-ns-other-default' => 'ჩემი ვიკი',
	'config-admin-box' => 'ადმინისტრატორის ანგარიში',
	'config-admin-name' => 'თქვენი სახელი:',
	'config-admin-password' => 'პაროლი:',
	'config-admin-password-confirm' => 'პაროლი ხელმეორედ:',
	'config-admin-name-blank' => 'შეიყვანეთ ადმინისტრატორის მომხმარებლის სახელი.',
	'config-admin-email' => 'ელ. ფოსტის მისამართი:',
	'config-profile-wiki' => 'ტრადიციული ვიკი',
	'config-profile-private' => 'დახურული ვიკი',
	'config-license' => 'საავტორო უფლები და ლიცენზია:',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0' => 'Creative Commons Zero (საზოგადოებრივი საკუთრება)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 ან უფრო გვიანი',
	'config-license-pd' => 'საზოგადოებრივი საკუთრება',
	'config-license-cc-choose' => 'აირჩიეთ Creative Commons-ის ლიცენზიიდან ერთ-ერთი',
	'config-email-settings' => 'ელ. ფოსტის პარამეტრები',
	'config-upload-settings' => 'სურათებისა და ფაილების ატვირთვა',
	'config-upload-enable' => 'ფაილების ატვირთვის ჩართვა',
	'config-logo' => 'ლოგოს URL:',
	'config-cc-again' => 'აირჩიეთ კიდევ ერთხელ...',
	'config-extensions' => 'გაფართოებები',
	'config-install-step-done' => 'შესრულდა',
	'config-install-step-failed' => 'ვერ მოხერხდა',
	'config-install-tables' => 'ცხრილების შექმნა',
	'config-download-localsettings' => 'LocalSettings.php-ის გადმოწერა',
	'config-help' => 'დახმარება',
	'mainpagetext' => "'''მედიავიკი წარმატებით ჩაიტვირთა.'''",
	'mainpagedocfooter' => 'ვიკი პროგრამის გამოყენების ინფორმაციისთვის იხილეთ [//meta.wikimedia.org/wiki/Help:Contents მომხმარებლის მეგზური].

== დაწყება ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings კონფიგურაციის მაჩვენებლების სია]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce მედიავიკის გამოცემის დაგზავნის სია]',
);

/** Kara-Kalpak (Qaraqalpaqsha)
 */
$messages['kaa'] = array(
	'mainpagetext' => "'''MediaWiki tabıslı ornatıldı.'''",
	'mainpagedocfooter' => "Wiki bag'darlamasın qollanıw haqqındag'i mag'lıwmat usın [//meta.wikimedia.org/wiki/Help:Contents Paydalanıwshılar qollanbasınan] ken'es alın'.

== Baslaw ushın ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Konfiguratsiya sazlaw dizimi]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWikidin' Ko'p Soralatug'ın Sorawları]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki haqqında xat tarqatıw dizimi]",
);

/** Адыгэбзэ (Адыгэбзэ)
 * @author Bogups
 */
$messages['kbd-cyrl'] = array(
	'mainpagetext' => "'''«MediaWiki» узыншу хэгъува.'''",
	'mainpagedocfooter' => 'Мы виким и лэжьыгъэ хъыбархэр здэбгъуэтыфынур [//meta.wikimedia.org/wiki/%D0%9F%D0%BE%D0%BC%D0%BE%D1%89%D1%8C:%D0%A1%D0%BE%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D0%BD%D0%B8%D0%B5 дэӀэпыкъуэгъу тхылъым].


== Къыщхьэпэгъуэ хъуфынухэр ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Зэгъэзэхуэгъуэ гуэрэхэм я тхылъ];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-м упщӀэ нахъыбу ятхэмрэ я жэуапхэмрэ];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-м и версиэ щӀэуэ къэжахэм я къэӀохугъуэ].',
);

/** Khowar (کھوار)
 * @author Rachitrali
 */
$messages['khw'] = array(
	'mainpagetext' => "\"<big>'''میڈیاوکیو کامیابیو سورا چالو کورونو بیتی شیر۔.'''</big>\"",
);

/** Kirmanjki (Kırmancki)
 * @author Mirzali
 */
$messages['kiu'] = array(
	'mainpagetext' => "'''MediaWiki fist ra ser, vıraziya.'''",
	'mainpagedocfooter' => "Serba melumatê gurenaena ''wiki software''i [//meta.wikimedia.org/wiki/Help:Contents İdarê karberi] de mıracaet ke.

== Gamê verêni ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista ayarunê vırastene]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki de ÇZP]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki ra lista serbest-daena postey]",
);

/** Kazakh (Arabic script) (قازاقشا (تٴوتە)‏)
 */
$messages['kk-arab'] = array(
	'mainpagetext' => "'''مەدىياۋىيكىي بۋماسى ٴساتتى ورناتىلدى.'''",
	'mainpagedocfooter' => 'ۋىيكىي باعدارلامالىق جاساقتاماسىن قالاي قولداناتىن اقپاراتى ٴۇشىن [//meta.wikimedia.org/wiki/Help:Contents پايدالانۋشىلىق نۇسقاۋلارىنان] كەڭەس الىڭىز.

== باستاۋ ٴۇشىن ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings باپتالىم قالاۋلارىنىڭ ٴتىزىمى]
* [//www.mediawiki.org/wiki/Manual:FAQ مەدىياۋىيكىيدىڭ جىيى قويىلعان ساۋالدارى]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce مەدىياۋىيكىي شىعۋ تۋرالى حات تاراتۋ ٴتىزىمى]',
);

/** Kazakh (Cyrillic script) (қазақша (кирил)‎)
 */
$messages['kk-cyrl'] = array(
	'mainpagetext' => "'''МедиаУики бумасы сәтті орнатылды.'''",
	'mainpagedocfooter' => 'Уики бағдарламалық жасақтамасын қалай қолданатын ақпараты үшін [//meta.wikimedia.org/wiki/Help:Contents Пайдаланушылық нұсқауларынан] кеңес алыңыз.

== Бастау үшін ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Бапталым қалауларының тізімі]
* [//www.mediawiki.org/wiki/Manual:FAQ МедиаУикидің Жиы Қойылған Сауалдары]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce МедиаУики шығу туралы хат тарату тізімі]',
);

/** Kazakh (Latin script) (qazaqşa (latın)‎)
 */
$messages['kk-latn'] = array(
	'mainpagetext' => "'''MedïaWïkï bwması sätti ornatıldı.'''",
	'mainpagedocfooter' => 'Wïkï bağdarlamalıq jasaqtamasın qalaý qoldanatın aqparatı üşin [//meta.wikimedia.org/wiki/Help:Contents Paýdalanwşılıq nusqawlarınan] keñes alıñız.

== Bastaw üşin ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Baptalım qalawlarınıñ tizimi]
* [//www.mediawiki.org/wiki/Manual:FAQ MedïaWïkïdiñ Jïı Qoýılğan Sawaldarı]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MedïaWïkï şığw twralı xat taratw tizimi]',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'config-your-language' => 'ភាសារបស់អ្នក៖',
	'config-your-language-help' => 'ជ្រើសយកភាសាដើម្បីប្រើក្នុងពេលតំលើង។',
	'config-wiki-language' => 'ភាសាវិគី៖',
	'config-wiki-language-help' => 'ជ្រើសរើសភាសាដែលវិគីនេះប្រើជាចំបង។',
	'config-back' => '← ត្រលប់ក្រោយ',
	'config-continue' => 'បន្ត →',
	'config-page-language' => 'ភាសា',
	'config-page-welcome' => 'មេឌាវិគីសូមស្វាគមន៍!',
	'config-page-dbconnect' => 'ភ្ជាប់ទៅមូលដ្ឋានទិន្នន័យ',
	'config-page-name' => 'ឈ្មោះ',
	'config-page-options' => 'ជំរើស',
	'config-page-install' => 'តំលើង',
	'config-page-complete' => 'បញ្ចប់!',
	'config-page-restart' => 'តំលើងឡើងវិញ',
	'config-help' => 'ជំនួយ',
	'mainpagetext' => "'''មេឌាវិគីត្រូវបានដំឡើងសំរេចហើយ​។'''",
	'mainpagedocfooter' => 'សូមពិនិត្យមើល [//meta.wikimedia.org/wiki/ជំនួយ​៖ ខ្លឹមសារ​ណែនាំ​ប្រើប្រាស់]សម្រាប់​ព័ត៌មាន​​បន្ថែមចំពោះ​ការប្រើប្រាស់ ផ្នែកទន់វិគី​។

== ចាប់ផ្ដើមជាមួយមេឌាវិគី ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings បញ្ជីកំណត់ទម្រង់]
* [//www.mediawiki.org/wiki/Manual:FAQ/km សំណួរញឹកញាប់​មេឌាវិគី]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce បញ្ជី​ពិភាក្សា​ការផ្សព្វផ្សាយ​របស់​មេឌាវិគី]',
);

/** Kannada (ಕನ್ನಡ)
 */
$messages['kn'] = array(
	'mainpagetext' => "'''ವಿಕಿ ತಂತ್ರಾಂಶವನ್ನು ಯಶಸ್ವಿಯಾಗಿ ಅನುಸ್ಥಾಪಿಸಲಾಯಿತು.'''",
	'mainpagedocfooter' => 'ವಿಕಿ ತಂತ್ರಾಂಶವನ್ನು ಬಳಸುವ ಬಗ್ಗೆ ಮಾಹಿತಿಗೆ [//meta.wikimedia.org/wiki/Help:Contents ಬಳಕೆದಾರರಿಗೆ ನಿರ್ದೇಶನ ಪುಟ] ನೋಡಿ.

== ಪ್ರಾರಂಭಿಸುವುದು ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ ಮೀಡಿಯವಿಕಿ FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]',
);

/** Korean (한국어)
 * @author Kwj2772
 * @author 아라
 */
$messages['ko'] = array(
	'config-desc' => '미디어위키 설치 마법사',
	'config-title' => 'MediaWiki $1 설치',
	'config-information' => '정보',
	'config-localsettings-upgrade' => '<code>LocalSettings.php</code> 파일이 감지되었습니다.
이 설치를 업그레이드하려면 아래 상자에 <code>$wgUpgradeKey</code>의 값을 입력하세요.
LocalSettings.php에 찾으세요.',
	'config-localsettings-cli-upgrade' => 'LocalSettings.php 파일이 감지되었습니다.
이 설치를 업그레이드하려면 update.php를 대신 실행하세요',
	'config-localsettings-key' => '업그레이드 키:',
	'config-localsettings-badkey' => '제공한 키가 잘못되었습니다.',
	'config-upgrade-key-missing' => '미디어위키의 기존 설치가 감지되었습니다.
이 설치를 업그레이드하려면 LocalSettings.php의 아래에 다음 줄을 넣으세요:

$1',
	'config-localsettings-incomplete' => '기존 LocalSettings.php가 완전하지 않은 것 같습니다.
$1 변수가 설정되어 있지 않습니다.
이 변수가 설정되도록 LocalSettings.php를 바꾸고 "계속"을 클릭하세요.',
	'config-localsettings-connection-error' => 'LocalSettings.php 또는 AdminSettings.php에 지정한 설정을 사용하여 데이터베이스에 연결할 때 오류가 발생했습니다. 이러한 설정을 수정하고 다시 시도하세요.

$1',
	'config-session-error' => '세션 시작 오류: $1',
	'config-session-expired' => '세션 데이터가 만료된 것 같습니다.
세션은 $1의 작동 시간 동안 구성됩니다.
php.ini에 있는 <code>session.gc_maxlifetime</code>에서 설정해 이를 증가시킬 수 있습니다.
설치 과정을 다시 시작합니다.',
	'config-no-session' => '세션 데이터가 손실되었습니다!
php.ini를 확인하고 <code>session.save_path</code>가 적절한 디렉토리로 설정되어 있는지 확인하세요.',
	'config-your-language' => '설치 언어:',
	'config-your-language-help' => '설치 과정에서 사용할 언어를 선택하세요.',
	'config-wiki-language' => '위키 언어:',
	'config-wiki-language-help' => '주로 작성될 위키에 대한 언어를 선택하세요.',
	'config-back' => '← 뒤로',
	'config-continue' => '계속 →',
	'config-page-language' => '언어',
	'config-page-welcome' => '미디어위키에 오신 것을 환영합니다!',
	'config-page-dbconnect' => '데이터베이스에 연결',
	'config-page-upgrade' => '기존 설치 업그레이드',
	'config-page-dbsettings' => '데이터베이스 설정',
	'config-page-name' => '이름',
	'config-page-options' => '설정',
	'config-page-install' => '설치',
	'config-page-complete' => '완료!',
	'config-page-restart' => '설치 다시 시작',
	'config-page-readme' => '읽어보기',
	'config-page-releasenotes' => '배포 노트',
	'config-page-copying' => '전문',
	'config-page-upgradedoc' => '업그레이드하기',
	'config-page-existingwiki' => '기존 위키',
	'config-help-restart' => '당신이 입력한 모든 저장된 데이터를 지우고 설치 과정을 다시 시작하겠습니까?',
	'config-restart' => '예, 다시 시작합니다',
	'config-welcome' => '=== 사용 환경 검사 ===
이 환경이 미디어위키 설치에 적합한지 기본 검사를 실행합니다.
설치 중 도움이 필요하다면 이 검사 결과를 함께 제공해주어야 합니다.',
	'config-copyright' => "=== 저작권 및 이용 약관 ===

$1

이 프로그램은 자유 소프트웨어입니다. 당신은 자유 소프트웨어 재단이 발표한 GNU 일반 공중 사용 허가서 버전 2나 그 이후 버전에 따라 이 프로그램을 재배포하거나 수정할 수 있습니다.

이 프로그램이 유용하게 사용될 수 있기를 바라지만 '''상용으로 사용'''되거나 '''특정 목적에 맞을 것'''이라는 것을 '''보증하지 않습니다'''.
자세한 내용은 GNU 일반 공중 사용 허가서를 참고하십시오.

당신은 이 프로그램을 통해 <doclink href=Copying>GNU 일반 공중 사용 허가서 전문</doclink>을 받았습니다. 그렇지 않다면, Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA로 편지를 보내주시거나 [http://www.gnu.org/copyleft/gpl.html 온라인으로 읽어보시기] 바랍니다.",
	'config-sidebar' => '* [//www.mediawiki.org 미디어위키 홈]
* [//www.mediawiki.org/wiki/Help:Contents 사용자 가이드]
* [//www.mediawiki.org/wiki/Manual:Contents 관리자 가이드]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>읽어보기</doclink>
* <doclink href=ReleaseNotes>배포 노트</doclink>
* <doclink href=Copying>전문</doclink>
* <doclink href=UpgradeDoc>업그레이드하기</doclink>',
	'config-env-good' => '환경이 확인되었습니다.
미디어위키를 설치할 수 있습니다.',
	'config-env-bad' => '환경이 확인되었습니다.
미디어위키를 설치할 수 없습니다.',
	'config-env-php' => 'PHP $1(이)가 설치되었습니다.',
	'config-env-php-toolow' => 'PHP $1(이)가 설치되었습니다.
하지만 미디어위키는 PHP $2 이상이 필요합니다.',
	'config-unicode-using-utf8' => '유니코드 정규화에 대해 Brion Vibber의 utf8_normalize.so를 사용합니다.',
	'config-unicode-using-intl' => '유니코드 정규화에 대해 [http://pecl.php.net/intl intl PECL 확장]을 사용합니다.',
	'config-unicode-pure-php-warning' => "'''경고''': [http://pecl.php.net/intl intl PECL 확장]은 PHP만으로 구현하는 데에는 느려질 정도로 성능이 떨어지는 유니코드 정규화를 처리할 수 없습니다.
높은 트래픽의 사이트에서 실행하려면 [//www.mediawiki.org/wiki/Unicode_normalization_considerations 유니코드 정규화]에 대해 약간 참고해야 합니다.",
	'config-unicode-update-warning' => "'''경고''': 유니코드 정규화 래퍼의 설치된 버전은 [http://site.icu-project.org/ ICU 프로젝트]의 라이브러리의 이전 버전을 사용합니다.
만약 유니코드를 사용하는 것에 대해 우려가 된다면 [//www.mediawiki.org/wiki/Unicode_normalization_considerations 업그레이드]해야합니다.",
	'config-no-db' => '적절한 데이터베이스 드라이버를 찾을 수 없습니다! PHP에 데이터베이스 드라이버를 설치해야 합니다.
다음 데이터베이스 유형을 지원합니다 : $1.

호스팅을 공유하고 있다면 적절한 데이터베이스 드라이버를 설치하도록 호스팅 제공 업체에 문의하세요.
PHP를 직접 컴파일할 경우 데이터베이스 클라이언트를 사용하여 활성화하도록 다시 설정하세요. 예들 들어 <code>./configure --with-mysql</code>을 사용하세요.
데비안이나 우분트 패키지에서 PHP를 설치했다면 php-mysql 모듈도 설치해야 합니다.',
	'config-outdated-sqlite' => "'''경고''': SQLite 필요한 최소 $2 버전보다 낮은 $1(이)가 있습니다. SQLite는 사용할 수 없습니다.",
	'config-no-fts3' => "'''경고''': SQLite는 [//sqlite.org/fts3.html FTS3 모듈] 없이 컴파일되어, 검색 기능은 백엔드에 사용할 수 없습니다.",
	'config-register-globals' => "'''경고: PHP의 <code>[http://php.net/register_globals register_globals]</code> 옵션이 활성화되어 있습니다.'''
'''가능하면 이를 비활성화하십시오.'''
미디어위키는 작동하지만 서버에 잠재적인 보안 취약점에 노출됩니다.",
	'config-magic-quotes-runtime' => "'''치명: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]이 활성합니다!'''
이 옵션은 데이터를 입력하는 데 예기치 않는 손상이 일어납니다.
설치할 수 없습니다. 또는 미디어위키가 사용하지 않는 이 옵션을 비활성화하십시오.",
	'config-magic-quotes-sybase' => "'''치명: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase]이 활성합니다!'''
이 옵션은 데이터를 입력하는 데 예기치 않는 손상이 일어납니다.
설치할 수 없습니다. 또는 미디어위키가 사용하지 않는 이 옵션을 비활성화하십시오.",
	'config-mbstring' => "'''치명: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]이 활성합니다!'''
이 옵션은 오류가 발생하고 데이터를 입력하는 데 예기치 않는 손상이 일어날 수 있습니다.
설치할 수 없습니다. 또는 미디어위키가 사용하지 않는 이 옵션을 비활성화하십시오.",
	'config-ze1' => "'''치명: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode]이 활성합니다!'''
이 옵션은 미디어위키에 끔찍한 버그를 일으킵니다.
설치할 수 없습니다. 또는 미디어위키가 사용하지 않는 이 옵션을 비활성화하십시오.",
	'config-safe-mode' => "'''경고:''' [http://www.php.net/features.safe-mode 안전 모드]이 활성합니다!
이는 특히 파일을 올리거나 <code>math</code>를 지원하는 데 문제가 발생할 수 있습니다.",
	'config-xml-bad' => 'PHP의 XML 모듈이 없습니다.
미디어위키는 이 모듈의 기능이 필요하며 이 설정에서는 작동하지 않습니다.
Mandrake를 실행하고 있다면 php-xml 패키지를 설치하세요.',
	'config-pcre' => 'PCRE 지원 모듈이 없는 것 같습니다.
미디어위키는 Perl 호환 정규 표현식을 작동시켜야 합니다.',
	'config-pcre-no-utf8' => "'''치명''': PHP의 PCRE 모듈은 RCRE_UTF8 지원 없이 컴파일된 것 같습니다.
미디어위키가 제대로 작동하려면 UTF-8 지원이 필요합니다.",
	'config-memory-raised' => 'PHP의 <code>memory_limit</code>는 $1이며 $2(으)로 늘리세요.',
	'config-memory-bad' => "'''경고:''' PHP의 <code>memory_limit</code>는 $1입니다.
이는 아마도 너무 낮은 것 같습니다.
설치가 실패할 수 있습니다!",
	'config-ctype' => "'''치명''': PHP는 [http://www.php.net/manual/en/ctype.installation.php Ctype 확장 기능]에 대해 지원하여 컴파일해야 합니다.",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache]가 설치되었습니다',
	'config-apc' => '[http://www.php.net/apc APC]가 설치되었습니다',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache]가 설치되었습니다',
	'config-no-cache' => "'''경고:''' [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] 또는 [http://www.iis.net/download/WinCacheForPhp WinCache]를 찾을 수 없습니다.
개체 캐싱이 활성화되지 않습니다.",
	'config-mod-security' => "'''경고''': 웹 서버에 [http://modsecurity.org/ mod_security]가 허용되었습니다. 잘못 설정된 경우 미디어위키나 사용자가 임의의 콘텐츠를 게시할 수 있는 다른 소프트웨어에 대한 문제를 일으킬 수 있습니다.
[http://modsecurity.org/documentation/ mod_security] 문서를 참고하거나 임의의 오류가 발생할 경우 호스트의 지원 요청에 문의하십시오.",
	'config-diff3-bad' => 'GNU diff3를 찾을 수 없습니다.',
	'config-imagemagick' => 'ImageMagick를 찾았습니다: <code>$1</code>.
올리기를 활성화할 경우 그림 섬네일이 활성화될 것입니다.',
	'config-gd' => '내장된 GD 그래픽 라이브러리를 찾았습니다.
올리기를 활성화할 경우 그림 섬네일이 활성화될 것입니다.',
	'config-no-scaling' => 'GD 라이브러리나 ImageMagick를 찾을 수 없습니다.
그림 섬네일이 비활성화될 것입니다.',
	'config-no-uri' => "'''오류:''' 현재 URI를 확인할 수 없습니다.
설치가 중단되었습니다.",
	'config-no-cli-uri' => "'''경고''': 기본값을 사용하여 --scriptpath를 지정하지 않았습니다: <code>$1</code>.",
	'config-using-server' => '"<nowiki>$1</nowiki>"(을)를 서버 이름으로 사용합니다.',
	'config-using-uri' => '"<nowiki>$1$2</nowiki>"(을)를 서버 URL로 사용합니다.',
	'config-uploads-not-safe' => "'''경고:''' 올리기에 대한 기본 디렉토리(<code>$1</code>)는 임의의 스크립트 실행에 취약합니다.
미디어위키는 보안 위협에 대한 모든 올린 파일을 검사하지만, 이는 올리기를 활성화하기 전에 [//www.mediawiki.org/wiki/Manual:Security#Upload_security 이 보안 취약점을 해결할 것]을 매우 권장합니다.",
	'config-no-cli-uploads-check' => "'''경고:''' 올리기에 대한 기본 디렉토리(<code>$1</code>)는 CLI를 설치하는 동안 임의의 스크립트 실행에 대한 취약점에 대해 검사되지 않습니다.",
	'config-brokenlibxml' => '시스템에 버그가 있는 PHP와 libxml2의 조합이 있으며 미디어위키나 다른 웹 어플리케이션에 숨겨진 데이터 손상을 일으킬 수 있습니다.
PHP 5.2.9 이후와 libxml2 2.7.3 이후로 업그레이드하세요 ([//bugs.php.net/bug.php?id=45996 PHP에 제기한 버그]).
설치가 중단되었습니다.',
	'config-using531' => '미디어위키는 <code>__call()</code>을 참고로 매개 변수를 포함하는 버그로 인해 PHP $1(와)과 함께 사용할 수 없습니다.
문제를 해결하려면 PHP 5.3.2 이상로 업그레이드하거나 PHP 5.3.0으로 다운그레이드를 하세요.
설치가 중단되었습니다.',
	'config-suhosin-max-value-length' => 'Suhosin(수호신)이 설치되었고 $1 바이트로 GET 매개 변수 길이를 제한하고 있습니다. 미디어위키의 ResourceLoader 구성 요소는 이 제한을 해결하지만 성능이 저하됩니다. 가능하면 php.ini의 suhosin.get.max_value_length에 1024 이상으로 설정하고 LocalSettings.php의 $wgResourceLoaderMaxQueryLength에 같은 값을 설정해야 합니다.',
	'config-db-type' => '데이터베이스 종류:',
	'config-db-host' => '데이터베이스 호스트:',
	'config-db-host-help' => '데이터베이스 서버가 다른 서버에 있을 경우 여기에 호스트 이름이나 IP 주소를 입력하세요.

웹 호스팅을 공유하여 사용하는 경우 호스팅 공급자는 당신에게 이들 설명서의 올바른 호스트 이름을 표기해야 합니다.

윈도 서버에 설치하고 MySQL을 사용할 경우 "localhost"는 서버 이름으로 작동하지 않을 수 있습니다. 그렇지 않으면 로컬 IP 주소로 "127.0.0.1"를 시도하세요.

PostgreSQL을 사용할 경우 유닉스 소켓을 통해 연결되도록 입력란을 비워두세요.',
	'config-db-host-oracle' => '데이터베이스 TNS:',
	'config-db-host-oracle-help' => '유효한 [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm 로컬 연결 이름]을 입력하세요. tnsnames.ora 파일이 이 설치에 보여야 합니다.<br />10g 이후의 클라이언트 라이브러리를 사용하는 경우 [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm 쉬운 연결] 네이밍 메소드도 사용할 수 있습니다.',
	'config-db-wiki-settings' => '이 위키 식별',
	'config-db-name' => '데이터베이스 이름:',
	'config-db-name-help' => '위키를 식별하기 위한 이름을 선택하세요.
이는 공백이 없어야 합니다.

웹 호스팅을 공유해 사용하는 경우 호스팅 제공 업체도 당신에게 제어판을 통해 데이터베이스를 사용하거나 만들 수 있도록 특정 데이터베이스 이름을 제공합니다.',
	'config-db-name-oracle' => '데이터베이스 스키마:',
	'config-db-account-oracle-warn' => '데이터베이스 백엔드로 오라클을 설치하기 위해 지원하는 세 가지 시나리오가 있습니다:

설치 과정의 일부로 데이터베이스 계정을 만들려면 설치를 위해 데이터베이스 계정으로 SYSDBA 역할을 가진 계정을 제공하고 웹 접근 계정에 대해 원하는 자격 증명을 지정하세요, 그렇지 않으면 수동으로 웹 접근 계정을 만들 수 있으며 (필요한 경우 권한 스키마 개체를 만들어야 합니다) 또는 다른 계정 두 개를 만들고 권한을 가진 하나의 웹 접근을 위한 제한된 하나를 제공할 수 있습니다.

필요한 권한을 가진 계정을 만드는 스크립트는 이 설치의 "maintenance/oracle/" 디렉토리에서 찾을 수 있습니다. 제한된 계정을 사용하면 기본 계정으로 모든 관리 기능을 비활성화할 것을 염두해 두십시오.',
	'config-db-install-account' => '설치를 위한 사용자 계정',
	'config-db-username' => '데이터베이스 사용자 이름:',
	'config-db-password' => '데이터베이스 비밀번호:',
	'config-db-password-empty' => '새 데이터베이스 사용자의 비밀번호를 입력하세요: $1.
비밀번호 없이 사용자를 만들 수도 있지만 이는 안전하지 않습니다.',
	'config-db-install-username' => '설치 과정 중에 데이터베이스에 연결할 때 사용할 사용자 이름을 입력하세요.
이는 미디어위키 계정의 사용자 이름이 아닌 데이터베이스에 대한 사용자 이름입니다.',
	'config-db-install-password' => '설치 과정 중에 데이터베이스에 연결할 때 사용할 비밀번호을 입력하세요. 이는 미디어위키 계정의 비밀번호가 아닌 데이터베이스에 대한 비밀번호입니다.',
	'config-db-install-help' => '설치 과정 중에 데이터베이스에 연결할 때 사용할 사용자 이름과 비밀번호를 입력하세요.',
	'config-db-account-lock' => '정상적으로 작동하는 동안 같은 사용자 이름과 비밀번호를 사용함',
	'config-db-wiki-account' => '정상적인 작동을 위한 사용자 계정',
	'config-db-wiki-help' => '정상적인 위키 작업 동안 데이터베이스에 연결하는 데 사용할 사용자 이름과 비밀 번호를 입력하세요.
계정이 존재하지 않고 설치 계정에 충분한 권한이 있는 경우 이 사용자 계정은 위키를 작동하는 데 필요한 최소 권한으로 만들어집니다.',
	'config-db-prefix' => '데이터베이스 테이블 접두어:',
	'config-db-prefix-help' => '여러 위키 사이 또는 미디어위키와 다른 웹 응용 프로그램 사이에서 하나의 데이터베이스를 공유해야 하는 경우, 충돌을 피하기 위해 모든 테이블 이름에 접두어를 추가하도록 선택할 수 있습니다.
공백을 사용하지 마세요.

이 필드는 일반적으로 비어있습니다.',
	'config-db-charset' => '데이터베이스 문자 집합',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 바이너리',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 UTF-8 하위 호환성',
	'config-charset-help' => "'''경고:''' MySQL 4.1에서 '''UTF-8 하위 호환성'''을 사용하고 나서 <code>mysqldump</code>로 데이터베이스에 백업한다면 이는 모든 ASCII가 아닌 문자를 파괴하고 손상한 백업을 되돌릴 수 없습니다!

'''바이너리 모드'''에서는 미디어위키는 바이너리 필드의 데이터베이스에 UTF-8 텍스트를 저장합니다.
이는 MySQL의 UTF-8 모드를 보다 더 효율적이고 유니코드 문자의 전체 범위를 사용할 수 있습니다.
'''UTF-8 모드'''에서는 MySQL은 데이터를 설정하는 어떤 문자열인지를 알 것이며, 표현하고 적절하게 그것을 변환할 수 있지만
[//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes 기본 다국어 범위] 상의 문자를 저장하지 못하게 될 수 있습니다.",
	'config-mysql-old' => 'MySQL $1 이상이 필요하나 $2(이)가 있습니다.',
	'config-db-port' => '데이터베이스 포트:',
	'config-db-schema' => '미디어위키에 대한 스키마:',
	'config-db-schema-help' => '이 스키마는 보통 괜찮습니다.
필요로 알고 있을 경우에만 이를 바꾸세요.',
	'config-pg-test-error' => "'''$1''' 데이터베이스에 연결할 수 없습니다: $2",
	'config-sqlite-dir' => 'SQLite 데이터 디렉토리:',
	'config-sqlite-dir-help' => 'SQLite는 하나의 파일에 모든 데이터를 저장합니다.

제공하는 디렉토리는 설치하는 동안 웹 서버에 의해 쓸 수 있어야 합니다.

PHP 파일이 있는 곳을 우리가 이를 맡길 수 없는 이유는 웹을 통해 접근할 수 없다는 것입니다.

설치 마법사가 이과 함께 .htaccess 파일을 만들지만 거기서 실패하면 누군가는 원본 데이터베이스에 접근하는 데 실패합니다.
이는 원시 사용자 데이터(이메일 주소, 암호 해시) 뿐만 아니라 삭제된 개정판과 위키의 다른 제한된 데이터를 포함합니다.

<code>/var/lib/mediawiki/yourwiki</code>와 같이 모두 다른 곳에서 데이터베이스를 넣어보도록 하세요.',
	'config-oracle-def-ts' => '기본 테이블공간:',
	'config-oracle-temp-ts' => '임시 테이블공간:',
	'config-type-oracle' => '오라클',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => '미디어위키는 다음의 데이터베이스 시스템을 지원합니다:

$1

데이터베이스 시스템이 표시되지 않을 때 아래에 나열된 다음 지원을 활성화하려면 당신은 위의 링크된 지시에 따라 사용해볼 수도 있습니다.',
	'config-support-mysql' => '* $1은 미디어위키의 기본 대상으로 가장 잘 지원합니다. ([http://www.php.net/manual/en/mysql.installation.php MySQL을 지원하여 PHP를 컴파일하는 방법])',
	'config-support-postgres' => '* $1은 MySQL의 대안으로 인기있는 오픈 소스 데이터베이스 시스템입니다. ([http://www.php.net/manual/en/pgsql.installation.php PostgreSQL을 지원하여 PHP를 컴파일하는 방법]) 몇가지 사소한 해결하지 못한 버그가 있을 수 있으며, 이를 제작 환경에서 사용하지 않는 것이 좋습니다.',
	'config-support-sqlite' => '* $1는 매우 잘 지원하는 가벼운 데이터베이스 시스템입니다. ([http://www.php.net/manual/en/pdo.installation.php SQLite를 지원하여 PHP를 컴파일하는 방법], PDO 사용)',
	'config-support-oracle' => '* $1은 상용 엔터프라이스 데이터베이스입니다. ([http://www.php.net/manual/en/oci8.installation.php OCI8을 지원하여 PHP를 컴파일하는 방법])',
	'config-support-ibm_db2' => '* $1는 상용 엔터프라이즈 데이터베이스입니다.',
	'config-header-mysql' => 'MySQL 설정',
	'config-header-postgres' => 'PostgreSQL 설정',
	'config-header-sqlite' => 'SQLite 설정',
	'config-header-oracle' => '오라클 설정',
	'config-header-ibm_db2' => 'IBM DB2 설정',
	'config-invalid-db-type' => '잘못된 데이터베이스 종류',
	'config-missing-db-name' => '"데이터베이스 이름"에 대한 값을 입력해야 합니다',
	'config-missing-db-host' => '"데이터베이스 호스트"에 대한 값을 입력해야 합니다',
	'config-missing-db-server-oracle' => '"데이터베이스 TNS"에 대한 값을 입력해야 합니다',
	'config-invalid-db-server-oracle' => '"$1" 데이터베이스 TNS가 잘못됐습니다.
ASCII 글자 (a-z, A-Z), 숫자 (0-9), 밑줄 (_)과 하이픈 (-)만 사용하세요.',
	'config-invalid-db-name' => '"$1" 데이터베이스 이름이 잘못되었습니다.
ASCII 글자 (a-z, A-Z), 숫자 (0-9), 밑줄 (_)과 하이픈 (-)만 사용하세요.',
	'config-invalid-db-prefix' => '"$1" 데이터베이스 접두어가 잘못됐습니다.
ASCII 글자 (a-z, A-Z), 숫자 (0-9), 밑줄 (_)과 하이픈 (-)만 사용하세요.',
	'config-connection-error' => '$1.

호스트, 계정 이름과 비밀번호를 확인하고 다시 시도하세요.',
	'config-invalid-schema' => '미디어위키 "$1"에 대한 스키마가 잘못됐습니다.
ASCII 글자 (a-z, A-Z), 숫자 (0-9), 밑줄 (_)과 하이픈 (-)만 사용하세요.',
	'config-db-sys-create-oracle' => '설치 마법사는 새 계정을 만들기 위한 SYSDBA 계정만을 지원합니다.',
	'config-db-sys-user-exists-oracle' => '"$1" 사용자 계정이 이미 존재합니다. SYSDBA는 새 계정을 만드는 데에만 사용할 수 있습니다!',
	'config-postgres-old' => 'PostgreSQL $1 이상이 필요하나 $2(이)가 있습니다.',
	'config-sqlite-name-help' => '위키를 식별하기 위한 이름을 선택하세요.
공백이나 하이픈을 사용하지 마십시오.
이는 SQLite 데이터 파일 이름에 사용됩니다.',
	'config-sqlite-parent-unwritable-group' => '<code><nowiki>$1</nowiki></code> 데이터 디렉토리를 만들 수 없으며 <code><nowiki>$2</nowiki></code> 상위 디렉토리에 웹 서버에 의해 쓸 수 없기 때문입니다.

설치 마법사는 웹 서버로 실행중인 사용자를 결정할 수 없습니다.
계속하려면 이를 쓸 수 있는 <code><nowiki>$3</nowiki></code> 디렉토리를 만드세요.
유닉스/리눅스 시스템에서의 수행:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => '<code><nowiki>$1</nowiki></code> 데이터 디렉토리를 만들 수 없으며 <code><nowiki>$2</nowiki></code> 상위 디렉토리에 웹 서버에 의해 쓸 수 없기 때문입니다.

설치 마법사는 웹 서버로 실행중인 사용자를 결정할 수 없습니다.
계속하려면 이(와 기타!)를 전역으로 쓸 수 있는 <code><nowiki>$3</nowiki></code> 디렉토리를 만드세요.
유닉스/리눅스 시스템에서의 수행:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => '"$1" 데이터 디렉토리를 만드는 중 오류났습니다.
경로를 확인하고 다시 시도하세요.',
	'config-sqlite-dir-unwritable' => '"$1" 디렉토리에 쓸 수 없습니다.
웹 서버를 쓸 수 있도록 권한을 바꾸고 다시 시도하세요.',
	'config-sqlite-connection-error' => '$1.

호스트, 계정 이름과 비밀번호를 확인하고 다시 시도하세요.',
	'config-sqlite-readonly' => '<code>$1</code> 파일은 쓰기가 불가능합니다.',
	'config-sqlite-cant-create-db' => '<code>$1</code> 데이터베이스 파일을 만들 수 없습니다.',
	'config-sqlite-fts3-downgrade' => 'PHP가 FTS3 지원이 없어졌습니다. 테이블을 다운그레이드하세요.',
	'config-can-upgrade' => "이 데이터베이스에 미디어위키 테이블이 있습니다.
미디어위키 $1(으)로 업그레이드하려면 '''계속'''을 클릭하세요.",
	'config-upgrade-done' => "업그레이드가 완료되었습니다.

이제 [$1 위키를 시작]할 수 있습니다.

만약 <code>LocalSettings.php</code> 파일을 다시 만들기를 원하면 아래의 버튼을 클릭하세요.
이것은 위키에 문제가 있지 않는 한 '''권장하지 않습니다'''.",
	'config-upgrade-done-no-regenerate' => '업그레이드가 완료되었습니다.

이제 [$1 위키를 시작]할 수 있습니다.',
	'config-regenerate' => 'LocalSettings.php 다시 만들기 →',
	'config-show-table-status' => 'SHOW TABLE STATUS 쿼리 실패!',
	'config-unknown-collation' => "'''경고:''' 데이터베이스가 인식하지 않는 정렬을 사용하고 있습니다.",
	'config-db-web-account' => '웹 접근을 위한 데이터베이스 계정',
	'config-db-web-help' => '위키의 일반적인 작업 중에 데이터베이스 서버에 연결하는 데 사용할 웹 서버에 대한 계정 이름과 비밀번호를 선택하세요.',
	'config-db-web-account-same' => '설치를 위해 같은 계정 사용',
	'config-db-web-create' => '이 계정이 아직 존재하지 않을 경우 계정 만들기',
	'config-db-web-no-create-privs' => '설치를 위해 지정한 계정은 계정을 만들 수 있는 충분한 권한이 없습니다.
여기서 지정한 계정은 이미 존재해야 합니다.',
	'config-mysql-engine' => '스토리지 엔진:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''경고''': 미디어위키와 함께 사용하도록 권장하지 않는 MySQL에 대한 스토리지 엔진으로 MyISAM을 선택하였습니다. 이유는:
* 이는 테이블이 잠겨있어 동시성을 거의 지원하지 않습니다
* 이는 다른 엔진보다 손상이 더 자주 발생합니다
* 미디어위키 바탕 코드가 항상 정상적으로 MyISAM을 처리하지 않습니다

MySQL 설치가 InnoDB를 지원한다면 그 선택 대신에 InnoDB를 선택할 것을 매우 권장합니다.
MySQL 설치가 InnoDB를 지원하지 않는다면 아마도 업그레이드를 해야 할 수도 있습니다.",
	'config-mysql-engine-help' => "'''InnoDB'''는 동시적인 지원에 좋기 때문에 거의 항상 최고의 옵션입니다.

'''MyISAM'''은 단일 사용자 또는 읽기 전용 설치에 빠를 수 있습니다.
MyISAM 데이터베이스는 InnoDB 데이터베이스보다 더 자주 손실될 수 있습니다.",
	'config-mysql-charset' => '데이터베이스 문자 집합:',
	'config-mysql-binary' => '바이너리',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "'''바이너리 모드'''에서는 미디어위키는 바이너리 필드의 데이터베이스에 UTF-8 텍스트를 저장합니다.
이는 MySQL의 UTF-8 모드를 보다 더 효율적이고 유니코드 문자의 전체 범위를 사용할 수 있습니다.
'''UTF-8 모드'''에서는 MySQL은 데이터를 설정하는 어떤 문자열인지를 알 것이며, 표현하고 적절하게 그것을 변환할 수 있지만
[//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes 기본 다국어 범위] 상의 문자를 저장하지 못하게 될 수 있습니다.",
	'config-ibm_db2-low-db-pagesize' => "당신의 DB2 데이터베이스에 부족한 페이지 크기가 기본 테이블 공간에 있습니다. 페이지 크기는 '''32K''' 이상이어야 합니다.",
	'config-site-name' => '위키 이름:',
	'config-site-name-help' => '이는 브라우저 제목 표시줄과 다른 여러 곳에 나타날 것입니다.',
	'config-site-name-blank' => '사이트 이름을 입력하세요.',
	'config-project-namespace' => '프로젝트 이름공간:',
	'config-ns-generic' => '프로젝트',
	'config-ns-site-name' => '위키 이름과 같은 이름: $1',
	'config-ns-other' => '기타 (지정)',
	'config-ns-other-default' => '내위키',
	'config-project-namespace-help' => '위키백과의 예를 따라서, 많은 위키는 "\'\'\'프로젝트 이름공간\'\'\'"에 그들의 콘텐츠 페이지에서 그들의 정책 페이지는 별도로 보관합니다.
이 이름공간에 있는 모든 페이지의 제목은 여기서 지정할 수 있는 특정 접두어로 시작합니다.
보통 이 접두어는 위키의 이름에서 파생되지만, 이는 "#" 또는 ":"와 같은 특수 문자를 포함할 수 없습니다.',
	'config-ns-invalid' => '특정 "<nowiki>$1</nowiki>" 이름공간이 잘못되었습니다.
다른 프로젝트 이름공간을 지정하세요.',
	'config-ns-conflict' => '특정 "<nowiki>$1</nowiki>" 이름공간이 기본 미디어위키 이름공간과 충돌합니다.
다른 프로젝트 이름공간을 지정하세요.',
	'config-admin-box' => '관리자 계정',
	'config-admin-name' => '사용자 이름:',
	'config-admin-password' => '비밀번호:',
	'config-admin-password-confirm' => '비밀번호 확인:',
	'config-admin-help' => '"홍길동"과 같이 여기에 원하는 사용자 이름을 입력하세요.
이는 위키에 로그인하는 데 사용되는 이름입니다.',
	'config-admin-name-blank' => '관리자의 사용자 이름을 입력하세요.',
	'config-admin-name-invalid' => '특정 "<nowiki>$1</nowiki>" 사용자 이름이 잘못되었습니다.
다른 사용자 이름을 지정하세요.',
	'config-admin-password-blank' => '관리자 계정의 비밀번호를 입력하세요.',
	'config-admin-password-same' => '비밀번호는 사용자 이름과 같아서는 안 됩니다.',
	'config-admin-password-mismatch' => '입력한 비밀번호 두 개가 일치하지 않습니다.',
	'config-admin-email' => '이메일 주소:',
	'config-admin-email-help' => '위키의 다른 사용자로부터 이메일을 전달받거나 비밀번호를 재설정하고 주시문서 목록에 대한 바뀜 알림을 받기 위해 여기에 이메일 주소를 입력하세요. 이 필드를 비워 둘 수 있습니다.',
	'config-admin-error-user' => '"<nowiki>$1</nowiki>" 이름의 관리자를 만드는 중 내부 오류가 발생했습니다.',
	'config-admin-error-password' => '"<nowiki>$1</nowiki>" 관리자의 비밀번호를 설정하는 중 내부 오류가 발생했습니다: <pre>$2</pre>',
	'config-admin-error-bademail' => '이메일 주소를 잘못 입력하였습니다.',
	'config-subscribe' => '[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce 배포 발표 메일링 리스트]에 가입합니다.',
	'config-subscribe-help' => '이는 중요한 보안 알림을 포함한 배포 알림에 대해 사용되는 로우 볼륨 메일링 리스트입니다.
당신이 이를 구독하고 나서 새 버전이 나올 때 미디어위키 설치를 업데이트해야합니다.',
	'config-subscribe-noemail' => '이메일 주소를 제공하지 않고 배포 발표 메일링 리스트에 가입하려 합니다.
메일링 리스트에 가입하고자 할 경우 이메일 주소를 제공하세요.',
	'config-almost-done' => '거의 다 완료했습니다!
이제 남은 설정을 생략하고 지금 바로 위키를 설치할 수 있습니다.',
	'config-optional-continue' => '더 많은 질문을 물어보세요.',
	'config-optional-skip' => '지겨워요, 그냥 위키를 설치할래요.',
	'config-profile' => '사용자 권한 프로필:',
	'config-profile-wiki' => '평범한 위키',
	'config-profile-no-anon' => '계정 만들기 필요',
	'config-profile-fishbowl' => '승인된 편집자만 이용 가능',
	'config-profile-private' => '비공개 위키',
	'config-profile-help' => "위키는 당신이 가능한 한 많은 사람들이 편집하도록 할 때 최고로 적합합니다.
미디어위키에서는 최근 바뀜을 검토하고, 선하거나 악의적인 사용자에 의해 수행되는 모든 손실을 되돌리는 것이 쉽습니다.

그러나 많은 사람들이 미디어위키가 다양한 역할의 유용하지만, 때로는 그것이 위키 방식의 장점을 모두 설득하기 쉽지 않음을 발견했습니다.
그래서 선택할 수 있습니다.

'''{{int:config-profile-wiki}}'''는 로그인하지 않고도 누구나 편집할 수 있습니다.
'''{{int:config-profile-no-anon}}'''는 추가적으로 필요한 책임을 제공하지만, 기존의 기여자를 망칠 수도 있습니다.

'''{{int:config-profile-fishbowl}}''' 같은 경우는 승인된 사용자만 편집할 수 있지만, 대중은 역사를 포함하여 페이지를 볼 수 있습니다. '''{{int:config-profile-private}}'''는 승인된 사용자만 같은 그룹에서 편집할 수 있고 볼 수 있습니다.

더 복잡한 사용자 권한을 설정하여 설치한 후 사용할 수 있도록 하려면 [//www.mediawiki.org/wiki/Manual:User_rights 관련 매뉴얼 항목]을 참고하세요.",
	'config-license' => '저작권 및 라이선스:',
	'config-license-none' => '라이선스 바닥글 없음',
	'config-license-cc-by-sa' => '크리에이티브 커먼즈 저작자표시-동일조건변경허락',
	'config-license-cc-by' => '크리에이티브 커먼즈 저작자표시',
	'config-license-cc-by-nc-sa' => '크리에이티브 커먼즈 저작자표시-비영리-동일조건변경허락',
	'config-license-cc-0' => '크리에이티브 커먼즈 제로 (퍼블릭 도메인)',
	'config-license-gfdl' => 'GNU 자유 문서 사용 허가서 1.3 이상',
	'config-license-pd' => '퍼블릭 도메인',
	'config-license-cc-choose' => '다른 크리에이티브 커먼즈 라이선스 선택',
	'config-license-help' => '많은 공개 위키는 모든 기여를 [http://freedomdefined.org/Definition 자유 라이선스] 하에 넣습니다.
이럴 경우 커뮤니티 소유권의 이해를 할 수 있도록 하고 장기적인 기여를 장려합니다.
이는 일반적으로 개인 또는 회사 위키에 대해서는 필요하지 않습니다.

위키백과의 텍스트를 사용할 수 있도록 하고 위키백과가 위키에서 복사한 텍스트를 사용할 수 있도록 원한다면 크리에이티브 커먼즈 저작자표시-동일조건변경허락으로 선택해야 합니다.

위키백과는 이전에 GNU 자유 문서 사용 허가서를 사용했습니다.
GFDL은 유효한 라이선스이지만 이는 이해하기 어렵습니다.
이는 GFDL 하에 라이선스 내용을 재사용하는 것도 어렵습니다.',
	'config-email-settings' => '이메일 설정',
	'config-enable-email' => '발신 이메일 활성화',
	'config-enable-email-help' => '이메일을 작동하려면 [http://www.php.net/manual/en/mail.configuration.php PHP의 메일 설정]을 올바르게 설정해야 합니다.
이메일 기능을 사용하지 않으려면 이를 비활성화할 수 있습니다.',
	'config-email-user' => '사용자와 사용자 간 이메일 활성화',
	'config-email-user-help' => '환경 설정에서 활성화한 경우 모든 사용자가 이메일을 서로 보내도록 활성화합니다.',
	'config-email-usertalk' => '사용자 토론 문서 알림 활성화',
	'config-email-usertalk-help' => '환경 설정에서 활성화한 경우 사용자는 사용자 토론 문서의 바뀜 알림을 받도록 활성화합니다.',
	'config-email-watchlist' => '주시문서 목록 알림 활성화',
	'config-email-watchlist-help' => '환경 설정에서 활성화한 경우 사용자가 주시한 문서에 대한 알림을 받도록 활성화합니다.',
	'config-email-auth' => '이메일 인증 활성화',
	'config-email-auth-help' => "이 설정이 활성화되어 있으면 사용자는 이메일 주소를 설정하거나 바꿀 때마다 그들에게 보낸 링크를 사용하여 이메일 주소를 확인해야 합니다.
인증된 이메일 주소만 다른 사용자로부터의 이메일이나 바뀜 알림 이메일을 받을 수 있습니다.
이메일 기능의 남용 가능성이 있기 때문에 이 옵션을 설정하는 것은 공개 위키에서 '''권장'''합니다.",
	'config-email-sender' => '반송 이메일 주소',
	'config-email-sender-help' => '발신한 이메일에 대한 반송 주소로 사용할 이메일 주소를 입력하세요.
이는 반송할 때 보내는 주소입니다.
대부분의 메일 서버는 적어도 도메인 이름 부분은 유효합니다.',
	'config-upload-settings' => '그림과 파일 올리기',
	'config-upload-enable' => '파일 올리기 활성화',
	'config-upload-help' => '파일 올리기는 서버에 잠재적인 보안 위험에 쉽게 노출될 수 있습니다.
자세한 내용은 매뉴얼의 [//www.mediawiki.org/wiki/Manual:Security 보안 문단]을 읽어보세요.

파일 올리기를 활성화하려면 미디어위키의 루트 디렉토리에 있는 <code>images</code> 하위 디렉토리에서 웹 서버가 기록할 수 있도록 모드를 바꿉니다.
그 다음 이 옵션을 활성화합니다.',
	'config-upload-deleted' => '삭제된 파일에 대한 디렉토리:',
	'config-upload-deleted-help' => '삭제된 파일을 보관할 디렉토리를 선택하세요.
이상적으로 웹에서 접근할 수 없게 해야 합니다.',
	'config-logo' => '로고 URL:',
	'config-logo-help' => '미디어위키 기본 스킨은 사이드바 메뉴 위에 135×160픽셀의 로고를 포함하고 있습니다.
적당한 크기로 이미지를 올리고 URL을 여기에 입력하세요.

로고 사용을 원하지 않으면 이 상자를 비워 두십시오.',
	'config-instantcommons' => '인스턴트 공용 활성화',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons 인스턴트 공용]은 [//commons.wikimedia.org/ 위키미디어 공용] 사이트에서 찾을 수 있는 그림, 소리 및 다른 미디어를 위키에서 사용할 수 있도록 하는 기능입니다.
이렇게 하려면 미디어위키가 인터넷에 접근해야합니다.

위키미디어 공용 외에 기타 위키를 설정하는 방법에 대한 지침을 포함한 기능에 대한 자세한 내용은 [//mediawiki.org/wiki/Manual:$wgForeignFileRepos 매뉴얼]을 참고하세요.',
	'config-cc-error' => '크리에이티브 커먼즈 라이선스 선택기에 결과가 없습니다.
수동으로 라이선스 이름을 입력하세요.',
	'config-cc-again' => '다시 선택...',
	'config-cc-not-chosen' => '원하는 크리에이티브 커먼즈 라이선스를 선택하고 "진행"을 클릭하세요.',
	'config-advanced-settings' => '고급 설정',
	'config-cache-options' => '개체 캐싱을 위한 설정:',
	'config-cache-help' => '개체 캐싱은 자주 사용하는 데이터를 캐싱하여 미디어위키의 속도를 개선하는 데 사용합니다.
큰 사이트의 규모에는 이를 많이 사용하도록 권장하고 있으며, 소규모 사이트들도 물론 이익을 볼 수 있습니다.',
	'config-cache-none' => '캐시하지 않음 (기능적으로는 삭제되지 않지만 큰 위키 사이트에 속도에 영향을 받을 수 있습니다)',
	'config-cache-accel' => 'PHP 개체 캐싱 (APC, XCache 또는 WinCache)',
	'config-cache-memcached' => 'Memcached 사용 (추가적인 설치와 설정이 필요합니다)',
	'config-memcached-servers' => 'Memcached 서버:',
	'config-memcached-help' => 'Memcached의 사용하기 위한 IP 주소 목록입니다.
한 줄에 하나씩 사용할 포트를 지정해야 합니다. 예를 들어 :
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => '캐시 종류로 Memcached를 선택했지만 어떠한 서버도 지정하지 않았습니다.',
	'config-memcache-badip' => 'Memcached에 대해 잘못된 IP 주소를 입력했습니다: $1.',
	'config-memcache-noport' => 'Memcached 서버에 사용할 포트를 지정하지 않았습니다: $1.
포트를 모를 경우 기본값은 11211입니다.',
	'config-memcache-badport' => 'Memcached 포트 번호는 $1(와)과 $2 사이여야 합니다.',
	'config-extensions' => '확장 기능',
	'config-extensions-help' => '위에 나열된 확장 기능이 <code>./extensions</code>에서 발견되었습니다.

이는 추가적인 설정이 필요할 수 있습니다만 지금 활성화시킬 수 있습니다.',
	'config-install-alreadydone' => "'''경고:''' 당신은 이미 미디어위키를 설치하였고 다시 설치하려고 합니다.
다음 페이지에서 진행하세요.",
	'config-install-begin' => '"{{int:config-continue}}"을 누르면 미디어위키의 설치를 시작합니다.
그래도 바꾸는 것을 원한다면 뒤로를 누릅니다.',
	'config-install-step-done' => '완료',
	'config-install-step-failed' => '실패',
	'config-install-extensions' => '확장 기능을 포함하는 중',
	'config-install-database' => '데이터베이스를 설정하는 중',
	'config-install-schema' => '스키마를 만드는 중',
	'config-install-pg-schema-not-exist' => 'PostgreSQL 스키마가 존재하지 않습니다.',
	'config-install-pg-schema-failed' => '테이블을 만드는 데 실패했습니다.
"$2" 스키마에 쓸 수 있는 "$1" 사용자가 있는지 확인하세요.',
	'config-install-pg-commit' => '바뀐 사항을 적용하는 중',
	'config-install-pg-plpgsql' => 'PL/pgSQL 언어에 대해 확인하는 중',
	'config-pg-no-plpgsql' => '$1 데이터베이스에 PL/pgSQL 언어를 설치해야 합니다',
	'config-pg-no-create-privs' => '설치를 위한 지정한 계정에 계정을 만드는 데 충분한 권한이 없습니다,',
	'config-pg-not-in-role' => '웹 사용자에 대해 지정한 계정이 이미 존재합니다.
설치에 대한 지정한 사용자는 슈퍼 사용자가 아니고, 그것은 웹 사용자의 역할의 구성원이 아니며, 그래서 웹 사용자가 소유한 개체를 만들 수 없습니다.

현재 미디어위키는 테이블을 웹 사용자가 소유해야 합니다. 다른 웹 계정 이름을 지정하거나 "뒤로"를 클릭하고 적절한 권한의 설치할 사용자를 지정하세요.',
	'config-install-user' => '데이터베이스 사용자를 만드는 중',
	'config-install-user-alreadyexists' => '"$1" 사용자가 이미 있음',
	'config-install-user-create-failed' => '"$1" 사용자 만드는 중 실패: $2',
	'config-install-user-grant-failed' => '"$1" 사용자에 대한 권한 부여 실패: $2',
	'config-install-user-missing' => '지정한 "$1" 사용자가 존재하지 않습니다.',
	'config-install-user-missing-create' => '지정된 "$1" 사용자가 존재하지 않습니다.
이를 만드는 것을 원하면 아래의 "계정 만들기" 확인 상자를 클릭하세요.',
	'config-install-tables' => '테이블을 만드는 중',
	'config-install-tables-exist' => "'''경고''': 미디어위키 테이블이 이미 있는 것 같습니다.
테이블 만들기를 생략합니다.",
	'config-install-tables-failed' => "'''오류''': 다음 오류와 함께 테이블 만들기에 실패했습니다: $1",
	'config-install-interwiki' => '기본 인터위키 테이블을 채우는 중',
	'config-install-interwiki-list' => '<code>interwiki.list</code> 파일을 불러올 수 없습니다.',
	'config-install-interwiki-exists' => "'''경고''': 인터위키 테이블이 이미 항목을 갖고 있는 것 같습니다.
기본 목록으로 넘어갑니다.",
	'config-install-stats' => '통계를 초기화하는 중',
	'config-install-keys' => '보안 키를 만드는 중',
	'config-insecure-keys' => "'''경고:''' 설치 중에 생성한 {{PLURAL:$2|보안 키}} ($1)를 설치하는 동안 완전히 안전하지 {{PLURAL:$2|않습니다}}. 직접 바꾸기를 고려하세요.",
	'config-install-sysop' => '관리자 사용자 계정을 만드는 중',
	'config-install-subscribe-fail' => '미디어위키 발표를 구독할 수 없습니다: $1',
	'config-install-subscribe-notpossible' => 'cURL이 설치되지 않았고 allow_url_fopen를 사용할 수 없습니다.',
	'config-install-mainpage' => '기본 콘텐츠로 대문을 만드는 중',
	'config-install-extension-tables' => '활성화된 확장 기능을 위한 테이블을 만드는 중',
	'config-install-mainpage-failed' => '대문을 삽입할 수 없습니다: $1',
	'config-install-done' => "'''축하합니다!'''
미디어위키가 성공적으로 설치되었습니다.

설치 마법사가 <code>LocalSettings.php</code> 파일을 만들었습니다.
이는 모든 설정이 포함되어 있습니다.

이를 다운로드하여 위키 설치의 거점에 넣어야 합니다 (index.php와 같은 디렉토리). 다운로드가 자동으로 시작됩니다.

다운로드가 제공되지 않을 경우나 그것을 취소한 경우에는 아래의 링크를 클릭하여 다운로드를 다시 시작할 수 있습니다:

$3

'''참고''': 지금 이렇게 하지 않으면, 이 설정 파일을 다운로드하지 않고 설치를 종료할 경우 만들어진 설정 파일은 나중에 사용할 수 없습니다.

완료되었으면 '''[$2 위키에 들어갈 수 있습니다]'''.",
	'config-download-localsettings' => 'LocalSettings.php 다운로드',
	'config-help' => '도움말',
	'config-nofile' => '"$1" 파일을 찾을 수 없습니다. 이미 삭제되었나요?',
	'mainpagetext' => "'''미디어위키가 성공적으로 설치되었습니다.'''",
	'mainpagedocfooter' => '[//meta.wikimedia.org/wiki/Help:Contents 이곳]에서 위키 프로그램에 대한 정보를 얻을 수 있습니다.

== 시작하기 ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings 설정하기]
* [//www.mediawiki.org/wiki/Manual:FAQ 미디어위키 FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce 미디어위키 발표 메일링 리스트]',
);

/** Karachay-Balkar (къарачай-малкъар)
 * @author Iltever
 */
$messages['krc'] = array(
	'mainpagetext' => "'''«MediaWiki» тыйыншлы салынды.'''",
	'mainpagedocfooter' => "Бу вики бла къалай ишлерге ангылатхан информацияны [//meta.wikimedia.org/wiki/Help:Contents_User's_Guide къошулуучугъа юретиуде] табаргъа боллукъду.

== Файдалы ресурсла ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings тюрлендириулени списогу (ингил.)];
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-ни юсюнден кёб берилген соруула];
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-ни джангы версиясыны чыкъгъанын билдириу письмола].",
);

/** Colognian (Ripoarisch)
 * @author Mormegil
 * @author Purodha
 * @author Reedy
 */
$messages['ksh'] = array(
	'config-desc' => 'Et Projramm för Mediwiki opzesäze.',
	'config-title' => 'MediaWiki $1 opsäze',
	'config-information' => 'Enfomazjuhn',
	'config-localsettings-upgrade' => 'De Dattei <code lang="en">LocalSettings.php</code> es ald doh.
De Projramme vum Wiki künne op der neußte Shtand jebraat wääde:
Donn doför dä Wäät vum <code lang="en">$wgUpgradeKey</code> en dat heh Feld enjävve.
Do fenggs_et en dä Dattei <code lang="en">LocalSettings.php</code> om ẞööver.',
	'config-localsettings-cli-upgrade' => 'En Dattei <code lang="en">LocalSettings.php</code> es jefonge woode.
Öm et Wiki_Projramm op ene neue Shtand ze bränge, donn <code lang="en">update.php</code> oproofe.',
	'config-localsettings-key' => 'Der Schlößel för et Projramm op ene neue Schtand ze bränge:',
	'config-localsettings-badkey' => 'Dinge Schlößel paß nit.',
	'config-upgrade-key-missing' => 'Mer han jefonge, dat MediaWiki ald enschtalleed es.
Üm de Projramme un Daate o der neue Schtand bränge ze künne, dunn aan et Engk vun dä Dattei <code lang="en">LocalSettings.php</code> op dämm ẞööver:

$1

aanhange.',
	'config-localsettings-incomplete' => 'Mer han en Dattei <code lang="en">LocalSettings.php:</code> jefonge, ävver di schingk nit kumplätt ze sin.
De Varijable <code lang="en">$1</code> es nit jesatz.
Bes esu joot, un donn di Dattei esu aanpaße, dat se jesaz ea, un dann donn op „{{int:config-continue}}“ klecke.',
	'config-localsettings-connection-error' => 'Ene Fähler es opjetrodde wi mer en Verbendung noh de Datebangk opmaache wullte met dä Enshtellunge uß dä Dattei <code lang="en">LocalSettings</code> udder uß dä Dattei <code lang="en">LocalSettings</code> un et hät nit jeflupp. Bes esu joot un dat repareere un versöhg et dann norr_ens.

$1',
	'config-session-error' => 'Ene Fähler es opjetrodde beim Aanmelde för en Sezung: $1',
	'config-session-expired' => 'De Daate för Ding Setzung sinn wall övverholld of afjeloufe.
De Setzungunge sin esu enjeshtallt, nit mieh wi $1 ze doore.
Dat kanns De verlängere, endämm dat De de <code lang="en">session.gc_maxlifetime</code> en dä Dattei <code>php.ini</code> jrüüßer määß.
Don dat Projramm för et Opsäze norr_ens aanschmiiße.',
	'config-no-session' => 'De Daate för Ding Setzung sinn verschött jejange.
Donn en dä Dattei <code>php.ini</code> nohloore, ov dä <code lang="en">session.save_path</code> op e zopaß Verzeijschneß zeisch.',
	'config-your-language' => 'Ding Schprooch:',
	'config-your-language-help' => 'Donn heh di Shprooch ußsöhke, di dat Enshtallzjuhnsprojramm kalle sull.',
	'config-wiki-language' => 'Dem Wiki sing Shprooch:',
	'config-wiki-language-help' => 'Donn heh di Shprooch ußsöhke, di et Wiki shtandattmääßesch kalle sull.',
	'config-back' => '← Retuur',
	'config-continue' => 'Wigger →',
	'config-page-language' => 'Schprooch',
	'config-page-welcome' => 'Wellkumme beim MediaWiki!',
	'config-page-dbconnect' => 'Met dä Daatebangk Verbenge',
	'config-page-upgrade' => 'En Inshtallzjuhn op der neuste Shtand bränge',
	'config-page-dbsettings' => 'Parrameeter för de Daatebangk',
	'config-page-name' => 'Name',
	'config-page-options' => 'Ennställunge',
	'config-page-install' => 'Opsäzze',
	'config-page-complete' => 'Fäädesch!',
	'config-page-restart' => 'Et Opsäze norr_ens neu aanfange',
	'config-page-readme' => 'Donn mesch lässe! (<i lang="en">read me</i>)',
	'config-page-releasenotes' => 'Henwies för heh di Version vum Projramm (<i lang="en">Release notes</i>)',
	'config-page-copying' => 'Ben aam Kopeere',
	'config-page-upgradedoc' => 'Ben op der neuste Stand aam bränge',
	'config-page-existingwiki' => 'Mer han ald e Wiki!',
	'config-help-restart' => 'Wells De all Ding enjejovve Sachee fottjeschmesse han, un dä janze Vörjang vun fürre aan neu aanfange?',
	'config-restart' => 'Joh, neu aanfange!',
	'config-welcome' => '=== Ömjevong Prööfe ===
Mer maache en Aanzal jrundlääje Prövunge, öm erus ze fenge, ov di Ömjevong heh paß, för Mediawiki opzesäze.
Wann de Hölp bem Opsäze bruchs, donn wigger ssare, wat erus kohm, wat heh shteiht.',
	'config-copyright' => "=== Urhävverrääsch un Lizänzbedengunge ===

\$1

Dat  Projramm heh es frei, mer kann et wiggerjävve un verdeijle un och verändere ungger dä Bedengunge vun de  GNU <i lang=\"en\">General Public License</i> (Alljemeine öffentlesche Lizänz) wi se vun de <i lang=\"en\">Free Software Foundation</i> (de Shteftung för frei Projramme) veröffentlesch woode es. Dobei kanns De Der de Version 2 vun dä Lizanz ußsöhke, udder jeede Version donoh, wi et Der jefällt.

Dat Projramm weed wigger jejovve met dä Hoffnung, dat et jät nöz, ävver '''ohne Jarrantie''', sujaa ohne de onußjeshproche Jarantie, '''verkoufbaa''' ze sin, udder '''för öhnds_ene beshtemmpte Zweck ze bruche''' ze sin.
Liß de GNU <i lang=\"en\">General Public License</i> sellver, öm mieh ze erfahre.

Do sullts en <doclink href=Copying>Kopie vun dä alljemene öffentlesche Lizänz vun dä GNU</doclink> (<i lang=\"en\">GNU General Public License</i>) zosamme met heh däm Projramm krääje han. Wann dat nit esu es, schrief aan de <i lang=\"en\">Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA</i>. udder [http://www.gnu.org/copyleft/gpl.html liß se online övver et Internet].",
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki sing Hompäjdsch]
* [//www.mediawiki.org/wiki/Help:Contents Handbooch för Aanwender]
* [//www.mediawiki.org/wiki/Manual:Contents Handbooch för Administratore un Wiki_Köbesse]
* [//www.mediawiki.org/wiki/Manual:FAQ Öff jeshtallte Froore met Antwoote]
----
* <doclink href=Readme>Liß Mesch! (<i lang="en">Read me</i>)</doclink>
* <doclink href=ReleaseNotes><i lang="en">Release notes</i> Övver heh di Projrammversion</doclink>
* <doclink href=Copying><i lang="en">Copying</i> — Lizänzbeshtemmunge</doclink>
* <doclink href=UpgradeDoc><i lang="en">Upgrading</i> — Ob en neu Projrammversion jonn</doclink>',
	'config-env-good' => 'De Ömjävung es jeprööf.
Do kanns MediaWiki opsäze.',
	'config-env-bad' => 'De Ömjävung es jeprööf.
Do kanns MediaWiki nit opsäze.',
	'config-env-php' => 'PHP $1 es doh.',
	'config-env-php-toolow' => 'PHP $1 es enshtalleert.
Ävver MediaWiki bruch PHP $2 udder hühter.',
	'config-unicode-using-utf8' => 'För et <i lang="en">Unicode</i>-Nommaliseere dom_mer däm <i lang="en">Brion Vibber</i> sing Projramm <code lang="en">utf8_normalize.so</code> nämme.',
	'config-unicode-using-intl' => 'För et <i lang="en">Unicode</i>-Nommaliseere dom_mer dä [http://pecl.php.net/intl Zohsaz <code lang="en">intl</code> uss em <code lang="en">PECL</code>] nämme.',
	'config-unicode-pure-php-warning' => '\'\'\'Opjepaß:\'\'\' Mer kunnte dä [http://pecl.php.net/intl Zohsaz <code lang="en">intl</code> uss em <code lang="en">PECL</code>] för et <i lang="en">Unicode</i>-Nommaliseere nit fenge. Dröm nämme mer dat eijfache, ävver ärsh lahme, <i lang="en">PHP</i>-Projrammshtöck doför.
För jruuße Wikis met vill Metmaachere doht Üsch die Sigg övver et [//www.mediawiki.org/wiki/Unicode_normalization_considerations <i lang="en">Unicode</i>-Nommaliseere] (es op Änglesch) aanloore.',
	'config-unicode-update-warning' => "'''Opjepaß:''' Dat Projramm för der <i lang=\"en\">Unicode</i> zo normaliseere boud em Momang op en  ählter Version vun dä Bibliothek vum [http://site.icu-project.org/ ICU-Projäk] op.
Doht di [//www.mediawiki.org/wiki/Unicode_normalization_considerations op der neuste Shtand bränge], wann auf dat Wiki em Äänz <i lang=\"en\">Unicode</i> bruche sull.",
	'config-no-db' => 'Mer kunnte kei zopaß Daatebangk-Driiverprojamm fenge.
Mer bruche e Daatebangk-Driiverprojamm för PHP. Dat moß enjeresht wääde.
Mer künne met heh dä Daatebangke ömjonn: $1.

Wann De nit om eijene Rääshner bes, moß De Dinge <i lang="en">provider</i> bedde, dat hä Der ene zopaß Driiver enresht.
Wann de PHP sellver övversaz häs, donn e Zohjangsprjramm för en Daatebangk enbenge, för e Beishpell met: <code  lang="en">./configure --with-mysql</code> op ene <i lang="en">command shell</i>.
Wann De PHP uss enem <i lang="en">Debian</i> udder <i lang="en">Ubuntu</i> Pakätt enjeresht häs, moß De dann och noch et <code lang="en">php5-mysql</code> op Dinge Räschner bränge.',
	'config-outdated-sqlite' => '\'\'\'Opjepaß:\'\'\' <i lang="en">SQLite</i> $1 es enschtaleert. Avver MediaWiki bruch <i lang="en">SQLite</i> $2 udder hühter. <i lang="en">SQLite</i> kann dröm nit enjesaz wääde.',
	'config-no-fts3' => "'''Opjepaß:''' De Projramme vum <i lang=\"en\">SQLite</i> sin der ohne et [//sqlite.org/fts3.html FTS3-Modul] övversaz, dröm wääde de Funxjohne för et Söhke fähle.",
	'config-register-globals' => "'''Opjepaß:''' dem PHP singe Schallder <code lang=\"en\">[http://php.net/register_globals register_globals]</code> es enjeschalldt.
'''Donn dä ußmaache, wann De kann.'''
MediaWiki löp och esu, dä künnt ävver Sesherheitslöcke opmaache, di mer noch nit jefonge un eruß jemaat hät.",
	'config-magic-quotes-runtime' => "'''Dä!''' Dem PHP singe Schallder <code lang=\"en\">[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime]</code> es enjeschalldt.
Dä määt enjejovve Daate kapott, un doh draan kam_mer dann nix mieh repareere.
Domet kam_mer MediaWiki nit ennreeshte un och nit loufe lohße.
Dat heiß, mer moß en affschallde, söns jeiht nix.",
	'config-magic-quotes-sybase' => "'''Dä!''' Dem PHP singe Schallder <code lang=\"en\">[http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase]</code> es enjeschalldt.
Dä määt enjejovve Daate kapott, un doh draan kam_mer dann nix mieh repareere.
Domet kam_mer MediaWiki nit ennreeshte un och nit loufe lohße.
Dat heiß, mer moß en affschallde, söns jeiht nix.",
	'config-mbstring' => "'''Dä!''' Dem PHP singe Schallder <code lang=\"en\">[http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload]</code> es enjeschalldt.
Dat sorresch för Fähler un kann enjejovve Daate esu kapott maach, dat doh draan nix mieh ze repareere es.
Domet kam_mer MediaWiki nit ennreeshte un och nit loufe lohße.
Dat heiß, mer moß en affschallde, söns jeiht nix.",
	'config-ze1' => "'''Dä!''' Dem PHP singe Schallder <code lang=\"en\">[http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode]</code> es enjeschalldt.
Dat sorresch för schräcklejje Fähler em MediaWiki.
Dat kam_mer domet nit ennreeshte un och nit loufe lohße.
Dat heiß, mer moß en affschallde, söns jeiht nix.",
	'config-safe-mode' => "'''Opjepaß:''' Dem PHP singe <code lang=\"en\">[http://www.php.net/features.safe-mode safe mode]</code> es aanjeschalldt. Dat kann Ärjer maache, besönders beim Datteie Huhlaade bei de Ongershtözung för <code lang=\"en\">math</code>-Befähle.",
	'config-xml-bad' => 'Dem PHP sing XML-Modul es nit ze fenge.
MediaWiki bruch Funxjohne en däm Modul un deiht et esu nit.
Wann De <i lang="en">Mandrake</i> aam loufehäs, donn dat Pakätt <code lang="en">php-xml</code> enstalleere.',
	'config-pcre' => 'Dem PHP sing Modul för <i lang="en">PCRE</i> schingk ze fähle.
MediaWiki deiht et nit ohne de Funxjohne för de <i lang="en">Perl-compatible regular expressions</i>.',
	'config-pcre-no-utf8' => "'''Dä:''' Et PHP-Modul <i lang=\"en\">PCRE</i> schingk ohne de <i lang=\"en\">PCRE_UTF8</i>-Aandeile övversaz ze sin.
MediaWiki bruch dä UTF-8-Krohm ävver, öm ohne Fähler loufe ze künne.",
	'config-memory-raised' => 'Der jrühzte zohjelasse Shpeisherbedarf vum PHP, et <code lang="en">memory_limit</code>, shtund op $1 un es op $2 erop jesaz woode.',
	'config-memory-bad' => "'''Opjepaß:''' Dem PHP singe Parameeter <code lang=\"en\">memory_limit</code> es \$1.
Dat es wall ze winnisch.
Et Enreeschte kunnt doh draan kappott jon!",
	'config-ctype' => "'''Fähler:''' <i lang=\"en\">PHP</i> moß met dä Ongerschtözong för der [http://www.php.net/manual/en/ctype.installation.php <code lang=\"en\">Ctype</code> Zohsaz] övversaz woode sin.",
	'config-xcache' => 'Dä <code lang="en">[http://xcache.lighttpd.net/ XCache]</code> es ennjeresht.',
	'config-apc' => 'Dä <code lang="en">[http://www.php.net/apc APC]</code> es ennjeresht.',
	'config-wincache' => 'Dä <code lang="en">[http://www.iis.net/download/WinCacheForPhp WinCache]</code> es ennjeresht.',
	'config-no-cache' => '\'\'\'Opjepaß:\'\'\' Mer kunnte dä <code lang="en">[http://www.php.net/apc APC]</code>, dä <code lang="en">[http://xcache.lighttpd.net/ XCache]</code> un dä <code lang="en">[http://www.iis.net/download/WinCacheForPhp WinCache]</code> nit fenge.
Et <i lang="en">object caching</i> es nit müjjelesh un ußjeschalldt.',
	'config-mod-security' => "'''Opjepaß''': Dinge Webßööver hät <code lang=\"en\">[http://modsecurity.org/ mod_security]</code> enjeschalldt. Wann doh derbei en Enschtällong nit janz akeraat paßß, dann kann et goot sin, dat mer Probleme met MeedijaWiki un oc met ander Projramme kritt, die zohlööt, dat vun ußerhallef öhndsene Krohm op dä Webßööver jebraat wääde künnt.Beloor Der di Sigg <code lang=\"en\">[http://modsecurity.org/documentation/ mod_security documentation]</code> udder donn met dä Fachlück för Dinge Webßööver kalle, wann zohfälleje un koomijje Fähler bemerke deihß.",
	'config-diff3-bad' => 'Mer han <i lang="en">GNU</i> <code lang="en">diff3</code> nit jefonge.',
	'config-imagemagick' => 'Mer han <i lang="en">ImageMagick</i> jefonge: <code>$1</code>.
Et Ömrääschne en Minni-Beldsche weed müjjelesch sin, wann De et Belder Huhlaade zohlöhß.',
	'config-gd' => 'Mer han de ennjeboute GD-Jrafik-Projramm-Biblijotheek jefonge.
Et Ömrääschne en Minni-Beldsche weed müjjelesch sin, wann De et Belder Huhlaade zohlöhß.',
	'config-no-scaling' => 'Mer han weeder de GD-Jrafik-Projramm-Biblijotheek, noch <i lang="en">ImageMagick</i> jefonge.
Et Ömrääschne en Minni-Beldsche weed ußjeschalldt.',
	'config-no-uri' => "'''Fähler:''' Mer kunnte der aktoälle <i lang=\"en\">URI</i> nit erusfenge.
Et Enreeschte es domet heh aam Engk.",
	'config-no-cli-uri' => "'''Opjepaß''': <code lang=\"en\">--scriptpath</code> es nit aanjejovve, mer nämme der Schtandatt: <code>\$1</code>.",
	'config-using-server' => 'Mer nämmen dem ẞööver singe Name: „<nowiki>$1</nowiki>“.',
	'config-using-uri' => 'Mer nämmen dem ẞööver singe <i lang="en">URL</i>: „<nowiki>$1$2</nowiki>“.',
	'config-uploads-not-safe' => "'''Opjepaß:''' Uß däm jewöhnlijje Verzeichnes för de huhjelaade Datteie, dat es <code>$1</code>, künnte öhnzwällsche Skrepte un Projramme ußjeföhrt wääde. Och wann MediaWiki de huhjelaade Datteie prööf, dat kein bekannte Risike dren sin, sullt mer doch dat [//www.mediawiki.org/wiki/Manual:Security#Upload_security Sesherheitsloch] zoh maache, ih dat mer et Dattei Huhlaade zohlöht.",
	'config-no-cli-uploads-check' => "'''Opjepaß''': <code>\$1</code> es dat Schtandatt-Verzeijschneß för et Datteije-Huhlaade. Beim Opsäze met <abbr lang=\"en\" title=\"Call Level Interface\">CLI</abbr> donn mer ävver nit övverpröhve, dat dat jeschöz es dojääje, dat Skrepte vun doh loufe künne, di mer nit loufe han well.",
	'config-brokenlibxml' => 'Op Dingem Rääschner loufe Versione vun PHP un <code lang="en">libxml2</code> zosamme, di ävver nit zosamme paßße, un de Daate em MediaWiki un ander Web_Aanwändunge [//bugs.php.net/bug.php?id=45996 bug kapott maache].
Jangk op PHP 5.2.9 udder dohnoh un op <code lang="en">libxml2</code> 2.7.3 udder dohnoh.
Heh jeihd et nit wigger.',
	'config-using531' => 'MediaWiki läuf nit met PHP $1 zosamme wääje enem [//bugs.php.net/bug.php?id=50394 Fähler em Zosammehang met Parrameetere för <code lang="en">__call()</code>].
Jangk op de Version 5.3.2 vum <i lang="en">PHP</i> ov dohnoh, udder op de Version 5.3.0 udder dovöör, öm dat Problem ze ömjonn.
Heh jeiht et nit wigger.',
	'config-suhosin-max-value-length' => '<i lang="en">Suhosin</i> es enschtalleet. Dröm kann ene <code lang="en">GET</code>-Parrameeter nit övver {{PLURAL:$1|ei Byte|$q Bytes|noll Byte}} lang wääde. En MediaWiki singe <i lang="en">ResourceLoader</i> kütt doh zwa drömeröm, ävver dat brems. Wann müjelesch, doht <code lang="en">suhosin.get.max_value_length</code> en dä Dattei <code lang="en">php.ini</code> op 1024 Bytes udder drövver enschtälle. un dann moß <code lang="en">$wgResourceLoaderMaxQueryLength</code> en dä Dattei <code lang="en">LocalSettings.php</code> op däsälve Wäät jesaz wääde.',
	'config-db-type' => 'De Zoot Daatebangk:',
	'config-db-host' => 'Dä Name vun däm Rääschner met dä Daatebangk:',
	'config-db-host-help' => 'Wann Dinge ẞööver för de Daatebangk ob enem andere Rääschner es, donn heh dämm singe Name udder dämm sing <i lang="en">IP</i>-Addräß enjävve.

Wann De ob enem Meetẞööver beß, weet Der Dinge Provaider odder däm sing Dokemäntazjuhn saare, wat De endraare moß.

Wann De ob enem ẞööver onger <i lang="en">Windows</i> am enshtalleere bes un en <i lang="en">MySQL</i>-Daatebangk häs, künnd_et sin, dat „<code lang="en">localhost</code>“ nit douch för der Name vum ẞööver. Wann dad-esu es, versöhg et ens met „<code lang="en">127.0.0.1</code>“ als <i lang="en">IP</i>-Addräß vum eije Rääschner.

Wann De ene <i lang="en">PostgreSQL</i>-ẞööver häs, donn dat Fäld läddesch lohße, öm en Verbendung övver e <i lang="en">Unix socket</i> opzemaache.',
	'config-db-host-oracle' => 'Dä Daatebangk ier <i lang="en" title="Transparent Network Substrate">TNS</i>:',
	'config-db-host-oracle-help' => 'Donn ene jöltije [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm „<i lang="en">Local Connect</i>“-Name] aanjävve. De Dattei „<code lang="en">tnsnames.ora</code>“ moß för heh dat Projamm seschbaa un ze Lässe sin.<br />Wann heh de Projamm_Biblijoteeke für de Aanwänderprojramme för de Version 10g udder neuer enjesaz wääde, kam_mer och et [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm „<i lang="en">Easy Connect</i>“] jenumme wääde för der Name ze verjävve.',
	'config-db-wiki-settings' => 'De Daate vum Wiki',
	'config-db-name' => 'Dä Name vun dä Daatebangk:',
	'config-db-name-help' => 'Jiff ene Name aan, dä för Ding Wiki passe deiht.
Doh sullte kei Zweschrereum un kein Stresche dren sin.

Wann De nit op Dingem eije Rääschner bes, künnt et sin, dat Dinge Provaider Der extra ene beshtemmpte Name för de Daatebangk jejovve hät, uffr dat de dä drom froore moß udder dat De de Daatebangke övver e Fommulaa selver enreeschte moß.',
	'config-db-name-oracle' => 'Schema för de Daatebangk:',
	'config-db-account-oracle-warn' => 'Mer han drei Aate, wi mer <i lang="en">Oracle</i> als Daatebangk aanbenge künne.

Wann De ene neue Zohjang op de Daatenbangk met Naame un Paßwoot mem Projramm för et Opsäze aanlääje wells, dann jif ene Zohjang met däm Rääsch „<i lang="en">SYSDBA</i>“ aan, dä et alld jitt, un jif däm di Daate aan för dä neue Zohjang aanzelääje.
Do kanns och dä neue Zohjang vun Hand aanlääje un heh beim Opsäze nur dää aanjävve — wann dä dat Rääsch hät, en de Daatebangk Schema_Objäkte aanzelääje.
Udder De jiß zwei ongerscheidlijje Zohjäng op de Daatenbangk aan, woh eine vun dat Rääsch zom Aanlääje hät un dä andere moß dat nit un es för der nomaale Bedrief zohshtändesch.

En Skrep, wat ene Zohjang op de Daatenbangk aanlääsch met all dä nüüdejje Rääschde, fengks De em Verzeishneß <code lang="en">maintenance/oracle/</code> vun Dingem MediaWiki. Donn draan dengke, dat ene Zohjang met beschrängkte Rääschde all di Müjjeleschkeite för et Waade un Repareere nit hät, di de jewöhnlejje Zoot Zohjang met sesh brängk.',
	'config-db-install-account' => 'Der Zohjang för en Enreeschte',
	'config-db-username' => 'Dä Name vun däm Aanwender för dä Zohjref op de Daatebangk:',
	'config-db-password' => 'Et Paßwoot vun däm Aanwender för dä Zohjref op de Daatebangk:',
	'config-db-password-empty' => 'Jiv e Paßwoot aan, för dä neue Aanwender för dä Zohjref op de Daatebangk, $1.
Ed es zwa müjjelesch, Aanwender för dä Zohjref op de Daatebangk der ohne e Paßwoot aanzelääje,
ävver dat wöhr en schwere Jevah för de Sescherheit vum Wiki.',
	'config-db-install-username' => 'Jiv ene Name aan för dä Aanwender för dä Zohjref op de Daatebangk beim Enshtalleere.
Dat es keine Metmaacher_Name em Wiki — heh dä Name es alleins en der Daatebangk bikannt.',
	'config-db-install-password' => 'Jiv e Paßwoot aan för dä Aanwender för dä Zohjref op de Daatebangk beim Enshtalleere.
Dat es kei Paßwoot för ene Metmaacher em Wiki — et es alleins en der Daatebangk bikannt.',
	'config-db-install-help' => 'Donn dä Name un et Paßwoot vun däm Aanwänder för der Zohjreff op de Daatebangk jäz för et Enreeshte aanjävve.',
	'config-db-account-lock' => 'Donn dersälve Name un et sälve Paßwoot för der nomaale Bedrief vum Wiki bruche',
	'config-db-wiki-account' => 'Dä Name vun däm Aanwender för dä Zohjref op de Daatebangk em nomaale Bedrief:',
	'config-db-wiki-help' => 'Jiv ene Name un e Paßwoot aan, för dä Aanwender för dä Zohjref op de Daatebangk, wann et wiki nommaal aam Loufe es.
Wan et dä Name en der Daatebangk noch it jit, un dä Aanwender för dä Zohjref op de Daatebangk beim Enshtalleere
jenooch Beräschtijunge hät, läät dä heh dä Aanwender en der Daatebangk aan un jidd_em di Rääschde, di dä nüüdesch hät, ävver nit mieh.',
	'config-db-prefix' => 'Vörsaz för de Name vun de Tabälle en de Daatebangk:',
	'config-db-prefix-help' => 'Wann ein Daatebangk för mieh wi ein Wiki udder e Wiki uns söns jät zosamme jebruch weed, dann kam_mer noch jet vör de Tabälle ier Name säze. Esu ene Vörsaz sull dubblte Tabällename vermeide hälfe.
Donn kein Zwescheräum enjävve!

Jewöhnlesch bliev dat Feld heh ävver läddesch.',
	'config-db-charset' => 'Dä Daatebangk iere Zeishesaz',
	'config-charset-mysql5-binary' => 'MySQL (4.1 udder 5.0) binär',
	'config-charset-mysql5' => 'MySQL (4.1 udder 5.0) UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 röckwääts kompatibel UTF-8',
	'config-charset-help' => "''' Opjepaß:'''
Wann De et '''röckwääts kompatibel UTF-8 Fommaat''' nemmps, met dem <i lang=\"en\">MySQL</i> singe Version4.1 udder hüüter, dann künnt dat all di Zeishe kappott maache, die nit em <i lang=\"en\" title=\"American Standard Code for Information Interchange\">ASCII</i> sen, un domet all ding Sesherungskopieje kapott maache, wat mer nieh mieh retuur krijje kann.

Beim Shpeishere em '''binäre Fomaat''' deiht MediaWiki de Täxte, di em UTF-8 Fommaat kumme, en dä Daatebangk en binär kodeerte Daatefälder faßhallde.
Dat es flöcker un spaasaamer wi et UTF-8 Fommaat vum <i lang=\"en\">MySQL</i> un määd et müjjelesch, all un jeedes <i lang=\"en\">Unicode</i>-Zeishe met faßzehallde.

Beim Shpeishere em '''UTF-8 Fomaat''' deiht et <i lang=\"en\">MySQL</i> der Zeishesaz un de Kodeerung vun dä Daate känne, un kann se akeraat aanzeije un ömwandelle,
allerdengs künne kein Zeishe ußerhalv vum [//de.wikipedia.org/wiki/Basic_Multilingual_Plane#Gliederung_in_Ebenen_und_Bl.C3.B6cke jrundlääje Knubbel för vill Shprooche (<i lang=\"en\">Basic Multilingual Plane — BMP</i>)] afjeshpeishert wääde.",
	'config-mysql-old' => 'Mer bruche <i lang="en">MySQL</i> $1 udder neuer. Em Momang es <i lang="en">MySQL</i> $2 aam Loufe.',
	'config-db-port' => 'De Pooz-Nommer (<i lang="en">port</i>) för de Daatebangk:',
	'config-db-schema' => 'Et Schema en de Datebangk för MediaWiki:',
	'config-db-schema-help' => 'För jewöhnlesch es dat Schema en Odenong.
Donn bloß jät draan ändere, wann De sescher weiß, dat dat nüüdesch es.',
	'config-pg-test-error' => "Mer krijje kein Verbendung zor Daatebank '''$1''': $2",
	'config-sqlite-dir' => 'Dem <i lang="en">SQLite</i> sing Daateverzeishnes:',
	'config-sqlite-dir-help' => '<i lang="en">SQLite</i> hät all sing Daate zosamme en en einzel Dattei.

En dat Verzeishneß, wat De aanjiß, moß dat Web_ẞööver_Projramm beim Opsäze eren schriive dörrve.

Dat Verzeishneß sullt \'\'\'nit\'\'\' övver et Web zohjänglesch sin, dröm dom_mer et nit dohen, woh de <i lang="en">PHP</i>-Datteije sin.

Mer donn beim Opsäze zwa uß Vöörssh en <code lang="en">.htaccess</code> Dattei dobei, ävver wann di nit werrek, künnte Lück vun ußerhallef aan Ding Daatebangk_Dattei eraan kumme.
Doh shtonn Saache dren, wi de Addräße för de Metmaacher ier <i lang="en">e-mail</i> un de verschlößelte Paßwööter un de vershtoche un de fottjeschmeße Sigge un ander Saache ussem Wiki, di mer nit öffentlesch maache darref.

Donn Ding Daatebangk et beß janz woh anders hen, noh <code lang="en">/var/lib/mediawiki/\'\'wikiname\'\'</code> för e Beishpell.',
	'config-oracle-def-ts' => 'Tabälleroum för der Shtandattjebruch:',
	'config-oracle-temp-ts' => 'Tabälleroum för der Jebruch zweschedorsh:',
	'config-type-mysql' => '<i lang="en">MySQL</i>',
	'config-type-postgres' => '<i lang="en">PostgreSQL</i>',
	'config-type-sqlite' => '<i lang="en">SQLite</i>',
	'config-type-oracle' => '<i lang="en">Oracle</i>',
	'config-type-ibm_db2' => 'Dä <i lang="en">IBM</i> ier <i lang="en">DB2</i>',
	'config-support-info' => 'MediaWiki kann met heh dä Daatebangk_Süßteeme zosamme jonn:

$1

Wann dat Daatebangk_Süßteem, wat De nämme wells, onge nit dobei es, dann donn desch aan di Aanleidonge hallde, di bovve verlengk sen, öm et op Dingem ẞööver singem Süßteem müjjelesh ze maache, se aan et Loufe ze krijje.',
	'config-support-mysql' => '* <i lang="en">$1</i> es dat vum MediaWiki et eets ongershtöz Daatebangksüßteem ([http://www.php.net/manual/de/mysql.installation.php Aanleidung för et Övversäze un Enreeschte von PHP met <i lang="en">MySQL</i> dobei, op Deutsch])',
	'config-support-postgres' => '* <i lang="en">$1</i> es e bikannt Daatebangksüßteem met offe Quälltäxde, un en och en Wahl nävve <i lang="en">MySQL</i> ([http://www.php.net/manual/de/pgsql.installation.php Aanleidung för et Övversäze un Enreeschte von PHP met <i lang="en">PostgreSQL</i> dobei, op Deutsch]) Et sinn_er ävver paa klein Fählershe bekannt, um kunne dat em Momang för et reschtijje Werke nit emfähle.',
	'config-support-sqlite' => '* <i lang="en">$1</i> es e eijfach Daatebangksüßteem, wat joot ongershtöz weed. ([http://www.php.net/manual/de/pdo.installation.php Aanleidong för et Övversäze un Enreeschte von PHP met <i lang="en">SQLite</i> dobei, op Deutsch])',
	'config-support-oracle' => '* <i lang="en">$1</i> es e jeschäfflesch Daatebangksüßteem för Ferme. ([http://www.php.net/manual/de/oci8.installation.php Aanleidong för et Övversäze un Enreeschte von PHP met <i lang="en">OCI8</i> dobei, op Deutsch])',
	'config-support-ibm_db2' => '* $1 es en Datebengk för et Jeschäff un fö Ongernehme.',
	'config-header-mysql' => 'De Enshtällunge för de <i lang="en">MySQL</i> Daatebangk',
	'config-header-postgres' => 'De Enshtällunge för de <i lang="en">PostgreSQL</i> Daatebangk',
	'config-header-sqlite' => 'De Enshtällunge för de <i lang="en">SQLite</i> Daatebangk',
	'config-header-oracle' => 'De Enshtällunge för de <i lang="en">Oracle</i> Daatebangk',
	'config-header-ibm_db2' => 'De Enshtällunge för de <i lang="en">IBM</i> ier <i lang="en">DB2</i>',
	'config-invalid-db-type' => 'Dat es en onjöltijje Zoot Daatebangk.',
	'config-missing-db-name' => 'Do moß jät enjävve för dä Name vun dä Daatebangk.',
	'config-missing-db-host' => 'Do moß jät enjävve för dä Name vun däm Rääschner met dä Daatebangk.',
	'config-missing-db-server-oracle' => 'Do moß jät enjävve för dä Daatebangk ier <i lang="en" title="Transparent Network Substrate">TNS</i>.',
	'config-invalid-db-server-oracle' => 'Dä Daatebangk ier <i lang="en" title="Transparent Network Substrate">TNS</i> kann nit „$1“ sin, dat es esu nit jöltesch.
Döh dörve bloß <i lang="en" title="American Standard Code for Information Interchange">ASCII</i> Boochshtaabe (a-z, A-Z), Zahle (0-9), Ongerstreshe (_), un Punkte (.) dren vörkumme.',
	'config-invalid-db-name' => 'Dä Daatebangk iere Name kann nit „$1“ sin, dä es esu nit jöltesch.
Döh dörve bloß <i lang="en" title="American Standard Code for Information Interchange">ASCII</i> Boochshtaabe (a-z, A-Z), Zahle (0-9), Ongerstresh (_), un Bendeshtresh (-) dren vörkumme.',
	'config-invalid-db-prefix' => 'Dä Vörsaz för de Name vun de Tabälle en de Daatebangk kann nit „$1“ sin, dä es esu nit jöltesch.
Döh dörve bloß <i lang="en" title="American Standard Code for Information Interchange">ASCII</i> Boochshtaabe (a-z, A-Z), Zahle (0-9), Ongerstreshe (_), un Bendeshtreshe (-) dren vörkumme.',
	'config-connection-error' => '$1.

Donn de Name för dä Rääschner, vun däm Aanwender för dä Zohjref op de Daatebangk, un et Paßwoot prööfe, repareere, un dann versöhg et norr_ens.',
	'config-invalid-schema' => 'Dat Schema för MediaWiki kann nit „$1“ sin, dä Name wöhr esu nit jöltesch.
Döh dörve bloß <i lang="en" title="American Standard Code for Information Interchange">ASCII</i> Boochshtaabe (a-z, A-Z), Zahle (0-9), un Ongerstreshe (_) dren vörkumme.',
	'config-db-sys-create-oracle' => 'Dat Projramm för MediaWiki opzesäze kann bloß <i lang="en">SYSDBA</i> bruche för ene neue Zohjang zor Daatebangk enzereeschte!',
	'config-db-sys-user-exists-oracle' => 'Dä Aanwender „$1“ för dä Zohjref op de Daatebangk jidd_et ald. <i lang="en">SYSDBA</i> kam_mer bloß bruche, för ene neue Zohjang enzereeschte!',
	'config-postgres-old' => 'Mer bruche <i lang="en">PostgreSQL</i> $1 udder neuer. Em Momang es <i lang="en">PostgreSQL</i> $2 aam Loufe.',
	'config-sqlite-name-help' => 'Söhk enen Name uß, dä Ding Wiki beschrief.
Donn kein Bendeschresch un Zweschräum en däm Name bruche.
Dä Name weed för der Dateiname för de <i lang="en">SQLite</i> Daatebangk jenumme.',
	'config-sqlite-parent-unwritable-group' => 'Mer kunnte dat Verzeischneß för de Daate, <code lang="en"><nowiki>$1</nowiki></code>, nit enreeschte, weil dat Projramm fö dä Web_ẞööver en dat Verzeischneß doh drövver, <code><nowiki>$2</nowiki></code>, nix erin donn darref.

Mer han dä Name vun däm Zohjang op et Süßteem eruß jefonge, onger dämm dat Web_ẞööver_Projramm läuf. Jez moß De bloß doför sorrje, dat dä en dat Verzeischneß  <code><nowiki>$3</nowiki></code> schrieve kann, öm heh wigger maache ze künne.
Ob enem Süßteem met <i lang="en">Unix</i>- oder <i lang="en">Linux</i> jeiht dat esu:
<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Mer kunnte dat Verzeischneß för de Daate, <code lang="en"><nowiki>$1</nowiki></code>, nit enreeschte, weil dat Projramm fö dä Web_ẞööver en dat Verzeischneß doh drövver, <code><nowiki>$2</nowiki></code>, nix erin donn darref.

Mer han dä Name vun däm Zohjang op et Süßteem nit eruß fenge künne, onger dämm dat Web_ẞööver_Projramm läuf. Jez moß De bloß doför sorrje, dat dä en dat Verzeischneß  <code><nowiki>$3</nowiki></code> schrieve kann, öm heh wigger maache ze künne. Wann De dä Name och nit weiß, maach, dat jeeder_ein doh schrieve kann.
Ob enem Süßteem met <i lang="en">Unix</i>- oder <i lang="en">Linux</i> jeiht dat esu:
<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Ene Fähler es opjetrodde beim Aanlääje vum Daate_Verzeishneß „$1“.
Don dä Plaz för et Shpeishere prööfe un Repareere, dann versöhg et norr_ens.',
	'config-sqlite-dir-unwritable' => 'Mer künne nit en dat Verzeishneß „$1“ schrieeve
Donn dohvun de Zohjreffs_Rääschde esu verändere, dat der Webßööver doh dren schrieeve kann, un dann versöhg et norr_ens.',
	'config-sqlite-connection-error' => '$1.

Donn onge dat Verzeishnes un der Name vun der Daatebangk prööfe un repareere, un dann versöhg_et norr-ens.',
	'config-sqlite-readonly' => 'En di Dattei <code lang="en">$1</code> künne mer nit schrieve.',
	'config-sqlite-cant-create-db' => 'Mer kunnte di Dattei <code lang="en">$1</code> för de Daatebangk nit aanlääje.',
	'config-sqlite-fts3-downgrade' => 'Dat PHP heh hät kein Ongershtözong för FTS3, dröm donn mer de Daatebangktabälle eronger shtoofe.',
	'config-can-upgrade' => 'Et sinn-er ald Daatebangktabelle vum MediaWiki en dä Daatebangk.
Öm di op der Shtand vum MediaWiki $1 ze bränge, donn jäz op „{{int:config-continue}}“ klecke.',
	'config-upgrade-done' => "Alles es jäz om neue Shtand.

Mer kann dat Wiki jäz [\$1 bruche].

Wann De Ding Dattei <code lang=\"en\">LocalSettings.php</code> neu schrieve wells, donn onge op dä Knopp klicke.
Dat dom_mer ävver '''nit vörschlonn'''em Jääjedeil, ußer, wann et Probleme mem Wiki jitt.",
	'config-upgrade-done-no-regenerate' => 'Alles es jäz om neue Shtand.

Mer kann dat Wiki jäz [$1 bruche].',
	'config-regenerate' => 'Donn de Dattei <code lang="en">LocalSettings.php</code> neu opsäze →',
	'config-show-table-status' => 'Et Kommando <code lang="en">SHOW TABLE STATUS</code> aan de Daatebangk es donävve jejange!',
	'config-unknown-collation' => "'''Opjepaß:''' De Daatabangk deiht en onbikannte Reijefollsch bruche, för Booshtaabe un Zeishe ze verjliishe un ze zotteere.",
	'config-db-web-account' => 'Dä Zohjang zor Daatebangk för et Wiki',
	'config-db-web-help' => 'Donn ene Name un e Paßwoot för der Zohjang zor Daatebangk för et Wiki em nomaale Bedrief aanjävve.',
	'config-db-web-account-same' => 'Donn dersällve Zohjang nämme, wi heh beim Opsäze.',
	'config-db-web-create' => 'Donn dä Zohjang aanlääje, wann dä noch nit doh es.',
	'config-db-web-no-create-privs' => 'Dä Zohjang för et Opsäze es nit berääschtesch, ene ander Zohjan enzereeschte.
Dä aanjejovve Zohjang för der Nomaalbedrief moß dröm schunn enjersht sen!',
	'config-mysql-engine' => 'De Zoot udder et Fommaat vun de Tabälle:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => '\'\'\'Opjepaß:\'\'\' <i lang="en">MyISAM</i> es als Speicher för <i lang="en">MySQL</i> nit besönders joot för et Zosammeschpell met MediaWiki zo bruche:
* Dorj_et kumplätte Sperre vun Tabälle, künne koum ens Saache parrallel en dä Daatebangk jedonn wääde.
* Dat Fomaat es anfällesch för Probleme met de Daate.
* Et weed vun MediaWiki nit ėmmer zopaß ongerschtöz.

Wann Ding <i lang="en">MySQL</i> et Schpeischere en <i lang="en">InnoDB</i>-Datteije ongerschtöze deiht, dom_mer dat nohdröcklesch ämfähle.
Kann dä ẞööver dat nit, künnd et joode jelääjeheit sin, dä ens op der neuste Schtand ze bränge.',
	'config-mysql-engine-help' => "'''InnoDB''' es fö jewöhnlesch et beß, weil vill Zohjreffe op eijmohl joot ongershtöz wääde.

'''MyISAM''' es flöcker op Rääschnere met bloß einem Minsch draan, un bei Wikis, di mer bloß lässe un nit schrieeve kann.
MyISAM-Daatebangke han em Schnett mieh Fähler un jon flöcker kappott, wi InnoDB-Daatebangke.",
	'config-mysql-charset' => 'Dä Daatebangk iere Zeishesaz:',
	'config-mysql-binary' => 'binär',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "Beim Shpeishere em '''binäre Fomaat''' deiht MediaWiki de Täxte, di em UTF-8 Fommaat kumme, en dä Daatebangk en binär kodeerte Daatefälder faßhallde.
Dat es flöcker un spaasaamer wi et UTF-8 Fommaat vum <i lang=\"en\">MySQL</i> un määd et müjjelesch, all un jeedes <i lang=\"en\">Unicode</i>-Zeishe met faßzehallde.

Beim Shpeishere em '''UTF-8 Fomaat''' deiht et <i lang=\"en\">MySQL</i> der Zeishesaz un de Kodeerung vun dä Daate känne, un kann se akeraat aanzeije un ömwandelle,
allerdengs künne kein Zeishe ußerhalv vum [//de.wikipedia.org/wiki/Basic_Multilingual_Plane#Gliederung_in_Ebenen_und_Bl.C3.B6cke jrundlääje Knubbel för vill Shprooche (<i lang=\"en\">Basic Multilingual Plane — BMP</i>)] afjeshpeishert wääde.",
	'config-ibm_db2-low-db-pagesize' => "De <i lang=\"en\">DB2</i> Daatebangk heh hät ene standattmääßeje Plaz för Tabälle met zoh klein Sigge. Dä Plaz en de Sigge moß '''32K''' udder mieh sin.",
	'config-site-name' => 'Däm Wiki singe Name:',
	'config-site-name-help' => 'Dä douch em Tittel vun de Brauserfinstere un aan ätlije andere Shtälle op.',
	'config-site-name-blank' => 'Donn ene Name för di Sait aanjävve.',
	'config-project-namespace' => 'Dä Name för et Appachtemang övver et Projäk:',
	'config-ns-generic' => 'Projäk',
	'config-ns-site-name' => 'Et sällve wi däm Wiki singe Name: $1',
	'config-ns-other' => 'Andere (jiff aan wälshe)',
	'config-ns-other-default' => 'MingWiki',
	'config-project-namespace-help' => "Noh dämm Vörbeld vun de Wikipeedija, donn vill Wikis dänne ier Sigge övver et Wiki un sing Rääjelle vun dä Sigge mem Enhald vum Wiki tränne, un en enem extra Appachtemang för et „'''Projäk'''“ afflääje.
Sigge en däm Appachtemang fange all med enem beshtemmpte Vörsaz aan, däm Name vum Appachtemang, un dä moß De heh faßlääje.
Dä Name kann beshtemmpte Zeiche nit enthallde, wi „#“ un „:“ un et es Tradizjuhn, dat hä vum Name vum Wiki her kütt.",
	'config-ns-invalid' => 'Dat aanjejovve Appachtemang „<nowiki>$1</nowiki>“ es nit jöltesch.
Nemm ene andere Name för däm Wiki sing eije Appachtemang.',
	'config-ns-conflict' => 'Dat aanjejovve Appachtemang „<nowiki>$1</nowiki>“ kütt ald als Standatt-Appachtemang em MediaWiki vör.
Nemm ene andere Name för däm Wiki sing eije Appachtemang.',
	'config-admin-box' => 'Der Zohjang för der eezte Wiki_Köbes',
	'config-admin-name' => 'Metmaacher_Name:',
	'config-admin-password' => 'Et Paßwoot:',
	'config-admin-password-confirm' => 'Norrens dat Paßwoot:',
	'config-admin-help' => 'Jif Dinge leevste Name als Metmaacher för Desch aan, för e Beishpell „Schmitzens Pitter“
— Dat weed dä Name wääde, met dämm De Desch enlogge deihs.',
	'config-admin-name-blank' => 'Jiv ene Metmaacher_Name en för dä Wiki-Köbes.',
	'config-admin-name-invalid' => '„<nowiki>$1</nowiki>“ es keine jöltijje Metmaacher_Name.
Jiv ene joode Name en!',
	'config-admin-password-blank' => 'Do mos_e Paßwoot för dä Wiki_Köbes aanjävve!',
	'config-admin-password-same' => 'Dat Paßwoot un dä Name dörve nit ejaal sin!',
	'config-admin-password-mismatch' => 'Di Paßwööter sin ongerscheidlesh!',
	'config-admin-email' => 'Addräß för de <i lang="en">e-mail</i>:',
	'config-admin-email-help' => 'Jiv heh di Adräß för de <i lang="en">e-mail</i> aan, woh De <i lang="en">e-mail</i> vun ander Metmaacher uss_em Wiki hen krijje wells, di et Der müjjelesh määt, Ding Paßwoot automatetsch truusche ze lohße, un woh Nohreeshte övver veränderte Sigge op Dinge Oppaßleß hen jescheck wääde sulle.
De kanns dat Fäld ävver och läddesch lohße.',
	'config-admin-error-user' => 'Beim Enreeshte vum Zohjang för dä Wiki_Köbes „<nowiki>$1</nowiki>“ es ene Fähler em Wiki opjetrodde.',
	'config-admin-error-password' => 'Beim Paßwoot-Säze för dä Wiki_Köbes „<nowiki>$1</nowiki>“ es ene Fähler em Wiki opjetrodde.: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Do häs_en onjöltijje Addräß för de <i lang="en">e-mail</i> aanjejovve.',
	'config-subscribe' => 'Donn de [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce <i lang="en">e-mail</i>-Leß met de Aanköndijunge vum MediaWiki] abonnere.',
	'config-subscribe-help' => 'Do kumme bloß winnish Meddeilunge un di jonn övver neu Versiohne vom MediaWiki un weeshtejje Saache vun däm sing Sesherheit.
Do sullts se abbonneere, un Ding MediWiki_Projramme op der neue Shtand bränge, wann neu Version eruß kumme.',
	'config-subscribe-noemail' => 'Do has versöhk, der ohne en Addräß för Ding <i lang="en">e-mail<i> aanzejävve, de Aanköndijonge för Aanköndijunge för neue Versione ze abboneere. Jivv en Addräß aan, wann De di Aanköndijonge hann wells.',
	'config-almost-done' => 'Do bes beinah dorsh!
Do künnts jez der Räß vun de einzel Enshtellunge övverjonn, un et Wiki tiräktemang fäädesch opsäze.',
	'config-optional-continue' => 'De wells noch mieh Frore jeshtallt krijje un noch mieh Enshtällunge maache?',
	'config-optional-skip' => 'Nä, lohß dä Ömshtand, donn eifarr_et Wiki opsäze.',
	'config-profile' => 'Enshtällunge för de Metmaacher ier Rääschte:',
	'config-profile-wiki' => 'E tradizjonäll offe Wiki',
	'config-profile-no-anon' => 'Schriever möße enlogge',
	'config-profile-fishbowl' => 'Bloß ußdröcklesch zohjelohße Schriever',
	'config-profile-private' => 'E jeschloße Privat_Wiki',
	'config-profile-help' => "Wikis loufe et beß, wam_mer esu vill Lück wi müjjelesch draan metmaache un schrieve löht.
Met MediaWiki es et ejfach, de neuste Änderunge ze beloore un wat ahnungslose udder fiese Lück kapott jemaat han wider retuur ze maache.

Bloß, mänsh eine häd_eruß jefonge, dat mer MediaWiki jood en en jruuße Zahl ongerscheidlijje Rolle bruche kann, un nit emmer es et leish, ene vum onverfälschte Wiki_Wääsch ze övverzeuje.
Esu häß De de Wahl:

'''{{int:config-profile-wiki}}''' löht jeder_ein metschrieve, och ohne enzelogge.

'''{{int:config-profile-no-anon}}''', dat sorsh för mieh seeshbaa Verantwootlishkeite, künnt ävver zohfällije Methellefer verschrecke.

'''{{int:config-profile-fishbowl}}''' löht nor de ußjesöhk Metmaacher schrieve, ävver de janze Öffentleshkeit kann et lässe un süht och de ällder Versione, un wat wää wann draan jedonn hät.

'''{{int:config-profile-private}}''' kann nur lässe, wäh en et Wiki zohjelohße es, un desellve Jropp kann uch schrieve.

Noch ander un un opwändijere Enshtellunge för de Rääschte sin müjjelesch, wann et Wiki ens aam Loufe es. Loor Der doför de [//www.mediawiki.org/wiki/Manual:User_rights zopaß Hölp em Handbooch] aan.",
	'config-license' => 'Urhävverrääsch un Lizänz:',
	'config-license-none' => 'Kein Fooßreih övver de Lizänz',
	'config-license-cc-by-sa' => '<i lang="en">Creative Commons</i> Der Name moß jenannt sin, et Wiggerjävve es zohjelohße onger dersellve Bedengunge',
	'config-license-cc-by' => 'De <i lang="en">Creative Commons</i> ier Lizänz met Namensnännong',
	'config-license-cc-by-nc-sa' => '<i lang="en">Creative Commons</i> Nit för e Jeschäff ze maache, et Wiggerjävve es zohjelohße unger dersellve Bedengunge',
	'config-license-cc-0' => '<i lang="en">Creative Commons</i> „Noll“ (jemeinfrei udder Pablic Domain)',
	'config-license-gfdl' => 'De <i lang="en">GNU</i>-Lizänz för frei Dokemäntazjuhne, Version 1.3 udder en späädere',
	'config-license-pd' => 'Allmende (jemeinfrei, <i lang="en">public domain</i>)',
	'config-license-cc-choose' => 'En <i lang="en">Creative Commons</i> Lizänz, sellver ußjesöhk:',
	'config-license-help' => "Ättlijje öffentleje Wikis donn iehr Beidrääsh onger en [http://freedomdefined.org/Definition frei Lizänz] shtelle.
Dat hellef, e Jeföhl vun Jemeinsamkeid opzeboue, un op lange Seesh emmer wider Beidrääsch ze krijje.
Dat es nit onbedengk nüüdesh för e Jeschäffs- udder Privaat_Wiki.

Wä Stöcke uß de Wikipedia bruche well, un han well, dat de Wikipedia uss_em eije Wiki jät övvernämme kann, sullt „'''<i lang=\"en\">Creative Commons</i>, dem Schriever singe Name moß jenannt wääde, un Wiggerjävve zoh dersellve Bedengunge es zohjelohße'''“ ußwähle.

De su jenannte '''<i lang=\"en\">GNU Free Documentation License</i>''' (de freije Lizänz för Dokemäntazjuhne vun dä GNU) sen de ahle Lizänzbedenonge vun de Wikipedia. Se es emmer noch in Odenong un jöltesch, ävver se es schwer ze vershtonn un et Wiggerjävve un widder Verwände es manshmool schwieeresch domet.",
	'config-email-settings' => 'Enschtellunge för de <i lang="en">e-mail</i>',
	'config-enable-email' => 'De <i lang="en">e-mail</i> noh druße zohlohße',
	'config-enable-email-help' => 'Sulle <i lang="en">e-mails</i> zohjelohße sin, moß mer, domet et noher flupp, de [http://www.php.net/manual/en/mail.configuration.php Enschtellunge em PHP för de <i lang="en">e-mails</i>] zopaß jemaat han.
Wann kein <i lang="en">e-mails</i> nüüdesch sin, kam_mer se heh afschallde.',
	'config-email-user' => '<i lang="en">e-mails</i> zwesche de Metmaacher zohlohße',
	'config-email-user-help' => 'Määt et müjjelesch, dat sesch de Metmaacher jääjesiggesch <i lang="en">e-mails</i> schecke künne, wann se dat en iehre eije Enschtellunge och enjeschalldt han.',
	'config-email-usertalk' => '<i lang="en">e-mails</i> mem Bescheid zohlohße, dat einem sing Klaafsigg verändert woodt',
	'config-email-usertalk-help' => 'Maach et müjjelesch, dat Metmaaacher en iere Enstellunge <i lang="en">e-mails</i> mem Bescheid zohlohße, dat einem sing Klaafsigg verändert woodt.',
	'config-email-watchlist' => 'Nohreeschte övver Änderonge aan Sigg op de Opaßleßte zohlohße',
	'config-email-watchlist-help' => 'Lohß Metmaacher Nohreeshte övver de Sigge op dänne iehr Oppaßleß krijje, wann se et en iehre Enschtellonge ußjewählt han.',
	'config-email-auth' => 'Donn de Övverprööfung för Zohjangsberääschtejunge övver de <i lang="en">e-mail</i> zohlohße',
	'config-email-auth-help' => 'Wann dat aanjeschald es, möße Metmaacher, di iehr Adräß för de <i lang="en">e-mail</i> neu aanjävve udder ändere, di Addräß övver ene Lengk beschtäätejje, dä se met de <i lang="en">e-mail</i> jescheck krijje.
Bloß aan esu beschtääteschte Adräße deiht et Wiki <i lang="en">e-mails</i> schecke, Di künne vun annder Metmaachere kumme, udder vum Wiki sellver, wann en Sigg en däm Metmaacher singe Oppaßleß verändert woode es.
Mer \'\'\'schlonn vör, dat aanzeschallde\'\'\' för öffentlesch Wikis, weil sönß zoh leisch Driß mem Wiki singe <i lang="en">e-mail</i> jemaat wääde künnt.',
	'config-email-sender' => 'De Adräß för de Antwoote op <i lang="en">e-mails</i>:',
	'config-email-sender-help' => 'Jiff de Adräß för de <i lang="en">e-mail</i> en, woh Antwoote ob em Wiki singe <i lang="en">e-mails</i> hen jonn sulle.
Dat es och de Adräß, woh de <i lang="en">e-mails</i> met Fählermäldonge hen jon.
Vill ẞöövere för de <i lang="en">e-mail</i> welle winnischßdens ene jöltijje Domain en dä Adräß han.',
	'config-upload-settings' => 'Belder un Datteie huh laade',
	'config-upload-enable' => 'Belder un Datteie huh laade zohlohße',
	'config-upload-help' => 'Datteije huh ze laade künnt e Risiko för dem ẞööver singe Sescherheit sin.
Mieh doh drövver kam_mer em [//www.mediawiki.org/wiki/Manual:Security Kapitel övver de Sescherheit] em Handbooch lässe.

Öm et Huhlaade zohzelohße donn de Rääschde för der Zohjreff op dat Ongerverzeischneß <code lang="en">images</code> em MediaWiki singem Houpverzeischneß esu enshtälle, dat et Webßööverprojramm doh Datteije un Verzeischneße eren schrieve kann.
Donoh donn heh di Saach zohlohße.',
	'config-upload-deleted' => 'Dat Verzeishneß för fottjeschmeße Datteije:',
	'config-upload-deleted-help' => 'Söhk e Verzeijschneß uß för de fottjeschmeße Datteije vum Wiki dren afzelääje.
Et bäß es, wam_mer vum <i lang="en">world wide web</i> doh nit drahn kumme kann.',
	'config-logo' => 'Dem Wiki singem Logo sing <i lang="en">URL</i>:',
	'config-logo-help' => 'De Schtandart_Bedeen_Bovverfläsch vum MediaWiki hät e Logo bovve en der Eck met 135x160 Pixele.
Donn e zopaß Logo huh laade, un donn däm sing URL heh endraare.

Wells De kei Logo han, draach heh nix en.',
	'config-instantcommons' => 'Donn <i lang="en">InstantCommons</i> zohlohße.',
	'config-instantcommons-help' => '<i lang="en">[//www.mediawiki.org/wiki/InstantCommons InstantCommons]</i> es en Eijeschaff, di et för Wikis müjjelesch määt, Belder, Tondatteie un ander Meedijedatteie enzebenge, di op dä Webßait vun de <i lang="en">[//commons.wikimedia.org/ Wikimedia Commons]</i> ongerjebraat sin. Öm dat noze ze künne, moß dä ẞööver vum MediaWiki en Verbendung nohm Internet opnämme künne.

Mieh Aanjaabe doh drövver un en Aanleidung, wi mer och ander Wikis ußer de <i lang="en">Wikimedia Commons</i> doför enreeschte kann, fengk mer em [//mediawiki.org/wiki/Manual:$wgForeignFileRepos Handbooch].',
	'config-cc-error' => 'Et Ußsöhke övver de <i lang="en">Creative Commons</i> iehr Projramm zum Lizänzbeshtemme hät nix jebraat.
Donn de Lizänz sellver beshtemme.',
	'config-cc-again' => 'Noch ens neu ußsöhke&nbsp;…',
	'config-cc-not-chosen' => 'Söhk uß, wat för en Lizänz vun de <i lang="en">Creative Commons</i> De han wells, un donn dann op „<i lang="en">proceed</i>“ klecke.',
	'config-advanced-settings' => 'Fottjeschredde Enshtellunge',
	'config-cache-options' => 'Enshtällunge för et Faßhallde vun Objäkte em Zweschsheisher:',
	'config-cache-help' => 'Objäkte em Zwescheshpeisher faßhallde, dat heiß öff jebruchte Daate en der <i lang="en">cache</i> donn, bruche mer, öm MediaWiki flöcker ze maache,
Meddlere un jruuße Wiki-ẞaits sullte dat onbedengk ußnoze, un och bei klein Wikis weed mer et jood merke.',
	'config-cache-none' => 'Keine Zweschshpeijsher (Et jeid_em Wiki nix verloore, ußer velleish Schnälleshkeid wann vill loss es)',
	'config-cache-accel' => 'Ene Objäk<i lang="en">cache</i> vum PHP (<i lang="en">APC</i>, <i lang="en">XCache</i>, udder <i lang="en">WinCache</i>)',
	'config-cache-memcached' => 'Donn der <code lang="en">memcached</code> ẞööver nämme (Määt extra Enshtellunge un Opsäze nüüdesch)',
	'config-memcached-servers' => 'De <code lang="en">memcached</code> ßöövere:',
	'config-memcached-help' => 'Donn de Leß aanhjävve, met de <i lang="en">IP</i>-Addräße för der <code lang="en">memcached</code> ẞööver ze bruche.
Se sullte ein pro Reih opjeschrevve sin, un en Pooz (<i lang="en">port</i>) ier Nommer han, För e Beishpell, esu:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Do häss der <code lang="en">memcached</code> als Dinge Zoot vun Zwescheshpeijscher aanjejovve, ävver nit eine ẞööver doför.',
	'config-memcache-badip' => 'Do häss en onjöltijje <i lang="en">IP</i>-Addräß för der <code lang="en">memcached</code> ẞööver aanjejovve: $1.',
	'config-memcache-noport' => 'Do has kein Pooz (<code lang="en">port</code>) Nommer aanjejovve för mem <code lang="en">memcached</code> ẞööver ze bruche: $1.
Wann De di Nommer nit weiß, der Shtandatt es 11211.',
	'config-memcache-badport' => 'Dem <code lang="en">memcached</code> ẞööver singe Pooz (<code lang="en">port</code>) Nommere sullte zwesche $1 un $2 sin.',
	'config-extensions' => 'Projramm-Zosätz (<i lang="en">extensions</i>)',
	'config-extensions-help' => 'Di bovve opjeleß Zohsazprojramme för et MediaWiki sin em Verzeischneß <code lang="en">./extensions</code> ald ze fenge.

Do kann se heh un jez aanschallde, ävver se künnte noch zohsäzlesch Enshtellunge bruche.',
	'config-install-alreadydone' => "'''Opjepaß:'''
Et sühd esu uß, wi wann De MediaWiki ald enshtalleet hätß, un wöhrs aam Versöhke, dat norr_ens ze donn.
Jang wigger op de näähßte Sigg.",
	'config-install-begin' => 'Wann De op „{{int:config-continue}}“ klecks, jeiht de Enshtallazjuhn vum MediaWiki loßß.
Wann De noch Änderonge maache wells, dann kleck op „{{int:config-back}}“.',
	'config-install-step-done' => 'jedonn',
	'config-install-step-failed' => 'donävve jejange',
	'config-install-extensions' => 'Zohsazprojramme enjeschloße',
	'config-install-database' => 'Ben de Daatebangk aam ennreeschte.',
	'config-install-schema' => 'Dat Schema en dä Daatebank weed aanjelaat.',
	'config-install-pg-schema-not-exist' => 'Dat Scheema för <i lang="en">PostgreSQL</i> es nit doh.',
	'config-install-pg-schema-failed' => 'Et Tabälle-Opsäze es donävve jejange.
Donn doför sorrje, dat dä Daatebangk-Aanwänder „$1“ en dämm Daatebangkscheema „$2“ schrieve kann.',
	'config-install-pg-commit' => 'Ben de Änderonge aam ennbränge.',
	'config-install-pg-plpgsql' => 'Ben noh dä Daatebangkshprooch <code lang="en">PL/pgSQL</code> aam söhke.',
	'config-pg-no-plpgsql' => 'Do moß de Daatebangkshprooch <code lang="en">PL/pgSQL</code> en dä Daatebangk $1 enreeschte.',
	'config-pg-no-create-privs' => 'Dä Daatebangk-Aanwänder för et Enreeschte hät nit jenooch Rääschde, öm ene andere Daatebangk-Aanwänder en dä Daatebangk aanzelääje.',
	'config-pg-not-in-role' => 'Dä aanjejovve Zohjang för et Web jiddet ald.
Dä aanjejovve Zohjang för et Enschtalleere es keine <i lang="en">superuser<i> un es nit en de Web-Jropp, dröm kam_mer domet kein Dateije aanlääje, di däm Zohjang för et Web jehüüre.

För MeedijaWiki mößße dämm ävver em Momang di Tabälle jehüüre.
Dröm donn ene andere Name för dä Zohjang zom Wäb nämme, udder donn „retuur“ klicke, un jivv ene Zohjang för et Enschtalleere aan, dä jenooch Rääschte hät.',
	'config-install-user' => 'Ben unse Daatebangk-Aanwänder en de Daatebangk am aanlääje.',
	'config-install-user-alreadyexists' => 'Dä Aanwender „$1“ för dä Zohjref op de Daatebangk kann nit aanjelaat wääde, et jidd_en alld.',
	'config-install-user-create-failed' => 'Dä Aanwender „$1“ för dä Zohjref op de Daatebangk kunnt nit aanjelaat wääde, wäje: <code lang="en">$2</code>',
	'config-install-user-grant-failed' => 'Däm Daatebangk-Aanwänder sing Beräschtijunge ze säze däät nit fluppe wääje: $2',
	'config-install-user-missing' => 'Dä aanjejovve Metmaacher „$1“ jidd_et nit.',
	'config-install-user-missing-create' => '{{int:Config-install-user-missing}}<!-- $1 -->
Donn e Höhksche en et Käßje „{{int:Createaccount}}“ onge, wann De dä aanlääje wells.',
	'config-install-tables' => 'Ben de Daatebangk-Tabälle aam aanlääje.',
	'config-install-tables-exist' => "'''Opjepaß''': Et schingk, dem MediaWiki sing Tabälle sin alt doh.
Doh dom_mer nix aanlääje.",
	'config-install-tables-failed' => "'''Fähler''': De Tabälle kunnte nit aanjelaat wääde, wääje: $1",
	'config-install-interwiki' => 'Ben de Engerwiki-Tabäll met de shtandattmääßejje Daate aam fölle.',
	'config-install-interwiki-list' => 'Mer kunnte de Dattei <code lang="en">interwiki.list</code> nit fenge.',
	'config-install-interwiki-exists' => "'''Opjepaß''': En der Engewiki-Tabäll schingk alt jät dren ze shtonn.
Doh dom_mer nix dobei.",
	'config-install-stats' => 'De Shtatestek-Zahle wääde op Aanfang jeshtallt.',
	'config-install-keys' => 'Jeheime Schlößel wääde opjebout.',
	'config-insecure-keys' => "'''Opjepaß:''' {{PLURAL:$2|Ene jeheime Schlößel|Jeheim Schlößele|Keine jeheime Schlößel}} ($1) {{PLURAL:$2|es|sin|es}} automattesch aanjelaat woode. {{PLURAL:$2|Dä es|Di sin|Hä es}} ävver nit onbedengk janz sescher. Övverlääsch Der, {{PLURAL:$2|dä|di|en}} norr_ens vun Hand ze ändere.",
	'config-install-sysop' => 'Dä Zohjang för der Wiki-Köbes weed aanjelaat.',
	'config-install-subscribe-fail' => 'Mer künne de <i lang="en">e-mail</i>-Leß <code lang="en">mediawiki-announce</code> nit abonneere: $1',
	'config-install-subscribe-notpossible' => '<code lang="en">cURL</code> es nit enstalleed un <code lang="en">allow_url_fopen</code>es nit doh.',
	'config-install-mainpage' => 'Ben de Houpsigg med enem shtandatmääßeje Enhald aam aanlääje',
	'config-install-extension-tables' => 'Ben Datebangk-Tabälle för de Zohsazprojramme aam ennreschte',
	'config-install-mainpage-failed' => 'Kunnt de Houpsigg nit afshpeishere: $1',
	'config-install-done' => "'''Jlöckwonsch!'''
MediaWiki es jetz enstalleet.

Et Projramm zom Enreeschte hät en Dattei <code lang=\"en\">LocalSettings.php</code> aanjelaat.
Doh sin de Enstellunge vum Wiki dren.

Do weeß se eronge laade möße un dann en dem Wiki sing Aanfangsverzeishnes donn möße, et sellve Verzeisneß, woh di Dattei <code lang=\"en\">index.php</code> dren litt. Dat Erongerlaade sullt automattesch aanjefange han.

Wann domet jet nit jeflupp hät, udder De di Dattei norr_ens han wells, donn op dä Lengk heh dronger klecke:

\$3

'''Opjepaß''': Wann De dat jez nit deihß, es alles verschött, wat De bes jöz enjejovve häs, weil di Dattei fott es en däm Momang, woh heh dat Projamm aam Engk es.

Wann De mem Ronger- un widder Huhlaade fäädesh bes, kanns De '''[\$2 en Ding Wiki jonn]'''.",
	'config-download-localsettings' => 'Donn di Dattei <code lang="en">LocalSettings.php</code> eronger laade',
	'config-help' => 'Hölp',
	'config-nofile' => 'De Dattei „$1“ ham_mer nit jefonge. Es di fottjeschmeße?',
	'mainpagetext' => "'''MediaWiki es jetz enstalleet.'''",
	'mainpagedocfooter' => 'Luur en et (änglesche) [//meta.wikimedia.org/wiki/Help:Contents Handboch] wann De wesse wells wie de Wiki-Soffwär jebruch un bedeent wääde muss.

== För dä Aanfang ==
Dat es och all op Änglesch:
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 */
$messages['ku-latn'] = array(
	'config-information' => 'Agahî',
	'config-your-language' => 'Zimanê te:',
	'config-page-language' => 'Ziman',
	'config-page-name' => 'Nav',
	'config-page-options' => 'Vebijêrk',
	'config-ns-generic' => 'Proje',
	'config-install-step-done' => 'çêbû',
	'config-help' => 'alîkarî',
	'mainpagetext' => "'''MediaWiki serketî hate çêkirin.'''",
	'mainpagedocfooter' => 'Alîkarî ji bo bikaranîn û guherandin yê datayê Wîkî tu di bin [//meta.wikimedia.org/wiki/Help:Contents pirtûka alîkarîyê ji bikarhêneran] da dikarê bibînê.

== Alîkarî ji bo destpêkê ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lîsteya varîyablên konfîgûrasîyonê]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lîsteya e-nameyên versyonên nuh yê MediaWiki]',
);

/** Ladino (Ladino)
 * @author Universal Life
 */
$messages['lad'] = array(
	'mainpagetext' => "'''MedyaViki ya se kureó con reuxitá.'''",
	'mainpagedocfooter' => 'Konsulta la [//meta.wikimedia.org/wiki/Ayudo:Contenido Guía de usador] para tomar enformasyones encima de como usar el lojikal viki.

== En Empeçando ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings La lista de los arreglamientos de la konfiggurasyón]
* [//www.mediawiki.org/wiki/Manual:FAQ/lad DDS de MedyaViki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce La lista de las letrales (e-mail) de MedyaViki]',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'config-desc' => 'Den Installatiounsprogramm vu MediaWiki',
	'config-title' => 'MediaWiki $1 Installatioun',
	'config-information' => 'Informatioun',
	'config-localsettings-upgrade' => "'''Opgepasst''': E Fichier <code>LocalSettings.php</code> gouf fonnt.
Är Software kann aktualiséiert ginn, setzt w.e.g. de Wäert vum <code>\$wgUpgradeKey</code> an d'Këscht.
Dir fannt en am LocalSettings.php.",
	'config-localsettings-key' => 'Aktualisatiounsschlëssel:',
	'config-localsettings-badkey' => 'De Schlëssel deen Dir aginn hutt ass net korrekt',
	'config-localsettings-incomplete' => 'De Fichier LocalSettings.php schéngt net komplett ze sinn.
D\'Variabel $1 ass net definéiert.
Ännert w.e.g. de Fichier LocalSettings.php esou datt déi Variabel definéiert ass a klickt op "Virufueren".',
	'config-session-error' => 'Feeler beim Starte vun der Sessioun: $1',
	'config-no-session' => "D'Donnéeë vun ärer Sessioun si verluergaangen!
Kuckt Är php.ini no a vergewëssert Iech datt <code>session.save_path</code>  op adequate REpertoire agestallt ass.",
	'config-your-language' => 'Är Sprooch',
	'config-your-language-help' => 'Sicht déi Sprooch eraus déi Dir während der Installatioun benotze wëllt',
	'config-wiki-language' => 'Sprooch vun der Wiki:',
	'config-wiki-language-help' => "Sicht d'Sprooch eraus an där d'Wiki haaptsächlech geschriwwe gëtt.",
	'config-back' => '← Zréck',
	'config-continue' => 'Weider →',
	'config-page-language' => 'Sprooch',
	'config-page-welcome' => 'Wëllkomm bäi MediaWiki!',
	'config-page-dbconnect' => 'Mat der Datebank verbannen',
	'config-page-upgrade' => 'Eng Installatioun déi besteet aktualiséieren',
	'config-page-dbsettings' => 'Astellunge vun der Datebank',
	'config-page-name' => 'Numm',
	'config-page-options' => 'Optiounen',
	'config-page-install' => 'Installéieren',
	'config-page-complete' => 'Fäerdeg!',
	'config-page-restart' => 'Installatioun neistarten',
	'config-page-readme' => 'Liest dëst',
	'config-page-releasenotes' => 'Informatiounen zur Versioun',
	'config-page-copying' => 'Kopéieren',
	'config-page-upgradedoc' => 'Aktualiséieren',
	'config-page-existingwiki' => 'Wiki déi et gëtt',
	'config-help-restart' => 'Wëllt dir all gespäichert Donnéeë läschen déi dir bis elo aginn hutt an den Installatiounsprozess nei starten?',
	'config-restart' => 'Jo, neistarten',
	'config-welcome' => "=== Iwwerpréifung vum Installatiounsenvironnement ===
Et gi grondsätzlech Iwwerpréifunge gemaach fir ze kucken ob den Environnment gëeegent ass fir MediaWiki z'installéieren.
Dir sollt d'Resultater vun dëser Iwwerpréifung ugi wann Dir während der Installatioun Hëllef braucht.",
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki Haaptsäit]
* [//www.mediawiki.org/wiki/Help:Contents Benotzerguide]
* [//www.mediawiki.org/wiki/Manual:Contents Guide fir Administrateuren]
* [//www.mediawiki.org/wiki/Manual:FAQ FAQ]
----
* <doclink href=Readme>Liest dëst</doclink>
* <doclink href=ReleaseNotes>Informatioune vun der aktueller Versioun</doclink>
* <doclink href=Copying>Lizenzbedingungen</doclink>
* <doclink href=UpgradeDoc>Aktualisatioun</doclink>',
	'config-env-good' => 'Den Environement gouf nogekuckt.
Dir kënnt MediaWiki installéieren.',
	'config-env-bad' => 'Den Environnement gouf iwwerpréift.
Dir kënnt MediWiki net installéieren.',
	'config-env-php' => 'PHP $1 ass installéiert.',
	'config-env-php-toolow' => 'PHP $1 ass installéiert.
Awer MediaWiki brauch PHP $2 oder méi héich.',
	'config-unicode-using-utf8' => "Fir d'Unicode-Normalisatioun gëtt dem Brion Vibber säin <code>utf8_normalize.so</code> benotzt.",
	'config-no-db' => "Et konnt kee passenden Datebank-Driver fonnt ginn! Dir musst een Datebank-Driver fir PHP installéieren.
Dës Datebank-Type ginn ënnerstëtzt: $1.

Wann Dir op engem gesharte Server sidd, da frot Ären Hosting-Provider fir de passenden Datebank-Driver z'installéieren.
Wann Dir PHP selwer compiléiert hutt, da reconfiguréiert en mat dem ageschalten Datebank-Client, zum Beispill an deem Dir <code>./configure --with-mysql</code> benotzt.
Wann Dir PHP vun engem Debian oder Ubuntu Package aus installéiert hutt, da musst Dir och den php5-mysql Modul installéieren.",
	'config-memory-bad' => "'''Opgepasst:''' De Parameter <code>memory_limit</code> vu PHP ass $1.
Dat ass wahrscheinlech ze niddreg.
D'Installatioun kéint net fonctionnéieren.",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] ass installéiert',
	'config-apc' => '[http://www.php.net/apc APC] ass installéiert',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] ass installéiert',
	'config-diff3-bad' => 'GNU diff3 gouf net fonnt.',
	'config-no-uri' => "'''Feeler:''' Déi aktuell URI konnt net festgestallt ginn.
Installatioun ofgebrach.",
	'config-using-server' => 'De Servernumm "<nowiki>$1</nowiki>" gëtt benotzt.',
	'config-db-type' => 'Datebanktyp:',
	'config-db-host-oracle' => 'Datebank-TNS:',
	'config-db-wiki-settings' => 'Dës Wiki identifizéieren',
	'config-db-name' => 'Numm vun der Datebank:',
	'config-db-name-oracle' => 'Datebankschema:',
	'config-db-install-account' => "Benotzerkont fir d'Installatioun",
	'config-db-username' => 'Datebank-Benotzernumm:',
	'config-db-password' => 'Passwuert vun der Datebank:',
	'config-db-install-help' => 'Gitt de Benotzernumm an Passwuert an dat wàhrend der Installatioun benotzt gëtt fir sech mat der Datebank ze verbannen.',
	'config-db-account-lock' => 'De selwechte Benotzernumm a Passwuert fir déi normal Operatioune benotzen',
	'config-db-wiki-account' => 'Benotzerkont fir normal Operatiounen',
	'config-db-wiki-help' => "Gitt de Benotzernumm an d'Passwuert an dat benotzt wäert gi fir sech bei den normale Wiki-Operatiounen mat der Datebank ze connectéieren.
Wann et de Kont net gëtt, a wann den Installatiouns-Kont genuch Rechter huet, gëtt dëse Benotzerkont opgemaach mat dem Minimum vu Rechter déi gebraucht gi fir dës Wiki bedreiwen ze kënnen.",
	'config-db-charset' => 'Zeechesaz (character set) vun der Datebank',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binair',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-mysql-old' => 'MySQL $1 oder eng méi nei Versioun gëtt gebraucht, Dir hutt $2.',
	'config-db-port' => 'Port vun der Datebank:',
	'config-db-schema' => 'Schema fir MediaWiki',
	'config-db-schema-help' => "D'Schemaen hei driwwer si gewéinlech korrekt.
Ännert se nëmme wann Dir wësst datt et néideg ass.",
	'config-pg-test-error' => "Et ass net méiglech d'Datebank '''$1''' ze kontaktéieren: $2",
	'config-sqlite-dir' => 'Repertoire vun den SQLite-Donnéeën',
	'config-oracle-def-ts' => "Standard 'tablespace':",
	'config-oracle-temp-ts' => "Temporären 'tablespace':",
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-ibm_db2' => '* $1 ass eng kommerziell Firma fir Datebanken',
	'config-header-mysql' => 'MySQL-Astellungen',
	'config-header-postgres' => 'PostgreSQL-Astellungen',
	'config-header-sqlite' => 'SQLite-Astellungen',
	'config-header-oracle' => 'Oracle-Astellungen',
	'config-header-ibm_db2' => 'IBM DB2-Astellungen',
	'config-invalid-db-type' => 'Net valabelen Datebank-Typ',
	'config-missing-db-name' => 'Dir musst en Numm fir de Wäert "Numm vun der Datebank" uginn',
	'config-missing-db-host' => 'Dir musst e Wäert fir "Database host" uginn',
	'config-missing-db-server-oracle' => 'Dir musst e Wäert fir "Datebank-TNS" uginn',
	'config-db-sys-user-exists-oracle' => 'De Benotzerkont "$1" gëtt et schonn. SYSDBA kann nëmme benotzt gi fir en neie Benotzerkont opzemaachen.',
	'config-postgres-old' => 'PostgreSQL $1 oder eng méi nei Versioun gëtt gebraucht, Dir hutt $2.',
	'config-sqlite-name-help' => 'Sicht en Numm deen Är wiki identifizéiert.
Benotzt keng Espacen a Bindestrécher.
E gëtt fir den Numm vum SQLite Date-Fichier benotzt.',
	'config-sqlite-readonly' => 'An de Fichier <code>$1</code> Kann net geschriwwe ginn.',
	'config-sqlite-cant-create-db' => 'Den Datebank-Fichier <code>$1</code> konnt net ugeluecht ginn.',
	'config-upgrade-done-no-regenerate' => "D'Aktualisatioun ass ofgeschloss.

Dir kënnt elo [$1 ufänken Är Wiki ze benotzen]",
	'config-regenerate' => 'LocalSettings.php regeneréieren →',
	'config-db-web-account' => 'Datebankkont fir den Accès iwwer de Web',
	'config-db-web-account-same' => 'Dee selwechte Kont wéi bei der Installatioun benotzen',
	'config-db-web-create' => 'De Kont uleeë wann et e net scho gëtt',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-binary' => 'binär',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Numm vun der Wiki:',
	'config-site-name-help' => 'Dësen daucht an der Titelleescht vum Browser an op verschiddenen anere Plazen op.',
	'config-site-name-blank' => 'Gitt den Numm vum Site un.',
	'config-project-namespace' => 'Projet Nummraum:',
	'config-ns-generic' => 'Projet',
	'config-ns-site-name' => 'Deeselwechte wéi den Numm vun der Wiki: $1',
	'config-ns-other' => 'Anerer (spezifizéieren)',
	'config-ns-other-default' => 'MyWiki',
	'config-admin-box' => 'Administrateurs-Kont',
	'config-admin-name' => 'Ären Numm:',
	'config-admin-password' => 'Passwuert:',
	'config-admin-password-confirm' => 'Passwuert confirméieren:',
	'config-admin-help' => 'Gitt w.e.g. Äre gewënschte Benotzernumm hei an, zum Beispill "Jang Muller".
Dësen Numm gëtt da gebraucht fir sech an d\'Wiki anzeloggen.',
	'config-admin-name-blank' => 'Gitt e Benotzernumm fir den Administrateur an.',
	'config-admin-name-invalid' => 'De spezifizéierte Benotzernumm "<nowiki>$1</nowiki>" ass net valabel.
Spezifizéiert en anere Benotzernumm.',
	'config-admin-password-blank' => 'Gitt e Passwuert fir den Adminstateur-Kont an.',
	'config-admin-password-same' => "D'Passwuert däerf net dat selwecht si wéi de Benotzernumm.",
	'config-admin-password-mismatch' => 'Déi zwee Passwierder Déi dir aginn stëmmen net iwwerteneen.',
	'config-admin-email' => 'E-Mailadress:',
	'config-admin-error-user' => 'Interne Feeler beim uleeë vun engem Administrateur mam Numm "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Interne Feeler beim Setze vum Passwuert fir den Admin "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'Dir hutt eng E-Mailadress aginn déi net valabel ass',
	'config-subscribe' => "Sech op d'[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Ukënnegunge vun neie Versiounen] abonnéieren.",
	'config-almost-done' => "Dir sidd bal fäerdeg!
Dir kënnt elo déi Astellungen déi nach iwwreg sinn iwwersprangen an d'Wiki elo direkt installéieren.",
	'config-optional-continue' => 'Stellt mir méi Froen.',
	'config-optional-skip' => "Ech hunn es genuch, installéier just d'Wiki.",
	'config-profile' => 'Profil vun de Benotzerrechter:',
	'config-profile-wiki' => 'Traditionell Wiki',
	'config-profile-no-anon' => 'Uleeë vun engem Benotzerkont verlaangt',
	'config-profile-fishbowl' => 'Nëmmen autoriséiert Editeuren',
	'config-profile-private' => 'Privat Wiki',
	'config-license' => 'Copyright a Lizenz:',
	'config-license-none' => 'Keng Lizenz ënnen op der Säit',
	'config-license-pd' => 'Ëffentlechen Domaine',
	'config-email-settings' => 'E-Mail-Astellungen',
	'config-enable-email' => 'E-Mailen déi no bausse ginn aschalten',
	'config-email-user' => 'Benotzer-op-Benotzer E-Mail aschalten',
	'config-email-usertalk' => 'Benoriichtege bäi Ännerung vun der Benotzerdiskussiounssäit aschalten',
	'config-email-watchlist' => 'Benoriichtigung vun der Iwwerwaachungslëscht aschalten',
	'config-email-auth' => 'E-Mail-Authentifizéierung aschalten',
	'config-email-sender' => 'E-Mailadress fir Äntwerten:',
	'config-upload-settings' => 'Eropgeluede Biller a Fichieren',
	'config-upload-enable' => 'Eropluede vu Fichieren aschalten',
	'config-upload-deleted' => 'Repertoire fir geläschte Fichieren:',
	'config-logo' => 'URL vum Logo:',
	'config-instantcommons' => '"Instant Commons" aktivéieren',
	'config-cc-again' => 'Nach eng kéier eraussichen...',
	'config-advanced-settings' => 'Erweidert Astellungen',
	'config-extensions' => 'Erweiderungen',
	'config-install-step-done' => 'fäerdeg',
	'config-install-step-failed' => 'huet net fonctionnéiert',
	'config-install-extensions' => 'Mat den Ereiderungen',
	'config-install-database' => 'Datebank gëtt installéiert',
	'config-pg-no-plpgsql' => "Fir d'Datebank $1 muss d'Datebanksprooch PL/pgSQL installéiert ginn",
	'config-install-user' => 'Datebank Benotzer uleeën',
	'config-install-user-alreadyexists' => 'De Benotzer "$1" gëtt et schonn!',
	'config-install-user-create-failed' => 'D\'Opmaache vum Benotzer "$1" huet net fonctionnéiert: $2',
	'config-install-user-missing' => 'De Benotzer "$1" deen ugi gouf gëtt et net.',
	'config-install-tables' => 'Tabelle ginn ugeluecht',
	'config-install-interwiki' => 'Standard Interwiki-Tabell gëtt ausgefëllt',
	'config-install-interwiki-list' => 'De Fichier <code>interwiki.list</code> gouf net fonnt.',
	'config-install-stats' => 'Initialisatioun vun de Statistiken',
	'config-install-keys' => 'Generéiere vum Geheimschlëssel',
	'config-install-sysop' => 'Administrateur Benotzerkont gëtt ugeluecht',
	'config-install-extension-tables' => "D'Tabelle fir déi aktivéiert Erweiderunge ginn ugeluecht",
	'config-install-mainpage-failed' => "D'Haaptsäit konnt net dragesat ginn: $1",
	'config-download-localsettings' => 'LocalSettings.php eroflueden',
	'config-help' => 'Hëllef',
	'config-nofile' => 'De Fichier "$1" gouf net fonnt. Gouf e geläscht?',
	'mainpagetext' => "'''MediaWiki gouf installéiert.'''",
	'mainpagedocfooter' => "Kuckt w.e.g. [//meta.wikimedia.org/wiki/Help:Contents d'Benotzerhandbuch] fir den Interface ze personnaliséieren.

== Starthëllefen ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Hëllef bei der Konfiguratioun]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailinglëscht vun neie MediaWiki-Versiounen]",
);

/** Lingua Franca Nova (Lingua Franca Nova)
 */
$messages['lfn'] = array(
	'mainpagetext' => "'''MediaWiki es aora instalada.'''",
	'mainpagedocfooter' => 'Atenda la [//meta.wikimedia.org/wiki/Help:Contents Gida per Usores] per informa supra la usa de la programa de vici.

== Comensa ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista de ajustas de la desinia]
* [//www.mediawiki.org/wiki/Manual:FAQ Demandas comun de MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista per receta anunsias de novas supra MediaWiki]',
);

/** Ganda (Luganda)
 * @author Kizito
 */
$messages['lg'] = array(
	'mainpagetext' => 'MediaWiki kati ewangidwa ku sisitemu yo',
	'mainpagedocfooter' => "Okuyiga ku nkozesa ya sofutiweya owa wiki, kebera [//meta.wikimedia.org/wiki/Help:Contents Okulagirira Abakozesa].

== Amagezi agakuyamba okutandika ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lukalala lw'eby'enteekateeka yo]
* [//www.mediawiki.org/wiki/Manual:FAQ Ebiter'okubuuzibwa ku MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Wewandise ofunenga amawulire aga email ag'ebifa ku MediaWiki]",
);

/** Limburgish (Limburgs)
 */
$messages['li'] = array(
	'mainpagetext' => "'''MediaWiki software succesvol geïnsjtalleerd.'''",
	'mainpagedocfooter' => "Raodpleeg de [//meta.wikimedia.org/wiki/NL_Help:Inhoudsopgave handjleiding] veur informatie euver 't gebroek van de wikisoftware.

== Mieë hölp ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lies mit instellinge]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki VGV (FAQ)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki mailinglies veur nuuj versies]",
);

/** Lao (ລາວ)
 */
$messages['lo'] = array(
	'mainpagetext' => "'''ຕິດຕັ້ງມີເດຍວິກິນີ້ສຳເລັດແລ້ວ.'''",
);

/** Lithuanian (lietuvių)
 */
$messages['lt'] = array(
	'mainpagetext' => "'''MediaWiki sėkmingai įdiegta.'''",
	'mainpagedocfooter' => 'Informacijos apie wiki programinės įrangos naudojimą, ieškokite [//meta.wikimedia.org/wiki/Help:Contents žinyne].

== Pradžiai ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Konfigūracijos nustatymų sąrašas]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki DUK]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki pranešimai paštu apie naujas versijas]',
);

/** Latvian (latviešu)
 * @author GreenZeb
 */
$messages['lv'] = array(
	'config-back' => '← Atpakaļ',
	'config-continue' => 'Turpināt →',
	'config-page-language' => 'Valoda',
	'config-page-welcome' => 'Laipni lūdzam MediaWiki!',
	'config-page-dbconnect' => 'Savienoties ar datubāzi',
	'config-page-upgrade' => 'Atjaunināt pašreizējo instalāciju',
	'config-page-dbsettings' => 'Datubāzes iestatījumi',
	'config-page-name' => 'Vārds',
	'config-page-options' => 'Iespējas',
	'config-page-install' => 'Instalēt',
	'config-page-complete' => 'Pabeigts!',
	'config-page-restart' => 'Pārstartēt instalāciju',
	'config-page-readme' => 'Lasīt mani',
	'config-page-releasenotes' => 'Informācija par laidienu',
	'mainpagetext' => "'''MediaWiki veiksmīgi ieinstalēts'''",
	'mainpagedocfooter' => 'Izlasi [//meta.wikimedia.org/wiki/Help:Contents Lietotāja pamācību], lai iegūtu vairāk informācijas par Wiki programmatūras lietošanu.

== Pirmie soļi ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Konfigurācijas iespēju saraksts]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki J&A]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Parakstīties uz paziņojumiem par jaunām MediaWiki versijām]',
);

/** Literary Chinese (文言)
 */
$messages['lzh'] = array(
	'mainpagetext' => "'''共筆臺已立'''",
	'mainpagedocfooter' => "欲識維基，見[//meta.wikimedia.org/wiki/Help:Contents User's Guide]

== 始 ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Lazuri (Lazuri)
 * @author Bombola
 */
$messages['lzz'] = array(
	'mainpagetext' => "'''Mediawiki dido k'ai ik'idu.'''",
	'mainpagedocfooter' => "Vik'i şeni muç'o ixmarinen ya mutxanepe oguru şeni [//meta.wikimedia.org/wiki/Help:Contents oxmaruşi rexberis] o3'k'edit.

== Ağani na gyoç’k’u maxmarepe ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Ok'iduşi ayarepeşi liste]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki P'anda Na-k'itxu K'itxalape]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki e-mailepeşiş liste]",
);

/** Maithili (मैथिली)
 * @author Umeshberma
 */
$messages['mai'] = array(
	'mainpagetext' => "'''मीडियाविकी नीक जकाँ प्रस्थापित भेल।'''",
	'mainpagedocfooter' => "सम्पर्क करू [//meta.wikimedia.org/wiki/Help:Contents User's Guide] विकी तंत्रांशक प्रयोगक जानकारी लेल।

==प्रारम्भ कोना करी==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Moksha (мокшень)
 */
$messages['mdf'] = array(
	'mainpagetext' => "'''МедиаВикить арафтозь лац.'''",
	'mainpagedocfooter' => 'Ванк [//meta.wikimedia.org/wiki/Help:Contents Ветямовал Тиинди] тяса ули кода содамс Вики програпнень эрявикснень колга.

== Эрявикс сюлмафксне ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Васьфневи арафнематнень кярькссь]
* [//www.mediawiki.org/wiki/Manual:FAQ МедиаВикить Сидеста Кеподеви Кизефксне]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce МедиаВикить од верзиятнень колга кулянь пачфтема]',
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'config-session-error' => 'Hadisoana teo am-panombohana ny fidirana : $1',
	'config-your-language' => 'Ny fiteninao :',
	'config-wiki-language' => "Fiteny ho ampiasain'ny wiki :",
	'config-back' => '← Miverina',
	'config-continue' => 'Manohy →',
	'config-page-language' => 'Fiteny',
	'config-page-welcome' => "Tonga soa eto amin'i MediaWiki !",
	'config-page-dbconnect' => "Hiditra eo amin'i banky angona",
	'config-page-name' => 'Anarana',
	'config-page-readme' => 'Vakio aho',
	'config-page-copying' => 'Hala-tahaka',
	'config-page-upgradedoc' => 'Fanavaozina',
	'config-page-existingwiki' => 'Wiki efa misy',
	'config-help-restart' => "Tianao hofafana avokoa ve ny data voaangona natsofokao ary hamerina ny fizotran'ny fametrahana ?",
	'config-restart' => 'Eny, avereno atao',
	'config-db-username' => "Anaram-pikamban'ny banky angona :",
	'config-db-password' => "Tenimiafin'ny banky angona :",
	'config-header-mysql' => "Parametatr'i MySQL",
	'config-header-sqlite' => "Parametatr'i SQLite",
	'config-header-oracle' => "Parametatr'i Oracle",
	'config-mysql-innodb' => 'innoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-ns-generic' => 'Tetikasa',
	'config-ns-other' => 'Hafa (lazao)',
	'config-admin-name' => 'Ny anaranao :',
	'config-admin-password' => 'Tenimiafina :',
	'config-admin-email' => 'Adiresy imailaka :',
	'config-profile-wiki' => 'Wiki tsotra',
	'config-profile-no-anon' => 'Mila mamorona kaonty',
	'config-profile-fishbowl' => 'Mpanova mahazo alalana ihany',
	'config-profile-private' => 'Wiki tsy sarababem-bahoaka',
	'config-license' => 'Zom-pamorona ary lisansa :',
	'config-license-none' => 'Tsy misy lisansa any an-tongom-pejy',
	'config-email-user' => 'Avela mifandefa imailaka ny mpikambana',
	'config-email-user-help' => "Hahafahan'ny mpikambana mifandefa imailaka raha omen'ny mpikambana alalana ao amin'ny safidiny.",
	'config-upload-deleted' => "Petra-drakitra ho an'ny rakitra voafafa :",
	'config-extensions' => 'Fanitarana',
	'config-install-step-done' => 'vita',
	'config-install-step-failed' => 'hadisoana',
	'config-install-user' => "Famoronana mpapiasan'ny banky angona",
	'config-install-tables' => 'Famoronana tabilao',
	'config-install-stats' => 'Fanombohana ny statistika',
	'config-install-keys' => 'Fanamboarana lakile miafina',
	'config-help' => 'fanoroana',
	'mainpagetext' => "'''Tafajoro soa aman-tsara ny rindrankajy Wiki.'''",
	'mainpagedocfooter' => "Vangio ny [//meta.wikimedia.org/wiki/Aide:Contenu Fanoroana ho an'ny mpampiasa] ra te hitady fanoroana momba ny fampiasan'ity rindrankajy ity.

== Hanomboka amin'ny MediaWiki ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lisitra ny paramètre de configuration]
* [//www.mediawiki.org/wiki/Manual:FAQ/fr FAQ momba ny MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Resaka momba ny fizaràn'ny MediaWiki]",
);

/** Eastern Mari (олык марий)
 */
$messages['mhr'] = array(
	'mainpagetext' => "'''MediaWiki сай шындыме.'''",
);

/** Minangkabau (Baso Minangkabau)
 * @author Luthfi94
 */
$messages['min'] = array(
	'mainpagetext' => "'''MediaWiki alah tapasang jo sukses'''.",
	'mainpagedocfooter' => 'Silakan baco [//www.mediawiki.org/wiki/Help:Contents/id Panduan Pangguno] untuak caro panggunoan parangkaik lunak wiki iko.

== Mamulai panggunoan ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings/id Dafta pangaturan konfigurasi]
* [//www.mediawiki.org/wiki/Manual:FAQ/id Dafta patanyoan nan acok diajukan manganai MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Milis rilis MediaWiki]',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'config-desc' => 'Инсталатор на МедијаВики',
	'config-title' => 'Инсталатор на МедијаВики $1',
	'config-information' => 'Информации',
	'config-localsettings-upgrade' => 'Востановена е податотека <code>LocalSettings.php</code>.
За да ја надградите инсталцијава, внесете ја вредноста на <code>$wgUpgradeKey</code> во полето подолу.
Тоа е го најдете во LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Утврдено е присуството на податотеката „LocalSettings.php“.
За да ја надградите инсталацијата, пуштете ја „update.php“ наместо горенаведената.',
	'config-localsettings-key' => 'Надградбен клуч:',
	'config-localsettings-badkey' => 'Клучот што го наведовте е погрешен',
	'config-upgrade-key-missing' => 'Востановена е постоечка инсталација на МедијаВики.
За да ја надградите, вметнете го следниов ред на дното од вашата страница LocalSettings.php:

$1',
	'config-localsettings-incomplete' => 'Постоечката страница LocalSettings.php е нецелосна.
Не е поставена променливата $1.
Изменете ја страницата LocalSettings.php така што ќе ѝ зададете вредност на променливата, па стиснете на „Продолжи“.',
	'config-localsettings-connection-error' => 'Се појави грешка при поврзувањето со базата користејќи ги поставките назначени во LocalSettings.php или AdminSettings.php. Исправете ги овие поставки и обидете се повторно.

$1',
	'config-session-error' => 'Грешка при започнување на сесијата: $1',
	'config-session-expired' => 'Вашите сесиски податоци истекоа.
Поставките на сесиите траат $1.
Нивниот рок можете да го зголемите со задавање на <code>session.gc_maxlifetime</code> во php.ini.
Почнете ја инсталацијата одново.',
	'config-no-session' => 'Вашите сесиски податоци се изгубени!
Погледајте во php.ini дали <code>session.save_path</code> е поставен во правилна папка.',
	'config-your-language' => 'Вашиот јазик:',
	'config-your-language-help' => 'Одберете на кој јазик да се одвива инсталацијата.',
	'config-wiki-language' => 'Јазик на викито:',
	'config-wiki-language-help' => 'Одберете на кој јазик ќе бидат содржините на викито.',
	'config-back' => '← Назад',
	'config-continue' => 'Продолжи →',
	'config-page-language' => 'Јазик',
	'config-page-welcome' => 'Добредојдовте на МедијаВики!',
	'config-page-dbconnect' => 'Поврзување со базата',
	'config-page-upgrade' => 'Надградба на постоечката инсталација',
	'config-page-dbsettings' => 'Нагодувања на базата',
	'config-page-name' => 'Назив',
	'config-page-options' => 'Поставки',
	'config-page-install' => 'Инсталирај',
	'config-page-complete' => 'Готово!',
	'config-page-restart' => 'Пушти ја инсталацијата одново',
	'config-page-readme' => 'Прочитај ме',
	'config-page-releasenotes' => 'Белешки за изданието',
	'config-page-copying' => 'Копирање',
	'config-page-upgradedoc' => 'Надградба',
	'config-page-existingwiki' => 'Постоечко вики',
	'config-help-restart' => 'Дали сакате да ги исчистите сите зачувани податоци што ги внесовте и да ја започнете инсталацијата одново?',
	'config-restart' => 'Да, почни одново',
	'config-welcome' => '=== Environmental checks ===
Се вршат основни проверки за да се востанови дали околината е погодна за инсталирање на МедијаВики.
Ако ви затреба помош при инсталацијата, ќе треба да ги наведете резултатите од овие проверки.',
	'config-copyright' => "=== Авторски права и услови ===

$1

Ова е слободна програмска опрема (free software); можете да го редистрибуирате и/или менувате согласно условите на ГНУ-овата општа јавна лиценца (GNU General Public License) на Фондацијата за слободна програмска опрема (Free Software Foundation); верзија 2 или било која понова верзија на лиценцата (по ваш избор).

Овој програм се нуди со надеж дека ќе биде корисен, но '''без никаква гаранција'''; дури ни подразбраната гаранција за '''продажна способност''' или '''погодност за определена цел'''.
Повеќе информации ќе најдете во текстот на ГНУ-овата општа јавна лиценца.

Би требало да имате добиено <doclink href=Copying>примерок од ГНУ-овата општа јавна лиценца</doclink> заедно со програмов; ако немате добиено, тогаш пишете ни на Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA. или [http://www.gnu.org/copyleft/gpl.html прочитајте ја тука].",
	'config-sidebar' => '* [//www.mediawiki.org Домашна страница на МедијаВики]
* [//www.mediawiki.org/wiki/Help:Contents Водич за корисници]
* [//www.mediawiki.org/wiki/Manual:Contents Водич за администратори]
* [//www.mediawiki.org/wiki/Manual:FAQ ЧПП]
----
* <doclink href=Readme>Прочитај ме</doclink>
* <doclink href=ReleaseNotes>Белешки за изданието</doclink>
* <doclink href=Copying>Копирање</doclink>
* <doclink href=UpgradeDoc>Надградување</doclink>',
	'config-env-good' => 'Околината е проверена.
Можете да го инсталирате МедијаВики.',
	'config-env-bad' => 'Околината е проверена.
Не можете да го инсталирате МедијаВики.',
	'config-env-php' => 'PHP $1 е инсталиран.',
	'config-env-php-toolow' => 'PHP $1 е инсталиран.
Меѓутоа, МедијаВики бара PHP $2 или поново.',
	'config-unicode-using-utf8' => 'Со utf8_normalize.so за уникодна нормализација од Брајон Вибер (Brion Vibber).',
	'config-unicode-using-intl' => 'Со додатокот [http://pecl.php.net/intl intl PECL] за уникодна нормализација.',
	'config-unicode-pure-php-warning' => "'''Предупредување''': Додатокот [http://pecl.php.net/intl intl PECL] не е достапен за врши уникодна нормализација, враќајќи се на бавна примена на чист PHP.

Ако имате високопрометно мрежно место, тогаш ќе треба да прочитате повеќе за [//www.mediawiki.org/wiki/Unicode_normalization_considerations уникодната нормализација].",
	'config-unicode-update-warning' => "'''Предупредување''': Инсталираната верзија на обвивката за уникодна нормализација користи постара верзија на библиотеката на [http://site.icu-project.org/ проектот ICU].
За да користите Уникод, ќе треба да направите [//www.mediawiki.org/wiki/Unicode_normalization_considerations надградба].",
	'config-no-db' => 'Не можев да пронајдам соодветен двигател за базата на податоци! Ќе треба да инсталирате двигател за базата на податоци за PHP.
Поддржани се следниве типови на бази $1.

Ако сте на заедничко (споделено) вдомување, побарајте му на вдомителот да инсталира соодветен двигател за базата.
Ако вие самите го составивте ова PHP, сменете ги поставките така што ќе овозможите клиент на базата - на пр. со кодот <code>./configure --with-mysql</code>.
Ако инсталиравте PHP од пакет на Debian или Ubuntu, тогаш ќе треба да го инсталирате и модулот php5-mysql.',
	'config-outdated-sqlite' => "'''Предупредување''': имате SQLite $1. Најстарата допуштена верзија е $2. Затоа, SQLite ќе биде недостапен.",
	'config-no-fts3' => "'''Предупредување''': SQLite iе составен без модулот [//sqlite.org/fts3.html FTS3] - за оваа база нема да има можност за пребарување.",
	'config-register-globals' => "'''Предупредување: Можноста <code>[http://php.net/register_globals register_globals]</code> за PHP е овозможена.'''
'''Оневозможете ја ако е можно.'''
МедијаВики ќе работи, но опслужувачот ви е изложен на безбедносни ризици.",
	'config-magic-quotes-runtime' => "'''Кобно: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] е активно!'''
Оваа можност непредвидливо го расипува вносот на податоци.
Оваа можност мора да е исклучена. Во спротивно нема да можете да го инсталирате и користите МедијаВики.",
	'config-magic-quotes-sybase' => "'''Кобно: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] е активно!'''
Оваа можност непредвидливо го расипува вносот на податоци.
Оваа можност мора да е исклучена. Во спротивно нема да можете да го инсталирате и користите МедијаВики.",
	'config-mbstring' => "'''Кобно: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] е активно!'''
Оваа можност предизвикува грешки и може непредвидиво да го расипува вносот на податоци.
Оваа можност мора да е исклучена. Во спротивно нема да можете да го инсталирате и користите МедијаВики.",
	'config-ze1' => "'''Кобно: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] е активно!'''
Оваа можност предизвикува ужасни грешки во МедијаВики.
Оваа можност мора да е исклучена. Во спротивно нема да можете да го инсталирате и користите МедијаВики.",
	'config-safe-mode' => "'''Предупредување:''' [http://www.php.net/features.safe-mode безбедниот режим] на PHP е активен.
Ова може да предизвика проблеми, особено ако користите подигања и поддршка за <code>math</code>.",
	'config-xml-bad' => 'XML-модулот за PHP недостасува.
МедијаВики има потреба од функции во овој модул и нема да работи со овие поставки.
Ако работите со Mandrake, инсталирајте го php-xml пакетот.',
	'config-pcre' => 'Недостасува модулот за поддршка на PCRE.
МедијаВики не може да работи без функции за регуларни изрази соодветни на Perl.',
	'config-pcre-no-utf8' => "'''Фатално''': PCRE-модулот на PHP е составен без поддршка за PCRE_UTF8.
МедијаВики бара поддршка за UTF-8 за да може да работи правилно.",
	'config-memory-raised' => '<code>memory_limit</code> за PHP изнесува $1, зголемен на $2.',
	'config-memory-bad' => "'''Предупредување:''' <code>memory_limit</code> за PHP изнесува $1.
Ова е веројатно премалку.
Инсталацијата може да не успее!",
	'config-ctype' => "'''Фатална грешка''': PHP мора да се состави со поддршка за [http://www.php.net/manual/en/ctype.installation.php додатокот Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] е инсталиран',
	'config-apc' => '[http://www.php.net/apc APC] е инсталиран',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] е инсталиран',
	'config-no-cache' => "'''Предупредување:''' Не можев да го најдам [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] или [http://www.iis.net/download/WinCacheForPhp WinCache].
Кеширањето на објекти не е овозможено.",
	'config-mod-security' => "'''Предупредување''': на вашиот опслужувач има овозможено [http://modsecurity.org/ mod_security]. Ако не е поставено како што треба, ова може да предизвика проблеми кај МедијаВики и други програми што им овозможуваат на корисниците да објавуваат произволни содржини.
Погледнете ја [http://modsecurity.org/documentation/ mod_security документацијата] или обратете се кај домаќинот ако наидете на случајни грешки.",
	'config-diff3-bad' => 'GNU diff3 не е пронајден.',
	'config-imagemagick' => 'Пронајден е ImageMagick: <code>$1</code>.
Ако овозможите подигање, тогаш ќе биде овозможена минијатуризација на сликите.',
	'config-gd' => 'Утврдив дека има вградена GD графичка библиотека.
Ако овозможите подигање, тогаш ќе биде овозможена минијатураизација на сликите.',
	'config-no-scaling' => 'Не можев да пронајдам GD-библиотека или ImageMagick.
Минијатуризацијата на сликите ќе биде оневозможена.',
	'config-no-uri' => "'''Грешка:''' Не можев да го утврдам тековниот URI.
Инсталацијата е откажана.",
	'config-no-cli-uri' => "'''Предупредување''': Нема наведено --scriptpath. Ќе се користи основниот: <code>$1</code>.",
	'config-using-server' => 'Користите опслужувач под името „<nowiki>$1</nowiki>“.',
	'config-using-uri' => 'Користите опслужувач со URL-адреса „<nowiki>$1$2</nowiki>“.',
	'config-uploads-not-safe' => "'''Предупредување:''' Вашата матична папка за подигање <code>$1</code> е подложна на извршување (пуштање) на произволни скрипти.
Иако МедијаВики врши безбедносни проверки на сите подигнати податотеки, ве советуваме [//www.mediawiki.org/wiki/Manual:Security#Upload_security да ја затворите оваа безбедносна дупка] пред да овозможите подигање.",
	'config-no-cli-uploads-check' => "'''Предупредување:''' Вашата основна папка за подигања (<code>$1</code>) не е проверена дали е подложна
произволно извршување на скрипти во текот на инсталацијата на посредникот на повикувачко ниво (CLI).",
	'config-brokenlibxml' => 'Вашиот систем има комбинација од PHP и libxml2 верзии и затоа има грешки и може да предизвика скриено расипување на податоците кај МедијаВики и други мрежни програми.
Надградете го на PHP 5.2.9 и libxml2 2.7.3 или нивни понови верзии! ПРЕКИНУВАМ ([//bugs.php.net/bug.php?id=45996 грешката е заведена во PHP]).',
	'config-using531' => 'МедијаВики не може да се користи со PHP $1 поради грешка кај упатните параметри за <code>__call()</code>.
За да го решите проблемот, надградете го на PHP 5.3.2 или понова верзија, или пак користете го постариот PHP 5.3.0.',
	'config-suhosin-max-value-length' => 'Suhosin е инсталиран и ја ограничува должината на параметарот GET на $1 bytes. Делот ResourceLoader на МедијаВики ќе ја заобиколува ова граница, но со тоа ќе се влоши делотворноста. Ако е воопшто можно, на suhosin.get.max_value_length треба да го наместите на 1024 или поевеќе во php.ini , и да му ја зададете истата вредност на $wgResourceLoaderMaxQueryLength во LocalSettings.php .',
	'config-db-type' => 'Тип на база:',
	'config-db-host' => 'Домаќин на базата:',
	'config-db-host-help' => 'Ако вашата база е на друг опслужувач, тогаш тука внесете го името на домаќинот или IP-адресата.

Ако користите заедничко (споделено) вдомување, тогаш вашиот вдомител треба да го наведе точното име на домаќинот во неговата документација.

Ако инсталирате на опслужувач на Windows и користите MySQL, можноста „localhost“ може да не функционира за опслужувачкото име. Во тој случај, обидете се со внесување на „127.0.0.1“ како локална IP-адреса.

Ако користите PostgreSQL, оставете го полево празно за да се поврзете преку Unix-приклучок.',
	'config-db-host-oracle' => 'TNS на базата:',
	'config-db-host-oracle-help' => 'Внесете важечко [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm локално име за поврзување]. На оваа инсталација мора да ѝ биде видлива податотеката tnsnames.ora.<br />Ако користите клиентски библиотеки 10g или понови, тогаш можете да го користите и методот на иметнување на [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Идентификувај го викиво',
	'config-db-name' => 'Име на базата:',
	'config-db-name-help' => 'Одберете име што ќе го претставува вашето вики.
Името не смее да содржи празни места.

Ако користите заедничко (споделено) вдомување, тогаш вашиот вдомител ќе ви даде конкретно име на база за користење, или пак ќе ви даде да создавате бази преку контролната табла.',
	'config-db-name-oracle' => 'Шема на базата:',
	'config-db-account-oracle-warn' => 'Постојат три поддржани сценарија за инсталирање на Oracle како базен услужник:

Ако сакате да создадете сметка на базата како дел од постапката за инсталација, наведете сметка со SYSDBA-улога како сметка за базата што ќе се инсталира и наведете ги саканите податоци за сметката за мрежен пристап. Во друг случај, можете да создадете сметка за мрежен пристап рачно и да ја наведете само таа сметка (ако има дозволи за создавање на шематски објекти) или пак да наведете две различни сметки, една со привилегии за создавање, а друга (ограничена) за мрежен пристап.

Скриптата за создавање сметка со задолжителни привилегии ќе ја најдете во папката „maintenance/oracle/“ од оваа инсталација. Имајте на ум дека ако користите ограничена сметка ќе ги оневозможите сите функции за одржување со основната сметка.',
	'config-db-install-account' => 'Корисничка смета за инсталација',
	'config-db-username' => 'Корисничко име за базата:',
	'config-db-password' => 'Лозинка за базата:',
	'config-db-password-empty' => 'Внесете лозинка за новиот корисник на базата: $1.
Иако може да се создаваат корисници без лозинка, тоа не е безбедно.',
	'config-db-install-username' => 'Внесете корисничко име што ќе се користи за поврзување со базата во текот на инсталацијата. Ова не е корисничкото име од сметката на МедијаВики, туку посебно корисничко име за вашата база на податоци.',
	'config-db-install-password' => 'Внесете клозинка што ќе се користи за поврзување со базата во текот на инсталацијата. Ова не е лозинката од сметката на МедијаВики, туку посебна лозинка за вашата база на податоци.',
	'config-db-install-help' => 'Внесете го корисничкото име и лозинката што ќе се користи за поврзување со базата на податоци во текот на инсталацијата.',
	'config-db-account-lock' => 'Користи го истото корисничко име и лозинка за редовна работа',
	'config-db-wiki-account' => 'Корисничко име за редовна работа',
	'config-db-wiki-help' => 'Внесете корисничко име и лозинка што ќе се користат за поврзување со базата на податоци во текот на редовната работа со викито.
Ако сметката не постои, а инсталационата сметка има доволно привилегии, тогаш оваа корисничка сметка ќе биде создадена со минималните привилегии потребни за работа со викито.',
	'config-db-prefix' => 'Префикс на табелата на базата:',
	'config-db-prefix-help' => 'Ако треба да делите една база на податоци со повеќе викија, или со МедијаВики и друг мрежен програм, тогаш можете да додадете префикс на сите називи на табелите за да спречите проблематични ситуации.
Не користете празни простори.

Ова поле обично се остава празно.',
	'config-db-charset' => 'Збир знаци за базата',
	'config-charset-mysql5-binary' => 'Бинарен за MySQL 4.1/5.0',
	'config-charset-mysql5' => 'UTF-8 за MySQL 4.1/5.0',
	'config-charset-mysql4' => 'Назадно-соодветен UTF-8 за MySQL 4.0',
	'config-charset-help' => "'''ПРЕДУПРЕДУВАЊЕ:''' Ако користите '''назадно-соодветен UTF-8''' во MySQL 4.1+, а потоа направите резервен примерок на базата со <code>mysqldump</code>, ова може да ги опустоши сите не-ASCII знаци, и со тоа неповратно да ја расипе целата зачувана резерва!

Во '''бинарен режим''', во базата МедијаВики го складира UTF-8 текстот во бинарни полиња.
Ова е поефикансно отколку  UTF-8 режимот на MySQL бидејќи ви овозможува да го користите целиот спектар на уникодни знаци.
Во '''UTF-8 режим''', MySQL ќе знае на кој збир знаци припаѓаат вашите податоци, и може соодветно да ги претстави и претвори,
но нема да ви дозволи да складирате знаци над [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Основната повеќејазична рамнина].",
	'config-mysql-old' => 'Се бара MySQL $1 или поново, а вие имате $2.',
	'config-db-port' => 'Порта на базата:',
	'config-db-schema' => 'Шема за МедијаВики',
	'config-db-schema-help' => 'Оваа шема обично по правило ќе работи нормално.
Сменете ја само ако знаете дека треба да се смени.',
	'config-pg-test-error' => "Не можам да се поврзам со базата '''$1''': $2",
	'config-sqlite-dir' => 'Папка на SQLite-податоци:',
	'config-sqlite-dir-help' => "SQLite ги складира сите податоци во една податотека.

Папката што ќе ја наведете мора да е запислива од мрежниот опслужувач во текот на инсталацијата.

Таа '''не''' смее да биде достапна преку интернет, и затоа не ја ставаме кајшто ви се наоѓаат PHP-податотеките.

Инсталаторот воедно ќе создаде податотека <code>.htaccess</code>, но ако таа не функционира како што треба, тогаш некој ќе може да ви влезе во вашата необработена (сирова) база на податоци.
Тука спаѓаат необработени кориснички податоци (е-поштенски адреси, хеширани лозинки) како и избришани ревизии и други податоци за викито до кои се има ограничен пристап.

Се препорачува целата база да ја сместите некаде, како на пр. <code>/var/lib/mediawiki/вашетовики</code>.",
	'config-oracle-def-ts' => 'Стандарден таблеарен простор:',
	'config-oracle-temp-ts' => 'Привремен табеларен простор:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'МедијаВики ги поддржува следниве системи на бази на податоци:

$1

Ако системот што сакате да го користите не е наведен подолу, тогаш проследете ја горенаведената врска со инструкции за да овозможите поддршка за тој систем.',
	'config-support-mysql' => '* $1 е главната цел на МедијаВики и најдобро се поддржува ([http://www.php.net/manual/en/mysql.installation.php како се составува PHP со поддршка за MySQL])',
	'config-support-postgres' => '* $1 е популарен систем на бази на податоци со отворен код кој претставува алтернатива на MySQL ([http://www.php.net/manual/en/pgsql.installation.php како да составите PHP со поддршка за PostgreSQL]). Може сè уште да има некои грешки. па затоа не се препорачува за употреба во производна средина.',
	'config-support-sqlite' => '* $1 е лесен систем за бази на податоци кој е многу добро поддржан. ([http://www.php.net/manual/en/pdo.installation.php Како да составите PHP со поддршка за SQLite], користи PDO)',
	'config-support-oracle' => '* $1 е база на податоци на комерцијално претпријатие. ([http://www.php.net/manual/en/oci8.installation.php Како да составите PHP со поддршка за OCI8])',
	'config-support-ibm_db2' => '* $1 is комерцијална база на податоциза фирми.',
	'config-header-mysql' => 'Нагодувања на MySQL',
	'config-header-postgres' => 'Нагодувања на PostgreSQL',
	'config-header-sqlite' => 'Нагодувања на SQLite',
	'config-header-oracle' => 'Нагодувања на Oracle',
	'config-header-ibm_db2' => 'Нагодувања на IBM DB2',
	'config-invalid-db-type' => 'Неважечки тип на база',
	'config-missing-db-name' => 'Мора да внесете значење за параметарот „Име на базата“',
	'config-missing-db-host' => 'Мора да внесете вредност за „Домаќин на базата на податоци“',
	'config-missing-db-server-oracle' => 'Мора да внесете вредност за „TNS на базата“',
	'config-invalid-db-server-oracle' => 'Неважечки TNS „$1“ за базата.
Користете само знаци по ASCII - букви (a-z, A-Z), бројки (0-9), долни црти (_) и точки (.).',
	'config-invalid-db-name' => 'Неважечко име на базата „$1“.
Користете само ASCII-букви (a-z, A-Z), бројки (0-9), долни црти (_) и цртички (-).',
	'config-invalid-db-prefix' => 'Неважечки префикс за базата „$1“.
Користете само ASCII-букви (a-z, A-Z), бројки (0-9), долни црти (_) и цртички (-).',
	'config-connection-error' => '$1.

Проверете го долунаведениот домаќин, корисничко име и лозинка и обидете се повторно.',
	'config-invalid-schema' => 'Неважечка шема за МедијаВики „$1“.
Користете само букви, бројки и долни црти.',
	'config-db-sys-create-oracle' => 'Инсталаторот поддржува само употреба на SYSDBA-сметка за создавање на нова сметка.',
	'config-db-sys-user-exists-oracle' => 'Корисничката сметка „$1“ веќе постои. SYSDBA служи само за создавање на нова сметка!',
	'config-postgres-old' => 'Се бара PostgreSQL $1 или поново, а вие имате $2.',
	'config-sqlite-name-help' => 'Одберете име кое ќе го претставува вашето вики.
Не користете празни простори и црти.
Ова ќе се користи за податотечното име на SQLite-податоците.',
	'config-sqlite-parent-unwritable-group' => 'Не можам да ја создадам папката <code><nowiki>$1</nowiki></code> бидејќи мрежниот опслужувач не може да запише во матичната папка <code><nowiki>$2</nowiki></code>.

Инсталаторот го утврди корисникот под кој работи вашиот мрежен опслужувач.
За да продолжите, наместете да може да запишува во папката <code><nowiki>$3</nowiki></code>.
На Unix/Linux систем направете го следново:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Не можам да ја создадам папката <code><nowiki>$1</nowiki></code> бидејќи мрежниот опслужувач не може да запише во матичната папка <code><nowiki>$2</nowiki></code>.

Инсталаторот не можеше го утврди корисникот под кој работи вашиот мрежен опслужувач.
За да продолжите, наместете тој (и други!) да може глобално да запишува во папката <code><nowiki>$3</nowiki></code>
На Unix/Linux систем направете го следново:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Грешка при создавањето на податочната папка „$1“.
Проверете каде се наоѓа и обидете се повторно.',
	'config-sqlite-dir-unwritable' => 'Не можам да запишам во папката „$1“.
Во дозволите за неа, овозможете му на мрежниот опслужувач да запишува во неа и обидете се повторно.',
	'config-sqlite-connection-error' => '$1.

Проверете ја податочната папка и името на базата, и обидете се повторно.',
	'config-sqlite-readonly' => 'Податотеката <code>$1</code> е незапислива.',
	'config-sqlite-cant-create-db' => 'Не можев да ја создадам податотеката <code>$1</code> за базата.',
	'config-sqlite-fts3-downgrade' => 'PHP нема поддршка за FTS3 — ја поништувам надградбата за табелите',
	'config-can-upgrade' => "Во оваа база има табели на МедијаВики.
За да ги надградите на МедијаВики $1, кликнете на '''Продолжи'''.",
	'config-upgrade-done' => "Надградбата заврши.

Сега можете да [$1 почнете да го користите вашето вики].

Ако сакате да ја пресоздадете вашата податотека <code>LocalSettings.php</code>, тогаш кликнете на копчето подолу.
Ова '''не се препорачува''' освен во случај на проблеми со викито.",
	'config-upgrade-done-no-regenerate' => 'Надградбата заврши.

Сега можете да [$1 почнете да го користите викито].',
	'config-regenerate' => 'Пресоздај LocalSettings.php →',
	'config-show-table-status' => 'Барањето SHOW TABLE STATUS не успеа!',
	'config-unknown-collation' => "'''Предупредување:''' Базата корисни непрепознаена упатна споредба.",
	'config-db-web-account' => 'Сметка на базата за мрежен пристап',
	'config-db-web-help' => 'Одберете корисничко име и лозинка што ќе ги користи мрежниот опслужувач за поврзување со опслужувачот на базта на податоци во текот на редовната работа со викито.',
	'config-db-web-account-same' => 'Користи ја истата сметка од инсталацијата',
	'config-db-web-create' => 'Создај ја сметката ако веќе не постои',
	'config-db-web-no-create-privs' => 'Сметката што ја назначивте за инсталација нема доволно привилегии за да може да создаде сметка.
Тука мора да назначите постоечка сметка.',
	'config-mysql-engine' => 'Складишен погон:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Предупредување''': Го одбравте MyISAM како складишен погон за MySQL. Но тој не се препорачува за МедијаВики бидејќи:
* одвај поддржува едновременост поради заклучување на табелите
* поподложен на расипување од другите погони
* кодната база на МедијаВики не секогаш може да работи со MyISAM како што треба

Ако вашата инсталација на MySQL поддржува InnoDB, тогаш сериозно препорачуваме да го користите него наместо MyISAM.
Ако вашата инсталација на MySQL не поддржува InnoDB, веројатно дошло време за надградба.",
	'config-mysql-engine-help' => "'''InnoDB''' речиси секогаш е најдобар избор, бидејќи има добра поддршка за едновременост.

'''MyISAM''' може да е побрз кај инсталациите наменети за само еден корисник или незаписни инсталации (само читање).
Базите на податоци од MyISAM почесто се расипуваат од базите на InnoDB.",
	'config-mysql-charset' => 'Збир знаци за базата:',
	'config-mysql-binary' => 'Бинарен',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "Во '''бинарен режим''', во базата на податоци МедијаВики складира UTF-8 текст во бинарни полиња.
Ова е поефикасно отколку  TF-8 режимот на MySQL, и ви овозможува да ја користите целата палета на уникодни знаци.

Во '''UTF-8 режим''', MySQL ќе знае на кој збир знаци припаѓаат вашите податоци, и може соодветно да ги претстави и претвори, но нема да ви дозволи да складиратезнаци над [//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes Основната повеќејазична рамнина].",
	'config-ibm_db2-low-db-pagesize' => "Вашата база на податоци DB2 има основно-зададен табеларен простор со недоволна големина на страниците. Таа треба да изнесува барем '''32 килобајти'''.",
	'config-site-name' => 'Име на викито:',
	'config-site-name-help' => 'Ова ќе се појавува во заглавната лента на прелистувачот и на разни други места.',
	'config-site-name-blank' => 'Внесете име на мрежното место.',
	'config-project-namespace' => 'Проектен именски простор:',
	'config-ns-generic' => 'Проект',
	'config-ns-site-name' => 'Исто име како викито: $1',
	'config-ns-other' => 'Друго (наведете)',
	'config-ns-other-default' => 'МоеВики',
	'config-project-namespace-help' => "По примерот на Википедија, многу викија ги чуваат страниците со правила на посебно место од самите содржини, т.е. во „'''проектен именски простор'''“.
Сите наслови на страниците во овој именски простор почнуваат со извесен префикс, којшто можете да го укажете тука.
По традиција префиксот произлегува од името на викито, но не смее да содржи интерпункциски знаци како „#“ или „:“.",
	'config-ns-invalid' => 'Назначениот именски простор „<nowiki>$1</nowiki>“ е неважечки.
Назначете друг проектен именски простор.',
	'config-ns-conflict' => 'Наведениот именски простор „<nowiki>$1</nowiki>“ се коси со основниот именски простор на МедијаВики.
Наведете друг именски простор за проектот.',
	'config-admin-box' => 'Администратоска сметка',
	'config-admin-name' => 'Вашето име:',
	'config-admin-password' => 'Лозинка:',
	'config-admin-password-confirm' => 'Пак лозинката:',
	'config-admin-help' => 'Тука внесете го вашето корисничко име, на пр. „Петар Петровски“.
Ова име ќесе користи за најава во викито.',
	'config-admin-name-blank' => 'Внесете администраторско корисничко име.',
	'config-admin-name-invalid' => 'Назначенотго корисничко име „<nowiki>$1</nowiki>“ е неважечко.
Назначете друго.',
	'config-admin-password-blank' => 'Внесете лозинка за администраторската сметка',
	'config-admin-password-same' => 'Лозинката не може да биде иста со корисничкото име.',
	'config-admin-password-mismatch' => 'Лозинките што ги внесовте не се совпаѓаат.',
	'config-admin-email' => 'Е-поштенска адреса:',
	'config-admin-email-help' => 'Тука внесете е-поштенска адреса за да можете да добивате е-пошта од други корисници на викито, да ја менувате лозинката, и да бидете известувани за промени во страниците на вашиот список на набљудувања. Можете и да го оставите празно.',
	'config-admin-error-user' => 'Се појави внатрешна грешка при создавањето на администраторот со име „<nowiki>$1</nowiki>“.',
	'config-admin-error-password' => 'Се појави внатрешна грешка при задавање на лозинката за администраторот „<nowiki>$1</nowiki>“: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Внесовте неважечка е-поштенска адреса',
	'config-subscribe' => 'Претплатете се на [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce release поштенскиот список за известувања].',
	'config-subscribe-help' => 'Ова е нископрометен поштенски список кој се користи за соопштувања во врска со изданија, вклучувајќи важни безбедносни соопштенија.
Треба да се претплатите и да ја надградувате вашата инсталација на МедијаВики кога излегуваат нови верзии.',
	'config-subscribe-noemail' => 'Се обидовте да се претплатите на поштенскиот список со известувања за нови изданија без да наведете е-пошта.
Наведете е-поштенска адреса ако сакате да се претплатите на списокот.',
	'config-almost-done' => 'Уште малку сте готови!
Сега можете да ги прескокнете преостанатите поставувања и веднаш да го инсталирате викито.',
	'config-optional-continue' => 'Постави ми повеќе прашања.',
	'config-optional-skip' => 'Веќе ми здосади, дај само инсталирај го викито.',
	'config-profile' => 'Профил на кориснички права:',
	'config-profile-wiki' => 'Традиционално вики',
	'config-profile-no-anon' => 'Задолжително отворање сметка',
	'config-profile-fishbowl' => 'Само овластени уредници',
	'config-profile-private' => 'Приватно вики',
	'config-profile-help' => "Викијата функционираат најдобро кога имаат што повеќе уредници.
Во МедијаВики лесно се проверуваат скорешните промени, и лесно се исправа (технички: „враќа“) штетата направена од неупатени или злонамерни корисници.

Многумина имаат најдено најразлични полезни примени за МедијаВики, но понекогаш не е лесно да убедите некого во предностите на вики-концептот.
Значи имате избор.

'''{{int:config-profile-wiki}}''' — секој може да го уредува, дури и без најавување.
Ако имате вики со '''задолжително отворање на сметка''', тогаш добивате повеќе контрола, но ова може даги одврати спонтаните учесници.

'''{{int:config-profile-fishbowl}}''' — може да уредуваат само уредници што имаат добиено дозвола за тоа, но јавноста може да ги гледа страниците, вклучувајќи ја нивната историја.
'''{{int:config-profile-private}}''' — страниците се видливи и уредливи само за овластени корисници.

По инсталацијата имате на избор и посложени кориснички права и поставки. Погледајте во [//www.mediawiki.org/wiki/Manual:User_rights прирачникот].",
	'config-license' => 'Авторски права и лиценца:',
	'config-license-none' => 'Без подножје за лиценца',
	'config-license-cc-by-sa' => 'Creative Commons НаведиИзвор СподелиПодИстиУслови',
	'config-license-cc-by' => 'Криејтив комонс НаведиИзвор',
	'config-license-cc-by-nc-sa' => 'Creative Commons НаведиИзвор-Некомерцијално-СподелиПодИстиУслови',
	'config-license-cc-0' => 'Криејтив комонс Нула (јавна сопственост)',
	'config-license-gfdl' => 'ГНУ-ова лиценца за слободна документација 1.3 или понова',
	'config-license-pd' => 'Јавна сопственост',
	'config-license-cc-choose' => 'Одберете друга Creative Commons лиценца по ваш избор',
	'config-license-help' => "Многу јавни викија ги ставаат сите придонеси под [http://freedomdefined.org/Definition слободна лиценца].
Со ова се создава атмосфера на општа сопственост и поттикнува долгорочно учество.
Ова не е неопходно за викија на поединечни физички или правни лица.

Ако сакате да користите текст од Википедија, и сакате Википедија да прифаќа текст прекопиран од вашето вики, тогаш треба да ја одберете лиценцата '''Криејтив комонс НаведиИзвор СподелиПодИстиУслови'''.

ГНУ-овата лиценца за слободна документација (ГЛСД) е старата лиценца на Википедија.
Оваа лиценца сè уште важи, но е тешка за разбирање.
Исто така треба да се има на ум дека пренамената на содржините под ГЛСД не е лесна.",
	'config-email-settings' => 'Нагодувања за е-пошта',
	'config-enable-email' => 'Овозможи излезна е-пошта',
	'config-enable-email-help' => 'Ако сакате да работи е-поштата, [http://www.php.net/manual/en/mail.configuration.php поштенските нагодувања на PHP] треба да се правилно наместени.
Ако воопшто не сакате никакви функции за е-пошта, тогаш можете да ги оневозможите тука.',
	'config-email-user' => 'Овозможи е-пошта од корисник до корисник',
	'config-email-user-help' => 'Дозволи сите корисници да можат да си праќаат е-пошта ако ја имаат овозможено во нагодувањата.',
	'config-email-usertalk' => 'Овозможи известувања за промени во кориснички страници за разговор',
	'config-email-usertalk-help' => 'Овозможи корисниците да добиваат известувања за промени во нивните кориснички страници за разговор ако ги имаат овозможено во нагодувањата.',
	'config-email-watchlist' => 'Овозможи известувања за список на набљудувања',
	'config-email-watchlist-help' => 'Овозможи корисниците да добиваат известувања за нивните набљудувани страници ако ги имаат овозможено во нагодувањата.',
	'config-email-auth' => 'Овозможи потврдување на е-пошта',
	'config-email-auth-help' => "Ако оваа можност е вклучена, тогаш корисниците ќе мора да ја потврдат нивната е-поштенска адреса преку врска испратена до нив кога ја укажуваат или менуваат е-поштенската адреса.
Само корисници со потврдена е-пошта можат да добиваат е-пошта од други корисници или да ги менуваат писмата за известување.
Оваа можност е '''препорачана''' за јавни викија поради можни злоупотреби на е-поштенската функција.",
	'config-email-sender' => 'Повратна е-поштенска адреса:',
	'config-email-sender-help' => 'Внесете ја е-поштенската адреса што ќе се користи како повратна адреса за излезна е-пошта.
Таму ќе се испраќаат вратените (непримени) писма.
Многу поштенски опслужувачи бараат барем делот за доменско име да биде важечки.',
	'config-upload-settings' => 'Подигање на слики и податотеки',
	'config-upload-enable' => 'Овозможи подигање на податотеки',
	'config-upload-help' => 'Подигањето на податотеки потенцијално го изложуваат вашиот опслужувач на безбедносни ризици.
За повеќе информации, прочитајте го [//www.mediawiki.org/wiki/Manual:Security поглавието за безбедност] во прирачникот.

За да овозможите подигање на податотеки, сменете го режимот на потпапката <code>images</code> во основната папка на МедијаВики, за да му овозможите на мрежниот опслужувач да запишува во неа.
Потоа овозможете ја оваа функција.',
	'config-upload-deleted' => 'Папка за избришаните податотеки:',
	'config-upload-deleted-help' => 'Одберете во која папка да се архивираат избришаните податотеки.
Најдобро би било ако таа не е достапна преку интернет.',
	'config-logo' => 'URL за логото:',
	'config-logo-help' => 'Матичното руво на МедијаВики има простор за лого од 135 x 160 пиксели над страничната лента.
Подигнете слика со соодветна големина, и тука внесете ја URL-адресата.

Ако не сакате да имате лого, тогаш оставете го ова поле празно.',
	'config-instantcommons' => 'Овозможи Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] е функција која им овозможува на викијата да користат слики, звучни записи и други мултимедијални содржини од [//commons.wikimedia.org/ Заедничката Ризница].
За да може ова да работи, МедијаВики бара пристап до интернет.

За повеќе информации за оваа функција и напатствија за нејзино поставување на вики (сите други освен Ризницата), коносултирајте го [//mediawiki.org/wiki/Manual:$wgForeignFileRepos прирачникот].',
	'config-cc-error' => 'Изборникот на Creative Commons лиценца не даде резултати.
Внесете го името на лиценцата рачно.',
	'config-cc-again' => 'Одберете повторно...',
	'config-cc-not-chosen' => 'Одберете ја саканата Creative Commons лиценца и кликнете на „продолжи“.',
	'config-advanced-settings' => 'Напредни нагодувања',
	'config-cache-options' => 'Нагодувања за кеширање на објекти:',
	'config-cache-help' => 'Кеширањето на објекти се користи за зголемување на брзината на МедијаВики со кеширање на често употребуваните податоци.
Ова многу се препорачува на средни до големи викија, но од тоа ќе имаат полза и малите викија.',
	'config-cache-none' => 'Без кеширање (не се остранува ниедна функција, но може да влијае на брзината кај поголеми викија)',
	'config-cache-accel' => 'Кеширање на PHP-објекти (APC, XCache или WinCache)',
	'config-cache-memcached' => 'Користи Memcached (бара дополнително поставување и нагодување)',
	'config-memcached-servers' => 'Memcached-опслужувачи:',
	'config-memcached-help' => 'Список на IP-адреси за употреба во Memcached.
Треба да се наведе по една во секој ред, како и портата што ќе се користи. На пример:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'Го одбравте Memcached како ваш ваш тип на скришно памтење (кеш), но не наведовте опслужувач(и)',
	'config-memcache-badip' => 'Внесовте неважечка IP-адреса за Memcached: $1',
	'config-memcache-noport' => 'Не ја наведовте портата за опслужувачот на Memcached: $1.
Ако не знаете која порта треба да се користи, основната е 11211',
	'config-memcache-badport' => 'Бројките за портата на Memcached треба да бидат помеѓу $1 и $2',
	'config-extensions' => 'Додатоци',
	'config-extensions-help' => 'Во вашата папка <code>./extensions</code> беа востановени горенаведените додатоци.

За ова може да треба дополнително нагодување, но можете да ги овозможите сега',
	'config-install-alreadydone' => "'''Предупредување:''' Изгледа дека веќе го имате инсталирано МедијаВики и сега сакате да го инсталирате повторно.
Продолжете на следната страница.",
	'config-install-begin' => 'Стискајќи на „{{int:config-continue}}“ ќе ја започнете инсталацијата на МедијаВики.
Ако сакате да направите измени во досегашното, стиснете на „Назад“.',
	'config-install-step-done' => 'готово',
	'config-install-step-failed' => 'не успеа',
	'config-install-extensions' => 'Вклучувам додатоци',
	'config-install-database' => 'Ја поставувам базата на податоци',
	'config-install-schema' => 'Создавам шема',
	'config-install-pg-schema-not-exist' => 'PostgreSQL-шемата не постои',
	'config-install-pg-schema-failed' => 'Создавањето натабелите не успеа.
Проверете дали корисникот „$1“ може да запишува во шемата „$2“.',
	'config-install-pg-commit' => 'Спроведување на промени',
	'config-install-pg-plpgsql' => 'Проверувам јазик PL/pgSQL',
	'config-pg-no-plpgsql' => 'Ќе треба да го инсталирате јазикот PL/pgSQL во базата $1',
	'config-pg-no-create-privs' => 'Сметката што ја наведовте за инсталацијата нема доволно привилегии за да создаде друга сметка.',
	'config-pg-not-in-role' => 'Сметката што ја наведовте за мрежниот корисник веќе постои.
Сметката што ја наведовте за инсталација не е суперкорисник и не ѝ припаѓа на улогата на мрежниот корисник, па затоа не може да создава објекти во негова  сопственост.

МедијаВики налага дека табелите мора да се во сопственост на мрежниот корисник. Наведете друга мрежна сметка, или стиснете на „назад“ и наведете соодветно привилегиран корисник за инталацијата.',
	'config-install-user' => 'Создавам корисник за базата',
	'config-install-user-alreadyexists' => 'Корисникот „$1“ веќе постои',
	'config-install-user-create-failed' => 'Создавањето на корисникот „$1“ не успеа: $2',
	'config-install-user-grant-failed' => 'Доделувањето на дозвола на корисникот „$1“ не успеа: $2',
	'config-install-user-missing' => 'Наведениот корисник „$1“ не постои.',
	'config-install-user-missing-create' => 'Наведениот корисник „$1“ не постои.
Ако сакате да го создадете, штиклирајте ја можноста „создај сметка“.',
	'config-install-tables' => 'Создавам табели',
	'config-install-tables-exist' => "'''Предупредување''': Изгледа дека табелите за МедијаВики веќе постојат.
Го прескокнувам создавањето.",
	'config-install-tables-failed' => "'''Грешка''': Создавањето на табелата не успеа поради следнава грешка: $1",
	'config-install-interwiki' => 'Ги пополнувам основно зададените меѓувики-табели',
	'config-install-interwiki-list' => 'Не можев да ја пронајдам податотеката <code>interwiki.list</code>.',
	'config-install-interwiki-exists' => "'''Предупредување''': Табелата со интервикија веќе содржи ставки.
Го прескокнувам основно-зададениот список.",
	'config-install-stats' => 'Ги подготвувам статистиките',
	'config-install-keys' => 'Создавање на тајни клучеви',
	'config-insecure-keys' => "'''Предупредување:''' {{PLURAL:$2|Безбедносниот клуч $1 создаден во текот на инсталацијата не е сосем безбеден|Безбедносните клучеви $1 создадени во текот на инсталацијата не се сосем безбедни}}. Ви препорачуваме да {{PLURAL:$2|го|ги}} смените рачно.",
	'config-install-sysop' => 'Создавање на администраторска корисничка сметка',
	'config-install-subscribe-fail' => 'Не можам да ве претплатам на известувањето mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL не е инсталиран, а allow_url_fopen не е достапно.',
	'config-install-mainpage' => 'Создавам главна страница со стандардна содржина',
	'config-install-extension-tables' => 'Изработка на табели за овозможени додатоци',
	'config-install-mainpage-failed' => 'Не можев да вметнам главна страница: $1',
	'config-install-done' => "'''Честитаме!'''
Успешно го инсталиравте МедијаВики.

Инсталаторот создаде податотека <code>LocalSettings.php</code>.
Таму се содржат сите ваши нагодувања.

Ќе треба да ја преземете и да ја ставите во основата на инсталацијата (истата папка во која се наоѓа index.php). Преземањето треба да е започнато автоматски.

Ако не ви е понудено преземање, или пак ако сте го откажале, можете да го почнете одново стискајќи на следнава врска:

$3

'''Напомена''': Ако ова не го направите сега, податотеката со поставки повеќе нема да биде на достапна.

Откога ќе завршите со тоа, можете да '''[$2 влезете на вашето вики]'''.",
	'config-download-localsettings' => 'Преземи го LocalSettings.php',
	'config-help' => 'помош',
	'config-nofile' => 'Податотеката „$1“ не е пронајдена. Да не е избришана?',
	'mainpagetext' => "'''МедијаВики е успешно инсталиран.'''",
	'mainpagedocfooter' => 'Погледнете го [//meta.wikimedia.org/wiki/Help:Contents Упатството за корисници] за подетални иформации како се користи вики-програмот.

==Од каде да почнете==
* [//meta.wikimedia.org/wiki/Manual:Configuration_settings Список на нагодувања]
* [//meta.wikimedia.org/wiki/Manual:FAQ ЧПП (често поставувани прашања) за МедијаВики].
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Поштенски список на МедијаВики за нови верзии]',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Sadik Khalid
 */
$messages['ml'] = array(
	'config-desc' => 'മീഡിയവിക്കി ഇൻസ്റ്റോളർ',
	'config-title' => 'മീഡിയവിക്കി $1 ഇൻസ്റ്റലേഷൻ',
	'config-information' => 'വിവരങ്ങൾ',
	'config-localsettings-upgrade' => "'''അറിയിപ്പ്''': ഒരു <code>LocalSettings.php</code> ഫയൽ കാണുന്നു.
സോഫ്റ്റ്‌വേർ അപ്‌ഗ്രേഡ് ചെയ്യുക സാദ്ധ്യമാണ്.
ദയവായി പെട്ടിയിൽ <code>\$wgUpgradeKey</code> എന്നതിന്റെ വില നൽകുക.", # Fuzzy
	'config-localsettings-key' => 'അപ്‌ഗ്രേഡ് ചാവി:',
	'config-localsettings-badkey' => 'താങ്കൾ നൽകിയ ചാവി തെറ്റാണ്',
	'config-session-error' => 'സെഷൻ തുടങ്ങുന്നതിൽ പിഴവ്: $1',
	'config-your-language' => 'താങ്കളുടെ ഭാഷ:',
	'config-your-language-help' => 'ഇൻസ്റ്റലേഷൻ പ്രക്രിയയിൽ ഉപയോഗിക്കേണ്ട ഭാഷ തിരഞ്ഞെടുക്കുക.',
	'config-wiki-language' => 'വിക്കി ഭാഷ:',
	'config-wiki-language-help' => 'വിക്കിയിൽ പ്രധാനമായി ഉപയോഗിക്കേണ്ട ഭാഷ തിരഞ്ഞെടുക്കുക.',
	'config-back' => '← പിന്നിലേയ്ക്ക്',
	'config-continue' => 'തുടരുക →',
	'config-page-language' => 'ഭാഷ',
	'config-page-welcome' => 'മീഡിയവിക്കിയിലേയ്ക്ക് സ്വാഗതം!',
	'config-page-dbconnect' => 'ഡേറ്റാബേസുമായി ബന്ധപ്പെടുക',
	'config-page-upgrade' => 'നിലവിലുള്ള ഇൻസ്റ്റലേഷൻ അപ്‌ഗ്രേഡ് ചെയ്യുക',
	'config-page-dbsettings' => 'ഡേറ്റാബേസ് സജ്ജീകരണങ്ങൾ',
	'config-page-name' => 'പേര്',
	'config-page-options' => 'ഐച്ഛികങ്ങൾ',
	'config-page-install' => 'ഇൻസ്റ്റോൾ',
	'config-page-complete' => 'സമ്പൂർണ്ണം!',
	'config-page-restart' => 'ഇൻസ്റ്റലേഷൻ അടച്ച ശേഷം പുനർപ്രവർത്തിപ്പിക്കുക',
	'config-page-readme' => 'ഇത് വായിക്കൂ',
	'config-page-releasenotes' => 'പ്രകാശന കുറിപ്പുകൾ',
	'config-page-copying' => 'പകർത്തൽ',
	'config-page-upgradedoc' => 'അപ്‌ഗ്രേഡിങ്',
	'config-help-restart' => 'ഇതുവരെ ഉൾപ്പെടുത്തിയ എല്ലാവിവരങ്ങളും ഒഴിവാക്കാനും ഇൻസ്റ്റലേഷൻ പ്രക്രിയ നിർത്തി-വീണ്ടുമാരംഭിക്കാനും താങ്കളാഗ്രഹിക്കുന്നുണ്ടോ?',
	'config-restart' => 'അതെ, പുനർപ്രവർത്തിപ്പിക്കുക',
	'config-sidebar' => '* [//www.mediawiki.org മീഡിയവിക്കി പ്രധാനതാൾ]
* [//www.mediawiki.org/wiki/Help:Contents ഉപയോക്തൃസഹായി]
* [//www.mediawiki.org/wiki/Manual:Contents കാര്യനിർവഹണസഹായി]
* [//www.mediawiki.org/wiki/Manual:FAQ പതിവുചോദ്യങ്ങൾ]', # Fuzzy
	'config-env-php' => 'പി.എച്ച്.പി. $1 ഇൻസ്റ്റോൾ ചെയ്തിട്ടുണ്ട്.',
	'config-no-db' => 'അനുയോജ്യമായ ഡേറ്റാബേസ് ഡ്രൈവർ കണ്ടെത്താനായില്ല!', # Fuzzy
	'config-memory-raised' => 'പി.എച്ച്.പി.യുടെ <code>memory_limit</code> $1 ആണ്, $2 ആയി ഉയർത്തിയിരിക്കുന്നു.',
	'config-memory-bad' => "'''മുന്നറിയിപ്പ്:''' പി.എച്ച്.പി.യുടെ <code>memory_limit</code> $1 ആണ്.
ഇത് മിക്കവാറും വളരെ കുറവാണ്.
ഇൻസ്റ്റലേഷൻ പരാജയപ്പെട്ടേക്കാം!",
	'config-db-type' => 'ഡേറ്റാബേസ് തരം:',
	'config-db-host' => 'ഡേറ്റാബേസ് ഹോസ്റ്റ്:',
	'config-db-name' => 'ഡേറ്റാബേസിന്റെ പേര്:',
	'config-db-name-oracle' => 'ഡേറ്റാബേസ് സ്കീമ:',
	'config-db-install-account' => 'ഇൻസ്റ്റലേഷനുള്ള ഉപയോക്തൃ അംഗത്വം',
	'config-db-username' => 'ഡേറ്റാബേസ് ഉപയോക്തൃനാമം:',
	'config-db-password' => 'ഡേറ്റാബേസ് രഹസ്യവാക്ക്:',
	'config-mysql-old' => 'മൈഎസ്‌ക്യൂഎൽ $1 അഥവാ അതിലും പുതിയത് ആവശ്യമാണ്, താങ്കളുടെ പക്കൽ ഉള്ളത് $2 ആണ്.',
	'config-db-port' => 'ഡേറ്റാബേസ് പോർട്ട്:',
	'config-db-schema' => 'മീഡിയവിക്കിയ്ക്കായുള്ള സ്കീമ',
	'config-support-info' => 'മീഡിയവിക്കി താഴെ പറയുന്ന ഡേറ്റാബേസ് സിസ്റ്റംസ് പിന്തുണയ്ക്കുന്നു:

$1

താങ്കൾ ഉപയോഗിക്കാനാഗ്രഹിക്കുന്ന ഡേറ്റാബേസ് സിസ്റ്റം പട്ടികയിലില്ലെങ്കിൽ, ദയവായി പിന്തുണ സജ്ജമാക്കാനായി മുകളിൽ നൽകിയിട്ടുള്ള ലിങ്കിലെ നിർദ്ദേശങ്ങൾ ചെയ്യുക.',
	'config-header-mysql' => 'മൈഎസ്‌ക്യൂഎൽ സജ്ജീകരണങ്ങൾ',
	'config-invalid-db-type' => 'അസാധുവായ ഡേറ്റാബേസ് തരം',
	'config-missing-db-name' => '"ഡേറ്റാബേസിന്റെ പേരി"ന് ഒരു വില നിർബന്ധമായും നൽകിയിരിക്കണം',
	'config-connection-error' => '$1.

താഴെ നൽകിയിരിക്കുന്ന ഹോസ്റ്റ്, ഉപയോക്തൃനാമം, രഹസ്യവാക്ക് എന്നിവ പരിശോധിച്ച് വീണ്ടും ശ്രമിക്കുക.',
	'config-regenerate' => 'LocalSettings.php പുനഃസൃഷ്ടിക്കുക →',
	'config-mysql-engine' => 'സ്റ്റോറേജ് എൻജിൻ:',
	'config-site-name' => 'വിക്കിയുടെ പേര്:',
	'config-site-name-help' => 'ഇത് ബ്രൗസറിന്റെ ടൈറ്റിൽ ബാറിലും മറ്റനേകം ഇടങ്ങളിലും പ്രദർശിപ്പിക്കപ്പെടും.',
	'config-site-name-blank' => 'സൈറ്റിന്റെ പേര് നൽകുക.',
	'config-project-namespace' => 'പദ്ധതി നാമമേഖല:',
	'config-ns-generic' => 'പദ്ധതി',
	'config-ns-site-name' => 'വിക്കിയുടെ പേര് തന്നെ: $1',
	'config-ns-other' => 'ഇതരം (വ്യക്തമാക്കുക)',
	'config-ns-other-default' => 'എന്റെ‌വിക്കി',
	'config-admin-box' => 'കാര്യനിർവാഹക അംഗത്വം',
	'config-admin-name' => 'താങ്കളുടെ പേര്:',
	'config-admin-password' => 'രഹസ്യവാക്ക്:',
	'config-admin-password-confirm' => 'രഹസ്യവാക്ക് ഒരിക്കൽക്കൂടി:',
	'config-admin-help' => 'ഇവിടെ താങ്കളുടെ ഇച്ഛാനുസരണമുള്ള ഉപയോക്തൃനാമം നൽകുക, ഉദാഹരണം "ശശി കൊട്ടാരത്തിൽ".
ഈ പേരായിരിക്കണം വിക്കിയിൽ പ്രവേശിക്കാൻ താങ്കൾ ഉപയോഗിക്കേണ്ടത്.',
	'config-admin-name-blank' => 'ഒരു കാര്യനിർവാഹക ഉപയോക്തൃനാമം നൽകുക.',
	'config-admin-name-invalid' => 'നൽകിയിട്ടുള്ള ഉപയോക്തൃനാമം "<nowiki>$1</nowiki>" അസാധുവാണ്.
മറ്റൊരു ഉപയോക്തൃനാമം നൽകുക.',
	'config-admin-password-blank' => 'കാര്യനിർവാഹക അംഗത്വത്തിനുള്ള രഹസ്യവാക്ക് നൽകുക.',
	'config-admin-password-same' => 'രഹസ്യവാക്കും ഉപയോക്തൃനാമവും ഒന്നാകരുത്.',
	'config-admin-password-mismatch' => 'താങ്കൾ നൽകിയ രഹസ്യവാക്കുകൾ രണ്ടും തമ്മിൽ യോജിക്കുന്നില്ല.',
	'config-admin-email' => 'ഇമെയിൽ വിലാസം:',
	'config-admin-error-user' => '"<nowiki>$1</nowiki>" എന്ന പേരിലുള്ള കാര്യനിർവഹണ അംഗത്വ നിർമ്മിതിയ്ക്കിടെ ആന്തരികമായ പിഴവുണ്ടായി.',
	'config-admin-error-password' => '"<nowiki>$1</nowiki>" എന്ന പേരിലുള്ള കാര്യനിർവാഹക അംഗത്വത്തിനു രഹസ്യവാക്ക് സജ്ജീകരിച്ചപ്പോൾ ആന്തരികമായ പിഴവുണ്ടായി: <pre>$2</pre>',
	'config-subscribe' => '[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce പ്രകാശന അറിയിപ്പ് മെയിലിങ് ലിസ്റ്റിൽ] വരിക്കാരാകുക.',
	'config-subscribe-help' => 'പുറത്തിറക്കൽ അറിയിപ്പുകളും, പ്രധാന സുരക്ഷാ അറിയിപ്പുകളും പ്രസിദ്ധീകരിക്കുന്ന വളരെ എഴുത്തുകളൊന്നും ഉണ്ടാകാറില്ലാത്ത മെയിലിങ് ലിസ്റ്റ് ആണിത്.
പുതിയ പതിപ്പുകൾ പുറത്ത് വരുന്നതനുസരിച്ച് അവയെക്കുറിച്ചറിയാനും മീഡിയവിക്കി ഇൻസ്റ്റലേഷൻ പുതുക്കാനും ഇതിന്റെ വരിക്കാരൻ/വരിക്കാരി ആവുക.',
	'config-almost-done' => 'മിക്കവാറും പൂർത്തിയായിരിക്കുന്നു!
ബാക്കിയുള്ളവ അവഗണിച്ച് വിക്കി ഇൻസ്റ്റോൾ ചെയ്യാവുന്നതാണ്.',
	'config-optional-continue' => 'കൂടുതൽ ചോദ്യങ്ങൾ ചോദിക്കൂ.',
	'config-optional-skip' => 'എനിക്ക് മടുത്തു, ഒന്ന് ഇൻസ്റ്റോൾ ചെയ്ത് തീർക്ക്.',
	'config-profile-wiki' => 'പരമ്പരാഗത വിക്കി',
	'config-profile-no-anon' => 'അംഗത്വ സൃഷ്ടി ചെയ്യേണ്ടതുണ്ട്',
	'config-profile-fishbowl' => 'അനുവാദമുള്ളവർ മാത്രം തിരുത്തുക',
	'config-profile-private' => 'സ്വകാര്യ വിക്കി',
	'config-license' => 'പകർപ്പവകാശവും അനുമതിയും:',
	'config-license-cc-by-sa' => 'ക്രിയേറ്റീവ് കോമൺസ് ആട്രിബ്യൂഷൻ ഷെയർ എലൈക്',
	'config-license-cc-by-nc-sa' => 'ക്രിയേറ്റീവ് കോമൺസ് ആട്രിബ്യൂഷൻ നോൺ-കൊമേഴ്സ്യൽ ഷെയർ എലൈക്',
	'config-license-pd' => 'പൊതുസഞ്ചയം',
	'config-email-settings' => 'ഇമെയിൽ സജ്ജീകരണങ്ങൾ',
	'config-enable-email-help' => "ഇമെയിൽ പ്രവർത്തിക്കണമെങ്കിൽ, [http://www.php.net/manual/en/mail.configuration.php PHP's മെയിൽ സജ്ജീകരണങ്ങൾ] ശരിയായി ക്രമീകരിക്കേണ്ടതുണ്ട്.
ഇമെയിൽ സൗകര്യം ആവശ്യമില്ലെങ്കിൽ, ഇവിടെത്തന്നെ അത് നിർജ്ജീവമാക്കാം.",
	'config-email-user' => 'ഉപയോക്താക്കൾ തമ്മിലുള്ള ഇമെയിൽ പ്രവർത്തനസജ്ജമാക്കുക',
	'config-email-user-help' => 'സ്വന്തം ക്രമീകരണങ്ങളിൽ ഇമെയിൽ സജ്ജമാക്കിയിട്ടുണ്ടെങ്കിൽ ഉപയോക്താക്കളെ മറ്റുള്ളവർക്ക് ഇമെയിൽ അയയ്ക്കാൻ അനുവദിക്കുക.',
	'config-email-usertalk' => 'ഉപയോക്തൃസംവാദം താളിൽ മാറ്റങ്ങളുണ്ടായാൽ അറിയിക്കുക',
	'config-email-watchlist' => 'ശ്രദ്ധിക്കുന്നവയിൽ മാറ്റം വന്നാൽ അറിയിക്കുക',
	'config-email-auth' => 'ഇമെയിലിന്റെ സാധുതാപരിശോധന സജ്ജമാക്കുക',
	'config-email-sender' => 'മറുപടിയ്ക്കുള്ള ഇമെയിൽ വിലാസം:',
	'config-upload-settings' => 'ചിത്രങ്ങളും പ്രമാണങ്ങളും അപ്‌ലോഡ് ചെയ്യൽ',
	'config-upload-enable' => 'പ്രമാണ അപ്‌ലോഡുകൾ സജ്ജമാക്കുക',
	'config-upload-deleted' => 'മായ്ക്കപ്പെട്ട ഫയലുകൾക്കുള്ള ഡയറക്റ്ററി:',
	'config-logo' => 'ലോഗോയുടെ യൂ.ആർ.എൽ.:',
	'config-logo-help' => 'മീഡിയവിക്കിയിൽ സ്വതേയുള്ള ദൃശ്യരൂപത്തിൽ 135x160 പിക്സലുള്ള ലോഗോ മുകളിൽ ഇടത് മൂലയിൽ കാണാം.
അനുയോജ്യമായ വലിപ്പമുള്ള ഒരു ചിത്രം അപ്‌ലോഡ് ചെയ്തിട്ട്, അതിന്റെ യൂ.ആർ.എൽ. ഇവിടെ നൽകുക.

താങ്കൾക്ക് ലോഗോ ആവശ്യമില്ലെങ്കിൽ, ഈ പെട്ടി ശൂന്യമായിടുക.', # Fuzzy
	'config-cc-again' => 'ഒന്നുകൂടി എടുക്കൂ...',
	'config-advanced-settings' => 'വിപുലീകൃത ക്രമീകരണങ്ങൾ',
	'config-extensions' => 'അനുബന്ധങ്ങൾ',
	'config-install-step-done' => 'ചെയ്തു കഴിഞ്ഞു',
	'config-install-step-failed' => 'പരാജയപ്പെട്ടു',
	'config-install-extensions' => 'അനുബന്ധങ്ങൾ ഉൾപ്പെടുത്തുന്നു',
	'config-install-database' => 'ഡേറ്റാബേസ് സജ്ജമാക്കുന്നു',
	'config-install-pg-commit' => 'മാറ്റങ്ങൾ സ്വീകരിക്കുന്നു',
	'config-install-user' => 'ഡേറ്റാബേസ് ഉപയോക്താവിനെ സൃഷ്ടിക്കുന്നു',
	'config-install-sysop' => 'കാര്യനിർവാഹക അംഗത്വം സൃഷ്ടിക്കുന്നു',
	'config-install-mainpage' => 'സ്വാഭാവിക ഉള്ളടക്കത്തോടുകൂടി പ്രധാനതാൾ സൃഷ്ടിക്കുന്നു',
	'config-install-mainpage-failed' => 'പ്രധാന താൾ ഉൾപ്പെടുത്താൻ കഴിഞ്ഞില്ല: $1',
	'config-install-done' => "'''അഭിനന്ദനങ്ങൾ!'''
താങ്കൾ വിജയകരമായി മീഡിയവിക്കി സജ്ജീകരിച്ചിരിക്കുന്നു.

ഇൻസ്റ്റോളർ താങ്കളുടെ എല്ലാ ക്രമീകരണങ്ങളുമടങ്ങുന്ന <code>LocalSettings.php</code> ഫയൽ സൃഷ്ടിച്ചിട്ടുണ്ട്.

പ്രസ്തുത പ്രമാണം ഡൗൺലോഡ് ചെയ്ത് താങ്കളുടെ വിക്കി സജ്ജീകരണത്തിന്റെ അടിസ്ഥാന ഡയറക്റ്ററിയിൽ ഇടേണ്ടതാണ് (index.php കിടക്കുന്ന അതേ ഡയറക്റ്ററിയിൽ). ഡൗൺലോഡിങ്ങ് സ്വയം ആരംഭിക്കുന്നതാണ്. ഡൗൺലോഡിങ്ങ് സ്വയം തുടങ്ങാതിരിക്കുകയോ, താങ്കൾ റദ്ദാക്കുകയോ ചെയ്ത പക്ഷം താഴെ കാണുന്ന കണ്ണിയിൽ ഞെക്കുക:
$3

'''ശ്രദ്ധിക്കുക''': താങ്കൾ ഇപ്പോൾ ചെയ്തില്ലെങ്കിൽ, ഫയൽ എടുക്കാതെ ഇൻസ്റ്റലേഷൻ പ്രക്രിയയിൽ നിന്ന് പുറത്തിറങ്ങിയാൽ, സൃഷ്ടിക്കപ്പെട്ട ക്രമീകരണങ്ങളടങ്ങുന്ന പ്രമാണം പിന്നീട് ലഭ്യമായിരിക്കില്ല.

മുകളിൽ പറഞ്ഞ പ്രകാരം ചെയ്തു കഴിഞ്ഞാൽ, താങ്കൾക്ക് '''[$2 വിക്കിയിൽ പ്രവേശിക്കാവുന്നതാണ്]'''.",
	'mainpagetext' => "'''മീഡിയവിക്കി വിജയകരമായി സജ്ജീകരിച്ചിരിക്കുന്നു.'''",
	'mainpagedocfooter' => 'വിക്കി സോഫ്റ്റ്‌വെയർ ഉപയോഗിക്കുന്നതിനെ കുറിച്ചുള്ള വിശദാംശങ്ങൾക്ക്  [//meta.wikimedia.org/wiki/Help:Contents സോഫ്റ്റ്‌വെയർ സഹായി] കാണുക.

== പ്രാരംഭസഹായികൾ ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings ക്രമീകരണങ്ങളുടെ പട്ടിക]
* [//www.mediawiki.org/wiki/Manual:FAQ മീഡിയവിക്കി പതിവുചോദ്യങ്ങൾ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce മീഡിയവിക്കി പ്രകാശന മെയിലിങ് ലിസ്റ്റ്]',
);

/** Mongolian (монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'config-page-language' => 'Хэл',
	'mainpagetext' => "'''МедиаВики амжилттай суулаа.'''",
	'mainpagedocfooter' => 'Вики программыг хэрэглэх талаар заавар авахын тулд [//meta.wikimedia.org/wiki/Help:Contents хэрэглэгчийн гарын авлага]-г үзнэ үү.

== Эхлэх ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Тохиргоо]
* [//www.mediawiki.org/wiki/Manual:FAQ МедиаВикигийн тогтмол тавигддаг асуултууд]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce МедиаВикигийн мэдээний мэйл явуулах жагсаалт]',
);

/** Marathi (मराठी)
 */
$messages['mr'] = array(
	'mainpagetext' => "'''मीडियाविकीचे इन्स्टॉलेशन पूर्ण.'''",
	'mainpagedocfooter' => 'विकी सॉफ्टवेअर वापरण्याकरिता [//meta.wikimedia.org/wiki/Help:Contents यूजर गाईड] पहा.

== सुरुवात ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings कॉन्फिगरेशन सेटींगची यादी]
* [//www.mediawiki.org/wiki/Manual:FAQ मीडियाविकी नेहमी विचारले जाणारे प्रश्न]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce मीडियाविकि मेलिंग लिस्ट]',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'config-back' => '← Undur',
	'config-continue' => 'Teruskan →',
	'config-page-language' => 'Bahasa',
	'config-page-welcome' => 'Selamat datang ke MediaWiki!',
	'config-page-dbconnect' => 'Bersambung dengan pangkalan data',
	'config-page-upgrade' => 'Naik taraf pemasangan sedia ada',
	'config-page-dbsettings' => 'Tetapan pangkalan data',
	'config-page-name' => 'Nama',
	'config-page-options' => 'Pilihan',
	'config-page-install' => 'Pasang',
	'config-env-php' => 'PHP $1 dipasang.',
	'config-env-php-toolow' => 'PHP $1 dipasang.
Bagaimanapun, MediaWiki memerlukan PHP $2 ke atas.',
	'config-unicode-using-utf8' => 'utf8_normalize.so oleh Brion Vibber digunakan untuk penormalan Unicode.',
	'config-unicode-using-intl' => '[http://pecl.php.net/intl Sambungan intl PECL] digunakan untuk penormalan Unicode.',
	'config-db-charset' => 'Peranggu aksara pangkalan data',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-mysql-engine' => 'Enjin storan:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-charset' => 'Peranggu aksara pangkalan data:',
	'config-mysql-binary' => 'Perduaan',
	'config-mysql-utf8' => 'UTF-8',
	'config-site-name' => 'Nama wiki:',
	'config-site-name-help' => 'Ini akan dipaparkan pada bar tajuk perisian pelayar dan tempat-tempat lain yang berkenaan.',
	'config-site-name-blank' => 'Isikan nama tapak.',
	'config-project-namespace' => 'Ruang nama projek:',
	'config-ns-generic' => 'Projek',
	'config-ns-site-name' => 'Sama dengan nama wiki: $1',
	'config-ns-other' => 'Lain-lain (nyatakan)',
	'config-ns-other-default' => 'MyWiki',
	'config-admin-password' => 'Kata laluan:',
	'config-admin-email' => 'Alamat e-mel:',
	'config-license' => 'Hak cipta dan lesen:',
	'config-license-none' => 'Tiada pengaki lesen',
	'config-license-cc-by-sa' => 'Creative Commons Attribution Share Alike',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Attribution Non-Commercial Share Alike',
	'config-license-cc-0' => 'Creative Commons Zero (Domain Awam)',
	'config-license-gfdl' => 'Lesen Dokumentasi Bebas GNU 1.3 ke atas',
	'config-license-pd' => 'Domain Awam',
	'config-email-settings' => 'Tetapan e-mel',
	'config-install-step-done' => 'siap',
	'config-install-step-failed' => 'gagal',
	'config-help' => 'bantuan',
	'mainpagetext' => "'''MediaWiki telah berjaya dipasang.'''",
	'mainpagedocfooter' => 'Sila rujuk [//meta.wikimedia.org/wiki/Help:Contents Panduan Penggunaan] untuk maklumat mengenai penggunaan perisian wiki ini.

== Untuk bermula ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Senarai tetapan konfigurasi]
* [//www.mediawiki.org/wiki/Manual:FAQ Soalan Lazim MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Senarai mel bagi keluaran MediaWiki]',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'config-page-language' => 'Lingwa',
	'config-page-welcome' => 'Merħba fuq MediaWiki!',
	'config-page-dbconnect' => 'Aqbad mad-databażi',
	'config-page-upgrade' => 'Aġġorna l-installazzjoni eżistenti',
	'config-page-dbsettings' => 'Impostazzjonijiet tad-databażi',
	'config-page-name' => 'Isem',
	'config-page-options' => 'Għażliet',
	'config-page-install' => 'Installa',
	'config-page-complete' => 'Lesta!',
	'config-page-restart' => "Erġa' ibda l-installazzjoni",
	'config-page-readme' => 'Aqrani',
	'config-page-releasenotes' => 'Noti tal-verżjoni',
	'mainpagetext' => "'''MediaWiki ġie installat b'suċċess.'''",
	'mainpagedocfooter' => "Ikkonsulta l-[//meta.wikimedia.org/wiki/Help:Contents Gwida għall-utenti] sabiex tikseb iktar informazzjoni dwar kif tuża' s-softwer tal-wiki.

== Biex tibda ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista ta' preferenzi għall-konfigurazzjoni]
* [//www.mediawiki.org/wiki/Manual:FAQ Mistoqsijiet rikorrenti fuq il-MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Il-lista tal-posta tħabbar 'l MediaWiki]",
);

/** Burmese (မြန်မာဘာသာ)
 * @author Lionslayer
 */
$messages['my'] = array(
	'mainpagetext' => "'''မီဒီယာဝီကီကို အောင်မြင်စွာ သွင်းပြီးပါပြီ။'''",
);

/** Erzya (эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'config-page-language' => 'Кель',
	'config-page-name' => 'Лемезэ',
	'config-page-readme' => 'Ловномак',
	'config-admin-name' => 'Леметь:',
	'config-admin-password' => 'Совамо валот:',
	'config-admin-password-confirm' => 'Совамо валот одов:',
	'config-admin-email' => 'Е-сёрма паргот:',
	'config-install-step-done' => 'теезь',
	'mainpagetext' => "'''МедияВикинь тевс аравтомазо парсте лиссь.'''",
);

/** Mazanderani (مازِرونی)
 * @author محک
 */
$messages['mzn'] = array(
	'config-help' => 'راهنما',
);

/** Nahuatl (Nāhuatl)
 */
$messages['nah'] = array(
	'mainpagetext' => "'''MediaHuiqui cualli ōmotlahtlāli.'''",
);

/** Min Nan Chinese (Bân-lâm-gú)
 * @author Ianbu
 */
$messages['nan'] = array(
	'mainpagetext' => "'''MediaWiki已經裝好矣。'''",
	'mainpagedocfooter' => '請查看[//meta.wikimedia.org/wiki/Help:Contents 用者說明書]的資料通使用wiki 軟體

== 入門 ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings 配置的設定]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki時常問答]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki的公布列單]',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'config-desc' => 'Installasjonsprogrammet for MediaWiki',
	'config-title' => 'Installasjon av MediaWiki $1',
	'config-information' => 'Informasjon',
	'config-localsettings-upgrade' => 'En <code>LocalSettings.php</code>-fil har blitt oppdaget.
For å oppgradere denne installasjonen, skriv inn verdien av <code>$wgUpgradeKey</code> i boksen nedenfor.
Du finner denne i LocalSettings.php.',
	'config-localsettings-cli-upgrade' => "Filen ''LocalSettings.php'' er funnet.
For å oppgradere denne installasjonen, vennligst kjør ''update.php'' i stedet",
	'config-localsettings-key' => 'Oppgraderingsnøkkel:',
	'config-localsettings-badkey' => 'Nøkkelen du oppga er feil.',
	'config-upgrade-key-missing' => "En eksisterende installasjon av MediaWiki er funnet.
For å oppgradere denne installasjonen, vær vennlig å legge til følgende linje helt til slutt i din ''LocalSettings.php''-fil:

$1",
	'config-localsettings-incomplete' => "Den eksisterende ''LocalSettings.php'' ser ut til å være ufullstendig.
Variabelen $1 har ingen verdi.
Vær vennlig å endre ''LocalSettings.php'' slik at variabelen får en verdi, og klikk ''Fortsett''.",
	'config-localsettings-connection-error' => "Det ble funnet en feil ved tilknytning av databasen med innstillingene i ''LocalSettings.php'' eller ''AdminSettings.php''. Vær vennlig å rette opp disse innstillingene og prøv igjen.

$1",
	'config-session-error' => 'Feil under oppstart av økt: $1',
	'config-session-expired' => 'Dine øktdata ser ut til å ha utløpt.
Økter er konfigurert for en levetid på $1.
Du kan øke dette ved å sette <code>session.gc_maxlifetime</code> i php.ini.
Start installasjonsprosessen på nytt.',
	'config-no-session' => 'Dine øktdata ble tapt!
Sjekk din php.ini og sørg for at <code>session.save_path</code> er satt til en passende mappe.',
	'config-your-language' => 'Ditt språk:',
	'config-your-language-help' => 'Velg et språk å bruke under installasjonsprosessen.',
	'config-wiki-language' => 'Wikispråk:',
	'config-wiki-language-help' => 'Velg språket som wikien hovedsakelig vil bli skrevet i.',
	'config-back' => '← Tilbake',
	'config-continue' => 'Fortsett →',
	'config-page-language' => 'Språk',
	'config-page-welcome' => 'Velkommen til MediaWiki!',
	'config-page-dbconnect' => 'Koble til database',
	'config-page-upgrade' => 'Oppgrader eksisterende innstallasjon',
	'config-page-dbsettings' => 'Databaseinnstillinger',
	'config-page-name' => 'Navn',
	'config-page-options' => 'Valg',
	'config-page-install' => 'Installer',
	'config-page-complete' => 'Ferdig!',
	'config-page-restart' => 'Start installasjonen på nytt',
	'config-page-readme' => 'Les meg',
	'config-page-releasenotes' => 'Utgivelsesnotat',
	'config-page-copying' => 'Kopiering',
	'config-page-upgradedoc' => 'Oppgradering',
	'config-page-existingwiki' => 'Eksisterende wiki',
	'config-help-restart' => 'Ønsker du å fjerne alle lagrede data som du har skrevet inn og starte installasjonsprosessen på nytt?',
	'config-restart' => 'Ja, start på nytt',
	'config-welcome' => '=== Miljøsjekker ===
Grunnleggende sjekker utføres for å se om dette miljøet er egnet for en MediaWiki-installasjon.
Du bør oppgi resultatene fra disse sjekkene om du trenger hjelp under installasjonen.',
	'config-copyright' => "=== Opphavsrett og vilkår ===

$1

MediaWiki er fri programvare; du kan redistribuere det og/eller modifisere det under betingelsene i GNU General Public License som publisert av Free Software Foundation; enten versjon 2 av lisensen, eller (etter eget valg) enhver senere versjon.

Dette programmet er distribuert i håp om at det vil være nyttig, men '''uten noen garanti'''; ikke engang implisitt garanti av '''salgbarhet''' eller '''egnethet for et bestemt formål'''.
Se GNU General Public License for flere detaljer.

Du skal ha mottatt <doclink href=Copying>en kopi av GNU General Public License</doclink> sammen med dette programmet; hvis ikke, skriv til Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA eller [http://www.gnu.org/copyleft/gpl.html les det på nettet].",
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki hjem]
* [//www.mediawiki.org/wiki/Help:Contents Brukerguide]
* [//www.mediawiki.org/wiki/Manual:Contents Administratorguide]
* [//www.mediawiki.org/wiki/Manual:FAQ OSS]
----
* <doclink href=Readme>Les meg</doclink>
* <doclink href=ReleaseNotes>Utgivelsesnotater</doclink>
* <doclink href=Copying>Kopiering</doclink>
* <doclink href=UpgradeDoc>Oppgradering</doclink>',
	'config-env-good' => 'Miljøet har blitt sjekket.
Du kan installere MediaWiki.',
	'config-env-bad' => 'Miljøet har blitt sjekket.
Du kan installere MediaWiki.',
	'config-env-php' => 'PHP $1 er innstallert.',
	'config-env-php-toolow' => 'PHP $1 er installert.
MediaWiki krever imidlertid PHP $2 eller høyere.',
	'config-unicode-using-utf8' => 'Bruker Brion Vibbers utf8_normalize.so for Unicode-normalisering.',
	'config-unicode-using-intl' => 'Bruker [http://pecl.php.net/intl intl PECL-utvidelsen] for Unicode-normalisering.',
	'config-unicode-pure-php-warning' => "'''Advarsel''': [http://pecl.php.net/intl intl PECL-utvidelsen] er ikke tilgjengelig for å håndtere Unicode-normaliseringen, faller tilbake til en langsommere ren-PHP-implementasjon.
Om du kjører et nettsted med høy trafikk bør du lese litt om [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode-normalisering].",
	'config-unicode-update-warning' => "'''Advarsel''': Den installerte versjonen av Unicode-normalisereren bruker en eldre versjon av [http://site.icu-project.org/ ICU-prosjektets] bibliotek.
Du bør [//www.mediawiki.org/wiki/Unicode_normalization_considerations oppgradere] om du er bekymret for å bruke Unicode.",
	'config-no-db' => 'Fant ikke en passende databasedriver! Du må installere en databasedriver for PHP.
Følgende databasetyper er støttet: $1

Om du er på delt vertsskap, spør din vertsleverandør om å installere en passende databasedriver.
Om du kompilerte PHP selv, rekonfigirer den med en aktivert databaseklient, for eksempel ved å bruke <code>./configure --with-mysql</code>.
Om du installerte PHP fra en Debian- eller Ubuntu-pakke må du også installere modulen php5-mysql.',
	'config-outdated-sqlite' => "'''Advarsel''': Du har SQLite $1, som er en eldre versjon enn minimumskravet SQLite $2. SQLite vil ikke være tilgjengelig.",
	'config-no-fts3' => "'''Advarsel''': SQLite er kompilert uten [//sqlite.org/fts3.html FTS3-modulen], søkefunksjoner vil ikke være tilgjengelig på dette bakstykket.",
	'config-register-globals' => "'''Advarsel: PHPs <code>[http://php.net/register_globals register_globals]</code>-alternativ er aktivert.'''
'''Deaktiver det om du kan.'''
MediaWiki vil fungere, men tjeneren din er utsatt for potensielle sikkerhetssårbarheter.",
	'config-magic-quotes-runtime' => "'''Kritisk: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] er aktiv!'''
Dette alternativet ødelegger inndata på en uforutsigbar måte.
Du kan ikke installere eller bruke MediaWiki med mindre dette alternativet deaktiveres.",
	'config-magic-quotes-sybase' => "'''Kritisk: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-sybase magic_quotes_sybase] er aktiv!'''
Dette alternativet ødelegger inndata på en uforutsigbar måte.
Du kan ikke installere eller bruke MediaWiki med mindre dette alternativet deaktiveres.",
	'config-mbstring' => "'''Kritisk: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] er aktiv!'''
Dette alternativet fører til feil og kan ødelegge data på en uforutsigbar måte.
Du kan ikke installere eller bruke MediaWiki med mindre dette alternativet deaktiveres.",
	'config-ze1' => "'''Kritisk: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] er aktiv!'''
Dette alternativet fører til horrible feil med MediaWiki.
Du kan ikke installere eller bruke MediaWiki med mindre dette alternativet deaktiveres.",
	'config-safe-mode' => "'''Advarsel:''' PHPs [http://www.php.net/features.safe-mode safe mode] er aktiv.
Det kan føre til problem, spesielt hvis du bruker støtte for filopplastinger og <code>math</code>.",
	'config-xml-bad' => 'PHPs XML-modul mangler.
MediaWiki krever funksjonene i denne modulen og vil ikke virke i denne konfigurasjonen.
Hvis du kjører Mandrak, installer pakken php-xml.',
	'config-pcre' => 'PCRE-støttemodulen ser ut til å mangle.
MediaWiki krever funksjonene for de Perl-kompatible regulære uttrykkene for å virke.',
	'config-pcre-no-utf8' => "'''Fatal''': PHPs PCRE modul ser ut til å være kompilert uten PCRE_UTF8-støtte.
MediaWiki krever UTF-8-støtte for å fungere riktig.",
	'config-memory-raised' => 'PHPs <code>memory_limit</code> er $1, økt til $2.',
	'config-memory-bad' => "'''Advarsel:''' PHPs <code>memory_limit</code> er $1.
Dette er sannsynligvis for lavt.
Installasjonen kan mislykkes!",
	'config-ctype' => "'''Fatal feil''': PHP må kompileres med støtte for [http://www.php.net/manual/en/ctype.installation.php Ctype-utvidelsen].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] er innstallert',
	'config-apc' => '[http://www.php.net/apc APC] er innstallert',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] er installert',
	'config-no-cache' => "'''Advarsel:''' Kunne ikke finne [http://www.php.net/apc APC], [http://xcache.lighttpd.net/ XCache] eller [http://www.iis.net/download/WinCacheForPhp WinCache].
Objekthurtiglagring er ikke aktivert.",
	'config-mod-security' => "'''Advarsel''': Din web-tjener har [http://modsecurity.org/ mod_security] påslått. Hvis denne er feilinnstilt, kan det gi problemer for MediaWiki eller annen programvare som tillater brukere å poste vilkårlig innhold.
Sjekk [http://modsecurity.org/documentation/ mod_security-dokumentasjonen] eller ta kontakt med din nettleverandør hvis du opplever tilfeldige feil.",
	'config-diff3-bad' => 'GNU diff3 ikke funnet.',
	'config-imagemagick' => 'Fant ImageMagick: <code>$1</code>.
Bildeminiatyrisering vil aktiveres om du aktiverer opplastinger.',
	'config-gd' => 'Fant innebygd GD-grafikkbibliotek.
Bildeminiatyrisering vil aktiveres om du aktiverer opplastinger.',
	'config-no-scaling' => 'Kunne ikke finne GD-bibliotek eller ImageMagick.
Bildeminiatyrisering vil være deaktivert.',
	'config-no-uri' => "'''Feil:''' Kunne ikke bestemme gjeldende URI.
Installasjon avbrutt.",
	'config-no-cli-uri' => "'''Advarsel''': Ingen --scriptpath er angitt; bruker standard: <code>$1</code>.",
	'config-using-server' => 'Bruker servernavnet  "<nowiki>$1</nowiki>".',
	'config-using-uri' => 'Bruker server-URL "<nowiki>$1$2</nowiki>".',
	'config-uploads-not-safe' => "'''Advarsel:''' Din standardmappe for opplastinger <code>$1</code> er sårbar for kjøring av vilkårlige skript.
Selv om MediaWiki sjekker alle opplastede filer for sikkerhetstrusler er det sterkt anbefalt å [//www.mediawiki.org/wiki/Manual:Security#Upload_security lukke denne sikkerhetssårbarheten] før du aktiverer opplastinger.",
	'config-no-cli-uploads-check' => "'''Advarsel:''' Din standard-katalog for opplastinger (<code>$1</code>) er ikke kontrollert for sårbarhet overfor vilkårlig skript-kjøring under CLI-installasjonen.",
	'config-brokenlibxml' => 'Ditt system har en kombinasjon av PHP- og libxml2-versjoner som er feilaktige og kan forårsake skjult dataødeleggelse i MediaWiki og andre web-applikasjoner.
Oppgrader til PHP 5.2.9 eller nyere og libxml 2 2.7.3 eller nyere ([//bugs.php.net/bug.php?id=45996 Feil-liste for PHP]).
Installasjon abortert.',
	'config-using531' => 'MediaWiki kan ikke brukes med PHP $1 på grunn av en feil med referanseparametere til <code>__call()</code>.
Oppgrader til PHP 5.3.2 eller høyere, eller nedgrader til PHP 5.3.0 for å løse dette.
Installasjonen avbrutt.',
	'config-suhosin-max-value-length' => 'Suhosin er installert og begrenser GET-parameterlengder til $1 bytes. MediaWiki\'s ResourceLoader-komponent klarer å komme rundt denne begrensningen, med med redusert ytelse. På mulig bør du sette suhosin.get.max_value_length til minst 1024 i php.ini, og sette $wgResourceLoaderMaxQueryLength til samme verdi i LocalSettings.php.',
	'config-db-type' => 'Databasetype:',
	'config-db-host' => 'Databasevert:',
	'config-db-host-help' => 'Hvis databasen kjører på en annen tjenermaskin, skriv inn vertsnavnet eller IP-adressen her.

Hvis du bruker et webhotell, vil du kunne be om aktuelt vertsnavn fra din leverandør.

Hvis du installerer på en Windowstjener og bruker MySQL, kan det hende at «localhost» ikke brukes som tjenernavn. Hvis så er tilfelle, prøv «127.0.0.1» som lokal IP-adresse.

Hvis du bruker PostgreSQL, la dette feltet være blankt slik at koplingen gjøres via en "Unix socket".',
	'config-db-host-oracle' => 'Database TNS:',
	'config-db-host-oracle-help' => 'Skriv inn et gyldig [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm Local Connect Name]; en tnsnames.ora-fil må være synlig for installasjonsprosessen.<br />Hvis du bruker klientbibliotek 10g eller nyere kan du også bruke navngivingsmetoden [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identifiser denne wikien',
	'config-db-name' => 'Databasenavn:',
	'config-db-name-help' => 'Velg et navn som identifiserer wikien din.
Det bør ikke inneholde mellomrom.

Hvis du bruker en delt nettvert vil verten din enten gi deg et spesifikt databasenavn å bruke, eller la deg opprette databaser via kontrollpanelet.',
	'config-db-name-oracle' => 'Databaseskjema:',
	'config-db-account-oracle-warn' => 'Det finnes tre mulig fremgangsmåter for å installere Oracle som database:

Hvis du ønsker å opprette en databasekonto som del av installasjonsprosessen, oppgi da en konto med SYSDBA-rolle som databasekonto for installasjonen og angi påkrevd autentiseringsinformasjon for web-aksesskontoen. Ellers kan du enten opprette web-aksesskontoen manuelt eller kun oppgi den kontoen (hvis den har påkrevede tillatelser for å opprette skjemeobjektene) , alternativt oppgi to ulike kontoer, en med opprettelsesprivilegier (create) og en begrenset konto for web-aksess.

Skript for å opprette en konto med påkrevde privilegier finnes i "maintenance/oracle/"-folderen av denne installasjonen. Husk at det å bruke en begrenset konto vil blokkere all vedlikeholdsfunksjonalitet med standard konto.',
	'config-db-install-account' => 'Brukerkonto for installasjon',
	'config-db-username' => 'Databasebrukernavn:',
	'config-db-password' => 'Databasepassord:',
	'config-db-password-empty' => 'Skriv inn et passord for den nye databasebrukeren: $1.
Det er mulig å opprette brukere uten passord, men dette er ikke sikkert.',
	'config-db-install-username' => 'Skriv inn brukernavnet som vil bli brukt til å koble til databasen under installasjonsprosessen.
Dette er ikke brukernavnet på MediaWiki-kontoen; dette er brukernavnet for databasen din.',
	'config-db-install-password' => 'Skriv inn passordet som vil bli brukt til å koble til databasen under installasjonsprosessen.
Dette er ikke passordet på MediaWiki-kontoen; dette er passordet for databasen din.',
	'config-db-install-help' => 'Skriv inn brukernavnet og passordet som vil bli brukt for å koble til databasen under installasjonsprosessen.',
	'config-db-account-lock' => 'Bruk det samme brukernavnet og passordet under normal drift',
	'config-db-wiki-account' => 'Brukerkonto for normal drift',
	'config-db-wiki-help' => 'Skriv inn brukernavnet og passordet som vil bli brukt til å koble til databasen under normal wikidrift.
Hvis kontoen ikke finnes, og installasjonskontoen har tilstrekkelige privilegier, vil denne brukerkontoen bli opprettet med et minimum av privilegier, tilstrekkelig for å operere wikien.',
	'config-db-prefix' => 'Databasetabellprefiks:',
	'config-db-prefix-help' => 'Hvis du trenger å dele en database mellom flere wikier, eller mellom MediaWiki og andre nettapplikasjoner, kan du velge å legge til et prefiks til alle tabellnavnene for å unngå konflikter.
Ikke bruk mellomrom.

Dette feltet er vanligvis tomt.',
	'config-db-charset' => 'Databasetegnsett',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binær',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 bakoverkompatibel UTF-8',
	'config-charset-help' => "'''Advarsel:''' Hvis du bruker '''bakoverkompatibel UTF-8''' på MySQL 4.1+, og deretter sikkerhetskopierer databasen med <code>mysqldump</code> kan det ødelegge alle ikke-ASCII tegn og irreversibelt ødelegge dine sikkerhetskopier!

I '''binary mode''' lagrer MediaWiki UTF-8 tekst til databasen i binærfelt.
Dette er mer effektivt enn MySQLs UTF-8 modus og tillater deg å bruke hele spekteret av Unicode-tegn.
I '''UTF-8 mode''' vil MySQL vite hvilket tegnsett dataene dine er i og kan presentere og konvertere det på en riktig måte,
men det vil ikke la deg lagre tegn over «[//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes the Basic Multilingual Plane]».",
	'config-mysql-old' => 'MySQL $1 eller senere kreves, du har $2.',
	'config-db-port' => 'Databaseport:',
	'config-db-schema' => 'Skjema for MediaWiki',
	'config-db-schema-help' => 'Dette skjemaet er som regel riktig.
Bare endre det hvis du vet at du trenger det.',
	'config-pg-test-error' => "Får ikke kontakt med database '''$1''': $2",
	'config-sqlite-dir' => 'SQLite datamappe:',
	'config-sqlite-dir-help' => "SQLite lagrer alle data i en enkelt fil.

Mappen du oppgir må være skrivbar for nettjeneren under installasjonen.

Den bør '''ikke''' være tilgjengelig fra nettet, dette er grunnen til at vi ikke legger det der PHP-filene dine er.

Installasjonsprogrammet vil skrive en <code>.htaccess</code>-fil sammen med det, men om det mislykkes kan noen få tilgang til din råe database. Dette inkluderer rå brukerdata (e-postadresser, hashede passord) samt slettede revisjoner og andre begrensede data på wikien.

Vurder å plassere databasen et helt annet sted, for eksempel i <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Standard tabellrom:',
	'config-oracle-temp-ts' => 'Midlertidig tabellrom:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki støtter følgende databasesystem:

$1

Hvis du ikke ser databasesystemet du prøver å bruke i listen nedenfor, følg instruksjonene det er lenket til over for å aktivere støtte.',
	'config-support-mysql' => '* $1 er det primære målet for MediaWiki og er best støttet ([http://www.php.net/manual/en/mysql.installation.php hvordan kompilere PHP med MySQL-støtte])',
	'config-support-postgres' => '* $1 er et populært åpen kildekode-databasesystem som er et alternativ til MySQL ([http://www.php.net/manual/en/pgsql.installation.php hvordan kompilere PHP med PostgreSQL-støtte]). Det kan være noen små utestående feil og det anbefales ikke for bruk i et produksjonsmiljø.',
	'config-support-sqlite' => '* $1 er et lettvekts-databasesystem som er veldig godt støttet. ([http://www.php.net/manual/en/pdo.installation.php hvordan kompilere PHP med SQLite-støtte], bruker PDO)',
	'config-support-oracle' => '* $1 er en kommersiell bedriftsdatabase. ([http://www.php.net/manual/en/oci8.installation.php Hvordan kompilere PHP med OCI8-støtte])',
	'config-support-ibm_db2' => '* $1 er en kommersiell bedriftsdatabase.',
	'config-header-mysql' => 'MySQL-innstillinger',
	'config-header-postgres' => 'PostgreSQL-innstillinger',
	'config-header-sqlite' => 'SQLite-innstillinger',
	'config-header-oracle' => 'Oracle-innstillinger',
	'config-header-ibm_db2' => 'IBM DB2-innstillinger',
	'config-invalid-db-type' => 'Ugyldig databasetype',
	'config-missing-db-name' => 'Du må skrive inn en verdi for «Databasenavn»',
	'config-missing-db-host' => 'Du må skrive inn en verdi for «Databasevert»',
	'config-missing-db-server-oracle' => 'Du må skrive inn en verdi for «Database TNS»',
	'config-invalid-db-server-oracle' => 'Ugyldig database-TNS «$1».
Bruk bare ASCII-bokstaver (a-z, A-Z), tall (0-9) og undestreker (_) og punktum (.).',
	'config-invalid-db-name' => 'Ugyldig databasenavn «$1».
Bruk bare ASCII-bokstaver (a-z, A-Z), tall (0-9), undestreker (_) og bindestreker (-).',
	'config-invalid-db-prefix' => 'Ugyldig databaseprefiks «$1».
Bruk bare ASCII-bokstaver (a-z, A-Z), tall (0-9), undestreker (_) og bindestreker (-).',
	'config-connection-error' => '$1.

Sjekk verten, brukernavnet og passordet nedenfor og prøv igjen.',
	'config-invalid-schema' => 'Ugyldig skjema for MediaWiki «$1».
Bruk bare ASCII-bokstaver (a-z, A-Z), tall (0-9) og undestreker (_).',
	'config-db-sys-create-oracle' => 'Installasjonsprogrammet støtter kun bruk av en SYSDBA-konto for opprettelse av en ny konto.',
	'config-db-sys-user-exists-oracle' => 'Brukerkontoen «$1» finnes allerede. SYSDBA kan kun brukes for oppretting av nye kontoer!',
	'config-postgres-old' => 'PostgreSQL $1 eller senere kreves, du har $2.',
	'config-sqlite-name-help' => 'Velg et navn som identifiserer wikien din.
Ikke bruk mellomrom eller bindestreker.
Dette vil bli brukt til SQLite-datafilnavnet.',
	'config-sqlite-parent-unwritable-group' => 'Kan ikke opprette datamappen <code><nowiki>$1</nowiki></code> fordi foreldremappen <code><nowiki>$2</nowiki></code> ikke er skrivbar for nettjeneren.

Installasjonsprogrammet har bestemt brukeren nettjeneren din kjører som.
Gjør <code><nowiki>$3</nowiki></code>-mappen skrivbar for denne for å fortsette.
På et Unix/Linux-system, gjør:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Kan ikke opprette datamappen <code><nowiki>$1</nowiki></code> fordi foreldremappen <code><nowiki>$2</nowiki></code> ikke er skrivbar for nettjeneren.

Installasjonsprogrammet kunne ikke bestemme brukeren nettjeneren din kjører som.
Gjør <code><nowiki>$3</nowiki></code>-mappen globalt skrivbar for denne (og andre!) for å fortsette.
På et Unix/Linux-system, gjør:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Feil under oppretting av datamappen «$1».
Sjekk plasseringen og prøv igjen.',
	'config-sqlite-dir-unwritable' => 'Kan ikke skrive til mappen «$1».
Endre dens tilganger slik at nettjeneren kan skrive til den og prøv igjen.',
	'config-sqlite-connection-error' => '$1.

Sjekk datamappen og databasenavnet nedenfor og prøv igjen.',
	'config-sqlite-readonly' => 'Filen <code>$1</code> er ikke skrivbar.',
	'config-sqlite-cant-create-db' => 'Kunne ikke opprette databasefilen <code>$1</code>.',
	'config-sqlite-fts3-downgrade' => 'PHP mangler FTS3-støtte, nedgraderer tabeller',
	'config-can-upgrade' => "Det er MediaWiki-tabeller i denne databasen.
For å oppgradere dem til MediaWiki $1, klikk '''Fortsett'''.",
	'config-upgrade-done' => "Oppgradering fullført.

Du kan nå [$1 begynne å bruke wikien din].

Hvis du ønsker å regenerere <code>LocalSettings.php</code>-filen din, klikk på knappen nedenfor.
Dette er '''ikke anbefalt''' med mindre du har problemer med wikien din.",
	'config-upgrade-done-no-regenerate' => 'Oppgradering fullført.

Du kan nå [$1 begynne å bruke wikien din].',
	'config-regenerate' => 'Regenerer LocalSettings.php →',
	'config-show-table-status' => 'SHOW TABLE STATUS etterspørselen mislyktes!',
	'config-unknown-collation' => "'''Advarsel:''' Databasen bruker en ukjent sortering.",
	'config-db-web-account' => 'Databasekonto for nettilgang',
	'config-db-web-help' => 'Velg brukernavnet og passordet som nettjeneren skal bruke for å koble til databasetjeneren under ordinær drift av wikien.',
	'config-db-web-account-same' => 'Bruk samme konto som for installasjonen',
	'config-db-web-create' => 'Opprett kontoen om den ikke finnes allerede',
	'config-db-web-no-create-privs' => 'Kontoen du oppga for installasjonen har ikke nok privilegier til å opprette en konto.
Kontoen du oppgir her må finnes allerede.',
	'config-mysql-engine' => 'Lagringsmotor:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-engine-help' => "'''InnoDB''' er nesten alltid det beste alternativet siden den har god støtte for samtidighet («concurrency»).

'''MyISAM''' kan være raskere i enbruker- eller les-bare-installasjoner.
MyISAM-databaser har en tendens til å bli ødelagt oftere enn InnoDB-databaser.",
	'config-mysql-charset' => 'Databasetegnsett:',
	'config-mysql-binary' => 'Binær',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "I '''binary mode''' lagrer MediaWiki UTF-8 tekst til databasen i binærfelt.
Dette er mer effektivt enn MySQLs UTF-8 modus og tillater deg å bruke hele spekteret av Unicode-tegn.

I '''UTF-8 mode''' vil MySQL vite hvilket tegnsett dataene dine er i og kan presentere og konvertere det på en riktig måte,
men det vil ikke la deg lagre tegn over «[//en.wikipedia.org/wiki/Mapping_of_Unicode_character_planes the Basic Multilingual Plane]».",
	'config-ibm_db2-low-db-pagesize' => "DB2-databasen din har et standard tabellområde med en utilstrekkelig pagesize. Pagesize må være '''32K''' eller større.",
	'config-site-name' => 'Navn på wiki:',
	'config-site-name-help' => 'Dette vil vises i tittellinjen i nettleseren og diverse andre steder.',
	'config-site-name-blank' => 'Skriv inn et nettstedsnavn.',
	'config-project-namespace' => 'Prosjektnavnerom:',
	'config-ns-generic' => 'Prosjekt',
	'config-ns-site-name' => 'Samme som wikinavnet: $1',
	'config-ns-other' => 'Annet (spesifiser)',
	'config-ns-other-default' => 'MyWiki',
	'config-project-namespace-help' => "Etter Wikipedias eksempel holder mange wikier deres sider med retningslinjer atskilt fra sine innholdssider, i et «'''prosjektnavnerom'''».
Alle sidetitler i dette navnerommet starter med et gitt prefiks som du kan angi her.
Tradisjonelt er dette prefikset avledet fra navnet på wikien, men det kan ikke innholde punkttegn som «#» eller «:».",
	'config-ns-invalid' => 'Det angitte navnerommet «<nowiki>$1</nowiki>» er ugyldig.
Angi et annet prosjektnavnerom.',
	'config-ns-conflict' => 'Det angitte navnerommet «<nowiki>$1</nowiki>» er i konflikt med et standard MediaWiki-navnerom.
Angi et annet prosjekt-navnerom.',
	'config-admin-box' => 'Administratorkonto',
	'config-admin-name' => 'Ditt navn:',
	'config-admin-password' => 'Passord:',
	'config-admin-password-confirm' => 'Passord igjen:',
	'config-admin-help' => 'Skriv inn ditt ønskede brukernavn her, for eksempel «Joe Bloggs».
Dette er navnet du vil bruke for å logge inn på denne wikien.',
	'config-admin-name-blank' => 'Skriv inn et administratorbrukernavn.',
	'config-admin-name-invalid' => 'Det angitte brukernavnet «<nowiki>$1</nowiki>» er ugyldig.
Angi et annet brukernavn.',
	'config-admin-password-blank' => 'Skriv inn et passord for administratorkontoen.',
	'config-admin-password-same' => 'Passordet skal ikke være det samme som brukernavnet.',
	'config-admin-password-mismatch' => 'De to passordene du skrev inn samsvarte ikke.',
	'config-admin-email' => 'E-postadresse:',
	'config-admin-email-help' => 'Skriv inn en e-postadresse her for at du skal kunne motta e-post fra andre brukere på wikien, tilbakestille passordet ditt, og bli varslet om endringer på sider på overvåkningslisten din. Du kan la dette feltet stå tomt.',
	'config-admin-error-user' => 'Intern feil ved opprettelse av en admin med navnet «<nowiki>$1</nowiki>».',
	'config-admin-error-password' => 'Intern feil ved opprettelse av passord for admin «<nowiki>$1</nowiki>»: <pre>$2</pre>',
	'config-admin-error-bademail' => 'Du har skrevet inn en ugyldig e-postadresse.',
	'config-subscribe' => 'Abonner på [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce e-postlisten for utgivelsesannonseringer].',
	'config-subscribe-help' => 'Dette er en lav-volums e-postliste brukt til utgivelsesannonseringer, herunder viktige sikkerhetsannonseringer.
Du bør abonnere på den og oppdatere MediaWikiinstallasjonen din når nye versjoner kommer ut.',
	'config-almost-done' => 'Du er nesten ferdig!
Du kan hoppe over de resterende konfigurasjonene og installere wikien nå.',
	'config-optional-continue' => 'Spør meg flere spørsmål.',
	'config-optional-skip' => 'Jeg er lei, bare installer wikien.',
	'config-profile' => 'Brukerrettighetsprofil:',
	'config-profile-wiki' => 'Tradisjonell wiki',
	'config-profile-no-anon' => 'Kontoopprettelse påkrevd',
	'config-profile-fishbowl' => 'Kun autoriserte bidragsytere',
	'config-profile-private' => 'Privat wiki',
	'config-profile-help' => "Wikier fungerer best når du lar så mange mennesker som mulig redigere den.
I MediaWiki er det lett å revidere siste endringer og tilbakestille eventuell skade som er gjort av naive eller ondsinnede brukere.

Imidlertid har mange funnet at MediaWiki er nyttig i mange roller, og av og til er det ikke lett å overbevise alle om fordelene med wikimåten.
Så du har valget.

En '''{{int:config-profile-wiki}}''' tillater alle å redigere, selv uten å logge inn.
En wiki med '''{{int:config-profile-no-anon}}''' tilbyr ekstra ansvarlighet, men kan avskrekke tilfeldige bidragsytere.

'''{{int:config-profile-fishbowl}}'''-scenariet tillater godkjente brukere å redigere, mens publikum kan se sider, og også historikken.
En '''{{int:config-profile-private}}''' tillater kun godkjente brukere å se sider, den samme gruppen som får lov til å redigere dem.

Mer komplekse konfigurasjoner av brukerrettigheter er tilgjengelig etter installasjon, se det [//www.mediawiki.org/wiki/Manual:User_rights relevante manualavsnittet].",
	'config-license' => 'Opphavsrett og lisens:',
	'config-license-none' => 'Ingen lisensbunntekst',
	'config-license-cc-by-sa' => 'Creative Commons Navngivelse Del på samme vilkår',
	'config-license-cc-by' => 'Creative Commons Attribution',
	'config-license-cc-by-nc-sa' => 'Creative Commons Navngivelse Ikke-kommersiell Del på samme vilkår',
	'config-license-cc-0' => 'Creative Commons Zero', # Fuzzy
	'config-license-pd' => 'Offentlig rom',
	'config-license-cc-choose' => 'Velg en egendefinert Creative Commons-lisens',
	'config-email-settings' => 'E-postinnstillinger',
	'config-enable-email' => 'Aktiver utgående e-post',
	'config-enable-email-help' => 'Hvis du vil at e-post skal virke må [http://www.php.net/manual/en/mail.configuration.php PHPs e-postinnstillinger] bli konfigurert riktig.
Hvis du ikke ønsker noen e-postfunksjoner kan du deaktivere dem her.',
	'config-email-user' => 'Aktiver e-post mellom brukere',
	'config-email-user-help' => 'Tillat alle brukere å sende hverandre e-post hvis de har aktivert det i deres innstillinger.',
	'config-email-usertalk' => 'Aktiver brukerdiskusjonssidevarsler',
	'config-email-usertalk-help' => 'Tillat brukere å motta varsler ved endringer på deres brukerdiskusjonsside hvis de har aktivert dette i deres innstillinger.',
	'config-email-watchlist' => 'Aktiver overvåkningslistevarsler',
	'config-email-watchlist-help' => 'Tillat brukere å motta varsler ved endringer på deres overvåkede sider hvis de har aktivert dette i deres innstillinger.',
	'config-email-auth' => 'Aktiver e-postautentisering',
	'config-email-auth-help' => "Om dette alternativet er aktivert må brukere bekrefte sin e-postadresse ved å bruke en lenke som blir sendt til dem når de setter eller endrer adressen sin.
Kun autentiserte e-postadresser kan motta e-post fra andre brukere eller endringsvarsel.
Å sette dette valget er '''anbefalt''' for offentlige wikier på grunn av potensiell misbruk av e-postfunksjonene.",
	'config-email-sender' => 'Svar-e-postadresse:',
	'config-email-sender-help' => 'Skriv inn e-postadressen som skal brukes som svar-adresse ved utgående e-post.
Det er hit returmeldinger vil bli sendt.
Mange e-posttjenere krever at minst domenenavnet må være gyldig.',
	'config-upload-settings' => 'Bilde- og filopplastinger',
	'config-upload-enable' => 'Aktiver filopplastinger',
	'config-upload-help' => 'Filopplastinger kan potensielt utsette tjeneren din for sikkerhetsrisikoer.
For mer informasjon, les [//www.mediawiki.org/wiki/Manual:Security sikkerhetsseksjonen] i manualen.

For å aktivere filopplastinger, endre modusen i <code>images</code>-undermappen i MediaWikis rotmappe slik at nettjeneren kan skrive til den.
Aktiver så dette alternativet.',
	'config-upload-deleted' => 'Mappe for slettede filer:',
	'config-upload-deleted-help' => 'Velg en mappe for å arkivere slettede filer.
Ideelt burde ikke denne være tilgjengelig for nettet.',
	'config-logo' => 'Logo-URL:',
	'config-logo-help' => 'MediaWikis standarddrakt inkluderer plass til en 135x160 pikslers logo i øvre venstre hjørne.
Last opp et bilde i passende størrelse og skriv inn nettadressen her.

Hvis du ikke ønsker en logo, la denne boksen være tom.', # Fuzzy
	'config-instantcommons' => 'Aktiver Instant Commons',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] er en funksjon som gjør det mulig for wikier å bruke bilder, lyder og andre media funnet på nettstedet [//commons.wikimedia.org/ Wikimedia Commons].
For å gjøre dette krever MediaWiki tilgang til internett.

For mer informasjon om denne funksjonen, inklusive instruksjoner om hvordan man setter opp dette for andre wikier enn Wikimedia Commons, konsulter [//mediawiki.org/wiki/Manual:$wgForeignFileRepos manualen].',
	'config-cc-again' => 'Velg igjen...',
	'config-cc-not-chosen' => 'Velg hvilken Creative Commons-lisens du ønsker og klikk «fortsett».',
	'config-advanced-settings' => 'Avansert konfigurasjon',
	'config-extensions' => 'Utvidelser',
	'config-install-step-done' => 'ferdig',
	'config-install-step-failed' => 'mislyktes',
	'config-install-extensions' => 'Inkludert utvidelser',
	'config-install-database' => 'Setter opp database',
	'config-install-user' => 'Oppretter databasebruker',
	'config-install-user-alreadyexists' => 'Brukeren «$1» finnes allerede',
	'config-install-user-create-failed' => 'Opprettelse av brukeren «$1» mislyktes: $2',
	'config-install-user-grant-failed' => 'Å gi tillatelse til brukeren «$1» mislyktes: $2',
	'config-install-tables' => 'Oppretter tabeller',
	'config-install-mainpage-failed' => 'Kunne ikke sette inn hovedside: $1',
	'config-download-localsettings' => 'Last ned LocalSettings.php',
	'config-help' => 'hjelp',
	'config-nofile' => 'Filen "$1" ble ikke funnet. Kan den være blitt slettet?',
	'mainpagetext' => "'''MediaWiki-programvaren er nå installert.'''",
	'mainpagedocfooter' => 'Se [//meta.wikimedia.org/wiki/Help:Contents brukerveiledningen] for informasjon om hvordan du bruker wiki-programvaren.

==Å starte==
*[//www.mediawiki.org/wiki/Manual:Configuration_settings Oppsettsliste]
*[//www.mediawiki.org/wiki/Manual:FAQ Ofte stilte spørsmål]
*[https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki e-postliste]',
);

/** Low German (Plattdüütsch)
 */
$messages['nds'] = array(
	'mainpagetext' => "'''De MediaWiki-Software is mit Spood installeert worrn.'''",
	'mainpagedocfooter' => 'Kiek de [//meta.wikimedia.org/wiki/MediaWiki_localisation Dokumentatschoon för dat Anpassen vun de Brukerböversiet]
un dat [//meta.wikimedia.org/wiki/MediaWiki_User%27s_Guide Brukerhandbook] för Hülp to de Bruuk un Konfiguratschoon.',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'mainpagetext' => "'''’t Installeren van de MediaWiki programmatuur is succesvol.'''",
	'mainpagedocfooter' => 'Bekiek de [//meta.wikimedia.org/wiki/Help:Contents haandleiding] veur informasie over t gebruuk van de wikiprogrammatuur.

== Meer hulpe ==
* [//www.mediawiki.org/wiki/Help:Configuration_settings Lieste mit instellingen]
* [//www.mediawiki.org/wiki/Help:FAQ MediaWiki-vragen die vake esteld wörden]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki-postlieste veur nieje versies]',
);

/** Nepali (नेपाली)
 * @author Bhawani Gautam
 * @author RajeshPandey
 */
$messages['ne'] = array(
	'mainpagetext' => "'''मीडिया सफलतापूर्वक कम्प्यूटरमा स्थापित भयो ।'''",
	'mainpagedocfooter' => ' विकी अनुप्रयोग कसरी प्रयोग गर्ने भन्ने जानकारीको लागि  [//meta.wikimedia.org/wiki/Help:Contents प्रयोगकर्ता सहायता] हेर्नुहोस्

== सुरू गर्नको लागि  ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings विन्यास सेटिङ्ग सूची]
* [//www.mediawiki.org/wiki/Manual:FAQ मेडियाविकि सामान्य प्रश्नका उत्तरहरु]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce मेडियाविकि सुचना मेलिङ्ग सूची]',
);

/** Dutch (Nederlands)
 * @author Catrope
 * @author McDutchie
 * @author Purodha
 * @author SPQRobin
 * @author Siebrand
 * @author Tjcool007
 */
$messages['nl'] = array(
	'config-desc' => 'Het installatieprogramma voor MediaWiki',
	'config-title' => 'Installatie MediaWiki $1',
	'config-information' => 'Gegevens',
	'config-localsettings-upgrade' => 'Er is een bestaand instellingenbestand <code>LocalSettings.php</code> gevonden.
Voer de waarde van <code>$wgUpgradeKey</code> in in onderstaande invoerveld om deze installatie bij te werken.
De instelling is terug te vinden in LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Het bestand LocalSettings.php is al aanwezig.
Voer update.php uit om deze installatie bij te werken.',
	'config-localsettings-key' => 'Upgradesleutel:',
	'config-localsettings-badkey' => 'De sleutel die u hebt opgegeven is onjuist',
	'config-upgrade-key-missing' => 'Er is een bestaande installatie van MediaWiki aangetroffen.
Plaats de volgende regel onderaan uw LocalSettings.php om deze installatie bij te werken:

$1',
	'config-localsettings-incomplete' => 'De bestaande inhoud van LocalSettings.php lijkt incompleet.
De variabele $1 is niet ingesteld.
Wijzig LocalSettings.php zodat deze variabele is ingesteld en klik op "Doorgaan".',
	'config-localsettings-connection-error' => 'Er is een fout opgetreden tijdens het verbinden van de database met de instellingen uit LocalSettings.php of AdminSettings.php. Los het probleem met de instellingen op en probeer het daarna opnieuw.

$1',
	'config-session-error' => 'Fout bij het begin van de sessie: $1',
	'config-session-expired' => 'Uw sessiegegevens zijn verlopen.
Sessies zijn ingesteld om een levensduur van $1 te hebben.
U kunt deze wijzigen via de instelling <code>session.gc_maxlifetime</code> in php.ini.
Begin het installatieproces opnieuw.',
	'config-no-session' => 'Uw sessiegegevens zijn verloren gegaan.
Controleer uw php.ini en zorg dat er een juiste map is ingesteld voor <code>session.save_path</code>.',
	'config-your-language' => 'Uw taal:',
	'config-your-language-help' => 'Selecteer een taal om tijdens het installatieproces te gebruiken.',
	'config-wiki-language' => 'Wikitaal:',
	'config-wiki-language-help' => 'Selecteer de taal waar de wiki voornamelijk in wordt geschreven.',
	'config-back' => '← Terug',
	'config-continue' => 'Doorgaan →',
	'config-page-language' => 'Taal',
	'config-page-welcome' => 'Welkom bij MediaWiki!',
	'config-page-dbconnect' => 'Verbinding maken met database',
	'config-page-upgrade' => 'Bestaande installatie bijwerken',
	'config-page-dbsettings' => 'Databaseinstellingen',
	'config-page-name' => 'Naam',
	'config-page-options' => 'Opties',
	'config-page-install' => 'Installeren',
	'config-page-complete' => 'Voltooid!',
	'config-page-restart' => 'Installatie herstarten',
	'config-page-readme' => 'Lees mij',
	'config-page-releasenotes' => 'Release notes',
	'config-page-copying' => 'Kopiëren',
	'config-page-upgradedoc' => 'Bijwerken',
	'config-page-existingwiki' => 'Bestaande wiki',
	'config-help-restart' => 'Wilt u alle opgeslagen gegevens die u hebt ingevoerd wissen en het installatieproces opnieuw starten?',
	'config-restart' => 'Ja, opnieuw starten',
	'config-welcome' => '=== Controle omgeving ===
Er worden een aantal basiscontroles uitgevoerd met als doel vast te stellen of deze omgeving geschikt is voor een installatie van MediaWiki.
Als u hulp nodig hebt bij de installatie, lever deze gegevens dan ook aan.',
	'config-copyright' => "=== Auteursrechten en voorwaarden ===

$1

Dit programma is vrije software. U mag het verder verspreiden en/of aanpassen in overeenstemming met de voorwaarden van de GNU General Public License zoals uitgegeven door de Free Software Foundation; ofwel versie 2 van de Licentie of - naar uw keuze - enige latere versie.

Dit programma wordt verspreid in de hoop dat het nuttig is, maar '''zonder enige garantie''', zelfs zonder de impliciete garantie van '''verkoopbaarheid''' of '''geschiktheid voor een bepaald doel'''.
Zie de GNU General Public License voor meer informatie.

Samen met dit programma hoort u een <doclink href=Copying>exemplaar van de GNU General Public License</doclink> ontvangen te hebben; zo niet, schrijf dan aan de Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, Verenigde Staten. Of [http://www.gnu.org/copyleft/gpl.html lees de licentie online].",
	'config-sidebar' => '* [//www.mediawiki.org MediaWiki thuispagina]
* [//www.mediawiki.org/wiki/Help:Contents Gebruikershandleiding] (Engelstalig)
* [//www.mediawiki.org/wiki/Manual:Contents Beheerdershandleiding] (Engelstalig)
* [//www.mediawiki.org/wiki/Manual:FAQ Veel gestelde vragen] (Engelstalig)
----
* <doclink href=Readme>Leesmij</doclink> (Engelstalig)
* <doclink href=ReleaseNotes>Release notes</doclink> (Engelstalig)
* <doclink href=Copying>Kopiëren</doclink> (Engelstalig)
* <doclink href=UpgradeDoc>Versie bijwerken</doclink> (Engelstalig)',
	'config-env-good' => 'De omgeving is gecontroleerd.
U kunt MediaWiki installeren.',
	'config-env-bad' => 'De omgeving is gecontroleerd.
U kunt MediaWiki niet installeren.',
	'config-env-php' => 'PHP $1 is op dit moment geïnstalleerd.',
	'config-env-php-toolow' => 'PHP $1 is geïnstalleerd.
MediaWiki heeft PHP $2 of hoger nodig om correct te kunnen werken.',
	'config-unicode-using-utf8' => 'Voor Unicode-normalisatie wordt utf8_normalize.so van Brion Vibber gebruikt.',
	'config-unicode-using-intl' => 'Voor Unicode-normalisatie wordt de [http://pecl.php.net/intl PECL-extensie intl] gebruikt.',
	'config-unicode-pure-php-warning' => "'''Waarschuwing''': De [http://pecl.php.net/intl PECL-extensie intl] is niet beschikbaar om de Unicode-normalisatie af te handelen en daarom wordt de langzame PHP-implementatie gebruikt.
Als u MediaWiki voor een website met veel verkeer installeert, lees u dan in over [//www.mediawiki.org/wiki/Unicode_normalization_considerations Unicode-normalisatie].",
	'config-unicode-update-warning' => "'''Waarschuwing''': De geïnstalleerde versie van de Unicode-normalisatiewrapper maakt gebruik van een oudere versie van [http://site.icu-project.org/ de bibliotheek van het ICU-project].
U moet [//www.mediawiki.org/wiki/Unicode_normalization_considerations bijwerken] als Unicode voor u van belang is.",
	'config-no-db' => 'Het was niet mogelijk een geschikte databasedriver te vinden voor PHP.
U moet een databasedriver installeren voor PHP.
De volgende databases worden ondersteund: $1.

Als u op een gedeelde omgeving zit, vraag dan aan uw hostingprovider een geschikte databasedriver te installeren.
Als u PHP zelf hebt gecompileerd, wijzig dan uw instellingen zodat een databasedriver wordt geactiveerd, bijvoorbeeld via <code>./configure --with-mysql</code>.
Als u PHP hebt geïnstalleerd via een Debian- of Ubuntu-package, installeer dan ook de module php5-mysql.',
	'config-outdated-sqlite' => "''' Waarschuwing:''' u gebruikt SQLite $1. SQLite is niet beschikbaar omdat de minimaal vereiste versie $2 is.",
	'config-no-fts3' => "'''Waarschuwing''': SQLite is gecompileerd zonder de module [//sqlite.org/fts3.html FTS3]; er zijn geen zoekfuncties niet beschikbaar.",
	'config-register-globals' => "'''Waarschuwing: De PHP-optie <code>[http://php.net/register_globals register_globals]</code> is ingeschakeld.'''
'''Schakel deze uit als dat mogelijk is.'''
MediaWiki kan ermee werken, maar uw server is dan meer kwetsbaar voor beveiligingslekken.",
	'config-magic-quotes-runtime' => "'''Onherstelbare fout: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_runtime] is actief!'''
Deze instelling zorgt voor gegevenscorruptie.
U kunt MediaWiki niet installeren tenzij deze instelling is uitgeschakeld.",
	'config-magic-quotes-sybase' => "'''Onherstelbare fout: [http://www.php.net/manual/en/ref.info.php#ini.magic-quotes-runtime magic_quotes_sybase] is actief!'''
Deze instelling zorgt voor gegevenscorruptie.
U kunt MediaWiki niet installeren tenzij deze instelling is uitgeschakeld.",
	'config-mbstring' => "'''Onherstelbare fout: [http://www.php.net/manual/en/ref.mbstring.php#mbstring.overload mbstring.func_overload] is actief!'''
Deze instelling zorgt voor gegevenscorruptie.
U kunt MediaWiki niet installeren tenzij deze instelling is uitgeschakeld.",
	'config-ze1' => "'''Onherstelbare fout: [http://www.php.net/manual/en/ini.core.php zend.ze1_compatibility_mode] is actief!'''
Deze instelling zorgt voor grote problemen in MediaWiki.
U kunt MediaWiki niet installeren tenzij deze instelling is uitgeschakeld.",
	'config-safe-mode' => "'''Waarschuwing:'''
'''PHP's [http://www.php.net/features.safe-mode veilige modus] is actief.'''
Dit kan problemen veroorzaken, vooral bij het uploaden van bestanden en ondersteuning van <code>math</code>.",
	'config-xml-bad' => 'De XML-module van PHP ontbreekt.
MediaWiki heeft de functies van deze module nodig en werkt niet zonder deze module.
Als u gebruik maakt van Mandrake, installeer dan het package php-xml.',
	'config-pcre' => 'De ondersteuningsmodule PCRE lijkt te missen.
MediaWiki vereist dat de met Perl compatibele reguliere expressies werken.',
	'config-pcre-no-utf8' => "'''Fataal:''' de module PRCE van PHP lijkt te zijn gecompileerd zonder ondersteuning voor PCRE_UTF8.
MediaWiki heeft ondersteuning voor UTF-8 nodig om correct te kunnen werken.",
	'config-memory-raised' => "PHP's <code>memory_limit</code> is $1 en is verhoogd tot $2.",
	'config-memory-bad' => "'''Waarschuwing:''' PHP's <code>memory_limit</code> is $1.
Dit is waarschijnlijk te laag.
De installatie kan mislukken!",
	'config-ctype' => "'''Fataal:''' PHP moet gecompileerd zijn met ondersteuning voor de [http://www.php.net/manual/en/ctype.installation.php extensie Ctype].",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] is op dit moment geïnstalleerd',
	'config-apc' => '[http://www.php.net/apc APC] is op dit moment geïnstalleerd',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] is op dit moment geïnstalleerd',
	'config-no-cache' => "'''Waarschuwing:''' [http://www.php.net/apc APC] of [http://trac.lighttpd.net/ xcache / XCache] is niet aangetroffen.
Het cachen van objecten is niet ingeschakeld.",
	'config-mod-security' => "'''Waarschuwing:''' uw webserver heeft de module [http://modsecurity.org/ mod_security] ingeschakeld. Als deze onjuist is ingesteld, kan dit problemen geven in combinatie met MediaWiki of andere software die gebruikers in staat stelt willekeurige inhoud te posten.
Lees de [http://modsecurity.org/documentation/ documentatie over mod_security] of neem contact op met de helpdesk van uw provider als u tegen problemen aanloopt.",
	'config-diff3-bad' => 'GNU diff3 niet aangetroffen.',
	'config-imagemagick' => 'ImageMagick aangetroffen: <code>$1</code>.
Het aanmaken van miniaturen van afbeeldingen wordt ingeschakeld als u uploaden inschakelt.',
	'config-gd' => 'Ingebouwde GD grafische bibliotheek aangetroffen.
Het aanmaken van miniaturen van afbeeldingen wordt ingeschakeld als u uploaden inschakelt.',
	'config-no-scaling' => 'De GD-bibliotheek en ImageMagick zijn niet aangetroffen.
Het maken van miniaturen van afbeeldingen wordt uitgeschakeld.',
	'config-no-uri' => "'''Fout:''' de huidige URI kon niet vastgesteld worden.
De installatie is afgebroken.",
	'config-no-cli-uri' => "'''Waarschuwing:''' de parameter ==scriptpath is niet opgegeven. De standaardwaarde wordt gebruikt: <code>$1</code>.",
	'config-using-server' => 'Servernaam "<nowiki>$1</nowiki>" wordt gebruikt.',
	'config-using-uri' => 'De server-URL "<nowiki>$1$2</nowiki>" wordt gebruikt.',
	'config-uploads-not-safe' => "'''Waarschuwing:''' uw uploadmap <code>$1</code> kan gebruikt worden voor het arbitrair uitvoeren van scripts.
Hoewel MediaWiki alle toegevoegde bestanden  controleert op bedreigingen, is het zeer aan te bevelen het [//www.mediawiki.org/wiki/Manual:Security#Upload_security beveiligingslek te verhelpen] alvorens uploads in te schakelen.",
	'config-no-cli-uploads-check' => "''Waarschuwing:'' uw standaardmap voor uploads (<code>$1</code>) wordt niet gecontroleerd op kwetsbaarheden voor het uitvoeren van willekeurige scripts gedurende de CLI-installatie.",
	'config-brokenlibxml' => 'Uw systeem heeft een combinatie van PHP- en libxml2-versies geïnstalleerd die is foutgevoelig is en kan leiden tot onzichtbare beschadiging van gegevens in MediaWiki en andere webapplicaties.
Upgrade naar PHP 5.2.9 of hoger en libxml2 2.7.3 of hoger! De installatie wordt afgebroken ([//bugs.php.net/bug.php?id=45996 bij PHP gerapporteerde fout]).',
	'config-using531' => 'PHP $1 is niet compatibel met MediaWiki vanwege een fout met betrekking tot referentieparameters met <code>__call()</code>.
Werk uw PHP bij naar PHP 5.3.2 of hoger of werk bij naar de lagere versie PHP 5.3.0 om dit op te lossen.
De installatie wordt afgebroken.',
	'config-suhosin-max-value-length' => 'Suhosin is geïnstalleerd en beperkt de lengte van de GET-parameter tot $1 bytes. De ResourceLoader van MediaWiki omzeilt deze beperking, maar dat is slecht voor de prestaties. Als het mogelijk is, moet u de waarde "suhosin.get.max_value_length" in php.ini instellen op 1024 of hoger en $wgResourceLoaderMaxQueryLength in LocalSettings.php op dezelfde waarde instellen.',
	'config-db-type' => 'Databasetype:',
	'config-db-host' => 'Databasehost:',
	'config-db-host-help' => 'Als uw databaseserver een andere server is, voer dan de hostnaam of het IP-adres hier in.

Als u gebruik maakt van gedeelde webhosting, hoort uw provider u de juiste hostnaam te hebben verstrekt.

Als u MediaWiki op een Windowsserver installeert en MySQL gebruikt, dan werkt "localhost" mogelijk niet als servernaam.
Als het inderdaad niet werkt, probeer dan "127.0.0.1" te gebruiken als lokaal IP-adres.

Als u PostgreSQL gebruikt, laat dit veld dan leeg om via een Unix-socket te verbinden.',
	'config-db-host-oracle' => 'Database-TNS:',
	'config-db-host-oracle-help' => 'Voer een geldige [http://download.oracle.com/docs/cd/B28359_01/network.111/b28317/tnsnames.htm Local Connect Name] in; een tnsnames.ora-bestand moet zichtbaar zijn voor deze installatie.<br />Als u gebruik maakt van clientlibraries 10g of een latere versie, kunt u ook gebruik maken van de naamgevingsmethode [http://download.oracle.com/docs/cd/E11882_01/network.112/e10836/naming.htm Easy Connect].',
	'config-db-wiki-settings' => 'Identificeer deze wiki',
	'config-db-name' => 'Databasenaam:',
	'config-db-name-help' => 'Kies een naam die uw wiki identificeert.
Er mogen geen spaties gebruikt worden.
Als u gebruik maakt van gedeelde webhosting, dan hoort uw provider ofwel u een te gebruiken databasenaam gegeven te hebben, of u aangegeven te hebben hoe u databases kunt aanmaken.',
	'config-db-name-oracle' => 'Databaseschema:',
	'config-db-account-oracle-warn' => 'Er zijn drie ondersteunde scenario\'s voor het installeren van Oracle als databasebackend:

Als u een databasegebruiker wilt aanmaken als onderdeel van het installatieproces, geef dan de gegevens op van een databasegebruiker in met de rol SYSDBA voor de installatie en voer de gewenste aanmeldgegevens in voor de gebruiker met webtoegang. U kunt ook de gebruiker met webtoegang handmatig aanmaken en alleen van die gebruiker de aanmeldgegevens opgeven als deze de vereiste rechten heeft om schemaobjecten aan te maken. Als laatste is het mogelijk om aanmeldgegevens van twee verschillende gebruikers op te geven; een met de rechten om schemaobjecten aan te maken, en een met alleen webtoegang.

Een script voor het aanmaken van een gebruiker met de vereiste rechten is te vinden in de map "maintenance/oracle/" van deze installatie. Onthoud dat het gebruiken van een gebruiker met beperkte rechten alle mogelijkheden om beheerscripts uit te voeren met de standaard gebruiker onmogelijk maakt.',
	'config-db-install-account' => 'Gebruiker voor installatie',
	'config-db-username' => 'Gebruikersnaam voor database:',
	'config-db-password' => 'Wachtwoord voor database:',
	'config-db-password-empty' => 'Voer een wachtwoord in voor de nieuwe databasegebruiker: $1.
Hoewel het wellicht mogelijk is gebruikers aan te maken zonder wachtwoord, is dit niet veilig.',
	'config-db-install-username' => 'Voer de gebruikersnaam in die gebruikt moet worden om te verbinden met de database tijdens het installatieproces. Dit is niet de gebruikersnaam van de MediaWikigebruiker. Dit is de gebruikersnaam voor de database.',
	'config-db-install-password' => 'Voer het wachtwoord in dat gebruikt moet worden om te verbinden met de database tijdens het installatieproces. Dit is niet het wachtwoord van de MediaWikigebruiker. Dit is het wachtwoord voor de database.',
	'config-db-install-help' => 'Voer de gebruikersnaam en het wachtwoord in die worden gebruikt voor de databaseverbinding tijdens het installatieproces.',
	'config-db-account-lock' => 'Dezelfde gebruiker en wachwoord gebruiken na de installatie',
	'config-db-wiki-account' => 'Gebruiker voor na de installatie',
	'config-db-wiki-help' => 'Selecteer de gebruikersnaam en het wachtwoord die gebruikt worden om verbinding te maken met de database na de installatie.
Als de gebruiker niet bestaat en de gebruiker die tijdens de installatie gebruikt wordt voldoende rechten heeft, wordt deze gebruiker aangemaakt met de minimaal benodigde rechten voor het laten werken van de wiki.',
	'config-db-prefix' => 'Databasetabelvoorvoegsel:',
	'config-db-prefix-help' => "Als u een database moet gebruiken voor meerdere wiki's, of voor MediaWiki en een andere applicatie, dan kunt u ervoor kiezen om een voorvoegsel toe te voegen aan de tabelnamen om conflicten te voorkomen.
Gebruik geen spaties.

Dit veld wordt meestal leeg gelaten.",
	'config-db-charset' => 'Tekenset voor de database',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binair',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 UTF-8-compatibel',
	'config-charset-help' => "'''Waarschuwing:''' als u '''achterwaarts compatibel met UTF-8''' gebruikt met MySQL 4.1+ en een back-up van de database maakt met <code>mysqldump</code>, dan kunnen alle niet-ASCII-tekens in uw back-ups onherstelbaar beschadigd raken.

In '''binaire modus''' slaat MediaWiki tekst in UTF-8 op in binaire databasevelden.
Dit is efficiënter dan de UTF-8-modus van MySQL en stelt u in staat de volledige reeks Unicode-tekens te gebruiken.
In '''UTF-8-modus''' kent MySQL de tekenset van uw gegevens en kan de databaseserver ze juist weergeven en converteren.
Het is dan niet mogelijk tekens op te slaan die de \"[//nl.wikipedia.org/wiki/Lijst_van_Unicode-subbereiken#Basic_Multilingual_Plane Basic Multilingual Plane]\" te boven gaan.",
	'config-mysql-old' => 'U moet MySQL $1 of later gebruiken.
U gebruikt $2.',
	'config-db-port' => 'Databasepoort:',
	'config-db-schema' => 'Schema voor MediaWiki',
	'config-db-schema-help' => 'Dit schema klopt meestal.
Wijzig het alleen als u weet dat dit nodig is.',
	'config-pg-test-error' => "Kan geen verbinding maken met database '''$1''': $2",
	'config-sqlite-dir' => 'Gegevensmap voor SQLite:',
	'config-sqlite-dir-help' => "SQLite slaat alle gegevens op in een enkel bestand.

De map die u opgeeft moet schrijfbaar zijn voor de webserver tijdens de installatie.

Deze mag '''niet toegankelijk''' zijn via het web en het bestand mag dus niet tussen de PHP-bestanden staan.

Het installatieprogramma schrijft het bestand <code>.htaccess</code> weg met het databasebestand, maar als dat niet werkt kan iemand zich toegang tot het ruwe databasebestand verschaffen.
Ook de gebruikersgegevens (e-mailsadressen, wachtwoordhashes) en verwijderde versies en overige gegevens met beperkte toegang via MediaWiki zijn dan onbeschermd.

Overweeg om de database op een totaal andere plaats neer te zetten, bijvoorbeeld in <code>/var/lib/mediawiki/yourwiki</code>.",
	'config-oracle-def-ts' => 'Standaard tablespace:',
	'config-oracle-temp-ts' => 'Tijdelijke tablespace:',
	'config-type-mysql' => 'MySQL',
	'config-type-postgres' => 'PostgreSQL',
	'config-type-sqlite' => 'SQLite',
	'config-type-oracle' => 'Oracle',
	'config-type-ibm_db2' => 'IBM DB2',
	'config-support-info' => 'MediaWiki ondersteunt de volgende databasesystemen:

$1

Als u het databasesysteem dat u wilt gebruiken niet in de lijst terugvindt, volg dan de handleiding waarnaar hierboven wordt verwezen om ondersteuning toe te voegen.',
	'config-support-mysql' => '* $1 is het primaire databasesysteem voor voor MediaWiki en wordt het best ondersteund ([http://www.php.net/manual/en/mysql.installation.php hoe PHP gecompileerd moet zijn met ondersteuning voor MySQL])',
	'config-support-postgres' => '* $1 is een populair open source databasesysteem als alternatief voor MySQL ([http://www.php.net/manual/en/pgsql.installation.php hoe PHP gecompileerd moet zijn met ondersteuning voor PostgreSQL]). Het is mogelijk dat er een aantal bekende problemen zijn met MediaWiki in combinatie met deze database en daarom wordt PostgreSQL niet aanbevolen voor een productieomgeving.',
	'config-support-sqlite' => '* $1 is een zeer goed ondersteund lichtgewicht databasesysteem ([http://www.php.net/manual/en/pdo.installation.php hoe PHP gecompileerd zijn met ondersteuning voor SQLite]; gebruikt PDO)',
	'config-support-oracle' => '* $1 is een commerciële data voor grote bedrijven ([http://www.php.net/manual/en/oci8.installation.php PHP compileren met ondersteuning voor OCI8]).',
	'config-support-ibm_db2' => '* $1 is een commerciële enterprisedatabase.',
	'config-header-mysql' => 'MySQL-instellingen',
	'config-header-postgres' => 'PostgreSQL-instellingen',
	'config-header-sqlite' => 'SQLite-instellingen',
	'config-header-oracle' => 'Oracle-instellingen',
	'config-header-ibm_db2' => 'Instellingen voor IBM DB2',
	'config-invalid-db-type' => 'Ongeldig databasetype',
	'config-missing-db-name' => 'U moet een waarde ingeven voor "Databasenaam"',
	'config-missing-db-host' => 'U moet een waarde invoeren voor "Databaseserver"',
	'config-missing-db-server-oracle' => 'U moet een waarde voor "Database-TNS" ingeven',
	'config-invalid-db-server-oracle' => 'Ongeldige database-TMS "$1".
Gebruik alleen letters (a-z, A-Z), cijfers (0-9) en liggende streepjes (_).',
	'config-invalid-db-name' => 'Ongeldige databasenaam "$1".
Gebruik alleen letters (a-z, A-Z), cijfers (0-9) en liggende streepjes (_) en streepjes (-).',
	'config-invalid-db-prefix' => 'Ongeldig databasevoorvoegsel "$1".
Gebruik alleen letters (a-z, A-Z), cijfers (0-9) en liggende streepjes (_) en streepjes (-).',
	'config-connection-error' => '$1.

Controleer de host, gebruikersnaam en wachtwoord hieronder in en probeer het opnieuw.',
	'config-invalid-schema' => 'Ongeldig schema voor MediaWiki "$1".
Gebruik alleen letters (a-z, A-Z), cijfers (0-9) en liggende streepjes (_).',
	'config-db-sys-create-oracle' => 'Het installatieprogramma biedt alleen de mogelijkheid een nieuwe gebruiker aan te maken met de SYSDBA-gebruiker.',
	'config-db-sys-user-exists-oracle' => 'De gebruiker "$1" bestaat al. SYSDBA kan alleen gebruikt worden voor het aanmaken van een nieuwe gebruiker!',
	'config-postgres-old' => 'PostgreSQL $1 of hoger is vereist.
U gebruikt $2.',
	'config-sqlite-name-help' => 'Kies een naam die uw wiki identificeert.
Gebruik geen spaties of koppeltekens.
Deze naam wordt gebruikt voor het gegevensbestands van SQLite.',
	'config-sqlite-parent-unwritable-group' => 'Het was niet mogelijk de gegevensmap <code><nowiki>$1</nowiki></code> te maken omdat in de bovenliggende map <code><nowiki>$2</nowiki></code> niet geschreven mag worden door de webserver.

Het installatieprogramma heeft vast kunnen stellen onder welke gebruiker de webserver draait.
Maak de map <code><nowiki>$3</nowiki></code> beschrijfbaar om door te kunnen gaan.
Voer op een Linux-systeem de volgende opdrachten uit:

<pre>cd $2
mkdir $3
chgrp $4 $3
chmod g+w $3</pre>',
	'config-sqlite-parent-unwritable-nogroup' => 'Het was niet mogelijk de gegevensmap <code><nowiki>$1</nowiki></code> te maken omdat in de bovenliggende map <code><nowiki>$2</nowiki></code> niet geschreven mag worden door de webserver.

Het installatieprogramma heeft niet vast kunnen stellen onder welke gebruiker de webserver draait.
Maak de map <code><nowiki>$3</nowiki></code> beschrijfbaar voor de webserver (en anderen!) om door te kunnen gaan.
Voer op een Linux-systeem de volgende opdrachten uit:

<pre>cd $2
mkdir $3
chmod a+w $3</pre>',
	'config-sqlite-mkdir-error' => 'Er is een fout opgetreden bij het aanmaken van de gegevensmap "$1".
Controleer de locatie en probeer het opnieuw.',
	'config-sqlite-dir-unwritable' => 'Het was niet mogelijk in de map "$1" te schrijven.
Wijzig de rechten zodat de webserver erin kan schrijven en probeer het opnieuw.',
	'config-sqlite-connection-error' => '$1.

Controleer de map voor gegevens en de databasenaam hieronder en probeer het opnieuw.',
	'config-sqlite-readonly' => 'Het bestand <code>$1</code> kan niet geschreven worden.',
	'config-sqlite-cant-create-db' => 'Het was niet mogelijk het databasebestand <code>$1</code> aan te maken.',
	'config-sqlite-fts3-downgrade' => 'PHP heeft geen ondersteuning voor FTS3.
De tabellen worden gedowngrade.',
	'config-can-upgrade' => "Er staan al tabellen voor MediaWiki in deze database.
Klik op '''Doorgaan''' om ze bij te werken naar MediaWiki $1.",
	'config-upgrade-done' => "Het bijwerken is afgerond.

Uw kunt [$1 uw wiki nu gebruiken].

Als u uw <code>LocalSettings.php</code> opnieuw wilt aanmaken, klik dan op de knop hieronder.
Dit is '''niet aan te raden''' tenzij u problemen hebt met uw wiki.",
	'config-upgrade-done-no-regenerate' => 'Het bijwerken is afgerond.

U kunt u [$1 uw wiki gebruiken].',
	'config-regenerate' => 'LocalSettings.php opnieuw aanmaken →',
	'config-show-table-status' => 'Het uitvoeren van SHOW TABLE STATUS is mislukt!',
	'config-unknown-collation' => "'''Waarschuwing:''' de database gebruikt een collatie die niet wordt herkend.",
	'config-db-web-account' => 'Databasegebruiker voor webtoegang',
	'config-db-web-help' => 'Selecteer de gebruikersnaam en het wachtwoord die de webserver gebruikt om verbinding te maken met de databaseserver na de installatie.',
	'config-db-web-account-same' => 'Dezelfde gebruiker gebruiken als voor de installatie',
	'config-db-web-create' => 'Maak de gebruiker aan als deze nog niet bestaat',
	'config-db-web-no-create-privs' => 'De gebruiker die u hebt opgegeven voor de installatie heeft niet voldoende rechten om een gebruiker aan te maken.
De gebruiker die u hier opgeeft moet al bestaan.',
	'config-mysql-engine' => 'Opslagmethode:',
	'config-mysql-innodb' => 'InnoDB',
	'config-mysql-myisam' => 'MyISAM',
	'config-mysql-myisam-dep' => "'''Waarschuwing''': U hebt MyISAM geselecteerd als opslagengine voor MySQL. Dit is niet aan te raden voor MediaWiki omdat:
* het nauwelijks ondersteuning biedt voor gebruik door meerdere gebruikers tegelijkertijd door het locken van tabellen;
* het meer vatbaar is voor corruptie dan andere engines;
* de code van MediaWiki niet alstijd omgaat met MyISAM zoals dat zou moeten.

Als uw installatie van MySQL InnoDB ondersteunt, gebruik dat dan vooral.
Als uw installatie van MySQL geen ondersteuning heeft voor InnoDB, denk dan na over upgraden.",
	'config-mysql-engine-help' => "'''InnoDB''' is vrijwel altijd de beste instelling, omdat deze goed omgaat met meerdere verzoeken tegelijkertijd.

'''MyISAM''' is bij een zeer beperkt aantal gebruikers mogelijk sneller, of als de wiki alleen-lezen is.
MyISAM-databases raken vaker corrupt dan InnoDB-databases.",
	'config-mysql-charset' => 'Tekenset voor de database:',
	'config-mysql-binary' => 'Binair',
	'config-mysql-utf8' => 'UTF-8',
	'config-mysql-charset-help' => "In '''binaire modus''' slaat MediaWiki tekst in UTF-8 op in binaire databasevelden.
Dit is efficiënter dan de UTF-8-modus van MySQL en stelt u in staat de volledige reeks Unicode-tekens te gebruiken.

In '''UTF-8-modus''' kent MySQL de tekenset van uw gegevens en kan de databaseserver ze juist weergeven en converteren.
Het is dat niet mogelijk tekens op te slaan die de \"[//nl.wikipedia.org/wiki/Lijst_van_Unicode-subbereiken#Basic_Multilingual_Plane Basic Multilingual Plane]\" te boven gaan.",
	'config-ibm_db2-low-db-pagesize' => "Uw DB2-database heeft een standaard tablespace met een onvoldoende grote pagesize. De pagesize moet tenminste '''32K''' zijn.",
	'config-site-name' => 'Naam van de wiki:',
	'config-site-name-help' => 'Deze naam verschijnt in de titelbalk van browsers en op andere plaatsen.',
	'config-site-name-blank' => 'Geef een naam op voor de site.',
	'config-project-namespace' => 'Projectnaamruimte:',
	'config-ns-generic' => 'Project',
	'config-ns-site-name' => 'Zelfde als de wiki: $1',
	'config-ns-other' => 'Andere (geef aan welke)',
	'config-ns-other-default' => 'MijnWiki',
	'config-project-namespace-help' => "In het kielzog van Wikipedia beheren veel wiki's hun beleidspagina's apart van hun inhoudelijke pagina's in een \"'''projectnaamruimte'''\".
Alle paginanamen in deze naamruimte beginnen met een bepaald voorvoegsel dat u hier kunt aangeven.
Dit voorvoegsel wordt meestal afgeleid van de naam van de wiki, maar het kan geen bijzondere tekens bevatten als \"#\" of \":\".",
	'config-ns-invalid' => 'De aangegeven naamruimte "<nowiki>$1</nowiki>" is ongeldig.
Geef een andere naamruimte op.',
	'config-ns-conflict' => 'De aangegeven naamruimte "<nowiki>$1</nowiki>" conflicteert met een standaard naamruimte in MediaWiki.
Geef een andere naam op voor de projectnaamruimte.',
	'config-admin-box' => 'Beheerdersgebruiker',
	'config-admin-name' => 'Uw naam:',
	'config-admin-password' => 'Wachtwoord:',
	'config-admin-password-confirm' => 'Wachtwoord opnieuw:',
	'config-admin-help' => 'Voer de gebruikersnaam hier in, bijvoorbeeld "Jan Jansen".
Dit is de naam die wordt gebruikt om aan de melden bij de wiki.',
	'config-admin-name-blank' => 'Geef een gebruikersnaam op voor de beheerder.',
	'config-admin-name-invalid' => 'De opgegeven gebruikersnaam "<nowiki>$1</nowiki>" is ongeldig.
Kies een andere gebruikersnaam.',
	'config-admin-password-blank' => 'Voer een wachtwoord voor de beheerder in.',
	'config-admin-password-same' => 'Het wachtwoord mag niet hetzelfde zijn als de gebruikersnaam.',
	'config-admin-password-mismatch' => 'De twee door u ingevoerde wachtwoorden komen niet overeen.',
	'config-admin-email' => 'E-mailadres:',
	'config-admin-email-help' => "Voer hier een e-mailadres in om e-mail te kunnen ontvangen van andere gebruikers op de wiki, uw wachtwoord opnieuw in te kunnen stellen en op de hoogte te worden gehouden van wijzigingen van pagina's op uw volglijst. U kunt het veld leeg laten.",
	'config-admin-error-user' => 'Interne fout bij het aanmaken van een beheerder met de naam "<nowiki>$1</nowiki>".',
	'config-admin-error-password' => 'Interne fout bij het instellen van een wachtwoord voor de bejeerder "<nowiki>$1</nowiki>": <pre>$2</pre>',
	'config-admin-error-bademail' => 'U hebt een ongeldig e-mailadres opgegeven',
	'config-subscribe' => 'Abonneren op de [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce mailinglijst releaseaankondigen].',
	'config-subscribe-help' => 'Dit is een mailinglijst met een laag volume voor aankondigingen van nieuwe versies, inclusief belangrijke aankondigingen met betrekking tot beveiliging.
Abonneer uzelf erop en werk uw MediaWiki-installatie bij als er nieuwe versies uitkomen.',
	'config-subscribe-noemail' => 'U hebt geprobeerd zich te abonneren op de mailinglijst voor release-aankondigingen zonder een e-mailadres op te geven.
Geef een e-mailadres op als u zich wil abonneren op de mailinglijst.',
	'config-almost-done' => 'U bent bijna klaar!
Als u wilt kunt u de overige instellingen overslaan en de wiki nu installeren.',
	'config-optional-continue' => 'Stel me meer vragen.',
	'config-optional-skip' => 'Laat dat maar, installeer gewoon de wiki.',
	'config-profile' => 'Gebruikersrechtenprofiel:',
	'config-profile-wiki' => 'Traditionele wiki',
	'config-profile-no-anon' => 'Gebruiker aanmaken verplicht',
	'config-profile-fishbowl' => 'Alleen voor geautoriseerde bewerkers',
	'config-profile-private' => 'Privéwiki',
	'config-profile-help' => "Wiki's werken het beste als ze door zoveel mogelijk gebruikers worden bewerkt.
In MediaWiki is het eenvoudig om de recente wijzigingen te controleren en eventuele foutieve of kwaadwillende bewerkingen terug te draaien.

Daarnaast vinden velen MediaWiki goed inzetbaar in vele andere rollen, en soms is het niet handig om helemaal \"op de wikimanier\" te werken.
Daarom biedt dit installatieprogramma u de volgende keuzes voor de basisinstelling van gebruikersvrijheden:

Een '''{{int:config-profile-wiki}}''' staat iedereen toe te bewerken, zonder zelfs aan te melden.
Een wiki met '''{{int:config-profile-no-anon}}\" biedt extra verantwoordelijkheid, maar kan afschrikken toevallige gebruikers afschrikken.

Het scenario '''{{int:config-profile-fishbowl}}''' laat gebruikers waarvoor dat is ingesteld bewerkt, maar andere gebruikers kunnen alleen pagina's bekijken, inclusief de bewerkingsgeschiedenis.
In een '''{{int:config-profile-private}}''' kunnen alleen goedgekeurde gebruikers pagina's bekijken en bewerken.

Meer complexe instellingen voor gebruikersrechten zijn te maken na de installatie; hierover is meer te lezen in de [//www.mediawiki.org/wiki/Manual:User_rights handleiding].",
	'config-license' => 'Auteursrechten en licentie:',
	'config-license-none' => 'Geen licentie in de voettekst',
	'config-license-cc-by-sa' => 'Creative Commons Naamsvermelding-Gelijk delen',
	'config-license-cc-by' => 'Creative Commons Naamsvermelding',
	'config-license-cc-by-nc-sa' => 'Creative Commons Naamsvermelding-Niet Commercieel-Gelijk delen',
	'config-license-cc-0' => 'Creative Commons Zero (Publiek domein)',
	'config-license-gfdl' => 'GNU Free Documentation License 1.3 of hoger',
	'config-license-pd' => 'Publiek domein',
	'config-license-cc-choose' => 'Een Creative Commons-licentie selecteren',
	'config-license-help' => "In veel openbare wiki's zijn alle bijdragen beschikbaar onder een [http://freedomdefined.org/Definition vrije licentie].
Dit helpt bij het creëren van een gevoel van gemeenschappelijk eigendom en stimuleert bijdragen op lange termijn.
Dit is over het algemeen niet nodig is voor een particuliere of zakelijke wiki.

Als u teksten uit Wikipedia wilt kunnen gebruiken en u wilt het mogelijk maken teksten uit uw wiki naar Wikipedia te kopiëren, kies dan de licentie '''Creative Commons Naamsvermelding-Gelijk delen'''.

De GNU Free Documentation License is de oude licentie voor inhoud uit Wikipedia.
Dit is nog steeds een geldige licentie, maar deze licentie is lastig te begrijpen.
Het is ook lastig inhoud te hergebruiken onder de GFDL.",
	'config-email-settings' => 'E-mailinstellingen',
	'config-enable-email' => 'Uitgaande e-mail inschakelen',
	'config-enable-email-help' => "Als u wilt dat e-mailen mogelijk is, dan moeten [http://www.php.net/manual/en/mail.configuration.php PHP's e-mailinstellingen] correct zijn.
Als u niet wilt dat e-mailen mogelijk is, dan kunt u de instellingen hier uitschakelen.",
	'config-email-user' => 'E-mail tussen gebruikers inschakelen',
	'config-email-user-help' => 'Gebruikers toestaan e-mail aan elkaar te verzenden als dit in de voorkeuren is ingesteld.',
	'config-email-usertalk' => 'Gebruikersoverlegnotificatie inschakelen',
	'config-email-usertalk-help' => 'Gebruikers toestaan notificaties te ontvangen bij wijzigingen op de eigen overlegpagina als dit in de voorkeuren is ingesteld',
	'config-email-watchlist' => 'Volglijstnotificatie inschakelen',
	'config-email-watchlist-help' => "Gebruikers toestaan notificaties te ontvangen bij wijzigingen van pagina's op hun volglijst als dit in de voorkeuren is ingesteld",
	'config-email-auth' => 'E-mailbevestiging inschakelen',
	'config-email-auth-help' => "Als deze instelling actief is, moeten gebruikers hun e-mailadres bevestigen via een verwijziging die ze per e-mail wordt toegezonden.
Alleen bevestigde e-mailadressen kunnen e-mail ontvangen van andere gebruikers of wijzigingsnotificaties ontvangen.
Het inschakelen van deze instelling is '''aan te raden''' voor openbare wiki's vanwege de mogelijkheden voor misbruik van e-mailmogelijkheden.",
	'config-email-sender' => 'E-mailadres voor antwoorden:',
	'config-email-sender-help' => 'Voer het e-mailadres in dat u wilt gebruiken als antwoordadres voor uitgaande e-mail.
Als een e-mail niet bezorgd kan worden, wordt dat op dit e-mailadres gemeld.
Veel mailservers vereisen dat tenminste het domein bestaat.',
	'config-upload-settings' => 'Afbeeldingen en bestanden uploaden',
	'config-upload-enable' => 'Uploaden van bestanden inschakelen',
	'config-upload-help' => "Het uploaden van bestanden stelt uw server mogelijk bloot aan beveiligingsrisico's.
Er is meer [//www.mediawiki.org/wiki/Manual:Security informatie over beveiliging] beschikbaar in de handleiding.

Om het bestandsuploads mogelijk te maken kunt u de rechten op de submap <code>images</code> onder de hoofdmap van MediaWiki aanpassen, zodat de webserver erin kan schrijven.
Daarmee wordt deze functie ingeschakeld.",
	'config-upload-deleted' => 'Map voor verwijderde bestanden:',
	'config-upload-deleted-help' => 'Kies een map waarin verwijderde bestanden gearchiveerd kunnen worden.
Idealiter is deze map niet via het web te benaderen.',
	'config-logo' => 'URL voor logo:',
	'config-logo-help' => 'Het standaarduiterlijk van MediaWiki bevat ruimte voor een logo van 135x160 pixels boven het menu.
Upload een afbeelding met de juiste afmetingen en voer de URL hier in.

Als u geen logo wilt gebruiken, kunt u dit veld leeg laten.',
	'config-instantcommons' => 'Instant Commons inschakelen',
	'config-instantcommons-help' => '[//www.mediawiki.org/wiki/InstantCommons Instant Commons] is functie die het mogelijk maakt om afbeeldingen, geluidsbestanden en andere mediabestanden te gebruiken van de website [//commons.wikimedia.org/ Wikimedia Commons].
Hiervoor heeft MediaWiki toegang nodig tot Internet.

Meer informatie over deze functie en hoe deze in te stellen voor andere wiki\'s dan Wikimedia Commons is te vinden in de [//mediawiki.org/wiki/Manual:$wgForeignFileRepos handleiding].',
	'config-cc-error' => 'De licentiekiezer van Creative Commons heeft geen resultaat opgeleverd.
Voer de licentie handmatig in.',
	'config-cc-again' => 'Opnieuw kiezen...',
	'config-cc-not-chosen' => 'Kies alstublieft de Creative Commons-licentie die u wilt gebruiken en klik op "doorgaan".',
	'config-advanced-settings' => 'Gevorderde instellingen',
	'config-cache-options' => 'Instellingen voor het cachen van objecten:',
	'config-cache-help' => 'Het cachen van objecten wordt gebruikt om de snelheid van MediaWiki te verbeteren door vaak gebruikte gegevens te bewaren.
Middelgrote tot grote websites wordt geadviseerd dit in te schakelen en ook kleine sites merken de voordelen.',
	'config-cache-none' => 'Niets cachen.
Er gaat geen functionaliteit verloren, maar dit kan invloed hebben op de snelheid.',
	'config-cache-accel' => 'Cachen van objecten via PHP (APC, XCache of WinCache)',
	'config-cache-memcached' => 'Memcached gebruiken (dit vereist aanvullende instellingen)',
	'config-memcached-servers' => 'Memcachedservers:',
	'config-memcached-help' => 'Lijst met IP-adressen te gebruiken voor Memcached.
Eén IP-adres per regel met een poortnummer.
Bijvoorbeeld:
 127.0.0.1:11211
 192.168.1.25:1234',
	'config-memcache-needservers' => 'U hebt Memcached geselecteerd als uw cache, maar u hebt geen servers opgegeven.',
	'config-memcache-badip' => 'U hebt een ongeldig IP-adres ingevoerd voor Memcached: $1.',
	'config-memcache-noport' => 'U hebt geen poort opgegeven voor de Memcachedserver: $1.
De standaardpoort is 11211.',
	'config-memcache-badport' => 'Poortnummers voor Memcached moeten tussen $1 en $2 liggen.',
	'config-extensions' => 'Uitbreidingen',
	'config-extensions-help' => 'De bovenstaande uitbreidingen zijn aangetroffen in de map <code>./extensions</code>.

Mogelijk moet u aanvullende instellingen maken, maar u kunt deze uitbreidingen nu inschakelen.',
	'config-install-alreadydone' => "'''Waarschuwing:''' het lijkt alsof u MediaWiki al hebt geïnstalleerd en probeert het programma opnieuw te installeren.
Ga alstublieft door naar de volgende pagina.",
	'config-install-begin' => 'Als u nu op "{{int:config-continue}}" klikt, begint de installatie van MediaWiki.
Als u nog wijzigingen wilt maken, klik dan op "Terug".',
	'config-install-step-done' => 'Afgerond',
	'config-install-step-failed' => 'Mislukt',
	'config-install-extensions' => 'Inclusief uitbreidingen',
	'config-install-database' => 'Database inrichten',
	'config-install-schema' => 'Het schema wordt aangemaakt',
	'config-install-pg-schema-not-exist' => 'Het schema voor PostgreSQL bestaat niet',
	'config-install-pg-schema-failed' => 'Het aanmaken van de tabellen is mislukt.
Zorg dat de gebruiker "$1" in het schema "$2" mag schrijven.',
	'config-install-pg-commit' => 'Wijzigingen worden doorgevoerd',
	'config-install-pg-plpgsql' => 'Controle op de taal PL/pgSQL',
	'config-pg-no-plpgsql' => 'U moet de taal PL/pgSQL installeren in de database $1',
	'config-pg-no-create-privs' => 'De gebruiker die u hebt opgegeven door de installatie heeft niet voldoende rechten om een gebruiker aan te maken.',
	'config-pg-not-in-role' => 'De gebruiker die u hebt opgegeven voor de webgebruiker bestaat al.
De gebruiker die u hebt opgegeven voor installatie is geen superuser en geen lid van de rol van de webgebruiker, en kan het dus geen objecten aanmaken die van de webgebruiker zijn.

MediaWiki vereist momenteel dat de tabellen van de webgebruiker zijn. Geef een andere webgebruikersnaam op, of klik op "terug" en geef een gebruiker op die voldoende installatierechten heeft.',
	'config-install-user' => 'Databasegebruiker aan het aanmaken',
	'config-install-user-alreadyexists' => 'Gebruiker "$1" bestaat al',
	'config-install-user-create-failed' => 'Het aanmaken van de gebruiker "$1" is mislukt: $2',
	'config-install-user-grant-failed' => 'Het geven van rechten aan gebruiker "$1" is mislukt: $2',
	'config-install-user-missing' => 'De opgegeven gebruiker "$1" bestaat niet.',
	'config-install-user-missing-create' => 'De opgegeven gebruiker "$1" bestaat niet.
Klik op "registreren" onderaan als u het wilt aanmaken.',
	'config-install-tables' => 'Tabellen aanmaken',
	'config-install-tables-exist' => "'''Waarschuwing''': de MediaWiki-tabellen lijken al te bestaan.
Het aanmaken wordt overgeslagen.",
	'config-install-tables-failed' => "'''Fout''': het aanmaken van een tabel is mislukt met de volgende foutmelding: $1",
	'config-install-interwiki' => 'Bezig met het vullen van de interwikitabel',
	'config-install-interwiki-list' => 'Het bestand <code>interwiki.list</code> is niet aangetroffen',
	'config-install-interwiki-exists' => "'''Waarschuwing''': de interwikitabel heeft al inhoud.
De standaardlijst wordt overgeslagen.",
	'config-install-stats' => 'Statistieken initialiseren',
	'config-install-keys' => 'Bezig met aanmaken van geheime sleutels',
	'config-insecure-keys' => "'''Waarschuwing:''' De {{PLURAL:$2|sleutel die is aangemaakt|sleutels die zijn aangemaakt}} ($1) tijdens de installatie {{PLURAL:$2|is|zijn}} niet volledig veilig. Overweeg deze handmatig te wijzigen.",
	'config-install-sysop' => 'Gebruiker voor beheerder aanmaken',
	'config-install-subscribe-fail' => 'Het is niet mogelijk te abonneren op mediawiki-announce: $1',
	'config-install-subscribe-notpossible' => 'cURL is niet geïnstalleerd en <code>allow_url_fopen</code> is niet beschikbaar.',
	'config-install-mainpage' => 'Hoofdpagina aanmaken met standaard inhoud',
	'config-install-extension-tables' => 'Tabellen voor ingeschakelde uitbreidingen worden aangemaakt',
	'config-install-mainpage-failed' => 'Het was niet mogelijk de hoofdpagina in te voegen: $1',
	'config-install-done' => "'''Gefeliciteerd!'''
U hebt MediaWiki met geïnstalleerd.

Het installatieprogramma heeft het bestand <code>LocalSettings.php</code> aangemaakt.
Dit bevat al uw instellingen.

U moet het bestand downloaden en in de hoofdmap van uw wiki-installatie plaatsten; in dezelfde map als index.php.
De download moet u automatisch zijn aangeboden.

Als de download niet is aangeboden of als u de download hebt geannuleerd, dan kunt u de download opnieuw starten door op de onderstaande verwijzing te klikken:

$3

'''Let op''': als u dit niet nu doet, dan het is bestand als u later de installatieprocedure afsluit zonder het bestand te downloaden niet meer beschikbaar.

Na het plaatsen van het bestand met instellingen kunt u '''[$2 uw wiki betreden]'''.",
	'config-download-localsettings' => 'LocalSettings.php downloaden',
	'config-help' => 'hulp',
	'config-nofile' => 'Het bestand "$1" is niet gevonden. Is het verwijderd?',
	'mainpagetext' => "'''De installatie van MediaWiki is geslaagd.'''",
	'mainpagedocfooter' => 'Raadpleeg de [//meta.wikimedia.org/wiki/NL_Help:Inhoudsopgave handleiding] voor informatie over het gebruik van de wikisoftware.

== Meer hulp over MediaWiki ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lijst met instellingen]
* [//www.mediawiki.org/wiki/Manual:FAQ Veelgestelde vragen (FAQ)]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Mailinglijst voor aankondigingen van nieuwe versies]',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Harald Khan
 * @author Nghtwlkr
 */
$messages['nn'] = array(
	'config-your-language' => 'Språket ditt:',
	'config-wiki-language' => 'Wikispråk:',
	'config-back' => '← Attende',
	'config-continue' => 'Hald fram →',
	'config-page-language' => 'Språk',
	'config-memory-raised' => 'PHPs <code>memory_limit</code> er $1, auka til $2.',
	'config-memory-bad' => "'''Advarsel:''' PHPs <code>memory_limit</code> er $1.
Dette er sannsynlegvis for lågt.
Installasjonen kan mislukkast!",
	'config-xcache' => '[http://xcache.lighttpd.net/ XCache] er innstallert',
	'config-apc' => '[http://www.php.net/apc APC] er innstallert',
	'config-wincache' => '[http://www.iis.net/download/WinCacheForPhp WinCache] er installert',
	'config-db-name' => 'Databasenamn:',
	'config-db-username' => 'Databasebrukarnamn:',
	'config-db-password' => 'Databasepassord:',
	'config-db-charset' => 'Databaseteiknsett',
	'config-charset-mysql5-binary' => 'MySQL 4.1/5.0 binær',
	'config-charset-mysql5' => 'MySQL 4.1/5.0 UTF-8',
	'config-charset-mysql4' => 'MySQL 4.0 bakoverkompatibel UTF-8',
	'config-mysql-old' => 'MySQL $1 eller seinare krevst, du har $2.',
	'config-db-port' => 'Databaseport:',
	'config-db-schema' => 'Skjema for MediaWiki',
	'config-header-mysql' => 'MySQL-innstillingar',
	'config-header-postgres' => 'PostgreSQL-innstillingar',
	'config-header-sqlite' => 'SQLite-innstillingar',
	'config-header-oracle' => 'Oracle-innstillingar',
	'config-invalid-db-type' => 'Ugyldig databasetype',
	'config-invalid-db-name' => 'Ugyldig databasenamn «$1».
Berre bruk ASCII-bokstavar (a-z, A-Z), tal (0-9) og undestrekar (_).', # Fuzzy
	'config-invalid-db-prefix' => 'Ugyldig databaseprefiks «$1».
Berre bruk ASCII-bokstavar (a-z, A-Z), tal (0-9) og undestrekar (_).', # Fuzzy
	'config-invalid-schema' => 'Ugyldig skjema for MediaWiki «$1».
Berre bruk ASCII-bokstavar (a-z, A-Z), tal (0-9) og undestrekar (_).',
	'config-postgres-old' => 'PostgreSQL $1 eller seinare krevst, du har $2.',
	'config-email-settings' => 'E-postinnstillingar',
	'config-logo' => 'Logo-URL:',
	'mainpagetext' => "'''MediaWiki er no installert.'''",
	'mainpagedocfooter' => 'Sjå [//meta.wikimedia.org/wiki/Help:Contents brukarmanualen] for informasjon om bruk og oppsettshjelp for wikiprogramvara.

==Kome i gang==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Liste over oppsettsinnstillingar]
* [//www.mediawiki.org/wiki/Manual:FAQ Spørsmål og svar om MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce E-postliste med informasjon om nye MediaWiki-versjonar]',
);

/** Norwegian (bokmål)‬ (‪norsk (bokmål)‬) */
$messages['no'] = array(
	'mainpagetext' => "'''MediaWiki-programvaren er nå installert.'''",
);

/** Occitan (occitan)
 */
$messages['oc'] = array(
	'mainpagetext' => "'''MediaWiki es estat installat amb succès.'''",
	'mainpagedocfooter' => "Consultatz lo [//meta.wikimedia.org/wiki/Ajuda:Contengut Guida de l'utilizaire] per mai d'entresenhas sus l'utilizacion d'aqueste logicial.

== Començar amb MediaWiki ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lista dels paramètres de configuracion]
* [//www.mediawiki.org/wiki/Manual:FAQ/fr FAQ MediaWiki]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de discussions de las parucions de MediaWiki]",
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Jnanaranjan Sahu
 */
$messages['or'] = array(
	'config-back' => '← ପଛକୁ',
	'config-continue' => 'ଚାଲୁରଖିବେ →',
	'config-page-language' => 'ଭାଷା',
	'config-page-welcome' => 'ମେଡିଆଉଇକିକୁ ଆପଣଙ୍କୁ ସ୍ଵାଗତ',
	'config-page-name' => 'ନାମ',
	'config-page-options' => 'ପସନ୍ଦସମୂହ',
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'config-page-language' => 'Æвзаг',
	'mainpagetext' => "'''Вики-скрипт «MediaWiki» æнтыстджынæй æвæрд æрцыд.'''",
);

/** Punjabi (ਪੰਜਾਬੀ)
 */
$messages['pa'] = array(
	'mainpagetext' => "'''ਮੀਡਿਆਵਿਕਿ ਠੀਕ ਤਰ੍ਹਾਂ ਇੰਸਟਾਲ ਹੋ ਗਿਆ ਹੈ।'''",
);

/** Pampanga (Kapampangan)
 */
$messages['pam'] = array(
	'mainpagetext' => "'''Melaus ing pamipalyari ning MediaWiki.'''",
	'mainpagedocfooter' => "Basan me ing [//meta.wikimedia.org/wiki/Help:Contents User's Guide] para king impormasiun keng pamangamit ning wiki software.

== Pamagumpisa ==
* [//www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",
);

/** Picard (Picard)
 */
$messages['pcd'] = array(
	'mainpagetext' => "'''MediaWiki o té instalé aveuc victoère.'''",
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'config-continue' => 'Weider →',
	'config-page-language' => 'Schprooch',
	'config-admin-password' => 'Paesswatt:',
	'config-install-step-done' => 'geduh',
	'config-help' => 'Hilf',
	'mainpagedocfooter' => "Hilf fer's Yuuse unn Konfiguriere vun de Wiki-Software kansch finne im [//meta.wikimedia.org/wiki/Help:Contents Handbuch fer Yuuser].

== Hilf zum Schtaerte ==

* [//www.mediawiki.org/wiki/Manual:Configuration_settings Lischt vun Gnepp zum Konfiguriere]
* [//www.mediawiki.org/wiki/Manual:FAQ MediaWiki-FAQ]
* [https://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Eposchde-Lischt fer neie MediaWiki-Versione]",
);

/** Polish (polski)
 * @author Beau
 * @author BeginaFelicysym
 * @author Holek
 * @author Saper
 * @author Sp5uhe
 * @author Woytecr
 */
$messages['pl'] = array(
	'config-desc' => 'Instalator MediaWiki',
	'config-title' => 'Instalacja MediaWiki $1',
	'config-information' => 'Informacja',
	'config-localsettings-upgrade' => 'Plik <code>LocalSettings.php</code> istnieje.
Aby oprogramowanie zostało zaktualizowane musisz wstawić wartość <code>$wgUpgradeKey</code> w poniższe pole.
Odnajdziesz ją w LocalSettings.php.',
	'config-localsettings-cli-upgrade' => 'Wykryto obecność pliku LocalSettings.php.
Aktualizację należy wykonać poprzez uruchomienie update.php',
	'config-localsettings-key' => 'Klucz aktualizacji',
	'config-localsettings-badkey' => 'Podany klucz jest nieprawidłowy',
	'config-upgrade-key-missing' => 'Wykryto zainstalowane wcześniej MediaWiki.
Jeśli chcesz je zaktualizować dodaj na koniec pliku LocalSettings.php poniższą linię tekstu.

$1',
	'config-localsettings-incomplete' => 'Istniejący plik LocalSettings.php wygląda na niekompletny.
Brak wartości zmiennej $1.
Zmień plik LocalSettings.php, tak by zawierał deklarację wartości tej zmiennej, a następnie kliknij „Dalej”.',
	'config-localsettings-connection-error' => 'Wystąpił błąd podczas łączenia z bazą danych z wykorzystaniem danych z LocalSettings.php lub AdminSettings.php.
Popraw ustawienia i spróbuj ponownie.

$1',
	'config-session-error' => 'Błąd uruchomienia sesji – $1',
	'config-session-expired' => 'Wygląda na to, że Twoja sesja wygasła.
Czas życia sesji został skonfigurowany na $1.
Możesz go wydłużyć zmieniając <code>session.gc_maxlifetime</