# Supported File Formats {#fileformats}

The Super4PCS library provides its own IO module, to load and save 3D point clouds, meshes and export computed matrices.

## Overview
|                       |   Input    |  Output   |
|:---------------------:|:----------:|:---------:|
| Point-cloud           | ply, ptx   |  ply      |
| Mesh                  | obj        |  obj      |
| Transformation Matrix |            |  txt      |
| Sampled clouds        |            |  ply      |

Input/Output files are specified using the following flags:
* `-i file1 file2`: two input files,
* `-r filename`: output file,
* `-m filename`: output matrix,
* `--sampled1 filename`: cloud sampled from input 1,
* `--sampled2 filename`: cloud sampled from input 2.

When neither `-r` nor `-m` are specified, the result is exported to `output.obj/.ply`.

## Parsers specifications
### Transformation matrices ([2c92b29](http://github.com/nmellado/Super4PCS/commit/2c92b29d796309de3c01a43406b9054df262b84f))
3D matrices are exported as text files, such as:

    VERSION	=	1
    MATRIX	=
     0.952888   0.099464  -0.286551   0.045467
    -0.096379   0.995034   0.024886  -0.372831
     0.287603   0.003904   0.957742  -0.447515
     0.000000   0.000000   0.000000   1.000000

These files can be loaded by Polyworks to transform geometry layers.


### PTX ([84d079e](http://github.com/nmellado/Super4PCS/commit/84d079e8ec0b2c79c82e167164d103ffb6e40f18))
[Cyclone pointcloud export](http://w3.leica-geosystems.com/kb/?guid=5532D590-114C-43CD-A55F-FE79E5937CB2) format, available only to **load** range maps as point-clouds.

The scanner position and the cloud transformations are ignored, and only the first range map is considered.

### PLY
The [PoLYgon file format](http://en.wikipedia.org/wiki/PLY_%28file_format%29) (.ply) is used to load/save **point-clouds** exclusively. Both ASCII and Binary encoding are supported, but ASCII encoding is in general preferred.

A limited set of property list is supported. Using other formats will **not** trigger any error, but will prevent the algorithm to find a solution.

In ASCII mode only, both float and double properties are supported (files generated by matlab).

The supported property lists are (any other property type will cause the program to run on wrong data!):
####Position only

    property float x
    property float y
    property float z

####Position + Normals

    property float x
    property float y
    property float z
    property float nx
    property float ny
    property float nz

####Position + Colors (RGB)

    property float x
    property float y
    property float z
    property uchar red
    property uchar green
    property uchar blue

####Position + Colors (RGBA)

    property float x
    property float y
    property float z
    property uchar red
    property uchar green
    property uchar blue
    property uchar alpha

####Position + Normals + Colors (RGB)

    property float x
    property float y
    property float z
    property float nx
    property float ny
    property float nz
    property uchar red
    property uchar green
    property uchar blue

####Position + Normals + Colors (RGBA)

    property float x
    property float y
    property float z
    property float nx
    property float ny
    property float nz
    property uchar red
    property uchar green
    property uchar blue
    property uchar alpha

### OBJ
[Wavefront OBJ](http://en.wikipedia.org/wiki/Wavefront_.obj_file) files are used to load/save meshes.
Faces lists are required, and textures are supported (per-vertex color fetched from the texture).

