/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File QtOgcClientEditor.h
// Sandor Kertesz - ECMWF May 2010
// based on:
//   File QtOgcClientEditor.h
//   Iain Russell - ECMWF Jan 2010 

#ifndef QtOgcClientEditor_H
#define QtOgcClientEditor_H



class QtOgcClientEditor;

class OgcClientEditorObserver : public ReplyObserver {
public:

	OgcClientEditorObserver (QtOgcClientEditor &editor, string &path);
	virtual ~OgcClientEditorObserver(); // Change to virtual if base class

	virtual void start();

	// From ReplyObserver
	virtual void reply(const Request&, int);
	virtual void progress(const Request&);  
	virtual void message(const string&);

protected:

	 void print(ostream&) const; // Change to virtual if base class	

private:

// No copy allowed
    OgcClientEditorObserver(const OgcClientEditorObserver&);
	OgcClientEditorObserver& operator=(const OgcClientEditorObserver&);


    QtOgcClientEditor &editor_;
    string         path_;

// -- Overridden methods

	// From Task
};





class QtOgcClientEditor :public Editor {
public:

// -- Exceptions
	// None

// -- Contructors

	QtOgcClientEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~QtOgcClientEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

// -- Overridden methods


// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	QtOgcClientEditor(const QtOgcClientEditor&);
	QtOgcClientEditor& operator=(const QtOgcClientEditor&);

// -- Members

// -- Methods

// -- Overridden methods
	virtual void edit(void);


// -- Class members
    //ReplyObserver replyObserver;
    OgcClientEditorObserver *replyObserver_;

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const OgcClientEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(QtOgcClientEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(OgcClientEditor);
//#endif

#endif
