/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQFEATUREICONITEM_H
#define MVQFEATUREICONITEM_H

#include <QGraphicsItem>
#include <QPixmap>

#include "MvQFeatureItem.h"

class MvQFeatureIconItem : public MvQFeatureItem
{
public:
    MvQFeatureIconItem(MvQFeatureType*, MvQPlotView*, QGraphicsItem* parent = nullptr);    
    MvQFeatureItem* clone() const override;
    void paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*) override;
    void resize(QRectF rect) override;
    void resizeTo(const MvQFeatureGeometry& geom) override;

protected:
    MvQFeatureIconItem(const MvQFeatureIconItem&);
    void makePixmap() override;
    void adjustSizeInReq();
    void updateRect(double, double);
    void adjustBRect() override;
    double halo() const override;

    QPixmap pix_;
    QPen boxPen_{Qt::NoPen};
    QBrush boxBrush_{Qt::NoBrush};
    QColor shapeCol_;
};

class MvQFeatureStandardIconItem : public MvQFeatureIconItem
{
public:
    MvQFeatureStandardIconItem(MvQFeatureType*, MvQPlotView*, QGraphicsItem* parent = nullptr);
    MvQFeatureItem* clone() const override;

protected:
    MvQFeatureStandardIconItem(const MvQFeatureStandardIconItem&);
    bool getRequestParameters() override;
};

class MvQFeatureWmoSymbolItem : public MvQFeatureIconItem
{
public:
    MvQFeatureWmoSymbolItem(MvQFeatureType*, MvQPlotView*, QGraphicsItem* parent = nullptr);
    MvQFeatureItem* clone() const override;
    void paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*) override;

protected:
    MvQFeatureWmoSymbolItem(const MvQFeatureWmoSymbolItem&);
    bool getRequestParameters() override;
};

#endif // MVQFEATUREICONITEM_H
