/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef ConfigLoader_H
#define ConfigLoader_H

#include <string>
using std::string;

#include "Metview.h"

class ConfigLoader 
{
public:
	ConfigLoader(const string& name,int order);
	virtual ~ConfigLoader(); // Change to virtual if base class

	virtual void load(request*) = 0;
	static bool process(request*,int);
private:
	// No copy allowed
	ConfigLoader(const ConfigLoader&);
	ConfigLoader& operator=(const ConfigLoader&);
};

template<class T>
class SimpleLoader : public ConfigLoader {
	void load(request* r) { T::load(r); }
public:
    SimpleLoader(const string& name,int order) : ConfigLoader(name,order) {}
};

#endif
