/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef min_max_macros_H
#define min_max_macros_H

/*
 *                               2000-07-28/vk
 *
 * These macros used to be part of 'gdefines.h'
 * which was included into several other header
 * files, which were included in other header files...
 *
 * On Alpha these macros clash with file
 * /usr/include/cxx/limits.
 *
 * These macros were isolated into this file.
 * Include this file directly only into those
 * .c or .cc files where macros are needed!
 */

#ifndef max
#define max(a, b) ((a) > (b) ? (a) : (b))
#endif

#ifndef min
#define min(a, b) ((a) > (b) ? (b) : (a))
#endif

#endif
