/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQServiceApplication.h"

#include <QDebug>
#include <QStyleFactory>

#include <iostream>
#include <stdlib.h>

#include "MvQMethods.h"

MvQServiceApplication::MvQServiceApplication(int& ac, char** av) :
    QApplication(ac, av)
{
    //Get qt style
    char* styleCh = getenv("METVIEW_QT_STYLE");
    if (styleCh == 0) {
        std::cout << "Error: METVIEW_QT_STYLE is not defined! MvQApplication exits" << std::endl;
        exit(1);
    }

    QString style(styleCh);

    QStringList styleLst = QStyleFactory::keys();
    if (styleLst.contains(style)) {
        setStyle(style);
    }

    //---------------------------
    // Set QSettings location
    //---------------------------

    //Set a custom location inside the metview home directory for qsettings
    if (char* spCh = getenv("METVIEW_USER_DIRECTORY")) {
        QString sp(spCh);
        sp += "/System/Preferences/._mv_desktop_config_";
        qDebug() << "QSettings path is set to:" << sp;
        MvQ::initSettings(sp);
    }
}
